/* SPDX-License-Identifier: GPL-2.0-only */

/*
 * This file is created based on MT8186 Functional Specification
 * Chapter number: 4.5
 */

#ifndef SOC_MEDIATEK_MT8186_INFRACFG_H
#define SOC_MEDIATEK_MT8186_INFRACFG_H

#include <soc/addressmap.h>
#include <types.h>

struct mt8186_infracfg_ao_regs {
	u32 reserved1[20];
	u32 infra_globalcon_dcmctl;
	u32 reserved2[7];
	u32 infra_bus_dcm_ctrl;
	u32 peri_bus_dcm_ctrl;
	u32 mem_dcm_ctrl;
	u32 dfs_mem_dcm_ctrl;
	u32 module_sw_cg_0_set;
	u32 module_sw_cg_0_clr;
	u32 module_sw_cg_1_set;
	u32 module_sw_cg_1_clr;
	u32 module_sw_cg_0_sta;
	u32 module_sw_cg_1_sta;
	u32 module_clk_sel;
	u32 mem_cg_ctrl;
	u32 p2p_rx_clk_on;
	u32 module_sw_cg_2_set;
	u32 module_sw_cg_2_clr;
	u32 module_sw_cg_2_sta;
	u32 reserved3[1];
	u32 dramc_wbr;
	u32 ddr_en_mask;
	u32 reserved4[1];
	u32 module_sw_cg_3_set;
	u32 module_sw_cg_3_clr;
	u32 module_sw_cg_3_sta;
	u32 reserved5[13];
	u32 i2c_dbtool_misc;
	u32 md_sleep_ctrl_mask;
	u32 pmicw_clock_ctrl;
	u32 reserved6[5];
	u32 infra_globalcon_rst0_set;
	u32 infra_globalcon_rst0_clr;
	u32 infra_globalcon_rst0_sta;
	u32 reserved7[1];
	u32 infra_globalcon_rst1_set;
	u32 infra_globalcon_rst1_clr;
	u32 infra_globalcon_rst1_sta;
	u32 reserved8[1];
	u32 infra_globalcon_rst2_set;
	u32 infra_globalcon_rst2_clr;
	u32 infra_globalcon_rst2_sta;
	u32 reserved9[1];
	u32 infra_globalcon_rst3_set;
	u32 infra_globalcon_rst3_clr;
	u32 infra_globalcon_rst3_sta;
	u32 reserved10[41];
	u32 infra_topaxi_si0_ctl;
	u32 infra_topaxi_si1_ctl;
	u32 infra_topaxi_mdbus_ctl;
	u32 infra_mci_si0_ctl;
	u32 infra_mci_si1_ctl;
	u32 infra_mci_si2_ctl;
	u32 infra_mci_async_ctl;
	u32 infra_mci_cg_mfg_sec_sta;
	u32 infra_topaxi_protecten;
	u32 infra_topaxi_protecten_sta0;
	u32 infra_topaxi_protecten_sta1;
	u32 infra_axi_aslice_ctrl;
	u32 infra_apb_async_sta;
	u32 infra_topaxi_si2_ctl;
	u32 reserved11[1];
	u32 infra_topaxi_trans_limiter_1;
	u32 infra_mci_trans_con_read;
	u32 infra_mci_trans_con_write;
	u32 infra_mci_id_remap_con;
	u32 infra_mci_emi_trans_con;
	u32 infra_topaxi_protecten_1;
	u32 infra_topaxi_protecten_sta0_1;
	u32 infra_topaxi_protecten_sta1_1;
	u32 reserved12[1];
	u32 infra_topaxi_aslice_ctrl;
	u32 infra_topaxi_protecten_2;
	u32 infra_topaxi_protecten_sta0_2;
	u32 infra_topaxi_protecten_sta1_2;
	u32 infra_topaxi_mi_ctrl;
	u32 infra_topaxi_cbip_aslice_ctrl;
	u32 infra_topaxi_cbip_slice_ctrl;
	u32 infra_top_master_sideband;
	u32 reserved13[1];
	u32 infra_topaxi_trans_limiter;
	u32 infra_topaxi_emi_gmc_l2c_ctrl;
	u32 infra_topaxi_cbip_slice_ctrl_1;
	u32 infra_mfg_slave_gals_ctrl;
	u32 infra_mfg_master_m0_gals_ctrl;
	u32 infra_mfg_master_m1_gals_ctrl;
	u32 infra_top_master_sideband_1;
	u32 infra_topaxi_protecten_set;
	u32 infra_topaxi_protecten_clr;
	u32 infra_topaxi_protecten_1_set;
	u32 infra_topaxi_protecten_1_clr;
	u32 infra_topaxi_protecten_2_set;
	u32 infra_topaxi_protecten_2_clr;
	u32 infra_topaxi_protecten_3_set;
	u32 infra_topaxi_protecten_3_clr;
	u32 infra_topaxi_protecten_3;
	u32 infra_topaxi_protecten_sta0_3;
	u32 infra_topaxi_protecten_sta1_3;
	u32 reserved14[12];
	u32 infra_topaxi_bus_dbg_con_a0;
	u32 md1_bank0_map0;
	u32 md1_bank0_map1;
	u32 md1_bank0_map2;
	u32 md1_bank0_map3;
	u32 md1_bank1_map0;
	u32 md1_bank1_map1;
	u32 md1_bank1_map2;
	u32 md1_bank1_map3;
	u32 md1_bank4_map0;
	u32 md1_bank4_map1;
	u32 md1_bank4_map2;
	u32 md1_bank4_map3;
	u32 md2_bank0_map0;
	u32 md2_bank0_map1;
	u32 md2_bank0_map2;
	u32 md2_bank0_map3;
	u32 reserved15[4];
	u32 md2_bank4_map0;
	u32 md2_bank4_map1;
	u32 md2_bank4_map2;
	u32 md2_bank4_map3;
	u32 c2k_config;
	u32 c2k_status;
	u32 c2k_spm_ctrl;
	u32 reserved16[1];
	u32 ap2md_dummy;
	u32 reserved17[3];
	u32 conn_map0;
	u32 cldma_map0;
	u32 conn_map1;
	u32 conn_bus_con;
	u32 mcusys_dfd_map;
	u32 reserved18[1];
	u32 conn_map3;
	u32 conn_map4;
	u32 reserved19[24];
	u32 peri_cci_sideband_con;
	u32 mfg_cci_sideband_con;
	u32 reserved20[2];
	u32 infra_pwm_cksw_ctrl;
	u32 reserved21[59];
	u32 infra_ao_dbg_con0;
	u32 infra_ao_dbg_con1;
	u32 infra_ao_dbg_con2;
	u32 infra_ao_dbg_con3;
	u32 md_dbg_ck_con;
	u32 reserved22[59];
	u32 mfg_misc_con;
	u32 reserved23[62];
	u32 infra_msdc_con;
	u32 infra_rsvd0;
	u32 infra_rsvd1;
	u32 infra_rsvd2;
	u32 infra_rsvd3;
	u32 infra_rsvd4;
	u32 infra_rsvd5;
	u32 infra_iommu_en;
	u32 reserved24[89];
	u32 md1_sbc_key0;
	u32 md1_sbc_key1;
	u32 md1_sbc_key2;
	u32 md1_sbc_key3;
	u32 md1_sbc_key4;
	u32 md1_sbc_key5;
	u32 md1_sbc_key6;
	u32 md1_sbc_key7;
	u32 md1_sbc_key_lock;
	u32 reserved25[1];
	u32 md1_misc_lock;
	u32 md1_misc;
	u32 c2k_sbc_key0;
	u32 c2k_sbc_key1;
	u32 c2k_sbc_key2;
	u32 c2k_sbc_key3;
	u32 c2k_sbc_key4;
	u32 c2k_sbc_key5;
	u32 c2k_sbc_key6;
	u32 c2k_sbc_key7;
	u32 c2k_sbc_key_lock;
	u32 reserved26[11];
	u32 infra_bonding;
	u32 subsys_pdn_nohang_dis0;
	u32 subsys_pdn_nohang_dis1;
	u32 reserved27[61];
	u32 infra_ao_scpsys_apb_async_sta;
	u32 infra_ao_md32_tx_apb_async_sta;
	u32 infra_ao_md32_rx_apb_async_sta;
	u32 infra_ao_cksys_apb_async_sta;
	u32 infra_ao_pmic_wrap_tx_apb_async_sta;
	u32 infra_ao_pmif_spmi_tx_apb_async_sta;
	u32 infra_ao_spmi_mst_tx_apb_async_sta;
	u32 infra_ao_infra0_iommu_apb_async_sta;
	u32 infra_ao_infra1_iommu_apb_async_sta;
	u32 reserved28[6];
	u32 infra_ao_mcu_pwr_mask;
	u32 reserved29[48];
	u32 pll_ulposc_con0;
	u32 pll_ulposc_con1;
	u32 reserved30[2];
	u32 pll_auxadc_con0;
	u32 scp_infra_irq_set;
	u32 scp_infra_irq_clr;
	u32 scp_infra_ctrl;
	u32 conn2infra_gals_dbg;
	u32 infra_infra2adsp_axi_gals_debug;
	u32 infra_adsp2infra_axi_gals_debug;
	u32 infra_adsp2emi_axi_gals_debug;
	u32 nna0_1_emi_axi_gals_debug;
	u32 nna2_emi_axi_gals_debug;
	u32 nn2infra_axi_gals_debug;
	u32 infra2nna_axi_gals_debug;
	u32 reserved31[48];
	u32 cldma_ctrl;
	u32 reserved32[3];
	u32 rg_ccif4_md_pwr_flag;
	u32 rg_ccif4_con_pwr_flag;
	u32 rd_ccif4_cpu_pwr_flag;
	u32 reserved33[1];
	u32 infra_ipsys_s_bus_bcrm_extended_bus_protect_set_ctrl_0;
	u32 infra_ipsys_s_bus_bcrm_extended_bus_protect_clr_ctrl_0;
	u32 infra_ipsys_s_bus_bcrm_extended_bus_protect_rw_ctrl_0;
	u32 infra_ipsys_s_bus_bcrm_extended_bus_protect_ro_ctrl_0;
	u32 infra_ipsys_s_bus_u_lnk_si0_to_ipcfg_s_axi_pwr_prot_ctrl_0;
	u32 infra_ipsys_s_bus_u_lnk_si0_to_ipcfg_s_axi2sbus_ctrl_0;
	u32 infra_ipsys_s_bus_u_lnk_si0_to_infra_ip0sys_bus_asl7_axi_pwr_prot_ctrl_0;
	u32 reserved34[1];
	u32 infra_ipsys_s_bus_u_lnk_si0_to_infra_ip1sys_bus_asl8_axi_pwr_prot_ctrl_0;
	u32 infra_ipsys_s_bus_u_lnk_si0_to_infra_ip2sys_bus_asl9_axi_pwr_prot_ctrl_0;
	u32 infra_ipsys_s_bus_u_si0_ctrl_0;
	u32 infra_ipsys_s_bus_u_si0_ctrl_1;
	u32 infra_ipsys_s_bus_u_si0_ctrl_2;
	u32 infra_ipsys_s_bus_u_si0_ctrl_3;
	u32 infra_ipsys_s_bus_u_si0_ctrl_4;
	u32 infra_ipsys_s_bus_u_si0_ctrl_5;
	u32 reserved35[40];
	u32 infrabus_dbg0;
	u32 infrabus_dbg1;
	u32 infrabus_dbg2;
	u32 infrabus_dbg3;
	u32 infrabus_dbg4;
	u32 infrabus_dbg5;
	u32 infrabus_dbg6;
	u32 infrabus_dbg7;
	u32 infrabus_dbg8;
	u32 infrabus_dbg9;
	u32 infrabus_dbg10;
	u32 infrabus_dbg11;
	u32 infrabus_dbg12;
	u32 infrabus_dbg13;
	u32 infrabus_dbg14;
	u32 infrabus_dbg15;
	u32 infrabus_dbg16;
	u32 reserved36[111];
	u32 infra_misc;
	u32 infra_acp;
	u32 misc_config;
	u32 infra_misc2;
	u32 mdsys_misc_con;
	u32 reserved37[12];
	u32 nna_infra_gals_ctrl;
	u32 nna_emi_gals_ctrl;
	u32 infra_adsp_infra_gals_ctrl;
	u32 infra_adsp_emi_gals_ctrl;
	u32 reserved38[11];
	u32 infra_ao_sec_con;
	u32 infra_ao_sec_cg_con0;
	u32 infra_ao_sec_cg_con1;
	u32 infra_ao_sec_rst_con0;
	u32 infra_ao_sec_rst_con1;
	u32 infra_ao_sec_rst_con2;
	u32 dxcc_dcu_en_lock;
	u32 infra_ao_sec_cg_con2;
	u32 infra_ao_sec_rst_con3;
	u32 infra_ao_sec_cg_con3;
	u32 reserved39[2];
	u32 infra_ao_sec_hyp;
	u32 infra_mcu2emi_slice;
	u32 infra_ao_sec_mfg_hyp;
};

check_member(mt8186_infracfg_ao_regs, infra_globalcon_dcmctl, 0x50);
check_member(mt8186_infracfg_ao_regs, infra_bus_dcm_ctrl, 0x70);
check_member(mt8186_infracfg_ao_regs, peri_bus_dcm_ctrl, 0x74);
check_member(mt8186_infracfg_ao_regs, mem_dcm_ctrl, 0x78);
check_member(mt8186_infracfg_ao_regs, dfs_mem_dcm_ctrl, 0x7c);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_0_set, 0x80);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_0_clr, 0x84);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_1_set, 0x88);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_1_clr, 0x8c);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_0_sta, 0x90);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_1_sta, 0x94);
check_member(mt8186_infracfg_ao_regs, module_clk_sel, 0x98);
check_member(mt8186_infracfg_ao_regs, mem_cg_ctrl, 0x9c);
check_member(mt8186_infracfg_ao_regs, p2p_rx_clk_on, 0xa0);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_2_set, 0xa4);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_2_clr, 0xa8);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_2_sta, 0xac);
check_member(mt8186_infracfg_ao_regs, dramc_wbr, 0xb4);
check_member(mt8186_infracfg_ao_regs, ddr_en_mask, 0xb8);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_3_set, 0xc0);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_3_clr, 0xc4);
check_member(mt8186_infracfg_ao_regs, module_sw_cg_3_sta, 0xc8);
check_member(mt8186_infracfg_ao_regs, i2c_dbtool_misc, 0x100);
check_member(mt8186_infracfg_ao_regs, md_sleep_ctrl_mask, 0x104);
check_member(mt8186_infracfg_ao_regs, pmicw_clock_ctrl, 0x108);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst0_set, 0x120);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst0_clr, 0x124);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst0_sta, 0x128);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst1_set, 0x130);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst1_clr, 0x134);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst1_sta, 0x138);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst2_set, 0x140);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst2_clr, 0x144);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst2_sta, 0x148);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst3_set, 0x150);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst3_clr, 0x154);
check_member(mt8186_infracfg_ao_regs, infra_globalcon_rst3_sta, 0x158);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_si0_ctl, 0x200);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_si1_ctl, 0x204);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_mdbus_ctl, 0x208);
check_member(mt8186_infracfg_ao_regs, infra_mci_si0_ctl, 0x20c);
check_member(mt8186_infracfg_ao_regs, infra_mci_si1_ctl, 0x210);
check_member(mt8186_infracfg_ao_regs, infra_mci_si2_ctl, 0x214);
check_member(mt8186_infracfg_ao_regs, infra_mci_async_ctl, 0x218);
check_member(mt8186_infracfg_ao_regs, infra_mci_cg_mfg_sec_sta, 0x21c);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten, 0x220);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta0, 0x224);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta1, 0x228);
check_member(mt8186_infracfg_ao_regs, infra_axi_aslice_ctrl, 0x22c);
check_member(mt8186_infracfg_ao_regs, infra_apb_async_sta, 0x230);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_si2_ctl, 0x234);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_trans_limiter_1, 0x23c);
check_member(mt8186_infracfg_ao_regs, infra_mci_trans_con_read, 0x240);
check_member(mt8186_infracfg_ao_regs, infra_mci_trans_con_write, 0x244);
check_member(mt8186_infracfg_ao_regs, infra_mci_id_remap_con, 0x248);
check_member(mt8186_infracfg_ao_regs, infra_mci_emi_trans_con, 0x24c);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_1, 0x250);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta0_1, 0x254);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta1_1, 0x258);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_aslice_ctrl, 0x260);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_2, 0x264);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta0_2, 0x268);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta1_2, 0x26c);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_mi_ctrl, 0x270);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_cbip_aslice_ctrl, 0x274);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_cbip_slice_ctrl, 0x278);
check_member(mt8186_infracfg_ao_regs, infra_top_master_sideband, 0x27c);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_trans_limiter, 0x284);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_emi_gmc_l2c_ctrl, 0x288);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_cbip_slice_ctrl_1, 0x28c);
check_member(mt8186_infracfg_ao_regs, infra_mfg_slave_gals_ctrl, 0x290);
check_member(mt8186_infracfg_ao_regs, infra_mfg_master_m0_gals_ctrl, 0x294);
check_member(mt8186_infracfg_ao_regs, infra_mfg_master_m1_gals_ctrl, 0x298);
check_member(mt8186_infracfg_ao_regs, infra_top_master_sideband_1, 0x29c);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_set, 0x2a0);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_clr, 0x2a4);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_1_set, 0x2a8);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_1_clr, 0x2ac);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_2_set, 0x2b0);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_2_clr, 0x2b4);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_3_set, 0x2b8);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_3_clr, 0x2bc);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_3, 0x2c0);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta0_3, 0x2c4);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_protecten_sta1_3, 0x2c8);
check_member(mt8186_infracfg_ao_regs, infra_topaxi_bus_dbg_con_a0, 0x2fc);
check_member(mt8186_infracfg_ao_regs, md1_bank0_map0, 0x300);
check_member(mt8186_infracfg_ao_regs, md1_bank0_map1, 0x304);
check_member(mt8186_infracfg_ao_regs, md1_bank0_map2, 0x308);
check_member(mt8186_infracfg_ao_regs, md1_bank0_map3, 0x30c);
check_member(mt8186_infracfg_ao_regs, md1_bank1_map0, 0x310);
check_member(mt8186_infracfg_ao_regs, md1_bank1_map1, 0x314);
check_member(mt8186_infracfg_ao_regs, md1_bank1_map2, 0x318);
check_member(mt8186_infracfg_ao_regs, md1_bank1_map3, 0x31c);
check_member(mt8186_infracfg_ao_regs, md1_bank4_map0, 0x320);
check_member(mt8186_infracfg_ao_regs, md1_bank4_map1, 0x324);
check_member(mt8186_infracfg_ao_regs, md1_bank4_map2, 0x328);
check_member(mt8186_infracfg_ao_regs, md1_bank4_map3, 0x32c);
check_member(mt8186_infracfg_ao_regs, md2_bank0_map0, 0x330);
check_member(mt8186_infracfg_ao_regs, md2_bank0_map1, 0x334);
check_member(mt8186_infracfg_ao_regs, md2_bank0_map2, 0x338);
check_member(mt8186_infracfg_ao_regs, md2_bank0_map3, 0x33c);
check_member(mt8186_infracfg_ao_regs, md2_bank4_map0, 0x350);
check_member(mt8186_infracfg_ao_regs, md2_bank4_map1, 0x354);
check_member(mt8186_infracfg_ao_regs, md2_bank4_map2, 0x358);
check_member(mt8186_infracfg_ao_regs, md2_bank4_map3, 0x35c);
check_member(mt8186_infracfg_ao_regs, c2k_config, 0x360);
check_member(mt8186_infracfg_ao_regs, c2k_status, 0x364);
check_member(mt8186_infracfg_ao_regs, c2k_spm_ctrl, 0x368);
check_member(mt8186_infracfg_ao_regs, ap2md_dummy, 0x370);
check_member(mt8186_infracfg_ao_regs, conn_map0, 0x380);
check_member(mt8186_infracfg_ao_regs, cldma_map0, 0x384);
check_member(mt8186_infracfg_ao_regs, conn_map1, 0x388);
check_member(mt8186_infracfg_ao_regs, conn_bus_con, 0x38c);
check_member(mt8186_infracfg_ao_regs, mcusys_dfd_map, 0x390);
check_member(mt8186_infracfg_ao_regs, conn_map3, 0x398);
check_member(mt8186_infracfg_ao_regs, conn_map4, 0x39c);
check_member(mt8186_infracfg_ao_regs, peri_cci_sideband_con, 0x400);
check_member(mt8186_infracfg_ao_regs, mfg_cci_sideband_con, 0x404);
check_member(mt8186_infracfg_ao_regs, infra_pwm_cksw_ctrl, 0x410);
check_member(mt8186_infracfg_ao_regs, infra_ao_dbg_con0, 0x500);
check_member(mt8186_infracfg_ao_regs, infra_ao_dbg_con1, 0x504);
check_member(mt8186_infracfg_ao_regs, infra_ao_dbg_con2, 0x508);
check_member(mt8186_infracfg_ao_regs, infra_ao_dbg_con3, 0x50c);
check_member(mt8186_infracfg_ao_regs, md_dbg_ck_con, 0x510);
check_member(mt8186_infracfg_ao_regs, mfg_misc_con, 0x600);
check_member(mt8186_infracfg_ao_regs, infra_msdc_con, 0x6fc);
check_member(mt8186_infracfg_ao_regs, infra_rsvd0, 0x700);
check_member(mt8186_infracfg_ao_regs, infra_rsvd1, 0x704);
check_member(mt8186_infracfg_ao_regs, infra_rsvd2, 0x708);
check_member(mt8186_infracfg_ao_regs, infra_rsvd3, 0x70c);
check_member(mt8186_infracfg_ao_regs, infra_rsvd4, 0x710);
check_member(mt8186_infracfg_ao_regs, infra_rsvd5, 0x714);
check_member(mt8186_infracfg_ao_regs, infra_iommu_en, 0x718);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key0, 0x880);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key1, 0x884);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key2, 0x888);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key3, 0x88c);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key4, 0x890);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key5, 0x894);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key6, 0x898);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key7, 0x89c);
check_member(mt8186_infracfg_ao_regs, md1_sbc_key_lock, 0x8a0);
check_member(mt8186_infracfg_ao_regs, md1_misc_lock, 0x8a8);
check_member(mt8186_infracfg_ao_regs, md1_misc, 0x8ac);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key0, 0x8b0);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key1, 0x8b4);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key2, 0x8b8);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key3, 0x8bc);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key4, 0x8c0);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key5, 0x8c4);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key6, 0x8c8);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key7, 0x8cc);
check_member(mt8186_infracfg_ao_regs, c2k_sbc_key_lock, 0x8d0);
check_member(mt8186_infracfg_ao_regs, infra_bonding, 0x900);
check_member(mt8186_infracfg_ao_regs, subsys_pdn_nohang_dis0, 0x904);
check_member(mt8186_infracfg_ao_regs, subsys_pdn_nohang_dis1, 0x908);
check_member(mt8186_infracfg_ao_regs, infra_ao_scpsys_apb_async_sta, 0xa00);
check_member(mt8186_infracfg_ao_regs, infra_ao_md32_tx_apb_async_sta, 0xa04);
check_member(mt8186_infracfg_ao_regs, infra_ao_md32_rx_apb_async_sta, 0xa08);
check_member(mt8186_infracfg_ao_regs, infra_ao_cksys_apb_async_sta, 0xa0c);
check_member(mt8186_infracfg_ao_regs, infra_ao_pmic_wrap_tx_apb_async_sta, 0xa10);
check_member(mt8186_infracfg_ao_regs, infra_ao_pmif_spmi_tx_apb_async_sta, 0xa14);
check_member(mt8186_infracfg_ao_regs, infra_ao_spmi_mst_tx_apb_async_sta, 0xa18);
check_member(mt8186_infracfg_ao_regs, infra_ao_infra0_iommu_apb_async_sta, 0xa1c);
check_member(mt8186_infracfg_ao_regs, infra_ao_infra1_iommu_apb_async_sta, 0xa20);
check_member(mt8186_infracfg_ao_regs, infra_ao_mcu_pwr_mask, 0xa3c);
check_member(mt8186_infracfg_ao_regs, pll_ulposc_con0, 0xb00);
check_member(mt8186_infracfg_ao_regs, pll_ulposc_con1, 0xb04);
check_member(mt8186_infracfg_ao_regs, pll_auxadc_con0, 0xb10);
check_member(mt8186_infracfg_ao_regs, scp_infra_irq_set, 0xb14);
check_member(mt8186_infracfg_ao_regs, scp_infra_irq_clr, 0xb18);
check_member(mt8186_infracfg_ao_regs, scp_infra_ctrl, 0xb1c);
check_member(mt8186_infracfg_ao_regs, conn2infra_gals_dbg, 0xb20);
check_member(mt8186_infracfg_ao_regs, infra_infra2adsp_axi_gals_debug, 0xb24);
check_member(mt8186_infracfg_ao_regs, infra_adsp2infra_axi_gals_debug, 0xb28);
check_member(mt8186_infracfg_ao_regs, infra_adsp2emi_axi_gals_debug, 0xb2c);
check_member(mt8186_infracfg_ao_regs, nna0_1_emi_axi_gals_debug, 0xb30);
check_member(mt8186_infracfg_ao_regs, nna2_emi_axi_gals_debug, 0xb34);
check_member(mt8186_infracfg_ao_regs, nn2infra_axi_gals_debug, 0xb38);
check_member(mt8186_infracfg_ao_regs, infra2nna_axi_gals_debug, 0xb3c);
check_member(mt8186_infracfg_ao_regs, cldma_ctrl, 0xc00);
check_member(mt8186_infracfg_ao_regs, rg_ccif4_md_pwr_flag, 0xc10);
check_member(mt8186_infracfg_ao_regs, rg_ccif4_con_pwr_flag, 0xc14);
check_member(mt8186_infracfg_ao_regs, rd_ccif4_cpu_pwr_flag, 0xc18);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_bcrm_extended_bus_protect_set_ctrl_0, 0xc20);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_bcrm_extended_bus_protect_clr_ctrl_0, 0xc24);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_bcrm_extended_bus_protect_rw_ctrl_0, 0xc28);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_bcrm_extended_bus_protect_ro_ctrl_0, 0xc2c);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_u_lnk_si0_to_ipcfg_s_axi_pwr_prot_ctrl_0, 0xc30);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_u_lnk_si0_to_ipcfg_s_axi2sbus_ctrl_0, 0xc34);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_u_lnk_si0_to_infra_ip0sys_bus_asl7_axi_pwr_prot_ctrl_0, 0xc38);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_u_lnk_si0_to_infra_ip1sys_bus_asl8_axi_pwr_prot_ctrl_0, 0xc40);
check_member(mt8186_infracfg_ao_regs,
	     infra_ipsys_s_bus_u_lnk_si0_to_infra_ip2sys_bus_asl9_axi_pwr_prot_ctrl_0, 0xc44);
check_member(mt8186_infracfg_ao_regs, infra_ipsys_s_bus_u_si0_ctrl_0, 0xc48);
check_member(mt8186_infracfg_ao_regs, infra_ipsys_s_bus_u_si0_ctrl_1, 0xc4c);
check_member(mt8186_infracfg_ao_regs, infra_ipsys_s_bus_u_si0_ctrl_2, 0xc50);
check_member(mt8186_infracfg_ao_regs, infra_ipsys_s_bus_u_si0_ctrl_3, 0xc54);
check_member(mt8186_infracfg_ao_regs, infra_ipsys_s_bus_u_si0_ctrl_4, 0xc58);
check_member(mt8186_infracfg_ao_regs, infra_ipsys_s_bus_u_si0_ctrl_5, 0xc5c);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg0, 0xd00);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg1, 0xd04);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg2, 0xd08);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg3, 0xd0c);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg4, 0xd10);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg5, 0xd14);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg6, 0xd18);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg7, 0xd1c);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg8, 0xd20);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg9, 0xd24);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg10, 0xd28);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg11, 0xd2c);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg12, 0xd30);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg13, 0xd34);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg14, 0xd38);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg15, 0xd3c);
check_member(mt8186_infracfg_ao_regs, infrabus_dbg16, 0xd40);
check_member(mt8186_infracfg_ao_regs, infra_misc, 0xf00);
check_member(mt8186_infracfg_ao_regs, infra_acp, 0xf04);
check_member(mt8186_infracfg_ao_regs, misc_config, 0xf08);
check_member(mt8186_infracfg_ao_regs, infra_misc2, 0xf0c);
check_member(mt8186_infracfg_ao_regs, mdsys_misc_con, 0xf10);
check_member(mt8186_infracfg_ao_regs, nna_infra_gals_ctrl, 0xf44);
check_member(mt8186_infracfg_ao_regs, nna_emi_gals_ctrl, 0xf48);
check_member(mt8186_infracfg_ao_regs, infra_adsp_infra_gals_ctrl, 0xf4c);
check_member(mt8186_infracfg_ao_regs, infra_adsp_emi_gals_ctrl, 0xf50);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_con, 0xf80);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_cg_con0, 0xf84);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_cg_con1, 0xf88);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_rst_con0, 0xf8c);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_rst_con1, 0xf90);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_rst_con2, 0xf94);
check_member(mt8186_infracfg_ao_regs, dxcc_dcu_en_lock, 0xf98);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_cg_con2, 0xf9c);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_rst_con3, 0xfa0);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_cg_con3, 0xfa4);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_hyp, 0xfb0);
check_member(mt8186_infracfg_ao_regs, infra_mcu2emi_slice, 0xfb4);
check_member(mt8186_infracfg_ao_regs, infra_ao_sec_mfg_hyp, 0xfb8);

static struct mt8186_infracfg_ao_regs *const mt8186_infracfg_ao =
	(void *)INFRACFG_AO_BASE;

#endif	/* SOC_MEDIATEK_MT8186_INFRACFG_H */
