
#ifndef header_gui2cpp
#define header_gui2cpp

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gui.h>

class GUI2CPP
{
//! Construction:
public:
	GUI2CPP(const std::string &gui_file, const std::string &source_file, const std::string &header_file);

	~GUI2CPP();

//! Attributes:
public:

//! Operations:
public:
	//: Load GUI definition file, source file and header file.
	//- <p>Returns false if the loading of any of these files fail.</p>
	bool load();

	//: Convert the contents of source file and header file to include the GUI definition entries.
	bool convert();

	//: Save the source and header files.
	bool save();

//! Implementation:
private:
	bool parse_components(const CL_DomElement &componentsElement);

	//: Loads a file from disk.
	bool load_file(std::string &file_data, const std::string &filename);

	//: Saves a file to disk.
	bool save_file(const std::string &file_data, const std::string &filename);

	//: Returns an autogenerated code block.
	std::string find_block(const std::string &file_data, const std::string &block_name);

	//: Injects an autogenerated code block into a file data (source or header) string.
	bool inject_block(std::string &file_data, const std::string &block_name, const std::string &block_data);

	//: Filenames of the GUI definition file, the source file and the header file.
	std::string gui_file, source_file, header_file;

	//: Contents of the source and header files.
	std::string source_data, header_data;

	//: Generated header variables code block.
	std::string old_header_variables, new_header_variables;

	//: Generated header functions code block.
	std::string old_header_functions, new_header_functions;

	//: Generated soruce connections code block.
	std::string old_source_connections, new_source_connections;

	//: Contents of the GUI definition file.
	CL_DomDocument gui_document;
};

#endif
