/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file has been auto-generated by code_generator_v8.pm. DO NOT MODIFY!

#include "config.h"
#include "V8TestSVG.h"

#include "HTMLNames.h"
#include "RuntimeEnabledFeatures.h"
#include "V8SVGAnimatedString.h"
#include "V8SVGPoint.h"
#include "bindings/v8/ExceptionState.h"
#include "bindings/v8/V8DOMConfiguration.h"
#include "bindings/v8/V8ObjectConstructor.h"
#include "core/dom/ContextFeatures.h"
#include "core/dom/Document.h"
#include "core/dom/custom/CustomElementCallbackDispatcher.h"
#include "platform/TraceEvent.h"
#include "wtf/GetPtr.h"
#include "wtf/RefPtr.h"

namespace WebCore {

static void initializeScriptWrappableForInterface(TestSVG* object)
{
    if (ScriptWrappable::wrapperCanBeStoredInObject(object))
        ScriptWrappable::setTypeInfoInObject(object, &V8TestSVG::wrapperTypeInfo);
    else
        ASSERT_NOT_REACHED();
}

} // namespace WebCore

// In ScriptWrappable::init, the use of a local function declaration has an issue on Windows:
// the local declaration does not pick up the surrounding namespace. Therefore, we provide this function
// in the global namespace.
// (More info on the MSVC bug here: http://connect.microsoft.com/VisualStudio/feedback/details/664619/the-namespace-of-local-function-declarations-in-c)
void webCoreInitializeScriptWrappableForInterface(WebCore::TestSVG* object)
{
    WebCore::initializeScriptWrappableForInterface(object);
}

namespace WebCore {
const WrapperTypeInfo V8TestSVG::wrapperTypeInfo = { gin::kEmbedderBlink, V8TestSVG::domTemplate, V8TestSVG::derefObject, 0, 0, 0, V8TestSVG::installPerContextEnabledMethods, 0, WrapperTypeObjectPrototype, false };

namespace TestSVGV8Internal {

template <typename T> void V8_USE(T) { }

static void animatedReflectedAttributeAttributeGetter(const v8::PropertyCallbackInfo<v8::Value>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    v8SetReturnValueFast(info, imp->getAttribute(HTMLNames::animatedreflectedattributeAttr), imp);
}

static void animatedReflectedAttributeAttributeGetterCallback(v8::Local<v8::String>, const v8::PropertyCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMGetter");
    TestSVGV8Internal::animatedReflectedAttributeAttributeGetter(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void animatedReflectedAttributeAttributeSetter(v8::Local<v8::Value> jsValue, const v8::PropertyCallbackInfo<void>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    V8TRYCATCH_VOID(SVGAnimatedString*, cppValue, V8SVGAnimatedString::hasInstance(jsValue, info.GetIsolate()) ? V8SVGAnimatedString::toNative(v8::Handle<v8::Object>::Cast(jsValue)) : 0);
    CustomElementCallbackDispatcher::CallbackDeliveryScope deliveryScope;
    imp->setAttribute(HTMLNames::animatedreflectedattributeAttr, WTF::getPtr(cppValue));
}

static void animatedReflectedAttributeAttributeSetterCallback(v8::Local<v8::String>, v8::Local<v8::Value> jsValue, const v8::PropertyCallbackInfo<void>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMSetter");
    CustomElementCallbackDispatcher::CallbackDeliveryScope deliveryScope;
    TestSVGV8Internal::animatedReflectedAttributeAttributeSetter(jsValue, info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void mutablePointAttributeGetter(const v8::PropertyCallbackInfo<v8::Value>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    v8SetReturnValueFast(info, imp->mutablePoint(), imp);
}

static void mutablePointAttributeGetterCallback(v8::Local<v8::String>, const v8::PropertyCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMGetter");
    TestSVGV8Internal::mutablePointAttributeGetter(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void mutablePointAttributeSetter(v8::Local<v8::Value> jsValue, const v8::PropertyCallbackInfo<void>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    V8TRYCATCH_VOID(SVGPointTearOff*, cppValue, V8SVGPoint::hasInstance(jsValue, info.GetIsolate()) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(jsValue)) : 0);
    imp->setMutablePoint(WTF::getPtr(cppValue));
}

static void mutablePointAttributeSetterCallback(v8::Local<v8::String>, v8::Local<v8::Value> jsValue, const v8::PropertyCallbackInfo<void>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMSetter");
    TestSVGV8Internal::mutablePointAttributeSetter(jsValue, info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void immutablePointAttributeGetter(const v8::PropertyCallbackInfo<v8::Value>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    v8SetReturnValueFast(info, imp->immutablePoint(), imp);
}

static void immutablePointAttributeGetterCallback(v8::Local<v8::String>, const v8::PropertyCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMGetter");
    TestSVGV8Internal::immutablePointAttributeGetter(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void immutablePointAttributeSetter(v8::Local<v8::Value> jsValue, const v8::PropertyCallbackInfo<void>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    V8TRYCATCH_VOID(SVGPointTearOff*, cppValue, V8SVGPoint::hasInstance(jsValue, info.GetIsolate()) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(jsValue)) : 0);
    imp->setImmutablePoint(WTF::getPtr(cppValue));
}

static void immutablePointAttributeSetterCallback(v8::Local<v8::String>, v8::Local<v8::Value> jsValue, const v8::PropertyCallbackInfo<void>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMSetter");
    TestSVGV8Internal::immutablePointAttributeSetter(jsValue, info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void mutablePointFunctionMethod(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    v8SetReturnValue(info, imp->mutablePointFunction());
}

static void mutablePointFunctionMethodCallback(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMMethod");
    TestSVGV8Internal::mutablePointFunctionMethod(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void immutablePointFunctionMethod(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    v8SetReturnValue(info, imp->immutablePointFunction());
}

static void immutablePointFunctionMethodCallback(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMMethod");
    TestSVGV8Internal::immutablePointFunctionMethod(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void immutablePointFunctionTypedefMethod(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    v8SetReturnValue(info, imp->immutablePointFunctionTypedef());
}

static void immutablePointFunctionTypedefMethodCallback(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMMethod");
    TestSVGV8Internal::immutablePointFunctionTypedefMethod(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void svgPointMethodMethod(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    ExceptionState exceptionState(ExceptionState::ExecutionContext, "svgPointMethod", "TestSVG", info.Holder(), info.GetIsolate());
    if (UNLIKELY(info.Length() < 2)) {
        exceptionState.throwTypeError(ExceptionMessages::notEnoughArguments(2, info.Length()));
        exceptionState.throwIfNeeded();
        return;
    }
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    V8TRYCATCH_VOID(SVGPointTearOff*, item, V8SVGPoint::hasInstance(info[0], info.GetIsolate()) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(info[0])) : 0);
    V8TRYCATCH_EXCEPTION_VOID(unsigned, index, toUInt32(info[1], exceptionState), exceptionState);
    v8SetReturnValue(info, imp->svgPointMethod(item, index));
}

static void svgPointMethodMethodCallback(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMMethod");
    TestSVGV8Internal::svgPointMethodMethod(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

static void strictSVGPointMethodMethod(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    ExceptionState exceptionState(ExceptionState::ExecutionContext, "strictSVGPointMethod", "TestSVG", info.Holder(), info.GetIsolate());
    if (UNLIKELY(info.Length() < 2)) {
        exceptionState.throwTypeError(ExceptionMessages::notEnoughArguments(2, info.Length()));
        exceptionState.throwIfNeeded();
        return;
    }
    TestSVG* imp = V8TestSVG::toNative(info.Holder());
    if (info.Length() > 0 && !V8SVGPoint::hasInstance(info[0], info.GetIsolate())) {
        exceptionState.throwTypeError("parameter 1 is not of type 'SVGPoint'.");
        exceptionState.throwIfNeeded();
        return;
    }
    V8TRYCATCH_VOID(SVGPointTearOff*, item, V8SVGPoint::hasInstance(info[0], info.GetIsolate()) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(info[0])) : 0);
    V8TRYCATCH_EXCEPTION_VOID(unsigned, index, toUInt32(info[1], exceptionState), exceptionState);
    RefPtr<SVGPointTearOff> result = imp->strictSVGPointMethod(item, index, exceptionState);
    if (exceptionState.throwIfNeeded())
        return;
    v8SetReturnValue(info, result.release());
}

static void strictSVGPointMethodMethodCallback(const v8::FunctionCallbackInfo<v8::Value>& info)
{
    TRACE_EVENT_SET_SAMPLING_STATE("Blink", "DOMMethod");
    TestSVGV8Internal::strictSVGPointMethodMethod(info);
    TRACE_EVENT_SET_SAMPLING_STATE("V8", "V8Execution");
}

} // namespace TestSVGV8Internal

static const V8DOMConfiguration::AttributeConfiguration V8TestSVGAttributes[] = {
    {"animatedReflectedAttribute", TestSVGV8Internal::animatedReflectedAttributeAttributeGetterCallback, TestSVGV8Internal::animatedReflectedAttributeAttributeSetterCallback, 0, 0, 0, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    {"mutablePoint", TestSVGV8Internal::mutablePointAttributeGetterCallback, TestSVGV8Internal::mutablePointAttributeSetterCallback, 0, 0, 0, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    {"immutablePoint", TestSVGV8Internal::immutablePointAttributeGetterCallback, TestSVGV8Internal::immutablePointAttributeSetterCallback, 0, 0, 0, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
};

static const V8DOMConfiguration::MethodConfiguration V8TestSVGMethods[] = {
    {"mutablePointFunction", TestSVGV8Internal::mutablePointFunctionMethodCallback, 0, 0},
    {"immutablePointFunction", TestSVGV8Internal::immutablePointFunctionMethodCallback, 0, 0},
    {"immutablePointFunctionTypedef", TestSVGV8Internal::immutablePointFunctionTypedefMethodCallback, 0, 0},
    {"svgPointMethod", TestSVGV8Internal::svgPointMethodMethodCallback, 0, 2},
    {"strictSVGPointMethod", TestSVGV8Internal::strictSVGPointMethodMethodCallback, 0, 2},
};

static void configureV8TestSVGTemplate(v8::Handle<v8::FunctionTemplate> functionTemplate, v8::Isolate* isolate, WrapperWorldType currentWorldType)
{
    functionTemplate->ReadOnlyPrototype();

    v8::Local<v8::Signature> defaultSignature;
    defaultSignature = V8DOMConfiguration::installDOMClassTemplate(functionTemplate, "TestSVG", v8::Local<v8::FunctionTemplate>(), V8TestSVG::internalFieldCount,
        V8TestSVGAttributes, WTF_ARRAY_LENGTH(V8TestSVGAttributes),
        0, 0,
        V8TestSVGMethods, WTF_ARRAY_LENGTH(V8TestSVGMethods),
        isolate, currentWorldType);
    v8::Local<v8::ObjectTemplate> ALLOW_UNUSED instanceTemplate = functionTemplate->InstanceTemplate();
    v8::Local<v8::ObjectTemplate> ALLOW_UNUSED prototypeTemplate = functionTemplate->PrototypeTemplate();

    // Custom toString template
    functionTemplate->Set(v8AtomicString(isolate, "toString"), V8PerIsolateData::current()->toStringTemplate());
}

v8::Handle<v8::FunctionTemplate> V8TestSVG::domTemplate(v8::Isolate* isolate, WrapperWorldType currentWorldType)
{
    V8PerIsolateData* data = V8PerIsolateData::from(isolate);
    V8PerIsolateData::TemplateMap::iterator result = data->templateMap(currentWorldType).find(&wrapperTypeInfo);
    if (result != data->templateMap(currentWorldType).end())
        return result->value.newLocal(isolate);

    TRACE_EVENT_SCOPED_SAMPLING_STATE("Blink", "BuildDOMTemplate");
    v8::EscapableHandleScope handleScope(isolate);
    v8::Local<v8::FunctionTemplate> templ = v8::FunctionTemplate::New(isolate, V8ObjectConstructor::isValidConstructorMode);
    configureV8TestSVGTemplate(templ, isolate, currentWorldType);
    data->templateMap(currentWorldType).add(&wrapperTypeInfo, UnsafePersistent<v8::FunctionTemplate>(isolate, templ));
    return handleScope.Escape(templ);
}

bool V8TestSVG::hasInstance(v8::Handle<v8::Value> jsValue, v8::Isolate* isolate)
{
    return V8PerIsolateData::from(isolate)->hasInstanceInMainWorld(&wrapperTypeInfo, jsValue)
        || V8PerIsolateData::from(isolate)->hasInstanceInNonMainWorld(&wrapperTypeInfo, jsValue);
}

v8::Handle<v8::Object> V8TestSVG::createWrapper(PassRefPtr<TestSVG> impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    ASSERT(impl);
    ASSERT(!DOMDataStore::containsWrapper<V8TestSVG>(impl.get(), isolate));
    if (ScriptWrappable::wrapperCanBeStoredInObject(impl.get())) {
        const WrapperTypeInfo* actualInfo = ScriptWrappable::getTypeInfoFromObject(impl.get());
        // Might be a XXXConstructor::wrapperTypeInfo instead of an XXX::wrapperTypeInfo. These will both have
        // the same object de-ref functions, though, so use that as the basis of the check.
        RELEASE_ASSERT_WITH_SECURITY_IMPLICATION(actualInfo->derefObjectFunction == wrapperTypeInfo.derefObjectFunction);
    }

    v8::Handle<v8::Object> wrapper = V8DOMWrapper::createWrapper(creationContext, &wrapperTypeInfo, toInternalPointer(impl.get()), isolate);
    if (UNLIKELY(wrapper.IsEmpty()))
        return wrapper;

    installPerContextEnabledProperties(wrapper, impl.get(), isolate);
    V8DOMWrapper::associateObjectWithWrapper<V8TestSVG>(impl, &wrapperTypeInfo, wrapper, isolate, WrapperConfiguration::Dependent);
    return wrapper;
}

void V8TestSVG::derefObject(void* object)
{
    fromInternalPointer(object)->deref();
}

template<>
v8::Handle<v8::Value> toV8NoInline(TestSVG* impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    return toV8(impl, creationContext, isolate);
}

} // namespace WebCore
