// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ppapi_simple/ps.h"
#include "ppapi_simple/ps_interface.h"

#define DEFINE_INTERFACE_FUNC(Name)                         \
  static const PPB_##Name* s_##Name;                        \
  const PPB_##Name* PSInterface##Name() { return s_##Name; }

DEFINE_INTERFACE_FUNC(Audio)
DEFINE_INTERFACE_FUNC(AudioConfig)
DEFINE_INTERFACE_FUNC(Console)
DEFINE_INTERFACE_FUNC(Core)
DEFINE_INTERFACE_FUNC(FileIO)
DEFINE_INTERFACE_FUNC(FileRef)
DEFINE_INTERFACE_FUNC(FileSystem)
DEFINE_INTERFACE_FUNC(Fullscreen)
DEFINE_INTERFACE_FUNC(Gamepad)
DEFINE_INTERFACE_FUNC(Graphics2D)
DEFINE_INTERFACE_FUNC(Graphics3D)
DEFINE_INTERFACE_FUNC(ImageData)
DEFINE_INTERFACE_FUNC(Instance)
DEFINE_INTERFACE_FUNC(Messaging)
DEFINE_INTERFACE_FUNC(MessageLoop)
DEFINE_INTERFACE_FUNC(MouseCursor)
DEFINE_INTERFACE_FUNC(URLLoader)
DEFINE_INTERFACE_FUNC(URLRequestInfo)
DEFINE_INTERFACE_FUNC(URLResponseInfo)
DEFINE_INTERFACE_FUNC(Var)
DEFINE_INTERFACE_FUNC(VarArrayBuffer)
DEFINE_INTERFACE_FUNC(View)
DEFINE_INTERFACE_FUNC(WebSocket)


#define REQUEST_INTERFACE(x, y)                        \
  s_##x = static_cast<const PPB_##x*>(PSGetInterface(PPB_ ## y ##_INTERFACE));

void PSInterfaceInit() {
  REQUEST_INTERFACE(Audio, AUDIO)
  REQUEST_INTERFACE(AudioConfig, AUDIO_CONFIG)
  REQUEST_INTERFACE(Console, CONSOLE)
  REQUEST_INTERFACE(Core, CORE)
  REQUEST_INTERFACE(FileIO, FILEIO)
  REQUEST_INTERFACE(FileRef, FILEREF)
  REQUEST_INTERFACE(FileSystem, FILESYSTEM)
  REQUEST_INTERFACE(Fullscreen, FULLSCREEN)
  REQUEST_INTERFACE(Gamepad, GAMEPAD)
  REQUEST_INTERFACE(Graphics2D, GRAPHICS_2D)
  REQUEST_INTERFACE(Graphics3D, GRAPHICS_3D)
  REQUEST_INTERFACE(ImageData, IMAGEDATA)
  REQUEST_INTERFACE(Instance, INSTANCE)
  REQUEST_INTERFACE(Messaging, MESSAGING)
  REQUEST_INTERFACE(MessageLoop, MESSAGELOOP)
  REQUEST_INTERFACE(MouseCursor, MOUSECURSOR)
  REQUEST_INTERFACE(URLLoader, URLLOADER)
  REQUEST_INTERFACE(URLRequestInfo, URLREQUESTINFO)
  REQUEST_INTERFACE(URLResponseInfo, URLRESPONSEINFO)
  REQUEST_INTERFACE(Var, VAR)
  REQUEST_INTERFACE(VarArrayBuffer, VAR_ARRAY_BUFFER)
  REQUEST_INTERFACE(View, VIEW)
  REQUEST_INTERFACE(WebSocket, WEBSOCKET)
}
