// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/extensions/api/bluetooth/bluetooth_manifest_handler.h"

#include "chrome/common/extensions/api/bluetooth/bluetooth_manifest_data.h"
#include "chrome/common/extensions/api/bluetooth/bluetooth_manifest_permission.h"
#include "extensions/common/extension.h"
#include "extensions/common/manifest_constants.h"

namespace extensions {

BluetoothManifestHandler::BluetoothManifestHandler() {}

BluetoothManifestHandler::~BluetoothManifestHandler() {}

bool BluetoothManifestHandler::Parse(Extension* extension,
                                     base::string16* error) {
  const base::Value* bluetooth = NULL;
  CHECK(extension->manifest()->Get(manifest_keys::kBluetooth, &bluetooth));
  scoped_ptr<BluetoothManifestData> data =
      BluetoothManifestData::FromValue(*bluetooth, error);
  if (!data)
    return false;

  extension->SetManifestData(manifest_keys::kBluetooth, data.release());
  return true;
}

ManifestPermission* BluetoothManifestHandler::CreatePermission() {
  return new BluetoothManifestPermission();
}

ManifestPermission* BluetoothManifestHandler::CreateInitialRequiredPermission(
    const Extension* extension) {
  BluetoothManifestData* data = BluetoothManifestData::Get(extension);
  if (data)
    return data->permission()->Clone();
  return NULL;
}

const std::vector<std::string> BluetoothManifestHandler::Keys() const {
  return SingleKey(manifest_keys::kBluetooth);
}

}  // namespace extensions
