*** Settings ***
Documentation       Check Cyberoam equipments in SNMP.

Resource            ${CURDIR}${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s
Test Setup          Ctn Generic Suite Setup

*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=network::cyberoam::snmp::plugin


*** Test Cases ***
list-interfaces ${tc}
    [Tags]    network    cyberoam
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=list-interfaces
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=network/cyberoam/snmp/slim_sophos
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Verify Command Output    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                                                       expected_result    --
            ...      1     ${EMPTY}                                                                                                           List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 071' [speed = ][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 175' [speed = ][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 128' [speed = ][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 037' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      2     --interface=1                                                                                                       List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback]
            ...      3     --name='Anonymized 027'                                                                                             List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 071' [speed = ][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 175' [speed = ][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 128' [speed = ][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 037' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      4     --speed=20                                                                                                          List interfaces: 'Anonymized 250' [speed = 20][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 20][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 20][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 20][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 071' [speed = 20][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 073' [speed = 20][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = 20][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = 20][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 20][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 175' [speed = 20][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 128' [speed = 20][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 037' [speed = 20][status = up][id = 2][type = ethernetCsmacd]
            ...      5     --skip-speed0='' --name='Anonymized 232'                                                                            List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] skipping interface 'Anonymized 071': interface speed is 0 and option --skip-speed0 is set 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] skipping interface 'Anonymized 232': interface speed is 0 and option --skip-speed0 is set skipping interface 'Anonymized 191': interface speed is 0 and option --skip-speed0 is set 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd]
            ...      6     --filter-status='up'                                                                                                List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] skipping interface 'Anonymized 071': no matching filter status 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] skipping interface 'Anonymized 232': no matching filter status skipping interface 'Anonymized 191': no matching filter status 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] skipping interface 'Anonymized 175': no matching filter status skipping interface 'Anonymized 128': no matching filter status 'Anonymized 037' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      7     --use-adminstatus='down'                                                                                            List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] skipping interface 'Anonymized 071': adminstatus is not 'up' and option --use-adminstatus is set 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] skipping interface 'Anonymized 175': adminstatus is not 'up' and option --use-adminstatus is set
            ...      8     --oid-filter='ifName'                                                                                               List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 071' [speed = ][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 175' [speed = ][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 128' [speed = ][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 037' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      9     --oid-display='ifDesc'                                                                                              List interfaces: 'Anonymized 147' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 026' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 232' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 093' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 058' [speed = ][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 158' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 160' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 188' [speed = ][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 034' [speed = ][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 029' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      10    --display-transform-src='ens' --display-transform-dst='eth'                                                         List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 071' [speed = ][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 175' [speed = ][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 128' [speed = ][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 037' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      11    --add-extra-oid='vlan,.1.3.6.1.2.1.31.19,\\\%{instance}\..*'                                                        List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][type = ethernetCsmacd] 'Anonymized 071' [speed = ][status = down][id = 13][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 14][type = ethernetCsmacd] 'Anonymized 232' [speed = ][status = down][id = 15][type = ethernetCsmacd] 'Anonymized 191' [speed = ][status = down][id = 16][type = ethernetCsmacd] 'Anonymized 242' [speed = 1000][status = up][id = 17][type = ethernetCsmacd] 'Anonymized 175' [speed = ][status = down][id = 18][type = ethernetCsmacd] 'Anonymized 128' [speed = ][status = down][id = 19][type = ethernetCsmacd] 'Anonymized 037' [speed = ][status = up][id = 2][type = ethernetCsmacd]
            ...      12    --add-mac-address                                                                                                   List interfaces: 'Anonymized 250' [speed = 10][status = up][id = 1][macaddress = ][type = softwareLoopback] 'Anonymized 012' [speed = 1000][status = up][id = 10][macaddress = 41:6e:6f:6e:79:6d:69:7a:65:64:20:30:38:34][type = ethernetCsmacd] 'Anonymized 118' [speed = 1000][status = up][id = 11][macaddress = 41:6e:6f:6e:79:6d:69:7a:65:64:20:31:38:34][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 12][macaddress = 41:6e:6f:6e:79:6d:69:7a:65:64:20:30:37:32][type = ethernetCsmacd] 'Anonymized 071' [speed = ][status = down][id = 13][macaddress = 41:6e:6f:6e:79:6d:69:7a:65:64:20:31:31:39][type = ethernetCsmacd] 'Anonymized 073' [speed = 1000][status = up][id = 14][macaddress = 41:6e:6f:6e:79:6d:69:7a:65:64:20:30:31:30][type = ethernetCsmacd]