/*
 *  Copyright (c) 2004 Boudewijn Rempt (boud@valdyas.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_config_widget.h"
#include "kis_debug.h"
#include <QTimer>

KisConfigWidget::KisConfigWidget(QWidget * parent, Qt::WFlags f, int delay)
        : QWidget(parent, f)
        , m_delay(delay)
{
    m_timer.setSingleShot(true);
    connect(&m_timer, SIGNAL(timeout()), SLOT(slotConfigChanged()));
    connect(this, SIGNAL(sigConfigurationItemChanged()), SLOT(kickTimer()));
}

KisConfigWidget::~KisConfigWidget()
{
}

void KisConfigWidget::slotConfigChanged()
{
    emit sigConfigurationUpdated();
}

void KisConfigWidget::kickTimer()
{
    m_timer.start(m_delay);
}

void KisConfigWidget::setView(KisView2 *view)
{
    if (!view) {
        qWarning() << "KisConfigWidget::setView has got view == 0. That's a bug! Please report it!";
    }
}

#include "kis_config_widget.moc"
