#include "GUI/Support/Util/MessageService.h"
#include "Tests/GTestWrapper/google_test.h"
#include <QObject>
#include <QString>

class TestMessageService : public ::testing::Test {
public:
    class Sender : public QObject {
    public:
        explicit Sender(const QString& name) { setObjectName(name); }
    };
};

TEST_F(TestMessageService, warningAndErrorCount)
{
    const QString senderName1("senderName1");
    const QString senderName2("senderName2");

    const QString description1("description1");
    const QString description2("description2");
    const QString description3("description3");

    MessageService svc;
    Sender sender1(senderName1);
    Sender sender2(senderName2);

    // sending messages
    svc.addWarning(&sender1, description1);
    svc.addWarning(&sender1, description2);
    svc.addError(&sender1, description1);
    svc.addError(&sender2, description2);
    svc.addWarning(&sender1, description3);

    EXPECT_EQ(svc.warnings().size(), 3);
    EXPECT_EQ(svc.errors().size(), 2);
}
