// Boost.Geometry (aka GGL, Generic Geometry Library)
// Unit Test

// Copyright (c) 2012-2014 Barend Gehrels, Amsterdam, the Netherlands.

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#include <test_buffer.hpp>

#include <boost/geometry/algorithms/buffer.hpp>

#include <boost/geometry/geometries/point.hpp>


// Test cases of the list sent by Aimes on geometry list at 2012 Jul 19.
// Complete list at: http://boost-geometry.203548.n3.nabble.com/file/n4025063/BufferProblems.txt
template <typename P>
void test_aimes()
{
    static std::string testcases[] =
    {
    "LINESTRING(-3.031075 52.22385,-3.030809 52.223579,-3.030424 52.223207,-3.030212 52.222931,-3.030013 52.222764,-3.029721 52.222584,-3.029469 52.222443,-3.029218 52.222319,-3.028886 52.222187,-3.028859 52.222176,-3.028815 52.222158,-3.028563 52.222016,-3.028462 52.221945,-3.028407 52.221881,-3.028351 52.22179,-3.028301 52.221718,-3.028203 52.221601,-3.028151 52.221552,-3.027982 52.221422,-3.027871 52.221353,-3.027755 52.221293,-3.027573 52.22121,-3.027493 52.221179,-3.027463 52.221165,-3.027147 52.221065,-3.027045 52.221039,-3.026812 52.220989,-3.026691 52.220968,-3.026602 52.220957,-3.026111 52.220898,-3.025715 52.220861,-3.025332 52.220842,-3.025011 52.220845,-3.024587 52.220849,-3.024339 52.220869,-3.024213 52.220881,-3.024103 52.220905,-3.023904 52.220966,-3.023687 52.221027,-3.023575 52.221054,-3.023409 52.221077,-3.023317 52.221072,-3.023259 52.221049,-3.023028 52.220905,-3.022859 52.220819,-3.022799 52.220774,-3.022739 52.220688)",
    "LINESTRING(-3.056646 52.20421,-3.055298 52.204143,-3.054991 52.204119,-3.053966 52.204125,-3.053793 52.204126)",
    "LINESTRING(-3.040117 52.307787,-3.040012 52.307874,-3.03999 52.30792,-3.039986 52.307973,-3.040054 52.308123,-3.040092 52.308238,-3.040125 52.308398,-3.040165 52.308558,-3.040194 52.308587,-3.040539 52.30889,-3.040868 52.309147,-3.041196 52.309396,-3.042401 52.310114,-3.042414 52.310121,-3.042758 52.31032,-3.04277 52.310327,-3.042779 52.310353,-3.042771 52.31038,-3.042746 52.310444,-3.042627 52.310704,-3.042601 52.310799,-3.042588 52.310846,-3.042588 52.310941,-3.042596 52.311007,-3.04261 52.311035,-3.04264 52.311099,-3.042646 52.311111,-3.042662 52.311134,-3.042681 52.311161,-3.042708 52.311199,-3.042792 52.311275,-3.042808 52.31129,-3.042908 52.311364,-3.04294 52.311385,-3.042996 52.311423,-3.043232 52.311542,-3.043424 52.311632,-3.043447 52.311641,-3.043452 52.311643,-3.043537 52.311677,-3.043725 52.311728,-3.043876 52.311759,-3.044048 52.311784,-3.044325 52.311813,-3.044963 52.31187,-3.045654 52.311927,-3.046044 52.31196,-3.04609 52.311963,-3.046235 52.311979,-3.046374 52.312015,-3.046477 52.312058,-3.046587 52.312109,-3.046654 52.312147,-3.046771 52.312228,-3.046962 52.312372,-3.047043 52.312443,-3.047089 52.312498,-3.04711 52.312547,-3.047112 52.312586,-3.047113 52.312607,-3.047105 52.312666,-3.047067 52.312722)",
    "LINESTRING(-3.054162 52.34456,-3.054088 52.344534,-3.054014 52.344508,-3.053926 52.34449,-3.053823 52.344491,-3.053632 52.344493,-3.053368 52.344513,-3.053149 52.344551,-3.053076 52.34457,-3.053033 52.344588,-3.053003 52.344598)",
    "LINESTRING(-3.032714 52.342934,-3.032658 52.342814,-3.032617 52.342701,-3.032583 52.342606,-3.032554 52.342502,-3.032517 52.342439,-3.032453 52.34233,-3.032374 52.3422,-3.032325 52.342121,-3.032288 52.342056,-3.032252 52.342028)",
    "LINESTRING(-3.041066 52.338221,-3.040547 52.33801,-3.040399 52.337939,-3.040398 52.337921,-3.040427 52.337894,-3.040456 52.337867,-3.040499 52.337849)",
    "LINESTRING(-3.044091 52.565713,-3.044077 52.565734,-3.044071 52.565742,-3.044028 52.565796,-3.043992 52.565879,-3.043952 52.565959,-3.043915 52.566,-3.043857 52.56604,-3.043741 52.566113,-3.043492 52.566223,-3.042615 52.566563,-3.042425 52.566646,-3.042294 52.566683,-3.041932 52.566745,-3.041648 52.566791,-3.041445 52.566841,-3.041226 52.566924,-3.041066 52.566992,-3.04089 52.567056,-3.040865 52.56708,-3.040858 52.5671,-3.040879 52.567118,-3.040944 52.567135,-3.041034 52.567137,-3.041288 52.567141,-3.041822 52.567144,-3.042107 52.567134,-3.042245 52.567142,-3.04229 52.56715,-3.042558 52.567247,-3.042736 52.56729,-3.042918 52.567326,-3.043082 52.567338,-3.043388 52.567401,-3.043848 52.567532,-3.043908 52.567568,-3.043923 52.567577,-3.043938 52.567603,-3.04394 52.567657,-3.043941 52.567711,-3.043895 52.56798,-3.043869 52.568115,-3.043868 52.568138,-3.043869 52.568158)",
    "LINESTRING(-3.039713 52.536795,-3.039808 52.536825,-3.039958 52.536844,-3.040172 52.536885,-3.040322 52.536924,-3.040476 52.536964,-3.04061 52.536989,-3.040678 52.536992,-3.040773 52.536986,-3.040949 52.536958,-3.041148 52.536905,-3.041312 52.536857,-3.041544 52.536777,-3.04173 52.536705,-3.041942 52.536634,-3.042081 52.5366,-3.042204 52.53659,-3.042324 52.536587,-3.042414 52.536591,-3.042491 52.536598,-3.042595 52.536619,-3.042767 52.536683,-3.042916 52.536749,-3.043007 52.536786,-3.043108 52.5368)",
    "LINESTRING(-3.049078 52.571837,-3.049229 52.571855,-3.04964 52.571857,-3.049841 52.571858,-3.049967 52.571873,-3.05006 52.571903,-3.050094 52.571922,-3.050135 52.57194,-3.050228 52.571958,-3.05033 52.571969,-3.050391 52.571987,-3.050413 52.572027,-3.050421 52.572072,-3.050386 52.572205)",
    "LINESTRING(-2.983733 52.233609,-2.98371 52.233684,-2.983736 52.233793,-2.98379 52.233906,-2.983869 52.233994,-2.984058 52.234121,-2.984225 52.234228,-2.984382 52.234341,-2.984557 52.234481,-2.984695 52.234575,-2.984716 52.234589,-2.984758 52.234617,-2.984943 52.234694,-2.984978 52.234706,-2.985031 52.234722,-2.98506 52.234731,-2.985343 52.234799,-2.985594 52.234867,-2.985755 52.234917,-2.986071 52.23497,-2.9863 52.235006,-2.986458 52.235044,-2.986602 52.235109,-2.987015 52.23534,-2.987215 52.235464,-2.987423 52.235617,-2.987637 52.235785,-2.987968 52.23602,-2.988192 52.236213,-2.988438 52.236386,-2.988512 52.236449,-2.988579 52.236505,-2.98865 52.236583,-2.98869 52.236656,-2.988721 52.236744,-2.988612 52.236848,-2.988548 52.236932,-2.988497 52.237107,-2.988432 52.237336,-2.988372 52.237567,-2.98833 52.237709,-2.988286 52.23788,-2.988233 52.23807,-2.988249 52.238145,-2.988291 52.238321,-2.988323 52.238505,-2.988379 52.238624,-2.988435 52.238727,-2.988438 52.238732,-2.988466 52.238777,-2.988485 52.238809,-2.988525 52.238854,-2.98858 52.238916,-2.988715 52.239098,-2.988806 52.239204,-2.988865 52.239275,-2.988962 52.239393,-2.989045 52.239474,-2.989244 52.239629,-2.989254 52.239636,-2.989273 52.239649,-2.989508 52.239816,-2.989534 52.239835,-2.989747 52.23998,-2.989769 52.239996,-2.98982 52.240033,-2.989843 52.240055,-2.989949 52.240152,-2.989956 52.240159,-2.99002 52.240248,-2.990074 52.240334,-2.990079 52.24034,-2.990089 52.240357,-2.990106 52.240401,-2.99015 52.240512,-2.990268 52.240793,-2.990336 52.24095,-2.990425 52.241123,-2.990472 52.241198,-2.990617 52.241383,-2.990723 52.241527,-2.990784 52.241601,-2.990811 52.241633,-2.990859 52.241753,-2.990892 52.241854,-2.99094 52.241995,-2.990947 52.242025,-2.990958 52.24207,-2.991023 52.242175,-2.991122 52.242333,-2.991202 52.242485,-2.991276 52.242624,-2.991408 52.242809,-2.991639 52.2431,-2.99172 52.243202,-2.991734 52.243222,-2.991897 52.243461,-2.991944 52.243547,-2.992072 52.243781,-2.992267 52.244138,-2.992431 52.244408,-2.992503 52.244532,-2.992657 52.244802,-2.992761 52.245063,-2.9928 52.245305,-2.992813 52.245622,-2.992822 52.245701,-2.99281 52.245784,-2.992793 52.245867,-2.992771 52.245927,-2.992736 52.245978,-2.992646 52.246076,-2.992573 52.246144,-2.992455 52.246276,-2.992316 52.246468,-2.992432 52.246557,-2.99253 52.246568,-2.992901 52.246565,-2.993581 52.246527,-2.993926 52.246509,-2.994191 52.246514)",
    "LINESTRING(-3.012501 52.228425,-3.012694 52.22837,-3.012848 52.228308,-3.012946 52.22824,-3.013055 52.228146,-3.013123 52.228048,-3.013182 52.227904,-3.013242 52.227742,-3.013269 52.227632,-3.01327 52.227553,-3.013245 52.227479,-3.013151 52.227332,-3.013072 52.227223,-3.012938 52.227095,-3.012779 52.226936,-3.01271 52.226867,-3.012639 52.226817,-3.012452 52.226743,-3.012278 52.226685,-3.01201 52.226616,-3.011707 52.226519,-3.011541 52.226458,-3.011388 52.22638,-3.011334 52.226352,-3.011111 52.226206,-3.010983 52.226107,-3.010893 52.226012,-3.010832 52.225905,-3.010825 52.225845,-3.010841 52.225687,-3.010858 52.225516,-3.010857 52.225451,-3.010844 52.225405,-3.010747 52.225247,-3.01062 52.225123,-3.010467 52.224893,-3.010372 52.224658)",
    "LINESTRING(-2.998218 52.230123,-2.998074 52.230203,-2.998066 52.230206,-2.997957 52.230258,-2.997863 52.230302,-2.997049 52.230561,-2.996351 52.230783,-2.995741 52.230976,-2.995552 52.231032)",
    "LINESTRING(-3.005291 52.231131,-3.005218 52.2312,-3.005076 52.23132,-3.004901 52.231443,-3.004725 52.231551,-3.004586 52.231621,-3.004439 52.231667,-3.004381 52.231685,-3.004236 52.231693,-3.004106 52.231684,-3.003877 52.231653,-3.003705 52.231618,-3.003613 52.231587,-3.003529 52.231549,-3.003019 52.231279,-3.002922 52.231244,-3.002789 52.231196,-3.002657 52.231144,-3.002492 52.231112,-3.002372 52.231091,-3.002239 52.231073,-3.001708 52.231062,-3.001596 52.231053,-3.000959 52.230853,-3.000714 52.230758,-3.00005 52.2305,-2.999016 52.230131,-2.999001 52.230122)",
    "LINESTRING(-3.031075 52.22385,-3.030809 52.223579,-3.030424 52.223207,-3.030212 52.222931,-3.030013 52.222764,-3.029721 52.222584,-3.029469 52.222443,-3.029218 52.222319,-3.028886 52.222187,-3.028859 52.222176,-3.028815 52.222158,-3.028563 52.222016,-3.028462 52.221945,-3.028407 52.221881,-3.028351 52.22179,-3.028301 52.221718,-3.028203 52.221601,-3.028151 52.221552,-3.027982 52.221422,-3.027871 52.221353,-3.027755 52.221293,-3.027573 52.22121,-3.027493 52.221179,-3.027463 52.221165,-3.027147 52.221065,-3.027045 52.221039,-3.026812 52.220989,-3.026691 52.220968,-3.026602 52.220957,-3.026111 52.220898,-3.025715 52.220861,-3.025332 52.220842,-3.025011 52.220845,-3.024587 52.220849,-3.024339 52.220869,-3.024213 52.220881,-3.024103 52.220905,-3.023904 52.220966,-3.023687 52.221027,-3.023575 52.221054,-3.023409 52.221077,-3.023317 52.221072,-3.023259 52.221049,-3.023028 52.220905,-3.022859 52.220819,-3.022799 52.220774,-3.022739 52.220688)",
    "LINESTRING(-3.005281 52.202464,-3.005919 52.202654,-3.006134 52.202718,-3.007138 52.202939,-3.007725 52.20309)",
    "LINESTRING(-3.003371 52.210074,-3.003224 52.21001,-3.003195 52.209997,-3.003094 52.209988,-3.003007 52.209981,-3.002994 52.20998,-3.002952 52.209994,-3.002853 52.210026,-3.002667 52.210068,-3.002566 52.21008,-3.002539 52.210084,-3.002326 52.210102,-3.002318 52.210103,-3.00231 52.210104,-3.002164 52.210134,-3.001964 52.21022,-3.001792 52.210359)",
    "LINESTRING(-2.968498 52.185726,-2.968594 52.185677,-2.968762 52.185642,-2.968969 52.185608,-2.969272 52.185575,-2.970091 52.185526,-2.970473 52.185443,-2.971035 52.185384,-2.971959 52.185251,-2.972754 52.185111,-2.973037 52.185044,-2.973168 52.185016,-2.973851 52.184803,-2.97401 52.184739,-2.974271 52.184602,-2.974856 52.184364,-2.97488 52.184356,-2.975153 52.184265,-2.975391 52.184212,-2.975741 52.184173,-2.97598 52.184125,-2.976288 52.184004,-2.976831 52.183673,-2.977132 52.183471,-2.977414 52.183259,-2.977612 52.183012,-2.978006 52.182385,-2.978157 52.182251,-2.97863 52.181886)",
    "LINESTRING(-2.898438 52.177673,-2.897173 52.178057,-2.896867 52.178131,-2.89675 52.178159,-2.896383 52.178233,-2.896087 52.178291,-2.895818 52.178337,-2.895512 52.178384,-2.895118 52.178441,-2.894593 52.178499,-2.894339 52.178519,-2.894317 52.178514,-2.894308 52.178511,-2.894282 52.178504,-2.894217 52.178425,-2.894159 52.178354,-2.894028 52.178134,-2.894001 52.178031,-2.893855 52.177495,-2.893851 52.177478,-2.893683 52.17713,-2.893553 52.176988,-2.893238 52.176731,-2.893127 52.176628,-2.892918 52.176433,-2.892613 52.176056,-2.892122 52.175233,-2.892067 52.175113,-2.891895 52.174561,-2.891781 52.174335,-2.891634 52.174134,-2.891492 52.17394,-2.891344 52.173699,-2.891083 52.173401,-2.89083 52.173169,-2.890577 52.172964,-2.890468 52.172913,-2.890384 52.172882,-2.890276 52.172865,-2.890107 52.17286,-2.890063 52.172851,-2.889975 52.172834,-2.889808 52.17278,-2.889709 52.172725,-2.889451 52.172532,-2.88907 52.172247,-2.888619 52.171957,-2.888574 52.171916)",
    "LINESTRING(-3.001027 52.270697,-3.001233 52.270714,-3.00157 52.270711,-3.001614 52.270715,-3.001658 52.270719,-3.001746 52.270736,-3.002 52.270828)",
    "LINESTRING(-3.002514 52.270973,-3.002616 52.270954,-3.00282 52.270916,-3.002878 52.27088,-3.002978 52.270771,-3.003022 52.270752,-3.003066 52.270743,-3.003124 52.270734)",
    "LINESTRING(-2.944639 52.25447,-2.944459 52.254529,-2.944255 52.254603,-2.944087 52.254655,-2.943732 52.254787,-2.943453 52.25489,-2.943209 52.254982,-2.943098 52.255011,-2.942917 52.255063,-2.94283 52.255093,-2.94258 52.255195,-2.942226 52.255335,-2.942051 52.255401,-2.941816 52.255507,-2.941631 52.255602,-2.941497 52.255668,-2.941335 52.255741,-2.941207 52.2558,-2.941149 52.255815,-2.941074 52.255876,-2.94107 52.255945,-2.941106 52.255995,-2.941153 52.256023,-2.94152 52.25616,-2.941797 52.256259,-2.94205 52.256349,-2.9425 52.256509,-2.942615 52.256533,-2.942714 52.256543,-2.94282 52.256546,-2.943027 52.256522,-2.943226 52.256496,-2.943459 52.256443,-2.943774 52.256373,-2.944095 52.256291,-2.944325 52.256228,-2.944471 52.256187,-2.94475 52.256106,-2.944948 52.256054,-2.945042 52.256035,-2.945176 52.256027,-2.945305 52.256026,-2.94547 52.256032,-2.945731 52.256048,-2.945977 52.256064,-2.94623 52.256087,-2.946353 52.256107,-2.94647 52.256139,-2.946483 52.256142,-2.946595 52.256185,-2.946689 52.256202,-2.946889 52.256233,-2.946994 52.256232)",
    "LINESTRING(-2.983733 52.233609,-2.98371 52.233684,-2.983736 52.233793,-2.98379 52.233906,-2.983869 52.233994,-2.984058 52.234121,-2.984225 52.234228,-2.984382 52.234341,-2.984557 52.234481,-2.984695 52.234575,-2.984716 52.234589,-2.984758 52.234617,-2.984943 52.234694,-2.984978 52.234706,-2.985031 52.234722,-2.98506 52.234731,-2.985343 52.234799,-2.985594 52.234867,-2.985755 52.234917,-2.986071 52.23497,-2.9863 52.235006,-2.986458 52.235044,-2.986602 52.235109,-2.987015 52.23534,-2.987215 52.235464,-2.987423 52.235617,-2.987637 52.235785,-2.987968 52.23602,-2.988192 52.236213,-2.988438 52.236386,-2.988512 52.236449,-2.988579 52.236505,-2.98865 52.236583,-2.98869 52.236656,-2.988721 52.236744,-2.988612 52.236848,-2.988548 52.236932,-2.988497 52.237107,-2.988432 52.237336,-2.988372 52.237567,-2.98833 52.237709,-2.988286 52.23788,-2.988233 52.23807,-2.988249 52.238145,-2.988291 52.238321,-2.988323 52.238505,-2.988379 52.238624,-2.988435 52.238727,-2.988438 52.238732,-2.988466 52.238777,-2.988485 52.238809,-2.988525 52.238854,-2.98858 52.238916,-2.988715 52.239098,-2.988806 52.239204,-2.988865 52.239275,-2.988962 52.239393,-2.989045 52.239474,-2.989244 52.239629,-2.989254 52.239636,-2.989273 52.239649,-2.989508 52.239816,-2.989534 52.239835,-2.989747 52.23998,-2.989769 52.239996,-2.98982 52.240033,-2.989843 52.240055,-2.989949 52.240152,-2.989956 52.240159,-2.99002 52.240248,-2.990074 52.240334,-2.990079 52.24034,-2.990089 52.240357,-2.990106 52.240401,-2.99015 52.240512,-2.990268 52.240793,-2.990336 52.24095,-2.990425 52.241123,-2.990472 52.241198,-2.990617 52.241383,-2.990723 52.241527,-2.990784 52.241601,-2.990811 52.241633,-2.990859 52.241753,-2.990892 52.241854,-2.99094 52.241995,-2.990947 52.242025,-2.990958 52.24207,-2.991023 52.242175,-2.991122 52.242333,-2.991202 52.242485,-2.991276 52.242624,-2.991408 52.242809,-2.991639 52.2431,-2.99172 52.243202,-2.991734 52.243222,-2.991897 52.243461,-2.991944 52.243547,-2.992072 52.243781,-2.992267 52.244138,-2.992431 52.244408,-2.992503 52.244532,-2.992657 52.244802,-2.992761 52.245063,-2.9928 52.245305,-2.992813 52.245622,-2.992822 52.245701,-2.99281 52.245784,-2.992793 52.245867,-2.992771 52.245927,-2.992736 52.245978,-2.992646 52.246076,-2.992573 52.246144,-2.992455 52.246276,-2.992316 52.246468,-2.992432 52.246557,-2.99253 52.246568,-2.992901 52.246565,-2.993581 52.246527,-2.993926 52.246509,-2.994191 52.246514)",
    "LINESTRING(-2.96971 52.385285,-2.969713 52.385302,-2.969795 52.385527,-2.969832 52.385568,-2.969956 52.38576,-2.970018 52.385883,-2.970042 52.386056,-2.970042 52.386067,-2.970029 52.386343,-2.970014 52.386442,-2.970008 52.386483,-2.970029 52.386586,-2.970032 52.386601,-2.970046 52.38667,-2.970131 52.386944,-2.970207 52.387072,-2.970265 52.387126,-2.970375 52.387143,-2.970425 52.387133,-2.970477 52.387106,-2.970477 52.38709,-2.970472 52.386848,-2.970485 52.386677,-2.970516 52.386575,-2.970655 52.386395,-2.970876 52.386204,-2.971034 52.386111,-2.971198 52.386032,-2.971267 52.386004,-2.97138 52.385958,-2.971639 52.385807,-2.971826 52.385679,-2.972103 52.385586,-2.97241 52.385483,-2.972753 52.385377,-2.973047 52.385311,-2.973623 52.385203,-2.973844 52.385136,-2.974009 52.385057,-2.974682 52.384692,-2.97509 52.384475,-2.975346 52.384353,-2.975663 52.384199,-2.975822 52.384099,-2.976126 52.383856,-2.976248 52.383782,-2.976406 52.383709,-2.976808 52.383507,-2.97691 52.383452,-2.977112 52.383324,-2.977314 52.383143,-2.977415 52.383034,-2.977529 52.382898,-2.9776 52.382799,-2.977628 52.382736,-2.977656 52.382637,-2.977696 52.382474,-2.977693 52.38234,-2.977622 52.382209,-2.977479 52.382031,-2.977175 52.381694,-2.97694 52.381417,-2.976698 52.381146,-2.976623 52.381043,-2.976554 52.380924,-2.976446 52.380715,-2.976363 52.380584,-2.976241 52.380298,-2.976087 52.379831,-2.976036 52.379608,-2.976069 52.37928,-2.976091 52.378928,-2.976071 52.378613,-2.976035 52.378424,-2.975992 52.378395,-2.975901 52.378223,-2.975842 52.378095,-2.975834 52.37802,-2.975822 52.3779,-2.975776 52.377677,-2.97571 52.377473,-2.975613 52.377281,-2.975564 52.377153,-2.975519 52.376974,-2.975433 52.376805,-2.975342 52.376658,-2.975273 52.376573,-2.97521 52.376501,-2.975142 52.376448,-2.975027 52.376371,-2.975012 52.376362,-2.974887 52.376293,-2.974849 52.376237,-2.974917 52.37617,-2.97468 52.376055,-2.974513 52.375966,-2.974362 52.375877,-2.97431 52.375843,-2.974406 52.375776,-2.974582 52.37576,-2.974724 52.37574,-2.974958 52.375653,-2.975739 52.375344,-2.976395 52.37508,-2.976664 52.374976,-2.97683 52.374762)",
    "LINESTRING(-2.997814 52.40448,-2.997576 52.404378,-2.997296 52.404275,-2.996941 52.404117,-2.99681 52.404059,-2.996536 52.40394,-2.996318 52.403882,-2.996251 52.403881,-2.995987 52.403877,-2.995775 52.403884,-2.995515 52.403893,-2.994131 52.403964,-2.993583 52.403996,-2.992706 52.404048,-2.991636 52.404103,-2.990507 52.404147,-2.990135 52.404129)",
    "LINESTRING(-2.982697 52.39662,-2.98267 52.396548,-2.982609 52.396497,-2.982548 52.396461,-2.982336 52.396409,-2.981863 52.396237,-2.981625 52.396145,-2.981339 52.396039,-2.981101 52.395931,-2.980871 52.395818,-2.980433 52.395637,-2.979978 52.395444,-2.979797 52.395343,-2.979337 52.395045,-2.978829 52.394739,-2.978805 52.39471,-2.978742 52.394637,-2.978614 52.39454,-2.978484 52.394484,-2.978426 52.394459,-2.97776 52.394027,-2.977536 52.393867,-2.977492 52.393849,-2.977344 52.393805,-2.975869 52.393539,-2.975558 52.393469,-2.975307 52.393408,-2.975026 52.393312,-2.974937 52.393268,-2.974733 52.393166,-2.974573 52.393071,-2.974432 52.39302,-2.974284 52.392994,-2.97424 52.392995,-2.97399 52.392997,-2.973932 52.393006,-2.973771 52.393035)",
    "LINESTRING(-2.953194 52.366719,-2.953507 52.366736,-2.95351 52.366736,-2.953908 52.366768,-2.954334 52.366791,-2.954562 52.366786,-2.954729 52.366779,-2.95522 52.366749,-2.955385 52.366757,-2.955502 52.366795,-2.955579 52.366826,-2.955921 52.366996,-2.956027 52.367056,-2.95617 52.367141,-2.956353 52.367269,-2.956449 52.367341,-2.956469 52.367356,-2.956512 52.367399,-2.956659 52.367549,-2.956776 52.367661,-2.956944 52.367788,-2.957149 52.367924,-2.95735 52.368033,-2.95769 52.368188,-2.957898 52.368266,-2.95797 52.368293,-2.958228 52.368394,-2.958339 52.368458,-2.958398 52.368522,-2.958431 52.368627,-2.958477 52.368714,-2.95853 52.368773,-2.958568 52.368816,-2.958702 52.368923,-2.958908 52.369053,-2.959013 52.369151,-2.959058 52.369195,-2.959133 52.369258)",
    "LINESTRING(-2.966068 52.360895,-2.966222 52.360891,-2.966478 52.360892,-2.966667 52.360885,-2.966835 52.360892,-2.967243 52.360923,-2.967495 52.360948,-2.967636 52.360953,-2.968078 52.360941,-2.968299 52.360944,-2.968545 52.360956,-2.968642 52.36095,-2.968822 52.360921,-2.968959 52.360912,-2.96913 52.360911,-2.969356 52.36086,-2.969479 52.360843,-2.969638 52.360834,-2.969796 52.360838,-2.96996 52.360861,-2.970075 52.360884,-2.970228 52.360942,-2.970326 52.360979,-2.970397 52.361011,-2.970521 52.361026,-2.970653 52.361041,-2.97072 52.361051,-2.97083 52.361056,-2.970936 52.36106,-2.97094 52.361061,-2.971028 52.36107,-2.971061 52.361068,-2.971165 52.361061,-2.971173 52.361062,-2.971229 52.361066,-2.971282 52.361087,-2.97138 52.361148,-2.97159 52.361282,-2.971747 52.361379,-2.971835 52.361427,-2.97189 52.361457,-2.971956 52.361493,-2.972094 52.361559,-2.972336 52.361658,-2.972537 52.361748,-2.972635 52.361815,-2.972698 52.361858,-2.972796 52.361938,-2.972891 52.362013,-2.972933 52.362045,-2.973002 52.36209)",
    "LINESTRING(-2.9647 52.372689,-2.964835 52.372426,-2.964879 52.372262,-2.964847 52.372112,-2.964788 52.372011,-2.964689 52.371911,-2.964426 52.371713,-2.964038 52.371527,-2.963476 52.371297,-2.962907 52.3711,-2.962814 52.371067,-2.962322 52.3709,-2.961904 52.370745,-2.9619 52.370744,-2.961896 52.370742,-2.961634 52.370672,-2.961628 52.370671,-2.961259 52.370618,-2.961135 52.370605,-2.961085 52.3706,-2.961086 52.370591,-2.961095 52.370497,-2.961096 52.370488,-2.961121 52.370455,-2.96131 52.370209,-2.961519 52.369984,-2.961685 52.369803,-2.96174 52.369743,-2.961792 52.369643,-2.961827 52.369523,-2.961869 52.369469)",
    "LINESTRING(-2.991736 52.342846,-2.991747 52.342813,-2.991756 52.342764,-2.991745 52.342628,-2.991739 52.342554,-2.991732 52.342531,-2.991722 52.342499,-2.991718 52.342485,-2.991714 52.342478,-2.9917 52.342451,-2.99169 52.342431,-2.991614 52.342342,-2.991594 52.342322,-2.991511 52.342239,-2.991321 52.34207,-2.991234 52.341994,-2.991138 52.341912,-2.99098 52.34178,-2.990834 52.34166,-2.990727 52.341549,-2.990648 52.341466,-2.990603 52.341414,-2.990584 52.341391,-2.990528 52.341311,-2.990484 52.341226,-2.990471 52.341181)",
    "LINESTRING(-2.981095 52.339053,-2.981289 52.3392,-2.981405 52.339277,-2.981642 52.339412,-2.981862 52.339531,-2.98203 52.339615,-2.982129 52.339653,-2.982253 52.339691,-2.982421 52.33973,-2.982601 52.339756,-2.982838 52.339782,-2.982943 52.339791,-2.983192 52.339812,-2.983421 52.339829,-2.983576 52.339841,-2.983713 52.339838,-2.983942 52.339827,-2.984066 52.339821,-2.984197 52.339814,-2.984359 52.339813,-2.984503 52.339822,-2.984523 52.339825,-2.984641 52.339843,-2.984781 52.339878,-2.984989 52.33993,-2.985142 52.339976,-2.98533 52.340048,-2.98545 52.340101,-2.985793 52.340305,-2.986179 52.340517,-2.987262 52.341021,-2.987502 52.341139,-2.987993 52.341405,-2.98828 52.341552,-2.988419 52.341614,-2.988615 52.341683,-2.988796 52.34174,-2.989201 52.34185,-2.98978 52.342006,-2.989938 52.342049,-2.990297 52.342157,-2.990544 52.342244,-2.99059 52.342263,-2.990618 52.342275,-2.990752 52.342331,-2.990972 52.342441,-2.991182 52.342569,-2.991334 52.34268,-2.991462 52.34278,-2.991575 52.342877)",
    "LINESTRING(-2.978378 52.326615,-2.97858 52.326744,-2.978935 52.326903,-2.979113 52.326964,-2.98031 52.327377,-2.98094 52.327552,-2.981104 52.3276,-2.981291 52.327676,-2.981642 52.327824,-2.981986 52.327972,-2.982377 52.328139,-2.982546 52.328208,-2.982722 52.328274,-2.982959 52.328344,-2.983549 52.328502,-2.983608 52.328518,-2.983888 52.328588,-2.984434 52.328711,-2.984582 52.328744,-2.985255 52.328894)",
    "LINESTRING(-2.943084 52.483843,-2.943363 52.483805,-2.943509 52.483777,-2.943656 52.483749,-2.943861 52.483702,-2.946632 52.483131,-2.946734 52.483095,-2.946799 52.483048,-2.946915 52.482932,-2.946924 52.482923,-2.947675 52.481978,-2.947651 52.481577)",
    "LINESTRING(-2.953071 52.469338,-2.953299 52.469326,-2.953594 52.469323,-2.953639 52.469322,-2.953712 52.469319,-2.953768 52.469307,-2.95379 52.469286,-2.953798 52.469217,-2.953806 52.46915,-2.953821 52.469024,-2.953855 52.468907,-2.953909 52.468773,-2.953968 52.468659,-2.954018 52.468562,-2.954068 52.468403,-2.954076 52.46835)",
    "LINESTRING(-2.916212 52.483947,-2.91619 52.483345,-2.916182 52.48319,-2.916111 52.48314,-2.915883 52.483029,-2.915722 52.482945,-2.915568 52.482864,-2.915468 52.4828,-2.915327 52.482683,-2.915234 52.482569,-2.915128 52.482414,-2.915013 52.482195,-2.914907 52.48201,-2.914737 52.481759,-2.914614 52.481537,-2.914521 52.481405,-2.914382 52.481233,-2.914305 52.481106,-2.914271 52.481006,-2.914213 52.480799,-2.914163 52.480589,-2.914093 52.480359,-2.914032 52.480197,-2.913985 52.480069,-2.913891 52.479905,-2.913802 52.479758,-2.913734 52.479661,-2.913625 52.479521,-2.913468 52.479309,-2.913381 52.479147,-2.913312 52.478929,-2.913259 52.478706,-2.913218 52.478303,-2.913225 52.478168,-2.913255 52.478098,-2.913311 52.478047,-2.913425 52.477985,-2.913772 52.477823,-2.914284 52.477584,-2.914879 52.477304,-2.915429 52.477045,-2.915857 52.476856,-2.915888 52.476843,-2.916396 52.476614,-2.916883 52.476387,-2.917208 52.476227,-2.917382 52.476128,-2.917702 52.47591,-2.917998 52.475688,-2.918258 52.475444,-2.918358 52.475335,-2.918513 52.475115,-2.918572 52.474971,-2.918603 52.474853,-2.918636 52.474674,-2.918663 52.47453,-2.91872 52.474392,-2.918813 52.474244)",
    "LINESTRING(-2.919312 52.439208,-2.919221 52.439125,-2.919125 52.43902,-2.919047 52.438938,-2.918999 52.438881,-2.918932 52.438799,-2.918872 52.438731,-2.918806 52.438649,-2.918698 52.438542,-2.918601 52.438445,-2.918499 52.438349,-2.918451 52.438292,-2.918439 52.438256,-2.918376 52.438088,-2.918314 52.437944,-2.918234 52.437751,-2.918185 52.437647,-2.918111 52.437478,-2.918055 52.437349,-2.918005 52.437213,-2.917956 52.437109,-2.917925 52.437023,-2.9179 52.43698,-2.917864 52.436926,-2.917809 52.436844,-2.917742 52.436751,-2.917724 52.436719,-2.917693 52.436644,-2.917668 52.436583,-2.917572 52.436479,-2.91747 52.436365,-2.917331 52.436215,-2.917139 52.436033,-2.917043 52.435915,-2.916953 52.435851,-2.916768 52.435712,-2.916576 52.435559,-2.916332 52.435417,-2.916082 52.435279,-2.915838 52.435151,-2.915684 52.435073,-2.915559 52.43501,-2.915481 52.434949,-2.915403 52.434892,-2.915349 52.434824,-2.9153 52.434756,-2.915258 52.434688,-2.915228 52.434645,-2.915186 52.434572,-2.915155 52.434498,-2.915139 52.434444,-2.915139 52.43442,-2.915138 52.434417,-2.915139 52.434415,-2.91516 52.434369,-2.915165 52.434358,-2.915181 52.434324,-2.915231 52.43426,-2.915311 52.434181,-2.915369 52.434138,-2.915495 52.434062,-2.91564 52.433982,-2.915832 52.433884,-2.916101 52.433748,-2.916287 52.433654,-2.916591 52.43349,-2.916911 52.433308,-2.917317 52.433053,-2.917607 52.432862,-2.918043 52.432589,-2.918319 52.432407,-2.91859 52.432242,-2.918741 52.43214,-2.918915 52.43202,-2.919031 52.431948,-2.919164 52.431846,-2.91935 52.4317,-2.919518 52.431584,-2.919732 52.43141,-2.919836 52.431326,-2.920015 52.431156,-2.920147 52.431018,-2.920192 52.430928,-2.920225 52.430809,-2.920223 52.43068,-2.92019 52.430536,-2.920104 52.430342,-2.920006 52.430149,-2.919897 52.429995,-2.919775 52.429802,-2.91972 52.429727,-2.919612 52.429616,-2.919503 52.429521,-2.919419 52.429431,-2.918939 52.429004,-2.918704 52.42882,-2.918615 52.428748,-2.918495 52.428652,-2.918399 52.428585,-2.918197 52.428464,-2.91803 52.428365,-2.917685 52.428162,-2.917572 52.428098,-2.917458 52.428024,-2.917214 52.427882,-2.917012 52.427772,-2.916822 52.427687,-2.916679 52.427623,-2.916631 52.427591,-2.916617 52.427566,-2.916582 52.427504,-2.91651 52.427356)",
    "LINESTRING(-2.947531 52.452306,-2.947455 52.452225,-2.947258 52.452046,-2.947076 52.45192,-2.946897 52.451781,-2.946825 52.451714,-2.946704 52.451592,-2.946619 52.451467,-2.946503 52.451249,-2.946459 52.451116,-2.946407 52.450915,-2.946378 52.450667,-2.946375 52.45052,-2.946369 52.450229,-2.946394 52.450034,-2.946421 52.449922,-2.946465 52.44976,-2.946549 52.449573,-2.946633 52.449371,-2.946715 52.449246,-2.947034 52.448702,-2.94729 52.448297,-2.947489 52.447958,-2.94775 52.447531,-2.947921 52.447256,-2.948205 52.446801,-2.948314 52.446631,-2.948518 52.446295,-2.948569 52.446201,-2.948642 52.446042,-2.948715 52.445855,-2.948821 52.445591,-2.948888 52.445408,-2.948953 52.445166,-2.948951 52.445083,-2.948944 52.445001,-2.948888 52.444902,-2.948786 52.444799,-2.948738 52.444734,-2.94869 52.444649,-2.948687 52.444493)",
    "LINESTRING(-2.984196 52.486523,-2.984457 52.486368,-2.984901 52.486099,-2.985548 52.4857,-2.985908 52.48547,-2.986144 52.485334,-2.986369 52.485187,-2.986479 52.485104,-2.986539 52.485057,-2.986632 52.485021,-2.986663 52.485009,-2.986728 52.485002,-2.986917 52.485008,-2.986978 52.485013,-2.987559 52.485093,-2.987778 52.485123,-2.987914 52.485143,-2.988009 52.485137,-2.988065 52.485122,-2.988137 52.485085,-2.988211 52.485037,-2.988273 52.484995,-2.98831 52.484979)",
    "LINESTRING(-2.995145 52.490812,-2.995121 52.49082,-2.995106 52.490825,-2.995003 52.490841)",
    "LINESTRING(-2.987242 52.435163,-2.987322 52.435211,-2.987423 52.435307,-2.98768 52.435622,-2.987945 52.435949,-2.988222 52.436339,-2.988312 52.436495,-2.988352 52.436544,-2.988361 52.436555,-2.988405 52.436579,-2.988465 52.436592,-2.988548 52.436586,-2.988625 52.436547,-2.988673 52.436501,-2.988917 52.436278,-2.989057 52.43615,-2.989383 52.435896,-2.989453 52.435863,-2.989572 52.435828,-2.989748 52.435819,-2.990029 52.435835,-2.990331 52.435876,-2.990701 52.435933,-2.990873 52.435968,-2.990993 52.435992,-2.991047 52.436006,-2.991327 52.436078,-2.992217 52.436386,-2.992457 52.436462,-2.992636 52.436531,-2.992846 52.436578,-2.993009 52.436622,-2.993203 52.436691,-2.993324 52.436736,-2.99351 52.436806,-2.993735 52.436909,-2.993967 52.43702,-2.994208 52.437165,-2.994378 52.437262,-2.994486 52.437308,-2.994589 52.437341,-2.994683 52.43736,-2.994729 52.437357,-2.994784 52.437355,-2.994838 52.437352,-2.994951 52.437331,-2.995025 52.437296,-2.995207 52.437212,-2.995258 52.437194,-2.995512 52.43715,-2.995565 52.437141,-2.995813 52.437096,-2.995912 52.437047,-2.996021 52.436998)",
    "LINESTRING(-3.029102 52.479538,-3.029049 52.479509,-3.028994 52.479479,-3.028888 52.479419,-3.028646 52.47933,-3.028348 52.479265,-3.028073 52.479214,-3.02755 52.479103,-3.027262 52.47905,-3.027073 52.479053,-3.026789 52.479067,-3.026518 52.47907,-3.026262 52.479053,-3.025955 52.479011,-3.025684 52.47899,-3.025529 52.478978,-3.025097 52.478974,-3.024128 52.47895,-3.023829 52.478945,-3.023721 52.478946,-3.023507 52.478953,-3.023167 52.478975,-3.022985 52.478992,-3.02261 52.479015,-3.021561 52.479059,-3.020843 52.479097,-3.020462 52.47911,-3.020266 52.479114,-3.020121 52.479106,-3.019963 52.47908,-3.019725 52.479036,-3.01932 52.478968,-3.018772 52.478867,-3.018526 52.478829,-3.018251 52.478814,-3.017985 52.478774,-3.017884 52.478751,-3.017605 52.478673,-3.017112 52.478514,-3.016597 52.478347,-3.016245 52.478223,-3.015841 52.478072,-3.015526 52.477969,-3.015358 52.477924,-3.014825 52.477794,-3.014565 52.47771,-3.014336 52.477613,-3.014103 52.4775,-3.013876 52.47739,-3.01364 52.477248,-3.013381 52.4771,-3.013161 52.476988,-3.013064 52.476926)",
    "LINESTRING(-3.008701 52.44449,-3.008806 52.444489,-3.008871 52.444477,-3.00893 52.444439,-3.008992 52.444367,-3.009041 52.444272,-3.009049 52.444253,-3.009086 52.444167,-3.009098 52.444151,-3.009134 52.444105,-3.009155 52.444079,-3.009207 52.444041,-3.009221 52.444037,-3.009296 52.444019,-3.009444 52.444016,-3.009517 52.444026,-3.009602 52.444065,-3.009694 52.444138,-3.009901 52.444328,-3.010028 52.444423,-3.010179 52.444535,-3.010234 52.444616,-3.010236 52.4447,-3.01023 52.444761,-3.010174 52.444835,-3.009969 52.445065,-3.009889 52.445178,-3.009855 52.445256,-3.009839 52.445333,-3.009853 52.445429,-3.009877 52.445498,-3.010006 52.445802,-3.010081 52.445987,-3.010137 52.446124,-3.010162 52.446161,-3.010229 52.446251,-3.010268 52.446287,-3.010294 52.446311,-3.010299 52.446313,-3.010328 52.446328,-3.010406 52.446368,-3.010632 52.446455,-3.010819 52.446526,-3.011086 52.446642,-3.011376 52.446774,-3.011647 52.446917,-3.011727 52.446963,-3.011901 52.447061,-3.012048 52.447139,-3.012145 52.447179,-3.012182 52.447194,-3.012277 52.447234,-3.01243 52.447287,-3.012658 52.447348,-3.012779 52.447373,-3.012893 52.447397,-3.012977 52.447417,-3.012991 52.447421,-3.013064 52.447438,-3.013156 52.447476,-3.013197 52.447503,-3.013264 52.447547,-3.013364 52.447637,-3.013408 52.447677,-3.013462 52.447734,-3.013562 52.447839,-3.013753 52.448031,-3.013818 52.44808,-3.013951 52.44818,-3.014102 52.448282,-3.014287 52.448381,-3.014469 52.448466,-3.014688 52.44857,-3.014982 52.448692,-3.015141 52.448747,-3.015189 52.448758,-3.015261 52.448775,-3.015477 52.448805,-3.015627 52.448814,-3.015683 52.448818,-3.015766 52.448816,-3.01584 52.448814,-3.015968 52.44881,-3.016098 52.448795,-3.016222 52.44878,-3.016235 52.448779,-3.016315 52.448758,-3.0164 52.448737,-3.016504 52.44871,-3.016553 52.448693,-3.016907 52.44857,-3.01692 52.448565,-3.017298 52.448432,-3.017657 52.448308,-3.018457 52.448028,-3.018735 52.447925,-3.019186 52.447718,-3.019297 52.447667,-3.019504 52.447573,-3.019691 52.447485,-3.020021 52.447306,-3.02034 52.447097,-3.020412 52.447042,-3.020528 52.446951,-3.020585 52.446897,-3.0207 52.446752,-3.02077 52.446625,-3.020854 52.446427,-3.020881 52.446319,-3.02093 52.446112,-3.020953 52.446002,-3.020959 52.445992,-3.02098 52.445958,-3.021035 52.445909,-3.021088 52.445881,-3.021142 52.445861,-3.021244 52.445841,-3.021316 52.445845,-3.021396 52.445857,-3.021469 52.445882,-3.021555 52.445938,-3.021636 52.446023,-3.02173 52.446141,-3.021988 52.446453,-3.022105 52.44658,-3.022157 52.446676,-3.022161 52.446683,-3.022195 52.446757,-3.022211 52.446841,-3.022242 52.447147,-3.022262 52.447328,-3.022289 52.4474,-3.022322 52.447442,-3.02234 52.447465,-3.022449 52.44753,-3.022566 52.447562,-3.022722 52.447581,-3.022849 52.447588,-3.023013 52.447578,-3.023241 52.447549,-3.02373 52.447493,-3.023942 52.447483)",
    "LINESTRING(-2.888846 52.559077,-2.888526 52.559015,-2.8881 52.558936,-2.887961 52.558894,-2.887797 52.55883,-2.887612 52.558738,-2.887359 52.558609,-2.887079 52.558467,-2.886905 52.558368,-2.886651 52.558193,-2.886535 52.55806,-2.886397 52.55782,-2.886355 52.557709,-2.886353 52.557593,-2.886389 52.557524,-2.886442 52.55749,-2.886469 52.557473,-2.886648 52.557357,-2.886851 52.557271,-2.887098 52.557196,-2.887359 52.557129,-2.887542 52.557082,-2.887792 52.557048,-2.88827 52.557015,-2.888439 52.556996,-2.888542 52.55699,-2.889071 52.556911,-2.889527 52.556827,-2.889674 52.556817,-2.889807 52.556843,-2.890283 52.55701,-2.890685 52.557196,-2.890908 52.557302,-2.891384 52.557487)",
    "LINESTRING(-3.001325 52.540011,-3.001671 52.540197,-3.002042 52.540409,-3.002262 52.540556,-3.002374 52.540609,-3.002493 52.54064,-3.002832 52.540729,-3.00343 52.540875,-3.00422 52.541066,-3.004733 52.54121,-3.004769 52.541221,-3.004913 52.54127,-3.005031 52.541311,-3.005047 52.541327,-3.005244 52.541459,-3.005596 52.541763,-3.006017 52.542175,-3.006452 52.542614,-3.006565 52.542732,-3.006843 52.542953,-3.006847 52.542957,-3.006998 52.543117,-3.007013 52.54314,-3.007085 52.543249,-3.007161 52.543314,-3.007272 52.54334,-3.007546 52.543391,-3.007698 52.543446,-3.007879 52.543533,-3.007883 52.543536,-3.008032 52.543626,-3.008038 52.54363,-3.008144 52.543722,-3.008188 52.543761,-3.008298 52.543868,-3.008317 52.543886,-3.008438 52.54404,-3.008465 52.544087,-3.008538 52.544214,-3.008612 52.544387,-3.008682 52.544563)",
    "LINESTRING(-3.011001 52.573086,-3.012121 52.572393,-3.01401 52.571244,-3.014085 52.571198,-3.014816 52.570754,-3.014951 52.570672,-3.015417 52.570455,-3.015886 52.570226,-3.016029 52.570153,-3.016323 52.569987,-3.016482 52.569904,-3.016585 52.569854,-3.016815 52.569735,-3.016974 52.56964,-3.017033 52.569586,-3.017063 52.569502,-3.017065 52.569402,-3.017007 52.569243,-3.016987 52.569186,-3.016885 52.568864,-3.016852 52.568756)",
    "LINESTRING(-3.015129 52.575841,-3.015019 52.575829,-3.014945 52.575821,-3.014885 52.575812,-3.014782 52.575786,-3.014678 52.57576,-3.014574 52.575734,-3.01447 52.575717,-3.014445 52.575713,-3.014381 52.5757,-3.0142 52.575673,-3.013943 52.575639,-3.013602 52.575603)",
    "LINESTRING(-3.019494 52.52701,-3.019262 52.527165,-3.01868 52.527548,-3.018282 52.52781,-3.01832 52.527865,-3.018397 52.528008,-3.018519 52.528205,-3.018731 52.528464,-3.018942 52.528642,-3.019077 52.52874,-3.019108 52.528766,-3.019393 52.529033,-3.019454 52.529105,-3.01956 52.529248,-3.019938 52.52977,-3.020112 52.529971,-3.020139 52.530025,-3.020088 52.530084,-3.020002 52.530183,-3.019925 52.530293)",
    "LINESTRING(-2.740076 52.23265,-2.740031 52.232641,-2.739944 52.232642,-2.739856 52.232643,-2.739753 52.232652,-2.739637 52.23268,-2.739535 52.232734,-2.739506 52.232762,-2.739406 52.232888,-2.739377 52.232906,-2.739333 52.232934,-2.73929 52.232952,-2.739217 52.232961,-2.739071 52.232971,-2.738968 52.232981)",
    "LINESTRING(-2.74881 52.228926,-2.748782 52.228995,-2.748772 52.229095,-2.748813 52.229324,-2.74882 52.229329,-2.7489 52.22938,-2.748952 52.229431,-2.748997 52.229574,-2.749054 52.229656,-2.74907 52.229679,-2.749201 52.229778)",
    "LINESTRING(-2.762382 52.225983,-2.7627 52.225925,-2.763153 52.225859,-2.763517 52.225776,-2.763912 52.225686)",
    "LINESTRING(-2.798257 52.212656,-2.798231 52.212824,-2.798217 52.212861,-2.798145 52.212924,-2.797348 52.213361,-2.79711 52.21347,-2.796976 52.213514,-2.796803 52.213559,-2.796593 52.213602,-2.796416 52.213631,-2.796137 52.213677,-2.795965 52.213701,-2.795794 52.213715,-2.795591 52.213721,-2.79543 52.21372,-2.795302 52.213724,-2.795172 52.213737,-2.795033 52.213758,-2.794911 52.213788,-2.794771 52.213826,-2.794724 52.213839,-2.794536 52.213891,-2.794189 52.213996,-2.793878 52.214113,-2.793834 52.21414,-2.79356 52.214357,-2.793459 52.214421,-2.793285 52.214494,-2.793038 52.214595,-2.792965 52.214613,-2.792921 52.214622,-2.792863 52.214632,-2.792819 52.214632,-2.792731 52.214615,-2.792443 52.214496)",
    "LINESTRING(-2.770867 52.164475,-2.770805 52.164343,-2.770749 52.164267,-2.770768 52.164207,-2.770905 52.164126,-2.771177 52.16399,-2.771345 52.163895,-2.771531 52.163784,-2.771669 52.163688,-2.77181 52.163566,-2.771884 52.163495,-2.771993 52.163371,-2.7721 52.163235,-2.772176 52.163118,-2.772345 52.163,-2.772474 52.162882,-2.772558 52.162848,-2.772658 52.162837,-2.77279 52.162871,-2.772898 52.163016,-2.773065 52.163285,-2.773134 52.163376,-2.773404 52.163732,-2.773459 52.163818,-2.77355 52.16408)",
    "LINESTRING(-2.781014 52.154968,-2.780805 52.154691,-2.780461 52.154235,-2.780358 52.154095,-2.780245 52.153973,-2.780063 52.153849,-2.77988 52.153794,-2.779824 52.153785,-2.779736 52.153772,-2.77963 52.153756,-2.779487 52.153738)",
    "LINESTRING(-2.870687 52.157811,-2.870528 52.157893,-2.870484 52.157902,-2.870124 52.157943,-2.869676 52.157994)",
    "LINESTRING(-2.791074 52.328059,-2.791045 52.32805,-2.791015 52.328041,-2.790911 52.32797,-2.790554 52.327667,-2.79042 52.327582,-2.790316 52.327516,-2.79031 52.327512,-2.790063 52.327293,-2.789899 52.327132,-2.789749 52.32698,-2.789689 52.326881,-2.789596 52.326639,-2.789536 52.326523,-2.78952 52.326482,-2.789505 52.326442,-2.789473 52.32629,-2.789516 52.326217,-2.789573 52.326154,-2.789629 52.326096,-2.789686 52.326042,-2.789909 52.325879,-2.789968 52.325835,-2.790036 52.325764,-2.790079 52.32571,-2.790135 52.325593,-2.790177 52.325449,-2.790223 52.325296)",
    "LINESTRING(-2.773759 52.312448,-2.77381 52.312252,-2.773812 52.312017,-2.773804 52.311886,-2.77377 52.311786,-2.773674 52.311637,-2.773624 52.311554,-2.773614 52.311493,-2.773592 52.311322,-2.773565 52.311134,-2.773535 52.311048,-2.773523 52.311013,-2.773473 52.310921,-2.773387 52.310827,-2.773263 52.31071,-2.773185 52.310631,-2.773152 52.310584,-2.773114 52.310494,-2.77309 52.310445,-2.773064 52.310392,-2.773028 52.310346,-2.772976 52.310304,-2.772771 52.310182,-2.77243 52.309952,-2.772317 52.309891,-2.772167 52.309832,-2.771975 52.309775,-2.77168 52.309706,-2.77148 52.309669,-2.77137 52.30967)",
    "LINESTRING(-2.785431 52.305367,-2.785715 52.305338,-2.785805 52.305312,-2.785869 52.305267,-2.785918 52.305217,-2.785966 52.305127,-2.786009 52.305053,-2.786069 52.304985,-2.786168 52.30492,-2.786481 52.30477,-2.786754 52.30465,-2.786958 52.304563,-2.787363 52.304407,-2.787459 52.304362,-2.787543 52.304308,-2.787585 52.304261,-2.787586 52.304219,-2.787557 52.304173,-2.787526 52.304166,-2.787396 52.304139,-2.786805 52.304046,-2.786647 52.304034,-2.786116 52.304031,-2.785881 52.304033,-2.785573 52.304044,-2.785383 52.304052,-2.785165 52.304042,-2.78493 52.304011,-2.784582 52.303947,-2.784168 52.303884,-2.784024 52.303864,-2.783814 52.303824,-2.783694 52.303791,-2.783578 52.303753,-2.78352 52.303729,-2.783488 52.303712,-2.783434 52.303684,-2.783335 52.303628,-2.783206 52.303549,-2.783037 52.303439,-2.782861 52.303342,-2.782699 52.303257,-2.782395 52.30311,-2.781973 52.302914,-2.781694 52.302819,-2.781396 52.30272,-2.781217 52.302671,-2.780941 52.302616,-2.780775 52.302591,-2.780146 52.3025,-2.779867 52.302464,-2.779539 52.302432,-2.779246 52.302421,-2.778979 52.302411,-2.778679 52.302375,-2.778164 52.302297,-2.7779 52.302263,-2.777551 52.30225,-2.777494 52.302248,-2.776549 52.302209,-2.776271 52.302202,-2.77608 52.302203,-2.775656 52.30226,-2.775393 52.302315,-2.775297 52.302361)",
    "LINESTRING(-2.768162 52.285915,-2.768448 52.285831,-2.768652 52.285764,-2.768716 52.285764,-2.768724 52.285766,-2.76878 52.28578,-2.768815 52.285808,-2.768911 52.285913,-2.769079 52.286078,-2.769143 52.286115,-2.76922 52.286138,-2.769578 52.286155,-2.769661 52.286164,-2.769734 52.286199,-2.769802 52.286251,-2.769847 52.286303)",
    "LINESTRING(-2.785332 52.291734,-2.785304 52.291218,-2.785283 52.29103,-2.785269 52.290905)",
    "LINESTRING(-2.810067 52.296994,-2.810306 52.296809,-2.810486 52.296658,-2.810606 52.296549,-2.810711 52.296415,-2.810832 52.296234,-2.810912 52.296108,-2.810927 52.296089,-2.81152 52.295364,-2.811823 52.29498,-2.812021 52.294804,-2.812244 52.294671,-2.812416 52.294582,-2.812839 52.294371,-2.813389 52.294105,-2.813715 52.293961,-2.814725 52.29352,-2.815498 52.293161,-2.815944 52.292958,-2.816497 52.292709,-2.816911 52.292523,-2.817309 52.292353,-2.817554 52.292232,-2.817807 52.29212,-2.818191 52.291952,-2.818516 52.291758,-2.818674 52.291653,-2.818796 52.291556,-2.819045 52.291358,-2.819169 52.291236,-2.819287 52.291088,-2.819404 52.290933,-2.819521 52.290805,-2.819616 52.290721,-2.819736 52.29064,-2.819933 52.290532,-2.820069 52.290466,-2.820477 52.290285,-2.820695 52.29019,-2.820963 52.290063,-2.821334 52.289891,-2.821566 52.289792,-2.821976 52.289633,-2.822547 52.2894,-2.822746 52.289344,-2.822912 52.289303,-2.823099 52.289258,-2.823253 52.289233,-2.823578 52.289197,-2.823976 52.289155,-2.824248 52.289124,-2.824589 52.289082,-2.824774 52.289047,-2.825019 52.289004,-2.825263 52.288949,-2.825477 52.288862,-2.825763 52.288707,-2.826032 52.288602,-2.826442 52.288464,-2.826752 52.288385,-2.82704 52.288331,-2.827267 52.288288,-2.827426 52.288252,-2.827609 52.28819,-2.827827 52.288111,-2.827996 52.288043,-2.828204 52.287909,-2.828342 52.287776,-2.828584 52.287612,-2.828936 52.287406,-2.829149 52.287291,-2.829567 52.287102,-2.82977 52.287014,-2.830091 52.286903,-2.830346 52.286808,-2.830576 52.286697,-2.830867 52.286455,-2.831063 52.286299,-2.831265 52.286057,-2.831309 52.285924,-2.831315 52.285778,-2.831316 52.285452,-2.831349 52.285112,-2.83138 52.284946,-2.831477 52.28477,-2.831655 52.284461,-2.831747 52.284338,-2.832017 52.284076,-2.832121 52.283978,-2.83233 52.283767,-2.832466 52.283576,-2.832612 52.283282,-2.83271 52.283022,-2.832765 52.282754,-2.832774 52.282516,-2.83276 52.28226,-2.832722 52.282057,-2.832663 52.28172,-2.832668 52.281617,-2.8327 52.281503,-2.832809 52.281175,-2.832862 52.280979,-2.832885 52.280839,-2.832872 52.280765,-2.832837 52.280582,-2.832766 52.280266,-2.832763 52.280223,-2.832772 52.280085,-2.832798 52.279996,-2.832863 52.279778,-2.832882 52.279713,-2.832876 52.279654,-2.832819 52.279514,-2.832641 52.279207,-2.832576 52.279063,-2.832564 52.279002,-2.832572 52.278926,-2.832579 52.278835)",
    "LINESTRING(-2.8096 52.313156,-2.809812 52.312762,-2.809934 52.312592,-2.810033 52.312491,-2.810125 52.312411,-2.81044 52.312106,-2.810489 52.312065,-2.810617 52.311959,-2.810653 52.31193,-2.810848 52.311783,-2.810927 52.311736,-2.811041 52.311684,-2.811097 52.311676,-2.811322 52.311644,-2.811699 52.311638,-2.811945 52.311586,-2.812366 52.311228,-2.812591 52.311079,-2.812836 52.310968,-2.81304 52.310901,-2.813225 52.310872,-2.813313 52.31088,-2.813416 52.310888,-2.813783 52.311141,-2.813911 52.311216,-2.814051 52.311194,-2.814099 52.311176,-2.814195 52.31114,-2.814227 52.311087,-2.814246 52.311025,-2.814254 52.310972,-2.814214 52.310739,-2.814205 52.31068,-2.81411 52.31053,-2.813621 52.310087,-2.813172 52.309559,-2.813157 52.309541,-2.813064 52.309299,-2.813077 52.309132,-2.813233 52.30893,-2.81437 52.308113,-2.814622 52.307931,-2.815506 52.307296,-2.815512 52.307292,-2.81569 52.307207,-2.81587 52.307147,-2.816298 52.307036,-2.816653 52.306942,-2.816811 52.306893,-2.817057 52.3068,-2.817143 52.30675,-2.817279 52.30664,-2.817435 52.306508,-2.817543 52.306409,-2.817628 52.306361,-2.8179 52.306176,-2.818153 52.306013,-2.818347 52.305877,-2.81847 52.305738,-2.818656 52.305494,-2.818772 52.305448)",
    "LINESTRING(-2.84966 52.261773,-2.849607 52.261747,-2.849544 52.261684,-2.849539 52.261679,-2.849462 52.26156,-2.849356 52.261536,-2.849261 52.261527,-2.849154 52.261515)",
    "LINESTRING(-2.871409 52.253843,-2.87124 52.25344,-2.871087 52.253117,-2.871026 52.252974,-2.870964 52.252804,-2.870824 52.2524,-2.870797 52.252328,-2.870748 52.252157,-2.870679 52.251973,-2.870634 52.251891,-2.870588 52.251822,-2.870409 52.2517,-2.870132 52.251533,-2.869956 52.251435,-2.869871 52.251388,-2.869749 52.251338,-2.869334 52.251179,-2.868741 52.250899,-2.868417 52.250783,-2.868236 52.250729,-2.868045 52.250672,-2.866816 52.250353)",
    "LINESTRING(-2.866721 52.282142,-2.866766 52.282095,-2.866835 52.282034,-2.866896 52.281948,-2.866942 52.281807,-2.866984 52.281567,-2.866991 52.281348,-2.867006 52.281279,-2.867061 52.281207,-2.867135 52.281129,-2.867236 52.281049,-2.867331 52.280989,-2.867449 52.280938,-2.867612 52.280873,-2.868169 52.280722,-2.868635 52.280548,-2.868836 52.280505,-2.868971 52.2805,-2.869074 52.280499,-2.869279 52.280507,-2.869416 52.2805,-2.869557 52.280482,-2.869675 52.280445,-2.869778 52.280377,-2.869861 52.280285,-2.869898 52.280191,-2.869895 52.280142,-2.869892 52.280068,-2.869854 52.279936,-2.869807 52.279858,-2.869681 52.279711,-2.869446 52.279519,-2.869358 52.279459,-2.869315 52.279431,-2.869233 52.279397,-2.869029 52.279331,-2.868575 52.279258,-2.8683 52.279184,-2.868182 52.279139,-2.867982 52.279053,-2.867644 52.278872,-2.867516 52.278822,-2.867511 52.27882,-2.867427 52.278795,-2.867315 52.278778,-2.867175 52.278764,-2.867006 52.27877,-2.866844 52.278795,-2.866732 52.278819,-2.866155 52.278948,-2.865845 52.279016,-2.865695 52.279031,-2.865584 52.279027,-2.865529 52.279025,-2.865376 52.279001,-2.865206 52.278966,-2.865049 52.278909,-2.864961 52.278851,-2.864926 52.278799,-2.864926 52.278784,-2.864925 52.278747,-2.864945 52.278685,-2.864986 52.278636,-2.865202 52.278483,-2.865357 52.278359,-2.865431 52.278293,-2.865515 52.278218,-2.865547 52.278181,-2.865644 52.278066,-2.865765 52.277915,-2.865774 52.277902,-2.865846 52.277793,-2.865912 52.277678,-2.86599 52.277542,-2.86609 52.277401,-2.866137 52.277336,-2.86626 52.2772,-2.866323 52.277128,-2.866543 52.276946,-2.866747 52.276785,-2.866852 52.276704,-2.866996 52.276593,-2.867047 52.27655,-2.867079 52.276496,-2.867102 52.27644,-2.86713 52.276372,-2.86713 52.276355,-2.867129 52.276333,-2.867129 52.276317,-2.867122 52.276257,-2.867119 52.276239,-2.867111 52.276195,-2.867043 52.276054,-2.867001 52.275938,-2.866955 52.275829,-2.866893 52.275746,-2.866827 52.275671,-2.866762 52.275632,-2.866691 52.275578,-2.866513 52.275507,-2.866306 52.275444,-2.86601 52.275385,-2.865752 52.275365,-2.865458 52.275371,-2.86523 52.275395,-2.865015 52.275435,-2.864873 52.275467,-2.864636 52.275542,-2.864401 52.275629,-2.864239 52.275701,-2.863556 52.276004,-2.863334 52.276119,-2.863074 52.276293,-2.863031 52.276303,-2.862937 52.276294,-2.862877 52.276262,-2.862847 52.276227,-2.862827 52.276156,-2.862827 52.276075,-2.862831 52.276051,-2.86284 52.275998,-2.862844 52.275975,-2.862864 52.275936,-2.862937 52.275793,-2.86301 52.275653,-2.863091 52.275495,-2.863188 52.275311,-2.863291 52.275136,-2.863322 52.275083,-2.863481 52.274831,-2.863709 52.274511,-2.863937 52.274198,-2.863983 52.274135,-2.864108 52.273941,-2.864208 52.27378,-2.864262 52.273664,-2.864344 52.273524,-2.864377 52.273449,-2.864455 52.273267,-2.864541 52.273114,-2.864604 52.272967,-2.86466 52.272888,-2.864761 52.272799,-2.864874 52.272701,-2.865244 52.272223,-2.865303 52.272127,-2.865359 52.272017,-2.86538 52.271943,-2.865378 52.271853,-2.865358 52.271782,-2.865321 52.271713,-2.865314 52.2717,-2.865286 52.271658,-2.865212 52.271578,-2.865112 52.271488,-2.864864 52.271324,-2.864508 52.271098,-2.864143 52.270876,-2.863871 52.270713,-2.86357 52.270537,-2.863198 52.270336,-2.862901 52.270192,-2.862665 52.270082,-2.862462 52.269977,-2.862355 52.269914,-2.862143 52.269791,-2.861777 52.269578,-2.861671 52.269522,-2.861598 52.269466,-2.861568 52.269412,-2.861557 52.269298,-2.861551 52.269222)",
    "LINESTRING(-2.870042 52.273476,-2.870124 52.273451,-2.870412 52.273356,-2.870614 52.273316,-2.870828 52.273282,-2.871244 52.27326,-2.871744 52.273239,-2.872129 52.273221,-2.87277 52.273192,-2.87302 52.273178,-2.873339 52.273154,-2.873444 52.273149,-2.873634 52.27313,-2.873663 52.27312,-2.873692 52.273102,-2.873773 52.273038,-2.873892 52.272891,-2.873901 52.272881,-2.873987 52.272815,-2.87408 52.272782,-2.874156 52.272771,-2.874329 52.272746,-2.874551 52.272709,-2.874662 52.272677,-2.874758 52.272637,-2.874892 52.272595,-2.874999 52.272543,-2.875313 52.27243,-2.875555 52.27235,-2.875835 52.272267,-2.876071 52.272199,-2.876178 52.272148,-2.876381 52.272039,-2.876555 52.271924,-2.876722 52.271792,-2.876875 52.271663,-2.87701 52.271536,-2.877145 52.271414,-2.877244 52.271326,-2.877368 52.271244,-2.877559 52.271134,-2.877754 52.271029,-2.877916 52.27095,-2.878073 52.270895,-2.878135 52.270884,-2.878202 52.270885,-2.878258 52.270903,-2.8783 52.27094,-2.878464 52.271092,-2.878685 52.271279,-2.878926 52.271466,-2.879012 52.271546,-2.879085 52.271657,-2.879158 52.271791,-2.879168 52.271856,-2.879157 52.272034,-2.879174 52.272151,-2.879231 52.272368,-2.879301 52.272639,-2.879357 52.272808,-2.879362 52.272916,-2.879353 52.273034,-2.87934 52.273124,-2.879347 52.273212,-2.879365 52.273387,-2.87935 52.2735,-2.879281 52.273704,-2.879202 52.273859,-2.87915 52.273902,-2.879067 52.274004,-2.879003 52.274159,-2.878877 52.27432,-2.878794 52.274425,-2.87864 52.274567)",
    "LINESTRING(-2.866721 52.282142,-2.866546 52.282289,-2.866394 52.282429,-2.866309 52.282508,-2.86607 52.282714,-2.865899 52.282839,-2.865598 52.283033,-2.865402 52.283143,-2.865272 52.283216,-2.864748 52.28343,-2.864323 52.283589,-2.86384 52.283766,-2.863651 52.28385,-2.863464 52.283952,-2.863198 52.284137,-2.86295 52.284316,-2.862834 52.284492)",
    "LINESTRING(-2.845194 52.369086,-2.845265 52.369109,-2.845329 52.369154,-2.845454 52.369264,-2.845608 52.369421,-2.845968 52.369803,-2.846306 52.370142,-2.846346 52.370182,-2.846352 52.370188,-2.847293 52.371183,-2.847719 52.371643,-2.847908 52.371843,-2.849636 52.373671)",
    "LINESTRING(-2.772262 52.351621,-2.772146 52.351676,-2.772073 52.351712,-2.771812 52.351912,-2.771522 52.35213,-2.771022 52.352546,-2.770992 52.352572,-2.770365 52.353117,-2.770282 52.353181,-2.770046 52.353362,-2.769878 52.353489,-2.769556 52.353646,-2.769406 52.353699,-2.76872 52.353919,-2.768529 52.353947,-2.768192 52.353949,-2.767383 52.353892,-2.76723 52.353883,-2.766907 52.353874,-2.766437 52.353888,-2.766083 52.353923,-2.765772 52.353968,-2.765589 52.354014,-2.765519 52.354032,-2.765474 52.354043,-2.765296 52.354115,-2.765148 52.354231,-2.76491 52.3544,-2.764838 52.354448,-2.764679 52.354533,-2.764424 52.354632,-2.764211 52.354685,-2.763933 52.354741,-2.763889 52.35475,-2.763596 52.354806,-2.763321 52.354844,-2.763259 52.354853,-2.763235 52.354852,-2.763095 52.35485,-2.763014 52.354846,-2.762868 52.354839,-2.762565 52.35481,-2.762292 52.354785,-2.762104 52.354779,-2.761605 52.354788,-2.761516 52.354793,-2.761476 52.354795,-2.761285 52.354806,-2.761247 52.354808,-2.760687 52.354846,-2.760029 52.354864,-2.760015 52.354865,-2.759721 52.354886,-2.759369 52.354926,-2.759053 52.354955,-2.758903 52.354953,-2.758735 52.35493,-2.758489 52.354875,-2.758337 52.354841,-2.758063 52.354778,-2.757839 52.354704,-2.757629 52.354657,-2.757158 52.35459,-2.756717 52.354517,-2.756277 52.354423,-2.755841 52.354312,-2.755313 52.354172,-2.754894 52.354049,-2.754619 52.353955,-2.754135 52.353786,-2.753547 52.353566,-2.753298 52.353465,-2.752793 52.353258,-2.752668 52.353175,-2.752563 52.353066,-2.752496 52.352931,-2.752453 52.352791,-2.752438 52.352626,-2.752416 52.352374,-2.752377 52.352138,-2.752361 52.35204,-2.752337 52.351869)",
    "LINESTRING(-2.773655 52.354022,-2.773551 52.353995,-2.773507 52.353978,-2.773209 52.353728,-2.773149 52.353665,-2.773117 52.353504,-2.773065 52.353162,-2.773034 52.352965,-2.772972 52.35274,-2.772923 52.352611,-2.772886 52.352534,-2.772743 52.352239,-2.772652 52.352068,-2.772561 52.351925,-2.772486 52.351836,-2.772411 52.351764,-2.772262 52.351621)",
    "LINESTRING(-2.753656 52.360846,-2.753728 52.360934,-2.75384 52.360962,-2.753998 52.360946,-2.754437 52.360861,-2.754844 52.360793,-2.755044 52.36079,-2.755406 52.360811,-2.755894 52.360855,-2.756264 52.360871,-2.756746 52.360857,-2.757133 52.360818,-2.757461 52.360766,-2.757826 52.360684,-2.758227 52.360567,-2.758449 52.360533,-2.758593 52.36053,-2.758726 52.360542,-2.758943 52.360557,-2.759457 52.36057,-2.759816 52.360576,-2.760312 52.360553,-2.761192 52.360483,-2.761344 52.360478,-2.761509 52.360472,-2.761826 52.360457,-2.762371 52.360427,-2.762703 52.360414,-2.762894 52.360411,-2.763043 52.360388,-2.763479 52.360312,-2.763729 52.360296,-2.76429 52.36028,-2.764477 52.36026,-2.764917 52.360214,-2.765116 52.360202,-2.765425 52.360215,-2.765639 52.360213,-2.765865 52.360194,-2.76605 52.360171,-2.766263 52.36013,-2.766457 52.360088,-2.76694 52.359981,-2.76706 52.359964,-2.767268 52.359952,-2.768163 52.359913,-2.768729 52.359888,-2.769041 52.359891,-2.769305 52.359905,-2.769823 52.359945,-2.770114 52.35996,-2.770396 52.35995,-2.770967 52.359901,-2.771202 52.359881,-2.77151 52.359843,-2.771908 52.359735,-2.772174 52.359668,-2.772387 52.35964,-2.77246 52.35963,-2.772868 52.359611,-2.773179 52.359572,-2.773429 52.359575,-2.773575 52.359585,-2.773773 52.359599,-2.773949 52.359605,-2.773984 52.359603,-2.774069 52.359597,-2.774254 52.359562,-2.774815 52.359409,-2.775031 52.359354,-2.775245 52.35932,-2.775579 52.359291,-2.775698 52.35927,-2.775772 52.359256,-2.775799 52.359252,-2.776123 52.359169,-2.776302 52.359162,-2.776435 52.359179,-2.776568 52.359227,-2.776772 52.35931,-2.776943 52.359359,-2.777208 52.359402,-2.777429 52.359408,-2.777672 52.359372,-2.778029 52.359313,-2.778447 52.35922,-2.77871 52.359146,-2.779052 52.359031,-2.77954 52.358873,-2.779776 52.358807,-2.780075 52.358754,-2.780289 52.358728,-2.780606 52.358709,-2.781231 52.358698,-2.781563 52.358681,-2.781774 52.358689,-2.7818 52.358693,-2.782251 52.35876,-2.782572 52.358786,-2.782757 52.358799,-2.782907 52.358797,-2.783039 52.358776,-2.783141 52.358741,-2.783219 52.358672,-2.783336 52.358477,-2.783339 52.358472,-2.783396 52.358373,-2.783511 52.358242,-2.78358 52.35819,-2.78379 52.358072,-2.784078 52.357953,-2.784352 52.357823,-2.784454 52.357751,-2.784543 52.357628,-2.784625 52.357492,-2.784723 52.357393,-2.784828 52.357338,-2.785047 52.357268,-2.785404 52.357212,-2.785891 52.357142,-2.78619 52.357119,-2.786454 52.357117,-2.786613 52.357129,-2.786808 52.357178,-2.787204 52.357335,-2.787725 52.357596,-2.787844 52.357651,-2.787959 52.357686,-2.788219 52.357751,-2.788682 52.357899,-2.789149 52.358066,-2.789808 52.358293,-2.790064 52.358316,-2.790349 52.358303,-2.790691 52.358225,-2.790901 52.358168,-2.791044 52.358104,-2.791144 52.358062,-2.791241 52.357942,-2.791255 52.357924,-2.791346 52.357721,-2.791407 52.357521,-2.791455 52.357414,-2.79158 52.357176,-2.791734 52.356947,-2.791818 52.356849,-2.791869 52.35679,-2.791974 52.356735,-2.792074 52.356716,-2.792153 52.356721,-2.792292 52.356756,-2.79254 52.356832,-2.792669 52.356851,-2.79276 52.356852,-2.792863 52.356848,-2.792998 52.356827,-2.793086 52.356814,-2.793267 52.356791,-2.793417 52.356786,-2.793567 52.356803,-2.793967 52.356842,-2.794114 52.35685,-2.794284 52.356833,-2.794483 52.356768,-2.794772 52.356662,-2.794939 52.356645,-2.795065 52.356662,-2.795174 52.356692,-2.795346 52.356779,-2.795737 52.356976,-2.795915 52.357054,-2.796172 52.357158,-2.79635 52.357236,-2.796486 52.3573,-2.796602 52.357365,-2.796807 52.357481,-2.796919 52.357523,-2.797055 52.357551,-2.797169 52.357565,-2.797284 52.357564,-2.797442 52.357556,-2.797624 52.357529,-2.7978 52.357496,-2.797975 52.357444,-2.798129 52.357373,-2.79824 52.357318,-2.798353 52.357231,-2.798466 52.357144,-2.798585 52.357059,-2.798716 52.356999,-2.79874 52.356991,-2.798815 52.356966,-2.798918 52.35696,-2.799035 52.35697,-2.799433 52.357046,-2.799616 52.357068,-2.799801 52.357071,-2.799918 52.357055,-2.80017 52.357009,-2.800416 52.356975,-2.800521 52.35694,-2.800654 52.356844)",
    "LINESTRING(-2.818355 52.347202,-2.818399 52.347293,-2.818443 52.347384,-2.818512 52.347477,-2.818663 52.3476,-2.818888 52.347728,-2.819106 52.347835,-2.819235 52.347893,-2.819377 52.347931,-2.819537 52.347956,-2.819804 52.347997,-2.820024 52.348028,-2.820145 52.348056,-2.820331 52.348128,-2.820539 52.348206,-2.82071 52.348258,-2.820909 52.348302,-2.820981 52.348318,-2.821029 52.348352,-2.821031 52.348388,-2.821011 52.348437,-2.820967 52.34846,-2.820826 52.348507,-2.820756 52.348526,-2.82037 52.348612,-2.820269 52.348639,-2.820204 52.34866,-2.819667 52.348853,-2.819451 52.34892,-2.819269 52.348968,-2.819144 52.349017,-2.818939 52.349106,-2.81881 52.349162,-2.818689 52.349193,-2.818372 52.349238,-2.818072 52.349298,-2.817924 52.34933,-2.817707 52.349379,-2.817626 52.349417,-2.817488 52.34949,-2.817383 52.349555,-2.817306 52.349621,-2.817254 52.349654,-2.817208 52.349686,-2.817105 52.34975,-2.817061 52.349773,-2.816975 52.349802,-2.816725 52.349885,-2.816603 52.349932,-2.816494 52.349974,-2.816223 52.350076,-2.816136 52.350122,-2.815942 52.350213,-2.815839 52.350255,-2.815772 52.350275,-2.815636 52.35032,-2.815461 52.350359,-2.815168 52.350407,-2.815007 52.350429,-2.814702 52.35048,-2.814474 52.350521,-2.814312 52.35054,-2.813958 52.350566,-2.813574 52.350584,-2.813074 52.350598,-2.812936 52.350596)",
    "LINESTRING(-2.817427 52.368525,-2.817397 52.368498,-2.817317 52.368426,-2.817133 52.368212,-2.816979 52.368059,-2.816899 52.367997,-2.816833 52.367974,-2.816774 52.367967,-2.816692 52.367984,-2.816435 52.368082,-2.816345 52.368116,-2.816226 52.368194,-2.816155 52.368223,-2.816103 52.368243,-2.816033 52.368271,-2.816012 52.368352,-2.816011 52.368378,-2.816065 52.368732,-2.816082 52.368876,-2.8161 52.369074,-2.816104 52.369262,-2.816104 52.369271)",
    "LINESTRING(-2.765419 52.340898,-2.765378 52.342352,-2.765365 52.342451,-2.764943 52.342966,-2.764864 52.343063,-2.764849 52.343129,-2.765031 52.343412,-2.765042 52.343442,-2.765041 52.343497,-2.764983 52.343558,-2.76489 52.343578,-2.764778 52.343581,-2.764724 52.343578,-2.764486 52.343576,-2.764254 52.34357,-2.764096 52.343593,-2.763938 52.343628,-2.763737 52.343721,-2.763547 52.343811,-2.763396 52.343864,-2.763203 52.343899,-2.763004 52.343974,-2.762803 52.344067,-2.762672 52.344127,-2.762663 52.344128,-2.762564 52.344139,-2.762487 52.344123,-2.762484 52.344121,-2.762422 52.344075,-2.762287 52.343936,-2.761979 52.343615,-2.761814 52.343418,-2.761739 52.343311,-2.761583 52.342988,-2.761496 52.342809,-2.761405 52.342665,-2.76136 52.342621,-2.76133 52.342585,-2.761239 52.342546)",
    "LINESTRING(-2.737783 52.341558,-2.737981 52.341618,-2.738154 52.341638,-2.738366 52.341621,-2.738571 52.341608,-2.738747 52.341607,-2.738976 52.341633,-2.739153 52.341677,-2.739309 52.341678,-2.739566 52.341635,-2.73983 52.341584,-2.740346 52.341505,-2.740486 52.341483,-2.740723 52.341448,-2.740952 52.341432,-2.741154 52.341443,-2.741561 52.341497,-2.741619 52.341505,-2.741772 52.341515,-2.741874 52.341495,-2.741986 52.341474,-2.742249 52.341397,-2.742395 52.341374,-2.742703 52.341356,-2.742976 52.341335,-2.743242 52.341282,-2.743443 52.341211,-2.743662 52.341118,-2.743995 52.341022,-2.744255 52.340947,-2.744517 52.340827,-2.744621 52.340743,-2.744632 52.340675,-2.744546 52.340604,-2.744345 52.340529,-2.744095 52.340491,-2.743921 52.340447,-2.743828 52.340356,-2.743807 52.340312,-2.743809 52.340236,-2.743912 52.340074,-2.744027 52.339961,-2.744239 52.339814,-2.744414 52.339725,-2.744788 52.339635,-2.745551 52.339441,-2.745769 52.339357,-2.745918 52.339264,-2.746016 52.339167,-2.746142 52.33899,-2.746219 52.338838,-2.746281 52.338717)",
    "LINESTRING(-2.791074 52.328059,-2.791045 52.32805,-2.791015 52.328041,-2.790911 52.32797,-2.790554 52.327667,-2.79042 52.327582,-2.790316 52.327516,-2.79031 52.327512,-2.790063 52.327293,-2.789899 52.327132,-2.789749 52.32698,-2.789689 52.326881,-2.789596 52.326639,-2.789536 52.326523,-2.78952 52.326482,-2.789505 52.326442,-2.789473 52.32629,-2.789516 52.326217,-2.789573 52.326154,-2.789629 52.326096,-2.789686 52.326042,-2.789909 52.325879,-2.789968 52.325835,-2.790036 52.325764,-2.790079 52.32571,-2.790135 52.325593,-2.790177 52.325449,-2.790223 52.325296)",
    "LINESTRING(-2.876391 52.35697,-2.876449 52.357044,-2.876479 52.357079,-2.876525 52.357196,-2.876726 52.357707,-2.876727 52.357743,-2.876669 52.357797,-2.87664 52.357815,-2.876509 52.357861,-2.876421 52.35788)",
    "LINESTRING(-2.85556 52.396517,-2.855534 52.396022,-2.855521 52.395526,-2.855513 52.395292,-2.855499 52.395243,-2.855499 52.395241,-2.855441 52.395187,-2.855286 52.395049,-2.855032 52.394824,-2.85445 52.394312,-2.853884 52.393808,-2.853774 52.393713,-2.853653 52.393622,-2.853425 52.393464,-2.853104 52.393254,-2.852847 52.393086,-2.852393 52.392779,-2.852311 52.392723,-2.8519 52.392452,-2.851752 52.392358,-2.851734 52.392346,-2.851695 52.392304,-2.851677 52.392247,-2.851691 52.392204,-2.851704 52.392193,-2.851712 52.392185,-2.851729 52.39217,-2.851751 52.392161,-2.851795 52.392143,-2.853022 52.391795,-2.853067 52.391781,-2.853157 52.391754,-2.853208 52.391727,-2.853232 52.391698,-2.853238 52.391659,-2.853226 52.391609,-2.853207 52.391558,-2.852786 52.390888,-2.852564 52.390535,-2.852295 52.390097,-2.851979 52.389588,-2.85188 52.389439,-2.851585 52.389,-2.851343 52.388633,-2.851011 52.388114,-2.850987 52.388076,-2.850866 52.38789,-2.850855 52.387881,-2.85083 52.387861,-2.850792 52.387854,-2.850735 52.387864,-2.850576 52.387911,-2.850467 52.387949,-2.85043 52.387961,-2.850363 52.387983,-2.850303 52.388025,-2.850294 52.388032,-2.850198 52.3881,-2.850123 52.388144,-2.850047 52.388176,-2.849561 52.38835,-2.849105 52.388508,-2.84873 52.388639,-2.848151 52.388841,-2.848126 52.38885,-2.848093 52.388861,-2.848036 52.388869,-2.847961 52.388866,-2.847881 52.388852,-2.8478 52.388826,-2.847373 52.388665,-2.846573 52.388365,-2.845732 52.388047,-2.845134 52.387819,-2.844629 52.387632,-2.844577 52.387619,-2.844511 52.387615,-2.844423 52.387617,-2.844304 52.387625,-2.844172 52.387633,-2.844031 52.38765,-2.843693 52.387697,-2.843032 52.387787,-2.842679 52.387842,-2.842089 52.387939,-2.841699 52.388,-2.841066 52.388111,-2.840644 52.388189,-2.840601 52.388197,-2.840249 52.388268,-2.840205 52.388278,-2.839876 52.388349,-2.839457 52.388438,-2.839302 52.388471,-2.839156 52.388507,-2.839064 52.388525,-2.838993 52.388536,-2.838901 52.388548,-2.83878 52.388561,-2.838608 52.388572,-2.838373 52.388602,-2.837898 52.38866,-2.837343 52.388751,-2.83692 52.388814,-2.836688 52.388836,-2.836525 52.388853,-2.836407 52.38886,-2.836264 52.388869,-2.836097 52.388875,-2.835884 52.388887,-2.835807 52.388894,-2.835725 52.388908,-2.835593 52.388929,-2.835501 52.388944,-2.835384 52.388961,-2.835305 52.388972,-2.835256 52.388979,-2.835115 52.388998,-2.834892 52.389042,-2.834639 52.38909,-2.834337 52.389144,-2.834152 52.389174,-2.834038 52.38919,-2.833914 52.389202,-2.833758 52.38921,-2.833503 52.389214,-2.833378 52.389219,-2.833226 52.389232,-2.832982 52.389261,-2.832221 52.389361,-2.831966 52.389395,-2.831785 52.389419,-2.831648 52.389439,-2.831467 52.389466,-2.83136 52.389482,-2.831282 52.389492,-2.831212 52.389498,-2.83115 52.389501,-2.831069 52.389498,-2.831008 52.389485,-2.830965 52.389454,-2.830933 52.389431,-2.830912 52.389387,-2.830918 52.389326,-2.830943 52.389246,-2.83098 52.389159,-2.831 52.389088,-2.83101 52.389013,-2.831014 52.38894,-2.831011 52.388855,-2.831001 52.388759,-2.830979 52.388633,-2.830951 52.388515,-2.830863 52.388224,-2.830836 52.388137,-2.830805 52.387982,-2.830787 52.387894,-2.830775 52.387745,-2.830763 52.387601,-2.830759 52.38756,-2.830742 52.387533,-2.830712 52.387509,-2.830673 52.387493,-2.830608 52.387477,-2.830474 52.387467,-2.829886 52.387431,-2.829247 52.387393,-2.828714 52.387362,-2.828589 52.387356,-2.828479 52.387342,-2.828398 52.387328,-2.828291 52.387296,-2.828268 52.387285,-2.828239 52.387272,-2.828188 52.387234,-2.828129 52.3872,-2.828118 52.387197,-2.828062 52.387177,-2.827989 52.387162,-2.827887 52.387148,-2.827766 52.387134,-2.827541 52.387099,-2.827199 52.387048,-2.826926 52.387011,-2.826678 52.386979,-2.826484 52.386962,-2.826128 52.386937,-2.825835 52.386921,-2.825578 52.386909,-2.825252 52.386883,-2.824822 52.386841,-2.82427 52.386796,-2.823937 52.386775,-2.823542 52.386749,-2.823387 52.386739,-2.823187 52.38673,-2.822928 52.386723,-2.822737 52.386725,-2.822636 52.386727,-2.822504 52.386737,-2.82239 52.386753,-2.822291 52.386764,-2.822187 52.386771,-2.822071 52.38677,-2.821698 52.386754,-2.821006 52.386716,-2.820424 52.386678,-2.820017 52.386642,-2.819853 52.386632,-2.819682 52.386628,-2.819589 52.386628,-2.819231 52.386643,-2.818809 52.386659,-2.818609 52.386667,-2.818181 52.386684,-2.817766 52.386708,-2.817455 52.386728,-2.817396 52.386731,-2.817365 52.386732,-2.817012 52.386745,-2.816911 52.386753,-2.816895 52.386757,-2.816813 52.38678,-2.81671 52.386814)",
    "LINESTRING(-2.749888 52.382861,-2.751339 52.382845,-2.751707 52.382817,-2.751819 52.382778,-2.75187 52.38276,-2.75201 52.382642,-2.752104 52.382552,-2.752124 52.382532,-2.752165 52.382507,-2.752235 52.382465,-2.75224 52.382462,-2.752326 52.382443,-2.75249 52.38246,-2.752823 52.382513,-2.753021 52.38252,-2.753173 52.382509,-2.753231 52.382491,-2.75326 52.382473,-2.753274 52.382455,-2.753361 52.382337,-2.753447 52.38222,-2.753542 52.382158)",
    "LINESTRING(-2.849636 52.373671,-2.849509 52.373732,-2.849432 52.373769,-2.849363 52.373797,-2.848991 52.373928,-2.848774 52.374004,-2.848314 52.374154,-2.848093 52.374223,-2.847627 52.37434,-2.847196 52.374451,-2.846893 52.374547,-2.846484 52.374688,-2.846072 52.374839,-2.845713 52.374983,-2.845325 52.375139,-2.844837 52.375341,-2.844717 52.375383,-2.844507 52.375452,-2.843824 52.375678,-2.843494 52.375781,-2.8433 52.375826,-2.843033 52.375873,-2.842747 52.37592,-2.842341 52.375982,-2.84211 52.376015,-2.841836 52.376063,-2.841536 52.376121,-2.841258 52.37618,-2.841027 52.376233,-2.840883 52.376266,-2.840791 52.376285,-2.840711 52.376296,-2.840647 52.376305,-2.840597 52.376303,-2.840554 52.376288,-2.840532 52.376278,-2.840492 52.376261,-2.840432 52.376221,-2.840385 52.376186,-2.840337 52.376165,-2.84028 52.376149,-2.840223 52.376136,-2.840149 52.376134,-2.840088 52.376141,-2.840085 52.376141,-2.839997 52.376156,-2.839849 52.376181,-2.839693 52.376196,-2.839501 52.376215,-2.839384 52.376221,-2.839316 52.376223,-2.839233 52.376212,-2.839133 52.376189,-2.838954 52.376148,-2.838297 52.375973,-2.837891 52.375872,-2.837768 52.375854,-2.837658 52.375844,-2.837547 52.375842,-2.83745 52.375842,-2.837346 52.375848,-2.83726 52.37586,-2.837161 52.375877,-2.837075 52.375903,-2.837011 52.375921,-2.836956 52.375931,-2.836916 52.37593,-2.836866 52.375921,-2.83682 52.375905,-2.83677 52.375886,-2.836633 52.375832,-2.836527 52.375789,-2.836448 52.37576,-2.836297 52.37572,-2.835957 52.375646,-2.835684 52.375592,-2.835382 52.375539,-2.835101 52.375498,-2.835051 52.375491,-2.834666 52.375443,-2.834309 52.375408,-2.834102 52.37539,-2.833896 52.375379,-2.833767 52.375379,-2.833655 52.375384,-2.833547 52.3754,-2.833465 52.375423,-2.833372 52.375473,-2.83333 52.375504,-2.833298 52.375527,-2.833246 52.375597,-2.833219 52.375648,-2.833215 52.375691,-2.83321 52.375722,-2.833227 52.375763,-2.833265 52.375818,-2.833342 52.375935,-2.833401 52.376015,-2.833472 52.376113,-2.833505 52.376174,-2.833506 52.376229,-2.8335 52.376258,-2.833497 52.376272,-2.833459 52.376299,-2.833439 52.376303,-2.833401 52.37631,-2.833357 52.376309,-2.833354 52.376308,-2.833312 52.376295,-2.833241 52.376231,-2.833152 52.376155,-2.833073 52.376082,-2.833008 52.376025,-2.832937 52.375973,-2.832878 52.375929,-2.8328 52.375893,-2.832717 52.375865,-2.832619 52.375831,-2.832523 52.3758,-2.832414 52.375772,-2.832111 52.375704,-2.831984 52.37568,-2.831765 52.375635,-2.831397 52.375571,-2.831087 52.375529,-2.830752 52.375481,-2.830563 52.375455,-2.830471 52.375449,-2.830324 52.375441,-2.830123 52.375437,-2.829918 52.375431,-2.829842 52.375423,-2.829737 52.375408,-2.829284 52.37535,-2.828579 52.375259,-2.827637 52.375138,-2.826761 52.375024,-2.826152 52.374942,-2.825627 52.374876,-2.825152 52.374818,-2.824631 52.374752,-2.82419 52.374692,-2.823612 52.374617,-2.822892 52.374522,-2.822234 52.374436,-2.819541 52.374073)",
    "LINESTRING(-2.812104 52.378289,-2.812462 52.378218,-2.812687 52.378173,-2.812849 52.37812,-2.812995 52.378065,-2.813084 52.378011,-2.813152 52.377925,-2.813193 52.377827,-2.813234 52.377705,-2.813288 52.377616,-2.813365 52.377529,-2.813436 52.377478,-2.813525 52.377435,-2.813627 52.377399,-2.813696 52.377367,-2.813739 52.377308,-2.813784 52.377238,-2.813816 52.37715,-2.813855 52.376997,-2.813891 52.376849,-2.813926 52.376782,-2.813993 52.37674,-2.814096 52.376715,-2.814202 52.376708,-2.814323 52.3767,-2.814413 52.376688,-2.814475 52.376669,-2.814553 52.376617,-2.814678 52.376511,-2.814971 52.376268,-2.815065 52.376187)",
    "LINESTRING(-2.829632 52.505566,-2.82985 52.505388,-2.830133 52.505157,-2.83044 52.504943,-2.831098 52.50454)",
    "LINESTRING(-2.857778 52.498206,-2.857762 52.498348,-2.857727 52.498658,-2.857706 52.499173,-2.85764 52.499648,-2.857575 52.5001)",
    "LINESTRING(-2.779723 52.462749,-2.779545 52.462676,-2.779526 52.462668,-2.779096 52.462511,-2.778881 52.462447,-2.778792 52.462417,-2.778607 52.462395,-2.778255 52.462332,-2.778078 52.462279,-2.777901 52.462215,-2.777793 52.462162,-2.777596 52.462038,-2.777408 52.461908,-2.777232 52.461832,-2.777084 52.461738,-2.776848 52.461632,-2.776494 52.461485,-2.776347 52.461427,-2.77626 52.461391,-2.776088 52.46132,-2.775911 52.46125,-2.775811 52.461218,-2.775773 52.461202,-2.77556 52.461128,-2.775442 52.461087,-2.775236 52.461023,-2.775099 52.460989,-2.774987 52.460989)",
    "LINESTRING(-2.748927 52.460261,-2.748895 52.460247,-2.748855 52.460247,-2.748774 52.460285,-2.748667 52.460342,-2.748423 52.460455,-2.74833 52.460504,-2.74826 52.460539,-2.748165 52.460628,-2.748143 52.460637,-2.747994 52.460698,-2.747658 52.460744,-2.747408 52.460786,-2.747086 52.460816,-2.746861 52.460802,-2.746672 52.46075,-2.746663 52.460748,-2.746633 52.46073,-2.74641 52.460588,-2.746082 52.460374,-2.745724 52.46018,-2.745566 52.4601,-2.745255 52.460006)",
    "LINESTRING(-2.831391 52.445745,-2.831339 52.445682,-2.831253 52.445621,-2.831039 52.44551,-2.830941 52.44546,-2.830856 52.445417,-2.830585 52.44522,-2.830148 52.444916,-2.829946 52.444785,-2.829823 52.444658,-2.829669 52.444499,-2.829529 52.444301,-2.829337 52.444027,-2.829228 52.443938)",
    "LINESTRING(-2.862644 52.42015,-2.862666 52.420191,-2.862617 52.420468,-2.86324 52.42065,-2.863646 52.420786,-2.863929 52.42088,-2.864098 52.420923,-2.864238 52.420943,-2.864523 52.421001,-2.864593 52.421023,-2.864624 52.421057,-2.864662 52.421116,-2.864726 52.421363,-2.864872 52.421795,-2.864946 52.422014,-2.865 52.422122,-2.865058 52.422183,-2.865126 52.422208,-2.865203 52.422225)",
    "LINESTRING(-2.755579 52.587427,-2.755548 52.587419,-2.755514 52.587406,-2.754749 52.587077,-2.754192 52.586858,-2.754158 52.586844,-2.753716 52.586664,-2.753125 52.586419,-2.75309 52.586407,-2.752784 52.586294,-2.751987 52.585975,-2.750903 52.585522,-2.750786 52.585474,-2.750434 52.585337,-2.7502 52.585287,-2.750041 52.585273,-2.749718 52.585276,-2.749452 52.585272,-2.749222 52.585245,-2.749042 52.585194,-2.74897 52.585173,-2.748916 52.585145,-2.748871 52.585093,-2.748724 52.584982,-2.748585 52.584877,-2.748371 52.584716,-2.74821 52.584667,-2.748025 52.584628,-2.747835 52.584588,-2.747546 52.584561)",
    "LINESTRING(-2.758824 52.566573,-2.758843 52.566612,-2.758884 52.56673,-2.758879 52.566811,-2.75884 52.566919,-2.758784 52.567022,-2.758735 52.567116,-2.758661 52.567189,-2.758503 52.56727,-2.758483 52.567301,-2.758484 52.567328,-2.758515 52.567351,-2.758562 52.567348,-2.75862 52.567336,-2.758687 52.567284,-2.758831 52.567185,-2.759103 52.566989,-2.759359 52.566874,-2.759639 52.566798,-2.759771 52.566778,-2.759893 52.566784,-2.760066 52.566813,-2.760578 52.56694,-2.760622 52.566931,-2.760666 52.566922,-2.760711 52.566913,-2.760755 52.566894,-2.760798 52.566858,-2.760968 52.566699)",
    "LINESTRING(-2.79983 52.554365,-2.79986 52.554392,-2.799905 52.554428,-2.800233 52.554632,-2.800442 52.554793,-2.800517 52.554837,-2.800636 52.554899,-2.800948 52.555032,-2.801053 52.555094,-2.801172 52.555183,-2.801217 52.555201,-2.801335 52.555209,-2.801512 52.555199,-2.80163 52.555198,-2.801748 52.555197,-2.801866 52.555188,-2.801969 52.555169,-2.802115 52.555132,-2.80235 52.555085,-2.802454 52.555076,-2.802793 52.555073,-2.80294 52.555054,-2.80316 52.554999,-2.803538 52.554912,-2.803829 52.554803,-2.804605 52.554622,-2.805872 52.554267,-2.806038 52.554234,-2.80643 52.554195,-2.806568 52.554212,-2.806931 52.554219,-2.807023 52.554211,-2.807075 52.554198,-2.807114 52.55418,-2.807192 52.554172,-2.807355 52.554181,-2.807566 52.554194,-2.808058 52.554246,-2.80856 52.554279,-2.808708 52.554287)",
    "LINESTRING(-2.838002 52.589989,-2.838081 52.590031,-2.838235 52.590053,-2.838557 52.590099,-2.838864 52.590158,-2.83901 52.590208,-2.839129 52.590255,-2.839262 52.590309,-2.839384 52.590391,-2.839451 52.590444,-2.839562 52.590509,-2.839657 52.590536,-2.839789 52.590543,-2.839919 52.590545,-2.840044 52.590556,-2.840131 52.59058,-2.840177 52.590626,-2.840219 52.590711,-2.84025 52.590812,-2.840451 52.591463,-2.840611 52.591889,-2.840709 52.592094,-2.840819 52.592311,-2.841156 52.592947,-2.841231 52.593054,-2.841378 52.59321,-2.841452 52.593274)",
    "LINESTRING(-2.888846 52.559077,-2.888526 52.559015,-2.8881 52.558936,-2.887961 52.558894,-2.887797 52.55883,-2.887612 52.558738,-2.887359 52.558609,-2.887079 52.558467,-2.886905 52.558368,-2.886651 52.558193,-2.886535 52.55806,-2.886397 52.55782,-2.886355 52.557709,-2.886353 52.557593,-2.886389 52.557524,-2.886442 52.55749,-2.886469 52.557473,-2.886648 52.557357,-2.886851 52.557271,-2.887098 52.557196,-2.887359 52.557129,-2.887542 52.557082,-2.887792 52.557048,-2.88827 52.557015,-2.888439 52.556996,-2.888542 52.55699,-2.889071 52.556911,-2.889527 52.556827,-2.889674 52.556817,-2.889807 52.556843,-2.890283 52.55701,-2.890685 52.557196,-2.890908 52.557302,-2.891384 52.557487)",
    "LINESTRING(-2.829632 52.505566,-2.82985 52.505388,-2.830133 52.505157,-2.83044 52.504943,-2.831098 52.50454)",
    "LINESTRING(-2.642485 52.161121,-2.642505 52.161137,-2.642515 52.161145,-2.642731 52.16118,-2.642813 52.161197,-2.643002 52.161234,-2.643168 52.161289,-2.643448 52.161364,-2.643565 52.161395)",
    "LINESTRING(-2.637575 52.233071,-2.637728 52.233077,-2.637808 52.233079,-2.638076 52.233102,-2.638622 52.233136,-2.638791 52.233154,-2.638988 52.233195,-2.639222 52.233274,-2.639415 52.233362,-2.639539 52.233424,-2.63961 52.23345,-2.639721 52.233468,-2.639879 52.233473,-2.639982 52.233465,-2.640052 52.233456,-2.640186 52.233424,-2.640256 52.233391,-2.640318 52.233354,-2.640357 52.233311,-2.640411 52.233211,-2.640523 52.232946,-2.640638 52.232675,-2.64068 52.232612,-2.640723 52.23256,-2.640835 52.232451,-2.640927 52.232405,-2.641263 52.232261,-2.641743 52.23204,-2.642283 52.23178,-2.642565 52.231658,-2.642817 52.231562,-2.643029 52.231484,-2.643329 52.231368,-2.643708 52.231212,-2.64387 52.231162,-2.644195 52.231077,-2.644562 52.230981,-2.644794 52.230902,-2.644881 52.230856,-2.645009 52.230764,-2.645114 52.23066,-2.645264 52.230502,-2.645455 52.230308,-2.645595 52.230207,-2.64568 52.230165,-2.645736 52.230157,-2.645791 52.230153,-2.646069 52.230191,-2.646136 52.230212,-2.64618 52.230262,-2.646227 52.230349,-2.646285 52.230415,-2.646331 52.230442,-2.646375 52.230449,-2.646438 52.230451,-2.64652 52.230443,-2.646687 52.230402,-2.646814 52.230356,-2.646936 52.230288,-2.64703 52.230232,-2.647068 52.230219,-2.647089 52.230219,-2.647115 52.230227,-2.647136 52.230247,-2.647171 52.230303,-2.647317 52.2306,-2.64753 52.23105,-2.647562 52.231115,-2.647752 52.231493,-2.647963 52.231909,-2.648125 52.232278,-2.648195 52.23237,-2.648499 52.232678,-2.648787 52.233036)",
    "LINESTRING(-2.690171 52.230102,-2.689196 52.230251,-2.689023 52.230279,-2.689 52.230275,-2.688958 52.230234,-2.688885 52.230144,-2.688817 52.230056,-2.688737 52.229961,-2.688654 52.229882,-2.688612 52.229842,-2.688251 52.229564,-2.687704 52.229139,-2.687509 52.228987,-2.687417 52.22891)",
    "LINESTRING(-2.665954 52.174958,-2.665528 52.175062,-2.664759 52.175273,-2.663968 52.175413,-2.663044 52.175559,-2.662799 52.175583,-2.662155 52.175646,-2.66196 52.175665,-2.661055 52.175805,-2.660705 52.175852,-2.659976 52.175964,-2.659505 52.175989,-2.659009 52.17604,-2.658398 52.176098,-2.657639 52.176165,-2.657347 52.176185,-2.657069 52.176232,-2.656894 52.176251,-2.656646 52.176252,-2.656445 52.176242,-2.655922 52.176208,-2.655463 52.176181)",
    "LINESTRING(-2.72594 52.149683,-2.72591 52.149665,-2.725895 52.149656,-2.725866 52.149657,-2.725793 52.149675,-2.725546 52.149748,-2.725343 52.149831,-2.725198 52.149903,-2.725159 52.149924,-2.72514 52.149949,-2.725155 52.149967,-2.725184 52.149984)",
    "LINESTRING(-2.632796 52.240441,-2.63376 52.240018,-2.634053 52.239885,-2.634766 52.239675,-2.634794 52.239667,-2.634963 52.239618,-2.635271 52.239519,-2.635415 52.239464,-2.635737 52.239402,-2.636024 52.239367,-2.636327 52.239342,-2.63676 52.239321,-2.636986 52.23931,-2.637142 52.239302,-2.637321 52.239294,-2.63775 52.239315,-2.637888 52.239316,-2.637972 52.239302,-2.638385 52.239243,-2.638485 52.239241,-2.638748 52.239205,-2.639029 52.239164,-2.639202 52.239131,-2.639375 52.239092,-2.639563 52.239052,-2.639751 52.238986,-2.64009 52.238867,-2.640313 52.238778,-2.640843 52.238542,-2.641227 52.238369,-2.641732 52.238155,-2.64186 52.238089)",
    "LINESTRING(-2.639628 52.316021,-2.639653 52.315956,-2.639945 52.315567,-2.640282 52.315088,-2.64036 52.314942,-2.640476 52.314813,-2.640679 52.314644,-2.640745 52.314588,-2.640912 52.314469,-2.641118 52.314317,-2.641179 52.314283,-2.641222 52.314259,-2.641342 52.314239,-2.641487 52.314269,-2.642391 52.314469,-2.642953 52.314591,-2.643178 52.314646)",
    "LINESTRING(-2.665957 52.29218,-2.666931 52.29203,-2.667244 52.291978,-2.667331 52.29194,-2.667506 52.291819,-2.667615 52.291681,-2.667794 52.29147,-2.668031 52.291296,-2.66824 52.291155,-2.668371 52.291076,-2.668653 52.290936,-2.669207 52.290705,-2.669537 52.290575,-2.669953 52.290379,-2.670247 52.29023,-2.670637 52.290046,-2.670942 52.289843,-2.671075 52.289716,-2.671488 52.289099,-2.671632 52.288956,-2.672236 52.288543,-2.672427 52.288412,-2.672747 52.28806,-2.672811 52.287989,-2.672892 52.287933,-2.672999 52.287857,-2.673944 52.287449,-2.674238 52.287319,-2.674307 52.287288,-2.674378 52.287251,-2.674592 52.28714,-2.674977 52.286959,-2.675056 52.286924,-2.675263 52.28683,-2.675265 52.286828,-2.675294 52.286799,-2.675328 52.286766,-2.675371 52.286705,-2.675399 52.286661,-2.675431 52.286611,-2.675543 52.286414,-2.675699 52.286026,-2.675725 52.285828,-2.675767 52.28572,-2.675881 52.285486,-2.676288 52.284918,-2.67647 52.28468,-2.676749 52.284329,-2.677128 52.283814,-2.6772 52.283739,-2.677232 52.283728,-2.677302 52.283711,-2.677379 52.283733,-2.677402 52.283746)",
    "LINESTRING(-2.672184 52.273394,-2.671954 52.273362,-2.671202 52.27319,-2.670777 52.273124,-2.670389 52.27307,-2.669867 52.272991,-2.669658 52.272944,-2.669554 52.272906,-2.669302 52.2728,-2.669102 52.272753,-2.669026 52.272692,-2.668962 52.272593,-2.668927 52.272465,-2.6689 52.272333,-2.668849 52.272254,-2.668552 52.271936,-2.668499 52.271864,-2.668375 52.271699,-2.668374 52.271697,-2.668306 52.271613,-2.668247 52.271578,-2.667917 52.271501,-2.667817 52.271476,-2.667733 52.271425,-2.667666 52.27137,-2.667582 52.271301,-2.667422 52.271071,-2.667232 52.270769,-2.667053 52.270509,-2.666868 52.270205,-2.666625 52.269824,-2.66648 52.269572,-2.666433 52.26948,-2.666419 52.269388,-2.666404 52.26923,-2.666411 52.269141,-2.666439 52.269054,-2.666486 52.26889,-2.666521 52.268726,-2.666542 52.268474,-2.666572 52.268218,-2.66661 52.267985,-2.666625 52.267873,-2.666709 52.267648,-2.6668 52.267359,-2.666856 52.267185,-2.666864 52.266914,-2.666884 52.266832,-2.666937 52.266732,-2.666994 52.266678,-2.667118 52.266601,-2.667395 52.266464,-2.667439 52.266433)",
    "LINESTRING(-2.692432 52.276201,-2.692573 52.276122,-2.692668 52.276056,-2.69298 52.275861,-2.693366 52.275692,-2.693791 52.275545,-2.693888 52.27549,-2.693936 52.275445,-2.69398 52.275364,-2.694043 52.275154,-2.694096 52.27492,-2.69415 52.274558,-2.694205 52.274431,-2.694414 52.273995,-2.694706 52.273077,-2.694727 52.273025,-2.694777 52.272924,-2.694852 52.272846,-2.694945 52.272757,-2.695188 52.272611,-2.695378 52.272511,-2.695563 52.272425,-2.695781 52.272325,-2.69595 52.272254,-2.696126 52.272181,-2.696269 52.272109,-2.69645 52.271997,-2.696741 52.271827,-2.696895 52.271751,-2.697155 52.27167,-2.697364 52.271596,-2.697454 52.27156,-2.697493 52.271543,-2.697549 52.271515,-2.697592 52.271487,-2.69765 52.271451,-2.697679 52.271433,-2.697693 52.271388)",
    "LINESTRING(-2.71662 52.29899,-2.716103 52.299093,-2.71594 52.299121,-2.715839 52.299122,-2.715711 52.299112,-2.715571 52.299113,-2.715197 52.299153,-2.714666 52.299215,-2.714587 52.299221,-2.714368 52.299293,-2.714006 52.299449,-2.713865 52.299471,-2.713742 52.299458,-2.713671 52.299432,-2.713618 52.299416,-2.713543 52.299414,-2.713271 52.299485,-2.713048 52.299527,-2.712863 52.299542,-2.712736 52.299537,-2.712603 52.299514,-2.712426 52.299461,-2.712134 52.299365,-2.711913 52.299299,-2.711755 52.299265,-2.711653 52.299244,-2.711437 52.299227,-2.711186 52.29922,-2.710958 52.299232,-2.71072 52.299215,-2.710236 52.299199,-2.709901 52.299171,-2.709575 52.299138,-2.709434 52.299134,-2.709285 52.299151,-2.709074 52.299203,-2.708771 52.299229,-2.708419 52.299242,-2.708094 52.299239,-2.707891 52.299202,-2.707749 52.299133,-2.707594 52.299058,-2.707474 52.298978,-2.70734 52.298882,-2.707131 52.298743,-2.706936 52.298636,-2.706577 52.298439,-2.706244 52.298255,-2.706146 52.298212,-2.706107 52.298204)",
    "LINESTRING(-2.625241 52.364223,-2.625313 52.364079,-2.625396 52.363755,-2.625417 52.363684,-2.625467 52.36353,-2.625566 52.363323,-2.625637 52.363115,-2.625694 52.362997,-2.625737 52.362908,-2.625837 52.362728,-2.626097 52.362394,-2.626226 52.362213,-2.626255 52.362177,-2.626284 52.362105,-2.626297 52.362024,-2.62631 52.361925,-2.626308 52.361772,-2.626276 52.361658,-2.626215 52.36144,-2.626199 52.361341,-2.626197 52.36118,-2.62623 52.361076,-2.626386 52.360856,-2.626497 52.360664,-2.626545 52.360526,-2.626561 52.360396,-2.626552 52.360324,-2.626536 52.360216,-2.62655 52.360062,-2.626547 52.359991,-2.626569 52.359896,-2.626591 52.359799,-2.626651 52.359693,-2.626763 52.359532,-2.626821 52.35939,-2.626881 52.359282,-2.626983 52.358974,-2.626997 52.358931,-2.62704 52.358888,-2.627095 52.358848,-2.627292 52.358805,-2.627482 52.358788,-2.627652 52.358769,-2.627925 52.358743,-2.628089 52.3587,-2.628234 52.358601,-2.6284 52.358454,-2.628643 52.358199,-2.628776 52.358066,-2.628833 52.357997)",
    "LINESTRING(-2.701915 52.415412,-2.70192 52.415411,-2.701938 52.415405,-2.701956 52.4154,-2.701968 52.415395,-2.701982 52.41539,-2.701996 52.415385,-2.70201 52.41538,-2.702027 52.415375,-2.702051 52.415369,-2.702096 52.415363,-2.702615 52.415426,-2.70304 52.415478,-2.703535 52.415544,-2.703915 52.415593,-2.704146 52.415621,-2.704382 52.415651,-2.704569 52.415674,-2.704741 52.415695,-2.704891 52.415713,-2.705012 52.415727,-2.705118 52.41574,-2.705203 52.415751,-2.705272 52.415759,-2.705334 52.415767,-2.705401 52.415775)",
    "LINESTRING(-2.707812 52.377531,-2.707872 52.377589,-2.708109 52.377788,-2.708334 52.377977,-2.708556 52.378111,-2.709177 52.378368,-2.70934 52.37842,-2.709472 52.378447,-2.709956 52.378548)",
    "LINESTRING(-2.620516 52.379118,-2.620457 52.379211,-2.620431 52.379337,-2.62039 52.37952,-2.62036 52.37975,-2.620341 52.379986,-2.620345 52.380114,-2.6204 52.380269,-2.6204 52.380305,-2.620328 52.380386,-2.620246 52.380461,-2.620105 52.380619,-2.620013 52.38068,-2.619911 52.380753,-2.619865 52.380797,-2.619844 52.380845,-2.619698 52.380995,-2.61959 52.381106,-2.61956 52.381171,-2.619543 52.381275,-2.619538 52.381331)",
    "LINESTRING(-2.707602 52.372668,-2.707795 52.372744,-2.70812 52.372872,-2.70846 52.372996)",
    "LINESTRING(-2.711811 52.37457,-2.711658 52.374351,-2.711597 52.374317,-2.711513 52.374312,-2.711339 52.374339,-2.710727 52.374445,-2.710437 52.374497,-2.710174 52.374562,-2.709927 52.374623,-2.709397 52.374757)",
    "LINESTRING(-2.706761 52.37698,-2.706716 52.376953,-2.706627 52.37689,-2.706537 52.37681,-2.706388 52.376667,-2.706314 52.376596,-2.706192 52.376318,-2.706146 52.376153)",
    "LINESTRING(-2.621756 52.445112,-2.621868 52.444997,-2.621989 52.444842,-2.622251 52.444614,-2.622538 52.444381,-2.622715 52.444245,-2.622746 52.444162,-2.622761 52.444092,-2.622739 52.444014,-2.622645 52.443805,-2.622485 52.443494,-2.622426 52.443401,-2.62237 52.443298,-2.622323 52.443194,-2.622298 52.443091,-2.622292 52.442974,-2.622318 52.442867,-2.622363 52.442789,-2.622434 52.442638,-2.622483 52.442528,-2.622536 52.442409,-2.622539 52.442289,-2.622522 52.442225,-2.622475 52.44213,-2.62243 52.442042,-2.622353 52.441909,-2.622241 52.441739,-2.622058 52.441463,-2.621748 52.441037,-2.621524 52.440713,-2.621368 52.440483,-2.621248 52.440291,-2.621166 52.440152,-2.621086 52.439994,-2.621018 52.439834,-2.62092 52.439574,-2.620759 52.439153,-2.620586 52.438729,-2.620425 52.438338,-2.620138 52.437647)",
    "LINESTRING(-2.654057 52.461737,-2.654156 52.461723,-2.654248 52.461682,-2.654354 52.461623,-2.654612 52.461392,-2.654764 52.461257,-2.654893 52.461097,-2.655048 52.460894,-2.655062 52.460875,-2.655109 52.460821,-2.655134 52.460792,-2.655226 52.46069,-2.655231 52.460685,-2.655344 52.460581,-2.655418 52.460523,-2.65552 52.460452,-2.655555 52.460434,-2.655627 52.460397,-2.655695 52.460367,-2.655719 52.460356,-2.655819 52.460324,-2.655992 52.460266,-2.656134 52.460217,-2.656205 52.460188,-2.656229 52.460176,-2.656276 52.460152,-2.6564 52.460089,-2.656492 52.46003,-2.656579 52.45996,-2.656722 52.459843,-2.656837 52.459745,-2.657007 52.459598,-2.657009 52.459596,-2.657095 52.459498,-2.657107 52.459484,-2.657153 52.459424,-2.657211 52.459359,-2.657332 52.459224,-2.657388 52.459182,-2.657462 52.459126,-2.65762 52.459015,-2.65783 52.458869,-2.657942 52.458791,-2.658069 52.458703,-2.658316 52.458521,-2.658471 52.45842,-2.658762 52.458249,-2.65919 52.458021,-2.659703 52.457759,-2.659955 52.457606)",
    "LINESTRING(-2.735941 52.47267,-2.735934 52.472667,-2.735924 52.472661,-2.735852 52.47262,-2.735599 52.47246,-2.73548 52.47237,-2.735464 52.472357,-2.735361 52.472276,-2.735294 52.472218,-2.735262 52.472172,-2.735206 52.472079,-2.735165 52.472022,-2.734934 52.471758,-2.734895 52.471727,-2.734885 52.471718,-2.734835 52.471673,-2.734825 52.471663,-2.734729 52.471589,-2.734697 52.47157,-2.73464 52.471541,-2.734612 52.471531)",
    "LINESTRING(-2.600202 52.588818,-2.599984 52.588964,-2.599881 52.58905,-2.599775 52.589104,-2.599548 52.589215,-2.599542 52.589219,-2.599052 52.589451,-2.59847 52.589744,-2.598061 52.589933,-2.597517 52.59018,-2.597069 52.590412,-2.596399 52.590737,-2.596005 52.590942,-2.595702 52.591172,-2.595278 52.591479,-2.594971 52.591716,-2.594324 52.592189,-2.594038 52.592401,-2.593483 52.592668,-2.592961 52.592903,-2.592742 52.593009,-2.59245 52.593148,-2.592205 52.593362,-2.591903 52.593647,-2.591599 52.593929,-2.591221 52.594265,-2.590853 52.594544,-2.590349 52.594841,-2.589792 52.595132,-2.589358 52.595346,-2.588695 52.595666,-2.58789 52.596063,-2.587503 52.596248,-2.587206 52.59639,-2.586929 52.596499,-2.58639 52.596768,-2.585825 52.597044,-2.585507 52.597212,-2.585136 52.597431,-2.584636 52.597744,-2.584113 52.598065,-2.583643 52.598353,-2.583338 52.598545,-2.58302 52.598717,-2.582686 52.5989,-2.582504 52.598987,-2.582322 52.599055,-2.582214 52.599083,-2.581887 52.599137,-2.581618 52.599174,-2.581605 52.599185,-2.5816 52.59919,-2.581574 52.599213,-2.581574 52.599231)",
    "LINESTRING(-2.643908 52.583275,-2.643708 52.583233,-2.643223 52.58317,-2.642576 52.583105,-2.641417 52.582982,-2.64131 52.582971,-2.641297 52.582969,-2.641206 52.582963,-2.641102 52.582947,-2.640998 52.582903,-2.640938 52.582866,-2.640862 52.582804,-2.640729 52.582636,-2.640672 52.582555,-2.640647 52.582507,-2.640625 52.582469,-2.640621 52.58244,-2.640622 52.582385,-2.640636 52.582358,-2.640709 52.582304,-2.640817 52.58222,-2.6409 52.582151,-2.640989 52.582077,-2.641102 52.58199,-2.641183 52.581935,-2.641303 52.581863,-2.641425 52.581798,-2.64147 52.581768,-2.641513 52.581728,-2.641632 52.58163,-2.64178 52.5815,-2.641912 52.581426,-2.642237 52.581273,-2.642484 52.58117,-2.642678 52.581101,-2.642836 52.581071)",
    "LINESTRING(-2.694135 52.569982,-2.6944 52.570116,-2.694927 52.57055,-2.695022 52.570633,-2.695077 52.570645,-2.695132 52.57064,-2.695204 52.570588,-2.695539 52.570325,-2.695671 52.570243,-2.6957 52.570225,-2.695773 52.570198,-2.695832 52.570188,-2.695906 52.570188,-2.696069 52.570214,-2.696187 52.570213,-2.696305 52.570213,-2.696393 52.570194,-2.696452 52.570185,-2.69654 52.570139,-2.696642 52.570067,-2.696685 52.570013,-2.696742 52.569886,-2.696786 52.569832,-2.696829 52.569796,-2.696932 52.569733,-2.697108 52.569669,-2.697695 52.569485,-2.69793 52.569412,-2.698376 52.569276,-2.698473 52.569256,-2.698576 52.569219,-2.699147 52.568955,-2.699557 52.568755,-2.70001 52.568492,-2.700259 52.568355,-2.700596 52.568219,-2.70091 52.568118,-2.701081 52.568063,-2.701433 52.567971,-2.701933 52.56786,-2.702052 52.567827)",
    "LINESTRING(-2.735197 52.581367,-2.734933 52.581501,-2.734664 52.581612,-2.734412 52.581716,-2.734155 52.581793,-2.73393 52.581831,-2.733637 52.581899,-2.733549 52.581899)",
    "LINESTRING(-2.471251 52.186382,-2.471183 52.186377,-2.471137 52.186366,-2.471089 52.18633,-2.471061 52.186262,-2.471046 52.186148,-2.471038 52.186098,-2.470963 52.186025,-2.470884 52.185977,-2.470715 52.185932,-2.470661 52.185913,-2.470461 52.185895,-2.470222 52.185855,-2.470068 52.185818,-2.46998 52.185797,-2.469735 52.185775,-2.469362 52.185764,-2.469308 52.185757,-2.468923 52.185734,-2.468668 52.185713,-2.468601 52.185695,-2.468482 52.185663,-2.468349 52.185615,-2.468213 52.185558,-2.468109 52.185501,-2.467894 52.185386,-2.467456 52.185107,-2.467185 52.184921,-2.467114 52.184875,-2.466823 52.184617,-2.466688 52.184521,-2.466615 52.184469,-2.466488 52.184209,-2.466276 52.183883)",
    "LINESTRING(-2.471194 52.161747,-2.471208 52.161746,-2.471329 52.161734,-2.471447 52.16172,-2.471514 52.161706,-2.471686 52.16167,-2.471771 52.161669,-2.47189 52.161687)",
    "LINESTRING(-2.486775 52.192233,-2.486664 52.192166,-2.486034 52.191851,-2.485589 52.191668,-2.485207 52.191477,-2.485187 52.191467,-2.484394 52.191077,-2.484261 52.190967,-2.484201 52.190922,-2.484156 52.190876,-2.484035 52.19073,-2.483971 52.190665,-2.483911 52.190625,-2.48372 52.1905,-2.483666 52.190465,-2.483521 52.19038,-2.483259 52.190129,-2.483087 52.189954,-2.482767 52.189456)",
    "LINESTRING(-2.506368 52.187521,-2.506339 52.187566,-2.50631 52.187593,-2.506252 52.187611,-2.506223 52.18762,-2.506091 52.187603)",
    "LINESTRING(-2.505218 52.189211,-2.505069 52.189019,-2.504941 52.188854)",
    "LINESTRING(-2.50762 52.201419,-2.507724 52.201279,-2.50784 52.201135,-2.507882 52.201,-2.507915 52.200773,-2.50795 52.200666,-2.507951 52.200662,-2.508038 52.200532,-2.508095 52.200451,-2.508153 52.200388,-2.508225 52.200315,-2.508327 52.200234,-2.508414 52.200171,-2.508574 52.20008,-2.509286 52.199681,-2.509563 52.199545,-2.509636 52.199518,-2.509841 52.199449,-2.510023 52.199411,-2.51022 52.199386,-2.51036 52.199374,-2.510693 52.19938,-2.511144 52.199398,-2.511418 52.199391,-2.511575 52.199373,-2.51177 52.199338,-2.512456 52.199218,-2.51266 52.19919,-2.513226 52.199136,-2.513306 52.199118,-2.513362 52.199106,-2.513367 52.199105,-2.5135 52.199064,-2.51351 52.199059,-2.51353 52.199049,-2.513624 52.199006,-2.513725 52.198907)",
    "LINESTRING(-2.511843 52.190473,-2.511727 52.190563,-2.511672 52.190594,-2.511625 52.1906,-2.511465 52.190619,-2.511392 52.190628,-2.511333 52.190628,-2.5113 52.19062,-2.511274 52.190601,-2.511259 52.190574,-2.511153 52.190269,-2.511032 52.189865,-2.511017 52.189818,-2.511001 52.189775,-2.510972 52.189749,-2.510928 52.189731,-2.510884 52.189713,-2.510825 52.189713,-2.510723 52.189723,-2.510636 52.189744)",
    "LINESTRING(-2.540195 52.199951,-2.540115 52.199992,-2.539923 52.200124,-2.539792 52.200195,-2.539712 52.200274,-2.539129 52.200421,-2.538881 52.200476,-2.538735 52.200495,-2.538427 52.200514,-2.538121 52.20056,-2.53796 52.200597,-2.537669 52.200706,-2.537523 52.200761,-2.537131 52.201005,-2.53671 52.201286,-2.536448 52.201413,-2.536288 52.201477,-2.536113 52.201522,-2.535953 52.201568,-2.535734 52.201605,-2.535573 52.201633,-2.535295 52.201652,-2.53512 52.201644,-2.535061 52.201635,-2.534944 52.2016,-2.53487 52.201564,-2.534723 52.201475,-2.534162 52.201073,-2.534088 52.201019,-2.533631 52.200707,-2.533528 52.200662,-2.533454 52.200644,-2.533393 52.200645,-2.533258 52.200637,-2.532589 52.200671,-2.532514 52.200672,-2.532447 52.200673,-2.532357 52.200667,-2.532181 52.20065,-2.531512 52.200542,-2.531233 52.200507,-2.531033 52.200494,-2.530901 52.200478,-2.530773 52.200462,-2.529977 52.200263,-2.529738 52.200201,-2.529564 52.200141,-2.529338 52.200039,-2.529245 52.199997,-2.528879 52.199775,-2.528693 52.199663,-2.528521 52.199549,-2.528378 52.199481,-2.528156 52.199402,-2.52758 52.19925,-2.527218 52.199153,-2.526851 52.199047,-2.526484 52.198959,-2.526279 52.198897,-2.525676 52.198692,-2.525427 52.198595,-2.524883 52.198372,-2.524721 52.198328,-2.524545 52.198293)",
    "LINESTRING(-2.544544 52.17669,-2.544596 52.176676,-2.544688 52.176668,-2.544773 52.176675,-2.54492 52.176689,-2.545117 52.176722,-2.545294 52.176748,-2.545435 52.176759,-2.545625 52.176784,-2.545699 52.176791,-2.545889 52.176809,-2.546085 52.176831,-2.546323 52.176845,-2.546654 52.176873,-2.546825 52.176888,-2.547009 52.17689,-2.54726 52.176893,-2.547529 52.176899,-2.547848 52.176917,-2.548111 52.176923,-2.548264 52.176934,-2.548447 52.176948,-2.548566 52.176945)",
    "LINESTRING(-2.572267 52.237221,-2.572354 52.23703,-2.572462 52.236915,-2.572642 52.236834,-2.572777 52.236822,-2.573147 52.236798,-2.573256 52.23677,-2.573293 52.236761,-2.573381 52.236734,-2.573672 52.236597,-2.57437 52.23618,-2.574776 52.235936,-2.575348 52.235529,-2.575583 52.235373,-2.575987 52.235117,-2.576503 52.234756,-2.576544 52.234726,-2.576745 52.234593,-2.576895 52.234517,-2.577057 52.234461,-2.577394 52.234363,-2.577633 52.234284,-2.577839 52.234198,-2.577967 52.234153,-2.578536 52.233986,-2.579064 52.233819,-2.579075 52.233815,-2.579399 52.23368,-2.579744 52.233564,-2.580219 52.233415,-2.580847 52.233218)",
    "LINESTRING(-2.441663 52.321315,-2.441916 52.321358,-2.442019 52.321366,-2.442294 52.321388,-2.44248 52.321436,-2.442685 52.321469,-2.44299 52.321514,-2.443297 52.32154,-2.443602 52.321574,-2.443702 52.321607,-2.443745 52.321669,-2.443789 52.32201,-2.443829 52.322171,-2.443914 52.322332,-2.443995 52.322392,-2.444002 52.322398,-2.444023 52.322413,-2.444032 52.322417,-2.444041 52.322421,-2.4441 52.322447,-2.444476 52.322556,-2.444493 52.32256,-2.444694 52.322611,-2.444935 52.322681,-2.445149 52.322755,-2.445355 52.322852,-2.445631 52.323012,-2.445893 52.323175,-2.446104 52.323281,-2.44629 52.323343,-2.446489 52.323402,-2.446927 52.323534,-2.447081 52.323584,-2.447145 52.323602,-2.447282 52.323637,-2.447384 52.323654,-2.447486 52.323657,-2.447589 52.323648,-2.448131 52.323592,-2.448249 52.323592,-2.44849 52.323599,-2.448762 52.323617)",
    "LINESTRING(-2.472028 52.316325,-2.472073 52.316386,-2.472207 52.316558,-2.472267 52.316683,-2.472312 52.316764,-2.472327 52.316809,-2.472343 52.316962,-2.472345 52.317132,-2.472304 52.317456,-2.47229 52.317501,-2.472203 52.317683,-2.472045 52.317966,-2.472003 52.318045,-2.47196 52.318159,-2.471917 52.318267,-2.471903 52.318312,-2.471859 52.318375,-2.47183 52.318402,-2.471801 52.318429,-2.471758 52.318447,-2.471654 52.318472)",
    "LINESTRING(-2.513312 52.310431,-2.513306 52.310371,-2.5133 52.310355,-2.513222 52.310076,-2.513172 52.30988,-2.513115 52.309663,-2.513099 52.309626,-2.513048 52.309509,-2.513032 52.309431,-2.513078 52.309344,-2.513109 52.309326,-2.513184 52.309281,-2.513257 52.309237,-2.513461 52.309147,-2.513605 52.309075,-2.513739 52.309009,-2.513795 52.308971,-2.513839 52.308901,-2.513843 52.308833,-2.513782 52.30868,-2.513738 52.308606,-2.513621 52.308397,-2.513579 52.308322,-2.513493 52.308058,-2.513457 52.307962,-2.513405 52.307867,-2.513197 52.307596,-2.51312 52.30749,-2.512969 52.307256,-2.512865 52.307106,-2.512804 52.307012,-2.512779 52.306933,-2.512773 52.306863,-2.512784 52.306794,-2.5128 52.306747)",
    "LINESTRING(-2.447545 52.312033,-2.447574 52.312015,-2.447603 52.311997,-2.447748 52.311762,-2.447893 52.311609,-2.447984 52.31151,-2.448009 52.311483,-2.448242 52.311302,-2.448344 52.311221,-2.448708 52.310967,-2.448795 52.310904,-2.449013 52.310652,-2.449042 52.310616,-2.449071 52.310597,-2.449114 52.31057,-2.44929 52.310507,-2.449859 52.310217,-2.449961 52.310154,-2.449975 52.3101,-2.450001 52.309803,-2.450015 52.309686,-2.450058 52.309587,-2.45013 52.309434,-2.450235 52.309256,-2.450453 52.309011,-2.450681 52.308838,-2.450827 52.30873,-2.451118 52.308531,-2.451569 52.308206,-2.451685 52.308114,-2.451712 52.308092,-2.451754 52.308061,-2.4518 52.308009,-2.451846 52.307936,-2.451896 52.307834,-2.451924 52.307764,-2.451926 52.307708,-2.451935 52.307634,-2.451944 52.307557,-2.451928 52.307467,-2.451928 52.307465,-2.451913 52.307395,-2.451838 52.307198,-2.45185 52.307128,-2.451852 52.307116,-2.451856 52.307093,-2.451884 52.307035,-2.451961 52.306947,-2.452048 52.306867,-2.452174 52.306789,-2.452283 52.306727,-2.452473 52.306631,-2.452524 52.306604,-2.452668 52.30651,-2.45271 52.306475,-2.45303 52.306222,-2.453176 52.306123,-2.453239 52.306091)",
    "LINESTRING(-2.504205 52.303927,-2.504313 52.303921,-2.504708 52.303739,-2.504743 52.303727,-2.504947 52.303657,-2.505136 52.30361,-2.505179 52.303607,-2.505327 52.303594,-2.505721 52.303539,-2.505735 52.303537,-2.506063 52.303488,-2.506494 52.303412,-2.506697 52.303379,-2.506829 52.303359,-2.507095 52.303328,-2.507372 52.303307,-2.507605 52.303302,-2.507775 52.303307,-2.508311 52.303289,-2.508416 52.303304,-2.508705 52.303355,-2.509098 52.303421,-2.509553 52.30349,-2.509639 52.303492,-2.509761 52.303471,-2.509877 52.303422,-2.509979 52.303349,-2.510145 52.303238,-2.510265 52.303178,-2.51049 52.303111,-2.510669 52.303047,-2.510794 52.302988,-2.510973 52.302883,-2.511093 52.302795,-2.511267 52.302679,-2.511436 52.302578,-2.511679 52.302427,-2.511826 52.302358,-2.511969 52.30229,-2.512169 52.302212,-2.512498 52.302075,-2.51274 52.301972,-2.512942 52.3019,-2.513044 52.301864,-2.513083 52.301833,-2.513105 52.301787,-2.513094 52.301723,-2.513033 52.30132,-2.512999 52.301071,-2.512998 52.301062)",
    "LINESTRING(-2.471692 52.306163,-2.471601 52.306131,-2.471559 52.30611,-2.471471 52.306066,-2.471372 52.306008,-2.471235 52.305918,-2.471124 52.305828,-2.470985 52.3057,-2.470942 52.305644,-2.470888 52.305565,-2.470828 52.305459,-2.470768 52.305348,-2.470707 52.305268,-2.470672 52.30523,-2.470672 52.30523,-2.470671 52.305229,-2.47066 52.305224)",
    "LINESTRING(-2.460975 52.291103,-2.460895 52.291139,-2.460541 52.291265,-2.46029 52.29135,-2.460273 52.29136,-2.460239 52.29138,-2.460162 52.291444,-2.460092 52.291508,-2.460018 52.291578,-2.459951 52.291614,-2.459858 52.291635,-2.459754 52.291643,-2.459648 52.29164,-2.45952 52.291627,-2.459354 52.291608,-2.459248 52.291608,-2.459195 52.291613,-2.459113 52.291632,-2.458917 52.291709,-2.458094 52.292053,-2.457536 52.29228,-2.45715 52.292444,-2.456959 52.292532,-2.456719 52.292656,-2.455967 52.293047,-2.45559 52.293237,-2.455529 52.293266,-2.455447 52.293284,-2.454891 52.293361,-2.454729 52.293387,-2.454654 52.293412,-2.454636 52.293418,-2.45458 52.293447)",
    "LINESTRING(-2.527254 52.284957,-2.527217 52.284992,-2.527166 52.285086,-2.527039 52.285303,-2.527002 52.285402,-2.52696 52.285441,-2.526887 52.28558,-2.526854 52.28564,-2.526846 52.285665,-2.526847 52.285695,-2.526855 52.285734,-2.52687 52.285764,-2.526912 52.285807,-2.526946 52.285842,-2.526988 52.285887,-2.527049 52.285949,-2.527079 52.285988,-2.527129 52.286055,-2.527159 52.286105,-2.527186 52.286149,-2.527216 52.286195,-2.52724 52.286247,-2.527259 52.286296,-2.527294 52.286383,-2.527327 52.286465,-2.527392 52.286665,-2.527405 52.286865,-2.527394 52.287169,-2.527378 52.287376,-2.527368 52.287493,-2.527344 52.287666,-2.527326 52.287704,-2.527292 52.287753,-2.527281 52.287816,-2.527302 52.287863,-2.527411 52.287887,-2.527687 52.287883,-2.52791 52.287894,-2.528124 52.287909,-2.528404 52.287941,-2.528654 52.287974,-2.528888 52.288003,-2.529118 52.288033,-2.52948 52.288081,-2.5296 52.288088,-2.5299 52.288117,-2.530232 52.288148,-2.530578 52.288161,-2.530763 52.288171,-2.530984 52.288192,-2.531201 52.2882,-2.531392 52.288201,-2.531518 52.288207,-2.531633 52.288219,-2.531806 52.288224,-2.531985 52.288245,-2.532221 52.288262,-2.532435 52.288288,-2.532926 52.288341,-2.533105 52.288362,-2.533188 52.288389,-2.533259 52.288423,-2.533339 52.288487,-2.533333 52.288518,-2.533328 52.288566,-2.53334 52.288619,-2.533332 52.288664,-2.533289 52.288739,-2.533199 52.288857,-2.533167 52.2889,-2.533148 52.288969,-2.533137 52.289042,-2.533123 52.28912,-2.53308 52.28919,-2.533037 52.289243,-2.532926 52.289358,-2.532822 52.289458,-2.532779 52.289508,-2.532703 52.289579,-2.532616 52.289655,-2.532564 52.28971)",
    "LINESTRING(-2.448937 52.282899,-2.448852 52.28286,-2.448805 52.282836,-2.447935 52.28238,-2.447175 52.281963,-2.446732 52.28172,-2.446589 52.281628,-2.44658 52.281619,-2.446447 52.281495,-2.446396 52.281389,-2.446387 52.281328,-2.446405 52.281235,-2.446457 52.281182,-2.446507 52.281131,-2.446744 52.281)",
    "LINESTRING(-2.563133 52.253041,-2.563455 52.252986,-2.563777 52.252876,-2.564579 52.252572,-2.56506 52.25239,-2.565162 52.252371,-2.565269 52.252375,-2.566355 52.252547,-2.566456 52.252563,-2.567209 52.252685,-2.567378 52.252711,-2.567596 52.252732,-2.568538 52.252798,-2.569435 52.252855,-2.569635 52.252857,-2.569726 52.252852,-2.57001 52.252813,-2.570499 52.252757,-2.570648 52.25274,-2.570966 52.25271,-2.57109 52.252714,-2.571365 52.252768,-2.571592 52.252817,-2.57164 52.252824,-2.571675 52.252829,-2.571753 52.25283,-2.571852 52.252811,-2.571865 52.252804,-2.571958 52.252754,-2.572143 52.252652,-2.572291 52.252577,-2.57244 52.252535,-2.572446 52.252534,-2.572473 52.25253,-2.572666 52.252499,-2.57274 52.252496,-2.572809 52.252494,-2.572882 52.252499)",
    "LINESTRING(-2.548434 52.318773,-2.54837 52.31869,-2.548342 52.318571,-2.54829 52.318243,-2.548328 52.318091,-2.548343 52.317724,-2.548345 52.317578,-2.548348 52.317463,-2.548352 52.317393,-2.548359 52.31729,-2.548367 52.317172,-2.548362 52.317132,-2.548348 52.317089,-2.548335 52.317051,-2.548303 52.317005,-2.548268 52.316968,-2.548228 52.316939,-2.548197 52.316914)",
    "LINESTRING(-2.5647 52.280694,-2.564611 52.280667,-2.564554 52.280647,-2.564553 52.280646,-2.564466 52.280583,-2.564464 52.280581,-2.564462 52.280579,-2.564382 52.280491,-2.5643 52.280394,-2.5642 52.280285,-2.564089 52.280184,-2.564012 52.280141,-2.563911 52.280103,-2.563849 52.28009,-2.56382 52.280083,-2.563771 52.280073,-2.56375 52.280071,-2.563685 52.280064,-2.56362 52.280057)",
    "LINESTRING(-2.572267 52.237221,-2.572354 52.23703,-2.572462 52.236915,-2.572642 52.236834,-2.572777 52.236822,-2.573147 52.236798,-2.573256 52.23677,-2.573293 52.236761,-2.573381 52.236734,-2.573672 52.236597,-2.57437 52.23618,-2.574776 52.235936,-2.575348 52.235529,-2.575583 52.235373,-2.575987 52.235117,-2.576503 52.234756,-2.576544 52.234726,-2.576745 52.234593,-2.576895 52.234517,-2.577057 52.234461,-2.577394 52.234363,-2.577633 52.234284,-2.577839 52.234198,-2.577967 52.234153,-2.578536 52.233986,-2.579064 52.233819,-2.579075 52.233815,-2.579399 52.23368,-2.579744 52.233564,-2.580219 52.233415,-2.580847 52.233218)",
    "LINESTRING(-2.471886 52.410372,-2.472048 52.410396,-2.472451 52.410365,-2.473273 52.4103,-2.473549 52.410281,-2.473782 52.410266,-2.474242 52.410265,-2.474647 52.410255,-2.474666 52.410255,-2.474948 52.410239,-2.475095 52.410224,-2.475192 52.410209,-2.475535 52.410156,-2.476032 52.410086,-2.476313 52.41005,-2.476674 52.410016,-2.476947 52.409988,-2.47713 52.409984,-2.477333 52.409991,-2.477465 52.410011,-2.477505 52.410023,-2.477604 52.410054,-2.477621 52.410059,-2.47776 52.410118,-2.477938 52.410225,-2.47796 52.410242,-2.478004 52.410276,-2.478065 52.410324,-2.478077 52.410336,-2.478164 52.410437,-2.478193 52.410445,-2.478311 52.410454,-2.478707 52.410425,-2.478741 52.410429)",
    "LINESTRING(-2.466721 52.410894,-2.466809 52.41093,-2.466969 52.411017,-2.467398 52.411283,-2.46767 52.411458,-2.467738 52.411487,-2.467844 52.411521,-2.468032 52.411543,-2.468194 52.411562,-2.468255 52.411569,-2.470843 52.41184,-2.471402 52.411902)",
    "LINESTRING(-2.554667 52.389753,-2.554543 52.38971,-2.554214 52.389653,-2.55373 52.389577,-2.553436 52.389514,-2.553155 52.389412,-2.552772 52.38929,-2.552624 52.389246,-2.552374 52.389193,-2.552153 52.389131,-2.552101 52.389104,-2.552049 52.389077,-2.552 52.389048)",
    "LINESTRING(-2.474069 52.386413,-2.474094 52.386471,-2.474115 52.386496,-2.474138 52.386512,-2.474147 52.386518,-2.474168 52.386532,-2.474186 52.386543,-2.474206 52.38655,-2.474224 52.386555,-2.474247 52.386557,-2.474265 52.386558,-2.474356 52.386555)",
    "LINESTRING(-2.577546 52.379129,-2.577584 52.379095,-2.577739 52.379002,-2.57807 52.378821,-2.579069 52.378298,-2.580057 52.377738,-2.580511 52.377505,-2.580879 52.3773,-2.58191 52.376725,-2.5821 52.376616,-2.582245 52.37653,-2.582368 52.376457,-2.582477 52.376409,-2.582588 52.376376,-2.582702 52.376349,-2.582832 52.37633,-2.583016 52.376318,-2.583245 52.376315,-2.583266 52.376315,-2.583497 52.376348,-2.583633 52.376389,-2.583712 52.376413,-2.583878 52.376449,-2.584109 52.376495,-2.584299 52.376554,-2.584416 52.376593,-2.58449 52.376599,-2.584599 52.376567,-2.584676 52.376514,-2.584728 52.376458,-2.584749 52.376421)",
    "LINESTRING(-2.459996 52.457962,-2.459215 52.4578,-2.45878 52.457693,-2.458686 52.457664,-2.458619 52.457636,-2.458585 52.457607,-2.458548 52.457468,-2.458519 52.457359,-2.458485 52.457302,-2.458481 52.457242,-2.458492 52.457168,-2.458519 52.457079,-2.458548 52.456995,-2.458598 52.456919,-2.458673 52.456838,-2.458893 52.456647,-2.459155 52.456424,-2.459233 52.456346,-2.459266 52.456298,-2.459277 52.456238,-2.459288 52.456113,-2.459284 52.455913,-2.459288 52.45563,-2.459307 52.45544,-2.459305 52.455367,-2.459301 52.455309,-2.459283 52.455264,-2.459234 52.455202,-2.459169 52.455154,-2.459056 52.455092,-2.458995 52.455039,-2.458933 52.454965,-2.458907 52.454912,-2.458852 52.454721,-2.458775 52.454426,-2.458715 52.454227,-2.458665 52.454112,-2.458609 52.454007,-2.458514 52.453871,-2.458433 52.453774,-2.458356 52.453697,-2.458293 52.45363,-2.458277 52.453587)",
    "LINESTRING(-2.578602 52.498031,-2.579251 52.498096,-2.579281 52.498114,-2.579311 52.498132,-2.579329 52.498169,-2.579309 52.498265)",
    "LINESTRING(-2.571655 52.452134,-2.571922 52.452084,-2.572008 52.452068,-2.572449 52.452065,-2.573334 52.452059,-2.573409 52.452073)",
    "LINESTRING(-2.545333 52.455671,-2.545365 52.455672,-2.545391 52.455671,-2.545479 52.455653,-2.545553 52.455635,-2.545919 52.455507,-2.545995 52.455476,-2.54605 52.455469,-2.546051 52.455469,-2.546107 52.455486,-2.54617 52.455533,-2.546229 52.455605,-2.546334 52.455703,-2.546482 52.455828,-2.54675 52.456016,-2.546824 52.456087,-2.546869 52.456177,-2.546884 52.456377,-2.546897 52.456551,-2.546919 52.456924,-2.546914 52.456973,-2.546866 52.456996,-2.546808 52.456985,-2.546774 52.456978,-2.546585 52.456905,-2.546199 52.456729,-2.546066 52.456697,-2.546052 52.456693,-2.545934 52.456672,-2.545904 52.456667,-2.545727 52.45665,-2.54547 52.456622,-2.544925 52.456606,-2.544903 52.456606,-2.544375 52.456603,-2.544226 52.456608,-2.543741 52.456612,-2.543313 52.456598)",
    "LINESTRING(-2.47225 52.463886,-2.472365 52.463904,-2.472832 52.463991,-2.472848 52.463994,-2.473175 52.464072,-2.473328 52.464126,-2.473333 52.464128,-2.473338 52.46413,-2.473463 52.464195,-2.473616 52.464322,-2.473678 52.464369,-2.473732 52.464407)",
    "LINESTRING(-2.457175 52.510534,-2.456312 52.51087,-2.45619 52.510917,-2.456011 52.510988,-2.455861 52.511048,-2.455756 52.51109,-2.455731 52.511109)",
    "LINESTRING(-2.518319 52.577444,-2.518208 52.577535,-2.518032 52.577597,-2.517232 52.577863,-2.51674 52.578024,-2.516571 52.578088,-2.516489 52.578164,-2.516356 52.578267,-2.5163 52.578304,-2.516133 52.578414,-2.515911 52.578595,-2.515846 52.578648)",
    "LINESTRING(-2.497517 52.560907,-2.497589 52.560937,-2.497794 52.561027,-2.498074 52.561161,-2.498513 52.561426,-2.49877 52.561577,-2.498981 52.561683,-2.499414 52.561923,-2.499551 52.562023,-2.499692 52.562176,-2.499774 52.562338,-2.499914 52.56263,-2.50008 52.562958,-2.500308 52.563461,-2.500415 52.563697)",
    "LINESTRING(-2.600202 52.588818,-2.599984 52.588964,-2.599881 52.58905,-2.599775 52.589104,-2.599548 52.589215,-2.599542 52.589219,-2.599052 52.589451,-2.59847 52.589744,-2.598061 52.589933,-2.597517 52.59018,-2.597069 52.590412,-2.596399 52.590737,-2.596005 52.590942,-2.595702 52.591172,-2.595278 52.591479,-2.594971 52.591716,-2.594324 52.592189,-2.594038 52.592401,-2.593483 52.592668,-2.592961 52.592903,-2.592742 52.593009,-2.59245 52.593148,-2.592205 52.593362,-2.591903 52.593647,-2.591599 52.593929,-2.591221 52.594265,-2.590853 52.594544,-2.590349 52.594841,-2.589792 52.595132,-2.589358 52.595346,-2.588695 52.595666,-2.58789 52.596063,-2.587503 52.596248,-2.587206 52.59639,-2.586929 52.596499,-2.58639 52.596768,-2.585825 52.597044,-2.585507 52.597212,-2.585136 52.597431,-2.584636 52.597744,-2.584113 52.598065,-2.583643 52.598353,-2.583338 52.598545,-2.58302 52.598717,-2.582686 52.5989,-2.582504 52.598987,-2.582322 52.599055,-2.582214 52.599083,-2.581887 52.599137,-2.581618 52.599174,-2.581605 52.599185,-2.5816 52.59919,-2.581574 52.599213,-2.581574 52.599231)",
    "LINESTRING(-2.478365 52.517265,-2.478477 52.517347,-2.478512 52.517372,-2.478895 52.517586,-2.4791 52.517735,-2.479305 52.517896,-2.479507 52.518064,-2.479846 52.518332,-2.480108 52.518545,-2.480699 52.51908,-2.480877 52.519241,-2.480944 52.519297,-2.480997 52.519358,-2.481038 52.519415,-2.48116 52.519651,-2.481163 52.519657,-2.481165 52.519662,-2.4812 52.519808,-2.481269 52.520139,-2.481295 52.520381,-2.481283 52.520579,-2.481261 52.520732,-2.481316 52.520904,-2.481459 52.521127,-2.481552 52.521267,-2.481731 52.521449,-2.481895 52.521618,-2.482215 52.521987,-2.482547 52.522309,-2.483038 52.522747,-2.483544 52.523186,-2.483841 52.523382,-2.484123 52.523534,-2.484448 52.523677,-2.484641 52.523748,-2.485042 52.52389,-2.485233 52.523952,-2.485345 52.523986,-2.485602 52.524068,-2.485927 52.524147,-2.486091 52.524175,-2.486336 52.524205,-2.486547 52.524225,-2.486651 52.524234,-2.486702 52.524243,-2.4868 52.52426,-2.486931 52.524296,-2.487035 52.52434,-2.487168 52.524412,-2.487242 52.524453,-2.487376 52.524546,-2.487449 52.524597,-2.48753 52.524681,-2.4876 52.524761,-2.487704 52.524868,-2.487764 52.524922,-2.487824 52.524976,-2.487943 52.525119,-2.488078 52.525352,-2.488187 52.525735,-2.488216 52.525855,-2.488278 52.526115,-2.488305 52.526239,-2.488385 52.526429,-2.488431 52.5266,-2.488462 52.526735,-2.488512 52.527283,-2.488513 52.527346,-2.488528 52.527418,-2.488559 52.527481,-2.488614 52.527547,-2.488721 52.52762,-2.488857 52.52769,-2.489649 52.528116,-2.490231 52.528454,-2.490491 52.528575,-2.490601 52.528632,-2.490729 52.528709,-2.490812 52.528777,-2.490994 52.528932,-2.491131 52.529129,-2.491132 52.529212,-2.49112 52.529238,-2.491085 52.529304)",
    "LINESTRING(-2.399788 52.170841,-2.39976 52.170875,-2.399673 52.170957,-2.399615 52.170993,-2.399542 52.171029,-2.399324 52.171111,-2.399207 52.171147,-2.39909 52.171183,-2.398828 52.171238,-2.398687 52.171248,-2.398571 52.171249,-2.398435 52.17124,-2.398415 52.171239,-2.39838 52.171242,-2.398299 52.17125,-2.398201 52.171264,-2.398103 52.171311)",
    "LINESTRING(-2.39886 52.194121,-2.398902 52.194016,-2.39878 52.19367,-2.398754 52.193547,-2.398799 52.193432,-2.398894 52.193346,-2.398981 52.193289,-2.399046 52.193265,-2.399249 52.193196,-2.399485 52.193106,-2.399774 52.192991,-2.400075 52.192865,-2.400318 52.192747,-2.40067 52.192582,-2.400878 52.192503,-2.401028 52.192446,-2.40112 52.192388,-2.4012 52.192317,-2.401209 52.192289,-2.40121 52.19225,-2.401165 52.192124,-2.40115 52.192061,-2.401261 52.191423,-2.401298 52.191298,-2.4014 52.19114,-2.401526 52.190955,-2.401612 52.190805,-2.401674 52.190626,-2.401736 52.190451,-2.401787 52.190325,-2.401832 52.190182,-2.401888 52.189919)",
    "LINESTRING(-2.420562 52.189747,-2.420649 52.189755,-2.420904 52.189748,-2.421703 52.189726,-2.421869 52.189701,-2.422065 52.189651,-2.422175 52.18964,-2.422326 52.189643,-2.422433 52.18966,-2.422603 52.189707,-2.422789 52.189736,-2.423127 52.189773,-2.423211 52.189771,-2.423304 52.189737,-2.423401 52.189718,-2.423611 52.189748,-2.423773 52.189749,-2.424169 52.189666,-2.424832 52.189523,-2.424895 52.189492,-2.425031 52.189393,-2.42513 52.189322,-2.425258 52.189185)",
    "LINESTRING(-2.431553 52.211334,-2.431826 52.211228,-2.432062 52.211176,-2.432725 52.21103,-2.432992 52.210966,-2.433262 52.21089,-2.433621 52.210751,-2.433836 52.210616,-2.434025 52.210455,-2.434143 52.210242,-2.434182 52.210042,-2.434238 52.209873,-2.434312 52.209601,-2.43435 52.209277,-2.434391 52.209007,-2.434394 52.208868)",
    "LINESTRING(-2.411074 52.184883,-2.410958 52.184882,-2.410934 52.18488,-2.41067 52.184841,-2.410351 52.184785,-2.410136 52.184761,-2.409997 52.18475,-2.409754 52.184755,-2.409291 52.184788,-2.409123 52.1848,-2.40881 52.184786,-2.408474 52.184759,-2.408347 52.184763,-2.407924 52.184807,-2.407374 52.184865,-2.407051 52.184899,-2.406995 52.184894,-2.406965 52.184885,-2.406892 52.184858,-2.406686 52.184751,-2.406636 52.18473,-2.406583 52.184715,-2.406525 52.184707,-2.405576 52.184658,-2.405101 52.184641,-2.404782 52.184628,-2.404481 52.184626,-2.404104 52.184627,-2.403745 52.184639,-2.403416 52.184676,-2.402704 52.184781)",
    "LINESTRING(-2.411444 52.156441,-2.411417 52.156354,-2.411373 52.156202,-2.411266 52.155878,-2.41114 52.155478,-2.411087 52.155324,-2.41101 52.1551,-2.410884 52.154704,-2.410759 52.154315,-2.41071 52.154107,-2.410674 52.154034,-2.41064 52.153965,-2.410614 52.153891,-2.410553 52.153752,-2.410141 52.153263,-2.40989 52.152986,-2.409609 52.152708,-2.40916 52.152261,-2.409114 52.152257,-2.408964 52.152286,-2.408323 52.152406,-2.408029 52.152462,-2.40781 52.15248,-2.407722 52.152481,-2.40743 52.152473,-2.407093 52.152429,-2.406984 52.152418,-2.406773 52.152362,-2.406536 52.152334,-2.406269 52.152317,-2.406083 52.152324)",
    "LINESTRING(-2.309246 52.321985,-2.30921 52.322046,-2.309069 52.322272,-2.309024 52.322327,-2.30898 52.322338,-2.30896 52.322343,-2.30885 52.322344,-2.308767 52.322364,-2.308753 52.322369)",
    "LINESTRING(-2.317414 52.305071,-2.317354 52.305041,-2.317212 52.30497,-2.317056 52.304907,-2.316933 52.304856,-2.316823 52.304778)",
    "LINESTRING(-2.31162 52.298537,-2.31168 52.298317,-2.311681 52.298306,-2.311717 52.298032,-2.311803 52.297506,-2.311828 52.297403,-2.311885 52.29728,-2.311899 52.297265,-2.311943 52.297213,-2.312097 52.297157,-2.312239 52.297129,-2.312491 52.297101,-2.3128 52.29706,-2.312944 52.297037,-2.313045 52.29702,-2.313186 52.29698,-2.313245 52.296964,-2.313407 52.296912,-2.313418 52.296908,-2.313451 52.296896,-2.313624 52.296829,-2.313666 52.296809,-2.313875 52.296709,-2.314267 52.296499,-2.314505 52.296391,-2.314865 52.29626,-2.315593 52.295989,-2.316099 52.295795,-2.317154 52.295436,-2.317332 52.295378,-2.318137 52.295173,-2.318314 52.29513,-2.319226 52.294921,-2.319938 52.294753,-2.320333 52.29466,-2.320446 52.294633,-2.320696 52.294577,-2.32076 52.294519,-2.32084 52.29447,-2.320946 52.294376,-2.321001 52.294344,-2.321105 52.294315,-2.321169 52.294298,-2.321239 52.294287,-2.321331 52.294279,-2.321476 52.29428,-2.322073 52.294296,-2.322789 52.294317,-2.322742 52.294467,-2.322676 52.294735,-2.322625 52.294996,-2.322596 52.295041,-2.322529 52.295078,-2.322365 52.295129,-2.322313 52.295156,-2.322284 52.295221,-2.322259 52.29536,-2.322265 52.295417)",
    "LINESTRING(-2.303381 52.282977,-2.303361 52.28292,-2.303334 52.282843,-2.303301 52.282764,-2.303278 52.282705,-2.303027 52.282448,-2.302958 52.282307,-2.302958 52.282251,-2.302958 52.282236)",
    "LINESTRING(-2.330317 52.266892,-2.330322 52.266946,-2.330326 52.266989,-2.330319 52.267158,-2.330317 52.267329,-2.330291 52.267437,-2.330195 52.267845)",
    "LINESTRING(-2.325552 52.324293,-2.325676 52.32429,-2.325721 52.324308,-2.325775 52.32433,-2.325834 52.324354,-2.326184 52.324634,-2.326472 52.324866,-2.32673 52.325073,-2.326893 52.325203,-2.327011 52.325296,-2.327231 52.325463)",
    "LINESTRING(-2.394535 52.321592,-2.394659 52.321506,-2.394904 52.321359,-2.395022 52.321287,-2.395179 52.321211,-2.39532 52.321134,-2.395429 52.321062,-2.39552 52.320986,-2.395648 52.32088,-2.395753 52.320779,-2.395813 52.320708,-2.395856 52.320643,-2.395939 52.3205,-2.396028 52.320348,-2.396095 52.320239,-2.396155 52.320159,-2.396269 52.320018,-2.39646 52.319815,-2.396568 52.319689,-2.396723 52.319489,-2.396904 52.319268,-2.397038 52.31913,-2.397126 52.319043,-2.397219 52.318972,-2.397266 52.318946,-2.397317 52.318896,-2.397368 52.318846,-2.397393 52.318803,-2.397433 52.318728,-2.397467 52.318668,-2.397516 52.318602,-2.39758 52.318536,-2.397689 52.318435,-2.397794 52.318348,-2.397905 52.318255,-2.398077 52.318125,-2.398168 52.31805,-2.398217 52.317987,-2.39824 52.317925,-2.398252 52.317882,-2.398254 52.317838)",
    "LINESTRING(-2.378569 52.312133,-2.37857 52.312127,-2.378321 52.311753,-2.3781 52.311421)",
    "LINESTRING(-2.367521 52.286345,-2.367594 52.286291,-2.367984 52.286161,-2.368477 52.286025,-2.368881 52.285927,-2.36908 52.285878,-2.369367 52.285843,-2.369432 52.285834,-2.369552 52.285818,-2.369669 52.285802,-2.369818 52.285757,-2.369894 52.285715,-2.370197 52.285531,-2.370559 52.285294,-2.37092 52.285059,-2.372029 52.284362,-2.372119 52.284306,-2.372218 52.284251,-2.37247 52.284157,-2.372648 52.284069,-2.372718 52.284018,-2.372749 52.283955,-2.372772 52.283858,-2.372733 52.283773,-2.372691 52.283642,-2.372643 52.283484,-2.372621 52.283362,-2.372615 52.283303,-2.372626 52.283207,-2.372652 52.283134,-2.372753 52.282962,-2.372846 52.282879,-2.37293 52.282811,-2.373244 52.282583,-2.37328 52.282551,-2.373543 52.282366,-2.373753 52.282222,-2.374052 52.282024,-2.374299 52.281847,-2.374437 52.281744,-2.374638 52.281589,-2.374835 52.281434,-2.37505 52.281274,-2.37517 52.281179,-2.375292 52.281104,-2.375429 52.281011,-2.375717 52.280825,-2.37583 52.280752,-2.375883 52.280713,-2.375901 52.280687,-2.375908 52.280641,-2.375943 52.280465,-2.375969 52.280312,-2.375983 52.28013,-2.375997 52.280043,-2.376011 52.279916,-2.376028 52.279736,-2.376029 52.279554,-2.376028 52.279374,-2.376055 52.27919,-2.376091 52.279008,-2.37611 52.278827,-2.376143 52.278646,-2.376142 52.278524,-2.376117 52.278402,-2.376085 52.278261,-2.376002 52.278084,-2.375937 52.277952,-2.375879 52.277791,-2.375869 52.277657)",
    "LINESTRING(-2.356828 52.29325,-2.35674 52.292996,-2.356687 52.292818,-2.356655 52.292763,-2.356609 52.292711,-2.356551 52.292684,-2.35648 52.29268,-2.356456 52.292684,-2.356274 52.292712,-2.356212 52.292719,-2.356141 52.292727,-2.356016 52.292741,-2.355927 52.292741,-2.355848 52.292741,-2.355743 52.292732,-2.355719 52.29273,-2.355703 52.292726,-2.355544 52.292691,-2.355469 52.292682,-2.355305 52.292664,-2.355283 52.292661,-2.355196 52.292648,-2.355177 52.29265,-2.355073 52.292657,-2.354956 52.292666,-2.35483 52.292723,-2.354682 52.292809,-2.354512 52.29291,-2.354314 52.292985,-2.35412 52.293026,-2.354027 52.293038)",
    "LINESTRING(-2.439742 52.273662,-2.439487 52.27359,-2.439344 52.273597,-2.439059 52.273611,-2.43898 52.273595,-2.43881 52.273451)",
    "LINESTRING(-2.386295 52.272591,-2.386277 52.272551,-2.386273 52.272507,-2.386273 52.272447,-2.386275 52.272432,-2.386278 52.272384,-2.386279 52.272367,-2.386284 52.272356,-2.386302 52.272316,-2.386322 52.272286,-2.38633 52.272274,-2.386347 52.272262,-2.386366 52.27225,-2.386368 52.272248,-2.386451 52.272216,-2.386781 52.272128,-2.386868 52.272101,-2.386905 52.272065,-2.386904 52.272017,-2.386883 52.271978,-2.386829 52.271926,-2.386761 52.271888,-2.386644 52.271853,-2.386502 52.27183,-2.386391 52.271819,-2.386275 52.271812,-2.386211 52.271794,-2.386207 52.27179,-2.386187 52.271768,-2.386193 52.271714,-2.386224 52.271702,-2.386245 52.271693,-2.386256 52.271689,-2.386336 52.271687,-2.386393 52.271685,-2.386579 52.27167,-2.386619 52.271665,-2.386721 52.271652,-2.386799 52.271643,-2.386816 52.271638,-2.386953 52.271599,-2.387064 52.271552,-2.38708 52.271546,-2.387114 52.271521,-2.387193 52.271465,-2.387434 52.271266,-2.387709 52.271054,-2.387859 52.270946,-2.388003 52.270832,-2.388051 52.270783,-2.388095 52.270737,-2.388136 52.270666,-2.388156 52.27053,-2.388171 52.27044,-2.388222 52.270343,-2.38829 52.270248,-2.388348 52.270213,-2.388433 52.270189,-2.388543 52.270166,-2.388775 52.270123,-2.388964 52.270083,-2.389059 52.270051,-2.38919 52.270002,-2.389295 52.269948,-2.389399 52.269881,-2.389458 52.269828,-2.389488 52.269756,-2.389557 52.269482,-2.389596 52.269274,-2.389609 52.269022,-2.389622 52.268896,-2.389692 52.268518,-2.389749 52.268374,-2.389778 52.268329,-2.389863 52.268272,-2.390046 52.268158,-2.390356 52.267968,-2.390702 52.26776,-2.390886 52.267669,-2.390974 52.267633,-2.391061 52.267605,-2.39112 52.267596,-2.391247 52.267581,-2.39153 52.267568,-2.391603 52.267559,-2.391706 52.267517,-2.391771 52.267474,-2.391774 52.267472,-2.391775 52.267471,-2.391863 52.267381,-2.391962 52.267263,-2.392009 52.267172,-2.39204 52.267074,-2.39206 52.266964,-2.392102 52.266757,-2.392115 52.266694,-2.392193 52.266545,-2.392282 52.266434,-2.39236 52.266357,-2.39245 52.266303,-2.392565 52.266261,-2.392723 52.266231,-2.392901 52.266206,-2.393029 52.266188,-2.393073 52.266175,-2.39316 52.266149,-2.393313 52.26609,-2.393392 52.266044,-2.393453 52.266005,-2.393627 52.265865,-2.393811 52.265725,-2.393847 52.265679,-2.393852 52.265637,-2.393825 52.265578,-2.393745 52.265507,-2.393448 52.265288,-2.393385 52.265244,-2.393161 52.265087,-2.393002 52.264965,-2.392901 52.264891)",
    "LINESTRING(-2.413413 52.258694,-2.413538 52.259264,-2.41355 52.259313,-2.413676 52.259883,-2.413779 52.260331,-2.413839 52.260595,-2.413895 52.260804,-2.413933 52.261004,-2.413968 52.261134,-2.414015 52.261357,-2.41411 52.26167,-2.414162 52.261798,-2.414221 52.261889,-2.414317 52.261954,-2.414454 52.261996,-2.414872 52.262069,-2.415052 52.26213,-2.415116 52.262207,-2.415148 52.262318,-2.415124 52.262503,-2.415013 52.262875,-2.414913 52.263165,-2.414805 52.263391,-2.414465 52.263742,-2.414041 52.264168,-2.413843 52.264367,-2.413608 52.264517,-2.413418 52.264593,-2.41315 52.264649,-2.412802 52.264738,-2.412492 52.264842,-2.412056 52.265013,-2.411777 52.265105,-2.41154 52.265151,-2.411298 52.265155,-2.411154 52.265137,-2.410854 52.2651,-2.410463 52.265056)",
    "LINESTRING(-2.422179 52.250591,-2.422229 52.25056,-2.422258 52.250542,-2.422404 52.250506,-2.422448 52.250479,-2.422506 52.250406,-2.422598 52.25024)",
    "LINESTRING(-2.304096 52.38383,-2.304311 52.383709,-2.304375 52.383673,-2.304741 52.383474)",
    "LINESTRING(-2.311777 52.355598,-2.311908 52.355533,-2.312027 52.355479,-2.311996 52.355417,-2.311862 52.355242,-2.311751 52.355094,-2.311715 52.35494,-2.311647 52.354695,-2.311602 52.354528,-2.311601 52.354461,-2.3116 52.354326,-2.311555 52.35417,-2.311489 52.354145,-2.311335 52.354178,-2.311181 52.354211,-2.31102 52.354269,-2.310948 52.354295,-2.310895 52.354314,-2.310667 52.354401)",
    "LINESTRING(-2.310861 52.374127,-2.310797 52.374063,-2.310739 52.374022,-2.310657 52.373964,-2.310579 52.373921)",
    "LINESTRING(-2.331681 52.351268,-2.331968 52.351174,-2.332394 52.351032,-2.332727 52.350926,-2.333121 52.3508,-2.333336 52.350697,-2.333535 52.350572,-2.333728 52.350421,-2.33399 52.350216,-2.334129 52.350094,-2.334252 52.349977,-2.334333 52.349867,-2.334419 52.349752,-2.334485 52.349592,-2.334495 52.349413,-2.334456 52.349228,-2.334372 52.348983,-2.334323 52.348821,-2.334316 52.348799)",
    "LINESTRING(-2.328113 52.34744,-2.328381 52.347429,-2.328637 52.347401,-2.328936 52.347357,-2.329147 52.347329,-2.32934 52.347286,-2.32945 52.347264,-2.329714 52.347204,-2.329903 52.347157,-2.330088 52.347111,-2.330303 52.347075,-2.330413 52.347035,-2.330616 52.346951)",
    "LINESTRING(-2.377692 52.403371,-2.377783 52.403294,-2.377821 52.403256,-2.377923 52.40318,-2.378179 52.402998,-2.378403 52.402832,-2.37892 52.402432,-2.379181 52.40224,-2.379405 52.402124,-2.379934 52.40181,-2.38016 52.401672,-2.380332 52.401507,-2.380498 52.401279,-2.380777 52.400857,-2.380868 52.400761,-2.38108 52.400531,-2.381152 52.400413,-2.381184 52.400297,-2.381217 52.400057,-2.381256 52.399866,-2.381298 52.399733,-2.381373 52.39961,-2.381469 52.399356,-2.381489 52.399177,-2.381495 52.398913,-2.381469 52.398764,-2.381359 52.398634,-2.381155 52.398507,-2.381016 52.398461,-2.380878 52.398423,-2.38062 52.398386,-2.380386 52.398338,-2.380169 52.398274,-2.380085 52.398228,-2.379902 52.398126,-2.379793 52.398048,-2.379716 52.397953,-2.379691 52.397856,-2.379723 52.397749,-2.379781 52.397586,-2.379801 52.39745,-2.379787 52.397334,-2.379669 52.397187,-2.379388 52.396965,-2.37896 52.39669,-2.378453 52.396307,-2.378046 52.395955,-2.377357 52.395277,-2.377302 52.395176,-2.3772 52.394948,-2.377105 52.394613,-2.376996 52.394229,-2.376749 52.393658,-2.376667 52.393464,-2.37645 52.392901,-2.37639 52.392785,-2.375713 52.391955,-2.375234 52.391356,-2.375004 52.391043,-2.374907 52.390855,-2.374914 52.390767,-2.374988 52.390534,-2.375028 52.390408,-2.375047 52.390376,-2.375212 52.390101,-2.375258 52.389951,-2.375276 52.389892,-2.375314 52.389655,-2.375315 52.389636,-2.375321 52.389509,-2.375321 52.389505,-2.375438 52.389241,-2.375754 52.388654,-2.375912 52.388359,-2.375976 52.388178,-2.37602 52.388052,-2.375996 52.387924,-2.375716 52.387478,-2.375151 52.386671,-2.374893 52.386348,-2.374724 52.386148,-2.374601 52.38596,-2.374589 52.385941,-2.374556 52.385827,-2.374571 52.385719,-2.374616 52.385639,-2.374694 52.385554,-2.374796 52.385442,-2.374826 52.38541,-2.375082 52.385237,-2.375492 52.385069,-2.375811 52.384952,-2.376154 52.384779,-2.376547 52.384534,-2.376794 52.384354,-2.377111 52.384089,-2.377263 52.38397,-2.377377 52.38388,-2.377532 52.383758,-2.377707 52.383613)",
    "LINESTRING(-2.41285 52.381728,-2.41263 52.381673,-2.412534 52.38165,-2.412416 52.381631,-2.412314 52.381609,-2.412146 52.381574,-2.41204 52.381558,-2.411958 52.381553,-2.411908 52.381559,-2.411769 52.381592,-2.411629 52.38164,-2.411416 52.381728,-2.41137 52.381751,-2.411362 52.381755)",
    "LINESTRING(-2.32153 52.435879,-2.321434 52.435843,-2.321169 52.435748,-2.321029 52.435692,-2.320891 52.435624,-2.320814 52.435544,-2.320789 52.435454,-2.320686 52.43505,-2.320678 52.435016,-2.320697 52.434978,-2.3207 52.434977,-2.320741 52.434964,-2.320807 52.434964,-2.320847 52.434986,-2.320903 52.435022,-2.32098 52.435044,-2.32112 52.435084,-2.321164 52.435095,-2.321305 52.435128,-2.321308 52.435129,-2.321397 52.435165,-2.321537 52.435254,-2.321663 52.435362,-2.321808 52.435503,-2.321811 52.435518,-2.321824 52.43558,-2.321813 52.435716,-2.321777 52.435796,-2.321718 52.435883,-2.321666 52.43593)",
    "LINESTRING(-2.307716 52.425456,-2.307818 52.425431,-2.307876 52.425407,-2.307913 52.425393,-2.307955 52.425381,-2.307993 52.425377,-2.308035 52.42538,-2.308086 52.425401,-2.308219 52.425445,-2.308331 52.425485,-2.308463 52.425511,-2.308596 52.425534,-2.308714 52.425547,-2.308825 52.425552,-2.309022 52.425546,-2.309125 52.425533,-2.309161 52.425522,-2.309213 52.425506,-2.309219 52.425501,-2.309245 52.425482,-2.309286 52.425452,-2.309447 52.425307,-2.309696 52.425131,-2.309799 52.425067,-2.310109 52.424883,-2.310276 52.424771,-2.310451 52.424658,-2.310519 52.424607,-2.310586 52.424531,-2.310665 52.42442,-2.310708 52.424391)",
    "LINESTRING(-2.368821 52.479672,-2.368718 52.479668,-2.368563 52.479662,-2.368422 52.479647,-2.368321 52.479625,-2.368055 52.479535,-2.367906 52.479453,-2.367768 52.479353,-2.367678 52.479272)",
    "LINESTRING(-2.356756 52.456904,-2.3567 52.456817,-2.356403 52.456452,-2.356335 52.456374,-2.356182 52.456224,-2.356001 52.456019,-2.355913 52.455933,-2.355897 52.455925,-2.355889 52.455921,-2.35586 52.455907,-2.355792 52.455906)",
    "LINESTRING(-2.351301 52.457594,-2.351243 52.457599,-2.351081 52.457613,-2.350831 52.457667,-2.350523 52.457776,-2.350141 52.457939,-2.350024 52.458003)",
    "LINESTRING(-2.351553 52.453669,-2.351661 52.453639,-2.351911 52.453547,-2.352488 52.453293,-2.352981 52.453076,-2.353348 52.452904,-2.353436 52.452854)",
    "LINESTRING(-2.358583 52.43464,-2.358485 52.434675,-2.358283 52.434761,-2.358063 52.434905,-2.357924 52.434996,-2.357888 52.435043,-2.357871 52.435063,-2.357815 52.435066,-2.357731 52.435058,-2.357557 52.435069,-2.357033 52.435113,-2.356814 52.43513,-2.356696 52.435121,-2.356544 52.435094,-2.356379 52.435059,-2.356325 52.435055,-2.356269 52.435064,-2.355794 52.435249)",
    "LINESTRING(-2.36948 52.442856,-2.369591 52.442905,-2.369678 52.442964,-2.369829 52.443057,-2.36992 52.443113,-2.370008 52.443155,-2.370101 52.443184,-2.37022 52.443212)",
    "LINESTRING(-2.378203 52.420339,-2.377907 52.420588,-2.377812 52.420689,-2.377747 52.420784,-2.377636 52.420949,-2.377438 52.421253,-2.37723 52.421596,-2.377145 52.421741,-2.377032 52.421894,-2.37695 52.421998,-2.37685 52.422099,-2.376733 52.42218,-2.376585 52.422267,-2.376382 52.422369,-2.376173 52.422464,-2.376015 52.422525,-2.375777 52.422613,-2.375539 52.422702,-2.375192 52.422816,-2.374837 52.422933,-2.374674 52.422981,-2.374571 52.423022,-2.374448 52.423075,-2.374379 52.423108,-2.374324 52.423142,-2.374227 52.423211,-2.374132 52.42328,-2.37405 52.423355,-2.373964 52.423444,-2.373799 52.423653,-2.373586 52.423942,-2.373383 52.424274,-2.373231 52.424506,-2.373167 52.424614,-2.373126 52.424671,-2.373096 52.424694,-2.373001 52.424733,-2.372757 52.424811,-2.372453 52.42491,-2.372215 52.424983,-2.371593 52.425148,-2.371186 52.425256,-2.371087 52.425292,-2.370841 52.425377,-2.370665 52.425442,-2.370489 52.425505,-2.370155 52.425593,-2.369952 52.425637,-2.369691 52.425684,-2.369177 52.425766,-2.368982 52.425788,-2.368642 52.425837,-2.368614 52.425842,-2.368611 52.425842,-2.368609 52.425843,-2.368465 52.42587,-2.368347 52.425896,-2.368256 52.425948,-2.368198 52.425992,-2.368112 52.426089,-2.367959 52.42626,-2.367834 52.426413,-2.3677 52.426546,-2.367614 52.426657,-2.36759 52.426744,-2.367598 52.426837,-2.367632 52.426944,-2.367705 52.427086)",
    "LINESTRING(-2.430145 52.497136,-2.429921 52.496968,-2.42984 52.49691,-2.429772 52.496859,-2.429759 52.496849,-2.429681 52.496802,-2.429674 52.496798,-2.429601 52.49676,-2.429592 52.496755,-2.429577 52.49675,-2.429452 52.496705,-2.429156 52.496622,-2.428936 52.496571,-2.428713 52.496519,-2.428662 52.496509,-2.42838 52.496451,-2.428278 52.49643,-2.427906 52.496362,-2.427796 52.496359,-2.427692 52.496374,-2.427614 52.496413,-2.427594 52.496423,-2.427497 52.496563,-2.427473 52.496604,-2.427424 52.496683,-2.427409 52.496697,-2.427333 52.496767,-2.427313 52.496788,-2.427262 52.496844,-2.427253 52.496852,-2.427253 52.496854,-2.42723 52.496909,-2.427251 52.496965,-2.42727 52.497014,-2.427279 52.497085,-2.427279 52.497097,-2.427274 52.497153,-2.427272 52.497192,-2.427256 52.497239,-2.427248 52.497264,-2.427249 52.497297,-2.427262 52.497316,-2.427274 52.497333,-2.427276 52.497335,-2.427375 52.497409,-2.427536 52.497534,-2.427549 52.497543,-2.427734 52.497685,-2.427863 52.497795,-2.427899 52.49783,-2.427971 52.497897,-2.428166 52.498061,-2.428402 52.498242,-2.428577 52.498372,-2.428759 52.498507,-2.428938 52.498655,-2.429307 52.498971,-2.42952 52.49917,-2.429637 52.499279,-2.429907 52.499533,-2.430107 52.499708,-2.43019 52.499779,-2.430309 52.499887,-2.430347 52.499938,-2.430354 52.499947,-2.430396 52.500005,-2.430403 52.500067,-2.430403 52.50013,-2.430396 52.500164,-2.430395 52.500168,-2.430384 52.500186,-2.430342 52.500254,-2.430222 52.500419,-2.430129 52.500571,-2.430049 52.500741)",
    "LINESTRING(-2.384219 52.482371,-2.384296 52.482448,-2.384358 52.482546,-2.38439 52.482628,-2.384477 52.482964,-2.38456 52.48325,-2.384633 52.48332,-2.384683 52.483336,-2.385527 52.483375,-2.386516 52.483431,-2.386754 52.483455,-2.386904 52.483491,-2.386908 52.483492,-2.38696 52.48351,-2.387116 52.483564,-2.387205 52.483599,-2.387258 52.48362,-2.387266 52.483624,-2.387373 52.483676,-2.3874 52.483699,-2.387405 52.483732,-2.387404 52.483741,-2.387401 52.483772,-2.387188 52.484013,-2.387151 52.484063,-2.387135 52.484117,-2.387132 52.484128,-2.387132 52.484135,-2.387133 52.484219,-2.387128 52.484283,-2.387116 52.484454,-2.387105 52.484566,-2.387079 52.484639,-2.387041 52.484709,-2.386988 52.484814,-2.386922 52.484945,-2.386917 52.484955,-2.386797 52.485264,-2.386765 52.485391,-2.386753 52.485438,-2.386725 52.485502,-2.386614 52.485766,-2.386546 52.485953,-2.38654 52.485983)",
    "LINESTRING(-2.409893 52.500854,-2.409695 52.500838,-2.409501 52.500821,-2.409485 52.500817,-2.40946 52.500811,-2.40945 52.500808,-2.409439 52.500768,-2.409456 52.500683,-2.409462 52.500587,-2.409477 52.500532,-2.409451 52.500492,-2.409392 52.500465,-2.409194 52.500421,-2.409173 52.500406,-2.409139 52.500381,-2.409116 52.500337,-2.409098 52.500304,-2.409093 52.500125,-2.40903 52.499999,-2.408956 52.49991,-2.408952 52.499905,-2.408935 52.499891,-2.408772 52.499757,-2.408677 52.499692,-2.408658 52.499679,-2.408632 52.499667,-2.408306 52.499518,-2.408293 52.499507,-2.408247 52.499467,-2.408236 52.499458,-2.408234 52.49945,-2.408202 52.499331,-2.408205 52.499195,-2.408133 52.498988,-2.408037 52.498857,-2.407772 52.49855,-2.407591 52.498335,-2.407348 52.498142,-2.407131 52.497985,-2.407067 52.497943,-2.406992 52.497894,-2.406829 52.497786,-2.406808 52.497772,-2.406522 52.497612,-2.406495 52.497602,-2.406233 52.497495,-2.406027 52.497414,-2.405534 52.497297,-2.405457 52.497278,-2.404824 52.497124,-2.403814 52.496815,-2.40333 52.496679,-2.403133 52.496635,-2.40265 52.496552,-2.401894 52.496427,-2.401568 52.496373,-2.400958 52.496297,-2.40045 52.496245,-2.400184 52.496219,-2.400092 52.496211,-2.400034 52.496193,-2.399953 52.496147,-2.39985 52.496033,-2.399776 52.495956)",
    "LINESTRING(-2.358014 52.492146,-2.358028 52.492193,-2.358029 52.492234,-2.35786 52.492818,-2.357794 52.493046,-2.357747 52.493245,-2.357732 52.493321)",
    "LINESTRING(-2.345449 52.467635,-2.345714 52.467635,-2.345802 52.467634,-2.345964 52.467634,-2.346156 52.467651,-2.346421 52.467677,-2.34648 52.467686,-2.346554 52.467713,-2.346687 52.467758,-2.34688 52.467846,-2.347019 52.467912,-2.347165 52.467976,-2.347251 52.468013,-2.347374 52.468089,-2.347533 52.468179,-2.347609 52.468222,-2.347754 52.468317,-2.347802 52.468356,-2.34787 52.468446,-2.347959 52.468599,-2.348004 52.468716,-2.348034 52.468787,-2.348168 52.46894,-2.348276 52.469186,-2.348332 52.469236)",
    "LINESTRING(-2.304184 52.534293,-2.304229 52.534219,-2.304246 52.53395,-2.304293 52.533323,-2.304343 52.532656,-2.304409 52.531983,-2.304495 52.531339,-2.304623 52.53067,-2.304758 52.530145,-2.304946 52.529717,-2.304941 52.529607)",
    "LINESTRING(-2.404084 52.529404,-2.404094 52.529399,-2.404103 52.529392,-2.40411 52.529384,-2.404115 52.529376,-2.404118 52.529367,-2.404119 52.529358,-2.404118 52.529349,-2.404115 52.529341,-2.40411 52.529332,-2.404102 52.529325,-2.404093 52.529318,-2.404082 52.529312,-2.40407 52.529307,-2.404057 52.529303,-2.404043 52.529301,-2.404029 52.529299,-2.404014 52.529299,-2.404 52.529301,-2.403986 52.529303,-2.403973 52.529307,-2.403961 52.529312,-2.40395 52.529318,-2.403941 52.529325,-2.403934 52.529333,-2.403929 52.529341,-2.403926 52.52935,-2.403925 52.529359,-2.403926 52.529368,-2.403929 52.529376,-2.403935 52.529385,-2.403942 52.529392,-2.403951 52.529399,-2.403962 52.529405,-2.403974 52.52941,-2.403987 52.529414,-2.404001 52.529416,-2.404015 52.529418,-2.40403 52.529418,-2.404044 52.529416,-2.404058 52.529414,-2.404071 52.52941,-2.404083 52.529405,-2.404084 52.529404)"
    };

    static double expectations[][4] =
    {
    { 3.41515232094025E-07, 3.42522426421965E-07, 6.83030293657794E-07, 6.87058957282716E-07},
    { 1.02802331980456E-07, 1.03813675877973E-07, 2.05604735015186E-07, 2.09650025340125E-07},
    { 3.56112451527224E-07, 3.57098969061553E-07, 7.12224860421884E-07, 7.16171342673988E-07},
    { 4.25305444196056E-08, 4.35412488286602E-08, 8.50612309477583E-08, 8.91039491079937E-08},
    { 3.69520876120077E-08, 3.79614419898644E-08, 7.39041894348702E-08, 7.79416069462968E-08},
    { 3.12580681338659E-08, 3.22376649819489E-08, 6.23702476332255E-08, 6.62886350255576E-08},
    { 2.64535032101776E-07, 2.65503302898651E-07, 5.29010577565714E-07, 5.32883049686461E-07},
    { 1.26452604831684E-07, 1.27462314480908E-07, 2.52905124398239E-07, 2.56944261423087E-07},
    { 5.62396706982327E-08, 5.7239461170866E-08, 1.12479426661594E-07, 1.16478773293238E-07},
    { 7.03945403301987E-07, 7.04847309407342E-07, 1.40789144609244E-06, 1.41149810417573E-06},
    { 2.05895901217446E-07, 2.06897283305807E-07, 4.11792029808566E-07, 4.15797074992952E-07},
    { 1.01571146160495E-07, 1.02582319527755E-07, 2.031423207427E-07, 2.07186729994646E-07},
    { 2.42559636376427E-07, 2.43568607061206E-07, 4.85119102222598E-07, 4.89155340233083E-07},
    { 3.41515232094025E-07, 3.42522426421965E-07, 6.83030293657794E-07, 6.87058957282716E-07},
    { 9.08697614931953E-08, 9.1881105390712E-08, 1.81739480353826E-07, 1.85784855943893E-07},
    { 6.0466163631645E-08, 6.14741111348849E-08, 1.20932355684999E-07, 1.24964373071634E-07},
    { 4.04659118657946E-07, 4.05667066161186E-07, 8.09318166261619E-07, 8.13350311545946E-07},
    { 4.80904560618001E-07, 4.81905772176106E-07, 9.61808808597198E-07, 9.65813697462181E-07},
    { 3.57066625156222E-08, 3.67177221960446E-08, 7.14132681878255E-08, 7.54576063854984E-08},
    { 2.44433664420285E-08, 2.54509160413363E-08, 4.88867044623476E-08, 5.29170023355618E-08},
    { 3.61392153536144E-07, 3.62384142249539E-07, 7.22784136542032E-07, 7.26752162449884E-07},
    { 7.03945403301987E-07, 7.04847309407342E-07, 1.40789144609244E-06, 1.41149810417573E-06},
    { 7.91276917766481E-07, 7.91866199278957E-07, 1.58255338078561E-06, 1.58491059210064E-06},
    { 2.80934472129957E-07, 2.81945006008755E-07, 5.61869072157606E-07, 5.65911307148781E-07},
    { 3.5339049020422E-07, 3.54394444457284E-07, 7.06780582504507E-07, 7.10797138481212E-07},
    { 2.44327040377357E-07, 2.4533331099974E-07, 4.88653867591893E-07, 4.9267929114194E-07},
    { 2.6145809783884E-07, 2.62465945866097E-07, 5.22915939882296E-07, 5.26947090406793E-07},
    { 2.21305654690696E-07, 2.22233921931547E-07, 4.42615530005241E-07, 4.46329210035401E-07},
    { 7.88202072499189E-08, 7.98287089764926E-08, 1.5764054239753E-07, 1.61674222454167E-07},
    { 4.08582224054044E-07, 4.09593170047629E-07, 8.17164746536037E-07, 8.21208203660717E-07},
    { 2.61692591152496E-07, 2.62703764519756E-07, 5.23385125461573E-07, 5.27429577346084E-07},
    { 2.01361032736713E-07, 2.0236487330294E-07, 4.02722207581974E-07, 4.06737527214318E-07},
    { 6.18118889406105E-08, 6.28143510539303E-08, 1.23623692616093E-07, 1.27633413171679E-07},
    { 5.01939382502314E-07, 5.02932437029813E-07, 1.00387870816121E-06, 1.00785118206659E-06},
    { 6.52623768360172E-07, 6.53615401802199E-07, 1.30525545216642E-06, 1.30922269647726E-06},
    { 3.24414514807359E-07, 3.25418923807774E-07, 6.48829413307794E-07, 6.52846509296978E-07},
    { 1.65468009072356E-07, 1.66476610274913E-07, 3.30936202885823E-07, 3.34970451376648E-07},
    { 5.23240828442795E-09, 6.24356744083343E-09, 1.04648165688559E-08, 1.45333485717657E-08},
    { 3.62318644420156E-07, 3.63320253882193E-07, 7.24637303051168E-07, 7.28643442471366E-07},
    { 5.94340193060816E-07, 5.95350627463631E-07, 1.18868054244103E-06, 1.19272210952204E-06},
    { 7.32884174681203E-07, 7.33866755808776E-07, 1.46576839199497E-06, 1.46969848913159E-06},
    { 3.02247087802243E-07, 3.0325044519941E-07, 6.04493862965683E-07, 6.08507960464522E-07},
    { 3.23513106081919E-07, 3.24517259286949E-07, 6.47026212163837E-07, 6.51042981303362E-07},
    { 2.82636392512359E-07, 2.83643203147221E-07, 5.65272713970444E-07, 5.6930015546186E-07},
    { 5.57109984811177E-08, 5.67222713243609E-08, 1.11422096438218E-07, 1.15467202022046E-07},
    { 1.69497056390355E-07, 1.70405499488879E-07, 3.38994169624129E-07, 3.42627942018225E-07},
    { 4.37937046626757E-08, 4.4801083731727E-08, 8.75873382710779E-08, 9.16166129627527E-08},
    { 3.69329029581422E-08, 3.79310165499192E-08, 7.38645837827789E-08, 7.78570665715961E-08},
    { 5.61418005418091E-08, 5.71532154935994E-08, 1.12283629505328E-07, 1.16328905619412E-07},
    { 2.30063292860905E-07, 2.31069662959271E-07, 4.60126457824117E-07, 4.64152151380404E-07},
    { 1.53257730062251E-07, 1.54239160110592E-07, 3.06515318015954E-07, 3.10441222950431E-07},
    { 7.43983150641725E-08, 7.54085220933121E-08, 1.4879661591749E-07, 1.52837202449518E-07},
    { 3.73331090486317E-08, 3.83436145057203E-08, 7.46662180972635E-08, 7.87081404496348E-08},
    { 1.35055771011139E-07, 1.36057437316595E-07, 2.70111300437748E-07, 2.74118391985212E-07},
    { 1.49921490333327E-07, 1.50926723563316E-07, 2.99842824347252E-07, 3.03863657791226E-07},
    { 5.4672608484907E-07, 5.47715472976051E-07, 1.09345225496327E-06, 1.09740931009128E-06},
    { 6.82862975054377E-08, 6.92914738920081E-08, 1.3657287922797E-07, 1.40593087394336E-07},
    { 2.99415603421949E-08, 3.09528473962928E-08, 5.9883106473535E-08, 6.39284820636021E-08},
    { 1.15991221605327E-06, 1.16091044333189E-06, 2.31982436105227E-06, 2.32381808018545E-06},
    { 5.37620522322868E-07, 5.38598712296334E-07, 1.07524111570001E-06, 1.07915387559387E-06},
    { 2.19138769352867E-08, 2.29165522114272E-08, 4.38277680814281E-08, 4.78386539271014E-08},
    { 2.25320761160219E-07, 2.26330556074572E-07, 4.50641536531293E-07, 4.54680815664688E-07},
    { 1.01003628572016E-06, 1.01100829397183E-06, 2.02007224459066E-06, 2.02395995074767E-06},
    { 4.75155772505786E-07, 4.76152848705169E-07, 9.50311530800718E-07, 9.5429980717654E-07},
    { 1.65787653827465E-07, 1.66797761380622E-07, 3.31575222389802E-07, 3.35615951030377E-07},
    { 2.30222070740638E-07, 2.31232661462855E-07, 4.60444127270421E-07, 4.64487072804332E-07},
    { 7.98883817765272E-07, 7.99890472080733E-07, 1.59776760710884E-06, 1.60179418173811E-06},
    { 1.04933420175257E-07, 1.05940515027214E-07, 2.0986679771795E-07, 2.13895532397146E-07},
    { 1.77967848458138E-06, 1.78066323996973E-06, 3.55935688389764E-06, 3.56329583439674E-06},
    { 4.1623603408425E-07, 4.17224313764564E-07, 8.3247203974679E-07, 8.36425286365738E-07},
    { 9.68960307545785E-08, 9.78908332172068E-08, 1.93792118352576E-07, 1.97771228727106E-07},
    { 2.7254995416115E-07, 2.73529721539489E-07, 5.45099553050932E-07, 5.49018324136341E-07},
    { 4.01288005491551E-07, 4.02259715315267E-07, 8.02576039404812E-07, 8.06462495006599E-07},
    { 1.35055771011139E-07, 1.36057437316595E-07, 2.70111300437748E-07, 2.74118391985212E-07},
    { 4.29554916081543E-08, 4.39544862729235E-08, 8.59111395357104E-08, 8.99071466164969E-08},
    { 1.76189836054164E-06, 1.76286511077706E-06, 3.52380727974833E-06, 3.52767503386531E-06},
    { 1.41602981784672E-07, 1.42607618158763E-07, 2.83206148310455E-07, 2.87224651174256E-07},
    { 1.15380575493873E-06, 1.15479357987169E-06, 0.000002307610870389, 2.31156330698923E-06},
    { 1.41356807148441E-07, 1.42356668675347E-07, 2.82713486399189E-07, 2.86713202513056E-07},
    { 6.45327844495114E-08, 6.55440999253187E-08, 1.29065526266459E-07, 1.33110816591397E-07},
    { 6.86342787048488E-08, 6.96456083915109E-08, 1.37268628463971E-07, 1.41313861945491E-07},
    { 1.83265086661777E-07, 1.84274682624164E-07, 3.66530358064665E-07, 3.70568429275409E-07},
    { 1.43990902756741E-07, 1.44994970696644E-07, 2.87981706037499E-07, 2.91998276225058E-07},
    { 1.02871865692578E-07, 1.03880751112229E-07, 2.05743802439429E-07, 2.09779301485469E-07},
    { 1.36728246502571E-07, 1.37673012545747E-07, 2.7345657827027E-07, 2.77235542966991E-07},
    { 3.10800132297118E-07, 3.11808250330614E-07, 6.21600349859364E-07, 6.25632381456853E-07},
    { 1.32283005882528E-07, 1.33261437440524E-07, 2.64565414909157E-07, 2.68479169562852E-07},
    { 3.33188367562798E-07, 3.34195561890738E-07, 6.66376735125596E-07, 6.70405427172227E-07},
    { 1.90134230138028E-07, 1.91139307048616E-07, 3.80268787125715E-07, 3.8428883897268E-07},
    { 3.02247087802243E-07, 3.0325044519941E-07, 6.04493862965683E-07, 6.08507960464522E-07},
    { 6.45327844495114E-08, 6.55440999253187E-08, 1.29065526266459E-07, 1.33110816591397E-07},
    { 4.02965838475211E-08, 4.13054976888816E-08, 8.05931534841875E-08, 8.46289225364671E-08},
    { 5.11229515609557E-07, 5.12224545445861E-07, 1.02245836330894E-06, 1.02643905108835E-06},
    { 1.18189390718726E-07, 1.19196172931879E-07, 2.36378838280871E-07, 2.40405839235791E-07},
    { 3.81603527443986E-07, 3.82614828708938E-07, 7.63207339105065E-07, 7.67251918887268E-07},
    { 3.34147500780091E-08, 3.43787576184695E-08, 6.67881465687969E-08, 7.06435514530313E-08},
    { 3.4107115709503E-07, 3.42081634130409E-07, 6.82142385244333E-07, 6.86184307596704E-07},
    { 1.58899425173331E-07, 1.59907060037767E-07, 3.17798821924953E-07, 3.21829773497484E-07},
    { 5.36395234007614E-07, 5.37394143407255E-07, 1.07279079486489E-06, 1.07678548033618E-06},
    { 3.9406657492691E-07, 3.95064475355866E-07, 7.88133220908094E-07, 7.92124779991354E-07},
    { 2.77072558674263E-07, 2.78073869708351E-07, 5.54145316300492E-07, 5.58150745177954E-07},
    { 3.93172285839682E-07, 3.94176680629243E-07, 7.8634455746851E-07, 7.90362207681028E-07},
    { 2.85718613213248E-07, 2.86716215214256E-07, 5.71436899576838E-07, 5.75428146021295E-07},
    { 1.26677917933193E-07, 1.27688309703444E-07, 2.5335566533613E-07, 2.57397502423373E-07},
    { 8.70625598281549E-08, 8.80735200325944E-08, 1.74125048602036E-07, 1.7816884678723E-07},
    { 9.37471753559294E-08, 9.47451752608686E-08, 1.87494393344423E-07, 1.91486549283582E-07},
    { 3.30706200202258E-08, 3.40820349720161E-08, 6.61412968838704E-08, 7.01866440522281E-08},
    { 9.30588299752344E-08, 9.40660100923196E-08, 1.86117645739614E-07, 1.90146408840519E-07},
    { 3.83720646368602E-08, 3.9382058503179E-08, 7.67441576954297E-08, 8.07838489436108E-08},
    { 3.12277990133225E-07, 3.13278405883466E-07, 6.2455600868816E-07, 6.28557373261174E-07},
    { 2.62851173715717E-07, 2.63860243876479E-07, 5.25702404274853E-07, 5.29738812815594E-07},
    { 6.38404742403509E-08, 6.48505391609433E-08, 1.27680962691556E-07, 1.3172102342196E-07},
    { 7.73673903609051E-07, 7.74670056102877E-07, 1.54734770774212E-06, 1.55133201928948E-06},
    { 2.23658261688797E-07, 2.24661988568187E-07, 4.47316281793064E-07, 4.51331573003699E-07},
    { 3.18664490350784E-07, 3.19664522407948E-07, 6.37329037544987E-07, 6.41328341544067E-07},
    { 6.28178327133355E-08, 6.38285229115354E-08, 1.25635679637526E-07, 1.29678596749727E-07},
    { 2.14196546721723E-07, 2.15193523445123E-07, 4.28392880280626E-07, 4.32381142445593E-07},
    { 2.53436667208007E-08, 2.63544563949836E-08, 5.06872623873278E-08, 5.47306626685895E-08},
    { 1.79067058070359E-07, 1.80076483502489E-07, 3.58134101929863E-07, 3.62171505230435E-07},
    { 1.14243619009358E-08, 1.24315846505851E-08, 2.28486385367432E-08, 2.69068462005454E-08},
    { 1.62669806513804E-08, 1.72783103380425E-08, 3.25339186701967E-08, 3.65793084711186E-08},
    { 2.55726050113481E-07, 2.56733443393387E-07, 5.11451958118414E-07, 5.15481701768294E-07},
    { 6.74249776011493E-08, 6.84268144368616E-08, 1.34849770461187E-07, 1.38856961484635E-07},
    { 6.02680273686929E-07, 6.03684966904439E-07, 1.20536046210873E-06, 1.20937964709356E-06},
    { 1.45373832083351E-07, 1.46384664390098E-07, 2.90747806275249E-07, 2.94791007604545E-07},
    { 3.46929951433594E-07, 3.4793785630427E-07, 6.93859675493513E-07, 6.9789133760878E-07},
    { 2.86301002461187E-07, 2.87301332946299E-07, 5.72601834392117E-07, 5.76603540025644E-07},
    { 8.92922287221154E-08, 9.02999346408251E-08, 1.78584627974487E-07, 1.82615082167104E-07},
    { 1.61394524411662E-07, 1.62388303692751E-07, 3.22789020401615E-07, 3.26764009628278E-07},
    { 3.15667904260408E-07, 3.16657960297562E-07, 6.31335680623124E-07, 6.35296956374987E-07},
    { 3.65886961617434E-07, 3.66888201597249E-07, 7.31774122186835E-07, 7.35779138949511E-07},
    { 5.1565010039667E-08, 5.25749044300028E-08, 1.03130020079334E-07, 1.07168872887087E-07},
    { 2.49045257305625E-07, 2.50053105332881E-07, 4.98090642508942E-07, 5.02122333045918E-07},
    { 3.89293546732006E-07, 3.90250974646733E-07, 7.78586866090336E-07, 7.82417473033092E-07},
    { 1.28008643685007E-07, 1.29012775573756E-07, 2.56017258948305E-07, 2.60033857557573E-07},
    { 3.59406385541661E-07, 3.60415128852765E-07, 7.18812870559304E-07, 7.2284757379748E-07},
    { 7.04774407722653E-08, 7.14837113946487E-08, 1.40955009442223E-07, 1.44979907190645E-07},
    { 4.69074876718878E-08, 4.79159325550427E-08, 9.38164674835207E-08, 9.78508154503288E-08},
    { 3.46929951433594E-07, 3.4793785630427E-07, 6.93859675493513E-07, 6.9789133760878E-07},
    { 2.52614157147946E-07, 2.5362039934862E-07, 5.05228484826148E-07, 5.09253013092348E-07},
    { 1.752849669856E-07, 1.76295728238074E-07, 3.50569891338637E-07, 3.54612936348531E-07},
    { 9.97295472870974E-08, 1.00740251696152E-07, 1.99459023519921E-07, 2.03501656415028E-07},
    { 1.27083694678731E-08, 1.37173685743619E-08, 2.54168952551481E-08, 2.94820375698493E-08},
    { 2.88675792603499E-07, 2.89683143250841E-07, 5.77351315200758E-07, 5.81380774633544E-07},
    { 2.2199529325917E-07, 2.22990578890858E-07, 4.43990884946288E-07, 4.47971643779965E-07},
    { 3.101136769601E-08, 3.20127782060808E-08, 6.20226217051822E-08, 6.60284200648675E-08},
    { 6.34119317055593E-08, 6.44227355905969E-08, 1.26823891832828E-07, 1.30867206848961E-07},
    { 2.27363642579803E-07, 2.28347417419172E-07, 4.54726489351742E-07, 4.5866131870298E-07},
    { 5.761698673723E-08, 5.86278900982506E-08, 1.15233817155058E-07, 1.19277274279739E-07},
    { 5.59963240220895E-08, 5.70068436900328E-08, 1.11992690676743E-07, 1.16034897246209E-07},
    { 1.00404065506154E-07, 1.01413306197173E-07, 2.00808131012309E-07, 2.04845150619803E-07},
    { 1.51791383018463E-07, 1.52801391095636E-07, 3.03582666560942E-07, 3.07622912032457E-07},
    { 7.73673903609051E-07, 7.74670056102877E-07, 1.54734770774212E-06, 1.55133201928948E-06},
    { 6.7849948948151E-07, 6.79496110933542E-07, 1.35699917791499E-06, 1.36098604741619E-06},
    { 6.46773514745291E-08, 6.56873169191385E-08, 1.29354639000212E-07, 1.33394671308906E-07},
    { 2.14274791687785E-07, 2.15266346970111E-07, 4.28549661535271E-07, 4.32515697923463E-07},
    { 1.75431694060535E-07, 1.76439094445868E-07, 3.50863423648207E-07, 3.54893018084113E-07},
    { 1.54840201105344E-07, 1.55849093630422E-07, 3.09680387999833E-07, 3.13715879940446E-07},
    { 3.03876547036452E-07, 3.04886683011318E-07, 6.07753179338033E-07, 6.11793765870061E-07},
    { 2.87581904956369E-07, 2.88585042085288E-07, 5.7516393781043E-07, 5.79176422377259E-07},
    { 2.4641536811032E-08, 2.56472958426457E-08, 4.92830878329187E-08, 5.33060031671084E-08},
    { 2.38351063330811E-08, 2.48459812723922E-08, 4.76701984553074E-08, 5.17136911071248E-08},
    { 5.06429515212403E-07, 5.07291815665667E-07, 1.01285916542793E-06, 1.0163081114456E-06},
    { 3.16136237188402E-08, 3.26210596313103E-08, 6.32272758593899E-08, 6.72569697712788E-08},
    { 3.48408235595343E-08, 3.58516203391446E-08, 6.96816471190687E-08, 7.37248200266549E-08},
    { 7.48174926457068E-08, 7.58264846467682E-08, 1.49634963975132E-07, 1.5367105987707E-07},
    { 1.93732120123968E-07, 1.94739627090712E-07, 3.87464289985928E-07, 3.9149432495833E-07},
    { 3.07901757423679E-08, 3.17564925467195E-08, 6.17883486597748E-08, 6.55261729320955E-08},
    { 4.99771878992306E-07, 5.00766930144891E-07, 9.99543672719483E-07, 1.00352374943213E-06},
    { 1.17716950853719E-07, 1.18722240927127E-07, 2.35433859074874E-07, 2.39455012263079E-07},
    { 3.58876590667023E-08, 3.6895563937378E-08, 7.17753749768235E-08, 7.58068807726886E-08},
    { 4.9829156978376E-07, 4.99225798478165E-07, 9.96582841139571E-07, 1.0003212125298E-06},
    { 3.75331644875132E-07, 3.76332543794433E-07, 7.50663197379708E-07, 7.54666956481742E-07},
    { 2.08074482088705E-08, 2.18164970533508E-08, 4.16148893123136E-08, 4.56511770607904E-08},
    { 2.65227200202389E-08, 2.75340639177557E-08, 5.30454471459052E-08, 5.70908014196903E-08},
    { 9.48590397342741E-08, 9.57736716600266E-08, 1.89718221577095E-07, 1.93376600066131E-07},
    { 1.26375994113914E-08, 1.36486946189507E-08, 2.52751917173555E-08, 2.93195441258831E-08},
    { 1.50946419807951E-07, 1.51955084959354E-07, 3.01892768561629E-07, 3.05927514432369E-07},
    { 9.22171139450256E-08, 9.32281949417302E-08, 1.84434327366034E-07, 1.88478459506314E-07},
    { 9.69194388744654E-07, 9.70171512904017E-07, 1.93838912565525E-06, 1.94229757255471E-06},
    { 5.55253905076825E-08, 5.65363365012672E-08, 1.11050773909938E-07, 1.15094508146285E-07},
    { 1.13003537194345E-07, 1.13988456007519E-07, 2.26006307002535E-07, 2.29945861462966E-07},
    { 1.2296865747885E-07, 1.23975510746277E-07, 2.45937201270863E-07, 2.49964827503391E-07},
    { 4.48469990033118E-08, 4.58578668371956E-08, 8.96939909011962E-08, 9.37375403964325E-08},
    { 5.0952010610672E-08, 5.19609670845966E-08, 1.01904042537626E-07, 1.05939804484478E-07},
    { 4.86714952785405E-08, 4.96825975915272E-08, 9.73430047679358E-08, 1.01387534812147E-07},
    { 7.39467296284602E-08, 7.49580095771307E-08, 1.47893480573202E-07, 1.51938643000449E-07},
    { 1.0657652893542E-07, 1.07576717311986E-07, 2.13153157346824E-07, 2.17153882431376E-07},
    { 2.98015478961133E-08, 3.08124867842707E-08, 5.96030602650899E-08, 6.36467447634459E-08},
    { 4.8263878227317E-07, 4.83640725690293E-07, 9.65278132980529E-07, 9.69288855401373E-07},
    { 3.14623996189312E-07, 3.15605028333721E-07, 6.29259531592652E-07, 6.33185010201487E-07},
    { 2.29475041635396E-07, 2.30466028483534E-07, 4.5895009037622E-07, 4.62914151455607E-07},
    { 4.36916394619402E-07, 4.37877190506697E-07, 8.7382976232675E-07, 8.77673194565887E-07},
    { 4.38233769273211E-08, 4.4833392109922E-08, 8.76467751709242E-08, 9.16867648470543E-08},
    { 1.28198685445113E-07, 1.29205858456771E-07, 2.56397569842193E-07, 2.60425942144593E-07},
    { 1.72098651773922E-07, 1.73105441092503E-07, 3.44197339074981E-07, 3.48224730828406E-07},
    { 1.79612058559542E-08, 1.79676149514307E-08, 3.59441060869162E-08, 3.59159741947224E-08}
    };

    typedef bg::model::linestring<P> linestring;
    typedef bg::model::polygon<P> polygon;

    int const n = sizeof(testcases) / sizeof(testcases[0]);
    int const ne = sizeof(expectations) / sizeof(expectations[0]);
    BOOST_ASSERT(n == ne);

    boost::ignore_unused(n, ne);

    bg::strategy::buffer::join_miter join_miter;
    bg::strategy::buffer::join_round join_round(100);
    bg::strategy::buffer::end_flat end_flat;
    bg::strategy::buffer::end_round end_round(100);

    // Aimes tested originally with 0.000018 degrees (around 2 m)
    ut_settings settings;
    settings.use_ln_area = true;
    settings.tolerance = 0.001;

    int expectation_index = 0;
    for (int width = 18; width <= 36; width += 18, expectation_index += 2)
    {
        double aimes_width = static_cast<double>(width) / 1000000.0;
        for (int i = 0; i < n; i++)
        {
#if ! defined(BOOST_GEOMETRY_USE_RESCALING)
            // Without rescaling, several cases are still reported as invalid
            settings.set_test_validity(i <= 10);
#endif
            std::ostringstream name;
            try
            {
                name << "aimes_" << i << "_" << width;
                test_one<linestring, polygon>
                (
                    name.str(), testcases[i], join_miter, end_flat,
                    expectations[i][expectation_index],
                    aimes_width, settings
                );
                test_one<linestring, polygon>
                (
                    name.str(), testcases[i], join_round, end_round,
                    expectations[i][expectation_index + 1],
                    aimes_width, settings
                );
            }
            catch(std::exception const& e)
            {
                std::cout << "Exception: " << e.what() << " in " << name.str() << std::endl;
            }
        }
    }
}


int test_main(int, char* [])
{
    BoostGeometryWriteTestConfiguration();

    test_aimes<bg::model::point<default_test_type, 2, bg::cs::cartesian> >();

#if defined(BOOST_GEOMETRY_TEST_FAILURES)
    // Non-rescaled reports failures, but in validity only
    BoostGeometryWriteExpectedFailures(BG_NO_FAILURES, 4);
#endif

    return 0;
}
