# make scripts and programs

- `canvas.c2w.wcwidth*.cpp` ... These C++ codes are used to generate the character-width table by the C-library implementations and different terminal implementations.
  [`src/canvas.c2w.musl.sh`](../src/canvas.c2w.musl.sh) is generated by this program.
- `canvas.emoji.sh` ... This script is used to test the emoji supports of different terminals.
- `mwg_pp.awk` ... This is a preprocessor program written in AWK, which is used to preprocess and combine multiple shell scripts into a single file `ble.sh`.
  The source repository is [`akinomyoga/mwg_pp`](https://github.com/akinomyoga/mwg_pp).
- `debug.leakvar.exclude-list.txt` ... This is a white list for the global variables.


## Update Unicode version

When a new Unicode standard is published, the following files need to be
updated:

- `canvas.GraphemeClusterBreak.sh`
- `canvas.c2w.sh`
- `canvas.emoji.sh`

These files can be updated using `make/canvas.c2w.generate-table.sh` as
described in the next subsection.

Also, the code points used to measure the terminal's Unicode version need to be
updated.  They are hardcoded in the array `codes` in the shell function
`ble/util/c2w:auto/test.buff` defined in `src/canvas.sh`.  Basically, a new
code point that can be used to test the support for the latest Unicode can be
added.  To identify codes that can be used to test it, after updating the
Unicode tables in `ble.sh`, one can run the following command:

```console
$ make/canvas.c2w.list-ucsver-detection-codes.sh
```

One can pick one code point from the lines starting with the corresponding
"verXX".  The code point can be added to the array `codes` in the shell
function `ble/util/c2w:auto/test.buff`, and the test codes in
`ble/util/c2w/test.hook` can be updated accordingly.

### `canvas.c2w.generate-table.sh`

This script file downloads data of Unicode properties from the Unicode database and
generates various tables.

```bash
$ make/canvas.c2w.generate-table.sh c2w

src/canvas.c2w.sh

$ make/canvas.c2w.generate-table.sh convert-custom-c2w <array-name> < input > output

src/canvas.c2w.musl.sh

$ make/canvas.c2w.generate-table.sh emoji

src/canvas.emoji.sh

$ make/canvas.c2w.generate-table.sh GraphemeClusterBreak

src/canvas.GraphemeClusterBreak.sh
lib/test-canvas.GraphemeClusterTest.sh

```

### `canvas.c2w.list-ucsver-detection-codes.sh`

This script is used to analyze the character-width table based on the Unicode
database.  The character codes used by the test for `bleopt
char_width_{mode,version}=auto` are determined based on the result of this
script.

```bash
$ make/canvas.c2w.list-ucsver-detection-codes.sh
```

## Update color themes

### `color.sample.sh`

This script is used to choose the colors in the default faces.  To show the
color sample for the brightness, the following command can be used:

```bash
$ make/color.sample.sh show-brightness-sample
```

The above command shows the sample of brightness in the grayscale foreground
characters in black and white backgrounds.

To list the safe colors, one can run the following command.  The HTML output is
available
[here](https://akinomyoga.github.io/ble.sh/color.sample.safe-colors.html).


```bash
$ make/color.sample.sh list-safe-colors [-t (ansi|html|markdown)] \
                                [-bB | -y MINBRIGHT | -Y MAXBRIGHT] \
                                [-dD | -E (cie76|cie94|ITP)]
```

The accepted range of the brightness can be specified by the options `-y
MINBRIGHT` and `-Y MAXBRIGHT`.  To enable/disable the filtering by the
brightness, one can use the option `-b`/`-B`.  The filtering by the brightness
is enabled by default.  To enable/disable the filtering the the distances from
white and black, one can use the option `-d`/`-D`.  The definition of the color
distance can be specified by the option `-E COLORDISTANCE`.  The output format
can be specified by the option `-t TYPE`.

To generate a patch to modify unsafe colors, one can run the following command:

```bash
$ make/color.sample.sh patch1       # suggested changes are printed to stdout
$ make/color.sample.sh patch1-save  # patch is saved to a.patch
```

To generate a list of base16 themes for `bleopt colorglass_base16_palette`, the
following command can be used.  The HTML output is available
[here](https://akinomyoga.github.io/ble.sh/colorglass.base16.html).

```bash
make/color.sample.sh generate-base16-sample [-t (ansi|html|markdown)]
```

To convert iTerm2-Color-Schemes to base16 palettes, the following command can
be used:

```bash
git clone git@github.com:mbadolato/iTerm2-Color-Schemes.git ext/iTerm2-Color-Schemes
make/color.sample.sh convert-iTerm2-palettes
```

To download and convert Gogh profiles to base16 palettes, the following command
can be used:

```bash
make/color.sample.sh convert-gogh-palettes
```


## Update airline themes in the contrib repository

First install `vim-airline` and `vim-airline-themes` using `vim-plug`. Then
create a directory at `out/data/airline`:

```bash
mkdir -p out/data/airline
```


Open Vim and run the following commands:

```vim
:source make/vim-airline.DumpAirlineThemes.vim
:call DumpAirlineThemeAll()
```

This can take time. Finally, you can run the following command in a ble.sh
session.

```bash
(source make/vim-airline.ConvertAirlineThemes.sh)
```
