//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_35.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot35(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[35] = {1.749958242808220e-02,1.575484042859406e-01,4.379248825101927e-01,8.591897511576237e-01,1.422191855664142e+00,
    2.128077678990523e+00,2.978304443737644e+00,3.974657159383102e+00,5.119270110765249e+00,6.414653438173411e+00,7.863725651125991e+00,9.469853160927341e+00,
    1.123689823037098e+01,1.316927714908235e+01,1.527203098782228e+01,1.755091201939778e+01,2.001248989832001e+01,2.266428308692950e+01,2.551492298714163e+01,
    2.857436107256040e+01,3.185413347588226e+01,3.536770372552119e+01,3.913091391474387e+01,4.316258973977563e+01,4.748536955673771e+01,5.212686940447470e+01,
    5.712136968778990e+01,6.251234600798013e+01,6.835643606745100e+01,7.473000587570237e+01,8.174080775359022e+01,8.955071509834151e+01,9.842636942882824e+01,
    1.088779508236660e+02,1.222183478887410e+02};
  constexpr double aw[35] = {2.599931062031600e-01,2.261284438373461e-01,1.710101529360384e-01,1.123881650198194e-01,6.413364098536906e-02,
    3.174127819005061e-02,1.360532756061864e-02,5.041636747637913e-03,1.611735395355833e-03,4.433999966333339e-04,1.046699428500667e-04,2.113123326730634e-05,
    3.634490404718271e-06,5.302485633505246e-07,6.529293418948361e-08,6.747331288132626e-09,5.813734448427968e-10,4.145791033248680e-11,2.425962302235481e-12,
    1.153495256018320e-13,4.406117539795009e-15,1.334243468124816e-16,3.153321059872526e-18,5.709512432304647e-20,7.745473674517019e-22,7.661592397261393e-24,
    5.343021620962718e-26,2.517269378501885e-28,7.579831860430619e-31,1.353842810777554e-33,1.291378802533876e-36,5.621622224396045e-40,8.632811368706500e-44,
    2.868816891233346e-48,5.985609246693381e-54};
  constexpr double x[13440] = {  9.788014554498177e-04, -6.889644201801367e-06,  3.635344917614209e-08, -1.703982979997241e-10,  7.481709575808662e-13,
 -3.150545879754670e-15,  1.288359063304725e-17, -5.154221957870396e-20,  2.026748165218917e-22, -7.858056016205990e-25,  3.010604244780962e-27, -1.141525326719528e-29,
  8.798035619779212e-03, -6.168926060346429e-05,  3.229873262785214e-07, -1.494333161413318e-09,  6.432987417642506e-12, -2.634042558421065e-14,  1.036808791127966e-16,
 -3.943598514838237e-19,  1.452216237009922e-21, -5.174592063675769e-24,  1.778718139976302e-26, -5.861220814213943e-29,  2.437697342626468e-02, -1.696054190072637e-04,
  8.742082436474089e-07, -3.938409225349933e-09,  1.626944604491539e-11, -6.268567625502880e-14,  2.260213961779226e-16, -7.573766837426671e-19,  2.309615455987030e-21,
 -6.078356595740213e-24,  1.157308945389846e-26,  1.172356740573207e-30,  4.759695056527830e-02, -3.273218683952291e-04,  1.647434851746378e-06, -7.120969284400274e-09,
  2.751194965288386e-11, -9.530958422643954e-14,  2.885179833836392e-16, -6.991924498034881e-19,  8.783583296311086e-22,  3.576240489609628e-24, -3.676918701316181e-26,
  2.024574658740088e-28,  7.828096135748160e-02, -5.299876220252185e-04,  2.582476764561268e-06, -1.053123912902897e-08,  3.678210399114459e-11, -1.059639620504395e-13,
  2.109807716503298e-16,  4.343081246415298e-20, -3.205476817206674e-21,  2.059421083894606e-23, -9.030323968492335e-26,  2.965761809503857e-28,  1.161948447123904e-01,
 -7.713612608069626e-04,  3.605680917572377e-06, -1.359502173535698e-08,  4.079490706129706e-11, -8.119916949279090e-14, -3.374176612524905e-17,  1.331153967186462e-18,
 -7.914881050293135e-21,  3.053000586793478e-23, -7.386526580294741e-26, -9.129529738127089e-30,  1.610488603181051e-01, -1.043997149864752e-03,  4.635025263072836e-06,
 -1.574939351471056e-08,  3.708960451859663e-11, -1.742092757922754e-14, -3.971492292700931e-16,  2.606009332705034e-18, -9.688110535433225e-21,  1.793246736875184e-23,
  4.862949594325638e-26, -6.134256682175423e-28,  2.124996504714657e-01, -1.339468435974084e-03,  5.585821924283661e-06, -1.651730383019548e-08,  2.462024855660835e-11,
  7.671079914003812e-14, -7.625807485671784e-16,  3.117407957859858e-18, -5.666474827318395e-21, -1.906629701974970e-23,  2.108960412281809e-25, -9.233623779998234e-28,
  2.701525815286950e-01, -1.648620624084143e-03,  6.376648728689967e-06, -1.557289279924294e-08,  4.085341977967369e-12,  1.813810731047448e-13, -9.823403485432842e-16,
  2.297941937776403e-18,  4.018342608995853e-21, -6.176879151900385e-23,  2.690663462702605e-25, -3.626447985792449e-28,  3.335644573479075e-01, -1.961848602360642e-03,
  6.935108992079644e-06, -1.278934717146645e-08, -2.207642144937066e-11,  2.700994506351949e-13, -9.322926136093236e-16,  1.090900273123531e-19,  1.546210050083110e-20,
 -7.935987754932130e-23,  1.158786322858950e-25,  9.205994808386842e-28,  4.022465952793839e-01, -2.269389223120194e-03,  7.203026169236594e-06, -8.263109235519419e-09,
 -5.003487600951287e-11,  3.164852702782570e-13, -5.641298736325744e-16, -2.826250828707640e-18,  2.250138634103719e-20, -4.948021545707245e-23, -2.032846459982205e-25,
  1.915721002196957e-27,  4.756682532151486e-01, -2.561620976026100e-03,  7.140712646094162e-06, -2.311022446190163e-09, -7.520627198892860e-11,  3.015911817334822e-13,
  6.501674011783723e-17, -5.399183422288345e-18,  1.995519562048784e-20,  2.261238760251106e-23, -4.823091578686099e-25,  1.517649141262095e-27,  5.532603939203923e-01,
 -2.829361931993885e-03,  6.730009051650348e-06,  4.559772045020216e-09, -9.306807528079071e-11,  2.197650889858665e-13,  7.988425157077017e-16, -6.450415382528547e-18,
  6.869240397286962e-21,  1.011240710066648e-22, -4.876390659420062e-25, -3.717200349363703e-28,  6.344197703276730e-01, -3.064157010303632e-03,  5.975868968044164e-06,
  1.170605572811587e-08, -1.000012926335905e-10,  8.135846475789519e-14,  1.424765730244435e-15, -5.287306640040716e-18, -1.218670840531585e-20,  1.381248666250251e-22,
 -1.457890093079121e-25, -2.471587000535573e-27,  7.185133126815998e-01, -3.258545742283195e-03,  4.906359290716560e-06,  1.842072766186384e-08, -9.400120184148193e-11,
 -8.862802181339157e-14,  1.740750311392303e-15, -2.048336406437846e-18, -2.878539855344416e-20,  1.035173330083094e-22,  3.650580952426144e-25, -3.014778639455321e-27,
  8.048827953883368e-01, -3.406302082410295e-03,  3.571052937547486e-06,  2.401450111679760e-08, -7.511765512473642e-11, -2.558087526824730e-13,  1.623821106948164e-15,
  2.267011736098553e-18, -3.465931226132127e-20,  7.272931191046353e-24,  7.113024113000012e-25, -1.271484203956120e-27,  8.928497581738785e-01, -3.502638455477412e-03,
  2.037901342462270e-06,  2.789728035964009e-08, -4.553346752086005e-11, -3.843731836090266e-13,  1.076142493906513e-15,  6.143521700301890e-18, -2.604061980527443e-20,
 -1.021628614571379e-22,  6.357256551228364e-25,  1.646067442884164e-27,  9.817206527236101e-01, -3.544367123120356e-03,  3.887818084950396e-07,  2.964922333006854e-08,
 -9.255579777750628e-12, -4.457565371407399e-13,  2.313202096487340e-16,  8.141939312349963e-18, -5.947199665403286e-21, -1.645481374857490e-22,  1.556296381020897e-25,
  3.538653317498859e-27,  1.070792182412794e+00, -3.530013092976925e-03, -1.285988197179698e-06,  2.907255659695238e-08,  2.853341783351338e-11, -4.257763778357606e-13,
 -6.830426829945159e-16,  7.489247814326151e-18,  1.696886068443477e-20, -1.439253618426825e-22, -4.305204544075841e-25,  2.901116619620206e-27,  1.159356799107019e+00,
 -3.459874158579472e-03, -2.893798524396302e-06,  2.621740977180919e-08,  6.235003987571498e-11, -3.283306891920419e-13, -1.415171358387838e-15,  4.409017198128168e-18,
  3.255586136475944e-20, -5.113959711002322e-23, -7.451533545801545e-25,  2.057939360443690e-28,  1.246708317391081e+00, -3.336025217962033e-03, -4.346129212956257e-06,
  2.137803809357863e-08,  8.735188451296809e-11, -1.746200992128775e-13, -1.768195997027088e-15,  4.075216409507454e-20,  3.416105391670788e-20,  6.219153518238631e-23,
 -5.968453823021328e-25, -2.466414334700725e-27,  1.332147603065283e+00, -3.162265734506853e-03, -5.564716254109088e-06,  1.505944136708838e-08,  1.001716781245308e-10,
  1.971363960825970e-15, -1.661570385030700e-15, -4.023024380238372e-18,  2.184597202212692e-20,  1.348321030828591e-22, -1.100465067078087e-25, -3.150065357291427e-27,
  1.414988289432770e+00, -2.944011026174038e-03, -6.487053629121473e-06,  7.918118689499837e-09,  9.948574152186569e-11,  1.640404642818612e-13, -1.153744851534003e-15,
 -6.382557846719910e-18,  2.116978737032969e-21,  1.322822872776680e-22,  3.764921924942965e-25, -1.566952672456045e-27,  1.494562471902914e+00, -2.688129941997304e-03,
 -7.070823726237081e-06,  6.840453989478736e-10,  8.620788568339568e-11,  2.792467801948273e-13, -4.185267287344126e-16, -6.378280892479213e-18, -1.562246241620519e-20,
  6.517459524038888e-23,  5.597006890465546e-25,  7.988117697908003e-28,  1.570226328873671e+00, -2.402733343723694e-03, -7.296918148891338e-06, -5.926523708337125e-09,
  6.327076059865312e-11,  3.279252069351514e-13,  3.160441195350038e-16, -4.305105389736793e-18, -2.390359564262428e-20, -2.113104698071443e-23,  3.769839900107471e-25,
  2.089614260836732e-27,  1.641365614853724e+00, -2.096919587007059e-03, -7.170807946585712e-06, -1.129648637696616e-08,  3.503650153555618e-11,  3.072363801756207e-13,
  8.442255923736217e-16, -1.212855322183807e-18, -2.067250854108664e-20, -7.730272009458311e-23,  1.731141234588692e-26,  1.607507071666461e-27,  1.707400970468224e+00,
 -1.780484819687286e-03, -6.722140027274439e-06, -1.498068081174028e-08,  6.451365682412967e-12,  2.308131558668595e-13,  1.047275950052769e-15,  1.598694450813128e-18,
 -9.645580370158673e-21, -7.983465305853617e-23, -2.503371925584068e-25,  1.626580225062574e-28,  1.767792993488902e+00, -1.463607314312285e-03, -6.002566614281874e-06,
 -1.675663519050826e-08, -1.788991752918937e-11,  1.241074965425812e-13,  9.240077577873174e-16,  3.147078701213054e-18,  2.394787685732563e-21, -4.082794869509828e-23,
 -2.803310618828359e-25, -8.953737192116996e-28,  1.822047015490095e+00, -1.156516162292356e-03, -5.081947393372659e-06, -1.664663621706039e-08, -3.458595907261220e-11,
  1.683279136628514e-14,  5.780112667078032e-16,  3.137006967814429e-18,  9.586263352222287e-21,  6.202249295510941e-24, -1.269966322220704e-25, -9.051458589198203e-28,
  1.869717530404958e+00, -8.691554192891808e-04, -4.043189120988495e-06, -1.490815640954565e-08, -4.201117693102484e-11, -6.531006748000733e-14,  1.687181595076749e-16,
  1.980313745256233e-18,  9.892789285474639e-21,  3.181778408980599e-23,  4.359205867641267e-26, -2.528851535263403e-28,  1.910412224819320e+00, -6.108551554562252e-04,
 -2.976094787387298e-06, -1.199381829448019e-08, -4.052585926822323e-11, -1.072706061448479e-13, -1.532403789067290e-16,  4.893578881463651e-19,  5.411930326317706e-21,
  2.852245615041342e-23,  1.073110688706721e-25,  2.719438518901785e-28,  1.943795568063244e+00, -3.900207796010056e-04, -1.970674806920402e-06, -8.486117106636988e-09,
 -3.227675159797205e-11, -1.078149052674191e-13, -3.008204471036641e-16, -5.765783584903391e-19,  2.528742890334823e-22,  9.926709499179762e-24,  6.463513551185777e-26,
  2.999640874077883e-28,  1.969591948484730e+00, -2.138513496629995e-04, -1.110418430041690e-06, -5.015516786247094e-09, -2.063515470422462e-11, -7.843206414018387e-14,
 -2.749048285104014e-16, -8.729906669807783e-19, -2.392209749532019e-21, -4.820536438464491e-24, -6.803673179977330e-28,  6.320286264065438e-29,  1.987588517772763e+00,
 -8.809545086051424e-05, -4.660252616807039e-07, -2.172778126283896e-09, -9.394116618744897e-12, -3.846394187405401e-14, -1.505551002415930e-16, -5.652936347749161e-19,
 -2.034623828768484e-21, -6.986102620562099e-24, -2.264150755110969e-26, -6.777325176017209e-29,  1.997640330539028e+00, -1.683461641987761e-05, -8.997244733279066e-08,
 -4.267595373756402e-10, -1.893976916324796e-12, -8.050196524609991e-15, -3.317334484992518e-17, -1.334780256994871e-19, -5.267176464369444e-22, -2.044161555599486e-24,
 -7.816394144337896e-27, -2.948019871396540e-29,  9.518118646773220e-04, -6.606796906259392e-06,  3.437846776238918e-08, -1.589153276405065e-10,  6.881388835992870e-13,
 -2.857950349964053e-15,  1.152711420924220e-17, -4.548695497786284e-20,  1.764377073058422e-22, -6.748495151877732e-25,  2.550827061023185e-27, -9.543094017380101e-30,
  8.556335223830702e-03, -5.917537938973166e-05,  3.056559383654279e-07, -1.395488292945703e-09,  5.930194334879959e-12, -2.397950552201970e-14,  9.326234178617420e-17,
 -3.507370735235371e-19,  1.278138999288191e-21, -4.512194025583815e-24,  1.539208569025167e-26, -5.045856214519251e-29,  2.371224588724721e-02, -1.627964648141469e-04,
  8.284687625868049e-07, -3.687840127461177e-09,  1.506830224030999e-11, -5.750748873917704e-14,  2.058172976022338e-16, -6.868808099745073e-19,  2.099119729289818e-21,
 -5.616554601042205e-24,  1.146837684581783e-26, -5.516530214507655e-30,  4.631349123228701e-02, -3.144768553156570e-04,  1.564562663827918e-06, -6.695657993722501e-09,
  2.567343339985019e-11, -8.861679591497386e-14,  2.693515275635701e-16, -6.692922149835138e-19,  9.826682633352863e-22,  2.271902616889745e-24, -2.872511177272456e-26,
  1.643518857727769e-28,  7.620154403766917e-02, -5.098234619311940e-04,  2.459563932610277e-06, -9.959404366713286e-09,  3.471350155069551e-11, -1.008967610382146e-13,
  2.108674116383920e-16, -4.795431826043369e-20, -2.526038069603831e-21,  1.723433781414781e-23, -7.790752017720452e-26,  2.667921353202758e-28,  1.131660728444272e-01,
 -7.431574019426890e-04,  3.446403267263315e-06, -1.295532691827723e-08,  3.916570102670930e-11, -8.158932919424143e-14,  1.458416278568306e-19,  1.094893058701616e-18,
 -6.868926008646749e-21,  2.758406667282938e-23, -7.305299604236498e-26,  4.293800772323457e-29,  1.569458493723536e-01, -1.007662860000267e-03,  4.449580033846745e-06,
 -1.515924088672057e-08,  3.665160210582733e-11, -2.611131348618572e-14, -3.284218077092194e-16,  2.306644050076104e-18, -9.013650574734330e-21,  1.937954948132936e-23,
  2.471765460126068e-26, -4.770678996420523e-28,  2.072299041632102e-01, -1.295567884170408e-03,  5.390025310355100e-06, -1.611207122920407e-08,  2.597840706033204e-11,
  5.943524232314961e-14, -6.779239383903688e-16,  2.926648743394945e-18, -6.210575669646138e-21, -1.141734628184028e-23,  1.722090592077616e-25, -8.332206021137939e-28,
  2.636589437940738e-01, -1.598353554409543e-03,  6.190281830378958e-06, -1.547976521547947e-08,  7.482480132322426e-12,  1.585895623274040e-13, -9.165174327189290e-16,
  2.392993666465226e-18,  1.984189236015432e-21, -5.136390553957104e-23,  2.503227736823707e-25, -4.802379834851046e-28,  3.258270447459482e-01, -1.906987221212963e-03,
  6.779691822382346e-06, -1.310056770116189e-08, -1.689765737165301e-11,  2.478143871235263e-13, -9.227337592822843e-16,  5.591339534724590e-19,  1.269745910110217e-20,
 -7.401062311761254e-23,  1.492948348196256e-25,  6.063472591424434e-28,  3.932836402239769e-01, -2.212174776345288e-03,  7.099271937667653e-06, -9.013790697437618e-09,
 -4.384655838043648e-11,  3.020762000320496e-13, -6.334623173180059e-16, -2.136115795818299e-18,  2.059339968132705e-20, -5.599742058959200e-23, -1.244041997364134e-25,
  1.665019223227247e-27,  4.655358168012451e-01, -2.504626201321212e-03,  7.105959762139615e-06, -3.466033520775628e-09, -6.917071404430699e-11,  3.014102381974207e-13,
 -7.712386585310663e-17, -4.751182482113744e-18,  2.043848211183527e-20,  4.698995619621377e-24, -4.124845051650621e-25,  1.638210376977024e-27,  5.420509375903427e-01,
 -2.775327964531180e-03,  6.775940033612062e-06,  3.106826026089000e-09, -8.849553868496717e-11,  2.367980375514038e-13,  6.218286102578900e-16, -6.176139252166172e-18,
  1.015610873094384e-20,  8.144868445684401e-23, -4.923995127243468e-25,  1.402943844648871e-28,  6.222596076276253e-01, -3.015815232753360e-03,  6.106801088171499e-06,
  1.012085922527969e-08, -9.804437958572585e-11,  1.137367893584896e-13,  1.271999818127577e-15, -5.599050692941681e-18, -7.344032372738331e-21,  1.302680498546750e-22,
 -2.432701107643046e-25, -1.952994157268806e-27,  7.055589951807991e-01, -3.218436361427812e-03,  5.118332708025852e-06,  1.690477655952720e-08, -9.536115081319261e-11,
 -4.763880564851299e-14,  1.671079856877372e-15, -2.907284815477819e-18, -2.482795198787441e-20,  1.154634485350274e-22,  2.324640368117283e-25, -2.985449073736942e-27,
  7.913165196674102e-01, -3.376601769832788e-03,  3.851853734852860e-06,  2.277382602925450e-08, -7.983961751104200e-11, -2.162002229098040e-13,  1.671847886204876e-15,
  1.167473668265379e-18, -3.390051067807263e-20,  3.442365189541850e-23,  6.419643652076770e-25, -1.857247830577796e-27,  8.788739127234504e-01, -3.485009135230436e-03,
  2.368048508856323e-06,  2.710870521019645e-08, -5.294922390567057e-11, -3.565789229622181e-13,  1.235977744087038e-15,  5.256412241848253e-18, -2.924533005833233e-20,
 -7.550821384449146e-23,  6.914250720139031e-25,  8.805488404619647e-28,  9.675516536365346e-01, -3.539836898657436e-03,  7.433909412839800e-07,  2.943019170398012e-08,
 -1.809686193959140e-11, -4.374960886807143e-13,  4.557499404802470e-16,  7.858351119710333e-18, -1.172199327778575e-20, -1.552817022538871e-22,  3.055498038170163e-25,
  3.244876372315676e-27,  1.056653773840757e+00, -3.538898407356651e-03, -9.346620101542098e-07,  2.946014871331292e-08,  1.987124203270518e-11, -4.395965555740544e-13,
 -4.665428244576100e-16,  7.946285287434219e-18,  1.150967321398233e-20, -1.584486729176230e-22, -2.923644751279809e-25,  3.351000960951675e-27,  1.145473017489056e+00,
 -3.481749662729821e-03, -2.573426559510954e-06,  2.716067618409695e-08,  5.545438505529309e-11, -3.606975560943937e-13, -1.277451459062447e-15,  5.415627743020739e-18,
  3.018267928134330e-20, -8.052582468931635e-23, -7.182152516817435e-25,  1.020878390908104e-27,  1.233296336357049e+00, -3.369744626516272e-03, -4.081329686581023e-06,
  2.274542593750958e-08,  8.343585447933803e-11, -2.169176851549679e-13, -1.751448246200689e-15,  1.164915954745750e-18,  3.594524608983967e-20,  3.627928161875469e-23,
 -6.951881005905960e-25, -1.975228668310305e-27,  1.319410687636651e+00, -3.206033375922180e-03, -5.374392295078171e-06,  1.666030012663850e-08,  9.980363144944076e-11,
 -3.917461855186494e-14, -1.763706010118338e-15, -3.247415083272197e-18,  2.658662894822980e-20,  1.275875965837506e-22, -2.536524764252445e-25, -3.351832630786514e-27,
  1.403109092765610e+00, -2.995500086122147e-03, -6.382382345939773e-06,  9.534571977964494e-09,  1.024752350035666e-10,  1.342182040109283e-13, -1.330772266948929e-15,
 -6.235859455675734e-18,  7.131896715716200e-21,  1.457759262640069e-22,  2.935484022263003e-25, -2.203552738051102e-27,  1.483696904601355e+00, -2.744639828479288e-03,
 -7.054156857700842e-06,  2.107443587583702e-09,  9.167762674622225e-11,  2.670048695110729e-13, -6.037335658392605e-16, -6.836277259852647e-18, -1.286591534435587e-20,
  8.813270021082085e-23,  5.846874862902327e-25,  3.159745283682930e-28,  1.560498219348844e+00, -2.461375451491922e-03, -7.361744790512387e-06, -4.861353931737660e-09,
  6.989490204719905e-11,  3.339767206109941e-13,  1.846997923942984e-16, -5.079100791662310e-18, -2.437058522862376e-20, -4.198750932460619e-24,  4.697917311085673e-25,
  2.111259136961076e-27,  1.632862359124237e+00, -2.154818277908745e-03, -7.302795971800069e-06, -1.068565658550619e-08,  4.138069531457412e-11,  3.270129601400900e-13,
  8.005877834514935e-16, -1.918623430157329e-18, -2.342490070096600e-20, -7.508621357927153e-23,  9.623334544592430e-26,  1.980537535021463e-27,  1.700170341368437e+00,
 -1.834978898031569e-03, -6.901132065534245e-06, -1.483914865066038e-08,  1.132240909078097e-11,  2.564473373103356e-13,  1.087272437087138e-15,  1.242137636738928e-18,
 -1.269736049419217e-20, -8.961770631231991e-23, -2.365220374439631e-25,  4.776163527810460e-28,  1.761841243050576e+00, -1.512436835152350e-03, -6.205277772496954e-06,
 -1.702178166759524e-08, -1.517882945922367e-11,  1.473483233444614e-13,  1.012961990203031e-15,  3.197953912880450e-18,  7.136707218210211e-22, -5.282601689193735e-23,
 -3.194078422140614e-25, -8.725374259137243e-28,  1.817338361297356e+00, -1.197980156725061e-03, -5.285013645780308e-06, -1.719653409867913e-08, -3.410328591992750e-11,
  3.179392931351240e-14,  6.701682189134876e-16,  3.446278650137638e-18,  9.708062531954887e-21,  2.767144404874654e-25, -1.705149166756154e-25, -1.074591235552235e-27,
  1.866175068420723e+00, -9.022280485505355e-04, -4.226162409776430e-06, -1.559054533291873e-08, -4.327220516108340e-11, -6.055860406710244e-14,  2.287733745520727e-16,
  2.315522660340798e-18,  1.106660423122289e-20,  3.330224681596308e-23,  2.966672909214929e-26, -3.853711210026491e-28,  1.907920259372201e+00, -6.352508043921514e-04,
 -3.123982521694384e-06, -1.265959014199743e-08, -4.270683394435813e-11, -1.107634024777587e-13, -1.369534074649330e-16,  6.798204955915457e-19,  6.518894060336896e-21,
  3.305489356859733e-23,  1.193073734195704e-25,  2.713998662577874e-28,  1.942203296589452e+00, -4.062024574082982e-04, -2.075679223805258e-06, -9.020193255076224e-09,
 -3.450654809633105e-11, -1.152270632341603e-13, -3.167939183524815e-16, -5.622428352926269e-19,  6.601009461966948e-22,  1.279234076099019e-23,  7.906316928975403e-26,
  3.571912432769797e-28,  1.968718387127859e+00, -2.229811762587839e-04, -1.172638555775945e-06, -5.358595336226518e-09, -2.227179847499536e-11, -8.533191551498861e-14,
 -3.004463698532278e-16, -9.523174144691132e-19, -2.565506368596024e-21, -4.785194411628593e-24,  2.630783660830180e-27,  8.839710347682293e-29,  1.987228510747934e+00,
 -9.193056127170242e-05, -4.930264715675678e-07, -2.329440063732866e-09, -1.020084979866080e-11, -4.227479892310518e-14, -1.673339230026811e-16, -6.346063711865697e-19,
 -2.303167502036992e-21, -7.953988653610144e-24, -2.581835423913246e-26, -7.677451231946903e-29,  1.997571519336685e+00, -1.757540814184947e-05, -9.528084037564317e-08,
 -4.583957633919099e-10, -2.063255317652859e-12, -8.893180247612163e-15, -3.715820745673872e-17, -1.515734031735504e-19, -6.062625652189847e-22, -2.384388598641321e-24,
 -9.237224386293816e-27, -3.528698678225368e-29,  9.259229136100312e-04, -6.339214174641759e-06,  3.253570645063921e-08, -1.483477680401944e-10,  6.336464241052945e-13,
 -2.595966991009099e-15,  1.032900706051639e-17, -4.021076164836200e-20,  1.538829035918544e-22, -5.807377868400030e-25,  2.166014738358770e-27, -7.996785182556158e-30,
  8.324420374290532e-03, -5.679553798298645e-05,  2.894639360453967e-07, -1.304323548125108e-09,  5.472214978856578e-12, -2.185458117563857e-14,  8.399071267227262e-17,
 -3.123210354369911e-19,  1.126266882652905e-21, -3.938773715354216e-24,  1.332995942458360e-26, -4.344971916399632e-29,  2.307404092548293e-02, -1.563417181609783e-04,
  7.856241349584738e-07, -3.455686508965070e-09,  1.396602921829828e-11, -5.279125880908863e-14,  1.874952717903655e-16, -6.228561432718956e-19,  1.905108930281041e-21,
 -5.164136266181783e-24,  1.111983276560314e-26, -1.001607346562103e-29,  4.508011762748474e-02, -3.022748948618018e-04,  1.486622050911406e-06, -6.298716819120078e-09,
  2.396424255044139e-11, -8.237362012578194e-14,  2.510623744428441e-16, -6.367464185934194e-19,  1.045428098317463e-21,  1.257800518595238e-24, -2.220970426040182e-26,
  1.327965933340262e-28,  7.420085942816862e-02, -4.906157113870093e-04,  2.343317873572865e-06, -9.419857466287383e-09,  3.274602089795211e-11, -9.586063762473793e-14,
  2.084821402863100e-16, -1.194395677907607e-19, -1.958946077216924e-21,  1.434405745287696e-23, -6.682185896009049e-26,  2.372393377355494e-28,  1.102476159602736e-01,
 -7.161975023905510e-04,  3.294645430631196e-06, -1.234171981627274e-08,  3.753630811634026e-11, -8.124188546595278e-14,  2.787085746452385e-17,  8.904162833274160e-19,
 -5.927936003548063e-21,  2.471120658875170e-23, -7.033312400231003e-26,  7.826877838115944e-29,  1.529852531291000e-01, -9.727839364212001e-04,  4.271169134894595e-06,
 -1.457739994404819e-08,  3.605562038108402e-11, -3.325034734400577e-14, -2.677678743997173e-16,  2.029521761084832e-18, -8.302924037518403e-21,  1.998382147099079e-23,
  6.334408906140884e-27, -3.619214950623282e-28,  2.021326586018293e-01, -1.253213910244984e-03,  5.199210821537322e-06, -1.568776363703289e-08,  2.701093029354144e-11,
  4.412563033807883e-14, -5.988128307764509e-16,  2.722593371293988e-18, -6.506186463916000e-21, -5.233744292969911e-24,  1.376838268201979e-25, -7.354589531269483e-28,
  2.573634008050086e-01, -1.549572059857306e-03,  6.005343826138298e-06, -1.533584345295007e-08,  1.043976458310559e-11,  1.374027241136953e-13, -8.488891435933775e-16,
  2.428791818497423e-18,  3.100111845127780e-22, -4.179683139299677e-23,  2.275374595145418e-25, -5.481602766521942e-28,  3.183065692852174e-01, -1.853382741156223e-03,
  6.621022511193571e-06, -1.333247704410388e-08, -1.216133061856590e-11,  2.259001404386203e-13, -9.017815973717544e-16,  9.240223189783195e-19,  1.014625020327416e-20,
 -6.758673000057532e-23,  1.699741297251302e-25,  3.419492379227339e-28,  3.845478281829107e-01, -2.155824735367776e-03,  6.987093821848830e-06, -9.667848494643890e-09,
 -3.796153321536660e-11,  2.862279416693932e-13, -6.843568148073510e-16, -1.510203304690339e-18,  1.850486409806932e-20, -5.958686606661833e-23, -5.702834807794690e-26,
  1.396161976252930e-27,  4.556307179749883e-01, -2.447963249996299e-03,  7.057925455943292e-06, -4.524683777593555e-09, -6.317141247571768e-11,  2.980368196213042e-13,
 -2.009969863716463e-16, -4.097486928181532e-18,  2.032815694953172e-20, -1.034598268724316e-23, -3.396122331593385e-25,  1.659431192992817e-27,  5.310582433900738e-01,
 -2.720995022487514e-03,  6.804885128530037e-06,  1.729537854881840e-09, -8.362414575053840e-11,  2.496860397467969e-13,  4.538604554448946e-16, -5.808010683870604e-18,
  1.273641441863835e-20,  6.200578203585876e-23, -4.767172406702109e-25,  5.560165554358498e-28,  6.102947872914606e-01, -2.966501507486503e-03,  6.218919430969912e-06,
  8.571952000035461e-09, -9.547718160377214e-11,  1.423612100442819e-13,  1.112626966279780e-15, -5.761061999087866e-18, -2.848806675395986e-21,  1.189768490619478e-22,
 -3.173659925293307e-25, -1.414786185519162e-27,  6.927683911249434e-01, -3.176704267119163e-03,  5.312010893887673e-06,  1.537352578295426e-08, -9.591990895558519e-11,
 -8.595616037930059e-15,  1.579189165707502e-15, -3.633732292536742e-18, -2.053518104254650e-20,  1.221774684908017e-22,  1.045398675438257e-25, -2.807051416549689e-27,
  7.778734419848352e-01, -3.344715827094689e-03,  4.117339438755892e-06,  2.146398912834521e-08, -8.376035868782466e-11, -1.758048685974392e-13,  1.689570386384285e-15,
  1.072728879687897e-19, -3.222003213447414e-20,  5.832804898106713e-23,  5.500779637804819e-25, -2.293332651003527e-27,  8.649738041866641e-01, -3.464778462786552e-03,
  2.688039856647921e-06,  2.620612482319072e-08, -5.977280265820511e-11, -3.252573729468841e-13,  1.369685156272554e-15,  4.282468856627901e-18, -3.145854219300159e-20,
 -4.730457285407842e-23,  7.131368718084347e-25,  1.097024351375047e-28,  9.534064291709105e-01, -3.532482705036670e-03,  1.094529323087839e-06,  2.907131082032869e-08,
 -2.671982163767530e-11, -4.239651450353430e-13,  6.697103335521284e-16,  7.396435864796174e-18, -1.705885756386751e-20, -1.403303725231389e-22,  4.386040467452524e-25,
  2.776891450563189e-27,  1.042485471335558e+00, -3.544956883082751e-03, -5.795244824104049e-07,  2.970722109427643e-08,  1.098555527462121e-11, -4.480873566069751e-13,
 -2.397624194131980e-16,  8.221365562887157e-18,  5.631422239245681e-21, -1.671015757319318e-22, -1.383319173610217e-25,  3.618239303734874e-27,  1.131506928782909e+00,
 -3.501018837975377e-03, -2.242418135159067e-06,  2.798862242341319e-08,  4.794668019998917e-11, -3.894304740257550e-13, -1.112766798908815e-15,  6.329648173714224e-18,
  2.677963736129627e-20, -1.081173981938082e-22, -6.555233419033462e-25,  1.821825705782275e-27,  1.219753816814422e+00, -3.401281133500048e-03, -3.800525261129513e-06,
  2.404342233303406e-08,  7.868047138053444e-11, -2.584300423911923e-13, -1.702569981491683e-15,  2.330534489677987e-18,  3.673145141638723e-20,  6.914975971557087e-24,
 -7.682630151042432e-25, -1.321587427688292e-27,  1.306501868266139e+00, -3.248201747922785e-03, -5.164920930272753e-06,  1.824856128606035e-08,  9.858999908116595e-11,
 -8.249439012296508e-14, -1.842047958593738e-15, -2.325400760090747e-18,  3.096138311426432e-20,  1.144695696745751e-22, -4.024698673893497e-25, -3.381748606840646e-27,
  1.391025738535962e+00, -3.046073419726064e-03, -6.258047057764468e-06,  1.119385648507529e-08,  1.048262249478531e-10,  1.002151349767793e-13, -1.501377298744499e-15,
 -5.921606370539299e-18,  1.256613406469104e-20,  1.553942465340589e-22,  1.828711832854063e-25, -2.820143158461439e-27,  1.472605674675872e+00, -2.800946589328019e-03,
 -7.019892989193911e-06,  3.616153246843714e-09,  9.685709599541540e-11,  2.501748451365102e-13, -8.004039952194926e-16, -7.192691131188062e-18, -9.270343447924589e-21,
  1.116284232905066e-22,  5.856814555196605e-25, -2.902691376413543e-28,  1.550534587673931e+00, -2.520483234428496e-03, -7.413150058224648e-06, -3.689408314127842e-09,
  7.660678946550439e-11,  3.366148082076799e-13,  3.157112953516472e-17, -5.857570491929800e-18, -2.416126349097372e-20,  1.643129347871489e-23,  5.609898405238510e-25,
  2.011891129024587e-27,  1.624125445721100e+00, -2.213741797904826e-03, -7.426832147484430e-06, -9.970219241298064e-09,  4.810829589473421e-11,  3.454952382642811e-13,
  7.359719214092459e-16, -2.710549996872540e-18, -2.603672108773484e-20, -6.938511019348604e-23,  1.914834421140153e-25,  2.345517623910231e-27,  1.692718884761361e+00,
 -1.890896754929258e-03, -7.077941019950674e-06, -1.461552976767867e-08,  1.671486821756929e-11,  2.829102752014065e-13,  1.115866113843044e-15,  7.824239054582210e-19,
 -1.608784184179717e-20, -9.854876693033326e-23, -2.071827943574159e-25,  8.686701136121288e-28,  1.755690912087811e+00, -1.562899998791462e-03, -6.410894708245272e-06,
 -1.723971583720669e-08, -1.198149360184719e-11,  1.727346570530278e-13,  1.102520519773834e-15,  3.187823724243212e-18, -1.427125891267724e-21, -6.635102058536242e-23,
 -3.562511651607978e-25, -7.910861910309827e-28,  1.812460560490939e+00, -1.241094921451923e-03, -5.494622064464617e-06, -1.773619230557258e-08, -3.329856951675158e-11,
  4.907098034237021e-14,  7.710047947812715e-16,  3.755684099666298e-18,  9.583389606267230e-21, -7.541079348724603e-24, -2.216565323903407e-25, -1.250430439851049e-27,
  1.862497336011211e+00, -9.367975540430266e-04, -4.417442025811264e-06, -1.629226889368134e-08, -4.442300848659758e-11, -5.424889554013850e-14,  2.987475068923527e-16,
  2.689029217971829e-18,  1.228233999340700e-20,  3.410329260415694e-23,  9.169171292568335e-27, -5.524604971017867e-28,  1.905328293682620e+00, -6.608621106380928e-04,
 -3.280071123058046e-06, -1.336079330635340e-08, -4.495330236604933e-11, -1.137971592062400e-13, -1.148123747902638e-16,  9.084089684708583e-19,  7.797622823491296e-21,
  3.806286720384802e-23,  1.309836893193787e-25,  2.565284938502596e-28,  1.940544576872708e+00, -4.232504241114601e-04, -2.187311573992013e-06, -9.591152757942834e-09,
 -3.688838084450147e-11, -1.230161958142680e-13, -3.321672252600126e-16, -5.331090016836453e-19,  1.181507318620689e-21,  1.628787242430452e-23,  9.619080093588553e-26,
  4.227403423388976e-28,  1.967807284226048e+00, -2.326256875059040e-04, -1.239137405791860e-06, -5.728998235368306e-09, -2.405275238631843e-11, -9.287204216431066e-14,
 -3.282863103395677e-16, -1.037141444463815e-18, -2.734860802371652e-21, -4.593159330769610e-24,  7.208765259951284e-27,  1.210775594638942e-28,  1.986852719038189e+00,
 -9.598942650440932e-05, -5.219876589744275e-07, -2.499642026521928e-09, -1.108798939672965e-11, -4.651264094384353e-14, -1.861792275648798e-16, -7.130953229341568e-19,
 -2.608940206764496e-21, -9.057127968344085e-24, -2.941051049630486e-26, -8.664518569682133e-29,  1.997499657562076e+00, -1.836023290670990e-05, -1.009856925420139e-07,
 -4.928806950777034e-10, -2.250392336812412e-12, -9.838180076656295e-15, -4.168729926201754e-17, -1.724216777831739e-19, -6.991433530589119e-22, -2.786905234351733e-24,
 -1.093989315746803e-26, -4.233301192373136e-29,  9.010755920101736e-04, -6.085880724298401e-06,  3.081469255999138e-08, -1.386116839849659e-10,  5.841176438849729e-13,
 -2.361043933311567e-15,  9.269017671688780e-18, -3.560495634936213e-20,  1.344546986899177e-22, -5.007399995810099e-25,  1.843194222320051e-27, -6.716442035948334e-30,
  8.101772575158324e-03, -5.454097810432279e-05,  2.743233089077573e-07, -1.220158219230536e-09,  5.054593287077747e-12, -1.993979878908085e-14,  7.572968717156603e-17,
 -2.784499496465325e-19,  9.936247232806014e-22, -3.441972198989256e-24,  1.155395153720422e-26, -3.742898270085179e-29,  2.246098666595085e-02, -1.502188779569898e-04,
  7.454625694969443e-07, -3.240437956869021e-09,  1.295382515444579e-11, -4.849393180947971e-14,  1.708814470254439e-16, -5.647822756430043e-19,  1.727091281868894e-21,
 -4.729104235788049e-24,  1.061090549682181e-26, -1.288737858197292e-29,  4.389433433820924e-02, -2.906778616985741e-04,  1.413284693866721e-06, -5.928147325533580e-09,
  2.237560066998110e-11, -7.655825368445357e-14,  2.337074750937205e-16, -6.027287439822766e-19,  1.076052348124430e-21,  4.782467340134115e-25, -1.695733063246665e-26,
  1.067854233447916e-28,  7.227518614401507e-02, -4.723125585871745e-04,  2.233360811190678e-06, -8.910988231801616e-09,  3.087853832058387e-11, -9.090382230812826e-14,
  2.043342924705210e-16, -1.743596196600955e-19, -1.488233139947488e-21,  1.187151033060149e-23, -5.701158249989968e-26,  2.089537224422561e-28,  1.074346165583760e-01,
 -6.904226548318646e-04,  3.150094798752924e-06, -1.175409314303474e-08,  3.592007151367411e-11, -8.029443767568924e-14,  5.027670528332088e-17,  7.144202110977961e-19,
 -5.088073391744748e-21,  2.197417709083051e-23, -6.635547503275229e-26,  1.006814169481799e-28,  1.491613619831591e-01, -9.393045441259124e-04,  4.099678650352070e-06,
 -1.400616045341758e-08,  3.533079975947373e-11, -3.902421463898438e-14, -2.145526455448023e-16,  1.775358416732270e-18, -7.582512723441278e-21,  1.994817697179131e-23,
 -7.421319133864245e-27, -2.664226023034110e-28,  1.972018085183468e-01, -1.212365827229452e-03,  5.013577370528775e-06, -1.524928400945972e-08,  2.775578046974026e-11,
  3.064524977352145e-14, -5.255160928390784e-16,  2.512382138372456e-18, -6.603001840990428e-21, -3.444075960193118e-25,  1.075032278869223e-25, -6.366452511226925e-28,
  2.512600368180004e-01, -1.502262388342807e-03,  5.822403085381699e-06, -1.514790661013745e-08,  1.298959428929457e-11,  1.178452510096580e-13, -7.809580452400822e-16,
  2.416345907041566e-18, -1.036764979668229e-21, -3.318868794129758e-23,  2.026611466397676e-25, -5.769482841862166e-28,  3.109979571857017e-01, -1.801057492072145e-03,
  6.460010609454920e-06, -1.349208080629288e-08, -7.857479464706870e-12,  2.046023418039876e-13, -8.717197259499395e-16,  1.211109938305301e-18,  7.838521745426392e-21,
 -6.055353836245158e-23,  1.801236231998316e-25,  1.274649874840487e-28,  3.760355739750908e-01, -2.100401937855740e-03,  6.867621316001680e-06, -1.023034215550773e-08,
 -3.240430779876752e-11,  2.693608684414492e-13, -7.186772787053359e-16, -9.526945631502415e-19,  1.633275537645293e-20, -6.071903925986899e-23, -1.540391428642812e-27,
  1.127257014805252e-27,  4.459514242433997e-01, -2.391733762669462e-03,  6.997760546892479e-06, -5.488040277042550e-09, -5.726783035818969e-11,  2.919092085973414e-13,
 -3.066934664686236e-16, -3.455424797042934e-18,  1.972867758415943e-20, -2.248214869139855e-23, -2.676192375488998e-25,  1.601657516380737e-27,  5.202832413002690e-01,
 -2.666495286313054e-03,  6.817778225661074e-06,  4.320386847178860e-10, -7.853442471897089e-11,  2.586751862439302e-13,  2.972517141771168e-16, -5.368356372062961e-18,
  1.463220533818713e-20,  4.352634476963552e-23, -4.449627170012097e-25,  8.707410592170231e-28,  5.985288990743575e-01, -2.916364442593793e-03,  6.312715553477254e-06,
  7.068490772705423e-09, -9.237602979202017e-11,  1.671221063272999e-13,  9.506667407179763e-16, -5.786255592205609e-18,  1.192279390084598e-21,  1.051933875441989e-22,
 -3.679906015289777e-25, -8.912174201444451e-28,  6.801476977848953e-01, -3.133496340809150e-03,  5.487285791789293e-06,  1.383945532698678e-08, -9.572142361073796e-11,
  2.801382174166599e-14,  1.468910502068490e-15, -4.219913768125726e-18, -1.609057538999103e-20,  1.239687970750524e-22, -1.280647222309854e-26, -2.510076869200849e-27,
  7.645620548723868e-01, -3.310769875836757e-03,  4.366757417195670e-06,  2.009789676157865e-08, -8.687130922986188e-11, -1.353335562155417e-13,  1.678484228697872e-15,
 -8.861277287229968e-19, -2.974934935309040e-20,  7.822038823183818e-23,  4.425399971827945e-25, -2.567813155338128e-27,  8.511596670489929e-01, -3.442032990737382e-03,
  2.996566387583820e-06,  2.519954357474925e-08, -6.594010689794376e-11, -2.910611504669618e-13,  1.475284085910946e-15,  3.254049759949659e-18, -3.264888373538942e-20,
 -1.890122641059523e-23,  7.017322221330878e-25, -6.170628924742713e-28,  9.392962091370856e-01, -3.522338953732437e-03,  1.440543151511848e-06,  2.857690179893705e-08,
 -3.502195708677496e-11, -4.054731205652213e-13,  8.684341776877851e-16,  6.773337145044905e-18, -2.176704124567228e-20, -1.205124934967732e-22,  5.478652032686727e-25,
  2.170099523364413e-27,  1.028298632478714e+00, -3.548164826992709e-03, -2.222797518044521e-07,  2.981106191367760e-08,  1.984992757471862e-12, -4.510645015125870e-13,
 -7.951458585547388e-18,  8.304566371119669e-18, -4.451289867946252e-22, -1.694167553607440e-22,  2.304266422436244e-26,  3.682661407518439e-27,  1.117469119495753e+00,
 -3.517602288738917e-03, -1.902213340482052e-06,  2.869207133548790e-08,  3.990584688053836e-11, -4.139170534602854e-13, -9.241596096355980e-16,  7.119430518840743e-18,
  2.243678682006548e-20, -1.325129972160711e-22, -5.589254283242767e-25,  2.552944379579306e-27,  1.206089740853724e+00, -3.430510257346861e-03, -3.504628556987663e-06,
  2.525876549421702e-08,  7.310922602220185e-11, -2.983758260314668e-13, -1.620864781099453e-15,  3.503892414521990e-18,  3.641524299178685e-20, -2.475544481363836e-23,
 -8.095268876959008e-25, -5.354038942482880e-28,  1.293427847103680e+00, -3.288618509042350e-03, -4.936535837571705e-06,  1.981038006242634e-08,  9.649334009642113e-11,
 -1.273692299684955e-13, -1.892692800223872e-15, -1.272098363213574e-18,  3.475693699038497e-20,  9.542934070482183e-23, -5.483170866685547e-25, -3.213401694324568e-27,
  1.378742207274968e+00, -3.095571839012701e-03, -6.113597814096686e-06,  1.288509722029404e-08,  1.064570238270948e-10,  6.224307251664492e-14, -1.660703046127532e-15,
 -5.428824123016116e-18,  1.826054745799362e-20,  1.600592262379445e-22,  4.637587403880751e-26, -3.368778800455131e-27,  1.461289882543896e+00, -2.856905439613103e-03,
 -6.967039322966032e-06,  5.204782002805827e-09,  1.016520260147430e-10,  2.285187574905994e-13, -1.005316295409032e-15, -7.420559692423495e-18, -4.834944924096533e-21,
  1.345970278923605e-22,  5.575417647515145e-25, -1.004743343489317e-27,  1.540333794031829e+00, -2.579944177807865e-03, -7.449846563208189e-06, -2.409857471966398e-09,
  8.333292910209562e-11,  3.353177101363374e-13, -1.431443009866559e-16, -6.616765945951358e-18, -2.314502639408327e-20,  4.058025771531596e-23,  6.446645589543421e-25,
  1.765254933042791e-27,  1.615150910652106e+00, -2.273621408898977e-03, -7.541625321019231e-06, -9.144275088754227e-09,  5.518819023430761e-11,  3.621514207313245e-13,
  6.480482965961761e-16, -3.582004705362413e-18, -2.837092510823677e-20, -5.956135366405418e-23,  3.020979112237513e-25,  2.673579472102732e-27,  1.685040946902472e+00,
 -1.948216842563739e-03, -7.251531297873633e-06, -1.430136478321553e-08,  2.264234136411890e-11,  3.098924494137027e-13,  1.130022351979775e-15,  2.093319846300227e-19,
 -1.977436519917502e-20, -1.059396286916475e-22, -1.589601683921789e-25,  1.335398011701802e-27,  1.749335423316125e+00, -1.615017649736446e-03, -6.618802777122687e-06,
 -1.740231427695522e-08, -8.255001951222647e-12,  2.002587907388108e-13,  1.190761148659256e-15,  3.101121460089238e-18, -4.080296169114228e-21, -8.125695989455532e-23,
 -3.878989837941563e-25, -6.333246907661628e-28,  1.807406906221619e+00, -1.285912211109346e-03, -5.710617292048391e-06, -1.826007629699845e-08, -3.212341306926271e-11,
  6.887134406415482e-14,  8.804036573017044e-16,  4.056187007758702e-18,  9.138588595780969e-21, -1.755923123693487e-23, -2.805123130384024e-25, -1.423387563534844e-27,
  1.858678211346388e+00, -9.729312820116639e-04, -4.617248331809462e-06, -1.701130087286316e-08, -4.542995392598282e-11, -4.612989291299768e-14,  3.797275929717634e-16,
  3.101727431591388e-18,  1.351028113240238e-20,  3.392610345559234e-23, -1.953308882277850e-26, -7.590919783410341e-28,  1.902631331190520e+00, -6.877563988988253e-04,
 -3.444791725967159e-06, -1.409839423311039e-08, -4.725458902040509e-11, -1.162179317699679e-13, -8.567025754576182e-17,  1.180889895748248e-18,  9.264838654010209e-21,
  4.351930702443677e-23,  1.415826679900069e-25,  2.213083130032172e-28,  1.938815834848231e+00, -4.412195154989653e-04, -2.306029299078511e-06, -1.020148757997385e-08,
 -3.942960950726489e-11, -1.311624922414334e-13, -3.464713008362954e-16, -4.851387208725268e-19,  1.841802684782738e-21,  2.052870639451282e-23,  1.163906149299329e-25,
  4.968395981674840e-28,  1.966856510447729e+00, -2.428204650126801e-04, -1.310257158485220e-06, -6.129139939085053e-09, -2.599138593019909e-11, -1.011094329211351e-13,
 -3.585758861413327e-16, -1.127235895229493e-18, -2.893635638963445e-21, -4.186619525138962e-24,  1.342487399086576e-26,  1.632190878913616e-28,  1.986460215203806e+00,
 -1.002883988375251e-04, -5.530793140050574e-07, -2.684741619467569e-09, -1.206459259492519e-11, -5.123028594355872e-14, -2.073653818425941e-16, -8.020330051168540e-19,
 -2.957119174135895e-21, -1.031288290925603e-23, -3.345497703732542e-26, -9.731650567712090e-29,  1.997424562516114e+00, -1.919240414267216e-05, -1.071229724304593e-07,
 -5.305171296726457e-10, -2.457565412807963e-12, -1.089923286096254e-14, -4.684402911910188e-17, -1.964877632536560e-19, -8.078192141866165e-22, -3.264154824468795e-24,
 -1.298496257209574e-26, -5.090285987662940e-29,  8.772147893725087e-04, -5.845861176558305e-06,  2.920590760376430e-08, -1.296318123336234e-10,  5.390430212336451e-13,
 -2.150080748156569e-15,  8.329702793473445e-18, -3.157716095113131e-20,  1.176869422310064e-22, -4.325955576987993e-25,  1.571763308519969e-27, -5.653749789279499e-30,
  7.887907005455807e-03, -5.240361405802508e-05,  2.601538037569797e-07, -1.142378930569335e-09,  4.673359006097553e-12, -1.821236391581128e-14,  6.836022224756550e-17,
 -2.485504636250293e-19,  8.776501547110054e-22, -3.011172503922063e-24,  1.002367384228717e-26, -3.225903448827624e-29,  2.187179716082878e-02, -1.444072672718151e-04,
  7.077895826126016e-07, -3.040718220436164e-09,  1.202370875825723e-11, -4.457645317176871e-14,  1.558162637135996e-16, -5.121585470491020e-19,  1.564341423112482e-21,
 -4.316575904490791e-24,  1.000336551837932e-26, -1.456013148578706e-29,  4.275379334858772e-02, -2.796501634726621e-04,  1.344245426848273e-06, -5.582087948670319e-09,
  2.089917856196272e-11, -7.114788868674362e-14,  2.173148479057402e-16, -5.681417197899896e-19,  1.082131692484030e-21, -1.126702691520390e-25, -1.274393812682265e-26,
  8.543431448054815e-29,  7.042100412489742e-02, -4.548651370216593e-04,  2.129334153915382e-06, -8.431211530140025e-09,  2.910908046473162e-11, -8.606338597735446e-14,
  1.988467071808469e-16, -2.155677130630760e-19, -1.099763733278012e-21,  9.767007195825463e-24, -4.840579577784884e-26,  1.825670271997741e-28,  1.047224477777233e-01,
 -6.657764442424022e-04,  3.012441243748492e-06, -1.119214706856675e-08,  3.432777742434421e-11, -7.886543717728294e-14,  6.811633789527821e-17,  5.637556611373716e-19,
 -4.343670729804439e-21,  1.941289244826617e-23, -6.161702439129796e-26,  1.133165359159423e-28,  1.454686876834994e-01, -9.071698616998849e-04,  3.934969864447570e-06,
 -1.344737489166036e-08,  3.450271044925020e-11, -4.360371510268417e-14, -1.681321500736643e-16,  1.544129405011564e-18, -6.872325024492749e-21,  1.944099517250519e-23,
 -1.737096760310991e-26, -1.885655377786640e-28,  1.924314142159400e-01, -1.172981582079780e-03,  4.833268587743478e-06, -1.480095006651805e-08,  2.824813634388896e-11,
  1.885316437948191e-14, -4.581237936967750e-16,  2.301664541073089e-18, -6.544489780132639e-21,  3.423894122033810e-24,  8.160613526542893e-26, -5.413681781278286e-28,
  2.453429996890635e-01, -1.456406557385003e-03,  5.641949748872564e-06, -1.492221330807190e-08,  1.516452579104648e-11,  9.990935192180957e-14, -7.139335815644625e-16,
  2.365567499533006e-18, -2.091777740896910e-21, -2.559156470191844e-23,  1.772019724828068e-25, -5.761244533441397e-28,  3.038960593725433e-01, -1.750026860640047e-03,
  6.297482709827921e-06, -1.358618881115866e-08, -3.971760444955139e-12,  1.841143810896005e-13, -8.346147439960610e-16,  1.428462112173897e-18,  5.789150768614247e-21,
 -5.328895843214332e-23,  1.818872482849020e-25, -3.985725005039163e-29,  3.677430587475455e-01, -2.045960434423828e-03,  6.741921116787176e-06, -1.070665852946933e-08,
 -2.719143702647892e-11,  2.518495497564443e-13, -7.383638090401027e-16, -4.649400381998091e-19,  1.415701519347618e-20, -5.986520616634116e-23,  4.237021312326760e-26,
  8.717731825414722e-28,  4.364960148610843e-01, -2.336030240131927e-03,  6.926597629642899e-06, -6.358051640129257e-09, -5.151072426370568e-11,  2.834580632384178e-13,
 -3.947425265574705e-16, -2.838986770276216e-18,  1.874334580423390e-20, -3.180812408550085e-23, -1.995290278489810e-25,  1.485327201092182e-27,  5.097263478056010e-01,
 -2.611953288559626e-03,  6.815595229006725e-06, -7.827866022395307e-10, -7.330147686534318e-11,  2.640596966819527e-13,  1.537044932369137e-16, -4.878410438163420e-18,
  1.588866932903377e-20,  2.656470642460580e-23, -4.015437769467977e-25,  1.087181236452939e-27,  5.869649468304665e-01, -2.865548295082352e-03,  6.388783509866573e-06,
  5.618398538688288e-09, -8.881851412093822e-11,  1.880016333558547e-13,  7.897343767195923e-16, -5.690420066310385e-18,  4.706169739879780e-21,  8.983508725520192e-23,
 -3.964133662400231e-25, -4.094599994108884e-28,  6.677025241074733e-01, -3.088959742024262e-03,  5.644194580673608e-06,  1.231426905235517e-08, -9.481846265133697e-11,
  6.179571417480676e-14,  1.344213332763496e-15, -4.663714725398069e-18, -1.166256840777267e-20,  1.213549846946658e-22, -1.151024817011547e-25, -2.128709968336791e-27,
  7.513903373159302e-01, -3.274894937987256e-03,  4.599510274784945e-06,  1.868848085150828e-08, -8.917769836448899e-11, -9.545252875091923e-14,  1.640791335350466e-15,
 -1.789859459277939e-18, -2.664244472098455e-20,  9.361742986816693e-23,  3.264845040849075e-25, -2.681637130653811e-27,  8.374413694251903e-01, -3.416869247023391e-03,
  3.292444870976788e-06,  2.409988469914115e-08, -7.140049365166726e-11, -2.546794666312418e-13,  1.551706743084635e-15,  2.203750772170086e-18, -3.283242123618363e-20,
  8.429072862935520e-24,  6.601158440562850e-25, -1.257307124377086e-27,  9.252320596057684e-01, -3.509453051853880e-03,  1.779840093895332e-06,  2.795287024070038e-08,
 -4.290805659534266e-11, -3.824374217482808e-13,  1.047714947426611e-15,  6.011780987574951e-18, -2.568983757545725e-20, -9.688931686628089e-23,  6.281829581939819e-25,
  1.469204052733004e-27,  1.014104682194117e+00, -3.548512279410526e-03,  1.353460300978434e-07,  2.977072006731963e-08, -7.019403050689949e-12, -4.484722330978625e-13,
  2.234631963226388e-16,  8.193231686548964e-18, -6.488711557206588e-21, -1.652814958074132e-22,  1.826785688201566e-25,  3.539818131651232e-27,  1.103370470009681e+00,
 -3.531432558289500e-03, -1.554354423482903e-06,  2.926320223159747e-08,  3.142225442342641e-11, -4.336281805412211e-13, -7.155104686416942e-16,  7.756996566906032e-18,
  1.729270867880408e-20, -1.524337933017731e-22, -4.326784616327414e-25,  3.161267660261571e-27,  1.192313572892515e+00, -3.457315446437597e-03, -3.194708563118231e-06,
  2.637869508407181e-08,  6.676132499917896e-11, -3.359686431732672e-13, -1.506620490610449e-15,  4.648640459039250e-18,  3.493780307783789e-20, -5.735484140775291e-23,
 -8.140635800631091e-25,  3.396030815112026e-28,  1.280195930860927e+00, -3.327133860998348e-03, -4.689640002160488e-06,  2.133141654564695e-08,  9.348948654102715e-11,
 -1.730925848673563e-13, -1.912255737708758e-15, -1.094131735271479e-19,  3.776438030706532e-20,  7.076527343278468e-23, -6.821158919872182e-25, -2.833059892666616e-27,
  1.366263122607483e+00, -3.143833100259951e-03, -5.948722845753437e-06,  1.459615251016356e-08,  1.072913678427097e-10,  2.063347431899758e-14, -1.803662323909390e-15,
 -4.752232773352859e-18,  2.401908497798271e-20,  1.588129967809319e-22, -1.118184970153800e-25, -3.797866555370748e-27,  1.449751223200880e+00, -2.912363936829948e-03,
 -6.894676962163676e-06,  6.866395588351081e-09,  1.059642246208151e-10,  2.018850039129428e-13, -1.214499463593040e-15, -7.493545919236920e-18,  3.992449192615049e-22,
  1.557852384352786e-22,  4.960770736447788e-25, -1.799275841871796e-27,  1.529894669296324e+00, -2.639635448764053e-03, -7.470544362329525e-06, -1.023130911151024e-09,
  8.998949570111847e-11,  3.295768525810476e-13, -3.385267673395113e-16, -7.328910132627848e-18, -2.120223365565537e-20,  6.781084743965242e-23,  7.138419372041297e-25,
  1.349989202831285e-27,  1.605935085971184e+00, -2.334377769700104e-03, -7.645816896199957e-06, -8.202510733601969e-09,  6.257808797245204e-11,  3.763965449269862e-13,
  5.347376293342068e-16, -4.521614338902684e-18, -3.026851681444247e-20, -4.504288192326512e-23,  4.256913494475310e-25,  2.929075078002933e-27,  1.677130977455477e+00,
 -2.006908919124888e-03, -7.420764706021232e-06, -1.388803031947444e-08,  2.911148583432415e-11,  3.370082524657583e-13,  1.126443347603808e-15, -4.855721040396796e-19,
 -2.368709785695342e-20, -1.109698870502548e-22, -8.865180851219009e-26,  1.870749035965989e-27,  1.742768126541143e+00, -1.668805313772392e-03, -6.828285748106808e-06,
 -1.750077092756699e-08, -3.957098233839778e-12,  2.298614694920621e-13,  1.275303167336046e-15,  2.920702750528500e-18, -7.290953638514564e-21, -9.726333533925685e-23,
 -4.105790478334097e-25, -3.802868788026735e-28,  1.802170487546970e+00, -1.332482258339023e-03, -5.932772774432083e-06, -1.876184424353170e-08, -3.052532186664043e-11,
  9.139629120955131e-14,  9.979597874714637e-16,  4.336216774922399e-18,  8.288955407356884e-21, -3.008014635691807e-23, -3.466763810099081e-25, -1.580020661318044e-27,
  1.854711299852855e+00, -1.010698234805670e-03, -4.825773976791324e-06, -1.774503533200747e-08, -4.625412520017529e-11, -3.592427565522360e-14,  4.728107012627800e-16,
  3.553377585613842e-18,  1.470887226813988e-20,  3.240636309011729e-23, -5.827775434865357e-26, -1.009549991424318e-27,  1.899824099069841e+00, -7.160044861966929e-04,
 -3.618585930807082e-06, -1.487316237680424e-08, -4.959665083122630e-11, -1.178422501305810e-13, -4.821126775492699e-17,  1.503542986627225e-18,  1.093567569203105e-20,
  4.936108122006402e-23,  1.500464694138159e-25,  1.580566381772837e-28,  1.937013269596849e+00, -4.601683484739227e-04, -2.432320435601798e-06, -1.085380361905613e-08,
 -4.213707532107246e-11, -1.396334340369594e-13, -3.591122953647539e-16, -4.134337991152357e-19,  2.670120321159228e-21,  2.564521918705742e-23,  1.400351418953113e-25,
  5.792195507828544e-28,  1.965863788471299e+00, -2.536039474328523e-04, -1.386370287432451e-06, -6.561658127469490e-09, -2.810224402487352e-11, -1.101046040302698e-13,
 -3.914566734060308e-16, -1.222125164203108e-18, -3.032822785289920e-21, -3.491042129097111e-24,  2.174727827672576e-26,  2.172642399636609e-28,  1.986050003561339e+00,
 -1.048452621820242e-04, -5.864891235632417e-07, -2.886250183413430e-09, -1.314084176897021e-11, -5.648758363300972e-14, -2.312047995332021e-16, -9.028678833092793e-19,
 -3.353532381361200e-21, -1.174001182552763e-23, -3.798390927588278e-26, -1.086310720475461e-28,  1.997346037646624e+00, -2.007553817533415e-05, -1.137325008696858e-07,
 -5.716450626928886e-10, -2.687253841954503e-12, -1.209254279698433e-14, -5.272599601338091e-17, -2.243229283939510e-19, -9.352441109956577e-22, -3.831273052704123e-24,
 -1.544699491432975e-26, -6.135096720393433e-29,  8.542889899410678e-04, -5.618292822033919e-06,  2.770068931382191e-08, -1.213405681195979e-10,  4.979710577520447e-13,
 -1.960366218990356e-15,  7.496008602871619e-18, -2.804868989813095e-20,  1.031877176451922e-22, -3.744283044927921e-25,  1.343035089307807e-27, -4.769622715308576e-30,
  7.682369948072865e-03, -5.037597377815223e-05,  2.468821613175341e-07, -1.070432333328631e-09,  4.324970455009039e-12, -1.665215541893615e-14,  6.177823609731911e-17,
 -2.221254054970153e-19,  7.761353492074609e-22, -2.637257693093356e-24,  8.704383514158661e-27, -2.782029814639909e-29,  2.130526615988536e-02, -1.388877010966461e-04,
  6.724264646357263e-07, -2.855272704195224e-09,  1.116844265758473e-11, -4.100343231281426e-14,  1.421538312802973e-16, -4.645100147837612e-19,  1.415989979521689e-21,
 -3.929544030001318e-24,  9.342416960618468e-27, -1.536193703083839e-29,  4.165628426783353e-02, -2.691585620331096e-04,  1.279220638328358e-06, -5.258806713698267e-09,
  1.952710800103625e-11, -6.611932205598880e-14,  2.018904045194197e-16, -5.336697622310152e-19,  1.069756260660384e-21, -5.526426865814961e-25, -9.381753145020903e-27,
  6.797715139131176e-29,  6.863498315872235e-02, -4.382273734160790e-04,  2.030898119601304e-06, -7.978979208072786e-09,  2.743502782619392e-11, -8.136716059199830e-14,
  1.923684006951778e-16, -2.454927754385783e-19, -7.811342606902465e-22,  7.984157723781075e-24, -4.091256138523320e-26,  1.584203250201647e-28,  1.021067034820547e-01,
 -6.422049194691031e-04,  2.881379196095176e-06, -1.065542718354408e-08,  3.276801670430841e-11, -7.705630089137342e-14,  8.205726023507675e-17,  4.354742239603277e-19,
 -3.687949856196677e-21,  1.704996867382310e-23, -5.649009284160398e-26,  1.187130283431412e-28,  1.419019589139908e-01, -8.763262596727299e-04,  3.776884176416210e-06,
 -1.290251310195477e-08,  3.359366081218083e-11, -4.714426804074646e-14, -1.278711579328169e-16,  1.335263867385810e-18, -6.186777185885389e-21,  1.859963235353999e-23,
 -2.424292038179976e-26, -1.261616157672677e-28,  1.878157061931273e-01, -1.135018170605292e-03,  4.658379574857451e-06, -1.434653928438322e-08,  2.852034835444917e-11,
  8.608023033957379e-15, -3.965863582024621e-16,  2.094798044565326e-18, -6.367970072978501e-21,  6.238404191609826e-24,  5.976592759271984e-26, -4.526231317125564e-28,
  2.396065165832068e-01, -1.411982954956809e-03,  5.464401969351173e-06, -1.466450399480965e-08,  1.699669134763344e-11,  8.356140918448885e-14, -6.487638421672608e-16,
  2.285208573021916e-18, -2.891552652082281e-21, -1.900524352742391e-23,  1.522764571235419e-25, -5.539405690808510e-28,  2.969956779379769e-01, -1.700299943491230e-03,
  6.134185183185375e-06, -1.362135306156068e-08, -4.864397616314414e-13,  1.645828015407273e-13, -7.923026859590592e-16,  1.584418807477013e-18,  4.000918420141186e-21,
 -4.608816391948915e-23,  1.772447397820283e-25, -1.645788145233446e-28,  3.596662640969629e-01, -1.992546004632242e-03,  6.610993928400796e-06, -1.110239195094290e-08,
 -2.233245166521335e-11,  2.340218123709000e-13, -7.453610321136106e-16, -4.600003371204534e-20,  1.204097425329395e-20, -5.747364905063230e-23,  7.551104169481328e-26,
  6.389169968052807e-28,  4.272622170342676e-01, -2.280936229107791e-03,  6.845541324418354e-06, -7.137410504338151e-09, -4.594239443207268e-11,  2.730970089659481e-13,
 -4.660195369811964e-16, -2.258936277590142e-18,  1.746995015974401e-20, -3.852579499819112e-23, -1.374911914968880e-25,  1.329530089398758e-27,  4.993874970660176e-01,
 -2.557485636039602e-03,  6.799339652261984e-06, -1.913205648523663e-09, -6.799415780699870e-11,  2.661676872277959e-13,  2.434934749738955e-17, -4.357675382523286e-18,
  1.656782178967495e-20,  1.150305086841389e-23, -3.506195395110488e-25,  1.213616615568498e-27,  5.756053674631315e-01, -2.814192210323870e-03,  6.447804984690403e-06,
  4.228358558272599e-09, -8.488175084732079e-11,  2.050631728978618e-13,  6.329751821403495e-16, -5.491165378585721e-18,  7.651653930039029e-21,  7.374694612948102e-23,
 -4.049294374681405e-25,  1.107525752929786e-29,  6.554378918647372e-01, -3.043240785991869e-03,  5.782909576988944e-06,  1.080876871245371e-08, -9.327071542298878e-11,
  9.245165474876215e-14,  1.209053902894368e-15, -4.968080845952434e-18, -7.398107497875389e-21,  1.150020542012350e-22, -1.994000091314432e-25, -1.697551728279333e-27,
  7.383657356347986e-01, -3.237226196320613e-03,  4.815154867352170e-06,  1.724848613298508e-08, -9.069750278986737e-11, -5.676807007834403e-14,  1.579262744528389e-15,
 -2.586204579571795e-18, -2.306560244645025e-20,  1.043170145650473e-22,  2.087498972587513e-25, -2.646939331165826e-27,  8.238283752347788e-01, -3.389392688395520e-03,
  3.574627558130777e-06,  2.291877036076491e-08, -7.611728698729749e-11, -2.168163068551644e-13,  1.598784115138245e-15,  1.162946394367592e-18, -3.206852364269162e-20,
  3.356435523405968e-23,  5.928495275053016e-25, -1.778542738362268e-27,  9.112248320264146e-01, -3.493884836473983e-03,  2.110907532468782e-06,  2.720657308931417e-08,
 -5.029221185100060e-11, -3.553682457023819e-13,  1.204046646574246e-15,  5.138860955245770e-18, -2.871196211015129e-20, -7.068697018969788e-23,  6.765002029737602e-25,
  7.238978399392602e-28,  9.999150575963470e-01, -3.546003105283468e-03,  4.916259724011169e-07,  2.958702296480128e-08, -1.591677867990465e-11, -4.403850937680283e-13,
  4.490840327678526e-16,  7.892100813135932e-18, -1.227054056701279e-20, -1.549454485578068e-22,  3.316558250628769e-25,  3.201394048769794e-27,  1.089222105299088e+00,
 -3.542454877922716e-03, -1.200468472855271e-06,  2.969571967338158e-08,  2.259586240479425e-11, -4.481367335863890e-13, -4.914145981109147e-16,  8.219501990799003e-18,
  1.152841206988089e-20, -1.668159152816917e-22, -2.832167501167463e-25,  3.601591083956041e-27,  1.178435225497849e+00, -3.481589301705681e-03, -2.871983111844680e-06,
  2.739120316937066e-08,  5.969155034110479e-11, -3.704413881789835e-13, -1.361161384712636e-15,  5.727374393601763e-18,  3.229293469620856e-20, -8.935139965117689e-23,
 -7.791358849098916e-25,  1.248700114775537e-27,  1.266814017897240e+00, -3.363601923177556e-03, -4.424810328248915e-06,  2.279706137867962e-08,  8.956916034260812e-11,
 -2.188847696023069e-13, -1.898056793452599e-15,  1.134307258263768e-18,  3.979218534266726e-20,  4.114645689394225e-23, -7.945244070281660e-25, -2.242917443015239e-27,
  1.353593761170222e+00, -3.190693068589213e-03, -5.763263164601764e-06,  1.631372016448365e-08,  1.072608514547026e-10, -2.415907496251769e-14, -1.925112871320407e-15,
 -3.893341521191072e-18,  2.961472613535710e-20,  1.509079952279957e-22, -2.853207004167548e-25, -4.056517029606913e-27,  1.437992015549678e+00, -2.967162647047788e-03,
 -6.801979730195123e-06,  8.592469830702406e-09,  1.096934794022982e-10,  1.702259438858349e-13, -1.423270442296512e-15, -7.387377497721582e-18,  6.343390156063106e-21,
  1.738009091161656e-22,  3.986340730229457e-25, -2.632143483692774e-27,  1.519216556245918e+00, -2.699423939066666e-03, -7.473967044783453e-06,  4.689207578617033e-10,
  9.648277843128448e-11,  3.189154844739960e-13, -5.528279427576160e-16, -7.962704971457317e-18, -1.823421536912861e-20,  9.739026092954723e-23,  7.607831255364488e-25,
  7.533272980361991e-28,  1.596474643220950e+00, -2.395920427713713e-03, -7.737988970502404e-06, -7.140385613887755e-09,  7.022352931279114e-11,  3.876001601476169e-13,
  3.943532665986447e-16, -5.512609894808071e-18, -3.155201796093469e-20, -2.538620383546394e-23,  5.581791795633988e-25,  3.070685300326915e-27,  1.668983565919537e+00,
 -2.066933222137848e-03, -7.584399200115385e-06, -1.336686255472030e-08,  3.612043760525458e-11,  3.637903764372307e-13,  1.101631042563565e-15, -1.307991165338677e-18,
 -2.772446332304881e-20, -1.126996617644867e-22,  6.450229345284385e-27,  2.458956272132656e-27,  1.735982321610386e+00, -1.724272352762717e-03, -7.038517710478801e-06,
 -1.752561638064209e-08,  9.526776723354216e-13,  2.614203881479754e-13,  1.353267348250311e-15,  2.628171923054461e-18, -1.109119554232976e-20, -1.139219604100352e-22,
 -4.196793809192754e-25, -1.303434685028564e-29,  1.796744196721398e+00, -1.380853164361549e-03, -6.160780685257446e-06, -1.923428284099212e-08, -2.844790085526271e-11,
  1.168331681247312e-13,  1.122904634899600e-15,  4.581322458993154e-18,  6.939346892484255e-21, -4.537675298909090e-23, -4.190443538036599e-25, -1.701889375554371e-27,
  1.850589928078997e+00, -1.050168819865358e-03, -5.043176414900400e-06, -1.849019787547611e-08, -4.685079769663158e-11, -2.332863703631959e-14,  5.790664965254577e-16,
  4.042185810327562e-18,  1.582207717226062e-20,  2.910283127856552e-23, -1.090629579540934e-25, -1.306691429831852e-27,  1.896901034108127e+00, -7.456807551809011e-04,
 -3.801903096468521e-06, -1.568561137102046e-08, -5.196144501725421e-11, -1.184529030398961e-13, -9.374093705809285e-19,  1.883087018633477e-18,  1.282214725252228e-20,
  5.547543427506759e-23,  1.549376848882434e-25,  5.716044206187773e-29,  1.935132837722591e+00, -4.801595711209541e-04, -2.566704923529545e-06, -1.155081020694048e-08,
 -4.501681495654795e-11, -1.483804947510488e-13, -3.693454320863702e-16, -3.120858400601045e-19,  3.700550594010071e-21,  3.178224609810649e-23,  1.674691390895013e-25,
  6.688331588702554e-28,  1.964826681054791e+00, -2.650176838667931e-04, -1.467882355208125e-06, -7.029433061373762e-09, -3.040111463373097e-11, -1.199212745744816e-13,
 -4.270524653807974e-16, -1.320998625144624e-18, -3.140366561733748e-21, -2.410860677405363e-24,  3.276355395681816e-26,  2.862137134134745e-28,  1.985621014169815e+00,
 -1.096793773517662e-04, -6.224239290100104e-07, -3.105851974732511e-09, -1.432819466480218e-11, -6.235239004257166e-14, -2.580531655056075e-16, -1.017245955824560e-18,
 -3.804704275592666e-21, -1.335838566782909e-23, -4.301982523394152e-26, -1.202998638760353e-28,  1.997263871272169e+00, -2.101358691656092e-05, -1.208584277688844e-07,
 -6.166468837830408e-10, -2.942285735947851e-12, -1.343685288950703e-14, -5.944764403397336e-17, -2.565822945241074e-19, -1.084974553799199e-21, -4.506714439773063e-24,
 -1.841801043904994e-26, -7.411981570531234e-29,  8.322499951695014e-04, -5.402379124214816e-06,  2.629114482558332e-08, -1.136771754618791e-10,  4.605010378455229e-13,
 -1.789525339743289e-15,  6.754918588243024e-18, -2.495238213744664e-20,  9.062678880254592e-23, -3.246774566621205e-25,  1.149874077750522e-27, -4.032357554735602e-30,
  7.484736442748475e-03, -4.845114564583628e-05,  2.344414353511820e-07, -1.003818657337590e-09,  4.006264483589130e-12, -1.524139076466165e-14,  5.589262611035027e-17,
 -1.987432607337419e-19,  6.871768977269214e-22, -2.312400143374017e-24,  7.566241453137238e-27, -2.400915549073060e-29,  2.076026138620926e-02, -1.336423657954348e-04,
  6.392088890082867e-07, -2.682957133913556e-09,  1.038146333874938e-11, -3.774282367391704e-14,  1.297611542024035e-16, -4.213909576606895e-19,  1.281089138478333e-21,
 -3.569456744471496e-24,  8.660662144390488e-27, -1.554134964377220e-29,  4.059972524863461e-02, -2.591720070912596e-04,  1.217946760449742e-06, -4.956693823324958e-09,
  1.825198479859819e-11, -6.144941798165607e-14,  1.874234272719549e-16, -4.998227284267547e-19,  1.043786637019299e-21, -8.724930243964014e-25, -6.714267439248143e-27,
  5.375726409505136e-29,  6.691397200658131e-02, -4.223558391938242e-04,  1.937731235512994e-06, -7.552789044769576e-09,  2.585328274202166e-11, -7.683537450628751e-14,
  1.851856902802054e-16, -2.661928048850845e-19, -5.215419724395889e-22,  6.480483702287311e-24, -3.442969414082375e-26,  1.366507274467105e-28,  9.958318848824714e-02,
 -6.196565499153639e-04,  2.756609299713079e-06, -1.014335700884686e-08,  3.124750551480870e-11, -7.495339112115574e-14,  9.268756151162100e-17,  3.268547526421495e-19,
 -3.113561038277232e-21,  1.489520435591788e-23, -5.124701150926483e-26,  1.188906755664770e-28,  1.384561162353258e-01, -8.467214420956624e-04,  3.625247389067185e-06,
 -1.237271203875556e-08,  3.262300173368669e-11, -4.978628680247711e-14, -9.315617720779037e-17,  1.147803308874946e-18, -5.535841723880004e-21,  1.753424764773871e-23,
 -2.866861713918971e-26, -7.701651153077806e-29,  1.833490882118688e-01, -1.098432000535679e-03,  4.488963116500029e-06, -1.388933404462292e-08,  2.860196102413683e-11,
 -2.290009269024165e-16, -3.407480301790519e-16,  1.895040229287753e-18, -6.104933096502622e-21,  8.255054086496397e-24,  4.165265130984835e-26, -3.721666205549319e-28,
  2.340449073799793e-01, -1.368966890669472e-03,  5.290112072907573e-06, -1.438001153644829e-08,  1.851734249150231e-11,  6.874785986778453e-14, -5.861681661022965e-16,
  2.182860345626128e-18, -3.471887403043092e-21, -1.339170923689490e-23,  1.286678298685684e-25, -5.172913153869957e-28,  2.902915900387784e-01, -1.651880175754971e-03,
  5.970787567990596e-06, -1.360382068740821e-08,  2.618725526892069e-12,  1.461128845790012e-13, -7.463863121581518e-16,  1.687253837054912e-18,  2.467353397406345e-21,
 -3.917149798608181e-23,  1.679506863478645e-25, -2.522531636399914e-28,  3.518010040848649e-01, -1.940196693046154e-03,  6.475772616256945e-06, -1.142323931724438e-08,
 -1.783078940451689e-11,  2.161593420813990e-13, -7.415612679839996e-16,  3.068404767278083e-19,  1.003249381134656e-20, -5.395337510376005e-23,  9.901146648450193e-26,
  4.342160715201285e-28,  4.182474412361377e-01, -2.226526579490810e-03,  6.755660148000167e-06, -7.829421368603753e-09, -4.059710129806692e-11,  2.612153921353084e-13,
 -5.216586364258396e-16, -1.723038789569978e-18,  1.599766045133221e-20, -4.290685540544230e-23, -8.286333161782368e-26,  1.151056555370888e-27,  4.892661729763235e-01,
 -2.503200842523956e-03,  6.770029408107060e-06, -2.958533995192636e-09, -6.267453252767199e-11,  2.653480903569858e-13, -9.019961131595649e-17, -3.823480394976420e-18,
  1.674254132897685e-20, -1.434295011994894e-24, -2.958967743124418e-25,  1.262031061543418e-27,  5.644520526796369e-01, -2.762429580270599e-03,  6.490534513118079e-06,
  2.903834304228151e-09, -8.064087431139882e-11,  2.184395555828951e-13,  4.830273615578143e-16, -5.206952753731187e-18,  1.001610391706987e-20,  5.766735548929569e-23,
 -3.965182803643064e-25,  3.586174143766662e-28,  6.433582411223567e-01, -2.996483907579332e-03,  5.903726807711054e-06,  9.332758407736972e-09, -9.114289923294858e-11,
  1.197766886174515e-13,  1.067243895703472e-15, -5.140256690411425e-18, -3.418403182665507e-21,  1.056640131702614e-22, -2.642309635987499e-25, -1.248879600464869e-27,
  7.254951492874333e-01, -3.197901772804297e-03,  5.013398873773174e-06,  1.579027647949038e-08, -9.146012277796464e-11, -1.981461215069035e-14,  1.497090370783653e-15,
 -3.262831324751888e-18, -1.918761498209188e-20,  1.103770796742351e-22,  9.543916024461845e-26, -2.484557803770080e-27,  8.103297107022553e-01, -3.359716586824559e-03,
  3.842209222673516e-06,  2.166829697523121e-08, -8.006786134979577e-11, -1.781694217001917e-13,  1.617193272356467e-15,  1.605028805078600e-19, -3.045335225130715e-20,
  5.559035177583854e-23,  5.056712033936080e-25, -2.159975694804331e-27,  8.972851148893621e-01, -3.475705869911422e-03,  2.432329029167258e-06,  2.634665588301494e-08,
 -5.709949649598366e-11, -3.248504546715099e-13,  1.334726767004575e-15,  4.184634172903902e-18, -3.076394047590661e-20, -4.320968439281867e-23,  6.919718502617988e-25,
 -1.571387157645814e-29,  9.857411528151854e-01, -3.540654914976909e-03,  8.448536832200520e-07,  2.926255276597116e-08, -2.459905193116514e-11, -4.270047572734316e-13,
  6.637468994571785e-16,  7.413022789402289e-18, -1.757707559135622e-20, -1.390002546792834e-22,  4.619035429435503e-25,  2.693962889088776e-27,  1.075035342940505e+00,
 -3.550627770026478e-03, -8.422482645086549e-07,  2.998498971773033e-08,  1.353402169627076e-11, -4.571328638910636e-13, -2.570203873668317e-16,  8.490454173920308e-18,
  5.358122967324812e-21, -1.748893426186500e-22, -1.187095138350198e-25,  3.840911730996783e-27,  1.164465020457682e+00, -3.503234727070193e-03, -2.537808371890866e-06,
  2.828527898357546e-08,  5.196962363443586e-11, -4.010712766425865e-13, -1.186853419948016e-15,  6.703390284300699e-18,  2.853095466237720e-20, -1.191543223528834e-22,
 -7.045811581335954e-25,  2.130402532215874e-27,  1.253290579751677e+00, -3.397882132766764e-03, -4.142799397880487e-06,  2.419268471763088e-08,  8.473925256004573e-11,
 -2.639119720104165e-13, -1.848291393015733e-15,  2.425043512237223e-18,  4.067956750495842e-20,  7.608546392871936e-24, -8.766867329457829e-25, -1.463063675455906e-27,
  1.340740057646956e+00, -3.235986993593855e-03, -5.557225654051640e-06,  1.802348291402989e-08,  1.063073871945593e-10, -7.155792740868802e-14, -2.020060059377433e-15,
 -2.861301170698518e-18,  3.479866798913328e-20,  1.358957506633356e-22, -4.656102943792776e-25, -4.099740959155307e-27,  1.426015228761327e+00, -3.021135963372811e-03,
 -6.688233371978819e-06,  1.037287586741913e-08,  1.127398022618631e-10,  1.336141175902800e-13, -1.626314006138474e-15, -7.081443399837716e-18,  1.285710490961332e-20,
  1.871863294762730e-22,  2.646804203864249e-25, -3.448939256915471e-27,  1.508299350337041e+00, -2.759166444225861e-03, -7.458869709771966e-06,  2.062873855005303e-09,
  1.027100237550669e-10,  3.029096609996813e-13, -7.833833473699336e-16, -8.484177683326786e-18, -1.417435938031785e-20,  1.282683086606975e-22,  7.774487889207224e-25,
 -2.497836093261053e-29,  1.586766638763727e+00, -2.458147384962939e-03, -7.816674805556891e-06, -5.954333424544118e-09,  7.805708205516888e-11,  3.950976256986298e-13,
  2.257597520750979e-16, -6.532322781272955e-18, -3.203137510399984e-20, -3.487913702812352e-25,  6.935725151166691e-25,  3.053636527849320e-27,  1.660593481373186e+00,
 -2.128239638157291e-03, -7.741089272293951e-06, -1.272930686959508e-08,  4.365713606119077e-11,  3.896860431450557e-13,  1.051978433388732e-15, -2.259816814842097e-18,
 -3.174929411690600e-20, -1.100976472237955e-22,  1.281311850691850e-25,  3.073538076791752e-27,  1.728971284873427e+00, -1.781421055959505e-03, -7.248555329813674e-06,
 -1.746675736617829e-08,  6.511606518238489e-12,  2.947378592922555e-13,  1.421247694218234e-15,  2.204401561257629e-18, -1.549346648013252e-20, -1.305839210346263e-22,
 -4.097899373142712e-25,  4.853882254559987e-28,  1.791120739089881e+00, -1.431070205931051e-03, -6.394241104579732e-06, -1.966924763499145e-08, -2.583122709673345e-11,
  1.453456676595042e-13,  1.254020992049405e-15,  4.773861540342811e-18,  4.985800007839985e-21, -6.365993897249834e-23, -4.955769148790068e-25, -1.764835427121141e-27,
  1.846307138690819e+00, -1.091414534457962e-03, -5.269569309258934e-06, -1.924274859482710e-08, -4.716892712866739e-11, -8.014718973104465e-15,  6.994868117245044e-16,
  4.564295288008546e-18,  1.677651176422250e-20,  2.349247635448100e-23, -1.739619210703893e-25, -1.650866077684817e-27,  1.893856268340923e+00, -7.768632027753836e-04,
 -3.995196863474712e-06, -1.653592939296563e-08, -5.432620960795184e-11, -1.177944305638029e-13,  5.784212706955877e-17,  2.326548287147506e-18,  1.493106494725249e-20,
  6.168303313806312e-23,  1.543490924712561e-25, -9.315485891348422e-29,  1.933170236709985e+00, -5.012601226539624e-04, -2.709735758998255e-06, -1.229530446815849e-08,
 -4.807370175079054e-11, -1.573351598893510e-13, -3.762444244456572e-16, -1.740095770713479e-19,  4.972632292344509e-21,  3.909718103786478e-23,  1.989673208399340e-25,
  7.634697882353119e-28,  1.963742578045743e+00, -2.771066105601790e-04, -1.555235045715957e-06, -7.535607957000068e-09, -3.290508773429690e-11, -1.306258153630202e-13,
 -4.654584057381253e-16, -1.422600018462126e-18, -3.200314342899780e-21, -8.241792490941368e-25,  4.720737498264987e-26,  3.737241204537927e-28,  1.985172096202999e+00,
 -1.148118439585461e-04, -6.611119290577280e-07, -3.345425910613622e-09, -1.563955537121307e-11, -6.890167495383968e-14, -2.883152841561636e-16, -1.147033594932241e-18,
 -4.317887346808369e-21, -1.518847034309886e-23, -4.856855870084145e-26, -1.318418110878076e-28,  1.997177835167081e+00, -2.201087463093120e-05, -1.285497760831148e-07,
 -6.659533869669487e-10, -3.225893088140736e-12, -1.495388642280528e-14, -6.714345915366847e-17, -2.940461713885075e-19, -1.261302640074889e-21, -5.313034560058749e-24,
 -2.201185095123623e-26, -8.976311570125575e-29,  8.110526708413845e-04, -5.197383877756747e-06,  2.497007363056166e-08, -1.065869062829955e-10,  4.262767684411985e-13,
 -1.635474078631240e-15,  6.095156871115753e-18, -2.223079763046465e-20,  7.972528949692354e-23, -2.820415892055553e-25,  9.864047517588709e-28, -3.416172619437798e-30,
  7.294608141359850e-03, -4.662273045724633e-05,  2.227703845619020e-07, -9.420860124339008e-10,  3.714412671843778e-12, -1.396433552333262e-14,  5.062356012685966e-17,
 -1.780291368847157e-19,  6.091327609084873e-22, -2.029878909940222e-24,  6.583649658582868e-27, -2.073615693568482e-29,  2.023571927271571e-02, -1.286547091571071e-04,
  6.079856509654702e-07, -2.522727293533076e-09,  9.656817273330337e-12, -3.476562729358483e-14,  1.185172863689604e-16, -3.823865871554377e-19,  1.158659968858651e-21,
 -3.236657691290930e-24,  7.981167236227541e-27, -1.528589322829368e-29,  3.958215454729543e-02, -2.496614816099293e-04,  1.160178847332427e-06, -4.674254264072076e-09,
  1.706686384029739e-11, -5.711545259668763e-14,  1.738909415273039e-16, -4.669715370299561e-19,  1.008079791895112e-21, -1.097331439561762e-24, -4.611652257966775e-27,
  4.221676454799652e-29,  6.525498811325012e-02, -4.072096063245493e-04,  1.849529745996130e-06, -7.151191264093395e-09,  2.436040722677469e-11, -7.248203826921827e-14,
  1.775318846745500e-16, -2.794037810615540e-19, -3.116387239058416e-22,  5.217670044463518e-24, -2.885223157348747e-26,  1.172565958076000e-28,  9.714790899209098e-02,
 -5.980821704618419e-04,  2.637839706438567e-06, -9.655265683299183e-09,  2.977136787934670e-11, -7.262984350261751e-14,  1.005224705075276e-16,  2.354149989554918e-19,
 -2.612977690834558e-21,  1.294914763396000e-23, -4.608115985573205e-26,  1.154314324839483e-28,  1.351263065255845e-01, -8.183045561160760e-04,  3.479873429333415e-06,
 -1.185882071822157e-08,  3.160742072495912e-11, -5.165581555146418e-14, -6.340445901689918e-17,  9.805288783840718e-19, -4.925957014001214e-21,  1.633164807749067e-23,
 -3.118502236504369e-26, -3.904481286303265e-29,  1.790261390093676e-01, -1.063179207051355e-03,  4.325035354108176e-06, -1.343216599657253e-08,  2.851978654524156e-11,
 -7.792010248445490e-15, -2.903751239319945e-16,  1.704728119759616e-18, -5.781509169159776e-21,  9.615325786079350e-24,  2.688054991296248e-26, -3.008255614317295e-28,
  2.286525959718905e-01, -1.327331098289838e-03,  5.119372553187632e-06, -1.407347821269547e-08,  1.975650340913161e-11,  5.540029957579623e-14, -5.266691301539653e-16,
  2.064995883043430e-18, -3.866716713123825e-21, -8.687289213724750e-24,  1.068853995171699e-25, -4.717453598078605e-28,  2.837785693370075e-01, -1.604765930462157e-03,
  5.807886443400065e-06, -1.353950009826003e-08,  5.365717942893396e-12,  1.287741951220460e-13, -6.982407140374725e-16,  1.744920072329880e-18,  1.175255054767980e-21,
 -3.269415349228587e-23,  1.555053946913974e-25, -3.087962215226985e-28,  3.441429550866193e-01, -1.888943355281277e-03,  6.337121530981254e-06, -1.167490989779073e-08,
 -1.368470137927056e-11,  1.984994810355262e-13, -7.287615230389315e-16,  5.976016291977864e-19,  8.165574036422910e-21, -4.966428596682136e-23,  1.141755400888527e-25,
  2.601977806896207e-28,  4.094488153730457e-01, -2.172867760393426e-03,  6.657979926170406e-06, -8.437876150562379e-09, -3.550160654792699e-11,  2.481730436358601e-13,
 -5.629729856771906e-16, -1.236371922199913e-18,  1.440505878681125e-20, -4.526333289718522e-23, -3.632509411889826e-26,  9.638785586961855e-28,  4.793614416917331e-01,
 -2.449199261975084e-03,  6.728684896941302e-06, -3.919023753193522e-09, -5.739757788739621e-11,  2.619590246130157e-13, -1.897798229444188e-16, -3.290720877995002e-18,
  1.649124715578267e-20, -1.216002419319811e-23, -2.405051409559417e-25,  1.246412457885878e-27,  5.535063730786868e-01, -2.710387518559904e-03,  6.517785077425987e-06,
  1.649111616734456e-09, -7.616777107660419e-11,  2.283207040326517e-13,  3.420103748373829e-16, -4.856246087842362e-18,  1.181122297539966e-20,  4.220727254962342e-23,
 -3.745217701241831e-25,  6.283042871128898e-28,  6.314674396628535e-01, -2.948830720724105e-03,  6.007053616783284e-06,  7.894978862873984e-09, -8.850293426957040e-11,
  1.436544942819370e-13,  9.223419901507377e-16, -5.190922625029506e-18,  1.832033846535625e-22,  9.412634949304912e-23, -3.094575920775364e-25, -8.106133409716045e-28,
  7.127849214945964e-01, -3.157061543290472e-03,  5.194095178031439e-06,  1.432566411975644e-08, -9.150485635210074e-11,  1.495355571295389e-14,  1.397736437551343e-15,
 -3.812730714230945e-18, -1.517103375813038e-20,  1.120794203137503e-22, -8.400043363738858e-27, -2.221129478137365e-27,  7.969539354072382e-01, -3.327960870363680e-03,
  4.094431510352910e-06,  2.036081247801839e-08, -8.324332015003817e-11, -1.394109894870406e-13,  1.608371836978145e-15, -7.782714238267621e-19, -2.811166285735915e-20,
  7.383702596623938e-23,  4.049659965050726e-25, -2.392952799041417e-27,  8.834231884572989e-01, -3.454998611534036e-03,  2.742798688682037e-06,  2.538286616984032e-08,
 -6.326726073606823e-11, -2.915234641925933e-13,  1.437918444356459e-15,  3.180627451190523e-18, -3.182333500396045e-20, -1.575225550615606e-23,  6.758862356168618e-25,
 -7.034267477812441e-28,  9.715942644739710e-01, -3.532498816998952e-03,  1.193363977901636e-06,  2.880158207043015e-08, -3.296338270395012e-11, -4.086521054033396e-13,
  8.627114525010078e-16,  6.774279375061869e-18, -2.222156934099512e-20, -1.183331857100872e-22,  5.667997489884619e-25,  2.056253129799898e-27,  1.060821639026103e+00,
 -3.555923491999175e-03, -4.814316936276350e-07,  3.012813875500530e-08,  4.349011228610667e-12, -4.604350276787567e-13, -1.783834323498081e-17,  8.560593613470156e-18,
 -9.824042977374045e-22, -1.762354971331566e-22,  5.155333473601769e-26,  3.861714189026989e-27,  1.150413645436972e+00, -3.522165984275657e-03, -2.193665481808281e-06,
  2.905113952035807e-08,  4.367907224426635e-11, -4.272044048622233e-13, -9.870591336690584e-16,  7.542506541173115e-18,  2.375890535763512e-20, -1.452212398121211e-22,
 -5.929936859163741e-25,  2.921824305763536e-27,  1.239634637065703e+00, -3.429840646686218e-03, -3.844534132654309e-06,  2.550390240480042e-08,  7.902368358749458e-11,
 -3.073090452188194e-13, -1.762173456419970e-15,  3.724293914636483e-18,  4.030913991608943e-20, -2.848163175527494e-23, -9.210325448003687e-25, -5.317241020595388e-28,
  1.327708604503740e+00, -3.279550882044921e-03, -5.330794179733135e-06,  1.971029276327589e-08,  1.043855938050132e-10, -1.208705508197639e-13, -2.083878881889529e-15,
 -1.673413059501502e-18,  3.931254812350834e-20,  1.137052325482031e-22, -6.424191205180127e-25, -3.893997789981097e-27,  1.413824505054537e+00, -3.074113078096484e-03,
 -6.552854706799022e-06,  1.219590375044871e-08,  1.150059754762570e-10,  9.225599976992700e-14, -1.817808604158612e-15, -6.560463816675360e-18,  1.974774913456881e-20,
  1.945135971061821e-22,  9.631268474834581e-26, -4.185149579561200e-27,  1.497143539462021e+00, -2.818709993451220e-03, -7.424058672653166e-06,  3.753596614209379e-09,
  1.085607168525996e-10,  2.812110034347507e-13, -1.026553546179574e-15, -8.857890628525290e-18, -8.999610571857279e-21,  1.590775332459591e-22,  7.561330567284264e-25,
 -9.689610207093267e-28,  1.576808560665364e+00, -2.520944757741627e-03, -7.880371783663555e-06, -4.641974370596815e-09,  8.599780366801251e-11,  3.982053601325863e-13,
  2.854245445851689e-17, -7.551913110486831e-18, -3.151259370517363e-20,  3.003263832232246e-23,  8.238980427269809e-25,  2.833184246515156e-27,  1.651955715521235e+00,
 -2.190766883204587e-03, -7.889388297177945e-06, -1.196709477127499e-08,  5.169759776229739e-11,  4.140558014754695e-13,  9.738926678635010e-16, -3.337945983043197e-18,
 -3.558632314818347e-20, -1.020879611458546e-22,  2.767449046195569e-25,  3.675703357938467e-27,  1.721728299397153e+00, -1.840245671652363e-03, -7.457330718853804e-06,
 -1.731354037617628e-08,  1.275215435079917e-11,  3.295280028802672e-13,  1.475300883044944e-15,  1.630282955726100e-18, -2.048278526817048e-20, -1.463701373520083e-22,
 -3.748465158721480e-25,  1.127249631959624e-27,  1.785292645931405e+00, -1.483175052971608e-03, -6.632650523979039e-06, -2.005761097531384e-08, -2.261243790911160e-11,
  1.770619594671859e-13,  1.389550068877532e-15,  4.892761140205206e-18,  2.318500529780762e-21, -8.503596563721531e-23, -5.730371389521086e-25, -1.738541485729285e-27,
  1.841855686873950e+00, -1.134507576848891e-03, -5.505012723108820e-06, -1.999777710010738e-08, -4.715067620259984e-11,  1.036796139116486e-14,  8.349196682221413e-16,
  5.113183669084095e-18,  1.747847570428311e-20,  1.497007465929331e-23, -2.549822949850649e-25, -2.038473001725322e-27,  1.890683614552804e+00, -8.096334574665533e-04,
 -4.198920769397004e-06, -1.742389728266106e-08, -5.666265160420976e-11, -1.155684143926330e-13,  1.300168573105453e-16,  2.841051986117327e-18,  1.726128023951796e-20,
  6.771722285134376e-23,  1.458050549131346e-25, -3.069627538035663e-28,  1.931120887224461e+00, -5.235415017311331e-04, -2.861999922156331e-06, -1.309014926034686e-08,
 -5.131099961147677e-11, -1.664041551521486e-13, -3.786660193379844e-16,  9.238060849123274e-21,  6.531740688031180e-21,  4.775600815673619e-23,  2.346722265256686e-25,
  8.592330339707065e-28,  1.962608682234188e+00, -2.899193528543935e-04, -1.648909446263258e-06, -8.083610200536458e-09, -3.563260038947411e-11, -1.422863966000865e-13,
 -5.067266141384361e-16, -1.525086397091267e-18, -3.191756283388840e-21,  1.423678065419482e-24,  6.598956845141189e-26,  4.842073123681401e-28,  1.984702010637118e+00,
 -1.202656810223086e-04, -7.028051607772020e-07, -3.607070234944638e-09, -1.708946889703992e-11, -7.622277746129210e-14, -3.224515782420184e-16, -1.294341040262007e-18,
 -4.901069292478421e-21, -1.725046749294736e-23, -5.460905242227401e-26, -1.424993238466979e-28,  1.997087682990238e+00, -2.307213935807637e-05, -1.368610634935121e-07,
 -7.200507369749965e-10, -3.541776487460280e-12, -1.666887283173105e-14, -7.597182750161136e-17, -3.376461366677183e-19, -1.469420657055402e-21, -6.277868974491111e-24,
 -2.636969870746775e-26, -1.089754037242208e-28,  7.906547163801490e-04, -5.002625948245312e-06,  2.373089909194798e-08, -1.000204123240757e-10,  3.949811561315652e-13,
 -1.496380691758454e-15,  5.506937694369819e-18, -1.983471366642507e-20,  7.024723424872021e-23, -2.454330871883661e-25,  8.477774702398487e-28, -2.900048755884005e-30,
  7.111611346027031e-03, -4.488479799426476e-05,  2.118129288643141e-07, -8.848253463026022e-10,  3.446882949146904e-12, -1.280705099419342e-14,  4.590100235032743e-17,
 -1.596570056419547e-19,  5.405853366702444e-22, -1.783922039389860e-24,  5.734665841627038e-27, -1.792431055022790e-29,  1.973064011901907e-02, -1.239093400626213e-04,
  5.786175234361664e-07, -2.373629737285312e-09,  8.989102827489525e-12, -3.204561009330646e-14,  1.083124565072840e-16, -3.471134756467355e-19,  1.047725923286343e-21,
 -2.930718158577258e-24,  7.319825588788938e-27, -1.473611938895249e-29,  3.860172268013447e-02, -2.405998582130709e-04,  1.105689241418819e-06, -4.410100541721699e-09,
  1.596524820262909e-11, -5.309536490774294e-14,  1.612611858292783e-16, -4.353771912241155e-19,  9.656765340442553e-22, -1.247539331326858e-24, -2.966662114272908e-27,
  3.288513864983811e-29,  6.365520788437258e-02, -3.927501081884196e-04,  1.766006954358244e-06, -6.772793051061939e-09,  2.295273531032349e-11, -6.831611375191478e-14,
  1.695956715611406e-16, -2.865838041544400e-19, -1.433804334271071e-22,  4.161569080946712e-24, -2.407742267012729e-26,  1.001458240085327e-28,  9.479706323309531e-02,
 -5.774349172863492e-04,  2.524787064191790e-06, -9.190411414334197e-09,  2.834338327442343e-11, -7.014723503213203e-14,  1.060110780431686e-16,  1.589125175900913e-19,
 -2.178776981826171e-21,  1.120589171719714e-23, -4.112454306272005e-26,  1.095549071600117e-28,  1.319078770387246e-01, -7.910262738663823e-04,  3.340567557194739e-06,
 -1.136144057548097e-08,  3.056122140070236e-11, -5.286534254953415e-14, -3.806982543049315e-17,  8.320617289402568e-19, -4.360801313196990e-21,  1.505894887340142e-23,
 -3.224105143656967e-26, -1.033773043839198e-29,  1.748416128351926e-01, -1.029215925029239e-03,  4.166580935833396e-06, -1.297745892559616e-08,  2.829801597133924e-11,
 -1.420880386807512e-14, -2.451794793414452e-16,  1.525441027893411e-18, -5.419019788052487e-21,  1.044475773183237e-23,  1.504307978356669e-26, -2.387565001117281e-28,
  2.234241196472546e-01, -1.287046191206538e-03,  4.952421831611484e-06, -1.374917748297429e-08,  2.074271883685725e-11,  4.343983655905172e-14, -4.706228980591596e-16,
  1.937042490220854e-18, -4.107372062402648e-21, -4.812470250501036e-24,  8.722078063872542e-26, -4.216508876382373e-28,  2.774514051073942e-01, -1.558951085540376e-03,
  5.646009638286827e-06, -1.343393857126046e-08,  7.777599055036186e-12,  1.126059155632288e-13, -6.490249768099679e-16,  1.764869645624976e-18,  1.068532390314095e-22,
 -2.675651720670564e-23,  1.411495593486741e-25, -3.400306574822078e-28,  3.366876834519649e-01, -1.838810205371823e-03,  6.195836829022233e-06, -1.186304930837585e-08,
 -9.888113459349463e-12,  1.812379053306100e-13, -7.086328827534819e-16,  8.311945020406640e-19,  6.462217629622120e-21, -4.491262621451442e-23,  1.223652410693177e-25,
  1.170790398601550e-28,  4.008632175903503e-01, -2.120018223077448e-03,  6.553478644399155e-06, -8.966939137610732e-09, -3.067580050081812e-11,  2.342968460339717e-13,
 -5.913844333779233e-16, -8.016824886707500e-19,  1.275914511972299e-20, -4.592302226404521e-23,  1.993033616021176e-27,  7.789827766807155e-28,  4.696719842384648e-01,
 -2.395573111662185e-03,  6.676318452723911e-06, -4.795749288962030e-09, -5.221110166887225e-11,  2.563577907647340e-13, -2.746103592824767e-16, -2.771755470099560e-18,
  1.589339906127861e-20, -2.069944463190021e-23, -1.869415887318197e-25,  1.181322323198919e-27,  5.427692041106733e-01, -2.658186448497989e-03,  6.530414322686203e-06,
  4.673591275874745e-10, -7.153006215811914e-11,  2.349412657477114e-13,  2.115350564984367e-16, -4.456808969649766e-18,  1.306826760450648e-20,  2.784149262612914e-23,
 -3.423640282376829e-25,  8.210506134745921e-28,  6.197687959685203e-01, -2.900419179678788e-03,  6.093395654474890e-06,  6.503070001182689e-09, -8.542023892483871e-11,
  1.640502585223588e-13,  7.775702432881758e-16, -5.133294737621972e-18,  3.341466084666417e-21,  8.115708194063337e-23, -3.360500234360068e-25, -4.050440766074807e-28,
  7.002408345015505e-01, -3.114846004922420e-03,  5.357234353195625e-06,  1.286576439887453e-08, -9.087924348508177e-11,  4.716701549624834e-14,  1.284788385970058e-15,
 -4.233896490350991e-18, -1.116492361251254e-20,  1.098832526519649e-22, -9.896495344065688e-26, -1.886127697071583e-27,  7.837091180239939e-01, -3.294250939787670e-03,
  4.330684659288181e-06,  1.900870170871022e-08, -8.564781035619948e-11, -1.011706536266936e-13,  1.574406902812043e-15, -1.632396469433728e-18, -2.518767504329964e-20,
  8.789391497110776e-23,  2.972442941847343e-25, -2.480225155628498e-27,  8.696489830246882e-01, -3.431855483935065e-03,  3.041133171710319e-06,  2.432584949382610e-08,
 -6.874601219425619e-11, -2.560601430223455e-13,  1.512670702995082e-15,  2.158353612361014e-18, -3.191292071268345e-20,  1.048073622423492e-23,  6.314110981685874e-25,
 -1.300531834589745e-27,  9.574855384825712e-01, -3.521579008804625e-03,  1.535552584336456e-06,  2.820997158268891e-08, -4.091444139471771e-11, -3.857550015071027e-13,
  1.041827753830278e-15,  5.999569556505223e-18, -2.605354787968694e-20, -9.405956230145092e-23,  6.416243922900141e-25,  1.335280085673890e-27,  1.046592532637164e+00,
 -3.558328311565182e-03, -1.197802635961871e-07,  3.012411142710313e-08, -4.844598258672765e-12, -4.579961807144258e-13,  2.204691260783018e-16,  8.428373118235978e-18,
 -7.249175687386708e-21, -1.708178127508277e-22,  2.178865985428325e-25,  3.663684733017152e-27,  1.136292106645318e+00, -3.538309630076009e-03, -1.841144541095168e-06,
  2.968043813327941e-08,  3.491561929200225e-11, -4.482786175253917e-13, -7.660420193837015e-16,  8.214829939952222e-18,  1.813682703155025e-20, -1.661680091570116e-22,
 -4.496580007397444e-25,  3.564542050589899e-27,  1.225855729940087e+00, -3.459351719842342e-03, -3.531111194405292e-06,  2.671685208377182e-08,  7.246377610050587e-11,
 -3.482052900000188e-13, -1.640039746490413e-15,  4.990642552900090e-18,  3.861772072719867e-20, -6.549309486181869e-23, -9.220438664633481e-25,  4.964987134257932e-28,
  1.314506646070455e+00, -3.321222949995035e-03, -5.084338263706567e-06,  2.135839227122040e-08,  1.014650066070789e-10, -1.713001597973895e-13, -2.112544320317261e-15,
 -3.552051451221986e-19,  4.290315490149033e-20,  8.470109386750986e-23, -8.043528724303693e-25, -3.422441207181438e-27,  1.401424178282932e+00, -3.125919106221448e-03,
 -6.395410244988512e-06,  1.404832880775792e-08,  1.164003388448808e-10,  4.650217304172645e-14, -1.991598733092646e-15, -5.816124024530619e-18,  2.677349132895469e-20,
  1.944975037916388e-22, -1.013892467581513e-25, -4.770556544585147e-27,  1.485750242062190e+00, -2.877892343357011e-03, -7.368412653033583e-06,  5.534138375776273e-09,
  1.139183293967259e-10,  2.535704223359941e-13, -1.277704336854735e-15, -9.048513851353673e-18, -2.741471880812929e-21,  1.881617459630967e-22,  6.902444933893170e-25,
 -2.043556952917828e-27,  1.566598376716827e+00, -2.584186550229376e-03, -7.927556952200544e-06, -3.202333364149337e-09,  9.395104950002064e-11,  3.962402190208142e-13,
 -1.968194907556504e-16, -8.536419669140778e-18, -2.980920762216955e-20,  6.536408707981524e-23,  9.392999251857069e-25,  2.369394194245517e-27,  1.643065528968295e+00,
 -2.254441710936119e-03, -8.027753166989492e-06, -1.107244845782910e-08,  6.020419842702941e-11,  4.361756840576126e-13,  8.639521210654576e-16, -4.533048180956322e-18,
 -3.902174297924675e-20, -8.761853622152839e-23,  4.506513417676977e-25,  4.213576352848351e-27,  1.714246689163007e+00, -1.900731385302532e-03, -7.663645237336350e-06,
 -1.705484350933432e-08,  1.970008029040412e-11,  3.654039637197131e-13,  1.510960357119063e-15,  8.877408944565693e-19, -2.600804639340717e-20, -1.601502900015262e-22,
 -3.084107189133828e-25,  1.916655101039727e-27,  1.779252290619468e+00, -1.537204891935186e-03, -6.875389791817989e-06, -2.038922140294392e-08, -1.872657918402909e-11,
  2.120605220899222e-13,  1.527093456687426e-15,  4.913400825793979e-18, -1.173522484936470e-21, -1.094531170439900e-22, -6.467186211823297e-25, -1.586597633519525e-27,
  1.837228038456053e+00, -1.179520373839446e-03, -5.749502007916502e-06, -2.074939049003980e-08, -4.673101107366455e-11,  3.218768841907425e-14,  9.859851001051033e-16,
  5.678966485661105e-18,  1.781108721368795e-20,  2.854824147164585e-24, -3.538531471728950e-25, -2.460110437774825e-27,  1.887376551785934e+00, -8.440767573560787e-04,
 -4.413522800636793e-06, -1.834879291364766e-08, -5.893604005869762e-11, -1.114287075108268e-13,  2.176737013727604e-16,  3.433512599309061e-18,  1.980010715078959e-20,
  7.319926241835880e-23,  1.261604269119487e-25, -6.005948343018615e-28,  1.928979914326502e+00, -5.470800410049138e-04, -3.024118994161928e-06, -1.393824316557410e-08,
 -5.472981255914144e-11, -1.754637616647218e-13, -3.752093255223522e-16,  2.476484878814011e-19,  8.429282033493352e-21,  5.792634108428437e-23,  2.745054912111397e-25,
  9.498479715601861e-28,  1.961421993943698e+00, -3.035085544226643e-04, -1.749429587910761e-06, -8.677173127400534e-09, -3.860346098162076e-11, -1.549717391153151e-13,
 -5.508473506057458e-16, -1.625849179882891e-18, -3.087509425255574e-21,  4.527945617626007e-24,  9.023339033535713e-26,  6.229206267406807e-28,  1.984209422174495e+00,
 -1.260660286682717e-04, -7.477822961315312e-07, -3.893130507018884e-09, -1.869434247259352e-11, -8.441482539405696e-14, -3.609852434829828e-16, -1.461545539975284e-18,
 -5.562940925194615e-21, -1.956296369219617e-23, -6.107874571187404e-26, -1.511207911177804e-28,  1.996993148537656e+00, -2.420257966128017e-05, -1.458530142600353e-07,
 -7.794885604240675e-10, -3.894181338101048e-12, -1.861117556341710e-14, -8.611970322143331e-17, -3.884969919255028e-19, -1.715625233871216e-21, -7.435161245818476e-24,
 -3.166707172068899e-26, -1.326298986500187e-28,  7.710164541529681e-04, -4.817474529189955e-06,  2.256760747993303e-08, -9.393313804867372e-11,  3.663315011811235e-13,
 -1.370632573009407e-15,  4.981753444659367e-18, -1.772186830638687e-20,  6.199251191350307e-23, -2.139410148169106e-25,  7.299799675334629e-28, -2.466807245467655e-30,
  6.935395212604026e-03, -4.323184771306062e-05,  2.015176626340129e-07, -8.316659778793401e-10,  3.201405924029639e-12, -1.175717473004016e-14,  4.166344075862422e-17,
 -1.433430402874528e-19,  4.803098008884701e-22, -1.569570827219639e-24,  5.000490678219899e-27, -1.550749652048017e-29,  1.924408363201584e-02, -1.193919368743902e-04,
  5.509762190016178e-07, -2.234793387805452e-09,  8.373417535293345e-12, -2.955904818626907e-14,  9.904719495317303e-17, -3.152190868002056e-19,  9.473359450723997e-22,
 -2.650686077153523e-24,  6.687173880017436e-27, -1.399654570161869e-29,  3.765668513345211e-02, -2.319617659192861e-04,  1.054266325797047e-06, -4.162945626785312e-09,
  1.494107402130494e-11, -4.936793354727795e-14,  1.494963482859152e-16, -4.052143391534767e-19,  9.189563819531946e-22, -1.339599130717632e-24, -1.691039844836437e-27,
  2.536798016132620e-29,  6.211195750935499e-02, -3.789410058932557e-04,  1.686892520599000e-06, -6.416261447437686e-09,  2.162646390879895e-11, -6.434249626312016e-14,
  1.615283363628839e-16, -2.889524486321144e-19, -9.879503455985518e-24,  3.282043674889219e-24, -2.000789357134533e-26,  8.517098653196114e-29,  9.252703243013345e-02,
 -5.576701568391723e-04,  2.417177246432412e-06, -8.748001225334036e-09,  2.696620247030284e-11, -6.755709137746963e-14,  1.095429732463605e-16,  9.533807187268494e-20,
 -1.803831675292914e-21,  9.655231451960670e-24, -3.646222149481945e-26,  1.021857257255795e-28,  1.287963691838976e-01, -7.648388505438783e-04,  3.207129116584886e-06,
 -1.088096148707103e-08,  2.949658550615843e-11, -5.351472226874329e-14, -1.664601464002528e-17,  7.009406627896636e-19, -3.841940255526955e-21,  1.376692795083869e-23,
 -3.220619123030706e-26,  1.080293263729374e-29,  1.707904389786040e-01, -9.964985221145163e-04,  4.013557663651712e-06, -1.252726961856953e-08,  2.795835673642101e-11,
 -1.959980726650925e-14, -2.048376105792869e-16,  1.358145145046135e-18, -5.034560054666953e-21,  1.085263802982093e-23,  5.737616746815257e-27, -1.856554449094685e-28,
  2.183541367415908e-01, -1.248081072921411e-03,  4.789449734944230e-06, -1.341093912837965e-08,  2.150288193182186e-11,  3.278074413474065e-14, -4.182472612131473e-16,
  1.803472561214760e-18, -4.222155598640819e-21, -1.679573411823216e-24,  6.979846807698152e-26, -3.702822386510067e-28,  2.713049191455494e-01, -1.514425556232702e-03,
  5.485620649264163e-06, -1.329230957097062e-08,  9.877952455785075e-12,  9.762184690126071e-14, -5.996979648929388e-16,  1.753937304227803e-18, -7.584036953664109e-22,
 -2.141437233059176e-23,  1.258755825345727e-25, -3.513803949462637e-28,  3.294306709866470e-01, -1.789815357154302e-03,  6.052647624773830e-06, -1.199317680157345e-08,
 -6.431427545543506e-12,  1.645319048855127e-13, -6.827006476860266e-16,  1.013068363416431e-18,  4.934380461257232e-21, -3.995050535559694e-23,  1.249132110696223e-25,
  3.409571652752743e-30,  3.924873075526464e-01, -2.068028799732187e-03,  6.443082616912444e-06, -9.421042437062898e-09, -2.613338209225831e-11,  2.198788659538571e-13,
 -6.083634989474262e-16, -4.197622272375967e-19,  1.111513345012840e-20, -4.521013392777970e-23,  3.237969630478404e-26,  6.044670101122588e-28,  4.601961288717062e-01,
 -2.342406574215411e-03,  6.613925162053803e-06, -5.590493123506020e-09, -4.715584476710874e-11,  2.488925651795330e-13, -3.452210032741536e-16, -2.276432700991658e-18,
  1.502590168116765e-20, -2.716501641454410e-23, -1.370707085291902e-25,  1.080787360947178e-27,  5.322409534704212e-01, -2.605939798159589e-03,  6.529311587149664e-06,
 -6.392969904143766e-10, -6.679032866093816e-11,  2.385687075668708e-13,  9.273124549824172e-17, -4.025157567125741e-18,  1.383314426133256e-20,  1.491005878388109e-23,
 -3.033261833579926e-25,  9.422140129659398e-28,  6.082650753489853e-01, -2.851382845685571e-03,  6.163343576249270e-06,  5.163559553418873e-09, -8.196418564756130e-11,
  1.810018461867188e-13,  6.357555239842947e-16, -4.982243913564428e-18,  6.017868958278274e-21,  6.746760825378648e-23, -3.458241454810883e-25, -4.828960440673410e-29,
  6.878681092399634e-01, -3.071395210184246e-03,  5.502935564004849e-06,  1.142087760311910e-08, -8.963734969125836e-11,  7.654259911610897e-14,  1.161825731148399e-15,
 -4.528801157777482e-18, -7.299394477853580e-21,  1.043737475539845e-22, -1.737614237561543e-25, -1.509147173656977e-27,  7.706028168059168e-01, -3.258716481560458e-03,
  4.550506721338645e-06,  1.762418532421463e-08, -8.729752606600780e-11, -6.402145134617766e-14,  1.517906529305177e-15, -2.385693819733938e-18, -2.183575439680606e-20,
  9.760554159798462e-23,  1.886741359505109e-25, -2.434262065803641e-27,  8.559720410889012e-01, -3.406377853003466e-03,  3.326281189450667e-06,  2.318693467598325e-08,
 -7.349987322396727e-11, -2.191457164942746e-13,  1.558898396752127e-15,  1.147930461012053e-18, -3.109617158903263e-20,  3.444267257700722e-23,  5.632035023971201e-25,
 -1.778364355181918e-27,  9.434259187737997e-01, -3.507952215466715e-03,  1.869894411230979e-06,  2.749503364617608e-08, -4.836639525254230e-11, -3.588324387753808e-13,
  1.197670577313901e-15,  5.116732762115850e-18, -2.896557490999549e-20, -6.744068473035509e-23,  6.838260380836852e-25,  5.818326480712695e-28,  1.032359589563840e+00,
 -3.557842607946365e-03,  2.409428638245957e-07,  2.997368565218338e-08, -1.393265307316372e-11, -4.499048155856444e-13,  4.523052665160130e-16,  8.099999878249967e-18,
 -1.320381084881269e-20, -1.589822987649500e-22,  3.709716650262726e-25,  3.263637941330028e-27,  1.122111678027205e+00, -3.551605315806524e-03, -1.481926267325140e-06,
  3.016644385749984e-08,  2.578514314953189e-11, -4.638435041198754e-13, -5.288237111340849e-16,  8.696340133598466e-18,  1.187018762176895e-20, -1.808706851716733e-22,
 -2.822254006547726e-25,  4.010285625424857e-27,  1.211963882873450e+00, -3.486299033270945e-03, -3.203789054115144e-06,  2.781847103599409e-08,  6.511809105945184e-11,
 -3.857521779914873e-13, -1.483405874931080e-15,  6.181628792432053e-18,  3.560419998535913e-20, -1.016262380452593e-22, -8.768995011748117e-25,  1.554407787021067e-27,
  1.301142066692793e+00, -3.360845133072924e-03, -4.818418899756696e-06,  2.295166903697366e-08,  9.753200006778488e-11, -2.219628462010057e-13, -2.102856970404634e-15,
  1.059990948907682e-18,  4.533873352969909e-20,  4.971268904970395e-23, -9.397231452706445e-25, -2.689115448528239e-27,  1.388819287736455e+00, -3.176376353963471e-03,
 -6.215633734761109e-06,  1.591552398698991e-08,  1.168397353028794e-10, -3.147169813352175e-15, -2.141411058705011e-15, -4.848542895914775e-18,  3.365063889776872e-20,
  1.861182064529944e-22, -3.202397018971692e-25, -5.135333267422673e-27,  1.474121242919466e+00, -2.936542645979425e-03, -7.290905109067199e-06,  7.395650549031702e-09,
  1.186625427794501e-10,  2.198617492372242e-13, -1.531235698470730e-15, -9.022726965171415e-18,  4.504611446927870e-21,  2.136379538549441e-22,  5.751839134517993e-25,
 -3.193197713698166e-27,  1.556134583096005e+00, -2.647734562956554e-03, -7.956705191291039e-06, -1.636057965275615e-09,  1.018087097147599e-10,  3.885429625071745e-13,
 -4.487871912182551e-16, -9.445220641609778e-18, -2.675643056906207e-20,  1.048248771154624e-22,  1.028378053770070e-24,  1.633058300897139e-27,  1.633918500569250e+00,
 -2.319178168174283e-03, -8.154551544252834e-06, -1.003831230923089e-08,  6.912403854011422e-11,  4.552435471230118e-13,  7.190977840341741e-16, -5.828362444759199e-18,
 -4.180563729764829e-20, -6.575234524770786e-23,  6.456469345027978e-25,  4.622733465143083e-27,  1.706519857443160e+00, -1.962853253018104e-03, -7.866164583959546e-06,
 -1.667920060789866e-08,  2.737229450628760e-11,  4.018658401431742e-13,  1.523282820932155e-15, -3.896352830462310e-20, -3.197280321731329e-20, -1.705362182435034e-22,
 -2.041186201232774e-25,  2.845380510012200e-27,  1.772991908484774e+00, -1.593191451025331e-03, -7.121711662349388e-06, -2.065287900566106e-08, -1.410776076104239e-11,
  2.503536016235186e-13,  1.663514217249558e-15,  4.807678449027913e-18, -5.595588465672781e-21, -1.366377456934001e-22, -7.101930156014863e-25, -1.267371177984781e-27,
  1.832416370105543e+00, -1.226525013929642e-03, -6.002955311673358e-06, -2.149059568980701e-08, -4.583740810169052e-11,  5.782386036450385e-14,  1.152970238965481e-15,
  6.247614499808667e-18,  1.763183009508462e-20, -1.359277024259141e-23, -4.717213599399786e-25, -2.898311090753866e-27,  1.883928211031223e+00, -8.802818797838053e-04,
 -4.639438706457335e-06, -1.930928029461239e-08, -6.110420483473255e-11, -1.049768129302997e-13,  3.230852703265157e-16,  4.110194781578373e-18,  2.251878179599678e-20,
  7.760963072136886e-23,  9.150732440831630e-26, -9.923007715666074e-28,  1.926742127580230e+00, -5.719571850088439e-04, -3.196749357304073e-06, -1.484248070992153e-08,
 -5.832841037818460e-11, -1.843530906228443e-13, -3.641697627297118e-16,  5.529534666830997e-19,  1.072256571445308e-20,  6.976624502693226e-23,  3.180442076561621e-25,
  1.025761069250944e-27,  1.960179294247177e+00, -3.179312358789273e-04, -1.857366248591221e-06, -9.320357963071031e-09, -4.183884351911173e-11, -1.687493483862781e-13,
 -5.977245357964671e-16, -1.721288336296574e-18, -2.852495480920892e-21,  8.733678730072697e-24,  1.213132565751054e-25,  7.960299136067040e-28,  1.983692890313432e+00,
 -1.322403736021929e-04, -7.963517965870055e-07, -4.206231367719056e-09, -2.047269700830507e-11, -9.359033405828156e-14, -4.045100285619453e-16, -1.651312563281645e-18,
 -6.312803574300724e-21, -2.214087945333728e-23, -6.785284823646493e-26, -1.559978539862229e-28,  1.996893943796048e+00, -2.540790748100426e-05, -1.555933759204344e-07,
 -8.448893633753982e-10, -4.287987833210041e-12, -2.081504348585114e-14, -9.780826960681080e-17, -4.479360161952785e-19, -2.007571166710759e-21, -8.826707017894193e-24,
 -3.812270910167485e-26, -1.618270021364100e-28,  7.521006368141073e-04, -4.641344859786139e-06,  2.147469362142300e-08, -8.828480380336843e-11,  3.400754063845473e-13,
 -1.256807793349823e-15,  4.512194910559921e-18, -1.585590802375151e-20,  5.479108952260135e-23, -1.868007714259136e-25,  6.296851562088036e-28, -2.102374214766119e-30,
  6.765630103954626e-03, -4.165877312109864e-05,  1.918374184643685e-07, -7.822716359589762e-10,  2.975945312592861e-12, -1.080372947549159e-14,  3.785678759041249e-17,
 -1.288398918756839e-19,  4.272469820584556e-22, -1.382563232346092e-24,  4.365021627945171e-27, -1.342902909381273e-29,  1.877516481692000e-02, -1.150891637406998e-04,
  5.249434477813423e-07, -2.105421937775467e-09,  7.805310317748392e-12, -2.728448991004824e-14,  9.063148266944252e-17, -2.863806968270189e-19,  8.565798098979466e-22,
 -2.395271234268832e-24,  6.089783006520517e-27, -1.314414514424375e-29,  3.674539558713153e-02, -2.237234665224988e-04,  1.005713359620329e-06, -3.931596167005552e-09,
  1.398869243065934e-11, -4.591289523532327e-14,  1.385547083456296e-16, -3.765903296371707e-19,  8.697650330842282e-22, -1.386790039430963e-24, -7.124041607060012e-28,
  1.933638810406998e-29,  6.062270430756850e-02, -3.657480603255387e-04,  1.611931732498318e-06, -6.080324941473076e-09,  2.037772569922195e-11, -6.056283610882865e-14,
  1.534499442417954e-16, -2.875255064493545e-19,  9.473517469607984e-23,  2.552711479788708e-24, -1.655349786130817e-26,  7.215443619634628e-29,  9.033437201143787e-02,
 -5.387454098741446e-04,  2.314745864400982e-06, -8.327207482108069e-09,  2.564153480000927e-11, -6.490223775982464e-14,  1.114546201465448e-16,  4.290403694268459e-20,
 -1.481434036496629e-21,  8.284299374454776e-24, -3.214397245985183e-26,  9.401191837846533e-29,  1.257875121138214e-01, -7.396961621425896e-04,  3.079353878562975e-06,
 -1.041759375214708e-08,  2.842381586351487e-11, -5.369215393087829e-14,  1.331875522849659e-18,  5.856809198012794e-19, -3.369360083837688e-21,  1.249301321276212e-23,
 -3.138006827447109e-26,  2.585417999909116e-29,  1.668677204348950e-01, -9.649837965381757e-04,  3.865900663918446e-06, -1.208332638154445e-08,  2.752018728833551e-11,
 -2.407741591518855e-14, -1.690060675765082e-16,  1.203319493234612e-18, -4.641576456194348e-21,  1.093251497334011e-23, -1.418054202849447e-27, -1.409223797731499e-28,
  2.134374327327289e-01, -1.210403304968671e-03,  4.630602656933340e-06, -1.306217659898784e-08,  2.206212867453622e-11,  2.333347195465455e-14, -3.696469835175866e-16,
  1.667904020708907e-18, -4.236155541694918e-21,  8.014586360924682e-25,  5.461951839898684e-26, -3.200032383675423e-28,  2.653339806179482e-01, -1.471175791707695e-03,
  5.327123160628435e-06, -1.311940820296302e-08,  1.169042274034316e-11,  8.381499795612909e-14, -5.510366268511864e-16,  1.718275215646966e-18, -1.442417122927748e-21,
 -1.668841749924696e-23,  1.104495385945539e-25, -3.476875716452426e-28,  3.223673382914171e-01, -1.741971353637097e-03,  5.908217820528503e-06, -1.207063483042375e-08,
 -3.302253264286248e-12,  1.485040285703619e-13, -6.523334745589333e-16,  1.148919994974349e-18,  3.585883210323778e-21, -3.497836633601908e-23,  1.230620993694274e-25,
 -8.336598241324948e-29,  3.843175560752683e-01, -2.016943128068944e-03,  6.327663844090970e-06, -9.804792530181247e-09, -2.188256265918617e-11,  2.051758004949359e-13,
 -6.153798695437417e-16, -8.981989605317152e-20,  9.516852626175594e-21, -4.343100034511782e-23,  5.542109234595051e-26,  4.458144091273501e-28,  4.509318828870856e-01,
 -2.289775967690364e-03,  6.542475037466227e-06, -6.305634703579289e-09, -4.226573261459801e-11,  2.398957741893565e-13, -4.023835477818677e-16, -1.812218135966005e-18,
  1.396041430158579e-20, -3.173178093575205e-23, -9.216658634823087e-26,  9.575194637316472e-28,  5.219215895079735e-01, -2.553753795463843e-03,  6.515385896233233e-06,
 -1.669687748259747e-09, -6.200556774795809e-11,  2.394922394473611e-13, -1.371144311933501e-17, -3.576167984131033e-18,  1.416170465589922e-20,  3.627486216899323e-24,
 -2.603811153952869e-25,  1.000227129602880e-27,  5.969585187889692e-01, -2.801850260200376e-03,  6.217559747123099e-06,  3.881874891991434e-09, -7.820274548952382e-11,
  1.946098542150752e-13,  4.992948038082616e-16, -4.753479080446173e-18,  8.198044603718757e-21,  5.368432536491396e-23, -3.411696479468048e-25,  2.496294358505507e-28,
  6.756714090997333e-01, -3.026847778934460e-03,  5.631436216488942e-06,  1.000039829958224e-08, -8.783805271724618e-11,  1.028817657038896e-13,  1.032303758408406e-15,
 -4.703726946891373e-18, -3.682004052675715e-21,  9.621027997875854e-23, -2.315578488251920e-25, -1.117657648934058e-27,  7.576420647908070e-01, -3.221490296392559e-03,
  4.753580474821552e-06,  1.621913673475571e-08, -8.821946239539441e-11, -2.846895217570366e-14,  1.441862107460570e-15, -3.026967892392857e-18, -1.821157672442875e-20,
  1.030498177901281e-22,  8.470306024860169e-26, -2.274925569195010e-27,  8.424014837365276e-01, -3.378674942437337e-03,  3.597330391372008e-06,  2.197791511474337e-08,
 -7.750662414226164e-11, -1.814575968613624e-13,  1.577325846996546e-15,  1.768800056908498e-19, -2.947061271244798e-20,  5.529514795480559e-23,  4.769339833381648e-25,
 -2.119640193379078e-27,  9.294260985663408e-01, -3.491686989265911e-03,  2.194959999093042e-06,  2.666536669440712e-08, -5.524454847724518e-11, -3.284759158400089e-13,
  1.327635391068910e-15,  4.156304557984360e-18, -3.089691810027555e-20, -3.979513682309125e-23,  6.930857698867180e-25, -1.541411184398518e-28,  1.018134345971527e+00,
 -3.554480797450372e-03,  5.989947387986316e-07,  2.967944442493113e-08, -2.280409412049005e-11, -4.363808134187099e-13,  6.723515440231149e-16,  7.589039744936467e-18,
 -1.862687385260054e-20, -1.414282226267887e-22,  5.025757655364305e-25,  2.693676565481749e-27,  1.107883847560249e+00, -3.562006432189459e-03, -1.117761709858266e-06,
  3.050418508475154e-08,  1.640127471909731e-11, -4.735764660384202e-13, -2.810007242736505e-16,  8.970176158360922e-18,  5.198933060689518e-21, -1.885497530238958e-22,
 -1.001569271338899e-25,  4.225751188376300e-27,  1.197969564536135e+00, -3.510576945582677e-03, -2.863976761012190e-06,  2.879676690293820e-08,  5.706170018007500e-11,
 -4.191517658038951e-13, -1.294966988025485e-15,  7.255808889207111e-18,  3.133354841787305e-20, -1.350302699895696e-22, -7.859128328420194e-25,  2.567753704711521e-27,
  1.287623372770061e+00, -3.398264630589970e-03, -4.533791142538951e-06,  2.447393791643478e-08,  9.259131487560458e-11, -2.719099228410298e-13, -2.052649411694683e-15,
  2.531994638144194e-18,  4.642569742098761e-20,  1.002659128574866e-23, -1.037527427688562e-24, -1.721370511009527e-27,  1.376015586597698e+00, -3.225305721427913e-03,
 -6.013442075459764e-06,  1.778161991402431e-08,  1.162525115347297e-10, -5.604237328383123e-14, -2.261107703955970e-15, -3.667435785137413e-18,  4.006540437157594e-20,
  1.687430186320724e-22, -5.491229243852856e-25, -5.217405959777084e-27,  1.462259025913405e+00, -2.994482298621682e-03, -7.190627291349142e-06,  9.327346871233315e-09,
  1.226719325454131e-10,  1.801040029141149e-13, -1.780667813178693e-15, -8.751378799607030e-18,  1.257273871909236e-20,  2.334940567557197e-22,  4.092395524713012e-25,
 -4.342529942866700e-27,  1.545416253088556e+00, -2.711438456970320e-03, -7.966309957839793e-06,  5.437143396518968e-11,  1.094499540951523e-10,  3.745054984462258e-13,
 -7.246156017170681e-16, -1.023298401724002e-17, -2.222749729526803e-20,  1.471172402172925e-22,  1.078804471877440e-24,  6.123317241218000e-28,  1.624510579623374e+00,
 -2.384876920004887e-03, -8.268072044265523e-06, -8.858609253439239e-09,  7.838748436064971e-11,  4.703903959374500e-13,  5.368567240384303e-16, -7.198628955194575e-18,
 -4.365809642479807e-20, -3.578043669525599e-23,  8.544570575416148e-25,  4.828572323238580e-27,  1.698541329511043e+00, -2.026575102324068e-03, -8.063415591360881e-06,
 -1.617496152468346e-08,  3.577448905224342e-11,  4.382901997795333e-13,  1.506935355280484e-15, -1.161635194974688e-18, -3.822618217354430e-20, -1.758970851686615e-22,
 -5.632369043947384e-26,  3.888265265995192e-27,  1.766503620777628e+00, -1.651159924971014e-03, -7.370728171339193e-06, -2.083633203411905e-08, -8.690666081469776e-12,
  2.918683454564097e-13,  1.794843224988134e-15,  4.544332542305521e-18, -1.103808499622074e-20, -1.660212985138780e-22, -7.551199325203415e-25, -7.360333151659771e-28,
  1.827412572006549e+00, -1.275592574830990e-03, -6.265199651975753e-06, -2.221317831135643e-08, -4.438972135690928e-11,  8.765751260229371e-14,  1.335701494755250e-15,
  6.800104828044919e-18,  1.677095227216927e-20, -3.513976136380334e-23, -6.087401019987335e-25, -3.324916897887588e-27,  1.880331361316785e+00, -9.183410118605678e-04,
 -4.877083883127542e-06, -2.030328193151635e-08, -6.311644683590384e-11, -9.575770848278912e-14,  4.486836633944505e-16,  4.876111734127289e-18,  2.536682651031923e-20,
  8.025602571676695e-23,  3.710640493804528e-26, -1.501442587747505e-27,  1.924402000050540e+00, -5.982597675418456e-04, -3.380581848383026e-06, -1.580570065555879e-08,
 -6.210140827720436e-11, -1.928661890733353e-13, -3.434877596670867e-16,  9.388055480697448e-19,  1.347417481071506e-20,  8.340725231182025e-23,  3.643524714910465e-25,
  1.072997896049838e-27,  1.958877126685710e+00, -3.332491848603481e-04, -1.973341017696349e-06, -1.001757535608706e-08, -4.536124020440281e-11, -1.836830789886420e-13,
 -6.471441693982345e-16, -1.806529021296747e-18, -2.441756733959261e-21,  1.434660687253162e-23,  1.608951335051073e-25,  1.010615892840473e-27,  1.983150859463209e+00,
 -1.388188014181914e-04, -8.488554741468090e-07, -4.549312595178379e-09, -2.244545244148830e-11, -1.038769984177720e-13, -4.536985552650188e-16, -1.866612693442711e-18,
 -7.160385852688180e-21, -2.499242919074329e-23, -7.471516552906355e-26, -1.546409847823435e-28,  1.996789756771147e+00, -2.669440799971324e-05, -1.661578581582922e-07,
 -9.169595164697730e-10, -4.728817409413564e-12, -2.332051232466242e-14, -1.112998219219857e-16, -5.175713043525258e-19, -2.354587776654437e-21, -1.050409997871103e-23,
 -4.600987980270593e-26, -1.979565292474424e-28,  7.338722709453870e-04, -4.473694353742519e-06,  2.044711237712974e-08, -8.303895010764915e-11,  3.159872142833542e-13,
 -1.153650620329401e-15,  4.091798566299267e-18, -1.420550445818623e-20,  4.849820630413724e-23, -1.633692338979505e-25,  5.441279313355056e-28, -1.795192273771336e-30,
  6.602006079030370e-03, -4.016082946170941e-05,  1.827288757427517e-07, -7.363369417607084e-10,  2.768671936761773e-12, -9.936956664710932e-15,  3.443342855339204e-17,
 -1.159317695971802e-19,  3.804801266198749e-22, -1.219233918596531e-24,  3.814466645175264e-27, -1.164037235898398e-29,  1.832305018856645e-02, -1.109885940849633e-04,
  5.004100620652013e-07, -1.984786979246381e-09,  7.280738239656327e-12, -2.520253887071541e-14,  8.298393641241643e-17, -2.603039214482265e-19,  7.745977167378609e-22,
 -2.162981723690671e-24,  5.531319317236940e-27, -1.223491902422717e-29,  3.586629961459244e-02, -2.158627399685480e-04,  9.598473931728908e-07, -3.714946005161864e-09,
  1.310284960691510e-11, -4.271101780273192e-14,  1.283922985203534e-16, -3.495605664820450e-19,  8.195189174219417e-22, -1.399768338099319e-24,  2.841629775601562e-29,
  1.451730390530854e-29,  5.918504857459060e-02, -3.531390100903965e-04,  1.540884764106507e-06, -5.763774015371584e-09,  1.920264697040081e-11, -5.697622296039965e-14,
  1.454546105321506e-16, -2.831454099817517e-19,  1.754479212455742e-22,  1.950634878973977e-24, -1.363223739543987e-26,  6.090581455151297e-29,  8.821580315547982e-02,
 -5.206202721261217e-04,  2.217238598155425e-06, -7.927181631010987e-09,  2.437030991266935e-11, -6.221800109083144e-14,  1.120353622891598e-16,  2.969516673313869e-23,
 -1.205368640705663e-21,  7.078784018454762e-24, -2.819358080475431e-26,  8.553437527314481e-29,  1.228772161973760e-01, -7.155537259102547e-04,  2.957036023382863e-06,
 -9.971396344471381e-09,  2.735155952485690e-11, -5.347517676996526e-14,  1.628736689160341e-17,  4.848175486766795e-19, -2.941900293206304e-21,  1.126388283708655e-23,
 -3.000211935286995e-26,  3.607663347803797e-29,  1.630687318443251e-01, -9.346291433760280e-04,  3.723526110927449e-06, -1.164706499709933e-08,  2.700072144147812e-11,
 -2.774566714735422e-14, -1.373335261104373e-16,  1.061063795283650e-18, -4.250416029079082e-21,  1.076323447044458e-23, -6.775595411941656e-27, -1.037862478137395e-28,
  2.086689249447112e-01, -1.173979434878014e-03,  4.475988383524011e-06, -1.270591560100595e-08,  2.244378664451278e-11,  1.500708323181928e-14, -3.248362801658405e-16,
  1.533203662175443e-18, -4.171240223736161e-21,  2.718876859984025e-24,  4.159799806063160e-26, -2.724304335082259e-28,  2.595335189979696e-01, -1.429185235410202e-03,
  5.170865577550850e-06, -1.291965333387961e-08,  1.323834175429644e-11,  7.116171822799471e-14, -5.036555345886379e-16,  1.663328289850115e-18, -1.967331587241648e-21,
 -1.257277593232994e-23,  9.543901361968892e-26, -3.331240688384503e-28,  3.154930660163924e-01, -1.695285679502863e-03,  5.763148473867743e-06, -1.210054972449920e-08,
 -4.860647775833515e-13,  1.332458990979009e-13, -6.187398162879150e-16,  1.244462344585949e-18,  2.414196172809259e-21, -3.014941362435452e-23,  1.179265278434353e-25,
 -1.464434079063879e-28,  3.763502730219643e-01, -1.966798092762785e-03,  6.208038423491230e-06, -1.012288811430018e-08, -1.792676975047587e-11,  1.904094885900716e-13,
 -6.138630653087727e-16,  1.901667779878139e-19,  7.997577417127472e-21, -4.086436891627677e-23,  7.189397651500727e-26,  3.062708422788840e-28,  4.418769636350016e-01,
 -2.237749972985105e-03,  6.462906497252053e-06, -6.944044167548416e-09, -3.756824296611698e-11,  2.296790656398040e-13, -4.470477293936300e-16, -1.384393838439978e-18,
  1.276150764873288e-20, -3.461505888362737e-23, -5.298218558105818e-26,  8.224380860808979e-28,  5.118106702736456e-01, -2.501727355073559e-03,  6.489555024907747e-06,
 -2.623509076596007e-09, -5.722685954321561e-11,  2.380128320301459e-13, -1.074939019277456e-16, -3.122827695276135e-18,  1.411547777044979e-20, -5.902586980016278e-24,
 -2.160867020044166e-25,  1.005323787996061e-27,  5.858508640918145e-01, -2.751944423560771e-03,  6.256765211469470e-06,  2.662374923418571e-09, -7.420133810092566e-11,
  2.050270968703790e-13,  3.701420217989683e-16, -4.462827327089866e-18,  9.888364505354066e-21,  4.033090956974271e-23, -3.247924469841577e-25,  4.842378578147722e-28,
  6.636548474808376e-01, -2.981339997131695e-03,  5.743080682597683e-06,  8.612751684042971e-09, -8.554338802256607e-11,  1.260664236965352e-13,  8.994572876897068e-16,
 -4.768010931993288e-18, -3.959680308232375e-22,  8.607832878196777e-23, -2.722530657930460e-25, -7.353532250732734e-28,  7.448333596291079e-01, -3.182707160929567e-03,
  4.939728266672399e-06,  1.480492053485355e-08, -8.844998541841101e-11,  5.056270581574658e-15,  1.349509472923641e-15, -3.549919607289693e-18, -1.446431627094300e-20,
  1.045034822459741e-22, -1.020981681496852e-26, -2.026839915642575e-27,  8.289459814652385e-01, -3.348862703634404e-03,  3.853511637481337e-06,  2.071083253734311e-08,
 -8.075735918930218e-11, -1.436469442101131e-13,  1.569400082364950e-15, -7.308344099632705e-19, -2.715971683607702e-20,  7.243837232698338e-23,  3.787788823207088e-25,
 -2.318577699737408e-27,  9.154964746793574e-01, -3.472862886036460e-03,  2.509429839841424e-06,  2.573066655169751e-08, -6.148659012541360e-11, -2.953290043838295e-13,
  1.429992737997792e-15,  3.150006210856660e-18, -3.183402453779253e-20, -1.241150649903247e-23,  6.711855195690084e-25, -8.277293388729118e-28,  1.003928252711650e+00,
 -3.548271086170299e-03,  9.526739018986343e-07,  2.924570571229570e-08, -3.135350161555737e-11, -4.177663740108329e-13,  8.757633552666502e-16,  6.915617180005375e-18,
 -2.332965449013162e-20, -1.191521128956378e-22,  6.061556570474043e-25,  1.997837177197304e-27,  1.093620261308761e+00, -3.569480585629340e-03, -7.504504799121490e-07,
  3.069055247452322e-08,  6.882720055155366e-12, -4.772939954284517e-13, -2.853050245953459e-17,  9.027528722920874e-18, -1.616046267713339e-21, -1.888282441656548e-22,
  8.601457299700548e-26,  4.195923311561904e-27,  1.183883642738233e+00, -3.532091641807617e-03, -2.513219551550198e-06,  2.964107224046720e-08,  4.838489469098062e-11,
 -4.476844224034908e-13, -1.078539588020428e-15,  8.174875362786158e-18,  2.593634585669860e-20, -1.639328779225212e-22, -6.526966048933481e-25,  3.461992359916575e-27,
  1.273959668597114e+00, -3.433335456433830e-03, -4.231403179117389e-06,  2.590924383824929e-08,  8.666709108885808e-11, -3.201548393550321e-13, -1.960958454060405e-15,
  4.015253801457492e-18,  4.602434494536497e-20, -3.266155215079798e-23, -1.088484889610992e-24, -5.699035113549006e-28,  1.363019544546219e+00, -3.272528224095598e-03,
 -5.788949023238512e-06,  1.962971259722354e-08,  1.145814524494240e-10, -1.113908896733420e-13, -2.344966180976188e-15, -2.292832747408443e-18,  4.568984942525005e-20,
  1.422344739994218e-22, -7.745077382910710e-25, -4.970356538407937e-27,  1.450166803008066e+00, -3.051525979274691e-03, -7.066811501721603e-06,  1.131651004690542e-08,
  1.258270725003490e-10,  1.344808454305482e-13, -2.018789898450493e-15, -8.211792390123927e-18,  2.122418787801766e-20,  2.457209683275408e-22,  1.943937605706359e-25,
 -5.399785745484277e-27,  1.534443085204540e+00, -2.775135993796578e-03, -7.954906461705097e-06,  1.864447882057526e-09,  1.167425543784107e-10,  3.536012591265805e-13,
 -1.020241295979876e-15, -1.085116461685321e-17, -1.615130463388026e-20,  1.904464717945672e-22,  1.078235397387681e-24, -6.806066087087846e-28,  1.614838140585100e+00,
 -2.451424669017595e-03, -8.366537625580433e-06, -7.528518363164906e-09,  8.790699136165704e-11,  4.806974062470942e-13,  3.155920814356959e-16, -8.609285138023078e-18,
 -4.427973658706281e-20,  2.647459026179297e-24,  1.066381783658839e-24,  4.750977735620596e-27,  1.690304799786949e+00, -2.091848415644522e-03, -8.253785178247965e-06,
 -1.553049184480587e-08,  4.489858371577275e-11,  4.739222550616576e-13,  1.456331218212182e-15, -2.486270599817555e-18, -4.455485506889972e-20, -1.744043499515075e-22,
  1.390558936079241e-25,  4.998625455788224e-27,  1.759779463132869e+00, -1.711127799083128e-03, -7.621398128846634e-06, -2.092630080941426e-08, -2.412460730223319e-12,
  3.364258325788735e-13,  1.916199098104663e-15,  4.089604986166893e-18, -1.756444885990839e-20, -1.966619476984594e-22, -7.711785063257922e-25,  5.187364806619085e-29,
  1.822208253455906e+00, -1.326792333728693e-03, -6.535955529526176e-06, -2.290758108492853e-08, -4.230027228811660e-11,  1.220584833403180e-13,  1.533392443159267e-15,
  7.311542160755582e-18,  1.503131005602659e-20, -6.253077694038525e-23, -7.635364473239631e-25, -3.698246787997426e-27,  1.876578396454250e+00, -9.583495496450230e-04,
 -5.126843619164956e-06, -2.132783312564003e-08, -6.491237249462812e-11, -8.325652408850668e-14,  5.970147181728733e-16,  5.734224348851212e-18,  2.826522265523822e-20,
  8.023950762251427e-23, -4.263223378729223e-26, -2.147004386077996e-27,  1.921953646200497e+00, -6.260802835620053e-04, -3.576340707411485e-06, -1.683061983574269e-08,
 -6.603877595756210e-11, -2.007428567090141e-13, -3.106927834830421e-16,  1.420927182206963e-18,  1.675059111389294e-20,  9.892955710667126e-23,  4.117568456242417e-25,
  1.071753558180306e-27,  1.957511777360430e+00, -3.495293796432385e-04, -2.098030612757701e-06, -1.077360571843455e-08, -4.919435703019016e-11, -1.998298383305637e-13,
 -6.987338644729824e-16, -1.875068156778595e-18, -1.798052308808647e-21,  2.174558184749356e-23,  2.109751520419568e-25,  1.274577727394550e-27,  1.982581647990018e+00,
 -1.458342792059234e-04, -9.056725136643377e-07, -4.925670023735840e-09, -2.463625095797709e-11, -1.154196898617957e-13, -5.093110113605064e-16, -2.110730660377979e-18,
 -8.115527392084869e-21, -2.811469387623909e-23, -8.131729845152429e-26, -1.434712525053777e-28,  1.996680249060676e+00, -2.806900757531688e-05, -1.776312143376510e-07,
 -9.965020970218583e-10, -5.223158997786766e-12, -2.617448874123349e-14, -1.269061566114291e-16, -5.993414427585897e-19, -2.768074168334836e-21, -1.253118982614475e-23,
 -5.567080291809254e-26, -2.427776564818421e-28,  7.162984554382814e-04, -4.314019095350420e-06,  1.948023526068954e-08, -7.816253522249140e-11,  2.938648992573926e-13,
 -1.060050422588689e-15,  3.714916561330810e-18, -1.274361154555317e-20,  4.299037978105878e-23, -1.431043454338269e-25,  4.710052006294482e-28, -1.535748694511501e-30,
  6.444231505205115e-03, -3.873360436803988e-05,  1.741522090458119e-07, -6.935842820752219e-10,  2.577940835133272e-12, -9.148171165927424e-15,  3.135139989357225e-17,
 -1.044302099499111e-19,  3.392149978698817e-22, -1.076428662421628e-24,  3.337011059786103e-27, -1.010000656418159e-29,  1.788695427557766e-02, -1.070786406195650e-04,
  4.772752793820459e-07, -1.872221791185862e-09,  6.796027413528397e-12, -2.329565601758789e-14,  7.603103875695944e-17, -2.367210068892329e-19,  7.005856652767259e-22,
 -1.952223263094847e-24,  5.013350900637503e-27, -1.130897387825424e-29,  3.501792882436431e-02, -2.083587781056342e-04,  9.164982587648044e-07, -3.511970025840347e-09,
  1.227866571684868e-11, -3.974413813264316e-14,  1.189641800292820e-16, -3.241408315718613e-19,  7.692906797176279e-22, -1.387049253736172e-24,  5.796467544147939e-28,
  1.068490384098753e-29,  5.779671590480167e-02, -3.410834553952073e-04,  1.473525932788366e-06, -5.465460870042028e-09,  1.809739298475059e-11, -5.357975349591806e-14,
  1.376149757167027e-16, -2.765076888538663e-19,  2.364743123222956e-22,  1.455987713266928e-24, -1.117054317239953e-26,  5.123391118994930e-29,  8.616820465345126e-02,
 -5.032563329573755e-04,  2.124411377509991e-06, -7.547065533663560e-09,  2.315281689067344e-11, -5.953327316478884e-14,  1.115329891093200e-16, -3.467516420094894e-20,
 -9.699475106565865e-22,  6.023817609513969e-24, -2.461613980148120e-26,  7.710795788552930e-29,  1.200615664400224e-01, -6.923687062456642e-04,  2.839969804305420e-06,
 -9.542301752837901e-09,  2.628701110554081e-11, -5.293165269932236e-14,  2.860361438363336e-17,  3.969363572888307e-19, -2.557599546380117e-21,  1.009768613605910e-23,
 -2.826082336743061e-26,  4.252883519723446e-29,  1.593889168229249e-01, -9.053926927000978e-04,  3.586334534928216e-06, -1.121966201431995e-08,  2.641517662498028e-11,
 -3.070016789557104e-14, -1.094700974394811e-16,  9.311894374708759e-19, -3.868832103286121e-21,  1.041028344738969e-23, -1.065071988296326e-26, -7.339679102520425e-29,
  2.040436660148585e-01, -1.138775286918582e-03,  4.325680571627489e-06, -1.234482314188487e-08,  2.266936737945057e-11,  7.711187089965111e-15, -2.837584210123343e-16,
  1.401588533796666e-18, -4.046178247011045e-21,  4.156257945771341e-24,  3.059045680441501e-26, -2.285855572205871e-28,  2.538985352327677e-01, -1.388434749343944e-03,
  5.017145500592977e-06, -1.269709505591586e-08,  1.454443277256787e-11,  5.962535724988160e-14, -4.580266622603261e-16,  1.593840231327948e-18, -2.354713791917002e-21,
 -9.042335209218083e-24,  8.124323202372148e-26, -3.111721012326946e-28,  3.088032141060290e-01, -1.649761252957101e-03,  5.617980576413172e-06, -1.208780226199252e-08,
  2.033219067277653e-12,  1.188220419184844e-13, -5.829700659761000e-16,  1.305247486948868e-18,  1.412041930559663e-21, -2.557518347859355e-23,  1.104732854304839e-25,
 -1.892945566435447e-28,  3.685816334173557e-01, -1.917624275852897e-03,  6.084965879689978e-06, -1.038004907610093e-08, -1.426533205136971e-11,  1.757682514424644e-13,
 -6.051725400213276e-16,  4.231305435484718e-19,  6.581136162462909e-21, -3.775562621021506e-23,  8.267640270426682e-26,  1.872652522199268e-28,  4.330288285288854e-01,
 -2.186389908426538e-03,  6.376121081725694e-06, -7.508982718835744e-09, -3.308485936041137e-11,  2.185297450651786e-13, -4.802834562739548e-16, -9.963045411803138e-19,
  1.148556925882517e-20, -3.605126461912692e-23, -1.983391715781587e-26,  6.844488511130213e-28,  5.019073728476009e-01, -2.449952048290831e-03,  6.452735692860310e-06,
 -3.501225762317010e-09, -5.249922126575529e-11,  2.344344959953360e-13, -1.886526825090496e-16, -2.676114400053714e-18,  1.375799308795652e-20, -1.366955200644603e-23,
 -1.725314144341851e-25,  9.684438232507768e-28,  5.749433689027058e-01, -2.701782376067885e-03,  6.281727148953907e-06,  1.508398687990178e-09, -7.002189360693087e-11,
  2.124480047547691e-13,  2.498134963389014e-16, -4.125631404158135e-18,  1.111207007898147e-20,  2.782030952999807e-23, -2.994889235797738e-25,  6.557376920282162e-28,
  6.518219987656608e-01, -2.935005008375791e-03,  5.838308416694259e-06,  7.265355614472331e-09, -8.281699917613107e-11,  1.460527018252957e-13,  7.662261241816634e-16,
 -4.733259431843858e-18,  2.500008980376958e-21,  7.464792664666693e-23, -2.966855651691862e-25, -3.811346948596592e-28,  7.321826578711484e-01, -3.142502738059424e-03,
  5.108905057448372e-06,  1.339225484003672e-08, -8.803328453269840e-11,  3.620289113756200e-14,  1.244195736124660e-15, -3.952831805841139e-18, -1.073024298218238e-20,
  1.023991550578371e-22, -9.274508781546322e-26, -1.716768151543914e-27,  8.156137295781771e-01, -3.317062661663466e-03,  4.094200720415500e-06,  1.939776908434770e-08,
 -8.325579655713080e-11, -1.063226029717296e-13,  1.537180885132506e-15, -1.555498064204955e-18, -2.430407024022597e-20,  8.552149076187021e-23,  2.749316706969929e-25,
 -2.379946128959602e-27,  9.016471053560494e-01, -3.451569536320491e-03,  2.812106325900788e-06,  2.470152109310082e-08, -6.704342373968455e-11, -2.600661179855035e-13,
  1.503900574165370e-15,  2.129267944745789e-18, -3.180799143802759e-20,  1.353015712089566e-23,  6.217090789899907e-25, -1.402406897778656e-27,  9.897526209558219e-01,
 -3.539255056498256e-03,  1.300340583836678e-06,  2.867841333187774e-08, -3.948341345205202e-11, -3.945125583016368e-13,  1.058338393406187e-15,  6.105274807057943e-18,
 -2.716353787219833e-20, -9.337091955860396e-23,  6.772882470806180e-25,  1.227663361820388e-27,  1.079332665927236e+00, -3.574009896152616e-03, -3.818180092463590e-07,
  3.072435750916460e-08, -2.649589478677436e-12, -4.749575700207466e-13,  2.225011840164441e-16,  8.868071900286590e-18, -8.307979583868085e-21, -1.817579525061211e-22,
  2.655275064553782e-25,  3.925480494290652e-27,  1.169717335051277e+00, -3.550762155285848e-03, -2.153181545693430e-06,  3.034227407290001e-08,  3.919135828585331e-11,
 -4.707344541475877e-13, -8.389449307147497e-16,  8.905685914144870e-18,  1.960359661383634e-20, -1.867703430236745e-22, -4.840173616886521e-25,  4.169494031203034e-27,
  1.260160626040935e+00, -3.465919967760473e-03, -3.912391685980121e-06,  2.724217663405573e-08,  7.980332526410069e-11, -3.657036806409466e-13, -1.828149292613980e-15,
  5.460789456666560e-18,  4.406210386889896e-20, -7.633584932644832e-23, -1.086015092082333e-24,  6.939044071032147e-28,  1.349838344074530e+00, -3.317866613198571e-03,
 -5.542476128118945e-06,  2.144211666120788e-08,  1.117865157447907e-10, -1.682707482459291e-13, -2.387971737676636e-15, -7.552289565260638e-19,  5.020126515122439e-20,
  1.070308995544445e-22, -9.813042532215746e-25, -4.370891064168554e-27,  1.437848538726788e+00, -3.107482866916944e-03, -6.918853962261183e-06,  1.334855094976018e-08,
  1.280139869682343e-10,  8.335568778883789e-14, -2.237873881452172e-15, -7.390063688271596e-18,  3.015034330789415e-20,  2.484731900252665e-22, -6.308226222584939e-26,
 -6.263059852987224e-27,  1.523215449950245e+00, -2.838653469703506e-03, -7.921097019175280e-06,  3.787470289133349e-09,  1.235448373334363e-10,  3.254177042856335e-13,
 -1.330220112347562e-15, -1.125006946053194e-17, -8.530041406017850e-21,  2.325432269744406e-22,  1.015499428461460e-24, -2.203840619666311e-27,  1.604898039862085e+00,
 -2.518693695286863e-03, -8.448122412289460e-06, -6.044768221264620e-09,  9.757632970570457e-11,  4.852191732903203e-13,  5.477013929152439e-17, -1.001607589894925e-17,
 -4.336711978859268e-20,  4.938300938029180e-23,  1.267203321559124e-24,  4.311576991240534e-27,  1.681804183450319e+00, -2.158611215693960e-03, -8.435521947929250e-06,
 -1.473441453032446e-08,  5.472005236346313e-11,  5.078719550320972e-13,  1.365821432325132e-15, -4.010959429573993e-18, -5.067728777522714e-20, -1.641145135013192e-22,
  3.835012076139122e-25,  6.104401552342035e-27,  1.752811418936105e+00, -1.773103574952415e-03, -7.872515096274191e-06, -2.090853561975937e-08,  4.784862150658379e-12,
  3.837184509736644e-13,  2.021732494855514e-15,  3.408333613856224e-18, -2.519631918344997e-20, -2.271671589990147e-22, -7.461965525253343e-25,  1.134968924721312e-27,
  1.816794751874448e+00, -1.380190848661801e-03, -6.814820100556865e-06, -2.356278598547006e-08, -3.947423457199783e-11,  1.613686346107257e-13,  1.744467338568160e-15,
  7.750308142560846e-18,  1.219042519508387e-20, -9.641424848479599e-23, -9.325549984988938e-25, -3.960356851770488e-27,  1.872661322755959e+00, -1.000405811967091e-03,
 -5.389061478288351e-06, -2.237891715954896e-08, -6.642067473473909e-11, -6.689661192214278e-14,  7.706665948444349e-16,  6.684402376926273e-18,  3.109836896174362e-20,
  7.642144978341587e-23, -1.540825988478506e-25, -2.945144376636128e-27,  1.919390798723416e+00, -6.555171492100701e-04, -3.784781630905373e-06, -1.791974959129578e-08,
 -7.012464927616729e-11, -2.076580751315913e-13, -2.628439574427513e-16,  2.017199682986687e-18,  2.061974981059837e-20,  1.163269080520409e-22,  4.575538262453439e-25,
  9.947140037112716e-28,  1.956079253259361e+00, -3.668444482349891e-04, -2.232171427833405e-06, -1.159361731177521e-08, -5.336293289023075e-11, -2.172351913463082e-13,
 -7.519113397744361e-16, -1.918336636239163e-18, -8.489799238945484e-22,  3.139644087138635e-23,  2.739104822276218e-25,  1.596363603099158e-27,  1.981983436064872e+00,
 -1.533229723913977e-04, -9.672240185680242e-07, -5.339001965319405e-09, -2.707182224931748e-11, -1.283826633340989e-13, -5.722039283353246e-16, -2.387261359335587e-18,
 -9.187670271658365e-21, -3.148725950640840e-23, -8.712191007429879e-26, -1.173987690631662e-28,  1.996565053137249e+00, -2.953935097937208e-05, -1.901084900154104e-07,
 -1.084431936116987e-09, -5.778519112888702e-12, -2.943205731803450e-14, -1.449988226412758e-16, -6.955893675451723e-19, -3.261994262484348e-21, -1.498719370985727e-23,
 -6.753506751522906e-26, -2.985217292440681e-28,  6.993482332270785e-04, -4.161850664098017e-06,  1.856981160199229e-08, -7.362557923290265e-11,  2.735273519366652e-13,
 -9.750234588014408e-16,  3.376605826190606e-18, -1.144683942874687e-20,  3.816207943346949e-23, -1.255483166921128e-25,  4.083945627340186e-28, -1.316196089678325e-30,
  6.292031782597265e-03, -3.737299118576467e-05,  1.660707719521280e-07, -6.537610264314880e-10,  2.402271090664881e-12, -8.429634423941778e-15,  2.857367545750182e-17,
 -9.417043592095286e-20,  3.027628279862552e-22, -9.514311302040955e-25,  2.922531184622643e-27, -8.772436085840634e-30,  1.746613639250140e-02, -1.033484912872973e-04,
  4.554459764919930e-07, -1.767115721882618e-09,  6.347837681174223e-12, -2.154797960679929e-14,  6.970641788719723e-17, -2.153890001939469e-19,  6.337977879461944e-22,
 -1.761370363344401e-24,  4.535957180423600e-27, -1.039443330744652e-29,  3.419889541097157e-02, -2.011920862180256e-04,  8.755076334247064e-07, -3.321718343544114e-09,
  1.151161338736362e-11, -3.699517333337253e-14,  1.102254092047043e-16, -3.003171333256931e-19,  7.198788560432865e-22, -1.355405533888845e-24,  9.804749623101055e-28,
  7.653060622723210e-30,  5.645554996659718e-02, -3.295527478521261e-04,  1.409642963568558e-06, -5.184298509295328e-09,  1.705820300343407e-11, -5.036900011591096e-14,
  1.299859906819795e-16, -2.681838425403514e-19,  2.813671379081901e-22,  1.051719892633122e-24, -9.103130444701939e-27,  4.295437349698931e-29,  8.418860509924636e-02,
 -4.866170930642714e-04,  2.036030439634187e-06, -7.186000738809095e-09,  2.198882340118781e-11, -5.687144586788910e-14,  1.101588317765793e-16, -6.242731140690456e-20,
 -7.700181385039405e-22,  5.104605631934211e-24, -2.140371111232031e-26,  6.897513062804680e-29,  1.173368159054400e-01, -6.700999084240189e-04,  2.727950932202185e-06,
 -9.130137723795297e-09,  2.523609677148191e-11, -5.212071543671844e-14,  3.862514257729154e-17,  3.206950030156188e-19, -2.213968116708115e-21,  9.005909524481536e-24,
 -2.630217617706892e-26,  4.608676783579641e-29,  1.558238847911592e-01, -8.772334228179985e-04,  3.454213746825700e-06, -1.080206534655317e-08,  2.577694153888236e-11,
 -3.302821707981660e-14, -8.507431003297593e-17,  8.132950564221978e-19, -3.502438695458564e-21,  9.927276652989290e-24, -1.332122217933764e-26, -4.888950675545458e-29,
  1.995568462673130e-01, -1.104756218406260e-03,  4.179722879809688e-06, -1.198123641311591e-08,  2.275859290392245e-11,  1.357433975728143e-15, -2.463025629403938e-16,
  1.274722042103798e-18, -3.876842240792593e-21,  5.190685785863304e-24,  2.141904696829719e-26, -1.890312072843089e-28,  2.484241112839316e-01, -1.348903002991333e-03,
  4.866214084581550e-06, -1.245542632462872e-08,  1.563058314654969e-11,  4.915945401293000e-14, -4.144986659742285e-16,  1.513881869038211e-18, -2.624974068845431e-21,
 -6.058880248086605e-24,  6.812292623560302e-26, -2.846520424691327e-28,  3.022931391231809e-01, -1.605396894086177e-03,  5.473198132531883e-06, -1.203700691595621e-08,
  4.272730278980481e-12,  1.052736087792176e-13, -5.459229710787174e-16,  1.336537537870337e-18,  5.687868347922691e-22, -2.133161416946447e-23,  1.015154497944058e-25,
 -2.153970965630534e-28,  3.610077017522094e-01, -1.869446409278945e-03,  5.959149281699464e-06, -1.058095617319600e-08, -1.089413102892180e-11,  1.614088470138023e-13,
 -5.905762345266596e-16,  6.126321880669949e-19,  5.283166566423127e-21, -3.431422034383456e-23,  8.867705923282418e-26,  8.882828623213111e-29,  4.243847038779683e-01,
 -2.135750041972840e-03,  6.282979319364743e-06, -8.004010752033237e-09, -2.883158256921415e-11,  2.067085123378474e-13, -5.032303201167965e-16, -6.496284628435814e-19,
  1.018033687557325e-20, -3.628223492685250e-23,  7.308674940278291e-27,  5.504230043649962e-28,  4.922105226403080e-01, -2.398512146753426e-03,  6.405834920899321e-06,
 -4.303974374151448e-09, -4.786162240410929e-11,  2.290569058004604e-13, -2.575033028952697e-16, -2.244981923808452e-18,  1.315177447563556e-20, -1.973670539714058e-23,
 -1.313232830329457e-25,  9.003613081162589e-28,  5.642368352108883e-01, -2.651474876848923e-03,  6.293246996767433e-06,  4.223272857863966e-10, -6.572212391178741e-11,
  2.170983419545435e-13,  1.394084423599504e-16, -3.756273978919493e-18,  1.190526825102562e-20,  1.645494671968532e-23, -2.679625124275987e-25,  7.679748991981577e-28,
  6.401759123327186e-01, -2.887972101927888e-03,  5.917641760807115e-06,  5.964606351813341e-09, -7.972272894557511e-11,  1.628631941649347e-13,  6.352023675748962e-16,
 -4.612579382814595e-18,  4.970553250618916e-21,  6.254045692326259e-23, -3.064112815917759e-25, -6.868786238939419e-29,  7.196953734920142e-01, -3.101012549041198e-03,
  5.261189965197750e-06,  1.199109889565243e-08, -8.701977093303383e-11,  6.470001381728766e-14,  1.129257549651021e-15, -4.238075464750426e-18, -7.127947435683789e-21,
  9.727858831060236e-23, -1.607638913630963e-25, -1.371251307372290e-27,  8.024124282065116e-01, -3.283400757227929e-03,  4.318917668905395e-06,  1.805065285450219e-08,
 -8.501729493629627e-11, -7.003787699094348e-14,  1.483215505992767e-15, -2.282049851937862e-18, -2.105250640100502e-20,  9.443445717615200e-23,  1.711753666834252e-25,
 -2.317287111803512e-27,  8.878876719779001e-01, -3.427905630979269e-03,  3.101923169598207e-06,  2.358919502949083e-08, -7.187957268493664e-11, -2.233714693598117e-13,
  1.549376798521802e-15,  1.123875797631089e-18, -3.088945725682959e-20,  3.702229523473356e-23,  5.496197440536375e-25, -1.852259523010509e-27,  9.756185697979873e-01,
 -3.527487097887688e-03,  1.640435382734023e-06,  2.798499309772502e-08, -4.710633676397698e-11, -3.671622044721146e-13,  1.216649321018236e-15,  5.187580326711773e-18,
 -3.002634653124787e-20, -6.543203876066789e-23,  7.138930090947942e-25,  4.372660190424753e-28,  1.065032850339273e+00, -3.575591111388284e-03, -1.369238266976349e-08,
  3.060634481476301e-08, -1.207540843013813e-11, -4.666738755782383e-13,  4.661180836143204e-16,  8.499904262281642e-18, -1.461960720097682e-20, -1.678113027067230e-22,
  4.282506381402223e-25,  3.438114110148107e-27,  1.155482155635927e+00, -3.566521240644536e-03, -1.785625880317683e-06,  3.089301028527775e-08,  2.959586004606709e-11,
 -4.878122726660465e-13, -5.818386286504071e-16,  9.422053230779763e-18,  1.257704150688337e-20, -2.023055508282108e-22, -2.893388928836527e-25,  4.636322118413566e-27,
  1.246236448200767e+00, -3.495890341353463e-03, -3.578073384808281e-06,  2.845818816047364e-08,  7.206369246320362e-11, -4.075879469235827e-13, -1.655979811237483e-15,
  6.818505814333028e-18,  4.054290883839426e-20, -1.187849944495104e-22, -1.027039797593423e-24,  1.983328712253101e-27,  1.336479870167847e+00, -3.361147070716217e-03,
 -5.274560379848505e-06,  2.320065979723707e-08,  1.078472269572153e-10, -2.256510187230840e-13, -2.386104848405312e-15,  9.049242205379357e-19,  5.330376019186233e-20,
  6.418652101296431e-23, -1.154019295354270e-24, -3.424763366240957e-27,  1.425308969385714e+00, -3.162158040964562e-03, -6.746336633418539e-06,  1.540712517738252e-08,
  1.291278487440501e-10,  2.728091110646752e-14, -2.429950227264798e-15, -6.283170091062202e-18,  3.898175826415032e-20,  2.402468105015813e-22, -3.523721319291048e-25,
 -6.829352704742896e-27,  1.511734434445374e+00, -2.901806360255614e-03, -7.863578208237604e-06,  5.814412358310362e-09,  1.297082978542078e-10,  2.896895639960692e-13,
 -1.647730339175568e-15, -1.138146481540142e-17,  5.448957202750293e-22,  2.707378385090738e-22,  8.819950081504034e-25, -3.882121874582851e-27,  1.594687674161639e+00,
 -2.586541545185738e-03, -8.510972094566276e-06, -4.405938607776827e-09,  1.072703393735064e-10,  4.830134410196711e-13, -2.447693601800488e-16, -1.136523793230979e-17,
 -4.063319347955696e-20,  1.036428128129805e-22,  1.439469998769278e-24,  3.443562977234885e-27,  1.673033672465476e+00, -2.226786975987200e-03, -8.606740944966025e-06,
 -1.377589469851977e-08,  6.519522195738183e-11,  5.391153980633840e-13,  1.229947197745265e-15, -5.723658069614899e-18, -5.624175084124410e-20, -1.430962718923826e-22,
  6.747206512983319e-25,  7.106014720701057e-27,  1.745591457974171e+00, -1.837085403415597e-03, -8.122696298472747e-06, -2.076791582462882e-08,  1.295167339364258e-11,
  4.332863614463836e-13,  2.104608063194286e-15,  2.465563011455752e-18, -3.389605963128473e-20, -2.556268578207185e-22, -6.665669657492509e-25,  2.538418819011465e-27,
  1.811163145770801e+00, -1.435850899756529e-03, -7.101248983557266e-06, -2.416620543934773e-08, -3.581039877918659e-11,  2.058805618434289e-13,  1.966362167968448e-15,
  8.077324366483656e-18,  8.005698221410185e-21, -1.372401037662552e-22, -1.109291706213581e-24, -4.034890097329324e-27,  1.868571748095754e+00, -1.044610653070086e-03,
 -5.664025586630609e-06, -2.345128077324021e-08, -6.755789498811860e-11, -4.603970975916458e-14,  9.721654965655479e-16,  7.722109972369861e-18,  3.370492706849302e-20,
  6.739565346653620e-23, -3.042017627547932e-25, -3.905469940371231e-27,  1.916706784372818e+00, -6.866749419084213e-04, -4.006688701102599e-06, -1.907529142426495e-08,
 -7.433591609095029e-11, -2.132099921412086e-13, -1.964694900630479e-16,  2.747651313199320e-18,  2.514710121294293e-20,  1.354582504470397e-22,  4.976381970062012e-25,
  8.051509561191621e-28,  1.954575258673819e+00, -3.852731646648951e-04, -2.376564278433947e-06, -1.248318066467253e-08, -5.789245737349693e-11, -2.359275710295023e-13,
 -8.058192877701222e-16, -1.925161229434717e-18,  4.964201525933860e-22,  4.386679490078231e-23,  3.524327064967042e-25,  1.984423980629356e-27,  1.981354252167755e+00,
 -1.613246002745955e-04, -1.033978150201044e-06, -5.793461839457263e-09, -2.978239499970491e-11, -1.429519717226668e-13, -6.433385820410039e-16, -2.700085454342422e-18,
 -1.038507573983499e-20, -3.506317364396688e-23, -9.132425437812670e-26, -6.924880023121357e-29,  1.996443769301143e+00, -3.111388938854583e-05, -2.036964673353461e-07,
 -1.181793290354624e-09, -6.403600719046242e-12, -3.315806029138415e-14, -1.660216805538358e-16, -8.091540076570970e-19, -3.853498266008854e-21, -1.797064307411715e-23,
 -8.214319727925388e-26, -3.680245397871376e-28,  6.829924551282400e-04, -4.016753253605707e-06,  1.771193373239035e-08, -6.940084880496471e-11,  2.548120025798092e-13,
 -8.976971292013650e-16,  3.072533305273342e-18, -1.029492573174562e-20,  3.392295037998470e-23, -1.103137688829442e-25,  3.546879955171521e-28, -1.130046707248218e-30,
  6.145148170246147e-03, -3.607516469702010e-05,  1.584508123931241e-07, -6.166370476194312e-10,  2.240328032357341e-12, -7.774443549109863e-15,  2.606754844091919e-17,
 -8.500822165507886e-20,  2.705257100263659e-22, -8.419002774164876e-25,  2.562348669654109e-27, -7.627327254960424e-30,  1.705989765730042e-02, -9.978805059055396e-05,
  4.348360475151091e-07, -1.668909108561152e-09,  5.933130727352823e-12, -1.994516182889258e-14,  6.395017930971278e-17, -1.960878815205463e-19,  5.735465199055704e-22,
 -1.588816273135719e-24,  4.098187138652969e-27, -9.510444502033044e-30,  3.340788708512061e-02, -1.943443917851164e-04,  8.367281692647273e-07, -3.143310835907325e-09,
  1.079749616245500e-11, -3.444811178744067e-14,  1.021317573003955e-16, -2.780535409808200e-19,  6.718644987684981e-22, -1.310196002368696e-24,  1.262650905650129e-27,
  5.268826768615230e-30,  5.515950570670139e-02, -3.185198861130453e-04,  1.349036267535088e-06, -4.919259333908566e-09,  1.608141679570763e-11, -4.733839612608829e-14,
  1.226081072063117e-16, -2.586410137733229e-19,  3.131104630314406e-22,  7.232336320023265e-25, -7.372584215975139e-27,  3.589441658386033e-29,  8.227417540887687e-02,
 -4.706678821371743e-04,  1.951872286231805e-06, -6.843135990896910e-09,  2.087767732771196e-11, -5.425122983103734e-14,  1.080923806988504e-16, -8.428707757935084e-20,
 -6.009525801214404e-22,  4.306857606241263e-24, -1.853965168228971e-26,  6.129308675848850e-29,  1.146993791828334e-01, -6.487077622404915e-04,  2.620777716290542e-06,
 -8.734646209984995e-09,  2.420363970371437e-11, -5.109367179071146e-14,  4.666006040598378e-17,  2.548363760053016e-19, -1.908199043142721e-21,  7.994921510327273e-24,
 -2.423724843884985e-26,  4.746561478442137e-29,  1.523694073941649e-01, -8.501112515380397e-04,  3.327041411693712e-06, -1.039502221465768e-08,  2.509773985008036e-11,
 -3.480907175310604e-14, -6.381817031152090e-17,  7.068284518404824e-19, -3.155110587177336e-21,  9.357471685907976e-24, -1.502738230859906e-26, -2.942943894606148e-29,
  1.952037951252612e-01, -1.071887344342486e-03,  4.038132755851334e-06, -1.161719103035095e-08,  2.272944834045890e-11, -4.139361406331731e-15, -2.123179912466094e-16,
  1.153802655067984e-18, -3.676462826668628e-21,  5.891743961492879e-24,  1.388909575999977e-26, -1.539870869769959e-28,  2.431054181812412e-01, -1.310566827978059e-03,
  4.718280238028091e-06, -1.219799774891844e-08,  1.651767618684045e-11,  3.971047509380327e-14, -3.733151426370213e-16,  1.426894694356778e-18, -2.796987514296750e-21,
 -3.576065825495740e-24,  5.622827514239357e-26, -2.557798132023487e-28,  2.959582097503789e-01, -1.562187767721136e-03,  5.329231441086162e-06, -1.195249858561763e-08,
  6.250219927593122e-12,  9.262190879895249e-14, -5.083550716316528e-16,  1.343216575922372e-18, -1.283876368162185e-22, -1.746513878482492e-23,  9.171653457926522e-26,
 -2.280468827177464e-28,  3.536244544847829e-01, -1.822283823756916e-03,  5.831236023019110e-06, -1.073020080396249e-08, -7.806208957304290e-12,  1.474588489394211e-13,
 -5.712364655326212e-16,  7.626192611835137e-19,  4.112417780945583e-21, -3.071354922422538e-23,  9.078240599481269e-26,  9.978942242268510e-30,  4.159416124118810e-01,
 -2.085877932218975e-03,  6.184297645049483e-06, -8.432904461102422e-09, -2.481947581695524e-11,  1.944483178456840e-13, -5.170548201191120e-16, -3.446547204361467e-19,
  8.884931651948376e-21, -3.554311674352098e-23,  2.873570235557342e-26,  4.253213930375281e-28,  4.827186223872699e-01, -2.347484730635218e-03,  6.349742546166751e-06,
 -5.033467537370843e-09, -4.334713383129438e-11,  2.221693785447042e-13, -3.145844032850790e-16, -1.836431284731608e-18,  1.235602186223678e-20, -2.422238155291061e-23,
 -9.361204140918380e-26,  8.110478366644373e-28,  5.537316349513591e-01, -2.601126174586590e-03,  6.292149378238408e-06, -5.943441524029649e-10, -6.135499373155638e-11,
  2.192255610235453e-13,  3.964102609332346e-17, -3.367828590319105e-18,  1.231305516499817e-20,  6.433324091947458e-24, -2.326869582675983e-25,  8.273704141516731e-28,
  6.287191292226274e-01, -2.840366098601933e-03,  5.981673708705530e-06,  4.715885541057805e-09, -7.632337641464804e-11,  1.765781935535424e-13,  5.085985468288027e-16,
 -4.419864861544419e-18,  7.001409424573859e-21,  5.030455314133422e-23, -3.034743578504250e-25,  1.934322003887248e-28,  7.073763803846805e-01, -3.058371018241277e-03,
  5.396776614661423e-06,  1.061056634556788e-08, -8.546448044622810e-11,  9.035561569129839e-14,  1.007915086753097e-15, -4.411490154229856e-18, -3.755254189403763e-21,
  8.974624097225513e-23, -2.132540837940931e-25, -1.014688855974856e-27,  7.893492669386131e-01, -3.248006203248944e-03,  4.527323820380006e-06,  1.668108113417035e-08,
 -8.606763638670973e-11, -3.528041584204109e-14,  1.410405944528720e-15, -2.900211374430605e-18, -1.755381955250328e-20,  9.928454682231271e-23,  7.254586670832421e-26,
 -2.150612977719425e-27,  8.742274449707165e-01, -3.401977841858134e-03,  3.377952214806248e-06,  2.240541152576140e-08, -7.597317418702017e-11, -1.859191210606451e-13,
  1.567236505251609e-15,  1.608153682733255e-19, -2.918151493236964e-20,  5.727530223398761e-23,  4.607672992451259e-25, -2.162966426412248e-27,  9.615369764206829e-01,
 -3.513033695622661e-03,  1.971496033829218e-06,  2.717417967393733e-08, -5.414638923281257e-11, -3.363301478592024e-13,  1.348135092097193e-15,  4.194583600159491e-18,
 -3.186533590548168e-20, -3.671880702413760e-23,  7.162366665339555e-25, -3.215384320804031e-28,  1.050732587331091e+00, -3.574235535407332e-03,  3.521186986794006e-07,
  3.033915817549434e-08, -2.127803626405223e-11, -4.526893949844878e-13,  6.966828560879306e-16,  7.939008707815941e-18, -2.031767341785617e-20, -1.478400524599316e-22,
  5.654678713065461e-25,  2.773872253116946e-27,  1.141189858909618e+00, -3.579316079075098e-03, -1.412392721249657e-06,  3.128782579408800e-08,  1.972154876297563e-11,
 -4.985719106619089e-13, -3.134950902250526e-16,  9.706160892536419e-18,  5.135619285249939e-21, -2.097220964067736e-22, -8.009299298935611e-26,  4.827714776068991e-27,
  1.232197827321881e+00, -3.523129967306219e-03, -3.229932831713488e-06,  2.954390126708884e-08,  6.353070262231809e-11, -4.448980713803110e-13, -1.447596720335283e-15,
  8.039722821265244e-18,  3.555157079401556e-20, -1.577537645556079e-22, -9.124980246727393e-25,  3.203891748200070e-27,  1.322952693104784e+00, -3.402200950786694e-03,
 -4.985958105133062e-06,  2.488701189160344e-08,  1.027645978058067e-10, -2.824189244916462e-13, -2.336604632509745e-15,  2.638432680661975e-18,  5.475040417595886e-20,
  1.536083760129523e-23, -1.278118353118807e-24, -2.170072541168429e-27,  1.412553616390717e+00, -3.215354048654407e-03, -6.549047273630704e-06,  1.747430986946023e-08,
  1.290767906838388e-10, -3.300020180894181e-14, -2.587137773236309e-15, -4.900685286868471e-18,  4.730370754369831e-20,  2.200591083550210e-22, -6.583060694421992e-25,
 -7.005750173714304e-27,  1.500001884018643e+00, -2.964400187640115e-03, -7.781169323957522e-06,  7.933838615413528e-09,  1.350808699481003e-10,  2.463310744474693e-13,
 -1.964655547214366e-15, -1.120163869796018e-17,  1.088069809813318e-20,  3.020927995484475e-22,  6.731768291845082e-25, -5.606618444123123e-27,  1.584205039732539e+00,
 -2.654810897904125e-03, -8.553227952206162e-06, -2.612760998873235e-09,  1.168453439340089e-10,  4.731771786414665e-13, -5.805579346206562e-16, -1.259441362546021e-17,
 -3.583232823906869e-20,  1.638926028632743e-22,  1.563261090037589e-24,  2.103603345246768e-27,  1.663987795866542e+00, -2.296283583802156e-03, -8.765432086401487e-06,
 -1.264496703946257e-08,  7.625866547271678e-11,  5.665030532285027e-13,  1.043754784665647e-15, -7.599981878020094e-18, -6.082976738013335e-20, -1.096056725050961e-22,
  1.005442817578845e-24,  7.877118509182938e-27,  1.738111580722470e+00, -1.903059634375097e-03, -8.370373010274874e-06, -2.048859766722387e-08,  2.212742827073737e-11,
  4.844941347671492e-13,  2.157039657675347e-15,  1.228749195483662e-18, -4.354726101375854e-20, -2.795705968218003e-22, -5.180471352815368e-25,  4.264167776092699e-27,
  1.805304272239268e+00, -1.493830279933400e-03, -7.394536848800296e-06, -2.470358943824426e-08, -3.120241215479714e-11,  2.558113035693349e-13,  2.195308001089615e-15,
  8.245547205756627e-18,  2.223876428365115e-21, -1.851252491398700e-22, -1.283459222076063e-24, -3.826259646200575e-27,  1.864300872753084e+00, -1.091066956357876e-03,
 -5.951952587402884e-06, -2.453823000779140e-08, -6.822721666133382e-11, -1.998908265637487e-14,  1.203830346011662e-15,  8.836784130088715e-18,  3.586785150558167e-20,
  5.147223346093526e-23, -5.001305887075958e-25, -5.025696628347720e-27,  1.913894498889623e+00, -7.196646104817470e-04, -4.242869919081624e-06, -2.029900802400077e-08,
 -7.864054736295245e-11, -2.169064722846493e-13, -1.075084853389990e-16,  3.634288455102684e-18,  3.038964340547062e-20,  1.559827826174681e-22,  5.260445942398922e-25,
  4.549103635699096e-28,  1.952995169552761e+00, -4.049009838402772e-04, -2.532079288252200e-06, -1.344827745792752e-08, -6.280875585135918e-11, -2.559107322244596e-13,
 -8.592435740998988e-16, -1.881109245907975e-18,  2.351596347758321e-21,  5.984075742948678e-23,  4.496283533101653e-25,  2.446235924409843e-27,  1.980691958083213e+00,
 -1.698828353237127e-04, -1.106455939852119e-06, -6.293717784049571e-09, -3.280215860554289e-11, -1.593380705116487e-13, -7.237883057634350e-16, -3.053314049274555e-18,
 -1.171365228684396e-20, -3.875620239721017e-23, -9.274419010735336e-26,  1.101547154923612e-29,  1.996315962256570e+00, -3.280198083063787e-05, -2.185153397523723e-07,
 -1.289780645501236e-09, -7.108516925508472e-12, -3.742901187890192e-14, -1.905063286721482e-16, -9.434842822368134e-19, -4.563704691856997e-21, -2.160439996978576e-23,
 -1.001768353251249e-25, -4.548965360798160e-28,  6.672036546700574e-04, -3.878321054571432e-06,  1.690300573467419e-08, -6.546357756778267e-11,  2.375727378270674e-13,
 -8.272963334662270e-16,  2.798894821634815e-18, -9.270288181009115e-21,  3.019549123702830e-23, -9.707227856201607e-26,  3.085376552746487e-28, -9.719254688504913e-31,
  6.003336705020096e-03, -3.483655900719354e-05,  1.512612161197432e-07, -5.820025100171865e-10,  2.090907513623740e-12, -7.176434241693644e-15,  2.380409470799265e-17,
 -7.681719034561708e-20,  2.419840755102813e-22, -7.458168502605990e-25,  2.249020172346995e-27, -6.638763078911467e-30,  1.666757823362965e-02, -9.638788582006492e-05,
  4.153658200686804e-07, -1.577088681892189e-09,  5.549141304715446e-12, -1.847422084867426e-14,  5.870828969210026e-17, -1.786187164738394e-19,  5.192012710790724e-22,
 -1.433007020754342e-24,  3.698401344364095e-27, -8.669482841145769e-30,  3.264366235534350e-02, -1.877985599410020e-04,  8.000226873874779e-07, -2.975932019298047e-09,
  1.013242729519253e-11, -3.208798936326498e-14,  9.464023461481903e-17, -2.572983843185203e-19,  6.256570588065355e-22, -1.255635578083026e-24,  1.451820794478723e-27,
  3.406858474126743e-30,  5.390664296051197e-02, -3.079594172031907e-04,  1.291518239417673e-06, -4.669373369189647e-09,  1.516349416742272e-11, -4.448155062915646e-14,
  1.155099580046119e-16, -2.482588349162831e-19,  3.342023755265430e-22,  4.580797300710663e-25, -5.928787083292790e-27,  2.989540314978202e-29,  8.042222166802972e-02,
 -4.553757771968968e-04,  1.871723559852345e-06, -6.517633237685102e-09,  1.981839309848174e-11, -5.168736792241477e-14,  1.054854339796422e-16, -1.011747901708569e-19,
 -4.586238847080287e-22,  3.617066964902931e-24, -1.600187219872229e-26,  5.415534502475405e-29,  1.121458259365381e-01, -6.281542973937722e-04,  2.518251992788258e-06,
 -8.355499812249847e-09,  2.319350809536865e-11, -4.989484601173465e-14,  5.298256394268399e-17,  1.981960589364756e-19, -1.637328874534218e-21,  7.067234710339822e-24,
 -2.214877479338649e-26,  4.724176860667689e-29,  1.490214145960450e-01, -8.239871081434233e-04,  3.204687302488643e-06, -9.999104519737892e-09,  2.438778748393709e-11,
 -3.611431529869405e-14, -4.539066090915695e-17,  6.111365628106312e-19, -2.829329570355977e-21,  8.735234430203114e-24, -1.597392357316098e-26, -1.423877507484636e-29,
  1.909799816830789e-01, -1.040133733092200e-03,  3.900904891160583e-06, -1.125444826981891e-08,  2.259825375770712e-11, -8.860410094942777e-15, -1.816259956568273e-16,
  1.039644023976725e-18, -3.455907381665451e-21,  6.321114682803777e-24,  7.802000181915397e-27, -1.234264547824501e-28,  2.379377227237733e-01, -1.273401539893967e-03,
  4.573514630660735e-06, -1.192783465615860e-08,  1.722547353155719e-11,  3.122013041069646e-14, -3.346315254100630e-16,  1.335743868898588e-18, -2.887874680722943e-21,
 -1.543327612534365e-24,  4.562392402936905e-26, -2.262402253952082e-28,  2.897938205730102e-01, -1.520125799522792e-03,  5.186460497243684e-06, -1.183832568450778e-08,
  7.983694527579932e-12,  8.087168746595150e-14, -4.708921125645281e-16,  1.329736584940638e-18, -6.935280838184300e-22, -1.399846829363092e-23,  8.160132889395332e-26,
 -2.302390114472871e-28,  3.464278007627347e-01, -1.776150889165168e-03,  5.701819147702361e-06, -1.083224410896524e-08, -4.992326501038376e-12,  1.340192877416957e-13,
 -5.482019889326361e-16,  8.772261535650796e-19,  3.072022427200407e-21, -2.709263681046473e-23,  8.981977177483276e-26, -5.093868375263226e-29,  4.076963993980475e-01,
 -2.036814790203174e-03,  6.080846266081463e-06, -8.799581300955230e-09, -2.105522323760405e-11,  1.819541525827473e-13, -5.229152788060994e-16, -8.055336333458600e-20,
  7.630266203570850e-21, -3.405360337807626e-23,  4.491739520855223e-26,  3.124114068039084e-28,  4.734298805984037e-01, -2.296939852179353e-03,  6.285324867998611e-06,
 -5.691901485717678e-09, -3.898318414176421e-11,  2.140461614545961e-13, -3.606048296504994e-16, -1.455645301235212e-18,  1.142495006110095e-20, -2.728246436928541e-23,
 -6.013431719719640e-26,  7.092579764896864e-28,  5.434277363521522e-01, -2.550833863235518e-03,  6.279271939654414e-06, -1.540927529012039e-09, -5.696837611377698e-11,
  2.190900307982717e-13, -4.911950073945818e-17, -2.971829874556344e-18,  1.238596502381354e-20, -2.138823559002292e-24, -1.958155072526864e-25,  8.419148629563119e-28,
  6.174537010657216e-01, -2.792306833883980e-03,  6.031055867162492e-06,  3.523585640878423e-09, -7.267963550622353e-11,  1.873263912360205e-13,  3.882346232098594e-16,
 -4.169166534619590e-18,  8.596523424196113e-21,  3.840097101014087e-23, -2.901905659633114e-25,  4.013312923041212e-28,  6.952300185138056e-01, -3.014710598807853e-03,
  5.515962597567538e-06,  9.258863674161535e-09, -8.342553150221573e-11,  1.130526624940552e-13,  8.831845024618314e-16, -4.481691892603939e-18, -6.877487160256350e-22,
  8.042654217645092e-23, -2.502035708745988e-25, -6.679565706371768e-28,  7.764309139631146e-01, -3.211010373007400e-03,  4.719216895280447e-06,  1.530016454526232e-08,
 -8.644163892906386e-11, -2.465300693174199e-15,  1.321876183025964e-15, -3.404366787366526e-18, -1.394954099013164e-20,  1.003615114036788e-22, -1.689773060938431e-26,
 -1.903895325094399e-27,  8.606752541204418e-01, -3.373899698409284e-03,  3.639407641449299e-06,  2.116213701394276e-08, -7.931559192901184e-11, -1.483549036284645e-13,
  1.559000254427538e-15, -7.366353430625546e-19, -2.681135056372458e-20,  7.374276326892074e-23,  3.613784833236936e-25, -2.331588439504501e-27,  9.475184293607886e-01,
 -3.495972594156189e-03,  2.292171957264067e-06,  2.625582043641120e-08, -6.054052641769088e-11, -3.026817752592128e-13,  1.451148239756978e-15,  3.159231938292693e-18,
 -3.267683453857410e-20, -8.559941160654187e-24,  6.867357130393927e-25, -1.003475550513855e-27,  1.036443575794593e+00, -3.569968775667274e-03,  7.138502762849936e-07,
  2.992726196269033e-08, -3.014701458498232e-11, -4.333797242310519e-13,  9.091051126230725e-16,  7.208278105024789e-18, -2.520540048964096e-20, -1.230054476537019e-22,
  6.705091214287054e-25,  1.984900125312495e-27,  1.126852380755689e+00, -3.589108800971152e-03, -1.035375671617979e-06,  3.152328291826950e-08,  9.696951624553877e-12,
 -5.028229403797946e-13, -4.055884530542824e-17,  9.749497908097945e-18, -2.420881457388626e-21, -2.086849441484079e-22,  1.312488841071824e-25,  4.731554788243577e-27,
  1.218055897353085e+00, -3.547534730467960e-03, -2.869606601886953e-06,  3.048739993288677e-08,  5.430419329888069e-11, -4.768159835031815e-13, -1.207459670183002e-15,
  9.079757971070334e-18,  2.925240677533051e-20, -1.911079438812271e-22, -7.474918149719899e-25,  4.262398717629684e-27,  1.309266044255730e+00, -3.440866536019657e-03,
 -4.677644750140106e-06,  2.648304017890499e-08,  9.656244221499868e-11, -3.374127908003017e-13, -2.238188509671992e-15,  4.389264770721710e-18,  5.436398185947353e-20,
 -3.724840800546199e-23, -1.341458454856139e-24, -6.770770080175164e-28,  1.399588792958750e+00, -3.266872623379997e-03, -6.326997011362402e-06,  1.953084137516520e-08,
  1.277856731924747e-10, -9.655996496180947e-14, -2.702013655667880e-15, -3.265895432806529e-18,  5.467794546938250e-20,  1.876102520861907e-22, -9.620715848703526e-25,
 -6.721603195517594e-27,  1.488020439873727e+00, -3.026231618729045e-03, -7.672841506642108e-06,  1.013187779433283e-08,  1.395108154064329e-10,  1.954651574362450e-13,
 -2.271757840926264e-15, -1.067476617422984e-17,  2.217677213801022e-20,  3.235936923161485e-22,  3.899595577864271e-25, -7.239073519548128e-27,  1.573448791733778e+00,
 -2.723329638409820e-03, -8.573054419570323e-06, -6.684063507325072e-10,  1.261403445565764e-10,  4.548883826763117e-13, -9.482804652626755e-16, -1.363442591231061e-17,
 -2.878884334102429e-20,  2.277729257352132e-22,  1.617503214272499e-24,  2.847765152674571e-28,  1.654661484029737e+00, -2.366992387002354e-03, -8.909472765467622e-06,
 -1.133290320014540e-08,  8.782083973379541e-11,  5.887762622638852e-13,  8.031696838698887e-16, -9.601217870150255e-18, -6.396671756341886e-20, -6.230775804351133e-23,
  1.362329618779269e-24,  8.269521050812739e-27,  1.730363868574318e+00, -1.970999297733157e-03, -8.613783046823340e-06, -2.005421822935873e-08,  3.233693352316649e-11,
  5.365090464748620e-13,  2.170396204930515e-15, -3.293941682849589e-19, -5.393438630725212e-20, -2.959658610345774e-22, -2.870293005841330e-25,  6.279408198684396e-27,
  1.799208749611980e+00, -1.554180426251094e-03, -7.693797030532535e-06, -2.515895698263555e-08, -2.554059714980978e-11,  3.112707207328746e-13,  2.426105211681923e-15,
  8.199849581943418e-18, -5.404031312922358e-21, -2.396855565671925e-22, -1.440163897318157e-24, -3.221186425547535e-27,  1.859839482554832e+00, -1.139878989657749e-03,
 -6.252969032586466e-06, -2.563140745273826e-08, -6.831736017937160e-11,  1.200326629436927e-14,  1.467577529206057e-15,  1.000988837586613e-17,  3.730418860868246e-20,
  2.668272069483171e-23, -7.485181556214060e-25, -6.284387128327974e-27,  1.910946381170802e+00, -7.546036428770485e-04, -4.494151020861747e-06, -2.159206536510291e-08,
 -8.299564580789961e-11, -2.181503314447194e-13,  8.739468723965532e-18,  4.700694706553477e-18,  3.638726563778578e-20,  1.772749220760417e-22,  5.344024115496728e-25,
 -1.174616009390507e-28,  1.951334005639016e+00, -4.258206157978864e-04, -2.699660837342147e-06, -1.449530145074740e-08, -6.813740244664275e-11, -2.771540073137667e-13,
 -9.105112483093619e-16, -1.767699159066571e-18,  4.856921373696292e-21,  8.013186458794465e-23,  5.688632457876506e-25,  2.986683156137919e-27,  1.979994232201083e+00,
 -1.790457519565714e-04, -1.185237862188982e-06, -6.845020079324994e-09, -3.616977859387710e-11, -1.777785746633249e-13, -8.147436537417531e-16, -3.451187612401398e-18,
 -1.317523831322176e-20, -4.242301011543403e-23, -8.967834510310083e-26,  1.373392393828805e-28,  1.996181157257715e+00, -3.461400508814385e-05, -2.347006582470825e-07,
 -1.409763266812155e-09, -7.905046944339330e-12, -4.233542414234567e-14, -2.190911004745599e-16, -1.102781260505634e-18, -5.418686625157300e-21, -2.604204400403401e-23,
 -1.224974455399563e-25, -5.637417158319835e-28,  6.519559329110058e-04, -3.746175874841107e-06,  1.613971535714536e-08, -6.179121774633520e-11,  2.216780717959509e-13,
 -7.631316335577489e-16,  2.552345487207310e-18, -8.357645335244342e-21,  2.691310782547036e-23, -8.554488772533524e-26,  2.688114704382940e-28, -8.373700103182429e-31,
  5.866367205035072e-03, -3.365384738195231e-05,  1.444732752617879e-07, -5.496658946072483e-10,  1.952922009269952e-12, -6.630095732199657e-15,  2.175770643789238e-17,
 -6.948648358909875e-20,  2.166859541219511e-22, -6.614376761492214e-25,  1.976157488794418e-27, -5.784601823921123e-30,  1.628855477919499e-02, -9.313917774155761e-05,
  3.969615238830511e-07, -1.491183408016377e-09,  5.193351274233797e-12, -1.712340701797147e-14,  5.393201167477944e-17, -1.628018680879861e-19,  4.701860960796118e-22,
 -1.292463632683501e-24,  3.334525032924842e-27, -7.879113523437530e-30,  3.190504613528734e-02, -1.815385151425534e-04,  7.652634312675891e-07, -2.818826259315937e-09,
  9.512809128019025e-12, -2.990085497371741e-14,  8.770946018662936e-17, -2.379891308548663e-19,  5.815314508689647e-22, -1.195016585550639e-24,  1.568634627845717e-27,
  1.964682715821392e-30,  5.269512044601308e-02, -2.978473433841582e-04,  1.236912578113141e-06, -4.433726227128979e-09,  1.430102879819831e-11, -4.179150446666310e-14,
  1.087106005345743e-16, -2.373437967433738e-19,  3.467272347284543e-22,  2.456785282591770e-25, -4.728268147764155e-27,  2.481394321762667e-29,  7.863017830387495e-02,
 -4.407095221865886e-04,  1.795380855944917e-06, -6.208672365492899e-09,  1.880972470385231e-11, -4.919125460569174e-14,  1.024657975881190e-16, -1.138863163229335e-19,
 -3.393745790049434e-22,  3.022678173294998e-24, -1.376524995787185e-26,  4.760873308758501e-29,  1.096728745677561e-01, -6.084031121906047e-04,  2.420179869923906e-06,
 -7.992315985562612e-09,  2.220874687638188e-11, -4.856236211091868e-14,  5.783558252255658e-17,  1.497053208951378e-19, -1.398357494128287e-21,  6.222523439014136e-24,
 -2.009679343861528e-26,  4.587382790360935e-29,  1.457759905204548e-01, -7.988229885124249e-04,  3.087015264133819e-06, -9.614731762231591e-09,  2.365594181944664e-11,
 -3.700829399740262e-14, -2.949998690636425e-17,  5.255051910870403e-19, -2.526479603997324e-21,  8.087405707892358e-24, -1.633290631632704e-26, -2.612409666954778e-30,
  1.868810145489939e-01, -1.009460575713170e-03,  3.768014355732541e-06, -1.089452104031361e-08,  2.237974954478468e-11, -1.288239799475514e-14, -1.540296293226932e-16,
  9.327460454659813e-19, -3.223964926609420e-21,  6.532614266142268e-24,  2.964295176708212e-27, -9.715388531767264e-29,  2.329163929565060e-01, -1.237381228901408e-03,
  4.432053486340281e-06, -1.164765569042664e-08,  1.777253989865110e-11,  2.362730196869748e-14, -2.985304165230890e-16,  1.242776184131084e-18, -2.912905852020705e-21,
  9.114066705628338e-26,  3.631061516429072e-26, -1.972663313573774e-28,  2.837954042529794e-01, -1.479200064614575e-03,  5.045218444437603e-06, -1.169824853715871e-08,
  9.491115156285384e-12,  7.001411684735016e-14, -4.340415716262383e-16,  1.300090775839887e-18, -1.141151668024656e-21, -1.093585337417065e-23,  7.157072400001880e-26,
 -2.246032077773852e-28,  3.394136014076073e-01, -1.731057442506404e-03,  5.571439115450197e-06, -1.089138456258931e-08, -2.441465999075972e-12,  1.211674198845500e-13,
 -5.224051019960029e-16,  9.606136579897854e-19,  2.160685120603928e-21, -2.355900591690087e-23,  8.653400620770948e-26, -9.597670422240195e-29,  3.996457572831608e-01,
 -1.988595854859356e-03,  5.973347869053959e-06, -9.108034374720706e-09, -1.754168471314922e-11,  1.694035912742940e-13, -5.219340928356265e-16,  1.443721040817300e-19,
  6.439713355526204e-21, -3.201214390712193e-23,  5.643533963679666e-26,  2.135333837744384e-28,  4.643422392585384e-01, -2.246940745703465e-03,  6.213419375663472e-06,
 -6.281868401106284e-09, -3.479189787262648e-11,  2.049429386966834e-13, -3.963951385864747e-16, -1.106166664637599e-18,  1.040672078620417e-20, -2.909501192633315e-23,
 -3.127268531830665e-26,  6.023080508505490e-28,  5.333247307022608e-01, -2.500688815174465e-03,  6.255456161772372e-06, -2.417458681200338e-09, -5.260487331220054e-11,
  2.169572921906494e-13, -1.268037591179141e-16, -2.578150388578149e-18,  1.217687537602283e-20, -9.234596842301783e-24, -1.591316398253697e-25,  8.202940652654444e-28,
  6.063812108868968e-01, -2.743908735866263e-03,  6.066486818097752e-06,  2.391150837694903e-09, -6.884922125805582e-11,  1.952754654526287e-13,  2.755412716666406e-16,
 -3.874161542804560e-18,  9.774730909941504e-21,  2.719562544582995e-23, -2.689574967431638e-25,  5.550504515876466e-28,  6.832601033940949e-01, -2.970160985205023e-03,
  5.619138339349756e-06,  7.943252591840488e-09, -8.096268020469085e-11,  1.327433601127417e-13,  7.578102110320078e-16, -4.459357392202534e-18,  2.021261496198851e-21,
  6.992727260905767e-23, -2.724251370813074e-25, -3.475816825939744e-28,  7.636635095692917e-01, -3.172545734785536e-03,  4.894524338347100e-06,  1.391839432643258e-08,
 -8.618166231505423e-11,  2.806874871567548e-14,  1.220845820788171e-15, -3.793233117993429e-18, -1.036810851490380e-20,  9.809575459258472e-23, -9.419296417518758e-26,
 -1.602626195421035e-27,  8.472394634335773e-01, -3.343790440875417e-03,  3.885647636482336e-06,  1.987137497017622e-08, -8.191069092359001e-11, -1.112808091133702e-13,
  1.526780796817808e-15, -1.549534890962922e-18, -2.392133525698181e-20,  8.612681206853847e-23,  2.575799293318491e-25, -2.365342551040550e-27,  9.335731853393553e-01,
 -3.476391853781808e-03,  2.601236348699647e-06,  2.524066317525132e-08, -6.623933239743439e-11, -2.669109725391174e-13,  1.524958430421763e-15,  2.113847193047592e-18,
 -3.250280886186697e-20,  1.784966231844529e-23,  6.295934116084464e-25, -1.573034140694357e-27,  1.022177384333416e+00, -3.562830315572139e-03,  1.069801299322854e-06,
  2.937682137901386e-08, -3.858056318248528e-11, -4.092342654436995e-13,  1.099016996108347e-15,  6.336186478856859e-18, -2.913204239837321e-20, -9.468724184701565e-23,
  7.391686752807057e-25,  1.130145277187809e-27,  1.112481778026660e+00, -3.595876815367808e-03, -6.564971506723373e-07,  3.159802215432972e-08, -3.472039790674574e-13,
 -5.005361707543701e-13,  2.302226965692451e-16,  9.553242596553528e-18, -9.789655268697548e-21, -1.993616023442106e-22,  3.322035943455850e-25,  4.359381068875580e-27,
  1.203822181652895e+00, -3.569014151899007e-03, -2.498864158412174e-06,  3.127849019987532e-08,  4.449919517074898e-11, -5.026449941544588e-13, -9.411945834509726e-16,
  9.900368937506071e-18,  2.188192521143481e-20, -2.169969353325772e-22, -5.410221631764267e-25,  5.076336577671954e-27,  1.295429784886890e+00, -3.476990774715531e-03,
 -4.350810297445391e-06,  2.797117991299324e-08,  8.928798535385936e-11, -3.894595521181303e-13, -2.091209653382860e-15,  6.097071019026953e-18,  5.205431484054913e-20,
 -9.102826986917398e-23, -1.335627119653672e-24,  9.559199426622572e-28,  1.386421603704178e+00, -3.316516531184029e-03, -6.080434709337020e-06,  2.155641166905052e-08,
  1.251996308561358e-10, -1.623019571133147e-13, -2.768003911959572e-15, -1.416132472023331e-18,  6.066964438650405e-20,  1.434058959312995e-22, -1.242453916624530e-24,
 -5.940142867901695e-27,  1.475793571896431e+00, -3.087089796343747e-03, -7.537746797628526e-06,  1.239226285154123e-08,  1.428511467612276e-10,  1.374472947665097e-13,
 -2.558947085225767e-15, -9.776358227765081e-18,  3.402619311824523e-20,  3.323911454981347e-22,  3.982865979803841e-26, -8.621017416592560e-27,  1.562418302849117e+00,
 -2.791911164352662e-03, -8.568669960852444e-06,  1.421253174467193e-09,  1.349790977919571e-10,  4.274524069493839e-13, -1.341620099345445e-15, -1.441199747915144e-17,
 -1.942712316021774e-20,  2.920888074400872e-22,  1.581848720951536e-24, -1.971145893152169e-27,  1.645050136527945e+00, -2.438787359937696e-03, -9.036645078147874e-06,
 -9.832613816899221e-09,  9.976614736220337e-11,  6.045933428764453e-13,  5.054203947984650e-16, -1.167281229321489e-17, -6.514113920696562e-20, -5.358622552289306e-25,
  1.725219337189334e-24,  8.123422310532334e-27,  1.722340540249723e+00, -2.040862535085747e-03, -8.850966073524456e-06, -1.944816242023731e-08,  4.358621252934392e-11,
  5.882829420668195e-13,  2.135396315702386e-15, -2.227408031029488e-18, -6.472339470251725e-20, -3.012776596805004e-22,  3.765964220360783e-26,  8.504262082738639e-27,
  1.792867005916316e+00, -1.616944885401723e-03, -7.997940512889084e-06, -2.551456197557689e-08, -1.871445651799113e-11,  3.722244773329056e-13,  2.651902023683523e-15,
  7.877482947713357e-18, -1.510122367432294e-20, -2.998372541624391e-22, -1.559225453685818e-24, -2.093877389194504e-27,  1.855177944911152e+00, -1.191151600636862e-03,
 -6.567090001153449e-06, -2.672055324167488e-08, -6.770167370934625e-11,  5.072400858937902e-14,  1.764666641178859e-15,  1.121264883744563e-17,  3.765562808219184e-20,
 -9.180811965947517e-24, -1.054480906414468e-24, -7.631598415722399e-27,  1.907854386878867e+00, -7.916161762795352e-04, -4.761367201403042e-06, -2.295484116000603e-08,
 -8.734518822439906e-11, -2.162235305432779e-13,  1.576491170035941e-16,  5.971299623775855e-18,  4.315061926244465e-20,  1.983159471968866e-22,  5.113187936851615e-25,
 -9.880221849170137e-28,  1.949586400229521e+00, -4.481326394098091e-04, -2.880332458173384e-06, -1.563104831452641e-08, -7.390291176407948e-11, -2.995798324888945e-13,
 -9.573644000324987e-16, -1.561462587522348e-18,  8.184519036444196e-21,  1.056912910437639e-22,  7.136160880039990e-25,  3.605493242848130e-27,  1.979258550911574e+00,
 -1.888663312902718e-04, -1.270971269097931e-06, -7.453277265244554e-09, -3.992896815370914e-11, -1.985410986173891e-13, -9.175138600802833e-16, -3.897908444807797e-18,
 -1.476512485945969e-20, -4.583840796650789e-23, -7.969883473144662e-26,  3.289743383256232e-28,  1.996038835762040e+00, -3.656149542327405e-05, -2.524055983352828e-07,
 -1.543314243010700e-09, -8.806943466728857e-12, -4.798464034311996e-14, -2.525445211035578e-16, -1.292175879668535e-18, -6.450718260646497e-21, -3.147601719740785e-23,
 -1.501959594115298e-25, -7.004387423933539e-28,  6.372248523466360e-04, -3.619964972724881e-06,  1.541900874004859e-08, -5.836321925010593e-11,  2.070095380436658e-13,
 -7.045889660155091e-16,  2.329939909653518e-18, -7.543694456693272e-21,  2.401847855403902e-23, -7.549422589371324e-26,  2.345566739366696e-28, -7.226684337793945e-31,
  5.734022350167062e-03, -3.252392384465478e-05,  1.380604793066076e-07, -5.194522334180017e-10,  1.825388306834945e-12, -6.130496168467683e-15,  1.990568645556981e-17,
 -6.291874943585118e-20,  1.942377559945330e-22, -5.872566122764151e-25,  1.738273852437597e-27, -5.045927017085043e-30,  1.592223808316979e-02, -9.003367534077039e-05,
  3.795548069070155e-07, -1.410760725235331e-09,  4.863466189736746e-12, -1.588208206123020e-14,  4.957738759626333e-17, -1.484752943594005e-19,  4.259767290094327e-22,
 -1.165795647992682e-24,  3.004233285474334e-27, -7.143334305520974e-30,  3.119092565274159e-02, -1.755491685860985e-04,  7.323313756519616e-07, -2.671293305256555e-09,
  8.935313240205806e-12, -2.787372877376411e-14,  8.129991039500285e-17, -2.200561962615290e-19,  5.396579008667965e-22, -1.130889702242353e-24,  1.629662188919473e-27,
  8.587057517162881e-31,  5.152319011952447e-02, -2.881610343515386e-04,  1.185053632833566e-06, -4.211456885313378e-09,  1.349075746699307e-11, -3.926093688525193e-14,
  1.022213893705844e-16, -2.261414608870181e-19,  3.524183521261546e-22,  7.706755660032938e-26, -3.733527030549338e-27,  2.052199317842434e-29,  7.689560157516580e-02,
 -4.266394492755384e-04,  1.722650484705238e-06, -5.915454860593053e-09,  1.785022717991541e-11, -4.677147159784060e-14,  9.914056521379155e-17, -1.231075187008009e-19,
 -2.399807031010256e-22,  2.512171109582432e-24, -1.180338064764752e-26,  4.166658042291063e-29,  1.072773860123628e-01, -5.894193369374621e-04,  2.326372314616612e-06,
 -7.644669259058421e-09,  2.125169443159022e-11, -4.712886206697673e-14,  6.143346021988316e-17,  1.083908212410598e-19, -1.188335152948804e-21,  5.458433717297809e-24,
 -1.812339831566351e-26,  4.372184999527070e-29,  1.426293691004491e-01, -7.745819955861156e-04,  2.973884916600927e-06, -9.242191646295240e-09,  2.290984169872286e-11,
 -3.754859518017130e-14, -1.587483481110203e-17,  4.491900430475806e-19, -2.247094994386762e-21,  7.434541253658651e-24, -1.624710509514225e-26,  6.075149888301162e-30,
  1.829026410586503e-01, -9.798333314283091e-04,  3.639419429965025e-06, -1.053869841311943e-08,  2.208719061687958e-11, -1.627714636468212e-14, -1.293216050574142e-16,
  8.333568911809495e-19, -2.987623986193304e-21,  6.572527998092199e-24, -8.063230798687635e-28, -7.486627158472931e-29,  2.280369025437386e-01, -1.202479020910655e-03,
  4.294002146783439e-06, -1.135989232553516e-08,  1.817620286609742e-11,  1.686962434495873e-14, -2.650352692955293e-16,  1.149879529477741e-18, -2.885497766034209e-21,
  1.378205322305674e-24,  2.824332594637003e-26, -1.697179119717304e-28,  2.779584422030823e-01, -1.439397148600148e-03,  4.905795018601688e-06, -1.153574212801505e-08,
  1.079015332282785e-11,  6.002947873289681e-14, -3.982056225656232e-16,  1.257808237324311e-18, -1.485666783674324e-21, -8.267709277868641e-24,  6.191843719504439e-26,
 -2.133801073324569e-28,  3.325776862179796e-01, -1.687009200325957e-03,  5.440585909125618e-06, -1.091173317184179e-08, -1.412790144083659e-13,  1.089595166641995e-13,
 -4.946627220875581e-16,  1.016844751186314e-18,  1.373753560089022e-21, -2.019225719088125e-23,  8.157508835575332e-26, -1.273638118653976e-28,  3.917862488169338e-01,
 -1.941250775815042e-03,  5.862477061279953e-06, -9.362275577700675e-09, -1.427843374924497e-11,  1.569479192272846e-13, -5.151767271486982e-16,  3.324564276091147e-19,
  5.329936731728484e-21, -2.959266195115394e-23,  6.392588237679422e-26,  1.293824300702046e-28,  4.554534006100627e-01, -2.197544075672200e-03,  6.134830493449866e-06,
 -6.806274662293852e-09, -3.079049237148826e-11,  1.950944388742952e-13, -4.228644867871416e-16, -7.901018031114560e-19,  9.342883764639307e-21, -2.984738917321265e-23,
 -7.120876827029447e-27,  4.960110842517592e-28,  5.234218592463047e-01, -2.450775183840373e-03,  6.221539180788483e-06, -3.224612595711215e-09, -4.830178151209434e-11,
  2.130914256562850e-13, -1.935950607099524e-16, -2.194968131253932e-18,  1.173844061060950e-20, -1.489075025284770e-23, -1.240346747335165e-25,  7.711823261608738e-28,
  5.955027954159364e-01, -2.695280494096848e-03,  6.088701049382791e-06,  1.321130442609841e-09, -6.488618239961615e-11,  2.006229147440763e-13,  1.715764942638307e-16,
 -3.547731965310904e-18,  1.056632359581613e-20,  1.695953392200415e-23, -2.421000201998130e-25,  6.577073743209860e-28,  6.714699385380811e-01, -2.924848416234888e-03,
  5.706775649143450e-06,  6.670034538157047e-09, -7.813600500631083e-11,  1.494420202005995e-13,  6.342170337534240e-16, -4.356526738944561e-18,  4.339601009372119e-21,
  5.881052208149881e-23, -2.813565674068471e-25, -6.543366525801093e-29,  7.510526637928306e-01, -3.132744845737615e-03,  5.053295212706271e-06,  1.254553396755676e-08,
 -8.533606741424977e-11,  5.606026475582720e-14,  1.110515319907160e-15, -4.069368814759758e-18, -6.920602622981242e-21,  9.301378695707233e-23, -1.574923594704031e-25,
 -1.271674494539846e-27,  8.339279505962421e-01, -3.311773869784292e-03,  4.116173669612488e-06,  1.854497363764931e-08, -8.377382870162885e-11, -7.524228227081235e-14,
  1.473156182191543e-15, -2.263622756843338e-18, -2.066025235363516e-20,  9.436572491803685e-23,  1.549924405572078e-25, -2.279634571908978e-27,  9.197111300418013e-01,
 -3.454388820952089e-03,  2.897595660990223e-06,  2.414013466568434e-08, -7.120737189078016e-11, -2.297184836949476e-13,  1.569715322705175e-15,  1.088755337081930e-18,
 -3.142486899937050e-20,  4.151113527871982e-23,  5.503224384629798e-25, -2.006417879402384e-27,  1.007945396907384e+00, -3.552872924098118e-03,  1.418354129608717e-06,
  2.869554639075060e-08, -4.648767097669021e-11, -3.808371838791674e-13,  1.262907787290831e-15,  5.355209646470497e-18, -3.199891977012207e-20, -6.438079775660730e-23,
  7.698800880199975e-25,  2.696999121273110e-28,  1.098090167127066e+00, -3.599612940365148e-03, -2.776833510319829e-07,  3.151277153977862e-08, -1.028121791957622e-11,
 -4.918428666748738e-13,  4.922691897535831e-16,  9.128071594373026e-18, -1.668273116179252e-20, -1.824020483592607e-22,  5.112920805619171e-25,  3.744835047307380e-27,
  1.189508536454942e+00, -3.587492365376428e-03, -2.119585813828596e-06,  3.190892238704891e-08,  3.424324041499200e-11, -5.218353716442300e-13, -6.553827318540652e-16,
  1.047187131255586e-17,  1.373594569388573e-20, -2.339976981650216e-22, -3.053255363809545e-25,  5.582431177828210e-27,  1.281454368117101e+00, -3.510430963520721e-03,
 -4.006850201812238e-06,  2.933480860111210e-08,  8.101169075917386e-11, -4.374151335637669e-13, -1.897736869004231e-15,  7.700177377330144e-18,  4.783024395168108e-20,
 -1.431224232533766e-22, -1.257014717507163e-24,  2.610505834466269e-27,  1.373059936633182e+00, -3.364091516999222e-03, -5.809857443295186e-06,  2.353001849547878e-08,
  1.212872117348101e-10, -2.289860750511586e-13, -2.779770757618868e-15,  5.978146514219104e-19,  6.487773521897309e-20,  8.882050022265588e-23, -1.477542113374886e-24,
 -4.667727366423369e-27,  1.463325605676694e+00, -3.146757899808081e-03, -7.375246275763789e-06,  1.469644518412056e-08,  1.449644553559073e-10,  7.288179598027284e-14,
 -2.815644683641358e-15, -8.496517046079994e-18,  4.592655781785464e-20,  3.260776119619084e-22, -3.625660116959037e-25, -9.587990773823250e-27,  1.551113720161008e+00,
 -2.860354951896911e-03, -8.538380855432712e-06,  3.647423314251605e-09,  1.431731504470136e-10,  3.903509925689083e-13, -1.752192729033814e-15, -1.485342412582700e-17,
 -7.800628682426627e-21,  3.528846940212834e-22,  1.439040036872389e-24, -4.564294250455616e-27,  1.635149693014800e+00, -2.511524426939107e-03, -9.144658041127470e-06,
 -8.139076814461196e-09,  1.119516255323849e-10,  6.125662925378164e-13,  1.494944755047380e-16, -1.374363003293764e-17, -6.383378364976679e-20,  7.542956742586179e-23,
  2.066951129422472e-24,  7.283665773852440e-27,  1.714034014530524e+00, -2.112591007861980e-03, -9.079762527863835e-06, -1.865389873590472e-08,  5.585806274550144e-11,
  6.385400123139088e-13,  2.042408806155810e-15, -4.471029471741615e-18, -7.544593660204557e-20, -2.916108299627248e-22,  4.624289932356375e-25,  1.080038846157869e-26,
  1.786269313808129e+00, -1.682157610195843e-03, -8.305654772375778e-06, -2.575090540402810e-08, -1.061597047009128e-11,  4.384519460352998e-13,  2.863996748080816e-15,
  7.209347381981065e-18, -2.703600361639112e-20, -3.635770535768146e-22, -1.614831320891201e-24, -3.163064761715797e-28,  1.850306208430238e+00, -1.244989229466309e-03,
 -6.894194771386040e-06, -2.779325386710883e-08, -6.623754195731253e-11,  9.697900759588040e-14,  2.095378882595885e-15,  1.240351937890563e-17,  3.648131721489157e-20,
 -5.847615509558495e-23, -1.420105594775268e-24, -8.977550977422236e-27,  1.904609961758775e+00, -8.308330311878733e-04, -5.045352312742633e-06, -2.438669462220655e-08,
 -9.161744524122566e-11, -2.102708269771331e-13,  3.452778241720458e-16,  7.470192061874226e-18,  5.064463245039462e-20,  2.175601244517420e-22,  4.417291671617373e-25,
 -2.247460273191966e-27,  1.947746567403499e+00, -4.719461545299056e-04, -3.075201523306443e-06, -1.686269036477874e-08, -8.012764865305218e-11, -3.230479137196662e-13,
 -9.968055543168257e-16, -1.232848612571634e-18,  1.254323657628564e-20,  1.376067912246144e-22,  8.871713596912271e-25,  4.293329334874263e-27,  1.978482167856414e+00,
 -1.994030291749727e-04, -1.364378793675026e-06, -8.125141857941632e-09, -4.412911638747186e-11, -2.219260651736983e-13, -1.033522351192965e-15, -4.397377937749888e-18,
 -1.646852640568427e-20, -4.866119527690309e-23, -5.938087986064298e-26,  6.123311258425340e-28,  1.995888430518092e+00, -3.865728992128000e-05, -2.718036070873215e-07,
 -1.692244933989034e-09, -9.830302763537829e-12, -5.450429575994763e-14, -2.917943453836527e-16, -1.517951652208832e-18, -7.699853578895379e-21, -3.814802401584676e-23,
 -1.846564630551827e-25, -8.725010808464492e-28,  6.229873390950184e-04, -3.499359082320435e-06,  1.473806764511410e-08, -5.516083291928958e-11,  1.934602736344221e-13,
 -6.511206867095539e-16,  2.129080727222309e-18, -6.816837420611238e-21,  2.146217878491281e-23, -6.671795753473449e-26,  2.049697831115637e-28, -6.247274062745477e-31,
  5.606096832960072e-03, -3.144388636442304e-05,  1.319983261304362e-07, -4.912015294761673e-10,  1.707416597224906e-12, -5.673217094879229e-15,  1.822789497073777e-17,
 -5.702840405454707e-20,  1.742963547915109e-22, -5.219711825681407e-25,  1.530652634110247e-27, -4.406577405583115e-30,  1.556807087716609e-02, -8.706365426517374e-05,
  3.630822944026355e-07, -1.335423136676981e-09,  4.557394178633176e-12, -1.474061009080136e-14,  4.560476949550906e-17, -1.354929471301255e-19,  3.860972517648926e-22,
 -1.051708306126797e-24,  2.705084522814093e-27, -6.463596162118993e-30,  3.050024663827288e-02, -1.698163509438885e-04,  7.011155871691441e-07, -2.532684135238244e-09,
  8.396861482910339e-12, -2.599455556984485e-14,  7.537407330901986e-17, -2.034258971555896e-19,  5.001258981950390e-22, -1.065211582658720e-24,  1.648147887430985e-27,
  2.086351952547010e-32,  5.038919187237031e-02, -2.788791445545337e-04,  1.135785776664293e-06, -4.001755348968117e-09,  1.272956556716069e-11, -3.688233115088072e-14,
  9.604753338147707e-17, -2.148468066467073e-19,  3.527120730432283e-22, -5.532390734390199e-26, -2.912368944278105e-27,  1.690630265180787e-29,  7.521616337305759e-02,
 -4.131374022280083e-04,  1.653348194548302e-06, -5.637206568429893e-09,  1.693830813402217e-11, -4.443424953519970e-14,  9.559900983632910e-17, -1.294275243174449e-19,
 -1.576139387148630e-22,  2.075086029845846e-24, -1.008981968347178e-26,  3.631883660589523e-29,  1.049563576936490e-01, -5.711695931946678e-04,  2.236645603257651e-06,
 -7.312101700002367e-09,  2.032408559604952e-11, -4.562216006618419e-14,  6.396459417392059e-17,  7.337195990523137e-20, -1.004423565751645e-21,  4.771219532232668e-24,
 -1.625668976217089e-26,  4.106449495764444e-29,  1.395779295921927e-01, -7.512283671630970e-04,  2.865153123859582e-06, -8.881658521903691e-09,  2.215603763721811e-11,
 -3.778654602317359e-14, -4.264867027851940e-18,  3.814405175599376e-19, -1.991066423057006e-21,  6.792012460554704e-24, -1.583354938183087e-26,  1.236887022139579e-29,
  1.790407459502659e-01, -9.512178515948379e-04,  3.515064151351249e-06, -1.018806860004947e-08,  2.173244565153046e-11, -1.911144196599943e-14, -1.072905771076096e-16,
  7.415263803143547e-19, -2.752334663426465e-21,  6.480136675383240e-24, -3.677331439007433e-27, -5.619937898290025e-29,  2.232948341533333e-01, -1.168667311190796e-03,
  4.159438398255458e-06, -1.106670878597855e-08,  1.845254111274820e-11,  1.088475673075248e-14, -2.341224144315817e-16,  1.058541341862823e-18, -2.817276647448557e-21,
  2.366268535465370e-24,  2.134605697254169e-26, -1.441547138703187e-28,  2.722784738721179e-01, -1.400701481221521e-03,  4.768439937697999e-06, -1.135400234405932e-08,
  1.189799738676321e-11,  5.088953681066585e-14, -3.636940126527916e-16,  1.205964591804729e-18, -1.740948016659433e-21, -5.974560225807527e-24,  5.284809943237749e-26,
 -1.984266589556182e-28,  3.259158696583844e-01, -1.644008153197016e-03,  5.309701398750769e-06, -1.089719539224577e-08,  1.921521373020807e-12,  9.743358922435716e-14,
 -4.656804835947564e-16,  1.049792511274691e-18,  7.041540288790578e-22, -1.704796714188254e-23,  7.549416252744352e-26, -1.473409436921568e-28,  3.841143286398381e-01,
 -1.894803998073173e-03,  5.748860443683220e-06, -9.566287141766099e-09, -1.126226827428572e-11,  1.447136897117547e-13, -5.036367144876146e-16,  4.864723645369556e-19,
  4.311801699609591e-21, -2.694329149799351e-23,  6.803580564972713e-26,  5.978101492048620e-29,  4.467608528812595e-01, -2.148800214996196e-03,  6.050326267268011e-06,
 -7.268265771993199e-09, -2.699171263889781e-11,  1.847130070675750e-13, -4.409634130665800e-16, -5.083357251885733e-19,  8.268233776012459e-21, -2.972602901638263e-23,
  1.245085978498479e-26,  3.947284935270857e-28,  5.137180399442407e-01, -2.401170467725065e-03,  6.178346625938508e-06, -3.963619058866182e-09, -4.409117685464561e-11,
  2.077495531709440e-13, -2.498823836285258e-16, -1.828807394698290e-18,  1.112107533716769e-20, -1.919250398961117e-23, -9.155252187800346e-26,  7.027152777177527e-28,
  5.848191685496371e-01, -2.646524814246592e-03,  6.098458586432219e-06,  3.152418458979770e-10, -6.084039238358761e-11,  2.035874192377495e-13,  7.705250609182692e-17,
 -3.201652076505821e-18,  1.100971553854038e-20,  7.874170681594611e-24, -2.117544861206879e-25,  7.146094224263810e-28,  6.598623305079274e-01, -2.878895070056989e-03,
  5.779416205197591e-06,  5.444555032773020e-09, -7.500474399994814e-11,  1.632170065833026e-13,  5.144812122927948e-16, -4.185957908737322e-18,  6.254180932356684e-21,
  4.757178023539827e-23, -2.788570130905503e-25,  1.711536602296744e-28,  7.386034579487748e-01, -3.091739415389997e-03,  5.195690941585965e-06,  1.119053549182537e-08,
 -8.395768414031624e-11,  8.132334755440035e-14,  9.939666807759696e-16, -4.238571477301709e-18, -3.698077897311274e-21,  8.569471089837459e-23, -2.059968163882471e-25,
 -9.335856759253818e-28,  8.207480910094642e-01, -3.277977210174188e-03,  4.330627566385929e-06,  1.719445175574110e-08, -8.493062339794868e-11, -4.071864166489961e-14,
  1.401037066965417e-15, -2.869393091597422e-18, -1.717524113524748e-20,  9.860716619381077e-23,  5.842241238380408e-26, -2.095663341250319e-27,  9.059417431516217e-01,
 -3.430069033435614e-03,  3.180296408996059e-06,  2.296611700653639e-08, -7.542312145944577e-11, -1.917915981495025e-13,  1.586376049459072e-15,  1.111398599280987e-19,
 -2.955639589206562e-20,  6.166342769299567e-23,  4.552110352693371e-25, -2.292165987055744e-27,  9.937587611379040e-01, -3.540161917409598e-03,  1.757991986097882e-06,
  2.789250541199438e-08, -5.378977747845187e-11, -3.488456834038910e-13,  1.398212148780162e-15,  4.300112869846258e-18, -3.376168419446309e-20, -3.359212728180905e-23,
  7.636466232429930e-25, -5.405475241825654e-28,  1.083689662474759e+00, -3.600325333634666e-03,  9.916060823821620e-08,  3.127030485109454e-08, -1.997956515622364e-11,
 -4.770276173840739e-13,  7.394241144309127e-16,  8.493416848103931e-18, -2.284339288744104e-20, -1.588801015823114e-22,  6.589342851172374e-25,  2.939788717361019e-27,
  1.175127090795776e+00, -3.602908907695030e-03, -1.733738299459676e-06,  3.237256644054847e-08,  2.367321472946334e-11, -5.340041952496159e-13, -3.572970248237962e-16,
  1.077476709888660e-17,  5.152100970020865e-21, -2.412251222608696e-22, -5.487362162097322e-26,  5.743226340816712e-27,  1.267350794317358e+00, -3.541056339714752e-03,
 -3.647351878666932e-06,  3.055861093601563e-08,  7.182626764653369e-11, -4.802057063439277e-13, -1.661546277626333e-15,  9.138855393172301e-18,  4.180474712416555e-20,
 -1.906379134037006e-22, -1.107465623817684e-24,  4.159202614375047e-27,  1.359512447213289e+00, -3.409408317099745e-03, -5.516016495799033e-06,  2.543036123579927e-08,
  1.160429245524554e-10, -2.952625723474420e-13, -2.733569540231542e-15,  2.713282244434417e-18,  6.696621088379948e-20,  2.608536687477068e-23, -1.646757082206284e-24,
 -2.958960293891869e-27,  1.450621742848766e+00, -3.205014923776273e-03, -7.184936350656044e-06,  1.702378819522361e-08,  1.457279703232260e-10,  2.628290217407142e-15,
 -3.031232119409019e-15, -6.842681320083289e-18,  5.730106569694605e-20,  3.029740722435356e-22, -7.955373498078315e-25, -9.987848386498555e-27,  1.539536019205101e+00,
 -2.928447401538994e-03, -8.480617310078890e-06,  5.998223262966222e-09,  1.505258619237472e-10,  3.432915344195899e-13, -2.169596781598759e-15, -1.488911434799434e-17,
  5.883578429925543e-21,  4.056208367663739e-22,  1.177578171006333e-24, -7.332704024407579e-27,  1.624956706426338e+00, -2.585040984412111e-03, -9.231175049046683e-06,
 -6.249780212615329e-09,  1.242064793523707e-10,  6.113085719642549e-13, -2.633991978288265e-16, -1.572630425926959e-17, -5.955664702110127e-20,  1.640912069153445e-22,
  2.354036510376693e-24,  5.621875095604119e-27,  1.705436979352971e+00, -2.186108314178722e-03, -9.297817003512282e-06, -1.765538762412054e-08,  6.910745025524791e-11,
  6.857731964905706e-13,  1.881873033716546e-15, -7.048728332047980e-18, -8.549046235374605e-20, -2.629547242918820e-22,  9.861593779598078e-25,  1.296305689295759e-26,
  1.779405832655273e+00, -1.749841088334425e-03, -8.615383111633958e-06, -2.584680725355180e-08, -1.143779723177824e-12,  5.094999068448872e-13,  3.051689824016345e-15,
  6.122321312083530e-18, -4.128463631958466e-20, -4.277593250251175e-22, -1.575782319770749e-24,  2.224969627630801e-27,  1.845213806890955e+00, -1.301494714678509e-03,
 -7.233999436502646e-06, -2.883468509722794e-08, -6.376626767336499e-11,  1.515652430733734e-13,  2.458621833995132e-15,  1.352548095797415e-17,  3.325510289400511e-20,
 -1.235510476052076e-22, -1.842420339717183e-24, -1.017994111715301e-26,  1.901204015009878e+00, -8.723916472964708e-04, -5.346925040793950e-06, -2.588569233129783e-08,
 -9.572207512343611e-11, -1.992836901282912e-13,  5.783324896195679e-16,  9.219323893381345e-18,  5.876674287011817e-20,  2.327754313945470e-22,  3.062935720579372e-25,
 -3.998772632878632e-27,  1.945808266569429e+00, -4.973794701068095e-04, -3.285463514055759e-06, -1.819773110347293e-08, -8.683038160716181e-11, -3.473352962110700e-13,
 -1.024910184955375e-15, -7.449723274673263e-19,  1.818331178139854e-20,  1.770854091413995e-22,  1.092101248112392e-24,  5.026012075273899e-27,  1.977662090766626e+00,
 -2.107204157490935e-04, -1.466267844954191e-06, -8.868106559008820e-09, -4.882597099618360e-11, -2.482693044150196e-13, -1.164293119544482e-15, -4.952798948672997e-18,
 -1.825560477140287e-20, -5.038731648811181e-23, -2.393679877902848e-26,  1.023403220151812e-27,  1.995729320002812e+00, -4.091570576960999e-05, -2.930915014623278e-07,
 -1.858645933941617e-09, -1.099401150745717e-11, -6.204655632143701e-14, -3.379635988682391e-16, -1.787824405524495e-18, -9.215929346282482e-21, -4.636232346226701e-23,
 -2.276378369261432e-25, -1.089536564824057e-27,  6.092215926309911e-04, -3.384050611927709e-06,  1.409428891591594e-08, -5.216693505766958e-11,  1.809337705568822e-13,
 -6.022377634263970e-16,  1.947474235728621e-18, -6.166947091626383e-21,  1.920152080653236e-23, -5.904332180587477e-26,  1.793718254334993e-28, -5.409647594375892e-31,
  5.482396573874369e-03, -3.041102148299332e-05,  1.262641509847978e-07, -4.647673412703756e-10,  1.598200794779729e-12, -5.254295853302837e-15,  1.670644161702563e-17,
 -5.174012849550699e-20,  1.565622821115219e-22, -4.644540742076319e-25,  1.349235155889735e-27, -3.852746597973383e-30,  1.522552580563563e-02, -8.422187863496376e-05,
  3.474851869706071e-07, -1.264805124029676e-09,  4.273226893097869e-12, -1.369025937644712e-14,  4.197839242089658e-17, -1.237232807781593e-19,  3.501165895871584e-22,
 -9.490052157053939e-25,  2.434614754170145e-27, -5.839577488156830e-30,  2.983200977299230e-02, -1.643267500213428e-04,  6.715126330078821e-07, -2.402397097138924e-09,
  7.894607976820839e-12, -2.425215543510235e-14,  6.989653033054122e-17, -1.880227168984289e-19,  4.629633430590091e-22, -9.994650683826867e-25,  1.634630612891408e-27,
 -6.041794058994046e-31,  4.929154854842601e-02, -2.699815354136257e-04,  1.088962808603920e-06, -3.803860249320902e-09,  1.201448966045657e-11, -3.464810607905835e-14,
  9.018938624243584e-17, -2.036129719607547e-19,  3.487942140746957e-22, -1.578743031250625e-25, -2.237273728637350e-27,  1.386745796994120e-29,  7.358964532383594e-02,
 -4.001766621033944e-04,  1.587298867124057e-06, -5.373179698648859e-09,  1.607227070157764e-11, -4.218386456273414e-14,  9.191512080642912e-17, -1.333507758417635e-19,
 -8.980363225358592e-23,  1.702007017264291e-24, -8.598934624924948e-27,  3.153972269524863e-29,  1.027069176445019e-01, -5.536219498994905e-04,  2.150821656391245e-06,
 -6.994131831098908e-09,  1.942714219168929e-11, -4.406583451365076e-14,  6.559397458644772e-17,  4.385661003976361e-20, -8.439367702460044e-22,  4.156235504191940e-24,
 -1.451401970946894e-26,  3.811394370482737e-29,  1.366181919996445e-01, -7.287274927932040e-04,  2.760675253691179e-06, -8.533209823824893e-09,  2.140011198961956e-11,
 -3.776771692682685e-14,  5.559363195364172e-18,  3.215175076496290e-19, -1.757809894908702e-21,  6.170965984252074e-24, -1.518701129127296e-26,  1.673621975521794e-29,
  1.752913495829513e-01, -9.235804843756407e-04,  3.394880595049656e-06, -9.843540324227173e-09,  2.132609833054860e-11, -2.144700096902546e-14, -8.772604287413618e-17,
  6.571512935682392e-19, -2.522249578788647e-21,  6.288352527714382e-24, -5.799488559686613e-27, -4.076234068743161e-29,  2.186858819582249e-01, -1.135917972324661e-03,
  4.028415558872785e-06, -1.077002196762976e-08,  1.861639534490027e-11,  5.611385706792867e-15, -2.057314854374752e-16,  9.699042682745006e-19, -2.718186220279812e-21,
  3.100273428530705e-24,  1.552356184892724e-26, -1.209019408829113e-28,  2.667511047490581e-01, -1.363095643249752e-03,  4.633366199260835e-06, -1.115595495185537e-08,
  1.283120336122882e-11,  4.255960477308581e-14, -3.307364718277050e-16,  1.147204111707942e-18, -1.920040915055206e-21, -4.030311387474203e-24,  4.448964794775021e-26,
 -1.812408702015234e-28,  3.194239650093386e-01, -1.602052940528435e-03,  5.179181886632192e-06, -1.085145889057837e-08,  3.760821598530473e-12,  8.661198755779554e-14,
 -4.360590152989071e-16,  1.063075708606630e-18,  1.431853182593665e-22, -1.416161499537664e-23,  6.874570641451669e-26, -1.580456399776543e-28,  3.766263633367713e-01,
 -1.849275143921392e-03,  5.633077217206130e-06, -9.723981085643601e-09, -8.487687127719574e-12,  1.328045773979217e-13, -4.882258489578801e-16,  6.094600042579385e-19,
  3.391302743685732e-21, -2.418665240718445e-23,  6.938948248965453e-26,  3.926176322127605e-30,  4.382618948539668e-01, -2.100753546354902e-03,  5.960635909590453e-06,
 -7.671158423456371e-09, -2.340428628622748e-11,  1.739879977233396e-13, -4.516526481948285e-16, -2.607460389277402e-19,  7.210990021567916e-21, -2.890873642321137e-23,
  2.773454702829082e-26,  3.015012041367257e-28,  5.042118938668565e-01, -2.351945627653697e-03,  6.126686457608362e-06, -4.636180501827528e-09, -4.000010026422711e-11,
  2.011774482713634e-13, -2.962153142219295e-16, -1.484635539742424e-18,  1.037147024133059e-20, -2.225927804775113e-23, -6.237378726885146e-26,  6.221349517197461e-28,
  5.743306456343337e-01, -2.597738252575997e-03,  6.096535422529675e-06, -6.255597293804352e-10, -5.675720609114954e-11,  2.044009404310001e-13, -7.630080603094958e-18,
 -2.846378379190950e-18,  1.114837623294894e-20,  4.068268279629913e-26, -1.797910564499883e-25,  7.324184340921916e-28,  6.484396062036816e-01, -2.832418550811793e-03,
  5.837660198696884e-06,  4.271225309393980e-09, -7.162629881563008e-11,  1.741821948317846e-13,  4.003184771454922e-16, -3.960557228550817e-18,  7.768345047199732e-21,
  3.662696162371344e-23, -2.670162670323092e-25,  3.589360797857157e-28,  7.263204497565612e-01, -3.049659446812598e-03,  5.321975190980690e-06,  9.861479857890820e-09,
 -8.210233549247149e-11,  1.037438074379009e-13,  8.740819456658782e-16, -4.309214603896536e-18, -7.703962994549154e-22,  7.673071756250814e-23, -2.398253794047918e-25,
 -6.073961232788813e-28,  8.077067463079848e-01, -3.242530007251149e-03,  4.528786614049187e-06,  1.583084535919822e-08, -8.541556212605956e-11, -8.116682004106484e-15,
  1.313535405710667e-15, -3.361928239588166e-18, -1.360489990563585e-20,  9.917125572551901e-23, -2.833763059877700e-26, -1.837905119722803e-27,  8.922740678554136e-01,
 -3.403545081722282e-03,  3.448529310133989e-06,  2.173072820454343e-08, -7.887851430946779e-11, -1.537859340296172e-13,  1.576604318547714e-15, -7.958329851064404e-19,
 -2.703355152417466e-20,  7.780357062053335e-23,  3.507894599967576e-25, -2.430548428502501e-27,  9.796283398312520e-01, -3.524774290286022e-03,  2.087314006841065e-06,
  2.697791566005925e-08, -6.042200249172735e-11, -3.139667441921189e-13,  1.503349970520586e-15,  3.206225522465193e-18, -3.442890881313391e-20, -3.740196745333312e-24,
  7.237540220777596e-25, -1.253375162628292e-27,  1.069292315633377e+00, -3.598037227000040e-03,  4.721747305056233e-07,  3.087535090423772e-08, -2.932384128953997e-11,
 -4.565153494286760e-13,  9.661837425045170e-16,  7.676237468122268e-18, -2.805989061076236e-20, -1.302029754444933e-22,  7.681324066841790e-25,  2.008708058679286e-27,
  1.160690183684433e+00, -3.615219305990289e-03, -1.343348544694846e-06,  3.266553409780370e-08,  1.293187892659511e-11, -5.389483991436742e-13, -5.460107873629170e-17,
  1.080075793249602e-17, -3.510851682381272e-21, -2.383973923174928e-22,  1.948560581189035e-25,  5.550804297809564e-27,  1.253130560384634e+00, -3.568749548220959e-03,
 -3.274076935794631e-06,  3.162892128641264e-08,  6.184486259116349e-11, -5.168676333531143e-13, -1.388020291351322e-15,  1.035863303106090e-17,  3.419226867943377e-20,
 -2.308675815475533e-22, -8.943974410563134e-25,  5.478355508137690e-27,  1.345788534328193e+00, -3.452284699863292e-03, -5.199918379027392e-06,  2.723627163598748e-08,
  1.094890236128374e-10, -3.597140211490625e-13, -2.627547544934500e-15,  4.858292928013090e-18,  6.669349839633392e-20, -4.180740955221121e-23, -1.732987538341153e-24,
 -9.162976489949854e-28,  1.437688073912036e+00, -3.261637656733651e-03, -6.966672245156276e-06,  1.935184223234083e-08,  1.450386339583763e-10, -7.220338363986149e-14,
 -3.195565385321577e-15, -4.841534413051028e-18,  6.752962808157382e-20,  2.623947318990116e-22, -1.231350222620823e-24, -9.701253706246492e-27,  1.527687054052830e+00,
 -2.995962979547806e-03, -8.393971126133631e-06,  8.458593359299239e-09,  1.568373892120698e-10,  2.862535453230919e-13, -2.581600001829527e-15, -1.445879127185825e-17,
  2.124860612012760e-20,  4.454577906768590e-22,  7.944027318811693e-25, -1.005615400711477e-26,  1.614468417621224e+00, -2.659155663893556e-03, -9.293846656755027e-06,
 -4.165164156578882e-09,  1.363326802967274e-10,  5.994937154677278e-13, -7.293968589748866e-16, -1.751898327590482e-17, -5.190098104271688e-20,  2.625129139020145e-22,
  2.548412164538898e-24,  3.063128267689791e-27,  1.696542467145941e+00, -2.261318453623941e-03, -9.502586977414512e-06, -1.643756352084664e-08,  8.325694351603358e-11,
  7.282521965888956e-13,  1.644846710523719e-15, -9.927122198682731e-18, -9.410419918399737e-20, -2.115437374713977e-22,  1.597224821250068e-24,  1.471998384907929e-26,
  1.772266658429531e+00, -1.820004310512166e-03, -8.925305288871575e-06, -2.577955292826271e-08,  9.791675922339596e-12,  5.846336191623930e-13,  3.202218915155590e-15,
  4.542904656309737e-18, -5.778656033847723e-20, -4.879000745372151e-22, -1.406642349885338e-24,  5.604423277496577e-27,  1.839889868449708e+00, -1.360767867623534e-03,
 -7.586026444179415e-06, -2.982735803001528e-08, -6.011361567239198e-11,  2.152323387945014e-13,  2.851458359958361e-15,  1.450336160380969e-17,  2.737012724874131e-20,
 -2.064908199786109e-22, -2.310801807293589e-24, -1.103131519351125e-26,  1.897626893157503e+00, -9.164358948191176e-04, -5.666871503106077e-06, -2.744828508711393e-08,
 -9.954690833293123e-11, -1.820856986360315e-13,  8.640755209476325e-16,  1.123592102719698e-17,  6.731899544243717e-20,  2.408631959679249e-22,  8.097450653378344e-26,
 -6.351037391379773e-27,  1.943764764195312e+00, -5.245608238388432e-04, -3.512405590807638e-06, -1.964393317018127e-08, -9.402438963362466e-11, -3.721114975474947e-13,
 -1.036602221497747e-15, -5.222853535236946e-20,  2.539997717417115e-20,  2.254096899084079e-22,  1.329440444360467e-24,  5.756219360013057e-27,  1.976795055582590e+00,
 -2.228898957598918e-04, -1.577541324331103e-06, -9.690611781676135e-09, -5.408236867095337e-11, -2.779441723397406e-13, -1.311423459701759e-15, -5.566088914534031e-18,
 -2.007451564782645e-20, -5.028604665169881e-23,  3.327167848662286e-26,  1.610895235574889e-27,  1.995560822108865e+00, -4.335274041826645e-05, -3.164931040523173e-07,
 -2.044935911631269e-09, -1.232028769151311e-11, -7.079332392483720e-14, -3.924154256095159e-16, -2.111294445647692e-18, -1.106111059479048e-20, -5.650272565261628e-23,
 -2.813782390258851e-25, -1.363830400525426e-27,  5.959070024109880e-04, -3.273751998686444e-06,  1.348526592894323e-08, -4.936587074934183e-11,  1.693427731492896e-13,
 -5.575029589296040e-16,  1.783092065542121e-18, -5.585167858249240e-21,  1.719957362052748e-23, -5.232257490376761e-26,  1.571878379291488e-28, -4.692219510824373e-31,
  5.362737995395070e-03, -2.942279024427721e-05,  1.208369715768285e-07, -4.400155132655326e-10,  1.497009938696059e-12, -4.870174893703151e-15,  1.532541668113550e-17,
 -4.698756764778432e-20,  1.407738713203483e-22, -4.137287877637832e-25,  1.190524755144750e-27, -3.372643406778571e-30,  1.489410354282270e-02, -8.150156592674724e-05,
  3.327088938452014e-07, -1.198570350882849e-09,  4.009222326777925e-12, -1.272311386708803e-14,  3.866598791626055e-17, -1.130478739228171e-19,  3.176449707291334e-22,
 -8.565878757444247e-25,  2.190402069126093e-27, -5.269771126738525e-30,  2.918526737651906e-02, -1.590678529644515e-04,  6.434260342090834e-07, -2.279874329582932e-09,
  7.425922112293156e-12, -2.263617306108767e-14,  6.483398235490409e-17, -1.737710233683397e-19,  4.281517841364606e-22, -9.347569266946636e-25,  1.597450825209389e-27,
 -1.061367755229253e-30,  4.822876126341032e-02, -2.614492022061425e-04,  1.044447384587513e-06, -3.617056420544011e-09,  1.134271769117827e-11, -3.255071936830797e-14,
  8.464351195837815e-17, -1.925586184878700e-19,  3.416397632173200e-22, -2.359449333477559e-25, -1.684812548852990e-27,  1.131869559014067e-29,  7.201393318382794e-02,
 -3.877318754813995e-04,  1.524336192145233e-06, -5.122654203075497e-09,  1.525034915332379e-11, -4.002297794604071e-14,  8.814982037086865e-17, -1.353078831372308e-19,
 -3.439995192772149e-23,  1.384517457078919e-24, -7.306465748031499e-27,  2.729342076079033e-29,  1.005263188098040e-01, -5.367458772160775e-04,  2.068728274699046e-06,
 -6.690262190667562e-09,  1.856165232296510e-11, -4.247976065070457e-14,  6.646558942352198e-17,  1.913580314100009e-20, -7.043664345763318e-22,  3.608312223965429e-24,
 -1.290462892523096e-26,  3.502863000412170e-29,  1.337468124506179e-01, -7.070459213498470e-04,  2.660306251439544e-06, -8.196840668211106e-09,  2.064678910592692e-11,
 -3.753241745212160e-14,  1.380692458108406e-17,  2.687063219455197e-19, -1.546403612148363e-21,  5.579147305308102e-24, -1.438330253147911e-26,  1.957259489102505e-29,
  1.716506057712477e-01, -8.968881621643146e-04,  3.278790907727846e-06, -9.505862571198036e-09,  2.087754822575406e-11, -2.334053612524112e-14, -7.042208025330039e-17,
  5.800133551706686e-19, -2.300440892332565e-21,  6.024403470636266e-24, -7.306238432017847e-27, -2.816237475564645e-29,  2.142058533539991e-01, -1.104202538417114e-03,
  3.900965328525533e-06, -1.047152103624018e-08,  1.868139690036451e-11,  9.899960905968317e-16, -1.797743386474314e-16,  8.848178839167215e-19, -2.596623763728378e-21,
  3.621123253130263e-24,  1.067038814393857e-26, -1.001068916453226e-28,  2.613720131916783e-01, -1.326560647463732e-03,  4.500753257206411e-06, -1.094426664679769e-08,
  1.360558415524373e-11,  3.500032499765919e-14, -2.994943871485414e-16,  1.083769522646850e-18, -2.034973047100961e-21, -2.404890839907963e-24,  3.691435033291096e-26,
 -1.629981547385713e-28,  3.130977970596689e-01, -1.561139204512458e-03,  5.049380768479573e-06, -1.077798632400202e-08,  5.390818986584668e-12,  7.650382995055747e-14,
 -4.063016866039613e-16,  1.060017566223880e-18, -3.188260438338344e-22, -1.155233365533434e-23,  6.169386043808968e-26, -1.614371900067653e-28,  3.693186499756928e-01,
 -1.804679388170378e-03,  5.515660231331513e-06, -9.839165981242175e-09, -5.947327495914814e-12,  1.213034131351989e-13, -4.697687463280345e-16,  7.045853732856712e-19,
  2.570459806729522e-21, -2.142123186220800e-23,  6.856617205228271e-26, -3.939778244825635e-29,  4.299536591916536e-01, -2.053442780023480e-03,  5.866448115643267e-06,
 -8.018379904872709e-09, -2.003338363113769e-11,  1.630858450864308e-13, -4.558777985618026e-16, -4.640725870458848e-20,  6.193210012959059e-21, -2.755930963599802e-23,
  3.913017545265299e-26,  2.182276849308602e-28,  4.949017710297229e-01, -2.303165249471468e-03,  6.067343770848338e-06, -5.244393447746610e-09, -3.605081950611960e-11,
  1.936061900748465e-13, -3.332622881970581e-16, -1.165999322446894e-18,  9.531595060542857e-21, -2.423197629388472e-23, -3.689205821400600e-26,  5.355870091700473e-28,
  5.640371682628611e-01, -2.549011123529626e-03,  6.083714814088592e-06, -1.501007198705885e-09, -5.267726591714132e-11,  2.033017011786945e-13, -8.234351345060045e-17,
 -2.490931941108402e-18,  1.102814279624149e-20, -6.508494565740620e-24, -1.477706027937672e-25,  7.184216434778834e-28,  6.372036320253459e-01, -2.785531464797297e-03,
  5.882155327144322e-06,  3.153558510569748e-09, -6.805541094911794e-11,  1.824883268665917e-13,  2.930868142751016e-16, -3.692900805350497e-18,  8.898880777038646e-21,
  2.630659709863939e-23, -2.479887079329879e-25,  4.981020680811599e-28,  7.142076817345212e-01, -3.006632461194781e-03,  5.432503175961217e-06,  8.565540260244379e-09,
 -7.982745678658779e-11,  1.232735772575979e-13,  7.534805899826076e-16, -4.291568659875647e-18,  1.813622358433824e-21,  6.669368204549484e-23, -2.598443311297064e-25,
 -3.079654568091219e-28,  7.948102572070308e-01, -3.205563068165844e-03,  4.710556966269768e-06,  1.446457769773220e-08, -8.527051241259661e-11,  2.223265171614267e-14,
  1.213840684198171e-15, -3.740534159022158e-18, -1.007383578970692e-20,  9.650784548542941e-23, -1.026001828355477e-25, -1.531744845624382e-27,  8.787166849520650e-01,
 -3.374935447685551e-03,  3.701630847214280e-06,  2.044611281720758e-08, -8.157814678750971e-11, -1.163099039064635e-13,  1.542649128646090e-15, -1.613593637698723e-18,
 -2.400593454815158e-20,  8.968644148563446e-23,  2.433458763762733e-25, -2.431970333183000e-27,  9.655646662007870e-01, -3.506797737414916e-03,  2.405047692630613e-06,
  2.596291759328768e-08, -6.633390488024683e-11, -2.769334755869508e-13,  1.577719048138776e-15,  2.107814548763664e-18, -3.405741281209359e-20,  2.392570930768562e-23,
  6.553142551490490e-25, -1.833396530219424e-27,  1.054910055883266e+00, -3.592786473760036e-03,  8.395668287852828e-07,  3.033445809026000e-08, -3.820539645050970e-11,
 -4.308533034820929e-13,  1.167886096752601e-15,  6.709409674044606e-18, -3.217546761948551e-20, -9.799881391705366e-23,  8.348811230808363e-25,  1.022016007596701e-27,
  1.146210299350175e+00, -3.624395450395024e-03, -9.504763315435482e-07,  3.278624371083671e-08,  2.164203775390705e-12, -5.366503301811125e-13,  2.449705310781772e-16,
  1.055306837342901e-17, -1.189515631165509e-20, -2.258498658600804e-22,  4.287007109541239e-25,  5.027169589989241e-27,  1.238805603457214e+00, -3.593407950582779e-03,
 -2.888939494600455e-06,  3.253403102599523e-08,  5.119848397029044e-11, -5.465838948054372e-13, -1.083956285898079e-15,  1.131339211606035e-17,  2.529809404157386e-20,
 -2.615057308810122e-22, -6.303422928416989e-25,  6.461223510519208e-27,  1.331898308086497e+00, -3.492547493621287e-03, -4.862820546373214e-06,  2.892716601565458e-08,
  1.016763891079458e-10, -4.209034823544115e-13, -2.461958568074697e-15,  6.954984935208614e-18,  6.393685586590133e-20, -1.112842795948817e-22, -1.724573259869480e-24,
  1.316541007217264e-27,  1.424531582784968e+00, -3.316402832791895e-03, -6.720587696934979e-06,  2.165669922711112e-08,  1.428179477216914e-10, -1.502711533048071e-13,
 -3.299527537559636e-15, -2.539773978561684e-18,  7.598857593390719e-20,  2.048540521737226e-22, -1.638111713571745e-24, -8.661634349085127e-27,  1.515569602220549e+00,
 -3.062665663748789e-03, -8.277233966152398e-06,  1.101028967394038e-08,  1.619105442795359e-10,  2.195288410760114e-13, -2.974477475022659e-15, -1.351702987095734e-17,
  3.774360836632432e-20,  4.676420016222114e-22,  2.971962091221190e-25, -1.246961397394916e-26,  1.603682830410990e+00, -2.733668378328395e-03, -9.330348568019433e-06,
 -1.889043449270343e-09,  1.481068360153288e-10,  5.759235796434108e-13, -1.241617791496196e-15, -1.900872567643614e-17, -4.059174152340269e-20,  3.661921286869408e-22,
  2.610416692335092e-24, -3.856861534608240e-28,  1.687343936132015e+00, -2.338104386219501e-03, -9.691357751954113e-06, -1.498688790680943e-08,  9.819244917311654e-11,
  7.640461596588605e-13,  1.323679096843955e-15, -1.304668523799505e-17, -1.004102384079058e-19, -1.343351592086111e-22,  2.270680917892577e-24,  1.574067160963194e-26,
  1.764841882022864e+00, -1.892640592056831e-03, -9.233320430101740e-06, -2.552512976343813e-08,  2.226203399595188e-11,  6.627877283551930e-13,  3.300817064209010e-15,
  2.402397006217647e-18, -7.629364927298192e-20, -5.380506663715449e-22, -1.070132004938410e-24,  9.825498869661582e-27,  1.834323131055868e+00, -1.422903791262770e-03,
 -7.949571168397573e-06, -3.075088064668586e-08, -5.509124531950484e-11,  2.886319091328739e-13,  3.268564046133082e-15,  1.524146988792152e-17,  1.815450432611270e-20,
 -3.087517533346085e-22, -2.803872714696640e-24, -1.124906155959107e-26,  1.893868354983488e+00, -9.631157301878295e-04, -6.005923651021875e-06, -2.906893112955663e-08,
 -1.029544690199032e-10, -1.573211711983914e-13,  1.210144819992315e-15,  1.352889503707533e-17,  7.597342341746949e-20,  2.376679245845858e-22, -2.629877989922066e-25,
 -9.407181181658304e-27,  1.941608792609448e+00, -5.536291263784357e-04, -3.757409099614515e-06, -2.120921171829268e-08, -1.017150147028190e-10, -3.969077758780031e-13,
 -1.025389411928056e-15,  9.011775264240484e-19,  3.453479748278782e-20,  2.838526708196320e-22,  1.597426434411091e-24,  6.401905315344377e-27,  1.975877497512914e+00,
 -2.359905199783150e-04, -1.699209703685515e-06, -1.060216516061428e-08, -5.996899984326692e-11, -3.113627905578998e-13, -1.476536782571404e-15, -6.237029648975157e-18,
 -2.184177138197020e-20, -4.731368196222694e-23,  1.213764968720826e-25,  2.440177006948207e-27,  1.995382186965224e+00, -4.598630432588814e-05, -3.422635204721897e-07,
 -2.253920000209536e-09, -1.383533726619776e-11, -8.096264622823644e-14, -4.568090349265206e-16, -2.500090825619847e-18, -1.331312976942868e-20, -6.905432297408131e-23,
 -3.487284447156142e-25, -1.711078374024470e-27,  5.830240707940299e-04, -3.168194204374221e-06,  1.290877182336586e-08, -4.674331377406227e-11,  1.586083031005570e-13,
 -5.165248701505645e-16,  1.634138028053934e-18, -5.063745060028513e-21,  1.542433292592924e-23, -4.642918040534595e-26,  1.379298503388758e-28, -4.076927160488819e-31,
  5.246947350037057e-03, -2.847681530460914e-05,  1.156973475903147e-07, -4.168230362225733e-10,  1.403180546577826e-12, -4.517657118491538e-15,  1.407065626430243e-17,
 -4.271220328046894e-20,  1.267022123583528e-22, -3.689488419877418e-25,  1.051504600650045e-27, -2.956205270115393e-30,  1.457333104452105e-02, -7.889635466117037e-05,
  3.187026981563185e-07, -1.136409127335001e-09,  3.763789311360827e-12, -1.183199353854780e-14,  3.563843451896471e-17, -1.033601636949021e-19,  2.883304439770768e-22,
 -7.734530894412958e-25,  1.970108538255597e-27, -4.751931106796415e-30,  2.855912031763278e-02, -1.540278926735951e-04,  6.167657603074492e-07, -2.164598446803221e-09,
  6.988372565107694e-12, -2.113702700679714e-14,  6.015523415827647e-17, -1.605963517046465e-19,  3.956384790554334e-22, -8.718972440592267e-25,  1.543163529408418e-27,
 -1.387207725679482e-30,  4.719940500771547e-02, -2.532642053874213e-04,  1.002110477543190e-06, -3.440672488481718e-09,  1.071158737337622e-11, -3.058274769784834e-14,
  7.940356103432657e-17, -1.817741227702126e-19,  3.320466817606470e-22, -2.940328620724678e-25, -1.235119645194479e-27,  9.184601567704590e-30,  7.048701151611819e-02,
 -3.757789853455391e-04,  1.464302328882675e-06, -4.884938635526433e-09,  1.447073821841887e-11, -3.795292600126900e-14,  8.435289259095283e-17, -1.356653253420696e-19,
  1.046100450305946e-23,  1.115137612184695e-24, -6.189871725887269e-27,  2.353821273917644e-29,  9.841193353666362e-02, -5.205121988396215e-04,  1.990199291533397e-06,
 -6.399985706223285e-09,  1.772803958481497e-11, -4.088058732496094e-14,  6.670467085526573e-17, -1.422198773480911e-21, -5.833954221052460e-22,  3.122036687985972e-24,
 -1.143176983364253e-26,  3.192391780712077e-29,  1.309605785586652e-01, -6.861513606837706e-04,  2.563901548852629e-06, -7.872476765259533e-09,  1.990003571873974e-11,
 -3.711617607624581e-14,  2.066732539595393e-17,  2.223256755736415e-19, -1.355697512089288e-21,  5.021597631118442e-24, -1.348230129112733e-26,  2.120801132835625e-29,
  1.681147993010439e-01, -8.711084736602079e-04,  3.166709114019032e-06, -9.175642741142856e-09,  2.039510952649211e-11, -2.484390163551718e-14, -5.518011498309221e-17,
  5.098106669394595e-19, -2.089092503108562e-21,  5.710521877791214e-24, -8.314024746515827e-27, -1.802178909335830e-29,  2.098506699837603e-01, -1.073492367435807e-03,
  3.777100406836352e-06, -1.017268645608728e-08,  1.866000974335698e-11, -3.036555428399376e-15, -1.561425887675745e-16,  8.038857871083879e-19, -2.459591144031559e-21,
  3.965415040452612e-24,  6.677625033682575e-27, -8.178660075712088e-29,  2.561369561812241e-01, -1.291076194772377e-03,  4.370750056544230e-06, -1.072135760482353e-08,
  1.423613165852229e-11,  2.816917765418575e-14, -2.700715715954004e-16,  1.017536443693792e-18, -2.096649757225424e-21, -1.066324608517935e-24,  3.014808463419768e-26,
 -1.445934377087435e-28,  3.069332134260672e-01, -1.521259922511776e-03,  4.920611255036542e-06, -1.068001235895507e-08,  6.825779772655407e-12,  6.710723490661965e-14,
 -3.768232348476556e-16,  1.043623381760512e-18, -6.920003418346887e-22, -9.226351813631914e-24,  5.462130326791714e-26, -1.592544347124806e-28,  3.621874331644444e-01,
 -1.761027823524648e-03,  5.397097390777172e-06, -9.915520387584193e-09, -3.632360651067495e-12,  1.102743049646922e-13, -4.490009704514601e-16,  7.750267698358468e-19,
  1.848150705703788e-21, -1.872349796076894e-23,  6.608583888241878e-26, -7.164477529381093e-29,  4.218331344736760e-01, -2.006901282386425e-03,  5.768410062723501e-06,
 -8.313414822928751e-09, -1.688107076342044e-11,  1.521506742369953e-13, -4.545495387967686e-16,  1.362208272208392e-19,  5.231359960688553e-21, -2.582416908911349e-23,
  4.709977048078300e-26,  1.458625479603780e-28,  4.857857754991199e-01, -2.254887744607695e-03,  6.001076514328371e-06, -5.790674634096396e-09, -3.226114846778369e-11,
  1.852497705113248e-13, -3.617730292601283e-16, -8.751861579814621e-19,  8.638125655531115e-21, -2.526218148357162e-23, -1.525625441417788e-26,  4.480429894095502e-28,
  5.539383293075486e-01, -2.500427473372641e-03,  6.060779478405990e-06, -2.311445556519297e-09, -4.863643873885406e-11,  2.005281257245659e-13, -1.471920016667343e-16,
 -2.142859778543327e-18,  1.069497397413290e-20, -1.179689999155482e-23, -1.169307551712834e-25,  6.799388668067586e-28,  6.261558345571845e-01, -2.738341082750278e-03,
  5.913586295471497e-06,  2.094217685941511e-09, -6.434350930552314e-11,  1.883145818042928e-13,  1.938012700204004e-16, -3.394853726833614e-18,  9.672933276984980e-21,
  1.685605109625859e-23, -2.238588287649751e-25,  5.915102244949759e-28,  7.022686925227085e-01, -2.962782809365781e-03,  5.527710655207957e-06,  7.308966552665683e-09,
 -7.719084013341972e-11,  1.399238486192125e-13,  6.344756851057232e-16, -4.197144834078348e-18,  4.024976193160324e-21,  5.610903961620765e-23, -2.674774605929806e-25,
 -4.577684768395258e-29,  7.820644404671457e-01, -3.167207462387594e-03,  4.875965631476824e-06,  1.310535334721793e-08, -8.454319589606276e-11,  5.007476042930210e-14,
  1.105108567283581e-15, -4.008226549469126e-18, -6.688793879125670e-21,  9.115214460533092e-23, -1.627767321069207e-25, -1.201454744671321e-27,  8.652776916167217e-01,
 -3.344363340552740e-03,  3.939082404894827e-06,  1.912424761412958e-08, -8.353820444027267e-11, -7.991225240266809e-14,  1.487211419477242e-15, -2.328453388632237e-18,
 -2.062757392054368e-20,  9.730679270418162e-23,  1.385285676556600e-25, -2.314699126558650e-27,  9.515779031857005e-01, -3.486329586133302e-03,  2.710058586593509e-06,
  2.485934096744016e-08, -7.148977373903397e-11, -2.384821716754107e-13,  1.621644733445797e-15,  1.036651369068879e-18, -3.274496918518744e-20,  4.838801882210126e-23,
  5.647024186073314e-25, -2.258733090963156e-27,  1.040554632954840e+00, -3.584624921703472e-03,  1.199633347179442e-06,  2.965581988286774e-08, -4.652756719874668e-11,
 -4.006890495424950e-13,  1.340850964373488e-15,  5.629863252602154e-18, -3.509411444372281e-20, -6.399376609314651e-23,  8.582793623018569e-25,  4.930335094320468e-29,
  1.131700001440638e+00, -3.630425745823630e-03, -5.571865254773987e-07,  3.273542595637915e-08, -8.486329253675749e-12, -5.272756032110874e-13,  5.339311555545205e-16,
  1.004606334318563e-17, -1.966573799041768e-20, -2.044967891126809e-22,  6.330754708516809e-25,  4.221298002723886e-27,  1.224388239763282e+00, -3.614944746512484e-03,
 -2.493981093829808e-06,  3.326444910364111e-08,  4.003275060799629e-11, -5.687149267086627e-13, -7.572944404102146e-16,  1.196800619483081e-17,  1.550042673320809e-20,
 -2.808342594425932e-22, -3.319403095852237e-25,  7.029502541937361e-27,  1.317852549622277e+00, -3.530034558331256e-03, -4.506221625629092e-06,  3.048350360911170e-08,
  9.268440073152126e-11, -4.774265915910672e-13, -2.239271616585656e-15,  8.923704179476713e-18,  5.870897175426835e-20, -1.784413051464058e-22, -1.616864802698839e-24,
  3.567111578913224e-27,  1.411160142465405e+00, -3.369089422788116e-03, -6.447109953376821e-06,  2.391342126977082e-08,  1.390163251254250e-10, -2.300320594010723e-13,
 -3.335584003053352e-15, -3.507942894923505e-21,  8.209625562280300e-20,  1.321814784945863e-22, -1.982468522798760e-24, -6.871366624972233e-27,  1.503187403185185e+00,
 -3.128310694049752e-03, -8.129435098230067e-06,  1.363197825148725e-08,  1.655573614574893e-10,  1.437517509506508e-13, -3.333504333360161e-15, -1.203868758671054e-17,
  5.465503193638590e-20,  4.679687331299587e-22, -2.941272923455137e-25, -1.428681916963311e-26,  1.592598785766104e+00, -2.808360691922454e-03, -9.338424468641459e-06,
  5.710111893694697e-10,  1.592835032777425e-10,  5.396039404801984e-13, -1.789922238555762e-15, -2.007668594775331e-17, -2.554418980805213e-20,  4.690758627777979e-22,
  2.502973465266440e-24, -4.610250136548978e-27,  1.677835357110016e+00, -2.416326738587462e-03, -9.861264425236719e-06, -1.329196604449082e-08,  1.137595724295888e-10,
  7.910638801874702e-13,  9.127939569220991e-16, -1.631829973891091e-17, -1.034437157128717e-19, -2.958737882160463e-23,  2.966161521847473e-24,  1.565979809946021e-26,
  1.757121656530080e+00, -1.967725270958591e-03, -9.537033399410183e-06, -2.505856924198783e-08,  3.631393056630098e-11,  7.425204948449068e-13,  3.330939102417743e-15,
 -3.562491881339765e-19, -9.631700913705643e-20, -5.707974842966927e-22, -5.310766856622396e-25,  1.478244599006260e-26,  1.828501965144339e+00, -1.487990920563253e-03,
 -8.323665793232402e-06, -3.158175111828318e-08, -4.849929131821137e-11,  3.722531587444845e-13,  3.701627556168572e-15,  1.562196595664749e-17,  4.902521720351466e-21,
 -4.306631383106265e-22, -3.286087464983287e-24, -1.047204011879550e-26,  1.889917548209485e+00, -1.012586659921777e-03, -6.364732809892865e-06, -3.073966215444637e-08,
 -1.057783211458299e-10, -1.234494548880989e-13,  1.624256761358162e-15,  1.609403844361317e-17,  8.423071612182533e-20,  2.177992464311407e-22, -7.583817909994837e-25,
 -1.324308231127683e-26,  1.939332505793401e+00, -5.847347197565955e-04, -4.021950542899758e-06, -2.290148335420637e-08, -1.098965327046169e-10, -4.210795514942871e-13,
 -9.830574819411858e-16,  2.182682507003339e-18,  4.597290669639982e-20,  3.535311506105710e-22,  1.889643470167556e-24,  6.830650813605280e-27,  1.974905518644998e+00,
 -2.501098991847543e-04, -1.832404611632431e-06, -1.161347342580414e-08, -6.656518478339261e-11, -3.489758299553841e-13, -1.661206801934857e-15, -6.962053713694364e-18,
 -2.342898927417028e-20, -3.999776352528068e-23,  2.528401390966996e-25,  3.598143790936072e-27,  1.995192588753631e+00, -4.883649091650769e-05, -3.706941849436017e-07,
 -2.488859796202281e-09, -1.557015347100860e-11, -9.281663091340970e-14, -5.331696641538082e-16, -2.968732879190160e-18, -1.606941243139499e-20, -8.463125034318967e-23,
 -4.333212533365508e-25, -2.151297296769838e-27,  5.705543417214851e-04, -3.067125338898716e-06,  1.236274432201451e-08, -4.428614121050827e-11,  1.486587960825598e-13,
 -4.789527086307509e-16,  1.499019386051535e-18, -4.595878906327158e-21,  1.384801671787761e-23, -4.125462159666536e-26,  1.211827057594542e-28, -3.548650202019144e-31,
  5.134860097744997e-03, -2.757086911413467e-05,  1.108272531773445e-07, -3.950770230123261e-10,  1.316109807203027e-12, -4.193866501917293e-15,  1.292953684651078e-17,
 -3.886237716276917e-20,  1.141467989116965e-22, -3.293800279750591e-25,  9.295670668749683e-28, -2.594858561000874e-30,  1.426275992391144e-02, -7.640027465085073e-05,
  3.054194511790429e-07, -1.078036110356147e-09,  3.535473525113145e-12, -1.101038271655491e-14,  3.286944215435099e-17, -9.456428966949774e-20,  2.618555150091935e-22,
 -6.986890623950476e-25,  1.771504836750189e-27, -4.283416853838055e-30,  2.795271513143067e-02, -1.491957981053775e-04,  5.914477622536711e-07, -2.056089471163125e-09,
  6.579712320803861e-12, -1.974585971233520e-14,  5.583114786337930e-17, -1.484263438210783e-19,  3.653458742469420e-22, -8.114639207176179e-25,  1.476872544945219e-27,
 -1.611403354842048e-30,  4.620212451549610e-02, -2.454096061163309e-04,  9.618308661798278e-07, -3.274078496912239e-09,  1.011858317296064e-11, -2.873694776013230e-14,
  7.446098763739655e-17, -1.713267698403002e-19,  3.206645682298141e-22, -3.359038438809880e-25, -8.714224155690621e-28,  7.399769435132976e-30,  6.900695863826008e-02,
 -3.642951647084050e-04,  1.407047559974499e-06, -4.659370586414676e-09,  1.373161705049732e-11, -3.597396686689176e-14,  8.056465587952969e-17, -1.347340746894325e-19,
  4.638964619402557e-23,  8.872516324556094e-25, -5.228521165344791e-27,  2.022939557570760e-29,  9.636124825741012e-02, -5.048930433680735e-04,  1.915074655306237e-06,
 -6.122791034140607e-09,  1.692642326069980e-11, -3.928216187787035e-14,  6.641977104561538e-17, -1.837811903363343e-20, -4.789026809190319e-22,  2.691956650213892e-24,
 -1.009440155109112e-26,  2.888089925046324e-29,  1.282564047999435e-01, -6.660126705993034e-04,  2.471317827296503e-06, -7.559985801292379e-09,  1.916315195008974e-11,
 -3.655019767923156e-14,  2.631153730479829e-17,  1.817335544771499e-19, -1.184399823132207e-21,  4.501235793197325e-24, -1.253067233801349e-26,  2.191424503071612e-29,
  1.646803431847538e-01, -8.462097223365037e-04,  3.058542714523266e-06, -8.853363247951189e-09,  1.988610627341950e-11, -2.600429454500868e-14, -4.181089023855866e-17,
  4.461833849204182e-19, -1.889667842296712e-21,  5.364607674215609e-24, -8.923217489728309e-27, -9.989080763249088e-30,  2.056163681540935e-01, -1.043758783509412e-03,
  3.656816887154995e-06, -9.874808264310319e-09,  1.856358222751953e-11, -6.522632236118704e-15, -1.347138945180204e-16,  7.275077558910736e-19, -2.312851058453817e-21,
  4.165403787516292e-24,  3.437744455928110e-27, -6.586697586048648e-29,  2.510417741001627e-01, -1.256620906680602e-03,  4.243477910939475e-06, -1.048941505301952e-08,
  1.473696650369800e-11,  2.202174324412567e-14, -2.425240323654683e-16,  9.500500670881640e-19, -2.114815515348190e-21,  1.768172712159875e-26,  2.418271969627214e-26,
 -1.266848358680546e-28,  3.009260945867822e-01, -1.482405717592935e-03,  4.793149107691025e-06, -1.056054421601503e-08,  8.079839651613557e-12,  5.841134028611076e-14,
 -3.479588019188918e-16,  1.016573052789505e-18, -9.864963724852967e-22, -7.180051797502925e-24,  4.773940723134613e-26, -1.529985963009850e-28,  3.552289206704654e-01,
 -1.718327813529032e-03,  5.277833344397220e-06, -9.956572275782647e-09, -1.532845062748756e-12,  9.976476884214671e-14, -4.265699815331748e-16,  8.238864231562823e-19,
  1.220858995948515e-21, -1.615043824710858e-23,  6.240180989776065e-26, -9.437035940434591e-29,  4.138971859033447e-01, -1.961157410021521e-03,  5.667127005821714e-06,
 -8.559758953581664e-09, -1.394674605245292e-11,  1.413053263758015e-13, -4.485288073299771e-16,  2.891246459087046e-19,  4.336975570855173e-21, -2.383064746081991e-23,
  5.213027291097055e-26,  8.461580349471055e-29,  4.768617896326971e-01, -2.207165581432298e-03,  5.928612063749471e-06, -6.277692578935250e-09, -2.864480565574346e-11,
  1.763035471170562e-13, -3.825457041423806e-16, -6.133978880983235e-19,  7.722223263082096e-21, -2.550340250133570e-23,  2.577806972169021e-27,  3.633179948801554e-28,
  5.440333979396251e-01, -2.452065112586175e-03,  6.028504706356056e-06, -3.057755724179035e-09, -4.466586422118864e-11,  1.963137665714297e-13, -2.024706732928057e-16,
 -1.808260715964797e-18,  1.019316682822003e-20, -1.589123068272139e-23, -8.819482398216246e-26,  6.238758274155216e-28,  6.152972224388056e-01, -2.690949083649939e-03,
  5.932664950272410e-06,  1.095072903857001e-09, -6.053822196667360e-11,  1.918606189542649e-13,  1.031580440876793e-16, -3.077286914371022e-18,  1.012501597170338e-20,
  8.440435928040078e-24, -1.965409810385216e-25,  6.439094629257810e-28,  6.905065307828422e-01, -2.918231071775807e-03,  5.608102854457433e-06,  6.097088610810827e-09,
 -7.424952525117059e-11,  1.537573712754793e-13,  5.190477567210310e-16, -4.038091543036736e-18,  5.852454196246895e-21,  4.543730721758298e-23, -2.645163226432197e-25,
  1.728796502088240e-28,  7.694745897218768e-01, -3.127593590839360e-03,  5.025151336932199e-06,  1.176207668102858e-08, -8.328567759420519e-11,  7.522939995067783e-14,
  9.903654305084459e-16, -4.171118459329865e-18, -3.536359296596983e-21,  8.368223189588853e-23, -2.082928512757660e-25, -8.686442077347378e-28,  8.519646847927241e-01,
 -3.311955548802037e-03,  4.160507184825543e-06,  1.777676623935745e-08, -8.478517130907190e-11, -4.507285780644960e-14,  1.413306682490477e-15, -2.931613553181862e-18,
 -1.704883063947891e-20,  1.008674929460608e-22,  4.105681443279116e-26, -2.102253571302959e-27,  9.376778071758307e-01, -3.463475663006480e-03,  3.001357133403144e-06,
  2.367946982564896e-08, -7.586847586710970e-11, -1.993310284977894e-13,  1.636293029214087e-15,  2.084340145606299e-20, -3.062119849469051e-20,  6.889935267155050e-23,
  4.589531999478008e-25, -2.521196461151125e-27,  1.026237562588948e+00, -3.573617628500873e-03,  1.550777889197732e-06,  2.884906831769723e-08, -5.420743943800812e-11,
 -3.667457846573322e-13,  1.482465821579295e-15,  4.476604974431659e-18, -3.678188802766015e-20, -2.989042727558072e-23,  8.403549539739893e-25, -8.468111093302861e-28,
  1.117171867056168e+00, -3.633315042329229e-03, -1.655215901302595e-07,  3.251607111185129e-08, -1.888130908371481e-11, -5.111635084647212e-13,  8.053408078361742e-16,
  9.304203307115496e-18, -2.652963427476486e-20, -1.757459734264838e-22,  7.970412815632015e-25,  3.203322990325116e-27,  1.209891099403347e+00, -3.633289883091136e-03,
 -2.091342797714504e-06,  3.381310603654455e-08,  2.850409459157287e-11, -5.828221118719446e-13, -4.167806930997722e-16,  1.230030636256910e-17,  5.226604125403067e-21,
 -2.878592197392623e-22, -1.849059286227031e-26,  7.141682509795751e-27,  1.303662663199898e+00, -3.564596657228576e-03, -4.131846198940213e-06,  3.188723444867566e-08,
  8.261975303927889e-11, -5.279648277741549e-13, -1.964159030892365e-15,  1.068747201568215e-17,  5.116454964329588e-20, -2.393450730300575e-22, -1.413121817623515e-24,
  5.651484066354397e-27,  1.397582501320728e+00, -3.419481023639841e-03, -6.146969228716046e-06,  2.609653309901784e-08,  1.336166866558501e-10, -3.097865582907545e-13,
 -3.298300082555602e-15,  2.683852549457500e-18,  8.536065747383965e-20,  4.751586479658279e-23, -2.232873899946760e-24, -4.410985756393582e-27,  1.490545189303616e+00,
 -3.192646618569858e-03, -7.949877361236903e-06,  1.629943857095396e-08,  1.676061387478977e-10,  5.991573497880662e-14, -3.643592906399314e-15, -1.002369911126743e-17,
  7.113532494657424e-20,  4.432810275181462e-22, -9.471738957187617e-25, -1.523271220667015e-26,  1.581216033829732e+00, -2.882996549942775e-03, -9.315933065870737e-06,
  3.203357228359144e-09,  1.696000581493880e-10,  4.898239553411065e-13, -2.360839538092374e-15, -2.060506772721397e-17, -6.916653058308716e-21,  5.637645132616522e-22,
  2.196737909621736e-24, -9.371601353430198e-27,  1.668011305013179e+00, -2.495822716404121e-03, -1.000932158169729e-05, -1.134421446561955e-08,  1.297609764347969e-10,
  8.071138015130406e-13,  4.095496308856521e-16, -1.962131241500578e-17, -1.022100303539490e-19,  1.025030883197205e-22,  3.627160916542915e-24,  1.411703702790384e-26,
  1.749096273928649e+00, -2.045213315280641e-03, -9.833745984450155e-06, -2.435440943099163e-08,  5.196107690354698e-11,  8.219759509125261e-13,  3.274703548169340e-15,
 -3.769906585083930e-18, -1.170770207181946e-19, -5.774541127571191e-22,  2.378998377481025e-25,  2.022004999668241e-26,  1.822414404758982e+00, -1.556108764846052e-03,
 -8.707041009151114e-06, -3.229320350412839e-08, -4.013037945696534e-11,  4.663436738174302e-13,  4.138722239480708e-15,  1.550454429857254e-17, -1.307376577122162e-20,
 -5.707929499345369e-22, -3.704416837825654e-24, -8.269529085701623e-27,  1.885762988782537e+00, -1.065008970986913e-03, -6.743837658328655e-06, -3.244959038929107e-08,
 -1.078193833517395e-10, -7.874811150980676e-14,  2.113755207872740e-15,  1.890780214539803e-17,  9.137322658893050e-20,  1.745032102444815e-22, -1.440165264852062e-24,
 -1.787496333479603e-26,  1.936927432138491e+00, -6.180401354112234e-04, -4.307600410913774e-06, -2.472845858688427e-08, -1.185481962149612e-10, -4.437610156702579e-13,
 -8.993257714945413e-16,  3.872628576147465e-18,  6.013344830453194e-20,  4.351695960768152e-22,  2.192376129400963e-24,  6.839307009654033e-27,  1.973874851671977e+00,
 -2.653452333848209e-04, -1.978394076268379e-06, -1.273658654803878e-08, -7.395962415946417e-11, -3.912700150447792e-13, -1.866841127476006e-15, -7.732533153392386e-18,
 -2.464481543056797e-20, -2.628328494874928e-23,  4.445259306109629e-25,  5.198945772971370e-27,  1.994991116358851e+00, -5.192589049099984e-05, -4.021188281367105e-07,
 -2.753557510939881e-09, -1.756149259705942e-11, -1.066712436206773e-13, -6.239762726819004e-16, -3.535241156505411e-18, -1.945233447735814e-20, -1.040120802589348e-22,
 -5.397852717677027e-25, -2.709934343331998e-27,  5.584803346692039e-04, -2.970309399430215e-06,  1.184527197756553e-08, -4.198232105441141e-11,  1.394293361970587e-13,
 -4.444717238365617e-16,  1.376321915295304e-18, -4.175599204516597e-21,  1.244646601764624e-23, -3.670573329660151e-26,  1.065921846601932e-28, -3.094740895530727e-31,
  5.026320328602984e-03, -2.670286307089810e-05,  1.062099611118474e-07, -3.746737873030731e-10,  1.235249513734749e-12, -3.896213326854545e-15,  1.189079534554985e-17,
 -3.539244377838085e-20,  1.029317660085691e-22, -2.943852901457968e-25,  8.224527111947608e-28, -2.281321159230631e-30,  1.396196494168495e-02, -7.400771958762978e-05,
  2.928152928816731e-07, -1.023188216946094e-09,  3.322944861773556e-12, -1.025236559786603e-14,  3.033526741546639e-17, -8.657404302596789e-20,  2.379339375108342e-22,
 -6.314707957569197e-25,  1.592481390961784e-27, -3.861466404195246e-30,  2.736524132803163e-02, -1.445611481678378e-04,  5.673935407414729e-07, -1.953901997359984e-09,
  6.197864685610605e-12, -1.845448891285364e-14,  5.183457401436943e-17, -1.371914192682286e-19,  3.371789870371806e-22, -7.538551559962420e-25,  1.402498531014017e-27,
 -1.758241531434711e-30,  4.523563038365586e-02, -2.378694057574615e-04,  9.234946519325250e-07, -3.116683590973640e-09,  9.561332230014918e-12, -2.700630172719571e-14,
  6.980563348501923e-17, -1.612651026368450e-19,  3.080188609613027e-22, -3.647076401585174e-25, -5.796307192044188e-28,  5.907454122657320e-30,  6.757194182992264e-02,
 -3.532587530211596e-04,  1.352429942164704e-06, -4.445316771280485e-09,  1.303116864074006e-11, -3.408548991737523e-14,  7.681740819837043e-17, -1.327772256495309e-19,
  7.477258824174533e-23,  6.950291659068783e-25, -4.403778052688915e-27,  1.732122397751963e-29,  9.437185836803684e-02, -4.898617952553045e-04,  1.843200453309248e-06,
 -5.858167001483711e-09,  1.615667050692047e-11, -3.769590731317697e-14,  6.570466272413768e-17, -3.222793330258261e-20, -3.889619084819215e-22,  2.312724402894283e-24,
 -8.888535748173976e-27,  2.595349790713830e-29,  1.256313279295568e-01, -6.465998502471691e-04,  2.382413652823553e-06, -7.259187436539910e-09,  1.843885342602720e-11,
 -3.586179478205832e-14,  3.089314765164652e-17,  1.463306247337177e-19, -1.031144555149252e-21,  4.019337622040879e-24, -1.156427400159201e-26,  2.191184397052525e-29,
  1.613437757069644e-01, -8.221609728954654e-04,  2.954194093621623e-06, -8.539396629111967e-09,  1.935696314688130e-11, -2.686449536594839e-14, -3.013578892008064e-17,
  3.887344005636065e-19, -1.703054567005142e-21,  5.000845985913838e-24, -9.219426786961083e-27, -3.745672457089615e-30,  2.014990987187700e-01, -1.014973200936410e-03,
  3.540096436473957e-06, -9.579003459554543e-09,  1.840240560413147e-11, -9.519546996825961e-15, -1.153571338334441e-16,  6.559169183457884e-19, -2.161081476728955e-21,
  4.249128165718296e-24,  8.478916101885153e-28, -5.221431245779186e-29,  2.460823946250639e-01, -1.223172535398011e-03,  4.119033213398273e-06, -1.025040745441334e-08,
  1.512131081864366e-11,  1.651274311545879e-14, -2.168687027758710e-16,  8.825622478669239e-19, -2.098064471831551e-21,  8.785784003169976e-25,  1.898559246772855e-26,
 -1.097361188726010e-28,  2.950723627168327e-01, -1.444565147252284e-03,  4.667235349694195e-06, -1.042236509475509e-08,  9.166842530352372e-12,  5.039810443075876e-14,
 -3.199730132303168e-16,  9.812249859700953e-19, -1.212205787332624e-21, -5.402611933958986e-24,  4.119872371013311e-26, -1.439344346779638e-28,  3.484392976571782e-01,
 -1.676583331109162e-03,  5.158271388485091e-06, -9.965683764917473e-09,  3.619626906774190e-13,  8.980780953811346e-14, -4.030382369699976e-16,  8.541245767422904e-19,
  6.833265123758615e-22, -1.374228239395333e-23,  5.789865361880764e-26, -1.091303298893248e-28,  4.061425746765279e-01, -1.916234844920710e-03,  5.563162385865472e-06,
 -8.760879895161911e-09, -1.122755296550783e-11,  1.306526852329477e-13, -4.386164169099185e-16,  4.145901897888194e-19,  3.517359760416872e-21, -2.168659223797509e-23,
  5.470493572276311e-26,  3.413887263882590e-29,  4.681274973449434e-01, -2.160045540839754e-03,  5.850644581157310e-06, -6.708305089509061e-09, -2.521179615084837e-11,
  1.669434252005964e-13, -3.963989974625618e-16, -3.809269661521010e-19,  6.809592109594105e-21, -2.510434698963123e-23,  1.679819294188910e-26,  2.841551539161242e-28,
  5.343213444146062e-01, -2.403995699726359e-03,  5.987652381095104e-06, -3.741279929338210e-09, -4.079209482432596e-11,  1.908832016633215e-13, -2.486259867678180e-16,
 -1.491861034276840e-18,  9.564024034455913e-21, -1.888923336348177e-23, -6.219724047277162e-26,  5.564180654871201e-28,  6.046284091076891e-01, -2.643451374585413e-03,
  5.940121141104046e-06,  1.572649355079873e-10, -5.668304072912680e-11,  1.933392835642982e-13,  2.156520310961330e-17, -2.749886100706120e-18,  1.029426201085616e-20,
  1.152860609742453e-24, -1.677125389728458e-25,  6.612089129502994e-28,  6.789237713217652e-01, -2.873093546638365e-03,  5.674243531604324e-06,  4.934336181219546e-09,
 -7.105884923578007e-11,  1.648803200006567e-13,  4.088345432343144e-16, -3.826665001044903e-18,  7.300077787014487e-21,  3.506294294484479e-23, -2.529451251543890e-25,
  3.454429503479998e-28,  7.570454798771254e-01, -3.086850331626411e-03,  5.158354557786722e-06,  1.044279407599590e-08, -8.155291647879997e-11,  9.758661137532224e-14,
  8.724308436267590e-16, -4.237758052308596e-18, -6.821126186075808e-22,  7.468117682415800e-23, -2.394464819687306e-25, -5.512301579913511e-28,  8.387847491137843e-01,
 -3.277841324790665e-03,  4.365665146140256e-06,  1.641480581803335e-08, -8.535438810435340e-11, -1.219680595903604e-14,  1.324130756227071e-15, -3.418935798374986e-18,
 -1.340962298870834e-20,  1.007385286373972e-22, -4.545183046723480e-26, -1.820772565125486e-27,  9.238736963621460e-01, -3.438349116740548e-03,  3.278102746663774e-06,
  2.243581321021402e-08, -7.946290091674235e-11, -1.601613055493343e-13,  1.623555221229036e-15, -9.160255025274990e-19, -2.783751011465761e-20,  8.499710617073535e-23,
  3.451789896669455e-25, -2.625165052968871e-27,  1.011970075515816e+00, -3.559841939223885e-03,  1.891527115203693e-06,  2.792504331049991e-08, -6.117710115489872e-11,
 -3.297962333772825e-13,  1.591216468131126e-15,  3.288767952787121e-18, -3.726404310930338e-20,  2.741643680210765e-24,  7.856455981886031e-25, -1.615529048517931e-27,
  1.102638421497141e+00, -3.633084349066168e-03,  2.225249290911543e-07,  3.213332094701825e-08, -2.889071529730737e-11, -4.888106674830608e-13,  1.053067456477884e-15,
  8.360434499174642e-18, -3.225165395047822e-20, -1.413765357787922e-22,  9.130691445134906e-25,  2.056712327421594e-27,  1.195327057956136e+00, -3.648390732107628e-03,
 -1.683235234764061e-06,  3.417549384646702e-08,  1.677557915461789e-11, -5.886826114610640e-13, -7.158596456726741e-17,  1.230221917048502e-17, -5.074481905392599e-21,
 -2.823832701723967e-22,  2.897736278643280e-25,  6.797085618287612e-27,  1.289340621109232e+00, -3.596099185622342e-03, -3.741624356873170e-06,  3.312221982908776e-08,
  7.161421850114894e-11, -5.713369818558835e-13, -1.643358229631153e-15,  1.217648499532810e-17,  4.159560494181879e-20, -2.903534367290676e-22, -1.124587391183712e-24,
  7.394046218172442e-27,  1.383808259708002e+00, -3.467368298811357e-03, -5.821201937544523e-06,  2.818056437049916e-08,  1.266370501028158e-10, -3.877343658850535e-13,
 -3.184778332417311e-15,  5.425195234469535e-18,  8.542441759151503e-20, -4.483623368883605e-23, -2.363057892395844e-24, -1.438888888650954e-27,  1.477648707990278e+00,
 -3.255417615789526e-03, -7.738170004406658e-06,  1.898588145154434e-08,  1.679086482921338e-10, -3.062678101858343e-14, -3.890048566790388e-15, -7.500666093251058e-18,
  8.624942443635098e-20,  3.919480974822330e-22, -1.618387336632566e-24, -1.508144884932529e-26,  1.569535302237702e+00, -2.957323398550436e-03, -9.260898398450168e-06,
  5.992055092579199e-09,  1.787831559329397e-10,  4.262348308569232e-13, -2.937713191947976e-15, -2.048560699443468e-17,  1.484790719339491e-20,  6.419328771479890e-22,
  1.675704278776387e-24, -1.430345233578669e-26,  1.657867054290835e+00, -2.576405287037982e-03, -1.013246120278125e-05, -9.138559972243976e-09,  1.459551513482602e-10,
  8.099850802292569e-13, -1.848760177945489e-16, -2.280382246567978e-17, -9.576604678899316e-20,  2.591758405156248e-22,  4.182434790388192e-24,  1.081327214597856e-26,
  1.740756251431645e+00, -2.125036884459246e-03, -1.012045441469682e-05, -2.338728958603276e-08,  6.917570556195962e-11,  8.988596990709061e-13,  3.113594130210103e-15,
 -7.845310350884310e-18, -1.374648201869787e-19, -5.485158498326972e-22,  1.248988644218944e-24,  2.569839424759336e-26,  1.816048188329529e+00, -1.627325337516556e-03,
 -9.098086298135491e-06, -3.285513119442247e-08, -2.977537700736516e-11,  5.708152338712355e-13,  4.563695579986860e-15,  1.472815740490488e-17, -3.636786083229044e-20,
 -7.251939650301078e-22, -3.985827514244718e-24, -4.169694598225309e-27,  1.881392543790408e+00, -1.120546680335849e-03, -7.143625942760217e-06, -3.418435786719340e-08,
 -1.088424307969529e-10, -2.132919198801883e-14,  2.684964664769508e-15,  2.191951236445628e-17,  9.641506754106629e-20,  9.964077235900129e-23, -2.341858104588203e-24,
 -2.321210434895537e-26,  1.934384424206260e+00, -6.537208317563189e-04, -4.616019111246445e-06, -2.669736323873344e-08, -1.276292841408683e-10, -4.638110933947312e-13,
 -7.614732063470161e-16,  6.065062887206810e-18,  7.744938171507107e-20,  5.287388332406958e-22,  2.480959550293511e-24,  6.128791009198113e-27,  1.972780819247663e+00,
 -2.818044700853632e-04, -2.138599567531064e-06, -1.398505332473645e-08, -8.225106750412626e-11, -4.387621887768615e-13, -2.094507950119420e-15, -8.532392440890772e-18,
 -2.521047879444425e-20, -3.330840593510576e-24,  7.190350169159672e-25,  7.390302737697669e-27,  1.994776762661015e+00, -5.527995620161035e-05, -4.369205553586975e-07,
 -3.052457423337615e-09, -1.985306847082606e-11, -1.229084696640493e-13, -7.322717013267698e-16, -4.222038727878059e-18, -2.361591981990956e-20, -1.281848059546461e-22,
 -6.740120235824727e-25, -3.419180072830295e-27,  5.467854834313191e-04, -2.877525114371798e-06,  1.135458169673353e-08, -3.982081138463485e-11,  1.308609762443858e-13,
 -4.127991849863880e-16,  1.264788219041751e-18, -3.797657815754819e-21,  1.119863357801699e-23, -3.270247026075487e-26,  9.385498327019974e-29, -2.704648649315385e-31,
  4.921180227142039e-03, -2.587083755907759e-05,  1.018299374386753e-07, -3.555180139814364e-10,  1.160100650864032e-12, -3.622363468602214e-15,  1.094437129307072e-17,
 -3.226203518303231e-20,  9.290262994999568e-23, -2.634118861495912e-25,  7.281970631853598e-28, -2.009444498906323e-30,  1.367054260149996e-02, -7.171342176861263e-05,
  2.808493963446451e-07, -9.716227294352811e-10,  3.124986023014522e-12, -9.552568263041285e-15,  2.801445685414348e-17, -7.931191567527632e-20,  2.163076754011746e-22,
 -5.710552593379166e-25,  1.431048546431622e-27, -3.483426717239252e-30,  2.679592887900296e-02, -1.401141289366617e-04,  5.445297472530183e-07, -1.857622572775923e-09,
  5.840910251165429e-12, -1.725536090708468e-14,  4.814026690478061e-17, -1.268252381469509e-19,  3.110310771170681e-22, -6.993323711184606e-25,  1.322990467941557e-27,
 -1.847787296666929e-30,  4.429869542527073e-02, -2.306284891377280e-04,  8.869948032878470e-07, -2.967933772385830e-09,  9.037599502487081e-12, -2.538405008130151e-14,
  6.542620019011734e-17, -1.516225603055211e-19,  2.945311707344475e-22, -3.830780905172490e-25, -3.479852979533598e-28,  4.658229829420738e-30,  6.618021278931162e-02,
 -3.426491953763956e-04,  1.300314957710768e-06, -4.242172840405480e-09,  1.236759537275976e-11, -3.228619295073962e-14,  7.313667151668585e-17, -1.300167193621348e-19,
  9.679948555365293e-23,  5.333450180263583e-25, -3.699019651084493e-27,  1.476806240096239e-29,  9.244146330289456e-02, -4.753930457732757e-04,  1.774428887000651e-06,
 -5.605606270815563e-09,  1.541844143553352e-11, -3.613115594810622e-14,  6.464006558795207e-17, -4.340902081999999e-20, -3.118359380960382e-22,  1.979192512980105e-24,
 -7.808304127602466e-27,  2.317404416319849e-29,  1.230825024577586e-01, -6.278840208949544e-04,  2.297049998870613e-06, -6.969862056557389e-09,  1.772934504952918e-11,
 -3.507479021322968e-14,  3.454957943130988e-17,  1.155617403146068e-19, -8.945433922214100e-22,  3.575925078905262e-24, -1.061026731499711e-26,  2.137659631060360e-29,
  1.581017573056744e-01, -7.989320871621267e-04,  2.853561754523513e-06, -8.234019243026268e-09,  1.881329116976955e-11, -2.746313398952685e-14, -1.998763842418701e-17,
  3.370457368024159e-19, -1.529688026932928e-21,  4.630267295284401e-24, -9.275041511378235e-27,  9.904098014116476e-31,  1.974951264999976e-01, -9.871072315729330e-04,
  3.426908272454969e-06, -9.286232417561133e-09,  1.818577678565052e-11, -1.207540312513304e-14, -9.793660663820924e-17,  5.892120760036453e-19, -2.008023503621014e-21,
  4.240642120436728e-24, -1.188063486552937e-27, -4.066028834344691e-29,  2.412548358213303e-01, -1.190708152948876e-03,  3.997489974770512e-06, -1.000609897328017e-08,
  1.540147977719882e-11,  1.159688279961051e-14, -1.930911461878065e-16,  8.160676544621973e-19, -2.053886559051901e-21,  1.546149312423198e-24,  1.450717622856486e-26,
 -9.405628404064738e-29,  2.893679894113782e-01, -1.407724970657754e-03,  4.543078921951945e-06, -1.026803990216146e-08,  1.010021313818216e-11,  4.304389172771840e-14,
 -2.930688240254087e-16,  9.396283458271936e-19, -1.378535061308572e-21, -3.878234637189406e-24,  3.509911871439843e-26, -1.331041758584093e-28,  3.418147395977079e-01,
 -1.635795281234285e-03,  5.038775524757209e-06, -9.946040504180270e-09,  2.063337746747762e-12,  8.042390723855392e-14, -3.788878603263816e-16,  8.685128763885503e-19,
  2.291073558287738e-22, -1.152522992953853e-23,  5.289382297437536e-26, -1.174102964763918e-28,  3.985659760139386e-01, -1.872152927066544e-03,  5.457038371410653e-06,
 -8.920184102146220e-09, -8.718764183948172e-12,  1.202772060784261e-13, -4.255464580751321e-16,  5.150787173650254e-19,  2.776276004667398e-21, -1.948095470920691e-23,
  5.528244518354362e-26, -6.311394454480213e-30,  4.595804063126707e-01, -2.113568990063873e-03,  5.767833087058513e-06, -7.085502978247419e-09, -2.196880361579297e-11,
  1.573256514326258e-13, -4.041490602131558e-16, -1.773272953542491e-19,  5.920744797633075e-21, -2.420407453480735e-23,  2.769234484639117e-26,  2.123512954026213e-28,
  5.248008644321529e-01, -2.356284869595904e-03,  5.938965876230470e-06, -4.363749931074053e-09, -3.703730856132585e-11,  1.844488518481822e-13, -2.862187937123337e-16,
 -1.197126011446429e-18,  8.844935874778958e-21, -2.090884476316616e-23, -3.931965300016509e-26,  4.828494127510420e-28,  5.941496361209794e-01, -2.595937980595593e-03,
  5.936694373521018e-06, -7.187268189272541e-10, -5.281712377291601e-11,  1.929701042276762e-13, -5.082244055492837e-17, -2.421043555157462e-18,  1.022201328737670e-20,
 -4.975264111362986e-24, -1.387772363942106e-25,  6.498420906301370e-28,  6.675225330892341e-01, -2.827481824352976e-03,  5.726744365815902e-06,  3.824272624212126e-09,
 -6.767166030016731e-11,  1.734340839807765e-13,  3.051343811348914e-16, -3.574786769243039e-18,  8.384261912389245e-21,  2.528974220415835e-23, -2.347902942160813e-25,
  4.724399960327587e-28,  7.447813747642040e-01, -3.045104267919233e-03,  5.275906988756818e-06,  9.154658563299737e-09, -7.940141453390116e-11,  1.171010154261547e-13,
  7.538587783079935e-16, -4.218459992199868e-18,  1.828962624082333e-21,  6.470558337678926e-23, -2.572321980742857e-25, -2.629135030280801e-28,  8.257444491956046e-01,
 -3.242151316821938e-03,  4.554446246994959e-06,  1.504887740803251e-08, -8.528852342550987e-11,  1.838841520836124e-14,  1.222934857520332e-15, -3.790520403109027e-18,
 -9.834224653644012e-21,  9.741135745546093e-23, -1.185429833540298e-25, -1.496625183437822e-27,  9.101744238434825e-01, -3.411069219383144e-03,  3.539605190027520e-06,
  2.114088760820666e-08, -8.227905922107059e-11, -1.216015082266427e-13,  1.585912996408355e-15, -1.755428718951047e-18, -2.455692264627968e-20,  9.649606172607024e-23,
  2.300605692139793e-25, -2.585467346701727e-27,  9.977630703602958e-01, -3.543386448058750e-03,  2.220543768721530e-06,  2.689554612904508e-08, -6.738437016980967e-11,
 -2.906364545075368e-13,  1.666664896238018e-15,  2.103812236146731e-18, -3.661857101710120e-20,  3.255485843182351e-23,  7.006028711924537e-25, -2.221022314111601e-27,
  1.088112074570233e+00, -3.629770342186745e-03,  6.050333171976010e-07,  3.159431043088012e-08, -3.839585273621076e-11, -4.608490112540053e-13,  1.271996929541757e-15,
  7.254153692085982e-18, -3.666517052354274e-20, -1.033933098083211e-22,  9.774355728748757e-25,  8.695158008376207e-28,  1.180709165863527e+00, -3.660212522147930e-03,
 -1.271907366960403e-06,  3.434973721461377e-08,  5.012513372330636e-12, -5.862947772302363e-13,  2.690938291714325e-16,  1.197999384172241e-17, -1.496130065052021e-20,
 -2.650069872639809e-22,  5.734818698223171e-25,  6.035077685150675e-27,  1.274898902003817e+00, -3.624423716626781e-03, -3.337666454928111e-06,  3.417460896844864e-08,
  5.982142443213097e-11, -6.065458231848890e-13, -1.285411298299502e-15,  1.333228051349561e-17,  3.041537323516078e-20, -3.284216389566952e-22, -7.696837571770699e-25,
  8.647166490492022e-27,  1.369847836822607e+00, -3.512551418003078e-03, -5.471147211030138e-06,  3.014062390236561e-08,  1.181319080285375e-10, -4.620394312532872e-13,
 -2.994975883643664e-15,  8.114640683675986e-18,  8.210225118672910e-20, -1.396776876864899e-22, -2.355249598938795e-24,  1.819711845488145e-27,  1.464504734107665e+00,
 -3.316366062203124e-03, -7.494257023237611e-06,  2.166238128295742e-08,  1.663471549306251e-10, -1.261837332732682e-13, -4.059402763928302e-15, -4.528697168908076e-18,
  9.903710886891165e-20,  3.142570394369860e-22, -2.256068249856719e-24, -1.369476164977417e-26,  1.557558359139693e+00, -3.031073716049888e-03, -9.171562178222628e-06,
  8.916758603160171e-09,  1.865567096993658e-10,  3.489220240483996e-13, -3.501099500196147e-15, -1.962909976120124e-17,  3.899949866179282e-20,  6.949722746626728e-22,
  9.425092673132475e-25, -1.892938929319634e-26,  1.647398676899553e+00, -2.657862699229365e-03, -1.022757902658870e-05, -6.674144216792770e-09,  1.620570148217194e-10,
  7.975494786105711e-13, -8.646483791095213e-16, -2.568591261884504e-17, -8.332218048271392e-20,  4.345904810887721e-22,  4.550174502966370e-24,  5.579457911596725e-27,
  1.732092427586682e+00, -2.207102901647848e-03, -1.039385484887486e-05, -2.213268447854815e-08,  8.787972403874503e-11,  9.704350164850660e-13,  2.829454637388793e-15,
 -1.254818459140486e-17, -1.560258021066673e-19, -4.744369987481076e-22,  2.490556350709267e-24,  3.057316071490441e-26,  1.809390810368430e+00, -1.701694266113339e-03,
 -9.494809916839572e-06, -3.323411820376565e-08, -1.723116796776968e-11,  6.851358524377912e-13,  4.955645460279404e-15,  1.311564384540652e-17, -6.537356311300679e-20,
 -8.865816329172502e-22, -4.036590693585795e-24,  2.284426274049043e-27,  1.876793419234493e+00, -1.179366150808478e-03, -7.564289261150223e-06, -3.592553325490676e-08,
 -1.085730963122240e-10,  5.082616977220572e-14,  3.342303258438962e-15,  2.504201047614690e-17,  9.805457525481689e-20, -1.614299821632882e-23, -3.489492359233883e-24,
 -2.899293846316681e-26,  1.931693605626974e+00, -6.919658843831720e-04, -4.948949042774297e-06, -2.881457151097966e-08, -1.370729794722960e-10, -4.797502469025884e-13,
 -5.539531005948285e-16,  8.867652308371931e-18,  9.833137473302901e-20,  6.329253015085381e-22,  2.714928894100566e-24,  4.275007990017282e-27,  1.971618288423647e+00,
 -2.996076065486933e-04, -2.314614966046144e-06, -1.537408646118266e-08, -9.154881548132427e-11, -4.919883202562109e-13, -2.344683768865304e-15, -9.334812016799409e-18,
 -2.472704856468103e-20,  3.274428860060153e-23,  1.106321326553394e-24,  1.035964329285947e-26,  1.994548412242606e+00, -5.892743186608984e-05, -4.755402653626782e-07,
 -3.390768542974257e-09, -2.249701878639435e-11, -1.419914482010195e-13, -8.618013275871247e-16, -5.057094902037328e-18, -2.875436420531480e-20, -1.584037187669370e-22,
 -8.434847948059257e-25, -4.319451046752756e-27,  5.354540793359622e-04, -2.788564882474911e-06,  1.088902741177994e-08, -3.779146978933038e-11,  1.229001333857361e-13,
 -3.836808489715621e-16,  1.163298836288748e-18, -3.457436261080321e-21,  1.008614608569557e-23, -2.917604592180626e-26,  8.271015777708342e-29, -2.369627851740405e-31,
  4.819299574870086e-03, -2.507295279163469e-05,  9.767274557762432e-08, -3.375220114633971e-10,  1.090208560007133e-12, -3.370211230826401e-15,  1.008126820075809e-17,
 -2.943542318622483e-20,  8.392345374328563e-23, -2.359805476292478e-25,  6.450835083499302e-28, -1.774094668165355e-30,  1.338810984258534e-02, -6.951242877892765e-05,
  2.694837338579340e-07, -9.231155743541723e-10,  2.940482211138809e-12, -8.906106541564768e-15,  2.588761556161336e-17, -7.270824383385612e-20,  1.967440365698788e-22,
 -5.167767541379807e-25,  1.285327039372662e-27, -3.146968859833451e-30,  2.624404586873317e-02, -1.358454939407598e-04,  5.227878153191967e-07, -1.766867279030557e-09,
  5.507074772591700e-12, -1.614150599440614e-14,  4.472478926346648e-17, -1.172650057259025e-19,  2.867879127728993e-22, -6.480556826288742e-25,  1.240487567624754e-27,
 -1.896952617750628e-30,  4.339015124286388e-02, -2.236725713419894e-04,  8.522307265604338e-07, -2.827309737043809e-09,  8.545282358745780e-12, -2.386371426148048e-14,
  6.131062831997321e-17, -1.424205208980929e-19,  2.805362497177045e-22, -3.932203046473144e-25, -1.667654986869774e-28,  3.608630565516179e-30,  6.483010332722168e-02,
 -3.324469844866257e-04,  1.250575169457280e-06, -4.049362966338140e-09,  1.173913131764400e-11, -3.057423167416846e-14,  6.954225957183066e-17, -1.266392557129071e-19,
  1.134869719027215e-22,  3.976989037159150e-25, -3.099618898485614e-27,  1.252485955641534e-29,  9.056786180487880e-02, -4.614625443360568e-04,  1.708618207429193e-06,
 -5.364608334871512e-09,  1.471122792474582e-11, -3.459544367452416e-14,  6.329520344573073e-17, -5.230608865439939e-20, -2.459683921512981e-22,  1.686471345725276e-24,
 -6.846811797702303e-27,  2.055744769095854e-29,  1.206071962027981e-01, -6.098374049165971e-04,  2.215090670761728e-06, -6.691758406100155e-09,  1.703638701537206e-11,
 -3.420989016469394e-14,  3.740333222331857e-17,  8.891599867666264e-20, -7.732250287014447e-22,  3.170076481773938e-24, -9.688958430761109e-27,  2.044513860139767e-29,
  1.549510673287091e-01, -7.764937507321719e-04,  2.756541397995203e-06, -7.937423638521369e-09,  1.825996793395567e-11, -2.783496983144356e-14, -1.121110869197692e-17,
  2.906913036946553e-19, -1.369655706194958e-21,  4.261243464178640e-24, -9.150883130998904e-27,  4.462805438012545e-30,  1.936008293105288e-01, -9.601327771750580e-04,
  3.317210949581416e-06, -8.997314282358185e-09,  1.792206334172830e-11, -1.423502679039348e-14, -8.231539745405434e-17,  5.273854428434203e-19, -1.856619676623404e-21,
  4.160308189109381e-24, -2.758453022126051e-27, -3.102165811624449e-29,  2.365552085210033e-01, -1.159204320669506e-03,  3.878902188382818e-06, -9.758063950408834e-09,
  1.558888824871340e-11,  7.229522408781324e-15, -1.711522724142610e-16,  7.513380263478640e-19, -1.988738079245993e-21,  2.047962837930437e-24,  1.068708656115753e-26,
 -7.983547638054416e-29,  2.838090023821337e-01, -1.371870394951591e-03,  4.420859258855406e-06, -1.009992277700000e-08,  1.089285925693818e-11,  3.632085069466973e-14,
 -2.673959365499984e-16,  8.935410740353241e-19, -1.494260548141177e-21, -2.587984086337219e-24,  2.949909647408355e-26, -1.213498785142866e-28,  3.353514239315864e-01,
 -1.595961806677066e-03,  4.919672621104396e-06, -9.900645066465021e-09,  3.582855299305243e-12,  7.162287834148409e-14, -3.545263818982567e-16,  8.696039328869745e-19,
 -1.489744633016012e-22, -9.514058356901319e-24,  4.764180155980628e-26, -1.205815315110686e-28,  3.911639958741424e-01, -1.828926981194847e-03,  5.349236760086219e-06,
 -9.040989812684636e-09, -6.414133825100580e-12,  1.102465637669311e-13, -4.099828766438827e-16,  5.931241542581656e-19,  2.114607118402788e-21, -1.728507740525600e-23,
  5.428268272144045e-26, -3.773538099594674e-29,  4.512178690585203e-01, -2.067772169320757e-03,  5.680800170268997e-06, -7.412360055453736e-09, -1.891958128033796e-11,
  1.475871043793054e-13, -4.065910989784739e-16, -1.574115231306538e-21,  5.071411531863001e-21, -2.292881241180146e-23,  3.560860430077292e-26,  1.489024729172676e-28,
  5.154704029069824e-01, -2.308992398847547e-03,  5.883165792915636e-06, -4.927219111295764e-09, -3.341957681017484e-11,  1.772086443874823e-13, -3.158908794129877e-16,
 -9.263948765958417e-19,  8.068825554734297e-21, -2.207890367779171e-23, -1.973266841361888e-26,  4.074729911461329e-28,  5.838607967895930e-01, -2.548492997980145e-03,
  5.923126292025792e-06, -1.533014240895918e-09, -4.897521980924514e-11,  1.909736553952614e-13, -1.140664409650080e-16, -2.097820794232458e-18,  9.949800396263103e-21,
 -9.962980055363086e-24, -1.108539337410756e-25,  6.162491990833644e-28,  6.563044987110922e-01, -2.781502444993891e-03,  5.766254821648617e-06,  2.769639931701262e-09,
 -6.413769396325989e-11,  1.795872757376383e-13,  2.089206901921916e-16, -3.293693697082945e-18,  9.130911634680119e-21,  1.634165662002601e-23, -2.120003705412324e-25,
  5.567622947040371e-28,  7.326860377107280e-01, -3.002479001401462e-03,  5.378220717305412e-06,  7.903915111181949e-09, -7.688799253273516e-11,  1.337849179712547e-13,
  6.368971941579790e-16, -4.124666592957061e-18,  3.971070854187218e-21,  5.426148756739043e-23, -2.631525013896005e-25, -1.310016986969253e-29,  8.128498260818390e-01,
 -3.205016561079279e-03,  4.726862279624110e-06,  1.368876120233381e-08, -8.463601781671803e-11,  4.643288087061638e-14,  1.112914502594715e-15, -4.050144625659014e-18,
 -6.427726031570056e-21,  9.145279250552557e-23, -1.768905680871749e-25, -1.154446930124918e-27,  8.965883555344165e-01, -3.381760166649588e-03,  3.785323444124711e-06,
  1.980701618233136e-08, -8.433489666395254e-11, -8.421495032148757e-14,  1.526293111972158e-15, -2.484112757628098e-18, -2.094449257934866e-20,  1.034627011722161e-22,
  1.194458875668918e-25, -2.424650110583803e-27,  9.836270708897289e-01, -3.524349867801082e-03,  2.536636691689944e-06,  2.577308536639464e-08, -7.279300728272209e-11,
 -2.500607574549955e-13,  1.709380117764121e-15,  9.559785454813145e-19, -3.496699443904474e-20,  5.848646240874286e-23,  5.928981245919590e-25, -2.643740618735524e-27,
  1.073605059248586e+00, -3.623424681801538e-03,  9.801804359353196e-07,  3.090796626216530e-08, -4.729180008354243e-11, -4.280194385841136e-13,  1.458181802088553e-15,
  6.028913731869793e-18, -3.967748292688622e-20, -6.387316193103071e-23,  9.902333437684037e-25, -2.741887090584600e-28,  1.166050576590520e+00, -3.668738518620091e-03,
 -8.596148279644428e-07,  3.433659412754729e-08, -6.621945414394350e-12, -5.758739918320252e-13,  5.964312624726384e-16,  1.135351714963022e-17, -2.402737287823011e-20,
 -2.370603942427057e-22,  8.157850358808091e-25,  4.929667619581597e-27,  1.260350423487281e+00, -3.649469327810250e-03, -2.922233689128560e-06,  3.503315701148784e-08,
  4.741276819938232e-11, -6.328171844428204e-13, -9.002967516907733e-16,  1.411121906128513e-17,  1.813198003593137e-20, -3.513596334042886e-22, -3.723981824672432e-25,
  9.307892261580257e-27,  1.355712427887891e+00, -3.554842441133395e-03, -5.098436434040536e-06,  3.195298520004572e-08,  1.081922414551285e-10, -5.309007428021322e-13,
 -2.731868510808958e-15,  1.064349076362358e-17,  7.540623498996169e-20, -2.313139705989216e-22, -2.202682439022112e-24,  5.094096681197549e-27,  1.451121071668342e+00,
 -3.375235304039268e-03, -7.218439651161087e-06,  2.429841636061408e-08,  1.628408453216418e-10, -2.247631213869320e-13, -4.140267709582722e-15, -1.197053628165798e-18,
  1.085868826468766e-19,  2.126513220836542e-22, -2.804971634845591e-24, -1.105421260464538e-26,  1.545288069252830e+00, -3.103966965853926e-03, -9.046436634795844e-06,
  1.195274401485467e-08,  1.926511952376596e-10,  2.584646167149619e-13, -4.029439247790885e-15, -1.797523751296269e-17,  6.448539446566091e-20,  7.148230512601602e-22,
  2.248018881844945e-26, -2.270295732141897e-26,  1.636603141420699e+00, -2.739958407141896e-03, -1.029158923414800e-05, -3.955001317503903e-09,  1.777407419593006e-10,
  7.678818797553086e-13, -1.618577605374138e-15, -2.806640591111852e-17, -6.435930823230790e-20,  6.195401005319540e-22,  4.645343677895173e-24, -1.550298581398847e-27,
  1.723096067938477e+00, -2.291290707611497e-03, -1.065035852164719e-05, -2.056777948641140e-08,  1.079360541362491e-10,  1.033546520683792e-12,  2.405790929005931e-15,
 -1.779235656441704e-17, -1.709774680857289e-19, -3.467636156008748e-22,  3.918221292915899e-24,  3.400473594112527e-26,  1.802429585362188e+00, -1.779251586007521e-03,
 -9.894800075020755e-06, -3.339361277375890e-08, -2.310700609980465e-12,  8.082112111462937e-13,  5.288577625334538e-15,  1.048219817184069e-17, -1.001502958949406e-19,
 -1.043543309826625e-21, -3.744794176461347e-24,  1.144433032423283e-26,  1.871952154109483e+00, -1.241634315594901e-03, -8.005770347580197e-06, -3.764996748314658e-08,
 -1.066957984019956e-10,  1.398085650466468e-13,  4.087113616255949e-15,  2.814092164394872e-17,  9.463794294191882e-20, -1.829466178230979e-22, -4.892391095160428e-24,
 -3.470527058798102e-26,  1.928844315394510e+00, -7.329785934757137e-04, -5.308201635327991e-06, -3.108513048273889e-08, -1.467788916054061e-10, -4.896882127381316e-13,
 -2.580296769631269e-16,  1.240009701634591e-17,  1.231087829136245e-19,  7.443801456384456e-22,  2.831855751307415e-24,  6.990039869834124e-28,  1.970381619561166e+00,
 -3.188881518390937e-04, -2.508227552754898e-06, -1.692073356668311e-08, -1.019729336350872e-10, -5.514852227554786e-13, -2.616892644135502e-15, -1.009772080360013e-17,
 -2.263207395339196e-20,  8.720267912701555e-23,  1.645545171310827e-24,  1.433844587726412e-26,  1.994304827239583e+00, -6.290085344320392e-05, -5.184866924868225e-07,
 -3.774613348228140e-09, -2.555571015998112e-11, -1.644833512259217e-13, -1.017187890351807e-15, -6.075377136121536e-18, -3.511285938720969e-20, -1.962607726802855e-22,
 -1.057674570948894e-24, -5.460928317736014e-27,  5.244712185299204e-04, -2.703233798394491e-06,  1.044707978314503e-08, -3.588497192014922e-11,  1.154980511146403e-13,
 -3.568878521585339e-16,  1.070855750532917e-18, -3.150866328618608e-21,  9.092927497570308e-24, -2.606738996909193e-26,  7.293168123346994e-29, -2.082523989527906e-31,
  4.720545287952019e-03, -2.430748038551759e-05,  9.372495895294171e-08, -3.206050371907951e-10,  1.025158615906895e-12, -3.137855304309722e-15,  9.293431571651986e-18,
 -2.688096634991961e-20,  7.587436997638842e-23, -2.116764330020546e-25,  5.716004983508885e-28, -1.571075486578761e-30,  1.311430282199718e-02, -6.740008196581907e-05,
  2.586828627159753e-07, -8.774597581717270e-10,  2.768411810822402e-12, -8.308539153484500e-15,  2.393719846943012e-17, -6.670044073889395e-20,  1.790329644037011e-22,
 -4.680428476829773e-25,  1.153528766401355e-27, -2.850319597892191e-30,  2.570889629894180e-02, -1.317465272849098e-04,  5.021036196665726e-07, -1.681279500481318e-09,
  5.194717914343275e-12, -1.510649628750641e-14,  4.156641013892739e-17, -1.084516598130194e-19,  2.643308655247352e-22, -6.001138180627869e-25,  1.156435653645531e-27,
 -1.920510155500224e-30,  4.250888500779261e-02, -2.169881478401624e-04,  8.191078620859543e-07, -2.694324802287082e-09,  8.082404801583846e-12, -2.243911117646893e-14,
  5.744639840513216e-17, -1.336708491492529e-19,  2.662960173950123e-22, -3.969873754562056e-25, -2.805814190705141e-29,  2.719717646195816e-30,  6.352002128769162e-02,
 -3.226336053992584e-04,  1.203089881945302e-06, -3.866339257278700e-09,  1.114405178257632e-11, -2.894734546591872e-14,  6.604919038341440e-17, -1.228014854174138e-19,
  1.256997260439845e-22,  2.841361328920186e-25, -2.592919967889502e-27,  1.054698423885763e-29,  8.874894738907464e-02, -4.480471504740737e-04,  1.645632618260049e-06,
 -5.134681935373668e-09,  1.403438690452782e-11, -3.309476880732124e-14,  6.172919948828902e-17, -5.925680197861878e-20, -1.899738383333245e-22,  1.429955727553588e-24,
 -5.996836736795543e-27,  1.810402245398505e-29,  1.182027859340451e-01, -5.924333017348772e-04,  2.136402644700854e-06, -6.424600224833414e-09,  1.636135366114271e-11,
 -3.328502757908802e-14,  3.956320864011997e-17,  6.592570253114649e-20, -6.658646070531983e-22,  2.800167653811697e-24, -8.815418423316599e-27,  1.921941780216718e-29,
  1.518886006998949e-01, -7.548174915623324e-04,  2.663026860169670e-06, -7.649729685969380e-09,  1.770121215532656e-11, -2.801117760634660e-14, -3.662797296831237e-18,
  2.492465847401910e-19, -1.222785014123296e-21,  3.899916430775770e-24, -8.897911201209314e-27,  6.876045522037743e-30,  1.898126966338331e-01, -9.340221081729058e-04,
  3.210953966887444e-06, -8.712941310765798e-09,  1.761876910848207e-11, -1.603997079345029e-14, -6.835802163615302e-17,  4.703461343804676e-19, -1.709141128730811e-21,
  4.025117681455640e-24, -3.943512126669502e-27, -2.311594937825908e-29,  2.319797180593164e-01, -1.128637240480598e-03,  3.763306022021691e-06, -9.507701173148505e-09,
  1.569406931990548e-11,  3.367197078128814e-15, -1.509941291962284e-16,  6.889538998799297e-19, -1.908128109874589e-21,  2.409032364875691e-24,  7.458589096342134e-27,
 -6.717721841920747e-29,  2.783914912091803e-01, -1.336985301332178e-03,  4.300728765307623e-06, -9.920165968803261e-09,  1.155709953599563e-11,  3.019809657279434e-14,
 -2.430586571926952e-16,  8.444515583714821e-19, -1.567443232661682e-21, -1.511272395023076e-24,  2.442401258415419e-26, -1.093411301070532e-28,  3.290455405334060e-01,
 -1.557078576230504e-03,  4.801254630584036e-06, -9.832313758531663e-09,  4.932194716259097e-12,  6.340558982246654e-14, -3.302931403639267e-16,  8.597140624451333e-19,
 -4.584578818804927e-22, -7.714533274374327e-24,  4.233969923566492e-26, -1.198785338294809e-28,  3.839331863758648e-01, -1.786568635139597e-03,  5.240200172194943e-06,
 -9.126505344461892e-09, -4.306216102408223e-12,  1.006133507853471e-13, -3.925186365259432e-16,  6.512507350856216e-19,  1.530958818478840e-21, -1.515443852728208e-23,
  5.207790627213150e-26, -6.128181110215655e-29,  4.430371028709051e-01, -2.022686486478384e-03,  5.590131260580887e-06, -7.691989308760144e-09, -1.606533305183966e-11,
  1.378459747479267e-13, -4.044852434515336e-16,  1.477907569202659e-19,  4.273037839681663e-21, -2.139018028287873e-23,  4.092426061332863e-26,  9.415244349431477e-29,
  5.063281770142130e-01, -2.262172402507230e-03,  5.820946484734168e-06, -5.433999182669393e-09, -2.995317114053090e-11,  1.693444324412044e-13, -3.383354825822939e-16,
 -6.810284916042289e-19,  7.263898224060325e-21, -2.253157744147414e-23, -3.439262952847435e-27,  3.336102290360936e-28,  5.737614598841543e-01, -2.501194604370242e-03,
  5.900154007809123e-06, -2.286230044113674e-09, -4.518769607643925e-11,  1.875668107970012e-13, -1.684076303846656e-16, -1.785969411676921e-18,  9.517730370820040e-21,
 -1.386850545103593e-23, -8.478541918096706e-26,  5.664840207945351e-28,  6.452709352339590e-01, -2.735256634567341e-03,  5.793452608060006e-06,  1.772412469440326e-09,
 -6.050310484419036e-11,  1.835281948772900e-13,  1.208649702418857e-16, -2.993679436847772e-18,  9.572626934505039e-21,  8.367773910148421e-24, -1.863581023290774e-25,
  6.029369457449628e-28,  7.207627446838240e-01, -2.959094552716604e-03,  5.465777333036145e-06,  6.695904345393353e-09, -7.406871198423809e-11,  1.477006544143356e-13,
  5.234647612138659e-16, -3.968366485961019e-18,  5.735463343058559e-21,  4.378776114994739e-23, -2.590337982481674e-25,  1.928234453623983e-28,  8.001063975843097e-01,
 -3.166567543487820e-03,  4.883037596718969e-06,  1.234342648163882e-08, -8.344955384433894e-11,  7.176172859520256e-14,  9.971154924828381e-16, -4.204613966616703e-18,
 -3.274111152624555e-21,  8.346185807503513e-23, -2.201869614340467e-25, -8.157051147532831e-28,  8.831233528389260e-01, -3.350549896610489e-03,  4.014862285627790e-06,
  1.844614876291465e-08, -8.565889599390656e-11, -4.849084334833547e-14,  1.447920147489070e-15, -3.094024537638968e-18, -1.715892671065242e-20,  1.061759679597596e-22,
  1.807544957870768e-26, -2.170016300150113e-27,  9.695721879247297e-01, -3.502839831442404e-03,  2.838767787157570e-06,  2.457062341293138e-08, -7.738244767415271e-11,
 -2.088387630833486e-13,  1.720830121539985e-15, -1.249326511039207e-19, -3.246340791830109e-20,  7.979300952538193e-23,  4.707098260103877e-25, -2.879983233951809e-27,
  1.059129373411885e+00, -3.614113157264544e-03,  1.346259835360062e-06,  3.008477060919189e-08, -5.548930116278415e-11, -3.911426863981719e-13,  1.608924465180698e-15,
  4.730045414402083e-18, -4.126972407368474e-20, -2.481811735782093e-23,  9.550290032861951e-25, -1.301651778875908e-27,  1.151364474570079e+00, -3.673969951640419e-03,
 -4.485886713535855e-07,  3.413938733225200e-08, -1.797101360452397e-11, -5.578393930748396e-13,  9.023297559953974e-16,  1.045479391336781e-17, -3.192537011524777e-20,
 -2.004740778242876e-22,  1.003690150135758e-24,  3.580378163747476e-27,  1.245708469886494e+00, -3.671153678351990e-03, -2.497705271866531e-06,  3.568947193407189e-08,
  3.457264647868972e-11, -6.496291421326808e-13, -4.989768850760763e-16,  1.448698950816457e-17,  5.314173386686128e-21, -3.580115842730932e-22,  3.995456418819549e-26,
  9.329242870999588e-27,  1.341413952020666e+00, -3.594067590617343e-03, -4.704975801922356e-06,  3.359566071518567e-08,  9.694409195772710e-11, -5.926249957270019e-13,
 -2.401439071948718e-15,  1.290674231315147e-17,  6.555538113735171e-20, -3.140252361862645e-22, -1.910976120611421e-24,  8.097256928064367e-27,  1.437506544133650e+00,
 -3.431772581297207e-03, -6.911391779783924e-06,  2.686250462833200e-08,  1.573512601224020e-10, -3.241328292821451e-13, -4.124147019424854e-15,  2.377668512907001e-18,
  1.141148231618090e-19,  9.176028433855364e-23, -3.212066028592559e-24, -7.280711379412209e-27,  1.532728441263809e+00, -3.175711968197153e-03, -8.884356082388117e-06,
  1.507109646363890e-08,  1.968139601823394e-10,  1.559753088871764e-13, -4.499998152559010e-15, -1.550179825448642e-17,  8.998682764741865e-20,  6.949270297085803e-22,
 -1.034576647829738e-24, -2.506976381302369e-26,  1.625478411556655e+00, -2.822431463471220e-03, -1.032148691310234e-05, -9.906700732669175e-10,  1.926451556766465e-10,
  7.193948661390121e-13, -2.429662796486133e-15, -2.973346577641639e-17, -3.874994798634108e-20,  8.015209901426818e-22,  4.390087960591913e-24, -1.027467119965790e-26,
  1.713758979763710e+00, -2.377449880107319e-03, -1.088611820141359e-05, -1.867247866842020e-08,  1.291407813075217e-10,  1.084678636492544e-12,  1.829363137266769e-15,
 -2.343016194237466e-17, -1.802742787394860e-19, -1.596035556382230e-22,  5.447225276503297e-24,  3.501023272012795e-26,  1.795151725091744e+00, -1.860012234778130e-03,
 -1.029518924122482e-05, -3.329428106384304e-08,  1.514453328201986e-11,  9.382612312089128e-13,  5.531364730111112e-15,  6.648577994915822e-18, -1.402628357148801e-19,
 -1.179938829500425e-21, -2.987674204840924e-24,  2.342753040651779e-26,  1.866854622478272e+00, -1.307516449582109e-03, -8.467702469778961e-06, -3.932912732446558e-08,
 -1.028531586141266e-10,  2.476893407588151e-13,  4.916180080462101e-15,  3.102311004842578e-17,  8.414737603079671e-20, -4.106972362765015e-22, -6.530183733831390e-24,
 -3.949656619437099e-26,  1.925825049978097e+00, -7.769769625724043e-04, -5.695637916314055e-06, -3.351215295049292e-08, -1.566040509853047e-10, -4.912437884987102e-13,
  1.485101344949965e-16,  1.679017280967140e-17,  1.519388509952784e-19,  8.566966109347475e-22,  2.739970050853474e-24, -5.356863912648216e-27,  1.969064609045915e+00,
 -3.397947650212306e-04, -2.721441057301340e-06, -1.864404812928780e-08, -1.136540028375566e-10, -6.177619309891140e-13, -2.909197923341756e-15, -1.075769617898275e-17,
 -1.814295373795978e-20,  1.670881214474479e-22,  2.387024775985091e-24,  1.960166752055264e-26,  1.994044631013881e+00, -6.723713850601057e-05, -5.663484201744686e-07,
 -4.211208668453763e-09, -2.910396622794819e-11, -1.910709878246358e-13, -1.204152226093423e-15, -7.320693612592803e-18, -4.300128753381026e-20, -2.437741048593782e-22,
 -1.328500392599985e-24, -6.904884674925910e-27,  5.138227530023045e-04, -2.621348756855398e-06,  1.002731682976235e-08, -3.409273817837014e-11,  1.086103196077306e-13,
 -3.322139726176106e-16,  9.865679607277717e-19, -2.874361901352850e-21,  8.204872750743002e-24, -2.332588715931795e-26,  6.432176636732109e-29, -1.837640565789893e-31,
  4.624790987240670e-03, -2.357279560459256e-05,  8.997408131719446e-08, -3.046926886095729e-10,  9.645723559910046e-13, -2.923577476288475e-15,  8.573641332396699e-18,
 -2.457063136858316e-20,  6.864939927374029e-23, -1.901417380613093e-25,  5.064010859103010e-28, -1.397101672623136e-30,  1.284877577966723e-02, -6.537199655376045e-05,
  2.484137289192357e-07, -8.344639448936573e-10,  2.607837959626978e-12, -7.755825611686934e-15,  2.214732194179174e-17, -6.123231386265156e-20,  1.629844592222454e-22,
 -4.243312958880434e-25,  1.033926269054578e-27, -2.592550888065436e-30,  2.518981803541048e-02, -1.278090093951083e-04,  4.824171610893405e-07, -1.600527866175045e-09,
  4.902322814916832e-12, -1.414440602855730e-14,  3.864499876763048e-17, -1.003299755188268e-19,  2.435390008296005e-22, -5.555502715686453e-25,  1.071658523808612e-27,
 -1.932143296850135e-30,  4.165383643282127e-02, -2.105624477468896e-04,  7.875373047239606e-07, -2.568522928537934e-09,  7.647111468678356e-12, -2.110436130125913e-14,
  5.382076649099375e-17, -1.253780379519100e-19,  2.520109756723512e-22, -3.959491500683710e-25,  7.440717058423529e-29,  1.955469791171511e-30,  6.224844668442540e-02,
 -3.131914828921273e-04,  1.157744810398481e-06, -3.692581036666196e-09,  1.058068055182931e-11, -2.740296290788963e-14,  6.266846239863708e-17, -1.186345735115768e-19,
  1.341686965931362e-22,  1.891689329465914e-25, -2.168235898556705e-27,  8.789367834856123e-30,  8.698270399678137e-02, -4.351247866915809e-04,  1.585342152805284e-06,
 -4.915346988924743e-09,  1.338716878754148e-11, -3.163381930178011e-14,  5.999231842857251e-17, -6.455708916690908e-20, -1.426274632897472e-22,  1.205325712579513e-24,
 -5.251435336319109e-27,  1.580090986270805e-29,  1.158667531162861e-01, -5.756460613549849e-04,  2.060856332564248e-06, -6.168091994780213e-09,  1.570528574198000e-11,
 -3.231567654993396e-14,  4.112549973470091e-17,  4.616450635844051e-20, -5.712055969586738e-22,  2.464051798074128e-24, -8.000937953751821e-27,  1.776967069992616e-29,
  1.489113645250581e-01, -7.338756915727534e-04,  2.572910923751554e-06, -7.370994561273488e-09,  1.714065251329760e-11, -2.801963219343817e-14,  2.788919580371127e-18,
  2.122957475948736e-19, -1.088716878380478e-21,  3.550558075560258e-24, -8.558959454105061e-27,  8.394772031251331e-30,  1.861273280138323e-01, -9.087479302536254e-04,
  3.108079209838360e-06, -8.433692171008298e-09,  1.728259913607708e-11, -1.752857450983518e-14, -5.593246914187593e-17,  4.179397729842070e-19, -1.567303167597629e-21,
  3.849009886315086e-24, -4.815707961389096e-27, -1.677457535208091e-29,  2.275246654401553e-01, -1.098982889302901e-03,  3.650721840774009e-06, -9.256247773090695e-09,
  1.572670190590435e-11, -3.199125015424597e-17, -1.325448456698240e-16,  6.293334057218128e-19, -1.816714216764378e-21,  2.651629754566640e-24,  4.751760208682210e-27,
 -5.612756480638864e-29,  2.731116122273803e-01, -1.303052451763736e-03,  4.182815181020535e-06, -9.730729692636853e-09,  1.210461312396698e-11,  2.464271289017576e-14,
 -2.201231163089093e-16,  7.936022345139230e-19, -1.605391375724497e-21, -6.270427365435649e-25,  1.987298811378565e-26, -9.760619074468787e-29,  3.228933010642798e-01,
 -1.519139055070525e-03,  4.683780830989614e-06, -9.743676299476197e-09,  6.122976375640467e-12,  5.576551541026714e-14, -3.064660159491539e-16,  8.409164322522304e-19,
 -7.069601889782218e-22, -6.125580429901796e-24,  3.713342994144132e-26, -1.163944461480590e-28,  3.768700599675466e-01, -1.745086127671313e-03,  5.130333475294656e-06,
 -9.179812217087488e-09, -2.386649999472045e-12,  9.141676984266846e-14, -3.736769280401452e-16,  6.919088953400239e-19,  1.022195215626651e-21, -1.313066170097800e-23,
  4.898809554508505e-26, -7.816728120196660e-29,  4.350352085368220e-01, -1.978338815543982e-03,  5.496374391194320e-06, -7.927505054432452e-09, -1.340507794895721e-11,
  1.282027378613322e-13, -3.985462498100718e-16,  2.725304002086785e-19,  3.533324753722762e-21, -1.968456443364346e-23,  4.401995427824770e-26,  4.793128249111542e-29,
  4.973721983977027e-01, -2.215873555345818e-03,  5.752973311710693e-06, -5.886602021629952e-09, -2.664889501411754e-11,  1.610210717899927e-13, -3.542720240386049e-16,
 -4.615610358337278e-19,  6.453631540456551e-21, -2.239650820200662e-23,  9.683028180354975e-27,  2.636534123477887e-28,  5.638508931992262e-01, -2.454115118810335e-03,
  5.868504266218293e-06, -2.979458484530828e-09, -4.148065244208622e-11,  1.829588745235646e-13, -2.142302762487793e-16, -1.489997105535079e-18,  8.963270179883893e-21,
 -1.677862126304482e-23, -6.116187428173543e-26,  5.059383916794656e-28,  6.344227157764848e-01, -2.688840114900974e-03,  5.809034822404841e-06,  8.338570370333356e-10,
 -5.681014312749987e-11,  1.854579206934340e-13,  4.136581474626031e-17, -2.683921919541814e-18,  9.746142451321086e-21,  1.450184109925813e-24, -1.594236639844870e-25,
  6.164482491019022e-28,  7.090142996579827e-01, -2.915066848579590e-03,  5.539117180089813e-06,  5.535082268633113e-09, -7.099795450209509e-11,  1.589525625087114e-13,
  4.151428206878551e-16, -3.761589970195139e-18,  7.127828456608125e-21,  3.364655197535020e-23, -2.468604335455851e-25,  3.529619471721460e-28,  7.875191622218983e-01,
 -3.126933339195676e-03,  5.023199022079486e-06,  1.102097552932631e-08, -8.178459725078391e-11,  9.427062480626676e-14,  8.783586978362349e-16, -4.263075782656921e-18,
 -4.357949795939500e-22,  7.403213790062520e-23, -2.489822838338046e-25, -4.978209471118379e-28,  8.697867599814371e-01, -3.317568943994472e-03,  4.227966845755195e-06,
  1.706970545378795e-08, -8.628853494821952e-11, -1.483886643252636e-14,  1.354174824850917e-15, -3.581994726462721e-18, -1.334577348665912e-20,  1.050796411899543e-22,
 -7.056330394526038e-26, -1.850774857153870e-27,  9.556080861359085e-01, -3.478971650117498e-03,  3.126055980081713e-06,  2.330133074445023e-08, -8.114710201353940e-11,
 -1.676954272425470e-13,  1.703244702322757e-15, -1.114416939662864e-18, -2.928278169982031e-20,  9.605715615244819e-23,  3.420626201169481e-25, -2.940039478675092e-27,
  1.044696725308447e+00, -3.601914683375786e-03,  1.701698868239532e-06,  2.913649933544684e-08, -6.291605907775287e-11, -3.510890003255288e-13,  1.722794420910289e-15,
  3.402363641098811e-18, -4.149180184204798e-20,  1.197186650919533e-23,  8.782370977237853e-25, -2.156877939420798e-27,  1.136664003929655e+00, -3.675925698320928e-03,
 -4.100533646158789e-08,  3.376387081976581e-08, -2.888815473930441e-11, -5.327924946994061e-13,  1.179733356210402e-15,  9.325740021469404e-18, -3.838571744523821e-20,
 -1.576057534491552e-22,  1.128936036196686e-24,  2.100763961101694e-27,  1.230986616258154e+00, -3.689413813092285e-03, -2.066543120172399e-06,  3.613818105874261e-08,
  2.149321455546457e-11, -6.567296209629455e-13, -9.289117251514248e-17,  1.445193256457924e-17, -7.447692649175880e-21, -3.483379108302798e-22,  4.393161739831935e-25,
  8.724483315849077e-27,  1.326964991329627e+00, -3.630069357033501e-03, -4.292922170993458e-06,  3.504894170879034e-08,  8.454569806713952e-11, -6.456967748266394e-13,
 -2.012481892291765e-15,  1.480962720987388e-17,  5.296754527419849e-20, -3.825664657916267e-22, -1.498129153118310e-24,  1.055907912327539e-26,  1.423670972819818e+00,
 -3.485732043249601e-03, -6.574167271549791e-06,  2.932291573942244e-08,  1.498863430600016e-10, -4.218986702599657e-13, -4.006132294743389e-15,  6.056850688817073e-18,
  1.150401812320645e-19, -4.181389662379857e-23, -3.432768604157893e-24, -2.635921919534548e-27,  1.519884664937280e+00, -3.246009672578230e-03, -8.684525237435786e-06,
  1.823906644826036e-08,  1.988200872787324e-10,  4.311491806085882e-14, -4.890043002824886e-15, -1.223210658902886e-17,  1.139905531694830e-19,  6.311914746824323e-22,
 -2.155707407876919e-24, -2.554579965284162e-26,  1.614023542010988e+00, -2.904997439975456e-03, -1.031441726004724e-05,  2.203302085494509e-09,  2.063818917417688e-10,
  6.509802432279211e-13, -3.274986295749551e-15, -3.047894820983704e-17, -6.868809802650005e-21,  9.652688096343154e-22,  3.726459715198223e-24, -1.998690904100516e-26,
  1.704073635025551e+00, -2.465398315347529e-03, -1.109706745311438e-05, -1.643052693183633e-08,  1.512168758032697e-10,  1.120055214274617e-12,  1.092009123309439e-15,
 -2.924582559233864e-17, -1.817302294756851e-19,  8.865948397487706e-23,  6.948258751956504e-24,  3.256986484162246e-26,  1.787544430514555e+00, -1.943966281591740e-03,
 -1.069262397203465e-05, -3.289458017553060e-08,  3.524957379957554e-11,  1.072700696794373e-12,  5.648149759780149e-15,  1.459716682444949e-18, -1.846062009245009e-19,
 -1.274717944552023e-21, -1.645370959680279e-24,  3.795577103721646e-26,  1.861486045481786e+00, -1.377173423885536e-03, -8.949340840257467e-06, -4.092843624797334e-08,
 -9.664762043102286e-11,  3.763901554171923e-13,  5.819923073313274e-15,  3.342539008885266e-17,  6.423248889751673e-20, -7.076372871527996e-22, -8.335903140694868e-24,
 -4.208887765232660e-26,  1.922623403879715e+00, -8.241939901437816e-04, -6.113140872856093e-06, -3.609605301595342e-08, -1.663522411401338e-10, -4.814593969563571e-13,
  6.914874535522003e-16,  2.216622007587948e-17,  1.846735730867719e-19,  9.590756698718833e-22,  2.310084779782885e-24, -1.483407669875703e-26,  1.967660425068452e+00,
 -3.624930858364562e-04, -2.956500712953158e-06, -2.056525119332231e-08, -1.267321603440052e-10, -6.912566113309457e-13, -3.217495484226608e-15, -1.122180226583687e-17,
 -1.018426453188265e-20,  2.817099593216140e-22,  3.393957792655277e-24,  2.645666235293342e-26,  1.993766289261160e+00, -7.197828114952481e-05, -6.198082955391212e-07,
 -4.709086298718594e-09, -3.323182525444908e-11, -2.225943777970348e-13, -1.429792237338179e-15, -8.848028683880836e-18, -5.281144643477500e-20, -3.034959674148200e-22,
 -1.670834061321057e-24, -8.724248790850870e-27,  5.034952450470291e-04, -2.542737628383682e-06,  9.628415394841098e-09, -3.240686765555916e-11,  1.021964475166493e-13,
 -3.094732168825625e-16,  9.096388213502908e-19, -2.624760550285936e-21,  7.409562185213678e-24, -2.090837413240969e-26,  5.670457403755524e-29, -1.630700314293384e-31,
  4.531916598106079e-03, -2.286737021177276e-05,  8.640847402542708e-08, -2.897163528076323e-10,  9.081040107729841e-13, -2.725823768253328e-15,  7.915416727289132e-18,
 -2.247958031348615e-20,  6.215450575831088e-23, -1.710699196290650e-25,  4.482622520589549e-28, -1.249838875705560e-30,  1.259119997995507e-02, -6.342404326391089e-05,
  2.386454871623810e-07, -7.939511620362011e-10,  2.457900916749819e-12, -7.244288425770524e-15,  2.050359334549017e-17, -5.625346313001443e-20,  1.484260852237757e-22,
 -3.851884700683620e-25,  9.248071230557708e-28, -2.373989268343831e-30,  2.468618088684293e-02, -1.240251851889395e-04,  4.636722750418140e-07, -1.524304352554039e-09,
  4.628486419566990e-12, -1.324977448104028e-14,  3.594191630743241e-17, -9.284861772439312e-20,  2.242902671037036e-22, -5.143875668658819e-25,  9.863800091274275e-28,
 -1.945663737870816e-30,  4.082399492573162e-02, -2.043833900238678e-04,  7.574354475207231e-07, -2.449476837940314e-09,  7.237661522999005e-12, -1.985389180091577e-14,
  5.042094447811199e-17, -1.175410230333306e-19,  2.378292489515701e-22, -3.914559189874591e-25,  1.453448462570304e-28,  1.280812901918594e-30,  6.101392804239227e-02,
 -3.041039314807372e-04,  1.114431758982782e-06, -3.527594022825027e-09,  1.004739519336067e-11, -2.593829016075354e-14,  5.940771059846918e-17, -1.142482250338328e-19,
  1.395064849699767e-22,  1.096968710520083e-25, -1.816902385472953e-27,  7.204762923820309e-30,  8.526720183600389e-02, -4.226743923929344e-04,  1.527622530528101e-06,
 -4.706136092791894e-09,  1.276874164199506e-11, -3.021617190489516e-14,  5.812706469652019e-17, -6.846612058701890e-20, -1.028551437155232e-22,  1.008523923602416e-24,
 -4.604520010176862e-27,  1.362186661671283e-29,  1.135966797637061e-01, -5.594510560418771e-04,  1.988325782539327e-06, -5.921923900150818e-09,  1.506893669722154e-11,
 -3.131513896835075e-14,  4.217510960353060e-17,  2.924495539412076e-20, -4.880762195315024e-22,  2.159183268727619e-24, -7.254392192687370e-27,  1.613541896570891e-29,
  1.460164746638613e-01, -7.136415922206603e-04,  2.486086015835687e-06, -7.101221673743103e-09,  1.658139084358036e-11, -2.788518779090870e-14,  8.264204157904193e-18,
  1.794365936053674e-19, -9.669676431544022e-22,  3.215859721265785e-24, -8.170525968103103e-27,  9.141858806338972e-30,  1.825414312003877e-01, -8.842834400301100e-04,
  3.008522238814946e-06, -8.160044214241879e-09,  1.691952298928992e-11, -1.873606670346591e-14, -4.491174942709304e-17,  3.699645748833603e-19, -1.432369735313364e-21,
  3.643166982173319e-24, -5.440618612316662e-27, -1.185501709516819e-29,  2.231864479951760e-01, -1.070217137949177e-03,  3.541156065984433e-06, -9.004792625467596e-09,
  1.569564507404349e-11, -3.008091361530430e-15, -1.157228132348998e-16,  5.727579179338819e-19, -1.718402910107736e-21,  2.795200215071936e-24,  2.495409987332865e-27,
 -4.670248943458925e-29,  2.679655926230166e-01, -1.270053677256924e-03,  4.067223822350545e-06, -9.533392638696581e-09,  1.254640765297633e-11,  1.962058777718939e-14,
 -1.986238164977256e-16,  7.420137523695562e-19, -1.614661111377785e-21,  8.529584974011020e-26,  1.582439069323055e-26, -8.656600986877182e-29,  3.168909472776494e-01,
 -1.482134757228656e-03,  4.567480053613388e-06, -9.637177869663499e-09,  7.166627998683852e-12,  4.869012882201405e-14, -2.832682394320358e-16,  8.150421097914977e-19,
 -9.019661704180276e-22, -4.741211240895998e-24,  3.212375023245339e-26, -1.110916547783826e-28,  3.699711023895154e-01, -1.704484604203523e-03,  5.020005385092485e-06,
 -9.203852560608027e-09, -6.464105179675860e-13,  8.268427778833398e-14, -3.539139424542906e-16,  7.174271118858784e-19,  5.838993821055498e-22, -1.124364932321797e-23,
  4.527922503433615e-26, -8.962354847706375e-29,  4.272091878796528e-01, -1.934751795332779e-03,  5.400040381030008e-06, -8.121990751779940e-09, -1.093599289601971e-11,
  1.187413320339763e-13, -3.894365587684377e-16,  3.746017246316676e-19,  2.856774516697313e-21, -1.789339901496846e-23,  4.525978078590686e-26,  9.674475305936115e-30,
  4.886002944532583e-01, -2.170139332518121e-03,  5.679880559975933e-06, -6.287686924812753e-09, -2.351442822897122e-11,  1.523860532519925e-13, -3.644250573980896e-16,
 -2.678489415861045e-19,  5.656947247376582e-21, -2.179658995952834e-23,  1.984298366047160e-26,  1.991486632132520e-28,  5.541280867891093e-01, -2.407321105210860e-03,
  5.828888432347979e-06, -3.614168468923631e-09, -3.787610445222800e-11,  1.773485461028574e-13, -2.520285758582137e-16, -1.213266722798805e-18,  8.320392786512560e-21,
 -1.879920745220095e-23, -4.035416987615567e-26,  4.391674989297089e-28,  6.237603418040267e-01, -2.642342981420675e-03,  5.813709841778503e-06, -4.540296136874086e-11,
 -5.309696186841774e-11,  1.855841500823993e-13, -2.941834660088260e-17, -2.372387846819259e-18,  9.690084304957179e-21, -4.386456703567954e-24, -1.325059413594177e-25,
  6.031442544654198e-28,  6.974430518643405e-01, -2.870507293684473e-03,  5.598828929235479e-06,  4.425053419881388e-09, -6.772766255233343e-11,  1.676789220812125e-13,
  3.131802638544676e-16, -3.515992148406197e-18,  8.165451155419768e-21,  2.411984544263224e-23, -2.286357316715223e-25,  4.682270601672469e-28,  7.750926064363702e-01,
 -3.086240835072777e-03,  5.147665225002914e-06,  9.728610071047461e-09, -7.969804527052127e-11,  1.139196571766649e-13,  7.591840753052253e-16, -4.236338474608385e-18,
  2.045607401931199e-21,  6.372116604364288e-23, -2.644968017856938e-25, -2.138159738321206e-28,  8.565853958223125e-01, -3.282949345103333e-03,  4.424515443060583e-06,
  1.568844559568861e-08, -8.626866893944737e-11,  1.641299288065040e-14,  1.248463980658400e-15, -3.949231518878031e-18, -9.632404339464625e-21,  1.007312978834852e-22,
 -1.442637361171186e-25, -1.495569584920255e-27,  9.417439558538114e-01, -3.452867050940282e-03,  3.397778309262409e-06,  2.197835440249441e-08, -8.409529268133694e-11,
 -1.272946016112616e-13,  1.659459568615226e-15, -1.993748493594515e-18, -2.560947410453878e-20,  1.071699820194833e-22,  2.142718956169554e-25, -2.845330263048174e-27,
  1.030318483286005e+00, -3.586920172539733e-03,  2.045072558957045e-06,  2.807594437272864e-08, -6.951742470409293e-11, -3.087481385955352e-13,  1.799584267822575e-15,
  2.088103487292632e-18, -4.045326194683899e-20,  4.499698866469252e-23,  7.683059862930453e-25, -2.803730469992256e-27,  1.121962198957518e+00, -3.674641732210847e-03,
  3.610414270971718e-07,  3.321803813685667e-08, -3.924045630091635e-11, -5.014891752729021e-13,  1.422867366504408e-15,  8.015485813884625e-18, -4.322844719974074e-20,
 -1.110422441557426e-22,  1.188341587369620e-24,  6.061916594340493e-28,  1.216198649754769e+00, -3.704206677543907e-03, -1.631255058356182e-06,  3.637701157301169e-08,
  8.368917385972619e-12, -6.541415382006766e-13,  3.065696120649074e-16,  1.401708864200110e-17, -1.958174251450474e-20, -3.233924308341441e-22,  7.994909649163937e-25,
  7.563875467189647e-27,  1.312378722017291e+00, -3.662708386565018e-03, -3.864652750908783e-06,  3.629588138416215e-08,  7.118328957538182e-11, -6.888418908890598e-13,
 -1.576230341071621e-15,  1.627360833766795e-17,  3.823368814629666e-20, -4.326380200707832e-22, -9.930534191411787e-25,  1.225858607035078e-26,  1.409625143180574e+00,
 -3.536877787290549e-03, -6.208198393258845e-06,  3.164843456275260e-08,  1.405027753460888e-10, -5.155971005597727e-13, -3.785418589260748e-15,  9.687412572876459e-18,
  1.110488631083477e-19, -1.799538258604279e-22, -3.436787175141768e-24,  2.497185810173526e-27,  1.506763136392680e+00, -3.314556296665332e-03, -8.446562211129136e-06,
  2.142060084426534e-08,  1.984832499119865e-10, -7.792356516256822e-14, -5.178189513676980e-15, -8.239665758103388e-18,  1.348932988466854e-19,  5.228283485197294e-22,
 -3.249754443871924e-24, -2.380115396489773e-26,  1.602238769544388e+00, -2.987349923377803e-03, -1.026774995297267e-05,  5.605008424648883e-09,  2.185463851291896e-10,
  5.621478993298378e-13, -4.126055755218304e-15, -3.011588187536277e-17,  3.032541899784582e-20,  1.093825791877464e-21,  2.629928230513629e-24, -2.978009221573249e-26,
  1.694033300286647e+00, -2.554920678969629e-03, -1.127897389621272e-05, -1.383071429056821e-08,  1.738103562894167e-10,  1.135784634018355e-12,  1.925889093440247e-16,
 -3.495377411481662e-17, -1.732048530196506e-19,  3.935957486869329e-22,  8.249251819163953e-24,  2.579143461291414e-26,  1.779594999162371e+00, -2.031074946957869e-03,
 -1.108324312694527e-05, -3.215158835601517e-08,  5.805882308208263e-11,  1.208036449479900e-12,  5.599349203603003e-15, -5.191075754868671e-18, -2.312356490976090e-19,
 -1.302436781926889e-21,  3.777604052034104e-25,  5.417762564800513e-26,  1.855831015477300e+00, -1.450758380685161e-03, -9.449486367121145e-06, -4.240666450664676e-08,
 -8.764613517946566e-11,  5.275055754906158e-13,  6.780300602852465e-15,  3.500525141478672e-17,  3.230919594472739e-20, -1.078067029461104e-21, -1.017591247399291e-23,
 -4.072551960186861e-26,  1.919226009529757e+00, -8.748777003430900e-04, -6.562577560143134e-06, -3.883359722698059e-08, -1.757616103354974e-10, -4.567155637647539e-13,
  1.400184585437102e-15,  2.864454145782129e-17,  2.206727333003934e-19,  1.034673977064766e-21,  1.368077711907547e-24, -2.882309512178110e-26,  1.966161535669193e+00,
 -3.871677732462771e-04, -3.215920127945569e-06, -2.270786979518644e-08, -1.413550894920367e-10, -7.722734882654963e-13, -3.534543195128317e-15, -1.135681284948738e-17,
  2.703352657723490e-21,  4.431794935441062e-22,  4.743257316085552e-24,  3.521199998226861e-26,  1.993468088090389e+00, -7.717217360191052e-05, -6.796607767971298e-07,
 -5.278362855218075e-09, -3.804796179839564e-11, -2.600838712487672e-13, -1.702935582547821e-15, -1.072649561284816e-17, -6.503852580905828e-20, -3.786409068234459e-22,
 -2.102994583998457e-24, -1.100233840979617e-26,  4.934759248906803e-04, -2.467238500253654e-06,  9.249143364793218e-09, -3.082007855541093e-11,  9.621947911364712e-14,
 -2.884976919249427e-16,  8.393548950042373e-19, -2.399273736677086e-21,  6.696007562029051e-24, -1.877838786850325e-26,  4.991983134507844e-29, -1.458932371094821e-31,
  4.441807977733168e-03, -2.218976587745219e-05,  8.301728959264133e-08, -2.756127087685357e-10,  8.554373895723108e-13, -2.543187724457568e-15,  7.312931927329425e-18,
 -2.058581709398690e-20,  5.630583052083081e-23, -1.542016074248673e-25,  3.960404499157243e-28, -1.128042749808554e-30,  1.234126272393772e-02, -6.155233131357230e-05,
  2.293493356423984e-07, -7.557576228691902e-10,  2.317811148111465e-12, -6.770579203017702e-15,  1.899295635866473e-17, -5.171875839826396e-20,  1.352004963838419e-22,
 -3.502300245783325e-25,  8.244059102241907e-28, -2.196847124095221e-30,  2.419738480652157e-02, -1.203877344887087e-04,  4.458163620944155e-07, -1.452322535042971e-09,
  4.371910529100720e-12, -1.241757143410410e-14,  3.343990650385254e-17, -8.596016941569393e-20,  2.064618134441630e-22, -4.766518012028939e-25,  9.001851367027971e-28,
 -1.976605945916894e-30,  4.001839691256302e-02, -1.984395424442314e-04,  7.287236473605339e-07, -2.336786231033542e-09,  6.852422520066142e-12, -1.868243590536657e-14,
  4.723423336057862e-17, -1.101547445431096e-19,  2.238533714857573e-22, -3.847005381894384e-25,  1.878999253281658e-28,  6.589677149584022e-31,  5.981507893431420e-02,
 -2.953551079587396e-04,  1.073048309364223e-06, -3.370909437027799e-09,  9.542630746518114e-12, -2.455038489220906e-14,  5.627175634169073e-17, -1.097342648747238e-19,
  1.422198033056765e-22,  4.292325082479733e-26, -1.532434685016956e-27,  5.740703332699667e-30,  8.360059340383749e-02, -4.106758790228274e-04,  1.472354997671358e-06,
 -4.506595674403824e-09,  1.217821163392816e-11, -2.884446658790098e-14,  5.616914552120807e-17, -7.121098723020886e-20, -6.972475654950092e-23,  8.357090149307738e-25,
 -4.051491296903394e-27,  1.152487418284270e-29,  1.113902444100106e-01, -5.438246506184353e-04,  1.918688824502646e-06, -5.685776091327174e-09,  1.445281344814850e-11,
 -3.029480506184448e-14,  4.278660431807250e-17,  1.481555983696921e-20, -4.154023947186601e-22,  1.882686864194890e-24, -6.583620441351915e-27,  1.432361941572716e-29,
  1.432011522898553e-01, -6.940892949032460e-04,  2.402444804474825e-06, -6.840368627092846e-09,  1.602605983405100e-11, -2.762994801386021e-14,  1.287218638356479e-17,
  1.502836793364839e-19, -8.569818597233815e-22,  2.897147742674064e-24, -7.764696164110692e-27,  9.193957680273340e-30,  1.790518200918194e-01, -8.606023709738219e-04,
  2.912213436342316e-06, -7.892384751591485e-09,  1.653483565559677e-11, -1.969470038080639e-14, -3.517503116273229e-17,  3.261842564858322e-19, -1.305248014720521e-21,
  3.416262890588578e-24, -5.878365973830010e-27, -8.254247203085069e-30,  2.189615595960925e-01, -1.042315855777946e-03,  3.434602876884542e-06, -8.754289159389496e-09,
  1.560897706983579e-11, -5.599112392168847e-15, -1.004401936219156e-16,  5.193944519338283e-19, -1.616452069978383e-21,  2.856330055871283e-24,  6.177999882192580e-28,
 -3.891575425073406e-29,  2.629497338123687e-01, -1.237970048726699e-03,  3.954039695470359e-06, -9.329762868656014e-09,  1.289280243232646e-11,  1.509710121131780e-14,
 -1.785695092638749e-16,  6.905086241717765e-19, -1.601087120346178e-21,  6.451219546270288e-25,  1.223974048454981e-26, -7.657213275081618e-29,  3.110347583506583e-01,
 -1.446055480367252e-03,  4.452552875480663e-06, -9.515083084269251e-09,  8.074277219505058e-12,  4.216213463485099e-14, -2.608750873989661e-16,  7.836867958812653e-19,
 -1.050682374948449e-21, -3.552220300353289e-24,  2.737151739866658e-26, -1.048267168691833e-28,  3.632327844798104e-01, -1.664766399153564e-03,  4.909550194389260e-06,
 -9.201420285006700e-09,  9.239721859941034e-13,  7.443314835408542e-14, -3.336228002736791e-16,  7.299772435328046e-19,  2.107563606181321e-22, -9.513746710639942e-24,
  4.116324930973192e-26, -9.687253461633192e-29,  4.195559601075238e-01, -1.891944125224740e-03,  5.301603371164896e-06, -8.278472105704565e-09, -8.653730525561938e-12,
  1.095304681953948e-13, -3.777622215480948e-16,  4.560615623319678e-19,  2.245213031563380e-21, -1.608414585904218e-23,  4.497605809584636e-26, -2.148545794112992e-29,
  4.800101286198775e-01, -2.125008264406988e-03,  5.602269961130390e-06, -6.640013409362730e-09, -2.055467399753977e-11,  1.435695909910494e-13, -3.695072923487760e-16,
 -9.921220128770196e-20,  4.888507527120075e-21, -2.084523353916605e-23,  2.730049076323256e-26,  1.408877479434087e-28,  5.445917757146052e-01, -2.360873512759566e-03,
  5.781998259891066e-06, -4.192150035164016e-09, -3.439221927703884e-11,  1.709216536422673e-13, -2.823762575853187e-16, -9.581174496351394e-19,  7.619038303203721e-21,
 -2.004724019068128e-23, -2.255305562633531e-26,  3.697922967960853e-28,  6.132839657674171e-01, -2.595849642673120e-03,  5.808189998980877e-06, -8.653212057259541e-10,
 -4.939753950554980e-11,  1.841158455848297e-13, -9.153478293539710e-17, -2.065803283608711e-18,  9.443085853188935e-21, -9.164707651205973e-24, -1.066577751631228e-25,
  5.687417907228869e-28,  6.860509145882787e-01, -2.825522424249413e-03,  5.645539615473016e-06,  3.368614902271047e-09, -6.430673934349090e-11,  1.740441415668815e-13,
  2.185087992708288e-16, -3.242527927662484e-18,  8.874341253073788e-21,  1.541095582160356e-23, -2.062749881032020e-25,  5.415811394557662e-28,  7.628307147461488e-01,
 -3.044614038467565e-03,  5.256835817459295e-06,  8.472618297463773e-09, -7.724700900873454e-11,  1.307261084187234e-13,  6.418132468589756e-16, -4.136231450230705e-18,
  4.147547205965829e-21,  5.302749356154373e-23, -2.684280318459766e-25,  2.758919702740741e-29,  8.435255499296693e-01, -3.246823605912525e-03,  4.604510999934708e-06,
  1.431236278771552e-08, -8.564990053004219e-11,  4.501766369164105e-14,  1.134106684603809e-15, -4.200683226841603e-18, -6.124827534277965e-21,  9.375218613284182e-23,
 -2.020307973577495e-25, -1.130565092823207e-27,  9.279884899278293e-01, -3.424652916904165e-03,  3.653368353343771e-06,  2.061460591826447e-08, -8.624789950482341e-11,
 -8.822645727864537e-14,  1.592751961245851e-15, -2.750109216018952e-18, -2.162674818572880e-20,  1.132937962846065e-22,  9.352722831940986e-26, -2.625034248164383e-27,
  1.016005630234452e+00, -3.569231309440722e-03,  2.375114094357057e-06,  2.691662980139312e-08, -7.525650031940942e-11, -2.650010896917325e-13,  1.840212474389345e-15,
  8.251986471059728e-19, -3.831123236131305e-20,  7.312109492077246e-23,  6.348192845538222e-25, -3.226684628410362e-27,  1.107271917204720e+00, -3.670170358209361e-03,
  7.555660299028127e-07,  3.251188143812262e-08, -4.891139484678093e-11, -4.648068342060090e-13,  1.627399247323624e-15,  6.577415849217793e-18, -4.636780164526765e-20,
 -6.339814337534039e-23,  1.183629424712135e-24, -7.975438668354009e-28,  1.201358489523377e+00, -3.715509336150745e-03, -1.194357580626356e-06,  3.640678340514918e-08,
 -4.608956652293886e-12, -6.421554543248626e-13,  6.885729209002539e-16,  1.321099588618118e-17, -3.057201814325853e-20, -2.852002191660092e-22,  1.098453940355207e-24,
  5.964578692356169e-27,  1.297668838452073e+00, -3.691865104025971e-03, -3.422729443255004e-06,  3.732270113575817e-08,  5.706571754819281e-11, -7.210798725265970e-13,
 -1.105830502322289e-15,  1.724129489815366e-17,  2.207658219522756e-20, -4.612706018492878e-22, -4.328034350218947e-25,  1.305025019070098e-26,  1.395380759018150e+00,
 -3.584986848113460e-03, -5.815284926572962e-06,  3.380914660900271e-08,  1.293063503722115e-10, -6.027975509334029e-13, -3.465582520626529e-15,  1.311109764035615e-17,
  1.021364937295577e-19, -3.136950019976122e-22, -3.212656893859987e-24,  7.653743743236515e-27,  1.493371470182021e+00, -3.381046780736357e-03, -8.170534103969176e-06,
  2.457704326082936e-08,  1.956659168228216e-10, -2.044644222816487e-13, -5.345828857782517e-15, -3.649009137992920e-18,  1.511319946069299e-19,  3.729237212907134e-22,
 -4.215837799955416e-24, -1.973449945425929e-26,  1.590125596834868e+00, -3.069162619885328e-03, -1.017915658734523e-05,  9.186029616132214e-09,  2.287315104662696e-10,
  4.531503260253128e-13, -4.949665771746625e-15, -2.849784773014846e-17,  7.125623441655935e-20,  1.170127610264755e-21,  1.121433289837267e-24, -3.850982426824880e-26,
  1.683632171873420e+00, -2.645767341681278e-03, -1.142750717807276e-05, -1.086811575006125e-08,  1.964898223143717e-10,  1.128051412175636e-12, -8.611163645661141e-16,
 -4.020389117389991e-17, -1.528497725240855e-19,  7.431911389920183e-22,  9.145534993720471e-24,  1.412331977039107e-26,  1.771290948738669e+00, -2.121266492869924e-03,
 -1.146266775694451e-05, -3.102212481859479e-08,  8.354711810956378e-11,  1.339797381665090e-12,  5.343405958719564e-15, -1.333294886694981e-17, -2.772324740540276e-19,
 -1.234780296238328e-21,  3.124301687150814e-24,  7.051074469016944e-26,  1.849873534741573e+00, -1.528412770354694e-03, -9.966402661951299e-06, -4.371542540106167e-08,
 -7.538891849995492e-11,  7.020726298506282e-13,  7.768507716578890e-15,  3.533620729460094e-17, -1.424527102282769e-20, -1.519255534634050e-21, -1.182894287487845e-23,
 -3.319246924689964e-26,  1.915618477742981e+00, -9.292908215807300e-04, -7.045748578722147e-06, -4.171674414577730e-08, -1.844906403469234e-10, -4.126538872754901e-13,
  2.306752201188563e-15,  3.630981126493649e-17,  2.585525941116136e-19,  1.058700403032841e-21, -3.096316186077432e-25, -4.845554347094518e-26,  1.964559628189693e+00,
 -4.140247649400613e-04, -3.502509579042674e-06, -2.509783176823287e-08, -1.576744887788082e-10, -8.608925093218399e-13, -3.848644867152003e-15, -1.097520644797552e-17,
  2.247380676001849e-20,  6.669432401316717e-22,  6.524298432047737e-24,  4.611042026899763e-26,  1.993148108517537e+00, -8.287358055844221e-05, -7.468328735143601e-07,
 -5.931070805967564e-09, -4.368394253457558e-11, -3.048068069159153e-13, -2.034585384155139e-15, -1.304305404177108e-17, -8.030753241829835e-20, -4.732316698258837e-22,
 -2.647112423249715e-24, -1.382777514951300e-26,  4.837526512364841e-04, -2.394698976924784e-06,  8.888352567703153e-09, -2.932565441485474e-11,  9.064565143061374e-14,
 -2.691357288290629e-16,  7.750760892873294e-19, -2.195444759114474e-21,  6.054420405268370e-24, -1.690568207004601e-26,  4.381567923738498e-29, -1.321349910376181e-31,
  4.354356567759258e-03, -2.153862809641049e-05,  7.979041093594260e-08, -2.623232768866408e-10,  8.062830809798838e-13, -2.374395613283530e-15,  6.760940766547155e-18,
 -1.886988845057563e-20,  5.102803841226860e-23, -1.393224578364382e-25,  3.486178062156774e-28, -1.031858086716279e-30,  1.209866642714537e-02, -5.975319268247984e-05,
  2.204983643577044e-07, -7.197316540707753e-10,  2.186843053436702e-12, -6.331648295378739e-15,  1.760354979402441e-17, -4.758789707792932e-20,  1.231628817496413e-22,
 -3.191449424291265e-25,  7.308004380480094e-28, -2.066255771184388e-30,  2.372285820812840e-02, -1.168897445093861e-04,  4.288001385336114e-07, -1.384315977478616e-09,
  4.131393512282684e-12, -1.164316534013390e-14,  3.112298556950842e-17, -7.962116443564608e-20,  1.899293772813765e-22, -4.424003295402847e-25,  8.118966076189362e-28,
 -2.044560466774721e-30,  3.923612331977875e-02, -1.927200831477932e-04,  7.013279114291174e-07, -2.230076101290567e-09,  6.489864316266568e-12, -1.758502958869820e-14,
  4.424811544232807e-17, -1.032115275776526e-19,  2.101447977850411e-22, -3.767837374633778e-25,  2.034929910011778e-28,  4.753294871193418e-32,  5.865057470207734e-02,
 -2.869299663862397e-04,  1.033497520277322e-06, -3.222083063699716e-09,  9.064882055243428e-12, -2.323621816959009e-14,  5.326306209151995e-17, -1.051698686331222e-19,
  1.427187725949791e-22, -1.373798665016066e-26, -1.310860831071396e-27,  4.334346324915354e-30,  8.198110968566194e-02, -3.991100865313707e-04,  1.419426155943388e-06,
 -4.316286840468667e-09,  1.161464020152988e-11, -2.752055940715509e-14,  5.414830661630147e-17, -7.299113320813025e-20, -4.243965262651852e-23,  6.831808875422227e-25,
 -3.590041979003094e-27,  9.446458771755520e-30,  1.092452181993729e-01, -5.287441717945623e-04,  1.851827167979060e-06, -5.459322336430529e-09,  1.385721222982890e-11,
 -2.926438978670707e-14,  4.302517343152013e-17,  2.557483776789427e-21, -3.522192173342699e-22,  1.631369155754089e-24, -5.996976813152809e-27,  1.230238865354907e-29,
  1.404627204578806e-01, -6.751937569548601e-04,  2.321880705077827e-06, -6.588354299937090e-09,  1.547687542782107e-11, -2.727352482372785e-14,  1.671145807611392e-17,
  1.244698576928438e-19, -7.581787577239200e-22,  2.594517104701335e-24, -7.371358998057089e-27,  8.572129130157400e-30,  1.756554125112162e-01, -8.376790306947319e-04,
  2.819079024748009e-06, -7.631021379604331e-09,  1.613321551018345e-11, -2.043391099594436e-14, -2.660846169704654e-17,  2.863380443621573e-19, -1.186575259958892e-21,
  3.174641967583157e-24, -6.185723547054834e-27, -5.926660838067775e-30,  2.148465904746188e-01, -1.015255002338212e-03,  3.331045762357013e-06, -8.505567517574249e-09,
  1.547403735743220e-11, -7.840910491191958e-15, -8.660584585168019e-17,  4.693147693612622e-19, -1.513574319162484e-21,  2.848717713950819e-24, -9.539419588718750e-28,
 -3.281108072550063e-29,  2.580604141698357e-01, -1.206782031471403e-03,  3.843329477600614e-06, -9.121288878396566e-09,  1.315342402962222e-11,  1.103767903308823e-14,
 -1.599484271191627e-16,  6.397334878317448e-19, -1.569837782965437e-21,  1.069976396508884e-24,  9.065807109397349e-27, -6.795182855528602e-29,  3.053210573111587e-01,
 -1.410889523234980e-03,  4.339173754372554e-06, -9.379481497425288e-09,  8.856667183110267e-12,  3.616054120565010e-14, -2.394203325979193e-16,  7.482212816153636e-19,
 -1.159949009983479e-21, -2.547699027693172e-24,  2.290150562627155e-26, -9.839163044109397e-29,  3.566515728788158e-01, -1.625931304105218e-03,  4.799269587966791e-06,
 -9.175155511274332e-09,  2.334223905798209e-12,  6.667193028434618e-14, -3.131382901087989e-16,  7.315508828756949e-19, -1.031415589757301e-22, -7.953893380409071e-24,
  3.679854307031512e-26, -1.011313457221026e-28,  4.120723769891455e-01, -1.849930855423163e-03,  5.201501654407355e-06, -8.399895040098931e-09, -6.552710013998134e-12,
  1.006250075896121e-13, -3.640712273336085e-16,  5.189888025960127e-19,  1.698266953719108e-21, -1.431181284371201e-23,  4.345737067795496e-26, -4.666324413078726e-29,
  4.715992196313796e-01, -2.080514201141037e-03,  5.520709744811170e-06, -6.946399531551261e-09, -1.777210049879780e-11,  1.346850719401850e-13, -3.702064288499839e-16,
  4.543512002118999e-20,  4.159085424273169e-21, -1.964496108884067e-23,  3.233518293700273e-26,  8.898728207387505e-29,  5.352404621651708e-01, -2.314827847200448e-03,
  5.728502398204496e-06, -4.715454931862875e-09, -3.104358998178772e-11,  1.638495741287970e-13, -3.058997756977433e-16, -7.259989449619598e-19,  6.884834149079959e-21,
 -2.064442617822689e-23, -7.811478222713341e-27,  3.004494921316654e-28,  6.029934138715167e-01, -2.549438815244449e-03,  5.793185058268898e-06, -1.626361720179672e-09,
 -4.574170110822044e-11,  1.812587139935672e-13, -1.452019626906304e-16, -1.769678664657652e-18,  9.042269759902029e-21, -1.294434132243493e-23, -8.269089452772018e-26,
  5.184237972124971e-28,  6.748393851970056e-01, -2.780213638996009e-03,  5.679905256496270e-06,  2.367808785378772e-09, -6.078060063821299e-11,  1.782314098500716e-13,
  1.317660470221572e-16, -2.951217296152038e-18,  9.286484313520053e-21,  7.649624912243871e-24, -1.815322049742165e-25,  5.772672842203086e-28,  7.507369824900847e-01,
 -3.002173473489259e-03,  5.351180407520453e-06,  7.258380169907596e-09, -7.448774790896550e-11,  1.447565400526202e-13,  5.281291099234935e-16, -3.975032297327118e-18,
  5.864119562487977e-21,  4.237527072683695e-23, -2.627705016916497e-25,  2.215132742349199e-28,  8.306129826341030e-01, -3.209323743437203e-03,  4.768071354919735e-06,
  1.295060573095378e-08, -8.448699023905832e-11,  7.080570769998524e-14,  1.014239366156328e-15, -4.344327097569452e-18, -2.906238145500083e-21,  8.478136424683648e-23,
 -2.439416798231925e-25, -7.781821056894529e-28,  9.143498655847495e-01, -3.394460049167951e-03,  3.892412249515957e-06,  1.922257270206359e-08, -8.763679351971026e-11,
 -5.099886030917655e-14,  1.506677129978713e-15, -3.376406760914875e-18, -1.750789103265274e-20,  1.148112964902905e-22, -1.537308349835690e-26, -2.312667123491646e-27,
  1.001768723076180e+00, -3.548959255405869e-03,  2.690721915817977e-06,  2.567253065532880e-08, -8.011370459198829e-11, -2.206946564291800e-13,  1.846583643806926e-15,
 -3.540247356618649e-19, -3.525673117437642e-20,  9.559920106426752e-23,  4.876111227863784e-25, -3.429516309745188e-27,  1.092605776035634e+00, -3.662579255981029e-03,
  1.140713378656511e-06,  3.165711173239836e-08, -5.780291241982896e-11, -4.237086908231398e-13,  1.790515642202704e-15,  5.066175046116109e-18, -4.780983039752791e-20,
 -1.713100426033504e-23,  1.120791405610151e-24, -2.023483712781068e-27,  1.186480106324403e+00, -3.723318894455305e-03, -7.583392150733802e-07,  3.623131678647511e-08,
 -1.725745614329758e-11, -6.213105296187065e-13,  1.043304313208483e-15,  1.207737736253393e-17, -3.998998162435092e-20, -2.365537033996557e-22,  1.320093138069087e-24,
  4.075378509031963e-27,  1.282849471347553e+00, -3.717441032632285e-03, -2.969858852978049e-06,  3.811910320983825e-08,  4.241817114470778e-11, -7.417623358697766e-13,
 -6.156976349621840e-16,  1.767983809260826e-17,  5.297909291901405e-21, -4.670789388146781e-22,  1.411435613037460e-25,  1.288026179257361e-26,  1.380950384971448e+00,
 -3.629852062128024e-03, -5.397573885901064e-06,  3.577721280724331e-08,  1.164502567927651e-10, -6.812081806157457e-13, -3.054584938175490e-15,  1.617472059562018e-17,
  8.862462512147007e-20, -4.340357860326433e-22, -2.770185809760148e-24,  1.234152667891220e-26,  1.479718497037452e+00, -3.445178490570017e-03, -7.856983255050539e-06,
  2.766798790219488e-08,  1.902882261256626e-10, -3.334326875863533e-13, -5.378517115996004e-15,  1.367872045133251e-18,  1.613276589418243e-19,  1.886086311875209e-22,
 -4.954618334112611e-24, -1.352250822901447e-26,  1.577686866674753e+00, -3.150092082663097e-03, -1.004668856415390e-05,  1.291151730857215e-08,  2.365434617457504e-10,
  3.250798813750491e-13, -5.709308097687818e-15, -2.553844091905042e-17,  1.137604494760272e-19,  1.178998761486944e-21, -7.247002893349035e-25, -4.491954488148889e-26,
  1.672865514116202e+00, -2.737653918026831e-03, -1.153832173653456e-05, -7.545305606072732e-09,  2.187502579305917e-10,  1.093350678235869e-12, -2.050770745671465e-15,
 -4.459545123456568e-17, -1.194009741843944e-19,  1.116911584747624e-21,  9.419965233217616e-24, -2.411756904193881e-27,  1.762620157224807e+00, -2.214432091044510e-03,
 -1.182600628597253e-05, -2.946418102804050e-08,  1.115898924669691e-10,  1.462516725065767e-12,  4.839409041783299e-15, -2.288516573866526e-17, -3.186469048965598e-19,
 -1.043360156521907e-21,  6.549388640032656e-24,  8.455859270230509e-26,  1.843597071387776e+00, -1.610261703226176e-03, -1.049772800537139e-05, -4.479885154805974e-08,
 -5.940337430688680e-11,  9.002844017937324e-13,  8.742650928417908e-15,  3.391132081370788e-17, -7.777158233204195e-20, -2.017566676935983e-21, -1.296878109051221e-23,
 -1.697383963721896e-26,  1.911785340362273e+00, -9.877100012887577e-04, -7.564322231825928e-06, -4.473124806932293e-08, -1.921027663057294e-10, -3.441217915093457e-13,
  3.444944905921439e-15,  4.518632268085933e-17,  2.958642253056209e-19,  9.964578550310193e-22, -2.993425650570610e-24, -7.467688965795483e-26,  1.962845519227524e+00,
 -4.432937666323093e-04, -3.819405038226538e-06, -2.776348774239892e-08, -1.758403844816045e-10, -9.568423019885894e-13, -4.141889733877575e-15, -9.817330913741118e-18,
  5.170361561136038e-20,  9.721913575432632e-22,  8.833489162226016e-24,  5.920104324514529e-26,  1.992804196699988e+00, -8.914529815937626e-05, -8.224095005581356e-07,
 -6.681565678339834e-09, -5.029953115716503e-11, -3.583262170465223e-13, -2.438482670831084e-15, -1.590715937642938e-17, -9.940515985618375e-20, -5.922533563402459e-22,
 -3.329123840511065e-24, -1.728197497359358e-26,  4.743138744968618e-04, -2.324975534799936e-06,  8.544972285427388e-09, -2.791739552320017e-11,  8.544408664856516e-14,
 -2.512502298760035e-16,  7.162268695651630e-19, -2.011113893150916e-21,  5.475992238210737e-24, -1.526606219162925e-26,  3.823966236970205e-29, -1.219345643885129e-31,
  4.269459070305044e-03, -2.091268056989671e-05,  7.671839576320623e-08, -2.497940110024103e-10,  7.603759318803811e-13, -2.218293340393021e-15,  6.254709118371031e-18,
 -1.731463705941142e-20,  4.625269957194076e-23, -1.262634931576086e-25,  3.048296400195402e-28, -9.633951064850636e-31,  1.186312775788373e-02, -5.802316754288832e-05,
  2.120674156926435e-07, -6.857327190724230e-10,  2.064329267468337e-12, -5.924717695462304e-15,  1.632457763600532e-17, -4.382504673508916e-20,  1.121781777858314e-22,
 -2.917048259147767e-25,  6.417479427828204e-28, -1.992034573010512e-30,  2.326205638774292e-02, -1.135246842666520e-04,  4.125774055136456e-07, -1.320036749187069e-09,
  3.905822628970473e-12, -1.092229410939322e-14,  2.897633071427824e-17, -7.379215695158820e-20,  1.745655586411528e-22, -4.117567926633618e-25,  7.193209667415459e-28,
 -2.176910765829590e-30,  3.847629720532058e-02, -1.872147646253263e-04,  6.751786033203262e-07, -2.128995146484479e-09,  6.148553062659193e-12, -1.655700648503172e-14,
  4.145030955531942e-17, -9.670235755709106e-20,  1.967259035321897e-22, -3.687896679215981e-25,  1.914462586409932e-28, -6.077866757976345e-31,  5.751914935345571e-02,
 -2.788142154358997e-04,  9.956876385560635e-07, -3.080694282631760e-09,  8.612704965391501e-12, -2.199272649418228e-14,  5.038209931881729e-17, -1.006205526264273e-19,
  1.413225663803451e-22, -6.277416785143009e-26, -1.151355590109458e-27,  2.903602698085468e-30,  8.040705652567597e-02, -3.879587412459972e-04,  1.368727782565673e-06,
 -4.134785974712587e-09,  1.107705836286157e-11, -2.624565677701266e-14,  5.208904622718306e-17, -7.398262925953598e-20, -2.033547420616357e-23,  5.472673383584083e-25,
 -3.221321025217607e-27,  7.290518752154071e-30,  1.071594611013676e-01, -5.141878768784850e-04,  1.787626459569880e-06, -5.242233136180798e-09,  1.328224991815057e-11,
 -2.823214729833738e-14,  4.294749360655361e-17, -7.819139205592134e-21, -2.976832251247585e-22,  1.401660366811076e-24, -5.505305905535527e-27,  9.987285696417479e-30,
  1.377986006950649e-01, -6.569307839190099e-04,  2.244288306703813e-06, -6.345065128608018e-09,  1.493568416895722e-11, -2.683328524472201e-14,  1.987058999442847e-17,
  1.016463908332516e-19, -6.699956241279746e-22,  2.306865733442442e-24, -7.021014695585394e-27,  7.223414037289712e-30,  1.723492278491457e-01, -8.154883305600970e-04,
  2.729041965371651e-06, -7.376191404554918e-09,  1.571877894128605e-11, -2.098049126806676e-14, -1.910574429696244e-17,  2.501479916254778e-19, -1.076800923228911e-21,
  2.922395165908270e-24, -6.419207679390008e-27, -4.912041847991798e-30,  2.108382266997518e-01, -9.890107071721603e-04,  3.230458930881838e-06, -8.259346028936977e-09,
  1.529747026575817e-11, -9.767139685714289e-15, -7.412776477566649e-17,  4.225111508904356e-19, -1.412042224373278e-21,  2.783090438733988e-24, -2.296033646546486e-27,
 -2.850539738860071e-29,  2.532940911690007e-01, -1.176469624333412e-03,  3.735143365408646e-06, -8.909270649411597e-09,  1.333721172588451e-11,  7.408228652304336e-15,
 -1.427329203113038e-16,  5.901792572681583e-19, -1.525491846524981e-21,  1.374977433469796e-24,  6.234438714628067e-27, -6.106771065422489e-29,  2.997462166286085e-01,
 -1.376623886327694e-03,  4.227493090377568e-06, -9.232294293436280e-09,  9.524092078867306e-12,  3.066158256497188e-14, -2.190023700308266e-16,  7.098038783322372e-19,
 -1.236204073286594e-21, -1.716439107142112e-24,  1.870393184358056e-26, -9.257839328269987e-29,  3.502239396906364e-01, -1.587976821234159e-03,  4.689434507110058e-06,
 -9.127541797902297e-09,  3.594165465304923e-12,  5.940178482041381e-14, -2.927421445514631e-16,  7.239442402183113e-19, -3.640668373344557e-22, -6.571771377258067e-24,
  3.228933685759207e-26, -1.036547847512609e-28,  4.047552368834572e-01, -1.808723669596395e-03,  5.100138742185799e-06, -8.489108102713057e-09, -4.626380129804995e-12,
  9.206735512442687e-14, -3.488538060627701e-16,  5.654208309559063e-19,  1.213777987146630e-21, -1.262091457413680e-23,  4.093805754392387e-26, -6.721363811917926e-29,
  4.633649596978434e-01, -2.036686582783260e-03,  5.435734158995315e-06, -7.209685582368745e-09, -1.516707057101291e-11,  1.258297787297977e-13, -3.671754738142977e-16,
  1.674667995148418e-19,  3.475964047873326e-21, -1.828719435104658e-23,  3.521784225004585e-26,  4.293052942358357e-29,  5.260724368444772e-01, -2.269234367280771e-03,
  5.669043585156471e-06, -5.186341805439334e-09, -2.784153526714469e-11,  1.562882511726027e-13, -3.232553541928462e-16, -5.176110929385521e-19,  6.139013433156476e-21,
 -2.071256757764052e-23,  3.911283523158030e-27,  2.327519833860312e-28,  5.928882087647610e-01, -2.503183567681746e-03,  5.769396487109238e-06, -2.329433151848299e-09,
 -4.215522185545724e-11,  1.772114993870112e-13, -1.907763811685029e-16, -1.488376762476657e-18,  8.522075308403072e-21, -1.581327170723306e-23, -6.120698512341339e-26,
  4.565023524760518e-28,  6.638095660972574e-01, -2.734677002554672e-03,  5.702602138263241e-06,  1.423980534998160e-09, -5.719086750364401e-11,  1.804359714818629e-13,
  5.332400486245974e-17, -2.650995134907869e-18,  9.437320716706647e-21,  8.993773065744851e-25, -1.559604134183626e-25,  5.800541820985096e-28,  7.388144308117468e-01,
 -2.959035664330386e-03,  5.431227813451673e-06,  6.090388486664503e-09, -7.147476618705332e-11,  1.561185700643794e-13,  4.196703276673564e-16, -3.764979007412118e-18,
  7.203210163063079e-21,  3.210554497654415e-23, -2.496622341535207e-25,  3.661732293775097e-28,  8.178529287575317e-01, -3.170580407972767e-03,  4.915418775160082e-06,
  1.161142385687553e-08, -8.283735416565348e-11,  9.368000091395351e-14,  8.917412639945011e-16, -4.390436973982927e-18, -3.710709045404919e-23,  7.443632814527555e-23,
 -2.709656716132121e-25, -4.565078958561445e-28,  9.008357311607442e-01, -3.362421969807699e-03,  4.114642604256836e-06,  1.781415566152019e-08, -8.830313691739246e-11,
 -1.603258036859767e-14,  1.404913596005817e-15, -3.870839415615314e-18, -1.340931888625941e-20,  1.122670398124747e-22, -1.091435826386245e-25, -1.943022491406082e-27,
  9.876178575312804e-01, -3.526223309373042e-03,  2.990963494898218e-06,  2.435780255991097e-08, -8.408586549101784e-11, -1.766197823639648e-13,  1.821418441203102e-15,
 -1.423706921515380e-18, -3.150060212089819e-20,  1.120712773136532e-22,  3.359751638240580e-25, -3.432453818588171e-27,  1.077976093340214e+00, -3.651950358621963e-03,
  1.514777679539195e-06,  3.066685169091973e-08, -6.583676717371134e-11, -3.792072261031541e-13,  1.910917613002337e-15,  3.534852511101541e-18, -4.764388231447574e-20,
  2.561076138711905e-23,  1.009109057537648e-24, -3.009836967097016e-27,  1.171577443039065e+00, -3.727652133991424e-03, -3.256254797761580e-07,  3.585726055018185e-08,
 -2.940666157934689e-11, -5.923653274118064e-13,  1.362349655500071e-15,  1.067194967740850e-17, -4.751759435031683e-20, -1.807535233697775e-22,  1.455208327668394e-24,
  2.058568558318405e-27,  1.267935101323755e+00, -3.739359780618096e-03, -2.508849173594001e-06,  3.867847756304057e-08,  2.747528817363453e-11, -7.505949670296593e-13,
 -1.208024151118494e-16,  1.758251771670665e-17, -1.128095555715170e-20, -4.503559262508501e-22,  6.870532670954009e-25,  1.179027773627391e-26,  1.366347377929053e+00,
 -3.671284733058282e-03, -4.957530173330129e-06,  3.752759998498488e-08,  1.021312693159276e-10, -7.487782210746538e-13, -2.564483891448133e-15,  1.874045291646754e-17,
  7.114662951771241e-20, -5.327944645586216e-22, -2.140313058787887e-24,  1.610246032930149e-26,  1.465814246455382e+00, -3.506655087070576e-03, -7.506942453952103e-06,
  3.065226028805522e-08,  1.823348670481778e-10, -4.614692526023591e-13, -5.267199959727798e-15,  6.599713191319098e-18,  1.644268972264690e-19, -1.925353307931288e-23,
 -5.380926819344003e-24, -5.630691297623834e-27,  1.564926824024175e+00, -3.229781053947013e-03, -9.868852392918571e-06,  1.674054531412864e-08,  2.416191955828268e-10,
  1.799258497258592e-13, -6.367101669733715e-15, -2.122853777903108e-17,  1.551953735732319e-19,  1.109337114434222e-21, -2.779617340635379e-24, -4.782029604196320e-26,
  1.661729798019767e+00, -2.830261524136717e-03, -1.160715360768036e-05, -3.873471390915166e-09,  2.400218797604378e-10,  1.028756096310778e-12, -3.346374696457835e-15,
 -4.770076960123001e-17, -7.248781985280757e-20,  1.485774443551968e-21,  8.872960623430856e-24, -2.300936310977028e-26,  1.753571019313922e+00, -2.310421806713315e-03,
 -1.216787877205288e-05, -2.743866850511057e-08,  1.419436866070746e-10,  1.569788184330822e-12,  4.050627504743449e-15, -3.362481179439926e-17, -3.505670382995865e-19,
 -7.039240014955946e-22,  1.048558081673459e-23,  9.317213209581430e-26,  1.836984635302570e+00, -1.696408585782096e-03, -1.104038496324435e-05, -4.559354273446984e-08,
 -3.922429049064387e-11,  1.121150285309862e-12,  9.645686914889696e-15,  3.015934456455496e-17, -1.598577396435670e-19, -2.544084305125351e-21, -1.315802688688421e-23,
  1.038869561751391e-26,  1.907709997208936e+00, -1.050424422667370e-03, -8.119750420529406e-06, -4.785500977211143e-08, -1.980502665626845e-10, -2.451585134586642e-13,
  4.847897295673105e-15,  5.519785643689623e-17,  3.287060895985843e-19,  8.017392853047582e-22, -6.984138419632479e-24, -1.078409399820950e-25,  1.961009054170346e+00,
 -4.752309728735538e-04, -4.170096825624216e-06, -3.073551934487442e-08, -1.959924369967531e-10, -1.059324410598489e-12, -4.387833328798020e-15, -7.529289284003919e-18,
  9.372917576587157e-20,  1.381910757701341e-21,  1.176121976108124e-23,  7.411329657155185e-26,  1.992433929096272e+00, -9.605953688255811e-05, -9.076642690574186e-07,
 -7.547028317665420e-09, -5.808931352905931e-11, -4.225747134267016e-13, -2.931814106942252e-15, -1.945651947752212e-17, -1.233170404203779e-19, -7.417928583219392e-22,
 -4.177940518369535e-24, -2.141278797627961e-26,  };
  constexpr double w[13440] = {  8.843164921144533e-02, -3.322679351798259e-04,  1.319145852258457e-06, -5.449817071116689e-09,  2.308332322810035e-11,
 -9.909444530010226e-14,  4.277850963841704e-16, -1.848143999723799e-18,  7.968240729436222e-21, -3.423487214730246e-23,  1.464682693050645e-25, -6.238413081610476e-28,
  8.792289530538626e-02, -4.962475809982721e-04,  3.251882879109601e-06, -2.116689333454370e-08,  1.329703064435082e-10, -8.074265384153446e-13,  4.765161411647583e-15,
 -2.746025865717421e-17,  1.550607948847126e-19, -8.602194697141871e-22,  4.697924298357113e-24, -2.529767847603363e-26,  8.691775870484607e-02, -8.173633701841819e-04,
  7.933258006116299e-06, -6.998062147054320e-08,  5.733436151217325e-10, -4.443791847321860e-12,  3.295753180613333e-14, -2.356776624296189e-16,  1.633837542469904e-18,
 -1.102566917001900e-20,  7.265930201313624e-23, -4.687655571839218e-25,  8.544033114197291e-02, -1.282351131982188e-03,  1.689147352671237e-05, -1.922128945156624e-07,
  1.981637988385251e-09, -1.898254935008672e-11,  1.715555326163299e-13, -1.477873741306858e-15,  1.222500376702313e-17, -9.764061166558352e-20,  7.561879473549108e-22,
 -5.697577566928231e-24,  8.352517815341542e-02, -1.872332912298129e-03,  3.217296463414185e-05, -4.605366544203485e-07,  5.838531362563382e-09, -6.763835129429341e-11,
  7.298218158635857e-13, -7.428882149397628e-15,  7.198827671600510e-17, -6.686063719838409e-19,  5.982916275422266e-21, -5.179050161073837e-23,  8.121559916675999e-02,
 -2.563935219219526e-03,  5.608213269469673e-05, -9.901943912980346e-07,  1.516369273259504e-08, -2.090066795951810e-10,  2.651966960126504e-12, -3.144474924237561e-14,
  3.521475868914050e-16, -3.754321225648507e-18,  3.833610985974383e-20, -3.767061093688313e-22,  7.856153338918294e-02, -3.330620990840819e-03,  9.088667121763667e-05,
 -1.946370575923872e-06,  3.547946276449078e-08, -5.741808413019513e-10,  8.463257107853526e-12, -1.155647177808014e-13,  1.479592672708757e-15, -1.792126327842538e-17,
  2.067693431314537e-19, -2.284559593298635e-21,  7.561727103332461e-02, -4.144124313643798e-03,  1.385232082238565e-04, -3.545280582562345e-06,  7.595655956439448e-08,
 -1.427047448027990e-09,  2.418271518288957e-11, -3.766222910990333e-13,  5.462747469431810e-15, -7.452503315578682e-17,  9.635405056778308e-19, -1.187561800928880e-20,
  7.243913296979571e-02, -4.975876078075809e-03,  2.003361608363670e-04, -6.046541605066867e-06,  1.505488819357112e-07, -3.250865261739402e-09,  6.275923174233335e-11,
 -1.105388511081840e-12,  1.802009436555085e-14, -2.748172465291605e-16,  3.953163895193892e-18, -5.397724230840012e-20,  6.908326947040865e-02, -5.798319492816228e-03,
  2.768767152586807e-04, -9.735954104319447e-06,  2.788293904391154e-07, -6.857425377926008e-09,  1.495786491903460e-10, -2.956881863356968e-12,  5.379188322426209e-14,
 -9.109091774094165e-16,  1.448527927855624e-17, -2.177755305883155e-19,  6.560370328953813e-02, -6.586034281977450e-03,  3.677799207788888e-04, -1.489961023998510e-05,
  4.861922103128779e-07, -1.350504855297327e-08,  3.303249802624100e-10, -7.277752695778406e-12,  1.467868111016327e-13, -2.743129055567865e-15,  4.794172750817740e-17,
 -7.892043840497034e-19,  6.205070824518541e-02, -7.316614085516257e-03,  4.717275695137106e-04, -2.179189442883353e-05,  8.031137482862491e-07, -2.500041583116102e-08,
  6.808701300575339e-10, -1.661073778246660e-11,  3.691934440147882e-13, -7.570726899627358e-15,  1.446349101890608e-16, -2.593596511333752e-18,  5.846957656807057e-02,
 -7.971269360339463e-03,  5.864944066773322e-04, -3.060113888737574e-05,  1.263275052181220e-06, -4.375004154843728e-08,  1.317922101756058e-09, -3.538604599955076e-11,
  8.617902761954718e-13, -1.928795203582335e-14,  4.007645948709965e-16, -7.790662424717705e-18,  5.489979121531863e-02, -8.535154487674770e-03,  7.090666241902981e-04,
 -4.141724538192813e-05,  1.900524280518564e-06, -7.272377525083890e-08,  2.408037971327510e-09, -7.074815264851479e-11,  1.877804058600328e-12, -4.563902475534876e-14,
  1.026419974475679e-15, -2.153188013796261e-17,  5.137458687593978e-02, -8.997440106602814e-03,  8.358154536584298e-04, -5.420542714849115e-05,  2.744869028481075e-06,
 -1.152979550377808e-07,  4.171611080687918e-09, -1.333764233578586e-10,  3.838416348798037e-12, -1.008192622686826e-13,  2.443053129803063e-15, -5.506435564528062e-17,
  4.792085808518019e-02, -9.351168182163484e-03,  9.627054081474710e-04, -6.878944205535026e-05,  3.817890601705343e-06, -1.749607195019137e-07,  6.877966419722707e-09,
 -2.380561548681781e-10,  7.391934311673425e-12, -2.088556984022671e-13,  5.429168073177694e-15, -1.309296693409509e-16,  4.455935593079512e-02, -9.592937298288830e-03,
  1.085516258671049e-03, -8.484646203253969e-05,  5.128124318093496e-06, -2.548849999096973e-07,  1.082811038440977e-08, -4.036744532183433e-10,  1.346068453785388e-11,
 -4.073047024467557e-13,  1.131021270936966e-14, -2.906662498838310e-16,  4.130510626473445e-02, -9.722469392917380e-03,  1.200059724122843e-03, -1.019142899524050e-04,
  6.667020490149071e-06, -3.574019581860458e-07,  1.632318259708503e-08, -6.522925957468456e-10,  2.325205325418285e-11, -7.502593654064808e-13,  2.216433549829276e-14,
 -6.046526234476134e-16,  3.816798115929732e-02, -9.742107573056848e-03,  1.302375421972662e-03, -1.194102300987631e-04,  8.406075957641844e-06, -4.834336664041539e-07,
  2.361917704691716e-08, -1.007018897299377e-09,  3.820601746432592e-11, -1.309099280306866e-12,  4.098158451968541e-14, -1.182292384903721e-15,  3.515335998884504e-02,
 -9.656289117832659e-03,  1.388895109920880e-03, -1.366597375402441e-04,  1.029561079759552e-05, -6.319629488838511e-07,  3.287165739100466e-08, -1.488590582132037e-09,
  5.985452879224497e-11, -2.169073490812615e-12,  7.167894624529591e-14, -2.178780810556015e-15,  3.226282513902669e-02, -9.471029784630373e-03,  1.456568933845281e-03,
 -1.529321432321808e-04,  1.226548015208057e-05, -7.996259572451085e-07,  4.407735458515828e-08, -2.110855871165391e-09,  8.958072675852433e-11, -3.419964679365225e-12,
  1.188531832512759e-13, -3.792782060746073e-15,  2.949484814460844e-02, -9.193446469069480e-03,  1.502951712635655e-03, -1.674803280624959e-04,  1.422778830549591e-05,
 -9.805068310571265e-07,  5.702195855236628e-08, -2.875679732919314e-09,  1.282882086617620e-10, -5.139962446947084e-12,  1.871671860388410e-13, -6.248498681311753e-15,
  2.684543348127600e-02, -8.831336279215478e-03,  1.526250848764324e-03, -1.795811845096747e-04,  1.608144576321356e-05, -1.166194000694593e-06,  7.124442376515748e-08,
 -3.768102084613906e-09,  1.760191254484211e-10, -7.373514608175117e-12,  2.803288949285161e-13, -9.757023843708259e-15,  2.430869809746504e-02, -8.392821993382068e-03,
  1.525340057125702e-03, -1.885739923611892e-04,  1.771821136128165e-05, -1.346127144738035e-06,  8.602727128579945e-08, -4.752768922626430e-09,  2.315880959466496e-10,
 -1.010608501967101e-11,  3.997364069603924e-13, -1.445636530662655e-14,  2.187737427889379e-02, -7.886067175865650e-03,  1.499744720602784e-03, -1.938943492545390e-04,
  1.902971353103583e-05, -1.508227219662164e-06,  1.004196214242892e-07, -5.772661163569203e-09,  2.923183125618376e-10, -1.324088877485635e-11,  5.430090116510874e-13,
 -2.033694344749176e-14,  1.954323117040943e-02, -7.319059132922985e-03,  1.449605398131246e-03, -1.951019339034572e-04,  1.991486048885930e-05, -1.639764910864828e-06,
  1.132953629974463e-07, -6.750924591654405e-09,  3.539686647478940e-10, -1.658407837958658e-11,  7.027600720486726e-13, -2.716806243584548e-14,  1.729741611997034e-02,
 -6.699454384351829e-03,  1.375625994277810e-03, -1.919010449016496e-04,  2.028703060479570e-05, -1.728390719095068e-06,  1.234436255143192e-07, -7.596169146815728e-09,
  4.109212637066696e-10, -1.984482180480637e-11,  8.660397214493028e-13, -3.444784497856742e-14,  1.513072106341341e-02, -6.034479235200042e-03,  1.279012545619303e-03,
 -1.841534759127345e-04,  2.008047511505332e-05, -1.763227055406568e-06,  1.296834420744923e-07, -8.211021374916923e-09,  4.566576934784246e-10, -2.265483392803944e-11,
  1.014834519203658e-12, -4.140088423759155e-14,  1.303378168814523e-02, -5.330877108219218e-03,  1.161407685025872e-03, -1.718838086303801e-04,  1.925545336536656e-05,
 -1.735911916526135e-06,  1.309900794319518e-07, -8.503086259691022e-09,  4.844959757162903e-10, -2.460828312381464e-11,  1.127835397425833e-12, -4.704173862355736e-14,
  1.099721845279651e-02, -4.594894277727029e-03,  1.024824786372367e-03, -1.552776030702116e-04,  1.780174076555733e-05, -1.641485876211426e-06,  1.266177381757482e-07,
 -8.396929567192351e-09,  4.885000855108213e-10, -2.531825588411058e-11,  1.183394980182062e-12, -5.030803302048118e-14,  9.011729216826851e-03, -3.832296343731179e-03,
  8.715847251772109e-04, -1.346732391419240e-04,  1.574028657768348e-05, -1.479028495656497e-06,  1.162026936856941e-07, -7.845347384005301e-09,  4.644239718081373e-10,
 -2.448125231675840e-11,  1.163256568045274e-12, -5.024714950362393e-14,  7.068144554192584e-03, -3.048409407058994e-03,  7.042573167111059e-04, -1.105483421487082e-04,
  1.312294099455846e-05, -1.251974853624955e-06,  9.983262801445712e-08, -6.838130868608479e-09,  4.105256525987985e-10, -2.193781876370413e-11,  1.056346683265603e-12,
 -4.622093376891405e-14,  5.157465788584975e-03, -2.248185235609723e-03,  5.256095781851025e-04, -8.350194292693289e-05,  1.003032189853530e-05, -9.680759918626714e-07,
  7.807180097107376e-08, -5.406800244830722e-09,  3.280932875222917e-10, -1.771654041560943e-11,  8.617811349920321e-13, -3.808039041814473e-14,  3.270992351819810e-03,
 -1.436329392924337e-03,  3.385713371091983e-04, -5.423498359396146e-05,  6.568187254094581e-06, -6.390191671346257e-07,  5.193845621415180e-08, -3.624423645708607e-09,
  2.215708668118343e-10, -1.205104287954384e-11,  5.903210892969325e-13, -2.626314527400345e-14,  1.402465503569710e-03, -6.183362022264692e-04,  1.464186874228258e-04,
 -2.356243341785879e-05,  2.866516428024792e-06, -2.801241567332115e-07,  2.286691593609373e-08, -1.602476334237361e-09,  9.836743090449598e-11, -5.371574604214632e-12,
  2.641536869191155e-13, -1.179657018360855e-14,  8.712327828813687e-02, -3.219702280019101e-04,  1.255900404208226e-06, -5.095798269095847e-09,  2.120005537572824e-11,
 -8.942086586401446e-14,  3.794293183896574e-16, -1.611800383803177e-18,  6.834952810030376e-21, -2.888973339911068e-23,  1.216187732254585e-25, -5.097758409282116e-28,
  8.598837591539901e-02, -4.712135490981382e-04,  3.010131844252776e-06, -1.916259459527734e-08,  1.179059154529415e-10, -7.017559811722692e-13,  4.061332397530990e-15,
 -2.295960033436567e-17,  1.272235203055650e-19, -6.927884146178906e-22,  3.714753823106058e-24, -1.964415656994625e-26,  8.377013042220118e-02, -7.571069125730345e-04,
  7.145731961073599e-06, -6.147729557076586e-08,  4.918721156354348e-10, -3.726438479914185e-12,  2.703462280256610e-14, -1.892226860840109e-16,  1.284615100943012e-18,
 -8.493102387417258e-21,  5.485463149057685e-23, -3.469633350208067e-25,  8.056730666780210e-02, -1.155934023987560e-03,  1.476331559267403e-05, -1.633334998689957e-07,
  1.640023912699934e-09, -1.532062725401754e-11,  1.351623836439821e-13, -1.137533959810388e-15,  9.198980552041722e-18, -7.186708418145015e-20,  5.446924303542706e-22,
 -4.018123357827094e-24,  7.651772698349710e-02, -1.635563834390255e-03,  2.716528269079473e-05, -3.770569103127467e-07,  4.645329484117004e-09, -5.237911564661537e-11,
  5.507505469393211e-13, -5.468301306824870e-15,  5.172840413309579e-17, -4.693238255742887e-19,  4.104949545000672e-21, -3.475099449542011e-23,  7.178734824213805e-02,
 -2.158979585125280e-03,  4.552800591751529e-05, -7.778361575636437e-07,  1.155480161144716e-08, -1.547665956921996e-10,  1.910893798539657e-12, -2.207219172769119e-14,
  2.410179088857499e-16, -2.507402542197945e-18,  2.500148757234478e-20, -2.400437606152239e-22,  6.655786955296905e-02, -2.688109145059347e-03,  7.059025222191451e-05,
 -1.460543049132739e-06,  2.579024099217317e-08, -4.050857871342895e-10,  5.803647689162533e-12, -7.712198691726339e-14,  9.618871836066131e-16, -1.135944209053237e-17,
  1.278824541981840e-19, -1.379617596049331e-21,  6.101424927292164e-02, -3.187432627909951e-03,  1.024229618636856e-04, -2.530028343963655e-06,  5.245774400921552e-08,
 -9.556904180149134e-10,  1.572892014165992e-11, -2.382169084749483e-13,  3.363728814093074e-15, -4.471582386214461e-17,  5.638122347709801e-19, -6.781814393372916e-21,
  5.533337739585496e-02, -3.626928971644314e-03,  1.403237114060465e-04, -4.085518084894722e-06,  9.838837127205453e-08, -2.059048947092990e-09,  3.858737770082444e-11,
 -6.606335690656580e-13,  1.048026248339166e-14, -1.556878428815559e-16,  2.183367442958639e-18, -2.908725326231892e-20,  4.967485600487331e-02, -3.984072808441321e-03,
  1.828495426998259e-04, -6.201823565133317e-06,  1.717634283062881e-07, -4.093260920810614e-09,  8.665525561485155e-11, -1.664801811562944e-12,  2.946801919139853e-14,
 -4.860191145562115e-16,  7.534207152828431e-18, -1.105106646238362e-19,  4.417445585706189e-02, -4.244769974492717e-03,  2.279723786153544e-04, -8.911384532060993e-06,
  2.812625165188974e-07, -7.571316178010727e-09,  1.797536112819413e-10, -3.849267006362109e-12,  7.554689640220367e-14, -1.375205988777837e-15,  2.343266107827422e-17,
 -3.763947581621768e-19,  3.894041712217342e-02, -4.403287480195457e-03,  2.733188943314325e-04, -1.219127517256280e-05,  4.348013287359386e-07, -1.312256185087476e-08,
  3.470249210727982e-10, -8.231551148074179e-12,  1.780907244287802e-13, -3.558444486584444e-15,  6.630184670046026e-17, -1.160504752417035e-18,  3.405241229230684e-02,
 -4.461362922394385e-03,  3.164455566598374e-04, -1.595823370602973e-05,  6.380576774936084e-07, -2.143899218493988e-08,  6.275033826714172e-10, -1.639117954486816e-11,
  3.887914429488427e-13, -8.483408360187596e-15,  1.720013741845303e-16, -3.265388768915647e-18,  2.956273321328685e-02, -4.426753533185937e-03,  3.551002147674243e-04,
 -2.007292446048514e-05,  8.930723552212637e-07, -3.318698717903738e-08,  1.068642088365718e-09, -3.056939174276270e-11,  7.908442053616247e-13, -1.875272359568259e-14,
  4.118312635875232e-16, -8.442966361041040e-18,  2.549912023541860e-02, -4.311504568435540e-03,  3.874317904195585e-04, -2.435259769763328e-05,  1.197224340618815e-06,
 -4.889487901254640e-08,  1.722230147009199e-09, -5.366688396987535e-11,  1.506822291517686e-12, -3.864881669908577e-14,  9.153196155808378e-16, -2.017898780483870e-17,
  2.186861450575511e-02, -4.130189933036666e-03,  4.121251950435457e-04, -2.858964576224225e-05,  1.542812120400695e-06, -6.883511296860494e-08,  2.637684712436779e-09,
 -8.908318292462136e-11,  2.701739887106401e-12, -7.462410689093002e-14,  1.897841862319575e-15, -4.481116778087770e-17,  1.866186277647896e-02, -3.898320656097203e-03,
  4.284551895611313e-04, -3.257263841761305e-05,  1.917345854314008e-06, -9.292390720583753e-08,  3.853407910263399e-09, -1.403642393971490e-10,  4.577320209802349e-12,
 -1.355614540658170e-13,  3.687109909959939e-15, -9.287929509639614e-17,  1.585740806716587e-02, -3.631046388762947e-03,  4.362669299061988e-04, -3.610636067784204e-05,
  2.304507155297788e-06, -1.206596725841445e-07,  5.387547318967304e-09, -2.106667831420164e-10,  7.354227422628540e-12, -2.325608015959841e-13,  6.738019436876703e-15,
 -1.803960776037787e-16,  1.342562900516081e-02, -3.342206383588890e-03,  4.359003054180420e-04, -3.902803517857662e-05,  2.685605076741988e-06, -1.511144014701569e-07,
  7.229877346081771e-09, -3.020992028270675e-10,  1.124118670850115e-11, -3.780253061595817e-13,  1.162207865069500e-14, -3.294858908745578e-16,  1.133212067086587e-02,
 -3.043729642268139e-03,  4.280793310538959e-04, -4.121800021361050e-05,  3.041278318199270e-06, -1.829818218322866e-07,  9.336491444940228e-09, -4.150442884578584e-10,
  1.639319359134801e-11, -5.839279839577478e-13,  1.897793007387904e-14, -5.676632423677627e-16,  9.540423088906994e-03, -2.745344102653348e-03,  4.137874745342033e-04,
 -4.260430919291708e-05,  3.353176487146812e-06, -2.146752426905655e-07,  1.162855323861129e-08, -5.475942204860721e-10,  2.286458359872033e-11, -8.593328547672791e-13,
  2.941507107175496e-14, -9.250410033367668e-16,  8.014091052143823e-03, -2.454532426768887e-03,  3.941462639116293e-04, -4.316174870279846e-05,  3.605391350723913e-06,
 -2.444594265845601e-07,  1.399561671496085e-08, -6.952234052179121e-10,  3.056551785912343e-11, -1.207482068069743e-12,  4.337394519178425e-14, -1.429073861901778e-15,
  6.718158480670045e-03, -2.176664639754875e-03,  3.703093886280297e-04, -4.290647893481386e-05,  3.785483846164556e-06, -2.705962815842134e-07,  1.630318997235388e-08,
 -8.507898061277186e-10,  3.923147749346848e-11, -1.622975057127491e-12,  6.096006353926407e-14, -2.097070811994449e-15,  5.620084479365358e-03, -1.915241509574397e-03,
  3.433791323677913e-04, -4.188783488766172e-05,  3.885041089267103e-06, -2.914841204100355e-07,  1.840349186884241e-08, -1.004898885210220e-09,  4.841415881639628e-11,
 -2.089684734367572e-12,  8.178370233476769e-14, -2.927536989054157e-15,  4.690281739407419e-03, -1.672192833284938e-03,  3.143473043559809e-04, -4.017883273541972e-05,
  3.899779090078165e-06, -3.057739520686257e-07,  2.014789147628296e-08, -1.146600419419323e-09,  5.749888257974097e-11, -2.580027434802825e-12,  1.048451996019643e-13,
 -3.892192071122982e-15,  3.902326837446171e-03, -1.448187962534888e-03,  2.840593624733393e-04, -3.786669835487979e-05,  3.829267556458775e-06, -3.124522807527311e-07,
  2.139939250286545e-08, -1.264332431840283e-09,  6.574902598187877e-11, -3.056016682581518e-12,  1.285050452087434e-13, -4.930966167997084e-15,  3.232941853978437e-03,
 -1.242929191297610e-03,  2.531982616380565e-04, -3.504438376051905e-05,  3.676387352826371e-06, -3.108865267718971e-07,  2.204370385806976e-08, -1.346989807038590e-09,
  7.237314220295220e-11, -3.472220670964901e-12,  1.505663761519514e-13, -5.952150938216834e-15,  2.661822067439978e-03, -1.055410320566906e-03,  2.222835704885914e-04,
 -3.180365832916274e-05,  3.446640132996594e-06, -3.008350558816186e-07,  2.199783227076728e-08, -1.384983130203487e-09,  7.660642747280333e-11, -3.780379457001339e-12,
  1.684768740258873e-13, -6.839092370924068e-15,  2.171368549022469e-03, -8.841319862994425e-04,  1.916813014632970e-04, -2.823002356248729e-05,  3.147419094662552e-06,
 -2.824280232777742e-07,  2.121562371885608e-08, -1.371164641480128e-09,  7.779580625641154e-11, -3.935103605441733e-12,  1.796319256472439e-13, -7.463468588264912e-15,
  1.746369382988745e-03, -7.272720293297341e-04,  1.616203850174506e-04, -2.439944019691786e-05,  2.787327213230203e-06, -2.561274877954354e-07,  1.969015477024060e-08,
 -1.301526758684162e-09,  7.547744679506567e-11, -3.899844392167598e-12,  1.817372454151783e-13, -7.703607701726907e-15,  1.373660130943056e-03, -5.828135614623235e-04,
  1.322125144463480e-04, -2.037668610931588e-05,  2.375601900277845e-06, -2.226756761610344e-07,  1.745325151516013e-08, -1.175615929048251e-09,  6.943685112114372e-11,
 -3.652241642360518e-12,  1.731727260037501e-13, -7.464878974261088e-15,  1.041783628197593e-03, -4.486359558376770e-04,  1.034729970227870e-04, -1.621507756856466e-05,
  1.921678590760515e-06, -1.830393298987813e-07,  1.457265380114070e-08, -9.966425430547198e-10,  5.974432218174154e-11, -3.188028782075106e-12,  1.532940848696021e-13,
 -6.698331448421951e-15,  7.406621793277229e-04, -3.225756842016509e-04,  7.534122866263033e-05, -1.195728324321229e-05,  1.434905636226475e-06, -1.383564700502096e-07,
  1.114745817970030e-08, -7.713012088325936e-10,  4.676204242609980e-11, -2.522886658244880e-12,  1.226163910646104e-13, -5.413728447536998e-15,  4.613011620435207e-04,
 -2.024694949941134e-04,  4.770140235368371e-05, -7.637182837870363e-06,  9.244304727805604e-07, -8.989212203849597e-08,  7.302648212003395e-09, -5.093527832975161e-10,
  3.112329740483418e-11, -1.691981404664531e-12,  8.284417329888712e-14, -3.684073547390415e-15,  1.957921581198690e-04, -8.630401428127628e-05,  2.043115481855253e-05,
 -3.287036190223232e-06,  3.997855356194216e-07, -3.905824254617605e-08,  3.187577544892227e-09, -2.233250773159595e-10,  1.370539751468243e-11, -7.482351498514681e-13,
  3.678672262005769e-14, -1.642442307076355e-15,  8.585511246750845e-02, -3.121619894497056e-04,  1.196728574351163e-06, -4.770424857462079e-09,  1.949916930407541e-11,
 -8.083234043668220e-14,  3.372110636093189e-16, -1.408825623184801e-18,  5.877344261219928e-21, -2.444509943213334e-23,  1.012816702153023e-25, -4.178852828724547e-28,
  8.415027138293607e-02, -4.480212617897122e-04,  2.791053095188122e-06, -1.738329551169636e-08,  1.047957265969665e-10, -6.115604490241065e-13,  3.471905431751009e-15,
 -1.926042371003989e-17,  1.047619567676072e-19, -5.601289173245888e-22,  2.949660986755222e-24, -1.532227856725671e-26,  8.085154389793117e-02, -7.027636216216842e-04,
  6.452874153689122e-06, -5.417004003236282e-08,  4.234253593443188e-10, -3.136809268384580e-12,  2.226878526820207e-14, -1.526116877944876e-16,  1.014939539095091e-18,
 -6.576105844026678e-21,  4.163992514950713e-23, -2.582947060621188e-25,  7.616797072166186e-02, -1.045243614429208e-03,  1.295118698892741e-05, -1.393784259569385e-07,
  1.363632699947149e-09, -1.242792632339379e-11,  1.070717221566647e-13, -8.806798249402037e-16,  6.964795056293656e-18, -5.324175123772343e-20,  3.950343389225069e-22,
 -2.853988580000073e-24,  7.038314426054984e-02, -1.435151970684588e-03,  2.305417299618731e-05, -3.104430007095003e-07,  3.718429547679396e-09, -4.082595027603779e-11,
  4.184821846856280e-13, -4.054398346422611e-15,  3.745364253655755e-17, -3.320608936598780e-19,  2.839779793582329e-21, -2.351794375569591e-23,  6.382490853264738e-02,
 -1.829168806495685e-03,  3.720862004549501e-05, -6.154256334215441e-07,  8.872198265269457e-09, -1.155268646876499e-10,  1.388543453914225e-12, -1.562978924647274e-14,
  1.664682790781815e-16, -1.690495110448491e-18,  1.646469698671922e-20, -1.545022832309978e-22,  5.683302517322144e-02, -2.187048216742058e-03,  5.529489139490209e-05,
 -1.105821101882293e-06,  1.892298000935715e-08, -2.885783414426794e-10,  4.020086270323361e-12, -5.200502154071233e-14,  6.320557482837992e-16, -7.279851046274146e-18,
  7.998969937925601e-20, -8.428071864250917e-22,  4.972938768335130e-02, -2.476551613286152e-03,  7.652854004031189e-05, -1.825171017127377e-06,  3.663567348758482e-08,
 -6.474191046155820e-10,  1.035174530336452e-11, -1.525049059719086e-13,  2.096970402896208e-15, -2.717015028436703e-17,  3.341757759884434e-19, -3.923827914597410e-21,
  4.279437309631930e-02, -2.676514022294512e-03,  9.953112203193850e-05, -2.796102325261599e-06,  6.514593550628595e-08, -1.321660980859505e-09,  2.404928700411448e-11,
 -4.003076449099289e-13,  6.181126990279054e-15, -8.946092631546806e-17,  1.223374138752445e-18, -1.590459653312433e-20,  3.625141046102674e-02, -2.777803519522078e-03,
  1.225423248141901e-04, -4.009652194586721e-06,  1.074086736663145e-07, -2.480652808576477e-09,  5.097752879370176e-11, -9.519568854635372e-13,  1.639741974033651e-14,
 -2.634404841243775e-16,  3.981584022544505e-18, -5.698489454607282e-20,  3.026021876455480e-02, -2.782383354558837e-03,  1.437097190754205e-04, -5.420454541316807e-06,
  1.654858321022283e-07, -4.317403968985812e-09,  9.949998323892983e-11, -2.071100048102749e-12,  3.955673831133040e-14, -7.014450346246082e-16,  1.165364601864804e-17,
 -1.826649328736005e-19,  2.491777818938078e-02, -2.701004638447211e-03,  1.613802540570948e-04, -6.949675826216202e-06,  2.398522482427930e-07, -7.018060949114182e-09,
  1.802094625772716e-10, -4.156149799521415e-12,  8.752713869688348e-14, -1.704097386941951e-15,  3.096611244989288e-17, -5.290488551371995e-19,  2.026517532901675e-02,
 -2.550196311898265e-03,  1.743286082503964e-04, -8.495233526744562e-06,  3.289245660858053e-07, -1.072134172870029e-08,  3.048696707582334e-10, -7.746731548723566e-12,
  1.789466829997065e-13, -3.806363842808880e-15,  7.530003855284058e-17, -1.395987417736778e-18,  1.629807595338676e-02, -2.349187761955072e-03,  1.818838566789705e-04,
 -9.946747007262661e-06,  4.289701758541277e-07, -1.547706955560402e-08,  4.845559177676665e-10, -1.349341983214799e-11,  3.401899659672595e-13, -7.868874084509985e-15,
  1.687201834756545e-16, -3.379845269190057e-18,  1.297866360707334e-02, -2.117248226741066e-03,  1.839467304242598e-04, -1.120156797410818e-05,  5.344478135317725e-07,
 -2.121503294656449e-08,  7.272650753037703e-10, -2.208172936356775e-11,  6.047333717086959e-13, -1.514324965915795e-14,  3.504334606486957e-16, -7.554874078315869e-18,
  1.024729118205835e-02, -1.871722513363393e-03,  1.809154294184621e-04, -1.217834960971615e-05,  6.387095959225934e-07, -2.773367906212060e-08,  1.035512101711446e-09,
 -3.411411653547666e-11,  1.010212049705295e-12, -2.726868470809063e-14,  6.782870569252913e-16, -1.567618787891956e-17,  8.032654182394064e-03, -1.626844603977481e-03,
  1.735529591049020e-04, -1.282569887164305e-05,  7.349003308614332e-07, -3.471309772630901e-08,  1.404532916083935e-09, -4.996897771174332e-11,  1.592972966927568e-12,
 -4.615816355555786e-14,  1.229267825506778e-15, -3.034197163622508e-17,  6.259860346747053e-03, -1.393259205497650e-03,  1.628323748107569e-04, -1.312499514973520e-05,
  8.168527403184938e-07, -4.175022882411525e-08,  1.821615010427130e-09, -6.966739725878925e-11,  2.380697599138364e-12, -7.375200133831948e-14,  2.094839513904482e-15,
 -5.502052750982666e-17,  4.856241032334782e-03, -1.178092119327149e-03,  1.497907048883833e-04, -1.308790570596329e-05,  8.798008251118643e-07, -4.840855937313539e-08,
  2.266804443610579e-09, -9.278148742527291e-11,  3.384437548237728e-12, -1.116521525979604e-13,  3.369685828232723e-15, -9.383814556718800e-17,  3.755079170735998e-03,
 -9.853797998854625e-04,  1.354118542689146e-04, -1.275010819895326e-05,  9.208004451853395e-07, -5.427155453664858e-08,  2.714886786090712e-09, -1.184106075589541e-10,
  4.591870644787023e-12, -1.606928180539479e-13,  5.134046935376228e-15, -1.510537030823022e-16,  2.897614184540708e-03, -8.166814096913831e-04,  1.205474910908221e-04,
 -1.216311106085456e-05,  9.388283081761635e-07, -5.898929886263577e-08,  3.138230677802861e-09, -1.452358100238019e-10,  5.963530519843235e-12, -2.205360447188992e-13,
  7.431959925527602e-15, -2.302198077045953e-16,  2.233750878538832e-03, -6.717343062900612e-04,  1.058756072442666e-04, -1.138592154725764e-05,  9.346018695247338e-07,
 -6.231072196424926e-08,  3.509909730903103e-09, -1.716439488514521e-10,  7.433170870847222e-12, -2.893914354695210e-13,  1.024963013692565e-14, -3.331330761503017e-16,
  1.721883264058021e-03, -5.490596755910616e-04,  9.189041925323852e-05, -1.047784415512765e-05,  9.102071502719280e-07, -6.409802282951145e-08,  3.806516447633139e-09,
 -1.958971541545877e-10,  8.912482777610680e-12, -3.639407463671459e-13,  1.349911594108600e-14, -4.587752929448749e-16,  1.328181345055787e-03, -4.464674744837690e-04,
  7.891457229671545e-05, -9.493113501888195e-06,  8.686353885715183e-07, -6.432405880642997e-08,  4.010224244338117e-09, -2.163152480154576e-10,  1.029939590349600e-11,
 -4.395056907129590e-13,  1.701204055131737e-14, -6.025047577080589e-16,  1.025607748667802e-03, -3.614429299034059e-04,  6.712449458525916e-05, -8.477542363888422e-06,
  8.133184776713151e-07, -6.305648965360034e-08,  4.109874831560171e-09, -2.314394880361426e-10,  1.148846050833830e-11, -5.104439294933871e-13,  2.054619100246094e-14,
 -7.557458929758604e-16,  7.928510059962017e-04, -2.914189058710285e-04,  5.658121965277986e-05, -7.466989125508867e-06,  7.477276580804429e-07, -6.043392846652296e-08,
  4.101094147534403e-09, -2.401541049340092e-10,  1.238150831385788e-11, -5.707102328593191e-13,  2.380515858279155e-14, -9.063410722679612e-16,  6.132938880785535e-04,
 -2.339506127800871e-04,  4.726113092628560e-05, -6.487241786941919e-06,  6.750703536389448e-07, -5.663936156807085e-08,  3.985614232550593e-09, -2.417539746163322e-10,
  1.289694592325946e-11, -6.144901123282308e-13,  2.646841756763659e-14, -1.039593017664560e-15,  4.740825037019901e-04, -1.868137982022394e-04,  3.908322377039014e-05,
 -5.554853592832736e-06,  5.980940303544065e-07, -5.187510458558001e-08,  3.770073859774896e-09, -2.359586883317909e-10,  1.297652655804722e-11, -6.368074879239693e-13,
  2.822718773277852e-14, -1.139877320506436e-15,  3.653246911642689e-04, -1.480473455823501e-04,  3.193125146750584e-05, -4.678502730660663e-06,  5.189874866023150e-07,
 -4.634210269634131e-08,  3.464588629432634e-09, -2.228824500560574e-10,  1.258908614171136e-11, -6.340238638616169e-13,  2.882053967921529e-14, -1.192583206952898e-15,
  2.794222208718595e-04, -1.159583499594805e-04,  2.567038683691163e-05, -3.860538433798178e-06,  4.393598263724704e-07, -4.022491751861955e-08,  3.081341399429546e-09,
 -2.029743104173796e-10,  1.173133410919651e-11, -6.041761218630704e-13,  2.806653727462960e-14, -1.186075509597319e-15,  2.105273509166779e-04, -8.910385794718117e-05,
  2.015880956703487e-05, -3.098481065628141e-06,  3.602742379985609e-07, -3.368256259159640e-08,  2.633373049388012e-09, -1.769443009684361e-10,  1.042622985596964e-11,
 -5.471335568701210e-13,  2.588448249452752e-14, -1.113371661047078e-15,  1.541073358312648e-04, -6.625957219801169e-05,  1.525502002852837e-05, -2.386340944229697e-06,
  2.823154555902280e-07, -2.684457585678960e-08,  2.133676097532745e-09, -1.456890481821570e-10,  8.719700609670926e-12, -4.645837982471535e-13,  2.230607018011820e-14,
 -9.732856164455723e-16,  1.065981860465514e-04, -4.638251271898470e-05,  1.082181652662294e-05, -1.715700533868735e-06,  2.056744836872575e-07, -1.981136501934123e-08,
  1.594628352882145e-09, -1.102268823463353e-10,  6.676487395793369e-12, -3.598772121101427e-13,  1.747502996616883e-14, -7.708860824768913e-16,  6.513075851667800e-05,
 -2.857268990076651e-05,  6.728005130916172e-06, -1.076587395407232e-06,  1.302428429219423e-07, -1.265811517532213e-08,  1.027780802794772e-09, -7.165007526677524e-11,
  4.375891931961110e-12, -2.377741901609975e-13,  1.163655063349845e-14, -5.172366182850500e-16,  2.734890840956181e-05, -1.205244476190794e-05,  2.852482093575098e-06,
 -4.587944740958681e-07,  5.578595416853630e-08, -5.448737271535182e-09,  4.445605712549767e-10, -3.113841259354904e-11,  1.910474480796025e-12, -1.042749973769583e-13,
  5.125396806332405e-15, -2.287825836575706e-16,  8.462525694382242e-02, -3.028119575473782e-04,  1.141303435601535e-06, -4.470944639649262e-09,  1.796036441834709e-11,
 -7.319217389431479e-14,  3.002700726582817e-16, -1.234083654710011e-18,  5.066023803589573e-21, -2.073856483524872e-23,  8.458561271048196e-26, -3.436110287751285e-28,
  8.240156110680744e-02, -4.264996318164835e-04,  2.592124489132584e-06, -1.580006296801839e-08,  9.335597386828438e-11, -5.343452512590052e-13,  2.976670532366995e-15,
 -1.620915911775441e-17,  8.656818475117443e-20, -4.545856017252413e-22,  2.351652514780500e-24, -1.200295791785173e-26,  7.813977501319906e-02, -6.536302048591916e-04,
  5.841502460348029e-06, -4.786947479795657e-08,  3.657056382183223e-10, -2.650173709192929e-12,  1.841693038475560e-14, -1.236209679263883e-16,  8.056316049223537e-19,
 -5.117229290296537e-21,  3.177608343130764e-23, -1.933603695224823e-25,  7.218412231880629e-02, -9.479713980655768e-04,  1.140178259129290e-05, -1.194171020707780e-07,
  1.138897026021277e-09, -1.013059649731477e-11,  8.526517022576675e-14, -6.856535761014385e-16,  5.304663641789255e-18, -3.969146330951959e-20,  2.883878432985023e-22,
 -2.041131446091484e-24,  6.498915978305980e-02, -1.264667130175549e-03,  1.966054887444164e-05, -2.569708746512091e-07,  2.993806653582841e-09, -3.201953250863949e-11,
  3.200864677119687e-13, -3.027100466456738e-15,  2.731715371353225e-17, -2.367457218621633e-19,  1.980238012985631e-21, -1.604790266260352e-23,  5.705998825493203e-02,
 -1.558791572816351e-03,  3.060447897664128e-05, -4.902827427028050e-07,  6.862350923947406e-09, -8.690347858386124e-11,  1.017172830078080e-12, -1.116162156947751e-14,
  1.159914243491241e-16, -1.150149416365235e-18,  1.094520153956067e-20, -1.004123382992396e-22,  4.889223637040993e-02, -1.793028329930511e-03,  4.366690326656069e-05,
 -8.444406305108225e-07,  1.400914574423066e-08, -2.075061950957420e-10,  2.811723559714794e-12, -3.542080928193256e-14,  4.196313144375377e-16, -4.715167402690645e-18,
  5.058102300604410e-20, -5.206470226318695e-22,  4.092179784481771e-02, -1.942869667193902e-03,  5.775627954715855e-05, -1.330414779292962e-06,  2.586149294385545e-08,
 -4.434554952151430e-10,  6.890611923350434e-12, -9.877572247229073e-14,  1.322931356563553e-15, -1.671123225519642e-17,  2.005427385606290e-19, -2.299141110204313e-21,
  3.349091399806210e-02, -1.998580852242189e-03,  7.145167013421528e-05, -1.937316698000756e-06,  4.368066085577303e-08, -8.592997255920912e-10,  1.518581137194631e-11,
 -2.458147857708113e-13,  3.695221187781196e-15, -5.211710778598025e-17,  6.950975557345687e-19, -8.820176853454242e-21,  2.683290762322403e-02, -1.964092797872483e-03,
  8.329341020974291e-05, -2.629641370973870e-06,  6.814407852700533e-08, -1.525531049142265e-09,  3.043670321467984e-11, -5.525610176199488e-13,  9.263558282804020e-15,
 -1.449956680046139e-16,  2.136875287419227e-18, -2.984542630289403e-20,  2.107393462434431e-02, -1.853683149954309e-03,  9.207343344241655e-05, -3.351131416320418e-06,
  9.897129003092319e-08, -2.502723966892304e-09,  5.599488214601269e-11, -1.133038153838150e-12,  2.106122440260003e-14, -3.638442575081487e-16,  5.894299631492877e-18,
 -9.016298390389699e-20,  1.624741593248392e-02, -1.687623549970081e-03,  9.704341178992041e-05, -4.034459006372121e-06,  1.347381639161827e-07, -3.822147487853918e-09,
  9.529914368051934e-11, -2.136978081342157e-12,  4.380756136732503e-14, -8.310723076632293e-16,  1.472862898807707e-17, -2.456190832475652e-19,  1.231568899932154e-02,
 -1.487908685288039e-03,  9.799759724865345e-05, -4.613851168376369e-06,  1.729708372002857e-07, -5.468766215731051e-09,  1.510674364554379e-10, -3.733817925274677e-12,
  8.399002090891064e-14, -1.741484930342373e-15,  3.361253049285603e-17, -6.084768691357468e-19,  9.193710717573026e-03, -1.274859122267051e-03,  9.523172305278867e-05,
 -5.036966442202971e-06,  2.105148425037116e-07, -7.372893469203053e-09,  2.243920127979536e-10, -6.081907955357149e-12,  1.494068002107413e-13, -3.370686932584049e-15,
  7.055277981283596e-17, -1.380833268101947e-18,  6.770868028550723e-03, -1.064969011278458e-03,  8.941288865789593e-05, -5.272945948812507e-06,  2.440796604782773e-07,
 -9.414422268030932e-09,  3.140143722266453e-10, -9.287735626518786e-12,  2.480376547720519e-13, -6.062625761805016e-15,  1.370592306133294e-16, -2.888943976773686e-18,
  4.928540869191878e-03, -8.699940174770118e-04,  8.140987390537903e-05, -5.315134964638759e-06,  2.708055742539836e-07, -1.143945046067270e-08,  4.160430355981059e-10,
 -1.336548463271926e-11,  3.863346438331212e-13, -1.018844918923042e-14,  2.478039327132546e-16, -5.604314258110583e-18,  3.552547568729465e-03, -6.970265005384890e-04,
  7.212974069818986e-05, -5.178731365892481e-06,  2.887057502872131e-07, -1.328503299138604e-08,  5.242539851505370e-10, -1.820953813559824e-11,  5.672851294194481e-13,
 -1.607704468696454e-14,  4.190913051259764e-16, -1.013286550960161e-17,  2.540709772034086e-03, -5.492014156000206e-04,  6.239164502646070e-05, -4.894905752515075e-06,
  2.968911443265611e-07, -1.480543137991119e-08,  6.309298297838694e-10, -2.359002735683215e-11,  7.887763245665034e-13, -2.392873680100672e-14,  6.660578285666674e-16,
 -1.715559193996138e-17,  1.806419139546826e-03, -4.266888682378410e-04,  5.285066617126606e-05, -4.503449402246316e-06,  2.955603755351473e-07, -1.589334797167289e-08,
  7.280266803113020e-10, -2.917492124625748e-11,  1.042786237399480e-12, -3.373303236180274e-14,  9.989717694747104e-16, -2.731516114524328e-17,  1.279326030242713e-03,
 -3.277093076107394e-04,  4.396939867903484e-05, -4.045802772259310e-06,  2.858010257320247e-07, -1.649183762122534e-08,  8.083722426166968e-10, -3.457410597950245e-11,
  1.315721656477026e-12, -4.521434284102511e-14,  1.419438811655173e-15, -4.106095720194215e-17,  9.042231304406073e-04, -2.494088640609829e-04,  3.602599833988824e-05,
 -3.559685047997961e-06,  2.692843021416967e-07, -1.659572983139259e-08,  8.666178550384833e-10, -3.939462466519584e-11,  1.589894556462095e-12, -5.782412117004629e-14,
  1.917537471065232e-15, -5.848378452060039e-17,  6.389954585218500e-04, -1.885234336096215e-04,  2.914435297892167e-05, -3.075811625038711e-06,  2.479385684067564e-07,
 -1.624421883452851e-08,  8.997685938953299e-10, -4.329392838789764e-11,  1.845803346190914e-12, -7.078548847155464e-14,  2.470783905934134e-15, -7.918268481095404e-17,
  4.522573314865776e-04, -1.418254958176206e-04,  2.333337658369813e-05, -2.616590743995033e-06,  2.236675660821536e-07, -1.550796906660100e-08,  9.072496745537472e-10,
 -4.601994869773624e-11,  2.064684137475377e-12, -8.318188024756698e-14,  3.045380700893098e-15, -1.022041722048440e-16,  3.210636377124112e-04, -1.063850961669791e-04,
  1.852595410244432e-05, -2.196338572237118e-06,  1.981494688246467e-07, -1.447444288113146e-08,  8.905842060582225e-10, -4.743167707554510e-11,  2.230776774676503e-12,
 -9.406988723133582e-14,  3.599598826505711e-15, -1.260782314167877e-16,  2.288990935248428e-04, -7.969118314533506e-05,  1.461201917276810e-05, -1.822436931037072e-06,
  1.727248092952774e-07, -1.323448692618200e-08,  8.528259516111210e-10, -4.749959762066980e-11,  2.332890987856659e-12, -1.025919212891403e-13,  4.088596877820194e-15,
 -1.489510592819166e-16,  1.640221603688368e-04, -5.967937005752300e-05,  1.146355339310335e-05, -1.496910306430162e-06,  1.483615087422777e-07, -1.187203485773943e-08,
  7.979049735822576e-10, -4.628987999812789e-11,  2.365086131974211e-12, -1.080671898723396e-13,  4.469676295380749e-15, -1.687904142485453e-16,  1.181630523084860e-04,
 -4.470439778075195e-05,  8.951538954907434e-06, -1.218035270119971e-06,  1.256754185770988e-07, -1.045758330337454e-08,  7.300167388865030e-10, -4.393868815773326e-11,
  2.326506828479325e-12, -1.100475867256896e-13,  4.706974778980411e-15, -1.836235106154750e-16,  8.553536521640540e-05, -3.348532381035126e-05,  6.956109702608123e-06,
 -9.817485930957620e-07,  1.049832416466641e-07, -9.045183740586555e-09,  6.531373176563797e-10, -4.062324555406619e-11,  2.220581740304022e-12, -1.083350566685399e-13,
  4.774862937782708e-15, -1.917637287434301e-16,  6.210569934571544e-05, -2.504181964554103e-05,  5.371578820265182e-06, -7.827497849314367e-07,  8.636831792098458e-08,
 -7.672173246581286e-09,  5.706979642819453e-10, -3.653502802061080e-11,  2.053867118564381e-12, -1.029655772103385e-13,  4.659705924728926e-15, -1.919902568500065e-16,
  4.506493601727275e-05, -1.863228622230643e-05,  4.107969857564083e-06, -6.152837932463216e-07,  6.974551938190931e-08, -6.360702512667996e-09,  4.854139388285511e-10,
 -3.185846992793853e-11,  1.834808884384252e-12, -9.417020655280880e-14,  4.360043649019484e-15, -1.836597753934473e-16,  3.245127660510519e-05, -1.369907015547018e-05,
  3.090389553817239e-06, -4.736408996157527e-07,  5.491725485618595e-08, -5.120199197178118e-09,  3.992395052806807e-10, -2.675659385551074e-11,  1.572635338945052e-12,
 -8.232527402529843e-14,  3.885528528283862e-15, -1.667458245488674e-16,  2.288416905127465e-05, -9.822596950973811e-06,  2.257224771208108e-06, -3.524322614571108e-07,
  4.161720301843122e-08, -3.950109095898038e-09,  3.134125258942426e-10, -2.136345599639791e-11,  1.276509964283575e-12, -6.790247293285726e-14,  3.255096070630019e-15,
 -1.418148929714829e-16,  1.537729371856810e-05, -6.684253827479394e-06,  1.557818031149127e-06, -2.467020222471880e-07,  2.954156797824651e-08, -2.842496745172939e-09,
  2.285541971644218e-10, -1.578241322228658e-11,  9.549971652402883e-13, -5.142666470914873e-14,  2.494844180191845e-15, -1.099561529455375e-16,  9.206835590282250e-06,
 -4.036955484014482e-06,  9.500362456820464e-07, -1.519327752711495e-07,  1.836991754835285e-08, -1.784342306748461e-09,  1.448007154644762e-10, -1.008912360797305e-11,
  6.158507963471393e-13, -3.344654330095544e-14,  1.636039482493754e-15, -7.268547617081518e-17,  3.822395895893150e-06, -1.684093792205346e-06,  3.984698221961414e-07,
 -6.407223278345504e-08,  7.788542536222228e-09, -7.605157789020061e-10,  6.203346981175037e-11, -4.343864408488368e-12,  2.664450386446008e-13, -1.453902040178369e-14,
  7.144518372453524e-16, -3.188314599085709e-17,  8.343193693004765e-02, -2.938913589513828e-04,  1.089329225089489e-06, -4.194909432116281e-09,  1.656587868537787e-11,
 -6.638269272888604e-14,  2.678775617851652e-16, -1.083291743986129e-18,  4.376864873584575e-21, -1.763887555812554e-23,  7.083720392819423e-26, -2.833808931176261e-28,
  8.073587057530753e-02, -4.064964338313151e-04,  2.411145404112700e-06, -1.438812991484562e-08,  8.334826330088429e-11, -4.680529023164726e-13,  2.559260100236142e-15,
 -1.368364781922320e-17,  7.177640343409352e-20, -3.702802089611901e-22,  1.882247811457319e-24, -9.442102203172292e-27,  7.561521546272636e-02, -6.091003259061930e-04,
  5.300502088457439e-06, -4.241932326014015e-08,  3.168562189517440e-10, -2.246952705107324e-12,  1.529042895343854e-14, -1.005586832804274e-16,  6.423795277478284e-19,
 -4.001205447363932e-21,  2.437291888613397e-23, -1.455322693741680e-25,  6.856600745502862e-02, -8.621940854452793e-04,  1.007176840747760e-05, -1.027106577940355e-07,
  9.552874819727758e-10, -8.296675188827730e-12,  6.824346025373391e-14, -5.367046972608063e-16,  4.063457956622655e-18, -2.976930720144702e-20,  2.118746654907437e-22,
 -1.469528737454338e-24,  6.022661896220064e-02, -1.118949119860165e-03,  1.684444829853892e-05, -2.138028372391843e-07,  2.423850262521598e-09, -2.526314508860899e-11,
  2.463859594752985e-13, -2.275310888851922e-15,  2.006492630747627e-17, -1.700386491717072e-19,  1.391507365445276e-21, -1.103827980918451e-23,  5.127970337365344e-02,
 -1.335746727512411e-03,  2.532653881167084e-05, -3.931624657342085e-07,  5.345103922101187e-09, -6.585764900162767e-11,  7.509428122720823e-13, -8.035828139339206e-15,
  8.150673522679495e-17, -7.894136106713951e-19,  7.342333163224578e-21, -6.587247001239410e-23,  4.235960777429509e-02, -1.480708924750882e-03,  3.475255655214937e-05,
 -6.501405887501217e-07,  1.046072508738544e-08, -1.505527533978209e-10,  1.984961625489035e-12, -2.435885180009834e-14,  2.813846460258358e-16, -3.085456588889522e-18,
  3.232288231043317e-20, -3.251192667334623e-22,  3.398241848721899e-02, -1.538265031392381e-03,  4.400805415493273e-05, -9.794593056533970e-07,  1.844465748885393e-08,
 -3.069907955843970e-10,  4.637112480934559e-12, -6.469776797839158e-14,  8.442574337843491e-16, -1.039993892773219e-17,  1.218013328471304e-19, -1.363753693706299e-21,
  2.650778155426761e-02, -1.509265747903475e-03,  5.188835990039836e-05, -1.358231999742330e-06,  2.964409546516508e-08, -5.656311262858997e-10,  9.710667036189540e-12,
 -1.528983225009311e-13,  2.238171402108531e-15, -3.076814543368431e-17,  4.003086904277979e-19, -4.958819314969624e-21,  2.013278407086187e-02, -1.407517926887103e-03,
  5.738821296689956e-05, -1.748445795761805e-06,  4.383966803518460e-08, -9.515049095854663e-10,  1.843458659030891e-11, -3.254157892664171e-13,  5.310678269238076e-15,
 -8.099675262290966e-17,  1.164149136664475e-18, -1.586952110085494e-20,  1.491121881523069e-02, -1.254408031925783e-03,  5.991934193255571e-05, -2.104566071322903e-06,
  6.013344571917069e-08, -1.474039816669157e-09,  3.202049464618793e-11, -6.299262778761387e-13,  1.139708689187431e-14, -1.918347855804703e-16,  3.030627969276452e-18,
 -4.524476896785833e-20,  1.078798365499557e-02, -1.073374342893412e-03,  5.939526794044073e-05, -2.383733890472481e-06,  7.703498648703921e-08, -2.118632899092722e-09,
  5.129439297285591e-11, -1.118385694844811e-12,  2.231780372334375e-14, -4.125645714092733e-16,  7.131126574021335e-18, -1.160802430644397e-19,  7.638245224361748e-03,
 -8.855339848843065e-04,  5.617988325756278e-05, -2.555070408441803e-06,  9.273721969974464e-08, -2.843805432598844e-09,  7.630810405019266e-11, -1.834459110243165e-12,
  4.018199642005684e-14, -8.121002926414798e-16,  1.529216305834625e-17, -2.703019503470716e-19,  5.303320743262577e-03, -7.070778797649054e-04,  5.094168076054701e-05,
 -2.605230356482087e-06,  1.054960867389606e-07, -3.585990498557493e-09,  1.060783210505916e-10, -2.798039505790023e-12,  6.696693019651718e-14, -1.473375618060553e-15,
  3.010236702760844e-17, -5.755412119771577e-19,  3.618598994178265e-03, -5.484086282195878e-04,  4.447434512274044e-05, -2.539041863076725e-06,  1.139898819473715e-07,
 -4.271060158675215e-09,  1.385779338637202e-10, -3.991892407860478e-12,  1.039380229751976e-13, -2.479256179575805e-15,  5.474563643956943e-17, -1.128006653630368e-18,
  2.432012936745380e-03, -4.145885224193037e-04,  3.753748158908392e-05, -2.375896240216907e-06,  1.175510166168648e-07, -4.829070555055892e-09,  1.710180510603116e-10,
 -5.355824263169398e-12,  1.510721328919682e-13, -3.891406627560589e-15,  9.252258197386551e-17, -2.047121650186095e-18,  1.613873174144273e-03, -3.065229912201339e-04,
  3.074927720484096e-05, -2.143730280956509e-06,  1.162196906617344e-07, -5.207649152108366e-09,  2.003498186158107e-10, -6.791633374188896e-12,  2.066903610796775e-13,
 -5.727255648612841e-15,  1.460887506360497e-16, -3.458878975115542e-18,  1.060079718935700e-03, -2.223655008417686e-04,  2.453860868064266e-05, -1.872687432910173e-06,
  1.106344892723387e-07, -5.380307257042021e-09,  2.238355775125415e-10, -8.178308670964656e-12,  2.674625021264077e-13, -7.942500732350950e-15,  2.165730258686058e-16,
 -5.468447008709823e-18,  6.910230917686261e-04, -1.587928846336663e-04,  1.914639647999007e-05, -1.590039873191347e-06,  1.018209711508643e-07, -5.348095133593500e-09,
  2.395236640878356e-10, -9.393267996501960e-12,  3.288249928519736e-13, -1.042596343770152e-14,  3.028375790471792e-16, -8.127338306960301e-18,  4.481977817775458e-04,
 -1.119771097047066e-04,  1.465791877990931e-05, -1.317122388923740e-06,  9.095334946967433e-08, -5.135321424936408e-09,  2.465096532715133e-10, -1.033353234128759e-11,
  3.857111596972151e-13, -1.300996968976241e-14,  4.011430835082178e-16, -1.140422959087731e-17,  2.900087497671433e-04, -7.821783938118012e-05,  1.104786353062514e-05,
 -1.068265415972628e-06,  7.915063304115152e-08, -4.781606417797734e-09,  2.449492011978583e-10, -1.093126689134497e-11,  4.333909585476671e-13, -1.549429790938361e-14,
  5.053750314592794e-16, -1.516917677489667e-17,  1.876900084474985e-04, -5.428261996253480e-05,  8.224606317534506e-06, -8.512378620442470e-07,  6.734076557846587e-08,
 -4.332963081255812e-09,  2.358652801303313e-10, -1.116053128444869e-11,  4.681970314990186e-13, -1.767736475716535e-14,  6.078104511947090e-16, -1.919773969242272e-17,
  1.217987790580493e-04, -3.753460461015872e-05,  6.066167735940936e-06, -6.685517973115803e-07,  5.619843614711218e-08, -3.834086497719751e-09,  2.208382920836428e-10,
 -1.103510481275674e-11,  4.879728736485796e-13, -1.938646635978552e-14,  7.002344959041286e-16, -2.319556978121543e-17,  7.943776752926492e-05, -2.592790172845570e-05,
  4.445340641122268e-06, -5.190534949017811e-07,  4.614306450153542e-08, -3.323057066907108e-09,  2.016742689391316e-10, -1.059965637516920e-11,  4.921816236285355e-13,
 -2.050000403804291e-14,  7.751216389539050e-16, -2.683778993034966e-17,  5.217843258061837e-05, -1.793450108513834e-05,  3.244724808003359e-06, -3.994070589596427e-07,
  3.737525849157094e-08, -2.828695821676057e-09,  1.801238812183317e-10, -9.917648933020135e-12,  4.817146639139194e-13, -2.095782048353638e-14,  8.266050233292904e-16,
 -2.981348053746970e-17,  3.457522323395867e-05, -1.244631430099747e-05,  2.363933291990094e-06, -3.052694291655223e-07,  2.993055706299891e-08, -2.370138180283908e-09,
  1.576901346730979e-10, -9.059213730200295e-12,  4.585043096934500e-13, -2.075952238986254e-14,  8.510512589584012e-16, -3.186506290464630e-17,  2.313847084023020e-05,
 -8.677822413078658e-06,  1.721539496303348e-06, -2.321043383810342e-07,  2.373456754543795e-08, -1.957889724038076e-09,  1.355302881627623e-10, -8.091257684843764e-12,
  4.250634385844835e-13, -1.995359570140062e-14,  8.471884355892807e-16, -3.281502622409235e-17,  1.564324722131084e-05, -6.081636112789145e-06,  1.253972835232122e-06,
 -1.756723659498798e-07,  1.865013929679632e-08, -1.595621969254098e-09,  1.144359102827968e-10, -7.070848546202108e-12,  3.840556981620519e-13, -1.862153021730846e-14,
  8.158517396732312e-16, -3.257680798040822e-17,  1.067399482472015e-05, -4.280953925317274e-06,  9.129710148360948e-07, -1.322727981954438e-07,  1.451278241488138e-08,
 -1.282129383744627e-09,  9.486562498366143e-11, -6.041890457298640e-12,  3.379612027582042e-13, -1.686109623089284e-14,  7.594816815325745e-16, -3.115095447577423e-17,
  7.329286618455454e-06, -3.018385398659954e-06,  6.626118869191356e-07, -9.881766671058912e-08,  1.115427810274092e-08, -1.013084152605631e-09,  7.700522879277362e-11,
 -5.034460684971750e-12,  2.888621272439063e-13, -1.477186428630641e-14,  6.815274134430195e-16, -2.861067736859923e-17,  5.032617311557989e-06, -2.118621234348167e-06,
  4.764884583437901e-07, -7.280553305705411e-08,  8.416382597502661e-09, -7.824171279053432e-10,  6.083530651547167e-11, -4.065930985289424e-12,  2.383416971567876e-13,
 -1.244465871830740e-14,  5.858840596594524e-16, -2.508210903828561e-17,  3.412022299468073e-06, -1.461917086492468e-06,  3.352781162890245e-07, -5.224409622097680e-08,
  6.157166147556394e-09, -5.832897192222027e-10,  4.619356554496323e-11, -3.143037954908743e-12,  1.874727661598453e-13, -9.955380015395295e-15,  4.764486956376924e-16,
 -2.072417983005386e-17,  2.223663319225011e-06, -9.655712444303624e-07,  2.247693407581801e-07, -3.555321592459121e-08,  4.252394060000978e-09, -4.087004677222967e-10,
  3.282556213730523e-11, -2.264264395576966e-12,  1.368672256575174e-13, -7.362784142014484e-15,  3.568336721146434e-16, -1.571172443968623e-17,  1.303122570748180e-06,
 -5.710777267483191e-07,  1.343132741163199e-07, -2.146668710633021e-08,  2.593932608645347e-09, -2.518097780540948e-10,  2.042272794737885e-11, -1.422168422964629e-12,
  8.676280495329738e-14, -4.709509505629979e-15,  2.302450678846913e-16, -1.022404094572075e-17,  5.345547969761070e-07, -2.354583288114838e-07,  5.569546779443734e-08,
 -8.953001748636901e-09,  1.088002637455034e-09, -1.062082877114521e-10,  8.660730664174535e-12, -6.062964260402126e-13,  3.717908850555337e-14, -2.028199502078833e-15,
  9.964028605573864e-17, -4.445412019442111e-18,  8.227348817979092e-02, -2.853736735667100e-04,  1.040537927686357e-06, -3.940137327169248e-09,  1.530013791428092e-11,
 -6.030235830330824e-14,  2.394145289921249e-16, -9.528686644794442e-19,  3.790002487624090e-21, -1.503960860416529e-23,  5.948273947436996e-26, -2.343853327065806e-28,
  7.914740076287544e-02, -3.878759204933801e-04,  2.246190828778034e-06, -1.312623464286653e-08,  7.457168408478417e-11, -4.109806390040792e-13,  2.206368912985514e-15,
 -1.158632809553398e-17,  5.970712965688564e-20, -3.026786024436757e-22,  1.512269575613525e-24, -7.457749012568079e-27,  7.326051565142370e-02, -5.686495422398646e-04,
  4.820467485619827e-06, -3.769011463923641e-08,  2.753702642370972e-10, -1.911573949748516e-12,  1.274218965821773e-14, -8.213091316246855e-17,  5.144447915660274e-19,
 -3.143159240296934e-21,  1.878702221801159e-23, -1.101068783272135e-25,  6.527092430022371e-02, -7.863022686876960e-04,  8.925747216014461e-06, -8.866939384832146e-08,
  8.045871015109065e-10, -6.825406207365983e-12,  5.488601476620905e-14, -4.223040235190186e-16,  3.129925467031340e-18, -2.245825285445705e-20,  1.566199018962718e-22,
 -1.064821132982446e-24,  5.600496727540045e-02, -9.938331974659574e-04,  1.449581474153346e-05, -1.787624734214079e-07,  1.972911883943358e-09, -2.004712610637281e-11,
  1.908175124672713e-13, -1.721315687473165e-15,  1.483850278322520e-17, -1.229989435330902e-19,  9.850852240693587e-22, -7.651231199656390e-24,  4.631398885367084e-02,
 -1.150646448126489e-03,  2.108122817435650e-05, -3.172703134253594e-07,  4.191370679103178e-09, -5.026469587248718e-11,  5.585558491619558e-13, -5.830852026679194e-15,
  5.774327858303525e-17, -5.464248763703126e-19,  4.968768661699933e-21, -4.360620353357659e-23,  3.694713736927362e-02, -1.231263008222371e-03,  2.786352649921352e-05,
 -5.044838604430801e-07,  7.875668313068033e-09, -1.101751216866331e-10,  1.413904782082252e-12, -1.690775863873615e-14,  1.905014104815310e-16, -2.039080540739088e-18,
  2.086633219645840e-20, -2.051495870853616e-22,  2.846556186721096e-02, -1.228627887627391e-03,  3.384064309943596e-05, -7.279816391083581e-07,  1.328543719982802e-08,
 -2.147007297562472e-10,  3.153598264783947e-12, -4.283763067259936e-14,  5.447917172017182e-16, -6.546143117342418e-18,  7.484070425887654e-20, -8.185583119873938e-22,
  2.120805197198820e-02, -1.152074978914032e-03,  3.809945714250505e-05, -9.630868287662929e-07,  2.035311430237196e-08, -3.767784283902821e-10,  6.285482604360666e-12,
 -9.629066537497622e-14,  1.372888515034453e-15, -1.839958251278384e-17,  2.335722147899253e-19, -2.825154983874720e-21,  1.530314902770391e-02, -1.021717429466349e-03,
  4.005764357393617e-05, -1.177997256800043e-06,  2.858471030871137e-08, -6.016149482593191e-10,  1.132071770013076e-11, -1.943501821006824e-13,  3.088083003864967e-15,
 -4.590093027854259e-17,  6.435014438705052e-19, -8.563023187726624e-21,  1.071279510379663e-02, -8.617124557853826e-04,  3.958498427782700e-05, -1.341852246661019e-06,
  3.709756797614270e-08, -8.816233096277224e-10,  1.859690294721214e-11, -3.557309083525583e-13,  6.265304892178320e-15, -1.027604284084248e-16,  1.583307708614408e-18,
 -2.307188224191843e-20,  7.289471818170738e-03, -6.945111847207388e-04,  3.697824549039766e-05, -1.432620825716166e-06,  4.480176865241864e-08, -1.194621279071996e-09,
  2.808646035275572e-11, -5.954570106716899e-13,  1.156756378797506e-14, -2.083784787485741e-16,  3.513014775476682e-18, -5.582087845149311e-20,  4.831434177500631e-03,
 -5.372670502906126e-04,  3.282512091052316e-05, -1.441936620476744e-06,  5.066449268710276e-08, -1.506796832752060e-09,  3.927327774797814e-11, -9.182811721646921e-13,
  1.958556304593157e-14, -3.858238998093371e-16,  7.087857696454468e-18, -1.223265776297887e-19,  3.126392369877009e-03, -4.005690730975732e-04,  2.782434503820700e-05,
 -1.375560888041201e-06,  5.395935330358437e-08, -1.779883926012771e-09,  5.116831944966692e-11, -1.313327751963799e-12,  3.062032195999659e-14, -6.569383197509373e-16,
  1.309970900020251e-17, -2.446500561566416e-19,  1.980077449903467e-03, -2.889650809704860e-04,  2.262572736847656e-05, -1.250033606032730e-06,  5.441437409721829e-08,
 -1.980088140941816e-09,  6.248147744772325e-11, -1.752566786684488e-12,  4.448137412867445e-14, -1.035269813475747e-15,  2.232493240681625e-17, -4.495870634639098e-19,
  1.230710584219344e-03, -2.024674338105400e-04,  1.772799115614127e-05, -1.087320693287413e-06,  5.222152629128245e-08, -2.085606048470774e-09,  7.189943139554804e-11,
 -2.194458314720305e-12,  6.038816932293231e-14, -1.518956799842860e-15,  3.529603304010635e-17, -7.638453214286934e-19,  7.528414320433702e-04, -1.383081302736112e-04,
  1.344191511162534e-05, -9.094881602121389e-07,  4.792759203490658e-08, -2.090371811476470e-09,  7.837452795978431e-11, -2.592005719632240e-12,  7.703398757835444e-14,
 -2.086386133104808e-15,  5.205989794172003e-17, -1.206681039485347e-18,  4.546023597946549e-04, -9.246083322013334e-05,  9.904548333163289e-06, -7.348378824667699e-07,
  4.226294753131807e-08, -2.003364034863754e-09,  8.132996427673278e-11, -2.902627441002264e-12,  9.280993150054686e-14, -2.696843461324547e-15,  7.201179132146782e-17,
 -1.781890853357733e-18,  2.718352873176018e-04, -6.071851424644850e-05,  7.121631775316930e-06, -5.760322897685055e-07,  3.597081210322524e-08, -1.844466788496790e-09,
  8.072717881332644e-11, -3.096631934896702e-12,  1.061224091510322e-13, -3.296600078489604e-15,  9.388157252128674e-17, -2.471945124729836e-18,  1.614869714102273e-04,
 -3.931646282907795e-05,  5.017308529244854e-06, -4.399748099709491e-07,  2.968121609593435e-08, -1.638783970086399e-09,  7.699732027954638e-11, -3.161863708234074e-12,
  1.157033656852537e-13, -3.828787467267540e-15,  1.158977771524682e-16, -3.236771803820203e-18,  9.562429145100502e-05, -2.519702564755481e-05,  3.477414633387761e-06,
 -3.288191574910319e-07,  2.384652137720254e-08, -1.411283281630654e-09,  7.088246035019218e-11, -3.103726901189059e-12,  1.208225116030903e-13, -4.244033078450394e-15,
  1.360894752470159e-16, -4.018227858977527e-18,  5.663031205482801e-05, -1.604202367253615e-05,  2.380385804280433e-06, -2.414386114864373e-07,  1.873225570553378e-08,
 -1.182987408458041e-09,  6.324878744531361e-11, -2.941419925948865e-12,  1.213548670884579e-13, -4.508765518788946e-15,  1.526368375881014e-16, -4.749274888831599e-18,
  3.365219310450657e-05, -1.018307844863982e-05,  1.615472335188612e-06, -1.748565351353119e-07,  1.444476220362726e-08, -9.690968213476941e-10,  5.492469559436673e-11,
 -2.702169142179789e-12,  1.177103865102317e-13, -4.609216912041932e-15,  1.641703731141372e-16, -5.365253137594506e-18,  2.013000357054371e-05, -6.467198917655782e-06,
  1.090906223404386e-06, -1.253705421214644e-07,  1.097536341709930e-08, -7.787809985001789e-10,  4.659326148040791e-11, -2.415346107997250e-12,  1.106717331637385e-13,
 -4.550789447638929e-15,  1.699461822847286e-16, -5.814117864042400e-18,  1.215701108016959e-05, -4.122576519383184e-06,  7.354699417366569e-07, -8.929577223009232e-08,
  8.245395487409739e-09, -6.160578739463141e-10,  3.874432395015714e-11, -2.107821044807705e-12,  1.012002254193820e-13, -4.353857201055211e-15,  1.698728946554173e-16,
 -6.063161191039645e-18,  7.431781892513744e-06, -2.645261650338009e-06,  4.964895682476309e-07, -6.337058181448968e-08,  6.143192464081217e-09, -4.811577209704338e-10,
  3.167470933672190e-11, -1.801144070905661e-12,  9.026112119595020e-14, -4.047781468548328e-15,  1.644123355921174e-16, -6.101138012083704e-18,  4.608229525802911e-06,
 -1.712380866715288e-06,  3.363918527341254e-07, -4.491624149096350e-08,  4.549937780157061e-09, -3.719147941802003e-10,  2.551830421458169e-11, -1.510491790929930e-12,
  7.869832277045624e-14, -3.664882073005585e-15,  1.544040846322974e-16, -5.936174450372982e-18,  2.901892395057056e-06, -1.119901487075491e-06,  2.290963957698792e-07,
 -3.184455060797473e-08,  3.355054805997733e-09, -2.849259656497581e-10,  2.028852090174092e-11, -1.244933165681394e-12,  6.716651211670054e-14, -3.235580823250097e-15,
  1.408695213625321e-16, -5.590831847477891e-18,  1.855725638886921e-06, -7.400545201726554e-07,  1.568596042641177e-07, -2.258765248831216e-08,  2.463535635349343e-09,
 -2.163822587765055e-10,  1.592053083304161e-11, -1.008456892835728e-12,  5.611285447709775e-14, -2.785256502262972e-15,  1.248391610012127e-16, -5.096028338252025e-18,
  1.202633304165251e-06, -4.932009368079351e-07,  1.077747950872755e-07, -1.599952196516805e-08,  1.797921820340146e-09, -1.625867008983750e-10,  1.230626167275627e-11,
 -8.012753179478872e-13,  4.579285586605836e-14, -2.332784556318906e-15,  1.072276965306396e-16, -4.485289343239310e-18,  7.855054416747335e-07, -3.297100582144456e-07,
  7.391384598196112e-08, -1.125725379444927e-08,  1.297227137279074e-09, -1.202229901928877e-10,  9.319705127691016e-12, -6.210732469477317e-13,  3.630427033100469e-14,
 -1.890397375167438e-15,  8.876273134642185e-17, -3.790269778154120e-18,  5.109274569121466e-07, -2.184943095898353e-07,  5.000373708481203e-08, -7.775207263919073e-09,
  9.144286898393234e-10, -8.645101094067901e-11,  6.832953785861644e-12, -4.640264423704073e-13,  2.762625530216148e-14, -1.464389122474574e-15,  6.996052050602358e-17,
 -3.037926270318120e-18,  3.223888822162964e-07, -1.398328740267674e-07,  3.251021525673918e-08, -5.135899374852554e-09,  6.135284159385444e-10, -5.889551918242790e-11,
  4.724750198247220e-12, -3.255347276337813e-13,  1.965563322490646e-14, -1.056235247167222e-15,  5.113623058682446e-17, -2.249288670102178e-18,  1.846888879736540e-07,
 -8.089170527614011e-08,  1.901300117378580e-08, -3.036805969557218e-09,  3.667198697845828e-10, -3.557766997178727e-11,  2.883725755105663e-12, -2.006933074697302e-13,
  1.223667648500078e-14, -6.638346335889180e-16,  3.243658073761101e-17, -1.439575706171676e-18,  7.480320888948866e-08, -3.294039236144315e-08,  7.789438719462581e-09,
 -1.251769302894147e-09,  1.520741940758463e-10, -1.484073903156487e-11,  1.209832312236928e-12, -8.467034248841423e-14,  5.190663796500890e-15, -2.830837144283828e-16,
  1.390341258632473e-17, -6.201306364377197e-19,  8.114834839883851e-02, -2.772344247747321e-04,  9.946862805244474e-07, -3.704680132320313e-09,  1.414945789190099e-11,
 -5.486335317510277e-14,  2.143538939416653e-16, -8.398116135782612e-19,  3.289032309885492e-21, -1.285420185438804e-23,  5.007857341355106e-26, -1.944067084528024e-28,
  7.763086637514792e-02, -3.705167761584323e-04,  2.095572674910007e-06, -1.199607403718997e-08,  6.685639660417086e-11, -3.617145565983154e-13,  1.907142087067111e-15,
 -9.838980500463956e-18,  4.982489751790003e-20, -2.482680689268494e-22,  1.219491952531038e-24, -5.913589186513362e-27,  7.106028255631693e-02, -5.318228285366990e-04,
  4.393411780872032e-06, -3.357417613653392e-08,  2.400198262740935e-10, -1.631596746216465e-12,  1.065696625138147e-14, -6.734307016306397e-17,  4.137270159572056e-19,
 -2.480243779219434e-21,  1.455061631983375e-23, -8.372588897800519e-26,  6.226208415268322e-02, -7.189435029605802e-04,  7.934671407152577e-06, -7.682031972802710e-08,
  6.803493077444294e-10, -5.639424180982622e-12,  4.435028217832634e-14, -3.339592507318946e-16,  2.423753994805846e-18, -1.703851684599953e-20,  1.164637552702238e-22,
 -7.763795509209031e-25,  5.224870093881356e-02, -8.859395788610415e-04,  1.252759695104296e-05, -1.501700688624276e-07,  1.614122500915034e-09, -1.599604684524352e-11,
  1.486532842309340e-13, -1.310338816476027e-15,  1.104555870613963e-17, -8.958504550214116e-20,  7.023799492482167e-22, -5.343129599006042e-24,  4.202610456616573e-02,
 -9.961574763058081e-04,  1.764539752784715e-05, -2.575743502490289e-07,  3.307912479507314e-09, -3.862661439812090e-11,  4.184569193465606e-13, -4.262910369803891e-15,
  4.123088200696859e-17, -3.813318302038062e-19,  3.391076131635173e-21, -2.911980049277044e-23,  3.243237862405030e-02, -1.030584078980352e-03,  2.249862932702958e-05,
 -3.944068390488280e-07,  5.976448142143441e-09, -8.129603810110902e-11,  1.015850422510876e-12, -1.184127365140839e-14,  1.301705956926676e-16, -1.360482576893909e-18,
  1.360336385258547e-20, -1.307607685741605e-22,  2.404187669652197e-02, -9.895337402522672e-04,  2.625084904372148e-05, -5.460294396467525e-07,  9.660457458810214e-09,
 -1.516365619023557e-10,  2.166527843997126e-12, -2.866089349857988e-14,  3.553333606994668e-16, -4.165865649416146e-18,  4.650481377892323e-20, -4.969824469729072e-22,
  1.714327123506372e-02, -8.884951088232477e-04,  2.827188466531023e-05, -6.903599014791597e-07,  1.413095043599152e-08, -2.538692680327067e-10,  4.116391887196696e-12,
 -6.137124671717370e-14,  8.524740308644841e-16, -1.114082835515306e-17,  1.380205381669750e-19, -1.630387999217249e-21,  1.177755521978513e-02, -7.508520864035049e-04,
  2.831195029942918e-05, -8.038053272716616e-07,  1.888042091552628e-08, -3.854188007312853e-10,  7.045519568008728e-12, -1.176568655908232e-13,  1.820525801312337e-15,
 -2.637682986217656e-17,  3.607543094477200e-19, -4.686848567949550e-21,  7.809982723441663e-03, -6.005487631860762e-04,  2.653244614170434e-05, -8.681193342078106e-07,
  2.322558806514153e-08, -5.351937082655231e-10,  1.096400057443184e-11, -2.039525323040137e-13,  3.497222298013942e-15, -5.589990581262938e-17,  8.401084177940719e-19,
 -1.195039312783896e-20,  5.009278413388561e-03, -4.568681841828827e-04,  2.340409892401369e-05, -8.753035112485176e-07,  2.648954077562958e-08, -6.848604143572380e-10,
  1.563685359771502e-11, -3.223762186951787e-13,  6.096968699730287e-15, -1.070340170130484e-16,  1.760088085899314e-18, -2.730171218762444e-20,  3.114788029862385e-03,
 -3.320946509737405e-04,  1.953593459490785e-05, -8.287947863247589e-07,  2.818940180438442e-08, -8.130696415744022e-10,  2.058417381786593e-11, -4.681099018331169e-13,
  9.721678524201853e-15, -1.866662292982613e-16,  3.345449304036662e-18, -5.637429421287825e-20,  1.882395462806251e-03, -2.316510735281294e-04,  1.550921078609160e-05,
 -7.410281045206418e-07,  2.815461040472543e-08, -9.010974096097196e-10,  2.517253773945101e-11, -6.286415960045671e-13,  1.427686224414211e-14, -2.986582634810254e-16,
  5.812031511796341e-18, -1.060196717724065e-19,  1.108731424380010e-03, -1.557130027067311e-04,  1.176669262611158e-05, -6.289198593773355e-07,  2.653817807980268e-08,
 -9.376662279644827e-10,  2.876996633947453e-11, -7.856424060341605e-13,  1.943416251842034e-14, -4.412684893526566e-16,  9.291466639625355e-18, -1.828553109597323e-19,
  6.383833547321427e-04, -1.012813822996846e-04,  8.571746607636966e-06, -5.092419064881419e-07,  2.373322238011795e-08, -9.211938204209969e-10,  3.090567034206197e-11,
 -9.190655780935982e-13,  2.466799424468290e-14, -6.057601893305865e-16,  1.375393752325008e-17, -2.910717159685086e-19,  3.604816352902982e-04, -6.401017301397601e-05,
  6.023466273081964e-06, -3.953358646807091e-07,  2.024157258797303e-08, -8.589902417282608e-10,  3.137535242799647e-11, -1.012002373311579e-12,  2.936253203552564e-14,
 -7.770770646666369e-16,  1.896222672292973e-17, -4.301619093970487e-19,  2.003241523908945e-04, -3.947336410588657e-05,  4.101922217433407e-06, -2.956899163167780e-07,
  1.654724372010141e-08, -7.642008375933571e-10,  3.026083153801093e-11, -1.054519073560024e-12,  3.295323857960209e-14, -9.366374950947430e-16,  2.448344514678280e-17,
 -5.935072857324010e-19,  1.099568788781785e-04, -2.385313888500608e-05,  2.719535267234545e-06, -2.141079784230574e-07,  1.303050824590037e-08, -6.519465560315484e-10,
  2.787072417286555e-11, -1.045251202759896e-12,  3.505256898520622e-14, -1.066371492059230e-15,  2.976274520131220e-17, -7.685782609417297e-19,  5.984365242373358e-05,
 -1.418583294890844e-05,  1.763504854966129e-06, -1.508141279980784e-07,  9.933162251947531e-09, -5.360052169033445e-10,  2.463640959596326e-11, -9.905544240139141e-13,
  3.551919780899318e-14, -1.152609757029250e-15,  3.423722281774659e-17, -9.389125101245713e-19,  3.242277929576094e-05, -8.339493870673453e-06,  1.123686833256861e-06,
 -1.038338657869914e-07,  7.365740569290947e-09, -4.267871875988567e-10,  2.100441801191213e-11, -9.019279146996891e-13,  3.445636595729394e-14, -1.188579045186130e-15,
  3.745208197328994e-17, -1.087312310240549e-18,  1.755861766572243e-05, -4.867670022614892e-06,  7.068161687837282e-07, -7.020671748597377e-08,  5.338619225939597e-09,
 -3.306975123783642e-10,  1.735563534424462e-11, -7.928433588491372e-13,  3.215244678464006e-14, -1.174916024113851e-15,  3.914262459764557e-17, -1.199231129534695e-18,
  9.543858406735401e-06, -2.833430261651048e-06,  4.409015720111536e-07, -4.683588287143481e-08,  3.799783037872011e-09, -2.505322107659474e-10,  1.396354418664549e-11,
 -6.759894821547947e-13,  2.899302271219183e-14, -1.118391855633918e-15,  3.926202421448315e-17, -1.265316012224636e-18,  5.227749240380324e-06, -1.651917516563961e-06,
  2.739548869418920e-07, -3.096652889342581e-08,  2.667879326227125e-09, -1.864077159186177e-10,  1.098794329084698e-11, -5.614996370566508e-13,  2.537484572026882e-14,
 -1.029574580219088e-15,  3.795625072894621e-17, -1.282483813296164e-18,  2.897048607080158e-06, -9.685898547671982e-07,  1.702753468489094e-07, -2.037833119689297e-08,
  1.855660085284411e-09, -1.367939031600768e-10,  8.492142223578716e-12, -4.562518144821419e-13,  2.164225871947134e-14, -9.202899900953248e-16,  3.550374468795953e-17,
 -1.253485483866662e-18,  1.630065415780364e-06, -5.733414598320170e-07,  1.062766481619551e-07, -1.339961138970616e-08,  1.283609096811264e-09, -9.938735775494741e-11,
  6.470409513046001e-12, -3.640058326894398e-13,  1.805344072002454e-14, -8.015436322692683e-16,  3.224332257464164e-17, -1.185379630032214e-18,  9.341041395299483e-07,
 -3.437334462527686e-07,  6.683043267630942e-08, -8.832847325417609e-09,  8.859172962879576e-10, -7.172294862254896e-11,  4.875639118288206e-12, -2.860212300580134e-13,
  1.477324603317089e-14, -6.822226310500407e-16,  2.851020271483080e-17, -1.087540682164616e-18,  5.463915764922487e-07, -2.092263718011602e-07,  4.244530835247455e-08,
 -5.851375687594599e-09,  6.115411363002528e-10, -5.153087444645399e-11,  3.641700422267796e-12, -2.218327311384346e-13,  1.188399343285669e-14, -5.685809970774758e-16,
  2.459144772494446e-17, -9.697715662839433e-19,  3.265519825391149e-07, -1.294452742621323e-07,  2.725872736613856e-08, -3.899929443012655e-09,  4.226709901919133e-10,
 -3.689802348167181e-11,  2.698732945675458e-12, -1.699664300808084e-13,  9.404856045682467e-15, -4.643194434646395e-16,  2.070329458807505e-17, -8.408818089749532e-19,
  1.991905188899935e-07, -8.132448500802698e-08,  1.768482926504601e-08, -2.612671374868211e-09,  2.922060166090224e-10, -2.630277260101768e-11,  1.981989957224068e-12,
 -1.284921361887122e-13,  7.312594535746745e-15, -3.710096000323325e-16,  1.698674117468361e-17, -7.078548359470386e-19,  1.234417532753921e-07, -5.165190904325124e-08,
  1.153947733673714e-08, -1.751460134709440e-09,  2.011507969928235e-10, -1.858105376407611e-11,  1.435832596182894e-12, -9.539054814675621e-14,  5.559331159099391e-15,
 -2.886427162011589e-16,  1.351512038841628e-17, -5.755487118084573e-19,  7.685826648932176e-08, -3.280106386605363e-08,  7.489829288816010e-09, -1.161986981693124e-09,
  1.363569550250246e-10, -1.286353003186542e-11,  1.014583133556295e-12, -6.876029969538237e-14,  4.085633878947705e-15, -2.161534771192175e-16,  1.030747383335695e-17,
 -4.467828081223301e-19,  4.686844276378126e-08, -2.030453902133623e-08,  4.714416719946182e-09, -7.437827832640140e-10,  8.873508505776363e-11, -8.507215674807727e-12,
  6.816214685807956e-13, -4.690682077645637e-14,  2.828882621763885e-15, -1.518421761920157e-16,  7.343086255678070e-18, -3.226476149927975e-19,  2.621253899471200e-08,
 -1.147391084318664e-08,  2.695041793782900e-09, -4.301664736026697e-10,  5.191136574466880e-11, -5.032918449208139e-12,  4.076780623491647e-13, -2.835463879027316e-14,
  1.727783841734132e-15, -9.367577606947349e-17,  4.574572756221586e-18, -2.029108262894220e-19,  1.047444090787461e-08, -4.611278074137627e-09,  1.090096514908028e-09,
 -1.751245427427272e-10,  2.126879508741668e-11, -2.074957756678286e-12,  1.691014743540274e-13, -1.183107724113636e-14,  7.250850689893944e-16, -3.953269028191829e-17,
  1.941067460710357e-18, -8.655312893876653e-20,  8.005504945022379e-02, -2.694509921394744e-04,  9.515531411702050e-07, -3.486795211458883e-09,  1.310179077023106e-11,
 -4.998955744477713e-14,  1.922457507449020e-16, -7.415961105143230e-19,  2.860369004454801e-21, -1.101203157824723e-23,  4.226807730329506e-26, -1.616884923315215e-28,
  7.618144169946751e-02, -3.543103554741016e-04,  1.957807076345636e-06, -1.098184963553789e-08,  6.005840203496642e-11, -3.190768111009271e-13,  1.652692846912477e-15,
 -8.378657679361524e-18,  4.170604311976150e-20, -2.043156425820153e-22,  9.869082350498786e-25, -4.707029186825730e-27,  6.900082320114732e-02, -4.982242021699074e-04,
  4.012530042565000e-06, -2.998163292067551e-08,  2.098002248683759e-10, -1.397039448924676e-12,  8.944047925107459e-15, -5.542692005268352e-17,  3.340843197017746e-19,
 -1.965670621511221e-21,  1.132167823575840e-23, -6.397721575194765e-26,  5.950767694657851e-02, -6.589766633958928e-04,  7.074598096995719e-06, -6.678223447286102e-08,
  5.774904742526239e-10, -4.678999625738751e-12,  3.599909566309193e-14, -2.653769828370619e-16,  1.886597675198859e-18, -1.299729870962294e-20,  8.710130254084613e-23,
 -5.694843551074337e-25,  4.889456053055464e-02, -7.925110389788177e-04,  1.087054997101616e-05, -1.267214246522809e-07,  1.327100948790227e-09, -1.283149801940236e-11,
  1.164635244096328e-13, -1.003488016734863e-15,  8.274273586043723e-18, -6.568209927200772e-20,  5.042838134309181e-22, -3.758261362419187e-24,  3.830542243386881e-02,
 -8.665134711131340e-04,  1.484823415281042e-05, -2.103203953743009e-07,  2.626861486164329e-09, -2.987870248597179e-11,  3.156761715489376e-13, -3.139305496731393e-15,
  2.966439762473855e-17, -2.682249143150118e-19,  2.333326381571073e-21, -1.961091967695226e-23,  2.864218769388028e-02, -8.680164696157224e-04,  1.828983302326089e-05,
 -3.105711712589074e-07,  4.569728889132450e-09, -6.046536035114555e-11,  7.359365076594120e-13, -8.364740209349690e-15,  8.974332901757274e-17, -9.161197097264006e-19,
  8.952968120144434e-21, -8.416257762528365e-23,  2.046568439323381e-02, -8.033221158710698e-04,  2.053427745397723e-05, -4.131502095746357e-07,  7.088785982312266e-09,
 -1.081117907407455e-10,  1.502998062814860e-12, -1.936955974410326e-14,  2.341690453695752e-16, -2.679345766987298e-18,  2.921268317853934e-20, -3.051055784848701e-22,
  1.399413177626351e-02, -6.919673862941586e-04,  2.119249847550596e-05, -5.000491958119473e-07,  9.916795908118485e-09, -1.729497565157726e-10,  2.726465667073692e-12,
 -3.956980207163558e-14,  5.356140140094994e-16, -6.827359498180281e-18,  8.256338283717791e-20, -9.526889692997463e-22,  9.172595515843276e-03, -5.583349283295946e-04,
  2.025139257536075e-05, -5.552102329514300e-07,  1.262675546783780e-08, -2.500629960899469e-10,  4.441711748645641e-12, -7.216709827700962e-14,  1.087629333462551e-15,
 -1.536320108833216e-17,  2.050259119729251e-19, -2.601013551156139e-21,  5.774282101872512e-03, -4.243709614258660e-04,  1.803294942627380e-05, -5.695796976756909e-07,
  1.474874438492868e-08, -3.295905233699879e-10,  6.558446785411715e-12, -1.186603069160869e-13,  1.981232300747471e-15, -3.086642102950610e-17,  4.525335690139200e-19,
 -6.284613744317421e-21,  3.498697761770310e-03, -3.053670894881944e-04,  1.504997339564791e-05, -5.433716950017795e-07,  1.591445826205913e-08, -3.989747632496594e-10,
  8.847260459452678e-12, -1.773855568173236e-13,  3.266353502273674e-15, -5.588569531959312e-17,  8.964566228497884e-19, -1.357536739022714e-20,  2.045386775324566e-03,
 -2.090030904266078e-04,  1.183609043984678e-05, -4.849090114001737e-07,  1.596488004105829e-08, -4.465741889008293e-10,  1.098153326688333e-11, -2.428936814542603e-13,
  4.911867658418240e-15, -9.192773023485717e-17,  1.607316385686782e-18, -2.644544613237060e-20,  1.156862412922295e-03, -1.366714267609562e-04,  8.816955327402797e-06,
 -4.070739045192031e-07,  1.497814995389645e-08, -4.650857951523225e-10,  1.262401880207964e-11, -3.067230550423649e-13,  6.784857053555101e-15, -1.383830157255612e-16,
  2.628009429122058e-18, -4.682035227542490e-20,  6.349273484590029e-04, -8.576332547730609e-05,  6.252226741707297e-06, -3.232001511881949e-07,  1.321692870045451e-08,
 -4.533455329434232e-10,  1.352292727068125e-11, -3.594610433230562e-13,  8.664996950605374e-15, -1.919151227650068e-16,  3.945297996081982e-18, -7.586628367344700e-20,
  3.392545582067469e-04, -5.187168183281155e-05,  4.241250883381810e-06, -2.439702311568053e-07,  1.102981577021103e-08, -4.159589021736721e-10,  1.357752444425630e-11,
 -3.933088749550759e-13,  1.029411998144528e-14, -2.467402953380653e-16,  5.473019171512098e-18, -1.132429164740988e-19,  1.771067918775452e-04, -3.037379359612637e-05,
  2.765866013770458e-06, -1.760058094471349e-07,  8.752143082736281e-09, -3.612467018111134e-10,  1.285011973592697e-11, -4.041075270456438e-13,  1.144321401769767e-14,
 -2.958402775335600e-16,  7.058056383037355e-18, -1.566648117621324e-19,  9.068282141576058e-05, -1.729780913031037e-05,  1.742604755303360e-06, -1.219826975858052e-07,
  6.638866751656891e-09, -2.985820161266795e-10,  1.152766667970763e-11, -3.920866128028660e-13,  1.197044589852645e-14, -3.326965217268562e-16,  8.510626831771042e-18,
 -2.020486150421423e-19,  4.572852109868483e-05, -9.626083510345382e-06,  1.066059789217555e-06, -8.164320446192453e-08,  4.839831024750505e-09, -2.361501265775304e-10,
  9.856109011990249e-12, -3.612331644993793e-13,  1.184913356856244e-14, -3.528842020295359e-16,  9.649002402210917e-18, -2.442846687516728e-19,  2.280999822772384e-05,
 -5.259953170908292e-06,  6.365054712827097e-07, -5.304976091736825e-08,  3.409212580238509e-09, -1.796929779528402e-10,  8.075414144234417e-12, -3.177487533723207e-13,
  1.115956191737591e-14, -3.549578659019797e-16,  1.034215059304463e-17, -2.783877265736078e-19,  1.130685065911463e-05, -2.836327460730080e-06,  3.728396218402294e-07,
 -3.364355027367375e-08,  2.332953160047475e-09, -1.322647116377537e-10,  6.374876872447494e-12, -2.682979822273886e-13,  1.005375946160246e-14, -3.404125609769020e-16,
  1.053551461403645e-17, -3.006151375102716e-19,  5.596523408985142e-06, -1.517021885057689e-06,  2.153936101494846e-07, -2.093649207757241e-08,  1.559299991657170e-09,
 -9.468277938363828e-11,  4.874853929487617e-12, -2.186291237665626e-13,  8.710254518255044e-15, -3.128935179958120e-16,  1.025348134585266e-17, -3.091777708651336e-19,
  2.779647883899208e-06, -8.089782574703985e-07,  1.233781137042929e-07, -1.285337497551281e-08,  1.023425755694268e-09, -6.627261448316929e-11,  3.630262729781108e-12,
 -1.728364991190526e-13,  7.294676435202103e-15, -2.770582830212581e-16,  9.581799051113623e-18, -3.043682304202323e-19,  1.392213501060161e-06, -4.323523251050563e-07,
  7.044083230241610e-08, -7.825998218109350e-09,  6.630982607641390e-10, -4.559392142023730e-11,  2.646357096105443e-12, -1.332340457228175e-13,  5.935182225297842e-15,
 -2.375043246372548e-16,  8.639448071382937e-18, -2.881692927821903e-19,  7.066115267295307e-07, -2.327514729025206e-07,  4.029182563315422e-08, -4.750045339096859e-09,
  4.262900604151192e-10, -3.098662478480273e-11,  1.897771646443331e-12, -1.006374992536008e-13,  4.713955813562924e-15, -1.980269150376599e-16,  7.550390081156888e-18,
 -2.635659195508682e-19,  3.651098382519050e-07, -1.268188073058484e-07,  2.320145674818432e-08, -2.887905551054415e-09,  2.732166313764215e-10, -2.090123881163309e-11,
  1.344995516908274e-12, -7.482061653834300e-14,  3.670836029605633e-15, -1.612815091394008e-16,  6.422472670544713e-18, -2.338184706039836e-19,  1.928597657178587e-07,
 -7.024013165808912e-08,  1.350833031976493e-08, -1.766291612548504e-09,  1.753159521353848e-10, -1.405075486669532e-11,  9.458756245300710e-13, -5.496747460071407e-14,
  2.813372599512735e-15, -1.287817098628893e-16,  5.336200819527811e-18, -2.018878511699205e-19,  1.044964028865994e-07, -3.968483612811698e-08,  7.980045670957236e-09,
 -1.090546723261628e-09,  1.130114606240189e-10, -9.444724436873172e-12,  6.621674068948860e-13, -4.002634485654495e-14,  2.128387818969933e-15, -1.011010989610393e-16,
  4.342357309878378e-18, -1.700959443659105e-19,  5.819905280890923e-08, -2.292297088837455e-08,  4.793945474604736e-09, -6.811935919584941e-10,  7.333569094378869e-11,
 -6.360650225516574e-12,  4.623098196519340e-13, -2.894007888896173e-14,  1.591982592467998e-15, -7.815125666924197e-17,  3.465546146171151e-18, -1.400112569527384e-19,
  3.331929849771437e-08, -1.353899539377861e-08,  2.929012441610324e-09, -4.304976707882906e-10,  4.790619314149295e-11, -4.291240544363746e-12,  3.218303268206672e-13,
 -2.076880602623593e-14,  1.176738155915974e-15, -5.944684525991622e-17,  2.710496609324029e-18, -1.124968072672776e-19,  1.953924441619186e-08, -8.148634276295442e-09,
  1.813827084644219e-09, -2.742988525891747e-10,  3.139011239379111e-11, -2.889557068585977e-12,  2.225356785913949e-13, -1.473606153176885e-14,  8.560979311893814e-16,
 -4.431285215885825e-17,  2.068708055370254e-18, -8.784467015126444e-20,  1.161789044580768e-08, -4.947471778647760e-09,  1.127006222510251e-09, -1.744269059657248e-10,
  2.042055056802417e-11, -1.922006360466443e-12,  1.512569637138735e-13, -1.022886672666728e-14,  6.065125663927990e-16, -3.202293095536037e-17,  1.524041039702992e-18,
 -6.593483420050105e-20,  6.833497604865111e-09, -2.956691798004811e-09,  6.855340140228626e-10, -1.080022322694663e-10,  1.286702322688706e-11, -1.231915289443643e-12,
  9.857420289805395e-14, -6.774837230875060e-15,  4.080719727228068e-16, -2.187706320328802e-17,  1.056733217955216e-18, -4.637902582498684e-20,  3.725845576517101e-09,
 -1.629863308558892e-09,  3.825566468635354e-10, -6.101754367078763e-11,  7.358219508294585e-12, -7.129001082661486e-13,  5.770743598475500e-14, -4.010990040661024e-15,
  2.442515224807533e-16, -1.323435698659099e-17,  6.458934226530693e-19, -2.863241527280537e-20,  1.467695634127098e-09, -6.459565144312046e-10,  1.526537447163334e-10,
 -2.451589352926914e-11,  2.976477551709860e-12, -2.902885138747787e-13,  2.364999852712849e-14, -1.654144978718096e-15,  1.013459225699324e-16, -5.523879622276221e-18,
  2.711448978894469e-19, -1.208702264039036e-20,  7.899221026840691e-02, -2.620024438829055e-04,  9.109371706323250e-07, -3.284921078357441e-09,  1.214650860310241e-11,
 -4.561484759879778e-14,  1.727051561724488e-16, -6.560943348624667e-19,  2.492730506855788e-21, -9.455305989423475e-24,  3.576365916970981e-26, -1.348346835518458e-28,
  7.479471301038425e-02, -3.391591631409116e-04,  1.831586665994952e-06, -1.006988951731636e-08,  5.405526082344831e-11, -2.820831363598087e-13,  1.435721044965904e-15,
 -7.154518280233634e-18,  3.501405942035084e-20, -1.686862497640763e-22,  8.014485476312791e-25, -3.760497015521661e-27,  6.706992612502452e-02, -4.675080648086479e-04,
  3.672005611514087e-06, -2.683719933394547e-08,  1.838862759957061e-10, -1.199860087151490e-12,  7.531718398637491e-15, -4.578626462411442e-17,  2.708365478942036e-19,
 -1.564423511667319e-21,  8.848753922633505e-24, -4.911840889719314e-26,  5.698010116181443e-02, -6.054351676235590e-04,  6.325707670122141e-06, -5.824649296864661e-08,
  4.919818955940327e-10, -3.897775519526353e-12,  2.934791911647865e-14, -2.118659781201145e-16,  1.475807927203452e-18, -9.966910360522103e-21,  6.550378852041043e-23,
 -4.201603576278011e-25,  4.588929942590636e-02, -7.112868586697583e-04,  9.469292854171989e-06, -1.073980223085133e-07,  1.096292163929320e-09, -1.034567890066935e-11,
  9.174325263237681e-14, -7.729528686297485e-16,  6.236209276085572e-18, -4.846602699080517e-20,  3.644867541161715e-22, -2.661963699077650e-24,  3.506190798057118e-02,
 -7.571513526803322e-04,  1.255810433235907e-05, -1.726876268633561e-07,  2.098448497182954e-09, -2.325833220141790e-11,  2.397329098557495e-13, -2.328090808576875e-15,
  2.149928138495883e-17, -1.901080889384084e-19,  1.618239977481379e-21, -1.331544695060760e-23,  2.544079673666677e-02, -7.354483008103071e-04,  1.496467006507805e-05,
 -2.462444668201844e-07,  3.519631475231293e-09, -4.531709584795622e-11,  5.374245385090324e-13, -5.958166981272063e-15,  6.240646608692876e-17, -6.224074673102796e-19,
  5.946620552966280e-21, -5.468354277208941e-23,  1.755206538388888e-02, -6.571034103814120e-04,  1.619152376662503e-05, -3.152378421030247e-07,  5.247364887354658e-09,
 -7.778292230460325e-11,  1.052525105886386e-12, -1.321780850303583e-14,  1.558673796464656e-16, -1.741007183997291e-18,  1.854399996188520e-20, -1.893312460556792e-22,
  1.153082689996483e-02, -5.439739145839041e-04,  1.604033895187904e-05, -3.658416704936850e-07,  7.031530958456770e-09, -1.190794482256168e-10,  1.825626376802433e-12,
 -2.579919350984327e-14,  3.403881801363110e-16, -4.232942695203277e-18,  4.997843732662188e-20, -5.634490322758760e-22,  7.225473214178435e-03, -4.198850116770142e-04,
  1.465303839916305e-05, -3.880225367025906e-07,  8.546177961726320e-09, -1.642367328094853e-10,  2.835253250868083e-12, -4.482911864184941e-14,  6.581938178497728e-16,
 -9.065976121132276e-18,  1.180755405289755e-19, -1.462964814602449e-21,  4.327104135494045e-03, -3.038860745488576e-04,  1.242124292559901e-05, -3.787948326832676e-07,
  9.494923085891666e-09, -2.058075686384228e-10,  3.978589592486388e-12, -7.002425428118653e-14,  1.138626531255468e-15, -1.729253555878393e-17,  2.473564646864578e-19,
 -3.354192581837634e-21,  2.482129469616151e-03, -2.072594954647873e-04,  9.827198462366540e-06, -3.425373005944330e-07,  9.709964130114234e-09, -2.360686336935677e-10,
  5.084642718773576e-12, -9.915347529940974e-14,  1.777819072902515e-15, -2.964785569582939e-17,  4.639532100785656e-19, -6.859568566384395e-21,  1.367238951825578e-03,
 -1.338436154748482e-04,  7.295831455963574e-06, -2.886308961797657e-07,  9.198349377661767e-09, -2.495331513574950e-10,  5.960328415275473e-12, -1.282251468397491e-13,
  2.524946043568493e-15, -4.606153470044882e-17,  7.857229481721488e-19, -1.262264410590529e-20,  7.252489163398328e-04, -8.221414376646090e-05,  5.109306536392014e-06,
 -2.279066659945700e-07,  8.120165099258107e-09, -2.446008184327882e-10,  6.450668346976201e-12, -1.524767406113910e-13,  3.285054040108944e-15, -6.532302853143417e-17,
  1.210550983678602e-18, -2.106307758697653e-20,  3.716392871269391e-04, -4.825358779396881e-05,  3.392410541789239e-06, -1.695612565916963e-07,  6.718605464261999e-09,
 -2.236790796284951e-10,  6.485641664052518e-12, -1.677924158156795e-13,  3.941049655187805e-15, -8.513475178630697e-17,  1.708517266338776e-18, -3.209873148720441e-20,
  1.846130653912150e-04, -2.718555870042962e-05,  2.146467687213742e-06, -1.195081057941143e-07,  5.239579905013224e-09, -1.919345203703800e-10,  6.094039155916210e-12,
 -1.719218413012969e-13,  4.387014270265169e-15, -1.026179008990540e-16,  2.223276879775074e-18, -4.496911177482737e-20,  8.924291141720630e-05, -1.477125224890755e-05,
  1.300897663047074e-06, -8.022633697179671e-08,  3.872963312731809e-09, -1.554273490664490e-10,  5.382659214516598e-12, -1.649899328212432e-13,  4.558582635360406e-15,
 -1.150976602584277e-16,  2.684051076374952e-18, -5.827988638754857e-20,  4.215723046577363e-05, -7.778350010731923e-06,  7.591795534040037e-07, -5.157745749185753e-08,
  2.728702329624191e-09, -1.194615500506441e-10,  4.495110054915297e-12, -1.491729641057098e-13,  4.447899514192104e-15, -1.208418014477272e-16,  3.024190300010715e-18,
 -7.029361281662410e-20,  1.954907353641077e-05, -3.989887034945635e-06,  4.289153366323050e-07, -3.193342654089287e-08,  1.842893353620376e-09, -8.764949129565649e-11,
  3.569834803722431e-12, -1.278066770623469e-13,  4.098989784207592e-15, -1.194573891964459e-16,  3.198823532497899e-18, -7.936893120366632e-20,  8.942374388677703e-06,
 -2.004230932264053e-06,  2.359071203848409e-07, -1.914912532017709e-08,  1.200002660615163e-09, -6.174662244057150e-11,  2.711737072359699e-12, -1.043696238553008e-13,
  3.588533580888459e-15, -1.118325784983859e-16,  3.194773073872848e-18, -8.437603386172368e-20,  4.056090744673662e-06, -9.914250726619870e-07,  1.270416393230768e-07,
 -1.118678158481091e-08,  7.578003473017430e-10, -4.201214820502312e-11,  1.981925381636481e-12, -8.171235513550588e-14,  3.001891061372858e-15, -9.972035984416927e-17,
  3.029974552926902e-18, -8.493402582086244e-20,  1.834293696011544e-06, -4.857354123012897e-07,  6.738305122643111e-08, -6.404780934003479e-09,  4.668879136142915e-10,
 -2.777281794206257e-11,  1.401957395086357e-12, -6.169333990850347e-14,  2.413388844945336e-15, -8.518182075986073e-17,  2.744379106772673e-18, -8.140750781635684e-20,
  8.317873809357067e-07, -2.371065870643623e-07,  3.541389170417729e-08, -3.615569726884684e-09,  2.823438800587289e-10, -1.794530260393731e-11,  9.655262666795284e-13,
 -4.518205884213544e-14,  1.875501024088347e-15, -7.010059674028312e-17,  2.387148616886597e-18, -7.470527321415491e-20,  3.804299705101426e-07, -1.160139186294541e-07,
  1.855496093391030e-08, -2.024724165760995e-09,  1.686072364242099e-10, -1.140147421824462e-11,  6.512243752706100e-13, -3.228371151078119e-14,  1.416874538128611e-15,
 -5.588906128388224e-17,  2.005002414728067e-18, -6.598775434961915e-20,  1.765230572458298e-07, -5.724172662214149e-08,  9.750701866571383e-09, -1.131577194993339e-09,
  1.000205433523527e-10, -7.164631024924583e-12,  4.326442318487289e-13, -2.263266870302997e-14,  1.046310644648007e-15, -4.340078723239784e-17,  1.634667498927549e-18,
 -5.639280416327560e-20,  8.357442442447003e-08, -2.864775331065205e-08,  5.169412952229811e-09, -6.348163163118957e-10,  5.927824529554698e-11, -4.477949958188339e-12,
  2.846692823848873e-13, -1.565093370470565e-14,  7.592091432401031e-16, -3.299348209359509e-17,  1.300032601858676e-18, -4.684909629667999e-20,  4.058859697902062e-08,
 -1.462204668106408e-08,  2.779921084729296e-09, -3.594031418925078e-10,  3.528361813669906e-11, -2.797957674820086e-12,  1.864332004993173e-13, -1.072744673159622e-14,
  5.438346299128160e-16, -2.466516504009815e-17,  1.012947668046995e-18, -3.799500488300976e-20,  2.031378432123093e-08, -7.647317626991359e-09,  1.523484876763534e-09,
 -2.062888155434451e-10,  2.118660154061173e-11, -1.755330242545493e-12,  1.220375338554671e-13, -7.317295416029168e-15,  3.860586965160815e-16, -1.819996617888204e-17,
  7.760001382022106e-19, -3.018306752133039e-20,  1.051213285553831e-08, -4.112378270614016e-09,  8.537644950641846e-10, -1.204388839221927e-10,  1.287485264075369e-11,
 -1.109053187727128e-12,  8.007631416631792e-14, -4.980647478892836e-15,  2.722901618839288e-16, -1.328698021387608e-17,  5.857932789941535e-19, -2.353456113548620e-20,
  5.631910099304107e-09, -2.276937761330061e-09,  4.898928268654818e-10, -7.161091391720920e-11,  7.926550447835528e-12, -7.063616137987229e-13,  5.271004250003654e-14,
 -3.385090982320039e-15,  1.908972690190031e-16, -9.600110635647299e-18,  4.358007202616193e-19, -1.801097697126284e-20,  3.116541756662428e-09, -1.295112414130438e-09,
  2.871626536390765e-10, -4.325833669553110e-11,  4.931613772652335e-12, -4.522971739846094e-13,  3.470862322018052e-14, -2.290409807405377e-15,  1.326164061811550e-16,
 -6.842143928389337e-18,  3.184164642778464e-19, -1.348008232969541e-20,  1.765222415563355e-09, -7.499837476255449e-10,  1.704065732100537e-10, -2.630659255535766e-11,
  3.072074582588363e-12, -2.884437787101470e-13,  2.264616761841143e-14, -1.527956877142047e-15,  9.039792148304863e-17, -4.762608048851165e-18,  2.261906697344937e-19,
 -9.766023903710009e-21,  9.994147372935670e-10, -4.318406468333088e-10,  9.997595753183579e-11, -1.572700925434257e-11,  1.870897225721058e-12, -1.788656643142297e-13,
  1.429226109557842e-14, -9.809471725015466e-16,  5.900787899902093e-17, -3.159408360652788e-18,  1.524200693781142e-19, -6.681531028043951e-21,  5.304266017615408e-10,
 -2.318778020767830e-10,  5.438462784386534e-11, -8.667722211415484e-12,  1.044473695561800e-12, -1.011194926702874e-13,  8.179507224453940e-15, -5.681252165350185e-16,
  3.457282200613895e-17, -1.872032064345542e-18,  9.130442414251997e-20, -4.044992121956309e-21,  2.058014154949836e-10, -9.054969967140194e-11,  2.139171780941290e-11,
 -3.434298381393132e-12,  4.168174834760838e-13, -4.063761279228846e-14,  3.309686800185399e-15, -2.314138695233966e-16,  1.417375003875664e-17, -7.723035114404247e-19,
  3.789772706311091e-20, -1.688892213051904e-21,  7.795853040825668e-02, -2.548693867810430e-04,  8.726547895405545e-07, -3.097656196584227e-09,  1.127421815117732e-11,
 -4.168166276353575e-14,  1.554019892113200e-16, -5.815083096370761e-19,  2.176722181330210e-21, -8.136596738961620e-24,  3.033268080213292e-26, -1.127321635542029e-28,
  7.346663663971920e-02, -3.249755384109206e-04,  1.715757005669494e-06, -9.248332368605819e-09,  4.874257601181906e-11, -2.499085363071040e-13,  1.250210208910786e-15,
 -6.125353957748813e-18,  2.948065993856786e-20, -1.397052374499831e-22,  6.530260373660323e-25, -3.015078342772649e-27,  6.525667461405760e-02, -4.393719504908334e-04,
  3.366851058338605e-06, -2.407759408013200e-08,  1.615976925551419e-10, -1.033553382839882e-12,  6.363034721909603e-15, -3.795630186655106e-17,  2.204001543949084e-19,
 -1.250163071216519e-21,  6.945988137416688e-24, -3.788372314778319e-26,  5.465532649192120e-02, -5.574972044706152e-04,  5.671526161387404e-06, -5.096208206492332e-08,
  4.206156098374515e-10, -3.259590223595702e-12,  2.402629909549281e-14, -1.699094248558254e-16,  1.160024641014750e-18, -7.682071264907384e-21,  4.952649403749983e-23,
 -3.117402295793160e-25,  4.318789960706938e-02, -6.404044125756311e-04,  8.279300837074681e-06, -9.139999561871006e-08,  9.097539593797907e-10, -8.382519832377167e-12,
  7.265090491597502e-14, -5.987108052034596e-16,  4.727901764024359e-18, -3.598425778735965e-20,  2.651525353429743e-22, -1.898202280017405e-24,  3.222186960476248e-02,
 -6.644381723902731e-04,  1.067290863864753e-05, -1.425420139287422e-07,  1.685914125073740e-09, -1.821514338728284e-11,  1.832320266840970e-13, -1.738185302339718e-15,
  1.569194191993350e-17, -1.357358196162221e-19,  1.130902319508895e-21, -9.112665630645752e-24,  2.272098980864927e-02, -6.266579298528313e-04,  1.231983612456772e-05,
 -1.965332086956207e-07,  2.729842343307411e-09, -3.421436108352841e-11,  3.954874234405157e-13, -4.278084203696763e-15,  4.375868980066404e-17, -4.265096647654038e-19,
  3.984952980595794e-21, -3.585559000041043e-23,  1.516062767476040e-02, -5.413852524437322e-04,  1.286520489341841e-05, -2.424691665983724e-07,  3.917018993165490e-09,
 -5.645305781872505e-11,  7.437661959045108e-13, -9.104559306639347e-15,  1.047522577486926e-16, -1.142538766390846e-18,  1.189170913271271e-20, -1.187157099148854e-22,
  9.586252267045276e-03, -4.314656960974204e-04,  1.225376342785256e-05, -2.702344108317521e-07,  5.035390051747113e-09, -8.283022291331806e-11,  1.235327503189644e-12,
 -1.700290045133770e-14,  2.187164880470144e-16, -2.654119554028401e-18,  3.060305823864199e-20, -3.371618256995035e-22,  5.753872537704888e-03, -3.191888028064448e-04,
  1.071971006585899e-05, -2.742519152501804e-07,  5.851361632245217e-09, -1.091450581465405e-10,  1.831679340272238e-12, -2.819000893081275e-14,  4.033048829405583e-16,
 -5.418036526802806e-18,  6.887927223590959e-20, -8.336443353092002e-22,  3.284783683331778e-03, -2.203978173934445e-04,  8.666532140050701e-06, -2.552164986800494e-07,
  6.193883350467586e-09, -1.302457672877534e-10,  2.446534393682177e-12, -4.189485930345874e-14,  6.635412310973683e-16, -9.825155963264579e-18,  1.371411925392389e-19,
 -1.816057033241651e-21,  1.787598434031009e-03, -1.427625921645285e-04,  6.512253655769665e-06, -2.191582444714407e-07,  6.013487832581297e-09, -1.417955797830347e-10,
  2.966832456613289e-12, -5.627649668714178e-14,  9.826253251934455e-16, -1.597372195657323e-17,  2.438826021231793e-19, -3.520807777100187e-21,  9.297508871514727e-04,
 -8.716354579174481e-05,  4.572807926515412e-06, -1.746844705662828e-07,  5.388745984964525e-09, -1.417782222717269e-10,  3.289584553824705e-12, -6.883548077097997e-14,
  1.319952421731467e-15, -2.347192969666548e-17,  3.906362370354969e-19, -6.127728113671185e-21,  4.635092875679560e-04, -5.039409594124002e-05,  3.016266992646379e-06,
 -1.299712201731328e-07,  4.483748742904641e-09, -1.310170181884219e-10,  3.356903716828162e-12, -7.719228627799147e-14,  1.619741116600096e-15, -3.140076337066301e-17,
  5.678307677533497e-19, -9.648891199200173e-21,  2.222091925513598e-04, -2.771783136426071e-05,  1.878610592305067e-06, -9.076806644336636e-08,  3.484178004899076e-09,
 -1.125719432655888e-10,  3.172412652614088e-12, -7.987286902057383e-14,  1.827754991222590e-15, -3.850578434510436e-17,  7.542945203184406e-19, -1.384428012388554e-20,
  1.028154084008997e-04, -1.457225422585569e-05,  1.110564997830909e-06, -5.982738815374323e-08,  2.543000379729833e-09, -9.046373189636759e-11,  2.793299643077558e-12,
 -7.673143403050303e-14,  1.908610112377924e-15, -4.356145644849231e-17,  9.216956414984196e-19, -1.822125947928781e-20,  4.609999765355784e-05, -7.358880917023714e-06,
  6.264685989261040e-07, -3.742508593232060e-08,  1.753347175842485e-09, -6.839202856937270e-11,  2.305228058219339e-12, -6.885387318630987e-14,  1.855722580790220e-15,
 -4.574821939290043e-17,  1.042549914614977e-18, -2.213970927859295e-20,  2.011982753946383e-05, -3.587955462037137e-06,  3.390666965658228e-07, -2.234553902447654e-08,
  1.148656749348401e-09, -4.893141243361008e-11,  1.793795639623782e-12, -5.806072510090933e-14,  1.690222089375098e-15, -4.487431405941618e-17,  1.098353524691083e-18,
 -2.498849148033116e-20,  8.589092847745104e-06, -1.698196565651429e-06,  1.770839246547922e-07, -1.280943585297158e-08,  7.192816945506358e-10, -3.332962505054704e-11,
  1.324091627278902e-12, -4.628789198800845e-14,  1.450929632906114e-15, -4.136312242932560e-17,  1.084339638598899e-18, -2.635881634319079e-20,  3.605578339023298e-06,
 -7.847395184404518e-07,  8.977775154931905e-08, -7.092800690153500e-09,  4.331674004843113e-10, -2.174724404939287e-11,  9.328672902089158e-13, -3.510334437282896e-14,
  1.181074487981029e-15, -3.604678010506852e-17,  1.009254011368564e-18, -2.614275691123579e-20,  1.496902839873478e-06, -3.561981676101832e-07,  4.445885122339758e-08,
 -3.817605130184934e-09,  2.524682566280636e-10, -1.367888524281368e-11,  6.312577346599198e-13, -2.548211370845904e-14,  9.173278787853493e-16, -2.988283565599872e-17,
  8.910205069670594e-19, -2.452629500669747e-20,  6.183861342404348e-07, -1.598290684799496e-07,  2.164549026246198e-08, -2.010413328845309e-09,  1.433450455216330e-10,
 -8.348003399156261e-12,  4.129195094704432e-13, -1.781903458160914e-14,  6.840853167382735e-16, -2.371186809975744e-17,  7.507185929531569e-19, -2.189684316564916e-20,
  2.558458584109502e-07, -7.136906176102149e-08,  1.043083409695381e-08, -1.042854165147046e-09,  7.981556341019948e-11, -4.975922137991215e-12,  2.628037639988464e-13,
 -1.208057701548861e-14,  4.929262549301215e-16, -1.812170887873356e-17,  6.073265352555250e-19, -1.871570717410369e-20,  1.067256796266262e-07, -3.193308579112702e-08,
  5.009709006281764e-09, -5.365255587605841e-10,  4.388080495516396e-11, -2.916313978700748e-12,  1.638198903343651e-13, -7.991968165134415e-15,  3.453753078953751e-16,
 -1.342196773335734e-17,  4.746346140825245e-19, -1.540583790328787e-20,  4.519738824718419e-08, -1.441725755666233e-08,  2.414790915736782e-09, -2.756699910839783e-10,
  2.398301350919551e-11, -1.691886915032335e-12,  1.006740120614135e-13, -5.192368337506699e-15,  2.367856827259088e-16, -9.693197095743378e-18,  3.604720083123350e-19,
 -1.228387095539289e-20,  1.956505033206690e-08, -6.613724459742480e-09,  1.176293078514099e-09, -1.424217611999073e-10,  1.311826517342886e-11, -9.779637425941596e-13,
  6.138365674756852e-14, -3.333644063593132e-15,  1.598071140830971e-16, -6.865907472759737e-18,  2.675650799881470e-19, -9.540087689972313e-21,  8.714053260339499e-09,
 -3.103228583345320e-09,  5.828774758714816e-10, -7.446600293871228e-11,  7.226639649576570e-12, -5.667099218208901e-13,  3.735667210278193e-14, -2.127307704042586e-15,
  1.067694250138025e-16, -4.795789634354274e-18,  1.951201273899908e-19, -7.253119375150734e-21,  4.016991288868285e-09, -1.498252629075484e-09,  2.955496796470778e-10,
 -3.963173188176150e-11,  4.032014833797826e-12, -3.310137419190184e-13,  2.281084952766534e-14, -1.356097855179716e-15,  7.095992215645288e-17, -3.318726635978990e-18,
  1.404171943391420e-19, -5.421231931571511e-21,  1.925647053043430e-09, -7.478946772002186e-10,  1.540695860648507e-10, -2.156804596532006e-11,  2.288434406112393e-12,
 -1.957048167398131e-13,  1.403167761316997e-14, -8.668615408352634e-16,  4.708182649055782e-17, -2.282971247308474e-18,  1.000375179179506e-19, -3.995423927146016e-21,
  9.625047395919340e-10, -3.870440436798629e-10,  8.278957571563255e-11, -1.203194758222858e-11,  1.324292658883494e-12, -1.173661917518997e-13,  8.711672838639614e-15,
 -5.566041410871298e-16,  3.123327189634170e-17, -1.563172990676381e-18,  7.063183887475047e-20, -2.906046501872398e-21,  5.011371161951076e-10, -2.074654958965619e-10,
  4.581064256048896e-11, -6.872495337292183e-12,  7.803331834214184e-13, -7.128715411255346e-14,  5.449716082820117e-15, -3.583039019115203e-16,  2.067231811012305e-17,
 -1.062889025824945e-18,  4.929961481798383e-20, -2.080382841796297e-21,  2.696786617307754e-10, -1.142952121023739e-10,  2.589889712794355e-11, -3.987298649688356e-12,
  4.643970451803227e-13, -4.349043765338202e-14,  3.405930189340952e-15, -2.292420765531089e-16,  1.353060356302274e-17, -7.112322889503473e-19,  3.370393422977180e-20,
 -1.452097719548971e-21,  1.466468561237886e-10, -6.327420957021102e-11,  1.462533247035660e-11, -2.297002016385162e-12,  2.728242600223212e-13, -2.604324562936144e-14,
  2.077891348278571e-15, -1.424099287394500e-16,  8.554530965707753e-18, -4.574060221241958e-19,  2.203768789145431e-20, -9.648203583037116e-22,  7.563983078004684e-11,
 -3.304260319597718e-11,  7.743621360654185e-12, -1.233171047856564e-12,  1.484811653386291e-13, -1.436388115270589e-14,  1.161008731920204e-15, -8.058095930220004e-17,
  4.900177244878500e-18, -2.651473282132921e-19,  1.292322846980994e-20, -5.721513434076225e-22,  2.887895201415704e-11, -1.270239610358160e-11,  2.999799887121497e-12,
 -4.814267796582521e-13,  5.840967327868774e-14, -5.692667682935216e-15,  4.634745966223726e-16, -3.239534297299410e-17,  1.983512520558717e-18, -1.080433337759568e-19,
  5.300119923358374e-21, -2.361240131525928e-22,  7.695278416328954e-02, -2.480338314413003e-04,  8.365383718519310e-07, -2.923740525749749e-09,  1.047660207226072e-11,
 -3.813979330466961e-14,  1.400525078190858e-16, -5.163150718672355e-19,  1.904500477530030e-21, -7.016870880501239e-24,  2.578638964550982e-26, -9.449053788523112e-29,
  7.219350195423697e-02, -3.116805138896976e-04,  1.609296490955111e-06, -8.506862697383685e-09,  4.403109528370955e-11, -2.218594812883157e-13,  1.091186043832325e-15,
 -5.257650003569894e-18,  2.489116723064495e-20, -1.160539889102067e-22,  5.338240863120785e-25, -2.425835415642045e-27,  6.355128657993671e-02, -4.135504307986342e-04,
  3.092777086159944e-06, -2.164944966323465e-08,  1.423716174399821e-10, -8.928366459333503e-13,  5.392595889648291e-15, -3.157306430644181e-17,  1.800184114544468e-19,
 -1.002979012740559e-21,  5.475300252647157e-24, -2.934872154454830e-26,  5.251236420552835e-02, -5.144615264341596e-04,  5.098306187796913e-06, -4.472398166386849e-08,
  3.608254044706825e-10, -2.736096465251766e-12,  1.974952902612035e-14, -1.368564552177953e-16,  9.160554268589481e-19, -5.950233052546985e-21,  3.764116430498609e-23,
 -2.325613423863787e-25,  4.075213765969818e-02, -5.783219056228606e-04,  7.264596818782573e-06, -7.809580545181369e-08,  7.582654335155690e-10, -6.824096496317104e-12,
  5.782405553453514e-14, -4.662507280458532e-16,  3.604836719511409e-18, -2.687709763585096e-20,  1.940996577108415e-22, -1.362427922220065e-24,  2.972466300823069e-02,
 -5.854645641832488e-04,  9.112961328474795e-06, -1.182584578816109e-07,  1.361919907856989e-09, -1.434908428912265e-11,  1.409162075357500e-13, -1.306224351353429e-15,
  1.153154337787415e-17, -9.760509478341882e-20,  7.961813314252242e-22, -6.284278061578624e-24,  2.039752262441021e-02, -5.368391642529250e-04,  1.020248674134963e-05,
 -1.578523654416696e-07,  2.131530739226676e-09, -2.601502714772380e-11,  2.931993614555747e-13, -3.095552840855262e-15,  3.093007078156495e-17, -2.947053076661202e-19,
  2.693385161960409e-21, -2.371872592309562e-23,  1.318390073384331e-02, -4.491166158254987e-04,  1.029726994429871e-05, -1.879397978712508e-07,  2.947620104698322e-09,
 -4.131797636216250e-11,  5.301838859426720e-13, -6.328112691168180e-15,  7.105749173641754e-17, -7.569997825997648e-19,  7.701048790344936e-21, -7.519063776792619e-23,
  8.037691748309161e-03, -3.451534000697160e-04,  9.444487682068177e-06, -2.014588304711234e-07,  3.640442944159391e-09, -5.818496514323781e-11,  8.443972097581572e-13,
 -1.132274907228734e-14,  1.420403104295229e-16, -1.682390122565653e-18,  1.894849595405190e-20, -2.040536503865060e-22,  4.629835779331255e-03, -2.451552596441816e-04,
  7.925444271537915e-06, -1.959490946371179e-07,  4.050964666919639e-09, -7.336109783431701e-11,  1.197129667514692e-12, -1.793763082414476e-14,  2.501170699193018e-16,
 -3.277854158769829e-18,  4.068392052467962e-20, -4.810762795899176e-22,  2.524601800722469e-03, -1.618102807464287e-04,  6.121924620658005e-06, -1.741229210598267e-07,
  4.092258448885592e-09, -8.349876205247337e-11,  1.524300957244210e-12, -2.540093392898790e-14,  3.919284341443812e-16, -5.659055670570818e-18,  7.709102367608869e-20,
 -9.970700359219015e-22,  1.306141820661673e-03, -9.974130623398960e-05,  4.377272773186755e-06, -1.422390077247277e-07,  3.778312448087030e-09, -8.641818035403848e-11,
  1.756706941611393e-12, -3.241710231081322e-14,  5.512751620546386e-16, -8.736719701715657e-18,  1.301557568182678e-19, -1.834877549132309e-21,  6.428022833600468e-04,
 -5.769076804220737e-05,  2.912631773498242e-06, -1.074379103598496e-07,  3.208271415069071e-09, -8.186868542539096e-11,  1.845285914898691e-12, -3.756029061426789e-14,
  7.014023904733448e-16, -1.215867309260905e-17,  1.974354897107823e-19, -3.024257636704085e-21,  3.018064006874292e-04, -3.145696771554254e-05,  1.812979927860481e-06,
 -7.545804372459423e-08,  2.520341421585974e-09, -7.143712425246572e-11,  1.778240428485245e-12, -3.977919412405988e-14,  8.129361875132643e-16, -1.536449885290953e-17,
  2.711161787535699e-19, -4.499136924102598e-21,  1.356393613538956e-04, -1.624569357554500e-05,  1.061154184173040e-06, -4.955195720890209e-08,  1.842361266386185e-09,
 -5.776098427782056e-11,  1.581908493020926e-12, -3.875629592065204e-14,  8.639821957666375e-16, -1.774977430140060e-17,  3.393740877054879e-19, -6.084682339779755e-21,
  5.856969365821655e-05, -7.984772747396686e-06,  5.871241926068758e-07, -3.059376878663583e-08,  1.260425094283134e-09, -4.353353729162082e-11,  1.307003276162740e-12,
 -3.495338079660785e-14,  8.473666727817900e-16, -1.886792127063477e-17,  3.898192222347818e-19, -7.531221595343189e-21,  2.440103943225910e-05, -3.753875789459643e-06,
  3.087495704677638e-07, -1.785999787908588e-08,  8.117366645286837e-10, -3.076629708715991e-11,  1.009032399256109e-12, -2.936066766613566e-14,  7.717253611012261e-16,
 -1.857179961227768e-17,  4.135091046207574e-19, -8.586587294787126e-21,  9.854098084891027e-06, -1.697107773105669e-06,  1.551915400375245e-07, -9.916239625161257e-09,
  4.950641798580236e-10, -2.051241712329274e-11,  7.323566434676120e-13, -2.311271583442983e-14,  6.567151349542338e-16, -1.703328534273204e-17,  4.076397823114804e-19,
 -9.075104624550298e-21,  3.877400845891383e-06, -7.420344931474570e-07,  7.500706490831389e-08, -5.268395054383448e-09,  2.876994074433811e-10, -1.298228993101488e-11,
  5.028551849537287e-13, -1.715790842065974e-14,  5.254574400031673e-16, -1.464814108256879e-17,  3.758060009967825e-19, -8.947154202559120e-21,  1.495016283831101e-06,
 -3.156960763837622e-07,  3.507859591966654e-08, -2.695575458399207e-09,  1.603399441333216e-10, -7.850130352907213e-12,  3.287457930180058e-13, -1.208902697106683e-14,
  3.978487986021074e-16, -1.188685245706452e-17,  3.260568288946839e-19, -8.280434529938273e-21,  5.683615334966683e-07, -1.315447724589581e-07,  1.598013963799505e-08,
 -1.337159790640160e-09,  8.627574788410384e-11, -4.565638913330346e-12,  2.059983738379320e-13, -8.137632662830113e-15,  2.869186521106493e-16, -9.161456603167279e-18,
  2.679480602849239e-19, -7.239587255924468e-21,  2.144814319636760e-07, -5.405704547774022e-08,  7.141225302361936e-09, -6.476431322412746e-10,  4.513656402439142e-11,
 -2.571866165817426e-12,  1.245787181804850e-13, -5.269113686547793e-15,  1.984144033395826e-16, -6.750690613611167e-18,  2.099265150255458e-19, -6.018077671219383e-21,
  8.092052042301084e-08, -2.206975179982827e-08,  3.153769908074269e-09, -3.085385537770046e-10,  2.312772249503704e-11, -1.413348738735593e-12,  7.322946948702742e-14,
 -3.304796412735777e-15,  1.324778927246242e-16, -4.787913101284555e-18,  1.578402591450968e-19, -4.787471309078331e-21,  3.075561344185859e-08, -9.020994418818162e-09,
  1.387067482629447e-09, -1.456875293575316e-10,  1.169435915236715e-11, -7.633530713584275e-13,  4.214548306086885e-14, -2.022167635594622e-15,  8.600062879653296e-17,
 -3.290975710666186e-18,  1.146573544335700e-19, -3.668542570962320e-21,  1.186877292902725e-08, -3.721157592783625e-09,  6.123686844897332e-10, -6.871785479977742e-11,
  5.880263473384929e-12, -4.082701801004040e-13,  2.392422348444235e-14, -1.215843715318817e-15,  5.466298196881921e-17, -2.207247509245687e-18,  8.100459485464127e-20,
 -2.725420362219472e-21,  4.687839460731690e-09, -1.561572183309914e-09,  2.735505745226148e-10, -3.263294800996102e-11,  2.962982077712152e-12, -2.178574177529668e-13,
  1.349332156675494e-14, -7.234561716666271e-16,  3.425437091781958e-17, -1.454234163593031e-18,  5.602243994017352e-20, -1.975425183679875e-21,  1.910001634084528e-09,
 -6.719405876585506e-10,  1.246096479853831e-10, -1.572152122816720e-11,  1.507314901850508e-12, -1.168264787193453e-13,  7.614511341978071e-15, -4.289158579461326e-16,
  2.130216129103351e-17, -9.471767886718284e-19,  3.816090154757599e-20, -1.405204450022510e-21,  8.086684004782834e-10, -2.986601038165731e-10,  5.830344212524254e-11,
 -7.738309017227251e-12,  7.794592315380678e-13, -6.337658436781782e-14,  4.326932077478440e-15, -2.549330908698264e-16,  1.322453527272238e-17, -6.133391206289331e-19,
  2.574158978780038e-20, -9.861086449201938e-22,  3.580028920482182e-10, -1.379791767665336e-10,  2.819148429849791e-11, -3.914531375976857e-12,  4.120693379287729e-13,
 -3.497077070671911e-14,  2.488837292398939e-15, -1.526614583653340e-16,  8.234397859047094e-18, -3.966248496029545e-19,  1.726796570732413e-20, -6.853934878814035e-22,
  1.664202762356241e-10, -6.653843347460664e-11,  1.414467559209069e-11, -2.043050444260966e-12,  2.235216830951614e-13, -1.969475298696847e-14,  1.453660783185565e-15,
 -9.237264919443945e-17,  5.156193760450474e-18, -2.567498448140446e-19,  1.154433091420143e-20, -4.727285365843231e-22,  8.127754314352919e-11, -3.351228386889943e-11,
  7.367276177558024e-12, -1.100387946086655e-12,  1.244074404874173e-13, -1.131792469394425e-14,  8.617388753937868e-16, -5.643605061190690e-17,  3.243794235391171e-18,
 -1.661747947492722e-19,  7.680438802766702e-21, -3.230019494919370e-22,  4.143987237534463e-11, -1.751685362394739e-11,  3.957761168458737e-12, -6.075596125100183e-13,
  7.056155000597779e-14, -6.589844013499900e-15,  5.147023247709863e-16, -3.455336218791832e-17,  2.034345400961499e-18, -1.066757005698883e-19,  5.043302227762764e-21,
 -2.167933386021273e-22,  2.159308661465035e-11, -9.302574360654880e-12,  2.146562677765899e-12, -3.365573872275052e-13,  3.990751874743191e-14, -3.803291650090875e-15,
  3.029705580218189e-16, -2.073249144849679e-17,  1.243544652479815e-18, -6.639583785529960e-20,  3.194464409587414e-21, -1.396663583646336e-22,  1.080547534220186e-11,
 -4.716699933899492e-12,  1.104434219014727e-12, -1.757310246314446e-13,  2.114129303389299e-14, -2.043502827152136e-15,  1.650407740175294e-16, -1.144589665002867e-17,
  6.955046689289193e-19, -3.760585528259324e-20,  1.831589064254055e-21, -8.103380121446914e-23,  4.055548891348017e-12, -1.783254036811474e-12,  4.209794655934449e-13,
 -6.753634066280602e-14,  8.190904753510807e-15, -7.980040383323387e-16,  6.494715627503832e-17, -4.538002140764059e-18,  2.777588972647695e-19, -1.512463582539429e-20,
  7.417021201668009e-22, -3.303270731396260e-23,  7.597381519524253e-02, -2.414790711858283e-04,  8.024346455215699e-07, -2.762039425393302e-09,  9.746282431579497e-12,
 -3.494535479548606e-14,  1.264123002906582e-16, -4.592215530945486e-19,  1.669500066633077e-21, -6.063916819314479e-24,  2.197119036782989e-26, -7.939535996380500e-29,
  7.097189859565244e-02, -2.992028231375856e-04,  1.511299172677055e-06, -7.836488264789873e-09,  3.984431526309836e-11, -1.973512982615345e-13,  9.545232186801779e-16,
 -4.524058543709889e-18,  2.107319204874958e-20, -9.669031944778912e-23,  4.377612149712906e-25, -1.958347352877633e-27,  6.194497686918798e-02, -3.898099754850207e-04,
  2.846084077624426e-06, -1.950761497971076e-08,  1.257407277416337e-10, -7.734038596936165e-13,  4.584057563392989e-15, -2.635032265239022e-17,  1.475610235744891e-19,
 -8.077489570369785e-22,  4.333588921835535e-24, -2.283469644919958e-26,  5.053282525316626e-02, -4.757276813250983e-04,  4.594531823221450e-06, -3.936404295606555e-08,
  3.105492873260079e-10, -2.304967094972538e-12,  1.629769987504932e-14, -1.106983126380465e-16,  7.266526945786260e-19, -4.630823161448072e-21,  2.875219069436903e-23,
 -1.744113659497716e-25,  3.854942639484782e-02, -5.237573854002784e-04,  6.395969392565606e-06, -6.698422652298386e-08,  6.346675797525307e-10, -5.580787549742052e-12,
  4.624858403249097e-14, -3.649885377082507e-16,  2.763684441459539e-18, -2.019113529155783e-20,  1.429487199393521e-22, -9.840670147324308e-25,  2.752012014368041e-02,
 -5.178875129134928e-04,  7.815696721322024e-06, -9.859156269090245e-08,  1.105998078255866e-09, -1.136732829124563e-11,  1.090206964987189e-13, -9.877916986102548e-16,
  8.530106103659305e-18, -7.066932883664001e-20,  5.645444429491150e-22, -4.365947337157716e-24,  1.840217830904769e-02, -4.622536049092789e-04,  8.496877925596244e-06,
 -1.275555220932513e-07,  1.675116304179515e-09, -1.991561234067810e-11,  2.189228168067492e-13, -2.256630363890390e-15,  2.203226602372406e-17, -2.052724233959041e-19,
  1.835580813070065e-21, -1.582474171793305e-23,  1.153896156445312e-02, -3.750164068835824e-04,  8.299779389588012e-06, -1.467533163573429e-07,  2.235380873062140e-09,
 -3.048607022810828e-11,  3.811227301905093e-13, -4.436771506160419e-15,  4.863581099684932e-17, -5.062164362355658e-19,  5.034789184510207e-21, -4.808947232929850e-23,
  6.794168808063794e-03, -2.783591093791894e-04,  7.341355146527806e-06, -1.515194644141484e-07,  2.656153682734151e-09, -4.126139521938558e-11,  5.828385327308881e-13,
 -7.616159303483672e-15,  9.319850077466589e-17, -1.077720539263544e-18,  1.185928233386234e-20, -1.248588923842160e-22,  3.762550088085380e-03, -1.901575526645232e-04,
  5.919155832384999e-06, -1.414661668786817e-07,  2.834620606404778e-09, -4.985135822990896e-11,  7.912089645136271e-13, -1.154506322072918e-14,  1.569322223126996e-16,
 -2.006728391209863e-18,  2.432179994311991e-20, -2.810401658574434e-22,  1.963497143043428e-03, -1.201947987087664e-04,  4.376031623989583e-06, -1.202374364585007e-07,
  2.737102833844081e-09, -5.420195245587497e-11,  9.618247365408002e-13, -1.560011774765586e-14,  2.345384710283681e-16, -3.302873381873087e-18,  4.391915717827322e-20,
 -5.548848263537115e-22,  9.676975242572111e-04, -7.064076668123143e-05,  2.982742641887915e-06, -9.359831638687180e-08,  2.407224775590854e-09, -5.341420173057995e-11,
  1.055058121232019e-12, -1.894313434821614e-14,  3.137881604805893e-16, -4.848780533550852e-18,  7.049184307167103e-20, -9.705380085639568e-22,  4.515616793480564e-04,
 -3.878449727955313e-05,  1.884254573977855e-06, -6.711493954768619e-08,  1.940150654867114e-09, -4.802158323502251e-11,  1.051547052848327e-12, -2.082190624434147e-14,
  3.786891827950918e-16, -6.399713461722650e-18,  1.014012393978238e-19, -1.516804199977654e-21,  2.000929648221442e-04, -1.998478671490321e-05,  1.108878607645450e-06,
 -4.457538677651364e-08,  1.441425347433077e-09, -3.963043241840005e-11,  9.584074629887326e-13, -2.085684020877985e-14,  4.151272904758463e-16, -7.649168836919356e-18,
  1.317081896368345e-19, -2.134538013859824e-21,  8.447571152458665e-05, -9.709853761959538e-06,  6.110694657939162e-07, -2.757261328816676e-08,  9.928445472582601e-10,
 -3.020142089769323e-11,  8.037595660883292e-13, -1.916056374898828e-14,  4.160904582882074e-16, -8.335484049564833e-18,  1.555476678322464e-19, -2.724135273437678e-21,
  3.410839653463717e-05, -4.469995683436897e-06,  3.169962931652849e-07, -1.597272663478887e-08,  6.376788648429449e-10, -2.137989331447605e-11,  6.240172767859719e-13,
 -1.624433542817033e-14,  3.837635117503692e-16, -8.335443795909288e-18,  1.681393529375787e-19, -3.174181704821919e-21,  1.322751123009356e-05, -1.959791215258716e-06,
  1.556545899051195e-07, -8.715269220182306e-09,  3.841524782636420e-10, -1.414377667142918e-11,  4.512415166328447e-13, -1.278845268453409e-14,  3.277448260058525e-16,
 -7.697882425328485e-18,  1.674283479120632e-19, -3.398960240338522e-21,  4.950759430113439e-06, -8.228129355429498e-07,  7.276587866829814e-08, -4.505803555045409e-09,
  2.183852003909536e-10, -8.797883608219299e-12,  3.058168002864557e-13, -9.407551764587971e-15,  2.608219833501381e-16, -6.607187705804488e-18,  1.545673824032009e-19,
 -3.366384091823691e-21,  1.797958686365227e-06, -3.327706370245901e-07,  3.258537934676890e-08, -2.221161481286470e-09,  1.179010732124565e-10, -5.178665784134089e-12,
  1.954954922365307e-13, -6.508279787680808e-15,  1.946614276982730e-16, -5.304658817006981e-18,  1.331463672280393e-19, -3.103689483574986e-21,  6.373836197235940e-07,
 -1.304710145839888e-07,  1.407020719410482e-08, -1.050980013444593e-09,  6.085418391435077e-11, -2.903941293828112e-12,  1.186674855667087e-13, -4.262576667578276e-15,
  1.371560836860670e-16, -4.010064490493242e-18,  1.077224313636846e-19, -2.681128527135437e-21,  2.220269284732601e-07, -4.993531394907087e-08,  5.899513229877594e-09,
 -4.807151565651520e-10,  3.024196361251420e-11, -1.562215236047217e-12,  6.887732671356336e-14, -2.661324232013561e-15,  9.185949815269803e-17, -2.873709826105532e-18,
  8.240676530810750e-20, -2.184572636085372e-21,  7.654868982160797e-08, -1.879588132383281e-08,  2.420125270128540e-09, -2.141541510346047e-10,  1.457880253769791e-11,
 -8.122513657794487e-13,  3.850749837259841e-14, -1.595422459746662e-15,  5.889731936098137e-17, -1.965965722695459e-18,  6.002034187377204e-20, -1.690361143754148e-21,
  2.632731341472582e-08, -7.013756359719059e-09,  9.791429282796906e-10, -9.366353928376649e-11,  6.871449395198069e-12, -4.113493804409591e-13,  2.089579958137782e-14,
 -9.252703871563565e-16,  3.641942288642990e-17, -1.293285506379767e-18,  4.191770626912182e-20, -1.250785107108458e-21,  9.108857761482131e-09, -2.616748880436630e-09,
  3.940203410193302e-10, -4.055634955697032e-11,  3.192815582445273e-12, -2.045608468157127e-13,  1.109349397338576e-14, -5.231848775505226e-16,  2.188473496952679e-17,
 -8.241927815573900e-19,  2.827592621601166e-20, -8.913751204240645e-22,  3.198605562986076e-09, -9.848433673197510e-10,  1.591086764557028e-10, -1.753772779886397e-11,
  1.475059494845491e-12, -1.007296582414510e-13,  5.809261503917323e-15, -2.907339538855084e-16,  1.287930933547460e-17, -5.127000252103431e-19,  1.855894522879711e-20,
 -6.162032886926824e-22,  1.150466069604829e-09, -3.773537393901101e-10,  6.505867971343631e-11, -7.641433288746520e-12,  6.834871703295552e-13, -4.953320470006451e-14,
  3.025515163963745e-15, -1.600561086124653e-16,  7.481130930995722e-18, -3.136729853104443e-19,  1.193949010449353e-20, -4.161539135787127e-22,  4.277530169777831e-10,
 -1.485568094586905e-10,  2.718161307457869e-11, -3.384533757194282e-12,  3.203850309040931e-13, -2.452836958891739e-14,  1.579870609635512e-15, -8.798115219775849e-17,
  4.321722145268011e-18, -1.901291727123823e-19,  7.581957720805962e-21, -2.764447607419345e-22,  1.658626722998558e-10, -6.062054666329861e-11,  1.170441891610355e-11,
 -1.536713097546694e-12,  1.531692542812293e-13, -1.232800786086346e-14,  8.334601553952180e-16, -4.864321236806335e-17,  2.500416905114528e-18, -1.149494685338023e-19,
  4.783523549029357e-21, -1.817511145073424e-22,  6.760005388075625e-11, -2.584197122147000e-11,  5.234095379345100e-12, -7.205466974989431e-13,  7.521682843190293e-14,
 -6.331843577710009e-15,  4.471174776777359e-16, -2.721901175239669e-17,  1.457492484791086e-18, -6.971001005241786e-20,  3.014405887037279e-21, -1.188645854892780e-22,
  2.913060781507353e-11, -1.157604501656999e-11,  2.444637428912200e-12, -3.507999310730971e-13,  3.813573511742405e-14, -3.339497219595880e-15,  2.450193875532767e-16,
 -1.548015748101563e-17,  8.592927197710570e-19, -4.255830413777107e-20,  1.903637188806357e-21, -7.756213053418590e-23,  1.330272774783428e-11, -5.461337366370597e-12,
  1.194972541646286e-12, -1.776493858979432e-13,  1.999307581408479e-14, -1.810816790559367e-15,  1.372839090605932e-16, -8.953614243166823e-18,  5.125698378722249e-19,
 -2.615659076656786e-20,  1.204410138791152e-21, -5.046891486282445e-23,  6.407307010732694e-12, -2.700789251677741e-12,  6.083306422597505e-13, -9.309735600561497e-14,
  1.077964147259364e-14, -1.003774840368816e-15,  7.817748700455739e-17, -5.233833290786387e-18,  3.073244658613203e-19, -1.607380110022191e-20,  7.580279716426748e-22,
 -3.250658524629028e-23,  3.191313244740399e-12, -1.372609649748306e-12,  3.161546468802358e-13, -4.947960804023933e-14,  5.856639492597784e-15, -5.571864321598365e-16,
  4.431089327793153e-17, -3.027283143131579e-18,  1.812910646339695e-19, -9.664753678254357e-21,  4.643053654923149e-22, -2.027099275199453e-23,  1.546507385442326e-12,
 -6.745222559410975e-13,  1.577999285519102e-13, -2.508545955700559e-14,  3.015213881997888e-15, -2.911948708382568e-16,  2.349803063865645e-17, -1.628290289138260e-18,
  9.886301751319727e-20, -5.341348144105139e-21,  2.599528628841545e-22, -1.149248910514303e-23,  5.699915425356218e-13, -2.505443916390105e-13,  5.912430389743662e-14,
 -9.481430928992800e-15,  1.149478302308670e-15, -1.119461254454221e-16,  9.107563165807247e-18, -6.361331015441333e-19,  3.892205326673895e-20, -2.118655554934561e-21,
  1.038617821539202e-22, -4.624073851607168e-24,  7.502053162369632e-02, -2.351895729924998e-04,  7.702032738723393e-07, -2.611529587318920e-09,  9.076703138469173e-12,
 -3.205991692885474e-14,  1.142703857888114e-16, -4.091273484164497e-19,  1.466211825135861e-21, -5.251081457829237e-24,  1.876173868990538e-26, -6.687163371250220e-29,
  6.979868743141428e-02, -2.874780356347768e-04,  1.420960033346916e-06, -7.229352468160766e-09,  3.611649489994366e-11, -1.758897235447255e-13,  8.367902344736170e-16,
 -3.902192001274518e-18,  1.788782705906958e-20, -8.078751408362173e-23,  3.600876036672847e-25, -1.586141297564770e-27,  6.042983851573713e-02, -3.679446048504301e-04,
  2.623572061199514e-06, -1.761377193040625e-08,  1.113157096375569e-10, -6.717323256564559e-13,  3.908211941241864e-15, -2.206204757606286e-17,  1.213745425393013e-19,
 -6.529338428992243e-22,  3.443496306815474e-24, -1.784081243823259e-26,  4.870055016931545e-02, -4.407798019176074e-04,  4.150520832695241e-06, -3.474380536588624e-08,
  2.681232833902384e-10, -1.948535814889026e-12,  1.350012520849101e-14, -8.990499221813550e-17,  5.789205987315932e-19, -3.620634722618691e-21,  2.206949830139865e-23,
 -1.314720488675337e-25,  3.655187456413094e-02, -4.756403510795731e-04,  5.649589716895197e-06, -5.766546622796908e-08,  5.333726297807743e-10, -4.584098380198938e-12,
  3.716516463282754e-14, -2.871565871557206e-16,  2.130085333624544e-18, -1.525334975940318e-20,  1.058955197517556e-22, -7.151367105545196e-25,  2.556653131304828e-02,
 -4.598099019237191e-04,  6.731707429991106e-06, -8.258108046537023e-08,  9.027261421694763e-10, -9.054088465589132e-12,  8.483057903999668e-14, -7.515253060573446e-16,
  6.350096344923902e-18, -5.150751306757927e-20,  4.030717785717966e-22, -3.055004883494258e-24,  1.668002526320212e-02, -3.999741330721965e-04,  7.114747821186048e-06,
 -1.036748163639395e-07,  1.324612001466869e-09, -1.534637718760642e-11,  1.645903448795693e-13, -1.656922062720921e-15,  1.581189078819823e-17, -1.440921403989383e-19,
  1.261045161309527e-21, -1.064569330466714e-23,  1.016134027339942e-02, -3.150976148681322e-04,  6.734716976077915e-06, -1.154072863716208e-07,  1.707908526350196e-09,
 -2.266955795938855e-11,  2.761971897247181e-13, -3.136930040703712e-15,  3.357910600357851e-17, -3.415536160241762e-19,  3.322038729556881e-21, -3.104794478520194e-23,
  5.787621657466054e-03, -2.262368450572861e-04,  5.753157259442478e-06, -1.149296789514448e-07,  1.955134261459950e-09, -2.952811786643623e-11,  4.061017432594002e-13,
 -5.172785574308984e-15,  6.176226232405365e-17, -6.974438325575589e-19,  7.500097760036386e-21, -7.721746760379047e-23,  3.086871358801507e-03, -1.488932431347445e-04,
  4.463848103861782e-06, -1.031572110250880e-07,  2.003971528467649e-09, -3.423460999762421e-11,  5.286029105938696e-13, -7.513133274910247e-15,  9.958042944481198e-17,
 -1.242724465714477e-18,  1.471109957233276e-20, -1.661436693556592e-22,  1.544548269802128e-03, -9.028836898722928e-05,  3.163861810869589e-06, -8.399643577465468e-08,
  1.852478109754626e-09, -3.561053795064005e-11,  6.143857047156398e-13, -9.700921458363687e-15,  1.421382204008961e-16, -1.952573987364787e-18,  2.534811586053872e-20,
 -3.128896479135096e-22,  7.265724588266639e-04, -5.068984978112545e-05,  2.059411857757601e-06, -6.241501102861164e-08,  1.554436029429594e-09, -3.346676153585028e-11,
  6.424299915055387e-13, -1.122449007522014e-14,  1.811355425493073e-16, -2.729444714354953e-18,  3.872820295613157e-20, -5.208142828271300e-22,  3.221299416737684e-04,
 -2.646923367351504e-05,  1.237389498363331e-06, -4.256082863056753e-08,  1.191132198779522e-09, -2.859909281044454e-11,  6.084569817380903e-13, -1.172160575958243e-14,
  2.076401927240080e-16, -3.421241457291266e-18,  5.289857681752856e-20, -7.727771283148513e-22,  1.349913788605421e-04, -1.291431376692481e-05,  6.897590577515103e-07,
 -2.677817224773806e-08,  8.383284457129446e-10, -2.235762682243075e-11,  5.253027312535074e-13, -1.112117874415059e-14,  2.155890115699244e-16, -3.872943025221856e-18,
  6.507449691932184e-20, -1.029977048378313e-21,  5.364620926923408e-05, -5.914633293751249e-06,  3.585331057280662e-07, -1.562973594969053e-08,  5.450010709078881e-10,
 -1.608407010530324e-11,  4.159303942635644e-13, -9.647228421705988e-15,  2.040705025979067e-16, -3.986217889208262e-18,  7.259786921301758e-20, -1.241875732280407e-21,
  2.029428171987394e-05, -2.555155779821658e-06,  1.746964948640963e-07, -8.509752736047226e-09,  3.291476967831649e-10, -1.071072741214331e-11,  3.038692989560935e-13,
 -7.698928971951776e-15,  1.772236173270061e-16, -3.754500853370126e-18,  7.393492395904876e-20, -1.363731219687276e-21,  7.339799612221793e-06, -1.046601551091941e-06,
  8.023348410328185e-08, -4.346716157746118e-09,  1.857565876684564e-10, -6.641973449055514e-12,  2.060899164072691e-13, -5.687547499082465e-15,  1.420959426371205e-16,
 -3.256746918010726e-18,  6.918225736536897e-20, -1.372847587597881e-21,  2.550343065193255e-06, -4.087299671004890e-07,  3.493712623833255e-08, -2.095554780178170e-09,
  9.856386000465634e-11, -3.859436988822569e-12,  1.305721783203934e-13, -3.914082804344099e-15,  1.058582337327383e-16, -2.618425418447223e-18,  5.986344728841761e-20,
 -1.275203369192721e-21,  8.560943230704336e-07, -1.531126449194593e-07,  1.451469870055135e-08, -9.596448226810187e-10,  4.949018344616559e-11, -2.115059010481510e-12,
  7.778579809974760e-14, -2.525701990734419e-15,  7.375483651009111e-17, -1.964096831224087e-18,  4.821634457680788e-20, -1.100132752575770e-21,  2.793547700455968e-07,
 -5.538307839240676e-08,  5.792485976582660e-09, -4.203141569176046e-10,  2.367750724892336e-11, -1.100723309939136e-12,  4.387150450057118e-14, -1.538671927972618e-15,
  4.838715255241661e-17, -1.383847250421645e-18,  3.639263738837430e-20, -8.874122768578089e-22,  8.923205608646817e-08, -1.948393256097879e-08,  2.236913146291513e-09,
 -1.773748391804018e-10,  1.087332512874569e-11, -5.479807090502992e-13,  2.359640487859753e-14, -8.913356741192186e-16,  3.010455343950191e-17, -9.223029705434207e-19,
  2.592064855430920e-20, -6.739318723445674e-22,  2.811658595163716e-08, -6.719555226779484e-09,  8.425875540580060e-10, -7.269597508726646e-11,  4.830779091128793e-12,
 -2.630059220708864e-13,  1.219632555857969e-14, -4.947213344135051e-16,  1.789543409568587e-17, -5.857561558278559e-19,  1.754855794303342e-20, -4.853110610186795e-22,
  8.813673864322778e-09, -2.291376385128654e-09,  3.122407665706883e-10, -2.918278318903746e-11,  2.093883057878604e-12, -1.227088551915243e-13,  6.107572322951525e-15,
 -2.652024453657692e-16,  1.024399549224940e-17, -3.572421714576560e-19,  1.137840175419143e-20, -3.338538268371567e-22,  2.773931074673784e-09, -7.797597949307681e-10,
  1.148854895055724e-10, -1.157933844711669e-11,  8.934007799951654e-13, -5.614375786327936e-14,  2.988764948851845e-15, -1.384645610280611e-16,  5.693496539958435e-18,
 -2.109092350694215e-19,  7.121469596025488e-21, -2.210803612217496e-22,  8.852184745910938e-10, -2.674292863299191e-10,  4.238097382001709e-11, -4.585017178474757e-12,
  3.787695958573206e-13, -2.542302991350984e-14,  1.442075459956896e-15, -7.102904185760992e-17,  3.098597772093056e-18, -1.215379377951806e-19,  4.337171266967631e-21,
 -1.420389163975273e-22,  2.894052929087126e-10, -9.339270151815125e-11,  1.583481544034577e-11, -1.829851141549899e-12,  1.611219704845088e-13, -1.150166609452058e-14,
  6.923921748967094e-16, -3.612020349609566e-17,  1.665689987365748e-18, -6.893891155947035e-20,  2.591392034641982e-21, -8.923999516829423e-23,  9.796036142597824e-11,
 -3.356101376520893e-11,  6.054390006828894e-12, -7.435000696696211e-13,  6.944484406846914e-14, -5.248457621721028e-15,  3.338765158680514e-16, -1.837187205925453e-17,
  8.920900749653630e-19, -3.881216455932407e-20,  1.531220152069978e-21, -5.525503895504446e-23,  3.468917783293459e-11, -1.253879900563420e-11,  2.392909634966597e-12,
 -3.105982996643062e-13,  3.061685591680847e-14, -2.437985076033624e-15,  1.631316467314949e-16, -9.426531768232834e-18,  4.799244434774058e-19, -2.185976801661642e-20,
  9.015815667651915e-22, -3.396208598279392e-23,  1.297473448100037e-11, -4.917028481340134e-12,  9.867349187893044e-13, -1.346039411943410e-13,  1.392710270377720e-14,
 -1.162394626282692e-15,  8.140514575748978e-17, -4.916269748102633e-18,  2.612309985811695e-19, -1.240182053467017e-20,  5.324461565130892e-22, -2.085084938947873e-23,
  5.165732723190276e-12, -2.039437140655412e-12,  4.276763117175254e-13, -6.094541602474104e-14,  6.580738644417124e-15, -5.725032408201047e-16,  4.173953041921403e-17,
 -2.621001925113636e-18,  1.446337884234595e-19, -7.122591199621866e-21,  3.168456879285714e-22, -1.284133488064762e-23,  2.198403393807852e-12, -8.983836087748023e-13,
  1.955873554088883e-13, -2.893213167005961e-14,  3.240287098531285e-15, -2.920988477382306e-16,  2.204415130468853e-17, -1.431387173322330e-18,  8.159465958400378e-20,
 -4.146699555663859e-21,  1.901818354250383e-22, -7.938787303663060e-24,  9.972186293014911e-13, -4.190807564325826e-13,  9.408289881209596e-14, -1.435081678956074e-14,
  1.656320113889043e-15, -1.537508518474639e-16,  1.193842502097472e-17, -7.969154247525352e-19,  4.666148645897856e-20, -2.433828289067580e-21,  1.144737483693432e-22,
 -4.896461068099953e-24,  4.735244587623735e-13, -2.033106352695878e-13,  4.673812655831972e-14, -7.300562131223171e-15,  8.624898482757348e-16, -8.190376348936755e-17,
  6.501830211686556e-18, -4.434290573009376e-19,  2.651046401241725e-20, -1.410992681525279e-21,  6.767888564341163e-23, -2.950282479290791e-24,  2.217815497016407e-13,
 -9.664894360049240e-14,  2.258872970875502e-14, -3.587477412489707e-15,  4.307986218321085e-16, -4.156604740690180e-17,  3.351166344376955e-18, -2.320153787896081e-19,
  1.407505316662598e-20, -7.598168265806791e-22,  3.694917709967621e-23, -1.632252601028603e-24,  8.017781959539658e-14, -3.523027893587757e-14,  8.310423624258641e-15,
 -1.332153582232090e-15,  1.614380672874716e-16, -1.571599006109508e-17,  1.278102264727171e-18, -8.923711976162651e-20,  5.457966615324011e-21, -2.969863533886773e-22,
  1.455379595322004e-23, -6.477290772143552e-25,  7.409190153026195e-02, -2.291508791403910e-04,  7.397155950413603e-07, -2.471286716922668e-09,  8.462028469410866e-12,
 -2.944976226950317e-14,  1.034442643501265e-16, -3.650939129700375e-19,  1.290001673108780e-21, -4.556253952303989e-24,  1.605545934751418e-26, -5.645524043469350e-29,
  6.867097474358301e-02, -2.764478010427768e-04,  1.337562335848163e-06, -6.678575749686249e-09,  3.279100314930975e-11, -1.570558032513621e-13,  7.351244392739639e-16,
 -3.373666152382627e-18,  1.522277002755813e-20, -6.768745070225105e-23,  2.970795505189627e-25, -1.288776450370466e-27,  5.899874004220291e-02, -3.477722004748450e-04,
  2.422465715653640e-06, -1.593530384360045e-08,  9.877117669126527e-11, -5.849300021135113e-13,  3.341497726502359e-15, -1.852903021049352e-17,  1.001701599579637e-19,
 -5.296892701787594e-22,  2.746706080784725e-24, -1.399566311125569e-26,  4.700129795930362e-02, -4.091732598833918e-04,  3.758103743206587e-06, -3.074881411675010e-08,
  2.321990217292354e-10, -1.652762124485225e-12,  1.122369919807288e-14, -7.330534053562159e-17,  4.631666259313092e-19, -2.843479423834871e-21,  1.702008481471393e-23,
 -9.959676669743438e-26,  3.473552002912896e-02, -4.330731643654019e-04,  5.005932225790322e-06, -4.981909789608400e-08,  4.499967862237768e-10, -3.781396266815454e-12,
  3.000199792508032e-14, -2.270200570952105e-16,  1.650192954150688e-18, -1.158555741467094e-20,  7.889247253831303e-23, -5.227854216719513e-25,  2.382905222847718e-02,
 -4.096876702805519e-04,  5.821760200057263e-06, -6.948225957844502e-08,  7.404110376095691e-10, -7.249313394184594e-12,  6.637470563428725e-14, -5.751239042440553e-16,
  4.756328990044547e-18, -3.778297601220512e-20,  2.897128451322320e-22, -2.152568267351611e-24,  1.518656497263362e-02, -3.476942536459182e-04,  5.988338646653484e-06,
 -8.473662225768613e-08,  1.053704592666391e-09, -1.190022534995383e-11,  1.245648688783675e-13, -1.225050961688432e-15,  1.142995005759501e-17, -1.019072676233450e-19,
  8.730854940719239e-22, -7.219200712109460e-24,  9.000547515657348e-03, -2.663271353426055e-04,  5.499916867438741e-06, -9.137553413635232e-08,  1.314272587544532e-09,
 -1.698391843353767e-11,  2.017265559111789e-13, -2.235940221125502e-15,  2.337872633460014e-17, -2.324530426166707e-19,  2.211521531423907e-21, -2.022940164012725e-23,
  4.966685789094896e-03, -1.852380864386441e-04,  4.543795325331836e-06, -8.788797788292931e-08,  1.451367251265976e-09, -2.131768270916356e-11,  2.855359407231993e-13,
 -3.546271111740441e-15,  4.132468618543702e-17, -4.558180922218362e-19,  4.791333506719908e-21, -4.824910346098053e-23,  2.555586164367746e-03, -1.176368129748180e-04,
  3.397799897953088e-06, -7.594744486525766e-08,  1.430803505293898e-09, -2.375007562811153e-11,  3.568553670940529e-13, -4.941709288531922e-15,  6.388051388548233e-17,
 -7.781968288091832e-19,  8.999403202418406e-21, -9.935834821575689e-23,  1.228278880999700e-03, -6.855477595554969e-05,  2.312602923848529e-06, -5.933718699455202e-08,
  1.268122379453980e-09, -2.366938647081671e-11,  3.971237542224542e-13, -6.105593595810087e-15,  8.720130716797266e-17, -1.168744035627726e-18,  1.481529585581948e-20,
 -1.787001119418036e-22,  5.525562063716012e-04, -3.683358205492335e-05,  1.440017200487265e-06, -4.215712683634554e-08,  1.016862271316489e-09, -2.124600136445322e-11,
  3.964184810107503e-13, -6.741080289916618e-15,  1.059949357386478e-16, -1.557733538517760e-18,  2.157506964313957e-20, -2.834296544440780e-22,  2.332225759502762e-04,
 -1.832786908193154e-05,  8.244276683282033e-07, -2.738454796921029e-08,  7.420411840336066e-10, -1.728445551834085e-11,  3.573256974910820e-13, -6.697796566971162e-15,
  1.155743945599851e-16, -1.856820642934747e-18,  2.801861714289427e-20, -3.997764565860332e-22,  9.261726785681866e-05, -8.483575368791075e-06,  4.361045703867647e-07,
 -1.635048036710670e-08,  4.955669529339442e-10, -1.282035219493615e-11,  2.926591235001998e-13, -6.027863321291710e-15,  1.138150889858182e-16, -1.993484537646337e-18,
  3.268659184338941e-20, -5.052731230045537e-22,  3.471733454452301e-05, -3.669686904322343e-06,  2.142154509765621e-07, -9.020882877387872e-09,  3.045793181765248e-10,
 -8.720214676514337e-12,  2.191092038070823e-13, -4.944577778338688e-15,  1.018812400566361e-16, -1.940452121516367e-18,  3.448945814750490e-20, -5.762616337104639e-22,
  1.232983881291080e-05, -1.490551761340179e-06,  9.821646903788730e-08, -4.624044620934791e-09,  1.732485226562771e-10, -5.470922133149584e-12,  1.508527362892577e-13,
 -3.719540112864596e-15,  8.341971360432030e-17, -1.723559284174289e-18,  3.313168605512975e-20, -5.970399158853199e-22,  4.166710007119099e-06, -5.714356437151040e-07,
  4.226396379976552e-08, -2.214707209891690e-09,  9.173627995223319e-11, -3.184820864027271e-12,  9.608876495134267e-14, -2.581789661310287e-15,  6.286993930723213e-17,
 -1.405864584831119e-18,  2.916363830111098e-20, -5.656092373955480e-22,  1.346466433729782e-06, -2.079308110324173e-07,  1.716952955244849e-08, -9.971245752265612e-10,
  4.549642504932558e-11, -1.730996996527829e-12,  5.698262429076448e-14, -1.664072744436324e-15,  4.389230456665053e-17, -1.059857760769861e-18,  2.367525874924726e-20,
 -4.931661878485385e-22,  4.184163475008984e-07, -7.225500533089747e-08,  6.626905135349938e-09, -4.247475998218510e-10,  2.127224547424539e-11, -8.841880124794311e-13,
  3.166809961353405e-14, -1.002556823052078e-15,  2.857423450344258e-17, -7.433819937215995e-19,  1.784347419479548e-20, -3.983946745027467e-22,  1.258373213239465e-07,
 -2.414113001374703e-08,  2.447033944221942e-09, -1.723856510349686e-10,  9.442708759446071e-12, -4.274385387003389e-13,  1.660909337305323e-14, -5.685302693509006e-16,
  1.746670477672460e-17, -4.884635628681088e-19,  1.257120877319278e-20, -3.002233851231156e-22,  3.689219302109146e-08, -7.813448665638578e-09,  8.710528432320556e-10,
 -6.716843230134710e-11,  4.009777655692945e-12, -1.970401263284283e-13,  8.282435417366873e-15, -3.057171983150431e-16,  1.009903877604943e-17, -3.028718930364557e-19,
  8.338871021155909e-21, -2.125568269121030e-22,  1.062923510815429e-08, -2.470126690273670e-09,  3.013957993238538e-10, -2.533504033090988e-11,  1.642294759323443e-12,
 -8.731990522229701e-14,  3.958566823733315e-15, -1.571226934123801e-16,  5.566259198264020e-18, -1.785766281228994e-19,  5.247510773222395e-21, -1.424427513335455e-22,
  3.036864891899716e-09, -7.697374291009500e-10,  1.022974211871456e-10, -9.334267422945610e-12,  6.545560922343721e-13, -3.752722790114872e-14,  1.829015647420295e-15,
 -7.783500386847219e-17,  2.948880781423447e-18, -1.009386130615009e-19,  3.157741218628531e-21, -9.106174710933560e-23,  8.689837827500861e-10, -2.387987863689516e-10,
  3.439628769371049e-11, -3.392082848867939e-12,  2.563065019664421e-13, -1.578793294561242e-14,  8.244835974005893e-16, -3.749959272342764e-17,  1.514860333378767e-18,
 -5.516727812390787e-20,  1.832381089060490e-21, -5.599086607723196e-23,  2.517310040956816e-10, -7.455068049249394e-11,  1.157930258802639e-11, -1.228578034213874e-12,
  9.961323799486567e-14, -6.567126072625865e-15,  3.661439927414572e-16, -1.773808967225770e-17,  7.615803785939004e-19, -2.941694365270465e-20,  1.034349065039182e-21,
 -3.339473762467443e-23,  7.467726195164748e-11, -2.368957252995063e-11,  3.946852189961560e-12, -4.483926508518139e-13,  3.883938199469083e-14, -2.729148457334661e-15,
  1.618198071086120e-16, -8.319430069152386e-18,  3.783014699617409e-19, -1.544655769680038e-20,  5.731048051311744e-22, -1.948956436328772e-23,  2.295937845448857e-11,
 -7.753476966914426e-12,  1.378038180338859e-12, -1.667833492154305e-13,  1.536058568660568e-14, -1.145303292161473e-15,  7.191440238504075e-17, -3.907828362838410e-18,
  1.874749461035652e-19, -8.062036234443911e-21,  3.145116264011743e-22, -1.122722925220278e-23,  7.404126070820962e-12, -2.645065672786954e-12,  4.986086535304657e-13,
 -6.394223887586057e-14,  6.229755942431959e-15, -4.905039993420125e-16,  3.246601364620521e-17, -1.856496710710294e-18,  9.356887924786139e-20, -4.220631163742399e-21,
  1.724485234503194e-22, -6.437564881712050e-24,  2.533346653550539e-12, -9.512254086313556e-13,  1.890248728147737e-13, -2.553747291735653e-14,  2.617619390238641e-15,
 -2.165024890303333e-16,  1.503016810929383e-17, -9.000902702152445e-19,  4.743993798694112e-20, -2.234595648452523e-21,  9.521442073414003e-23, -3.701565140858199e-24,
  9.286849449046913e-13, -3.641035606872393e-13,  7.578522078030093e-14, -1.072015491628388e-14,  1.149246773634223e-15, -9.928796616198296e-17,  7.190348188093953e-18,
 -4.485960216102143e-19,  2.460041094753307e-20, -1.204176501856528e-21,  5.325624128151279e-23, -2.146329924638255e-24,  3.670511018962373e-13, -1.492581905929832e-13,
  3.232145452730187e-14, -4.755777639239270e-15,  5.298759506447029e-16, -4.752697669791192e-17,  3.569406263102954e-18, -2.306874711713455e-19,  1.309070577939313e-20,
 -6.623782577945396e-22,  3.025100661943250e-23, -1.257648494050131e-24,  1.562960829776795e-13, -6.547193235926671e-14,  1.464647608872243e-14, -2.226230452586315e-15,
  2.560616631747911e-16, -2.369020918396383e-17,  1.833563931377740e-18, -1.220128189682945e-19,  7.122649416358773e-21, -3.704306063170041e-22,  1.737398129449462e-23,
 -7.411334417785088e-25,  7.055822938855078e-14, -3.023792967210276e-14,  6.936877218837275e-15, -1.081309764135435e-15,  1.274875755497672e-16, -1.208265100989322e-17,
  9.573364547846538e-19, -6.517034260935869e-20,  3.889250580778952e-21, -2.066432633995397e-22,  9.895139442463457e-24, -4.306554823922906e-25,  3.187269429595189e-14,
 -1.387693179852756e-14,  3.240003726013733e-15, -5.140417242738349e-16,  6.166613239076549e-17, -5.944084938503438e-18,  4.787709167794254e-19, -3.311661066514418e-20,
  2.007188758219567e-21, -1.082598968066713e-22,  5.260113837514020e-24, -2.321780845287129e-25,  1.128820317531365e-14, -4.958205971247728e-15,  1.169092464663206e-15,
 -1.873245819607821e-16,  2.269148150913945e-17, -2.208096528438444e-18,  1.795001429403494e-19, -1.252769811664177e-20,  7.659260570855126e-22, -4.166068077680730e-23,
  2.040815062059458e-24, -9.079506703832465e-26,  7.318694883691548e-02, -2.233495183749091e-04,  7.108534999778783e-07, -2.340474725724595e-09,  7.897055294639050e-12,
 -2.708525407889861e-14,  9.377575344076950e-17, -3.263190102149245e-19,  1.136962335453145e-21, -3.961045525387846e-24,  1.376818073008703e-26, -4.777049659779960e-29,
  6.758608924968938e-02, -2.660591874914951e-04,  1.260466726056606e-06, -6.178121180568975e-09,  2.981894069353214e-11, -1.404934952211822e-13,  6.471309945679306e-16,
 -2.923338442286442e-18,  1.298693349376401e-20, -5.686441100162547e-23,  2.458071275727981e-25, -1.050408799631623e-27,  5.764523639921727e-02, -3.291313652085340e-04,
  2.240351696410246e-06, -1.444436660197458e-08,  8.783431214196211e-11, -5.106144857674009e-13,  2.864838916798922e-15, -1.560862925960854e-17,  8.293913924888126e-20,
 -4.312066654277099e-22,  2.199054909686809e-24, -1.102250105322787e-26,  4.542248363777326e-02, -3.805236353390793e-04,  3.410363828958341e-06, -2.728410490714549e-08,
  2.016794812683045e-10, -1.406439219125011e-12,  9.364148810995582e-15, -5.999856993078421e-17,  3.720689739324031e-19, -2.242815765965750e-21,  1.318607649263086e-23,
 -7.581319450371451e-26,  3.307970156428576e-02, -3.953001279880142e-04,  4.448928092249873e-06, -4.318710872004631e-08,  3.810837381960729e-10, -3.132024628684182e-12,
  2.432611675263047e-14, -1.803204038504479e-16,  1.284779011209154e-18, -8.845864832495264e-21,  5.909849829069988e-23, -3.843686933941058e-25,  2.227843952568255e-02,
 -3.662578279470317e-04,  5.054534115790557e-06, -5.871420160073468e-08,  6.101341481621525e-10, -5.833544411128390e-12,  5.221252420252921e-14, -4.426206916917608e-16,
  3.583768348850152e-18, -2.788794457842419e-20,  2.095854673933056e-22, -1.526928846210791e-24,  1.388554342980091e-02, -3.035853827455056e-04,  5.065296667539417e-06,
 -6.962991230312754e-08,  8.430172872641575e-10, -9.284118314724973e-12,  9.487721970290663e-14, -9.118265850262481e-16,  8.320219990010290e-18, -7.259686266081463e-20,
  6.090364154988306e-22, -4.933695040779381e-24,  8.016765779413595e-03, -2.263805502554061e-04,  4.519168628399003e-06, -7.282140683683425e-08,  1.018343661191421e-09,
 -1.281638193390194e-11,  1.484481964009948e-13, -1.606241888730961e-15,  1.640923760806894e-17, -1.595297632780149e-19,  1.484966305315829e-21, -1.329768177657083e-23,
  4.292272141736656e-03, -1.527417160284216e-04,  3.615521107224649e-06, -6.773584627558507e-08,  1.086211719265248e-09, -1.552087302790648e-11,  2.025283931683543e-13,
 -2.453231568675338e-15,  2.790798282940859e-17, -3.007556674607415e-19,  3.090920636754229e-21, -3.045102644864113e-23,  2.134137080818180e-03, -9.374400719550602e-05,
  2.609500786426057e-06, -5.643245944466609e-08,  1.031331844936676e-09, -1.663856766261761e-11,  2.433442185950730e-13, -3.284036044718564e-15,  4.141332108951744e-17,
 -4.925819555523380e-19,  5.566072410201034e-21, -6.008676700192099e-23,  9.869952350683533e-04, -5.259008843747489e-05,  1.708205910817346e-06, -4.236939422223088e-08,
  8.776752603683304e-10, -1.590971486034653e-11,  2.596423018561325e-13, -3.887771065508549e-15,  5.413538498517309e-17, -7.080451865163612e-19,  8.765641634599397e-21,
 -1.033336836009670e-22,  4.254099827700252e-04, -2.708962820944962e-05,  1.019242479254914e-06, -2.882765006642114e-08,  6.735747502306471e-10, -1.366009763791800e-11,
  2.477831816783454e-13, -4.101624990218196e-15,  6.284928627917619e-17, -9.009742978597818e-19,  1.218261000069652e-20, -1.563616147644537e-22,  1.712744832070469e-04,
 -1.286860450557595e-05,  5.569929413569704e-07, -1.786841472519278e-08,  4.688430381399366e-10, -1.059598781632085e-11,  2.128788964444445e-13, -3.882947164861823e-15,
  6.527476204579050e-17, -1.022671216047510e-18,  1.506166541790996e-20, -2.099155425045376e-22,  6.458541723069249e-05, -5.662032709201798e-06,  2.801073312566573e-07,
 -1.014178735532602e-08,  2.976021846062986e-10, -7.468601140823953e-12,  1.656542587652854e-13, -3.319620256201566e-15,  6.105337246547430e-17, -1.042664140876701e-18,
  1.668437852706430e-20, -2.518989053232569e-22,  2.288201255555415e-05, -2.317727925262746e-06,  1.302603513521302e-07, -5.298316168888688e-09,  1.732080703669149e-10,
 -4.810696932795816e-12,  1.174469194784401e-13, -2.578647012951469e-15,  5.175365017589309e-17, -9.611141763265385e-19,  1.667156281742280e-20, -2.720728696157261e-22,
  7.644650669893616e-06, -8.868443906789095e-07,  5.630105806109272e-08, -2.561340482927172e-09,  9.294409852140082e-11, -2.847894474029257e-12,  7.631304996878168e-14,
 -1.831010087556869e-15,  4.000602221407278e-17, -8.060818904478636e-19,  1.512471055086618e-20, -2.662556173035501e-22,  2.418611717601038e-06, -3.188117519063130e-07,
  2.273958186796315e-08, -1.152215346415300e-09,  4.624798774288112e-11, -1.558611433130007e-12,  4.571674965134459e-14, -1.195731045333869e-15,  2.837637152914255e-17,
 -6.190063323226361e-19,  1.253785812158907e-20, -2.376236829034924e-22,  7.282002946463893e-07, -1.082783317192381e-07,  8.632646042172159e-09, -4.852172425014585e-10,
  2.146965524861047e-11, -7.934665226239144e-13,  2.540854720350788e-14, -7.226965509872074e-16,  1.858646643721696e-17, -4.380349151857237e-19,  9.558615605174633e-21,
 -1.946664424343920e-22,  2.098306565299406e-07, -3.495807570111332e-08,  3.100063023104321e-09, -1.925262550874308e-10,  9.359628793442641e-12, -3.782263245235297e-13,
  1.318798607780998e-14, -4.069419200672955e-16,  1.131686887258570e-17, -2.875458765281546e-19,  6.746753111435760e-21, -1.473673026034620e-22,  5.824268997570597e-08,
 -1.080283431536109e-08,  1.060506498069338e-09, -7.248878937315104e-11,  3.859004740461959e-12, -1.700143138400117e-13,  6.437853543308428e-15, -2.149918042345161e-16,
  6.450486155812171e-18, -1.763296624600821e-19,  4.439618840334140e-21, -1.038079578478023e-22,  1.568882259659662e-08, -3.219952213124865e-09,  3.482961662934181e-10,
 -2.610109545520449e-11,  1.516494662549685e-12, -7.262270923879922e-14,  2.978397250143384e-15, -1.073765663628938e-16,  3.467765861853147e-18, -1.017623548673996e-19,
  2.743727494137119e-21, -6.853985153727665e-23,  4.135926083476168e-09, -9.337094385560448e-10,  1.107688136297912e-10, -9.065161815223928e-12,  5.728517298570188e-13,
 -2.972733837141163e-14,  1.316736017849227e-15, -5.111416234504901e-17,  1.772531862115173e-18, -5.571066610969275e-20,  1.605008721872434e-21, -4.274517915993006e-23,
  1.077226907312679e-09, -2.659361243593212e-10,  3.443947259043017e-11, -3.065599042501841e-12,  2.099501231750706e-13, -1.176814540630585e-14,  5.612964565801458e-16,
 -2.339642952868164e-17,  8.689346409923203e-19, -2.917902424896102e-20,  8.961440641284504e-22, -2.538738752595230e-23,  2.801473138575118e-10, -7.518654537637041e-11,
  1.057829710151169e-11, -1.019907177403100e-12,  7.541616832251568e-14, -4.550326795207691e-15,  2.329626948076504e-16, -1.039597398724290e-17,  4.123513621119675e-19,
 -1.475474589574546e-20,  4.818369025276011e-22, -1.448458209761120e-23,  7.359837766972768e-11, -2.134669951540643e-11,  3.246791590550596e-12, -3.375804802918623e-13,
  2.684404395140480e-14, -1.737036517569213e-15,  9.512962521552690e-17, -4.530098963321566e-18,  1.913110624458426e-19, -7.272994015357898e-21,  2.518401682342079e-22,
 -8.011678558631064e-24,  1.978021161031336e-11, -6.162790344328718e-12,  1.008097329397065e-12, -1.125061671735949e-13,  9.579600156011344e-15, -6.621434832393232e-16,
  3.864446476841552e-17, -1.956795157359911e-18,  8.768713392923767e-20, -3.530291722197433e-21,  1.292156461470890e-22, -4.337140746813803e-24,  5.511599989365067e-12,
 -1.833223344065371e-12,  3.207540260622958e-13, -3.823188441282287e-14,  3.469573946218904e-15, -2.550501587048075e-16,  1.579765807916047e-17, -8.472439140224123e-19,
  4.013516715993637e-20, -1.705047999592388e-21,  6.573986123235944e-23, -2.320353147512668e-24,  1.614221528941015e-12, -5.695337166873495e-13,  1.059725214321606e-13,
 -1.341801371237720e-14,  1.291277307521661e-15, -1.004690888134381e-16,  6.574328459358798e-18, -3.718204965859175e-19,  1.854227812248716e-20, -8.278825719690782e-22,
  3.349417037573280e-23, -1.238536981969805e-24,  5.036194835558754e-13, -1.872486937624242e-13,  3.682417816553739e-14, -4.924303377280054e-15,  4.997601251655048e-16,
 -4.094072833635516e-17,  2.816073075649573e-18, -1.671472827024905e-19,  8.734349706389079e-21, -4.080303230420832e-22,  1.724768613761768e-23, -6.653913181209481e-25,
  1.693909839419770e-13, -6.592063264857892e-14,  1.361213501373055e-14, -1.910427821477684e-15,  2.032484419844885e-16, -1.743030688525665e-17,  1.253328634014132e-18,
 -7.765816386991401e-20,  4.230552495757746e-21, -2.057642946854176e-22,  9.044264472817197e-24, -3.623444945568192e-25,  6.195415511567350e-14, -2.506047353296643e-14,
  5.395831468091455e-15, -7.894534173529521e-16,  8.747444785750997e-17, -7.804148537789551e-18,  5.830938677615912e-19, -3.749744181802035e-20,  2.117637606190212e-21,
 -1.066543769126709e-22,  4.849161761346300e-24, -2.007300439895667e-25,  2.468013305630935e-14, -1.030277033221725e-14,  2.296095643501444e-15, -3.476906029188972e-16,
  3.984491081303493e-17, -3.673254723238107e-18,  2.833235973397343e-19, -1.879088493923320e-20,  1.093422008371740e-21, -5.668985912850724e-23,  2.650917357159099e-24,
 -1.127558749545666e-25,  1.056108285956566e-14, -4.516910384522858e-15,  1.033930374969955e-15, -1.608112765364277e-16,  1.891882969900472e-17, -1.789268145477955e-18,
  1.414793424371636e-19, -9.612188157272287e-21,  5.725456068807900e-22, -3.036439249285244e-23,  1.451412335445874e-24, -6.305969971198690e-26,  4.590831062384678e-15,
 -1.996836006772592e-15,  4.657176431065940e-16, -7.380778661976120e-17,  8.844752940459539e-18, -8.516690275567147e-19,  6.852879925896102e-20, -4.735475801802835e-21,
  2.867418330288523e-22, -1.545140507672082e-23,  7.500757062737201e-25, -3.307908699767409e-26,  1.590739715930733e-15, -6.984390916778039e-16,  1.646117798065657e-16,
 -2.636407023981888e-17,  3.192184825454360e-18, -3.104945348680867e-19,  2.522988000299146e-20, -1.760111088566033e-21,  1.075667440046740e-22, -5.848491293251943e-24,
  2.863856806241544e-25, -1.273633052869379e-26,  7.230474952250904e-02, -2.177729255531272e-04,  6.835084321047976e-07, -2.218336232322149e-09,  7.377137004317627e-12,
 -2.494029598732158e-14,  8.512747775871461e-17, -2.921154632878552e-19,  1.003791711109476e-21, -3.450125632494736e-24,  1.183064791793804e-26, -4.051247180874142e-29,
  6.654156160579655e-02, -2.562641009502793e-04,  1.189101823911255e-06, -5.722680238770398e-09,  2.715798700934837e-11, -1.258994581807875e-13,  5.708009376817941e-16,
 -2.538699624091742e-18,  1.110620414440323e-20, -4.789703459064177e-23,  2.039567817633884e-25, -8.587113727356500e-28,  5.636349152846780e-02, -3.118787428807796e-04,
  2.075126093259217e-06, -1.311712355185608e-08,  7.827567463192306e-11, -4.468167026382445e-13,  2.462736100582064e-15, -1.318687973259677e-17,  6.888878601777361e-20,
 -3.522224834871039e-22,  1.766948784536169e-24, -8.714151001394336e-27,  4.395295604871376e-02, -3.544975661192722e-04,  3.101425600125103e-06, -2.427060053387500e-08,
  1.756686652348151e-10, -1.200584886453217e-12,  7.839427305329013e-15, -4.928860898161864e-17,  3.000695306525187e-19, -1.776466719680699e-21,  1.026109169757751e-23,
 -5.797881901158918e-26,  3.156654199073106e-02, -3.616825924741798e-04,  3.965297946538045e-06, -3.756080827535515e-08,  3.238953651438780e-10, -2.604418441224802e-12,
  1.980792346654054e-14, -1.438775804960490e-16,  1.005097202884818e-18, -6.788330105965657e-21,  4.450672818438320e-23, -2.841751373854634e-25,  2.089004161430037e-02,
 -3.284823248649659e-04,  4.404896004165430e-06, -4.982132914475188e-08,  5.050536395942950e-10, -4.717078386648697e-12,  4.128456055575706e-14, -3.425083679732443e-16,
  2.715807655956909e-18, -2.070828781051698e-20,  1.525714808294589e-22, -1.090200824298539e-24,  1.274726084790835e-02, -2.661892935544513e-04,  4.304918143033986e-06,
 -5.751154340700219e-08,  6.781832517997169e-10, -7.285609562611627e-12,  7.271185340725155e-14, -6.830875694059793e-16,  6.097526038909127e-18, -5.208052337718941e-20,
  4.279427925825719e-22, -3.397174708511314e-24,  7.178382706034249e-03, -1.934639343341052e-04,  3.735201618591864e-06, -5.839924097145476e-08,  7.942861766432404e-10,
 -9.738910071250573e-12,  1.100369388278900e-13, -1.162625593285304e-15,  1.160790166557461e-17, -1.103721500370976e-19,  1.005452258634702e-21, -8.816403252399647e-24,
  3.734393720782048e-03, -1.267954031071955e-04,  2.897519274223707e-06, -5.259736084196383e-08,  8.193191451004542e-10, -1.139277401213013e-11,  1.448690594315972e-13,
 -1.711944832656506e-15,  1.901714795090336e-17, -2.002818858181422e-19,  2.012922638038080e-21, -1.940526716147745e-23,  1.796989305375000e-03, -7.531961066622198e-05,
  2.021286193512368e-06, -4.230476543968678e-08,  7.502245206890498e-10, -1.176695990167626e-11,  1.675573245165814e-13, -2.204255739639593e-15,  2.712307118271107e-17,
 -3.150598039613627e-19,  3.479386705671214e-21, -3.673334527276937e-23,  8.010538088935749e-04, -4.074159790752149e-05,  1.274533058322512e-06, -3.056734012724361e-08,
  6.138975393218091e-10, -1.081017349344928e-11,  1.716408334897975e-13, -2.503598437804899e-15,  3.399548755136284e-17, -4.339804474534812e-19,  5.248146858111853e-21,
 -6.047623378542225e-23,  3.314021523466954e-04, -2.015504586826719e-05,  7.299072017525391e-07, -1.994827242076684e-08,  4.515968783869943e-10, -8.891097408587798e-12,
  1.568179527141140e-13, -2.527354015369986e-15,  3.774619282395354e-17, -5.279092140700374e-19,  6.969832108938490e-21, -8.741203680988875e-23,  1.275148210579308e-04,
 -9.157289641143222e-06,  3.813950895062933e-07, -1.181780734795651e-08,  3.002970069559142e-10, -6.585799512579993e-12,  1.285996321937434e-13, -2.282894148927912e-15,
  3.739189517211712e-17, -5.713492890216080e-19,  8.213856119125132e-21, -1.118316954315618e-22,  4.574913411466979e-05, -3.837123091546262e-06,  1.826684654815644e-07,
 -6.387149200051906e-09,  1.814672644906659e-10, -4.418086004053313e-12,  9.522016632467809e-14, -1.856650385093822e-15,  3.326339374487872e-17, -5.539265189148300e-19,
  8.650753417111515e-21, -1.275719146358195e-22,  1.535058525559983e-05, -1.489278443168242e-06,  8.056978680847973e-08, -3.165098056853256e-09,  1.001795906154282e-10,
 -2.699144544419220e-12,  6.402649474965013e-14, -1.367711266525020e-15,  2.673816793460461e-17, -4.841670467506483e-19,  8.196308895437214e-21, -1.306488660667359e-22,
  4.834131723293036e-06, -5.378587994289482e-07,  3.288830426265203e-08, -1.445520874131593e-09,  5.079601694459051e-11, -1.510083220172630e-12,  3.932101752604885e-14,
 -9.180039141411597e-16,  1.953932586072096e-17, -3.839164677296400e-19,  7.030939314263108e-21, -1.209080451829390e-22,  1.434692364259936e-06, -1.816535976563424e-07,
  1.249005534636900e-08, -6.117813732804938e-10,  2.378992721926599e-11, -7.781435523819919e-13,  2.218598763170058e-14, -5.647887845647076e-16,  1.306035580672285e-17,
 -2.778939124975779e-19,  5.495254936269712e-21, -1.017648466550119e-22,  4.032217151506178e-07, -5.768847652592476e-08,  4.438515276014320e-09, -2.413592079298296e-10,
  1.035323603148175e-11, -3.715747078426658e-13,  1.157172220265922e-14, -3.204982428511596e-16,  8.035327788963312e-18, -1.847931316251450e-19,  3.938518346590155e-21,
 -7.840631142526821e-23,  1.079239077199783e-07, -1.733280745645723e-08,  1.485301301293174e-09, -8.933555100541508e-11,  4.214067195972169e-12, -1.655008165247037e-13,
  5.616108300293462e-15, -1.688601821431426e-16,  4.580671366612434e-18, -1.136423422629210e-19,  2.605796210749998e-21, -5.566927127191065e-23,  2.768953365681404e-08,
 -4.961160671267140e-09,  4.713647607979757e-10, -3.124375232589990e-11,  1.615699413300597e-12, -6.924854169659571e-14,  2.554309724550507e-15, -8.318878276614058e-17,
  2.436667451258377e-18, -6.508744793008393e-20,  1.602715070118242e-21, -3.667986477384519e-23,  6.861402037803897e-09, -1.363391919246423e-09,  1.429847389793945e-10,
 -1.040653780699667e-11,  5.881178623102538e-13, -2.743251718215754e-14,  1.097169074390849e-15, -3.861633960456893e-17,  1.218734112757555e-18, -3.498100042314877e-20,
  9.232671123136693e-22, -2.259470333024266e-23,  1.656419419805677e-09, -3.629195998556471e-10,  4.182628843674148e-11, -3.330186885374261e-12,  2.050175031614304e-13,
 -1.037764524270266e-14,  4.488704674395069e-16, -1.703265612689177e-17,  5.779014006110706e-19, -1.778617227605581e-20,  5.021606821261888e-22, -1.311578042751678e-23,
  3.934379212000090e-10, -9.450794141331752e-11,  1.191600018437943e-11, -1.033944928323963e-12,  6.910773700476278e-14, -3.784676883375365e-15,  1.765484035145554e-16,
 -7.204012669360755e-18,  2.621408662402679e-19, -8.631401909369251e-21,  2.601154308962633e-22, -7.235790575027632e-24,  9.297704318886895e-11, -2.434617870780277e-11,
  3.342858825019217e-12, -3.148496015118704e-13,  2.276646021706874e-14, -1.344580553654877e-15,  6.744310959981942e-17, -2.951120982258999e-18,  1.148672097962107e-19,
 -4.036256956989448e-21,  1.295255268280270e-22, -3.828686641828217e-24,  2.213499749981782e-11, -6.281564293206666e-12,  9.347585150910188e-13, -9.516347821523078e-14,
  7.415968984770471e-15, -4.706778753895580e-16,  2.530297451958773e-17, -1.183660867320908e-18,  4.913876744739320e-20, -1.837564118453241e-21,  6.262699554611478e-23,
 -1.962108973299601e-24,  5.381920908268427e-12, -1.645360634429389e-12,  2.640240311405932e-13, -2.892244194406379e-14,  2.419006837076937e-15, -1.643558795995792e-16,
  9.435436804599248e-18, -4.702649247215041e-19,  2.075483578930883e-20, -8.234318247161700e-22,  2.971653717867813e-23, -9.839685859751324e-25,  1.356305949453884e-12,
 -4.439448891110720e-13,  7.640574704515076e-14, -8.962117052467558e-15,  8.008378379535768e-16, -5.800112502032625e-17,  3.541577231770795e-18, -1.873459506185871e-19,
  8.758272121892231e-21, -3.673672503211291e-22,  1.399149356865870e-23, -4.880453618263877e-25,  3.597855937365688e-13, -1.252762916478730e-13,  2.299191041669579e-14,
 -2.872331775722726e-15,  2.728523016685937e-16, -2.096576063716382e-17,  1.355515625929409e-18, -7.578064722253219e-20,  3.737209162181281e-21, -1.650784150505897e-22,
  6.609927219219673e-24, -2.419975685808164e-25,  1.020239532020544e-13, -3.753805413211028e-14,  7.301130718025249e-15, -9.658091254372029e-16,  9.699417189494947e-17,
 -7.865725442774604e-18,  5.357815348468043e-19, -3.150360856173786e-20,  1.631393769700216e-21, -7.554940749875936e-23,  3.166767366529599e-24, -1.211843535350428e-25,
  3.137224432604545e-14, -1.211246831666665e-14,  2.480041643414232e-15, -3.451714364175170e-16,  3.642578269842702e-17, -3.099444264376918e-18,  2.211883280798633e-19,
 -1.360571999335815e-20,  7.360091163006745e-22, -3.555638390971418e-23,  1.552698758712990e-24, -6.181709505116974e-26,  1.057861142865961e-14, -4.254932189627724e-15,
  9.105603396518002e-16, -1.324187357190699e-16,  1.458639002187749e-17, -1.293954588265315e-18,  9.614893315309608e-20, -6.150417466767330e-21,  3.455679994998751e-22,
 -1.731882363754339e-23,  7.836820321586664e-25, -3.229212116581162e-26,  3.928277479774111e-15, -1.633801488188333e-15,  3.626413593534153e-16, -5.469313127663029e-17,
  6.243221788018665e-18, -5.733712822736370e-19,  4.406277401435422e-20, -2.912027281933490e-21,  1.688685264469901e-22, -8.726312540328701e-24,  4.067577991179447e-25,
 -1.724823155392557e-26,  1.588393415766707e-15, -6.778857906620133e-16,  1.548017530569620e-16, -2.401999115648942e-17,  2.819327759343844e-18, -2.660424905101709e-19,
  2.099055503550377e-20, -1.423113681199981e-21,  8.459493893805549e-23, -4.477601859050265e-24,  2.136224349306778e-25, -9.264305044490860e-27,  6.628378035947873e-16,
 -2.880088531836578e-16,  6.709384789775505e-17, -1.062080572147300e-17,  1.271293316867040e-18, -1.222780394625979e-19,  9.828383701365993e-21, -6.784501894391965e-22,
  4.103973917731982e-23, -2.209297411993900e-24,  1.071462670792303e-25, -4.720901868626738e-27,  2.243869365804338e-16, -9.847994070497596e-17,  2.319948733651263e-17,
 -3.713861921289678e-18,  4.494684492508975e-19, -4.369850278173554e-20,  3.549222704890528e-21, -2.474958098268436e-22,  1.511888499188618e-23, -8.216820008837648e-25,
  4.021921091148450e-26, -1.787942026661969e-27,  7.144442814538876e-02, -2.124093688557714e-04,  6.575804940080108e-07, -2.104184198454943e-09,  6.898117444836289e-12,
 -2.299186918980244e-14,  7.737990291665453e-17, -2.618934416427573e-19,  8.876928064886723e-22, -3.010683205339799e-24,  1.018572880108675e-26, -3.443301576347200e-29,
  6.553510608979306e-02, -2.470187746864584e-04,  1.122956080878894e-06, -5.307575501267812e-09,  2.477143329109835e-11, -1.130146174448550e-13,  5.044445210441177e-16,
 -2.209386224785349e-18,  9.520094791555326e-21, -4.044650230390865e-23,  1.696953523718684e-25, -7.040585846988583e-28,  5.514821086102872e-02, -2.958867239843527e-04,
  1.924950246428507e-06, -1.193311322516005e-08,  6.990172879355615e-11, -3.919039725321005e-13,  2.122552494597016e-15, -1.117239356821842e-17,  5.739375261692883e-20,
 -2.886508787700819e-22,  1.424723084671064e-24, -6.914817416861138e-27,  4.258280915990675e-02, -3.308051289931916e-04,  2.826282076597756e-06, -2.164222329489465e-08,
  1.534320103648072e-10, -1.027970931293856e-12,  6.584700314360375e-15, -4.063514431731100e-17,  2.429289406793068e-19, -1.412813318162187e-21,  8.019321794219878e-24,
 -4.454087559604412e-26,  3.018052112651911e-02, -3.316788256074292e-04,  3.544023363571269e-06, -3.277066695425766e-08,  2.762524515063990e-10, -2.173950815470254e-12,
  1.619521133418007e-14, -1.153039940841222e-16,  7.899626528237075e-19, -5.234986336657579e-21,  3.369083300011441e-23, -2.112341647479600e-25,  1.964298913913480e-02,
 -2.955040417371467e-04,  3.852577815615984e-06, -4.244446081217151e-08,  4.198915335404773e-10, -3.832160324413966e-12,  3.280681880284521e-14, -2.664404361814429e-16,
  2.069508873620634e-18, -1.546661961650652e-20,  1.117425742052040e-22, -7.833081655399710e-25,  1.174725804713399e-02, -2.343365255089817e-04,  3.675366987144820e-06,
 -4.773762004583091e-08,  5.484796698237576e-10, -5.749614992977274e-12,  5.605719642826254e-14, -5.149330764882384e-16,  4.497834790459181e-18, -3.761652834714425e-20,
  3.028194999772178e-22, -2.356265771874843e-24,  6.460138452179501e-03, -1.661833620610158e-04,  3.104670793565082e-06, -4.711575705580726e-08,  6.234823078400374e-10,
 -7.450103159298349e-12,  8.213766475173608e-14, -8.476850144852662e-16,  8.273768614569903e-18, -7.696163618906943e-20,  6.862947448544554e-22, -5.894050092005033e-24,
  3.269868257786600e-03, -1.059332332814157e-04,  2.338056549454954e-06, -4.113732981950300e-08,  6.226785676099723e-10, -8.428509346673597e-12,  1.044721778069087e-13,
 -1.204747951974134e-15,  1.307166460530244e-17, -1.345691734565123e-19,  1.322953441494087e-21, -1.248282388308226e-23,  1.525102454019638e-03, -6.099245247754609e-05,
  1.578538766423599e-06, -3.198473730884793e-08,  5.505654930880735e-10, -8.397729674016541e-12,  1.164588264132090e-13, -1.493803327955805e-15,  1.793989068370430e-17,
 -2.035583164044460e-19,  2.197516053454983e-21, -2.269378937138584e-23,  6.563725988721949e-04, -3.186067290815055e-05,  9.601892607209338e-07, -2.227258186749421e-08,
  4.337886455512811e-10, -7.422181473653777e-12,  1.146826218843842e-13, -1.629890281843486e-15,  2.158657496551541e-17, -2.690231064446855e-19,  3.178496019159956e-21,
 -3.580962172243836e-23,  2.611015497707083e-04, -1.516276709279526e-05,  5.286152223012359e-07, -1.396261951286673e-08,  3.063165334413058e-10, -5.855975084093563e-12,
  1.004493209545117e-13, -1.576466413816193e-15,  2.295259043774078e-17, -3.132312138094226e-19,  4.038615447584535e-21, -4.950007614445969e-23,  9.619319837245211e-05,
 -6.600722612465313e-06,  2.645524748062732e-07, -7.918612709357795e-09,  1.948930045679951e-10, -4.148207489650141e-12,  7.873984919598546e-14, -1.360563326915512e-15,
  2.171584396949295e-17, -3.236606029463942e-19,  4.542511626532699e-21, -6.042396492583811e-23,  3.289966221277815e-05, -2.638987936309686e-06,  1.208862483686847e-07,
 -4.082125474533560e-09,  1.122988320292237e-10, -2.652640658917074e-12,  5.555735871132925e-14, -1.054132903532954e-15,  1.839853292968834e-17, -2.987818591136372e-19,
  4.554333184853907e-21, -6.560562716118619e-23,  1.047571260975432e-05, -9.730145070005032e-07,  5.066306470027746e-08, -1.922064381388335e-09,  5.889985296811905e-11,
 -1.539468035666704e-12,  3.548231722784166e-14, -7.374648402060685e-16,  1.404357669569448e-17, -2.479601050437921e-19,  4.096725152390182e-21, -6.378394787903793e-23,
  3.115901542593029e-06, -3.323217904327216e-07,  1.956676734218084e-08, -8.307379102752440e-10,  2.826664111986087e-11, -8.152339726468595e-13,  2.062674831547647e-14,
 -4.685531336893185e-16,  9.714880895975004e-18, -1.861326976601163e-19,  3.327003496454819e-21, -5.588694503229941e-23,  8.692073014758333e-07, -1.056462325177580e-07,
  6.999773559298317e-09, -3.313471563842482e-10,  1.248049571897199e-11, -3.961418517270039e-13,  1.097722747339212e-14, -2.719552593912094e-16,  6.127242432401317e-18,
 -1.271543179852120e-19,  2.454589116099462e-21, -4.441112364284187e-23,  2.284790248824881e-07, -3.142954309765179e-08,  2.332524160628230e-09, -1.226674922487996e-10,
  5.099625153114861e-12, -1.776917038306858e-13,  5.380530456856638e-15, -1.450838007654022e-16,  3.545318704699897e-18, -7.954887427099904e-20,  1.655662040748246e-21,
 -3.221396739282642e-23,  5.690600489918663e-08, -8.803178403169376e-09,  7.285490253119715e-10, -4.241893717625377e-11,  1.940786470569108e-12, -7.405181691859593e-14,
  2.444829662629011e-15, -7.160748108560446e-17,  1.894335923950071e-18, -4.587683857993443e-20,  1.027795680181849e-21, -2.147113386961704e-23,  1.351698915662864e-08,
 -2.337462708085478e-09,  2.147971492126921e-10, -1.379887717800474e-11,  6.928304385438338e-13, -2.887571636449025e-14,  1.037136402649313e-15, -3.292936722819115e-17,
  9.413084242893293e-19, -2.456208823070073e-20,  5.913357176750153e-22, -1.324244695232957e-23,  3.085369847336664e-09, -5.930101688259435e-10,  6.025284629136778e-11,
 -4.256222272975778e-12,  2.338376542810192e-13, -1.061855747885223e-14,  4.139706927946127e-16, -1.421840189778241e-17,  4.383398750616958e-19, -1.230139886678721e-20,
  3.177118529916031e-22, -7.614456484523310e-24,  6.827612612419105e-10, -1.450397260959346e-10,  1.622580299036367e-11, -1.255966599122978e-12,  7.527997049638693e-14,
 -3.714746553828494e-15,  1.568187714361631e-16, -5.813812497869198e-18,  1.929064555236006e-19, -5.811211663892793e-21,  1.607178595286171e-22, -4.115107996796392e-24,
  1.479738361833548e-10, -3.455112134415999e-11,  4.237717079454195e-12, -3.581561399728813e-13,  2.334675048608804e-14, -1.248416370219422e-15,  5.692271324832634e-17,
 -2.272513942058310e-18,  8.097675717748232e-20, -2.613080046317586e-21,  7.723396638351833e-23, -2.108676902403780e-24,  3.177716347144717e-11, -8.110181389871377e-12,
  1.085775260275817e-12, -9.981891141267600e-14,  7.052942465579148e-15, -4.074507637957532e-16,  2.001026914144332e-17, -8.580445855299132e-19,  3.275496038719608e-20,
 -1.129645660505920e-21,  3.560427629591099e-23, -1.034356280481398e-24,  6.851548039032152e-12, -1.900502801738216e-12,  2.764488013720904e-13, -2.753421782276499e-14,
  2.101180026616000e-15, -1.307080845139978e-16,  6.892850824903168e-18, -3.165503249719250e-19,  1.291050719568009e-20, -4.746337264035733e-22,  1.591286927571274e-23,
 -4.907350046774614e-25,  1.505222271885662e-12, -4.511136258806792e-13,  7.094792935943977e-14, -7.622381768768214e-15,  6.257339434547325e-16, -4.176071014278188e-17,
  2.356627908822280e-18, -1.155353778354859e-19,  5.018952938698181e-21, -1.961115513537701e-22,  6.974281437752325e-24, -2.276918561279906e-25,  3.424144617669645e-13,
 -1.101975667314503e-13,  1.863987838880469e-14, -2.149884483543734e-15,  1.890209222656290e-16, -1.347845096349820e-17,  8.107856525059520e-19, -4.227786923062045e-20,
  1.949332334163674e-21, -8.068482304993430e-23,  3.033833219422938e-24, -1.045282981621472e-25,  8.205458939267373e-14, -2.817432476837168e-14,  5.096333863353586e-15,
 -6.277190919526576e-16,  5.881942599940700e-17, -4.460572925936815e-18,  2.847679297605107e-19, -1.572757485127261e-20,  7.665978348797780e-22, -3.348239082868383e-23,
  1.326196756443623e-24, -4.804918067971219e-26,  2.108073850859658e-14, -7.670376755110464e-15,  1.474511368021856e-15, -1.928237016706443e-16,  1.915083808148396e-17,
 -1.536487144015648e-18,  1.035856957865115e-19, -6.030625853178748e-21,  3.093226608169298e-22, -1.419345015267539e-23,  5.896884286085487e-25, -2.237426787806450e-26,
  5.904719098235862e-15, -2.260516389754990e-15,  4.586867970058196e-16, -6.327511519895657e-17,  6.620094490991874e-18, -5.586328031196919e-19,  3.954789787737084e-20,
 -2.413956488665944e-21,  1.296167555984291e-22, -6.217039084575729e-24,  2.696211192231253e-25, -1.066326234828625e-26,  1.828558727081327e-15, -7.310429958578658e-16,
  1.554259908163869e-16, -2.245741341771235e-17,  2.458283096511978e-18, -2.167542843461657e-19,  1.601218913963012e-20, -1.018497508752885e-21,  5.691499349421230e-23,
 -2.837491571601207e-24,  1.277499483376837e-25, -5.238481341144090e-27,  6.305818823403694e-16, -2.612227363837231e-16,  5.773053739692827e-17, -8.669434110651906e-18,
  9.854727703585541e-19, -9.013794054554465e-20,  6.899848366916676e-21, -4.542750671478844e-22,  2.624738825189867e-23, -1.351568965494520e-24,  6.278665732580645e-26,
 -2.653722857306902e-27,  2.401269564607420e-16, -1.022435392968414e-16,  2.328897616756971e-17, -3.604507902918194e-18,  4.220297188231060e-19, -3.972875532577009e-20,
  3.127290870049000e-21, -2.115476848170739e-22,  1.254788734264325e-23, -6.627678625467964e-25,  3.155612033555922e-26, -1.365848551774663e-27,  9.594811579777185e-17,
 -4.164385727290441e-17,  9.689244212192417e-18, -1.531883850532146e-18,  1.831411205854974e-19, -1.759439434938179e-20,  1.412566153834145e-21, -9.740040268479197e-23,
  5.885434151033318e-24, -3.165001154771509e-25,  1.533404354652803e-26, -6.749622448104750e-28,  3.168415477128123e-17, -1.389964008363690e-17,  3.272817591736843e-18,
 -5.236660334477977e-19,  6.334545026255156e-20, -6.155653660082142e-21,  4.997314283242362e-22, -3.483145572296895e-23,  2.126809008097862e-24, -1.155372396750335e-25,
  5.652826874867214e-27, -2.511911639370587e-28,  7.060515464348310e-02, -2.072478837615147e-04,  6.329776484442037e-07, -1.997394551745868e-09,  6.456273437649210e-12,
 -2.121963522664100e-14,  7.042882303783306e-17, -2.351456599186804e-19,  7.862911923730038e-22, -2.631988259825931e-24,  8.786168640470134e-27, -2.932968547609742e-29,
  6.456460420361132e-02, -2.382833194441650e-04,  1.061570717569440e-06, -4.928677542545513e-09,  2.262736910743113e-11, -1.016171780802319e-13,  4.466368134611192e-16,
 -1.926788564942629e-18,  8.179091919345720e-21, -3.423950322773006e-23,  1.415654350492228e-25, -5.789076089584029e-28,  5.399458233134295e-02, -2.810414764025770e-04,
  1.788213480841870e-06, -1.087472513821214e-08,  6.254875616876607e-11, -3.445183237754922e-13,  1.833950799586009e-15, -9.491625843001765e-18,  4.795884415814040e-20,
 -2.373075369536683e-22,  1.152688620650701e-24, -5.506826483197860e-27,  4.130322127403158e-02, -3.091934741803988e-04,  2.580653202785740e-06, -1.934357165229911e-08,
  1.343651075019147e-10, -8.827579748854275e-13,  5.548522441075280e-15, -3.361692726895713e-17,  1.973987724819500e-19, -1.128036843080260e-21,  6.293498931722876e-24,
 -3.436807254592149e-26,  2.890812151799211e-02, -3.048276624937440e-04,  3.175926316236994e-06, -2.867838974951071e-08,  2.364128328033252e-10, -1.821316648935856e-12,
  1.329402520130874e-14, -9.279759044418556e-17,  6.236769525205075e-19, -4.056314596562081e-21,  2.563103300747716e-23, -1.578380407155473e-25,  1.851954233229876e-02,
 -2.666121018466371e-04,  3.381156602939037e-06, -3.629897001337022e-08,  3.505542756099058e-10, -3.127322545024524e-12,  2.619570215918315e-14, -2.083254264791848e-16,
  1.585500512738641e-18, -1.161688709510648e-20,  8.232180294098912e-23, -5.662566135207892e-25,  1.086528942165323e-02, -2.070840966046960e-04,  3.151598911169813e-06,
 -3.981340993722136e-08,  4.458522636158631e-10, -4.562168074915923e-12,  4.346608207569245e-14, -3.905204122206289e-16,  3.338803914409838e-18, -2.734846888380221e-20,
  2.157452501961978e-22, -1.645863351941679e-24,  5.841724256492741e-03, -1.434486311373103e-04,  2.594545069636795e-06, -3.823251184470363e-08,  4.924151426835389e-10,
 -5.736085889940535e-12,  6.172764301940270e-14, -6.224248395992704e-16,  5.940573921699762e-18, -5.407246736097549e-20,  4.721211926847091e-22, -3.972203914967381e-24,
  2.880641059611787e-03, -8.904598406879665e-05,  1.899034799392235e-06, -3.239747526481310e-08,  4.766758720271490e-10, -6.282841349486189e-12,  7.593408628563726e-14,
 -8.547387881057121e-16,  9.060670155760978e-18, -9.120123266624838e-20,  8.772336719041914e-22, -8.103199295460318e-24,  1.304154174507321e-03, -4.976149997988113e-05,
  1.242489401353730e-06, -2.438059889000880e-08,  4.074816619679587e-10, -6.045974816877264e-12,  8.167825501240852e-14, -1.021789580388132e-15,  1.197961349409831e-17,
 -1.328087624016643e-19,  1.401839570781437e-21, -1.416382607603856e-23,  5.427530562928097e-04, -2.514063407000817e-05,  7.301085180251040e-07, -1.638418521262477e-08,
  3.095406554789642e-10, -5.147526817887169e-12,  7.741910401720693e-14, -1.072322565112825e-15,  1.385524243978269e-17, -1.686034592046576e-19,  1.946613470211739e-21,
 -2.144556515970014e-23,  2.079540439050338e-04, -1.152885190723126e-05,  3.869918466421657e-07, -9.881163105684668e-09,  2.101179108149093e-10, -3.901289274618476e-12,
  6.509563578629523e-14, -9.950422234669958e-16,  1.412565747709955e-17, -1.881331406228966e-19,  2.369240643351574e-21, -2.838408950360219e-23,  7.348862707246612e-05,
 -4.817082530099408e-06,  1.858013629498588e-07, -5.373027404884833e-09,  1.281049835405046e-10, -2.646706139805095e-12,  4.884392411854091e-14, -8.216340143346142e-16,
  1.278101235707764e-17, -1.858346818752044e-19,  2.546537121197855e-21, -3.309873395703126e-23,  2.400599323338213e-05, -1.840901390242906e-06,  8.114056843653330e-08,
 -2.646274243559228e-09,  7.049483363321805e-11, -1.615732249115762e-12,  3.288851933484783e-14, -6.072867100391186e-16,  1.032701366825689e-17, -1.635577146035464e-19,
  2.433593204917922e-21, -3.424636166639768e-23,  7.268059364570089e-06, -6.460191856271613e-07,  3.236931281203308e-08, -1.185915241401643e-09,  3.518484271261906e-11,
 -8.921390311802738e-13,  1.998006910139714e-14, -4.040529895943527e-16,  7.495345710784844e-18, -1.290486562622081e-19,  2.080925841230496e-21, -3.164703270132673e-23,
  2.045963126777344e-06, -2.090587799435415e-07,  1.184975986516418e-08, -4.859115594051722e-10,  1.600797800537556e-11, -4.478766931100714e-13,  1.101072779880314e-14,
 -2.433554149080561e-16,  4.915006849453807e-18, -9.182465155413330e-20,  1.601902432861056e-21, -2.628452782378455e-23,  5.375382110479729e-07, -6.267855373559375e-08,
  4.000428850400932e-09, -1.829662116257718e-10,  6.674149632032106e-12, -2.055454710103152e-13,  5.535076218113967e-15, -1.334391444976287e-16,  2.928943999532791e-18,
 -5.927661883040161e-20,  1.116955788119298e-21, -1.974325384249070e-23,  1.324107229933705e-07, -1.750082479565577e-08,  1.252244577337434e-09, -6.366839436135407e-11,
  2.564561600254735e-12, -8.673685932608507e-14,  2.553189861826303e-15, -6.701425909959101e-17,  1.595850730412162e-18, -3.493029630798392e-20,  7.098530836205311e-22,
 -1.349694366582612e-23,  3.074558828346486e-08, -4.577791639964607e-09,  3.656864092629509e-10, -2.060213364748109e-11,  9.139318234609929e-13, -3.386842409063769e-14,
  1.087587592990616e-15, -3.102284894976118e-17,  8.001560743676453e-19, -1.891213315293559e-20,  4.138810203266316e-22, -8.452963389939514e-24,  6.772787155230298e-09,
 -1.129425869566867e-09,  1.003161156406839e-10, -6.242587770663185e-12,  3.041837876056221e-13, -1.232318406756073e-14,  4.308324066514199e-16, -1.333113166333272e-17,
  3.717897189333417e-19, -9.474049280820758e-21,  2.229426140596683e-22, -4.883978824789829e-24,  1.426133624557027e-09, -2.648873596694036e-10,  2.605584219210814e-11,
 -1.785306187772520e-12,  9.530130436095479e-14, -4.211025415645328e-15,  1.599538278283777e-16, -5.358958058301632e-18,  1.613226211921317e-19, -4.424873141525000e-21,
  1.117926043677620e-22, -2.623014470663453e-24,  2.896153750078016e-10, -5.959264386605226e-11,  6.466093344784269e-12, -4.862532354097421e-13,  2.835775593311436e-14,
 -1.363381397591033e-15,  5.614437571612113e-17, -2.032637487390374e-18,  6.592679966240859e-20, -1.943058273944113e-21,  5.261897034953776e-23, -1.320245275617437e-24,
  5.731438258130545e-11, -1.299523199421861e-11,  1.549121464308871e-12, -1.274285007692288e-13,  8.095515875350665e-15, -4.224084229652086e-16,  1.881456452492948e-17,
 -7.344908048879395e-19,  2.561584281733778e-20, -8.097174659857599e-22,  2.346156934961923e-23, -6.284149781578886e-25,  1.118714296855252e-11, -2.780003307089066e-12,
  3.625628289182738e-13, -3.250795821829134e-14,  2.242789611150215e-15, -1.266506851677651e-16,  6.086020700601687e-18, -2.555854017133147e-19,  9.563443866571519e-21,
 -3.235396530164486e-22,  1.001031151720294e-23, -2.856773129445916e-25,  2.183717566584509e-12, -5.914542841936446e-13,  8.401963635637325e-14, -8.180120897330876e-15,
  6.108086032344101e-16, -3.721458114342946e-17,  1.923816540057485e-18, -8.667989081927309e-20,  3.471043865500169e-21, -1.253785619894393e-22,  4.132821025370135e-24,
 -1.253877973479376e-25,  4.330140431069138e-13, -1.270918116274180e-13,  1.957246776575140e-14, -2.060576859609421e-15,  1.658987139372665e-16, -1.086754441328397e-17,
  6.024211803891642e-19, -2.903244629578206e-20,  1.240606508412588e-21, -4.771445206384936e-23,  1.671198509933853e-24, -5.376603864380418e-26,  8.875821352273533e-14,
 -2.805911144035148e-14,  4.660565691774085e-15, -5.281319209777333e-16,  4.565249791066284e-17, -3.202722759525497e-18,  1.896685192027939e-19, -9.742750311967909e-21,
  4.427790616438742e-22, -1.807439986404378e-23,  6.705922463422778e-25, -2.280952377304364e-26,  1.916600219408716e-14, -6.484033874358732e-15,  1.155040695889991e-15,
 -1.401591709159165e-16,  1.294574474456505e-17, -9.682526678704008e-19,  6.099810461919795e-20, -3.326127682531456e-21,  1.601435793750242e-22, -6.912329065097165e-24,
  2.706898809416193e-25, -9.700522522151594e-27,  4.446901525915897e-15, -1.598963898779179e-15,  3.035813000151913e-16, -3.921972354359120e-17,  3.849693565203332e-18,
 -3.053872949421087e-19,  2.036539312020071e-20, -1.173294197172020e-21,  5.957719997143040e-23, -2.707346675801912e-24,  1.114349525874094e-25, -4.190311646964606e-27,
  1.130402967270013e-15, -4.288557293254499e-16,  8.618796069272288e-17, -1.177764207869535e-17,  1.220991061441557e-18, -1.021266547712074e-19,  7.168735671304828e-21,
 -4.340036369906305e-22,  2.312079036939417e-23, -1.100600247772321e-24,  4.738330080769103e-26, -1.860840058930424e-27,  3.202122133653946e-16, -1.271899040905071e-16,
  2.685354929648567e-17, -3.853388388025974e-18,  4.189926676966765e-19, -3.670564450524867e-20,  2.694682651770373e-21, -1.703757987433441e-22,  9.465893028504091e-24,
 -4.692978153463489e-25,  2.101560133902694e-26, -8.573206711804952e-28,  1.021437804544476e-16, -4.213327353807790e-17,  9.268306326472309e-18, -1.385422937647742e-18,
  1.567784821703331e-19, -1.427786028831911e-20,  1.088364557641570e-21, -7.136711017386890e-23,  4.107455589047465e-24, -2.107140431375878e-25,  9.753255315466351e-27,
 -4.107946027939189e-28,  3.650172349206997e-17, -1.550349468003079e-17,  3.521748514644093e-18, -5.435919191506103e-19,  6.347718309249259e-20, -5.960222730770930e-21,
  4.679999659759473e-22, -3.158223506727761e-23,  1.868953201117505e-24, -9.849575470341157e-26,  4.679523782378698e-27, -2.021238049975039e-28,  1.392691023997820e-17,
 -6.037411066643471e-18,  1.402859550499357e-18, -2.215002161824142e-19,  2.644660683806024e-20, -2.537520694408782e-21,  2.034753239521691e-22, -1.401354559861624e-23,
  8.457976820813235e-25, -4.543374123264860e-26,  2.198838699338921e-27, -9.668616991103545e-29,  4.478746580610266e-18, -1.963897375757786e-18,  4.621822137027789e-19,
 -7.391280195336478e-20,  8.936287383110086e-21, -8.679535913964338e-22,  7.042784124586416e-23, -4.906475814676830e-24,  2.994482651030946e-25, -1.625980944340186e-26,
  7.951774881278688e-28, -3.531936471877048e-29,  6.978614138624938e-02, -2.022782130741524e-04,  6.096150026094972e-07, -1.897399667726128e-09,  6.048264671612469e-12,
 -1.960559437293607e-14,  6.418322805856218e-17, -2.114349820981588e-19,  6.975667370949464e-22, -2.305034287445198e-24,  7.592779766809883e-27, -2.503694900120750e-29,
  6.362808996774943e-02, -2.300213263444142e-04,  1.004533584879786e-06, -4.582333796054787e-09,  2.069799658078127e-11, -9.151682098634344e-14,  3.961731752587282e-16,
 -1.683734603343725e-18,  7.042547210284474e-21, -2.905488930981732e-23,  1.184045650945668e-25, -4.773273432219503e-28,  5.289822470966287e-02, -2.672412506677016e-04,
  1.663501584690087e-06, -9.926763837800600e-09,  5.607787475726099e-11, -3.035268586783780e-13,  1.588447332597671e-15, -8.085186126922846e-18,  4.019048987986588e-20,
 -1.957011276221320e-22,  9.356787368560246e-25, -4.400917681755148e-27,  4.010631760159999e-02, -2.894414890115548e-04,  2.360869365429032e-06, -1.732804359021151e-08,
  1.179688860564719e-10, -7.602107863315774e-13,  4.689908188988180e-15, -2.790413925611880e-17,  1.609787404827701e-19, -9.041101599404189e-22,  4.959109998527412e-24,
 -2.663196214689881e-26,  2.773753340078058e-02, -2.807351703826216e-04,  2.853333036352154e-06, -2.517070419986346e-08,  2.029777083617894e-10, -1.531312995641904e-12,
  1.095448299227217e-14, -7.499131555977131e-17,  4.945451486982651e-19, -3.157529789515584e-21,  1.959399319848575e-23, -1.185388930142570e-25,  1.750456232255994e-02,
 -2.412143898649871e-04,  2.977263609976977e-06, -3.115819886184181e-08,  2.938503802281856e-10, -2.563254719455412e-12,  2.101428755973731e-14, -1.636909204675656e-16,
  1.221015461440095e-18, -8.773041581514270e-21,  6.099342623009872e-23, -4.117823635116882e-25,  1.008451530571179e-02, -1.836676610415839e-04,  2.713802719401512e-06,
 -3.335655247783078e-08,  3.642138027841777e-10, -3.638977347217886e-12,  3.389038684781707e-14, -2.978978334457641e-16,  2.493597320351577e-18, -2.001000021019566e-20,
  1.547267155773448e-22, -1.157530397195597e-24,  5.306714999122851e-03, -1.244017180488699e-04,  2.179486394090708e-06, -3.119671129155860e-08,  3.912002331675066e-10,
 -4.443952432873225e-12,  4.669261630783990e-14, -4.601438042194873e-16,  4.295603311927148e-18, -3.827009216359265e-20,  3.272527504924284e-22, -2.697970057213648e-24,
  2.552550688537965e-03, -7.528807338687740e-05,  1.552179155488303e-06, -2.568448214642152e-08,  3.674619596451888e-10, -4.717659929391146e-12,  5.561152370908433e-14,
 -6.111978165589201e-16,  6.331602893665945e-18, -6.232850783992895e-20,  5.867035364189633e-22, -5.306765300910472e-24,  1.123280252654288e-03, -4.088956172143128e-05,
  9.853703008708117e-07, -1.873074091929393e-08,  3.040539741071431e-10, -4.389758715846735e-12,  5.778688147241286e-14, -7.052294094667933e-16,  8.073702398351699e-18,
 -8.747259230423999e-20,  9.029576383869525e-22, -8.927865642532632e-24,  4.527363746956356e-04, -2.000922735959781e-05,  5.601179788314945e-07, -1.216355853856530e-08,
  2.229756230406947e-10, -3.604781696789073e-12,  5.278606099426380e-14, -7.127129638382393e-16,  8.985924942474295e-18, -1.067954399649643e-19,  1.205128766937292e-21,
 -1.298532385679395e-23,  1.673530460154677e-04, -8.855482918330530e-06,  2.862654882079615e-07, -7.067226123049108e-09,  1.456979467841583e-10, -2.627909740246776e-12,
  4.266206765969528e-14, -6.352883636813224e-16,  8.795109285311105e-18, -1.143404349118043e-19,  1.406677672046146e-21, -1.647491604173544e-23,  5.682913462376809e-05,
 -3.557377286098156e-06,  1.320630726282083e-07, -3.690191432148347e-09,  8.524490630052622e-11, -1.709848223197603e-12,  3.068354735236304e-14, -5.025588219424439e-16,
  7.620250253018472e-18, -1.081041434055841e-19,  1.446579806740243e-21, -1.837419151791454e-23,  1.776367098851122e-05, -1.301826890747461e-06,  5.521100014848579e-08,
 -1.739160586706355e-09,  4.486824145475405e-11, -9.979489582953565e-13,  1.974442109693024e-14, -3.548445852946294e-16,  5.879755137325810e-18, -9.082919872571975e-20,
  1.319322712754676e-21, -1.813874058357584e-23,  5.123677295822747e-06, -4.356224095275459e-07,  2.100221294201255e-08, -7.430547868024075e-10,  2.134463702212609e-11,
 -5.250552845242030e-13,  1.142655696395403e-14, -2.248499869641744e-16,  4.063378294112076e-18, -6.822288138230812e-20,  1.073749958627827e-21, -1.595149627406199e-23,
  1.367749287843247e-06, -1.338281025972016e-07,  7.300859926470077e-09, -2.891183676304300e-10,  9.221425459695821e-12, -2.502765522454822e-13,  5.978327283880666e-15,
 -1.285577050824378e-16,  2.529204961117407e-18, -4.607529545341557e-20,  7.844946278603300e-22, -1.257358787978979e-23,  3.391285945029924e-07, -3.791328063236975e-08,
  2.330210927401292e-09, -1.029516762023307e-10,  3.636388151739902e-12, -1.086490789037415e-13,  2.842992496490403e-15, -6.668932795265156e-17,  1.425982637375932e-18,
 -2.814265360157556e-20,  5.176019923671923e-22, -8.937630230906315e-24,  7.843934325843487e-08, -9.954391841134890e-09,  6.864378701970980e-10, -3.373126476739306e-11,
  1.316125037057299e-12, -4.319789428950330e-14,  1.235915415563880e-15, -3.157160129587124e-17,  7.325706328542227e-19, -1.563989784318394e-20,  3.102949040633717e-22,
 -5.764793819771950e-24,  1.701276097179704e-08, -2.436159047497728e-09,  1.877418529354610e-10, -1.023030334984576e-11,  4.398728804146960e-13, -1.582726776852760e-14,
  4.942200716115252e-16, -1.372602012173179e-17,  3.450951849577864e-19, -7.958781452065589e-21,  1.701062161550576e-22, -3.395932271917039e-24,  3.481747770601177e-09,
 -5.594286198358829e-10,  4.799696823551462e-11, -2.891781399588910e-12,  1.366901761670008e-13, -5.380720000842183e-15,  1.830458322246802e-16, -5.518152915645020e-18,
  1.500995782643685e-19, -3.734252571633114e-21,  8.586906550322618e-23, -1.839736121392840e-24,  6.773934096300910e-10, -1.214753856870932e-10,  1.155975178731237e-11,
 -7.678129397799590e-13,  3.980246467431729e-14, -1.710541962995437e-15,  6.327881056420968e-17, -2.067177681343127e-18,  6.074183459406371e-20, -1.627814957077761e-21,
  4.021681043875957e-23, -9.235074229444817e-25,  1.264040531849686e-10, -2.516857239055455e-11,  2.646617083155911e-12, -1.932243068518948e-13,  1.095757681760313e-14,
 -5.129989768959481e-16,  2.059708473701343e-17, -7.278570354933561e-19,  2.306604586370636e-20, -6.648445557902499e-22,  1.762235048535222e-23, -4.331185885800337e-25,
  2.286231375279919e-11, -5.028488003055240e-12,  5.820961914503686e-13, -4.656784845119786e-14,  2.881316122135661e-15, -1.466096294227532e-16,  6.375416364476384e-18,
 -2.432415200079813e-19,  8.298663343477659e-21, -2.568366744874068e-22,  7.292058965244010e-24, -1.915304133239809e-25,  4.057704304814738e-12, -9.807526808001979e-13,
  1.244885001719622e-13, -1.087712303402104e-14,  7.322019743175752e-16, -4.038928744312983e-17,  1.897855173459950e-18, -7.801026069372591e-20,  2.859540359231819e-21,
 -9.484740730880001e-23,  2.879286320409652e-24, -8.067929875455699e-26,  7.169419366309232e-13, -1.894066804773000e-13,  2.625186051583790e-14, -2.496255283397557e-15,
  1.822418823918787e-16, -1.086696808371283e-17,  5.503222324403517e-19, -2.431108279588741e-20,  9.552659477057358e-22, -3.388331087088173e-23,  1.097501002821829e-24,
 -3.274135923186448e-26,  1.282060146690059e-13, -3.681355691543433e-14,  5.546282474616930e-15, -5.716916050719466e-16,  4.510479043118023e-17, -2.897983246186314e-18,
  1.576902392760299e-19, -7.465510006838367e-21,  3.136096118754777e-22, -1.186511327001661e-23,  4.090579355191237e-25, -1.296166944730813e-26,  2.364112107953372e-14,
 -7.334284531673408e-15,  1.195147380987361e-15, -1.329503002222846e-16,  1.129003064532086e-17, -7.786673695086811e-19,  4.536633372493635e-20, -2.294097110533448e-21,
  1.027016315173529e-22, -4.132051220712343e-24,  1.511847355025528e-25, -5.073938251791395e-27,  4.589052671001308e-15, -1.528332047725946e-15,  2.678861126621634e-16,
 -3.199966452760768e-17,  2.911223885736699e-18, -2.145962800933615e-19,  1.333174230580372e-20, -7.172762160027053e-22,  3.409264268527787e-23, -1.453426096766428e-24,
  5.624185353810951e-26, -1.992514953700017e-27,  9.585878019063986e-16, -3.403552186883986e-16,  6.377460785893341e-17, -8.133632847391814e-18,  7.885096546784254e-19,
 -6.180699557623986e-20,  4.074619243665720e-21, -2.321681073420423e-22,  1.166437970933692e-23, -5.246701609528693e-25,  2.138408565359182e-26, -7.965407930919202e-28,
  2.203164244634725e-16, -8.277974254645307e-17,  1.646696552938562e-17, -2.227709857481888e-18,  2.287107360265020e-19, -1.895138145686928e-20,  1.318335349374688e-21,
 -7.912387070752835e-23,  4.180138984661272e-24, -1.973912757012011e-25,  8.432643914290629e-27, -3.287141118645698e-28,  5.685414801704437e-17, -2.242606005278906e-17,
  4.699579813479076e-18, -6.694229190771488e-19,  7.227034525463064e-20, -6.287685615428030e-21,  4.585427635918893e-22, -2.880726739621475e-23,  1.590675421721390e-24,
 -7.839599188865923e-26,  3.490660181383078e-27, -1.416204550648988e-28,  1.670621920609121e-17, -6.859545740926249e-18,  1.501424762761895e-18, -2.233256445919616e-19,
  2.515097467507813e-20, -2.279886562134314e-21,  1.730126974448119e-22, -1.129603439014881e-23,  6.474314721588403e-25, -3.308061611986683e-26,  1.525289524466786e-27,
 -6.400514188844164e-29,  5.581424047997922e-18, -2.364287652861381e-18,  5.354944814909215e-19, -8.241421318315785e-20,  9.596457430666991e-21, -8.985842232065907e-22,
  7.036970841178670e-23, -4.736601798288596e-24,  2.796056851065067e-25, -1.470031995804805e-26,  6.968019082915742e-28, -3.003041788273478e-29,  2.027425653200617e-18,
 -8.777779828114127e-19,  2.036721117377591e-19, -3.211256807880579e-20,  3.828841965804822e-21, -3.668771148350014e-22,  2.938017662480674e-23, -2.020879870594788e-24,
  1.218222568999136e-25, -6.536175326338988e-27,  3.159660169121360e-28, -1.387812145947555e-29,  6.338204625404487e-19, -2.777910334250823e-19,  6.533960117901778e-20,
 -1.044346053272558e-20,  1.261962130576238e-21, -1.225052529121875e-22,  9.935203321912491e-24, -6.918016047091291e-25,  4.220059452653133e-26, -2.290352605068949e-27,
  1.119557084066876e-28, -4.970452210597668e-30,  6.898664045553679e-02, -1.974907523758920e-04,  5.874141660302232e-07, -1.803682601592522e-09,  5.671089942570188e-12,
 -1.813379128329051e-14,  5.856348937072422e-17, -1.903840174738579e-19,  6.197969983375366e-22, -2.022245877052452e-24,  6.572977306409207e-27, -2.141918356675891e-29,
  6.272373671112542e-02, -2.221995156594666e-04,  9.514738166117594e-07, -4.265307515357435e-09,  1.895905063871404e-11, -8.254986854564517e-14,  3.520327091805115e-16,
 -1.474234151307386e-18,  6.076995989802713e-21, -2.471318309993827e-23,  9.928257013431795e-26, -3.946383921377150e-28,  5.185514224042980e-02, -2.543949177477619e-04,
  1.549570072293309e-06, -9.076085240996117e-09,  5.037095210809768e-11, -2.679816770408791e-13,  1.379057713792529e-15, -6.904953062925448e-18,  3.377477154166056e-20,
 -1.618751451428528e-22,  7.619641404060359e-25, -3.529101364543836e-27,  3.898505244916935e-02, -2.713553097085637e-04,  2.163775225014958e-06, -1.555631504576373e-08,
  1.038298472657193e-10, -6.564754416674944e-13,  3.976077955426388e-15, -2.323748141622693e-17,  1.317360285023128e-19, -7.273271776499988e-22,  3.923025464017690e-24,
 -2.072284704718230e-26,  2.665840806173615e-02, -2.590637281643332e-04,  2.569804175059123e-06, -2.215446933769409e-08,  1.748192593316254e-10, -1.291914076671925e-12,
  9.060215980877034e-15, -6.084298123762455e-17,  3.938096461128081e-19, -2.468890925890091e-21,  1.504939783626426e-23, -8.946365213696806e-26,  1.658508087473022e-02,
 -2.188156727678139e-04,  2.629967801829743e-06, -2.684079338422648e-08,  2.472791024169014e-10, -2.109772604277530e-12,  1.693363953108146e-14, -1.292341048896566e-16,
  9.450604975006519e-19, -6.660436527405756e-21,  4.544094403690345e-23, -3.011747085705555e-25,  9.390863317918923e-03, -1.634645452265280e-04,  2.346222666485916e-06,
 -2.806985683199075e-08,  2.989362401616519e-10, -2.917310135653179e-12,  2.656605721604435e-14, -2.285269324867253e-16,  1.873370982552467e-18, -1.473103976446960e-20,
  1.116778398168994e-22, -8.195015110555876e-25,  4.841750747457209e-03, -1.083632424698677e-04,  1.839933971574428e-06, -2.559176935242210e-08,  3.125589918201971e-10,
 -3.463593181189212e-12,  3.554265369555361e-14, -3.424168770558924e-16,  3.127448321901101e-18, -2.727863514894817e-20,  2.285059340304372e-22, -1.846405407361662e-24,
  2.274413452189290e-03, -6.401027263757340e-05,  1.276348003582284e-06, -2.049283069549087e-08,  2.851794123668708e-10, -3.567372738489095e-12,  4.102704821737176e-14,
 -4.403787555112411e-16,  4.459390099914874e-18, -4.294254047013835e-20,  3.956749013565633e-22, -3.505228366882732e-24,  9.741729323779758e-04, -3.382918638151897e-05,
  7.871202857118078e-07, -1.449910813479938e-08,  2.286675751112365e-10, -3.213314380788752e-12,  4.122965226000881e-14, -4.909864243065085e-16,  5.490086246733674e-18,
 -5.814261945452557e-20,  5.870965887175440e-22, -5.681708233418003e-24,  3.808158460381470e-04, -1.605654849404326e-05,  4.333875236718004e-07, -9.110123492329668e-09,
  1.620861928608324e-10, -2.548140218951841e-12,  3.633818958200744e-14, -4.783874679791319e-16,  5.886875398293562e-18, -6.834467548052567e-20,  7.539464957712893e-22,
 -7.947023754926715e-24,  1.360253559076663e-04, -6.868616875526656e-06,  2.138763149275310e-07, -5.106414124797529e-09,  1.020873460924059e-10, -1.789121490870133e-12,
  2.826530956509889e-14, -4.101211785690072e-16,  5.538232305297357e-18, -7.029310209423587e-20,  8.449578789327188e-22, -9.676071224595861e-24,  4.446178831576325e-05,
 -2.657176185910005e-06,  9.495342161399892e-08, -2.564168339472607e-09,  5.740067483839310e-11, -1.117980681889526e-12,  1.951202028113139e-14, -3.112223257817960e-16,
  4.600645764748954e-18, -6.368983531239958e-20,  8.323577964032204e-22, -1.033331778781554e-23,  1.332298470493378e-05, -9.327793858303251e-07,  3.806479124162699e-08,
 -1.158224840374800e-09,  2.894140722844918e-11, -6.247418916864516e-13,  1.201580576154937e-14, -2.102058740263073e-16,  3.394358985989987e-18, -5.114971957955944e-20,
  7.253773606944501e-22, -9.744361114215908e-24,  3.668005186341265e-06, -2.981765191710180e-07,  1.383109947709483e-08, -4.725518355881291e-10,  1.314323078777295e-11,
 -3.136781305093220e-13,  6.633920319525326e-15, -1.270323917675320e-16,  2.236557480055488e-18, -3.662121890981024e-20,  5.626044772886902e-22, -8.164856508764680e-24,
  9.303742280425748e-07, -8.712591918961683e-08,  4.573779424446590e-09, -1.749010956870707e-10,  5.400596235111723e-12, -1.421866991193736e-13,  3.300057635844313e-15,
 -6.904584139638244e-17,  1.323218938405169e-18, -2.350555312560528e-20,  3.906094014515132e-22, -6.115349985534836e-24,  2.181400611176134e-07, -2.336804983350758e-08,
  1.382649486780138e-09, -5.899889318139227e-11,  2.017614580112922e-12, -5.847879373228642e-14,  1.486796060023835e-15, -3.393342779190516e-17,  7.067952975288628e-19,
 -1.360199807388634e-20,  2.441702094194797e-22, -4.118543582228451e-24,  4.747160536371031e-08, -5.780513161303275e-09,  3.840010682672533e-10, -1.823210671671662e-11,
  6.889415385943282e-13, -2.194048615407365e-14,  6.100343057510454e-16, -1.516451808382278e-17,  3.428130076476427e-19, -7.137852789626148e-21,  1.382409609589695e-22,
 -2.509246612929651e-24,  9.636264223850536e-09, -1.326071852999662e-09,  9.853803469317918e-11, -5.191439217887530e-12,  2.162857066201863e-13, -7.554209502766020e-15,
  2.293229428750769e-16, -6.199937978724398e-18,  1.519143465908350e-19, -3.417980412361790e-21,  7.133570915241041e-23, -1.391807422698299e-24,  1.835592392076761e-09,
 -2.839326255863716e-10,  2.351667257566881e-11, -1.371115697748472e-12,  6.284473194187591e-14, -2.402887754676008e-15,  7.951489819058102e-17, -2.334700434749761e-18,
  6.192341778136741e-20, -1.503677712320148e-21,  3.377992133214489e-23, -7.076442600019854e-25,  3.305231391620443e-10, -5.717381569214456e-11,  5.259786677518935e-12,
 -3.384707992250764e-13,  1.703042967353246e-14, -7.115248854725140e-16,  2.562457062460802e-17, -8.159205975698534e-19,  2.339387158037249e-20, -6.123341246793946e-22,
  1.478925064026414e-23, -3.322726125104745e-25,  5.675436657901868e-11, -1.092436410205198e-11,  1.112420905008866e-12, -7.879480658814849e-14,  4.342465087082890e-15,
 -1.978622861410337e-16,  7.741775189626284e-18, -2.669137650432392e-19,  8.261121375082369e-21, -2.327744832361620e-22,  6.036721964574759e-24, -1.452836962461530e-25,
  9.391610642597777e-12, -2.001722689099012e-12,  2.248239410022914e-13, -1.747903151184466e-14,  1.052583028433616e-15, -5.219696174639710e-17,  2.214778016087184e-18,
 -8.254059576162757e-20,  2.753413061078153e-21, -8.339522171922108e-23,  2.319053335002213e-24, -5.970514298667836e-26,  1.516590803790890e-12, -3.561520317521753e-13,
  4.395797637696847e-14, -3.739777778879921e-15,  2.454475994365241e-16, -1.321644677654067e-17,  6.068875473285682e-19, -2.440204741583769e-20,  8.757805412413820e-22,
 -2.846503143739960e-23,  8.474081038101906e-25, -2.330294940800796e-26,  2.425558307826321e-13, -6.243671995769863e-14,  8.435202372874785e-15, -7.827079080046120e-16,
  5.582507997890522e-17, -3.255547062261242e-18,  1.613965814388474e-19, -6.986115628091750e-21,  2.691976519505312e-22, -9.370915838691035e-24,  2.980984737981981e-25,
 -8.739933697203587e-27,  3.909047514487045e-14, -1.096964662489622e-14,  1.615231124442173e-15, -1.628649674979738e-16,  1.258173587492457e-17, -7.922608531081810e-19,
  4.228707697601838e-20, -1.965359507626930e-21,  8.111021091850001e-23, -3.016913490361333e-24,  1.023201753257963e-25, -3.191504484162183e-27,  6.475346271016677e-15,
 -1.969416980630924e-15,  3.145514745749766e-16, -3.431977596195500e-17,  2.860753005012886e-18, -1.938242271480483e-19,  1.110155837397863e-20, -5.522803073315091e-22,
  2.433919919919922e-23, -9.645865115888203e-25,  3.478392380455894e-26, -1.151209631847395e-27,  1.127381868024043e-15, -3.692701268001279e-16,  6.363163297032496e-17,
 -7.476164566041301e-18,  6.694147532888315e-19, -4.859686067293517e-20,  2.975152769786020e-21, -1.578341722766819e-22,  7.401312115560295e-24, -3.114594017734349e-25,
  1.190261146892680e-26, -4.166481460167021e-28,  2.113650670626443e-16, -7.404595067919318e-17,  1.368205712789452e-17, -1.721348919374416e-18,  1.646962459078502e-19,
 -1.274760260897022e-20,  8.302509274361602e-22, -4.675891187794722e-23,  2.323060547266384e-24, -1.033735150498721e-25,  4.169793172156096e-27, -1.537832202296556e-28,
  4.375786262132650e-17, -1.627206563884702e-17,  3.201808746588770e-18, -4.285438014180974e-19,  4.354440282567660e-20, -3.572426584079273e-21,  2.461453270057906e-22,
 -1.463786069535630e-23,  7.665125648865522e-25, -3.588902240981277e-26,  1.520694149501044e-27, -5.881401470258310e-29,  1.024351202345748e-17, -4.010462508386519e-18,
  8.337387593205089e-19, -1.178290245530270e-19,  1.262402953658496e-20, -1.090268112955813e-21,  7.894900644051436e-23, -4.926177938067971e-24,  2.702360664267283e-25,
 -1.323478586315162e-26,  5.857261277880203e-28, -2.362549319978836e-29,  2.760733600117926e-18, -1.127958914371516e-18,  2.455695411874336e-19, -3.633346297766308e-20,
  4.070856937666055e-21, -3.671837819877762e-22,  2.773102157422112e-23, -1.802223979074793e-24,  1.028362479271207e-25, -5.231997518460094e-27,  2.402462143154953e-28,
 -1.004152415203437e-29,  8.588549829661269e-19, -3.627640509556948e-19,  8.190464921665280e-20, -1.256590487732922e-20,  1.458733501702999e-21, -1.361883396733384e-22,
  1.063475656989462e-23, -7.138608976534290e-25,  4.202819453473242e-26, -2.203997697039954e-27,  1.042133247519412e-28, -4.480700975912315e-30,  2.960718479506930e-19,
 -1.280086552336541e-19,  2.965683157955957e-20, -4.668823721942424e-21,  5.558450375854799e-22, -5.318380932685834e-23,  4.253099876002887e-24, -2.921486902566122e-25,
  1.758821946343104e-26, -9.424746015838684e-28,  4.550460355928857e-29, -1.996336125418566e-30,  8.980471151673599e-20, -3.933947892947529e-20,  9.247775334254418e-21,
 -1.477247967492902e-21,  1.784048873024255e-22, -1.730898498336005e-23,  1.402993733116141e-24, -9.764014413970014e-26,  5.953043742382802e-27, -3.229253911152553e-28,
  1.577723794048736e-29, -7.001184476061158e-31,  6.820594113478461e-02, -1.928765003521127e-04,  5.663026736584831e-07, -1.715771975304939e-09,  5.322048867179069e-12,
 -1.679006088070049e-14,  5.349981292184894e-17, -1.716663703962886e-19,  5.515101564500511e-22, -1.777239188282194e-24,  5.699590528653073e-27, -1.836509535370859e-29,
  6.184984518470150e-02, -2.147874255870233e-04,  9.020571619431924e-07, -3.974725283081898e-09,  1.738930773059459e-11, -7.457524725658504e-14,  3.133481734548874e-16,
 -1.293271307524526e-18,  5.254811860286478e-21, -2.106830095339430e-23,  8.345283449431760e-26, -3.271368849933241e-28,  5.086168472785719e-02, -2.424207043284471e-04,
  1.445321443567991e-06, -8.311292389187945e-09,  4.532724106073493e-11, -2.370874081486865e-13,  1.200014301352772e-15, -5.911808737277309e-18,  2.846043449279241e-20,
 -1.342874629419985e-22,  6.224388496723801e-25, -2.839380207348185e-27,  3.793310793021019e-02, -2.547645345340570e-04,  1.986650046487250e-06, -1.399510170467908e-08,
  9.160425755600436e-11, -5.684041605815576e-13,  3.380715944353239e-15, -1.941227987622963e-17,  1.081701855294531e-19, -5.872208903799573e-22,  3.115265824417421e-24,
 -1.618984636672683e-26,  2.566165091111390e-02, -2.395230481799412e-04,  2.319917275774650e-06, -1.955280753694298e-08,  1.510244633042809e-10, -1.093566273429314e-12,
  7.520463380386697e-15, -4.955425395795844e-17,  3.148794969452033e-19, -1.938814763819755e-21,  1.161165128886996e-23, -6.784321178634071e-26,  1.574994866893637e-02,
 -1.990000977802361e-04,  2.330292933239121e-06, -2.320098144221684e-08,  2.088713856933469e-10, -1.743580199472571e-12,  1.370478405098061e-14, -1.025021413577901e-16,
  7.350428937991838e-19, -5.082487271226604e-21,  3.403572613936101e-23, -2.215088306480010e-25,  8.772520606691970e-03, -1.459650259360481e-04,  2.036263389726149e-06,
 -2.372106416093081e-08,  2.464806291660372e-10, -2.350196551165617e-12,  2.093261016229285e-14, -1.762678718654600e-16,  1.415470634301975e-18, -1.090957603636746e-20,
  8.110745302172863e-23, -5.839274096824958e-25,  4.435905188780783e-03, -9.479213852090258e-05,  1.560694121897593e-06, -2.110172015250581e-08,  2.510955764605016e-10,
 -2.715160757995827e-12,  2.722015918618782e-14, -2.564344445067293e-16,  2.292079980547864e-18, -1.957797912720286e-20,  1.606931091209936e-22, -1.272921454434519e-24,
  2.037339248236626e-03, -5.471067020377561e-05,  1.055619296445292e-06, -1.645116003813481e-08,  2.227573205962409e-10, -2.715891947780788e-12,  3.048199231377201e-14,
 -3.196366724802510e-16,  3.164714919766596e-18, -2.981893003018579e-20,  2.690063536435136e-22, -2.334550499257362e-24,  8.504299614108965e-04, -2.817054048293600e-05,
  6.331244791004929e-07, -1.130513406370150e-08,  1.732777917929526e-10, -2.370705357730212e-12,  2.965660996250646e-14, -3.447090588541100e-16,  3.765618393580980e-18,
 -3.899140900623987e-20,  3.852117204602732e-22, -3.649634142610169e-24,  3.228889796523454e-04, -1.298623325415836e-05,  3.380864547069363e-07, -6.881260312635238e-09,
  1.188606446120023e-10, -1.817556000990724e-12,  2.524862509043657e-14, -3.241750380556582e-16,  3.894396319190087e-18, -4.417568910444216e-20,  4.765000171031366e-22,
 -4.914232485273255e-24,  1.116207177524170e-04, -5.377444495032800e-06,  1.613284413764712e-07, -3.725989928841674e-09,  7.225279935953421e-11, -1.230652624401962e-12,
  1.892470814694162e-14, -2.676144340128035e-16,  3.525695287063480e-18, -4.369706811287476e-20,  5.133114352380987e-22, -5.748503594119260e-24,  3.517745459082244e-05,
 -2.006563516379312e-06,  6.903098786176088e-08, -1.801879352634068e-09,  3.909585142149804e-11, -7.395360555891638e-13,  1.255532375206342e-14, -1.950567021064739e-16,
  2.811565496122557e-18, -3.798809638506202e-20,  4.849459875905793e-22, -5.885038541995639e-24,  1.012285735529728e-05, -6.768407036631711e-07,  2.657791319778968e-08,
 -7.812527298788754e-10,  1.891049703937163e-11, -3.962379360012272e-13,  7.409431155234654e-15, -1.261925433355766e-16,  1.986071079382449e-18, -2.919799696448991e-20,
  4.043147761278880e-22, -5.307497601238502e-24,  2.665165272795522e-06, -2.070613038779965e-07,  9.240236403580653e-09, -3.048760618450044e-10,  8.210841253594383e-12,
 -1.901382136802149e-13,  3.908116058042645e-15, -7.283081202640345e-17,  1.249360613383879e-18, -1.995192506815865e-20,  2.992160585824513e-22, -4.242359875923590e-24,
  6.435790436409763e-07, -5.765308548015792e-08,  2.911911046158891e-09, -1.075184352251785e-10,  3.214044910775259e-12, -8.208578258784829e-14,  1.851153619057984e-15,
 -3.768491050903737e-17,  7.035294031791580e-19, -1.218674903719439e-20,  1.976614105595298e-22, -3.022873714349443e-24,  1.429780225772864e-07, -1.466773663921166e-08,
  8.352545735349870e-10, -3.441714592106329e-11,  1.139417210277462e-12, -3.203446449578681e-14,  7.913198709282000e-16, -1.757143244175505e-17,  3.565060475816709e-19,
 -6.689927733220025e-21,  1.172082686156956e-22, -1.931173811297952e-24,  2.933424753516225e-08, -3.425070649570226e-09,  2.191035142461370e-10, -1.004880376868992e-11,
  3.676693566142400e-13, -1.135935387701552e-14,  3.068939048839673e-16, -7.423026181465465e-18,  1.634714907336021e-19, -3.319233989233099e-21,  6.274760126636603e-23,
 -1.112663674643772e-24,  5.584083570935442e-09, -7.379239411120807e-10,  5.284676420233398e-11, -2.690928652816282e-12,  1.085972633507847e-13, -3.680933721213359e-15,
  1.086099251016345e-16, -2.857875507347507e-18,  6.823339449050722e-20, -1.497479029997641e-21,  3.051373810427826e-23, -5.817504740981996e-25,  9.919720437994432e-10,
 -1.475937314305887e-10,  1.179407742903948e-11, -6.651321456241759e-13,  2.955008412597635e-14, -1.097085693271835e-15,  3.530390486557329e-17, -1.009339663449563e-18,
  2.609702087080002e-20, -6.183934011021676e-22,  1.356885277385696e-23, -2.778717919694970e-25,  1.656073387426951e-10, -2.760745021218586e-11,  2.453632170748607e-12,
 -1.528848629824028e-13,  7.462936915501123e-15, -3.029915956161349e-16,  1.061873007176772e-17, -3.294449350913341e-19,  9.213801442963389e-21, -2.354835145913900e-22,
  5.558353365176703e-24, -1.221485394688938e-25,  2.620771402440411e-11, -4.871892533990996e-12,  4.800353187796141e-13, -3.296659749789367e-14,  1.764612253004920e-15,
 -7.821267092643289e-17,  2.980842488036981e-18, -1.002238297229436e-19,  3.028333781547150e-21, -8.338410818351369e-23,  2.115014109856692e-24, -4.982537652517114e-26,
  3.972706007488140e-12, -8.196782037118340e-13,  8.924639782063093e-14, -6.737927024832414e-15,  3.946503857993054e-16, -1.906155978461497e-17,  7.887566890455541e-19,
 -2.869896484188431e-20,  9.356096203420057e-22, -2.771968310192093e-23,  7.546523234150388e-25, -1.903628642831691e-26,  5.841569088242854e-13, -1.331412421004576e-13,
  1.596418126850439e-14, -1.321368581813515e-15,  8.449162128445816e-17, -4.438106621493124e-18,  1.990293641681395e-19, -7.823692034862859e-21,  2.747688441251854e-22,
 -8.746735528112820e-24,  2.552316522105244e-25, -6.884769478754522e-27,  8.458980907142312e-14, -2.119255183912385e-14,  2.788106017163433e-15, -2.522384510966780e-16,
  1.756170911996101e-17, -1.000870304135442e-18,  4.854156620121508e-20, -2.057462239016464e-21,  7.770002971541113e-23, -2.652975503922486e-24,  8.283878127924096e-26,
 -2.385686893983775e-27,  1.228068946865496e-14, -3.364268091069766e-15,  4.836736717240667e-16, -4.766374958574450e-17,  3.602410826834336e-18, -2.221472094054502e-19,
  1.162245868228162e-20, -5.299291028263970e-22,  2.147221841089161e-23, -7.847030007371949e-25,  2.616605177983838e-26, -8.029543545965924e-28,  1.825218097035367e-15,
 -5.436468315151600e-16,  8.502348738307215e-17, -9.090467065034619e-18,  7.431720970250583e-19, -4.942523573221412e-20,  2.780995024604101e-21, -1.360106167801205e-22,
  5.896798063860519e-24, -2.300528306449364e-25,  8.171521028654983e-27, -2.665458869638476e-28,  2.844247917265015e-16, -9.153679860324336e-17,  1.549244544999254e-17,
 -1.788797939283996e-18,  1.575116603024520e-19, -1.125283536169018e-20,  6.784037589428998e-22, -3.546321426364561e-23,  1.639609127757349e-24, -6.806571700014908e-26,
  2.567384402288898e-27, -8.874881834490991e-29,  4.771927621192765e-17, -1.647995061446392e-17,  3.000387571628346e-18, -3.720764178169324e-19,  3.510875834146332e-20,
 -2.681445004408219e-21,  1.724218270676331e-22, -9.592084050330016e-24,  4.709623818202018e-25, -2.072105087569342e-26,  8.267655316831395e-28, -3.017375784189554e-29,
  8.865304892880195e-18, -3.260459795340919e-18,  6.341391894496395e-19, -8.391567166351069e-20,  8.433514519805055e-21, -6.846209711766662e-22,  4.669490847062913e-23,
 -2.749922955358245e-24,  1.426570097441767e-25, -6.619482134071759e-27,  2.780624308922720e-28, -1.066520059085619e-29,  1.874504927358461e-18, -7.280271106908260e-19,
  1.500609448475365e-19, -2.102978115246564e-20,  2.234815925455727e-21, -1.914996230252284e-22,  1.376266349124209e-23, -8.525385304651714e-25,  4.644267345817802e-26,
 -2.259317037432931e-27,  9.934638190029893e-29, -3.982423317859258e-30,  4.612709405152788e-19, -1.874608274490611e-19,  4.057803633882871e-20, -5.969690914785517e-21,
  6.651692648502606e-22, -5.967810985249601e-23,  4.484029431129752e-24, -2.899790563612925e-25,  1.646799862646580e-26, -8.340210230135359e-28,  3.812901565584429e-29,
 -1.586953636050285e-30,  1.330569479445356e-19, -5.602637581894743e-20,  1.260669479232012e-20, -1.927620844368332e-21,  2.230376833992855e-22, -2.075696188761329e-23,
  1.615927586616245e-24, -1.081500875885675e-25,  6.349215571970674e-27, -3.320488152044207e-28,  1.565918194368722e-29, -6.715702901640742e-31,  4.338202213195047e-20,
 -1.872876589736251e-20,  4.331954865003726e-21, -6.808594810943883e-22,  8.093025132024558e-23, -7.731510500007118e-24,  6.173622025651593e-25, -4.234574359146103e-26,
  2.545777364436446e-27, -1.362327786692603e-28,  6.569020914769733e-30, -2.878279871410108e-31,  1.274046007958347e-20, -5.578004983480706e-21,  1.310458967888386e-21,
 -2.092055899887001e-22,  2.525015392991319e-23, -2.448340275661516e-24,  1.983375383977445e-25, -1.379535567598895e-26,  8.406304791949854e-28, -4.557597528451520e-29,
  2.225555662245836e-30, -9.870954955457329e-32,  6.744336758806528e-02, -1.884270134959802e-04,  5.462134668084652e-07, -1.633237438541700e-09,  4.998708326697818e-12,
 -1.556180859350014e-14,  4.893091746995022e-17, -1.549992669056954e-19,  4.914457708232338e-22, -1.564625412639043e-24,  4.949893862905799e-27, -1.578327332652948e-29,
  6.100483284913949e-02, -2.077571359728203e-04,  8.559819031710733e-07, -3.708031771775412e-09,  1.597016851747070e-11, -6.747110731346591e-14,  2.793811462062925e-16,
 -1.136635530859323e-18,  4.553126954454783e-21, -1.800100260366353e-23,  7.031425406255642e-26, -2.718818481850789e-28,  4.991451233843090e-02, -2.312450962834445e-04,
  1.349785791768229e-06, -7.622480183334600e-09,  4.086060186773428e-11, -2.101748207184735e-13,  1.046540062528025e-15, -5.073853175630601e-18,  2.404570065723318e-20,
 -1.117182362045877e-22,  5.100069337538698e-25, -2.291830873946997e-27,  3.694480663703449e-02, -2.395190189085921e-04,  1.827141479613330e-06, -1.261614780564890e-08,
  8.100546073888339e-11, -4.934170672981949e-13,  2.882618035494052e-15, -1.626634989078501e-17,  8.911162905624912e-20, -4.757634563440479e-22,  2.483009782937817e-24,
 -1.269795644849259e-26,  2.473924726081924e-02, -2.218627668505790e-04,  2.099090705071682e-06, -1.730203211084896e-08,  1.308512820149680e-10, -9.286482039511886e-13,
  6.264124247940866e-15, -4.051075235673307e-17,  2.527701821908723e-19, -1.528953935858751e-21,  8.998897526764636e-24, -5.168685093432537e-26,  1.498954654320810e-02,
 -1.814171271993110e-04,  2.070837379317273e-06, -2.012107114258163e-08,  1.770695068308837e-10, -1.446608307402540e-12,  1.113828536189401e-14, -8.166346488153365e-17,
  5.743996461699647e-19, -3.897650202223714e-21,  2.562572257711568e-23, -1.637999398086094e-25,  8.219528068736597e-03, -1.307498900971429e-04,  1.773805676693607e-06,
 -2.012769984124080e-08,  2.041257391093704e-10, -1.902263263805127e-12,  1.657638714724116e-14, -1.366775810975289e-16,  1.075420792879569e-18, -8.126242093296152e-21,
  5.926036404329690e-23, -4.186740328924741e-25,  4.080195265839072e-03, -8.325507809361151e-05,  1.329895298483342e-06, -1.748542163049626e-08,  2.027838302393279e-10,
 -2.140360206876804e-12,  2.096913888491232e-14, -1.932260696134928e-16,  1.690636700080341e-18, -1.414494354352086e-20,  1.137856633495076e-22, -8.838217027284406e-25,
  1.834216591994997e-03, -4.699866574829476e-05,  8.779185009227776e-07, -1.328468617109494e-08,  1.750854121160365e-10, -2.081200780372502e-12,  2.280229647510066e-14,
 -2.336502852980125e-16,  2.262476868279277e-18, -2.086373911722413e-20,  1.843243375910486e-22, -1.567408195586780e-24,  7.470806864847780e-04, -2.360442709921838e-05,
  5.126497312320406e-07, -8.876382311883221e-09,  1.322647024781820e-10, -1.762350463538641e-12,  2.150024393312200e-14, -2.439825265068525e-16,  2.604491023905354e-18,
 -2.637386432032841e-20,  2.549858219561858e-22, -2.365581053467936e-24,  2.758727061565685e-04, -1.058207514942275e-05,  2.658211549095228e-07, -5.240225150247677e-09,
  8.790095576353830e-11, -1.307777378019280e-12,  1.770129963260953e-14, -2.217060491771819e-16,  2.600717449084335e-18, -2.883062190535348e-20,  3.041353216371335e-22,
 -3.069541057078124e-24,  9.243448602667637e-05, -4.247733758679779e-06,  1.228140911784796e-07, -2.744507376398026e-09,  5.163492651987153e-11, -8.549523796723540e-13,
  1.280015087608232e-14, -1.764460142873539e-16,  2.268364957953298e-18, -2.745815179249999e-20,  3.152729288175071e-22, -3.453397939368199e-24,  2.813240784922514e-05,
 -1.531198005674714e-06,  5.072191091446374e-08, -1.279988348799762e-09,  2.692364965209111e-11, -4.947220584513806e-13,  8.171744145035056e-15, -1.236780800689416e-16,
  1.738585010087998e-18, -2.293062451251757e-20,  2.859804928727818e-22, -3.392997260019098e-24,  7.787905893099357e-06, -4.971188625795245e-07,  1.878507197622708e-08,
 -5.335045219128912e-10,  1.251116410830854e-11, -2.545006538632053e-13,  4.627639873177162e-15, -7.674118235527209e-17,  1.177330127786828e-18, -1.688833419031423e-20,
  2.283776380842074e-22, -2.929919870857149e-24,  1.964403056349394e-06, -1.457991547241164e-07,  6.259265229066100e-09, -1.994483584213816e-10,  5.201650311420628e-12,
 -1.168862114976164e-13,  2.335156637232787e-15, -4.235548933010094e-17,  7.079958154111389e-19, -1.102837076765982e-20,  1.614649987823607e-22, -2.236727016443006e-24,
  4.524733563705170e-07, -3.875516098309705e-08,  1.883000371552160e-09, -6.713123188235395e-11,  1.942743837342544e-12, -4.813290653248800e-14,  1.054739109931998e-15,
 -2.089284329960010e-17,  3.799721372327393e-19, -6.418633313679098e-21,  1.016144995734609e-22, -1.518060186185024e-24,  9.543631914610182e-08, -9.370535210283796e-09,
  5.134257916018456e-10, -2.042675299730449e-11,  6.546165478615380e-13, -1.785153710660387e-14,  4.284289061383205e-16, -9.255582824849837e-18,  1.829155828334392e-19,
 -3.346918098533369e-21,  5.722994895989559e-23, -9.210700590889735e-25,  1.849722656316590e-08, -2.069557353297571e-09,  1.274430115925347e-10, -5.644694432600821e-12,
  1.999440193030298e-13, -5.992126445466497e-15,  1.572883476390920e-16, -3.701421174939360e-18,  7.940117261343015e-20, -1.572084866700763e-21,  2.900645352241362e-23,
 -5.024485109910869e-25,  3.308763731461650e-09, -4.195698570409416e-10,  2.894541438789856e-11, -1.424026560555642e-12,  5.565418200852549e-14, -1.830294317939996e-15,
  5.248129727312445e-17, -1.343817325579771e-18,  3.125865178652297e-20, -6.690606691758448e-22,  1.330880437668225e-23, -2.479095045613882e-25,  5.492268351860773e-10,
 -7.853993213690052e-11,  6.051670251599932e-12, -3.299702258315572e-13,  1.420448486277349e-14, -5.119067688097075e-16,  1.601481942944892e-17, -4.457193651648133e-19,
  1.123171444164498e-20, -2.596577740677563e-22,  5.563730034669274e-24, -1.113596412752749e-25,  8.517185034936200e-11, -1.367097670618874e-11,  1.173016237701807e-12,
 -7.073369039894302e-14,  3.348216705130172e-15, -1.320432906006871e-16,  4.501706727031393e-18, -1.360388674005794e-19,  3.710116873137243e-21, -9.255913305082798e-23,
  2.134587459240351e-24, -4.587075210594672e-26,  1.244298210543396e-11, -2.231706457882075e-12,  2.126095131465612e-13, -1.414746078757729e-14,  7.351045304136074e-16,
 -3.167840447574900e-17,  1.175477822312485e-18, -3.852724560232811e-20,  1.136049967720620e-21, -3.055637807283718e-23,  7.577845296642070e-25, -1.746870989094040e-26,
  1.730215772357569e-12, -3.452186074462964e-13,  3.640661692319673e-14, -2.667223101519470e-15,  1.518490644687336e-16, -7.139399455547815e-18,  2.879477310081722e-19,
 -1.022367711673890e-20,  3.255805194644508e-22, -9.431597482326828e-24,  2.512765752497408e-25, -6.207955604589177e-27,  2.318922039543065e-13, -5.123979671827233e-14,
  5.963096779055517e-15, -4.798067156002923e-16,  2.986871880697774e-17, -1.529468469243093e-18,  6.694523237326191e-20, -2.571240168202823e-21,  8.831856091222434e-23,
 -2.752150862228444e-24,  7.867901245595188e-26, -2.080895448954240e-27,  3.041711906157572e-14, -7.408492956257778e-15,  9.482042087051550e-16, -8.356459515856466e-17,
  5.674908210181690e-18, -3.158413527069736e-19,  1.497531250588711e-20, -6.211475941946341e-22,  2.297619782991045e-23, -7.690340601960757e-25,  2.355781101579238e-26,
 -6.660744488065247e-28,  3.977197089931502e-15, -1.062430936016699e-15,  1.489859838701011e-16, -1.433597956350531e-17,  1.059156941077956e-18, -6.391316473523895e-20,
  3.275291513219715e-21, -1.464060832636930e-22,  5.820556164725767e-24, -2.088666590480351e-25,  6.843598675942811e-27, -2.064977271147586e-28,  5.298239170270399e-16,
 -1.543779551323204e-16,  2.361781667461739e-17, -2.472184039096981e-18,  1.980522601418432e-19, -1.291886448548214e-20,  7.135534331304694e-22, -3.428388720154023e-23,
  1.461304848978291e-24, -5.608593744207775e-26,  1.961127916945983e-27, -6.301138506821450e-29,  7.375647549150651e-17, -2.329909171390473e-17,  3.869372483454878e-18,
 -4.386598704645068e-19,  3.795338446076852e-20, -2.666213495205668e-21,  1.581704389408206e-22, -8.141604633196037e-24,  3.708852459448188e-25, -1.517924736836192e-26,
  5.647740077774132e-28, -1.926829785721324e-29,  1.104212646376279e-17, -3.755885278514346e-18,  6.731661123449537e-19, -8.221547054181129e-20,  7.644799092450956e-21,
 -5.757161562577529e-22,  3.652350028595697e-23, -2.005733047550522e-24,  9.726408278865514e-26, -4.228606816117575e-27,  1.667969163841990e-28, -6.020797805165954e-30,
  1.834038103441991e-18, -6.665904019801650e-19,  1.280523256248751e-19, -1.674133390265592e-20,  1.662977271895730e-21, -1.334925321371144e-22,  9.007426711244302e-24,
 -5.250055772373980e-25,  2.696667271202835e-26, -1.239420022114249e-27,  5.158904002675721e-29, -1.961394350830867e-30,  3.487271310228670e-19, -1.342774847816660e-19,
  2.742485764766156e-20, -3.808929498858508e-21,  4.012640171593773e-22, -3.409718059641998e-23,  2.430844166981202e-24, -1.494206198354484e-25,  8.079559699126205e-27,
 -3.902541290301973e-28,  1.704283897010540e-29, -6.786992084254634e-31,  7.798309678436663e-20, -3.151081572810090e-20,  6.778768054288415e-21, -9.911907442380875e-22,
  1.097903161349141e-22, -9.794126790827874e-24,  7.318664602181418e-25, -4.707981709690652e-26,  2.660127548247501e-27, -1.340655371297827e-28,  6.100359407297775e-30,
 -2.527586718606898e-31,  2.076419574300874e-20, -8.713900212843186e-21,  1.953577342696128e-21, -2.976279844392974e-22,  3.431602495764759e-23, -3.182739702418951e-24,
  2.469628285069674e-25, -1.647639014625287e-26,  9.643447620309340e-28, -5.028527882301017e-29,  2.364733527084626e-30, -1.011410457446340e-31,  6.379559125458071e-21,
 -2.749776258136155e-21,  6.349031819752953e-22, -9.961365325923026e-23,  1.182029450730236e-23, -1.127354671941720e-24,  8.987503054207620e-26, -6.155105840749415e-27,
  3.694845950295483e-28, -1.974378083243287e-29,  9.507009462647303e-31, -4.160000871644115e-32,  1.809909377808895e-21, -7.919550623741300e-22,  1.859366961420702e-22,
 -2.966422432667704e-23,  3.578045784183565e-24, -3.467223403744305e-25,  2.807047942771853e-26, -1.951279667368807e-27,  1.188338744098265e-28, -6.439116269881532e-30,
  3.142609446870695e-31, -1.393091790922826e-32,  6.669827671233651e-02, -1.841343647565023e-04,  5.270844254795468e-07, -1.555685633048018e-09,  4.698873004835035e-12,
 -1.443781997236402e-14,  4.480290272399303e-17, -1.401373310686354e-19,  4.385219585424617e-22, -1.379849364246016e-24,  4.304812748834680e-27, -1.359865695817639e-29,
  6.018722420553436e-02, -2.010830226283712e-04,  8.129752783931134e-07, -3.462950671695785e-09,  1.468530257365336e-11, -6.113198517743674e-14,  2.495014695597391e-16,
 -1.000783768333597e-18,  3.952962726210641e-21, -1.541369062297579e-23,  5.938143520123206e-26, -2.265309430701815e-28,  4.901056449763590e-02, -2.208018857474492e-04,
  1.262104224234600e-06, -7.001020621537030e-09,  3.689720166309695e-11, -1.866793047908832e-13,  9.146669975428496e-16, -4.364992192027190e-18,  2.036799410515706e-20,
 -9.319920285206728e-23,  4.191186078828064e-25, -1.855682847090472e-27,  3.601503614498294e-02, -2.254861549993896e-04,  1.683210341496809e-06, -1.139539748523581e-08,
  7.179365621269482e-11, -4.293926669222091e-13,  2.464638006706848e-15, -1.367068991640141e-17,  7.364505126768622e-20, -3.867720029266278e-22,  1.986212387273280e-24,
 -9.997130303540270e-27,  2.388411514073202e-02, -2.058663075283311e-04,  1.903440579107434e-06, -1.534919673916071e-08,  1.136943460208278e-10, -7.910552989534650e-13,
  5.235260215695924e-15, -3.323752702025240e-17,  2.036942311227203e-19, -1.210659713686752e-21,  7.004048565037354e-24, -3.955576862600458e-26,  1.429554744109642e-02,
 -1.657701848683694e-04,  1.845473447133515e-06, -1.750563370002485e-08,  1.506355253142470e-10, -1.204774266119461e-12,  9.089278138997842e-15, -6.534317155735318e-17,
  4.509210691078194e-19, -3.003426038537770e-21,  1.939114455038839e-23, -1.217636564520136e-25,  7.723454435486753e-03, -1.174728092672800e-04,  1.550680480376920e-06,
 -1.714566904483616e-08,  1.697678292099347e-10, -1.546719722292299e-12,  1.319028850274074e-14, -1.065210825736830e-16,  8.214488952927412e-19, -6.086974351092981e-21,
  4.355104263938720e-23, -3.020095776917058e-25,  3.767198179060896e-03, -7.340314314512001e-05,  1.138208648541829e-06, -1.455772948045819e-08,  1.646006892813156e-10,
 -1.696352387138355e-12,  1.624551006245480e-14, -1.464655488912483e-16,  1.254765615145098e-18, -1.028566439335496e-20,  8.111045652770149e-23, -6.179077625789738e-25,
  1.659322281497652e-03, -4.056834016403462e-05,  7.340274489919892e-07, -1.078866308418324e-08,  1.384435400194357e-10, -1.604917330897863e-12,  1.717017778478306e-14,
 -1.719702997303732e-16,  1.629000703042306e-18, -1.470565632121983e-20,  1.272608124154242e-22, -1.060591175657794e-24,  6.602382427932198e-04, -1.989582710435172e-05,
  4.177522588652323e-07, -7.016250686367400e-09,  1.016695902607817e-10, -1.319716550862807e-12,  1.570574725788792e-14, -1.740486850860523e-16,  1.816025404085831e-18,
 -1.798838224902815e-20,  1.702323660889032e-22, -1.546775904518152e-24,  2.374305970094595e-04, -8.684975345431453e-06,  2.105831971219487e-07, -4.021924699725591e-09,
  6.553570930567861e-11, -9.489164088287825e-13,  1.251794498480694e-14, -1.529825860940207e-16,  1.752721593971295e-18, -1.899268816264311e-20,  1.959849677881013e-22,
 -1.936104861292277e-24,  7.721823548088699e-05, -3.384111546417987e-06,  9.432249649697794e-08, -2.039992629018655e-09,  3.724654564621899e-11, -5.996653934057116e-13,
  8.743057069464843e-15, -1.175094665947909e-16,  1.474453302392483e-18, -1.743519086436229e-20,  1.957090065776248e-22, -2.097174389540360e-24,  2.273131513613239e-05,
 -1.180227090775639e-06,  3.765175728987536e-08, -9.187828863471448e-10,  1.873944487914787e-11, -3.345598151871828e-13,  5.377739623793222e-15, -7.930604427878575e-17,
  1.087438477688940e-18, -1.400298088805670e-20,  1.706424047455438e-22, -1.979668916509743e-24,  6.063784825139121e-06, -3.693944420633667e-07,  1.343383983505444e-08,
 -3.686721636580806e-10,  8.377564617312933e-12, -1.654695755085876e-13,  2.926176620740648e-15, -4.725600384602063e-17,  7.068053689394390e-19, -9.894180774103153e-21,
  1.306786648024180e-22, -1.638676883941837e-24,  1.467982484503072e-06, -1.040434187092899e-07,  4.296961850307525e-09, -1.322401633926592e-10,  3.340123915272779e-12,
 -7.284041040314942e-14,  1.414582884685533e-15, -2.497560545740909e-17,  4.068475146662678e-19, -6.182159210624404e-21,  8.837225313345326e-23, -1.196193887909228e-24,
  3.231384614662510e-07, -2.645015289128333e-08,  1.236127082552013e-09, -4.254987869228887e-11,  1.192125634089782e-12, -2.865357579835178e-14,  6.101462290247351e-16,
 -1.176085811646851e-17,  2.083808196969253e-19, -3.432874890164026e-21,  5.304849207094326e-23, -7.742167619151086e-25,  6.483624704974301e-08, -6.089455651448971e-09,
  3.209606775665044e-10, -1.232796119260508e-11,  3.824147563974019e-13, -1.011499682232777e-14,  2.358483110849223e-16, -4.957088150252663e-18,  9.542484846508482e-20,
 -1.702538757461175e-21,  2.841305124328552e-23, -4.466771118865555e-25,  1.189534661334459e-08, -1.274505377611124e-09,  7.552572267128932e-11, -3.229897171032352e-12,
  1.107438571492910e-13, -3.219012098757764e-15,  8.208859540225372e-17, -1.879332540421093e-18,  3.926745149782353e-20, -7.580720721685388e-22,  1.365102405294935e-23,
 -2.309773283913402e-25,  2.003579635502633e-09, -2.436154505426661e-10,  1.618296743070154e-11, -7.689834391347529e-13,  2.909760327047582e-14, -9.282844520360267e-16,
  2.586222833892018e-17, -6.443189610468247e-19,  1.459991525960973e-20, -3.047362199732996e-22,  5.916790615724509e-24, -1.076724227504988e-25,  3.113931087229292e-10,
 -4.276238350529328e-11,  3.175396957796968e-12, -1.673300070688232e-13,  6.977174007259076e-15, -2.440088665634832e-16,  7.419555738634101e-18, -2.009763594413237e-19,
  4.934815813348443e-21, -1.112817045021468e-22,  2.328066646844034e-24, -4.553456166279779e-26,  4.494277047312908e-11, -6.939487001051352e-12,  5.744740943598658e-13,
 -3.350698352159479e-14,  1.537361837861600e-15, -5.887038794457730e-17,  1.951776509119530e-18, -5.743250518054890e-20,  1.526957532109315e-21, -3.717511037330926e-23,
  8.374242328996164e-25, -1.759305713039365e-26,  6.072133276251230e-12, -1.049713013915470e-12,  9.661847373610928e-14, -6.225606343882490e-15,  3.138455051215472e-16,
 -1.314350230734360e-17,  4.746413738030497e-19, -1.515896955435388e-20,  4.360502761582776e-22, -1.145291248113557e-23,  2.776075976733683e-25, -6.260196861624225e-27,
  7.757129115828965e-13, -1.495111469531789e-13,  1.525921843721533e-14, -1.084035290545828e-15,  5.995000833585839e-17, -2.742184721263652e-18,  1.077436003182079e-19,
 -3.731190027248571e-21,  1.160184574517297e-22, -3.284761605720531e-24,  8.560607881006818e-26, -2.070599226018144e-27,  9.487171547404288e-14, -2.030078262262541e-14,
  2.290902423332493e-15, -1.790478478215140e-16,  1.084347013425494e-17, -5.409396691219201e-19,  2.309547278111003e-20, -8.662347530162661e-22,  2.908512277136561e-23,
 -8.867840356395188e-25,  2.482552147914255e-26, -6.434741418116122e-28,  1.127983329504769e-14, -2.667849751079310e-15,  3.318570543985552e-16, -2.846490473843511e-17,
  1.884010399337019e-18, -1.023238960843256e-19,  4.739827363533119e-21, -1.922689196877019e-22,  6.961927801315089e-24, -2.283017329027804e-25,  6.857351966420912e-27,
 -1.902531478553447e-28,  1.328390499662561e-15, -3.456216227261422e-16,  4.722623980087455e-17, -4.433123072144209e-18,  3.198917438730748e-19, -1.887450784693912e-20,
  9.467192054850239e-22, -4.145938776205751e-23,  1.616198020264218e-24, -5.691285259052374e-26,  1.831286320846816e-27, -5.430310037794380e-29,  1.584915036092020e-16,
 -4.512502796546107e-17,  6.746150375908453e-18, -6.906853231883103e-19,  5.417459874218286e-20, -3.463159317194151e-21,  1.876268366414566e-22, -8.849906984217640e-24,
  3.705981292469708e-25, -1.398427219894111e-26,  4.810649169447850e-28, -1.521627696880223e-29,  1.967662608284214e-17, -6.094440454058010e-18,  9.921507444231438e-19,
 -1.103335158064232e-19,  9.371848185337723e-21, -6.468639735692591e-22,  3.773260986581931e-23, -1.911104892878139e-24,  8.572081682163138e-26, -3.456523667967803e-27,
  1.267825754333152e-28, -4.266495959811875e-30,  2.621520951226309e-18, -8.773853588537828e-19,  1.546628024344817e-19, -1.858726059823086e-20,  1.701775023511921e-21,
 -1.262698269851141e-22,  7.897496376217701e-24, -4.278313794153515e-25,  2.047746390370911e-26, -8.791692035676856e-28,  3.426324667858785e-29, -1.222562036507175e-30,
  3.878502776393067e-19, -1.391950110392319e-19,  2.638901438515169e-20, -3.405933225063428e-21,  3.341549870919207e-22, -2.650635534810521e-23,  1.768221883902746e-24,
 -1.019402139345787e-25,  5.181397735679312e-27, -2.357534133806648e-28,  9.718267548171274e-30, -3.660660382323877e-31,  6.602056403525010e-20, -2.518681158077746e-20,
  5.093917791498089e-21, -7.006968187310728e-22,  7.313403954283245e-23, -6.159212969027523e-24,  4.353474508941452e-25, -2.654063229365499e-26,  1.423814520726612e-27,
 -6.825184603591675e-29,  2.958961419420898e-30, -1.170132149725089e-31,  1.335085036582504e-20, -5.361366153590302e-21,  1.145703651103882e-21, -1.664279105014058e-22,
  1.831766986909547e-23, -1.624092709596890e-24,  1.206476237878197e-25, -7.717276850240342e-27,  4.336815549123008e-28, -2.174289489855188e-29,  9.844090119326991e-31,
 -4.059152772904616e-32,  3.265790135097220e-21, -1.365556145490910e-21,  3.049375664066406e-22, -4.627581178778157e-23,  5.315279727829437e-24, -4.911754355454436e-25,
  3.797804807487436e-26, -2.525148812459048e-27,  1.473118195783209e-28, -7.657389899380969e-30,  3.590117539596196e-31, -1.531064246328732e-32,  9.417978098991947e-22,
 -4.052442104082027e-22,  9.339057537810653e-23, -1.462493717220048e-23,  1.732221604457569e-24, -1.649153031349681e-25,  1.312475225209140e-26, -8.973577123550022e-28,
  5.378115307094557e-29, -2.869409950987649e-30,  1.379617035902612e-31, -6.028162938517046e-33,  2.574837101160982e-22, -1.125972270316472e-22,  2.641770399261905e-23,
 -4.211762794891175e-24,  5.076710275629599e-25, -4.916211154951334e-26,  3.977572003929023e-27, -2.763215233096071e-28,  1.681782480742139e-29, -9.107463539157765e-31,
  4.442323902476838e-32, -1.968138645863110e-33,  6.597005614791410e-02, -1.799911057420206e-04,  5.088579463998781e-07, -1.482756599336367e-09,  4.420559475134693e-12,
 -1.340809549431230e-14,  4.106827787450132e-17, -1.268673244667747e-19,  3.918078473229967e-22, -1.219056958855862e-24,  3.748267925313146e-27, -1.174975265436759e-29,
  5.939564205447802e-02, -1.947415384842876e-04,  7.727903407364907e-07, -3.237450874936006e-09,  1.352034520061783e-11, -5.546641614193512e-14,  2.231701913395586e-16,
 -8.827276189291594e-19,  3.438528139041448e-21, -1.322626897282399e-23,  5.026127255875245e-26, -1.892131513398480e-28,  4.814703234860276e-02, -2.110313411090981e-04,
  1.181514652911249e-06, -6.439381626192321e-09,  3.337360373476131e-11, -1.661232718896860e-13,  8.010898592636232e-16, -3.763816641155756e-18,  1.729590660740624e-20,
 -7.795920251890247e-23,  3.454178983902159e-25, -1.507131521695649e-27,  3.513918357403884e-02, -2.125485558958865e-04,  1.553084429723557e-06, -1.031231343804153e-08,
  6.376763448474202e-11, -3.745807439997028e-13,  2.112862997439344e-15, -1.152231576557291e-17,  6.105136396730542e-20, -3.154652229054419e-22,  1.594385226080420e-24,
 -7.899901140894524e-27,  2.308998054830359e-02, -1.913457790466172e-04,  1.729664058934468e-06, -1.365013293847162e-08,  9.905796230664969e-11, -6.758787237359661e-13,
  4.389679040371858e-15, -2.736580852702819e-17,  1.647605204024699e-19, -9.624262311290554e-22,  5.474188734578410e-24, -3.040465228486226e-26,  1.366071937166189e-02,
 -1.518074520720638e-04,  1.649108463479875e-06, -1.527697071965000e-08,  1.285812899820911e-10, -1.007051168011427e-12,  7.446436982778248e-15, -5.250385258170544e-17,
  3.555583002251282e-19, -2.325175249097987e-21,  1.474525900623841e-23, -9.097804399676653e-26,  7.277133241352629e-03, -1.058464247809551e-04,  1.360262396593852e-06,
 -1.466062191729693e-08,  1.417720480062808e-10, -1.263164592674175e-12,  1.054501913615577e-14, -8.342896860782693e-17,  6.307167023789435e-19, -4.584251903910648e-21,
  3.218751279429837e-23, -2.191368517743450e-25,  3.490750529900062e-03, -6.495392101362085e-05,  9.782629669128590e-07, -1.217566758265324e-08,  1.342624547533267e-10,
 -1.351456341830188e-12,  1.265511791742247e-14, -1.116609768878257e-16,  9.368738318932648e-19, -7.526175723603722e-21,  5.819384633413023e-23, -4.348999713974216e-25,
  1.508023541513709e-03, -3.517862148419663e-05,  6.168631220310580e-07, -8.809500422792216e-09,  1.101044954141097e-10, -1.245180796008335e-12,  1.301172387638851e-14,
 -1.274148154180066e-16,  1.180992176348465e-18, -1.043924536943094e-20,  8.851116901127668e-23, -7.231024136208000e-25,  5.868422899992021e-04, -1.686481561957772e-05,
  3.425086006565317e-07, -5.581757622583631e-09,  7.868145596395127e-11, -9.952467038655923e-13,  1.155726163136052e-14, -1.251054723754754e-16,  1.276206002197198e-18,
 -1.236832992155984e-20,  1.145947586678288e-22, -1.020011038668230e-24,  2.057777498837748e-04, -7.176879536057796e-06,  1.680343982512148e-07, -3.110206535847648e-09,
  4.924498184970781e-11, -6.941315726997305e-13,  8.926756545912143e-15, -1.064745570605882e-16,  1.191716360571423e-18, -1.262567497407395e-20,  1.274691670465388e-22,
 -1.232812591627348e-24,  6.504909771266395e-05, -2.718162769099174e-06,  7.305656389667662e-08, -1.529623113663196e-09,  2.711033675447466e-11, -4.245136832843209e-13,
  6.028797272953788e-15, -7.902253258374160e-17,  9.679633625329214e-19, -1.118355199664468e-20,  1.227484219651217e-22, -1.287011610227332e-24,  1.854958601944485e-05,
 -9.184839330977365e-07,  2.822535070418580e-08, -6.661585495434457e-10,  1.317754429379516e-11, -2.286313141604773e-13,  3.577048170675709e-15, -5.140981783718584e-17,
  6.877356068214662e-19, -8.647901184058889e-21,  1.029903677293149e-22, -1.168504050201617e-24,  4.776043504744763e-06, -2.775700732363870e-07,  9.716043259893382e-09,
 -2.576983093587944e-10,  5.675211971808012e-12, -1.088598065941663e-13,  1.872560374487222e-15, -2.945446264834834e-17,  4.295710556697353e-19, -5.869092994111841e-21,
  7.572076780952817e-23, -9.282131316592402e-25,  1.111660357389163e-06, -7.520655254110837e-08,  2.988041062991869e-09, -8.882174306821005e-11,  2.172982711227748e-12,
 -4.599464394760593e-14,  8.684018196826486e-16, -1.492640950620491e-17,  2.369827429406636e-19, -3.513190755187426e-21,  4.903793605652628e-23, -6.486524081861650e-25,
  2.342883406889592e-07, -1.831816199316280e-08,  8.233622830897029e-10, -2.736454763905489e-11,  7.422736943904454e-13, -1.730925582279405e-14,  3.581922796821083e-16,
 -6.719010791410981e-18,  1.159897460797311e-19, -1.863627188879443e-21,  2.811280568253152e-23, -4.008445705064235e-25,  4.480570565904768e-08, -4.023083624770883e-09,
  2.039418451460432e-10, -7.561817101625814e-12,  2.270444853930454e-13, -5.824811371644195e-15,  1.319520625246394e-16, -2.698269909039920e-18,  5.059596336428984e-20,
 -8.802387240996182e-22,  1.433743176601026e-23, -2.201709578317304e-25,  7.797118122352832e-09, -7.994892432852170e-10,  4.557718866679660e-11, -1.881620024373881e-12,
  6.244166443390294e-14, -1.760239388071560e-15,  4.360631880844848e-17, -9.711745039729564e-19,  1.976415981168001e-20, -3.720214038870458e-22,  6.537965987988425e-24,
 -1.080532617357243e-25,  1.239158753767184e-09, -1.443672576823773e-10,  9.230382743400339e-12, -4.235224864743615e-13,  1.551264567601618e-14, -4.799961442767543e-16,
  1.299160842021856e-17, -3.148792001714211e-19,  6.949678920823593e-21, -1.414400292334360e-22,  2.680283345878697e-24, -4.764551947507856e-26,  1.806920652558907e-10,
 -2.380963423771614e-11,  1.702992922334053e-12, -8.669558448276489e-14,  3.500451142751205e-15, -1.187678129635895e-16,  3.509253185646615e-18, -9.249579950355140e-20,
  2.212632204954469e-21, -4.866140716285731e-23,  9.937843674428897e-25, -1.899124678112494e-26,  2.432019049872345e-11, -3.609174424011073e-12,  2.880815895449931e-13,
 -1.624459153498156e-14,  7.221468479759087e-16, -2.684176790328763e-17,  8.651281822421715e-19, -2.478142218926387e-20,  6.421338286022930e-22, -1.525236151782470e-23,
  3.355266925217821e-25, -6.889679816648494e-27,  3.044519247912622e-12, -5.068014819237715e-13,  4.503520583903063e-14, -2.808272186648925e-15,  1.372824886056688e-16,
 -5.584648699712650e-18,  1.961903041599359e-19, -6.103383017484274e-21,  1.712082395012348e-22, -4.389728669383713e-24,  1.039658177302740e-25, -2.292769656636931e-27,
  3.579209365705944e-13, -6.656994169526284e-14,  6.569732354145474e-15, -4.522583061249397e-16,  2.428062859871796e-17, -1.079910821278708e-18,  4.131514746903228e-20,
 -1.394851562238925e-21,  4.233014348261832e-23, -1.170848761014566e-24,  2.983794125840653e-26, -7.063106694297469e-28,  3.999961029035077e-14, -8.279389260095973e-15,
  9.051522407737989e-16, -6.866052140621754e-17,  4.042489064957676e-18, -1.963399984116094e-19,  8.172053256342196e-21, -2.991502484374241e-22,  9.813619471626009e-24,
 -2.926132077163861e-25,  8.018070451797866e-27, -2.035890528227779e-28,  4.314571429804990e-15, -9.897710772482843e-16,  1.195394148594075e-16, -9.970756810705626e-18,
  6.426826896121714e-19, -3.403778687296640e-20,  1.539346145659810e-21, -6.102965549696851e-23,  2.161947522942697e-24, -6.942209783774541e-26,  2.043503742116589e-27,
 -5.560596415745749e-29,  4.577592999026764e-16, -1.158634376413430e-16,  1.541041302559132e-17, -1.409870560454644e-18,  9.928025061018079e-20, -5.723176709655086e-21,
  2.807706338383180e-22, -1.203785685843519e-23,  4.598410428063175e-25, -1.588072032064396e-26,  5.015280838775986e-28, -1.460701775080980e-29,  4.888917881958773e-17,
 -1.358533368232929e-17,  1.982587926248897e-18, -1.983445196350090e-19,  1.521828896434734e-20, -9.526124908897744e-22,  5.058527579962822e-23, -2.340633533714597e-24,
  9.623094952040071e-26, -3.567743388860917e-27,  1.206707205024930e-28, -3.755289010505918e-30,  5.404945557862550e-18, -1.639573242641374e-18,  2.613756688247737e-19,
 -2.848524708034351e-20,  2.373259862053749e-21, -1.608104794961962e-22,  9.216205272277587e-24, -4.589685715994931e-25,  2.025604186471140e-26, -8.041992387603562e-28,
  2.906073865504272e-29, -9.640551289341873e-31,  6.392071647996338e-19, -2.102865552466128e-19,  3.642245891582875e-20, -4.303293789109429e-21,  3.876067685298784e-22,
 -2.831366088434546e-23,  1.744553335171789e-24, -9.316240523847780e-26,  4.398206980281594e-27, -1.863569811347063e-28,  7.171382502714854e-30, -2.527960098542350e-31,
  8.393421296883800e-20, -2.971842506905776e-20,  5.555493224615165e-21, -7.072814980714869e-22,  6.848357582021907e-23, -5.364209448934839e-24,  3.535401701247922e-25,
 -2.014709626822713e-26,  1.012711536104027e-27, -4.558942697229740e-29,  1.860144544974277e-30, -6.938281446472005e-32,  1.273276456689425e-20, -4.809394528737673e-21,
  9.625024420106231e-22, -1.310413070773294e-22,  1.354202009348254e-23, -1.129652879406595e-24,  7.911892148596175e-26, -4.781265331026012e-27,  2.543474527373283e-28,
 -1.209422656376789e-29,  5.202742948043559e-31, -2.042194276295606e-32,  2.316636777509833e-21, -9.240946204029986e-22,  1.960632921399204e-22, -2.828020925228515e-23,
  3.091428198027263e-24, -2.722978435141547e-25,  2.010062166520628e-26, -1.277974199153952e-27,  7.140059999420523e-29, -3.559770382146766e-30,  1.603060285228605e-31,
 -6.576216271882126e-33,  5.179804401178198e-22, -2.157386699573316e-22,  4.797054580637306e-23, -7.249088465249883e-24,  8.292314691818293e-25, -7.632559887920105e-26,
  5.879160976798784e-27, -3.894779947730898e-28,  2.264168529196534e-29, -1.172969063655409e-30,  5.481581716579436e-32, -2.330450114830724e-33,  1.396175930730878e-22,
 -5.996408506990369e-23,  1.379076198040796e-23, -2.155236069871900e-24,  2.547667904593943e-25, -2.420844104877688e-26,  1.923059298217587e-27, -1.312477487645965e-28,
  7.852524686472245e-30, -4.182654231861492e-31,  2.007817345647705e-32, -8.759590350972454e-34,  3.668618725002104e-23, -1.603236459149503e-23,  3.758797586234482e-24,
 -5.988252369405860e-25,  7.212836706241102e-26, -6.979898305755152e-27,  5.643382171306315e-28, -3.917843767469242e-29,  2.382984786109775e-30, -1.289661699828910e-31,
  6.286705708812632e-33, -2.783628485605325e-34,  6.525812243364297e-02, -1.759902321336817e-04,  4.914805618070083e-07, -1.414120572775787e-09,  4.161973370562950e-12,
 -1.246370700982683e-14,  3.768512575983774e-17, -1.150036956938696e-19,  3.505003548381841e-22, -1.078986664444277e-24,  3.266627974097055e-27, -1.018648084690855e-29,
  5.862879958271588e-02, -1.887110183255846e-04,  7.352031957777152e-07, -3.029717149750685e-09,  1.246263813896241e-11, -5.039492079059057e-14,  1.999253729552305e-16,
 -7.799407402912859e-19,  2.996651350759389e-21, -1.137283529097741e-23,  4.263447828977801e-26, -1.584297968380946e-28,  4.732133431649979e-02, -2.018794824776252e-04,
  1.107339586533239e-06, -5.930973807393336e-09,  3.023517608569597e-11, -1.481017166707706e-13,  7.030479308675127e-16, -3.252709934126791e-18,  1.472289242992639e-20,
 -6.538203618183772e-23,  2.854739960829099e-25, -1.227694307645348e-27,  3.431307872352454e-02, -2.006020786980134e-04,  1.435219772377695e-06, -9.349314882862763e-09,
  5.675807206019226e-11, -3.275328382528311e-13,  1.815965840242926e-15, -9.738720173279359e-18,  5.076350706511281e-20, -2.581310175239748e-22,  1.284219508167555e-24,
 -6.265110768159895e-27,  2.235127137607311e-02, -1.781377205880047e-04,  1.574943803198479e-06, -1.216787219538758e-08,  8.653479364142152e-11, -5.791561299238556e-13,
  3.692327266279451e-15, -2.260805208320020e-17,  1.337522924876269e-19, -7.680342073472243e-22,  4.295854036136483e-24, -2.347022028841983e-26,  1.307876168265001e-02,
 -1.393143748703733e-04,  1.477494106530458e-06, -1.337156577051817e-08,  1.101146634424491e-10, -8.447657365708720e-13,  6.123803783109276e-15, -4.235884490378872e-17,
  2.815701029220002e-19, -1.808251017620280e-21,  1.126577104409446e-23, -6.831352562986174e-26,  6.874449550312437e-03, -9.563130791902159e-05,  1.197153828252810e-06,
 -1.258137986017169e-08,  1.188615144974382e-10, -1.035979647140339e-12,  8.468427227830260e-15, -6.565577649779444e-17,  4.867094593878772e-19, -3.470716317219094e-21,
  2.391981064228146e-23, -1.599136408978280e-25,  3.245710679946689e-03, -5.767768197475180e-05,  8.442028811142444e-07, -1.022820416625287e-08,  1.100338107022427e-10,
 -1.082099032951896e-12,  9.910596982263848e-15, -8.560175960702592e-17,  7.035962782086147e-19, -5.540432241121185e-21,  4.201490584620151e-23, -3.080887951250711e-25,
  1.376549260153701e-03, -3.063841226981493e-05,  5.209491521088200e-07, -7.231230512925559e-09,  8.805539749683282e-11, -9.717646109135022e-13,  9.921229924257958e-15,
 -9.501048209976756e-17,  8.619185130768863e-19, -7.461912628460649e-21,  6.200061156684379e-23, -4.966379778446458e-25,  5.244672872671591e-04, -1.437269027924261e-05,
  2.824698187239702e-07, -4.468136084592540e-09,  6.128873790587385e-11, -7.556749382250249e-13,  8.564944267160298e-15, -9.058726909825547e-17,  9.036720908649274e-19,
 -8.570807309391994e-21,  7.776330806698485e-23, -6.782048335166757e-25,  1.795400149326003e-04, -5.969483816436541e-06,  1.350164237980453e-07, -2.422648549646252e-09,
  3.728389643739248e-11, -5.117428772747049e-13,  6.417473580168109e-15, -7.472509582063110e-17,  8.172423392039039e-19, -8.467138872652372e-21,  8.365512930188138e-23,
 -7.922403705320426e-25,  5.523872001735906e-05, -2.200355835368969e-06,  5.704705176161868e-08, -1.156612137996289e-09,  1.990437710837557e-11, -3.032146479309120e-13,
  4.195453041792762e-15, -5.364251788395693e-17,  6.415949017420725e-19, -7.244291767494173e-21,  7.776221221502917e-23, -7.979177444939325e-25,  1.528126526220592e-05,
 -7.213919207564279e-07,  2.135946806685669e-08, -4.876824838520190e-10,  9.358539847952157e-12, -1.578305483236487e-13,  2.404011182071565e-15, -3.367915202005496e-17,
  4.396404884353242e-19, -5.399331015417073e-21,  6.285223931515046e-23, -6.975154526520887e-25,  3.803614370931020e-06, -2.108184776582772e-07,  7.103842154157418e-09,
 -1.821254381139856e-10,  3.887897176514558e-12, -7.243787916470583e-14,  1.212266139085249e-15, -1.857577421722069e-17,  2.642063020215938e-19, -3.523731122302252e-21,
  4.441503251869452e-23, -5.323131171722801e-25,  8.526430801237182e-07, -5.503781885306589e-08,  2.103743981007401e-09, -6.040882291849042e-11,  1.431631181615439e-12,
 -2.941593704913006e-14,  5.400239265359493e-16, -9.037586574095710e-18,  1.398669397308301e-19, -2.023156037203482e-21,  2.757810972797819e-23, -3.565212950378251e-25,
  1.723635978915352e-07, -1.286642849709469e-08,  5.561766806942849e-10, -1.784770985468051e-11,  4.687462973099387e-13, -1.060581877589744e-14,  2.133054078179146e-16,
 -3.894148342287929e-18,  6.550265088175828e-20, -1.026532188515249e-21,  1.511753333806884e-23, -2.106036417632610e-25,  3.147852195018038e-08, -2.700611155805188e-09,
  1.316462904292581e-10, -4.711745166097340e-12,  1.369313971127264e-13, -3.407372254878358e-15,  7.499501846210552e-17, -1.492074968930038e-18,  2.725406231434393e-20,
 -4.623588645319694e-22,  7.350443702099713e-24, -1.102623209916120e-25,  5.206258152707181e-09, -5.105526740526790e-10,  2.799210300950767e-11, -1.115431288862548e-12,
  3.582250903255782e-14, -9.793119967737677e-16,  2.356665795513710e-17, -5.105748043396386e-19,  1.012002518833243e-20, -1.857262913402646e-22,  3.185363443786279e-24,
 -5.142045048988568e-26,  7.823055458286285e-10, -8.726660003811442e-11,  5.368185500608454e-12, -2.377777326662090e-13,  8.428873267174483e-15, -2.529223336479797e-16,
  6.649692417546490e-18, -1.567778484080748e-19,  3.370058404092937e-21, -6.687171636918494e-23,  1.236694834980938e-24, -2.147303017365255e-26,  1.072514536486369e-10,
 -1.354960456794453e-11,  9.330257071599306e-13, -4.587009061449362e-14,  1.792898526083950e-15, -5.900354664775978e-17,  1.693755226784840e-18, -4.343308315783015e-20,
  1.012041384740438e-21, -2.170352267949404e-23,  4.326243145418070e-25, -8.076578131234441e-27,  1.348970569260696e-11, -1.922329965164585e-12,  1.478547289389843e-13,
 -8.056634433866385e-15,  3.468805849857768e-16, -1.251088806386620e-17,  3.918934617733744e-19, -1.092491793470800e-20,  2.758307842343115e-22, -6.390608999844853e-24,
  1.372574081339354e-25, -2.754193846995877e-27,  1.567761904619452e-12, -2.510515689655247e-13,  2.152237162408398e-14, -1.298052722957170e-15,  6.150329170484617e-17,
 -2.429290882395146e-18,  8.298935462248606e-20, -2.513927080620391e-21,  6.874687689845396e-23, -1.720153826042665e-24,  3.979533458288472e-26, -8.580152926379725e-28,
  1.699169445634002e-13, -3.046384953305021e-14,  2.904748072986467e-15, -1.936326045129830e-16,  1.008608616356194e-17, -4.359561751859872e-19,  1.623243832051706e-20,
 -5.340408252438241e-22,  1.581103727794845e-23, -4.270888957018268e-25,  1.063885253088938e-26, -2.463799046161238e-28,  1.737775910946005e-14, -3.475443510417464e-15,
  3.677607731980355e-16, -2.705413904210494e-17,  1.547455042265520e-18, -7.312856597159168e-20,  2.965558160732852e-21, -1.058972892664036e-22,  3.392460433590518e-24,
 -9.887694308667155e-26,  2.650784832007003e-27, -6.590639367154755e-29,  1.702406167654110e-15, -3.783398254960987e-16,  4.432129055584837e-17, -3.591775140841649e-18,
  2.252855906219279e-19, -1.162680172101120e-20,  5.130268148285402e-22, -1.986724856082923e-23,  6.881404204588172e-25, -2.162557623344545e-26,  6.235235632766751e-28,
 -1.663246152079364e-29,  1.628002652430198e-16, -4.003762336786127e-17,  5.178010263285297e-18, -4.612723377834884e-19,  3.167089265635885e-20, -1.782359669120032e-21,
  8.545994610146326e-23, -3.584761866926277e-24,  1.340996646713566e-25, -4.539143549618098e-27,  1.406139506360874e-28, -4.020263243220921e-30,  1.555988265632627e-17,
 -4.214836307494548e-18,  5.997836619329729e-19, -5.857579549289249e-20,  4.392397391796071e-21, -2.690063920699313e-22,  1.398998453218013e-23, -6.345626690690709e-25,
  2.559607350978976e-26, -9.317748893209741e-28,  3.096667256253786e-29, -9.475806562069918e-31,  1.529970075053418e-18, -4.540133307142060e-19,  7.079869455376045e-20,
 -7.553956965215614e-21,  6.167492433802402e-22, -4.099091406562130e-23,  2.306277169998885e-24, -1.128439459805717e-25,  4.896782401774578e-27, -1.912859079081287e-28,
  6.805667736615324e-30, -2.224254773169183e-31,  1.602372677205324e-19, -5.176024086624329e-20,  8.799790642985865e-21, -1.021157176139868e-21,  9.040665070853810e-23,
 -6.496068190008563e-24,  3.940008682902072e-25, -2.072555859378435e-26,  9.644271619882731e-28, -4.030191059435810e-29,  1.530420569056131e-30, -5.326514204665754e-32,
  1.860903656891082e-20, -6.494262368703046e-21,  1.195988913585867e-21, -1.500649619444111e-22,  1.432860518863632e-23, -1.107412285111103e-24,  7.205704602429283e-26,
 -4.056206296784627e-27,  2.015050220462423e-28, -8.969464954490331e-30,  3.620336312686650e-31, -1.336439557672031e-32,  2.504347938689169e-21, -9.358554656673001e-22,
  1.851933031048396e-22, -2.493718508774861e-23,  2.549840223997464e-24, -2.105480348702161e-25,  1.460316812953194e-26, -8.742726453077615e-28,  4.609321056206527e-29,
 -2.172964204242801e-30,  9.270914159458590e-32, -3.610383892560950e-33,  4.078032621476851e-22, -1.614975416399966e-22,  3.400061458384381e-23, -4.867125131821078e-24,
  5.281531479528571e-25, -4.619332110722856e-26,  3.386902077837316e-27, -2.139408525184541e-28,  1.187865562146063e-29, -5.886959737140274e-31,  2.635888165412452e-32,
 -1.075390581719429e-33,  8.290279285630752e-23, -3.438218992248687e-23,  7.609814485901486e-24, -1.144725512435755e-24,  1.303687464199613e-25, -1.194863256572314e-26,
  9.166120156261725e-28, -6.048474696127170e-29,  3.502938333812180e-30, -1.808157491636580e-31,  8.420612966047650e-33, -3.568032191883867e-34,  2.079122578749857e-23,
 -8.911610319659705e-24,  2.044994289745618e-24, -3.188921982366882e-25,  3.761515022338834e-26, -3.566882665597323e-27,  2.827801921850739e-28, -1.926258105233949e-29,
  1.150348213994996e-30, -6.116448153239153e-32,  2.931079083950998e-33, -1.276652012113588e-34,  5.235492641699131e-24, -2.286392629718288e-24,  5.356308256972179e-25,
 -8.526654941448720e-26,  1.026248480485734e-26, -9.923649938451425e-28,  8.017638955896187e-29, -5.562214717503996e-30,  3.380837571317099e-31, -1.828478315484451e-32,
  8.907512150413702e-34, -3.941600910386468e-35,  6.456191929454978e-02, -1.721251520008728e-04,  4.749025945750471e-07, -1.349475123048359e-09,  3.921489233227140e-12,
 -1.159667283510938e-14,  3.461638180206769e-17, -1.043848144409841e-19,  3.139045029523327e-22, -9.568811232308881e-25,  2.848244154629934e-27, -8.868579904396377e-30,
  5.788549318879381e-02, -1.829715042875768e-04,  7.000105672502369e-07, -2.838124658985058e-09,  1.150100734493171e-11, -4.584830290441562e-14,  1.793702522262640e-16,
 -6.902826707712330e-19,  2.616318163503659e-21, -9.799031745606743e-24,  3.624096570273889e-26, -1.329773923159925e-28,  4.653109438679624e-02, -1.932974478685465e-04,
  1.038975617927172e-06, -5.470020525273132e-09,  2.743476230066538e-11, -1.322703375010382e-13,  6.182291823958957e-16, -2.817134988244678e-18,  1.256230301167757e-20,
 -5.497375243554569e-23,  2.365756376932037e-25, -1.002969997494675e-27,  3.353294453471758e-02, -1.895541323500701e-04,  1.328268022060809e-06, -8.491312481296409e-09,
  5.062207316032794e-11, -2.870465521365230e-13,  1.564694402204283e-15, -8.253572089381876e-18,  4.233267017180228e-20, -2.118762931434139e-22,  1.037823434211519e-24,
 -4.986021598583791e-27,  2.166302694315971e-02, -1.660995406341548e-04,  1.436869462562780e-06, -1.087137252634952e-08,  7.578894983750831e-11, -4.976773430697126e-13,
  3.115291479118219e-15, -1.873912104833961e-17,  1.089624861320987e-19, -6.151958790055261e-22,  3.384455275116884e-24, -1.819238370905719e-26,  1.254416850399234e-02,
 -1.281075400799497e-04,  1.327073587171983e-06, -1.173729391243614e-08,  9.459800936839344e-11, -7.110660399080516e-13,  5.054700898741203e-15, -3.430873703038230e-17,
  2.239089837220126e-19, -1.412433378615673e-21,  8.647076514803427e-24, -5.154263180336378e-26,  6.510166248476048e-03, -8.662715911839360e-05,  1.056938364675699e-06,
 -1.083490433857571e-08,  1.000340654938669e-10, -8.531469662649652e-13,  6.830568754981870e-15, -5.190847668078111e-17,  3.774154756730355e-19, -2.641098064850979e-21,
  1.787059988393612e-23, -1.173435290292299e-25,  3.027770040130553e-03, -5.138664822510163e-05,  7.313532325317380e-07, -8.628647028773460e-09,  9.058863548367123e-11,
 -8.706360168936572e-13,  7.801141584639248e-15, -6.597838436936971e-17,  5.313868921862207e-19, -4.102606171357398e-21,  3.051927401738452e-23, -2.196344250303993e-25,
  1.261813190508291e-03, -2.679536435238503e-05,  4.420259037026166e-07, -5.965740652491120e-09,  7.080083000651589e-11, -7.626940190997632e-13,  7.609872090617149e-15,
 -7.128820309510984e-17,  6.331218040904201e-19, -5.369515066153110e-21,  4.373156451674304e-23, -3.435375410632395e-25,  4.711785718648265e-04, -1.231181184331762e-05,
  2.342711150157369e-07, -3.598062633731156e-09,  4.804112560010342e-11, -5.775509170668007e-13,  6.390924916962191e-15, -6.606009032642811e-17,  6.445959359454303e-19,
 -5.984378946286485e-21,  5.318224449361614e-23, -4.545584401916144e-25,  1.576515770654167e-04, -4.996225144689498e-06,  1.092114291687191e-07, -1.900278290839401e-09,
  2.843391243255617e-11, -3.801361389056232e-13,  4.649708817359583e-15, -5.286712556978860e-17,  5.651045792699104e-19, -5.726838326299330e-21,  5.538186055396761e-23,
 -5.136784816430399e-25,  4.726922449268024e-05, -1.794510531662899e-06,  4.489482502992250e-08, -8.816574023903993e-10,  1.473637222434529e-11, -2.184487503826361e-13,
  2.945603607698747e-15, -3.674642293084912e-17,  4.292453603253152e-19, -4.737452288775878e-21,  4.974385892133470e-23, -4.996122416781564e-25,  1.270368643054826e-05,
 -5.716004314088241e-07,  1.631087255945886e-08, -3.603580685651891e-10,  6.710019807968628e-12, -1.100243692357626e-13,  1.631872865131974e-15, -2.228974788654480e-17,
  2.839806905386067e-19, -3.406949262739058e-21,  3.877204001867953e-23, -4.209440571799964e-25,  3.061520132659213e-06, -1.617729017071303e-07,  5.248441772369401e-09,
 -1.300893912274604e-10,  2.692434952084168e-12, -4.873558262506405e-14,  7.936409996206893e-16, -1.184908565729898e-17,  1.643870967863425e-19, -2.140530340667181e-21,
  2.636322533825691e-23, -3.089606927968620e-25,  6.620567177379727e-07, -4.075861694335359e-08,  1.498926319870010e-09, -4.158281411048780e-11,  9.547746485561460e-13,
 -1.904661605301122e-14,  3.400394388817593e-16, -5.541609167541120e-18,  8.361021844507968e-20, -1.180210953482630e-21,  1.571278078959773e-23, -1.985480435109777e-25,
  1.286011002978739e-07, -9.160688001820004e-09,  3.808130543401998e-10, -1.179976042741739e-11,  3.000843709144917e-13, -6.588448124124448e-15,  1.287964682920294e-16,
 -2.288649251332596e-18,  3.751454028537632e-20, -5.734922988605195e-22,  8.245879614983366e-24, -1.122458755677248e-25,  2.247080081879384e-08, -1.840967056836212e-09,
  8.628373926680419e-11, -2.980839141066516e-12,  8.384948674992707e-14, -2.023842084278525e-15,  4.327994200898079e-17, -8.378272992931961e-19,  1.490823199429630e-20,
 -2.466367300301190e-22,  3.827143772674854e-24, -5.608294294639022e-26,  3.539166597248176e-09, -3.317234354616347e-10,  1.748723510167406e-11, -6.725037269803856e-13,
  2.090007149549457e-14, -5.540686146223530e-16,  1.295179984660446e-17, -2.729603616383270e-19,  5.269380874914697e-21, -9.428685310099861e-23,  1.578138919523587e-24,
 -2.488288594344972e-26,  5.038517223470448e-10, -5.377650856960606e-11,  3.181577741584532e-12, -1.360108829552664e-13,  4.665431140422288e-15, -1.357448404546745e-16,
  3.466454222324739e-18, -7.949425752037715e-20,  1.664138877116564e-21, -3.219316506476022e-23,  5.809898380297315e-25, -9.852861136528961e-27,  6.508140691383822e-11,
 -7.876645053816374e-12,  5.219256260001973e-13, -2.477146485426049e-14,  9.370573045489445e-16, -2.990516457391711e-17,  8.338705479517903e-19, -2.080001328800700e-20,
  4.720304554197805e-22, -9.869636838774453e-24,  1.919997764654942e-25, -3.501223787188822e-27,  7.665517156128316e-12, -1.048007407048594e-12,  7.762757206181965e-14,
 -4.085710983588731e-15,  1.703133686872202e-16, -5.958656812796959e-18,  1.813526379108121e-19, -4.918978575529746e-21,  1.209844305240066e-22, -2.733555501090454e-24,
  5.731134182853845e-26, -1.123582394671424e-27,  8.287703010595170e-13, -1.275425733045751e-13,  1.054123791641788e-14, -6.145664972994716e-16,  2.821007615964205e-17,
 -1.081462830496388e-18,  3.591369926856146e-20, -1.058975539872950e-21,  2.822287376898271e-23, -6.889594957112147e-25,  1.556516714942806e-26, -3.280181118744078e-28,
  8.296761782569066e-14, -1.432356409810252e-14,  1.318494625287937e-15, -8.505336045110153e-17,  4.295950285766062e-18, -1.803653114730579e-19,  6.533049639613081e-21,
 -2.093616977995043e-22,  6.044751239692497e-24, -1.593985661029419e-25,  3.879884339957600e-27, -8.787570787199920e-29,  7.778179584363369e-15, -1.501315279254098e-15,
  1.536258545560782e-16, -1.095169520317914e-17,  6.081567189183820e-19, -2.794673810023068e-20,  1.103590731386497e-21, -3.842247208059729e-23,  1.201430259358854e-24,
 -3.421365823798080e-26,  8.970107231999117e-28, -2.182944444106780e-29,  6.929364114355752e-16, -1.490081011986480e-16,  1.691456350527526e-17, -1.330641880965827e-18,
  8.115331175012532e-20, -4.078414738446561e-21,  1.754674912574910e-22, -6.633272003163942e-24,  2.245220743201595e-25, -6.901733754033610e-27,  1.948197839927310e-28,
 -5.091978864322566e-30,  5.977192821042764e-17, -1.426501342076212e-17,  1.791965314350965e-18, -1.552897211302641e-19,  1.038708668557443e-20, -5.702295882902801e-22,
  2.670270972971875e-23, -1.095115295935397e-24,  4.009224790651768e-26, -1.329321265635387e-27,  4.037073254501104e-29, -1.132444038789262e-30,  5.112328694155147e-18,
 -1.348228822268074e-18,  1.868731510446311e-19, -1.779801141702754e-20,  1.303153137296204e-21, -7.801898545067682e-23,  3.970640639116309e-24, -1.764194184840673e-25,
  6.976890287083281e-27, -2.492148017437915e-28,  8.133218340018084e-30, -2.445720676857523e-31,  4.466544236519376e-19, -1.295004415619388e-19,  1.973176868493485e-20,
 -2.059048230769605e-21,  1.645888823731435e-22, -1.072036008342937e-23,  5.916490337277787e-25, -2.842059770819178e-26,  1.211746822058408e-27, -4.654244095531911e-29,
  1.629291052476539e-30, -5.242779793836418e-32,  4.133921175460716e-20, -1.309670015660372e-20,  2.183189570510045e-21, -2.485815610298893e-22,  2.161188636586079e-23,
 -1.526206031082131e-24,  9.104708251292259e-26, -4.714070913500692e-27,  2.160599243202511e-28, -8.898561238096734e-30,  3.332352765257440e-31, -1.144405953382579e-32,
  4.231754214697273e-21, -1.454151864318784e-21,  2.635644288474739e-22, -3.256311959177054e-23,  3.063446344992870e-24, -2.334282950118680e-25,  1.498396443551019e-26,
 -8.325890067847359e-28,  4.085039497549845e-29, -1.796807956954678e-30,  7.170018340811768e-32, -2.617974404734030e-33,  5.029169889618690e-22, -1.857817790990378e-22,
  3.632225509961944e-23, -4.833661605320641e-24,  4.886707317491258e-25, -3.991474492703290e-26,  2.739735071101514e-27, -1.623976707793908e-28,  8.480542081299263e-30,
 -3.961552170952557e-31,  1.675422584006765e-32, -6.470027129753264e-34,  7.289847087315620e-23, -2.864398211708836e-23,  5.980426918545723e-24, -8.491113985904864e-25,
  9.141615518264188e-26, -7.935045578830189e-27,  5.775852583341748e-28, -3.623115164430644e-29,  1.998281295487284e-30, -9.840135617269060e-32,  4.378963427052794e-33,
 -1.776064777764545e-34,  1.339858588520160e-23, -5.531142089404601e-24,  1.218100079850417e-24, -1.823340050394076e-25,  2.066644622412820e-26, -1.885448931443193e-27,
  1.440011101564514e-28, -9.462101431806769e-30,  5.457710192312076e-31, -2.806221729142229e-32,  1.301982950321546e-33, -5.497118114973308e-35,  3.111241254703248e-24,
 -1.330640523293433e-24,  3.046183397575218e-25, -4.738876753510959e-26,  5.576874096772356e-27, -5.276524658948349e-28,  4.174217043670953e-29, -2.837545104124553e-30,
  1.691196829191260e-31, -8.974982688530420e-33,  4.293019608301030e-34, -1.866556356459718e-35,  7.484468366590511e-25, -3.266117528263782e-25,  7.645173957472787e-26,
 -1.216018496664629e-26,  1.462380254282774e-27, -1.412974939780387e-28,  1.140707802089493e-29, -7.907702598978611e-31,  4.802984315743559e-32, -2.595794600958016e-33,
  1.263687345837824e-34, -5.588150886300901e-36,  6.388091605092579e-02, -1.683896567436322e-04,  4.590778458134100e-07, -1.288542596930595e-09,  3.697632697379422e-12,
 -1.079984895290082e-14,  3.182921002266208e-17, -9.486978808361241e-20,  2.814165941433913e-22, -8.504161319441593e-25,  2.483043802749437e-27, -7.764540149736923e-30,
  5.716459596962752e-02, -1.775045896609524e-04,  6.670276482727455e-07, -2.661216776484164e-09,  1.062557213237997e-11, -4.176620745012528e-14,  1.611633459850494e-16,
 -6.119360016813768e-19,  2.288296088655301e-21, -8.459917933897702e-24,  3.086824047806351e-26, -1.118873806300386e-28,  4.577412275996719e-02, -1.852409375981812e-04,
  9.758843504202692e-07, -5.051447436274971e-09,  2.493156852781563e-11, -1.183357346157697e-13,  5.446923345689978e-16, -2.445062710392802e-18,  1.074346357083174e-20,
 -4.633716167491598e-23,  1.965731419693960e-25, -8.216988506311252e-28,  3.279535383379224e-02, -1.793222254026714e-04,  1.231048941599645e-06, -7.725322305113467e-09,
  4.523871188798530e-11, -2.521207834453593e-13,  1.351467476170116e-15, -7.013365408958688e-18,  3.540236918314991e-20, -1.744378075377410e-22,  8.414093471149691e-25,
 -3.981591472625594e-27,  2.102082060552315e-02, -1.551065271551524e-04,  1.313372952444145e-06, -9.734486924720504e-09,  6.654252533828258e-11, -4.288322509587418e-13,
  2.636259437669135e-15, -1.558203468331580e-17,  8.907100242550472e-20, -4.945609280292065e-22,  2.676639603376289e-24, -1.415818498447984e-26,  1.205211443942386e-02,
 -1.180296503932049e-04,  1.194858657951998e-06, -1.033121763061401e-08,  8.151599795930832e-11, -6.005160009563236e-13,  4.187174831810930e-15, -2.789465057957670e-17,
  1.787770772305386e-19, -1.107969049054910e-21,  6.666842028827176e-24, -3.907123298955940e-26,  6.179781946500878e-03, -7.866575961568266e-05,  9.359872647265605e-07,
 -9.362426437765338e-09,  8.449943176888406e-11, -7.053729898614530e-13,  5.532847992277024e-15, -4.122399184625893e-17,  2.940488793094725e-19, -2.019753975769081e-21,
  1.342035150556723e-23, -8.656994000384130e-26,  2.833302442669737e-03, -4.592661757267910e-05,  6.359626727794601e-07, -7.308953147990395e-09,  7.490793083796922e-11,
 -7.037843517435386e-13,  6.171181191556173e-15, -5.111917710604932e-17,  4.035218462832883e-19, -3.055241503794738e-21,  2.230030836738404e-23, -1.575371897463158e-25,
  1.161276487642823e-03, -2.352735288207612e-05,  3.767609016402575e-07, -4.945674792010130e-09,  5.722275283633922e-11, -6.018877913614911e-13,  5.870627149425687e-15,
 -5.381103471881837e-17,  4.679744240812671e-19, -3.888971291284130e-21,  3.105311759200815e-23, -2.392829770907109e-25,  4.254235645416597e-04, -1.059810943731061e-05,
  1.953505004372682e-07, -2.914068374533121e-09,  3.788535693188160e-11, -4.442193494480401e-13,  4.800349127189461e-15, -4.850562012299811e-17,  4.630736632676073e-19,
 -4.209222064744796e-21,  3.664703329099362e-23, -3.070359849951157e-25,  1.392798417761286e-04, -4.206553817155577e-06,  8.890520407378589e-08, -1.500563083219991e-09,
  2.183702176719227e-11, -2.844393022373402e-13,  3.394412505488398e-15, -3.769550202736920e-17,  3.939063107724330e-19, -3.905490222540643e-21,  3.697569959365415e-23,
 -3.359593847700023e-25,  4.074774404462663e-05, -1.473971910428871e-06,  3.559700121697186e-08, -6.773099720411925e-10,  1.099840099177488e-11, -1.586937617226442e-13,
  2.085874102291292e-15, -2.539456215670680e-17,  2.897783533391762e-19, -3.126800917703348e-21,  3.212203383343444e-23, -3.158512683926755e-25,  1.065324382599304e-05,
 -4.567399078595030e-07,  1.256447629016110e-08, -2.686687652283820e-10,  4.855491152973055e-12, -7.742536219699717e-14,  1.118485902603179e-15, -1.489828261075418e-17,
  1.852911886114874e-19, -2.171947744002703e-21,  2.416870569674594e-23, -2.567476639147124e-25,  2.489460864482136e-06, -1.253651899229834e-07,  3.916745358859840e-09,
 -9.387617158705408e-11,  1.884117856708255e-12, -3.313960204184385e-14,  5.252377423022133e-16, -7.642044493923903e-18,  1.034322867628845e-19, -1.315154879120246e-21,
  1.582971753066824e-23, -1.814306863597321e-25,  5.201765751905518e-07, -3.052979425181498e-08,  1.080324405248589e-09, -2.895824695949114e-11,  6.442938696054226e-13,
 -1.248062594286585e-14,  2.167194244056726e-16, -3.439838122996536e-18,  5.060410977997951e-20, -6.971597674974185e-22,  9.066529062697945e-24, -1.119950728973524e-25,
  9.725785801705127e-08, -6.607971440110619e-09,  2.641655406545542e-10, -7.904182711521064e-12,  1.946636034229494e-13, -4.147685526419963e-15,  7.882046331108384e-17,
 -1.363413011530597e-18,  2.178054149951816e-20, -3.248295808279184e-22,  4.560455800364361e-24, -6.066380805209744e-26,  1.628948896383428e-08, -1.273715929112324e-09,
  5.739063015934930e-11, -1.913726856931251e-12,  5.210692424530727e-14, -1.219981475830923e-15,  2.535048948154380e-17, -4.775193395959083e-19,  8.277909593650624e-21,
 -1.335555808656553e-22,  2.022955627006342e-24, -2.896060011751538e-26,  2.447997606612788e-09, -2.191650071960384e-10,  1.110626558091362e-11, -4.121564667545252e-13,
  1.239465306042120e-14, -3.186345590942670e-16,  7.235156047118349e-18, -1.483295762855655e-19,  2.788877741569214e-21, -4.865473932013275e-23,  7.947523182629671e-25,
 -1.223965264549878e-26,  3.308664832179510e-10, -3.376373687382617e-11,  1.920545015638729e-12, -7.922371734208762e-14,  2.629268427849434e-15, -7.417177349876657e-17,
  1.839571136403974e-18, -4.103060418567628e-20,  8.364504457598040e-22, -1.577476276241485e-23,  2.778004652006238e-25, -4.601193528865810e-27,  4.035073884354764e-11,
 -4.674653606641073e-12,  2.979350558417443e-13, -1.364705247541175e-14,  4.995080928006215e-16, -1.545614379070643e-17,  4.185690643256576e-19, -1.015474526020227e-20,
  2.244149474369211e-22, -4.574392708572687e-24,  8.683718005899752e-26, -1.546617264702877e-27,  4.460159558970452e-12, -5.845006022452363e-13,  4.167117796645984e-14,
 -2.117582476283560e-15,  8.543446158826904e-17, -2.898708140122553e-18,  8.569816224848535e-20, -2.261154216447119e-21,  5.416630609480948e-23, -1.193291815563001e-24,
  2.441758973075808e-26, -4.676274500882810e-28,  4.495482375522120e-13, -6.642178247555465e-14,  5.288850310310159e-15, -2.979095026016859e-16,  1.324218581888199e-17,
 -4.925270789219690e-19,  1.589423488620891e-20, -4.560679375246454e-22,  1.184236524676815e-23, -2.819650488648606e-25,  6.219318130011899e-27, -1.280750767669849e-28,
  4.165272618553348e-14, -6.916982713244071e-15,  6.141912892298358e-16, -3.831608722080385e-17,  1.875579480537026e-18, -7.645301354397784e-20,  2.692726381104992e-21,
 -8.402189476870554e-23,  2.364882396694719e-24, -6.085745885233595e-26,  1.446985105547977e-27, -3.204187095432261e-29,  3.586019638221757e-15, -6.672432618898325e-16,
  6.596646662455754e-17, -4.553672698695490e-18,  2.453360046767120e-19, -1.095644535578620e-20,  4.210885124366783e-22, -1.428685804966400e-23,  4.358477737575823e-25,
 -1.212187118978213e-26,  3.106771412031794e-28, -7.397365754957726e-30,  2.909485739452950e-16, -6.046433137054732e-17,  6.644123506499266e-18, -5.069548318576054e-19,
  3.004037367560217e-20, -1.469098525223267e-21,  6.158978387770279e-23, -2.271538819273395e-24,  7.509420388766857e-26, -2.256788070086260e-27,  6.233664888709788e-29,
 -1.595675975489034e-30,  2.265970366489839e-17, -5.241278410199429e-18,  6.388358298890416e-19, -5.380335136815308e-20,  3.502987823414105e-21, -1.874468277968796e-22,
  8.566640198394390e-24, -3.432667493273910e-25,  1.229117086488588e-26, -3.989597839448034e-28,  1.187145952617521e-29, -3.265470659516888e-31,  1.734832801311159e-18,
 -4.448461612254829e-19,  5.998884928649732e-20, -5.566155583715840e-21,  3.975747934991077e-22, -2.324869405604668e-23,  1.156969613909927e-24, -5.031714653775142e-26,
  1.949606560388149e-27, -6.828864785067324e-29,  2.187116777303575e-30, -6.459245768510230e-32,  1.345817608847131e-19, -3.807548735383722e-20,  5.662115988812966e-21,
 -5.772654824374304e-22,  4.513267978707820e-23, -2.878340728893220e-24,  1.556919660971369e-25, -7.336658228450607e-27,  3.071167045279371e-28, -1.159053251980243e-29,
  3.989583908784076e-31, -1.263183756059365e-32,  1.098689764223004e-20, -3.409723319196159e-21,  5.566940718310124e-22, -6.213017915264340e-23,  5.299391568450002e-24,
 -3.674756256854599e-25,  2.154388192384892e-26, -1.097066553494038e-27,  4.948837078803055e-29, -2.007393320170623e-30,  7.408317140060930e-32, -2.508821375026947e-33,
  9.881871615392788e-22, -3.340004342350714e-22,  5.951936240497436e-23, -7.233816183066736e-24,  6.699174496372648e-25, -5.028478414174877e-26,  3.181794643899995e-27,
 -1.743863050170967e-28,  8.444452067429225e-30, -3.667850019543109e-31,  1.446076001378661e-32, -5.219387369742283e-34,  1.032407364651008e-22, -3.766765030438448e-23,
  7.269655297949556e-24, -9.553021558629679e-25,  9.541538177930452e-26, -7.703656120562622e-27,  5.229404362062372e-28, -3.066989835295385e-29,  1.585413845441211e-30,
 -7.334277797748233e-32,  3.073017761159804e-33, -1.176169113438667e-34,  1.324712962779592e-23, -5.161259683949327e-24,  1.067939159884365e-24, -1.502975190736849e-25,
  1.604432492466010e-26, -1.381369080740195e-27,  9.976718980944762e-29, -6.211684994703398e-30,  3.401552711885403e-31, -1.663587298901364e-32,  7.354674997798541e-34,
 -2.964300874380539e-35,  2.188329742186818e-24, -8.988464119584851e-25,  1.968786277132330e-25, -2.931325030820183e-26,  3.305367848591493e-27, -3.000636637144892e-28,
  2.280851532896672e-29, -1.491890769496155e-30,  8.567625603504066e-32, -4.386833199298390e-33,  2.027161133942826e-34, -8.526036089609565e-36,  4.680291471100486e-25,
 -1.996957217867770e-25,  4.559692249090486e-26, -7.075167532064535e-27,  8.305515823136750e-28, -7.839290651794487e-29,  6.187234383638748e-30, -4.196586744218151e-31,
  2.495843513705463e-32, -1.321791386578073e-33,  6.310052703817381e-35, -2.738340218099985e-36,  1.071922943864676e-25, -4.674005923735016e-26,  1.093102316471533e-26,
 -1.737116114103059e-27,  2.087236547490502e-28, -2.015015633237180e-29,  1.625405115751512e-30, -1.125878485680875e-31,  6.833086096049689e-33, -3.690207828901734e-34,
  1.795166790939879e-35, -7.932833870403339e-37,  6.321460613882926e-02, -1.647778944162080e-04,  4.439633115110074e-07, -1.231067829523341e-09,  3.489064705563021e-12,
 -1.006683417787854e-14,  2.929446101926203e-17, -8.633577877267461e-20,  2.525096617302464e-22, -7.576451088245544e-25,  2.162158508932640e-27, -6.851100224589970e-30,
  5.646505179908665e-02, -1.722932788720114e-04,  6.360862013696866e-07, -2.497685738840413e-09,  9.827580915349539e-12, -3.809589628757164e-14,  1.450101543393714e-16,
 -5.433544389471510e-19,  2.004827230195490e-21, -7.318259215456997e-24,  2.634214191830914e-26, -9.437904285543899e-29,  4.504839859142888e-02, -1.776697262535955e-04,
  9.175845489987255e-07, -4.670788375854893e-09,  2.269022901875248e-11, -1.060473000957679e-13,  4.808032970672808e-16, -2.126512492122466e-18,  9.208562778044153e-21,
 -3.915191271008295e-23,  1.637566143617906e-25, -6.750478269321183e-28,  3.209719147119680e-02, -1.698327165072215e-04,  1.142527122116011e-06, -7.040144462866022e-09,
  4.050537989641023e-11, -2.219196182961096e-13,  1.170053849401132e-15, -5.974797728360280e-18,  2.968847293619308e-20, -1.440385804395408e-22,  6.843116988724863e-25,
 -3.190041174775242e-27,  2.042069336334864e-02, -1.450493295453706e-04,  1.202674906237957e-06, -8.735124747183229e-09,  5.856483987472075e-11, -3.704912487305172e-13,
  2.237330269618596e-15, -1.299712525796408e-17,  7.305280485564697e-20, -3.989837314538518e-22,  2.124746645705126e-24, -1.106172712276517e-26,  1.159835854567986e-02,
 -1.089453858077521e-04,  1.078330229662024e-06, -9.117838528555801e-09,  7.045052586491463e-11, -5.087850449623281e-13,  3.480568774151251e-15, -2.276368897061758e-17,
  1.433031380368523e-19, -8.727381673640516e-22,  5.162479609514925e-24, -2.975234817518673e-26,  5.879414250838801e-03, -7.160530128769693e-05,  8.313068894246890e-07,
 -8.116454522273931e-09,  7.163158248091512e-11, -5.854362758821401e-13,  4.500076867475674e-15, -3.288121594640716e-17,  2.301480225154300e-19, -1.552019748163502e-21,
  1.012900703493704e-23, -6.420114104480323e-26,  2.659243312000575e-03, -4.117039076814852e-05,  5.550066965205919e-07, -6.215446177293192e-09,  6.220452012775360e-11,
 -5.714887057626796e-13,  4.905240196961407e-15, -3.980683561597681e-17,  3.080485428285965e-19, -2.287843771410137e-21,  1.638844382048535e-23, -1.136703054214581e-25,
  1.072840206301516e-03, -2.073596102887394e-05,  3.225324100980235e-07, -4.119240908367807e-09,  4.648013030192299e-11, -4.775023271727584e-13,  4.554120508619474e-15,
 -4.085534774020123e-17,  3.480054234926899e-19, -2.834414642541715e-21,  2.219421621081561e-23, -1.677896216107927e-25,  3.859489719371141e-04, -9.165512619713577e-06,
  1.637445731829855e-07, -2.373151450818008e-09,  3.005113758775214e-11, -3.437649026512663e-13,  3.628742176430009e-15, -3.585332331372348e-17,  3.349664797270861e-19,
 -2.981757485474453e-21,  2.543858869256075e-23, -2.089588978832572e-25,  1.237699165486311e-04, -3.561804815966524e-06,  7.282048693828219e-08, -1.192589513531905e-09,
  1.688424635103878e-11, -2.143351048502706e-13,  2.496151088156633e-15, -2.708121491756487e-17,  2.767153960082948e-19, -2.684779867066475e-21,  2.489024985965803e-23,
 -2.215814132082991e-25,  3.537385911118466e-05, -1.218939885332395e-06,  2.842858297452750e-08, -5.242307326440733e-10,  8.272544934693166e-12, -1.162132909341583e-13,
  1.489346935454026e-15, -1.769956272538351e-17,  1.973417556507449e-19, -2.082283329012419e-21,  2.093329911961979e-23, -2.015513995369304e-25,  9.008617469854475e-06,
 -3.679083736337679e-07,  9.759841592628990e-09, -2.020411002997881e-10,  3.544810002358643e-12, -5.498359645257160e-14,  7.738022048303410e-16, -1.005349056129609e-17,
  1.220842538562774e-19, -1.398481143250568e-21,  1.521920277949405e-23, -1.582225803820926e-25,  2.044195726312350e-06, -9.807106130009193e-08,  2.951269352815091e-09,
 -6.841425579408621e-11,  1.331812768686938e-12, -2.276734796683561e-14,  3.512689983430796e-16, -4.981614887606491e-18,  6.579000497705556e-20, -8.170021037643893e-22,
  9.611915637781564e-24, -1.077576091357176e-25,  4.133662889531020e-07, -2.311923160724440e-08,  7.872737089655867e-10, -2.039357241015809e-11,  4.397481417105778e-13,
 -8.273068388555574e-15,  1.397497980792149e-16, -2.160703525529224e-18,  3.099804280882402e-20, -4.168603862056168e-22,  5.296328076997336e-24, -6.396387597207352e-26,
  7.451911081043706e-08, -4.826795231011816e-09,  1.855661862823224e-10, -5.362102563617653e-12,  1.278999665323342e-13, -2.645007388087921e-15,  4.886828390436693e-17,
 -8.229666552221396e-19,  1.281432774413983e-20, -1.864621558964873e-22,  2.556424896975381e-24, -3.323425770131024e-26,  1.198524171617565e-08, -8.939368605027313e-10,
  3.871882648970430e-11, -1.246215387428676e-12,  3.284609488883027e-14, -7.460236362852216e-16,  1.506403928053127e-17, -2.761316986503852e-19,  4.663767760041069e-21,
 -7.338707362867219e-23,  1.085128031964588e-24, -1.517731808740248e-26,  1.721904404057975e-09, -1.471564153275595e-10,  7.167074326850932e-12, -2.566383310348332e-13,
  7.467960785123494e-15, -1.861676094949654e-16,  4.106336041300281e-18, -8.189445961190270e-20,  1.499715390009054e-21, -2.551053496855707e-23,  4.066764895783949e-25,
 -6.117545034819306e-27,  2.213977578093807e-10, -2.158584992187907e-11,  1.180137579986972e-12, -4.696633885314817e-14,  1.507928143349050e-15, -4.124058966328854e-17,
  9.933352469696433e-19, -2.154818547655380e-20,  4.277667039723574e-22, -7.864391781783418e-24,  1.351413404033699e-25, -2.186034294393823e-27,  2.554669148721907e-11,
 -2.830739473845645e-12,  1.734573608667898e-13, -7.665902619438727e-15,  2.714367334729746e-16, -8.142122824138918e-18,  2.141218578972248e-19, -5.051860687926973e-21,
  1.087093740009279e-22, -2.160026049552330e-24,  4.000975433162565e-26, -6.959275154660199e-28,  2.655756993039601e-12, -3.333111081216723e-13,  2.285941456697126e-14,
 -1.121125616854349e-15,  4.376505817499164e-17, -1.439668187564717e-18,  4.133592684658706e-20, -1.060744916521554e-21,  2.474449813070478e-23, -5.314280000304549e-25,
  1.061150639240437e-26, -1.984918154085078e-28,  2.500861953551396e-13, -3.544154449789411e-14,  2.717015054085996e-15, -1.477893258945935e-16,  6.358880456956838e-18,
 -2.293837268362633e-19,  7.191167859586632e-21, -2.007394032765601e-22,  5.077193959364970e-24, -1.178801527121199e-25,  2.537913378001382e-27, -5.106010691206625e-29,
  2.149138934655125e-14, -3.429288537069905e-15,  2.935041624817707e-16, -1.769650502790107e-17,  8.390777060679815e-19, -3.319168778143478e-20,  1.136278856762434e-21,
 -3.450982749205132e-23,  9.465556028043892e-25, -2.376338328145528e-26,  5.517487196198168e-28, -1.194184872899363e-29,  1.702472461409586e-15, -3.050185244512426e-16,
  2.910892219784051e-17, -1.944316697860517e-18,  1.015678770596120e-19, -4.405682360619682e-21,  1.647109281622947e-22, -5.443375269704960e-24,  1.619428071578003e-25,
 -4.396956002270582e-27,  1.101195147111040e-28, -2.564444983709507e-30,  1.260066973007852e-16, -2.527584384920582e-17,  2.685962712346558e-18, -1.986072122911071e-19,
  1.142611665035504e-20, -5.433928553756369e-22,  2.218495104180235e-23, -7.978191971333527e-25,  2.574637218278571e-26, -7.560825660858747e-28,  2.042652737794124e-29,
 -5.118559174940754e-31,  8.871326635080187e-18, -1.986164415797850e-18,  2.346337978851422e-19, -1.918697300486362e-20,  1.214916979629880e-21, -6.331922873449135e-23,
  2.822198305177092e-24, -1.104179527438649e-25,  3.864509522571964e-27, -1.227280865358807e-28,  3.576166225321042e-30, -9.641009978845992e-32,  6.082805666922992e-19,
 -1.514552533105397e-19,  1.984823210420217e-20, -1.792343986842089e-21,  1.247730799472344e-22, -7.120416842235237e-24,  3.462176260435314e-25, -1.472758572660663e-26,
  5.586984612671196e-28, -1.917718232423133e-29,  6.023846349233011e-31, -1.746194980732810e-32,  4.188274605051520e-20, -1.154723165114926e-20,  1.673922730583086e-21,
 -1.665569816169808e-22,  1.272428337089992e-23, -7.938388278932612e-25,  4.204927207178868e-26, -1.942270991759370e-27,  7.976600780570308e-29, -2.955797099975994e-30,
  9.997314403684737e-32, -3.112591914346396e-33,  3.011138706075517e-21, -9.142595523628758e-22,  1.460254435914004e-22, -1.595722946309241e-23,  1.333981714703665e-24,
 -9.074731632690179e-26,  5.223927332313711e-27, -2.614166329634082e-28,  1.159748290646362e-29, -4.629808385193253e-31,  1.682706425884324e-32, -5.615606434308148e-34,
  2.372449976674088e-22, -7.878219394467740e-23,  1.378804277135416e-23, -1.646807110100416e-24,  1.499880068857171e-25, -1.108053570938211e-26,  6.905562057448456e-28,
 -3.730242177926100e-29,  1.781435385066880e-30, -7.635587222366728e-32,  2.972323731669078e-33, -1.059828306219443e-34,  2.169221803687979e-23, -7.809434462952297e-24,
  1.486399971244144e-24, -1.927098288951771e-25,  1.900027344972065e-26, -1.515172885913547e-27,  1.016435472205254e-28, -5.894256584236222e-30,  3.014134152717381e-31,
 -1.380009553752752e-32,  5.725116096810117e-34, -2.170555515521204e-35,  2.449921271775187e-24, -9.457973302878108e-25,  1.938072992029001e-25, -2.701788670305030e-26,
  2.857930290738649e-27, -2.439140371249071e-28,  1.746932395893339e-29, -1.078989555516439e-30,  5.863473491066463e-32, -2.846661457859190e-33,  1.249686055990003e-34,
 -5.003123087774387e-36,  3.614844452118123e-25, -1.476679919452107e-25,  3.215462479234854e-26, -4.759876081623478e-27,  5.337338996746203e-28, -4.819349821429437e-29,
  3.644512691122258e-30, -2.372146575606711e-31,  1.355868964063396e-32, -6.911104818478750e-34,  3.179843618881870e-35, -1.331889489812161e-36,  7.080882109974280e-26,
 -3.013427267809671e-26,  6.861222678015529e-27, -1.061670348609044e-27,  1.242920600523772e-28, -1.170093174081496e-29,  9.211944757062418e-31, -6.233119416481288e-32,
  3.698477615582531e-33, -1.954362393739321e-34,  9.310006638876829e-36, -4.031977618493543e-37,  1.538229838661498e-26, -6.701571352495044e-27,  1.565802020534257e-27,
 -2.485954652975442e-28,  2.984233364450428e-29, -2.878374573351167e-30,  2.319797375104417e-31, -1.605503697861449e-32,  9.735979066394570e-34, -5.253729967440172e-35,
  2.553799143261295e-36, -1.127681969618473e-37,  6.256250573292821e-02, -1.612843452117574e-04,  4.295189251907932e-07, -1.176816093531981e-09,  3.294567497185347e-12,
 -9.391887480020513e-15,  2.698619882587411e-17, -7.867575696938797e-20,  2.267206552254876e-22, -6.769581782183970e-25,  1.877560119615553e-27, -6.113424001709876e-30,
  5.578586993766812e-02, -1.673218617769075e-04,  6.070328756763911e-07, -2.346355739715549e-09,  9.099269557813023e-12, -3.479120657964891e-14,  1.306561903968526e-16,
 -4.832197741929436e-19,  1.759376591405412e-21, -6.343147183183959e-24,  2.251941936350985e-26, -7.982277906086889e-29,  4.435205456482248e-02, -1.705472331780153e-04,
  8.636453362610972e-07, -4.324104973643554e-09,  2.068001960099019e-11, -9.519048954846156e-14,  4.251831809858801e-16, -1.853181641333406e-18,  7.910179066365114e-21,
 -3.315886552179171e-23,  1.367617043267887e-25, -5.560650618747976e-28,  3.143562110963315e-02, -1.610197366810589e-04,  1.061792229493803e-06, -6.426094781450780e-09,
  3.633478476598343e-11, -1.957431134298076e-13,  1.015316545099193e-15, -5.102712600921699e-18,  2.496375533610750e-20, -1.192784547056232e-22,  5.582494130404084e-25,
 -2.564091467697377e-27,  1.985909674377032e-02, -1.358318314344892e-04,  1.103240233158401e-06, -7.854567574812740e-09,  5.166380763893867e-11, -3.209109054740030e-13,
  1.904090776581610e-15, -1.087375346442173e-17,  6.010879832013514e-20, -3.229807114388631e-22,  1.692765333006302e-24, -8.675388217722661e-27,  1.117916339966837e-02,
 -1.007379825819705e-04,  9.753577511244799e-07, -8.067704806102515e-09,  6.106109327410360e-11, -4.324094764935761e-13,  2.902932008695637e-15, -1.864325712566580e-17,
  1.153063976961176e-19, -6.902163777851331e-22,  4.014494482394042e-24, -2.275641839884863e-26,  5.605703484888195e-03, -6.532580543292564e-05,  7.404178668055073e-07,
 -7.058449597908703e-09,  6.093239250128531e-11, -4.876992659513869e-13,  3.674636673674934e-15, -2.633745433585265e-17,  1.809352923602557e-19, -1.198173007625179e-21,
  7.682196402349650e-24, -4.785438643821500e-26,  2.502992273582971e-03, -3.701258789194962e-05,  4.860355242607043e-07, -5.305575467678722e-09,  5.186717135152825e-11,
 -4.660959445797020e-13,  3.917121118932313e-15, -3.114973328055282e-17,  2.363725105287984e-19, -1.722386653808138e-21,  1.211105184042856e-23, -8.249318067583504e-26,
  9.947607562457935e-04, -1.834147178033304e-05,  2.772666860278921e-07, -3.446388075841338e-09,  3.793653739362906e-11, -3.807609416903620e-13,  3.551880113305969e-15,
 -3.119392231133485e-17,  2.603139407958711e-19, -2.078444230871517e-21,  1.596302609353904e-23, -1.184266724650000e-25,  3.517373626110573e-04, -7.961786784691314e-06,
  1.379392251551745e-07, -1.942924490758574e-09,  2.397128548845585e-11, -2.676031529395358e-13,  2.760079309085236e-15, -2.667217536354590e-17,  2.439202542222237e-19,
 -2.126847513497407e-21,  1.778420547852444e-23, -1.432548004589623e-25,  1.106032674566630e-04, -3.032198554699370e-06,  5.999871953120947e-08, -9.537210986646278e-10,
  1.314001618468859e-11, -1.626090448576073e-13,  1.848582458031500e-15, -1.959817783616105e-17,  1.958592055328781e-19, -1.859979569347642e-21,  1.688884218949931e-23,
 -1.473413772268098e-25,  3.091607406053563e-05, -1.014588978263468e-06,  2.286113740270714e-08, -4.086785269544860e-10,  6.268993506746399e-12, -8.576631921242589e-14,
  1.071957908924027e-15, -1.243830357001043e-17,  1.355332768593534e-19, -1.398766778158803e-21,  1.376339540511930e-23, -1.297852500003122e-25,  7.679045051846804e-06,
 -2.986408896624495e-07,  7.642385902368902e-09, -1.532008015657903e-10,  2.610147671962652e-12, -3.939149228147356e-14,  5.401945221314163e-16, -6.847217379175249e-18,
  8.120294047528302e-20, -9.091947660942881e-22,  9.678430015439448e-24, -9.848774044138884e-26,  1.694401578673512e-06, -7.741438730278948e-08,  2.244489630901928e-09,
 -5.033344103869752e-11,  9.505951965756325e-13, -1.579755456575903e-14,  2.373158543747326e-16, -3.281104114228507e-18,  4.228971406886371e-20, -5.130006961059940e-22,
  5.900225900437658e-24, -6.471076226782761e-26,  3.320894903863660e-07, -1.769180752936064e-08,  5.798450294731955e-10, -1.451777687628732e-11,  3.034516149546146e-13,
 -5.545510947768497e-15,  9.114361718892477e-17, -1.372928331925448e-18,  1.921093546749126e-20, -2.522210445586344e-22,  3.131152032457818e-24, -3.697648250784712e-26,
  5.781775988975924e-08, -3.568500039153503e-09,  1.319405065144290e-10, -3.682254059591319e-12,  8.507723135030517e-14, -1.707910543769716e-15,  3.068260553545059e-17,
 -5.031208639902586e-19,  7.636847482950510e-21, -1.084351487398769e-22,  1.451952179567906e-24, -1.844947394367628e-26,  8.945547197063379e-09, -6.360887018617195e-10,
  2.648220675352487e-11, -8.227520708086109e-13,  2.099251740282901e-14, -4.625738590012786e-16,  9.077470343315294e-18, -1.619381736089004e-19,  2.665012120998575e-21,
 -4.090344049575816e-23,  5.904634703629812e-25, -8.069233290837589e-27,  1.230981570234692e-09, -1.003588702094154e-10,  4.696896086052762e-12, -1.622750440041262e-13,
  4.569188760680354e-15, -1.104572434660635e-16,  2.366761940717485e-18, -4.591892877143758e-20,  8.190609986454719e-22, -1.358498598792116e-23,  2.113624097429910e-25,
 -3.105713402591500e-27,  1.508729970782376e-10, -1.404416329363286e-11,  7.377795180809514e-13, -2.832300143762208e-14,  8.796517470415255e-16, -2.332241611116068e-17,
  5.455365429279002e-19, -1.150941064582426e-20,  2.224880043851296e-22, -3.987444791743034e-24,  6.685984090310771e-26, -1.056232261526204e-27,  1.650638242819562e-11,
 -1.747988050203375e-12,  1.029389115943512e-13, -4.388283574238024e-15,  1.502884741769341e-16, -4.369660965355455e-18,  1.115789743327244e-19, -2.559894761955664e-21,
  5.363348142978270e-23, -1.038739019783199e-24,  1.877231209286268e-26, -3.188653672318913e-28,  1.617365294698004e-12, -1.942281270406215e-13,  1.280761600006358e-14,
 -6.060187176482416e-16,  2.288340553586337e-17, -7.296629152986163e-19,  2.034245592017669e-20, -5.076196987067996e-22,  1.152945076977122e-23, -2.413577027899817e-25,
  4.702317105546314e-27, -8.589928637539736e-29,  1.426089846855793e-13, -1.936573773295744e-14,  1.428454212512229e-15, -7.499620104594942e-17,  3.122292177262587e-18,
 -1.092011363873349e-19,  3.324825513632603e-21, -9.026828248687374e-23,  2.223347006919731e-24, -5.032567754455899e-26,  1.057364385681666e-27, -2.077909362203306e-29,
  1.139145594987923e-14, -1.744695220468648e-15,  1.438218417163123e-16, -8.375985863389426e-18,  3.844998888378737e-19, -1.475385242076772e-20,  4.907421379736725e-22,
 -1.450167214306221e-23,  3.874968720165407e-25, -9.487623647149667e-27,  2.150549458798785e-28, -4.548178426931793e-30,  8.320344729649970e-16, -1.433692797799693e-16,
  1.319583673532579e-17, -8.522552438001088e-19,  4.314033108933258e-20, -1.816580218595974e-21,  6.603256655392231e-23, -2.124676711294275e-24,  6.161712734280808e-26,
 -1.632594511050778e-27,  3.993950755523626e-29, -9.093684934548194e-31,  5.628098608432409e-17, -1.088326691224138e-17,  1.117326910987963e-18, -7.999760062146363e-20,
  4.465110331071585e-21, -2.063642473467731e-22,  8.199896639063136e-24, -2.873765169629835e-25,  9.048287918829143e-27, -2.595253133889183e-28,  6.854564708692868e-30,
 -1.680723375557359e-31,  3.587023975007578e-18, -7.763005031723663e-19,  8.878821757269442e-20, -7.043001429407549e-21,  4.333562985873368e-22, -2.198135854571107e-23,
  9.548250941173263e-25, -3.645244395160638e-26,  1.246270143382308e-27, -3.870153965392534e-29,  1.103738816085848e-30, -2.914814233034550e-32,  2.204502304232862e-19,
 -5.322606451723519e-20,  6.770653859506765e-21, -5.944234308007353e-22,  4.029274534632182e-23, -2.242055506751387e-24,  1.064311649593085e-25, -4.425080585251177e-27,
  1.642416700209626e-28, -5.520960069678629e-30,  1.699816648477126e-31, -4.833652924043354e-33,  1.347112576357761e-20, -3.614367021947596e-21,  5.101359103284504e-22,
 -4.948442493218979e-23,  3.690288170973915e-24, -2.250129661160847e-25,  1.166177235048902e-26, -5.275795893109421e-28,  2.124087938855109e-29, -7.722853065449647e-31,
  2.564948785796315e-32, -7.847645586339619e-34,  8.518154897981309e-22, -2.526979869185680e-22,  3.943625310137581e-23, -4.214883761431261e-24,  3.449869996962957e-25,
 -2.300148046020555e-26,  1.298979506837937e-27, -6.382702975975881e-29,  2.782631428078052e-30, -1.092455473151162e-31,  3.907534526742430e-33, -1.284221578057789e-34,
  5.862924186244534e-23, -1.910475567509089e-23,  3.280065500890358e-24, -3.845849143803834e-25,  3.441414565199560e-26, -2.499940413141364e-27,  1.533188063156401e-28,
 -8.156022944319508e-30,  3.838422612143873e-31, -1.622343825373809e-32,  6.231212491146324e-34, -2.193512301214952e-35,  4.671110109064177e-24, -1.657635493110573e-24,
  3.108440120947412e-25, -3.972318503305689e-26,  3.862745619951895e-27, -3.039930512100919e-28,  2.013754268768065e-29, -1.153791376763319e-30,  5.832628921875215e-32,
 -2.641223865643938e-33,  1.084259776387075e-34, -4.069558986663115e-36,  4.616709052406491e-25, -1.764635432791181e-25,  3.578249521598423e-26, -4.937489775669105e-27,
  5.171703362820177e-28, -4.372499413123782e-29,  3.103565611220720e-30, -1.900497697101057e-31,  1.024318253542762e-32, -4.934022545493806e-34,  2.149801528787811e-35,
 -8.545088046174828e-37,  6.044775081695301e-26, -2.454639414143303e-26,  5.310893600140998e-27, -7.812565629646516e-28,  8.707511627434806e-29, -7.816939255969377e-30,
  5.878610761391641e-31, -3.805995967630975e-32,  2.164392973470585e-33, -1.097874089037588e-34,  5.027911165160383e-36, -2.096607158214036e-37,  1.077919876202690e-26,
 -4.574415696373811e-27,  1.038346437877079e-27, -1.601814879058502e-28,  1.869775930945303e-29, -1.755247629240673e-30,  1.378130245487879e-31, -9.300656448148311e-33,
  5.504866965910726e-34, -2.901943958683405e-35,  1.379228746009824e-36, -5.960046070024934e-38,  2.212052988036372e-27, -9.628372016440950e-28,  2.247354102110073e-28,
 -3.564400599846473e-29,  4.274588311215803e-30, -4.118976425290623e-31,  3.316542446880950e-32, -2.293260408077492e-33,  1.389443883021820e-34, -7.491362086102486e-36,
  3.638507874032867e-37, -1.605384786326931e-38,  6.192415246343724e-02, -1.579037989110629e-04,  4.157073238804795e-07, -1.125571260097615e-09,  3.113032141931186e-12,
 -8.769855953590343e-15,  2.488128513436751e-17, -7.179664432147364e-20,  2.036388324405769e-22, -6.070562221331776e-25,  1.621669565995752e-27, -5.546218002376573e-30,
  5.512612011930008e-02, -1.625758006437810e-04,  5.797277140730033e-07, -2.206168132607731e-09,  8.433738975424648e-12, -3.181166289730456e-14,  1.178811091153412e-16,
 -4.304061697114909e-19,  1.546425065303620e-21, -5.508887342072359e-24,  1.928173476517583e-26, -6.771172178489430e-29,  4.368336308031158e-02, -1.638401437342688e-04,
  8.136802817134633e-07, -4.007917840936320e-09,  1.887419403610268e-11, -8.558122542907956e-14,  3.766656586361358e-16, -1.618145653806370e-18,  6.809307081096691e-21,
 -2.814779386592441e-23,  1.144964265358390e-25, -4.592620636731795e-28,  3.080805602621462e-02, -1.528242574956831e-04,  9.880422007659946e-07, -5.874780153692908e-09,
  3.265247574588269e-11, -1.730035777281165e-13,  8.830083140676028e-16, -4.368478396219592e-18,  2.104590311207148e-20, -9.905035873702178e-23,  4.567695802713037e-25,
 -2.067421199507546e-27,  1.933284353013606e-02, -1.273693484087739e-04,  1.013741115749970e-06, -7.076909203932744e-09,  4.567898900946489e-11, -2.786592488292242e-13,
  1.624895469206307e-15, -9.123952028581761e-18,  4.961361405427063e-20, -2.623266368081309e-22,  1.353371298626992e-24, -6.829041379237050e-27,  1.079122665864525e-02,
 -9.330639530673912e-05,  8.841335626249381e-07, -7.156297672576670e-09,  5.306938582160503e-11, -3.686081926701209e-13,  2.429052740681213e-15, -1.532188206788657e-17,
  9.312305703161341e-20, -5.480013314712766e-22,  3.134634236023666e-24, -1.748041644184593e-26,  5.355732965298159e-03, -5.972540583850149e-05,  6.612589636331532e-07,
 -6.157010926240357e-09,  5.200380623325140e-11, -4.077409417309352e-13,  3.012162577366873e-15, -2.118225157436629e-17,  1.428599234204585e-19, -9.291937955827084e-22,
  5.854087642126066e-24, -3.584611524358333e-26,  2.362334289685189e-03, -3.336554014194947e-05,  4.270560149078446e-07, -4.545450021515564e-09,  4.341889976915308e-11,
 -3.817507434787147e-13,  3.142129544848963e-15, -2.449107390400585e-17,  1.822774752905415e-19, -1.303435181896165e-21,  8.998562434272706e-24, -6.020390145848230e-26,
  9.255830513789857e-04, -1.627899625520056e-05,  2.393148651299408e-07, -2.895974451778577e-09,  3.110760860325808e-11, -3.051206528128227e-13,  2.784645318199399e-15,
 -2.394734076317462e-17,  1.958294160502750e-19, -1.533134052771600e-21,  1.155183187411885e-23, -8.411695004775201e-26,  3.219582775020562e-04, -6.945397741945697e-06,
  1.167597576858092e-07, -1.598840194782059e-09,  1.922542407603889e-11, -2.095072124322760e-13,  2.111935980982381e-15, -1.996594365503898e-17,  1.787720310461433e-19,
 -1.527225433824650e-21,  1.251906041679514e-23, -9.891044497109835e-26,  9.936670850173483e-05, -2.594645708498570e-06,  4.971551358762536e-08, -7.672623171498327e-10,
  1.029046009828655e-11, -1.241773313339144e-13,  1.378373147544273e-15, -1.428335434521743e-17,  1.396441363870479e-19, -1.298289524644919e-21,  1.154850028769835e-23,
 -9.875478086232031e-26,  2.719468295913453e-05, -8.497331193147712e-07,  1.850643708676568e-08, -3.208095648589453e-10,  4.785075344248407e-12, -6.377150011525754e-14,
  7.775316083479214e-16, -8.810922527786763e-18,  9.384950354312813e-20, -9.475502103925922e-22,  9.127517218189186e-24, -8.431162564591272e-26,  6.596045157279721e-06,
 -2.442010827333181e-07,  6.030667668726971e-09, -1.170969293528232e-10,  1.937833298669591e-12, -2.846162689495399e-14,  3.804181173460231e-16, -4.705428855638265e-18,
  5.450840673705728e-20, -5.966556861943300e-22,  6.213938131399810e-24, -6.190463123647050e-26,  1.417166248306385e-06, -6.163805989247733e-08,  1.722242341672472e-09,
 -3.737075523776486e-11,  6.848817788471910e-13, -1.106706938596555e-14,  1.619094776499394e-16, -2.182814770142391e-18,  2.746251822805330e-20, -3.254789142564432e-22,
  3.660265946291593e-24, -3.927910557689154e-26,  2.696027411111458e-07, -1.367507891540797e-08,  4.314550929057941e-10, -1.044290154820437e-11,  2.116283853998334e-13,
 -3.757499721660212e-15,  6.009860590886925e-17, -8.821463731105911e-19,  1.204137484771647e-20, -1.543671035396940e-22,  1.872758997160098e-24, -2.162852666073142e-26,
  4.540450421020832e-08, -2.668941166913325e-09,  9.491126976469248e-11, -2.558609364061887e-12,  5.727052109792303e-14, -1.116204111297710e-15,  1.950124717445605e-17,
 -3.114082038253560e-19,  4.608503728721128e-21, -6.386073308503511e-23,  8.352372566073577e-25, -1.037458902227561e-26,  6.769600983897623e-09, -4.586463961248248e-10,
  1.835367805012437e-11, -5.504308158563979e-13,  1.359692985201380e-14, -2.907024443723932e-16,  5.544630995505970e-18, -9.627457080962232e-20,  1.543954143956169e-21,
 -2.311610247515094e-23,  3.258058482536165e-25, -4.350708794123493e-27,  8.939195833404209e-10, -6.947990048094378e-11,  3.124255363222881e-12, -1.041440513390165e-13,
  2.837504586570456e-15, -6.652154654962028e-17,  1.384697345716304e-18, -2.613683379170903e-20,  4.541209932812173e-22, -7.344629909411617e-24,  1.115319737363084e-25,
 -1.600879353774625e-27,  1.046445385734110e-10, -9.293484817220637e-12,  4.689937083393079e-13, -1.736540962655873e-14,  5.216844687461966e-16, -1.340839592587658e-17,
  3.045800575026478e-19, -6.249481724089923e-21,  1.176401492513062e-22, -2.055299049152557e-24,  3.362749904037807e-26, -5.188173515863672e-28,  1.087795571327753e-11,
 -1.100040706781917e-12,  6.223547464984969e-14, -2.558592311281140e-15,  8.474093787878541e-17, -2.387930336864390e-18,  5.920130987141411e-20, -1.320658632877545e-21,
  2.693870305431787e-23, -5.085127602048279e-25,  8.965924399674282e-27, -1.487147026982707e-28,  1.006833292964586e-12, -1.155898252210480e-13,  7.324947560507864e-15,
 -3.342775999534012e-16,  1.220664622283485e-17, -3.772067209931985e-19,  1.020950654838698e-20, -2.477016929064535e-22,  5.477027654539519e-24, -1.117459174094574e-25,
  2.123981612136037e-27, -3.788718198551099e-29,  8.331261262986440e-14, -1.083022159485219e-14,  7.681696924493853e-16, -3.890973601759539e-17,  1.566881108862665e-18,
 -5.311698911287735e-20,  1.570250585023696e-21, -4.145424309114989e-23,  9.941019127769418e-25, -2.193278126238789e-26,  4.496216022681196e-28, -8.629163533345418e-30,
  6.199839602273062e-15, -9.104475981855815e-16,  7.223304564544446e-17, -4.061050597884949e-18,  1.804020682687874e-19, -6.712103790415873e-21,  2.168426339118425e-22,
 -6.232703002477072e-24,  1.621975235182324e-25, -3.872038478533549e-27,  8.565960354393005e-29, -1.769751379418232e-30,  4.184439496458947e-16, -6.926470464081307e-17,
  6.143281602878234e-18, -3.833754999878479e-19,  1.879350844003525e-20, -7.678388730846805e-22,  2.712486968995256e-23, -8.493913773487962e-25,  2.400277891771899e-26,
 -6.203905285491555e-28,  1.482007752724653e-29, -3.298004082128093e-31,  2.591978171283332e-17, -4.825756580312395e-18,  4.781755188877953e-19, -3.312309828264869e-20,
  1.792381017544803e-21, -8.045369353094725e-23,  3.109574868671132e-24, -1.061480903848477e-25,  3.259251657979164e-27, -9.126222310262264e-29,  2.355462883711983e-30,
 -5.649040290290089e-32,  1.497946813372603e-18, -3.129512189885534e-19,  3.461610530641181e-20, -2.661099160432371e-21,  1.589780044361459e-22, -7.842305226083962e-24,
  3.317681986026617e-25, -1.235135172183927e-26,  4.122636272628041e-28, -1.251170767560377e-29,  3.490524282196091e-31, -9.025209685385648e-33,  8.260390500932417e-20,
 -1.931247909787517e-20,  2.381764157632140e-21, -2.030854692544779e-22,  1.339173558439602e-23, -7.259774874822010e-25,  3.361901947456521e-26, -1.365186095620188e-27,
  4.954212087566656e-29, -1.629862576252581e-30,  4.915555708974122e-32, -1.370405101880785e-33,  4.480763649855396e-21, -1.168279886329317e-21,  1.603451023201962e-22,
 -1.514640847601086e-23,  1.101496726069871e-24, -6.558054456012819e-26,  3.322681536533385e-27, -1.471075318006116e-28,  5.801868031833449e-30, -2.068292930792685e-31,
  6.740804923496961e-33, -2.025420739817808e-34,  2.489544409850163e-22, -7.205907809084623e-23,  1.097414556407992e-23, -1.145840473010100e-24,  9.172952066696058e-26,
 -5.988367985791158e-27,  3.314700612702833e-28, -1.597879644212740e-29,  6.840198116540020e-31, -2.638990683549329e-32,  9.282825783190721e-34, -3.002418767828044e-35,
  1.493176825595808e-23, -4.768423746773437e-24,  8.021566243873294e-25, -9.222633938765522e-26,  8.099950037190984e-27, -5.780240734024467e-28,  3.485368566123550e-29,
 -1.824358309477709e-30,  8.454354842624097e-32, -3.520968024451741e-33,  1.333394658151299e-34, -4.630855344004072e-36,  1.032246271449954e-24, -3.606833780575305e-25,
  6.656614842115880e-26, -8.376331741086885e-27,  8.025937906751844e-28, -6.227995420657522e-29,  4.070609594886073e-30, -2.302587663418937e-31,  1.149847482318362e-32,
 -5.146398159496119e-34,  2.089172499395451e-35, -7.757959887352210e-37,  8.876025637133023e-26, -3.356223248191985e-26,  6.728887975493753e-27, -9.183009323809331e-28,
  9.517255713835837e-29, -7.965455440848173e-30,  5.599426827235042e-31, -3.397363042827870e-32,  1.815020292184595e-33, -8.669407061368280e-35,  3.747038909944063e-36,
 -1.477972085382944e-37,  1.024257617507120e-26, -4.132297316926030e-27,  8.878726090504238e-28, -1.297229106638677e-28,  1.436371339037417e-29, -1.281383939259361e-30,
  9.578708166429137e-32, -6.166035468447295e-33,  3.487303036776639e-34, -1.759651720747047e-35,  8.018285104188135e-37, -3.327588598511880e-38,  1.651968586860222e-27,
 -6.988971298845522e-28,  1.581122177734071e-28, -2.431088035825704e-29,  2.828722622697957e-30, -2.647315593582360e-31,  2.072426113698415e-32, -1.394689527837096e-33,
  8.232609342836273e-35, -4.328681865175258e-36,  2.052228503155870e-37, -8.847264495319361e-39,  3.188265696322757e-28, -1.386381993017037e-28,  3.232410766625546e-29,
 -5.121148759795944e-30,  6.134961901856924e-31, -5.905508335254588e-32,  4.750271219558699e-33, -3.281447947540744e-34,  1.986307769923898e-35, -1.069974188328356e-36,
  5.192253340222713e-38, -2.288997402745783e-39,  6.129910421965031e-02, -1.546313341184884e-04,  4.024936350023140e-07, -1.077134148093906e-09,  2.943447418007638e-12,
 -8.196112182034436e-15,  2.295901043334041e-17, -6.561781618350827e-20,  1.828947888750405e-22, -5.469419406907065e-25,  1.386887041156882e-27, -5.156304579948090e-30,
  5.448492806741094e-02, -1.580416283995418e-04,  5.540428266970830e-07, -2.076168457256382e-09,  7.824849163379791e-12, -2.912171894503451e-14,  1.064937491371698e-16,
 -3.839504710281807e-19,  1.361298432008685e-21, -4.794103830396706e-24,  1.653075739475328e-26, -5.764030732766820e-29,  4.304072386824036e-02, -1.575180747232210e-04,
  7.673422566262823e-07, -3.719147533857081e-09,  1.724942272237099e-11, -7.706122976446400e-14,  3.342618943185588e-16, -1.415615085883635e-18,  5.873778296833701e-21,
 -2.394767779828049e-23,  9.608413962547441e-26, -3.802926966519795e-28,  3.021213338918214e-02, -1.451932835491751e-04,  9.205689136325457e-07, -5.378909931097480e-09,
  2.939479824733674e-11, -1.532062579513886e-13,  7.696075700350575e-16, -3.748706685544765e-18,  1.778817252116807e-20, -8.247598830040364e-23,  3.748262709279873e-25,
 -1.672022242540779e-27,  1.883906514838236e-02, -1.195870966539990e-04,  9.330261069028730e-07, -6.388595736457878e-09,  4.047597728754269e-11, -2.425563691564593e-13,
  1.390303220364967e-15, -7.677528868203774e-18,  4.107599814741987e-20, -2.137529624332500e-22,  1.085746101528294e-24, -5.394981653956554e-27,  1.043162300081875e-02,
 -8.656293462695205e-05,  8.031192460426500e-07, -6.363137356828019e-09,  4.624711056255827e-11, -3.151397456448489e-13,  2.038957585640070e-15, -1.263482122752292e-17,
  7.547817570728934e-20, -4.367418642721386e-22,  2.457410606466390e-24, -1.348381950327348e-26,  5.126962735849103e-03, -5.471732083053007e-05,  5.921102828171601e-07,
 -5.386453458881296e-09,  4.452640932339570e-11, -3.420790610300799e-13,  2.478337172321650e-15, -1.710366935748469e-17,  1.132696760122641e-19, -7.237701236678714e-22,
  4.481572216048618e-24, -2.698011546642937e-26,  2.235375511159870e-03, -3.015601843523263e-05,  3.764395362118476e-07, -3.907952235876065e-09,  3.648568129760633e-11,
 -3.139505161244412e-13,  2.531452412909393e-15, -1.934437279795382e-17,  1.412415273572256e-19, -9.913712105194745e-22,  6.721156023458325e-24, -4.417715708438132e-26,
  8.640873723985592e-04, -1.449546411246543e-05,  2.073592912309403e-07, -2.443656703060543e-09,  2.562265216381033e-11, -2.456753326944318e-13,  2.194150256479120e-15,
 -1.848147126186483e-17,  1.481330819894935e-19, -1.137396725705710e-21,  8.409478374418592e-24, -6.011575865955191e-26,  2.959303149544931e-04, -6.083136151697395e-06,
  9.928946940568168e-08, -1.322179662895037e-09,  1.549999895516407e-11, -1.649304121327584e-13,  1.625356795279879e-15, -1.503618718839766e-17,  1.318468487222184e-19,
 -1.103786701615463e-21,  8.871898734842036e-24, -6.876553923695263e-26,  8.972897856298321e-05, -2.231128897862110e-06,  4.141976434465751e-08, -6.208133462151209e-10,
  8.107765753383598e-12, -9.543082689451402e-14,  1.034563042673291e-15, -1.048125914571690e-17,  1.002699701804912e-19, -9.128509850148225e-22,  7.956227209319906e-24,
 -6.670126487193249e-26,  2.406918943719048e-05, -7.158696796455825e-07,  1.507706931922635e-08, -2.535160529339247e-10,  3.677898491185662e-12, -4.776102036447320e-14,
  5.682054810732090e-16, -6.289731038191752e-18,  6.550375493289383e-20, -6.471424651138011e-22,  6.103914557243118e-24, -5.524105837336433e-26,  5.707523038120137e-06,
 -2.010895509352363e-07,  4.794244341776868e-09, -9.019087956018147e-11,  1.450169474502506e-12, -2.073376907829655e-14,  2.701702255846819e-16, -3.261727539310579e-18,
  3.691571799163491e-20, -3.951250339554369e-22,  4.026763839205480e-24, -3.927990593976553e-26,  1.195572135211721e-06, -4.948317618054179e-08,  1.332868807134446e-09,
 -2.799137107341889e-11,  4.979187449788170e-13, -7.825257502072352e-15,  1.115158179624632e-16, -1.466299917578529e-18,  1.801111380155481e-20, -2.085947508482586e-22,
  2.294082506331001e-24, -2.409194087758435e-26,  2.210863757603379e-07, -1.067237549591629e-08,  3.242093114819362e-10, -7.587354452551023e-12,  1.491063319402696e-13,
 -2.572653345446587e-15,  4.005081937163414e-17, -5.729573618857862e-19,  7.630771509536639e-21, -9.553554001316661e-23,  1.132829459188292e-24, -1.279668740135320e-26,
  3.607281207152571e-08, -2.018431680997202e-09,  6.904417224048126e-11, -1.798133957904692e-12,  3.899834733539282e-14, -7.380570505927341e-16,  1.254208142940393e-17,
 -1.950704853552081e-19,  2.814966459229104e-21, -3.807374502486755e-23,  4.864659395001353e-25, -5.907404040380083e-27,  5.191534232068129e-09, -3.349383536448612e-10,
  1.288308809634379e-11, -3.729872536687922e-13,  8.921132074318562e-15, -1.850841041753296e-16,  3.431503324926936e-18, -5.800002301503019e-20,  9.065092964331884e-22,
 -1.324092037465649e-23,  1.822288408666125e-25, -2.378050088083509e-27,  6.590428142396583e-10, -4.880347774495354e-11,  2.108256910223159e-12, -6.780391094869658e-14,
  1.787674589363685e-15, -4.064531272715632e-17,  8.219859791210445e-19, -1.509571932213982e-20,  2.555032974202312e-22, -4.029758975660215e-24,  5.973057236747201e-26,
 -8.375421422360215e-28,  7.383110797627568e-11, -6.251244074668345e-12,  3.029816263492928e-13, -1.081926341916837e-14,  3.143808372144394e-16, -7.832997544032866e-18,
  1.727946965394117e-19, -3.448203996967337e-21,  6.320779163116460e-23, -1.076538823682902e-24,  1.718722965948887e-26, -2.589752403773950e-28,  7.307425930359894e-12,
 -7.051038925345256e-13,  3.831096701821018e-14, -1.518622417533277e-15,  4.863513071874161e-17, -1.328154362657041e-18,  3.196735420447402e-20, -6.933692315539131e-22,
  1.376909123451456e-23, -2.533198976697264e-25,  4.357419288034360e-27, -7.057360644098255e-29,  6.402957137712424e-13, -7.021263065714561e-14,  4.273944070722662e-15,
 -1.880553736610454e-16,  6.639488168763596e-18, -1.988040862146173e-19,  5.223167397119771e-21, -1.231954467548738e-22,  2.651607085048150e-24, -5.272133267031792e-26,
  9.775351674487912e-28, -1.702541283872335e-29,  4.983518457054656e-14, -6.195500111954139e-15,  4.223081673247418e-16, -2.062897796033106e-17,  8.032641635361360e-19,
 -2.638662197516611e-20,  7.572050438088922e-22, -1.943383919768172e-23,  4.536589232776816e-25, -9.754326082423868e-27,  1.950732577119285e-28, -3.655696673830035e-30,
  3.462961430788626e-15, -4.870664273728772e-16,  3.716508597116990e-17, -2.016018785318967e-18,  8.662638792803627e-20, -3.124016867375522e-21,  9.799297723693530e-23,
 -2.738829771489779e-24,  6.939560398355205e-26, -1.614814821046124e-27,  3.485768472879837e-29, -7.033674013923722e-31,  2.164661842278780e-16, -3.438056735351683e-17,
  2.935913738091862e-18, -1.769164965817558e-19,  8.394181831816843e-21, -3.325983963178034e-22,  1.141359879253200e-23, -3.476929399591075e-25,  9.570506542962301e-27,
 -2.412212351525216e-28,  5.624966752137096e-30, -1.223062245671834e-31,  1.230520834191561e-17, -2.202952498292492e-18,  2.104780628772122e-19, -1.409453603035324e-20,
  7.389183514249833e-22, -3.219303462604599e-23,  1.209650251678725e-24, -4.019947865192938e-26,  1.203131635270435e-27, -3.287417627393546e-29,  8.287890806203741e-31,
 -1.943352364623543e-32,  6.460273997149419e-19, -1.301135209866365e-19,  1.390357555816179e-20, -1.034875597820119e-21,  5.997919373134527e-23, -2.875336944558421e-24,
  1.183895546974765e-25, -4.295402518657653e-27,  1.398913874208563e-28, -4.146907178793316e-30,  1.131131158348448e-31, -2.862138152475418e-33,  3.200856021554267e-20,
 -7.236075996133874e-21,  8.641697144854074e-22, -7.148951704310459e-23,  4.581681555091474e-24, -2.417758113727124e-25,  1.091386709461048e-26, -4.325421855909687e-28,
  1.533699584472681e-29, -4.935000756045464e-31,  1.457078248731970e-32, -3.980288001946434e-34,  1.542093768689955e-21, -3.901504941374196e-22,  5.200480065437659e-23,
 -4.778348314073170e-24,  3.385239128292378e-25, -1.966162398674022e-26,  9.730027653843503e-28, -4.212431943270693e-29,  1.626244522938993e-30, -5.680142988658448e-32,
  1.815366832720017e-33, -5.353425217532069e-35,  7.523758355746852e-23, -2.121697365770048e-23,  3.149108452273497e-24, -3.208428958587359e-25,  2.509439771328246e-26,
 -1.602470798520641e-27,  8.685872648097630e-29, -4.104260677935875e-30,  1.723773065479213e-31, -6.530362010472413e-33,  2.257394069441690e-34, -7.180468700132452e-36,
  3.923781183578716e-24, -1.226340502848584e-24,  2.018779897711604e-25, -2.273344215389579e-26,  1.957527812882174e-27, -1.370908209306398e-28,  8.119755745606298e-30,
 -4.178331985574691e-31,  1.905073889681563e-32, -7.811735422548303e-34,  2.914685672520717e-35, -9.979904371171038e-37,  2.344195557796494e-25, -8.055535015583521e-26,
  1.461505852989887e-26, -1.808996861977219e-27,  1.706235153338467e-28, -1.304289276147932e-29,  8.403814819626404e-31, -4.689375112506779e-32,  2.311492636389592e-33,
 -1.021793337438915e-34,  4.099009116008981e-36, -1.504975254450081e-37,  1.743407832955561e-26, -6.515387913972546e-27,  1.290361631100826e-27, -1.740133617505314e-28,
  1.783014233476457e-29, -1.476129067070331e-30,  1.026944802588377e-31, -6.169413833102673e-33,  3.264966537980058e-34, -1.545493505633373e-35,  6.622480236826510e-37,
 -2.590748308818826e-38,  1.760510448643500e-27, -7.052357311275003e-28,  1.503848509955551e-28, -2.180986287968103e-29,  2.397781406857051e-30, -2.124530632837886e-31,
  1.577846292559132e-32, -1.009406342538136e-33,  5.675105783734302e-35, -2.847414759006833e-36,  1.290489039717432e-37, -5.327946064258288e-39,  2.550290322540171e-28,
 -1.075317066733092e-28,  2.423818876223117e-29, -3.713393027795104e-30,  4.305759039379454e-31, -4.016196799271280e-32,  3.134005037939091e-33, -2.102661658006404e-34,
  1.237536408251798e-35, -6.488725804402942e-37,  3.068065420267858e-38, -1.319274626790455e-39,  4.606526657001516e-29, -2.000961418657287e-29,  4.659831306417740e-30,
 -7.373955760094409e-31,  8.823620623840969e-32, -8.484171050338938e-33,  6.817164982085580e-34, -4.704356184531890e-35,  2.844762931840287e-36, -1.530920772748412e-37,
  7.422147138473810e-39, -3.269099467755078e-40,  6.068693803324123e-02, -1.514622991265163e-04,  3.898452820434268e-07, -1.031321041817837e-09,  2.784889857756478e-12,
 -7.666499991901445e-15,  2.120076218264797e-17, -6.006995393196398e-20,  1.641494378215680e-22, -4.959325965969770e-25,  1.164959823420911e-27, -4.967653343859744e-30,
  5.386147139773412e-02, -1.537068568935331e-04,  5.298612104462855e-07, -1.955495046470937e-09,  7.267127264061777e-12, -2.669010889725293e-14,  9.632793384782193e-17,
 -3.430275120063064e-19,  1.200025264477996e-21, -4.181023365117085e-24,  1.418406233988801e-26, -4.928911944825155e-29,  4.242265286307601e-02, -1.515532782754482e-04,
  7.243189463870925e-07, -3.455063794029978e-09,  1.578531684955251e-11, -6.949412225077159e-14,  2.971316246486119e-16, -1.240737789888903e-18,  5.076993238970643e-21,
 -2.041901769780724e-23,  8.081895652607965e-26, -3.157058493030527e-28,  2.964569154902866e-02, -1.380791510576788e-04,  8.587459349829797e-07, -4.932137156747846e-09,
  2.650719798736281e-11, -1.359335631631996e-13,  6.721863505526372e-16, -3.224235602321743e-18,  1.507208436741875e-20, -6.885621747169299e-23,  3.084604576871386e-25,
 -1.356215658422891e-27,  1.837517471730058e-02, -1.124188881876611e-04,  8.600942438541350e-07, -5.778046669562629e-09,  3.594184855308018e-11, -2.116270324619446e-13,
  1.192634803648514e-15, -6.478279680285873e-18,  3.410863747503524e-20, -1.747214377554992e-22,  8.739648264617183e-25, -4.276940864010072e-27,  1.009775472021355e-02,
 -8.043129435388616e-05,  7.310016234699340e-07, -5.671062699241859e-09,  4.040636096387954e-11, -2.701910116008028e-13,  1.716761990088589e-15, -1.045321379809415e-17,
  6.139063055020129e-20, -3.493559515993897e-22,  1.934003050159296e-24, -1.044326565873708e-26,  4.917174284701487e-03, -5.022737689387820e-05,  5.315316451106423e-07,
 -4.725687562480986e-09,  3.824285684784215e-11, -2.879591123098777e-13,  2.046496047434478e-15, -1.386352831732724e-17,  9.017377626314114e-20, -5.661710516741099e-22,
  3.446223134791845e-24, -2.040180933273689e-26,  2.120490872916820e-03, -2.732261638425359e-05,  3.328497383477000e-07, -3.371287778397068e-09,  3.077285256552062e-11,
 -2.592158499132425e-13,  2.048069906990387e-15, -1.534736250780240e-17,  1.099569859142584e-19, -7.577173368618182e-22,  5.045792625820807e-24, -3.258897795269889e-26,
  8.092469158596252e-04, -1.294727161662573e-05,  1.803418492185445e-07, -2.070307919113580e-09,  2.119644141395144e-11, -1.987254868395027e-13,  1.737311626301761e-15,
 -1.433627365183314e-17,  1.126541565677703e-19, -8.485159763956302e-22,  6.157366200182144e-24, -4.322031762690385e-26,  2.730915542017917e-04, -5.348306622155604e-06,
  8.480895333292438e-08, -1.098584094648215e-09,  1.255969088692994e-11, -1.305316562694651e-13,  1.257893305980839e-15, -1.138988727946084e-17,  9.783063817265189e-20,
 -8.027826375027935e-22,  6.328253314842425e-24, -4.812928054836700e-26,  8.142292999226861e-05, -1.927501271657931e-06,  3.468947760830627e-08, -5.051025830681086e-10,
  6.425425403807896e-12, -7.378874398511621e-14,  7.814751572671372e-16, -7.742314630062883e-18,  7.249256646018481e-20, -6.463945434142820e-22,  5.521394589647330e-24,
 -4.538959856954975e-26,  2.142899892858226e-05, -6.064895710371673e-07,  1.235867884566481e-08, -2.016263772408791e-10,  2.845920852633972e-12, -3.602052931670122e-14,
  4.182466578075822e-16, -4.523618753046814e-18,  4.607246738269566e-20, -4.454831537404977e-22,  4.115153540552714e-24, -3.649573881932708e-26,  4.973536257854579e-06,
 -1.666996837312493e-07,  3.838547558771160e-09, -6.998207714244874e-11,  1.093575249517764e-12, -1.522424720784569e-14,  1.934451601028625e-16, -2.280022815664958e-18,
  2.521713273076190e-20, -2.639796173903437e-22,  2.633022148345986e-24, -2.515397735916918e-26,  1.017014617103365e-06, -4.003939210081639e-08,  1.040043423813926e-09,
 -2.114416619963955e-11,  3.651611213089278e-13, -5.582779764703356e-15,  7.751467759929211e-17, -9.942694424976495e-19,  1.192623207677589e-20, -1.349984684224843e-22,
  1.452207089656362e-24, -1.492722950282870e-26,  1.830600817040537e-07, -8.405933414657092e-09,  2.459326976345326e-10, -5.566047365957788e-12,  1.060961695789008e-13,
 -1.779244968476646e-15,  2.696606357491719e-17, -3.760501677610253e-19,  4.887435838921440e-21, -5.976813231492117e-23,  6.928065970767412e-25, -7.655957452903884e-27,
  2.898075365269094e-08, -1.542805301396599e-09,  5.077159994750529e-11, -1.277583589318259e-12,  2.685256910191598e-14, -4.935556754961991e-16,  8.159249597295818e-18,
 -1.236223367496933e-19,  1.739792738196824e-21, -2.297163845184305e-23,  2.867674978686352e-25, -3.404976576418472e-27,  4.032651544218564e-09, -2.476052652529323e-10,
  9.154630778350061e-12, -2.558862872946474e-13,  5.926706643676326e-15, -1.193328861654752e-16,  2.150915697417044e-18, -3.539379615527189e-20,  5.391946108652703e-22,
 -7.684357569754436e-24,  1.032782394391192e-25, -1.317225585346490e-27,  4.930209066122418e-10, -3.476123119072790e-11,  1.442516801145019e-12, -4.476115495422957e-14,
  1.142068658785320e-15, -2.518509586320317e-17,  4.948744619666198e-19, -8.843257661955500e-21,  1.458192311666393e-22, -2.242930419755713e-24,  3.245292442120874e-26,
 -4.445745821764913e-28,  5.295826210714701e-11, -4.271794096984781e-12,  1.988104217673582e-13, -6.846256253534165e-15,  1.924160072005375e-16, -4.647527400284974e-18,
  9.956661595152474e-20, -1.932459837678906e-21,  3.449604016607729e-23, -5.727732341966935e-25,  8.923380860183994e-27, -1.313187362220355e-28,  5.000889924709338e-12,
 -4.600587192309861e-13,  2.399882545831418e-14, -9.170819027315210e-16,  2.839714664801097e-17, -7.514797416944265e-19,  1.755928218059940e-20, -3.702977467777086e-22,
  7.158744978571587e-24, -1.283605448431955e-25,  2.154024214566686e-27, -3.406507927916297e-29,  4.157366410585172e-13, -4.350491953285931e-14,  2.542688950386143e-15,
 -1.078415955770625e-16,  3.680547923087389e-18, -1.067697921738499e-19,  2.722638647231624e-21, -6.242296778476020e-23,  1.307734142529592e-24, -2.533682139472787e-26,
  4.582388090438796e-28, -7.791991079708565e-30,  3.050497552786274e-14, -3.623242116301144e-15,  2.372144809629160e-16, -1.117039480160617e-17,  4.204597166386553e-19,
 -1.338055690434320e-20,  3.726575447680084e-22, -9.296559483394525e-24,  2.112181630023527e-25, -4.425254507584715e-27,  8.632237401100329e-29, -1.579379723868604e-30,
  1.984030944418958e-15, -2.669838157433382e-16,  1.957935955130019e-17, -1.024219580879841e-18,  4.255237591836134e-20, -1.486906258400469e-21,  4.527205026998730e-23,
 -1.230045567610164e-24,  3.033747510068739e-26, -6.879625344532747e-28,  1.448720600425743e-29, -2.854462374839883e-31,  1.151341282992577e-16, -1.752510549020049e-17,
  1.439710968516871e-18, -8.371876790442469e-20,  3.842628982663054e-21, -1.475877749389601e-22,  4.917908574406276e-24, -1.456886396827979e-25,  3.904821416283106e-27,
 -9.594431273223847e-29,  2.183286121945531e-30, -4.637038986130013e-32,  6.020013607384322e-18, -1.034989871341095e-18,  9.525812197153288e-20, -6.161819673575059e-21,
  3.127617751148186e-22, -1.321832123166886e-23,  4.826026030440444e-25, -1.560599124180893e-26,  4.550693963867807e-28, -1.212847880136112e-29,  2.985571156855523e-31,
 -6.841949712079420e-33,  2.877034896415051e-19, -5.578349305677249e-20,  5.752284998176143e-21, -4.141761312878665e-22,  2.326963614270044e-23, -1.083307484068145e-24,
  4.338410201504259e-26, -1.533113450215275e-27,  4.869091769370286e-29, -1.409118107345449e-30,  3.756098098691199e-32, -9.296549870451725e-34,  1.282825094043583e-20,
 -2.800051729441099e-21,  3.234254892268484e-22, -2.593165205464515e-23,  1.613756488614618e-24, -8.282606257000781e-26,  3.641718482261449e-27, -1.407644870752282e-28,
  4.873578325948437e-30, -1.532837447716134e-31,  4.428032042221722e-33, -1.184553979151194e-34,  5.493897227292409e-22, -1.346691365162818e-22,  1.741079822218542e-23,
 -1.554307578022643e-24,  1.071617952581117e-25, -6.065978550212028e-27,  2.929549425917833e-28, -1.239203847262641e-29,  4.679379388766940e-31, -1.600229771148483e-32,
  5.011880898970577e-34, -1.449619971395017e-35,  2.353143150037800e-23, -6.455294484265049e-24,  9.325195572080364e-25, -9.259522238428233e-26,  7.067952244736035e-27,
 -4.410425837847280e-28,  2.338745182032339e-29, -1.082292911919887e-30,  4.456076397814795e-32, -1.656381419399598e-33,  5.622621586982946e-35, -1.757662079866142e-36,
  1.065133681153098e-24, -3.253303482751531e-25,  5.233831281709143e-26, -5.765660062185638e-27,  4.862074122948595e-28, -3.338173756334570e-29,  1.940243101610524e-30,
 -9.806686342234017e-32,  4.395425384160196e-33, -1.773139301440080e-34,  6.513366910107785e-36, -2.197153638329597e-37,  5.478549181504747e-26, -1.849136253135881e-26,
  3.294020647356362e-27, -4.005990922614237e-28,  3.715475308514255e-29, -2.795162899898406e-30,  1.773796370344638e-31, -9.755540588022172e-33,  4.742766307340680e-34,
 -2.069088054994853e-35,  8.196473653523583e-37, -2.973438494172499e-38,  3.503449323885657e-27, -1.292731061747706e-27,  2.526540046818788e-28, -3.363718199883492e-29,
  3.404519851636475e-30, -2.785728272177370e-31,  1.916532592605828e-32, -1.139190995268245e-33,  5.968019948120437e-35, -2.797819780363283e-36,  1.187856228340576e-37,
 -4.606229894288674e-39,  3.073052704115194e-28, -1.221487799200166e-28,  2.583291978008298e-29, -3.716399841534703e-30,  4.054329350423801e-31, -3.565845317112785e-32,
  2.629677037219844e-33, -1.671029592727574e-34,  9.334850831108710e-36, -4.655077178098345e-37,  2.097458296824302e-38, -8.611540749468186e-40,  3.968571086644502e-29,
 -1.667148777017167e-29,  3.742827134602471e-30, -5.711649654844886e-31,  6.597697838241523e-32, -6.131661766862585e-33,  4.768175981001459e-34, -3.188439876186211e-35,
  1.870626339907155e-36, -9.778438197315268e-38,  4.610131216909789e-39, -1.976879420237493e-40,  6.673237286990326e-30, -2.895343396735832e-30,  6.734076354828644e-31,
 -1.064283777618493e-31,  1.271940722062003e-32, -1.221545992731918e-33,  9.803982778669973e-35, -6.757951406641600e-36,  4.082200834959005e-37, -2.194578094603444e-38,
  1.062903465985381e-39, -4.677079001939348e-41,  };
  int offset = -35;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 35;
    if (std::isnan(t)) {
      fill_n(rr+offset, 35, 0.5);
      fill_n(ww+offset, 35, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 35; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=35; ++j) {
        const int boxof = it*420+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
