/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:30:00 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.io.IOException;
import java.io.PipedWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.Track;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Track_ESTest extends Track_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-2866.5884941), "T`!.[", "", true, true, true, entry0);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals("T`!.[", track0.getKeyStr());
      assertEquals("", track0.getQualifier());
      assertTrue(track0.isShowForward());
      assertEquals((-2866.5884941), track0.getPosition(), 0.01);
      assertNotNull(track0);
      
      boolean boolean0 = track0.isShowReverse();
      assertTrue(boolean0);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals("T`!.[", track0.getKeyStr());
      assertEquals("", track0.getQualifier());
      assertTrue(track0.isShowForward());
      assertEquals((-2866.5884941), track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Track track0 = new Track((-571.0896), (String) null, true, true, (Entry) null);
      assertTrue(track0.isShowForward());
      assertTrue(track0.isAny());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-571.0896), track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNotNull(track0);
      
      boolean boolean0 = track0.isShowForward();
      assertTrue(boolean0);
      assertTrue(track0.isShowForward());
      assertTrue(track0.isAny());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-571.0896), track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Track track0 = new Track(0.0, "$A$uW@g", "$A$uW@g", true, true, false, (Entry) null);
      assertEquals("$A$uW@g", track0.getQualifier());
      assertTrue(track0.isShowForward());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isShowReverse());
      assertEquals("$A$uW@g", track0.getKeyStr());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNotNull(track0);
      
      boolean boolean0 = track0.isNotQualifier();
      assertTrue(boolean0);
      assertEquals("$A$uW@g", track0.getQualifier());
      assertTrue(track0.isShowForward());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isShowReverse());
      assertEquals("$A$uW@g", track0.getKeyStr());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Track track0 = new Track((-571.0896), (String) null, true, true, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertTrue(track0.isAny());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertEquals((-571.0896), track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNotNull(track0);
      
      boolean boolean0 = track0.isAny();
      assertTrue(boolean0);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertTrue(track0.isAny());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertEquals((-571.0896), track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(0.05, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertEquals(0.05, track0.getPosition(), 0.01);
      assertNotNull(track0);
      
      track0.setQualifierValue("b/tQ");
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isAny());
      assertEquals("b/tQ", track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertEquals(0.05, track0.getPosition(), 0.01);
      
      String string0 = track0.getQualifierValue();
      assertEquals("b/tQ", string0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isAny());
      assertEquals("b/tQ", track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertEquals(0.05, track0.getPosition(), 0.01);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Track track0 = new Track(0.0, (Entry) null);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNotNull(track0);
      
      track0.setQualifierValue("");
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertEquals("", track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      
      String string0 = track0.getQualifierValue();
      assertEquals("", string0);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertEquals("", track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Track track0 = new Track(0.0, (Entry) null);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNotNull(track0);
      
      String string0 = track0.getQualifier();
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Track track0 = new Track(1058.1985871425666, "", "", false, false, false, (Entry) null);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isNotQualifier());
      assertEquals("", track0.getQualifier());
      assertEquals("", track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(1058.1985871425666, track0.getPosition(), 0.01);
      assertFalse(track0.isShowForward());
      assertNotNull(track0);
      
      String string0 = track0.getQualifier();
      assertEquals("", string0);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isNotQualifier());
      assertEquals("", track0.getQualifier());
      assertEquals("", track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(1058.1985871425666, track0.getPosition(), 0.01);
      assertFalse(track0.isShowForward());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Track track0 = new Track(0.0, "Za&&xp", "tWM{~", false, false, true, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isShowForward());
      assertEquals("Za&&xp", track0.getKeyStr());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isNotQualifier());
      assertEquals("tWM{~", track0.getQualifier());
      assertNotNull(track0);
      
      double double0 = track0.getPosition();
      assertEquals(0.0, double0, 0.01);
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isShowForward());
      assertEquals("Za&&xp", track0.getKeyStr());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isNotQualifier());
      assertEquals("tWM{~", track0.getQualifier());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-2093.62271619433), "painted", " end=", true, false, true, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals((-2093.62271619433), track0.getPosition(), 0.01);
      assertEquals("painted", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertEquals(" end=", track0.getQualifier());
      assertFalse(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNotNull(track0);
      
      double double0 = track0.getPosition();
      assertEquals((-2093.62271619433), double0, 0.01);
      assertFalse(entry0.isReadOnly());
      assertEquals((-2093.62271619433), track0.getPosition(), 0.01);
      assertEquals("painted", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertEquals(" end=", track0.getQualifier());
      assertFalse(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Track track0 = new Track(0.0, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNotNull(track0);
      
      String string0 = track0.getKeyStr();
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(2415.2690983864, "//\n", false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals(2415.2690983864, track0.getPosition(), 0.01);
      assertNull(track0.getQualifier());
      assertEquals("//\n", track0.getKeyStr());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNotNull(track0);
      
      FeaturePredicate featurePredicate0 = track0.getFeaturePredicate();
      assertFalse(entry0.isReadOnly());
      assertEquals(2415.2690983864, track0.getPosition(), 0.01);
      assertNull(track0.getQualifier());
      assertEquals("//\n", track0.getKeyStr());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNotNull(featurePredicate0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Track track0 = new Track(0.0, (Entry) null);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNotNull(track0);
      
      Entry entry0 = track0.getEntry();
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(entry0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Track track0 = new Track(0.0, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNotNull(track0);
      
      Color color0 = Color.darkGray;
      assertEquals((-12566464), color0.getRGB());
      assertEquals(255, color0.getAlpha());
      assertEquals(64, color0.getRed());
      assertEquals(64, color0.getGreen());
      assertEquals(64, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertNotNull(color0);
      
      track0.setColour(color0);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertEquals((-12566464), color0.getRGB());
      assertEquals(255, color0.getAlpha());
      assertEquals(64, color0.getRed());
      assertEquals(64, color0.getGreen());
      assertEquals(64, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      
      Color color1 = track0.getColour();
      assertSame(color1, color0);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertEquals(64, color1.getBlue());
      assertEquals(64, color1.getRed());
      assertEquals((-12566464), color1.getRGB());
      assertEquals(1, color1.getTransparency());
      assertEquals(64, color1.getGreen());
      assertEquals(255, color1.getAlpha());
      assertNotNull(color1);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      StringWriter stringWriter0 = new StringWriter();
      assertEquals("", stringWriter0.toString());
      assertNotNull(stringWriter0);
      
      // Undeclared exception!
      try { 
        Track.writeHeader(stringWriter0, (DNADraw) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Track", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Track track0 = new Track((-3047.70432694405), "rkdqnehstpycgamwlvfi", "", false, false, false, (Entry) null);
      assertFalse(track0.isNotQualifier());
      assertEquals((-3047.70432694405), track0.getPosition(), 0.01);
      assertEquals("rkdqnehstpycgamwlvfi", track0.getKeyStr());
      assertFalse(track0.isAny());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals("", track0.getQualifier());
      assertNotNull(track0);
      
      PipedWriter pipedWriter0 = new PipedWriter();
      assertNotNull(pipedWriter0);
      
      try { 
        track0.write(pipedWriter0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedWriter", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(0.0, "lesK%0Gj.fy", true, true, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
      assertEquals("lesK%0Gj.fy", track0.getKeyStr());
      assertNotNull(track0);
      
      // Undeclared exception!
      try { 
        track0.setPropertiesFromTemplate("lesK%0Gj.fy");
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(75.0, "host", false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals(75.0, track0.getPosition(), 0.01);
      assertEquals("host", track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertFalse(track0.isShowForward());
      assertNotNull(track0);
      
      // Undeclared exception!
      try { 
        track0.setPropertiesFromTemplate((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Track", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Track track0 = new Track(875.0989426, "", (String) null, false, false, false, (Entry) null);
      assertNull(track0.getQualifier());
      assertFalse(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals("", track0.getKeyStr());
      assertEquals(875.0989426, track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNotNull(track0);
      
      String string0 = track0.getKeyStr();
      assertEquals("", string0);
      assertNull(track0.getQualifier());
      assertFalse(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals("", track0.getKeyStr());
      assertEquals(875.0989426, track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Track track0 = new Track(4018.89, (String) null, (String) null, false, true, true, (Entry) null);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(4018.89, track0.getPosition(), 0.01);
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isAny());
      assertNull(track0.getKeyStr());
      assertNotNull(track0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertNotNull(track0);
      
      boolean boolean0 = track0.isNotQualifier();
      assertFalse(boolean0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Track track0 = new Track(0.0, "w#KgV9XJ/;", "w#KgV9XJ/;", false, true, false, (Entry) null);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertEquals("w#KgV9XJ/;", track0.getQualifier());
      assertEquals("w#KgV9XJ/;", track0.getKeyStr());
      assertNotNull(track0);
      
      boolean boolean0 = track0.isAny();
      assertFalse(boolean0);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertEquals("w#KgV9XJ/;", track0.getQualifier());
      assertEquals("w#KgV9XJ/;", track0.getKeyStr());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertNotNull(dNADraw0);
      
      StringWriter stringWriter0 = new StringWriter();
      assertEquals("", stringWriter0.toString());
      assertNotNull(stringWriter0);
      
      Track.writeHeader(stringWriter0, dNADraw0);
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals("## DNA Plot :: track template (created: 14/02/2014 20:21:21)\n# line attributes: start=0 end=4000 line_size=5 circular=true\n# tick marks: major=500 minor=100\n# Columns are:\n# POS  - track position\n# SIZE - track size\n# FWD  - show forward strand features\n# REV  - show reverse strand features\n# NOT  - use NOT\n# ANY  - show any features\n# KEY  - show features of this key\n# QUAL - show features with this qualifier\n# VAL  - show features with this qualifier value(s)\n# COL  - colour for this track e.g. 255:0:0 (R:G:B) or NULL\n# NAME - file entry name or null\n# DIR  - root directory for this file\n#\n#POS\tSIZE\tFWD\tREV\tNOT \tANY\tKEY\tQUAL\tVAL\tCOL\tNAME\tDIR\n", stringWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(0.0, "pseudogenic_exon", true, true, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isAny());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertEquals("pseudogenic_exon", track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertNotNull(track0);
      
      // Undeclared exception!
      try { 
        track0.write((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Track", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Track track0 = new Track((-1061.1021092063818), "Y1GBcg%", true, true, (Entry) null);
      assertTrue(track0.isShowForward());
      assertEquals("Y1GBcg%", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-1061.1021092063818), track0.getPosition(), 0.01);
      assertNull(track0.getQualifier());
      assertNotNull(track0);
      
      Color color0 = new Color((-1141));
      assertEquals((-1141), color0.getRGB());
      assertEquals(251, color0.getGreen());
      assertEquals(1, color0.getTransparency());
      assertEquals(255, color0.getRed());
      assertEquals(255, color0.getAlpha());
      assertEquals(139, color0.getBlue());
      assertNotNull(color0);
      
      track0.setColour(color0);
      assertTrue(track0.isShowForward());
      assertEquals("Y1GBcg%", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-1061.1021092063818), track0.getPosition(), 0.01);
      assertNull(track0.getQualifier());
      assertEquals((-1141), color0.getRGB());
      assertEquals(251, color0.getGreen());
      assertEquals(1, color0.getTransparency());
      assertEquals(255, color0.getRed());
      assertEquals(255, color0.getAlpha());
      assertEquals(139, color0.getBlue());
      
      StringWriter stringWriter0 = new StringWriter();
      assertEquals("", stringWriter0.toString());
      assertNotNull(stringWriter0);
      
      track0.write(stringWriter0);
      assertTrue(track0.isShowForward());
      assertEquals("Y1GBcg%", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-1061.1021092063818), track0.getPosition(), 0.01);
      assertNull(track0.getQualifier());
      assertEquals("-1061.1021092063818\t10.0\ttrue\ttrue\ttrue\tfalse\tY1GBcg%\tnull\tnull\t255:251:139\tnull\n", stringWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Track track0 = new Track((-4413.5710003653), (String) null, false, true, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals((-4413.5710003653), track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isAny());
      assertNotNull(track0);
      
      boolean boolean0 = track0.isOnTrack((uk.ac.sanger.artemis.Feature) null);
      assertTrue(boolean0);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals((-4413.5710003653), track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(Double.NEGATIVE_INFINITY, "orange", true, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(Double.NEGATIVE_INFINITY, track0.getPosition(), 0.01);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals("orange", track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertNotNull(track0);
      
      // Undeclared exception!
      try { 
        track0.isOnTrack((uk.ac.sanger.artemis.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertNotNull(track0);
      
      boolean boolean0 = track0.isShowReverse();
      assertFalse(boolean0);
      assertFalse(entry0.isReadOnly());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(Double.NEGATIVE_INFINITY, "orange", true, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifier());
      assertEquals(Double.NEGATIVE_INFINITY, track0.getPosition(), 0.01);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals("orange", track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertNotNull(track0);
      
      float float0 = track0.getSize();
      assertEquals(10.0F, float0, 0.01F);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifier());
      assertEquals(Double.NEGATIVE_INFINITY, track0.getPosition(), 0.01);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals("orange", track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowReverse());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowForward());
      assertNotNull(track0);
      
      track0.setShowForward(false);
      assertFalse(entry0.isReadOnly());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowReverse());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertNull(track0.getQualifierValue());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(0.0, "lesK%0Gj.fy", true, true, entry0);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isShowForward());
      assertEquals("lesK%0Gj.fy", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNotNull(track0);
      
      track0.setShowReverse(true);
      assertFalse(entry0.isReadOnly());
      assertTrue(track0.isShowForward());
      assertEquals("lesK%0Gj.fy", track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertTrue(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertNotNull(track0);
      
      Color color0 = track0.getColour();
      assertFalse(entry0.isReadOnly());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertNull(color0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNotNull(track0);
      
      String string0 = track0.getQualifierValue();
      assertFalse(entry0.isReadOnly());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Track track0 = new Track(1793.841524892, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getKeyStr());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNotNull(track0);
      
      track0.setQualifier((String) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getKeyStr());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Track track0 = new Track(1793.841524892, (Entry) null);
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertTrue(track0.isShowForward());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertNotNull(track0);
      
      FeaturePredicate featurePredicate0 = track0.getFeaturePredicate();
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertTrue(track0.isShowForward());
      assertNull(track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertNull(featurePredicate0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Track track0 = new Track(1793.841524892, (Entry) null);
      assertTrue(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertNotNull(track0);
      
      track0.setSize(0.0F);
      assertTrue(track0.isShowForward());
      assertEquals(0.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      
      float float0 = track0.getSize();
      assertEquals(0.0F, float0, 0.01F);
      assertTrue(track0.isShowForward());
      assertEquals(0.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertNotNull(track0);
      
      String string0 = track0.getKeyStr();
      assertEquals("OLmB1LZ?unOC", string0);
      assertFalse(entry0.isReadOnly());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Track track0 = new Track(1793.841524892, (Entry) null);
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertNotNull(track0);
      
      track0.setPosition(1793.841524892);
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Track track0 = new Track(1793.841524892, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isAny());
      assertFalse(track0.isNotQualifier());
      assertNotNull(track0);
      
      double double0 = track0.getPosition();
      assertEquals(1793.841524892, double0, 0.01);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(1793.841524892, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isAny());
      assertFalse(track0.isNotQualifier());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Track track0 = new Track((-2043.0), " file_name=", true, false, (Entry) null);
      assertTrue(track0.isShowForward());
      assertEquals((-2043.0), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(" file_name=", track0.getKeyStr());
      assertNotNull(track0);
      
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", " file_name=");
      assertNotNull(featureKeyQualifierPredicate0);
      
      track0.setFeaturePredicate(featureKeyQualifierPredicate0);
      assertTrue(track0.isShowForward());
      assertEquals((-2043.0), track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(" file_name=", track0.getKeyStr());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Track track0 = new Track(2790.76, "cUnId_EXLP>?}%4", true, true, (Entry) null);
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowReverse());
      assertEquals(2790.76, track0.getPosition(), 0.01);
      assertTrue(track0.isShowForward());
      assertTrue(track0.isNotQualifier());
      assertEquals("cUnId_EXLP>?}%4", track0.getKeyStr());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNotNull(track0);
      
      // Undeclared exception!
      try { 
        track0.isOnTrack((uk.ac.sanger.artemis.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureKeyPredicate", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isAny());
      assertNull(track0.getQualifierValue());
      assertNotNull(track0);
      
      track0.setEntry(entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertFalse(track0.isAny());
      assertNull(track0.getQualifierValue());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isNotQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowForward());
      assertNotNull(track0);
      
      track0.setNotQualifier(false);
      assertFalse(entry0.isReadOnly());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isNotQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track(Double.NEGATIVE_INFINITY, "orange", true, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertEquals(Double.NEGATIVE_INFINITY, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals("orange", track0.getKeyStr());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNotNull(track0);
      
      track0.setKeyStr("Q > rBp&YX.lIO+!?_");
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertEquals("Q > rBp&YX.lIO+!?_", track0.getKeyStr());
      assertEquals(Double.NEGATIVE_INFINITY, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNotNull(track0);
      
      Entry entry1 = track0.getEntry();
      assertSame(entry0, entry1);
      assertSame(entry1, entry0);
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isShowForward());
      assertEquals("OLmB1LZ?unOC", track0.getKeyStr());
      assertEquals("OLmB1LZ?unOC", track0.getQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertFalse(entry1.isReadOnly());
      assertNotNull(entry1);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      track0.getQualifier();
      assertFalse(track0.isNotQualifier());
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isShowForward());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      boolean boolean0 = track0.isShowForward();
      assertFalse(track0.isAny());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-880.5525062236), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track((-880.5525062236), "OLmB1LZ?unOC", "OLmB1LZ?unOC", false, false, false, entry0);
      track0.setAny(false);
  }
}
