#
# (c) 2022, Ansible by Red Hat, inc
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
#

from __future__ import absolute_import, division, print_function


__metaclass__ = type

from textwrap import dedent

from ansible_collections.cisco.ios.plugins.modules import ios_hostname
from ansible_collections.cisco.ios.tests.unit.compat.mock import patch
from ansible_collections.cisco.ios.tests.unit.modules.utils import set_module_args

from .ios_module import TestIosModule


class TestIosHostnameModule(TestIosModule):
    module = ios_hostname

    def setUp(self):
        super(TestIosHostnameModule, self).setUp()

        self.mock_get_resource_connection_facts = patch(
            "ansible_collections.ansible.netcommon.plugins.module_utils.network.common.rm_base.resource_module_base."
            "get_resource_connection",
        )
        self.get_resource_connection_facts = self.mock_get_resource_connection_facts.start()

        self.mock_execute_show_command = patch(
            "ansible_collections.cisco.ios.plugins.module_utils.network.ios.facts.hostname.hostname."
            "HostnameFacts.get_hostname_data",
        )
        self.execute_show_command = self.mock_execute_show_command.start()

    def tearDown(self):
        super(TestIosHostnameModule, self).tearDown()
        self.mock_get_resource_connection_facts.stop()
        self.mock_execute_show_command.stop()

    def test_ios_hostname_merged_idempotent(self):
        self.execute_show_command.return_value = dedent(
            """\
            hostname testname
            """,
        )
        set_module_args(dict(config=dict(hostname="testname"), state="merged"))
        commands = []
        result = self.execute_module(changed=False)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_ios_hostname_merged(self):
        self.execute_show_command.return_value = dedent(
            """\
            hostname testname
            """,
        )
        set_module_args(dict(config=dict(hostname="testnameNew"), state="merged"))
        commands = ["hostname testnameNew"]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_ios_hostname_deleted(self):
        self.execute_show_command.return_value = dedent(
            """\
            hostname testname
            """,
        )
        set_module_args(dict(config=dict(), state="deleted"))
        commands = ["no hostname testname"]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_ios_hostname_deleted_blank(self):
        self.execute_show_command.return_value = dedent(
            """\
            """,
        )
        set_module_args(dict(config=dict(), state="deleted"))
        commands = []
        result = self.execute_module(changed=False)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_ios_hostname_replaced_overridden(self):
        """both the replaced and overridden states are supported to have same behaviour"""
        self.execute_show_command.return_value = dedent(
            """\
            hostname testname
            """,
        )
        set_module_args(dict(config=dict(hostname="testnameNew"), state="replaced"))
        commands = ["hostname testnameNew"]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))
