!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawdenpot
!! NAME
!! pawdenpot
!!
!! FUNCTION
!! Compute different (PAW) energies densities and potentials (or potential-like quantities)
!! inside PAW spheres
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  ixc= choice of exchange-correlation scheme (see above, and below)
!!  natom=number of atoms in cell.
!!  nspden=number of spin-density components
!!  ntypat=number of types of atoms in unit cell.
!!  nzlmopt= if -1, compute all LM-moments of densities
!!                  initialize "lmselect" (index of non-zero LM-moments of densities)
!!           if  0, compute all LM-moments of densities
!!                  force "lmselect" to 1 (index of non-zero LM-moments of densities)
!!           if  1, compute only non-zero LM-moments of densities (stored before)
!!  option=0: compute both energies and potentials
!!         1: compute only potentials
!!         2: compute only energies
!!  paw_an(natom) <type(paw_an_type)>=paw arrays given on angular mesh
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawprtvol=control print volume and debugging output for PAW
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data
!!  pawrhoij(natom) <type(pawrhoij_type)>= paw rhoij occupancies and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  pawxcdev=Choice of XC development (0=no dev. (use of angular mesh) ; 1=dev. on moments)
!!  typat(natom)=type (integer) for each atom
!!  ucvol=unit cell volume (bohr^3)
!!
!! OUTPUT
!!  paw_ij(natom)%veij(lmn2_size)=enters into calculation of hartree energy
!!  ==== if option=0 or 2
!!    compch_sph=compensation charge inside spheres computed over spherical meshes
!!    epaw=contribution to total energy from the PAW spherical part
!!    epawdc=contribution to total double-counting energy from the PAW spherical part
!!  ==== if option=0 or 1
!!    paw_an(natom)%vxc1[m](mesh_size,:,nspden)=XC potential calculated from spherical density
!!    paw_an(natom)%vxct1[m](mesh_size,:,nspden)=XC potential calculated from spherical pseudo density
!!  ==== if nzlmopt==-1,
!!    paw_an(iatom)%lnmselect(lm_size,nspden)=select the non-zero LM-moments of rho1 and trho1

!!
!! PARENTS
!!      respfn,scfcv
!!
!! CHILDREN
!!      deducer0,leave_new,pawuenergy,pawxc,pawxcm,simp_gen,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawdenpot(compch_sph,epaw,epawdc,ixc,natom,nspden,ntypat,nzlmopt,option,paw_an,&
&                     paw_ij,pawang,pawprtvol,pawrad,pawrhoij,pawtab,pawxcdev,typat)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13paw, except_this_one => pawdenpot
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: ixc,natom,nspden,ntypat,nzlmopt,option,pawprtvol
 integer,intent(in) :: pawxcdev
 real(dp),intent(out) :: compch_sph,epaw,epawdc
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: typat(natom)
 type(paw_an_type),intent(inout) :: paw_an(natom)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)
 type(pawrad_type),intent(in) :: pawrad(ntypat)
 type(pawrhoij_type),intent(in) :: pawrhoij(natom)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables ---------------------------------------
!scalars
 integer :: facproj,iatom,icount,ij_size,ilm,ils,ilslm,im1,im11,im2,ir,irhoij
 integer :: irhoij1,isel,ispden,itypat,itypat0,jspden,klm,klmn,klmn1,kln,l_size
 integer :: lcutdens,lm_size,lmax,lmin,lmn2_size,mesh_size,mm,opt,usetcore
 integer :: usexcnhat
 real(dp) :: compchspha,compchsphb,e1t10,e1xc,e1xcdc,eexc,eexcdc,eh2,eldaumdc
 real(dp) :: eldaumdcdc,etild1xc,etild1xcdc,exccore,m1,mt1,ro,ro_dlt,ro_ql
 real(dp) :: ro_rg
 character(len=500) :: message
!arrays
 real(dp) :: tsec(2)
 real(dp),allocatable :: aa(:),bb(:),nhat(:,:,:),noccmmptemp(:,:,:)
 real(dp),allocatable :: one_over_rad2(:),rho1(:,:,:),trho1(:,:,:),vxc_tmp(:,:,:)

! *************************************************************************

!DEBUG
!write(6,*)' pawdenpot : enter '
!ENDDEBUG

 call timab(560,1,tsec)

 if(nspden==4) then
    write(message, '(a,a,a,a)' )ch10,&
&    ' pawdenpot : ERROR -',ch10,&
&    '  nspden 4 is not yet allowed.'
    call wrtout(6,message,'COLL')
    call leave_new('PERS')
 end if

 if(nzlmopt/=0.and.nzlmopt/=1.and.nzlmopt/=-1) then
  write(message, '(a,a,a,a)' )ch10,&
&   ' pawdenpot : BUG -',ch10,&
&   '  invalid value for variable "nzlmopt".'
  call wrtout(6,message,'COLL')
  call leave_new('PERS')
 end if

 if (pawprtvol>=2) then
  print *,ch10," PAW TEST:"
  if (nzlmopt==0) print *,' ====== Moments of (n1-tn1) ========='
  if (nzlmopt==1) print *,' ==== Non-zero Moments of (n1-tn1) ===='
  print *,' The moments of (n1-tn1-nhat) must be very small...'
 end if

!Various inits
 usexcnhat=maxval(pawtab(1:ntypat)%vlocopt)
 if (option/=1) compch_sph=zero
 lcutdens=pawang%lcutd

!Init energies
 if (option/=1) then
  e1xc=zero ; e1xcdc=zero
  etild1xc=zero ; etild1xcdc=zero
  exccore=zero ; eh2=zero ; e1t10=zero
  eldaumdc=zero ; eldaumdcdc=zero
 end if

! ================ Big loop on atoms =======================
! ==========================================================

 do iatom=1,natom
  itypat=typat(iatom)
  lmn2_size=paw_ij(iatom)%lmn2_size
  lm_size=paw_an(iatom)%lm_size
  l_size   =pawtab(itypat)%l_size
  ij_size  =pawtab(itypat)%ij_size
  mesh_size=pawrad(itypat)%mesh_size
  usetcore =pawtab(itypat)%usetcore

! Allocations of spherical densities
  allocate(rho1 (mesh_size,lm_size,nspden))
  allocate(trho1(mesh_size,lm_size,nspden))
  allocate(nhat (mesh_size,lm_size,nspden))
  rho1=zero;trho1=zero;nhat=zero

! Store some usefull quantities
  itypat0=0;if (iatom>1) itypat0=typat(iatom-1)
  if (itypat/=itypat0) then
   allocate(one_over_rad2(mesh_size))
   one_over_rad2(2:mesh_size)=one/pawrad(itypat)%rad(2:mesh_size)**2
  end if

! ===== Compute spherical densities (n1, ntild1, nhat) =====
! ==========================================================

  do ispden=1,nspden
   jspden=nspden+1-ispden
   if (nzlmopt<1) paw_an(iatom)%lmselect(1:lm_size,ispden)=1

!  -- Loop over ij channels (basis components)
   do irhoij=1,pawrhoij(iatom)%nrhoijsel(ispden)
    klmn=pawrhoij(iatom)%rhoijselect(irhoij,ispden)
    klm =pawtab(itypat)%indklmn(1,klmn)
    kln =pawtab(itypat)%indklmn(2,klmn)
    lmin=pawtab(itypat)%indklmn(3,klmn)
    lmax=min(lcutdens-1,pawtab(itypat)%indklmn(4,klmn))

!   -- Computation of the moments of the densities on the spherical mesh
    do ils=lmin,lmax,2
     do mm=-ils,ils
      ilslm=ils*ils+ils+mm+1
      if (paw_an(iatom)%lmselect(ilslm,ispden)>0) then
       isel=pawang%gntselect(ilslm,klm)
       if (isel>0) then
        ro=pawtab(itypat)%dltij(klmn)*pawrhoij(iatom)%rhoijp(irhoij,ispden)
        ro_ql=ro*pawtab(itypat)%qijl(ilslm,klmn)
        ro_rg=ro*pawang%realgnt(isel)

!       == nhat(r=0)
        nhat(1,ilslm,jspden) = nhat(1,ilslm,jspden)+ro_ql*pawtab(itypat)%shapefunc(1,ils+1)
!       == rho1(r>0), trho1(r>0), nhat(r>0)
        do ir=2,mesh_size
         rho1(ir,ilslm,jspden) = rho1(ir,ilslm,jspden)&
&               +ro_rg*pawtab(itypat)%phiphj  (ir,kln)*one_over_rad2(ir)
         trho1(ir,ilslm,jspden)=trho1(ir,ilslm,jspden)&
&               +ro_rg*pawtab(itypat)%tphitphj(ir,kln)*one_over_rad2(ir)
         nhat(ir,ilslm,jspden) = nhat(ir,ilslm,jspden)+ro_ql*pawtab(itypat)%shapefunc(ir,ils+1)
        end do

       end if
      end if
     end do  ! End loops over ils, mm
    end do
   end do ! End loop over ij channels

!  Computation of rho1(r=0) and trho1(r=0)
   do ilm=1,lm_size
    if (paw_an(iatom)%lmselect(ilm,ispden)>0) then
     call deducer0( rho1(:,ilm,jspden),mesh_size,pawrad(itypat))
     call deducer0(trho1(:,ilm,jspden),mesh_size,pawrad(itypat))
    end if
   end do

!  -- Test moments of densities
   if (option/=1.or.nzlmopt==-1.or.pawprtvol>=2) then
    allocate(aa(mesh_size))
    if (pawprtvol>=2) then
     allocate(bb(mesh_size))
     print *,' Atom ',iatom,' (ispden=',ispden,'):'
     print *,'  ******* Moment of (n1-tn1) ** Moment of (n1-tn1-nhat)'
    end if
    do ils=0,min(lcutdens,l_size)-1
     do mm=-ils,ils
      ilslm=ils*ils+ils+mm+1
      if (paw_an(iatom)%lmselect(ilslm,ispden)>0) then
       m1=zero;mt1=zero
       do ir=1,mesh_size
        ro=pawrad(itypat)%rad(ir)**(2+ils)
        aa(ir)=(rho1(ir,ilslm,jspden)-trho1(ir,ilslm,jspden))*ro
        m1 =max(m1 ,abs(rho1 (ir,ilslm,jspden)))
        mt1=max(mt1,abs(trho1(ir,ilslm,jspden)))
       end do
       call simp_gen(compchspha,aa,pawrad(itypat))
       if (ils==0.and.option/=1) compch_sph=compch_sph+compchspha*sqrt(four_pi)
       if ((nzlmopt==-1).and.(ilslm>1).and.(m1<1d-15).and.(mt1<1.d-15)) &
&                                paw_an(iatom)%lmselect(ilslm,ispden)=0
       if (pawprtvol>=2) then
        bb(1:mesh_size)= nhat(1:mesh_size,ilslm,jspden) &
&                       *pawrad(itypat)%rad(1:mesh_size)**(2+ils)
        call simp_gen(compchsphb,bb,pawrad(itypat))
        print '(3x,a,2i2,2(a,g14.7))','l,m=',ils,mm,&
&            ': M=',compchspha,' **    M=',compchspha-compchsphb
       end if
      end if
     end do
    end do
    deallocate(aa);if (pawprtvol>=2) deallocate(bb)
   end if

!  Transfer components of densities (1=up+down, 2=up)
   if (ispden==2) then
    do ilm=1,lm_size
     if (paw_an(iatom)%lmselect(ilm,ispden)>0) then
      rho1 (:,ilm,1) = rho1(:,ilm,1)+ rho1(:,ilm,2)
      trho1(:,ilm,1) =trho1(:,ilm,1)+trho1(:,ilm,2)
      nhat (:,ilm,1) = nhat(:,ilm,1)+ nhat(:,ilm,2)
     end if
    end do
   end if

!----- End loop over spin components
  end do
  itypat0=0;if (iatom<natom) itypat0=typat(iatom+1)
  if (itypat/=itypat0) deallocate(one_over_rad2)

! =========== Compute XC potentials and energies ===========
! ==========================================================

! Temporary storage
  if (pawxcdev/=0) allocate(vxc_tmp(mesh_size,lm_size,nspden))
  if (pawxcdev==0) allocate(vxc_tmp(mesh_size,pawang%angl_size,nspden))

! ===== Vxc1 term =====
  if (pawxcdev/=0) then
   call pawxcm(pawtab(itypat)%coredens,eexc,eexcdc,ixc,lm_size,&
&              paw_an(iatom)%lmselect,nhat,nspden,option,&
&              pawrad(itypat),rho1,1,0,vxc_tmp)
  else
   call pawxc(pawtab(itypat)%coredens,eexc,eexcdc,ixc,lm_size,&
&             paw_an(iatom)%lmselect,nhat,nspden,option,&
&             pawang,pawrad(itypat),rho1,1,0,vxc_tmp)
  end if
  if (option/=1) then
   e1xc=e1xc+eexc
   e1xcdc=e1xcdc+eexcdc
  end if
  if (option<2) paw_an(iatom)%vxc1(:,:,:)=vxc_tmp(:,:,:)

! ===== tVxc1 term =====
  if (pawxcdev/=0) then
   call pawxcm(pawtab(itypat)%tcoredens,eexc,eexcdc,ixc,lm_size,&
&              paw_an(iatom)%lmselect,nhat,nspden,option,&
&              pawrad(itypat),trho1,usetcore,1+usexcnhat,vxc_tmp)
  else
   call pawxc(pawtab(itypat)%tcoredens,eexc,eexcdc,ixc,lm_size,&
&             paw_an(iatom)%lmselect,nhat,nspden,option,&
&             pawang,pawrad(itypat),trho1,usetcore,1+usexcnhat,vxc_tmp)
  end if
  if (option/=1) then
   etild1xc=etild1xc+eexc
   etild1xcdc=etild1xcdc+eexcdc
  end if
  if (option<2) paw_an(iatom)%vxct1(:,:,:)=vxc_tmp(:,:,:)

  deallocate(vxc_tmp)
  deallocate(nhat,rho1,trho1)

! ==== Compute Hartree-like terms and some energy terms ====
! ==========================================================

  paw_ij(iatom)%veij=zero
  do ispden=1,nspden
   do irhoij=1,pawrhoij(iatom)%nrhoijsel(ispden)
    klmn=pawrhoij(iatom)%rhoijselect(irhoij,ispden)
    ro_dlt=pawrhoij(iatom)%rhoijp(irhoij,ispden)*pawtab(itypat)%dltij(klmn)
    paw_ij(iatom)%veij(klmn)=paw_ij(iatom)%veij(klmn)&
&                           +ro_dlt*pawtab(itypat)%eijkl(klmn,klmn)
    do klmn1=1,klmn-1
     paw_ij(iatom)%veij(klmn1)=paw_ij(iatom)%veij(klmn1)&
&                             +ro_dlt*pawtab(itypat)%eijkl(klmn1,klmn)
    end do
    do klmn1=klmn+1,lmn2_size
     paw_ij(iatom)%veij(klmn1)=paw_ij(iatom)%veij(klmn1)&
&                             +ro_dlt*pawtab(itypat)%eijkl(klmn,klmn1)
    end do
   end do
  end do
  if (option/=1) then
   do ispden=1,nspden
    do irhoij=1,pawrhoij(iatom)%nrhoijsel(ispden)
     klmn=pawrhoij(iatom)%rhoijselect(irhoij,ispden)
     ro_dlt=pawrhoij(iatom)%rhoijp(irhoij,ispden)*pawtab(itypat)%dltij(klmn)
     eh2=eh2    +ro_dlt*paw_ij(iatom)%veij(klmn)
     e1t10=e1t10+ro_dlt*pawtab(itypat)%dij0(klmn)
    end do
   end do
  end if
  if (option/=1) exccore=exccore+pawtab(itypat)%exccore

! ===== lda+u term =====
! noccmmp^{\sigma}_{m,m'}=\sum_{ni,nj}
! [\rho^{\sigma}_{ni,nj}*phiphjint_{ni,nj}]
  if (pawtab(itypat)%usepawu>0) then
   allocate(noccmmptemp(2*pawtab(itypat)%lpawu+1,2*pawtab(itypat)%lpawu+1,nspden))
   paw_ij(iatom)%noccmmp(:,:,:)=zero
   noccmmptemp(:,:,:)=zero
   do ispden=1,nspden
    do irhoij=1,pawrhoij(iatom)%nrhoijsel(ispden)
     klmn=pawrhoij(iatom)%rhoijselect(irhoij,ispden)
     if(pawtab(itypat)%indklmn(3,klmn)==0.and.&
&     pawtab(itypat)%indklmn(4,klmn)==2*pawtab(itypat)%lpawu) then
      icount=pawtab(itypat)%klmntomn(3,klmn)+(pawtab(itypat)%klmntomn(4,klmn)&
&     *(pawtab(itypat)%klmntomn(4,klmn)-1))/2
!------test
      if(pawtab(itypat)%ij_proj<icount)  then
       write(message, '(a,a,a,a,a,a)' ) ch10,&
&      '  pawsphpot : ERROR -',ch10,&
&      '  PAW+U: Error in the loop for calculating noccmmp',ch10,&
&      '  Action : contact the abinit group.'
       call wrtout(ab_out,message,'COLL');call wrtout(06,  message,'COLL')
       call leave_new('COLL')
      end if
!------
!========= Test if the projectors are different
      if(pawtab(itypat)%klmntomn(3,klmn)/=pawtab(itypat)%klmntomn(4,klmn)) then
       facproj=Two
      else
       facproj=One
      end if
!=========
       if(abs(facproj-Two)<tol8) then
        if(pawtab(itypat)%klmntomn(2,klmn)<=pawtab(itypat)%klmntomn(1,klmn)) then
        noccmmptemp(pawtab(itypat)%klmntomn(1,klmn)&
&      ,pawtab(itypat)%klmntomn(2,klmn),ispden)=&
&       noccmmptemp(pawtab(itypat)%klmntomn(1,klmn)&
&      ,pawtab(itypat)%klmntomn(2,klmn),ispden) +&
&      pawtab(itypat)%phiphjint(icount)*pawrhoij(iatom)%rhoijp(irhoij,ispden)
        end if
       end if
        if(pawtab(itypat)%klmntomn(2,klmn)>=pawtab(itypat)%klmntomn(1,klmn)) then
       paw_ij(iatom)%noccmmp(pawtab(itypat)%klmntomn(1,klmn)&
&      ,pawtab(itypat)%klmntomn(2,klmn),ispden)=&
&      paw_ij(iatom)%noccmmp(pawtab(itypat)%klmntomn(1,klmn)&
&      ,pawtab(itypat)%klmntomn(2,klmn),ispden)+&
&      pawtab(itypat)%phiphjint(icount)*pawrhoij(iatom)%rhoijp(irhoij,ispden)
       end if
      if(pawprtvol>=3) then
       write(message,*) "pawsphpot:klmn,rhoijp", klmn,pawrhoij(iatom)%rhoijp(irhoij,ispden)
       call wrtout(6,message,'COLL')
      end if
     end if
    end do ! irhoij
    do im2=1,2*pawtab(itypat)%lpawu+1
     do im1=1,im2
      paw_ij(iatom)%noccmmp(im1,im2,ispden)=paw_ij(iatom)%noccmmp(im1,im2,ispden)&
&  +noccmmptemp(im2,im1,ispden)
     end do
    end do
    do im1=1,2*pawtab(itypat)%lpawu+1
     do im2=1,im1
      paw_ij(iatom)%noccmmp(im1,im2,ispden)=paw_ij(iatom)%noccmmp(im2,im1,ispden)
     end do
    end do
   end do ! ispden

   do ispden=1,nspden
    paw_ij(iatom)%nocctot(ispden)= 0._dp
    do im11=1,2*pawtab(itypat)%lpawu+1
    paw_ij(iatom)%nocctot(ispden)= paw_ij(iatom)%nocctot(ispden)+&
&   paw_ij(iatom)%noccmmp(im11,im11,ispden)
    end do
   end do
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    write(message, '(a)' )'========== LDA+U DATA =================================================== '
    call wrtout(06,  message,'COLL')
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    write(message,fmt=9) "====== For Atom", iatom,", occupations for correlated orbitals. lpawu ="&
&    ,pawtab(itypat)%lpawu
    call wrtout(6,message,'COLL')
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
9   format(a,i5,a,i4)
    do ispden=1,nspden
     write(message,fmt=10) "Atom", iatom,". Occ. for lpawu and for spin",&
&     ispden," =",paw_ij(iatom)%nocctot(ispden)
     call wrtout(6,message,'COLL')
10  format(a,i4,a,i3,a,f10.5)
    end do
    if(nspden==2) then
     write(message,fmt=11) "=> On atom",iatom,",  local Mag. for lpawu is  ",&
&    paw_ij(iatom)%nocctot(2)-paw_ij(iatom)%nocctot(1)
     call wrtout(6,message,'COLL')
    end if
11  format(a,i4,a,2x,e16.8)
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    write(message,'(a)') "== Occupation matrix for correlated orbitals:"
    call wrtout(6,message,'COLL')
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    do ispden=1,nspden
     write(message,fmt=12) "Occupation matrix for spin",ispden
12   format(a,i3)
     call wrtout(6,message,'COLL')
     do im1=1,pawtab(itypat)%lpawu*2+1
       write(message,fmt=13) (paw_ij(iatom)%noccmmp(im1,im2,ispden)&
&       ,im2=1,pawtab(itypat)%lpawu*2+1)
       call wrtout(6,message,'COLL')
     end do
     write(message, '(a)' )' '
     call wrtout(06,  message,'COLL')
    end do
13   format(12(1x,9(1x,f10.5)))
   if (option/=1) then
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    write(message, '(a)' )'======= LDA+U Energy terms (in Hartree) ===='
    call wrtout(06,  message,'COLL')
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    write(message, '(a,i4)' )' For Atom',iatom
    call wrtout(06,  message,'COLL')
    call pawuenergy(eldaumdc,eldaumdcdc,pawprtvol,pawtab(itypat),paw_ij(iatom),nspden)
   end if
    write(message, '(a)' )'------------------------------------------------------------------------- '
    call wrtout(06,  message,'COLL')

   deallocate(noccmmptemp)
  end if !end lda+u

! =========== End loop on atoms ============================
! ==========================================================

 end do

! ========== Assemble spherical energy terms ===============
! ==========================================================

 if (option/=1) then
  epaw  =(e1xc+half*eh2+e1t10-exccore) -(etild1xc)+eldaumdc
  epawdc=(e1xc-e1xcdc-half*eh2-exccore)-(etild1xc-etild1xcdc)+eldaumdcdc
 end if

 call timab(560,2,tsec)

!DEBUG
!write(6,*)' pawdenpot : exit '
!ENDDEBUG

end subroutine pawdenpot
!!***
