// Copyright 2019 Google LLC.
// Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.
#include "tools/fiddle/examples.h"
REG_FIDDLE(Region_Iterator_next, 256, 256, true, 0) {
void draw(SkCanvas* canvas) {
    SkRegion region;
    SkIRect rects[] = {{1, 2, 3, 4}, {5, 6, 7, 8}};
    region.setRects(rects, std::size(rects));
    SkRegion::Iterator iter(region);
    do {
        auto r2 = iter.rect();
        SkDebugf("rect={%d,%d,%d,%d}\n", r2.fLeft, r2.fTop, r2.fRight, r2.fBottom);
        iter.next();
    } while (!iter.done());
}
}  // END FIDDLE
