/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphExtract;
import org.apache.jena.graph.TripleBoundary;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StatementBoundary;

public class ModelExtract {
    protected StatementBoundary boundary;

    public ModelExtract(StatementBoundary b) {
        this.boundary = b;
    }

    public Model extract(Resource r, Model s) {
        return this.extractInto(ModelFactory.createDefaultModel(), r, s);
    }

    public Model extractInto(Model model, Resource r, Model s) {
        TripleBoundary tb = this.boundary.asTripleBoundary(s);
        Graph g = this.getGraphExtract(tb).extractInto(model.getGraph(), r.asNode(), s.getGraph());
        return ModelFactory.createModelForGraph(g);
    }

    protected GraphExtract getGraphExtract(TripleBoundary tb) {
        return new GraphExtract(tb);
    }
}

