/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterDescription;
import com.mongodb.ServerDescription;
import com.mongodb.ServerSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LatencyMinimizingServerSelector
implements ServerSelector {
    private final long acceptableLatencyDifferenceNanos;

    LatencyMinimizingServerSelector(long acceptableLatencyDifference, TimeUnit timeUnit) {
        this.acceptableLatencyDifferenceNanos = TimeUnit.NANOSECONDS.convert(acceptableLatencyDifference, timeUnit);
    }

    @Override
    public List<ServerDescription> choose(ClusterDescription clusterDescription) {
        return this.getServersWithAcceptableLatencyDifference(clusterDescription.getAll(), this.getBestLatencyNanos(clusterDescription.getAll()));
    }

    public String toString() {
        return "LatencyMinimizingServerSelector{acceptableLatencyDifference=" + TimeUnit.MILLISECONDS.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS) + " ms" + '}';
    }

    private long getBestLatencyNanos(Set<ServerDescription> members) {
        long bestPingTime = Long.MAX_VALUE;
        for (ServerDescription cur : members) {
            if (!cur.isOk() || cur.getAverageLatencyNanos() >= bestPingTime) continue;
            bestPingTime = cur.getAverageLatencyNanos();
        }
        return bestPingTime;
    }

    private List<ServerDescription> getServersWithAcceptableLatencyDifference(Set<ServerDescription> servers, long bestPingTime) {
        ArrayList<ServerDescription> goodSecondaries = new ArrayList<ServerDescription>(servers.size());
        for (ServerDescription cur : servers) {
            if (!cur.isOk() || cur.getAverageLatencyNanos() - this.acceptableLatencyDifferenceNanos > bestPingTime) continue;
            goodSecondaries.add(cur);
        }
        return goodSecondaries;
    }
}

