// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMULL_4S_4H_H_TRACE_AARCH64_H_
#define VIXL_SIM_SMULL_4S_4H_H_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smull_4S_4H_H[] = {
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0x003efe86, 0x003eff04, 0x003eff82, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00000000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x00000000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x00000000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00000000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00000000,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000001,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x0007ffe0, 0x0007fff0, 0x00000000, 0x00000010,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x003e7f06, 0x003e7f83, 0x00000000, 0x0000007d,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0x003eff04, 0x003eff82, 0x00000000, 0x0000007e,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0x003f7f02, 0x003f7f81, 0x00000000, 0x0000007f,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0x1999199a, 0x19994ccd, 0x00000000, 0x00003333,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0x2aa9d556, 0x2aaa2aab, 0x00000000, 0x00005555,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0x3ffd8006, 0x3ffe0003, 0x00000000, 0x00007ffd,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0x3ffe0004, 0x3ffe8002, 0x00000000, 0x00007ffe,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0x3ffe8002, 0x3fff0001, 0x00000000, 0x00007fff,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xc0010000, 0xc0008000, 0x00000000, 0xffff8000,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xc0017ffe, 0xc000ffff, 0x00000000, 0xffff8001,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xd555aaac, 0xd5555556, 0x00000000, 0xffffaaaa,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xe6666668, 0xe6663334, 0x00000000, 0xffffcccc,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffc00100, 0xffc00080, 0x00000000, 0xffffff80,
  0xffc080fe, 0xffc0807f, 0x00000000, 0xffffff81,
  0xffc100fc, 0xffc1007e, 0x00000000, 0xffffff82,
  0xffc180fa, 0xffc1807d, 0x00000000, 0xffffff83,
  0xfff80020, 0xfff80010, 0x00000000, 0xfffffff0,
  0xfffe8006, 0xfffe8003, 0x00000000, 0xfffffffd,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xffff8002, 0xffff8001, 0x00000000, 0xffffffff,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x0007fff0, 0x00000000, 0x00000010, 0x00000020,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x003e7f83, 0x00000000, 0x0000007d, 0x000000fa,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0x003eff82, 0x00000000, 0x0000007e, 0x000000fc,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0x003f7f81, 0x00000000, 0x0000007f, 0x000000fe,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0x19994ccd, 0x00000000, 0x00003333, 0x00006666,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0x2aaa2aab, 0x00000000, 0x00005555, 0x0000aaaa,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0x3ffe0003, 0x00000000, 0x00007ffd, 0x0000fffa,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0x3ffe8002, 0x00000000, 0x00007ffe, 0x0000fffc,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0x3fff0001, 0x00000000, 0x00007fff, 0x0000fffe,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xc0008000, 0x00000000, 0xffff8000, 0xffff0000,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xc000ffff, 0x00000000, 0xffff8001, 0xffff0002,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xd5555556, 0x00000000, 0xffffaaaa, 0xffff5554,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xe6663334, 0x00000000, 0xffffcccc, 0xffff9998,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffc00080, 0x00000000, 0xffffff80, 0xffffff00,
  0xffc0807f, 0x00000000, 0xffffff81, 0xffffff02,
  0xffc1007e, 0x00000000, 0xffffff82, 0xffffff04,
  0xffc1807d, 0x00000000, 0xffffff83, 0xffffff06,
  0xfff80010, 0x00000000, 0xfffffff0, 0xffffffe0,
  0xfffe8003, 0x00000000, 0xfffffffd, 0xfffffffa,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0xffff8001, 0x00000000, 0xffffffff, 0xfffffffe,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00000001, 0x00000002, 0x00000010,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00000010, 0x00000020, 0x00000100,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x0000007d, 0x000000fa, 0x000007d0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007e0,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0x0000007f, 0x000000fe, 0x000007f0,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0x00003333, 0x00006666, 0x00033330,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0x00005555, 0x0000aaaa, 0x00055550,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0x00007ffd, 0x0000fffa, 0x0007ffd0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007ffe0,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0x00007fff, 0x0000fffe, 0x0007fff0,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffff8000, 0xffff0000, 0xfff80000,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80010,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xffffaaaa, 0xffff5554, 0xfffaaaa0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xffffcccc, 0xffff9998, 0xfffcccc0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffff80, 0xffffff00, 0xfffff800,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff810,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff820,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff830,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffff00,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0xffffffff, 0xfffffffe, 0xfffffff0,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00000001, 0x00000002, 0x00000010, 0x0000007d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00000010, 0x00000020, 0x00000100, 0x000007d0,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x0000007d, 0x000000fa, 0x000007d0, 0x00003d09,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0x0000007e, 0x000000fc, 0x000007e0, 0x00003d86,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0x0000007f, 0x000000fe, 0x000007f0, 0x00003e03,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0x00003333, 0x00006666, 0x00033330, 0x0018ffe7,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0x00005555, 0x0000aaaa, 0x00055550, 0x0029aa81,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0x00007ffd, 0x0000fffa, 0x0007ffd0, 0x003e7e89,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0x00007ffe, 0x0000fffc, 0x0007ffe0, 0x003e7f06,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0x00007fff, 0x0000fffe, 0x0007fff0, 0x003e7f83,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffff8000, 0xffff0000, 0xfff80000, 0xffc18000,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xffff8001, 0xffff0002, 0xfff80010, 0xffc1807d,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xffffaaaa, 0xffff5554, 0xfffaaaa0, 0xffd65502,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xffffcccc, 0xffff9998, 0xfffcccc0, 0xffe6ff9c,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffff80, 0xffffff00, 0xfffff800, 0xffffc180,
  0xffffff81, 0xffffff02, 0xfffff810, 0xffffc1fd,
  0xffffff82, 0xffffff04, 0xfffff820, 0xffffc27a,
  0xffffff83, 0xffffff06, 0xfffff830, 0xffffc2f7,
  0xfffffff0, 0xffffffe0, 0xffffff00, 0xfffff830,
  0xfffffffd, 0xfffffffa, 0xffffffd0, 0xfffffe89,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xffffffff, 0xfffffffe, 0xfffffff0, 0xffffff83,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x00000002, 0x00000010, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x00000020, 0x00000100, 0x000007d0, 0x000007e0,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x000000fa, 0x000007d0, 0x00003d09, 0x00003d86,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0x000000fc, 0x000007e0, 0x00003d86, 0x00003e04,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0x000000fe, 0x000007f0, 0x00003e03, 0x00003e82,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0x00006666, 0x00033330, 0x0018ffe7, 0x0019331a,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0x0000aaaa, 0x00055550, 0x0029aa81, 0x0029ffd6,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0x0000fffa, 0x0007ffd0, 0x003e7e89, 0x003efe86,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0x0000fffc, 0x0007ffe0, 0x003e7f06, 0x003eff04,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0x0000fffe, 0x0007fff0, 0x003e7f83, 0x003eff82,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffff0000, 0xfff80000, 0xffc18000, 0xffc10000,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffff0002, 0xfff80010, 0xffc1807d, 0xffc1007e,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xffff5554, 0xfffaaaa0, 0xffd65502, 0xffd5ffac,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xffff9998, 0xfffcccc0, 0xffe6ff9c, 0xffe6cc68,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xffffff00, 0xfffff800, 0xffffc180, 0xffffc100,
  0xffffff02, 0xfffff810, 0xffffc1fd, 0xffffc17e,
  0xffffff04, 0xfffff820, 0xffffc27a, 0xffffc1fc,
  0xffffff06, 0xfffff830, 0xffffc2f7, 0xffffc27a,
  0xffffffe0, 0xffffff00, 0xfffff830, 0xfffff820,
  0xfffffffa, 0xffffffd0, 0xfffffe89, 0xfffffe86,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffffffe, 0xfffffff0, 0xffffff83, 0xffffff82,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x00000100, 0x000007d0, 0x000007e0, 0x000007f0,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x000007d0, 0x00003d09, 0x00003d86, 0x00003e03,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0x000007e0, 0x00003d86, 0x00003e04, 0x00003e82,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0x000007f0, 0x00003e03, 0x00003e82, 0x00003f01,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0x00033330, 0x0018ffe7, 0x0019331a, 0x0019664d,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0x00055550, 0x0029aa81, 0x0029ffd6, 0x002a552b,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0x0007ffd0, 0x003e7e89, 0x003efe86, 0x003f7e83,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0x0007ffe0, 0x003e7f06, 0x003eff04, 0x003f7f02,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0x0007fff0, 0x003e7f83, 0x003eff82, 0x003f7f81,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfff80000, 0xffc18000, 0xffc10000, 0xffc08000,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xfff80010, 0xffc1807d, 0xffc1007e, 0xffc0807f,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xfffaaaa0, 0xffd65502, 0xffd5ffac, 0xffd5aa56,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xfffcccc0, 0xffe6ff9c, 0xffe6cc68, 0xffe69934,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffff800, 0xffffc180, 0xffffc100, 0xffffc080,
  0xfffff810, 0xffffc1fd, 0xffffc17e, 0xffffc0ff,
  0xfffff820, 0xffffc27a, 0xffffc1fc, 0xffffc17e,
  0xfffff830, 0xffffc2f7, 0xffffc27a, 0xffffc1fd,
  0xffffff00, 0xfffff830, 0xfffff820, 0xfffff810,
  0xffffffd0, 0xfffffe89, 0xfffffe86, 0xfffffe83,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xfffffff0, 0xffffff83, 0xffffff82, 0xffffff81,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003333,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x000007d0, 0x000007e0, 0x000007f0, 0x00033330,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x00003d09, 0x00003d86, 0x00003e03, 0x0018ffe7,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0x00003d86, 0x00003e04, 0x00003e82, 0x0019331a,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0x00003e03, 0x00003e82, 0x00003f01, 0x0019664d,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0x0018ffe7, 0x0019331a, 0x0019664d, 0x0a3d5c29,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0x0029aa81, 0x0029ffd6, 0x002a552b, 0x1110eeef,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0x003e7e89, 0x003efe86, 0x003f7e83, 0x1998e667,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0x003e7f06, 0x003eff04, 0x003f7f02, 0x1999199a,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0x003e7f83, 0x003eff82, 0x003f7f81, 0x19994ccd,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffc18000, 0xffc10000, 0xffc08000, 0xe6668000,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xffc1807d, 0xffc1007e, 0xffc0807f, 0xe666b333,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xffd65502, 0xffd5ffac, 0xffd5aa56, 0xeeeeddde,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffe6ff9c, 0xffe6cc68, 0xffe69934, 0xf5c270a4,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffc180, 0xffffc100, 0xffffc080, 0xffe66680,
  0xffffc1fd, 0xffffc17e, 0xffffc0ff, 0xffe699b3,
  0xffffc27a, 0xffffc1fc, 0xffffc17e, 0xffe6cce6,
  0xffffc2f7, 0xffffc27a, 0xffffc1fd, 0xffe70019,
  0xfffff830, 0xfffff820, 0xfffff810, 0xfffcccd0,
  0xfffffe89, 0xfffffe86, 0xfffffe83, 0xffff6667,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffffff83, 0xffffff82, 0xffffff81, 0xffffcccd,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005555,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x000007e0, 0x000007f0, 0x00033330, 0x00055550,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x00003d86, 0x00003e03, 0x0018ffe7, 0x0029aa81,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0x00003e04, 0x00003e82, 0x0019331a, 0x0029ffd6,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0x00003e82, 0x00003f01, 0x0019664d, 0x002a552b,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0x0019331a, 0x0019664d, 0x0a3d5c29, 0x1110eeef,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0x0029ffd6, 0x002a552b, 0x1110eeef, 0x1c718e39,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0x003efe86, 0x003f7e83, 0x1998e667, 0x2aa98001,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0x003eff04, 0x003f7f02, 0x1999199a, 0x2aa9d556,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0x003eff82, 0x003f7f81, 0x19994ccd, 0x2aaa2aab,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffc10000, 0xffc08000, 0xe6668000, 0xd5558000,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xffc1007e, 0xffc0807f, 0xe666b333, 0xd555d555,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xffd5ffac, 0xffd5aa56, 0xeeeeddde, 0xe38e1c72,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffe6cc68, 0xffe69934, 0xf5c270a4, 0xeeeebbbc,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffc100, 0xffffc080, 0xffe66680, 0xffd55580,
  0xffffc17e, 0xffffc0ff, 0xffe699b3, 0xffd5aad5,
  0xffffc1fc, 0xffffc17e, 0xffe6cce6, 0xffd6002a,
  0xffffc27a, 0xffffc1fd, 0xffe70019, 0xffd6557f,
  0xfffff820, 0xfffff810, 0xfffcccd0, 0xfffaaab0,
  0xfffffe86, 0xfffffe83, 0xffff6667, 0xffff0001,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffffff82, 0xffffff81, 0xffffcccd, 0xffffaaab,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x0000007f, 0x00003333, 0x00005555, 0x00007ffd,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x000007f0, 0x00033330, 0x00055550, 0x0007ffd0,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x00003e03, 0x0018ffe7, 0x0029aa81, 0x003e7e89,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0x00003e82, 0x0019331a, 0x0029ffd6, 0x003efe86,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0x00003f01, 0x0019664d, 0x002a552b, 0x003f7e83,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0x0019664d, 0x0a3d5c29, 0x1110eeef, 0x1998e667,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0x002a552b, 0x1110eeef, 0x1c718e39, 0x2aa98001,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0x003f7e83, 0x1998e667, 0x2aa98001, 0x3ffd0009,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0x003f7f02, 0x1999199a, 0x2aa9d556, 0x3ffd8006,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0x003f7f81, 0x19994ccd, 0x2aaa2aab, 0x3ffe0003,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffc08000, 0xe6668000, 0xd5558000, 0xc0018000,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xffc0807f, 0xe666b333, 0xd555d555, 0xc001fffd,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xffd5aa56, 0xeeeeddde, 0xe38e1c72, 0xd5560002,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffe69934, 0xf5c270a4, 0xeeeebbbc, 0xe666999c,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffc080, 0xffe66680, 0xffd55580, 0xffc00180,
  0xffffc0ff, 0xffe699b3, 0xffd5aad5, 0xffc0817d,
  0xffffc17e, 0xffe6cce6, 0xffd6002a, 0xffc1017a,
  0xffffc1fd, 0xffe70019, 0xffd6557f, 0xffc18177,
  0xfffff810, 0xfffcccd0, 0xfffaaab0, 0xfff80030,
  0xfffffe83, 0xffff6667, 0xffff0001, 0xfffe8009,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffffff81, 0xffffcccd, 0xffffaaab, 0xffff8003,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x00003333, 0x00005555, 0x00007ffd, 0x00007ffe,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x00033330, 0x00055550, 0x0007ffd0, 0x0007ffe0,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x0018ffe7, 0x0029aa81, 0x003e7e89, 0x003e7f06,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0x0019331a, 0x0029ffd6, 0x003efe86, 0x003eff04,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0x0019664d, 0x002a552b, 0x003f7e83, 0x003f7f02,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0x0a3d5c29, 0x1110eeef, 0x1998e667, 0x1999199a,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0x1110eeef, 0x1c718e39, 0x2aa98001, 0x2aa9d556,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0x1998e667, 0x2aa98001, 0x3ffd0009, 0x3ffd8006,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0x1999199a, 0x2aa9d556, 0x3ffd8006, 0x3ffe0004,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0x19994ccd, 0x2aaa2aab, 0x3ffe0003, 0x3ffe8002,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xe6668000, 0xd5558000, 0xc0018000, 0xc0010000,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xe666b333, 0xd555d555, 0xc001fffd, 0xc0017ffe,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xeeeeddde, 0xe38e1c72, 0xd5560002, 0xd555aaac,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xf5c270a4, 0xeeeebbbc, 0xe666999c, 0xe6666668,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffe66680, 0xffd55580, 0xffc00180, 0xffc00100,
  0xffe699b3, 0xffd5aad5, 0xffc0817d, 0xffc080fe,
  0xffe6cce6, 0xffd6002a, 0xffc1017a, 0xffc100fc,
  0xffe70019, 0xffd6557f, 0xffc18177, 0xffc180fa,
  0xfffcccd0, 0xfffaaab0, 0xfff80030, 0xfff80020,
  0xffff6667, 0xffff0001, 0xfffe8009, 0xfffe8006,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffffcccd, 0xffffaaab, 0xffff8003, 0xffff8002,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x00055550, 0x0007ffd0, 0x0007ffe0, 0x0007fff0,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x0029aa81, 0x003e7e89, 0x003e7f06, 0x003e7f83,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0x0029ffd6, 0x003efe86, 0x003eff04, 0x003eff82,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0x002a552b, 0x003f7e83, 0x003f7f02, 0x003f7f81,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0x1110eeef, 0x1998e667, 0x1999199a, 0x19994ccd,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0x1c718e39, 0x2aa98001, 0x2aa9d556, 0x2aaa2aab,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0x2aa98001, 0x3ffd0009, 0x3ffd8006, 0x3ffe0003,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0x2aa9d556, 0x3ffd8006, 0x3ffe0004, 0x3ffe8002,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0x2aaa2aab, 0x3ffe0003, 0x3ffe8002, 0x3fff0001,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xd5558000, 0xc0018000, 0xc0010000, 0xc0008000,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xd555d555, 0xc001fffd, 0xc0017ffe, 0xc000ffff,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xe38e1c72, 0xd5560002, 0xd555aaac, 0xd5555556,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xeeeebbbc, 0xe666999c, 0xe6666668, 0xe6663334,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffd55580, 0xffc00180, 0xffc00100, 0xffc00080,
  0xffd5aad5, 0xffc0817d, 0xffc080fe, 0xffc0807f,
  0xffd6002a, 0xffc1017a, 0xffc100fc, 0xffc1007e,
  0xffd6557f, 0xffc18177, 0xffc180fa, 0xffc1807d,
  0xfffaaab0, 0xfff80030, 0xfff80020, 0xfff80010,
  0xffff0001, 0xfffe8009, 0xfffe8006, 0xfffe8003,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xffffaaab, 0xffff8003, 0xffff8002, 0xffff8001,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x0007ffd0, 0x0007ffe0, 0x0007fff0, 0xfff80000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x003e7e89, 0x003e7f06, 0x003e7f83, 0xffc18000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0x003efe86, 0x003eff04, 0x003eff82, 0xffc10000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0x003f7e83, 0x003f7f02, 0x003f7f81, 0xffc08000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0x1998e667, 0x1999199a, 0x19994ccd, 0xe6668000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0x2aa98001, 0x2aa9d556, 0x2aaa2aab, 0xd5558000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0x3ffd0009, 0x3ffd8006, 0x3ffe0003, 0xc0018000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0x3ffd8006, 0x3ffe0004, 0x3ffe8002, 0xc0010000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0x3ffe0003, 0x3ffe8002, 0x3fff0001, 0xc0008000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xc0018000, 0xc0010000, 0xc0008000, 0x40000000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xc001fffd, 0xc0017ffe, 0xc000ffff, 0x3fff8000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xd5560002, 0xd555aaac, 0xd5555556, 0x2aab0000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xe666999c, 0xe6666668, 0xe6663334, 0x199a0000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffc00180, 0xffc00100, 0xffc00080, 0x00400000,
  0xffc0817d, 0xffc080fe, 0xffc0807f, 0x003f8000,
  0xffc1017a, 0xffc100fc, 0xffc1007e, 0x003f0000,
  0xffc18177, 0xffc180fa, 0xffc1807d, 0x003e8000,
  0xfff80030, 0xfff80020, 0xfff80010, 0x00080000,
  0xfffe8009, 0xfffe8006, 0xfffe8003, 0x00018000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xffff8003, 0xffff8002, 0xffff8001, 0x00008000,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x00007ffe, 0x00007fff, 0xffff8000, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x0007ffe0, 0x0007fff0, 0xfff80000, 0xfff80010,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x003e7f06, 0x003e7f83, 0xffc18000, 0xffc1807d,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0x003eff04, 0x003eff82, 0xffc10000, 0xffc1007e,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0x003f7f02, 0x003f7f81, 0xffc08000, 0xffc0807f,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0x1999199a, 0x19994ccd, 0xe6668000, 0xe666b333,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0x2aa9d556, 0x2aaa2aab, 0xd5558000, 0xd555d555,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0x3ffd8006, 0x3ffe0003, 0xc0018000, 0xc001fffd,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0x3ffe0004, 0x3ffe8002, 0xc0010000, 0xc0017ffe,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0x3ffe8002, 0x3fff0001, 0xc0008000, 0xc000ffff,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xc0010000, 0xc0008000, 0x40000000, 0x3fff8000,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xc0017ffe, 0xc000ffff, 0x3fff8000, 0x3fff0001,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xd555aaac, 0xd5555556, 0x2aab0000, 0x2aaaaaaa,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xe6666668, 0xe6663334, 0x199a0000, 0x1999cccc,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffc00100, 0xffc00080, 0x00400000, 0x003fff80,
  0xffc080fe, 0xffc0807f, 0x003f8000, 0x003f7f81,
  0xffc100fc, 0xffc1007e, 0x003f0000, 0x003eff82,
  0xffc180fa, 0xffc1807d, 0x003e8000, 0x003e7f83,
  0xfff80020, 0xfff80010, 0x00080000, 0x0007fff0,
  0xfffe8006, 0xfffe8003, 0x00018000, 0x00017ffd,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xffff8002, 0xffff8001, 0x00008000, 0x00007fff,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x00007fff, 0xffff8000, 0xffff8001, 0xffffaaaa,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x0007fff0, 0xfff80000, 0xfff80010, 0xfffaaaa0,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x003e7f83, 0xffc18000, 0xffc1807d, 0xffd65502,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0x003eff82, 0xffc10000, 0xffc1007e, 0xffd5ffac,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0x003f7f81, 0xffc08000, 0xffc0807f, 0xffd5aa56,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0x19994ccd, 0xe6668000, 0xe666b333, 0xeeeeddde,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0x2aaa2aab, 0xd5558000, 0xd555d555, 0xe38e1c72,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0x3ffe0003, 0xc0018000, 0xc001fffd, 0xd5560002,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0x3ffe8002, 0xc0010000, 0xc0017ffe, 0xd555aaac,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0x3fff0001, 0xc0008000, 0xc000ffff, 0xd5555556,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xc0008000, 0x40000000, 0x3fff8000, 0x2aab0000,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xc000ffff, 0x3fff8000, 0x3fff0001, 0x2aaaaaaa,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xd5555556, 0x2aab0000, 0x2aaaaaaa, 0x1c7238e4,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xe6663334, 0x199a0000, 0x1999cccc, 0x11117778,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffc00080, 0x00400000, 0x003fff80, 0x002aab00,
  0xffc0807f, 0x003f8000, 0x003f7f81, 0x002a55aa,
  0xffc1007e, 0x003f0000, 0x003eff82, 0x002a0054,
  0xffc1807d, 0x003e8000, 0x003e7f83, 0x0029aafe,
  0xfff80010, 0x00080000, 0x0007fff0, 0x00055560,
  0xfffe8003, 0x00018000, 0x00017ffd, 0x00010002,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0xffff8001, 0x00008000, 0x00007fff, 0x00005556,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xffff8000, 0xffff8001, 0xffffaaaa, 0xffffcccc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xfff80000, 0xfff80010, 0xfffaaaa0, 0xfffcccc0,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xffc18000, 0xffc1807d, 0xffd65502, 0xffe6ff9c,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0xffc10000, 0xffc1007e, 0xffd5ffac, 0xffe6cc68,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0xffc08000, 0xffc0807f, 0xffd5aa56, 0xffe69934,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0xe6668000, 0xe666b333, 0xeeeeddde, 0xf5c270a4,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0xd5558000, 0xd555d555, 0xe38e1c72, 0xeeeebbbc,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0xc0018000, 0xc001fffd, 0xd5560002, 0xe666999c,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0xc0010000, 0xc0017ffe, 0xd555aaac, 0xe6666668,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0xc0008000, 0xc000ffff, 0xd5555556, 0xe6663334,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x40000000, 0x3fff8000, 0x2aab0000, 0x199a0000,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x3fff8000, 0x3fff0001, 0x2aaaaaaa, 0x1999cccc,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x2aab0000, 0x2aaaaaaa, 0x1c7238e4, 0x11117778,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x199a0000, 0x1999cccc, 0x11117778, 0x0a3dc290,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00400000, 0x003fff80, 0x002aab00, 0x00199a00,
  0x003f8000, 0x003f7f81, 0x002a55aa, 0x001966cc,
  0x003f0000, 0x003eff82, 0x002a0054, 0x00193398,
  0x003e8000, 0x003e7f83, 0x0029aafe, 0x00190064,
  0x00080000, 0x0007fff0, 0x00055560, 0x00033340,
  0x00018000, 0x00017ffd, 0x00010002, 0x0000999c,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00008000, 0x00007fff, 0x00005556, 0x00003334,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xffff8001, 0xffffaaaa, 0xffffcccc, 0xffffff80,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xfff80010, 0xfffaaaa0, 0xfffcccc0, 0xfffff800,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xffc1807d, 0xffd65502, 0xffe6ff9c, 0xffffc180,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0xffc1007e, 0xffd5ffac, 0xffe6cc68, 0xffffc100,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0xffc0807f, 0xffd5aa56, 0xffe69934, 0xffffc080,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0xe666b333, 0xeeeeddde, 0xf5c270a4, 0xffe66680,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0xd555d555, 0xe38e1c72, 0xeeeebbbc, 0xffd55580,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0xc001fffd, 0xd5560002, 0xe666999c, 0xffc00180,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0xc0017ffe, 0xd555aaac, 0xe6666668, 0xffc00100,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0xc000ffff, 0xd5555556, 0xe6663334, 0xffc00080,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x3fff8000, 0x2aab0000, 0x199a0000, 0x00400000,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x3fff0001, 0x2aaaaaaa, 0x1999cccc, 0x003fff80,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x2aaaaaaa, 0x1c7238e4, 0x11117778, 0x002aab00,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x1999cccc, 0x11117778, 0x0a3dc290, 0x00199a00,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x003fff80, 0x002aab00, 0x00199a00, 0x00004000,
  0x003f7f81, 0x002a55aa, 0x001966cc, 0x00003f80,
  0x003eff82, 0x002a0054, 0x00193398, 0x00003f00,
  0x003e7f83, 0x0029aafe, 0x00190064, 0x00003e80,
  0x0007fff0, 0x00055560, 0x00033340, 0x00000800,
  0x00017ffd, 0x00010002, 0x0000999c, 0x00000180,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00007fff, 0x00005556, 0x00003334, 0x00000080,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xffffaaaa, 0xffffcccc, 0xffffff80, 0xffffff81,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xfffaaaa0, 0xfffcccc0, 0xfffff800, 0xfffff810,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xffd65502, 0xffe6ff9c, 0xffffc180, 0xffffc1fd,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0xffd5ffac, 0xffe6cc68, 0xffffc100, 0xffffc17e,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0xffd5aa56, 0xffe69934, 0xffffc080, 0xffffc0ff,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0xeeeeddde, 0xf5c270a4, 0xffe66680, 0xffe699b3,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0xe38e1c72, 0xeeeebbbc, 0xffd55580, 0xffd5aad5,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0xd5560002, 0xe666999c, 0xffc00180, 0xffc0817d,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0xd555aaac, 0xe6666668, 0xffc00100, 0xffc080fe,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0xd5555556, 0xe6663334, 0xffc00080, 0xffc0807f,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x2aab0000, 0x199a0000, 0x00400000, 0x003f8000,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x2aaaaaaa, 0x1999cccc, 0x003fff80, 0x003f7f81,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x1c7238e4, 0x11117778, 0x002aab00, 0x002a55aa,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x11117778, 0x0a3dc290, 0x00199a00, 0x001966cc,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x002aab00, 0x00199a00, 0x00004000, 0x00003f80,
  0x002a55aa, 0x001966cc, 0x00003f80, 0x00003f01,
  0x002a0054, 0x00193398, 0x00003f00, 0x00003e82,
  0x0029aafe, 0x00190064, 0x00003e80, 0x00003e03,
  0x00055560, 0x00033340, 0x00000800, 0x000007f0,
  0x00010002, 0x0000999c, 0x00000180, 0x0000017d,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00005556, 0x00003334, 0x00000080, 0x0000007f,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xffffcccc, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xfffcccc0, 0xfffff800, 0xfffff810, 0xfffff820,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xffe6ff9c, 0xffffc180, 0xffffc1fd, 0xffffc27a,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0xffe6cc68, 0xffffc100, 0xffffc17e, 0xffffc1fc,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0xffe69934, 0xffffc080, 0xffffc0ff, 0xffffc17e,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0xf5c270a4, 0xffe66680, 0xffe699b3, 0xffe6cce6,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0xeeeebbbc, 0xffd55580, 0xffd5aad5, 0xffd6002a,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0xe666999c, 0xffc00180, 0xffc0817d, 0xffc1017a,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0xe6666668, 0xffc00100, 0xffc080fe, 0xffc100fc,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0xe6663334, 0xffc00080, 0xffc0807f, 0xffc1007e,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x199a0000, 0x00400000, 0x003f8000, 0x003f0000,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x1999cccc, 0x003fff80, 0x003f7f81, 0x003eff82,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x11117778, 0x002aab00, 0x002a55aa, 0x002a0054,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x0a3dc290, 0x00199a00, 0x001966cc, 0x00193398,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00199a00, 0x00004000, 0x00003f80, 0x00003f00,
  0x001966cc, 0x00003f80, 0x00003f01, 0x00003e82,
  0x00193398, 0x00003f00, 0x00003e82, 0x00003e04,
  0x00190064, 0x00003e80, 0x00003e03, 0x00003d86,
  0x00033340, 0x00000800, 0x000007f0, 0x000007e0,
  0x0000999c, 0x00000180, 0x0000017d, 0x0000017a,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00003334, 0x00000080, 0x0000007f, 0x0000007e,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xfffff800, 0xfffff810, 0xfffff820, 0xfffff830,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffffc180, 0xffffc1fd, 0xffffc27a, 0xffffc2f7,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0xffffc100, 0xffffc17e, 0xffffc1fc, 0xffffc27a,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0xffffc080, 0xffffc0ff, 0xffffc17e, 0xffffc1fd,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0xffe66680, 0xffe699b3, 0xffe6cce6, 0xffe70019,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0xffd55580, 0xffd5aad5, 0xffd6002a, 0xffd6557f,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0xffc00180, 0xffc0817d, 0xffc1017a, 0xffc18177,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0xffc00100, 0xffc080fe, 0xffc100fc, 0xffc180fa,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0xffc00080, 0xffc0807f, 0xffc1007e, 0xffc1807d,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00400000, 0x003f8000, 0x003f0000, 0x003e8000,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x003fff80, 0x003f7f81, 0x003eff82, 0x003e7f83,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x002aab00, 0x002a55aa, 0x002a0054, 0x0029aafe,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00199a00, 0x001966cc, 0x00193398, 0x00190064,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00004000, 0x00003f80, 0x00003f00, 0x00003e80,
  0x00003f80, 0x00003f01, 0x00003e82, 0x00003e03,
  0x00003f00, 0x00003e82, 0x00003e04, 0x00003d86,
  0x00003e80, 0x00003e03, 0x00003d86, 0x00003d09,
  0x00000800, 0x000007f0, 0x000007e0, 0x000007d0,
  0x00000180, 0x0000017d, 0x0000017a, 0x00000177,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000080, 0x0000007f, 0x0000007e, 0x0000007d,
};
const unsigned kExpectedCount_NEON_smull_4S_4H_H = 4608;

#endif  // VIXL_SIM_SMULL_4S_4H_H_TRACE_AARCH64_H_
