#include "mathdefs.h"
using std::pow;
using std::floor;

// roundoff examples:	roundoff(375.25, 1) == 375.3
//			roundoff(375.25, -1) == 380.0

// sigdigits examples:	sigdigits(375.25, 1) == 400.0
//			sigdigits(375.25, 4) == 375.3
double
starmath::sigdigits(double value, int numdigits)
{
  if (value == 0.0 || numdigits == 0)
    return 0.0;
  else if (numdigits < 0)
    return value;

  int exponent = FLOOR(std::log10(std::fabs(value)));
  return starmath::roundoff(value, numdigits - exponent - 1);
}

