// Keycodes from <linux/input-event-codes.h>

pub const KEY_RESERVED: u32 = 0;
pub const KEY_ESC: u32 = 1;
pub const KEY_1: u32 = 2;
pub const KEY_2: u32 = 3;
pub const KEY_3: u32 = 4;
pub const KEY_4: u32 = 5;
pub const KEY_5: u32 = 6;
pub const KEY_6: u32 = 7;
pub const KEY_7: u32 = 8;
pub const KEY_8: u32 = 9;
pub const KEY_9: u32 = 10;
pub const KEY_0: u32 = 11;
pub const KEY_MINUS: u32 = 12;
pub const KEY_EQUAL: u32 = 13;
pub const KEY_BACKSPACE: u32 = 14;
pub const KEY_TAB: u32 = 15;
pub const KEY_Q: u32 = 16;
pub const KEY_W: u32 = 17;
pub const KEY_E: u32 = 18;
pub const KEY_R: u32 = 19;
pub const KEY_T: u32 = 20;
pub const KEY_Y: u32 = 21;
pub const KEY_U: u32 = 22;
pub const KEY_I: u32 = 23;
pub const KEY_O: u32 = 24;
pub const KEY_P: u32 = 25;
pub const KEY_LEFTBRACE: u32 = 26;
pub const KEY_RIGHTBRACE: u32 = 27;
pub const KEY_ENTER: u32 = 28;
pub const KEY_LEFTCTRL: u32 = 29;
pub const KEY_A: u32 = 30;
pub const KEY_S: u32 = 31;
pub const KEY_D: u32 = 32;
pub const KEY_F: u32 = 33;
pub const KEY_G: u32 = 34;
pub const KEY_H: u32 = 35;
pub const KEY_J: u32 = 36;
pub const KEY_K: u32 = 37;
pub const KEY_L: u32 = 38;
pub const KEY_SEMICOLON: u32 = 39;
pub const KEY_APOSTROPHE: u32 = 40;
pub const KEY_GRAVE: u32 = 41;
pub const KEY_LEFTSHIFT: u32 = 42;
pub const KEY_BACKSLASH: u32 = 43;
pub const KEY_Z: u32 = 44;
pub const KEY_X: u32 = 45;
pub const KEY_C: u32 = 46;
pub const KEY_V: u32 = 47;
pub const KEY_B: u32 = 48;
pub const KEY_N: u32 = 49;
pub const KEY_M: u32 = 50;
pub const KEY_COMMA: u32 = 51;
pub const KEY_DOT: u32 = 52;
pub const KEY_SLASH: u32 = 53;
pub const KEY_RIGHTSHIFT: u32 = 54;
pub const KEY_KPASTERISK: u32 = 55;
pub const KEY_LEFTALT: u32 = 56;
pub const KEY_SPACE: u32 = 57;
pub const KEY_CAPSLOCK: u32 = 58;
pub const KEY_F1: u32 = 59;
pub const KEY_F2: u32 = 60;
pub const KEY_F3: u32 = 61;
pub const KEY_F4: u32 = 62;
pub const KEY_F5: u32 = 63;
pub const KEY_F6: u32 = 64;
pub const KEY_F7: u32 = 65;
pub const KEY_F8: u32 = 66;
pub const KEY_F9: u32 = 67;
pub const KEY_F10: u32 = 68;
pub const KEY_NUMLOCK: u32 = 69;
pub const KEY_SCROLLLOCK: u32 = 70;
pub const KEY_KP7: u32 = 71;
pub const KEY_KP8: u32 = 72;
pub const KEY_KP9: u32 = 73;
pub const KEY_KPMINUS: u32 = 74;
pub const KEY_KP4: u32 = 75;
pub const KEY_KP5: u32 = 76;
pub const KEY_KP6: u32 = 77;
pub const KEY_KPPLUS: u32 = 78;
pub const KEY_KP1: u32 = 79;
pub const KEY_KP2: u32 = 80;
pub const KEY_KP3: u32 = 81;
pub const KEY_KP0: u32 = 82;
pub const KEY_KPDOT: u32 = 83;

pub const KEY_ZENKAKUHANKAKU: u32 = 85;
pub const KEY_102ND: u32 = 86;
pub const KEY_F11: u32 = 87;
pub const KEY_F12: u32 = 88;
pub const KEY_RO: u32 = 89;
pub const KEY_KATAKANA: u32 = 90;
pub const KEY_HIRAGANA: u32 = 91;
pub const KEY_HENKAN: u32 = 92;
pub const KEY_KATAKANAHIRAGANA: u32 = 93;
pub const KEY_MUHENKAN: u32 = 94;
pub const KEY_KPJPCOMMA: u32 = 95;
pub const KEY_KPENTER: u32 = 96;
pub const KEY_RIGHTCTRL: u32 = 97;
pub const KEY_KPSLASH: u32 = 98;
pub const KEY_SYSRQ: u32 = 99;
pub const KEY_RIGHTALT: u32 = 100;
pub const KEY_LINEFEED: u32 = 101;
pub const KEY_HOME: u32 = 102;
pub const KEY_UP: u32 = 103;
pub const KEY_PAGEUP: u32 = 104;
pub const KEY_LEFT: u32 = 105;
pub const KEY_RIGHT: u32 = 106;
pub const KEY_END: u32 = 107;
pub const KEY_DOWN: u32 = 108;
pub const KEY_PAGEDOWN: u32 = 109;
pub const KEY_INSERT: u32 = 110;
pub const KEY_DELETE: u32 = 111;
pub const KEY_MACRO: u32 = 112;
pub const KEY_MUTE: u32 = 113;
pub const KEY_VOLUMEDOWN: u32 = 114;
pub const KEY_VOLUMEUP: u32 = 115;
pub const KEY_POWER: u32 = 116;
pub const KEY_KPEQUAL: u32 = 117;
pub const KEY_KPPLUSMINUS: u32 = 118;
pub const KEY_PAUSE: u32 = 119;
pub const KEY_SCALE: u32 = 120;

pub const KEY_KPCOMMA: u32 = 121;
pub const KEY_HANGEUL: u32 = 122;
pub const KEY_HANGUEL: u32 = KEY_HANGEUL;
pub const KEY_HANJA: u32 = 123;
pub const KEY_YEN: u32 = 124;
pub const KEY_LEFTMETA: u32 = 125;
pub const KEY_RIGHTMETA: u32 = 126;
pub const KEY_COMPOSE: u32 = 127;

pub const KEY_STOP: u32 = 128;
pub const KEY_AGAIN: u32 = 129;
pub const KEY_PROPS: u32 = 130;
pub const KEY_UNDO: u32 = 131;
pub const KEY_FRONT: u32 = 132;
pub const KEY_COPY: u32 = 133;
pub const KEY_OPEN: u32 = 134;
pub const KEY_PASTE: u32 = 135;
pub const KEY_FIND: u32 = 136;
pub const KEY_CUT: u32 = 137;
pub const KEY_HELP: u32 = 138;
pub const KEY_MENU: u32 = 139;
pub const KEY_CALC: u32 = 140;
pub const KEY_SETUP: u32 = 141;
pub const KEY_SLEEP: u32 = 142;
pub const KEY_WAKEUP: u32 = 143;
pub const KEY_FILE: u32 = 144;
pub const KEY_SENDFILE: u32 = 145;
pub const KEY_DELETEFILE: u32 = 146;
pub const KEY_XFER: u32 = 147;
pub const KEY_PROG1: u32 = 148;
pub const KEY_PROG2: u32 = 149;
pub const KEY_WWW: u32 = 150;
pub const KEY_MSDOS: u32 = 151;
pub const KEY_COFFEE: u32 = 152;
pub const KEY_SCREENLOCK: u32 = KEY_COFFEE;
pub const KEY_ROTATE_DISPLAY: u32 = 153;
pub const KEY_DIRECTION: u32 = KEY_ROTATE_DISPLAY;
pub const KEY_CYCLEWINDOWS: u32 = 154;
pub const KEY_MAIL: u32 = 155;
pub const KEY_BOOKMARKS: u32 = 156;
pub const KEY_COMPUTER: u32 = 157;
pub const KEY_BACK: u32 = 158;
pub const KEY_FORWARD: u32 = 159;
pub const KEY_CLOSECD: u32 = 160;
pub const KEY_EJECTCD: u32 = 161;
pub const KEY_EJECTCLOSECD: u32 = 162;
pub const KEY_NEXTSONG: u32 = 163;
pub const KEY_PLAYPAUSE: u32 = 164;
pub const KEY_PREVIOUSSONG: u32 = 165;
pub const KEY_STOPCD: u32 = 166;
pub const KEY_RECORD: u32 = 167;
pub const KEY_REWIND: u32 = 168;
pub const KEY_PHONE: u32 = 169;
pub const KEY_ISO: u32 = 170;
pub const KEY_CONFIG: u32 = 171;
pub const KEY_HOMEPAGE: u32 = 172;
pub const KEY_REFRESH: u32 = 173;
pub const KEY_EXIT: u32 = 174;
pub const KEY_MOVE: u32 = 175;
pub const KEY_EDIT: u32 = 176;
pub const KEY_SCROLLUP: u32 = 177;
pub const KEY_SCROLLDOWN: u32 = 178;
pub const KEY_KPLEFTPAREN: u32 = 179;
pub const KEY_KPRIGHTPAREN: u32 = 180;
pub const KEY_NEW: u32 = 181;
pub const KEY_REDO: u32 = 182;

pub const KEY_F13: u32 = 183;
pub const KEY_F14: u32 = 184;
pub const KEY_F15: u32 = 185;
pub const KEY_F16: u32 = 186;
pub const KEY_F17: u32 = 187;
pub const KEY_F18: u32 = 188;
pub const KEY_F19: u32 = 189;
pub const KEY_F20: u32 = 190;
pub const KEY_F21: u32 = 191;
pub const KEY_F22: u32 = 192;
pub const KEY_F23: u32 = 193;
pub const KEY_F24: u32 = 194;

pub const KEY_PLAYCD: u32 = 200;
pub const KEY_PAUSECD: u32 = 201;
pub const KEY_PROG3: u32 = 202;
pub const KEY_PROG4: u32 = 203;
pub const KEY_DASHBOARD: u32 = 204;
pub const KEY_SUSPEND: u32 = 205;
pub const KEY_CLOSE: u32 = 206;
pub const KEY_PLAY: u32 = 207;
pub const KEY_FASTFORWARD: u32 = 208;
pub const KEY_BASSBOOST: u32 = 209;
pub const KEY_PRINT: u32 = 210;
pub const KEY_HP: u32 = 211;
pub const KEY_CAMERA: u32 = 212;
pub const KEY_SOUND: u32 = 213;
pub const KEY_QUESTION: u32 = 214;
pub const KEY_EMAIL: u32 = 215;
pub const KEY_CHAT: u32 = 216;
pub const KEY_SEARCH: u32 = 217;
pub const KEY_CONNECT: u32 = 218;
pub const KEY_FINANCE: u32 = 219;
pub const KEY_SPORT: u32 = 220;
pub const KEY_SHOP: u32 = 221;
pub const KEY_ALTERASE: u32 = 222;
pub const KEY_CANCEL: u32 = 223;
pub const KEY_BRIGHTNESSDOWN: u32 = 224;
pub const KEY_BRIGHTNESSUP: u32 = 225;
pub const KEY_MEDIA: u32 = 226;

pub const KEY_SWITCHVIDEOMODE: u32 = 227;
pub const KEY_KBDILLUMTOGGLE: u32 = 228;
pub const KEY_KBDILLUMDOWN: u32 = 229;
pub const KEY_KBDILLUMUP: u32 = 230;

pub const KEY_SEND: u32 = 231;
pub const KEY_REPLY: u32 = 232;
pub const KEY_FORWARDMAIL: u32 = 233;
pub const KEY_SAVE: u32 = 234;
pub const KEY_DOCUMENTS: u32 = 235;

pub const KEY_BATTERY: u32 = 236;

pub const KEY_BLUETOOTH: u32 = 237;
pub const KEY_WLAN: u32 = 238;
pub const KEY_UWB: u32 = 239;

pub const KEY_UNKNOWN: u32 = 240;

pub const KEY_VIDEO_NEXT: u32 = 241;
pub const KEY_VIDEO_PREV: u32 = 242;
pub const KEY_BRIGHTNESS_CYCLE: u32 = 243;
pub const KEY_BRIGHTNESS_AUTO: u32 = 244;
pub const KEY_BRIGHTNESS_ZERO: u32 = KEY_BRIGHTNESS_AUTO;
pub const KEY_DISPLAY_OFF: u32 = 245;

pub const KEY_WWAN: u32 = 246;
pub const KEY_WIMAX: u32 = KEY_WWAN;
pub const KEY_RFKILL: u32 = 247;

pub const KEY_MICMUTE: u32 = 248;

pub const BTN_MISC: u32 = 0x100;
pub const BTN_0: u32 = 0x100;
pub const BTN_1: u32 = 0x101;
pub const BTN_2: u32 = 0x102;
pub const BTN_3: u32 = 0x103;
pub const BTN_4: u32 = 0x104;
pub const BTN_5: u32 = 0x105;
pub const BTN_6: u32 = 0x106;
pub const BTN_7: u32 = 0x107;
pub const BTN_8: u32 = 0x108;
pub const BTN_9: u32 = 0x109;

pub const BTN_MOUSE: u32 = 0x110;
pub const BTN_LEFT: u32 = 0x110;
pub const BTN_RIGHT: u32 = 0x111;
pub const BTN_MIDDLE: u32 = 0x112;
pub const BTN_SIDE: u32 = 0x113;
pub const BTN_EXTRA: u32 = 0x114;
pub const BTN_FORWARD: u32 = 0x115;
pub const BTN_BACK: u32 = 0x116;
pub const BTN_TASK: u32 = 0x117;

pub const BTN_JOYSTICK: u32 = 0x120;
pub const BTN_TRIGGER: u32 = 0x120;
pub const BTN_THUMB: u32 = 0x121;
pub const BTN_THUMB2: u32 = 0x122;
pub const BTN_TOP: u32 = 0x123;
pub const BTN_TOP2: u32 = 0x124;
pub const BTN_PINKIE: u32 = 0x125;
pub const BTN_BASE: u32 = 0x126;
pub const BTN_BASE2: u32 = 0x127;
pub const BTN_BASE3: u32 = 0x128;
pub const BTN_BASE4: u32 = 0x129;
pub const BTN_BASE5: u32 = 0x12a;
pub const BTN_BASE6: u32 = 0x12b;
pub const BTN_DEAD: u32 = 0x12f;

pub const BTN_GAMEPAD: u32 = 0x130;
pub const BTN_SOUTH: u32 = 0x130;
pub const BTN_A: u32 = BTN_SOUTH;
pub const BTN_EAST: u32 = 0x131;
pub const BTN_B: u32 = BTN_EAST;
pub const BTN_C: u32 = 0x132;
pub const BTN_NORTH: u32 = 0x133;
pub const BTN_X: u32 = BTN_NORTH;
pub const BTN_WEST: u32 = 0x134;
pub const BTN_Y: u32 = BTN_WEST;
pub const BTN_Z: u32 = 0x135;
pub const BTN_TL: u32 = 0x136;
pub const BTN_TR: u32 = 0x137;
pub const BTN_TL2: u32 = 0x138;
pub const BTN_TR2: u32 = 0x139;
pub const BTN_SELECT: u32 = 0x13a;
pub const BTN_START: u32 = 0x13b;
pub const BTN_MODE: u32 = 0x13c;
pub const BTN_THUMBL: u32 = 0x13d;
pub const BTN_THUMBR: u32 = 0x13e;

pub const BTN_DIGI: u32 = 0x140;
pub const BTN_TOOL_PEN: u32 = 0x140;
pub const BTN_TOOL_RUBBER: u32 = 0x141;
pub const BTN_TOOL_BRUSH: u32 = 0x142;
pub const BTN_TOOL_PENCIL: u32 = 0x143;
pub const BTN_TOOL_AIRBRUSH: u32 = 0x144;
pub const BTN_TOOL_FINGER: u32 = 0x145;
pub const BTN_TOOL_MOUSE: u32 = 0x146;
pub const BTN_TOOL_LENS: u32 = 0x147;
pub const BTN_TOOL_QUINTTAP: u32 = 0x148;
pub const BTN_STYLUS3: u32 = 0x149;
pub const BTN_TOUCH: u32 = 0x14a;
pub const BTN_STYLUS: u32 = 0x14b;
pub const BTN_STYLUS2: u32 = 0x14c;
pub const BTN_TOOL_DOUBLETAP: u32 = 0x14d;
pub const BTN_TOOL_TRIPLETAP: u32 = 0x14e;
pub const BTN_TOOL_QUADTAP: u32 = 0x14f;

pub const BTN_WHEEL: u32 = 0x150;
pub const BTN_GEAR_DOWN: u32 = 0x150;
pub const BTN_GEAR_UP: u32 = 0x151;

pub const KEY_OK: u32 = 0x160;
pub const KEY_SELECT: u32 = 0x161;
pub const KEY_GOTO: u32 = 0x162;
pub const KEY_CLEAR: u32 = 0x163;
pub const KEY_POWER2: u32 = 0x164;
pub const KEY_OPTION: u32 = 0x165;
pub const KEY_INFO: u32 = 0x166;
pub const KEY_TIME: u32 = 0x167;
pub const KEY_VENDOR: u32 = 0x168;
pub const KEY_ARCHIVE: u32 = 0x169;
pub const KEY_PROGRAM: u32 = 0x16a;
pub const KEY_CHANNEL: u32 = 0x16b;
pub const KEY_FAVORITES: u32 = 0x16c;
pub const KEY_EPG: u32 = 0x16d;
pub const KEY_PVR: u32 = 0x16e;
pub const KEY_MHP: u32 = 0x16f;
pub const KEY_LANGUAGE: u32 = 0x170;
pub const KEY_TITLE: u32 = 0x171;
pub const KEY_SUBTITLE: u32 = 0x172;
pub const KEY_ANGLE: u32 = 0x173;
pub const KEY_FULL_SCREEN: u32 = 0x174;
pub const KEY_ZOOM: u32 = KEY_FULL_SCREEN;
pub const KEY_MODE: u32 = 0x175;
pub const KEY_KEYBOARD: u32 = 0x176;
pub const KEY_ASPECT_RATIO: u32 = 0x177;
pub const KEY_SCREEN: u32 = KEY_ASPECT_RATIO;
pub const KEY_PC: u32 = 0x178;
pub const KEY_TV: u32 = 0x179;
pub const KEY_TV2: u32 = 0x17a;
pub const KEY_VCR: u32 = 0x17b;
pub const KEY_VCR2: u32 = 0x17c;
pub const KEY_SAT: u32 = 0x17d;
pub const KEY_SAT2: u32 = 0x17e;
pub const KEY_CD: u32 = 0x17f;
pub const KEY_TAPE: u32 = 0x180;
pub const KEY_RADIO: u32 = 0x181;
pub const KEY_TUNER: u32 = 0x182;
pub const KEY_PLAYER: u32 = 0x183;
pub const KEY_TEXT: u32 = 0x184;
pub const KEY_DVD: u32 = 0x185;
pub const KEY_AUX: u32 = 0x186;
pub const KEY_MP3: u32 = 0x187;
pub const KEY_AUDIO: u32 = 0x188;
pub const KEY_VIDEO: u32 = 0x189;
pub const KEY_DIRECTORY: u32 = 0x18a;
pub const KEY_LIST: u32 = 0x18b;
pub const KEY_MEMO: u32 = 0x18c;
pub const KEY_CALENDAR: u32 = 0x18d;
pub const KEY_RED: u32 = 0x18e;
pub const KEY_GREEN: u32 = 0x18f;
pub const KEY_YELLOW: u32 = 0x190;
pub const KEY_BLUE: u32 = 0x191;
pub const KEY_CHANNELUP: u32 = 0x192;
pub const KEY_CHANNELDOWN: u32 = 0x193;
pub const KEY_FIRST: u32 = 0x194;
pub const KEY_LAST: u32 = 0x195;
pub const KEY_AB: u32 = 0x196;
pub const KEY_NEXT: u32 = 0x197;
pub const KEY_RESTART: u32 = 0x198;
pub const KEY_SLOW: u32 = 0x199;
pub const KEY_SHUFFLE: u32 = 0x19a;
pub const KEY_BREAK: u32 = 0x19b;
pub const KEY_PREVIOUS: u32 = 0x19c;
pub const KEY_DIGITS: u32 = 0x19d;
pub const KEY_TEEN: u32 = 0x19e;
pub const KEY_TWEN: u32 = 0x19f;
pub const KEY_VIDEOPHONE: u32 = 0x1a0;
pub const KEY_GAMES: u32 = 0x1a1;
pub const KEY_ZOOMIN: u32 = 0x1a2;
pub const KEY_ZOOMOUT: u32 = 0x1a3;
pub const KEY_ZOOMRESET: u32 = 0x1a4;
pub const KEY_WORDPROCESSOR: u32 = 0x1a5;
pub const KEY_EDITOR: u32 = 0x1a6;
pub const KEY_SPREADSHEET: u32 = 0x1a7;
pub const KEY_GRAPHICSEDITOR: u32 = 0x1a8;
pub const KEY_PRESENTATION: u32 = 0x1a9;
pub const KEY_DATABASE: u32 = 0x1aa;
pub const KEY_NEWS: u32 = 0x1ab;
pub const KEY_VOICEMAIL: u32 = 0x1ac;
pub const KEY_ADDRESSBOOK: u32 = 0x1ad;
pub const KEY_MESSENGER: u32 = 0x1ae;
pub const KEY_DISPLAYTOGGLE: u32 = 0x1af;
pub const KEY_BRIGHTNESS_TOGGLE: u32 = KEY_DISPLAYTOGGLE;
pub const KEY_SPELLCHECK: u32 = 0x1b0;
pub const KEY_LOGOFF: u32 = 0x1b1;

pub const KEY_DOLLAR: u32 = 0x1b2;
pub const KEY_EURO: u32 = 0x1b3;

pub const KEY_FRAMEBACK: u32 = 0x1b4;
pub const KEY_FRAMEFORWARD: u32 = 0x1b5;
pub const KEY_CONTEXT_MENU: u32 = 0x1b6;
pub const KEY_MEDIA_REPEAT: u32 = 0x1b7;
pub const KEY_10CHANNELSUP: u32 = 0x1b8;
pub const KEY_10CHANNELSDOWN: u32 = 0x1b9;
pub const KEY_IMAGES: u32 = 0x1ba;
pub const KEY_NOTIFICATION_CENTER: u32 = 0x1bc;
pub const KEY_PICKUP_PHONE: u32 = 0x1bd;
pub const KEY_HANGUP_PHONE: u32 = 0x1be;

pub const KEY_DEL_EOL: u32 = 0x1c0;
pub const KEY_DEL_EOS: u32 = 0x1c1;
pub const KEY_INS_LINE: u32 = 0x1c2;
pub const KEY_DEL_LINE: u32 = 0x1c3;

pub const KEY_FN: u32 = 0x1d0;
pub const KEY_FN_ESC: u32 = 0x1d1;
pub const KEY_FN_F1: u32 = 0x1d2;
pub const KEY_FN_F2: u32 = 0x1d3;
pub const KEY_FN_F3: u32 = 0x1d4;
pub const KEY_FN_F4: u32 = 0x1d5;
pub const KEY_FN_F5: u32 = 0x1d6;
pub const KEY_FN_F6: u32 = 0x1d7;
pub const KEY_FN_F7: u32 = 0x1d8;
pub const KEY_FN_F8: u32 = 0x1d9;
pub const KEY_FN_F9: u32 = 0x1da;
pub const KEY_FN_F10: u32 = 0x1db;
pub const KEY_FN_F11: u32 = 0x1dc;
pub const KEY_FN_F12: u32 = 0x1dd;
pub const KEY_FN_1: u32 = 0x1de;
pub const KEY_FN_2: u32 = 0x1df;
pub const KEY_FN_D: u32 = 0x1e0;
pub const KEY_FN_E: u32 = 0x1e1;
pub const KEY_FN_F: u32 = 0x1e2;
pub const KEY_FN_S: u32 = 0x1e3;
pub const KEY_FN_B: u32 = 0x1e4;
pub const KEY_FN_RIGHT_SHIFT: u32 = 0x1e5;

pub const KEY_BRL_DOT1: u32 = 0x1f1;
pub const KEY_BRL_DOT2: u32 = 0x1f2;
pub const KEY_BRL_DOT3: u32 = 0x1f3;
pub const KEY_BRL_DOT4: u32 = 0x1f4;
pub const KEY_BRL_DOT5: u32 = 0x1f5;
pub const KEY_BRL_DOT6: u32 = 0x1f6;
pub const KEY_BRL_DOT7: u32 = 0x1f7;
pub const KEY_BRL_DOT8: u32 = 0x1f8;
pub const KEY_BRL_DOT9: u32 = 0x1f9;
pub const KEY_BRL_DOT10: u32 = 0x1fa;

pub const KEY_NUMERIC_0: u32 = 0x200;
pub const KEY_NUMERIC_1: u32 = 0x201;
pub const KEY_NUMERIC_2: u32 = 0x202;
pub const KEY_NUMERIC_3: u32 = 0x203;
pub const KEY_NUMERIC_4: u32 = 0x204;
pub const KEY_NUMERIC_5: u32 = 0x205;
pub const KEY_NUMERIC_6: u32 = 0x206;
pub const KEY_NUMERIC_7: u32 = 0x207;
pub const KEY_NUMERIC_8: u32 = 0x208;
pub const KEY_NUMERIC_9: u32 = 0x209;
pub const KEY_NUMERIC_STAR: u32 = 0x20a;
pub const KEY_NUMERIC_POUND: u32 = 0x20b;
pub const KEY_NUMERIC_A: u32 = 0x20c;
pub const KEY_NUMERIC_B: u32 = 0x20d;
pub const KEY_NUMERIC_C: u32 = 0x20e;
pub const KEY_NUMERIC_D: u32 = 0x20f;

pub const KEY_CAMERA_FOCUS: u32 = 0x210;
pub const KEY_WPS_BUTTON: u32 = 0x211;

pub const KEY_TOUCHPAD_TOGGLE: u32 = 0x212;
pub const KEY_TOUCHPAD_ON: u32 = 0x213;
pub const KEY_TOUCHPAD_OFF: u32 = 0x214;

pub const KEY_CAMERA_ZOOMIN: u32 = 0x215;
pub const KEY_CAMERA_ZOOMOUT: u32 = 0x216;
pub const KEY_CAMERA_UP: u32 = 0x217;
pub const KEY_CAMERA_DOWN: u32 = 0x218;
pub const KEY_CAMERA_LEFT: u32 = 0x219;
pub const KEY_CAMERA_RIGHT: u32 = 0x21a;

pub const KEY_ATTENDANT_ON: u32 = 0x21b;
pub const KEY_ATTENDANT_OFF: u32 = 0x21c;
pub const KEY_ATTENDANT_TOGGLE: u32 = 0x21d;
pub const KEY_LIGHTS_TOGGLE: u32 = 0x21e;

pub const BTN_DPAD_UP: u32 = 0x220;
pub const BTN_DPAD_DOWN: u32 = 0x221;
pub const BTN_DPAD_LEFT: u32 = 0x222;
pub const BTN_DPAD_RIGHT: u32 = 0x223;

pub const KEY_ALS_TOGGLE: u32 = 0x230;
pub const KEY_ROTATE_LOCK_TOGGLE: u32 = 0x231;

pub const KEY_BUTTONCONFIG: u32 = 0x240;
pub const KEY_TASKMANAGER: u32 = 0x241;
pub const KEY_JOURNAL: u32 = 0x242;
pub const KEY_CONTROLPANEL: u32 = 0x243;
pub const KEY_APPSELECT: u32 = 0x244;
pub const KEY_SCREENSAVER: u32 = 0x245;
pub const KEY_VOICECOMMAND: u32 = 0x246;
pub const KEY_ASSISTANT: u32 = 0x247;
pub const KEY_KBD_LAYOUT_NEXT: u32 = 0x248;
pub const KEY_EMOJI_PICKER: u32 = 0x249;

pub const KEY_BRIGHTNESS_MIN: u32 = 0x250;
pub const KEY_BRIGHTNESS_MAX: u32 = 0x251;

pub const KEY_KBDINPUTASSIST_PREV: u32 = 0x260;
pub const KEY_KBDINPUTASSIST_NEXT: u32 = 0x261;
pub const KEY_KBDINPUTASSIST_PREVGROUP: u32 = 0x262;
pub const KEY_KBDINPUTASSIST_NEXTGROUP: u32 = 0x263;
pub const KEY_KBDINPUTASSIST_ACCEPT: u32 = 0x264;
pub const KEY_KBDINPUTASSIST_CANCEL: u32 = 0x265;

pub const KEY_RIGHT_UP: u32 = 0x266;
pub const KEY_RIGHT_DOWN: u32 = 0x267;
pub const KEY_LEFT_UP: u32 = 0x268;
pub const KEY_LEFT_DOWN: u32 = 0x269;

pub const KEY_ROOT_MENU: u32 = 0x26a;
pub const KEY_MEDIA_TOP_MENU: u32 = 0x26b;
pub const KEY_NUMERIC_11: u32 = 0x26c;
pub const KEY_NUMERIC_12: u32 = 0x26d;
pub const KEY_AUDIO_DESC: u32 = 0x26e;
pub const KEY_3D_MODE: u32 = 0x26f;
pub const KEY_NEXT_FAVORITE: u32 = 0x270;
pub const KEY_STOP_RECORD: u32 = 0x271;
pub const KEY_PAUSE_RECORD: u32 = 0x272;
pub const KEY_VOD: u32 = 0x273;
pub const KEY_UNMUTE: u32 = 0x274;
pub const KEY_FASTREVERSE: u32 = 0x275;
pub const KEY_SLOWREVERSE: u32 = 0x276;
pub const KEY_DATA: u32 = 0x277;
pub const KEY_ONSCREEN_KEYBOARD: u32 = 0x278;
pub const KEY_PRIVACY_SCREEN_TOGGLE: u32 = 0x279;

pub const KEY_SELECTIVE_SCREENSHOT: u32 = 0x27a;

pub const KEY_MACRO1: u32 = 0x290;
pub const KEY_MACRO2: u32 = 0x291;
pub const KEY_MACRO3: u32 = 0x292;
pub const KEY_MACRO4: u32 = 0x293;
pub const KEY_MACRO5: u32 = 0x294;
pub const KEY_MACRO6: u32 = 0x295;
pub const KEY_MACRO7: u32 = 0x296;
pub const KEY_MACRO8: u32 = 0x297;
pub const KEY_MACRO9: u32 = 0x298;
pub const KEY_MACRO10: u32 = 0x299;
pub const KEY_MACRO11: u32 = 0x29a;
pub const KEY_MACRO12: u32 = 0x29b;
pub const KEY_MACRO13: u32 = 0x29c;
pub const KEY_MACRO14: u32 = 0x29d;
pub const KEY_MACRO15: u32 = 0x29e;
pub const KEY_MACRO16: u32 = 0x29f;
pub const KEY_MACRO17: u32 = 0x2a0;
pub const KEY_MACRO18: u32 = 0x2a1;
pub const KEY_MACRO19: u32 = 0x2a2;
pub const KEY_MACRO20: u32 = 0x2a3;
pub const KEY_MACRO21: u32 = 0x2a4;
pub const KEY_MACRO22: u32 = 0x2a5;
pub const KEY_MACRO23: u32 = 0x2a6;
pub const KEY_MACRO24: u32 = 0x2a7;
pub const KEY_MACRO25: u32 = 0x2a8;
pub const KEY_MACRO26: u32 = 0x2a9;
pub const KEY_MACRO27: u32 = 0x2aa;
pub const KEY_MACRO28: u32 = 0x2ab;
pub const KEY_MACRO29: u32 = 0x2ac;
pub const KEY_MACRO30: u32 = 0x2ad;

pub const KEY_MACRO_RECORD_START: u32 = 0x2b0;
pub const KEY_MACRO_RECORD_STOP: u32 = 0x2b1;
pub const KEY_MACRO_PRESET_CYCLE: u32 = 0x2b2;
pub const KEY_MACRO_PRESET1: u32 = 0x2b3;
pub const KEY_MACRO_PRESET2: u32 = 0x2b4;
pub const KEY_MACRO_PRESET3: u32 = 0x2b5;

pub const KEY_KBD_LCD_MENU1: u32 = 0x2b8;
pub const KEY_KBD_LCD_MENU2: u32 = 0x2b9;
pub const KEY_KBD_LCD_MENU3: u32 = 0x2ba;
pub const KEY_KBD_LCD_MENU4: u32 = 0x2bb;
pub const KEY_KBD_LCD_MENU5: u32 = 0x2bc;

pub const BTN_TRIGGER_HAPPY: u32 = 0x2c0;
pub const BTN_TRIGGER_HAPPY1: u32 = 0x2c0;
pub const BTN_TRIGGER_HAPPY2: u32 = 0x2c1;
pub const BTN_TRIGGER_HAPPY3: u32 = 0x2c2;
pub const BTN_TRIGGER_HAPPY4: u32 = 0x2c3;
pub const BTN_TRIGGER_HAPPY5: u32 = 0x2c4;
pub const BTN_TRIGGER_HAPPY6: u32 = 0x2c5;
pub const BTN_TRIGGER_HAPPY7: u32 = 0x2c6;
pub const BTN_TRIGGER_HAPPY8: u32 = 0x2c7;
pub const BTN_TRIGGER_HAPPY9: u32 = 0x2c8;
pub const BTN_TRIGGER_HAPPY10: u32 = 0x2c9;
pub const BTN_TRIGGER_HAPPY11: u32 = 0x2ca;
pub const BTN_TRIGGER_HAPPY12: u32 = 0x2cb;
pub const BTN_TRIGGER_HAPPY13: u32 = 0x2cc;
pub const BTN_TRIGGER_HAPPY14: u32 = 0x2cd;
pub const BTN_TRIGGER_HAPPY15: u32 = 0x2ce;
pub const BTN_TRIGGER_HAPPY16: u32 = 0x2cf;
pub const BTN_TRIGGER_HAPPY17: u32 = 0x2d0;
pub const BTN_TRIGGER_HAPPY18: u32 = 0x2d1;
pub const BTN_TRIGGER_HAPPY19: u32 = 0x2d2;
pub const BTN_TRIGGER_HAPPY20: u32 = 0x2d3;
pub const BTN_TRIGGER_HAPPY21: u32 = 0x2d4;
pub const BTN_TRIGGER_HAPPY22: u32 = 0x2d5;
pub const BTN_TRIGGER_HAPPY23: u32 = 0x2d6;
pub const BTN_TRIGGER_HAPPY24: u32 = 0x2d7;
pub const BTN_TRIGGER_HAPPY25: u32 = 0x2d8;
pub const BTN_TRIGGER_HAPPY26: u32 = 0x2d9;
pub const BTN_TRIGGER_HAPPY27: u32 = 0x2da;
pub const BTN_TRIGGER_HAPPY28: u32 = 0x2db;
pub const BTN_TRIGGER_HAPPY29: u32 = 0x2dc;
pub const BTN_TRIGGER_HAPPY30: u32 = 0x2dd;
pub const BTN_TRIGGER_HAPPY31: u32 = 0x2de;
pub const BTN_TRIGGER_HAPPY32: u32 = 0x2df;
pub const BTN_TRIGGER_HAPPY33: u32 = 0x2e0;
pub const BTN_TRIGGER_HAPPY34: u32 = 0x2e1;
pub const BTN_TRIGGER_HAPPY35: u32 = 0x2e2;
pub const BTN_TRIGGER_HAPPY36: u32 = 0x2e3;
pub const BTN_TRIGGER_HAPPY37: u32 = 0x2e4;
pub const BTN_TRIGGER_HAPPY38: u32 = 0x2e5;
pub const BTN_TRIGGER_HAPPY39: u32 = 0x2e6;
pub const BTN_TRIGGER_HAPPY40: u32 = 0x2e7;

pub const KEY_MIN_INTERESTING: u32 = KEY_MUTE;
pub const KEY_MAX: u32 = 0x2ff;
pub const KEY_CNT: u32 = KEY_MAX + 1;
