#version 330


layout(points) in;
layout(triangle_strip, max_vertices = 103) out;
//layout(line_strip, max_vertices = 80) out;

uniform mat4 pmv;
uniform mat3 normalMatrix;
uniform int dontshowSymElement[200];
uniform int dontshowSymOperation[200];
uniform int dssesize=0;
uniform int dssosize=0;
uniform float InversionCenterRadius = 0.15;

in float coli[];
in float oprn[];
out vec3 Normal;
out float col;

out gl_PerVertex{
  vec4 gl_Position;
};


void icosa(float r){
  const float phi = (1.0 + sqrt(5.0)) / 2.0;
  const float du = 1.0 / sqrt(phi * phi + 1.0);
  const float dv = phi * du;
  const vec3  eckn[] = vec3[12](
                          vec3(0.0, dv, du),   vec3(0.0, dv, -du),  vec3(0.0, -dv, du),
                          vec3(0.0, -dv, -du), vec3(du, 0.0, dv),   vec3(-du, 0.0, dv),
                          vec3(du, 0.0, -dv),  vec3(-du, 0.0, -dv), vec3(dv, du, 0.0),
                          vec3(dv, -du, 0.0),  vec3(-dv, du, 0.0),  vec3(-dv, -du, 0.0));
  const int triangle[] = int[60](
    1, 0, 8,
    4, 0, 5,
    5, 0, 10,
    8, 0, 4,
   10, 0, 1,
    6, 1, 8,
    7, 1, 6,
   10, 1, 7,
    3, 2, 11,
    4, 2, 9,
    5, 2, 4,
    9, 2, 3,
   11, 2, 5,
    6, 3, 7,
    7, 3, 11,
    9, 3, 6,
    8, 4, 9,
   11, 5, 10,
    9, 6, 8,
   10, 7, 11);
  vec3 _nor;
  for (int j=0; j<triangle.length(); j++){
      gl_Position = pmv*(gl_in[0].gl_Position + (vec4(r * eckn[triangle[j]], 0.0)));
      if ((j%3 == 0)&&((j+2) < triangle.length())) _nor = normalize(eckn[triangle[j]]+eckn[triangle[j+1]]+eckn[triangle[j+2]]);
      Normal =  normalize(normalMatrix * _nor);
      //nor = eckn[triangle[j]];
      col = 5;
      EmitVertex();
    if (j%3 == 2)EndPrimitive();
  }
  EndPrimitive();
}


void main() {
  for (int i=0; i<dssesize; i++) if ((dontshowSymElement[i]==coli[0])) return;
  for (int i=0; i<dssosize; i++) if ((dontshowSymOperation[i]==oprn[0])) return;
  if (coli[0]==5) icosa(InversionCenterRadius);
}
