package net.sf.saxon.charcode;

/*

Copyright (C) 2006 Hewlett-Packard Development Company, L.P.

The contents of this file are subject to the Mozilla Public License Version 1.1
(the "License"); you may not use this file except in compliance with the
License. You may obtain a copy of the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: all this file
The Initial Developer of the Original Code is Lauren Ward. All Rights Reserved.
Contributor(s): Integrated into Saxon by Michael Kay. Removed code to perform dynamic
 initialization of the boolean array, replaced it with generated static data.

*************************
Author:
  Lauren Ward
Date:
  February 01, 2006
Address:
  Hewlett-Packard Company
  3404 East Harmony Road
  Fort Collins, CO 80528-9599
Revision:
  1.0 - Initial creation

Description: This class implements the PluggableCharacterSet to support
EUC-JP encoding.  The character mapping was obtained by extracting the
Unicode values from an iconv character table (eucJP=ucs2) available on HP-UX 11.23.

The class was tested by transforming numerous manuals and having localization engineers
review the output. The class was also tested by transforming a document with EUC-JP
set as the output encoding, converting EUC-JP output to utf-8 using iconv,
and then comparing converted content to the same transformed document with utf-8 set
as the output encoding.

*/


public class EucJPCharacterSet implements CharacterSet {

    private static EucJPCharacterSet THE_INSTANCE = new EucJPCharacterSet();

    public static EucJPCharacterSet getInstance() {
        return THE_INSTANCE;
    }


    private static long[] flags = {
        0xffffffffffffffffL, 0xffffffffffffffffL, 0x7febcaa1L, 0xffff7fffffffffffL,
        0xfffff3ffeff3ffffL, 0xfffcfffffffffffeL, 0x0L, 0x7fff800000400L,
        0x0L, 0x0L, 0x0L, 0x10000f400000000L,
        0x0L, 0x0L, 0xeebffffdfffffffL, 0xfffe000000000000L,
        0x7ffbffffffffffffL, 0xffff7ffb00000000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x8accc600b012L, 0x0L, 0x0L, 0x0L,
        0x1000020020100000L, 0x0L, 0xf00000000000L, 0x280000000000L,
        0xb190202681f80c04L, 0x2000c3300000L, 0x3300000004000000L, 0x0L,
        0x200000000000L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xf009999c9c999999L, 0x2010000000000000L, 0xc000300cL, 0x313000000010000L,
        0x600000000000000L, 0xa000000000250000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xf7fffc0800000000L, 0x7fffffffffffffffL, 0xfffff01e7fffffffL, 0xfffffffffffffe1eL,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xfdfeefc35ab7e6d9L, 0xfd1747ef30c05c43L, 0xa6fe6fdfee9f9260L, 0xfb378ff7fc87f717L,
        0xf0ffe76c0003dffeL, 0xb3dfffff906bd7ffL, 0x7efffbf7c017275fL, 0xfeffe9bdfc03b6afL,
        0xcf7ffbff7ffeb650L, 0xf7ebf769b72cee84L, 0xde27fafbe02dbd66L, 0xbd6fdeaf3fc76672L,
        0xfbdeafff51ad7df9L, 0xffffbda92efe478aL, 0xbe7ff7c4fefcffafL, 0x2edd769ee766ffe6L,
        0xffb27f842de2f7f8L, 0x1d7d0fbbde63fdc5L, 0xb5ec7fb99f7dcffeL, 0xdfcd6fdfffe8ffe3L,
        0xf6bdd7ffd5fdf4ffL, 0xf7fc79fad64ffdd3L, 0x39821ae5cef7bfb4L, 0xb4ff3f77fffff7a0L,
        0x78ffd035c3ff4edeL, 0xbbe740032bf6df1dL, 0xdedfe6096fff71ffL, 0xebe60080e6ef222fL,
        0xcfcf8e00003376deL, 0xcf6dd3beda00001bL, 0xfbf379ef19fea201L, 0x5f5a79bb38400347L,
        0x6e7ebd00049ffddL, 0xfa5f8812fafd6ca0L, 0x8fb90c67a7de5b0aL, 0xf4ffd1ffdf96f365L,
        0xf9fd76bdbfef9997L, 0xa72fe0006ff7dd7bL, 0x70d81d6ff9e89084L, 0x939b3e0fdb448fefL,
        0xbefc0457cb25ec65L, 0xc07dede369d0a4cbL, 0xd5ed9b0de2d270faL, 0x6daeffef6c5bf17cL,
        0x2679befc7dfff783L, 0x1bc3fdf7f5ff3edcL, 0x783e37551d8fb17aL, 0x5af4f86f1fb36b11L,
        0xd84e70ab9de58608L, 0xcfc88422372c0133L, 0x10b27ba10874bfL, 0x6ad98328d6620634L,
        0xc0d80354642caa82L, 0xd418efbf1ed3d4afL, 0xdfffdffd3ecfffe9L, 0xff4dbbf7efd3dea7L,
        0x6fff5323badee6ffL, 0xc6b7d46afdcfce7cL, 0x1a9e805f2f87fbaL, 0x5502144c0e7ea34L,
        0x43166ff13b504845L, 0x32bae449e86d9263L, 0x79b8bc55a11aa9ecL, 0x115eb2d6dfd27dd6L,
        0xb31c6ef58497b786L, 0x9d5acf9b78bebeffL, 0xd9330728afbc5787L, 0x72fbfe3ff4d8dbbbL,
        0x7bffdfdd7fdfcf9fL, 0xcdaedbdcfb7dfdefL, 0xfdfdf3cee9ffd8ccL, 0x1ddcfbcee8fff6bdL,
        0x127bffdcff55420L, 0xf3fcef65fdfdc503L, 0x7afe7fb7bfe0ff9eL, 0x2ff35cfff580fffcL,
        0xf3efff7b61b8cf4fL, 0x6ffe14e7b59bff9bL, 0xf936fbed8dfe22eaL, 0xf3ff840f774d2bafL,
        0xd9eefe3ff373b8d5L, 0xfbdefeba9887526fL, 0xb867ff9a0298577fL, 0x2feffffcc02f7f0fL,
        0x79fcd2c101f5066fL, 0x7a7fbd9807de6fbdL, 0xb9ebaef3ffff2c16L, 0xdec3fe38d46a3ee0L,
        0x265bb8aaeed8e27L, 0x201378bdd1451ab4L, 0x1581f4f75edeb05fL, 0x6d7eeda0ff6def37L,
        0xcce11adf3a7b4fffL, 0x15c5efc7b318ada4L, 0x75eae5dddf1fb94dL, 0x7edbabd1e7ccec73L,
        0xbbef7e0fffffdf49L, 0xfe7b61dfebfb9ffbL, 0xd9dee3fdaa166cdbL, 0xf9cb0a7d82dabdffL,
        0x95d71f5fa3be5ba7L, 0x47cbde4ffe2fff1bL, 0x4d5bd7fce241ffdcL, 0xfee3f9ee6b4bff53L,
        0x38001b4761fdf8ddL, 0xfeaefddd1113ef7bL, 0x7e851bbdf7e7f678L, 0xefdffedd5bfe67cL,
        0xcefff37876a0ded5L, 0x24621d7efefffdffL, 0xe0266e98c79769bbL, 0x55bed3c625977457L,
        0xf4397d77f8f2aff7L, 0xff2e6d16b207083L, 0xdb56c11fb43bd897L, 0x72c8de3f09a8e03cL,
        0x3f61e317d99927f7L, 0x136ebad5fb739cd7L, 0xbe740793b8fffdffL, 0x9e5e3ab1531b5141L,
        0x2cc7f9511b8a1fb3L, 0xe037ad7fa1b5baf6L, 0x77ccbff96012f8ffL, 0x6e6dff7cf5fbf800L,
        0x93b717307f376dfL, 0x4c00016b5f6b89c8L, 0x258a7fd800292dcdL, 0x8fbb66d7eefbdf78L,
        0x8df01477ff5f22faL, 0x1cf77b9f31933217L, 0xa00d92cda5277335L, 0xfdff5c06001f29d7L,
        0x6aed5eb0b27df29bL, 0x440179ff6a8f88aeL, 0xfb9efb21dfa3d648L, 0xf7a00cb3c8dbd66eL,
        0xc75545b79309a94aL, 0x18fa4c861c1b868eL, 0x46622fd0081fd9e0L, 0xb15ecd08004064L,
        0x1f59086ac215c288L, 0x477aa76aafca0044L, 0x8da92c71a089f063L, 0xd8dabf69870e04dbL,
        0x83c4913508bdaeffL, 0xf79bb6fff1d369dfL, 0xe9463210a18f6a42L, 0x7b4aa7d1e44c19feL,
        0x2d3433df2dfb6f37L, 0x1c07a38793fbe5f8L, 0xdf52978ba674355dL, 0xa6ff3246d7664df7L,
        0xdf6040302efffe61L, 0xdb14657fbbf7f202L, 0xd751e0ebf3f3e455L, 0xe998bbbbf3ebb9L,
        0x1e0e77abdff9f3ffL, 0x9bffe97fef75dbffL, 0x6773fc6c3c107cefL, 0xff2f2ddbf94bf86bL,
        0xf9fd365fff44bcf8L, 0xfff826c96defeabeL, 0xdf9e967dbfa689e5L, 0x76fe2b5bdfaaeadaL,
        0xcbfa2d7baec70feeL, 0xa727233bffb8b867L, 0x881e4e23a52fd65fL, 0x1144657bbf6fd898L,
        0x264e6c04f706ad21L, 0x1d8a200ed8bb282aL, 0x432f5da759edf43fL, 0x47fafe31cba93b35L,
        0xc30ae06b877c4c3fL, 0xcff1dfbfa5d4217bL, 0xcc3f5e9c43f3d8f7L, 0xe9f16ea7ff7cc098L,
        0xb1fe4dfbc117edffL, 0xbfcf874df5748ee7L, 0xfeb0ff83906b9679L, 0x1fff747df6fdcaf7L,
        0x2bb148d397ffde45L, 0xc7dfee048f6ffd20L, 0xb57efffc42deebcL, 0xeff90b748ee43feaL,
        0xfb5f7951d7b85be7L, 0x922dfeffdd4eb44eL, 0x7355ad93ef96f37fL, 0xade73fefa3512eb2L,
        0xbff5fffef23ff46fL, 0xff9fd37e77a2f6f5L, 0x76dd537f333ffff7L, 0x3f3f65eeeefd6e70L,
        0xccf0e51ff39f7777L, 0x5f36aee7677790dfL, 0x73effebe00000000L, 0x0L,
        0x2bfL, 0x1d0ffc9ddff6e5c7L, 0xb7bfcb2e7ae72acdL, 0xd6ab2c11d6dbb07fL,
        0xdfbfffcfca8a9f7fL, 0x8a2022a3ea85ff47L, 0x4fda12be677d68e0L, 0x1a8f2ff6cc07faeeL,
        0x37f003ba9949d46aL, 0x73afd01c7d7c9e1L, 0xfeb396beb8c2bcb7L, 0xb6f755f7ddbcfeffL,
        0xf5efbbff60fa3fe0L, 0x9f1342edbbb76b97L, 0xd9766af5dffff9ffL, 0x600fd7bffb55b76L,
        0xfff2039f709fffecL, 0xbd67ff800000959dL, 0xaf663effa3fc4407L, 0xc56bda8d80f1ebdcL,
        0x5b3f5440a06944ccL, 0x7e763f8ff7fdfecL, 0x6c10bc4b42e568ffL, 0xebfdd268012be93dL,
        0xb30addab7f3d3e05L, 0xd2f3f7eff8f50177L, 0xcff9d9ddafff0befL, 0x617784ad8ee4137bL,
        0xaf36f3f2614582adL, 0xe206bfeff9594770L, 0xbc56a85bf5dfc1L, 0xdf566d7b9d4f00feL,
        0xbff7f8eb54c3697fL, 0x945e15c5dea36a91L, 0x3fdc95c3b11f5437L, 0xcbf2a669b83573f3L,
        0x5677fefb7186e678L, 0xfefe77fff8d0e557L, 0xe09423fba8b2cd27L, 0xfc3f7cdf4181fdceL,
        0x6b2fb6ee87b0e6f2L, 0xfe4d233bfa37bd3fL, 0x53f59fb9c769bf2dL, 0x80002fac17545ac5L,
        0xbdabff97be3d5f3eL, 0xd7c6ff9ef75ef77bL, 0xbf5df7e3dfcfb35bL, 0x3bfd7f3feb1edfabL,
        0xef3acb7fc29c914aL, 0x7ecf3afb121debceL, 0xdc3fbe6b00000000L, 0x0L,
        0x1e7L, 0x47fbddf47afc16faL, 0x277eb8dee9ffbbfdL, 0xfff7567efaada5bfL,
        0x5df5bb1000000000L, 0xf5ed901L, 0x6ca4c4439299357aL, 0xa7bb4f755db9fc0dL,
        0x4ef1ca07f320dfc4L, 0xe9ff8c5ff84dea78L, 0x7d74fc76617fd432L, 0xdfbd68193096c1feL,
        0xb5e9bfdfd7ef1ff3L, 0xff4f7d8f7c000000L, 0x1fdf87e7bbL, 0xee36fc20bef7cff6L,
        0xfe9fdff7f1ef7fcbL, 0x7d7ffedef7cfafedL, 0xfdfbc5d0f6a1fe86L, 0x5daa25dd6c958f07L,
        0xae84abeab547eb6cL, 0x11ff3bf07d6c3df0L, 0x7776fd8a6abffebdL, 0xf7dfdbff5f6fc75dL,
        0xcf6efe8e1ecb9febL, 0xbff7c1feefc3c7dfL, 0x94e677f98d9523fdL, 0xf79fb5cdddeeb0f9L,
        0xa285cceffffb3f30L, 0x9d4efba8d6fde2fL, 0xe0bd2fb25bde8e60L, 0x5ffcd3cf6f8001f4L,
        0x79c79fe140137eb5L, 0x5ca8747bf0b7e50fL, 0x5800000000000000L, 0x0L,
        0x0L, 0x1c2L, 0xb9ff5ac7ffdc2a7fL, 0x13fcfeefee000000L,
        0xe6eab71fdL, 0xe81dab9f7e2abfbfL, 0x7ef74ffd9fe3fbf8L, 0xcf7e66ff30f1e370L,
        0xbfe7527e79a0f0c6L, 0x7ae327fafbf65bfdL, 0xce5587ebb29e7eebL, 0x5ffed9dec8077fb1L,
        0x77affbeade1fbd9eL, 0xb3f7ff23739d800L, 0xb7cbb1L, 0x3e88001977773a0eL,
        0x35e8ffbfeb9a7c7eL, 0xe7deeddb80000000L, 0x3d5068efc6dL, 0x5ec0fcff213eecd7L,
        0x7c1bf242b9969782L, 0xfd3e4f352c700000L, 0xafaedbL, 0xda83ff9bbf7f7d75L,
        0xfedea2f9b7f77d7cL, 0x7c9f4fb256bf1dc1L, 0x9f77fb2783fee9dbL, 0xc3e3eb957db1f5e5L,
        0xaafdfefa7fe7e776L, 0x5fe3bbbf91f2a790L, 0x0L, 0x758bb40L,
        0x33d2659f12b9b83fL, 0x7fa0d84ffc79a33aL, 0x1b6737a0487b6cf9L, 0x7b611f638757b8e6L,
        0x2122e67e00000000L, 0x4fdL, 0xfd9b77970eef9cfbL, 0xa9facdf8d8fefddL,
        0x31c3ff71e239697fL, 0x5f333fa7f3eff724L, 0x5ef0ef4000000L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x5efbffffffffffffL, 0xfffffffe7fffffffL, 0xffffffff00000000L, 0x0L,
    };

    public EucJPCharacterSet() {

    }

    // Determine if it is a valid character
    public final boolean inCharset(int ch) {
        if (ch > 65535) {
            return false;
        }
        long g = flags[ch >> 6];
        long h = (g >> (63 - (ch & 0x3f))) & 1L;
        return h == 1L;
    }

    public final String getEncodingName() {
        // Canonical Name for java.io and java.lang API
        return "EUC_JP";
    }
}

