# Generated by OTF2 Template Engine

import re
from numbers import Number, Integral
from six import with_metaclass, string_types

from .attribute_list import AttributeList
from .enums import Base, ParameterType


def _replace_doxygen_commands(doc_string):
    if doc_string is not None:
        p = re.compile(r'@eref\{([^}]*)\}')
        doc_string = p.sub(r':py:class:`\1`', doc_string)
        doc_string = doc_string.replace('@b', '')
    return doc_string


class _EventMeta(type):
    def __new__(mcls, name, bases, namespace):
        clazz = type.__new__(mcls, name, bases, namespace)
        old_doc = namespace.get("__doc__")
        clazz.__doc__ = _replace_doxygen_commands(old_doc)
        return clazz


class _Event(with_metaclass(_EventMeta, object)):
    def __init__(self, time, attributes=None):
        self.time = time
        if attributes is not None:
            if not isinstance(attributes, dict):
                raise TypeError("Unexpected type for argument: attributes")
        self.attributes = attributes

    def __str__(self):
        return str(self.__dict__)


def _get_string_ref(writer, value):
    # The writer argument is the event writer, but for get_ref its the definition
    # writer. But we do not want, that this string definition will be written now
    return writer._archive.definitions.strings.get_ref(value, writer=None)

class BufferFlush(_Event):
    """This event signals that the internal buffer was flushed at the given
time.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("stopTime", "TimeStamp", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, stop_time, attributes=None):
        super(BufferFlush, self).__init__(time, attributes)
        self.stop_time = stop_time

    @classmethod
    def _construct(cls, registry, time, stop_time):
        return cls(time, stop_time)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._buffer_flush(al._handle, self.time, self.stop_time)

class MeasurementOnOff(_Event):
    """This event signals where the measurement system turned measurement on or
off.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("measurementMode", "MeasurementMode", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, measurement_mode, attributes=None):
        super(MeasurementOnOff, self).__init__(time, attributes)
        self.measurement_mode = measurement_mode

    @classmethod
    def _construct(cls, registry, time, measurement_mode):
        return cls(time, measurement_mode)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._measurement_on_off(al._handle, self.time, self.measurement_mode)

class Enter(_Event):
    """An @e Enter record indicates that the program enters a code region.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("region", "RegionRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, region, attributes=None):
        super(Enter, self).__init__(time, attributes)
        self.region = region

    @classmethod
    def _construct(cls, registry, time, region):
        return cls(time, registry.regions[region])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._enter(al._handle, self.time, self.region._ref)

class Leave(_Event):
    """A @e Leave record indicates that the program leaves a code region.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("region", "RegionRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, region, attributes=None):
        super(Leave, self).__init__(time, attributes)
        self.region = region

    @classmethod
    def _construct(cls, registry, time, region):
        return cls(time, registry.regions[region])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._leave(al._handle, self.time, self.region._ref)

class MpiSend(_Event):
    """An @e MpiSend record indicates that an MPI send operation was initiated
(MPI_SEND). It keeps the necessary information for this event: receiver
of the message, communicator, and the message tag. You can optionally add
further information like the message length (size of the send buffer).

    """
    _fields = ("time", "int", "the timestamp"), \
              ("receiver", "ctypes.c_uint32", ""), \
              ("communicator", "CommRef", ""), \
              ("msgTag", "ctypes.c_uint32", ""), \
              ("msgLength", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, receiver, communicator, msg_tag, msg_length, attributes=None):
        super(MpiSend, self).__init__(time, attributes)
        self.receiver = receiver
        self.communicator = communicator
        self.msg_tag = msg_tag
        self.msg_length = msg_length

    @classmethod
    def _construct(cls, registry, time, receiver, communicator, msg_tag, msg_length):
        return cls(time, receiver, registry.comms[communicator], msg_tag, msg_length)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_send(al._handle, self.time, self.receiver, self.communicator._ref, self.msg_tag, self.msg_length)

class MpiIsend(_Event):
    """An @e MpiIsend record indicates that a non-blocking MPI send operation was
initiated (MPI_ISEND). It keeps the necessary information for this event:
receiver of the message, communicator, and the message tag. You can
optionally add further information like the message length (size of the
send buffer).

    """
    _fields = ("time", "int", "the timestamp"), \
              ("receiver", "ctypes.c_uint32", ""), \
              ("communicator", "CommRef", ""), \
              ("msgTag", "ctypes.c_uint32", ""), \
              ("msgLength", "ctypes.c_uint64", ""), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, receiver, communicator, msg_tag, msg_length, request_id, attributes=None):
        super(MpiIsend, self).__init__(time, attributes)
        self.receiver = receiver
        self.communicator = communicator
        self.msg_tag = msg_tag
        self.msg_length = msg_length
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, receiver, communicator, msg_tag, msg_length, request_id):
        return cls(time, receiver, registry.comms[communicator], msg_tag, msg_length, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_isend(al._handle, self.time, self.receiver, self.communicator._ref, self.msg_tag, self.msg_length, self.request_id)

class MpiIsendComplete(_Event):
    """An @e MpiIsendComplete record indicates the completion of a non-blocking MPI
send operation. In the case where the send request is released before it is
completed by MPI, this record will only indicate the release, as it becomes
impossible to track the completion of the send operation afterwards. This
case may be identified by the surrounding events.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, request_id, attributes=None):
        super(MpiIsendComplete, self).__init__(time, attributes)
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, request_id):
        return cls(time, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_isend_complete(al._handle, self.time, self.request_id)

class MpiIrecvRequest(_Event):
    """An @e MpiIrecvRequest record indicates that a non-blocking MPI receive
operation was initiated (MPI_IRECV).

    """
    _fields = ("time", "int", "the timestamp"), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, request_id, attributes=None):
        super(MpiIrecvRequest, self).__init__(time, attributes)
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, request_id):
        return cls(time, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_irecv_request(al._handle, self.time, self.request_id)

class MpiRecv(_Event):
    """An @e MpiRecv record indicates that an MPI message was received (MPI_RECV). It
keeps the necessary information for this event: sender of the message,
communicator, and the message tag. You can optionally add further
information like the message length (size of the receive buffer).

    """
    _fields = ("time", "int", "the timestamp"), \
              ("sender", "ctypes.c_uint32", ""), \
              ("communicator", "CommRef", ""), \
              ("msgTag", "ctypes.c_uint32", ""), \
              ("msgLength", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, sender, communicator, msg_tag, msg_length, attributes=None):
        super(MpiRecv, self).__init__(time, attributes)
        self.sender = sender
        self.communicator = communicator
        self.msg_tag = msg_tag
        self.msg_length = msg_length

    @classmethod
    def _construct(cls, registry, time, sender, communicator, msg_tag, msg_length):
        return cls(time, sender, registry.comms[communicator], msg_tag, msg_length)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_recv(al._handle, self.time, self.sender, self.communicator._ref, self.msg_tag, self.msg_length)

class MpiIrecv(_Event):
    """An @e MpiIrecv record indicates the completion of a non-blocking MPI receive
operation completed (MPI_IRECV). It keeps the necessary information for this
event: sender of the message, communicator, and the message tag. You can
optionally add further information like the message length (size of the
receive buffer).

    """
    _fields = ("time", "int", "the timestamp"), \
              ("sender", "ctypes.c_uint32", ""), \
              ("communicator", "CommRef", ""), \
              ("msgTag", "ctypes.c_uint32", ""), \
              ("msgLength", "ctypes.c_uint64", ""), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, sender, communicator, msg_tag, msg_length, request_id, attributes=None):
        super(MpiIrecv, self).__init__(time, attributes)
        self.sender = sender
        self.communicator = communicator
        self.msg_tag = msg_tag
        self.msg_length = msg_length
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, sender, communicator, msg_tag, msg_length, request_id):
        return cls(time, sender, registry.comms[communicator], msg_tag, msg_length, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_irecv(al._handle, self.time, self.sender, self.communicator._ref, self.msg_tag, self.msg_length, self.request_id)

class MpiRequestTest(_Event):
    """This events appears if the program tests if a request has already completed
but the test failed.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, request_id, attributes=None):
        super(MpiRequestTest, self).__init__(time, attributes)
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, request_id):
        return cls(time, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_request_test(al._handle, self.time, self.request_id)

class MpiRequestCancelled(_Event):
    """This events appears if the program canceled a request.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, request_id, attributes=None):
        super(MpiRequestCancelled, self).__init__(time, attributes)
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, request_id):
        return cls(time, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_request_cancelled(al._handle, self.time, self.request_id)

class MpiCollectiveBegin(_Event):
    """An @e MpiCollectiveBegin record marks the begin of an MPI collective operation
(MPI_GATHER, MPI_SCATTER etc.).

    """
    _fields = ("time", "int", "the timestamp"), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, attributes=None):
        super(MpiCollectiveBegin, self).__init__(time, attributes)

    @classmethod
    def _construct(cls, registry, time):
        return cls(time, )

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_collective_begin(al._handle, self.time, )

class MpiCollectiveEnd(_Event):
    """An @e MpiCollectiveEnd record marks the end of an MPI collective operation
(MPI_GATHER, MPI_SCATTER etc.). It keeps the necessary information for this
event: type of collective operation, communicator, the root of this
collective operation. You can optionally add further information like sent
and received bytes.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("collectiveOp", "CollectiveOp", ""), \
              ("communicator", "CommRef", ""), \
              ("root", "ctypes.c_uint32", ""), \
              ("sizeSent", "ctypes.c_uint64", ""), \
              ("sizeReceived", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, collective_op, communicator, root, size_sent, size_received, attributes=None):
        super(MpiCollectiveEnd, self).__init__(time, attributes)
        self.collective_op = collective_op
        self.communicator = communicator
        self.root = root
        self.size_sent = size_sent
        self.size_received = size_received

    @classmethod
    def _construct(cls, registry, time, collective_op, communicator, root, size_sent, size_received):
        return cls(time, collective_op, registry.comms[communicator], root, size_sent, size_received)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._mpi_collective_end(al._handle, self.time, self.collective_op, self.communicator._ref, self.root, self.size_sent, self.size_received)

class OmpFork(_Event):
    """An @e OmpFork record marks that an OpenMP Thread forks a thread team.

This event record is superseded by the @eref{ThreadFork} event record and
should not be used when the @eref{ThreadFork} event record is in use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("numberOfRequestedThreads", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, number_of_requested_threads, attributes=None):
        super(OmpFork, self).__init__(time, attributes)
        self.number_of_requested_threads = number_of_requested_threads

    @classmethod
    def _construct(cls, registry, time, number_of_requested_threads):
        return cls(time, number_of_requested_threads)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_fork(al._handle, self.time, self.number_of_requested_threads)

class OmpJoin(_Event):
    """An @e OmpJoin record marks that a team of threads is joint and only the master
thread continues execution.

This event record is superseded by the @eref{ThreadJoin} event record and
should not be used when the @eref{ThreadJoin} event record is in use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, attributes=None):
        super(OmpJoin, self).__init__(time, attributes)

    @classmethod
    def _construct(cls, registry, time):
        return cls(time, )

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_join(al._handle, self.time, )

class OmpAcquireLock(_Event):
    """An @e OmpAcquireLock record marks that a thread acquires an OpenMP lock.

This event record is superseded by the @eref{ThreadAcquireLock} event
record and should not be used when the @eref{ThreadAcquireLock} event
record is in use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("lockID", "ctypes.c_uint32", ""), \
              ("acquisitionOrder", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, lock_id, acquisition_order, attributes=None):
        super(OmpAcquireLock, self).__init__(time, attributes)
        self.lock_id = lock_id
        self.acquisition_order = acquisition_order

    @classmethod
    def _construct(cls, registry, time, lock_id, acquisition_order):
        return cls(time, lock_id, acquisition_order)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_acquire_lock(al._handle, self.time, self.lock_id, self.acquisition_order)

class OmpReleaseLock(_Event):
    """An @e OmpReleaseLock record marks that a thread releases an OpenMP lock.

This event record is superseded by the @eref{ThreadReleaseLock} event
record and should not be used when the @eref{ThreadReleaseLock} event
record is in use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("lockID", "ctypes.c_uint32", ""), \
              ("acquisitionOrder", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, lock_id, acquisition_order, attributes=None):
        super(OmpReleaseLock, self).__init__(time, attributes)
        self.lock_id = lock_id
        self.acquisition_order = acquisition_order

    @classmethod
    def _construct(cls, registry, time, lock_id, acquisition_order):
        return cls(time, lock_id, acquisition_order)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_release_lock(al._handle, self.time, self.lock_id, self.acquisition_order)

class OmpTaskCreate(_Event):
    """An @e OmpTaskCreate record marks that an OpenMP Task was/will be created in
the current region.

This event record is superseded by the @eref{ThreadTaskCreate} event record
and should not be used when the @eref{ThreadTaskCreate} event record is in
use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("taskID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, task_id, attributes=None):
        super(OmpTaskCreate, self).__init__(time, attributes)
        self.task_id = task_id

    @classmethod
    def _construct(cls, registry, time, task_id):
        return cls(time, task_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_task_create(al._handle, self.time, self.task_id)

class OmpTaskSwitch(_Event):
    """An @e OmpTaskSwitch record indicates that the execution of the current task
will be suspended and another task starts/restarts its execution.
Please note that this may change the current call stack of the executing
location.

This event record is superseded by the @eref{ThreadTaskSwitch} event record
and should not be used when the @eref{ThreadTaskSwitch} event record is in
use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("taskID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, task_id, attributes=None):
        super(OmpTaskSwitch, self).__init__(time, attributes)
        self.task_id = task_id

    @classmethod
    def _construct(cls, registry, time, task_id):
        return cls(time, task_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_task_switch(al._handle, self.time, self.task_id)

class OmpTaskComplete(_Event):
    """An @e OmpTaskComplete record indicates that the execution of an OpenMP task
has finished.

This event record is superseded by the @eref{ThreadTaskComplete} event
record and should not be used when the @eref{ThreadTaskComplete} event
record is in use.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("taskID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, task_id, attributes=None):
        super(OmpTaskComplete, self).__init__(time, attributes)
        self.task_id = task_id

    @classmethod
    def _construct(cls, registry, time, task_id):
        return cls(time, task_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._omp_task_complete(al._handle, self.time, self.task_id)

class Metric(_Event):
    """
        This event represents a measurement point.
    """

    _fields = ("time", "int", "the timestamp"), \
              ("metric", "MetricRef", "the :py:class:`otf2.definitions.MetricClass` or \
               :py:class:`otf2.definitions.MetricInstance`"), \
              ("values", "array", "an array of values, one for each :py:class:`otf2.definitions.MetricMember`"), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, metric, values, attributes=None):
        super(Metric, self).__init__(time, attributes)
        self.metric = metric
        if isinstance(values, Number):
            self.values = [values]
        else:
            self.values = values

    @property
    def value(self):
        if len(self.values) != 1:
            raise AttributeError(
                "Trying to access singular metric value on metric event with {} values".format(
                    len(self.values)))
        return self.values[0]

    @value.setter
    def value(self, new_value):
        if len(self.values) != 1:
            raise AttributeError(
                "Trying to access singular metric value on metric event with {} values".format(
                    len(self.values)))
        self.values[0] = new_value

    @property
    def member(self):
        if len(self.values) != 1:
            raise AttributeError(
                "Trying to access singular metric value on metric event with {} values".format(
                    len(self.values)))
        return self.metric.members[0]

    @property
    def scaled_value(self):
        if self.member.base == Base.DECIMAL:
            base = 10
        else:
            base = 2

        return self.value * pow(base, self.member.exponent)

    @property
    def scaled_values(self):
        def get_base(base):
            if base == Base.DECIMAL:
                return 10
            return 2

        return [value * pow(get_base(member.base), member.exponent) for value, member in
                zip(self.values, self.metric.members)]

    @classmethod
    def _construct(cls, registry, time, metric_ref, type_ids, union_values):
        # Type ids is redundant with the ids from the metric itself, we don't check the consistency
        # for performance reaons
        metric = registry.metrics[metric_ref]
        values = metric._convert_unions(union_values)
        return cls(time, metric, values)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._metric(al._handle, self.time, self.metric._ref, self.metric._type_ids,
                           self.metric._convert_values(self.values))
class ParameterString(_Event):
    """A ParameterString record marks that in the current region, the specified
string parameter has the specified value.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("parameter", "ParameterRef", ""), \
              ("string", "StringRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, parameter, string, attributes=None):
        super(ParameterString, self).__init__(time, attributes)
        if parameter.parameter_type != ParameterType.STRING:
            raise TypeError("Expected parameter of type STRING, but got {}".format(parameter.parameter_type))
        self.parameter = parameter
        self.string = string

    @classmethod
    def _construct(cls, registry, time, parameter, string):
        return cls(time, registry.parameters[parameter], registry.strings[string])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._parameter_string(al._handle, self.time, self.parameter._ref, _get_string_ref(writer, self.string))

class ParameterInt(_Event):
    """A @e ParameterInt record marks that in the current region, the specified
integer parameter has the specified value.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("parameter", "ParameterRef", ""), \
              ("value", "ctypes.c_int64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, parameter, value, attributes=None):
        super(ParameterInt, self).__init__(time, attributes)
        if parameter.parameter_type != ParameterType.INT64:
            raise TypeError("Expected parameter of type INT64, but got {}".format(parameter.parameter_type))
        self.parameter = parameter
        if not isinstance(value, Integral):
            raise TypeError("Expected INT64 parameter value, but got {}".format(type(value)))
        self.value = value

    @classmethod
    def _construct(cls, registry, time, parameter, value):
        return cls(time, registry.parameters[parameter], value)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._parameter_int(al._handle, self.time, self.parameter._ref, self.value)

class ParameterUnsignedInt(_Event):
    """A @e ParameterUnsignedInt record marks that in the current region, the
specified unsigned integer parameter has the specified value.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("parameter", "ParameterRef", ""), \
              ("value", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, parameter, value, attributes=None):
        super(ParameterUnsignedInt, self).__init__(time, attributes)
        if parameter.parameter_type != ParameterType.UINT64:
            raise TypeError("Expected parameter of type UINT64, but got {}".format(parameter.parameter_type))
        self.parameter = parameter
        if not isinstance(value, Integral) or value < 0:
            raise TypeError("Expected UINT64 parameter value, but got {}".format(type(value)))
        self.value = value

    @classmethod
    def _construct(cls, registry, time, parameter, value):
        return cls(time, registry.parameters[parameter], value)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._parameter_unsigned_int(al._handle, self.time, self.parameter._ref, self.value)

class RmaWinCreate(_Event):
    """An @e RmaWinCreate record denotes the creation of an RMA window. Only valid
if the @eref{RmaWin} definition was flagged with
@eref{OTF2_RMA_WIN_FLAG_CREATE_DESTROY_EVENTS}. This event can be enclosed
by an @eref{RmaCollectiveBegin} and @eref{RmaCollectiveEnd} event pair either
with @eref{OTF2_COLLECTIVE_OP_CREATE_HANDLE} or
@eref{OTF2_COLLECTIVE_OP_CREATE_HANDLE_AND_ALLOCATE} as the operation type.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, attributes=None):
        super(RmaWinCreate, self).__init__(time, attributes)
        self.win = win

    @classmethod
    def _construct(cls, registry, time, win):
        return cls(time, registry.rma_wins[win])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_win_create(al._handle, self.time, self.win._ref)

class RmaWinDestroy(_Event):
    """An @e RmaWinDestroy record denotes the destruction of an RMA window. Only
valid if the @eref{RmaWin} definition was flagged with
@eref{OTF2_RMA_WIN_FLAG_CREATE_DESTROY_EVENTS}. This event can be enclosed
by an @eref{RmaCollectiveBegin} and @eref{RmaCollectiveEnd} event pair
either with @eref{OTF2_COLLECTIVE_OP_DESTROY_HANDLE} or
@eref{OTF2_COLLECTIVE_OP_DESTROY_HANDLE_AND_DEALLOCATE} as the operation type.
In this case the RMA window is only marked for destruction, which will happen
with the @eref{RmaCollectiveEnd} event.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, attributes=None):
        super(RmaWinDestroy, self).__init__(time, attributes)
        self.win = win

    @classmethod
    def _construct(cls, registry, time, win):
        return cls(time, registry.rma_wins[win])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_win_destroy(al._handle, self.time, self.win._ref)

class RmaCollectiveBegin(_Event):
    """An @e RmaCollectiveBegin record denotes the beginning of a collective RMA
operation.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, attributes=None):
        super(RmaCollectiveBegin, self).__init__(time, attributes)

    @classmethod
    def _construct(cls, registry, time):
        return cls(time, )

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_collective_begin(al._handle, self.time, )

class RmaCollectiveEnd(_Event):
    """An @e RmaCollectiveEnd record denotes the end of a collective RMA operation.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("collectiveOp", "CollectiveOp", ""), \
              ("syncLevel", "RmaSyncLevel", ""), \
              ("win", "RmaWinRef", ""), \
              ("root", "ctypes.c_uint32", ""), \
              ("bytesSent", "ctypes.c_uint64", ""), \
              ("bytesReceived", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, collective_op, sync_level, win, root, bytes_sent, bytes_received, attributes=None):
        super(RmaCollectiveEnd, self).__init__(time, attributes)
        self.collective_op = collective_op
        self.sync_level = sync_level
        self.win = win
        self.root = root
        self.bytes_sent = bytes_sent
        self.bytes_received = bytes_received

    @classmethod
    def _construct(cls, registry, time, collective_op, sync_level, win, root, bytes_sent, bytes_received):
        return cls(time, collective_op, sync_level, registry.rma_wins[win], root, bytes_sent, bytes_received)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_collective_end(al._handle, self.time, self.collective_op, self.sync_level, self.win._ref, self.root, self.bytes_sent, self.bytes_received)

class RmaGroupSync(_Event):
    """An @e RmaGroupSync record denotes the synchronization with a subgroup of
processes on an RMA window.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("syncLevel", "RmaSyncLevel", ""), \
              ("win", "RmaWinRef", ""), \
              ("group", "GroupRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, sync_level, win, group, attributes=None):
        super(RmaGroupSync, self).__init__(time, attributes)
        self.sync_level = sync_level
        self.win = win
        self.group = group

    @classmethod
    def _construct(cls, registry, time, sync_level, win, group):
        return cls(time, sync_level, registry.rma_wins[win], registry.groups[group])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_group_sync(al._handle, self.time, self.sync_level, self.win._ref, self.group._ref)

class RmaRequestLock(_Event):
    """An @e RmaRequestLock record denotes the time a lock was requested and with
it the earliest time it could have been granted.  It is used to mark
(possibly) non-blocking lock request, as defined by the MPI standard.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("lockId", "ctypes.c_uint64", ""), \
              ("lockType", "LockType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, lock_id, lock_type, attributes=None):
        super(RmaRequestLock, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.lock_id = lock_id
        self.lock_type = lock_type

    @classmethod
    def _construct(cls, registry, time, win, remote, lock_id, lock_type):
        return cls(time, registry.rma_wins[win], remote, lock_id, lock_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_request_lock(al._handle, self.time, self.win._ref, self.remote, self.lock_id, self.lock_type)

class RmaAcquireLock(_Event):
    """An @e RmaAcquireLock record denotes the time a lock was acquired by the
process.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("lockId", "ctypes.c_uint64", ""), \
              ("lockType", "LockType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, lock_id, lock_type, attributes=None):
        super(RmaAcquireLock, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.lock_id = lock_id
        self.lock_type = lock_type

    @classmethod
    def _construct(cls, registry, time, win, remote, lock_id, lock_type):
        return cls(time, registry.rma_wins[win], remote, lock_id, lock_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_acquire_lock(al._handle, self.time, self.win._ref, self.remote, self.lock_id, self.lock_type)

class RmaTryLock(_Event):
    """An @e RmaTryLock record denotes the time of an unsuccessful attempt to
acquire the lock.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("lockId", "ctypes.c_uint64", ""), \
              ("lockType", "LockType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, lock_id, lock_type, attributes=None):
        super(RmaTryLock, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.lock_id = lock_id
        self.lock_type = lock_type

    @classmethod
    def _construct(cls, registry, time, win, remote, lock_id, lock_type):
        return cls(time, registry.rma_wins[win], remote, lock_id, lock_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_try_lock(al._handle, self.time, self.win._ref, self.remote, self.lock_id, self.lock_type)

class RmaReleaseLock(_Event):
    """An @e RmaReleaseLock record denotes the time the lock was released.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("lockId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, lock_id, attributes=None):
        super(RmaReleaseLock, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.lock_id = lock_id

    @classmethod
    def _construct(cls, registry, time, win, remote, lock_id):
        return cls(time, registry.rma_wins[win], remote, lock_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_release_lock(al._handle, self.time, self.win._ref, self.remote, self.lock_id)

class RmaSync(_Event):
    """An @e RmaSync record denotes the direct synchronization with a possibly
remote process.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("syncType", "RmaSyncType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, sync_type, attributes=None):
        super(RmaSync, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.sync_type = sync_type

    @classmethod
    def _construct(cls, registry, time, win, remote, sync_type):
        return cls(time, registry.rma_wins[win], remote, sync_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_sync(al._handle, self.time, self.win._ref, self.remote, self.sync_type)

class RmaWaitChange(_Event):
    """An @e RmaWaitChange record denotes the change of a window that was waited
for.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, attributes=None):
        super(RmaWaitChange, self).__init__(time, attributes)
        self.win = win

    @classmethod
    def _construct(cls, registry, time, win):
        return cls(time, registry.rma_wins[win])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_wait_change(al._handle, self.time, self.win._ref)

class RmaPut(_Event):
    """An @e RmaPut record denotes the time a put operation was issued.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("bytes", "ctypes.c_uint64", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, bytes, matching_id, attributes=None):
        super(RmaPut, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.bytes = bytes
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, remote, bytes, matching_id):
        return cls(time, registry.rma_wins[win], remote, bytes, matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_put(al._handle, self.time, self.win._ref, self.remote, self.bytes, self.matching_id)

class RmaGet(_Event):
    """An @e RmaGet record denotes the time a get operation was issued.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("bytes", "ctypes.c_uint64", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, bytes, matching_id, attributes=None):
        super(RmaGet, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.bytes = bytes
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, remote, bytes, matching_id):
        return cls(time, registry.rma_wins[win], remote, bytes, matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_get(al._handle, self.time, self.win._ref, self.remote, self.bytes, self.matching_id)

class RmaAtomic(_Event):
    """An @e RmaAtomic record denotes the time an atomic RMA operation was issued.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("remote", "ctypes.c_uint32", ""), \
              ("type", "RmaAtomicType", ""), \
              ("bytesSent", "ctypes.c_uint64", ""), \
              ("bytesReceived", "ctypes.c_uint64", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, remote, type, bytes_sent, bytes_received, matching_id, attributes=None):
        super(RmaAtomic, self).__init__(time, attributes)
        self.win = win
        self.remote = remote
        self.type = type
        self.bytes_sent = bytes_sent
        self.bytes_received = bytes_received
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, remote, type, bytes_sent, bytes_received, matching_id):
        return cls(time, registry.rma_wins[win], remote, type, bytes_sent, bytes_received, matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_atomic(al._handle, self.time, self.win._ref, self.remote, self.type, self.bytes_sent, self.bytes_received, self.matching_id)

class RmaOpCompleteBlocking(_Event):
    """An @e RmaOpCompleteBlocking record denotes the local completion of a
blocking RMA operation.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, matching_id, attributes=None):
        super(RmaOpCompleteBlocking, self).__init__(time, attributes)
        self.win = win
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, matching_id):
        return cls(time, registry.rma_wins[win], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_op_complete_blocking(al._handle, self.time, self.win._ref, self.matching_id)

class RmaOpCompleteNonBlocking(_Event):
    """An @e RmaOpCompleteNonBlocking record denotes the local completion of a
non-blocking RMA operation.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, matching_id, attributes=None):
        super(RmaOpCompleteNonBlocking, self).__init__(time, attributes)
        self.win = win
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, matching_id):
        return cls(time, registry.rma_wins[win], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_op_complete_non_blocking(al._handle, self.time, self.win._ref, self.matching_id)

class RmaOpTest(_Event):
    """An @e RmaOpTest record denotes that a non-blocking RMA operation has been
tested for completion unsuccessfully.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, matching_id, attributes=None):
        super(RmaOpTest, self).__init__(time, attributes)
        self.win = win
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, matching_id):
        return cls(time, registry.rma_wins[win], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_op_test(al._handle, self.time, self.win._ref, self.matching_id)

class RmaOpCompleteRemote(_Event):
    """An @e RmaOpCompleteRemote record denotes the remote completion of an RMA
operation.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("win", "RmaWinRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, win, matching_id, attributes=None):
        super(RmaOpCompleteRemote, self).__init__(time, attributes)
        self.win = win
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, win, matching_id):
        return cls(time, registry.rma_wins[win], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._rma_op_complete_remote(al._handle, self.time, self.win._ref, self.matching_id)

class ThreadFork(_Event):
    """A @e ThreadFork record marks that a thread forks a thread team.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("model", "Paradigm", ""), \
              ("numberOfRequestedThreads", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, model, number_of_requested_threads, attributes=None):
        super(ThreadFork, self).__init__(time, attributes)
        self.model = model
        self.number_of_requested_threads = number_of_requested_threads

    @classmethod
    def _construct(cls, registry, time, model, number_of_requested_threads):
        return cls(time, model, number_of_requested_threads)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_fork(al._handle, self.time, self.model, self.number_of_requested_threads)

class ThreadJoin(_Event):
    """A @e ThreadJoin record marks that a team of threads is joint and only the
master thread continues execution.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("model", "Paradigm", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, model, attributes=None):
        super(ThreadJoin, self).__init__(time, attributes)
        self.model = model

    @classmethod
    def _construct(cls, registry, time, model):
        return cls(time, model)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_join(al._handle, self.time, self.model)

class ThreadTeamBegin(_Event):
    """The current location enters the specified thread team.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadTeam", "CommRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_team, attributes=None):
        super(ThreadTeamBegin, self).__init__(time, attributes)
        self.thread_team = thread_team

    @classmethod
    def _construct(cls, registry, time, thread_team):
        return cls(time, registry.comms[thread_team])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_team_begin(al._handle, self.time, self.thread_team._ref)

class ThreadTeamEnd(_Event):
    """The current location leaves the specified thread team.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadTeam", "CommRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_team, attributes=None):
        super(ThreadTeamEnd, self).__init__(time, attributes)
        self.thread_team = thread_team

    @classmethod
    def _construct(cls, registry, time, thread_team):
        return cls(time, registry.comms[thread_team])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_team_end(al._handle, self.time, self.thread_team._ref)

class ThreadAcquireLock(_Event):
    """A @e ThreadAcquireLock record marks that a thread acquires a lock.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("model", "Paradigm", ""), \
              ("lockID", "ctypes.c_uint32", ""), \
              ("acquisitionOrder", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, model, lock_id, acquisition_order, attributes=None):
        super(ThreadAcquireLock, self).__init__(time, attributes)
        self.model = model
        self.lock_id = lock_id
        self.acquisition_order = acquisition_order

    @classmethod
    def _construct(cls, registry, time, model, lock_id, acquisition_order):
        return cls(time, model, lock_id, acquisition_order)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_acquire_lock(al._handle, self.time, self.model, self.lock_id, self.acquisition_order)

class ThreadReleaseLock(_Event):
    """A @e ThreadReleaseLock record marks that a thread releases a lock.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("model", "Paradigm", ""), \
              ("lockID", "ctypes.c_uint32", ""), \
              ("acquisitionOrder", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, model, lock_id, acquisition_order, attributes=None):
        super(ThreadReleaseLock, self).__init__(time, attributes)
        self.model = model
        self.lock_id = lock_id
        self.acquisition_order = acquisition_order

    @classmethod
    def _construct(cls, registry, time, model, lock_id, acquisition_order):
        return cls(time, model, lock_id, acquisition_order)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_release_lock(al._handle, self.time, self.model, self.lock_id, self.acquisition_order)

class ThreadTaskCreate(_Event):
    """A @e ThreadTaskCreate record marks that a task in was/will be created and
will be processed by the specified thread team.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadTeam", "CommRef", ""), \
              ("creatingThread", "ctypes.c_uint32", ""), \
              ("generationNumber", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_team, creating_thread, generation_number, attributes=None):
        super(ThreadTaskCreate, self).__init__(time, attributes)
        self.thread_team = thread_team
        self.creating_thread = creating_thread
        self.generation_number = generation_number

    @classmethod
    def _construct(cls, registry, time, thread_team, creating_thread, generation_number):
        return cls(time, registry.comms[thread_team], creating_thread, generation_number)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_task_create(al._handle, self.time, self.thread_team._ref, self.creating_thread, self.generation_number)

class ThreadTaskSwitch(_Event):
    """A @e ThreadTaskSwitch record indicates that the execution of the current
task will be suspended and another task starts/restarts its execution.
Please note that this may change the current call stack of the executing
location.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadTeam", "CommRef", ""), \
              ("creatingThread", "ctypes.c_uint32", ""), \
              ("generationNumber", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_team, creating_thread, generation_number, attributes=None):
        super(ThreadTaskSwitch, self).__init__(time, attributes)
        self.thread_team = thread_team
        self.creating_thread = creating_thread
        self.generation_number = generation_number

    @classmethod
    def _construct(cls, registry, time, thread_team, creating_thread, generation_number):
        return cls(time, registry.comms[thread_team], creating_thread, generation_number)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_task_switch(al._handle, self.time, self.thread_team._ref, self.creating_thread, self.generation_number)

class ThreadTaskComplete(_Event):
    """A @e ThreadTaskComplete record indicates that the execution of an OpenMP
task has finished.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadTeam", "CommRef", ""), \
              ("creatingThread", "ctypes.c_uint32", ""), \
              ("generationNumber", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_team, creating_thread, generation_number, attributes=None):
        super(ThreadTaskComplete, self).__init__(time, attributes)
        self.thread_team = thread_team
        self.creating_thread = creating_thread
        self.generation_number = generation_number

    @classmethod
    def _construct(cls, registry, time, thread_team, creating_thread, generation_number):
        return cls(time, registry.comms[thread_team], creating_thread, generation_number)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_task_complete(al._handle, self.time, self.thread_team._ref, self.creating_thread, self.generation_number)

class ThreadCreate(_Event):
    """The location created successfully a new thread.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadContingent", "CommRef", ""), \
              ("sequenceCount", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_contingent, sequence_count, attributes=None):
        super(ThreadCreate, self).__init__(time, attributes)
        self.thread_contingent = thread_contingent
        self.sequence_count = sequence_count

    @classmethod
    def _construct(cls, registry, time, thread_contingent, sequence_count):
        return cls(time, registry.comms[thread_contingent], sequence_count)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_create(al._handle, self.time, self.thread_contingent._ref, self.sequence_count)

class ThreadBegin(_Event):
    """Marks the begin of a thread created by another thread.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadContingent", "CommRef", ""), \
              ("sequenceCount", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_contingent, sequence_count, attributes=None):
        super(ThreadBegin, self).__init__(time, attributes)
        self.thread_contingent = thread_contingent
        self.sequence_count = sequence_count

    @classmethod
    def _construct(cls, registry, time, thread_contingent, sequence_count):
        return cls(time, registry.comms[thread_contingent], sequence_count)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_begin(al._handle, self.time, self.thread_contingent._ref, self.sequence_count)

class ThreadWait(_Event):
    """The location waits for the completion of another thread.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadContingent", "CommRef", ""), \
              ("sequenceCount", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_contingent, sequence_count, attributes=None):
        super(ThreadWait, self).__init__(time, attributes)
        self.thread_contingent = thread_contingent
        self.sequence_count = sequence_count

    @classmethod
    def _construct(cls, registry, time, thread_contingent, sequence_count):
        return cls(time, registry.comms[thread_contingent], sequence_count)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_wait(al._handle, self.time, self.thread_contingent._ref, self.sequence_count)

class ThreadEnd(_Event):
    """Marks the end of a thread.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("threadContingent", "CommRef", ""), \
              ("sequenceCount", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, thread_contingent, sequence_count, attributes=None):
        super(ThreadEnd, self).__init__(time, attributes)
        self.thread_contingent = thread_contingent
        self.sequence_count = sequence_count

    @classmethod
    def _construct(cls, registry, time, thread_contingent, sequence_count):
        return cls(time, registry.comms[thread_contingent], sequence_count)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._thread_end(al._handle, self.time, self.thread_contingent._ref, self.sequence_count)

class CallingContextEnter(_Event):
    """The thread entered an instrumented region, represented by the referenced
@eref{CallingContext}. In contrast to the @eref{Enter} event, it gives
the full calling context through the @eref{CallingContext} tree.

Events based on the @eref{CallingContext} definition are mutually exclusive
with the @eref{Enter}/@eref{Leave} events in a trace.

If no callback for this event is set but a callback for @eref{Enter} events
is defined, the reader will automatically generate an @eref{Enter} callback
call for the @eref{Region} referenced by the @eref{CallingContext} attribute
of this event.  Note that this emulation does @b not re-create the full
calling context!  It only re-creates the event order for instrumented
regions.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("callingContext", "CallingContextRef", ""), \
              ("unwindDistance", "ctypes.c_uint32", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, calling_context, unwind_distance, attributes=None):
        super(CallingContextEnter, self).__init__(time, attributes)
        self.calling_context = calling_context
        self.unwind_distance = unwind_distance

    @classmethod
    def _construct(cls, registry, time, calling_context, unwind_distance):
        return cls(time, registry.calling_contexts[calling_context], unwind_distance)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._calling_context_enter(al._handle, self.time, self.calling_context._ref, self.unwind_distance)

class CallingContextLeave(_Event):
    """The thread left an instrumented region, represented by the referenced
@eref{CallingContext}. In contrast to the @eref{Leave} event, it gives
the full calling context through the @eref{CallingContext} tree.

The unwind distance for this @eref{CallingContext} is defined to be 1.
Because it must be assumed that the instrumented region made progress
since the previous @eref{CallingContext} event.

Events based on the @eref{CallingContext} definition are mutually exclusive
with the @eref{Enter}/@eref{Leave} events in a trace.

The parent of the @eref{CallingContext} must be used as the previous calling
context for the next event.

If no callback for this event is set but a callback for @eref{Leave} events
is defined, the reader will automatically generate an @eref{Leave} callback
call for the @eref{Region} referenced by the @eref{CallingContext} attribute
of this event.  Note that this emulation does @b not re-create the full
calling context!  It only re-creates the event order for instrumented
regions.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("callingContext", "CallingContextRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, calling_context, attributes=None):
        super(CallingContextLeave, self).__init__(time, attributes)
        self.calling_context = calling_context

    @classmethod
    def _construct(cls, registry, time, calling_context):
        return cls(time, registry.calling_contexts[calling_context])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._calling_context_leave(al._handle, self.time, self.calling_context._ref)

class CallingContextSample(_Event):
    """The thread was interrupted to take a sample of its current state (region and
source code location).

Events based on the @eref{CallingContext} definition are mutually exclusive
with the @eref{Enter}/@eref{Leave} events in a trace.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("callingContext", "CallingContextRef", ""), \
              ("unwindDistance", "ctypes.c_uint32", ""), \
              ("interruptGenerator", "InterruptGeneratorRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, calling_context, unwind_distance, interrupt_generator, attributes=None):
        super(CallingContextSample, self).__init__(time, attributes)
        self.calling_context = calling_context
        self.unwind_distance = unwind_distance
        self.interrupt_generator = interrupt_generator

    @classmethod
    def _construct(cls, registry, time, calling_context, unwind_distance, interrupt_generator):
        return cls(time, registry.calling_contexts[calling_context], unwind_distance, registry.interrupt_generators[interrupt_generator])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._calling_context_sample(al._handle, self.time, self.calling_context._ref, self.unwind_distance, self.interrupt_generator._ref)

class IoCreateHandle(_Event):
    """An @e IoCreateHandle record marks the creation of a new @emph{active} I/O
handle that can be used by subsequent I/O operation events.

An @eref{IoHandle} is @emph{active} between a pair of consecutive @eref{IoCreateHandle}
and @eref{IoDestroyHandle} events. All @eref{Location}s of a @eref{LocationGroup}
have access to an @emph{active} @eref{IoHandle}.

If the @eref{Comm} attribute of the @eref{IoHandle} handle is not
@eref{OTF2_UNDEFINED_COMM}, this is a collective operation over @eref{Comm}.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("mode", "IoAccessMode", ""), \
              ("creationFlags", "IoCreationFlag", ""), \
              ("statusFlags", "IoStatusFlag", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, mode, creation_flags, status_flags, attributes=None):
        super(IoCreateHandle, self).__init__(time, attributes)
        self.handle = handle
        self.mode = mode
        self.creation_flags = creation_flags
        self.status_flags = status_flags

    @classmethod
    def _construct(cls, registry, time, handle, mode, creation_flags, status_flags):
        return cls(time, registry.io_handles[handle], mode, creation_flags, status_flags)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_create_handle(al._handle, self.time, self.handle._ref, self.mode, self.creation_flags, self.status_flags)

class IoDestroyHandle(_Event):
    """An @e IoDestroyHandle record marks the end of an @emph{active} I/O handle's
lifetime.

An @eref{IoHandle} is @emph{active} between a pair of consecutive
@eref{IoCreateHandle} and @eref{IoDestroyHandle} events. All
@eref{Location}s of a @eref{LocationGroup} have access to an @emph{active}
@eref{IoHandle}.

If the @eref{Comm} attribute of the @eref{IoHandle} handle is not
@eref{OTF2_UNDEFINED_COMM}, this is a collective operation over @eref{Comm}.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, attributes=None):
        super(IoDestroyHandle, self).__init__(time, attributes)
        self.handle = handle

    @classmethod
    def _construct(cls, registry, time, handle):
        return cls(time, registry.io_handles[handle])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_destroy_handle(al._handle, self.time, self.handle._ref)

class IoDuplicateHandle(_Event):
    """An @e IoDuplicateHandle record marks the duplication of an already
existing @emph{active} I/O handle.

The new I/O handle @p newHandle is @emph{active} after this event.

Both @eref{IoHandle}s must reference the same @eref{Comm} definition or be
@eref{OTF2_UNDEFINED_COMM}.  If the @eref{Comm} attribute of the @eref{IoHandle}
handles is not @eref{OTF2_UNDEFINED_COMM}, this is a collective operation over
@eref{Comm}.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("oldHandle", "IoHandleRef", ""), \
              ("newHandle", "IoHandleRef", ""), \
              ("statusFlags", "IoStatusFlag", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, old_handle, new_handle, status_flags, attributes=None):
        super(IoDuplicateHandle, self).__init__(time, attributes)
        self.old_handle = old_handle
        self.new_handle = new_handle
        self.status_flags = status_flags

    @classmethod
    def _construct(cls, registry, time, old_handle, new_handle, status_flags):
        return cls(time, registry.io_handles[old_handle], registry.io_handles[new_handle], status_flags)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_duplicate_handle(al._handle, self.time, self.old_handle._ref, self.new_handle._ref, self.status_flags)

class IoSeek(_Event):
    """An @e IoSeek record marks a change of the position, e.g., within a file.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("offsetRequest", "ctypes.c_int64", ""), \
              ("whence", "IoSeekOption", ""), \
              ("offsetResult", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, offset_request, whence, offset_result, attributes=None):
        super(IoSeek, self).__init__(time, attributes)
        self.handle = handle
        self.offset_request = offset_request
        self.whence = whence
        self.offset_result = offset_result

    @classmethod
    def _construct(cls, registry, time, handle, offset_request, whence, offset_result):
        return cls(time, registry.io_handles[handle], offset_request, whence, offset_result)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_seek(al._handle, self.time, self.handle._ref, self.offset_request, self.whence, self.offset_result)

class IoChangeStatusFlags(_Event):
    """An @e IoChangeStatusFlags record marks a change to the status flags
associated with an @emph{active} I/O handle.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("statusFlags", "IoStatusFlag", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, status_flags, attributes=None):
        super(IoChangeStatusFlags, self).__init__(time, attributes)
        self.handle = handle
        self.status_flags = status_flags

    @classmethod
    def _construct(cls, registry, time, handle, status_flags):
        return cls(time, registry.io_handles[handle], status_flags)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_change_status_flags(al._handle, self.time, self.handle._ref, self.status_flags)

class IoDeleteFile(_Event):
    """An @e IoDeleteFile record marks the deletion of an I/O file.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("ioParadigm", "IoParadigmRef", ""), \
              ("file", "IoFileRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, io_paradigm, file, attributes=None):
        super(IoDeleteFile, self).__init__(time, attributes)
        self.io_paradigm = io_paradigm
        self.file = file

    @classmethod
    def _construct(cls, registry, time, io_paradigm, file):
        return cls(time, registry.io_paradigms[io_paradigm], registry.io_files[file])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_delete_file(al._handle, self.time, self.io_paradigm._ref, self.file._ref)

class IoOperationBegin(_Event):
    """An @e IoOperationBegin record marks the begin of a file operation (read,
write, etc.).

See @ref otf2_io_operation_event_order for the possible event orders.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("mode", "IoOperationMode", ""), \
              ("operationFlags", "IoOperationFlag", ""), \
              ("bytesRequest", "ctypes.c_uint64", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, mode, operation_flags, bytes_request, matching_id, attributes=None):
        super(IoOperationBegin, self).__init__(time, attributes)
        self.handle = handle
        self.mode = mode
        self.operation_flags = operation_flags
        self.bytes_request = bytes_request
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, handle, mode, operation_flags, bytes_request, matching_id):
        return cls(time, registry.io_handles[handle], mode, operation_flags, bytes_request, matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_operation_begin(al._handle, self.time, self.handle._ref, self.mode, self.operation_flags, self.bytes_request, self.matching_id)

class IoOperationTest(_Event):
    """An @e IoOperationTest record marks an unsuccessful test whether an I/O
operation has already finished.

See @ref otf2_io_operation_event_order for the possible event orders.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, matching_id, attributes=None):
        super(IoOperationTest, self).__init__(time, attributes)
        self.handle = handle
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, handle, matching_id):
        return cls(time, registry.io_handles[handle], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_operation_test(al._handle, self.time, self.handle._ref, self.matching_id)

class IoOperationIssued(_Event):
    """An @e IoOperationIssued record marks the successful initiation of a
non-blocking operation (read, write, etc.) on an @emph{active} I/O handle.

See @ref otf2_io_operation_event_order for the possible event orders.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, matching_id, attributes=None):
        super(IoOperationIssued, self).__init__(time, attributes)
        self.handle = handle
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, handle, matching_id):
        return cls(time, registry.io_handles[handle], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_operation_issued(al._handle, self.time, self.handle._ref, self.matching_id)

class IoOperationComplete(_Event):
    """An @e IoOperationComplete record marks the end of a file operation
(read, write, etc.) on an @emph{active} I/O handle.

See @ref otf2_io_operation_event_order for the possible event orders.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("bytesResult", "ctypes.c_uint64", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, bytes_result, matching_id, attributes=None):
        super(IoOperationComplete, self).__init__(time, attributes)
        self.handle = handle
        self.bytes_result = bytes_result
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, handle, bytes_result, matching_id):
        return cls(time, registry.io_handles[handle], bytes_result, matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_operation_complete(al._handle, self.time, self.handle._ref, self.bytes_result, self.matching_id)

class IoOperationCancelled(_Event):
    """An @e IoOperationCancelled record marks the successful cancellation of a
non-blocking operation (read, write, etc.) on an @emph{active} I/O handle.

See @ref otf2_io_operation_event_order for the possible event orders.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("matchingId", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, matching_id, attributes=None):
        super(IoOperationCancelled, self).__init__(time, attributes)
        self.handle = handle
        self.matching_id = matching_id

    @classmethod
    def _construct(cls, registry, time, handle, matching_id):
        return cls(time, registry.io_handles[handle], matching_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_operation_cancelled(al._handle, self.time, self.handle._ref, self.matching_id)

class IoAcquireLock(_Event):
    """An @e IoAcquireLock record marks the acquisition of an I/O lock.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("lockType", "LockType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, lock_type, attributes=None):
        super(IoAcquireLock, self).__init__(time, attributes)
        self.handle = handle
        self.lock_type = lock_type

    @classmethod
    def _construct(cls, registry, time, handle, lock_type):
        return cls(time, registry.io_handles[handle], lock_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_acquire_lock(al._handle, self.time, self.handle._ref, self.lock_type)

class IoReleaseLock(_Event):
    """An @e IoReleaseLock record marks the release of an I/O lock.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("lockType", "LockType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, lock_type, attributes=None):
        super(IoReleaseLock, self).__init__(time, attributes)
        self.handle = handle
        self.lock_type = lock_type

    @classmethod
    def _construct(cls, registry, time, handle, lock_type):
        return cls(time, registry.io_handles[handle], lock_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_release_lock(al._handle, self.time, self.handle._ref, self.lock_type)

class IoTryLock(_Event):
    """An @e IoTryLock record marks when an I/O lock was requested but not granted.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("handle", "IoHandleRef", ""), \
              ("lockType", "LockType", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, handle, lock_type, attributes=None):
        super(IoTryLock, self).__init__(time, attributes)
        self.handle = handle
        self.lock_type = lock_type

    @classmethod
    def _construct(cls, registry, time, handle, lock_type):
        return cls(time, registry.io_handles[handle], lock_type)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._io_try_lock(al._handle, self.time, self.handle._ref, self.lock_type)

class ProgramBegin(_Event):
    """The ProgramBegin record marks the begin of the program.

This event is restricted to happen at most once on any @eref{Location}
in a @eref{LocationGroup} that is of type
@eref{OTF2_LOCATION_GROUP_TYPE_PROCESS}.

If there is a ProgramBegin record, a corresponding
@eref{ProgramEnd} record on any @eref{Location} in the same
@eref{LocationGroup} is mandatory and vice versa.

None of the timestamps recorded within the same
@eref{LocationGroup} must be smaller than ProgramBegin's timestamp.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("programName", "StringRef", ""), \
              ("programArguments", "array", "an array of program arguments"), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, program_name, program_arguments, attributes=None):
        super(ProgramBegin, self).__init__(time, attributes)
        self.program_name = program_name
        self.program_arguments = program_arguments

    @classmethod
    def _construct(cls, registry, time, program_name_ref, program_argument_refs):
        return cls(time, registry.strings[program_name_ref], [registry.strings[ref] for ref in program_argument_refs])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._program_begin(al._handle, self.time,
                                  _get_string_ref(writer, self.program_name),
                                  [_get_string_ref(writer, argument) for argument in self.program_arguments])

class ProgramEnd(_Event):
    """The @e ProgramEnd record marks the end of the program.

This event is restricted to happen at most once on any @eref{Location} in
a @eref{LocationGroup} that is of type
@eref{OTF2_LOCATION_GROUP_TYPE_PROCESS}.

If there is a ProgramEnd record, a corresponding
@eref{ProgramBegin} record on any @eref{Location} in the same
@eref{LocationGroup} is mandatory, and vice versa.

None of the timestamps recorded within the same
@eref{LocationGroup} must be larger than ProgramEnd's timestamp.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("exitStatus", "ctypes.c_int64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, exit_status, attributes=None):
        super(ProgramEnd, self).__init__(time, attributes)
        self.exit_status = exit_status

    @classmethod
    def _construct(cls, registry, time, exit_status):
        return cls(time, exit_status)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._program_end(al._handle, self.time, self.exit_status)

class NonBlockingCollectiveRequest(_Event):
    """A @e NonBlockingCollectiveRequest record indicates that a non-blocking
collective operation was initiated.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, request_id, attributes=None):
        super(NonBlockingCollectiveRequest, self).__init__(time, attributes)
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, request_id):
        return cls(time, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._non_blocking_collective_request(al._handle, self.time, self.request_id)

class NonBlockingCollectiveComplete(_Event):
    """A @e NonBlockingCollectiveComplete record indicates that a non-blocking
collective operation completed.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("collectiveOp", "CollectiveOp", ""), \
              ("communicator", "CommRef", ""), \
              ("root", "ctypes.c_uint32", ""), \
              ("sizeSent", "ctypes.c_uint64", ""), \
              ("sizeReceived", "ctypes.c_uint64", ""), \
              ("requestID", "ctypes.c_uint64", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, collective_op, communicator, root, size_sent, size_received, request_id, attributes=None):
        super(NonBlockingCollectiveComplete, self).__init__(time, attributes)
        self.collective_op = collective_op
        self.communicator = communicator
        self.root = root
        self.size_sent = size_sent
        self.size_received = size_received
        self.request_id = request_id

    @classmethod
    def _construct(cls, registry, time, collective_op, communicator, root, size_sent, size_received, request_id):
        return cls(time, collective_op, registry.comms[communicator], root, size_sent, size_received, request_id)

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._non_blocking_collective_complete(al._handle, self.time, self.collective_op, self.communicator._ref, self.root, self.size_sent, self.size_received, self.request_id)

class CommCreate(_Event):
    """A @e CommCreate record denotes the creation of a communicator. Only valid if
the @eref{Comm} definition was flagged with
@eref{OTF2_COMM_FLAG_CREATE_DESTROY_EVENTS}. This event must be enclosed by
an @eref{MpiCollectiveBegin} and @eref{MpiCollectiveEnd} or
@eref{NonBlockingCollectiveRequest} and @eref{NonBlockingCollectiveComplete}
event pair with @eref{OTF2_COLLECTIVE_OP_CREATE_HANDLE} as the operation
type.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("communicator", "CommRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, communicator, attributes=None):
        super(CommCreate, self).__init__(time, attributes)
        self.communicator = communicator

    @classmethod
    def _construct(cls, registry, time, communicator):
        return cls(time, registry.comms[communicator])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._comm_create(al._handle, self.time, self.communicator._ref)

class CommDestroy(_Event):
    """A @e CommDestroy record marks the communicator for destruction at the end of
the enclosing @eref{MpiCollectiveBegin} and @eref{MpiCollectiveEnd} event
pair. Only valid if the @eref{Comm} definition was flagged with
@eref{OTF2_COMM_FLAG_CREATE_DESTROY_EVENTS}. This event must be enclosed
by an @eref{MpiCollectiveBegin} and @eref{MpiCollectiveEnd} event pair
with @eref{OTF2_COLLECTIVE_OP_DESTROY_HANDLE} as the operation type.

    """
    _fields = ("time", "int", "the timestamp"), \
              ("communicator", "CommRef", ""), \
              ("attributes", "dict", "a dict with an :py:class:`otf2.definitions.Attribute` \
               referencing a suitable value.")

    def __init__(self, time, communicator, attributes=None):
        super(CommDestroy, self).__init__(time, attributes)
        self.communicator = communicator

    @classmethod
    def _construct(cls, registry, time, communicator):
        return cls(time, registry.comms[communicator])

    def _write(self, writer):
        with AttributeList(writer._archive.definitions, self.attributes) as al:
            writer._comm_destroy(al._handle, self.time, self.communicator._ref)
