// This code was generated by CLI, a command line interface
// compiler for C++.
//

#ifndef ODB_OPTIONS_HXX
#define ODB_OPTIONS_HXX

// Begin prologue.
//
//
// End prologue.

#include <deque>
#include <map>
#include <vector>
#include <iosfwd>
#include <string>
#include <cstddef>
#include <exception>

namespace cli
{
  class unknown_mode
  {
    public:
    enum value
    {
      skip,
      stop,
      fail
    };

    unknown_mode (value v);

    operator value () const 
    {
      return v_;
    }

    private:
    value v_;
  };

  // Exceptions.
  //

  class exception: public std::exception
  {
    public:
    virtual void
    print (::std::ostream&) const = 0;
  };

  ::std::ostream&
  operator<< (::std::ostream&, const exception&);

  class unknown_option: public exception
  {
    public:
    virtual
    ~unknown_option () throw ();

    unknown_option (const std::string& option);

    const std::string&
    option () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();

    private:
    std::string option_;
  };

  class unknown_argument: public exception
  {
    public:
    virtual
    ~unknown_argument () throw ();

    unknown_argument (const std::string& argument);

    const std::string&
    argument () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();

    private:
    std::string argument_;
  };

  class missing_value: public exception
  {
    public:
    virtual
    ~missing_value () throw ();

    missing_value (const std::string& option);

    const std::string&
    option () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();

    private:
    std::string option_;
  };

  class invalid_value: public exception
  {
    public:
    virtual
    ~invalid_value () throw ();

    invalid_value (const std::string& option,
                   const std::string& value);

    const std::string&
    option () const;

    const std::string&
    value () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();

    private:
    std::string option_;
    std::string value_;
  };

  class eos_reached: public exception
  {
    public:
    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();
  };

  class file_io_failure: public exception
  {
    public:
    virtual
    ~file_io_failure () throw ();

    file_io_failure (const std::string& file);

    const std::string&
    file () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();

    private:
    std::string file_;
  };

  class unmatched_quote: public exception
  {
    public:
    virtual
    ~unmatched_quote () throw ();

    unmatched_quote (const std::string& argument);

    const std::string&
    argument () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const throw ();

    private:
    std::string argument_;
  };

  class scanner
  {
    public:
    virtual
    ~scanner ();

    virtual bool
    more () = 0;

    virtual const char*
    peek () = 0;

    virtual const char*
    next () = 0;

    virtual void
    skip () = 0;
  };

  class argv_scanner: public scanner
  {
    public:
    argv_scanner (int& argc, char** argv, bool erase = false);
    argv_scanner (int start, int& argc, char** argv, bool erase = false);

    int
    end () const;

    virtual bool
    more ();

    virtual const char*
    peek ();

    virtual const char*
    next ();

    virtual void
    skip ();

    private:
    int i_;
    int& argc_;
    char** argv_;
    bool erase_;
  };

  class argv_file_scanner: public argv_scanner
  {
    public:
    argv_file_scanner (int& argc,
                       char** argv,
                       const std::string& option,
                       bool erase = false);

    argv_file_scanner (int start,
                       int& argc,
                       char** argv,
                       const std::string& option,
                       bool erase = false);

    struct option_info
    {
      // If search_func is not NULL, it is called, with the arg
      // value as the second argument, to locate the options file.
      // If it returns an empty string, then the file is ignored.
      //
      const char* option;
      std::string (*search_func) (const char*, void* arg);
      void* arg;
    };

    argv_file_scanner (int& argc,
                        char** argv,
                        const option_info* options,
                        std::size_t options_count,
                        bool erase = false);

    argv_file_scanner (int start,
                       int& argc,
                       char** argv,
                       const option_info* options,
                       std::size_t options_count,
                       bool erase = false);

    virtual bool
    more ();

    virtual const char*
    peek ();

    virtual const char*
    next ();

    virtual void
    skip ();

    private:
    const option_info*
    find (const char*) const;

    void
    load (const std::string& file);

    typedef argv_scanner base;

    const std::string option_;
    option_info option_info_;
    const option_info* options_;
    std::size_t options_count_;

    std::string hold_;
    std::deque<std::string> args_;
    bool skip_;
  };

  typedef std::vector<std::string> option_names;

  class option
  {
    public:

    const std::string&
    name () const;

    const option_names&
    aliases () const;

    bool
    flag () const;

    const std::string&
    default_value () const;

    public:option ();
    option (const std::string& name,
            const option_names& aliases,
            bool flag,
            const std::string& default_value);

    private:
    std::string name_;
    option_names aliases_;
    bool flag_;
    std::string default_value_;
  };

  class options: public std::vector<option>
  {
    public:
    typedef std::vector<option> container_type;

    container_type::const_iterator
    find (const std::string& name) const;

    void
    push_back (const option&);
    private:
    typedef std::map<std::string, container_type::size_type> map_type;
    map_type map_;
  };

  template <typename X>
  struct parser;
}

#include <set>

#include <vector>

#include <string>

#include <cstddef>

#include <odb/option-types.hxx>

class options
{
  public:
  options (int& argc,
           char** argv,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (::cli::scanner&,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options ();

  // Option accessors and modifiers.
  //
  const bool&
  help () const;

  bool&
  help ();

  void
  help (const bool&);

  const bool&
  version () const;

  bool&
  version ();

  void
  version (const bool&);

  const std::vector<std::string>&
  I () const;

  std::vector<std::string>&
  I ();

  void
  I (const std::vector<std::string>&);

  bool
  I_specified () const;

  void
  I_specified (bool);

  const std::vector<std::string>&
  D () const;

  std::vector<std::string>&
  D ();

  void
  D (const std::vector<std::string>&);

  bool
  D_specified () const;

  void
  D_specified (bool);

  const std::vector<std::string>&
  U () const;

  std::vector<std::string>&
  U ();

  void
  U (const std::vector<std::string>&);

  bool
  U_specified () const;

  void
  U_specified (bool);

  const std::vector< ::database>&
  database () const;

  std::vector< ::database>&
  database ();

  void
  database (const std::vector< ::database>&);

  bool
  database_specified () const;

  void
  database_specified (bool);

  const ::multi_database&
  multi_database () const;

  ::multi_database&
  multi_database ();

  void
  multi_database (const ::multi_database&);

  bool
  multi_database_specified () const;

  void
  multi_database_specified (bool);

  const ::database&
  default_database () const;

  ::database&
  default_database ();

  void
  default_database (const ::database&);

  bool
  default_database_specified () const;

  void
  default_database_specified (bool);

  const bool&
  generate_query () const;

  bool&
  generate_query ();

  void
  generate_query (const bool&);

  const bool&
  generate_prepared () const;

  bool&
  generate_prepared ();

  void
  generate_prepared (const bool&);

  const bool&
  omit_unprepared () const;

  bool&
  omit_unprepared ();

  void
  omit_unprepared (const bool&);

  const bool&
  generate_session () const;

  bool&
  generate_session ();

  void
  generate_session (const bool&);

  const bool&
  generate_schema () const;

  bool&
  generate_schema ();

  void
  generate_schema (const bool&);

  const bool&
  generate_schema_only () const;

  bool&
  generate_schema_only ();

  void
  generate_schema_only (const bool&);

  const bool&
  suppress_migration () const;

  bool&
  suppress_migration ();

  void
  suppress_migration (const bool&);

  const bool&
  suppress_schema_version () const;

  bool&
  suppress_schema_version ();

  void
  suppress_schema_version (const bool&);

  const database_map<qname>&
  schema_version_table () const;

  database_map<qname>&
  schema_version_table ();

  void
  schema_version_table (const database_map<qname>&);

  bool
  schema_version_table_specified () const;

  void
  schema_version_table_specified (bool);

  const database_map<std::set< ::schema_format> >&
  schema_format () const;

  database_map<std::set< ::schema_format> >&
  schema_format ();

  void
  schema_format (const database_map<std::set< ::schema_format> >&);

  bool
  schema_format_specified () const;

  void
  schema_format_specified (bool);

  const bool&
  omit_drop () const;

  bool&
  omit_drop ();

  void
  omit_drop (const bool&);

  const bool&
  omit_create () const;

  bool&
  omit_create ();

  void
  omit_create (const bool&);

  const database_map<std::string>&
  schema_name () const;

  database_map<std::string>&
  schema_name ();

  void
  schema_name (const database_map<std::string>&);

  bool
  schema_name_specified () const;

  void
  schema_name_specified (bool);

  const database_map<deferrable>&
  fkeys_deferrable_mode () const;

  database_map<deferrable>&
  fkeys_deferrable_mode ();

  void
  fkeys_deferrable_mode (const database_map<deferrable>&);

  bool
  fkeys_deferrable_mode_specified () const;

  void
  fkeys_deferrable_mode_specified (bool);

  const std::string&
  default_pointer () const;

  std::string&
  default_pointer ();

  void
  default_pointer (const std::string&);

  bool
  default_pointer_specified () const;

  void
  default_pointer_specified (bool);

  const std::string&
  session_type () const;

  std::string&
  session_type ();

  void
  session_type (const std::string&);

  bool
  session_type_specified () const;

  void
  session_type_specified (bool);

  const std::string&
  profile () const;

  std::string&
  profile ();

  void
  profile (const std::string&);

  bool
  profile_specified () const;

  void
  profile_specified (bool);

  const bool&
  at_once () const;

  bool&
  at_once ();

  void
  at_once (const bool&);

  const database_map<qname>&
  schema () const;

  database_map<qname>&
  schema ();

  void
  schema (const database_map<qname>&);

  bool
  schema_specified () const;

  void
  schema_specified (bool);

  const database_map<std::string>&
  export_symbol () const;

  database_map<std::string>&
  export_symbol ();

  void
  export_symbol (const database_map<std::string>&);

  bool
  export_symbol_specified () const;

  void
  export_symbol_specified (bool);

  const database_map<std::string>&
  extern_symbol () const;

  database_map<std::string>&
  extern_symbol ();

  void
  extern_symbol (const database_map<std::string>&);

  bool
  extern_symbol_specified () const;

  void
  extern_symbol_specified (bool);

  const cxx_version&
  std () const;

  cxx_version&
  std ();

  void
  std (const cxx_version&);

  bool
  std_specified () const;

  void
  std_specified (bool);

  const bool&
  warn_hard_add () const;

  bool&
  warn_hard_add ();

  void
  warn_hard_add (const bool&);

  const bool&
  warn_hard_delete () const;

  bool&
  warn_hard_delete ();

  void
  warn_hard_delete (const bool&);

  const bool&
  warn_hard () const;

  bool&
  warn_hard ();

  void
  warn_hard (const bool&);

  const std::string&
  output_dir () const;

  std::string&
  output_dir ();

  void
  output_dir (const std::string&);

  bool
  output_dir_specified () const;

  void
  output_dir_specified (bool);

  const std::string&
  input_name () const;

  std::string&
  input_name ();

  void
  input_name (const std::string&);

  bool
  input_name_specified () const;

  void
  input_name_specified (bool);

  const database_map<std::string>&
  changelog () const;

  database_map<std::string>&
  changelog ();

  void
  changelog (const database_map<std::string>&);

  bool
  changelog_specified () const;

  void
  changelog_specified (bool);

  const database_map<std::string>&
  changelog_in () const;

  database_map<std::string>&
  changelog_in ();

  void
  changelog_in (const database_map<std::string>&);

  bool
  changelog_in_specified () const;

  void
  changelog_in_specified (bool);

  const database_map<std::string>&
  changelog_out () const;

  database_map<std::string>&
  changelog_out ();

  void
  changelog_out (const database_map<std::string>&);

  bool
  changelog_out_specified () const;

  void
  changelog_out_specified (bool);

  const database_map<std::string>&
  changelog_dir () const;

  database_map<std::string>&
  changelog_dir ();

  void
  changelog_dir (const database_map<std::string>&);

  bool
  changelog_dir_specified () const;

  void
  changelog_dir_specified (bool);

  const bool&
  init_changelog () const;

  bool&
  init_changelog ();

  void
  init_changelog (const bool&);

  const database_map<std::string>&
  odb_file_suffix () const;

  database_map<std::string>&
  odb_file_suffix ();

  void
  odb_file_suffix (const database_map<std::string>&);

  bool
  odb_file_suffix_specified () const;

  void
  odb_file_suffix_specified (bool);

  const database_map<std::string>&
  sql_file_suffix () const;

  database_map<std::string>&
  sql_file_suffix ();

  void
  sql_file_suffix (const database_map<std::string>&);

  bool
  sql_file_suffix_specified () const;

  void
  sql_file_suffix_specified (bool);

  const database_map<std::string>&
  schema_file_suffix () const;

  database_map<std::string>&
  schema_file_suffix ();

  void
  schema_file_suffix (const database_map<std::string>&);

  bool
  schema_file_suffix_specified () const;

  void
  schema_file_suffix_specified (bool);

  const database_map<std::string>&
  changelog_file_suffix () const;

  database_map<std::string>&
  changelog_file_suffix ();

  void
  changelog_file_suffix (const database_map<std::string>&);

  bool
  changelog_file_suffix_specified () const;

  void
  changelog_file_suffix_specified (bool);

  const std::string&
  hxx_suffix () const;

  std::string&
  hxx_suffix ();

  void
  hxx_suffix (const std::string&);

  bool
  hxx_suffix_specified () const;

  void
  hxx_suffix_specified (bool);

  const std::string&
  ixx_suffix () const;

  std::string&
  ixx_suffix ();

  void
  ixx_suffix (const std::string&);

  bool
  ixx_suffix_specified () const;

  void
  ixx_suffix_specified (bool);

  const std::string&
  cxx_suffix () const;

  std::string&
  cxx_suffix ();

  void
  cxx_suffix (const std::string&);

  bool
  cxx_suffix_specified () const;

  void
  cxx_suffix_specified (bool);

  const std::string&
  sql_suffix () const;

  std::string&
  sql_suffix ();

  void
  sql_suffix (const std::string&);

  bool
  sql_suffix_specified () const;

  void
  sql_suffix_specified (bool);

  const std::string&
  changelog_suffix () const;

  std::string&
  changelog_suffix ();

  void
  changelog_suffix (const std::string&);

  bool
  changelog_suffix_specified () const;

  void
  changelog_suffix_specified (bool);

  const database_map<std::vector<std::string> >&
  hxx_prologue () const;

  database_map<std::vector<std::string> >&
  hxx_prologue ();

  void
  hxx_prologue (const database_map<std::vector<std::string> >&);

  bool
  hxx_prologue_specified () const;

  void
  hxx_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  ixx_prologue () const;

  database_map<std::vector<std::string> >&
  ixx_prologue ();

  void
  ixx_prologue (const database_map<std::vector<std::string> >&);

  bool
  ixx_prologue_specified () const;

  void
  ixx_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  cxx_prologue () const;

  database_map<std::vector<std::string> >&
  cxx_prologue ();

  void
  cxx_prologue (const database_map<std::vector<std::string> >&);

  bool
  cxx_prologue_specified () const;

  void
  cxx_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  schema_prologue () const;

  database_map<std::vector<std::string> >&
  schema_prologue ();

  void
  schema_prologue (const database_map<std::vector<std::string> >&);

  bool
  schema_prologue_specified () const;

  void
  schema_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  sql_prologue () const;

  database_map<std::vector<std::string> >&
  sql_prologue ();

  void
  sql_prologue (const database_map<std::vector<std::string> >&);

  bool
  sql_prologue_specified () const;

  void
  sql_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  migration_prologue () const;

  database_map<std::vector<std::string> >&
  migration_prologue ();

  void
  migration_prologue (const database_map<std::vector<std::string> >&);

  bool
  migration_prologue_specified () const;

  void
  migration_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  sql_interlude () const;

  database_map<std::vector<std::string> >&
  sql_interlude ();

  void
  sql_interlude (const database_map<std::vector<std::string> >&);

  bool
  sql_interlude_specified () const;

  void
  sql_interlude_specified (bool);

  const database_map<std::vector<std::string> >&
  hxx_epilogue () const;

  database_map<std::vector<std::string> >&
  hxx_epilogue ();

  void
  hxx_epilogue (const database_map<std::vector<std::string> >&);

  bool
  hxx_epilogue_specified () const;

  void
  hxx_epilogue_specified (bool);

  const database_map<std::vector<std::string> >&
  ixx_epilogue () const;

  database_map<std::vector<std::string> >&
  ixx_epilogue ();

  void
  ixx_epilogue (const database_map<std::vector<std::string> >&);

  bool
  ixx_epilogue_specified () const;

  void
  ixx_epilogue_specified (bool);

  const database_map<std::vector<std::string> >&
  cxx_epilogue () const;

  database_map<std::vector<std::string> >&
  cxx_epilogue ();

  void
  cxx_epilogue (const database_map<std::vector<std::string> >&);

  bool
  cxx_epilogue_specified () const;

  void
  cxx_epilogue_specified (bool);

  const database_map<std::vector<std::string> >&
  schema_epilogue () const;

  database_map<std::vector<std::string> >&
  schema_epilogue ();

  void
  schema_epilogue (const database_map<std::vector<std::string> >&);

  bool
  schema_epilogue_specified () const;

  void
  schema_epilogue_specified (bool);

  const database_map<std::vector<std::string> >&
  sql_epilogue () const;

  database_map<std::vector<std::string> >&
  sql_epilogue ();

  void
  sql_epilogue (const database_map<std::vector<std::string> >&);

  bool
  sql_epilogue_specified () const;

  void
  sql_epilogue_specified (bool);

  const database_map<std::vector<std::string> >&
  migration_epilogue () const;

  database_map<std::vector<std::string> >&
  migration_epilogue ();

  void
  migration_epilogue (const database_map<std::vector<std::string> >&);

  bool
  migration_epilogue_specified () const;

  void
  migration_epilogue_specified (bool);

  const database_map<std::string>&
  hxx_prologue_file () const;

  database_map<std::string>&
  hxx_prologue_file ();

  void
  hxx_prologue_file (const database_map<std::string>&);

  bool
  hxx_prologue_file_specified () const;

  void
  hxx_prologue_file_specified (bool);

  const database_map<std::string>&
  ixx_prologue_file () const;

  database_map<std::string>&
  ixx_prologue_file ();

  void
  ixx_prologue_file (const database_map<std::string>&);

  bool
  ixx_prologue_file_specified () const;

  void
  ixx_prologue_file_specified (bool);

  const database_map<std::string>&
  cxx_prologue_file () const;

  database_map<std::string>&
  cxx_prologue_file ();

  void
  cxx_prologue_file (const database_map<std::string>&);

  bool
  cxx_prologue_file_specified () const;

  void
  cxx_prologue_file_specified (bool);

  const database_map<std::string>&
  schema_prologue_file () const;

  database_map<std::string>&
  schema_prologue_file ();

  void
  schema_prologue_file (const database_map<std::string>&);

  bool
  schema_prologue_file_specified () const;

  void
  schema_prologue_file_specified (bool);

  const database_map<std::string>&
  sql_prologue_file () const;

  database_map<std::string>&
  sql_prologue_file ();

  void
  sql_prologue_file (const database_map<std::string>&);

  bool
  sql_prologue_file_specified () const;

  void
  sql_prologue_file_specified (bool);

  const database_map<std::string>&
  migration_prologue_file () const;

  database_map<std::string>&
  migration_prologue_file ();

  void
  migration_prologue_file (const database_map<std::string>&);

  bool
  migration_prologue_file_specified () const;

  void
  migration_prologue_file_specified (bool);

  const database_map<std::string>&
  sql_interlude_file () const;

  database_map<std::string>&
  sql_interlude_file ();

  void
  sql_interlude_file (const database_map<std::string>&);

  bool
  sql_interlude_file_specified () const;

  void
  sql_interlude_file_specified (bool);

  const database_map<std::string>&
  hxx_epilogue_file () const;

  database_map<std::string>&
  hxx_epilogue_file ();

  void
  hxx_epilogue_file (const database_map<std::string>&);

  bool
  hxx_epilogue_file_specified () const;

  void
  hxx_epilogue_file_specified (bool);

  const database_map<std::string>&
  ixx_epilogue_file () const;

  database_map<std::string>&
  ixx_epilogue_file ();

  void
  ixx_epilogue_file (const database_map<std::string>&);

  bool
  ixx_epilogue_file_specified () const;

  void
  ixx_epilogue_file_specified (bool);

  const database_map<std::string>&
  cxx_epilogue_file () const;

  database_map<std::string>&
  cxx_epilogue_file ();

  void
  cxx_epilogue_file (const database_map<std::string>&);

  bool
  cxx_epilogue_file_specified () const;

  void
  cxx_epilogue_file_specified (bool);

  const database_map<std::string>&
  schema_epilogue_file () const;

  database_map<std::string>&
  schema_epilogue_file ();

  void
  schema_epilogue_file (const database_map<std::string>&);

  bool
  schema_epilogue_file_specified () const;

  void
  schema_epilogue_file_specified (bool);

  const database_map<std::string>&
  sql_epilogue_file () const;

  database_map<std::string>&
  sql_epilogue_file ();

  void
  sql_epilogue_file (const database_map<std::string>&);

  bool
  sql_epilogue_file_specified () const;

  void
  sql_epilogue_file_specified (bool);

  const database_map<std::string>&
  migration_epilogue_file () const;

  database_map<std::string>&
  migration_epilogue_file ();

  void
  migration_epilogue_file (const database_map<std::string>&);

  bool
  migration_epilogue_file_specified () const;

  void
  migration_epilogue_file_specified (bool);

  const database_map<std::vector<std::string> >&
  odb_prologue () const;

  database_map<std::vector<std::string> >&
  odb_prologue ();

  void
  odb_prologue (const database_map<std::vector<std::string> >&);

  bool
  odb_prologue_specified () const;

  void
  odb_prologue_specified (bool);

  const database_map<std::vector<std::string> >&
  odb_prologue_file () const;

  database_map<std::vector<std::string> >&
  odb_prologue_file ();

  void
  odb_prologue_file (const database_map<std::vector<std::string> >&);

  bool
  odb_prologue_file_specified () const;

  void
  odb_prologue_file_specified (bool);

  const database_map<std::vector<std::string> >&
  odb_epilogue () const;

  database_map<std::vector<std::string> >&
  odb_epilogue ();

  void
  odb_epilogue (const database_map<std::vector<std::string> >&);

  bool
  odb_epilogue_specified () const;

  void
  odb_epilogue_specified (bool);

  const database_map<std::vector<std::string> >&
  odb_epilogue_file () const;

  database_map<std::vector<std::string> >&
  odb_epilogue_file ();

  void
  odb_epilogue_file (const database_map<std::vector<std::string> >&);

  bool
  odb_epilogue_file_specified () const;

  void
  odb_epilogue_file_specified (bool);

  const database_map<std::string>&
  table_prefix () const;

  database_map<std::string>&
  table_prefix ();

  void
  table_prefix (const database_map<std::string>&);

  bool
  table_prefix_specified () const;

  void
  table_prefix_specified (bool);

  const database_map<std::string>&
  index_suffix () const;

  database_map<std::string>&
  index_suffix ();

  void
  index_suffix (const database_map<std::string>&);

  bool
  index_suffix_specified () const;

  void
  index_suffix_specified (bool);

  const database_map<std::string>&
  fkey_suffix () const;

  database_map<std::string>&
  fkey_suffix ();

  void
  fkey_suffix (const database_map<std::string>&);

  bool
  fkey_suffix_specified () const;

  void
  fkey_suffix_specified (bool);

  const database_map<std::string>&
  sequence_suffix () const;

  database_map<std::string>&
  sequence_suffix ();

  void
  sequence_suffix (const database_map<std::string>&);

  bool
  sequence_suffix_specified () const;

  void
  sequence_suffix_specified (bool);

  const database_map<name_case>&
  sql_name_case () const;

  database_map<name_case>&
  sql_name_case ();

  void
  sql_name_case (const database_map<name_case>&);

  bool
  sql_name_case_specified () const;

  void
  sql_name_case_specified (bool);

  const database_map<std::vector<std::string> >&
  table_regex () const;

  database_map<std::vector<std::string> >&
  table_regex ();

  void
  table_regex (const database_map<std::vector<std::string> >&);

  bool
  table_regex_specified () const;

  void
  table_regex_specified (bool);

  const database_map<std::vector<std::string> >&
  column_regex () const;

  database_map<std::vector<std::string> >&
  column_regex ();

  void
  column_regex (const database_map<std::vector<std::string> >&);

  bool
  column_regex_specified () const;

  void
  column_regex_specified (bool);

  const database_map<std::vector<std::string> >&
  index_regex () const;

  database_map<std::vector<std::string> >&
  index_regex ();

  void
  index_regex (const database_map<std::vector<std::string> >&);

  bool
  index_regex_specified () const;

  void
  index_regex_specified (bool);

  const database_map<std::vector<std::string> >&
  fkey_regex () const;

  database_map<std::vector<std::string> >&
  fkey_regex ();

  void
  fkey_regex (const database_map<std::vector<std::string> >&);

  bool
  fkey_regex_specified () const;

  void
  fkey_regex_specified (bool);

  const database_map<std::vector<std::string> >&
  sequence_regex () const;

  database_map<std::vector<std::string> >&
  sequence_regex ();

  void
  sequence_regex (const database_map<std::vector<std::string> >&);

  bool
  sequence_regex_specified () const;

  void
  sequence_regex_specified (bool);

  const database_map<std::vector<std::string> >&
  statement_regex () const;

  database_map<std::vector<std::string> >&
  statement_regex ();

  void
  statement_regex (const database_map<std::vector<std::string> >&);

  bool
  statement_regex_specified () const;

  void
  statement_regex_specified (bool);

  const database_map<std::vector<std::string> >&
  sql_name_regex () const;

  database_map<std::vector<std::string> >&
  sql_name_regex ();

  void
  sql_name_regex (const database_map<std::vector<std::string> >&);

  bool
  sql_name_regex_specified () const;

  void
  sql_name_regex_specified (bool);

  const bool&
  sql_name_regex_trace () const;

  bool&
  sql_name_regex_trace ();

  void
  sql_name_regex_trace (const bool&);

  const std::vector<std::string>&
  accessor_regex () const;

  std::vector<std::string>&
  accessor_regex ();

  void
  accessor_regex (const std::vector<std::string>&);

  bool
  accessor_regex_specified () const;

  void
  accessor_regex_specified (bool);

  const bool&
  accessor_regex_trace () const;

  bool&
  accessor_regex_trace ();

  void
  accessor_regex_trace (const bool&);

  const std::vector<std::string>&
  modifier_regex () const;

  std::vector<std::string>&
  modifier_regex ();

  void
  modifier_regex (const std::vector<std::string>&);

  bool
  modifier_regex_specified () const;

  void
  modifier_regex_specified (bool);

  const bool&
  modifier_regex_trace () const;

  bool&
  modifier_regex_trace ();

  void
  modifier_regex_trace (const bool&);

  const bool&
  include_with_brackets () const;

  bool&
  include_with_brackets ();

  void
  include_with_brackets (const bool&);

  const std::string&
  include_prefix () const;

  std::string&
  include_prefix ();

  void
  include_prefix (const std::string&);

  bool
  include_prefix_specified () const;

  void
  include_prefix_specified (bool);

  const std::vector<std::string>&
  include_regex () const;

  std::vector<std::string>&
  include_regex ();

  void
  include_regex (const std::vector<std::string>&);

  bool
  include_regex_specified () const;

  void
  include_regex_specified (bool);

  const bool&
  include_regex_trace () const;

  bool&
  include_regex_trace ();

  void
  include_regex_trace (const bool&);

  const std::string&
  guard_prefix () const;

  std::string&
  guard_prefix ();

  void
  guard_prefix (const std::string&);

  bool
  guard_prefix_specified () const;

  void
  guard_prefix_specified (bool);

  const bool&
  show_sloc () const;

  bool&
  show_sloc ();

  void
  show_sloc (const bool&);

  const std::size_t&
  sloc_limit () const;

  std::size_t&
  sloc_limit ();

  void
  sloc_limit (const std::size_t&);

  bool
  sloc_limit_specified () const;

  void
  sloc_limit_specified (bool);

  const std::string&
  options_file () const;

  std::string&
  options_file ();

  void
  options_file (const std::string&);

  bool
  options_file_specified () const;

  void
  options_file_specified (bool);

  const std::vector<std::string>&
  x () const;

  std::vector<std::string>&
  x ();

  void
  x (const std::vector<std::string>&);

  bool
  x_specified () const;

  void
  x_specified (bool);

  const bool&
  v () const;

  bool&
  v ();

  void
  v (const bool&);

  const bool&
  trace () const;

  bool&
  trace ();

  void
  trace (const bool&);

  const std::string&
  mysql_engine () const;

  std::string&
  mysql_engine ();

  void
  mysql_engine (const std::string&);

  bool
  mysql_engine_specified () const;

  void
  mysql_engine_specified (bool);

  const bool&
  sqlite_override_null () const;

  bool&
  sqlite_override_null ();

  void
  sqlite_override_null (const bool&);

  const bool&
  sqlite_lax_auto_id () const;

  bool&
  sqlite_lax_auto_id ();

  void
  sqlite_lax_auto_id (const bool&);

  const ::pgsql_version&
  pgsql_server_version () const;

  ::pgsql_version&
  pgsql_server_version ();

  void
  pgsql_server_version (const ::pgsql_version&);

  bool
  pgsql_server_version_specified () const;

  void
  pgsql_server_version_specified (bool);

  const ::oracle_version&
  oracle_client_version () const;

  ::oracle_version&
  oracle_client_version ();

  void
  oracle_client_version (const ::oracle_version&);

  bool
  oracle_client_version_specified () const;

  void
  oracle_client_version_specified (bool);

  const bool&
  oracle_warn_truncation () const;

  bool&
  oracle_warn_truncation ();

  void
  oracle_warn_truncation (const bool&);

  const ::mssql_version&
  mssql_server_version () const;

  ::mssql_version&
  mssql_server_version ();

  void
  mssql_server_version (const ::mssql_version&);

  bool
  mssql_server_version_specified () const;

  void
  mssql_server_version_specified (bool);

  const unsigned int&
  mssql_short_limit () const;

  unsigned int&
  mssql_short_limit ();

  void
  mssql_short_limit (const unsigned int&);

  bool
  mssql_short_limit_specified () const;

  void
  mssql_short_limit_specified (bool);

  // Print usage information.
  //
  static void
  print_usage (::std::ostream&);

  // Option description.
  //
  static const ::cli::options&
  description ();

  // Implementation details.
  //
  protected:
  friend struct _cli_options_desc_init;

  static void
  fill (::cli::options&);

  bool
  _parse (const char*, ::cli::scanner&);

  private:
  void
  _parse (::cli::scanner&,
          ::cli::unknown_mode option,
          ::cli::unknown_mode argument);

  public:
  bool help_;
  bool version_;
  std::vector<std::string> I_;
  bool I_specified_;
  std::vector<std::string> D_;
  bool D_specified_;
  std::vector<std::string> U_;
  bool U_specified_;
  std::vector< ::database> database_;
  bool database_specified_;
  ::multi_database multi_database_;
  bool multi_database_specified_;
  ::database default_database_;
  bool default_database_specified_;
  bool generate_query_;
  bool generate_prepared_;
  bool omit_unprepared_;
  bool generate_session_;
  bool generate_schema_;
  bool generate_schema_only_;
  bool suppress_migration_;
  bool suppress_schema_version_;
  database_map<qname> schema_version_table_;
  bool schema_version_table_specified_;
  database_map<std::set< ::schema_format> > schema_format_;
  bool schema_format_specified_;
  bool omit_drop_;
  bool omit_create_;
  database_map<std::string> schema_name_;
  bool schema_name_specified_;
  database_map<deferrable> fkeys_deferrable_mode_;
  bool fkeys_deferrable_mode_specified_;
  std::string default_pointer_;
  bool default_pointer_specified_;
  std::string session_type_;
  bool session_type_specified_;
  std::string profile_;
  bool profile_specified_;
  bool at_once_;
  database_map<qname> schema_;
  bool schema_specified_;
  database_map<std::string> export_symbol_;
  bool export_symbol_specified_;
  database_map<std::string> extern_symbol_;
  bool extern_symbol_specified_;
  cxx_version std_;
  bool std_specified_;
  bool warn_hard_add_;
  bool warn_hard_delete_;
  bool warn_hard_;
  std::string output_dir_;
  bool output_dir_specified_;
  std::string input_name_;
  bool input_name_specified_;
  database_map<std::string> changelog_;
  bool changelog_specified_;
  database_map<std::string> changelog_in_;
  bool changelog_in_specified_;
  database_map<std::string> changelog_out_;
  bool changelog_out_specified_;
  database_map<std::string> changelog_dir_;
  bool changelog_dir_specified_;
  bool init_changelog_;
  database_map<std::string> odb_file_suffix_;
  bool odb_file_suffix_specified_;
  database_map<std::string> sql_file_suffix_;
  bool sql_file_suffix_specified_;
  database_map<std::string> schema_file_suffix_;
  bool schema_file_suffix_specified_;
  database_map<std::string> changelog_file_suffix_;
  bool changelog_file_suffix_specified_;
  std::string hxx_suffix_;
  bool hxx_suffix_specified_;
  std::string ixx_suffix_;
  bool ixx_suffix_specified_;
  std::string cxx_suffix_;
  bool cxx_suffix_specified_;
  std::string sql_suffix_;
  bool sql_suffix_specified_;
  std::string changelog_suffix_;
  bool changelog_suffix_specified_;
  database_map<std::vector<std::string> > hxx_prologue_;
  bool hxx_prologue_specified_;
  database_map<std::vector<std::string> > ixx_prologue_;
  bool ixx_prologue_specified_;
  database_map<std::vector<std::string> > cxx_prologue_;
  bool cxx_prologue_specified_;
  database_map<std::vector<std::string> > schema_prologue_;
  bool schema_prologue_specified_;
  database_map<std::vector<std::string> > sql_prologue_;
  bool sql_prologue_specified_;
  database_map<std::vector<std::string> > migration_prologue_;
  bool migration_prologue_specified_;
  database_map<std::vector<std::string> > sql_interlude_;
  bool sql_interlude_specified_;
  database_map<std::vector<std::string> > hxx_epilogue_;
  bool hxx_epilogue_specified_;
  database_map<std::vector<std::string> > ixx_epilogue_;
  bool ixx_epilogue_specified_;
  database_map<std::vector<std::string> > cxx_epilogue_;
  bool cxx_epilogue_specified_;
  database_map<std::vector<std::string> > schema_epilogue_;
  bool schema_epilogue_specified_;
  database_map<std::vector<std::string> > sql_epilogue_;
  bool sql_epilogue_specified_;
  database_map<std::vector<std::string> > migration_epilogue_;
  bool migration_epilogue_specified_;
  database_map<std::string> hxx_prologue_file_;
  bool hxx_prologue_file_specified_;
  database_map<std::string> ixx_prologue_file_;
  bool ixx_prologue_file_specified_;
  database_map<std::string> cxx_prologue_file_;
  bool cxx_prologue_file_specified_;
  database_map<std::string> schema_prologue_file_;
  bool schema_prologue_file_specified_;
  database_map<std::string> sql_prologue_file_;
  bool sql_prologue_file_specified_;
  database_map<std::string> migration_prologue_file_;
  bool migration_prologue_file_specified_;
  database_map<std::string> sql_interlude_file_;
  bool sql_interlude_file_specified_;
  database_map<std::string> hxx_epilogue_file_;
  bool hxx_epilogue_file_specified_;
  database_map<std::string> ixx_epilogue_file_;
  bool ixx_epilogue_file_specified_;
  database_map<std::string> cxx_epilogue_file_;
  bool cxx_epilogue_file_specified_;
  database_map<std::string> schema_epilogue_file_;
  bool schema_epilogue_file_specified_;
  database_map<std::string> sql_epilogue_file_;
  bool sql_epilogue_file_specified_;
  database_map<std::string> migration_epilogue_file_;
  bool migration_epilogue_file_specified_;
  database_map<std::vector<std::string> > odb_prologue_;
  bool odb_prologue_specified_;
  database_map<std::vector<std::string> > odb_prologue_file_;
  bool odb_prologue_file_specified_;
  database_map<std::vector<std::string> > odb_epilogue_;
  bool odb_epilogue_specified_;
  database_map<std::vector<std::string> > odb_epilogue_file_;
  bool odb_epilogue_file_specified_;
  database_map<std::string> table_prefix_;
  bool table_prefix_specified_;
  database_map<std::string> index_suffix_;
  bool index_suffix_specified_;
  database_map<std::string> fkey_suffix_;
  bool fkey_suffix_specified_;
  database_map<std::string> sequence_suffix_;
  bool sequence_suffix_specified_;
  database_map<name_case> sql_name_case_;
  bool sql_name_case_specified_;
  database_map<std::vector<std::string> > table_regex_;
  bool table_regex_specified_;
  database_map<std::vector<std::string> > column_regex_;
  bool column_regex_specified_;
  database_map<std::vector<std::string> > index_regex_;
  bool index_regex_specified_;
  database_map<std::vector<std::string> > fkey_regex_;
  bool fkey_regex_specified_;
  database_map<std::vector<std::string> > sequence_regex_;
  bool sequence_regex_specified_;
  database_map<std::vector<std::string> > statement_regex_;
  bool statement_regex_specified_;
  database_map<std::vector<std::string> > sql_name_regex_;
  bool sql_name_regex_specified_;
  bool sql_name_regex_trace_;
  std::vector<std::string> accessor_regex_;
  bool accessor_regex_specified_;
  bool accessor_regex_trace_;
  std::vector<std::string> modifier_regex_;
  bool modifier_regex_specified_;
  bool modifier_regex_trace_;
  bool include_with_brackets_;
  std::string include_prefix_;
  bool include_prefix_specified_;
  std::vector<std::string> include_regex_;
  bool include_regex_specified_;
  bool include_regex_trace_;
  std::string guard_prefix_;
  bool guard_prefix_specified_;
  bool show_sloc_;
  std::size_t sloc_limit_;
  bool sloc_limit_specified_;
  std::string options_file_;
  bool options_file_specified_;
  std::vector<std::string> x_;
  bool x_specified_;
  bool v_;
  bool trace_;
  std::string mysql_engine_;
  bool mysql_engine_specified_;
  bool sqlite_override_null_;
  bool sqlite_lax_auto_id_;
  ::pgsql_version pgsql_server_version_;
  bool pgsql_server_version_specified_;
  ::oracle_version oracle_client_version_;
  bool oracle_client_version_specified_;
  bool oracle_warn_truncation_;
  ::mssql_version mssql_server_version_;
  bool mssql_server_version_specified_;
  unsigned int mssql_short_limit_;
  bool mssql_short_limit_specified_;
};

#include <odb/options.ixx>

// Begin epilogue.
//
//
// End epilogue.

#endif // ODB_OPTIONS_HXX
