/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.ShellFilter;
import org.scidac.cmcs.tools.bse.translators.IBasisSetXmlToText;
import org.scidac.cmcs.tools.pertable.PerTable;

public abstract class AbstractBasisSetXmlToText
implements IBasisSetXmlToText {
    protected boolean mSplitSP = false;
    protected final int START_OPT_COLUMN = 1;
    protected int mGlobalShellCounter = 0;
    protected PerTable mPertable = PerTable.getPerTable();
    protected String[] mShells = new String[]{"UL", "S", "P", "SP", "D", "F", "G", "H", "I", "K", "L", "M"};

    protected void enableSplitSP() {
        this.mSplitSP = true;
    }

    protected String readBasisSet(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        SAXBuilder builder = new SAXBuilder();
        StringBuffer output = new StringBuffer("\n");
        try {
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(data.getBytes());
            Document doc = builder.build(xmlStream);
            try {
                AbstractBasisSetToXml.addContractionDescriptions(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Element root = doc.getRootElement();
            this.addHeader(output, root);
            String contractionType = root.getChildText("contractionType", BSEProperties.mBseNs);
            List contractionsList = root.getChildren("contractions", BSEProperties.mBseNs);
            Iterator iterator1 = contractionsList.iterator();
            while (iterator1.hasNext()) {
                Element contractions = (Element)iterator1.next();
                boolean found = true;
                iterator1.remove();
                String element = contractions.getAttributeValue("elementType");
                if (elementList.size() > 0) {
                    found = elementList.contains(element);
                }
                if (!found) continue;
                this.addElementDescription(output, element, contractions);
                if (contractionType.equalsIgnoreCase("uncontracted")) {
                    optimize = true;
                }
                this.mGlobalShellCounter = 0;
                this.readContraction(output, contractions, element, optimize);
                this.addElementFooter(output, element, contractions);
            }
            this.addFooter(output);
        }
        catch (JDOMException e) {
            throw new FormatException(e.getMessage());
        }
        return output.toString();
    }

    protected void addHeader(StringBuffer output, Element root) throws FormatException {
    }

    protected void addFooter(StringBuffer output) throws FormatException {
    }

    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
    }

    protected void addElementFooter(StringBuffer output, String element, Element contractions) {
    }

    protected void readContraction_old(StringBuffer output, Element contractions, String element, boolean optimize) throws FormatException {
        List contractionList = contractions.getChildren("contraction", BSEProperties.mBseNs);
        Iterator iterator2 = contractionList.iterator();
        while (iterator2.hasNext()) {
            Element contraction = (Element)iterator2.next();
            iterator2.remove();
            String shell = contraction.getAttributeValue("shell").toUpperCase();
            Matrix matrix = new Matrix(contraction.getChild("matrix", BSEProperties.mCmlNs));
            Vector matrices = new Vector();
            if (optimize) {
                matrices = this.optimizeCmlMatrix(matrix, shell);
            } else {
                matrices.add(matrix);
            }
            this.readCmlMatrix(output, matrices, element, shell);
        }
    }

    protected void readContraction(StringBuffer output, Element contractions, String element, boolean optimize) throws FormatException {
        Vector[] matricesList = this.getCmlMatrices(contractions, optimize);
        if (this.mSplitSP) {
            this.splitSPmatrix(matricesList);
        }
        for (int i = 0; i < this.mShells.length; ++i) {
            if (matricesList[i].size() <= 0) continue;
            this.readCmlMatrix(output, matricesList[i], element, this.mShells[i]);
        }
    }

    protected void splitSPmatrix(Vector[] matricesList) throws FormatException {
        int indexSP = this.getShellIndex("SP");
        int indexS = this.getShellIndex("S");
        int indexP = this.getShellIndex("P");
        for (int k = 0; k < matricesList[indexSP].size(); ++k) {
            Matrix matrixSP = (Matrix)matricesList[indexSP].get(k);
            int rows = matrixSP.getNumRows();
            int columns = matrixSP.getNumColumns();
            Matrix matrixS = new Matrix(rows, 2);
            Matrix matrixP = new Matrix(rows, 2);
            if (columns != 3) {
                throw new FormatException("Invalid number of columns for an SP shell matrix. # of columns should be 3.");
            }
            try {
                for (int i = 0; i < rows; ++i) {
                    String value1 = matrixSP.getValue(i, 0);
                    String value2 = matrixSP.getValue(i, 1);
                    String value3 = matrixSP.getValue(i, 2);
                    matrixS.setValue(i, 0, value1);
                    matrixP.setValue(i, 0, value1);
                    matrixS.setValue(i, 1, value2);
                    matrixP.setValue(i, 1, value3);
                }
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
            matricesList[indexS].add(matrixS);
            matricesList[indexP].add(matrixP);
        }
        matricesList[indexSP].removeAllElements();
    }

    protected Matrix[] splitMatrixNcolumnTo2column(Matrix matrix) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        if (columns < 2) {
            throw new FormatException("matrix columns should >= 2 ");
        }
        Matrix[] matricesList = new Matrix[columns - 1];
        boolean[] ONEColumns = this.getONEColumns(matrix);
        try {
            for (int j = 1; j < columns; ++j) {
                int i;
                int columnCount = 2;
                int rowCount = 0;
                for (i = 0; i < rows; ++i) {
                    double value = this.getValueAsDouble(matrix.getValue(i, j));
                    if (ONEColumns[j] && value == 0.0) continue;
                    ++rowCount;
                }
                matricesList[j - 1] = new Matrix(rowCount, columnCount);
                rowCount = 0;
                for (i = 0; i < rows; ++i) {
                    String value2_;
                    String value1 = matrix.getValue(i, 0);
                    String value2 = value2_ = matrix.getValue(i, j);
                    double value = this.getValueAsDouble(value2);
                    if (ONEColumns[j] && value == 0.0) continue;
                    matricesList[j - 1].setValue(rowCount, 0, value1);
                    matricesList[j - 1].setValue(rowCount, 1, value2_);
                    ++rowCount;
                }
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
        return matricesList;
    }

    protected Vector[] getCmlMatrices(Element contractions, boolean optimize) throws FormatException {
        int i;
        Vector[] matricesList = new Vector[this.mShells.length];
        for (i = 0; i < this.mShells.length; ++i) {
            matricesList[i] = new Vector();
        }
        for (i = 0; i < this.mShells.length; ++i) {
            String shell = this.mShells[i];
            ShellFilter sfilter = new ShellFilter("contraction", BSEProperties.mBseNs, shell);
            List contractionList = contractions.getContent(sfilter);
            Iterator iterator2 = contractionList.iterator();
            while (iterator2.hasNext()) {
                Element contraction = (Element)iterator2.next();
                iterator2.remove();
                Matrix matrix = new Matrix(contraction.getChild("matrix", BSEProperties.mCmlNs));
                if (optimize) {
                    Vector optMatrices = this.optimizeCmlMatrix(matrix, shell);
                    for (int j = 0; j < optMatrices.size(); ++j) {
                        matricesList[i].add((Matrix)optMatrices.get(j));
                    }
                    continue;
                }
                matricesList[i].add(matrix);
            }
        }
        return matricesList;
    }

    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            output.append(element + "    " + shell + "\n");
            try {
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        String value = this.formattedValue(matrix.getValue(i, j));
                        output.append(value);
                    }
                    output.append("\n");
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }

    protected String formatInteger(String value, int width) {
        String ret = value.trim();
        while (ret.length() < width) {
            ret = " " + ret;
        }
        return ret;
    }

    protected String formatInteger(int value, int width) {
        return this.formatInteger("" + value, width);
    }

    protected String formattedValue(String value) {
        int TOTAL_WIDTH = 23;
        int DECIMAL_WIDTH = 15;
        return this.formattedValue(value, TOTAL_WIDTH, DECIMAL_WIDTH);
    }

    protected String formattedValue(String value, int width, int decimal) {
        int i;
        String[] split;
        String beforeDecimal;
        String tmp;
        int TOTAL_WIDTH = width;
        int DECIMAL_WIDTH = decimal + 1;
        value = value.trim();
        boolean isExponential = false;
        String expChars = "DE";
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            if (c != 'D' && c != 'd' && c != 'E' && c != 'e') continue;
            isExponential = true;
        }
        if (!isExponential && value.indexOf(46) == -1) {
            value = value + ".0";
        }
        if ((tmp = (beforeDecimal = (split = value.split("\\."))[0].trim()).replaceAll("\\+", "").replaceAll("\\-", "")).trim().length() == 0) {
            value = beforeDecimal + "0" + value.substring(value.indexOf(46));
        }
        if (beforeDecimal.indexOf(43) == -1 && beforeDecimal.indexOf(45) == -1) {
            value = " " + value;
        }
        beforeDecimal = value.split("\\.")[0];
        int nonDeciLen = beforeDecimal.length();
        int deciLen = value.length() - nonDeciLen;
        String whitespaces = "";
        for (i = 0; i < TOTAL_WIDTH - DECIMAL_WIDTH - nonDeciLen; ++i) {
            whitespaces = whitespaces + " ";
        }
        value = whitespaces + value;
        if (!isExponential && deciLen < 8 && deciLen < 8) {
            for (i = 0; i < 8 - deciLen; ++i) {
                value = value + "0";
            }
        }
        if (value.length() < TOTAL_WIDTH) {
            int fill = TOTAL_WIDTH - value.length();
            for (int i3 = 0; i3 < fill; ++i3) {
                value = value + " ";
            }
        } else {
            value = value + "      ";
        }
        return value;
    }

    protected String fixedFormatValue(String value, int width, int decimal) {
        String[] split;
        String beforeDecimal;
        String tmp;
        int TOTAL_WIDTH = width;
        int DECIMAL_WIDTH = decimal + 1;
        value = value.trim();
        boolean isExponential = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != 'D' && c != 'd' && c != 'E' && c != 'e') continue;
            isExponential = true;
            break;
        }
        if (!isExponential && value.indexOf(46) == -1) {
            value = value + ".0";
        }
        if ((tmp = (beforeDecimal = (split = value.split("\\."))[0].trim()).replaceAll("\\+", "").replaceAll("\\-", "")).trim().length() == 0) {
            value = beforeDecimal + "0" + value.substring(value.indexOf(46));
        }
        if (beforeDecimal.indexOf(43) == -1 && beforeDecimal.indexOf(45) == -1) {
            value = " " + value;
        }
        beforeDecimal = value.split("\\.")[0];
        int nonDeciLen = beforeDecimal.length();
        int deciLen = value.length() - nonDeciLen;
        int len = value.length();
        if (len > TOTAL_WIDTH) {
            if (isExponential) {
                value = this.formatENotation(value, width);
            } else {
                int totoss = len - TOTAL_WIDTH;
                if (totoss > deciLen) {
                    value = this.formatENotation(value, width);
                } else {
                    value = value.substring(0, TOTAL_WIDTH);
                    beforeDecimal = value.split("\\.")[0];
                    nonDeciLen = beforeDecimal.length();
                    deciLen = value.length() - nonDeciLen;
                }
            }
        }
        if (!isExponential && value.length() < TOTAL_WIDTH && deciLen < 8) {
            for (int i = 0; i < 8 - deciLen && value.length() < TOTAL_WIDTH; ++i) {
                value = value + "0";
            }
        }
        if (value.length() < TOTAL_WIDTH) {
            int fill = TOTAL_WIDTH - value.length();
            for (int i = 0; i < fill; ++i) {
                value = " " + value;
            }
        }
        return value;
    }

    protected String formatENotation(String value, int width) {
        String ret = value;
        ret = ret.replace('D', 'E');
        ret = ret.replace('d', 'E');
        String format = ".";
        for (int idx = 0; idx < width - 5; ++idx) {
            format = format + "#";
        }
        format = format + "E0";
        try {
            double dvalue = Double.parseDouble(ret);
            DecimalFormat f = new DecimalFormat(format);
            ret = f.format(dvalue);
        }
        catch (Exception ex) {
            System.out.println("Error generating E value: " + ex.getMessage());
        }
        return ret;
    }

    protected boolean[] getONEColumns(Matrix matrix) throws FormatException {
        int count = 0;
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        boolean[] ONEColumns = new boolean[columns];
        for (int j = 0; j < columns; ++j) {
            ONEColumns[j] = true;
            count = 0;
            for (int i = 0; i < rows; ++i) {
                try {
                    double value = this.getValueAsDouble(matrix.getValue(i, j));
                    if (value != 0.0) continue;
                    ++count;
                    continue;
                }
                catch (IndexOutOfBoundsException ie) {
                    throw new FormatException(ie.getMessage());
                }
            }
            if (count != 0 && rows != 1) continue;
            ONEColumns[j] = false;
        }
        return ONEColumns;
    }

    protected Vector optimizeCmlMatrix(Matrix matrix, String shell) throws FormatException {
        Vector<Matrix> optMatrices = new Vector<Matrix>();
        if (shell.equals("SP")) {
            optMatrices.add(matrix);
            return optMatrices;
        }
        Vector oneColumnRows = this.getONEColumnRows(matrix);
        int[][] indexes = this.idIndexesForOptimize(matrix, oneColumnRows);
        int rows = matrix.getNumRows();
        int cols = matrix.getNumColumns();
        Matrix tmpMatrix = new Matrix(rows - oneColumnRows.size(), cols);
        int newRowIndex = 0;
        for (int i = 0; i < rows && newRowIndex < tmpMatrix.getNumRows(); ++i) {
            if (oneColumnRows.contains(new Integer(i))) continue;
            for (int j = 0; j < cols; ++j) {
                String tmp = matrix.getValue(i, j);
                tmpMatrix.setValue(newRowIndex, j, tmp);
            }
            ++newRowIndex;
        }
        optMatrices.addAll(this.processOptimizedMatrix(tmpMatrix, indexes));
        Iterator it = oneColumnRows.iterator();
        while (it.hasNext()) {
            int rowNo = (Integer)it.next();
            Matrix newMatrix = new Matrix(1, 2);
            newMatrix.setValue(0, 0, matrix.getValue(rowNo, 0));
            newMatrix.setValue(0, 1, "1");
            optMatrices.add(newMatrix);
        }
        return optMatrices;
    }

    protected Vector processOptimizedMatrix(Matrix matrix, int[][] indexes) throws FormatException {
        Vector optMatrices = new Vector();
        int startrow = 0;
        int rows = matrix.getNumRows();
        if (rows > 0) {
            int startpos = indexes[0][0];
            int endpos = indexes[0][1];
            for (int i = 1; i < matrix.getNumRows(); ++i) {
                int nextstart = indexes[i][0];
                int nextend = indexes[i][1];
                if (nextstart <= endpos) {
                    if (nextend < startpos) {
                        throw new FormatException("Next contraction ends before the start of the previous one, not allowed!");
                    }
                    endpos = nextend;
                    continue;
                }
                this.copyOptimizedMatrix(matrix, optMatrices, startrow, startpos, i, endpos);
                startrow = i;
                startpos = nextstart;
                endpos = nextend;
            }
            if (startrow < matrix.getNumRows()) {
                this.copyOptimizedMatrix(matrix, optMatrices, startrow, startpos, matrix.getNumRows(), endpos);
            }
        }
        return optMatrices;
    }

    protected void copyOptimizedMatrix(Matrix matrix, Vector optMatrices, int startrow, int startpos, int endrow, int endpos) {
        int newW = endpos - startpos + 1;
        int newH = endrow - startrow;
        Matrix newContraction = new Matrix(newH, newW + 1);
        for (int j = 0; j < newH; ++j) {
            newContraction.setValue(j, 0, matrix.getValue(j + startrow, 0));
            for (int k = 0; k < newW; ++k) {
                newContraction.setValue(j, k + 1, matrix.getValue(j + startrow, k + startpos));
            }
        }
        optMatrices.add(newContraction);
    }

    protected Vector getONEColumnRows(Matrix matrix) throws FormatException {
        int count = 0;
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        Vector<Integer> results = new Vector<Integer>();
        for (int j = 1; j < columns; ++j) {
            count = 0;
            int row = -1;
            for (int i = 0; i < rows; ++i) {
                try {
                    double value = this.getValueAsDouble(matrix.getValue(i, j));
                    if (value == 0.0) continue;
                    ++count;
                    row = i;
                    continue;
                }
                catch (IndexOutOfBoundsException ie) {
                    throw new FormatException(ie.getMessage());
                }
            }
            if (count != true || results.contains(new Integer(row))) continue;
            results.add(new Integer(row));
        }
        return results;
    }

    protected int[][] idIndexesForOptimize(Matrix matrix, Vector oneColRows) throws FormatException {
        int oldrows = matrix.getNumRows();
        int newrows = matrix.getNumRows() - oneColRows.size();
        int columns = matrix.getNumColumns();
        int[][] indexes = new int[newrows][2];
        int curindex = 0;
        for (int i = 0; i < oldrows && curindex < newrows; ++i) {
            int start = -1;
            int end = -1;
            if (oneColRows.contains(new Integer(i))) continue;
            for (int j = 1; j < columns; ++j) {
                try {
                    double value = this.getValueAsDouble(matrix.getValue(i, j));
                    if (value == 0.0) continue;
                    if (start < 0) {
                        start = j;
                    }
                    end = j;
                    continue;
                }
                catch (IndexOutOfBoundsException ie) {
                    throw new FormatException(ie.getMessage());
                }
            }
            indexes[curindex][0] = start;
            indexes[curindex][1] = end;
            ++curindex;
        }
        return indexes;
    }

    protected double getValueAsDouble(String val) {
        if (val.indexOf(68) != -1) {
            val = val.replace('D', 'E');
        } else if (val.indexOf(100) != -1) {
            val = val.replace('d', 'E');
        }
        return Double.parseDouble(val);
    }

    protected int getShellIndex(String shellType) throws FormatException {
        int index = -1;
        for (int i = 0; i < this.mShells.length; ++i) {
            if (!this.mShells[i].equalsIgnoreCase(shellType)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new FormatException("Invalid shell type");
        }
        return index;
    }

    protected int getShellValue(String shell) throws FormatException {
        int max = -1;
        if (shell.equalsIgnoreCase("S")) {
            if (max < 0) {
                max = 0;
            }
        } else if (shell.equalsIgnoreCase("P")) {
            if (max < 1) {
                max = 1;
            }
        } else if (shell.equalsIgnoreCase("D")) {
            if (max < 2) {
                max = 2;
            }
        } else if (shell.equalsIgnoreCase("F")) {
            if (max < 3) {
                max = 3;
            }
        } else if (shell.equalsIgnoreCase("G")) {
            if (max < 4) {
                max = 4;
            }
        } else if (shell.equalsIgnoreCase("H")) {
            if (max < 5) {
                max = 5;
            }
        } else if (shell.equalsIgnoreCase("I")) {
            if (max < 6) {
                max = 6;
            }
        } else if (shell.equalsIgnoreCase("K")) {
            if (max < 7) {
                max = 7;
            }
        } else if (shell.equalsIgnoreCase("L")) {
            if (max < 8) {
                max = 8;
            }
        } else if (shell.equalsIgnoreCase("M") && max < 9) {
            max = 9;
        }
        if (max == -1) {
            throw new FormatException("Unrecognized shell:" + shell);
        }
        return max;
    }

    protected Matrix buildAssociationMatrix(Vector matrices) throws FormatException {
        int totalRows = 0;
        int totalColumns = 0;
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            totalRows += matrix.getNumRows();
            if (k == 0) {
                totalColumns += matrix.getNumColumns();
                continue;
            }
            totalColumns += matrix.getNumColumns() - 1;
        }
        Matrix associationMatrix = new Matrix(totalRows, totalColumns);
        try {
            int rowIndex = 0;
            int columnIndex = 0;
            for (int k = 0; k < matrices.size(); ++k) {
                Matrix matrix = (Matrix)matrices.get(k);
                int rows = matrix.getNumRows();
                int columns = matrix.getNumColumns();
                for (int i = 0; i < rows; ++i) {
                    int curr = 0;
                    for (int j = 0; j < columns; ++j) {
                        if (j == 0) {
                            associationMatrix.setValue(rowIndex + i, 0, matrix.getValue(i, j));
                        } else {
                            associationMatrix.setValue(rowIndex + i, columnIndex + curr, matrix.getValue(i, j));
                        }
                        if (k != 0 && j == 0) continue;
                        ++curr;
                    }
                }
                rowIndex += rows;
                if (k == 0) {
                    columnIndex += columns;
                    continue;
                }
                columnIndex += columns - 1;
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
        return associationMatrix;
    }

    protected String readECP(String data, Vector elementList) throws IOException, FormatException {
        SAXBuilder builder = new SAXBuilder();
        StringBuffer output = new StringBuffer("\n");
        try {
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(data.getBytes());
            Document doc = builder.build(xmlStream);
            Element root = doc.getRootElement();
            int printHdrFtr = 0;
            this.initialize(root, elementList);
            List potentialsList = root.getChildren("potentials", BSEProperties.mBseNs);
            Iterator iterator1 = potentialsList.iterator();
            while (iterator1.hasNext()) {
                Element potentials = (Element)iterator1.next();
                boolean found = true;
                iterator1.remove();
                String element = potentials.getAttributeValue("elementType");
                if (elementList.size() > 0) {
                    found = elementList.contains(element);
                }
                if (!found) continue;
                if (++printHdrFtr == 1) {
                    this.addHeaderECP(output, root);
                }
                this.addElementDescriptionECP(output, potentials, element);
                this.readPotential(output, potentials, element);
                this.addElementFooter(output, element, null);
            }
            if (printHdrFtr > 0) {
                this.addFooterECP(output);
            }
        }
        catch (JDOMException e) {
            throw new FormatException(e.getMessage());
        }
        return output.toString();
    }

    protected void initialize(Element root, Vector elements) throws FormatException {
    }

    protected void readPotential(StringBuffer output, Element potentials, String element) throws FormatException {
        List potentialList = potentials.getChildren("potential", BSEProperties.mBseNs);
        Iterator iterator2 = potentialList.iterator();
        while (iterator2.hasNext()) {
            Element potential = (Element)iterator2.next();
            iterator2.remove();
            Matrix matrix = new Matrix(potential.getChild("matrix", BSEProperties.mCmlNs));
            String shell = potential.getAttributeValue("shell").toUpperCase();
            String potentialType = potential.getAttributeValue("potentialType");
            this.readCmlMatrixECP(output, matrix, element, shell, potentialType);
        }
    }

    protected void addHeaderECP(StringBuffer output, Element root) {
    }

    protected void addFooterECP(StringBuffer output) {
    }

    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
    }

    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        throw new FormatException("readCmlMatrixECP() not implemented");
    }

    public class OptimizedComparator
    implements Comparator {
        public int compare(Object sc1, Object sc2) throws ClassCastException {
            int i2;
            if (sc1 == null && sc2 != null) {
                return -1;
            }
            if (sc1 != null && sc2 == null) {
                return 1;
            }
            if (sc1 == null & sc2 == null) {
                return 0;
            }
            if (!(sc1 instanceof Integer) || !(sc2 instanceof Integer)) {
                throw new ClassCastException();
            }
            int i1 = (Integer)sc1;
            if (i1 < (i2 = ((Integer)sc2).intValue())) {
                return -1;
            }
            if (i1 == i2) {
                return 0;
            }
            return 1;
        }
    }
}

