/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include <stdio.h>
#include "chordstruct.h"

struct chord_str ned_chords[] = {
	{ "E46343356:3:;<<E46343356:3:;", "B13", NULL, 7, 3, "7", { 0x7, CHORD_MUTE | 0x0, 0x7, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9 } },
	{ "Dppdm:343334839883Dppdm:3433", "Ammaj7", NULL, 5, 2, "5", { 0x5, CHORD_MUTE | 0x0, 0x6, 0x5, 0x5, CHORD_MUTE | 0x0 } },
	{ "Jdgg<4353363d::;:Jdgg<435336", "Gadd9", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x8, 0x7 } },
	{ "D&Ee44333333;:99D&Ee44333333", "A#", "Bb", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x7, 0x6, 0x6 } },
	{ "Hglp333344345333Hglp33334434", "Edim", NULL, 1, 2, "1", { 0x0, 0x1, 0x2, 0x0, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F&46Ge46343356<3<;99F&46Ge46", "C#13", "Db13", 6, 4, "6", { 0x9, CHORD_MUTE | 0x0, 0x9, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6 } },
	{ "I&ppdm:Jeppdm:443333337998I&", "F#mmaj7", "Gbmmaj7", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x6, 0x6, 0x5 } },
	{ "G&glpHeglp43333439:;:3G&glpH", "D#dim", "Ebdim", 6, 3, "6", { CHORD_MUTE | 0x0, 0x6, 0x7, 0x8, 0x7, CHORD_MUTE | 0x0 } },
	{ "G&:pdm8He:pdm8345336eeeffeG&", "D#7maj5", "Eb7maj5", 11, 2, "11", { 0xb, CHORD_MUTE | 0xb, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xc, 0xc, 0xb } },
	{ "E08333344:;<;33E08333344:;<;", "B-5", NULL, 7, 3, "7", { 0x7, 0x8, 0x9, 0x8, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Hp4533363:<<;:Hp4533363:<<;:", "Em", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x8, 0x7 } },
	{ "E:433333354535E:433333354535", "B7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x1, 0x2, 0x0, 0x2 } },
	{ "G&dgg<Hedgg<435336396676G&dg", "D#add9", "Ebadd9", 3, 4, "3", { CHORD_MUTE | 0x0, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x4, 0x3 } },
	{ "Gpdm:45333638:9:8Gpdm:453336", "Dmaj7", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x6, 0x7, 0x5 } },
	{ "F&9dgg<Ge9dgg<353333<;;;<<F&", "C#6add9", "Db6add9", 8, 2, "8", { 0x9, 0x8, 0x8, 0x8, 0x9, 0x9 } },
	{ "Hdgg<333333357433Hdgg<333333", "Eadd9", NULL, 1, 4, "1", { 0x0, 0x2, 0x4, 0x1, 0x0, 0x0 } },
	{ "J&vxvDevxv4333343ee;<3J&vxvD", "G#sus", "Absus", 8, 4, "8", { CHORD_MUTE | 0x0, 0xb, 0xb, 0x8, 0x9, CHORD_MUTE | 0x0 } },
	{ "I533336466544I533336466544I5", "F", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x2, 0x1, 0x1 } },
	{ "H464333333:9::<H464333333:9:", "E13", NULL, 6, 4, "6", { CHORD_MUTE | 0x0, 0x7, 0x6, 0x7, 0x7, 0x9 } },
	{ "Ivxv4333343;;893Ivxv4333343;", "Fsus", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, 0x8, 0x8, 0x5, 0x6, CHORD_MUTE | 0x0 } },
	{ "Hp3333333d<3;3Hp3333333d<3;3", "Em", NULL, 8, 3, "8", { 0x0, 0xa, 0x9, 0x0, 0x8, 0x0 } },
	{ "E:533336:<:;::E:533336:<:;::", "B7", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x8, 0x7, 0x7 } },
	{ "F&glpGeglp333344<de<33F&glpG", "C#dim", "Dbdim", 9, 3, "9", { 0x9, 0xa, 0xb, 0x9, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D<4333343feff3D<4333343feff3", "A9", NULL, 11, 2, "11", { CHORD_MUTE | 0x0, 0xc, 0xb, 0xc, 0xc, CHORD_MUTE | 0x0 } },
	{ "Ip443333336897Ip443333336897", "Fm", NULL, 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x5, 0x6, 0x4 } },
	{ "Dpdm<43533633<<<<Dpdm<435336", "Amaj9", NULL, 9, 1, "9", { CHORD_MUTE | 0x0, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9, 0x9, 0x9 } },
	{ "J94353363dffffJ94353363dffff", "G6", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xa, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xc, 0xc, 0xc } },
	{ "Hpdm:333334354433Hpdm:333334", "Emaj7", NULL, 1, 2, "1", { 0x0, 0x2, 0x1, 0x1, 0x0, CHORD_MUTE | 0x0 } },
	{ "D9dgg<435333337788D9dgg<4353", "A6add9", NULL, 4, 2, "4", { CHORD_MUTE | 0x0, 0x0, 0x4, 0x4, 0x5, 0x5 } },
	{ "Idgg<4353363;88;8Idgg<435336", "Fadd9", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x8, 0x5 } },
	{ "Jp443536333666Jp443536333666", "Gm", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x3 } },
	{ "Jvxv533336688866Jvxv53333668", "Gsus", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x5, 0x3, 0x3 } },
	{ "Hp:443333335766Hp:4433333357", "Em7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x3, 0x3 } },
	{ "F&dxjGedxj44333333edd<F&dxjG", "C#aug", "Dbaug", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xa, 0xa, 0x9 } },
	{ "G&08He0843333439:;;3G&08He08", "D#-5", "Eb-5", 6, 3, "6", { CHORD_MUTE | 0x0, 0x6, 0x7, 0x8, 0x8, CHORD_MUTE | 0x0 } },
	{ "D&glpEeglp4333343ghih3D&glpE", "A#dim", "Bbdim", 13, 3, "13", { CHORD_MUTE | 0x0, 0xd, 0xe, 0xf, 0xe, CHORD_MUTE | 0x0 } },
	{ "D&08Ee08433334345663D&08Ee08", "A#-5", "Bb-5", 1, 3, "1", { CHORD_MUTE | 0x0, 0x1, 0x2, 0x3, 0x3, CHORD_MUTE | 0x0 } },
	{ "D&9dgg<Ee9dgg<433333343344D&", "A#6add9", "Bb6add9", 1, 1, "1", { CHORD_MUTE | 0x0, 0x1, 0x0, 0x0, 0x1, 0x1 } },
	{ "D0833334489:933D0833334489:9", "A-5", NULL, 5, 3, "5", { 0x5, 0x6, 0x7, 0x6, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D&dgg<Eedgg<44333333;:9;D&dg", "A#add9", "Bbadd9", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x7, 0x6, 0x8 } },
	{ "F9dgg<353333;:::;;F9dgg<3533", "C6add9", NULL, 7, 2, "7", { 0x8, 0x7, 0x7, 0x7, 0x8, 0x8 } },
	{ "J443333338:;:J443333338:;:J4", "G", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x7, 0x8, 0x7 } },
	{ "G&:vxv7He:vxv7533336egegeeG&", "D#7sus4", "Eb7sus4", 11, 3, "11", { CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xb, 0xd, 0xb, 0xb } },
	{ "I&:vxv7Je:vxv74333563<<<::I&", "F#7sus4", "Gb7sus4", 7, 3, "7", { CHORD_MUTE | 0x0, 0x9, 0x9, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7 } },
	{ "G&p9Hep9445333334645G&p9Hep9", "D#m6", "Ebm6", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x1, 0x2 } },
	{ "D&pdm<Eepdm<433334343543D&pd", "A#maj9", "Bbmaj9", 1, 2, "1", { CHORD_MUTE | 0x0, 0x1, 0x0, 0x2, 0x1, CHORD_MUTE | 0x0 } },
	{ "E4335363hgefeE4335363hgefeE4", "B", NULL, 11, 4, "11", { CHORD_MUTE | 0x0, 0xe, 0xd, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xc, 0xb } },
	{ "Jpdm:443333338:::Jpdm:443333", "Gmaj7", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x7, 0x7, 0x7 } },
	{ "J9445333338:8:J9445333338:8:", "G6", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x7, 0x5, 0x7 } },
	{ "F0844333333d<:;F0844333333d<", "C-5", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0x9, 0x7, 0x8 } },
	{ "G&pdm:Hepdm:44333333giiiG&pd", "D#maj7", "Ebmaj7", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xd, 0xf, 0xf, 0xf } },
	{ "I&<Je<4333343<;<<3I&<Je<4333", "F#9", "Gb9", 8, 2, "8", { CHORD_MUTE | 0x0, 0x9, 0x8, 0x9, 0x9, CHORD_MUTE | 0x0 } },
	{ "G&:vxv7He:vxv745333639;9<9G&", "D#7sus4", "Eb7sus4", 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x9, 0x6 } },
	{ "Jpdm<4333343d<ed3Jpdm<433334", "Gmaj9", NULL, 9, 3, "9", { CHORD_MUTE | 0x0, 0xa, 0x9, 0xb, 0xa, CHORD_MUTE | 0x0 } },
	{ "G933333333fefdG933333333fefd", "D6", NULL, 10, 3, "10", { 0x0, 0x0, 0xc, 0xb, 0xc, 0xa } },
	{ "I&pdm<Jepdm<333334546453I&pd", "F#maj9", "Gbmaj9", 1, 3, "1", { 0x2, 0x1, 0x3, 0x1, 0x2, CHORD_MUTE | 0x0 } },
	{ "F333333665343F333333665343F3", "C", NULL, 1, 3, "1", { 0x3, 0x3, 0x2, 0x0, 0x1, 0x0 } },
	{ "Dp433333365543Dp433333365543", "Am", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x2, 0x1, 0x0 } },
	{ "F&pGep533336<ee<<<F&pGep5333", "C#m", "Dbm", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0x9, 0x9, 0x9 } },
	{ "D&pEep44333333;de<D&pEep4433", "A#m", "Bbm", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0xa, 0xb, 0x9 } },
	{ "I9533336;;ddddI9533336;;dddd", "F6", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0xa, 0xa, 0xa, 0xa } },
	{ "Dp:5333368::8;8Dp:5333368::8", "Am7", NULL, 5, 4, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x5, 0x8, 0x5 } },
	{ "E<343356:3:9::E<343356:3:9::", "B9", NULL, 6, 2, "6", { 0x7, CHORD_MUTE | 0x0, 0x7, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7 } },
	{ "D&dxjEedxj44333333;::9D&dxjE", "A#aug", "Bbaug", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x7, 0x7, 0x6 } },
	{ "J&<De<343356737677J&<De<3433", "G#9", "Ab9", 1, 4, "1", { 0x4, CHORD_MUTE | 0x0, 0x4, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "J:pdm8345336666776J:pdm83453", "G7maj5", NULL, 1, 4, "1", { 0x3, CHORD_MUTE | 0x3, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x4, 0x4, 0x3 } },
	{ "D&pdm<Eepdm<33333498:893D&pd", "A#maj9", "Bbmaj9", 5, 3, "5", { 0x6, 0x5, 0x7, 0x5, 0x6, CHORD_MUTE | 0x0 } },
	{ "F&46Ge46343356<3<deeF&46Ge46", "C#13", "Db13", 9, 3, "9", { 0x9, CHORD_MUTE | 0x0, 0x9, 0xa, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xb } },
	{ "H443333335433H443333335433H4", "E", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x1, 0x0, 0x0 } },
	{ "D&vxvEevxv5333369;;;99D&vxvE", "A#sus", "Bbsus", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x8, 0x6, 0x6 } },
	{ "Gdgg<45333638:<:8Gdgg<453336", "Dadd9", NULL, 5, 5, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x9, 0x7, 0x5 } },
	{ "F&pdm:Gepdm:44333333ed<;F&pd", "C#maj7", "Dbmaj7", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xa, 0x9, 0x8 } },
	{ "H:vxv7533336fhfhffH:vxv75333", "E7sus4", NULL, 12, 3, "12", { CHORD_END_OF_BARREE_RIGHT | 0xc, 0xe, 0xc, 0xe, 0xc, 0xc } },
	{ "D4533363fhhhfD4533363fhhhfD4", "A", NULL, 12, 3, "12", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xe, 0xe, 0xe, 0xc } },
	{ "I&<Je<533333575657I&<Je<5333", "F#9", "Gb9", 1, 4, "1", { 0x2, 0x4, 0x2, 0x3, 0x2, 0x4 } },
	{ "G&ppdm:Heppdm:443333334665G&", "D#mmaj7", "Ebmmaj7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x3, 0x2 } },
	{ "D:08533744898933D:0853374489", "A7-5", NULL, 5, 2, "5", { CHORD_END_OF_BARREE_LEFT | 0x5, 0x6, 0x5, 0x6, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&:08Je:084333343<d<e3I&:08J", "F#7-5", "Gb7-5", 9, 3, "9", { CHORD_MUTE | 0x0, 0x9, 0xa, 0x9, 0xb, CHORD_MUTE | 0x0 } },
	{ "D533336<fe<d<D533336<fe<d<D5", "A", NULL, 9, 4, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xc, 0xb, 0x9, 0xa, 0x9 } },
	{ "Epdm<433334354653Epdm<433334", "Bmaj9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x2, 0x1, 0x3, 0x2, CHORD_MUTE | 0x0 } },
	{ "E:0844533333<ddeE:0844533333", "B7-5", NULL, 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xa, 0xa, 0xb } },
	{ "D&p:Eep:453336346454D&p:Eep:", "A#m7", "Bbm7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x2, 0x1 } },
	{ "Fpdm<433333363333Fpdm<433333", "Cmaj9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x0, 0x0, 0x0, 0x0 } },
	{ "J44533333686868J445333336868", "G11", NULL, 3, 3, "3", { 0x3, 0x5, 0x3, 0x5, 0x3, 0x5 } },
	{ "G0844333333fe<dG0844333333fe", "D-5", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xb, 0x9, 0xa } },
	{ "Hdxj333333365443Hdxj33333336", "Eaug", NULL, 1, 3, "1", { 0x0, 0x3, 0x2, 0x1, 0x1, 0x0 } },
	{ "Fp<533333;d;;;dFp<533333;d;;", "Cm9", NULL, 8, 3, "8", { 0x8, 0xa, 0x8, 0x8, 0x8, 0xa } },
	{ "F&08Ge0844333333efhgF&08Ge08", "C#-5", "Db-5", 11, 4, "11", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xc, 0xe, 0xd } },
	{ "J&De443333339;<;J&De44333333", "G#", "Ab", 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x8, 0x9, 0x8 } },
	{ "Ip9445333336867Ip94453333368", "Fm6", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x5, 0x3, 0x4 } },
	{ "Hvxv333333335733Hvxv33333333", "Esus", NULL, 1, 4, "1", { 0x0, 0x0, 0x2, 0x4, 0x0, 0x0 } },
	{ "J46343356636788J463433566367", "G13", NULL, 3, 3, "3", { 0x3, CHORD_MUTE | 0x0, 0x3, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "E:vxv7433333355533E:vxv74333", "B7sus4", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x2, 0x2, 0x0, 0x0 } },
	{ "G:533336dfdeddG:533336dfdedd", "D7", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xa, 0xb, 0xa, 0xa } },
	{ "Dp:5333368:88;8Dp:5333368:88", "Am7", NULL, 5, 4, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x5, 0x8, 0x5 } },
	{ "G&pdm:Hepdm:443536334666G&pd", "D#maj7", "Ebmaj7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x3 } },
	{ "D9435336335555D9435336335555", "A6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x2, 0x2 } },
	{ "D&p9Eep95333369;;9;9D&p9Eep9", "A#m6", "Bbm6", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x6, 0x8, 0x6 } },
	{ "Gp:343334d3ddd3Gp:343334d3dd", "Dm7", NULL, 10, 1, "10", { 0xa, CHORD_MUTE | 0x0, 0xa, 0xa, 0xa, CHORD_MUTE | 0x0 } },
	{ "G943533638::::G943533638::::", "D6", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x7, 0x7 } },
	{ "Dp4533363fhhgfDp4533363fhhgf", "Am", NULL, 12, 3, "12", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xe, 0xe, 0xd, 0xc } },
	{ "J:084333343dedf3J:084333343d", "G7-5", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xa, 0xb, 0xa, 0xc, CHORD_MUTE | 0x0 } },
	{ "Ip<4333343;9;;3Ip<4333343;9;", "Fm9", NULL, 6, 3, "6", { CHORD_MUTE | 0x0, 0x8, 0x6, 0x8, 0x8, CHORD_MUTE | 0x0 } },
	{ "Jdgg<333333633336Jdgg<333333", "Gadd9", NULL, 1, 3, "1", { 0x3, 0x0, 0x0, 0x0, 0x0, 0x3 } },
	{ "E533336:<<;::E533336:<<;::E5", "B", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x8, 0x7, 0x7 } },
	{ "I&p9Jep94333343<:;:3I&p9Jep9", "F#m6", "Gbm6", 7, 3, "7", { CHORD_MUTE | 0x0, 0x9, 0x7, 0x8, 0x7, CHORD_MUTE | 0x0 } },
	{ "Fdgg<44333333d<;dFdgg<443333", "Cadd9", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0x9, 0x8, 0xa } },
	{ "D&:Ee:5333369;9:99D&:Ee:5333", "A#7", "Bb7", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x7, 0x6, 0x6 } },
	{ "D&44Ee44453336344444D&44Ee44", "A#11", "Bb11", 1, 1, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1, 0x1, 0x1, 0x1 } },
	{ "Dp:4533363fhfgfDp:4533363fhf", "Am7", NULL, 12, 3, "12", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xe, 0xc, 0xd, 0xc } },
	{ "J08333344678733J083333446787", "G-5", NULL, 3, 3, "3", { 0x3, 0x4, 0x5, 0x4, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "J&dxjDedxj4333343ed<<3J&dxjD", "G#aug", "Abaug", 9, 3, "9", { CHORD_MUTE | 0x0, 0xb, 0xa, 0x9, 0x9, CHORD_MUTE | 0x0 } },
	{ "I:443333336878I:443333336878", "F7", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x5, 0x4, 0x5 } },
	{ "J&ppdm:Deppdm:443333339776J&", "G#mmaj7", "Abmmaj7", 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x4, 0x4, 0x3 } },
	{ "D&:vxv7Ee:vxv75333369;9;99D&", "A#7sus4", "Bb7sus4", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x8, 0x6, 0x6 } },
	{ "D&dxjEedxj333344987:33D&dxjE", "A#aug", "Bbaug", 4, 4, "4", { 0x6, 0x5, 0x4, 0x7, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Dp433333335543Dp433333335543", "Am", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x1, 0x0 } },
	{ "Hp<3333333dfef3Hp<3333333dfe", "Em9", NULL, 10, 3, "10", { 0x0, 0xa, 0xc, 0xb, 0xc, 0x0 } },
	{ "I&:pdm8Je:pdm8345336555665I&", "F#7maj5", "Gb7maj5", 1, 3, "1", { 0x2, CHORD_MUTE | 0x2, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x3, 0x3, 0x2 } },
	{ "J&De4533363egggeJ&De4533363e", "G#", "Ab", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xd, 0xd, 0xb } },
	{ "J&pdm<Depdm<4353363e;;;;J&pd", "G#maj9", "Abmaj9", 8, 4, "8", { CHORD_MUTE | 0x0, 0xb, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0x8, 0x8 } },
	{ "I46333356434566I463333564345", "F13", NULL, 1, 3, "1", { 0x1, 0x0, 0x1, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "Dp<5333338:888:Dp<5333338:88", "Am9", NULL, 5, 3, "5", { 0x5, 0x7, 0x5, 0x5, 0x5, 0x7 } },
	{ "Evxv453336357785Evxv45333635", "Bsus", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x5, 0x2 } },
	{ "F&9dgg<Ge9dgg<433356376677F&", "C#6add9", "Db6add9", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x3, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "I&pJep4533363<eed<I&pJep4533", "F#m", "Gbm", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0xa, 0x9 } },
	{ "G&pdm<Hepdm<433334398:93G&pd", "D#maj9", "Ebmaj9", 5, 3, "5", { CHORD_MUTE | 0x0, 0x6, 0x5, 0x7, 0x6, CHORD_MUTE | 0x0 } },
	{ "Gp:533336dfddgdGp:533336dfdd", "Dm7", NULL, 10, 4, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xa, 0xa, 0xd, 0xa } },
	{ "F&44Ge44453336377777F&44Ge44", "C#11", "Db11", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4, 0x4, 0x4, 0x4 } },
	{ "F&p<Gep<333344<:<;33F&p<Gep<", "C#m9", "Dbm9", 7, 3, "7", { 0x9, 0x7, 0x9, 0x8, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Ddgg<44333333:98:Ddgg<443333", "Aadd9", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x6, 0x5, 0x7 } },
	{ "Hp333333355333Hp333333355333", "Em", NULL, 1, 2, "1", { 0x0, 0x2, 0x2, 0x0, 0x0, 0x0 } },
	{ "G43335633feddG43335633feddG4", "D", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0x0, 0xc, 0xb, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "J44343356636544J443433566365", "G11", NULL, 1, 3, "1", { 0x3, CHORD_MUTE | 0x0, 0x3, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "I&p:Jep:533336577585I&p:Jep:", "F#m7", "Gbm7", 2, 4, "2", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x2, 0x5, 0x2 } },
	{ "H44333333353535H443333333535", "E11", NULL, 1, 2, "1", { 0x0, 0x2, 0x0, 0x2, 0x0, 0x2 } },
	{ "G&pHep443333334675G&pHep4433", "D#m", "Ebm", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x4, 0x2 } },
	{ "Dpdm<333334879783Dpdm<333334", "Amaj9", NULL, 4, 3, "4", { 0x5, 0x4, 0x6, 0x4, 0x5, CHORD_MUTE | 0x0 } },
	{ "F0844333333degfF0844333333de", "C-5", NULL, 10, 4, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0xb, 0xd, 0xc } },
	{ "D:5333368:8988D:5333368:8988", "A7", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x6, 0x5, 0x5 } },
	{ "E44343356:3:988E44343356:3:9", "B11", NULL, 5, 3, "5", { 0x7, CHORD_MUTE | 0x0, 0x7, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "E533336557775E533336557775E5", "B", NULL, 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x4, 0x4, 0x4, 0x2 } },
	{ "Fppdm:453336368776Fppdm:4533", "Cmmaj7", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x4, 0x4, 0x3 } },
	{ "D:vxv7433333335366D:vxv74333", "A7sus4", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x3, 0x3 } },
	{ "J&:vxv7De:vxv7443356339977J&", "G#7sus4", "Ab7sus4", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "Fdgg<433333363363Fdgg<433333", "Cadd9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x0, 0x0, 0x3, 0x0 } },
	{ "Jppdm:343334637663Jppdm:3433", "Gmmaj7", NULL, 1, 4, "1", { 0x3, CHORD_MUTE | 0x0, 0x4, 0x3, 0x3, CHORD_MUTE | 0x0 } },
	{ "Fvxv533336;ddd;;Fvxv533336;d", "Csus", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0xa, 0x8, 0x8 } },
	{ "F&ppdm:Geppdm:453336379887F&", "C#mmaj7", "Dbmmaj7", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x5, 0x5, 0x4 } },
	{ "Dglp433334334543Dglp43333433", "Adim", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x1, 0x2, 0x1, CHORD_MUTE | 0x0 } },
	{ "I&46Je464333333<;<<eI&46Je46", "F#13", "Gb13", 8, 4, "8", { CHORD_MUTE | 0x0, 0x9, 0x8, 0x9, 0x9, 0xb } },
	{ "Fp9533336;dd;d;Fp9533336;dd;", "Cm6", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0x8, 0xa, 0x8 } },
	{ "F44343356;3;:99F44343356;3;:", "C11", NULL, 6, 3, "6", { 0x8, CHORD_MUTE | 0x0, 0x8, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6 } },
	{ "H433333355433H433333355433H4", "E", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x2, 0x1, 0x0, 0x0 } },
	{ "J&De4335363ed;<;J&De4335363e", "G#", "Ab", 8, 4, "8", { CHORD_MUTE | 0x0, 0xb, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x9, 0x8 } },
	{ "I&08Je08443333337645I&08Je08", "F#-5", "Gb-5", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x3, 0x1, 0x2 } },
	{ "D&glpEeglp433334345653D&glpE", "A#dim", "Bbdim", 1, 3, "1", { CHORD_MUTE | 0x0, 0x1, 0x2, 0x3, 0x2, CHORD_MUTE | 0x0 } },
	{ "G533336587565G533336587565G5", "D", NULL, 2, 4, "2", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x5, 0x4, 0x2, 0x3, 0x2 } },
	{ "Jp533336ddffedJp533336ddffed", "Gm", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa, 0xc, 0xc, 0xb, 0xa } },
	{ "Hp<333333355365Hp<3333333553", "Em9", NULL, 1, 3, "1", { 0x0, 0x2, 0x2, 0x0, 0x3, 0x2 } },
	{ "Ivxv4533363;dde;Ivxv4533363;", "Fsus", NULL, 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0xb, 0x8 } },
	{ "D&:pdm8Ee:pdm8345336999::9D&", "A#7maj5", "Bb7maj5", 6, 2, "6", { 0x6, CHORD_MUTE | 0x6, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x7, 0x7, 0x6 } },
	{ "H9333333355453H9333333355453", "E6", NULL, 1, 2, "1", { 0x0, 0x2, 0x2, 0x1, 0x2, 0x0 } },
	{ "H:vxv74533363:<:d:H:vxv74533", "E7sus4", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0xa, 0x7 } },
	{ "Evxv533336:<<<::Evxv533336:<", "Bsus", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x9, 0x7, 0x7 } },
	{ "J9443333338786J9443333338786", "G6", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x4, 0x5, 0x3 } },
	{ "G44343356d3d<;;G44343356d3d<", "D11", NULL, 8, 3, "8", { 0xa, CHORD_MUTE | 0x0, 0xa, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8 } },
	{ "Jglp333344678633Jglp33334467", "Gdim", NULL, 3, 3, "3", { 0x3, 0x4, 0x5, 0x3, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Jp<333344646533Jp<3333446465", "Gm9", NULL, 1, 3, "1", { 0x3, 0x1, 0x3, 0x2, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Edgg<453336357975Edgg<453336", "Badd9", NULL, 2, 5, "2", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x6, 0x4, 0x2 } },
	{ "I:08445333336778I:0844533333", "F7-5", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x4, 0x4, 0x5 } },
	{ "J533336688766J533336688766J5", "G", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x4, 0x3, 0x3 } },
	{ "Dp944533333:<:;Dp944533333:<", "Am6", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x9, 0x7, 0x8 } },
	{ "J&dgg<Dedgg<4353363e;;e;J&dg", "G#add9", "Abadd9", 8, 4, "8", { CHORD_MUTE | 0x0, 0xb, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0xb, 0x8 } },
	{ "J&vxvDevxv533336799977J&vxvD", "G#sus", "Absus", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x6, 0x4, 0x4 } },
	{ "Gpdm:44333333fhhhGpdm:443333", "Dmaj7", NULL, 12, 3, "12", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xe, 0xe, 0xe } },
	{ "D&p<Eep<5333339;999;D&p<Eep<", "A#m9", "Bbm9", 6, 3, "6", { 0x6, 0x8, 0x6, 0x6, 0x6, 0x8 } },
	{ "J&p9Dep9533336799797J&p9Dep9", "G#m6", "Abm6", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x4, 0x6, 0x4 } },
	{ "F&:Ge:343334<3<d<3F&:Ge:3433", "C#7", "Db7", 9, 2, "9", { 0x9, CHORD_MUTE | 0x0, 0x9, 0xa, 0x9, CHORD_MUTE | 0x0 } },
	{ "Ddxj44333333:998Ddxj44333333", "Aaug", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x6, 0x6, 0x5 } },
	{ "F&p:Gep:533336<ee<f<F&p:Gep:", "C#m7", "Dbm7", 9, 4, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0x9, 0xc, 0x9 } },
	{ "J&p9Dep9445333339;9:J&p9Dep9", "G#m6", "Abm6", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x8, 0x6, 0x7 } },
	{ "F&08Ge08333344<ded33F&08Ge08", "C#-5", "Db-5", 9, 3, "9", { 0x9, 0xa, 0xb, 0xa, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Jdxj333333654336Jdxj33333365", "Gaug", NULL, 1, 3, "1", { 0x3, 0x2, 0x1, 0x0, 0x0, 0x3 } },
	{ "Ep:433333353535Ep:4333333535", "Bm7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x0, 0x2, 0x0, 0x2 } },
	{ "Hp433333355333Hp433333355333", "Em", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x2, 0x0, 0x0, 0x0 } },
	{ "G46343356d3deffG46343356d3de", "D13", NULL, 10, 3, "10", { 0xa, CHORD_MUTE | 0x0, 0xa, 0xb, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xc } },
	{ "E9435336357777E9435336357777", "B6", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4, 0x4, 0x4 } },
	{ "I&glpJeglp333344567533I&glpJ", "F#dim", "Gbdim", 1, 4, "1", { 0x2, 0x3, 0x4, 0x2, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D0843333333:;d<D0843333333:;", "A-5", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0x0, 0x7, 0x8, 0xa, 0x9 } },
	{ "Gp944533333fhfgGp944533333fh", "Dm6", NULL, 12, 3, "12", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xe, 0xc, 0xd } },
	{ "G953333688::::G953333688::::", "D6", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x7, 0x7, 0x7, 0x7 } },
	{ "J&p<Dep<533333797779J&p<Dep<", "G#m9", "Abm9", 4, 3, "4", { 0x4, 0x6, 0x4, 0x4, 0x4, 0x6 } },
	{ "F433333365346F433333365346F4", "C", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x1, 0x3 } },
	{ "F&dxjGedxj433334376553F&dxjG", "C#aug", "Dbaug", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x3, 0x2, 0x2, CHORD_MUTE | 0x0 } },
	{ "I&p:Jep:533336575585I&p:Jep:", "F#m7", "Gbm7", 2, 4, "2", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x2, 0x5, 0x2 } },
	{ "F&pdm<Gepdm<333334<;d;<3F&pd", "C#maj9", "Dbmaj9", 8, 3, "8", { 0x9, 0x8, 0xa, 0x8, 0x9, CHORD_MUTE | 0x0 } },
	{ "Fdxj44333333d<<;Fdxj44333333", "Caug", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0x9, 0x9, 0x8 } },
	{ "G443333333565G443333333565G4", "D", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x3, 0x2 } },
	{ "I4533363;ddd;I4533363;ddd;I4", "F", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0xa, 0x8 } },
	{ "I44533333464646I445333334646", "F11", NULL, 1, 3, "1", { 0x1, 0x3, 0x1, 0x3, 0x1, 0x3 } },
	{ "Ipdm:4533363;d<d;Ipdm:453336", "Fmaj7", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x9, 0xa, 0x8 } },
	{ "Idgg<443333336546Idgg<443333", "Fadd9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x2, 0x1, 0x3 } },
	{ "I&46Je46343356535677I&46Je46", "F#13", "Gb13", 1, 4, "1", { 0x2, CHORD_MUTE | 0x0, 0x2, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "Jdgg<4533363dffddJdgg<453336", "Gadd9", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xa, 0xa } },
	{ "I08443333336534I084433333365", "F-5", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x1 } },
	{ "I&p<Jep<533333575557I&p<Jep<", "F#m9", "Gbm9", 1, 4, "1", { 0x2, 0x4, 0x2, 0x2, 0x2, 0x4 } },
	{ "G08433334389::3G08433334389:", "D-5", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x5, 0x6, 0x7, 0x7, CHORD_MUTE | 0x0 } },
	{ "Ddgg<4353363f<<d<Ddgg<435336", "Aadd9", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, 0xc, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9, 0xa, 0x9 } },
	{ "J&:08De:08445333339::;J&:08D", "G#7-5", "Ab7-5", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x7, 0x7, 0x8 } },
	{ "I443333336898I443333336898I4", "F", NULL, 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x5, 0x6, 0x5 } },
	{ "Hpdm:4533363:<;<:Hpdm:453336", "Emaj7", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x8, 0x9, 0x7 } },
	{ "D:08433333338978D:0843333333", "A7-5", NULL, 4, 3, "4", { CHORD_MUTE | 0x0, 0x0, 0x5, 0x6, 0x4, 0x5 } },
	{ "D&p:Eep:5333369;;9<9D&p:Eep:", "A#m7", "Bbm7", 6, 4, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x6, 0x9, 0x6 } },
	{ "G:08533744dede33G:08533744de", "D7-5", NULL, 10, 2, "10", { CHORD_END_OF_BARREE_LEFT | 0xa, 0xb, 0xa, 0xb, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&:Je:533336575655I&:Je:5333", "F#7", "Gb7", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x3, 0x2, 0x2 } },
	{ "J&vxvDevxv443356339977J&vxvD", "G#sus", "Absus", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "Gvxv45333638::;8Gvxv45333638", "Dsus", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x8, 0x5 } },
	{ "Hp:333333355363Hp:3333333553", "Em7", NULL, 1, 3, "1", { 0x0, 0x2, 0x2, 0x0, 0x3, 0x0 } },
	{ "G333333533565G333333533565G3", "D", NULL, 1, 3, "1", { 0x2, 0x0, 0x0, 0x2, 0x3, 0x2 } },
	{ "J:pdm84533333dgdfeJ:pdm84533", "G7maj5", NULL, 10, 4, "10", { CHORD_MUTE | 0x0, 0xa, 0xd, 0xa, 0xc, 0xb } },
	{ "I&dgg<Jedgg<4353363<99:9I&dg", "F#add9", "Gbadd9", 6, 4, "6", { CHORD_MUTE | 0x0, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6, 0x7, 0x6 } },
	{ "Edgg<44333333<;:<Edgg<443333", "Badd9", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x8, 0x7, 0x9 } },
	{ "H<333333353435H<333333353435", "E9", NULL, 1, 2, "1", { 0x0, 0x2, 0x0, 0x1, 0x0, 0x2 } },
	{ "I&p:Jep:4533363<e<d<I&p:Jep:", "F#m7", "Gbm7", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0xa, 0x9 } },
	{ "G<533333dfdedfG<533333dfdedf", "D9", NULL, 10, 3, "10", { 0xa, 0xc, 0xa, 0xb, 0xa, 0xc } },
	{ "Gdxj44333333feedGdxj44333333", "Daug", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xb, 0xb, 0xa } },
	{ "D&p:Eep:343334939993D&p:Eep:", "A#m7", "Bbm7", 6, 1, "6", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x6, 0x6, CHORD_MUTE | 0x0 } },
	{ "E944333333<;<:E944333333<;<:", "B6", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x8, 0x9, 0x7 } },
	{ "Fp:533336;dd;e;Fp:533336;dd;", "Cm7", NULL, 8, 4, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0x8, 0xb, 0x8 } },
	{ "D43333333:<d<D43333333:<d<D4", "A", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0x0, 0x7, 0x9, 0xa, 0x9 } },
	{ "Ep:343334:3:::3Ep:343334:3::", "Bm7", NULL, 7, 1, "7", { 0x7, CHORD_MUTE | 0x0, 0x7, 0x7, 0x7, CHORD_MUTE | 0x0 } },
	{ "Gppdm:343334d3edd3Gppdm:3433", "Dmmaj7", NULL, 10, 2, "10", { 0xa, CHORD_MUTE | 0x0, 0xb, 0xa, 0xa, CHORD_MUTE | 0x0 } },
	{ "Fdxj333344;:9833Fdxj333344;:", "Caug", NULL, 5, 4, "5", { 0x8, 0x7, 0x6, 0x5, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D:433333335353D:433333335353", "A7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x2, 0x0 } },
	{ "J<343356636566J<343356636566", "G9", NULL, 1, 3, "1", { 0x3, CHORD_MUTE | 0x0, 0x3, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "Hpdm:443333335777Hpdm:443333", "Emaj7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x4, 0x4 } },
	{ "G&9He944533333gigiG&9He94453", "D#6", "Eb6", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xd, 0xf, 0xd, 0xf } },
	{ "I:vxv74333563;;;99I:vxv74333", "F7sus4", NULL, 6, 3, "6", { CHORD_MUTE | 0x0, 0x8, 0x8, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6 } },
	{ "G&pdm<Hepdm<44333333gdedG&pd", "D#maj9", "Ebmaj9", 10, 4, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xd, 0xa, 0xb, 0xa } },
	{ "D:08433334334353D:0843333433", "A7-5", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x1, 0x0, 0x2, CHORD_MUTE | 0x0 } },
	{ "J&pdm<Depdm<443333339676J&pd", "G#maj9", "Abmaj9", 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x3, 0x4, 0x3 } },
	{ "Fppdm:343334;3<;;3Fppdm:3433", "Cmmaj7", NULL, 8, 2, "8", { 0x8, CHORD_MUTE | 0x0, 0x9, 0x8, 0x8, CHORD_MUTE | 0x0 } },
	{ "G:433333333545G:433333333545", "D7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x0, 0x2, 0x1, 0x2 } },
	{ "Dp:433333335346Dp:4333333353", "Am7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x1, 0x3 } },
	{ "F&:pdm8Ge:pdm8345336<<<dd<F&", "C#7maj5", "Db7maj5", 9, 2, "9", { 0x9, CHORD_MUTE | 0x9, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xa, 0xa, 0x9 } },
	{ "J084333343deff3J084333343def", "G-5", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xa, 0xb, 0xc, 0xc, CHORD_MUTE | 0x0 } },
	{ "Jvxv333333663346Jvxv33333366", "Gsus", NULL, 1, 3, "1", { 0x3, 0x3, 0x0, 0x0, 0x1, 0x3 } },
	{ "J4335363d<:;:J4335363d<:;:J4", "G", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0xa, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x8, 0x7 } },
	{ "G08333344defe33G08333344defe", "D-5", NULL, 10, 3, "10", { 0xa, 0xb, 0xc, 0xb, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Idxj4333343;:993Idxj4333343;", "Faug", NULL, 6, 3, "6", { CHORD_MUTE | 0x0, 0x8, 0x7, 0x6, 0x6, CHORD_MUTE | 0x0 } },
	{ "Edxj333334:98;33Edxj333334:9", "Baug", NULL, 5, 4, "5", { 0x7, 0x6, 0x5, 0x8, 0x0, CHORD_MUTE | 0x0 } },
	{ "D&Ee4335363gfdedD&Ee4335363g", "A#", "Bb", 10, 4, "10", { CHORD_MUTE | 0x0, 0xd, 0xc, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xb, 0xa } },
	{ "I&pJep533336577555I&pJep5333", "F#m", "Gbm", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x2, 0x2, 0x2 } },
	{ "J&pdm:Depdm:443333339;;;J&pd", "G#maj7", "Abmaj7", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x8, 0x8, 0x8 } },
	{ "G&:08He:08445333334556G&:08H", "D#7-5", "Eb7-5", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x2, 0x2, 0x3 } },
	{ "E44333333<efeE44333333<efeE4", "B", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xb, 0xc, 0xb } },
	{ "J<4333343d<dd3J<4333343d<dd3", "G9", NULL, 9, 2, "9", { CHORD_MUTE | 0x0, 0xa, 0x9, 0xa, 0xa, CHORD_MUTE | 0x0 } },
	{ "G&pdm<Hepdm<333334edfde3G&pd", "D#maj9", "Ebmaj9", 10, 3, "10", { 0xb, 0xa, 0xc, 0xa, 0xb, CHORD_MUTE | 0x0 } },
	{ "F&pdm:Gepdm:44333333egggF&pd", "C#maj7", "Dbmaj7", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xd, 0xd, 0xd } },
	{ "F433333365343F433333365343F4", "C", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x1, 0x0 } },
	{ "I&44Je44343333535433I&44Je44", "F#11", "Gb11", 1, 2, "1", { 0x2, CHORD_MUTE | 0x0, 0x2, 0x1, 0x0, 0x0 } },
	{ "I&glpJeglp4333343<ded3I&glpJ", "F#dim", "Gbdim", 9, 3, "9", { CHORD_MUTE | 0x0, 0x9, 0xa, 0xb, 0xa, CHORD_MUTE | 0x0 } },
	{ "Fpdm:44333333dfffFpdm:443333", "Cmaj7", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0xc, 0xc, 0xc } },
	{ "E:pdm8453333358576E:pdm84533", "B7maj5", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x2, 0x5, 0x2, 0x4, 0x3 } },
	{ "Edxj333334:98333Edxj333334:9", "Baug", NULL, 5, 3, "5", { 0x7, 0x6, 0x5, 0x0, 0x0, CHORD_MUTE | 0x0 } },
	{ "F944533333dfdfF944533333dfdf", "C6", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0xc, 0xa, 0xc } },
	{ "Dp333333635543Dp333333635543", "Am", NULL, 1, 3, "1", { 0x3, 0x0, 0x2, 0x2, 0x1, 0x0 } },
	{ "Jppdm:443333338665Jppdm:4433", "Gmmaj7", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x3, 0x3, 0x2 } },
	{ "D&Ee4533363giiigD&Ee4533363g", "A#", "Bb", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xd, 0xf, 0xf, 0xf, 0xd } },
	{ "D&:08Ee:085337449:9:33D&:08E", "A#7-5", "Bb7-5", 6, 2, "6", { CHORD_END_OF_BARREE_LEFT | 0x6, 0x7, 0x6, 0x7, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F&p:Gep:343334<3<<<3F&p:Gep:", "C#m7", "Dbm7", 9, 1, "9", { 0x9, CHORD_MUTE | 0x0, 0x9, 0x9, 0x9, CHORD_MUTE | 0x0 } },
	{ "Dp:433333335546Dp:4333333355", "Am7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x1, 0x3 } },
	{ "G:vxv7533336dfdfddG:vxv75333", "D7sus4", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xa, 0xc, 0xa, 0xa } },
	{ "Gglp443536333464Gglp44353633", "Ddim", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1 } },
	{ "D433333335553D433333335553D4", "A", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x2, 0x0 } },
	{ "Gglp333344defd33Gglp333344de", "Ddim", NULL, 10, 3, "10", { 0xa, 0xb, 0xc, 0xa, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&9Je9443333337675I&9Je94433", "F#6", "Gb6", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x3, 0x4, 0x2 } },
	{ "Dvxv4333343ff<d3Dvxv4333343f", "Asus", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, 0xc, 0xc, 0x9, 0xa, CHORD_MUTE | 0x0 } },
	{ "I9dgg<333333433344I9dgg<3333", "F6add9", NULL, 1, 1, "1", { 0x1, 0x0, 0x0, 0x0, 0x1, 0x1 } },
	{ "F&:08Ge:08533744<d<d33F&:08G", "C#7-5", "Db7-5", 9, 2, "9", { CHORD_END_OF_BARREE_LEFT | 0x9, 0xa, 0x9, 0xa, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D:vxv74333563fffddD:vxv74333", "A7sus4", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xc, 0xc, 0xc, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "I&<Je<343356535455I&<Je<3433", "F#9", "Gb9", 1, 2, "1", { 0x2, CHORD_MUTE | 0x0, 0x2, 0x1, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2 } },
	{ "D&:08Ee:0844533333;<<dD&:08E", "A#7-5", "Bb7-5", 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x9, 0x9, 0xa } },
	{ "D&p:Eep:5333369;9999D&p:Eep:", "A#m7", "Bbm7", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x6, 0x6, 0x6 } },
	{ "I&pdm:Jepdm:443333337999I&pd", "F#maj7", "Gbmaj7", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x6, 0x6, 0x6 } },
	{ "D&9Ee9435336346666D&9Ee94353", "A#6", "Bb6", 1, 3, "1", { CHORD_MUTE | 0x0, 0x1, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x3, 0x3 } },
	{ "Gp:45333638:898Gp:45333638:8", "Dm7", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x6, 0x5 } },
	{ "Fp<433334364663Fp<4333343646", "Cm9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x1, 0x3, 0x3, CHORD_MUTE | 0x0 } },
	{ "G9443333333535G9443333333535", "D6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x2 } },
	{ "D:0844533333:;;<D:0844533333", "A7-5", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x8, 0x8, 0x9 } },
	{ "Ip:533336464474Ip:5333364644", "Fm7", NULL, 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x1, 0x4, 0x1 } },
	{ "G:vxv7433356388866G:vxv74333", "D7sus4", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x5, 0x5, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "D9dgg<4333563feeffD9dgg<4333", "A6add9", NULL, 11, 2, "11", { CHORD_MUTE | 0x0, 0xc, 0xb, 0xb, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xc } },
	{ "D433333375553D433333375553D4", "A", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x2, 0x2, 0x2, 0x0 } },
	{ "H084333343:;<<3H084333343:;<", "E-5", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, 0x7, 0x8, 0x9, 0x9, CHORD_MUTE | 0x0 } },
	{ "Dp<433333335746Dp<4333333357", "Am9", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x4, 0x1, 0x3 } },
	{ "Jvxv4333343dd:;3Jvxv4333343d", "Gsus", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0xa, 0xa, 0x7, 0x8, CHORD_MUTE | 0x0 } },
	{ "H:083333333:;:<3H:083333333:", "E7-5", NULL, 7, 3, "7", { 0x0, 0x7, 0x8, 0x7, 0x9, 0x0 } },
	{ "G&:08He:0843333439:9;3G&:08H", "D#7-5", "Eb7-5", 6, 3, "6", { CHORD_MUTE | 0x0, 0x6, 0x7, 0x6, 0x8, CHORD_MUTE | 0x0 } },
	{ "I08333344456533I083333444565", "F-5", NULL, 1, 3, "1", { 0x1, 0x2, 0x3, 0x2, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G:45333638:8:8G:45333638:8:8", "D7", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x7, 0x5 } },
	{ "F9433333365543F9433333365543", "C6", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x2, 0x1, 0x0 } },
	{ "F&Ge44333333egfgF&Ge44333333", "C#", "Db", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xd, 0xc, 0xd } },
	{ "D&p<Eep<44533633;d<;D&p<Eep<", "A#m9", "Bbm9", 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x9, 0x8 } },
	{ "I&p<Jep<333344535433I&p<Jep<", "F#m9", "Gbm9", 1, 2, "1", { 0x2, 0x0, 0x2, 0x1, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Hdgg<4533363:<e<:Hdgg<453336", "Eadd9", NULL, 7, 5, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0xb, 0x9, 0x7 } },
	{ "J9333333653333J9333333653333", "G6", NULL, 1, 3, "1", { 0x3, 0x2, 0x0, 0x0, 0x0, 0x0 } },
	{ "H:vxv7333333353533H:vxv73333", "E7sus4", NULL, 1, 2, "1", { 0x0, 0x2, 0x0, 0x2, 0x0, 0x0 } },
	{ "E:08533744:;:;33E:08533744:;", "B7-5", NULL, 7, 2, "7", { CHORD_END_OF_BARREE_LEFT | 0x7, 0x8, 0x7, 0x8, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Dp94333343fded3Dp94333343fde", "Am6", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xc, 0xa, 0xb, 0xa, CHORD_MUTE | 0x0 } },
	{ "I&pdm:Jepdm:4533363<ede<I&pd", "F#maj7", "Gbmaj7", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xa, 0xb, 0x9 } },
	{ "F&:vxv7Ge:vxv7533336<e<e<<F&", "C#7sus4", "Db7sus4", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0xb, 0x9, 0x9 } },
	{ "Fvxv453336368896Fvxv45333636", "Csus", NULL, 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x6, 0x3 } },
	{ "Jp:533336686696Jp:5333366866", "Gm7", NULL, 3, 4, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x3, 0x6, 0x3 } },
	{ "Ipdm<44333333ifgfIpdm<443333", "Fmaj9", NULL, 12, 4, "12", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xf, 0xc, 0xd, 0xc } },
	{ "Hpdm:333333354433Hpdm:333333", "Emaj7", NULL, 1, 2, "1", { 0x0, 0x2, 0x1, 0x1, 0x0, 0x0 } },
	{ "F:pdm8453333369687F:pdm84533", "C7maj5", NULL, 3, 4, "3", { CHORD_MUTE | 0x0, 0x3, 0x6, 0x3, 0x5, 0x4 } },
	{ "Dp5333368::888Dp5333368::888", "Am", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x5, 0x5, 0x5 } },
	{ "I&pdm<Jepdm<443333337454I&pd", "F#maj9", "Gbmaj9", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x1, 0x2, 0x1 } },
	{ "J443356333766J443356333766J4", "G", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "G&He44333333gihiG&He44333333", "D#", "Eb", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xd, 0xf, 0xe, 0xf } },
	{ "D943333333eed3D943333333eed3", "A6", NULL, 10, 2, "10", { CHORD_MUTE | 0x0, 0x0, 0xb, 0xb, 0xa, 0x0 } },
	{ "G:08443333333445G:0844333333", "D7-5", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x1, 0x1, 0x2 } },
	{ "Hpdm:353333355777Hpdm:353333", "Emaj7", NULL, 1, 4, "1", { 0x0, 0x2, 0x2, 0x4, 0x4, 0x4 } },
	{ "Jpdm:4533363dfefdJpdm:453336", "Gmaj7", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xb, 0xc, 0xa } },
	{ "J&:pdm8De:pdm84533333ehegfJ&", "G#7maj5", "Ab7maj5", 11, 4, "11", { CHORD_MUTE | 0x0, 0xb, 0xe, 0xb, 0xd, 0xc } },
	{ "Fp:343334;3;;;3Fp:343334;3;;", "Cm7", NULL, 8, 1, "8", { 0x8, CHORD_MUTE | 0x0, 0x8, 0x8, 0x8, CHORD_MUTE | 0x0 } },
	{ "F&ppdm:Geppdm:44333333e<<;F&", "C#mmaj7", "Dbmmaj7", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0x9, 0x9, 0x8 } },
	{ "D46433356338755D464333563387", "A13", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x0, 0x5, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2 } },
	{ "F44333333dfgfF44333333dfgfF4", "C", NULL, 10, 4, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0xc, 0xd, 0xc } },
	{ "H:pdm8343333333443H:pdm83433", "E7maj5", NULL, 1, 1, "1", { 0x0, CHORD_MUTE | 0x0, 0x0, 0x1, 0x1, 0x0 } },
	{ "Jp443333338:;9Jp443333338:;9", "Gm", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x7, 0x8, 0x6 } },
	{ "F9435336368888F9435336368888", "C6", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x5, 0x5 } },
	{ "H44343356f3feddH44343356f3fe", "E11", NULL, 10, 3, "10", { 0xc, CHORD_MUTE | 0x0, 0xc, 0xb, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "J:343334636763J:343334636763", "G7", NULL, 1, 4, "1", { 0x3, CHORD_MUTE | 0x0, 0x3, 0x4, 0x3, CHORD_MUTE | 0x0 } },
	{ "D&9Ee944333333;:;9D&9Ee94433", "A#6", "Bb6", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x7, 0x8, 0x6 } },
	{ "Hp:533336fhffifHp:533336fhff", "Em7", NULL, 12, 4, "12", { CHORD_END_OF_BARREE_RIGHT | 0xc, 0xe, 0xc, 0xc, 0xf, 0xc } },
	{ "G&pdm<Hepdm<435336396666G&pd", "D#maj9", "Ebmaj9", 3, 4, "3", { CHORD_MUTE | 0x0, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x3, 0x3 } },
	{ "Dpdm:44333333:<<<Dpdm:443333", "Amaj7", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x9, 0x9, 0x9 } },
	{ "Ep:533336:<::d:Ep:533336:<::", "Bm7", NULL, 7, 4, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x7, 0xa, 0x7 } },
	{ "H:333333353463H:333333353463", "E7", NULL, 1, 3, "1", { 0x0, 0x2, 0x0, 0x1, 0x3, 0x0 } },
	{ "Dglp4333343fghg3Dglp4333343f", "Adim", NULL, 12, 3, "12", { CHORD_MUTE | 0x0, 0xc, 0xd, 0xe, 0xd, CHORD_MUTE | 0x0 } },
	{ "D&dgg<Eedgg<453336346644D&dg", "A#add9", "Bbadd9", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x1, 0x1 } },
	{ "E453336357775E453336357775E4", "B", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x4, 0x2 } },
	{ "J&pdm<Depdm<333334768673J&pd", "G#maj9", "Abmaj9", 3, 3, "3", { 0x4, 0x3, 0x5, 0x3, 0x4, CHORD_MUTE | 0x0 } },
	{ "Jdgg<4533363dfhfdJdgg<453336", "Gadd9", NULL, 10, 5, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xe, 0xc, 0xa } },
	{ "G:vxv7443333333546G:vxv74433", "D7sus4", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x3 } },
	{ "J&44De444533363eeeeeJ&44De44", "G#11", "Ab11", 11, 1, "11", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xb, 0xb, 0xb, 0xb } },
	{ "Fp:533336;d;;;;Fp:533336;d;;", "Cm7", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0x8, 0x8, 0x8 } },
	{ "J:4533363dfdfdJ:4533363dfdfd", "G7", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xa, 0xc, 0xa } },
	{ "Dp95333368::8:8Dp95333368::8", "Am6", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x5, 0x7, 0x5 } },
	{ "F9533336668888F9533336668888", "C6", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x5, 0x5, 0x5, 0x5 } },
	{ "F&dgg<Gedgg<453336379;97F&dg", "C#add9", "Dbadd9", 4, 5, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x8, 0x6, 0x4 } },
	{ "Gp443333333564Gp443333333564", "Dm", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x3, 0x1 } },
	{ "G&44He44453336399999G&44He44", "D#11", "Eb11", 6, 1, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6, 0x6, 0x6, 0x6 } },
	{ "Fp<333344;9;:33Fp<333344;9;:", "Cm9", NULL, 6, 3, "6", { 0x8, 0x6, 0x8, 0x7, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D:333333335556D:333333335556", "A7", NULL, 1, 3, "1", { 0x0, 0x0, 0x2, 0x2, 0x2, 0x3 } },
	{ "I&dgg<Jedgg<4353363<99<9I&dg", "F#add9", "Gbadd9", 6, 4, "6", { CHORD_MUTE | 0x0, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6, 0x9, 0x6 } },
	{ "J&pdm<Depdm<4333343edfe3J&pd", "G#maj9", "Abmaj9", 10, 3, "10", { CHORD_MUTE | 0x0, 0xb, 0xa, 0xc, 0xb, CHORD_MUTE | 0x0 } },
	{ "Ip:533336464444Ip:5333364644", "Fm7", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x1, 0x1, 0x1 } },
	{ "G&pdm:Hepdm:443333334666G&pd", "D#maj7", "Ebmaj7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x3, 0x3 } },
	{ "I08443333336798I084433333367", "F-5", NULL, 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x4, 0x6, 0x5 } },
	{ "J&glpDeglp333344789733J&glpD", "G#dim", "Abdim", 4, 3, "4", { 0x4, 0x5, 0x6, 0x4, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Fp:453336368676Fp:4533363686", "Cm7", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x4, 0x3 } },
	{ "Hp:333333353363Hp:3333333533", "Em7", NULL, 1, 3, "1", { 0x0, 0x2, 0x0, 0x0, 0x3, 0x0 } },
	{ "G44443333333886G444433333338", "D11", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x5, 0x5, 0x3 } },
	{ "Ep9533336:<<:<:Ep9533336:<<:", "Bm6", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x7, 0x9, 0x7 } },
	{ "H:333333353433H:333333353433", "E7", NULL, 1, 2, "1", { 0x0, 0x2, 0x0, 0x1, 0x0, 0x0 } },
	{ "Dppdm:433333335443Dppdm:4333", "Ammaj7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x1, 0x0 } },
	{ "Dp3333563::888Dp3333563::888", "Am", NULL, 5, 3, "5", { 0x0, 0x7, 0x7, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "Fppdm:44333333d;;:Fppdm:4433", "Cmmaj7", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0x8, 0x8, 0x7 } },
	{ "D&:Ee:343334939:93D&:Ee:3433", "A#7", "Bb7", 6, 2, "6", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x7, 0x6, CHORD_MUTE | 0x0 } },
	{ "Jdgg<4353363d::d:Jdgg<435336", "Gadd9", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0xa, 0x7 } },
	{ "Hdgg<4533363:<<::Hdgg<453336", "Eadd9", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x7, 0x7 } },
	{ "Hppdm:343334f3gff3Hppdm:3433", "Emmaj7", NULL, 12, 2, "12", { 0xc, CHORD_MUTE | 0x0, 0xd, 0xc, 0xc, CHORD_MUTE | 0x0 } },
	{ "I&:pdm8Je:pdm84533333<f<edI&", "F#7maj5", "Gb7maj5", 9, 4, "9", { CHORD_MUTE | 0x0, 0x9, 0xc, 0x9, 0xb, 0xa } },
	{ "F&pdm<Gepdm<44333333e;<;F&pd", "C#maj9", "Dbmaj9", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0x8, 0x9, 0x8 } },
	{ "G433536387565G433536387565G4", "D", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x5, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x3, 0x2 } },
	{ "Hdgg<4353363:7787Hdgg<435336", "Eadd9", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4, 0x5, 0x4 } },
	{ "F&:vxv7Ge:vxv7433356377755F&", "C#7sus4", "Db7sus4", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x4, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2 } },
	{ "G&44He44434333393997G&44He44", "D#11", "Eb11", 4, 3, "4", { CHORD_MUTE | 0x0, 0x6, CHORD_MUTE | 0x0, 0x6, 0x6, 0x4 } },
	{ "H:4533363:<:<:H:4533363:<:<:", "E7", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x9, 0x7 } },
	{ "D9335336335555D9335336335555", "A6", NULL, 1, 2, "1", { 0x0, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x2, 0x2 } },
	{ "G&He533336eggfeeG&He533336eg", "D#", "Eb", 11, 3, "11", { CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xd, 0xc, 0xb, 0xb } },
	{ "F&dgg<Gedgg<453336379977F&dg", "C#add9", "Dbadd9", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x4, 0x4 } },
	{ "Fp453336368876Fp453336368876", "Cm", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x4, 0x3 } },
	{ "F<433333365663F<433333365663", "C9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x3, 0x3, 0x0 } },
	{ "F44433333363664F444333333636", "C11", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x0, 0x3, 0x3, 0x1 } },
	{ "Dpdm<44333333:787Dpdm<443333", "Amaj9", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x4, 0x5, 0x4 } },
	{ "F&:pdm8Ge:pdm845333337:798F&", "C#7maj5", "Db7maj5", 4, 4, "4", { CHORD_MUTE | 0x0, 0x4, 0x7, 0x4, 0x6, 0x5 } },
	{ "D&:Ee:453336346464D&:Ee:4533", "A#7", "Bb7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x3, 0x1 } },
	{ "Iglp4333343;<d<3Iglp4333343;", "Fdim", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0x8, 0x9, 0xa, 0x9, CHORD_MUTE | 0x0 } },
	{ "G&p:Hep:343334e3eee3G&p:Hep:", "D#m7", "Ebm7", 11, 1, "11", { 0xb, CHORD_MUTE | 0x0, 0xb, 0xb, 0xb, CHORD_MUTE | 0x0 } },
	{ "Ddgg<4353363f<<f<Ddgg<435336", "Aadd9", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, 0xc, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9, 0xc, 0x9 } },
	{ "Ippdm:443333336443Ippdm:4433", "Fmmaj7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x1, 0x1, 0x0 } },
	{ "G&pdm:Hepdm:45333639;:;9G&pd", "D#maj7", "Ebmaj7", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x7, 0x8, 0x6 } },
	{ "F&dgg<Gedgg<435336374454F&dg", "C#add9", "Dbadd9", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1, 0x2, 0x1 } },
	{ "J&08De08333344789833J&08De08", "G#-5", "Ab-5", 4, 3, "4", { 0x4, 0x5, 0x6, 0x5, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G&dxjHedxj333344ed<;33G&dxjH", "D#aug", "Ebaug", 8, 4, "8", { 0xb, 0xa, 0x9, 0x8, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "E<433334354553E<433334354553", "B9", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x1, 0x2, 0x2, CHORD_MUTE | 0x0 } },
	{ "I:084333343;<;d3I:084333343;", "F7-5", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0x8, 0x9, 0x8, 0xa, CHORD_MUTE | 0x0 } },
	{ "H9443333335453H9443333335453", "E6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x1, 0x2, 0x0 } },
	{ "D4335363fe<d<D4335363fe<d<D4", "A", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, 0xc, 0xb, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xa, 0x9 } },
	{ "H333333755433H333333755433H3", "E", NULL, 1, 4, "1", { 0x4, 0x2, 0x2, 0x1, 0x0, 0x0 } },
	{ "J9dgg<4333563d<<ddJ9dgg<4333", "G6add9", NULL, 9, 2, "9", { CHORD_MUTE | 0x0, 0xa, 0x9, 0x9, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "Ep944533333<e<dEp944533333<e", "Bm6", NULL, 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xb, 0x9, 0xa } },
	{ "Hp:333333353336Hp:3333333533", "Em7", NULL, 1, 3, "1", { 0x0, 0x2, 0x0, 0x0, 0x0, 0x3 } },
	{ "G45333638:::8G45333638:::8G4", "D", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x7, 0x5 } },
	{ "D&Ee533336446664D&Ee53333644", "A#", "Bb", 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1, 0x3, 0x3, 0x3, 0x1 } },
	{ "G&p<Hep<445336334654G&p<Hep<", "D#m9", "Ebm9", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x2, 0x1 } },
	{ "Epdm<44333333<9:9Epdm<443333", "Bmaj9", NULL, 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x6, 0x7, 0x6 } },
	{ "G&p:Hep:45333639;9:9G&p:Hep:", "D#m7", "Ebm7", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x7, 0x6 } },
	{ "Epdm:453336357675Epdm:453336", "Bmaj7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x3, 0x4, 0x2 } },
	{ "I&Je4433333379:9I&Je44333333", "F#", "Gb", 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x6, 0x7, 0x6 } },
	{ "Gdgg<435336385565Gdgg<435336", "Dadd9", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x3, 0x2 } },
	{ "G<443333333543G<443333333543", "D9", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x0 } },
	{ "Jglp4333343defe3Jglp4333343d", "Gdim", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xa, 0xb, 0xc, 0xb, CHORD_MUTE | 0x0 } },
	{ "J&08De08443333339867J&08De08", "G#-5", "Ab-5", 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x5, 0x3, 0x4 } },
	{ "I&dxjJedxj4333343<;::3I&dxjJ", "F#aug", "Gbaug", 7, 3, "7", { CHORD_MUTE | 0x0, 0x9, 0x8, 0x7, 0x7, CHORD_MUTE | 0x0 } },
	{ "F:343334;3;<;3F:343334;3;<;3", "C7", NULL, 8, 2, "8", { 0x8, CHORD_MUTE | 0x0, 0x8, 0x9, 0x8, CHORD_MUTE | 0x0 } },
	{ "J&46De46343356737899J&46De46", "G#13", "Ab13", 4, 3, "4", { 0x4, CHORD_MUTE | 0x0, 0x4, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6 } },
	{ "D&44Ee445333339;9;9;D&44Ee44", "A#11", "Bb11", 6, 3, "6", { 0x6, 0x8, 0x6, 0x8, 0x6, 0x8 } },
	{ "D&Ee44333333;dedD&Ee44333333", "A#", "Bb", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0xa, 0xb, 0xa } },
	{ "I&44Je44533333575757I&44Je44", "F#11", "Gb11", 1, 4, "1", { 0x2, 0x4, 0x2, 0x4, 0x2, 0x4 } },
	{ "D&p:Eep:5333369;99<9D&p:Eep:", "A#m7", "Bbm7", 6, 4, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x6, 0x9, 0x6 } },
	{ "Fdgg<453336368866Fdgg<453336", "Cadd9", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x3, 0x3 } },
	{ "G&vxvHevxv45333639;;<9G&vxvH", "D#sus", "Ebsus", 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x9, 0x6 } },
	{ "H444533363:::::H444533363:::", "E11", NULL, 7, 1, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x7, 0x7, 0x7 } },
	{ "Fpdm:433333365333Fpdm:433333", "Cmaj7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x0, 0x0 } },
	{ "Jpdm<333334657563Jpdm<333334", "Gmaj9", NULL, 1, 4, "1", { 0x3, 0x2, 0x4, 0x2, 0x3, CHORD_MUTE | 0x0 } },
	{ "G&p<Hep<333344e<ed33G&p<Hep<", "D#m9", "Ebm9", 9, 3, "9", { 0xb, 0x9, 0xb, 0xa, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G46343356d3d<::G46343356d3d<", "D13", NULL, 7, 4, "7", { 0xa, CHORD_MUTE | 0x0, 0xa, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7 } },
	{ "G9dgg<353333d<<<ddG9dgg<3533", "D6add9", NULL, 9, 2, "9", { 0xa, 0x9, 0x9, 0x9, 0xa, 0xa } },
	{ "Gpdm<435336385555Gpdm<435336", "Dmaj9", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x2, 0x2 } },
	{ "Hp:333333355366Hp:3333333553", "Em7", NULL, 1, 3, "1", { 0x0, 0x2, 0x2, 0x0, 0x3, 0x3 } },
	{ "F&pGep453336379987F&pGep4533", "C#m", "Dbm", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x5, 0x4 } },
	{ "D&pdm:Eepdm:44333333;:98D&pd", "A#maj7", "Bbmaj7", 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x7, 0x6, 0x5 } },
	{ "Idxj443333336554Idxj44333333", "Faug", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x2, 0x2, 0x1 } },
	{ "F&p<Gep<533333<e<<<eF&p<Gep<", "C#m9", "Dbm9", 9, 3, "9", { 0x9, 0xb, 0x9, 0x9, 0x9, 0xb } },
	{ "G&pdm<Hepdm<443333334364G&pd", "D#maj9", "Ebmaj9", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x0, 0x3, 0x1 } },
	{ "Ipdm<4333343;:<;3Ipdm<433334", "Fmaj9", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, 0x8, 0x7, 0x9, 0x8, CHORD_MUTE | 0x0 } },
	{ "I464333333;:;;dI464333333;:;", "F13", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0x8, 0x7, 0x8, 0x8, 0xa } },
	{ "Jpdm:443333338765Jpdm:443333", "Gmaj7", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x4, 0x3, 0x2 } },
	{ "F&Ge453336379997F&Ge45333637", "C#", "Db", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x6, 0x4 } },
	{ "Hp443333335786Hp443333335786", "Em", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x5, 0x3 } },
	{ "Dvxv433333333563Dvxv43333333", "Asus", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x0, 0x2, 0x3, 0x0 } },
	{ "Iglp333344456433Iglp33334445", "Fdim", NULL, 1, 3, "1", { 0x1, 0x2, 0x3, 0x1, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Ddgg<433333335753Ddgg<433333", "Aadd9", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x4, 0x2, 0x0 } },
	{ "Hppdm:443333335776Hppdm:4433", "Emmaj7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x4, 0x3 } },
	{ "G&p9Hep9433334397873G&p9Hep9", "D#m6", "Ebm6", 4, 3, "4", { CHORD_MUTE | 0x0, 0x6, 0x4, 0x5, 0x4, CHORD_MUTE | 0x0 } },
	{ "D&:pdm8Ee:pdm8453333347465D&", "A#7maj5", "Bb7maj5", 1, 4, "1", { CHORD_MUTE | 0x0, 0x1, 0x4, 0x1, 0x3, 0x2 } },
	{ "G&:He:45333639;9;9G&:He:4533", "D#7", "Eb7", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x6, 0x8, 0x6 } },
	{ "Dp:333333838883Dp:3333338388", "Am7", NULL, 5, 1, "5", { 0x5, 0x0, 0x5, 0x5, 0x5, 0x0 } },
	{ "Gp<443333333543Gp<4433333335", "Dm9", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x0 } },
	{ "D&08Ee0844333333;<edD&08Ee08", "A#-5", "Bb-5", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x9, 0xb, 0xa } },
	{ "F&vxvGevxv533336<eee<<F&vxvG", "C#sus", "Dbsus", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0xb, 0x9, 0x9 } },
	{ "Gpdm<333334d<e<d3Gpdm<333334", "Dmaj9", NULL, 9, 3, "9", { 0xa, 0x9, 0xb, 0x9, 0xa, CHORD_MUTE | 0x0 } },
	{ "J4533363dfffdJ4533363dfffdJ4", "G", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xc, 0xa } },
	{ "I&:vxv7Je:vxv74533363<e<f<I&", "F#7sus4", "Gb7sus4", 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0xc, 0x9 } },
	{ "G&:He:343334e3efe3G&:He:3433", "D#7", "Eb7", 11, 2, "11", { 0xb, CHORD_MUTE | 0x0, 0xb, 0xc, 0xb, CHORD_MUTE | 0x0 } },
	{ "F453336368886F453336368886F4", "C", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x5, 0x3 } },
	{ "G&dgg<Hedgg<45333639;;99G&dg", "D#add9", "Ebadd9", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x6, 0x6 } },
	{ "I&p9Jep9445333337978I&p9Jep9", "F#m6", "Gbm6", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x6, 0x4, 0x5 } },
	{ "Gdxj443333333665Gdxj44333333", "Daug", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x3, 0x3, 0x2 } },
	{ "D&pdm:Eepdm:453336346564D&pd", "A#maj7", "Bbmaj7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x2, 0x3, 0x1 } },
	{ "Dvxv433333335563Dvxv43333333", "Asus", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x3, 0x0 } },
	{ "E46343356:3:977E46343356:3:9", "B13", NULL, 4, 4, "4", { 0x7, CHORD_MUTE | 0x0, 0x7, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "I443333336544I443333336544I4", "F", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x2, 0x1, 0x1 } },
	{ "H5333367:9787H5333367:9787H5", "E", NULL, 4, 4, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x7, 0x6, 0x4, 0x5, 0x4 } },
	{ "G&9dgg<He9dgg<433356398899G&", "D#6add9", "Eb6add9", 5, 2, "5", { CHORD_MUTE | 0x0, 0x6, 0x5, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6 } },
	{ "Jdgg<333333653536Jdgg<333333", "Gadd9", NULL, 1, 3, "1", { 0x3, 0x2, 0x0, 0x2, 0x0, 0x3 } },
	{ "Hvxv333333335533Hvxv33333333", "Esus", NULL, 1, 2, "1", { 0x0, 0x0, 0x2, 0x2, 0x0, 0x0 } },
	{ "Idgg<4533363;dd;;Idgg<453336", "Fadd9", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0x8, 0x8 } },
	{ "Fp:533336;d;;e;Fp:533336;d;;", "Cm7", NULL, 8, 4, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0x8, 0xb, 0x8 } },
	{ "I&p:Jep:533336575555I&p:Jep:", "F#m7", "Gbm7", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x2, 0x2, 0x2 } },
	{ "Gpdm:44333333fed<Gpdm:443333", "Dmaj7", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xb, 0xa, 0x9 } },
	{ "Eppdm:343334:3;::3Eppdm:3433", "Bmmaj7", NULL, 7, 2, "7", { 0x7, CHORD_MUTE | 0x0, 0x8, 0x7, 0x7, CHORD_MUTE | 0x0 } },
	{ "G&9He943533639;;;;G&9He94353", "D#6", "Eb6", 6, 3, "6", { CHORD_MUTE | 0x0, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0x8, 0x8 } },
	{ "F&vxvGevxv4533363799:7F&vxvG", "C#sus", "Dbsus", 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x7, 0x4 } },
	{ "Dp:433333335343Dp:4333333353", "Am7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x1, 0x0 } },
	{ "Hdgg<333333355435Hdgg<333333", "Eadd9", NULL, 1, 2, "1", { 0x0, 0x2, 0x2, 0x1, 0x0, 0x2 } },
	{ "Hdgg<4353363:77:7Hdgg<435336", "Eadd9", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4, 0x7, 0x4 } },
	{ "Ep453336357765Ep453336357765", "Bm", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x3, 0x2 } },
	{ "Fdgg<453336368:86Fdgg<453336", "Cadd9", NULL, 3, 5, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x7, 0x5, 0x3 } },
	{ "Ipdm:443333336888Ipdm:443333", "Fmaj7", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x5, 0x5, 0x5 } },
	{ "Gdgg<44333333fedfGdgg<443333", "Dadd9", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xb, 0xa, 0xc } },
	{ "I&ppdm:Jeppdm:443333337554I&", "F#mmaj7", "Gbmmaj7", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x2, 0x2, 0x1 } },
	{ "Gp<433334386883Gp<4333343868", "Dm9", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x5, 0x3, 0x5, 0x5, CHORD_MUTE | 0x0 } },
	{ "Jppdm:443333338::9Jppdm:4433", "Gmmaj7", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x7, 0x7, 0x6 } },
	{ "J333333653336J333333653336J3", "G", NULL, 1, 3, "1", { 0x3, 0x2, 0x0, 0x0, 0x0, 0x3 } },
	{ "F&glpGeglp433334378983F&glpG", "C#dim", "Dbdim", 4, 3, "4", { CHORD_MUTE | 0x0, 0x4, 0x5, 0x6, 0x5, CHORD_MUTE | 0x0 } },
	{ "H46343356f3fe<<H46343356f3fe", "E13", NULL, 9, 4, "9", { 0xc, CHORD_MUTE | 0x0, 0xc, 0xb, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9 } },
	{ "I&08Je084333343<dee3I&08Je08", "F#-5", "Gb-5", 9, 3, "9", { CHORD_MUTE | 0x0, 0x9, 0xa, 0xb, 0xb, CHORD_MUTE | 0x0 } },
	{ "G:443333333545G:443333333545", "D7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x2 } },
	{ "Hp:343334f3fff3Hp:343334f3ff", "Em7", NULL, 12, 1, "12", { 0xc, CHORD_MUTE | 0x0, 0xc, 0xc, 0xc, CHORD_MUTE | 0x0 } },
	{ "G44453336388888G444533363888", "D11", NULL, 5, 1, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x5, 0x5, 0x5 } },
	{ "D5333368::988D5333368::988D5", "A", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x6, 0x5, 0x5 } },
	{ "I&08Je084433333378:9I&08Je08", "F#-5", "Gb-5", 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x5, 0x7, 0x6 } },
	{ "F&<Ge<533333<e<d<eF&<Ge<5333", "C#9", "Db9", 9, 3, "9", { 0x9, 0xb, 0x9, 0xa, 0x9, 0xb } },
	{ "Fp533336;dd;;;Fp533336;dd;;;", "Cm", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0x8, 0x8, 0x8 } },
	{ "Hp9445333335756Hp94453333357", "Em6", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x2, 0x3 } },
	{ "J&dxjDedxj333344765433J&dxjD", "G#aug", "Abaug", 1, 4, "1", { 0x4, 0x3, 0x2, 0x1, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F:08433333367683F:0843333336", "C7-5", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x3, 0x4, 0x3, 0x5, 0x0 } },
	{ "D44433356338766D444333563387", "A11", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x0, 0x5, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "F:333333365643F:333333365643", "C7", NULL, 1, 3, "1", { 0x0, 0x3, 0x2, 0x3, 0x1, 0x0 } },
	{ "Jp9533336688686Jp95333366886", "Gm6", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x3, 0x5, 0x3 } },
	{ "F&<Ge<433334376773F&<Ge<4333", "C#9", "Db9", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x3, 0x4, 0x4, CHORD_MUTE | 0x0 } },
	{ "F&pdm<Gepdm<435336374444F&pd", "C#maj9", "Dbmaj9", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1, 0x1, 0x1 } },
	{ "G&dgg<Hedgg<435336396696G&dg", "D#add9", "Ebadd9", 3, 4, "3", { CHORD_MUTE | 0x0, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x6, 0x3 } },
	{ "Hpdm<3353363:7777Hpdm<335336", "Emaj9", NULL, 4, 4, "4", { 0x0, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4, 0x4, 0x4 } },
	{ "D&dgg<Eedgg<453336346864D&dg", "A#add9", "Bbadd9", 1, 5, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x5, 0x3, 0x1 } },
	{ "F&p9Gep9433334375653F&p9Gep9", "C#m6", "Dbm6", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x2, 0x3, 0x2, CHORD_MUTE | 0x0 } },
	{ "D&08Ee083333449:;:33D&08Ee08", "A#-5", "Bb-5", 6, 3, "6", { 0x6, 0x7, 0x8, 0x7, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D9433333337553D9433333337553", "A6", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x0, 0x4, 0x2, 0x2, 0x0 } },
	{ "F&:Ge:453336379797F&:Ge:4533", "C#7", "Db7", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x6, 0x4 } },
	{ "Fdgg<433333365366Fdgg<433333", "Cadd9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x3, 0x3 } },
	{ "J&ppdm:Deppdm:443333339;;:J&", "G#mmaj7", "Abmmaj7", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x8, 0x8, 0x7 } },
	{ "E:453336357575E:453336357575", "B7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x4, 0x2 } },
	{ "E9433333354435E9433333354435", "B6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x1, 0x1, 0x0, 0x2 } },
	{ "Hp<333333353365Hp<3333333533", "Em9", NULL, 1, 3, "1", { 0x0, 0x2, 0x0, 0x0, 0x3, 0x2 } },
	{ "G0844333333fgihG0844333333fg", "D-5", NULL, 12, 4, "12", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xd, 0xf, 0xe } },
	{ "Ip<533333464446Ip<5333334644", "Fm9", NULL, 1, 3, "1", { 0x1, 0x3, 0x1, 0x1, 0x1, 0x3 } },
	{ "Gp<333344d;d<33Gp<333344d;d<", "Dm9", NULL, 8, 3, "8", { 0xa, 0x8, 0xa, 0x9, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G443333333eddG443333333eddG4", "D", NULL, 10, 2, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0xb, 0xa, 0xa } },
	{ "J&:08De:08533744787833J&:08D", "G#7-5", "Ab7-5", 4, 2, "4", { CHORD_END_OF_BARREE_LEFT | 0x4, 0x5, 0x4, 0x5, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&dgg<Jedgg<4533363<ee<<I&dg", "F#add9", "Gbadd9", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0x9, 0x9 } },
	{ "Hp:4533363:<:;:Hp:4533363:<:", "Em7", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x8, 0x7 } },
	{ "Gp533336dffdddGp533336dffddd", "Dm", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xa, 0xa, 0xa } },
	{ "H94353363:<<<<H94353363:<<<<", "E6", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9, 0x9, 0x9 } },
	{ "J&9De9445333339;9;J&9De94453", "G#6", "Ab6", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x8, 0x6, 0x8 } },
	{ "I:343334434543I:343334434543", "F7", NULL, 1, 2, "1", { 0x1, CHORD_MUTE | 0x0, 0x1, 0x2, 0x1, CHORD_MUTE | 0x0 } },
	{ "H9dgg<353333feeeffH9dgg<3533", "E6add9", NULL, 11, 2, "11", { 0xc, 0xb, 0xb, 0xb, 0xc, 0xc } },
	{ "D:vxv75333368:8:88D:vxv75333", "A7sus4", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x7, 0x5, 0x5 } },
	{ "I084333343;<dd3I084333343;<d", "F-5", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0x8, 0x9, 0xa, 0xa, CHORD_MUTE | 0x0 } },
	{ "Ddgg<433333335533Ddgg<433333", "Aadd9", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x0, 0x0 } },
	{ "J<533333686768J<533333686768", "G9", NULL, 3, 3, "3", { 0x3, 0x5, 0x3, 0x4, 0x3, 0x5 } },
	{ "Jp:533336688696Jp:5333366886", "Gm7", NULL, 3, 4, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x3, 0x6, 0x3 } },
	{ "D&p:Eep:4533363gighgD&p:Eep:", "A#m7", "Bbm7", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xd, 0xf, 0xd, 0xe, 0xd } },
	{ "G&He443333334676G&He44333333", "D#", "Eb", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x4, 0x3 } },
	{ "F&p<Gep<433334375773F&p<Gep<", "C#m9", "Dbm9", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x2, 0x4, 0x4, CHORD_MUTE | 0x0 } },
	{ "D&<Ee<5333339;9:9;D&<Ee<5333", "A#9", "Bb9", 6, 3, "6", { 0x6, 0x8, 0x6, 0x7, 0x6, 0x8 } },
	{ "I&p:Jep:343334535553I&p:Jep:", "F#m7", "Gbm7", 1, 2, "1", { 0x2, CHORD_MUTE | 0x0, 0x2, 0x2, 0x2, CHORD_MUTE | 0x0 } },
	{ "I:vxv74533363;d;e;I:vxv74533", "F7sus4", NULL, 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0xb, 0x8 } },
	{ "D&<Ee<345333939:9;D&<Ee<3453", "A#9", "Bb9", 6, 3, "6", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x7, 0x6, 0x8 } },
	{ "D&dxjEedxj333344987633D&dxjE", "A#aug", "Bbaug", 3, 4, "3", { 0x6, 0x5, 0x4, 0x3, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F&pdm:Gepdm:453336379897F&pd", "C#maj7", "Dbmaj7", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x5, 0x6, 0x4 } },
	{ "F46343356;3;<ddF46343356;3;<", "C13", NULL, 8, 3, "8", { 0x8, CHORD_MUTE | 0x0, 0x8, 0x9, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "Gpdm<44333333f<d<Gpdm<443333", "Dmaj9", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0x9, 0xa, 0x9 } },
	{ "Gp9533336dffdfdGp9533336dffd", "Dm6", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xa, 0xc, 0xa } },
	{ "Hvxv3333333::783Hvxv3333333:", "Esus", NULL, 4, 4, "4", { 0x0, 0x7, 0x7, 0x4, 0x5, 0x0 } },
	{ "Jp<533333686668Jp<5333336866", "Gm9", NULL, 3, 3, "3", { 0x3, 0x5, 0x3, 0x3, 0x3, 0x5 } },
	{ "E0844333333<dfeE0844333333<d", "B-5", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xa, 0xc, 0xb } },
	{ "Fpdm:433333365336Fpdm:433333", "Cmaj7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x0, 0x3 } },
	{ "J:333333653334J:333333653334", "G7", NULL, 1, 3, "1", { 0x3, 0x2, 0x0, 0x0, 0x0, 0x1 } },
	{ "Jp:343334636663Jp:3433346366", "Gm7", NULL, 1, 3, "1", { 0x3, CHORD_MUTE | 0x0, 0x3, 0x3, 0x3, CHORD_MUTE | 0x0 } },
	{ "Ep:533336:<<:d:Ep:533336:<<:", "Bm7", NULL, 7, 4, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x7, 0xa, 0x7 } },
	{ "G&ppdm:Heppdm:343334e3fee3G&", "D#mmaj7", "Ebmmaj7", 11, 2, "11", { 0xb, CHORD_MUTE | 0x0, 0xc, 0xb, 0xb, CHORD_MUTE | 0x0 } },
	{ "D&pEep4533363giihgD&pEep4533", "A#m", "Bbm", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xd, 0xf, 0xf, 0xe, 0xd } },
	{ "Fp9433334364543Fp94333343645", "Cm6", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x1, 0x2, 0x1, CHORD_MUTE | 0x0 } },
	{ "Fp433333364346Fp433333364346", "Cm", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x1, 0x0, 0x1, 0x3 } },
	{ "Edgg<453336357755Edgg<453336", "Badd9", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x2, 0x2 } },
	{ "Dvxv5333368:::88Dvxv5333368:", "Asus", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x7, 0x5, 0x5 } },
	{ "I<4333343;:;;3I<4333343;:;;3", "F9", NULL, 7, 2, "7", { CHORD_MUTE | 0x0, 0x8, 0x7, 0x8, 0x8, CHORD_MUTE | 0x0 } },
	{ "G&:He:443333334656G&:He:4433", "D#7", "Eb7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x2, 0x3 } },
	{ "J443333338766J443333338766J4", "G", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x4, 0x3, 0x3 } },
	{ "F<343356;3;:;;F<343356;3;:;;", "C9", NULL, 7, 2, "7", { 0x8, CHORD_MUTE | 0x0, 0x8, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8 } },
	{ "I&p9Jep9533336577575I&p9Jep9", "F#m6", "Gbm6", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x2, 0x4, 0x2 } },
	{ "Dp9433333335545Dp94333333355", "Am6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x1, 0x2 } },
	{ "D9dgg<353333877788D9dgg<3533", "A6add9", NULL, 4, 2, "4", { 0x5, 0x4, 0x4, 0x4, 0x5, 0x5 } },
	{ "G:pdm8345336dddeedG:pdm83453", "D7maj5", NULL, 10, 2, "10", { 0xa, CHORD_MUTE | 0xa, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xb, 0xb, 0xa } },
	{ "Gppdm:443333333554Gppdm:4433", "Dmmaj7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x1 } },
	{ "I&:08Je:08445333337889I&:08J", "F#7-5", "Gb7-5", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x5, 0x5, 0x6 } },
	{ "J&p9Dep94333343e<d<3J&p9Dep9", "G#m6", "Abm6", 9, 3, "9", { CHORD_MUTE | 0x0, 0xb, 0x9, 0xa, 0x9, CHORD_MUTE | 0x0 } },
	{ "J433356388766J433356388766J4", "G", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x5, 0x5, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "I&08Je08333344567633I&08Je08", "F#-5", "Gb-5", 1, 4, "1", { 0x2, 0x3, 0x4, 0x3, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D&pEep5333369;;999D&pEep5333", "A#m", "Bbm", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x6, 0x6, 0x6 } },
	{ "Ip94333343;9:93Ip94333343;9:", "Fm6", NULL, 6, 3, "6", { CHORD_MUTE | 0x0, 0x8, 0x6, 0x7, 0x6, CHORD_MUTE | 0x0 } },
	{ "G&p<Hep<433334397993G&p<Hep<", "D#m9", "Ebm9", 4, 3, "4", { CHORD_MUTE | 0x0, 0x6, 0x4, 0x6, 0x6, CHORD_MUTE | 0x0 } },
	{ "I433356366544I433356366544I4", "F", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x3, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "F&pdm<Gepdm<433334376873F&pd", "C#maj9", "Dbmaj9", 3, 3, "3", { CHORD_MUTE | 0x0, 0x4, 0x3, 0x5, 0x4, CHORD_MUTE | 0x0 } },
	{ "F&:vxv7Ge:vxv74533363797:7F&", "C#7sus4", "Db7sus4", 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x7, 0x4 } },
	{ "Gppdm:44333333fdd<Gppdm:4433", "Dmmaj7", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xc, 0xa, 0xa, 0x9 } },
	{ "I&Je4533363<eee<I&Je4533363<", "F#", "Gb", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0xb, 0x9 } },
	{ "J&dgg<Dedgg<4353363e;;<;J&dg", "G#add9", "Abadd9", 8, 4, "8", { CHORD_MUTE | 0x0, 0xb, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0x9, 0x8 } },
	{ "J&pdm:Depdm:443333339876J&pd", "G#maj7", "Abmaj7", 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x5, 0x4, 0x3 } },
	{ "Fpdm<333334;:<:;3Fpdm<333334", "Cmaj9", NULL, 7, 3, "7", { 0x8, 0x7, 0x9, 0x7, 0x8, CHORD_MUTE | 0x0 } },
	{ "F&dgg<Gedgg<44333333ed<eF&dg", "C#add9", "Dbadd9", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xa, 0x9, 0xb } },
	{ "H08343333335687H083433333356", "E-5", NULL, 2, 4, "2", { 0x0, CHORD_MUTE | 0x0, 0x2, 0x3, 0x5, 0x4 } },
	{ "D944533333:<:<D944533333:<:<", "A6", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x9, 0x7, 0x9 } },
	{ "G&9He9445333334646G&9He94453", "D#6", "Eb6", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x1, 0x3 } },
	{ "Jp:533336686666Jp:5333366866", "Gm7", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x3, 0x3, 0x3 } },
	{ "Fdgg<433333363343Fdgg<433333", "Cadd9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x0, 0x0, 0x1, 0x0 } },
	{ "F&p:Gep:453336379787F&p:Gep:", "C#m7", "Dbm7", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x5, 0x4 } },
	{ "G:343334d3ded3G:343334d3ded3", "D7", NULL, 10, 2, "10", { 0xa, CHORD_MUTE | 0x0, 0xa, 0xb, 0xa, CHORD_MUTE | 0x0 } },
	{ "Jdxj4333343d<;;3Jdxj4333343d", "Gaug", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0xa, 0x9, 0x8, 0x8, CHORD_MUTE | 0x0 } },
	{ "E:343334:3:;:3E:343334:3:;:3", "B7", NULL, 7, 2, "7", { 0x7, CHORD_MUTE | 0x0, 0x7, 0x8, 0x7, CHORD_MUTE | 0x0 } },
	{ "J46343333636533J463433336365", "G13", NULL, 1, 3, "1", { 0x3, CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x0 } },
	{ "Fglp333344;<d;33Fglp333344;<", "Cdim", NULL, 8, 3, "8", { 0x8, 0x9, 0xa, 0x8, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "E44453336355555E444533363555", "B11", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x2, 0x2, 0x2 } },
	{ "I&ppdm:Jeppdm:343334536553I&", "F#mmaj7", "Gbmmaj7", 1, 3, "1", { 0x2, CHORD_MUTE | 0x0, 0x3, 0x2, 0x2, CHORD_MUTE | 0x0 } },
	{ "H4335363:9787H4335363:9787H4", "E", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, 0x7, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x5, 0x4 } },
	{ "Ipdm<333333436343Ipdm<333333", "Fmaj9", NULL, 1, 3, "1", { 0x1, 0x0, 0x3, 0x0, 0x1, 0x0 } },
	{ "Fglp433334367873Fglp43333436", "Cdim", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x3, 0x4, 0x5, 0x4, CHORD_MUTE | 0x0 } },
	{ "D&Ee5333369;;:99D&Ee5333369;", "A#", "Bb", 6, 3, "6", { CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x7, 0x6, 0x6 } },
	{ "J084433333389;:J084433333389", "G-5", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x6, 0x8, 0x7 } },
	{ "E9dgg<353333:999::E9dgg<3533", "B6add9", NULL, 6, 2, "6", { 0x7, 0x6, 0x6, 0x6, 0x7, 0x7 } },
	{ "I&p<Jep<445336337987I&p<Jep<", "F#m9", "Gbm9", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x5, 0x4 } },
	{ "F&vxvGevxv433334377453F&vxvG", "C#sus", "Dbsus", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x4, 0x1, 0x2, CHORD_MUTE | 0x0 } },
	{ "Hp<333333353335Hp<3333333533", "Em9", NULL, 1, 2, "1", { 0x0, 0x2, 0x0, 0x0, 0x0, 0x2 } },
	{ "F4335363ihfgfF4335363ihfgfF4", "C", NULL, 12, 4, "12", { CHORD_MUTE | 0x0, 0xf, 0xe, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xd, 0xc } },
	{ "H:3533363:<:<:H:3533363:<:<:", "E7", NULL, 7, 3, "7", { 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x9, 0x7 } },
	{ "F&<Ge<343356<3<;<<F&<Ge<3433", "C#9", "Db9", 8, 2, "8", { 0x9, CHORD_MUTE | 0x0, 0x9, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9 } },
	{ "D:435333335556D:435333335556", "A7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x2, 0x3 } },
	{ "J:533336686766J:533336686766", "G7", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x4, 0x3, 0x3 } },
	{ "J&pDep4533363eggfeJ&pDep4533", "G#m", "Abm", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xd, 0xc, 0xb } },
	{ "Hp333333655333Hp333333655333", "Em", NULL, 1, 3, "1", { 0x3, 0x2, 0x2, 0x0, 0x0, 0x0 } },
	{ "Dp943333333ded3Dp943333333de", "Am6", NULL, 10, 2, "10", { CHORD_MUTE | 0x0, 0x0, 0xa, 0xb, 0xa, 0x0 } },
	{ "J&:pdm8De:pdm8345336777887J&", "G#7maj5", "Ab7maj5", 4, 2, "4", { 0x4, CHORD_MUTE | 0x4, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x5, 0x5, 0x4 } },
	{ "F&08Ge0844333333ed;<F&08Ge08", "C#-5", "Db-5", 8, 4, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xa, 0x8, 0x9 } },
	{ "F533336668886F533336668886F5", "C", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x5, 0x5, 0x5, 0x3 } },
	{ "D&p<Eep<333344979833D&p<Eep<", "A#m9", "Bbm9", 4, 3, "4", { 0x6, 0x4, 0x6, 0x5, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Gp<533333dfdddfGp<533333dfdd", "Dm9", NULL, 10, 3, "10", { 0xa, 0xc, 0xa, 0xa, 0xa, 0xc } },
	{ "Jp9445333338:89Jp9445333338:", "Gm6", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x7, 0x5, 0x6 } },
	{ "Jp533336688666Jp533336688666", "Gm", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x5, 0x3, 0x3, 0x3 } },
	{ "E<533333:<:;:<E<533333:<:;:<", "B9", NULL, 7, 3, "7", { 0x7, 0x9, 0x7, 0x8, 0x7, 0x9 } },
	{ "F&08Ge08433334378993F&08Ge08", "C#-5", "Db-5", 4, 3, "4", { CHORD_MUTE | 0x0, 0x4, 0x5, 0x6, 0x6, CHORD_MUTE | 0x0 } },
	{ "J&glpDeglp4333343efgf3J&glpD", "G#dim", "Abdim", 11, 3, "11", { CHORD_MUTE | 0x0, 0xb, 0xc, 0xd, 0xc, CHORD_MUTE | 0x0 } },
	{ "G443333333::8G443333333::8G4", "D", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x7, 0x7, 0x5 } },
	{ "F:433333365643F:433333365643", "C7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x3, 0x1, 0x0 } },
	{ "D&pdm<Eepdm<44333333;898D&pd", "A#maj9", "Bbmaj9", 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x5, 0x6, 0x5 } },
	{ "G:pdm845333338;8:9G:pdm84533", "D7maj5", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, 0x5, 0x8, 0x5, 0x7, 0x6 } },
	{ "Hdxj4333343:9883Hdxj4333343:", "Eaug", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x7, 0x6, 0x5, 0x5, CHORD_MUTE | 0x0 } },
	{ "Ddgg<43333333:933Ddgg<433333", "Aadd9", NULL, 6, 2, "6", { CHORD_MUTE | 0x0, 0x0, 0x7, 0x6, 0x0, 0x0 } },
	{ "Fdxj433333365443Fdxj43333336", "Caug", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x1, 0x1, 0x0 } },
	{ "D333333335553D333333335553D3", "A", NULL, 1, 2, "1", { 0x0, 0x0, 0x2, 0x2, 0x2, 0x0 } },
	{ "G&9dgg<He9dgg<353333edddeeG&", "D#6add9", "Eb6add9", 10, 2, "10", { 0xb, 0xa, 0xa, 0xa, 0xb, 0xb } },
	{ "Hp9333333355353Hp93333333553", "Em6", NULL, 1, 2, "1", { 0x0, 0x2, 0x2, 0x0, 0x2, 0x0 } },
	{ "Gp9433334386763Gp94333343867", "Dm6", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x5, 0x3, 0x4, 0x3, CHORD_MUTE | 0x0 } },
	{ "H:pdm83533333:d:<;H:pdm83533", "E7maj5", NULL, 7, 4, "7", { 0x0, 0x7, 0xa, 0x7, 0x9, 0x8 } },
	{ "G<433334387883G<433334387883", "D9", NULL, 4, 2, "4", { CHORD_MUTE | 0x0, 0x5, 0x4, 0x5, 0x5, CHORD_MUTE | 0x0 } },
	{ "G&p9Hep944533333gighG&p9Hep9", "D#m6", "Ebm6", 13, 3, "13", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xd, 0xf, 0xd, 0xe } },
	{ "Ddxj333344876533Ddxj33334487", "Aaug", NULL, 2, 4, "2", { 0x5, 0x4, 0x3, 0x2, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F&dgg<Gedgg<435336374474F&dg", "C#add9", "Dbadd9", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1, 0x4, 0x1 } },
	{ "H:vxv74333563:::88H:vxv74333", "E7sus4", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x7, 0x7, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "G&<He<343356e3edeeG&<He<3433", "D#9", "Eb9", 10, 2, "10", { 0xb, CHORD_MUTE | 0x0, 0xb, 0xa, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xb } },
	{ "D&<Ee<433334343443D&<Ee<4333", "A#9", "Bb9", 1, 1, "1", { CHORD_MUTE | 0x0, 0x1, 0x0, 0x1, 0x1, CHORD_MUTE | 0x0 } },
	{ "H4533363:<<<:H4533363:<<<:H4", "E", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x9, 0x7 } },
	{ "G9dgg<433356387788G9dgg<4333", "D6add9", NULL, 4, 2, "4", { CHORD_MUTE | 0x0, 0x5, 0x4, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "Dppdm:44333333:887Dppdm:4433", "Ammaj7", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x5, 0x5, 0x4 } },
	{ "J&p<Dep<4333343e<ee3J&p<Dep<", "G#m9", "Abm9", 9, 3, "9", { CHORD_MUTE | 0x0, 0xb, 0x9, 0xb, 0xb, CHORD_MUTE | 0x0 } },
	{ "F9dgg<433356365566F9dgg<4333", "C6add9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "Ippdm:343334435443Ippdm:3433", "Fmmaj7", NULL, 1, 2, "1", { 0x1, CHORD_MUTE | 0x0, 0x2, 0x1, 0x1, CHORD_MUTE | 0x0 } },
	{ "Hp:333333353366Hp:3333333533", "Em7", NULL, 1, 3, "1", { 0x0, 0x2, 0x0, 0x0, 0x3, 0x3 } },
	{ "I4335363;:898I4335363;:898I4", "F", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, 0x8, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x6, 0x5 } },
	{ "Jp<445336338:98Jp<445336338:", "Gm9", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x6, 0x5 } },
	{ "I&Je443333337655I&Je44333333", "F#", "Gb", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x3, 0x2, 0x2 } },
	{ "Ep<333344:8:933Ep<333344:8:9", "Bm9", NULL, 5, 3, "5", { 0x7, 0x5, 0x7, 0x6, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&:Je:343334535653I&:Je:3433", "F#7", "Gb7", 1, 3, "1", { 0x2, CHORD_MUTE | 0x0, 0x2, 0x3, 0x2, CHORD_MUTE | 0x0 } },
	{ "J444533363dddddJ444533363ddd", "G11", NULL, 10, 1, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa, 0xa, 0xa, 0xa } },
	{ "H44353336355565H443533363555", "E11", NULL, 1, 3, "1", { 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x2, 0x3, 0x2 } },
	{ "D944333333:9:8D944333333:9:8", "A6", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x6, 0x7, 0x5 } },
	{ "G&46He4643333339899;G&46He46", "D#13", "Eb13", 5, 4, "5", { CHORD_MUTE | 0x0, 0x6, 0x5, 0x6, 0x6, 0x8 } },
	{ "J&pDep533336799777J&pDep5333", "G#m", "Abm", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x4, 0x4, 0x4 } },
	{ "Hp:333333353333Hp:3333333533", "Em7", NULL, 1, 2, "1", { 0x0, 0x2, 0x0, 0x0, 0x0, 0x0 } },
	{ "F&Ge533336<eed<<F&Ge533336<e", "C#", "Db", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0xa, 0x9, 0x9 } },
	{ "D43333333:988D43333333:988D4", "A", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x0, 0x7, 0x6, 0x5, 0x5 } },
	{ "H46343356333455H463433563334", "E13", NULL, 1, 2, "1", { 0x0, CHORD_MUTE | 0x0, 0x0, 0x1, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2 } },
	{ "Hpdm<333333354435Hpdm<333333", "Emaj9", NULL, 1, 2, "1", { 0x0, 0x2, 0x1, 0x1, 0x0, 0x2 } },
	{ "D:433333335356D:433333335356", "A7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x2, 0x3 } },
	{ "I&pdm<Jepdm<4333343<;d<3I&pd", "F#maj9", "Gbmaj9", 8, 3, "8", { CHORD_MUTE | 0x0, 0x9, 0x8, 0xa, 0x9, CHORD_MUTE | 0x0 } },
	{ "J&44De44343356737655J&44De44", "G#11", "Ab11", 1, 4, "1", { 0x4, CHORD_MUTE | 0x0, 0x4, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2 } },
	{ "I:pdm84533333;e;d<I:pdm84533", "F7maj5", NULL, 8, 4, "8", { CHORD_MUTE | 0x0, 0x8, 0xb, 0x8, 0xa, 0x9 } },
	{ "I&pdm<Jepdm<4353363<9999I&pd", "F#maj9", "Gbmaj9", 6, 4, "6", { CHORD_MUTE | 0x0, 0x9, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6, 0x6, 0x6 } },
	{ "D&46Ee46343356939:;;D&46Ee46", "A#13", "Bb13", 6, 3, "6", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8 } },
	{ "F46433333365668F464333333656", "C13", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x3, 0x3, 0x5 } },
	{ "I9dgg<4333563;::;;I9dgg<4333", "F6add9", NULL, 7, 2, "7", { CHORD_MUTE | 0x0, 0x8, 0x7, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8 } },
	{ "H9dgg<4333563:99::H9dgg<4333", "E6add9", NULL, 6, 2, "6", { CHORD_MUTE | 0x0, 0x7, 0x6, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7 } },
	{ "Dp<333344868733Dp<3333448687", "Am9", NULL, 3, 3, "3", { 0x5, 0x3, 0x5, 0x4, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Hp94333343:8983Hp94333343:89", "Em6", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x7, 0x5, 0x6, 0x5, CHORD_MUTE | 0x0 } },
	{ "J&:vxv7De:vxv7533336797977J&", "G#7sus4", "Ab7sus4", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x6, 0x4, 0x4 } },
	{ "I&9Je94353363<eeeeI&9Je94353", "F#6", "Gb6", 9, 3, "9", { CHORD_MUTE | 0x0, 0x9, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xb, 0xb, 0xb } },
	{ "Gvxv433334388563Gvxv43333438", "Dsus", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x5, 0x5, 0x2, 0x3, CHORD_MUTE | 0x0 } },
	{ "J&pDep443333339;<:J&pDep4433", "G#m", "Abm", 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x8, 0x9, 0x7 } },
	{ "Hp<333344fdfe33Hp<333344fdfe", "Em9", NULL, 10, 3, "10", { 0xc, 0xa, 0xc, 0xb, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&9dgg<Je9dgg<4333563<;;<<I&", "F#6add9", "Gb6add9", 8, 2, "8", { CHORD_MUTE | 0x0, 0x9, 0x8, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9 } },
	{ "I&:08Je:08533744565633I&:08J", "F#7-5", "Gb7-5", 1, 3, "1", { CHORD_END_OF_BARREE_LEFT | 0x2, 0x3, 0x2, 0x3, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Ep533336:<<:::Ep533336:<<:::", "Bm", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0x7, 0x7, 0x7 } },
	{ "Fp944533333dfdeFp944533333df", "Cm6", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0xc, 0xa, 0xb } },
	{ "H443333335787H443333335787H4", "E", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x5, 0x4 } },
	{ "D<5333338:898:D<5333338:898:", "A9", NULL, 5, 3, "5", { 0x5, 0x7, 0x5, 0x6, 0x5, 0x7 } },
	{ "E:08433334356573E:0843333435", "B7-5", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x2, 0x3, 0x2, 0x4, CHORD_MUTE | 0x0 } },
	{ "I&44Je444533363<<<<<I&44Je44", "F#11", "Gb11", 9, 1, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9, 0x9, 0x9, 0x9 } },
	{ "G<343356d3d<ddG<343356d3d<dd", "D9", NULL, 9, 2, "9", { 0xa, CHORD_MUTE | 0x0, 0xa, 0x9, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "D533336ffhhhfD533336ffhhhfD5", "A", NULL, 12, 3, "12", { CHORD_END_OF_BARREE_RIGHT | 0xc, 0xc, 0xe, 0xe, 0xe, 0xc } },
	{ "J&:De:343334737873J&:De:3433", "G#7", "Ab7", 4, 2, "4", { 0x4, CHORD_MUTE | 0x0, 0x4, 0x5, 0x4, CHORD_MUTE | 0x0 } },
	{ "J:vxv7533336686866J:vxv75333", "G7sus4", NULL, 3, 3, "3", { CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x5, 0x3, 0x3 } },
	{ "J&:De:533336797877J&:De:5333", "G#7", "Ab7", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x5, 0x4, 0x4 } },
	{ "Jdgg<443333338768Jdgg<443333", "Gadd9", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x4, 0x3, 0x5 } },
	{ "Ep:453336357565Ep:4533363575", "Bm7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x3, 0x2 } },
	{ "F&9Ge944533333egegF&9Ge94453", "C#6", "Db6", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xd, 0xb, 0xd } },
	{ "Epdm:44333333<;:9Epdm:443333", "Bmaj7", NULL, 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x8, 0x7, 0x6 } },
	{ "G&<He<433334398993G&<He<4333", "D#9", "Eb9", 5, 2, "5", { CHORD_MUTE | 0x0, 0x6, 0x5, 0x6, 0x6, CHORD_MUTE | 0x0 } },
	{ "Ep:533336:<::::Ep:533336:<::", "Bm7", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x7, 0x7, 0x7 } },
	{ "F533336;dd<;;F533336;dd<;;F5", "C", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0x9, 0x8, 0x8 } },
	{ "G&46He46343356e3ed;;G&46He46", "D#13", "Eb13", 8, 4, "8", { 0xb, CHORD_MUTE | 0x0, 0xb, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8 } },
	{ "G&p:Hep:533336egeeheG&p:Hep:", "D#m7", "Ebm7", 11, 4, "11", { CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xb, 0xb, 0xe, 0xb } },
	{ "J&44De44533333797979J&44De44", "G#11", "Ab11", 4, 3, "4", { 0x4, 0x6, 0x4, 0x6, 0x4, 0x6 } },
	{ "Hp<353336355765Hp<3533363557", "Em9", NULL, 1, 4, "1", { 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x4, 0x3, 0x2 } },
	{ "I533336;;ddd;I533336;;ddd;I5", "F", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0xa, 0xa, 0xa, 0x8 } },
	{ "D&ppdm:Eeppdm:34333493:993D&", "A#mmaj7", "Bbmmaj7", 6, 2, "6", { 0x6, CHORD_MUTE | 0x0, 0x7, 0x6, 0x6, CHORD_MUTE | 0x0 } },
	{ "Jp4533363dffedJp4533363dffed", "Gm", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xb, 0xa } },
	{ "J&<De<533333797879J&<De<5333", "G#9", "Ab9", 4, 3, "4", { 0x4, 0x6, 0x4, 0x5, 0x4, 0x6 } },
	{ "Jdxj333334654343Jdxj33333465", "Gaug", NULL, 1, 3, "1", { 0x3, 0x2, 0x1, 0x0, 0x1, CHORD_MUTE | 0x0 } },
	{ "J&p:Dep:343334737773J&p:Dep:", "G#m7", "Abm7", 1, 4, "1", { 0x4, CHORD_MUTE | 0x0, 0x4, 0x4, 0x4, CHORD_MUTE | 0x0 } },
	{ "H9533336::<<<<H9533336::<<<<", "E6", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x9, 0x9, 0x9, 0x9 } },
	{ "Dpdm:433333335453Dpdm:433333", "Amaj7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x2, 0x0 } },
	{ "F&:08Ge:08433334378793F&:08G", "C#7-5", "Db7-5", 4, 3, "4", { CHORD_MUTE | 0x0, 0x4, 0x5, 0x4, 0x6, CHORD_MUTE | 0x0 } },
	{ "J533336ddfffdJ533336ddfffdJ5", "G", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa, 0xc, 0xc, 0xc, 0xa } },
	{ "F&ppdm:Geppdm:343334<3d<<3F&", "C#mmaj7", "Dbmmaj7", 9, 2, "9", { 0x9, CHORD_MUTE | 0x0, 0xa, 0x9, 0x9, CHORD_MUTE | 0x0 } },
	{ "D<43333333898:D<43333333898:", "A9", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x0, 0x5, 0x6, 0x5, 0x7 } },
	{ "D&46Ee46343356939866D&46Ee46", "A#13", "Bb13", 3, 4, "3", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3 } },
	{ "Gp:443333333544Gp:4433333335", "Dm7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x1, 0x1 } },
	{ "D:pdm8433333336354D:pdm84333", "A7maj5", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x3, 0x0, 0x2, 0x1 } },
	{ "J&dgg<Dedgg<4533363eghgeJ&dg", "G#add9", "Abadd9", 11, 4, "11", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xe, 0xd, 0xb } },
	{ "Fpdm<433334365763Fpdm<433334", "Cmaj9", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x4, 0x3, CHORD_MUTE | 0x0 } },
	{ "Edxj333344:98733Edxj333344:9", "Baug", NULL, 4, 4, "4", { 0x7, 0x6, 0x5, 0x4, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D&ppdm:Eeppdm:453336346554D&", "A#mmaj7", "Bbmmaj7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x2, 0x2, 0x1 } },
	{ "H9445333335757H9445333335757", "E6", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x4, 0x2, 0x4 } },
	{ "I&vxvJevxv533336577755I&vxvJ", "F#sus", "Gbsus", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x4, 0x2, 0x2 } },
	{ "D08433334334553D084333343345", "A-5", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x0, 0x1, 0x2, 0x2, CHORD_MUTE | 0x0 } },
	{ "Jp94333343d;<;3Jp94333343d;<", "Gm6", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0xa, 0x8, 0x9, 0x8, CHORD_MUTE | 0x0 } },
	{ "I&Je533336577655I&Je53333657", "F#", "Gb", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x4, 0x3, 0x2, 0x2 } },
	{ "G&:pdm8He:pdm845333339<9;:G&", "D#7maj5", "Eb7maj5", 6, 4, "6", { CHORD_MUTE | 0x0, 0x6, 0x9, 0x6, 0x8, 0x7 } },
	{ "F:0844533333deefF:0844533333", "C7-5", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0xb, 0xb, 0xc } },
	{ "G433333333565G433333333565G4", "D", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x0, 0x2, 0x3, 0x2 } },
	{ "D0843333333:978D0843333333:9", "A-5", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, 0x0, 0x7, 0x6, 0x4, 0x5 } },
	{ "Ep44333333<efdEp44333333<efd", "Bm", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xb, 0xc, 0xa } },
	{ "H<4333343:9::3H<4333343:9::3", "E9", NULL, 6, 2, "6", { CHORD_MUTE | 0x0, 0x7, 0x6, 0x7, 0x7, CHORD_MUTE | 0x0 } },
	{ "F&46Ge46433333376779F&46Ge46", "C#13", "Db13", 3, 4, "3", { CHORD_MUTE | 0x0, 0x4, 0x3, 0x4, 0x4, 0x6 } },
	{ "J&dxjDedxj443333339887J&dxjD", "G#aug", "Abaug", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x5, 0x5, 0x4 } },
	{ "E44333333<;::E44333333<;::E4", "B", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x8, 0x7, 0x7 } },
	{ "Fdgg<433333365363Fdgg<433333", "Cadd9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x2, 0x0, 0x3, 0x0 } },
	{ "Gdgg<45333638::88Gdgg<453336", "Dadd9", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x5, 0x5 } },
	{ "E944533333<e<eE944533333<e<e", "B6", NULL, 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xb, 0x9, 0xb } },
	{ "D&44Ee44343356939877D&44Ee44", "A#11", "Bb11", 4, 3, "4", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "Dglp33334489:833Dglp33334489", "Adim", NULL, 5, 3, "5", { 0x5, 0x6, 0x7, 0x5, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G&He433536398676G&He43353639", "D#", "Eb", 3, 4, "3", { CHORD_MUTE | 0x0, 0x6, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x4, 0x3 } },
	{ "Ip:533336466474Ip:5333364664", "Fm7", NULL, 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x1, 0x4, 0x1 } },
	{ "Epdm<333334:9;9:3Epdm<333334", "Bmaj9", NULL, 6, 3, "6", { 0x7, 0x6, 0x8, 0x6, 0x7, CHORD_MUTE | 0x0 } },
	{ "J&p<Dep<333344757633J&p<Dep<", "G#m9", "Abm9", 1, 4, "1", { 0x4, 0x2, 0x4, 0x3, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "I&9Je9445333337979I&9Je94453", "F#6", "Gb6", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x6, 0x4, 0x6 } },
	{ "Gp45333638::98Gp45333638::98", "Dm", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x7, 0x6, 0x5 } },
	{ "Jpdm:333333653335Jpdm:333333", "Gmaj7", NULL, 1, 3, "1", { 0x3, 0x2, 0x0, 0x0, 0x0, 0x2 } },
	{ "Ippdm:343334g3hgg3Ippdm:3433", "Fmmaj7", NULL, 13, 2, "13", { 0xd, CHORD_MUTE | 0x0, 0xe, 0xd, 0xd, CHORD_MUTE | 0x0 } },
	{ "J&ppdm:Deppdm:343334738773J&", "G#mmaj7", "Abmmaj7", 4, 2, "4", { 0x4, CHORD_MUTE | 0x0, 0x5, 0x4, 0x4, CHORD_MUTE | 0x0 } },
	{ "G&:08He:08533744efef33G&:08H", "D#7-5", "Eb7-5", 11, 2, "11", { CHORD_END_OF_BARREE_LEFT | 0xb, 0xc, 0xb, 0xc, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F08333344;<d<33F08333344;<d<", "C-5", NULL, 8, 3, "8", { 0x8, 0x9, 0xa, 0x9, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G&44He44343356e3ed<<G&44He44", "D#11", "Eb11", 9, 3, "9", { 0xb, CHORD_MUTE | 0x0, 0xb, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9 } },
	{ "Fpdm:44333333d<;:Fpdm:443333", "Cmaj7", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0x9, 0x8, 0x7 } },
	{ "F:vxv7533336;d;d;;F:vxv75333", "C7sus4", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0xa, 0x8, 0x8 } },
	{ "F:453336368686F:453336368686", "C7", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x5, 0x3 } },
	{ "Dp433536335888Dp433536335888", "Am", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x0, 0x2, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x5 } },
	{ "I&vxvJevxv4333343<<9:3I&vxvJ", "F#sus", "Gbsus", 6, 4, "6", { CHORD_MUTE | 0x0, 0x9, 0x9, 0x6, 0x7, CHORD_MUTE | 0x0 } },
	{ "I&dxjJedxj443333337665I&dxjJ", "F#aug", "Gbaug", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x3, 0x3, 0x2 } },
	{ "D&Ee453336346664D&Ee45333634", "A#", "Bb", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x3, 0x1 } },
	{ "Ip:4533363;d;<;Ip:4533363;d;", "Fm7", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0x9, 0x8 } },
	{ "J333333653366J333333653366J3", "G", NULL, 1, 3, "1", { 0x3, 0x2, 0x0, 0x0, 0x3, 0x3 } },
	{ "D&08Ee0844333333;:89D&08Ee08", "A#-5", "Bb-5", 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x7, 0x5, 0x6 } },
	{ "J:vxv74333563ddd;;J:vxv74333", "G7sus4", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0xa, 0xa, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8 } },
	{ "D&vxvEevxv453336346674D&vxvE", "A#sus", "Bbsus", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x4, 0x1 } },
	{ "F933333333d<d;F933333333d<d;", "C6", NULL, 8, 3, "8", { 0x0, 0x0, 0xa, 0x9, 0xa, 0x8 } },
	{ "G43333333:::8G43333333:::8G4", "D", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x0, 0x7, 0x7, 0x7, 0x5 } },
	{ "I433333336544I433333336544I4", "F", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x3, 0x2, 0x1, 0x1 } },
	{ "E44533333:<:<:<E44533333:<:<", "B11", NULL, 7, 3, "7", { 0x7, 0x9, 0x7, 0x9, 0x7, 0x9 } },
	{ "I&ppdm:Jeppdm:343334h3ihh3I&", "F#mmaj7", "Gbmmaj7", 14, 2, "14", { 0xe, CHORD_MUTE | 0x0, 0xf, 0xe, 0xe, CHORD_MUTE | 0x0 } },
	{ "Ipdm<443333336343Ipdm<443333", "Fmaj9", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x0, 0x1, 0x0 } },
	{ "F:533336;d;<;;F:533336;d;<;;", "C7", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0x9, 0x8, 0x8 } },
	{ "F&9Ge933333333ede<F&9Ge93333", "C#6", "Db6", 9, 3, "9", { 0x0, 0x0, 0xb, 0xa, 0xb, 0x9 } },
	{ "Fvxv433356366344Fvxv43335636", "Csus", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x3, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "Gvxv533336dfffddGvxv533336df", "Dsus", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xc, 0xa, 0xa } },
	{ "G&dxjHedxj433334398773G&dxjH", "D#aug", "Ebaug", 4, 3, "4", { CHORD_MUTE | 0x0, 0x6, 0x5, 0x4, 0x4, CHORD_MUTE | 0x0 } },
	{ "Eglp433334356763Eglp43333435", "Bdim", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x2, 0x3, 0x4, 0x3, CHORD_MUTE | 0x0 } },
	{ "Gp:533336dfddddGp:533336dfdd", "Dm7", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xa, 0xa, 0xa, 0xa } },
	{ "Hpdm<4333343:9;:3Hpdm<433334", "Emaj9", NULL, 6, 3, "6", { CHORD_MUTE | 0x0, 0x7, 0x6, 0x8, 0x7, CHORD_MUTE | 0x0 } },
	{ "I444533363;;;;;I444533363;;;", "F11", NULL, 8, 1, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0x8, 0x8, 0x8 } },
	{ "D&:vxv7Ee:vxv7453336346474D&", "A#7sus4", "Bb7sus4", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x4, 0x1 } },
	{ "D&ppdm:Eeppdm:44333333;998D&", "A#mmaj7", "Bbmmaj7", 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0x6, 0x6, 0x5 } },
	{ "G:vxv745333638:8;8G:vxv74533", "D7sus4", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x8, 0x5 } },
	{ "J&08De08443333339:<;J&08De08", "G#-5", "Ab-5", 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x7, 0x9, 0x8 } },
	{ "I5333368;:898I5333368;:898I5", "F", NULL, 5, 4, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x8, 0x7, 0x5, 0x6, 0x5 } },
	{ "H333333355433H333333355433H3", "E", NULL, 1, 2, "1", { 0x0, 0x2, 0x2, 0x1, 0x0, 0x0 } },
	{ "Gdgg<435336385585Gdgg<435336", "Dadd9", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x5, 0x2 } },
	{ "J&p:Dep:5333367997:7J&p:Dep:", "G#m7", "Abm7", 4, 4, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x4, 0x7, 0x4 } },
	{ "F&44Ge44434333373775F&44Ge44", "C#11", "Db11", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, CHORD_MUTE | 0x0, 0x4, 0x4, 0x2 } },
	{ "E9dgg<433356354455E9dgg<4333", "B6add9", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x1, 0x1, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2 } },
	{ "I:vxv7533336gigiggI:vxv75333", "F7sus4", NULL, 13, 3, "13", { CHORD_END_OF_BARREE_RIGHT | 0xd, 0xf, 0xd, 0xf, 0xd, 0xd } },
	{ "Eppdm:44333333<::9Eppdm:4433", "Bmmaj7", NULL, 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x7, 0x7, 0x6 } },
	{ "J&9dgg<De9dgg<353333766677J&", "G#6add9", "Ab6add9", 1, 4, "1", { 0x4, 0x3, 0x3, 0x3, 0x4, 0x4 } },
	{ "H:08445333335667H:0844533333", "E7-5", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x2, 0x3, 0x3, 0x4 } },
	{ "Dp<43533333888:Dp<4353333388", "Am9", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x0, 0x5, 0x5, 0x5, 0x7 } },
	{ "Fpdm:453336368786Fpdm:453336", "Cmaj7", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x4, 0x5, 0x3 } },
	{ "E0844333333<;9:E0844333333<;", "B-5", NULL, 6, 4, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x8, 0x6, 0x7 } },
	{ "D445333338:8:8:D445333338:8:", "A11", NULL, 5, 3, "5", { 0x5, 0x7, 0x5, 0x7, 0x5, 0x7 } },
	{ "D&glpEeglp3333449:;933D&glpE", "A#dim", "Bbdim", 6, 3, "6", { 0x6, 0x7, 0x8, 0x6, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F&p:Gep:533336<e<<f<F&p:Gep:", "C#m7", "Dbm7", 9, 4, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0x9, 0xc, 0x9 } },
	{ "J&:vxv7De:vxv74333563eee<<J&", "G#7sus4", "Ab7sus4", 9, 3, "9", { CHORD_MUTE | 0x0, 0xb, 0xb, 0xb, CHORD_END_OF_BARREE_RIGHT | 0x9, 0x9 } },
	{ "Jpdm<443333338565Jpdm<443333", "Gmaj9", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x2, 0x3, 0x2 } },
	{ "J&46De46343356737644J&46De46", "G#13", "Ab13", 1, 4, "1", { 0x4, CHORD_MUTE | 0x0, 0x4, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "D&9dgg<Ee9dgg<353333988899D&", "A#6add9", "Bb6add9", 5, 2, "5", { 0x6, 0x5, 0x5, 0x5, 0x6, 0x6 } },
	{ "J&9De9443333339897J&9De94433", "G#6", "Ab6", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x5, 0x6, 0x4 } },
	{ "I9445333336868I9445333336868", "F6", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x5, 0x3, 0x5 } },
	{ "G533336dffeddG533336dffeddG5", "D", NULL, 10, 3, "10", { CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xc, 0xb, 0xa, 0xa } },
	{ "Jp:4533363dfdedJp:4533363dfd", "Gm7", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xa, 0xb, 0xa } },
	{ "J&dgg<Dedgg<443333339879J&dg", "G#add9", "Abadd9", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x5, 0x4, 0x6 } },
	{ "D&9Ee944533333;d;dD&9Ee94453", "A#6", "Bb6", 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0xa, 0x8, 0xa } },
	{ "H:08333344343433H:0833334434", "E7-5", NULL, 1, 1, "1", { 0x0, 0x1, 0x0, 0x1, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "G&dgg<Hedgg<45333639;d;9G&dg", "D#add9", "Ebadd9", 6, 5, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0xa, 0x8, 0x6 } },
	{ "Hdxj333344fed<33Hdxj333344fe", "Eaug", NULL, 9, 4, "9", { 0xc, 0xb, 0xa, 0x9, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "D44433333333333D444333333333", "A11", NULL, 1, 0, "1", { CHORD_MUTE | 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 } },
	{ "F&p9Gep944533333egefF&p9Gep9", "C#m6", "Dbm6", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xb, 0xd, 0xb, 0xc } },
	{ "D&pdm:Eepdm:44333333;dddD&pd", "A#maj7", "Bbmaj7", 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0xa, 0xa, 0xa } },
	{ "G&vxvHevxv433334399673G&vxvH", "D#sus", "Ebsus", 3, 4, "3", { CHORD_MUTE | 0x0, 0x6, 0x6, 0x3, 0x4, CHORD_MUTE | 0x0 } },
	{ "D&:08Ee:08433334345463D&:08E", "A#7-5", "Bb7-5", 1, 3, "1", { CHORD_MUTE | 0x0, 0x1, 0x2, 0x1, 0x3, CHORD_MUTE | 0x0 } },
	{ "D:pdm84533333fifhgD:pdm84533", "A7maj5", NULL, 12, 4, "12", { CHORD_MUTE | 0x0, 0xc, 0xf, 0xc, 0xe, 0xd } },
	{ "I&:vxv7Je:vxv7533336575755I&", "F#7sus4", "Gb7sus4", 1, 4, "1", { CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x4, 0x2, 0x2 } },
	{ "F&44Ge44343356<3<;::F&44Ge44", "C#11", "Db11", 7, 3, "7", { 0x9, CHORD_MUTE | 0x0, 0x9, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7 } },
	{ "Ip533336;;dd<;Ip533336;;dd<;", "Fm", NULL, 8, 3, "8", { CHORD_END_OF_BARREE_RIGHT | 0x8, 0x8, 0xa, 0xa, 0x9, 0x8 } },
	{ "Jdgg<333333653338Jdgg<333333", "Gadd9", NULL, 2, 4, "2", { 0x3, 0x2, 0x0, 0x0, 0x0, 0x5 } },
	{ "Ip<445336336876Ip<4453363368", "Fm9", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x4, 0x3 } },
	{ "J464333333d<ddfJ464333333d<d", "G13", NULL, 9, 4, "9", { CHORD_MUTE | 0x0, 0xa, 0x9, 0xa, 0xa, 0xc } },
	{ "J&De443333339877J&De44333333", "G#", "Ab", 4, 3, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x6, 0x5, 0x4, 0x4 } },
	{ "D:vxv7433333335566D:vxv74333", "A7sus4", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x2, 0x3, 0x3 } },
	{ "I:08533744454533I:0853374445", "F7-5", NULL, 1, 2, "1", { CHORD_END_OF_BARREE_LEFT | 0x1, 0x2, 0x1, 0x2, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "H:333333355463H:333333355463", "E7", NULL, 1, 3, "1", { 0x0, 0x2, 0x2, 0x1, 0x3, 0x0 } },
	{ "Hp<4333343:8::3Hp<4333343:8:", "Em9", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x7, 0x5, 0x7, 0x7, CHORD_MUTE | 0x0 } },
	{ "G:084333343898:3G:0843333438", "D7-5", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, 0x5, 0x6, 0x5, 0x7, CHORD_MUTE | 0x0 } },
	{ "Fpdm<44333333d:;:Fpdm<443333", "Cmaj9", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xa, 0x7, 0x8, 0x7 } },
	{ "Ddxj433333336554Ddxj43333333", "Aaug", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x3, 0x2, 0x2, 0x1 } },
	{ "Ep9433334353433Ep94333343534", "Bm6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x0, 0x1, 0x0, CHORD_MUTE | 0x0 } },
	{ "Eppdm:453336357665Eppdm:4533", "Bmmaj7", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x3, 0x3, 0x2 } },
	{ "D<433356338788D<433356338788", "A9", NULL, 4, 2, "4", { CHORD_MUTE | 0x0, 0x0, 0x5, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "D&p9Eep944533333;d;<D&p9Eep9", "A#m6", "Bbm6", 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x8, 0xa, 0x8, 0x9 } },
	{ "D:343334838983D:343334838983", "A7", NULL, 5, 2, "5", { 0x5, CHORD_MUTE | 0x0, 0x5, 0x6, 0x5, CHORD_MUTE | 0x0 } },
	{ "Idgg<4533363;dfd;Idgg<453336", "Fadd9", NULL, 8, 5, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xc, 0xa, 0x8 } },
	{ "F:08533744;<;<33F:08533744;<", "C7-5", NULL, 8, 2, "8", { CHORD_END_OF_BARREE_LEFT | 0x8, 0x9, 0x8, 0x9, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Ip:343334434443Ip:3433344344", "Fm7", NULL, 1, 1, "1", { 0x1, CHORD_MUTE | 0x0, 0x1, 0x1, 0x1, CHORD_MUTE | 0x0 } },
	{ "D<435333335756D<435333335756", "A9", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x4, 0x2, 0x3 } },
	{ "Hpdm<44333333hefeHpdm<443333", "Emaj9", NULL, 11, 4, "11", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0xe, 0xb, 0xc, 0xb } },
	{ "Gdxj333344d<;:33Gdxj333344d<", "Daug", NULL, 7, 4, "7", { 0xa, 0x9, 0x8, 0x7, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Hp443333333333Hp443333333333", "Em", NULL, 1, 0, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x0, 0x0, 0x0 } },
	{ "Dpdm:44333333:987Dpdm:443333", "Amaj7", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x6, 0x5, 0x4 } },
	{ "Ipdm<4353363;8888Ipdm<435336", "Fmaj9", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x5, 0x5 } },
	{ "Dp33335633:888Dp33335633:888", "Am", NULL, 5, 3, "5", { 0x0, 0x0, 0x7, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "I&9dgg<Je9dgg<353333544455I&", "F#6add9", "Gb6add9", 1, 2, "1", { 0x2, 0x1, 0x1, 0x1, 0x2, 0x2 } },
	{ "I:533336464544I:533336464544", "F7", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x2, 0x1, 0x1 } },
	{ "Idgg<4353363;8898Idgg<435336", "Fadd9", NULL, 5, 4, "5", { CHORD_MUTE | 0x0, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5, 0x6, 0x5 } },
	{ "Ip4533363;dd<;Ip4533363;dd<;", "Fm", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0xa, 0x9, 0x8 } },
	{ "G&:vxv7He:vxv7433356399977G&", "D#7sus4", "Eb7sus4", 4, 3, "4", { CHORD_MUTE | 0x0, 0x6, 0x6, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4 } },
	{ "I94353363;ddddI94353363;dddd", "F6", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0x8, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa, 0xa, 0xa } },
	{ "Dp<4333343fdff3Dp<4333343fdf", "Am9", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xc, 0xa, 0xc, 0xc, CHORD_MUTE | 0x0 } },
	{ "F:pdm8345336;;;<<;F:pdm83453", "C7maj5", NULL, 8, 2, "8", { 0x8, CHORD_MUTE | 0x8, CHORD_END_OF_BARREE_RIGHT | 0x8, 0x9, 0x9, 0x8 } },
	{ "Edxj44333333<;;:Edxj44333333", "Baug", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0x8, 0x8, 0x7 } },
	{ "F<533333;d;<;dF<533333;d;<;d", "C9", NULL, 8, 3, "8", { 0x8, 0xa, 0x8, 0x9, 0x8, 0xa } },
	{ "Dp:5333368:8888Dp:5333368:88", "Am7", NULL, 5, 3, "5", { CHORD_END_OF_BARREE_RIGHT | 0x5, 0x7, 0x5, 0x5, 0x5, 0x5 } },
	{ "I<343356434344I<343356434344", "F9", NULL, 1, 1, "1", { 0x1, CHORD_MUTE | 0x0, 0x1, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "Ep<433334353553Ep<4333343535", "Bm9", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, 0x2, 0x0, 0x2, 0x2, CHORD_MUTE | 0x0 } },
	{ "J&p<Dep<445336339;:9J&p<Dep<", "G#m9", "Abm9", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x7, 0x6 } },
	{ "H08333344345433H083333443454", "E-5", NULL, 1, 2, "1", { 0x0, 0x1, 0x2, 0x1, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Ip533336466444Ip533336466444", "Fm", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x1, 0x1, 0x1 } },
	{ "F&p:Gep:533336<e<<<<F&p:Gep:", "C#m7", "Dbm7", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0x9, 0x9, 0x9 } },
	{ "Dp44333333:<d;Dp44333333:<d;", "Am", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x7, 0x9, 0xa, 0x8 } },
	{ "I&pdm:Jepdm:443333337654I&pd", "F#maj7", "Gbmaj7", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x3, 0x2, 0x1 } },
	{ "J08443333338756J084433333387", "G-5", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x4, 0x2, 0x3 } },
	{ "E:vxv7533336:<:<::E:vxv75333", "B7sus4", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x7, 0x9, 0x7, 0x7 } },
	{ "I:vxv7533336464644I:vxv75333", "F7sus4", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x1, 0x3, 0x1, 0x1 } },
	{ "Hp533336::<<;:Hp533336::<<;:", "Em", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x9, 0x9, 0x8, 0x7 } },
	{ "Ep<44533633<ed<Ep<44533633<e", "Bm9", NULL, 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xa, 0x9 } },
	{ "Jdxj443333338776Jdxj44333333", "Gaug", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x4, 0x4, 0x3 } },
	{ "F44453336366666F444533363666", "C11", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x3, 0x3, 0x3, 0x3 } },
	{ "Gdxj433334387663Gdxj43333438", "Daug", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x5, 0x4, 0x3, 0x3, CHORD_MUTE | 0x0 } },
	{ "Ipdm<333334435343Ipdm<333334", "Fmaj9", NULL, 1, 2, "1", { 0x1, 0x0, 0x2, 0x0, 0x1, CHORD_MUTE | 0x0 } },
	{ "D463433568389::D463433568389", "A13", NULL, 5, 3, "5", { 0x5, CHORD_MUTE | 0x0, 0x5, 0x6, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7 } },
	{ "I<533333464546I<533333464546", "F9", NULL, 1, 3, "1", { 0x1, 0x3, 0x1, 0x2, 0x1, 0x3 } },
	{ "Ivxv443356336644Ivxv44335633", "Fsus", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "Gpdm:443536333555Gpdm:443536", "Dmaj7", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x2, 0x2 } },
	{ "I&Je4335363<;9:9I&Je4335363<", "F#", "Gb", 6, 4, "6", { CHORD_MUTE | 0x0, 0x9, 0x8, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x7, 0x6 } },
	{ "I9443333336564I9443333336564", "F6", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x2, 0x3, 0x1 } },
	{ "F&pGep533336779987F&pGep5333", "C#m", "Dbm", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x4, 0x6, 0x6, 0x5, 0x4 } },
	{ "Hvxv333333355533Hvxv33333335", "Esus", NULL, 1, 2, "1", { 0x0, 0x2, 0x2, 0x2, 0x0, 0x0 } },
	{ "J533336:d<:;:J533336:d<:;:J5", "G", NULL, 7, 4, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0xa, 0x9, 0x7, 0x8, 0x7 } },
	{ "I&:Je:4533363<e<e<I&:Je:4533", "F#7", "Gb7", 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0xb, 0x9 } },
	{ "F333333365343F333333365343F3", "C", NULL, 1, 3, "1", { 0x0, 0x3, 0x2, 0x0, 0x1, 0x0 } },
	{ "J:08533744676733J:0853374467", "G7-5", NULL, 1, 4, "1", { CHORD_END_OF_BARREE_LEFT | 0x3, 0x4, 0x3, 0x4, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "E:vxv7453336357585E:vxv74533", "B7sus4", NULL, 2, 4, "2", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x2, 0x4, 0x2, 0x5, 0x2 } },
	{ "Hglp4333343:;<;3Hglp4333343:", "Edim", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, 0x7, 0x8, 0x9, 0x8, CHORD_MUTE | 0x0 } },
	{ "J&De533336799877J&De53333679", "G#", "Ab", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x6, 0x5, 0x4, 0x4 } },
	{ "G&He45333639;;;9G&He45333639", "D#", "Eb", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x8, 0x6 } },
	{ "G08443333333465G084433333334", "D-5", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x1, 0x3, 0x2 } },
	{ "F:vxv7433356366644F:vxv74333", "C7sus4", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x3, 0x3, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x1 } },
	{ "J:0844533333899:J:0844533333", "G7-5", NULL, 5, 3, "5", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x5, 0x6, 0x6, 0x7 } },
	{ "Eglp333344:;<:33Eglp333344:;", "Bdim", NULL, 7, 3, "7", { 0x7, 0x8, 0x9, 0x7, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "Hvxv4533363:<<d:Hvxv4533363:", "Esus", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x9, 0xa, 0x7 } },
	{ "I:4533363;d;d;I:4533363;d;d;", "F7", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x8, 0xa, 0x8, 0xa, 0x8 } },
	{ "Jp<4333343d;dd3Jp<4333343d;d", "Gm9", NULL, 8, 3, "8", { CHORD_MUTE | 0x0, 0xa, 0x8, 0xa, 0xa, CHORD_MUTE | 0x0 } },
	{ "G4333563ffeddG4333563ffeddG4", "D", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, 0xc, 0xc, 0xb, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xa } },
	{ "Dp<44533633:<;:Dp<44533633:<", "Am9", NULL, 7, 3, "7", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x9, 0x8, 0x7 } },
	{ "I&p<Jep<4333343<:<<3I&p<Jep<", "F#m9", "Gbm9", 7, 3, "7", { CHORD_MUTE | 0x0, 0x9, 0x7, 0x9, 0x9, CHORD_MUTE | 0x0 } },
	{ "Ipdm:443333336543Ipdm:443333", "Fmaj7", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x3, 0x2, 0x1, 0x0 } },
	{ "F&p9Gep9533336<ee<e<F&p9Gep9", "C#m6", "Dbm6", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0x9, 0xb, 0x9 } },
	{ "G&08He08443333334576G&08He08", "D#-5", "Eb-5", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x2, 0x4, 0x3 } },
	{ "Dp333333335543Dp333333335543", "Am", NULL, 1, 2, "1", { 0x0, 0x0, 0x2, 0x2, 0x1, 0x0 } },
	{ "F&dxjGedxj333344<;:933F&dxjG", "C#aug", "Dbaug", 6, 4, "6", { 0x9, 0x8, 0x7, 0x6, CHORD_MUTE | 0x0, CHORD_MUTE | 0x0 } },
	{ "F&Ge433536376454F&Ge43353637", "C#", "Db", 1, 4, "1", { CHORD_MUTE | 0x0, 0x4, 0x3, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x2, 0x1 } },
	{ "Epdm:44333333<eeeEpdm:443333", "Bmaj7", NULL, 9, 3, "9", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x9, 0xb, 0xb, 0xb } },
	{ "I&pJep4433333379:8I&pJep4433", "F#m", "Gbm", 4, 4, "4", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x6, 0x7, 0x5 } },
	{ "J9dgg<353333655566J9dgg<3533", "G6add9", NULL, 1, 3, "1", { 0x3, 0x2, 0x2, 0x2, 0x3, 0x3 } },
	{ "F&:Ge:533336<e<d<<F&:Ge:5333", "C#7", "Db7", 9, 3, "9", { CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0x9, 0xa, 0x9, 0x9 } },
	{ "J&p:Dep:5333367977:7J&p:Dep:", "G#m7", "Abm7", 4, 4, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x4, 0x7, 0x4 } },
	{ "I&vxvJevxv4533363<eef<I&vxvJ", "F#sus", "Gbsus", 9, 4, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xb, 0xc, 0x9 } },
	{ "Gp9443333333534Gp94433333335", "Dm6", NULL, 1, 2, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x1 } },
	{ "D&pdm<Eepdm<433333343544D&pd", "A#maj9", "Bbmaj9", 1, 2, "1", { CHORD_MUTE | 0x0, 0x1, 0x0, 0x2, 0x1, 0x1 } },
	{ "D&pEep453336346654D&pEep4533", "A#m", "Bbm", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x2, 0x1 } },
	{ "J&9dgg<De9dgg<4333563eddeeJ&", "G#6add9", "Ab6add9", 10, 2, "10", { CHORD_MUTE | 0x0, 0xb, 0xa, 0xa, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xb } },
	{ "Gvxv443333333566Gvxv44333333", "Dsus", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x0, 0x2, 0x3, 0x3 } },
	{ "E08433334356773E084333343567", "B-5", NULL, 1, 4, "1", { CHORD_MUTE | 0x0, 0x2, 0x3, 0x4, 0x4, CHORD_MUTE | 0x0 } },
	{ "D444533363fffffD444533363fff", "A11", NULL, 12, 1, "12", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xc, 0xc, 0xc, 0xc } },
	{ "Gpdm<433334387983Gpdm<433334", "Dmaj9", NULL, 4, 3, "4", { CHORD_MUTE | 0x0, 0x5, 0x4, 0x6, 0x5, CHORD_MUTE | 0x0 } },
	{ "I&dgg<Jedgg<4533363<ege<I&dg", "F#add9", "Gbadd9", 9, 5, "9", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x9, 0xb, 0xd, 0xb, 0x9 } },
	{ "H533336::<<<:H533336::<<<:H5", "E", NULL, 7, 3, "7", { CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x9, 0x9, 0x9, 0x7 } },
	{ "G&p:Hep:443333334655G&p:Hep:", "D#m7", "Ebm7", 1, 3, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x1, 0x3, 0x2, 0x2 } },
	{ "Ivxv533336466644Ivxv53333646", "Fsus", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x3, 0x1, 0x1 } },
	{ "Ep<533333:<:::<Ep<533333:<::", "Bm9", NULL, 7, 3, "7", { 0x7, 0x9, 0x7, 0x7, 0x7, 0x9 } },
	{ "F08433334367883F084333343678", "C-5", NULL, 3, 3, "3", { CHORD_MUTE | 0x0, 0x3, 0x4, 0x5, 0x5, CHORD_MUTE | 0x0 } },
	{ "F46343356;3;:88F46343356;3;:", "C13", NULL, 5, 4, "5", { 0x8, CHORD_MUTE | 0x0, 0x8, 0x7, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x5 } },
	{ "Jpdm<4353363d::::Jpdm<435336", "Gmaj9", NULL, 7, 4, "7", { CHORD_MUTE | 0x0, 0xa, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x7, 0x7, 0x7 } },
	{ "F:vxv7453336368696F:vxv74533", "C7sus4", NULL, 3, 4, "3", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x3, 0x5, 0x3, 0x6, 0x3 } },
	{ "I:pdm8345336444554I:pdm83453", "F7maj5", NULL, 1, 2, "1", { 0x1, CHORD_MUTE | 0x1, CHORD_END_OF_BARREE_RIGHT | 0x1, 0x2, 0x2, 0x1 } },
	{ "F&9Ge9435336379999F&9Ge94353", "C#6", "Db6", 4, 3, "4", { CHORD_MUTE | 0x0, 0x4, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6, 0x6, 0x6 } },
	{ "J&p:Dep:533336797777J&p:Dep:", "G#m7", "Abm7", 4, 3, "4", { CHORD_END_OF_BARREE_RIGHT | 0x4, 0x6, 0x4, 0x4, 0x4, 0x4 } },
	{ "D:pdm8345336888998D:pdm83453", "A7maj5", NULL, 5, 2, "5", { 0x5, CHORD_MUTE | 0x5, CHORD_END_OF_BARREE_RIGHT | 0x5, 0x6, 0x6, 0x5 } },
	{ "J&<De<4333343edee3J&<De<4333", "G#9", "Ab9", 10, 2, "10", { CHORD_MUTE | 0x0, 0xb, 0xa, 0xb, 0xb, CHORD_MUTE | 0x0 } },
	{ "D&<Ee<343356939899D&<Ee<3433", "A#9", "Bb9", 5, 2, "5", { 0x6, CHORD_MUTE | 0x0, 0x6, 0x5, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x6 } },
	{ "H<343356f3feffH<343356f3feff", "E9", NULL, 11, 2, "11", { 0xc, CHORD_MUTE | 0x0, 0xc, 0xb, CHORD_END_OF_BARREE_RIGHT | 0xc, 0xc } },
	{ "D:vxv7433333335363D:vxv74333", "A7sus4", NULL, 1, 3, "1", { CHORD_MUTE | 0x0, 0x0, 0x2, 0x0, 0x3, 0x0 } },
	{ "Ip9533336466464Ip95333364664", "Fm6", NULL, 1, 3, "1", { CHORD_END_OF_BARREE_RIGHT | 0x1, 0x3, 0x3, 0x1, 0x3, 0x1 } },
	{ "G4643333338788:G464333333878", "D13", NULL, 4, 4, "4", { CHORD_MUTE | 0x0, 0x5, 0x4, 0x5, 0x5, 0x7 } },
	{ "I&dgg<Jedgg<443333337657I&dg", "F#add9", "Gbadd9", 1, 4, "1", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, 0x4, 0x3, 0x2, 0x4 } },
	{ "Fp<44533633dfedFp<44533633df", "Cm9", NULL, 10, 3, "10", { CHORD_MUTE | 0x0, CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xa, 0xc, 0xb, 0xa } },
	{ "G&pHep45333639;;:9G&pHep4533", "D#m", "Ebm", 6, 3, "6", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0x6, 0x8, 0x8, 0x7, 0x6 } },
	{ "J&p:Dep:4533363egefeJ&p:Dep:", "G#m7", "Abm7", 11, 3, "11", { CHORD_MUTE | 0x0, CHORD_END_OF_BARREE_RIGHT | 0xb, 0xd, 0xb, 0xc, 0xb } },
	{ "E:pdm8345336:::;;:E:pdm83453", "B7maj5", NULL, 7, 2, "7", { 0x7, CHORD_MUTE | 0x7, CHORD_END_OF_BARREE_RIGHT | 0x7, 0x8, 0x8, 0x7 } },
	{0, NULL, NULL, 0, 0, NULL, {0, 0, 0, 0, 0, 0 }}
};
