---
id: fast-foundation.numberfield
title: NumberField class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [NumberField](./fast-foundation.numberfield.md)

## NumberField class

A Number Field Custom HTML Element. Based largely on the [&lt;input type="number" /&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/number)<!-- -->.


start - Content which can be provided before the number field input


end - Content which can be provided after the number field input


- The default slot for the label


step-up-glyph - The glyph for the step up control


step-down-glyph - The glyph for the step down control


label - The label


root - The element wrapping the control, including start and end slots


control - The element representing the input


controls - The step up and step down controls


step-up - The step up control


step-down - The step down control


input - Fires a custom 'input' event when the value has changed


change - Fires a custom 'change' event when the value has changed

<b>Signature:</b>

```typescript
export declare class NumberField extends FormAssociatedNumberField 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [autofocus](./fast-foundation.numberfield.autofocus.md) |  | boolean | Indicates that this element should get focus after the page finishes loading. See [autofocus HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefautofocus) for more information. |
|  [hideStep](./fast-foundation.numberfield.hidestep.md) |  | boolean | When true, spin buttons will not be rendered |
|  [list](./fast-foundation.numberfield.list.md) |  | string | Allows associating a [datalist](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist) to the element by [https://developer.mozilla.org/en-US/docs/Web/API/Element/id](https://developer.mozilla.org/en-US/docs/Web/API/Element/id)<!-- -->. |
|  [max](./fast-foundation.numberfield.max.md) |  | number | The maximum the value can be |
|  [maxlength](./fast-foundation.numberfield.maxlength.md) |  | number | The maximum number of characters a user can enter. |
|  [min](./fast-foundation.numberfield.min.md) |  | number | The minimum the value can be |
|  [minlength](./fast-foundation.numberfield.minlength.md) |  | number | The minimum number of characters a user can enter. |
|  [placeholder](./fast-foundation.numberfield.placeholder.md) |  | string | Sets the placeholder value of the element, generally used to provide a hint to the user. |
|  [readOnly](./fast-foundation.numberfield.readonly.md) |  | boolean | When true, the control will be immutable by user interaction. See [readonly HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/readonly) for more information. |
|  [size](./fast-foundation.numberfield.size.md) |  | number | Sets the width of the element to a specified number of characters. |
|  [step](./fast-foundation.numberfield.step.md) |  | number | Amount to increment or decrement the value by |
|  [valueAsNumber](./fast-foundation.numberfield.valueasnumber.md) |  | number | The value property, typed as a number. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [select()](./fast-foundation.numberfield.select.md) |  | Selects all the text in the number field |
|  [stepDown()](./fast-foundation.numberfield.stepdown.md) |  | Decrements the value using the step value |
|  [stepUp()](./fast-foundation.numberfield.stepup.md) |  | Increments the value using the step value |
