if (typeof T === 'undefined') require('../setup');

T('acosh', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).acosh().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('0.9999999999999999999999999', 40, 4, 'NaN');
  t('0', 40, 4, 'NaN');
  t('-1', 40, 4, 'NaN');
  t('-Infinity', 40, 4, 'NaN');
  t('1', 40, 4, '0');
  t('Infinity', 40, 4, 'Infinity');

  t('3.3', 2, 4, '1.9');
  t('4608888.8834', 7, 1, '16.03664');
  t('145005612624726799', 7, 1, '40.20869');
  t('644444444487588842435356055860541441083823652904922222222222222', 2, 6, '150');
  t('9.28', 1, 5, '3');
  t('76', 10, 0, '5.023837236');
  t('28099999969999999491999992999999999999.9999999999999939697', 4, 1, '86.92');
  t('585287364', 7, 6, '20.88076');
  t('7', 3, 1, '2.63');
  t('43999099999999099999999999999999999997999999999999999999999990993999999.999099999999999699999', 10, 1, '163.3556877');
  t('557921.15371560132973597030139633138927112983', 9, 2, '13.9251202');
  t('222222270476', 7, 1, '26.82009');
  t('9925', 4, 2, '9.896');
  t('51156203358371111111111111111111.88888888888888185816094145162589', 5, 0, '73.706');
  t('920.33', 5, 5, '7.5179');
  t('398.29', 4, 0, '6.681');
  t('300000000000000000000000', 8, 4, '54.751217');
  t('2077', 8, 2, '8.331827');
  t('466660000000000000000000.666663813047981223086678888888888888', 5, 2, '55.194');
  t('1481.596575', 2, 0, '8');
  t('51843625827420648103724841829104208766358144', 6, 4, '101.35');
  t('66.49', 6, 6, '4.89014');
  t('30564048384', 13, 1, '24.83623744632');
  t('7', 48, 1, '2.63391579384963341725009269461593688805396394293');
  t('97574340', 32, 2, '19.08927228754035088993028581182');
  t('59258006', 62, 4, '18.590558631774124907454170672852196556349238888846297909065851');
  t('2', 29, 1, '1.3169578969248167086250463473');
  t('47824727144130804625931275592321416135112742535362856133451607743134653532851722527764075063.55842730879104516021234131120280682177076228198214593563443436114750010543987134572764385', 33, 3, '211.793348360036258224908114351528');
  t('28888888888888888888005555555555', 63, 4, '73.1341570240606241766246193827749684596026580789070620470111545');
  t('53333333332333333333333333333333333333333.3333333333238', 44, 1, '94.470527333874694216410397776492923242508444');
  t('372499047371205457405389940445944981761906694426814657494361227129962080514219995743180551139499492754067', 40, 4, '241.4770611463762121239476457202278064235');
  t('2800646674524111760613114531', 29, 6, '63.892795037101476241199480935');
  t('582502684111672632668804', 18, 4, '55.4147679267811784');
  t('59.9999999999194977', 38, 3, '4.7874222911013468319935340554530121378');
  t('3623643157643492007800000000000000000', 54, 0, '84.8736904452442702624435580686958522860590865192215031');
  t('23885562764027262', 28, 1, '38.40519778343449888592577782');
  t('676263', 32, 1, '14.117484513177343902058185404775');
  t('47551685235102870485407214.46883446439928999925', 58, 1, '59.81700664210749659679029308727990790424880703317942061059');
  t('2082819111111111111111.66668634223026707142169092', 34, 6, '49.78115645138172332225379630123395');
  t('7531.926725308', 22, 5, '9.620053337431944749948');
  t('3100000000000000000000000000000000070000080000000000000000000300000000000000000000000000000000080', 6, 6, '222.873');
  t('49844937529139.9399', 55, 0, '32.23308523365993666498473649670539223213853202660291314');
  t('36666666666999999999999.91929310391451604503565774644', 28, 5, '52.64930221056830211957060803');

  /*
  t('688794659750592416', 10, 4, '41.76686678');
  t('2', 9, 3, '1.31695789');
  t('59690', 1, 3, '10');
  t('185157101054393517830827', 2, 0, '55');
  t('7339333333333333.3339', 10, 4, '37.22517159');
  t('143293', 10, 1, '12.56579394');
  t('62318899.42132781822551066', 6, 5, '18.6409');
  t('209993.13964675979087777312767201615918', 7, 0, '12.94798');
  t('8344444444444444444444444444443444344444444444444.44444444623', 3, 5, '113');
  t('5654929.9999', 7, 4, '16.24119');
  t('3551', 4, 5, '8.868');
  t('10', 10, 1, '2.993222846');
  t('2932424523822944651143728066593172499992979349088', 4, 1, '112.2');
  t('6.39', 5, 3, '2.5417');
  t('35554664', 8, 4, '18.079729');
  t('6162345253079358700', 10, 2, '43.95813629');
  t('7322091622521.519767109364013654', 6, 4, '30.3151');
  t('5', 7, 4, '2.292432');
  t('399999999999999999935316411018604918039599999999999999999999.36939115746638208018', 8, 6, '137.93196');
  t('2000000000000000748', 8, 5, '42.832826');
  t('9.12', 1, 4, '3');
  t('443571.841448', 3, 3, '13.6');
  t('8.6891576', 9, 4, '2.85189541');
  t('62666', 2, 2, '12');
  t('8572', 9, 2, '9.74940354');
  t('9825', 9, 5, '9.88583261');
  t('34930332322753463339602158973222066786428322', 1, 4, '100');
  t('33809999999999', 5, 3, '31.844');
  t('364300000.0000005000000000000000000000000000000000000006100008000000000000000004', 7, 4, '20.40664');
  t('66322.733', 5, 4, '11.795');
  t('41111.1111111450094213682059581804', 9, 3, '11.3171808');
  t('6382684751355812260550286012768053775172785382718996890699347000000000000000', 9, 3, '175.240617');
  t('899898784', 8, 2, '21.310941');
  t('95851434098223440189.9999999999112787642593208233262777777777777777777', 3, 2, '46.8');
  t('2.1', 5, 4, '1.3729');
  t('7.03247', 7, 3, '2.638591');
  t('42074415192304513830847567527805489757200654475924', 9, 1, '114.956671');
  t('18926441693', 10, 6, '24.35697299');
  t('83.5', 2, 4, '5.1');
  t('98026.9', 9, 4, '12.1861444');
  t('2.222222222222222222502937', 4, 2, '1.437');
  t('6297484644.4', 9, 5, '23.2565633');
  t('485975802458987968981230993431574741136807777777777', 2, 3, '110');
  t('26.66666666666666666666670416422187810665421327039', 8, 2, '3.9762098');
  t('7', 2, 0, '2.7');
  t('4812.1111111111111111111109', 5, 1, '9.172');
  t('7210142909', 3, 3, '23.3');
  t('8550429999999999999999999999999.9999299999999999999959999999999', 10, 2, '71.91668155');
  t('729250190.57908800914344534791386405739736678231141402397319236581853117776727058', 4, 3, '21.1');
  t('3.6381043101384038035400919576', 8, 2, '1.965163');
  t('8219031139', 6, 6, '23.5229');
  t('213', 7, 5, '6.054434');
  t('1.3', 8, 6, '0.75643291');
  t('28.4', 6, 5, '4.03923');
  t('979000', 8, 4, '14.487434');
  t('9099882222222222222.88888', 7, 2, '44.34795');
  t('50.0009', 9, 6, '4.60508817');
  t('57918824268321306191403.639719313', 1, 4, '50');
  t('302886700', 2, 0, '21');
  t('90911', 7, 1, '12.11078');
  t('8.1', 9, 5, '2.78117888');
  t('7333333339574354800153039260402793737734657.99992', 7, 0, '99.39416');
  t('383955931730937604', 6, 3, '41.1824');
  t('3479959517.9590905451212', 10, 1, '22.66343367');
  t('1259.24', 5, 6, '7.8314');
  t('7150862477018.38294089660523', 2, 0, '31');
  t('366666666666666666678514444444', 7, 3, '68.76739');
  t('7264742348252172662795558', 10, 0, '57.93822225');
  t('61466967667003533', 10, 2, '39.3504235');
  t('5.1', 1, 6, '2');
  t('277.7777777777777777777777777777777777777779', 7, 4, '6.319965');
  t('88999999.9999999999999999969979999949999999912999999999999999995', 10, 1, '18.9972941');
  t('74470', 2, 1, '11');
  t('1822222222222222222222.7777779', 3, 3, '49.6');
  t('86.155', 1, 2, '6');
  t('3300000000', 8, 1, '22.610335');
  t('6352311968376696.550668309', 10, 6, '37.08074241');
  t('450000000000000900000.000000002200053', 4, 0, '48.25');
  t('20.75', 9, 3, '3.72511228');
  t('9531111112222222222222222222.111111111111', 10, 5, '65.11750599');
  t('1333333.5558', 7, 4, '14.79634');
  t('6426', 9, 3, '9.46125471');
  t('3', 1, 5, '2');
  t('55709330.834715245752457138070117472389817859371577879445647713355041196', 5, 4, '18.529');
  t('1', 6, 2, '0');
  t('8569803134.829', 2, 4, '24');
  t('5', 9, 2, '2.29243167');
  t('29216030850742921269080222332244252306', 5, 2, '86.961');
  t('71111111121111111111121111511121111111111111.1111111111111111111611111272', 4, 1, '101.6');
  t('4123748.30991539798604850558116', 5, 6, '15.925');
  t('1137.71942931123672005865923849506285507', 7, 5, '7.729928');
  t('41901994757638791662401297', 1, 4, '60');
  t('4', 6, 4, '2.06344');
  t('7023080293863491033849058332911858160065', 1, 6, '90');
  t('4', 1, 6, '2');
  t('4581184000000000006', 5, 3, '43.661');
  t('2370.4537450762082343879772090696', 9, 6, '8.46398381');
  t('92348696.0789388695753918836531632296673154362245799313886801633', 1, 1, '10');
  t('7.2', 8, 2, '2.6623705');
  t('3191.913286478573', 8, 0, '8.761523');
  t('16937179424805646671818546532718996103544004742402952', 6, 4, '120.954');
  t('5', 7, 2, '2.292432');
  t('4', 2, 0, '2.1');
  t('7186', 10, 2, '9.573037144');
  t('288888888888888879293326377258623961960181', 9, 2, '96.160008');
  t('132.412', 9, 4, '5.5790512');
  t('7.815504405398309331795693', 8, 6, '2.7451385');
  t('3030000000008.009', 4, 6, '29.43');
  t('656633333333333333333333333333333333233333333333333333333333333333333333.333333388', 1, 5, '200');
  t('6', 10, 2, '2.477888731');
  t('848804345996441702.69111673174', 5, 6, '41.976');
  t('257003.9', 2, 3, '13');
  t('691.84', 7, 4, '7.232501');
  t('5566734', 2, 3, '16');
  t('31.3996', 6, 5, '4.13969');
  t('680570817991604801232717809312109580370199', 8, 3, '97.016897');
  t('1.57091', 1, 1, '1');
  t('6393.3', 4, 4, '9.456');
  t('87082084344581241478620.17429184906262032232746139175', 7, 6, '53.51429');
  t('4.1', 8, 1, '2.0889188');
  t('6.3475', 3, 3, '2.53');
  t('51387777777777777.561792576841996021680552554078', 9, 4, '39.1713239');
  t('7', 7, 3, '2.633915');
  t('3', 7, 0, '1.762748');
  t('48888810857344814329607780730572594654538212906554820830939508611854021189481344222', 6, 4, '191.092');
  t('8444444444444444444420325506716748175309262499111111', 1, 5, '100');
  t('70000000080000050500000.0000001', 2, 1, '53');
  t('89333333332333337333333333.331333333413333333333332333333333333333233333333316333333333333', 8, 4, '60.447564');
  t('5', 3, 0, '2.3');
  t('6043333333334333335133333333333.335333333133393333333334', 4, 6, '71.57');
  t('7', 7, 3, '2.633915');
  t('82222222222222222222.222222222222222222222222', 2, 0, '47');
  t('244730931839123673209878', 5, 1, '54.547');
  t('5', 5, 0, '2.2925');
  t('9', 1, 0, '3');
  t('7232555555555555555.888888888888775794001018177603398', 1, 3, '40');
  t('2.489937600116761', 4, 2, '1.563');
  t('166666666674871849769108495054364444444.80828377042757112817483666001735224658867678505538888', 5, 1, '88.702');
  t('3999999999999.2', 10, 2, '29.71046266');
  t('64560268495084511111.99999999999911111', 10, 6, '46.30727804');
  t('733333333333332180750727264961494503517297', 7, 0, '97.09157');
  t('9481510951080291281011730141950557543113128179169591821423729222222222222222222', 3, 5, '183');
  t('4', 7, 4, '2.063437');
  t('9837.503', 7, 0, '9.887105');
  t('21.22222222222222222211111111111111163401341559', 3, 2, '3.75');
  t('763.756445520805', 7, 2, '7.331396');
  t('2599999999999999999999999999999999.9', 11, 3, '77.633966694');
  t('8839000000', 9, 1, '23.5955867');
  t('3353941193.20510874412', 4, 0, '22.63');
  t('80059999999999999999999', 19, 1, '53.43021048699933223');
  t('49064140362236749728704271199451859640', 19, 2, '87.47933895746407069');
  t('5377150453333333333333333333.3', 19, 0, '64.54510326974159099');
  t('1405500000', 15, 0, '21.7568061288709');
  t('5287913568230499', 3, 0, '36.9');
  t('25643078378317969065240841', 12, 0, '59.1994630989');
  t('74107777777771111111111111111111.55555555555555555557777777', 2, 4, '74');
  t('4.52', 2, 1, '2.1');
  t('1', 7, 4, '0');
  t('61', 2, 6, '4.8');
  t('770', 11, 0, '7.3395372738');
  t('26009816628915839.48106802232293', 15, 1, '38.4903976048838');
  t('29999999991099.9999999991999999999996593', 7, 0, '31.72537');
  t('799999999977221292744819555555555555555', 7, 2, '90.27083');
  t('1', 7, 2, '0');
  t('76.4', 20, 5, '5.0290870434659643206');
  t('14005075084515997', 15, 6, '37.8713433454333');
  t('9', 20, 1, '2.8872709503576206849');
  t('811111111100723596188348.111111111111166555555555', 18, 2, '55.7458391832223613');
  t('6999994.9999', 20, 0, '16.454567173279272505');
  t('689889.9899', 7, 1, '14.13743');
  t('172411633.5814807', 13, 0, '19.65854257465');
  t('59002539284', 16, 0, '25.49399349919781');
  t('88', 7, 4, '5.170452');
  t('3', 11, 0, '1.7627471741');
  t('956047954792273470461890103655', 4, 2, '69.73');
  t('3000309999.1', 16, 3, '22.5151286338693');
  t('221235021260937.750724969', 8, 6, '33.723394');
  t('71046488.8853376', 8, 6, '18.771992');
  t('44499999.442', 15, 6, '18.3041469151571');
  t('317086.1974355232512', 20, 5, '13.3600761126547556');
  t('488887777777777777.111881565057225', 10, 6, '41.42405655');
  t('409000000000002400.04', 1, 0, '50');
  t('41843.503', 7, 0, '11.33484');
  t('640098', 16, 6, '14.06252374917275');
  t('5.6004', 4, 3, '2.407');
  t('22554533117680', 17, 4, '31.440104367408607');
  t('299092', 17, 1, '13.301653677910096');
  t('54117646771868637437148805854834158730824569839138899999999999999999', 12, 4, '156.654923639');
  t('9', 14, 3, '2.8872709503576');
  t('5972682', 16, 5, '16.295853811279');
  t('802005416', 15, 5, '21.1957730994851');
  t('980', 12, 1, '7.58069949191');
  t('37777.77', 1, 6, '10');
  t('523603.34373281', 8, 3, '13.861636');
  t('779999999.99999999', 10, 0, '21.16795166');
  t('32', 19, 4, '4.158638853279167201');
  t('6976.99', 8, 6, '9.54352');
  t('9333333333333333337162799129172126314655704899149242475651934102388981417960449094742033333333333333', 5, 1, '230.88');
  t('7', 4, 2, '2.634');
  t('896.1998', 5, 1, '7.4913');
  t('447351998978633272059897777855555555555', 15, 3, '89.6895562828183');
  t('73.039', 4, 0, '4.985');
  t('6369177597222222222222222', 2, 1, '57');
  t('558888888111111.8', 11, 3, '34.65011898');
  t('5610829', 9, 6, '16.2333562');
  t('61035.9', 17, 3, '11.712364675125771');
  t('78019099.572499', 2, 2, '19');
  t('7098000000500060000000300000900.028', 18, 3, '71.7305130246760713');
  t('31595', 1, 3, '10');
  t('67.7', 14, 2, '4.9081788100445');
  t('30008', 12, 0, '11.0023664721');
  t('819', 17, 5, '7.4012308917018109');
  t('198286254683875638023754059108303270', 5, 2, '81.969');
  t('652361.415', 14, 4, '14.081501185376');
  t('3', 7, 3, '1.762747');
  t('5', 7, 6, '2.292432');
  t('4888888887436680888888888888.777777777777777777151', 7, 1, '64.4499');
  t('4.7', 14, 4, '2.229195247679');
  t('52477708090980557820', 3, 6, '46.1');
  t('574999999969.7999979', 13, 4, '27.77078305825');
  t('49000000', 5, 4, '18.4');
  t('9288384', 9, 0, '16.7374224');
  t('22682.126567', 1, 1, '10');
  t('5444444444444444444717719046150070257602965299084327644053398857004444444444444444444', 9, 4, '195.804891');
  t('83662.6626663666666668', 16, 0, '12.02769525224759');
  t('27452474533965122852969512675794759546408', 20, 5, '93.806422118177108963');
  t('7033', 15, 0, '9.55151581181369');
  t('1', 16, 2, '0');
  t('5167894160.77496943103516', 6, 6, '23.0589');
  t('2057110276674016259763027395492619', 2, 0, '78');
  t('988563064118972848719798803.34613', 8, 2, '62.851442');
  t('3999999999999999999539818660311111', 1, 6, '80');
  t('1999999.59999956', 1, 2, '20');
  t('49126', 1, 6, '10');
  t('36677449719367071998469329009963366', 16, 5, '80.28061736650922');
  t('42369896728775635.2603541628125783538247824456799236', 17, 4, '38.978361702739492');
  t('650', 11, 1, '7.1701189517');
  t('76.3', 17, 0, '5.0277771732271599');
  t('919978945.418589024455379', 10, 5, '21.33300852');
  t('8893575', 10, 2, '16.69398685');
  t('1111111111111111111111111111111111111111111111111111.11111111111119', 1, 4, '100');
  t('2', 18, 4, '1.31695789692481671');
  t('25', 14, 4, '3.9116227652146');
  t('17964.505548552851604783483558429595213', 11, 3, '10.489300355');
  t('9000', 10, 0, '9.798127034');
  t('768818888888888888.88888888', 5, 2, '41.877');
  t('444777347338', 7, 6, '27.51399');
  t('358.974586', 14, 1, '6.5763968354018');
  t('780.3', 14, 1, '7.3528252310844');
  t('5', 5, 3, '2.2924');
  t('299.99999', 15, 6, '6.39692684409328');
  t('3', 14, 1, '1.762747174039');
  t('83784768867990', 4, 3, '32.75');
  t('112725.5', 3, 6, '12.3');
  t('3', 9, 2, '1.76274718');
  t('2777777777777777.78777777777', 10, 5, '36.25357482');
  t('9539988497.17692805781324828', 7, 2, '23.67191');
  t('922935211', 17, 5, '21.336216776630534');
  t('4618555555555555.4883', 15, 2, '36.7620055813664');
  t('431454987847885709788742740', 2, 5, '62');
  t('8640', 6, 3, '9.7573');
  t('873', 19, 3, '7.465082408370928985');
  t('61.27767', 7, 5, '4.808496');
  t('253678340782509684625443992327148876342696020', 10, 6, '102.9377882');
  t('2952091', 12, 1, '15.5911714713');
  t('58.19', 9, 0, '4.75678686');
  t('77489.4060920964', 9, 3, '11.9510436');
  t('8', 3, 1, '2.76');
  t('6139149828702444444444.5741193384639201876', 1, 3, '50');
  t('80400000060000000300000000000000000000000.0000000004000000600000000000000000000000000005', 5, 0, '94.881');
  t('89999386760685029044', 11, 2, '46.639481711');
  t('493', 14, 5, '6.8936553260019');
  t('5565555555555555555595.5655255555559', 17, 3, '50.76403094346821');
  t('59999999999999999999999999999999999969.999999999999999999999999999', 2, 4, '88');
  t('527594720781512.43163112373214476666666666', 11, 0, '34.592496712');
  t('21', 13, 3, '3.737102242198');
  t('3933604967702', 7, 6, '29.69372');
  t('400000000.000000000000000000000000000000005', 1, 4, '20');
  t('81138.56', 8, 1, '11.99706');
  t('33333333333333333.333333', 19, 5, '38.73848147279061225');
  t('754', 15, 5, '7.31853910882625');
  t('1854.13613026373033695347983285210097', 7, 0, '8.218322');
  t('36', 12, 1, '4.27647316194');
  t('25438994574049', 14, 0, '31.56045151272');
  t('81374.8649123536830012739613993141318574470909821274221525492674243872', 12, 5, '11.9999689');
  t('6348226.1207463', 13, 1, '16.35683316133');
  t('515771.3625286218471198636866006610274', 13, 1, '13.84656603095');
  t('20000000050000000000000000000.0000000060000000000005000000000000000000000000000000009', 8, 1, '65.858676');
  t('67250722715744897672930587456073962887591224237', 4, 5, '108.5');
  t('59999999999999699999999199999.99995999999999999999979999099999999999999', 19, 6, '66.95728925362127446');
  t('556.5', 6, 3, '7.01481');
  t('41772704', 12, 5, '18.2409008504');
  t('9062980899032359103861773818870194606913914800000000000000000000', 17, 1, '147.96020612267854');
  t('9765558.55195555555', 13, 4, '16.7875195006');
  t('5', 17, 0, '2.2924316695611777');
  t('5241.59', 10, 5, '9.257527338');
  t('19384667.18102', 18, 1, '17.4731401406072814');
  t('3222222222222222600894057266144', 10, 6, '70.94077122');
  t('6000000', 19, 1, '16.30041720775226746');
  t('27844386714766.44444666666', 17, 2, '31.650799688319587');
  t('641875390333287539866278126167', 20, 1, '69.32733888019599383');
  t('9030000.000006', 13, 1, '16.70921010595');
  t('78', 8, 6, '5.0498149');
  t('3000000000', 13, 0, '22.51502530618');
  t('522276333.7777777777777777777333333', 13, 1, '20.76685456139');
  t('547.51002750772', 17, 0, '6.9985271231840144');
  t('56666666666666666.6666666666666666666666666', 8, 1, '39.269109');
  t('20783795783373318190658285827', 22, 2, '65.89711832561389428339');
  t('57493662.855', 28, 0, '18.56033246903643030590458284');
  t('2362.5', 32, 3, '8.4606227951362609359503843479658');
  t('78158633908238185853457189410727460579757716', 23, 0, '101.76046161574730423851');
  t('442', 10, 0, '6.784455783');
  t('48867.638', 30, 2, '11.4900178372412032109872706908');
  t('681707021389209213540', 23, 1, '48.664278832591273859923');
  t('81300.174', 29, 6, '11.999050616277136117846286638');
  t('8253740684128450567625', 2, 3, '51');
  t('5718408217', 14, 5, '23.160103500429');
  t('2279', 26, 0, '8.4246391616716920725623049');
  t('445462625.65868593268537434678710487', 29, 3, '20.607771088893837681580476655');
  t('421111111111111111711111116111111111.91111141181111111511117111', 26, 4, '82.72135197010370553248049');
  t('6363147631159', 30, 1, '30.174691461972276712796663461');
  t('82222222227930600001148491445484369425724116611111111111', 39, 5, '129.442167811169834517629373803410924838');
  t('2395606649221.9', 24, 6, '29.1978047934905326604021');
  t('285.2774428848831159151305', 30, 4, '6.34660629920663772981413954482');
  t('43493', 12, 5, '11.373502465');
  t('2300000000.000000000006', 7, 4, '22.24932');
  t('21', 9, 2, '3.73710225');
  t('6', 29, 4, '2.4778887302884750048139507451');
  t('9455555555555555555555.1174413511718437477325149994749035890609339739117616771743245793037554', 12, 6, '51.2940365917');
  t('8060209938624425679089226', 37, 1, '58.04212901557209726301936643403738545');
  t('855555555555555555555.5555555555555555555555555575555555555535555555555', 18, 4, '48.8914298849583235');
  t('900', 40, 2, '7.495541635242137861700342505711552690807');
  t('37.62', 12, 2, '4.32050631218');
  t('7899999999999999999999999799999999.99996', 34, 0, '78.74531800883642869216590418752279');
  t('6228813', 7, 5, '16.33784');
  t('4692379381873326605192095142687652329126673142739786727032', 13, 2, '133.486437266');
  t('50806000000000000000000000000000000000000000000000800000000000000.0000000000000000000000000000005', 13, 2, '149.6840224971');
  t('655220909203068791644856.0666770845209662883483914904', 39, 6, '55.5324065781676613121205192374047441786');
  t('4.69754954696457222410850721701', 34, 5, '2.228661511423570498229774094059837');
  t('744444444444.44311617171', 35, 2, '28.029051245549192726247762477982657');
  t('599.666572', 40, 5, '7.089520272759238082142051507835946883525');
  t('26913093827328008876685631162519080431049132420236425548348598622436420025896', 29, 1, '176.67964208267247065948406295');
  t('399899949999999.99399991', 21, 4, '34.3153826873100005485');
  t('966666666666393982829571662824767733333333333333333333.185933749269', 1, 2, '200');
  t('283965108696842854259', 12, 5, '47.7885302284');
  t('4.0000000000000000000900000000100008', 21, 3, '2.06343706889556054675');
  t('455.44', 9, 3, '6.81440995');
  t('7486693', 37, 1, '16.52178491652441950043043482511510107');
  t('2554441762861809', 35, 4, '36.169757287137583718978264152800537');
  t('58812222222212262222222.2222292222', 24, 0, '53.1217838276613748739474');
  t('899.99991', 33, 5, '7.49554153524207113323853218901942');
  t('87771666666666666.44444444444444444444577479428478034853138996354979748322222222222', 38, 2, '39.706662320918711491721449735597665395');
  t('7683.31488245447708474', 30, 6, '9.63995353466294761318164419226');
  t('2543430714794751207109390536104751', 23, 0, '77.611969094168832202415');
  t('948668.36781935465387262136170388', 7, 4, '14.45596');
  t('5.5555557', 16, 0, '2.399745410046718');
  t('202', 24, 3, '6.00140875105453306775285');
  t('654', 30, 6, '7.17625394751663622557455779756');
  t('7.15', 11, 1, '2.6553330563');
  t('23192105636911.1', 13, 1, '31.46798024298');
  t('18715015583280969971394525473508147066666666666666666', 25, 1, '121.0543130972749427798072');
  t('850784888488885988888888.882888888888888', 21, 3, '55.7935934550716151588');
  t('555551624764.77777777777777744444444444444', 9, 6, '27.7363746');
  t('977.731658', 25, 3, '7.578382173105494277554113');
  t('513359999999999999999.949999', 24, 4, '48.3806562078950275014831');
  t('475214225368504435743900', 32, 3, '55.211199836575062578332207259495');
  t('4000000', 3, 5, '15.9');
  t('1.2', 35, 4, '0.62236250371477866780685115857913059');
  t('7510918801207835413135591963200120055425848503007753019336896436217399685954597393612788', 29, 3, '203.03440807303735710363524384');
  t('7.239741491578', 25, 3, '2.667928457894097454723437');
  t('708983541860', 30, 6, '27.9802453305955703036220800107');
  t('5694816766.3', 3, 3, '23.1');
  t('3000000000000000000000000000000000000000000000', 24, 2, '105.408088653960110781623');
  t('80000.000075351079395133171776466666666666666', 21, 5, '11.9829290951187899658');
  t('65799982.880001', 13, 2, '18.69527731668');
  t('3888888888888888431602193181777652527777777777.72522847176624010024756017', 12, 6, '105.667599849');
  t('32', 13, 3, '4.158638853279');
  t('1274002927.1', 38, 0, '21.658576872220407661971685810438407436');
  t('889999999999999999999.99', 32, 5, '48.930900317178953144076874065176');
  t('7.95286990705358103646', 1, 6, '3');
  t('510870725873133.851844190063817705987041725973', 4, 2, '34.57');
  t('2309.766666666466666666665', 7, 4, '8.438049');
  t('61000081.0000005', 32, 6, '18.619532930565509633753111279232');
  t('581514', 26, 2, '13.96653750687662802604073');
  t('15567000600000000002.007', 4, 2, '44.89');
  t('3287841070', 23, 5, '22.606644157157353879532');
  t('70600', 10, 3, '11.8579326');
  t('7.248088765792676', 8, 1, '2.6690919');
  t('527777204469', 5, 4, '27.685');
  t('605452.850565230629731348', 37, 2, '14.006879150906810214375519545924622');
  t('5', 38, 2, '2.2924316695611776878007873113480154317');
  t('1.4', 31, 2, '0.8670147264905651039505202695015');
  t('75555575516595912104851575982414976543346266', 21, 1, '101.726589571334002153');
  t('2735555.5555585552728555', 21, 3, '15.5149922819453706406');
  t('103268717.69665038139', 2, 1, '19');
  t('93552555555555555.555555555255', 11, 2, '39.770446946');
  t('3626666666666.06666266666666666666666666666', 15, 4, '29.612482249248');
  t('42222222222222807736331954584326257', 34, 3, '80.42140192474767882010415168976016');
  t('13.332313159866168469878581', 7, 2, '3.281929');
  t('68888188.8988', 23, 4, '18.741142478029060806198');
  t('66355565555558.55558555', 29, 5, '32.519195935520625293459012293');
  t('21847734193912439', 38, 1, '38.31602079341608733151211885202759983');
  t('14663131522875', 23, 1, '31.009504580154385854738');
  t('610', 40, 0, '7.10660546586422256259205731286867392587');
  t('78042586050836434.29', 2, 5, '40');
  t('5466.666', 29, 2, '9.2995713753873400986219378863');
  t('90.03908', 1, 5, '5');
  t('6444444455555555.4494348809681611111111111111', 23, 4, '37.095142010404968436578');
  t('71085100', 23, 0, '18.772535489377438272718');
  t('36000.00008000003', 16, 3, '11.18442140002751');
  t('11893037', 40, 1, '16.98461084133822739880630108970024046177');
  t('396645173988888888888888888.99999999', 23, 0, '61.938231525165254827578');
  t('56500000080030.0003', 21, 1, '32.358408936057348958');
  t('4316321611057467.45598', 34, 0, '36.69432713609067955868915699108864');
  t('47573032886666666666666', 35, 3, '52.909700198135726624393228043153839');
  t('25505073629437392980342296549044.1316504395405246012733400255242', 12, 3, '73.0095773686');
  t('5.81', 36, 5, '2.44523802683985658743286515936458208');
  t('710287', 2, 1, '14');
  t('29918', 17, 5, '10.999362765215049');
  t('15098745939089136', 36, 6, '37.9465352654511865526984995938866965');
  t('7', 38, 6, '2.6339157938496334172500926946159368881');
  t('9.8', 24, 5, '2.9729162609330438353561');
  t('7104020327231710192222222.8715208', 2, 4, '58');
  t('89999991863333333333.9', 25, 3, '46.63948843437562119439854');
  t('64062501.5856370106479309595347923', 29, 1, '18.668516932608353357172244893');
  t('60000000.00000000010000010000030000000000090000000000000000000050000000000000005', 23, 6, '18.603002300746320030578');
  t('350095309000.04', 1, 5, '30');
  t('1700', 40, 1, '8.131530624099051221559980534496351033572');
  t('25800000', 9, 6, '17.7590322');
  t('111111.4', 3, 3, '12.3');
  t('2006899459785102405616918445435405.22228115531599', 35, 6, '77.375046223147135058707859637650197');
  t('603299714.621', 11, 0, '20.911071851');
  t('19999999999999999699999999999999999999999999999997999999999.6', 8, 6, '134.93623');
  t('9676877.9999999999991', 1, 2, '20');
  t('2.3876', 19, 0, '1.516377988855881991');
  t('8.2040544391860208424426138336', 30, 5, '2.79404043833071443023764808272');
  t('444.2222222222244444418527113548', 33, 1, '6.7894708513900939219741556360654');
  t('155555555963333333333333.7', 32, 4, '54.094437074323463841555759884423');
  t('71483.17269060631716468', 34, 0, '11.87036453451014464767309772125707');
  t('81055245093630003669331307380188344709542996668713059671339999999999', 19, 5, '157.0588942785500158');
  t('174909999.999', 37, 1, '19.67292929443747395640583835855643387');
  t('72389726667648937978.95830476', 19, 3, '46.42174324692044937');
  t('130331539707084054280229937028032408765495183123', 19, 2, '109.1795578746763325');
  t('2389.75708170159', 20, 3, '8.4720941370888186499');
  t('400000000000000.00007', 33, 3, '34.315632843596475504678576729954');
  t('85432282404487044444444444444444', 39, 1, '74.2184240138505726220714669889583672213');
  t('955637601125390730411111111111111111.38922', 30, 2, '83.5408340122257834914502291611');
  t('593568266996', 21, 6, '27.8025652493658771352');
  t('31994628083219964815323947873588354325896483161322064035639786789', 32, 6, '149.22157605549302547006587180157');
  t('72005172621424', 23, 3, '32.600906254888260731124');
  t('939999999999999', 12, 5, '35.1700481718');
  t('838499999899919999999999999991.9996959999999999999999099', 30, 2, '69.5945592725430863265558566044');
  t('9916665566666.6666', 5, 1, '30.618');
  t('5.36759', 12, 1, '2.36473379388');
  t('1680000000', 16, 2, '21.93520681092153');
  t('94754530764046933.603934', 26, 6, '39.7832132363801229723966');
  t('78.66666666666666666666', 18, 0, '5.05832629659506946');
  t('3177531972', 33, 2, '22.5725178035356333977594690856642');
  t('43', 35, 5, '4.4542120606027113335780195417851821');
  t('16666666666636666666660666666666666666666666.66666668666666666666661', 25, 0, '100.2151318030681004053961');
  t('99906891879943737715', 34, 4, '46.74391752551495210415801805458335');
  t('52.786', 25, 0, '4.659303449785841695619066');
  t('734557015475.92555555555', 6, 2, '28.0157');
  t('70050000000000000000000000000000', 20, 0, '74.01990924316433184');
  t('97966954933.201', 21, 5, '26.0010432447548866219');
  t('220', 8, 2, '6.0867696');
  t('443786303', 1, 6, '20');
  t('2658.7112219', 26, 2, '8.5787439265140948747775106');
  t('313.371', 6, 0, '6.44054');
  t('60084724496857256894441.8529363741447990955344106873326611', 31, 3, '53.14318977456434289121348040513');
  t('8828.47889', 11, 5, '9.77888519');
  t('30', 25, 1, '4.09406666863208512766772');
  t('2747.1726076', 9, 4, '8.61147467');
  t('26014495379288528098', 7, 4, '45.39833');
  t('9171761155525466666666', 13, 0, '51.26356345749');
  t('8938338345188.2228888888', 44, 2, '30.514518000969814699923641606764039527375296');
  t('768282499898726855', 39, 1, '41.8760810793921410281161108738756248606');
  t('48815741324.5300828046569472', 77, 3, '25.304465846477161630573234169214391160850523010870967883563157200984307414098');
  t('24196444.0454544', 70, 6, '17.69486342061960114953535208586209672585965472913061773781996208605337');
  t('847317015401917', 8, 6, '35.066243');
  t('5999999999999999999999999999999999.9999999999929994999990999999999999999999999999', 38, 6, '78.470214718591507882823427484422897692');
  t('776777777777.222222222222222222226', 58, 2, '28.07156732668140703729803192141364600386912754974132216043');
  t('889112.0000000000000000900000090000000000009', 74, 2, '14.391125671372289803097018465974313403559190631839978724405376819075811612');
  t('832171411221867614626497877784504', 70, 5, '76.49473841308588563157657646059722500813066544405616857779969740991285');
  t('745606001360', 40, 2, '28.03061032987967935486003117349283469885');
  t('44840460835121811098.97', 13, 5, '45.94278972993');
  t('3943797154951.7025503782406', 52, 0, '29.69631230060596956901470095466552588852734350192919');
  t('8', 61, 0, '2.768659383313573832732001409383745519872057893445600633657278');
  t('339258006.28206206542', 65, 0, '20.335418636907848295370352390759348271696383638466727072541405726');
  t('954929080435.6733181587', 15, 4, '28.2780500939057');
  t('81288.20178584267212558629630013', 56, 0, '11.998903346041831701460193148216002753365781699052918708');
  t('1542406580719.555555555', 41, 0, '28.757512207898890957091145657301885474088');
  t('2000000000000000000000000000000000000000000000000000000000000000000', 71, 1, '153.35691049872690576402190025208439083782369851821952692644100148284657');
  t('700002000000000000000000800610000000000000000000000000000.74', 73, 3, '131.5838253944205924375087108307003662777373304206388002806269900674853124');
  t('170.6', 48, 5, '5.83246022572854424522995950984825372202265097044');
  t('61630992031693693681645018448018518909067573434757061', 54, 1, '122.246151784672251162106251252548556474750670747320834');
  t('20000000000.200000000000000000000000000000000000000000000000000000000000000000002', 54, 2, '24.4121452910703474590137037897600080454953477124040737');
  t('5301.662', 39, 4, '9.26892280695396343092210195195345376548');
  t('379161.4324826016075607712124988714457228279287', 22, 1, '13.5388645171605667375');
  t('869599.94699999999999999', 14, 6, '14.368935734401');
  t('5.58406697', 48, 4, '2.40494886749449615751276287848939832547789093282');
  t('120150229357.68498888138999733859', 9, 6, '26.2051559');
  t('19.29995819', 64, 2, '3.652578271585085623824201600249540414914865550792071747379834773');
  t('99999999999999999999999999.99999999999999999999999999999999999299999999999999999999', 68, 1, '60.56035959840513309388500994325164596570413883870835260598720536465');
  t('86.669366661666666666816', 8, 0, '5.1552144');
  t('5222222222222222228775239777', 46, 5, '64.51586771577301798318829474265036651467219809');
  t('808428236065003', 68, 4, '35.019260209741728798666680318306137040311907110272455193244463656411');
  t('566666666666666286666666666666666666.88888888823975903074522705594997258464', 63, 6, '83.0182264907396499683129871222436527623327347014182884855456321');
  t('45.427', 76, 3, '4.50913265368539261256037479084466170954947062088782553263541261759886882346');
  t('98681285', 28, 4, '19.10055305198952520533436779');
  t('27090492777342226402359540019471962362608942221246364236930491603820341', 18, 2, '162.87070144345874');
  t('4222222222222222253007249141104988', 34, 4, '78.11881683175361927593790979159436');
  t('299.999981876999999999', 20, 4, '6.3969268170164570069');
  t('96548651750771140561', 3, 5, '46.7');
  t('399999999999999999999999999999999999999999999999999999999999999.99999999999999999999999999999999999954', 50, 6, '144.83971730731066833736716655480511057549479269806');
  t('5.929358078871196868', 53, 6, '2.4658751678685554076646546249382756046731256573231434');
  t('68071814409707382348764390068978504613223487.29635432163018324', 14, 0, '101.62228432848');
  t('823636064', 13, 2, '21.22238650097');
  t('9429403', 36, 5, '16.752490524575901750367433411572786');
  t('50176000859', 79, 0, '25.33194985935403749177354968558409920023699512930684100128798387958355811421296');
  t('60004000000000000000000000000000', 28, 1, '73.86511119704795971972597953');
  t('5577537924897616428.0333333333', 22, 6, '43.85842630137726068627');
  t('855777774777777777777787771776777777777777777777777777.7777777778', 66, 1, '124.876997656789327040025905039163683669487035160398019813093899339');
  t('347681479.7979158226693500931831', 59, 1, '20.359944511229896065805264676838175661585870668054507001072');
  t('16466.66666666666663666656066662', 65, 6, '10.402240594145854372965969489848271000860777549055628692117392922');
  t('7977777.777779777777777777777776777777777777777777777777777777777771', 61, 0, '16.5853176372424252975187065748869421157994967318462801359976');
  t('4956192265692501357', 15, 4, '43.7403166119975');
  t('333643027314494671423.5096704', 73, 4, '47.94975049538078976184014550104194248141114283427163379251530131791574901');
  t('59.8768767098533', 27, 6, '4.78536784197059742937982664');
  t('21.568132', 21, 1, '3.76382618031436466644');
  t('99321349251378983965415', 67, 6, '53.64579467887364570944440763695096025805043724873491849399005863274');
  t('654904834245', 79, 5, '27.90090295135680768232157402030518366169815855407448261109534752236526730032983');
  t('60007.096700204', 25, 2, '11.6953652930371574027332');
  t('21622558.0697507661', 24, 1, '17.5823948633360122508469');
  t('1400000000', 6, 2, '21.7529');
  t('3720826.22151497', 14, 1, '15.822603484705');
  t('4376817990679715433746665069090469860.45237247251976642992911992857763899012079', 45, 4, '85.0625325025688222279975128668465676255112089');
  t('649400', 17, 4, '14.076951319210235');
  t('539.989994', 74, 0, '6.984696932945263884457779873213006707301547394563950394559247304351619527');
  t('634824734.659130806326200685838625713', 31, 2, '20.96200669090876172776908344965');
  t('100500000.00040800040009000007', 41, 3, '19.11881546602740953589492748233514372087');
  t('970257912536908892148386809813.79782283132588447580592664', 7, 0, '69.74051');
  t('111111111111111111112735802', 4, 2, '60.67');
  t('7.1458635582181542814702778', 24, 5, '2.65474861802689656638805');
  t('26503642236033.4444444444444427408888', 48, 5, '31.6014504629054508476238153915057904225072357905');
  t('866666666666668292340', 62, 1, '48.90433328979423321962945861816774784187515621001922463727794');
  t('4.161649742730688095', 14, 1, '2.1043010448258');
  t('4804.47740517416093971868618377927298887716668566920024163162448153376544398464', 46, 1, '9.170450724589264830449798143054033639278108396');
  t('200.9432687359', 80, 5, '5.9961636121676812248757832499215794759139877290930275985873863239952961856829968');
  t('1229333333333333333333', 63, 4, '49.2539061504611423769699834768286424536734290025054557740893388');
  t('677777777777777723487509694344575868233120178292237795387378888888888888888888888.8', 26, 3, '186.81360390692069181671705');
  t('231.035', 25, 0, '6.135711711072862859353363');
  t('6258384523.4', 28, 1, '23.25033510595965370247864387');
  t('469358438219159270715646506', 29, 2, '62.106556149560129546986427449');
  t('999999999999999999999999999999999999999999999999999.999999999999999999999999', 20, 5, '118.12498692325627519');
  t('70000000', 15, 4, '18.7571529805736');
  t('17436335918609123305289280.1187313', 6, 5, '58.8137');
  t('7', 42, 3, '2.63391579384963341725009269461593688805396');
  t('7793427761562210468702986164870463604186321815608664487325403737901864', 23, 0, '161.62479938099071129233');
  t('5', 7, 5, '2.292432');
  t('322262222422222222622222222222322.22222222222221222222222222222222922222229', 36, 0, '75.546065539866833584196614245638605');
  t('9444711979', 61, 1, '23.66186802344748161179198590267900452850055784980761728579321');
  t('1000000000000001.64297469833894830805290421111111', 33, 4, '35.2319235754706322126618022806703');
  t('76.1142654', 46, 3, '5.025339728353915415325732669653160002326598441');
  t('588888888088.488', 11, 1, '27.794650538');
  t('2841771514127', 80, 5, '29.368595926776285890263220170460817227897508216809699750500566425671184125203302');
  t('161717494675.88749', 36, 2, '26.5022639704194248262716004162930028');
  t('889427842999.5999909949999', 10, 5, '28.2069914');
  t('922222222222224881308159942236950279691100312607497180570459854888888888888', 50, 4, '173.30606009257970735077977904527010368793549799723');
  t('720.7777777771758442355944444444444444', 1, 4, '7');
  t('633333033333333333333303333.3333833333333333333333333334333333332', 66, 6, '62.4061858152191411477818764090316204442766891038295114613682814615');
  t('80.29', 59, 6, '5.0787534776710317707128482336541142608868065104362104839446');
  t('24366793404928330068408', 18, 0, '52.2406554128056494');
  t('54966664666666663661666666666666264566666.6666666666', 1, 6, '90');
  t('3233.333333332333338333336333333392', 60, 0, '8.77441603246972514919714362545736405823779576428779256154367');
  t('5999999.999999999', 52, 3, '16.30041720775226730322654709675928630862732081540597');
  t('3580000.000000000070900000300000020006000006', 8, 3, '15.78402');
  t('2111111111114.46480156173191', 43, 3, '29.07138269832030318506511717517815427822474');
  t('210.30999264505718020566509119828496051908', 9, 4, '6.04172413');
  t('27777777777724015343367898444444444444.4911', 4, 1, '86.91');
  t('1768699.984839', 47, 4, '15.078902543410917971144758198395829337884732221');
  t('4183405755555555555555.22222222222244523661768913305579351770136738888', 6, 4, '50.4786');
  t('90809.371593336083980845799', 47, 1, '12.109664951173438790433935608614379576287358092');
  t('8439548544689', 65, 4, '30.45709711369996173513309931961257455186125867905743707351375417');
  t('2778', 16, 6, '8.622633671479416');
  t('4.31371111911111511', 64, 5, '2.141231626768932091343370714625890127680274889507801990791119695');
  t('64.5850595040297407051027231423699896933299141512480951316', 79, 6, '4.861070347822366991687571506968334346498441351210607148535245277843121748913689');
  t('43.09', 1, 0, '5');
  t('14444443111111111.88888899934907761444444444444444', 67, 4, '37.90223335628229709276665937412252746880024738190824212662729033445');
  t('82526.540452715118290567661', 77, 0, '12.014022403568023068029230059363917254352687452887254008714619978286115304391');
  t('6', 50, 5, '2.4778887302884750048139507450745054494563976572947');
  t('463790300.0002', 40, 6, '20.6480902489402276252595479201292900649');
  t('144300158827924999999999', 23, 0, '54.019329699892745043947');
  t('825725702992510270.63874086554285', 17, 3, '41.948186215139705');
  t('83932044187438299450749', 4, 3, '53.47');
  t('638800000060000000000000000000000000020000000.064', 67, 5, '103.8613125027446475182528756196765027947814643463271024675988525447');
  t('7000000000000000000000000000000', 43, 3, '71.71661011943662913506232850543228252574562');
  t('85173153778518767096017630289679076579476302841422222222222', 48, 6, '136.385183768906229098787163097875767409283061206');
  t('11111111148525296.555555590706161111', 57, 1, '37.6398691874897792392633234000198068788836986608908055392');
  t('529999999.99999799999998999999999999', 65, 2, '20.781534745070383157212720474954530347548453760686643047125313706');
  t('280269539408.486852858883956009016751', 15, 2, '27.0521647983788');
  t('58052400244.68488287', 76, 4, '25.47775907267977860456091179429799292836751261391568303518790151302720970567');
  t('21525861401744686345122338136290015086146124444444444444444', 17, 2, '135.00975254939772');
  t('186847280228837293086025099723488561533351172374', 12, 3, '109.539767965');
  t('981576085965865', 31, 4, '35.21332782728796600816634880236');
  t('84371000', 39, 6, '18.9438814791857392108713630135372588033');
  t('76525380797426132572999.5555555555555', 65, 6, '53.385056594371950157998197281363587992459600288618078132426815225');
  t('59.757126901528', 39, 0, '4.78336562550900011129477724795249387493');
  t('796.66', 60, 1, '7.37357477467404924870168825135914472931756383657102939159157');
  t('10167656724507185887010784388542621885443670453789321', 7, 1, '120.4441');
  t('62.478512452', 63, 1, '4.82790582723873276594995284956211159215367329801430003205397668');
  t('88.5205000000000000000000005', 57, 5, '5.17634943811526589480603012710958575744376529215619151757');
  t('42531267340930412687856751439255.3', 54, 6, '73.5209394779550686401613113000309464743306618089382804');
  t('778.5932633849243297627430147225601360664389789994', 57, 3, '7.35063555108293761259064192862131692115181005254366689253');
  t('4333333333333333333348300838', 29, 1, '64.329281760192605822564697642');
  t('8004194091', 43, 5, '23.496378683184209935442495315385822870438');
  t('8113000000.806', 75, 2, '23.5098807310186311548566408132789930195928276516447363276058594016180615654');
  t('862.93288', 52, 1, '7.453483757689003433460872521310871353021728319575152');
  t('3700070000000001000000000000000000000000000', 40, 3, '98.71007282470000149833250629738477932392');
  t('860600', 56, 1, '14.358532279946244074320350077249431415699277591579624988');
  t('373', 40, 5, '6.61472380330538712734069807905030986175');
  t('37885.00861585094722419', 52, 3, '11.23545794217237835850752954036613313974320593251109');
  t('47771213299999999999999999999', 61, 5, '66.7293679172643544145090352620235764612720414362631857184773');
  t('244.4444444444', 64, 2, '6.192131058659396231924168116235525417323685573155993373447452911');
  t('30000000000000000000000000000000000000000000000000000000000000000000000.00000000000000000000003', 39, 4, '162.972715978811252882071879186286196805');
  t('729122', 34, 1, '14.19274353008611935938471721174377');
  t('893', 15, 2, '7.48773344793663');
  t('8752', 80, 5, '9.7701847019578938140306269651060199976048821340893142682307303476558056686812564');
  t('6804', 60, 6, '9.5184131286754783199219005857614557711174088445710501106427');
  t('69428256478096947251996885410371373340', 54, 0, '87.8265044668567747267894700541159337196332013668502918');
  t('40.2', 58, 0, '4.386859441133728137729739969457164287983748198530264406331');
  t('59999999.9990999999999999999999', 15, 1, '18.6030023007313');
  t('689457892092807603121002663482554287', 55, 5, '83.21436087452572303874062224859754091950298971441110094');
  t('3970804111111.712626626611', 77, 5, '29.703136917557267375169990360122262068539926083174777749434802378458904704107');
  t('50414113.13327141165729045000527', 65, 5, '18.42892889688810748384524564146722393452379799385248519278174647');
  t('95891238.2150413', 2, 6, '19');
  t('3588739898.086354266707742682753157086195134965', 28, 6, '22.69421415507189615620890672');
  t('88467584890590280582488', 27, 0, '53.5300703459319523413898183');
  t('1832710221.5016129293972911', 17, 2, '22.022208884123715');
  t('2638658', 113, 0, '15.47892819310388446550214666941956663688075643053708241251359367352912050906976681631927742152988559828017095759');
  t('1786396', 74, 3, '15.08885792092527508913524048216150329484990188301172174413263008971169256');
  t('22875914443644444444444444.4844', 16, 3, '59.08527399845806');
  t('766666666666666666666866661.6666666666666666663666666664666666666666', 39, 2, '62.5972415256661730932967784011827946404');
  t('103777.76798777', 11, 3, '12.243154226');
  t('58961996316390008', 9, 6, '39.3088167');
  t('5769260977747675203474551195320727444080382875531808825548963111549677132367746619868996693435411218633631791866403671224034502134565723555791563099193741', 69, 6, '354.741210400852930488775090946961251890584253346738387845484224202884');
  t('9641329859135147369813307875553.0252214817665086881400525400325391949', 150, 0, '72.0367590216816840729041770213898172222794079915865702561896407914521008669014785382513279140451010930321695767962254803492078774675977227343899518026');
  t('39999999999999999999952530137763727947615', 148, 3, '94.18284526144166328897016780519319120696093424404799082536781288852456076015928525905821094430401190363165284079282281148195193265398762094564431523');
  t('9777777777777512040240881322267051147543612415791737335333333333333', 122, 5, '154.94387555530892036642518046125609288063840664450845423927906000941524555259205067010196013799554929408932697742252209764');
  t('31474.36314847974634', 25, 4, '11.05007580544846263884902');
  t('8000000000000681265593.3333333573121383', 33, 1, '51.126875675114825760245915697248');
  t('7888888888888888844637999999999999999', 18, 0, '85.651665828050686');
  t('411111111451684902785982765504247507459102648281255986394987709935066.555559431142835058814620227305540037405132402', 102, 4, '158.682626840291479620381558686930498057364378653091371870052242364504572858477377847853204134154631533');
  t('576346768451315357', 113, 5, '41.58863308358133880463792401763859672393909489031191277166452974395927443387240567600032234165470089130821350248');
  t('68349440538766794118.30536405534314271', 120, 5, '46.3643122323480680917175987335352237426333205291432721562766874758426479503943615455706996174006862548194650599377218599');
  t('198.1083495013065625905600558072507610771481167268213442307684618221978606740405147733524', 32, 0, '5.9819549113001715795686824014732');
  t('7444444444444444444444444444444444344444.44444444444444444444454444464444444444836', 100, 0, '92.50143384938247366299848037666705199235757415756327536502916213162455448198811511717570744253483732');
  t('3043999999999999.999999999999999999999999999999996999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999', 17, 5, '36.34509601547007');
  t('15213368329504069322051900609124185206028387937847.78583471775890434327615999999', 123, 1, '113.939406180959049974734230399897489586099093291987479084192234705056167952455131844575906879899848692146914777024279819619');
  t('99999313879467966666', 93, 1, '46.7448421792120004795462713798227650121773308547958317428601736249357515261611483786925833483');
  t('962200000001026079020.0000008', 101, 4, '49.008901183719187340541348379809295364211442600287264078824696116715218623219482664546855141683651622');
  t('148791951.37610429302513926644226427019813', 45, 5, '19.5112067692459296257389875964755475021560135');
  t('511111111111111111112277777777777777.11111111111111153847970515823144627756580624042873713087689011661920155005214177777777777777777777', 87, 0, '82.9150422545044198674827101235298972839456446169451866541149090491972503205404925073327');
  t('47998.610038242153727179479264932016206969959699132462100251589608261341092913546617661412622932701103857903254492585241469357614899587863486', 102, 6, '11.4720745123855607064778487982855780378166444871148568237984096099770213493208482669807470836380315926');
  t('785851760865507310163617.91878063740458858563590474', 14, 3, '55.714202308669');
  t('47364324017285', 53, 0, '32.182037583937203537355453152604833700184688198563553');
  t('99', 123, 1, '5.28824152211725815139565594987875385416896196956981246451977365192026310533215652700224135146153625714043889715263895313257');
  t('499.88', 156, 5, '6.90751424969585392293953541908318975224494982388987612277851717480326895376803817738265038547032635666628800636238069103445267857651860096914335276043944845');
  t('81349250584797061870760666', 119, 0, '60.35394103380606083232211219582862767993353319993910124969951795916433496632123656914061117329536959506704639250851093');
  t('62784808', 115, 4, '18.64837087190520270799091873935786992530108861777142184574495398876133273141364367029861553777957111261395523086438');
  t('3434008559005080.777141447382284045859', 132, 6, '36.465651830372942440238225632276549055341315013300926525210584005230082047225348944944077357087251237606560909691028293272846801304');
  t('943162652634324', 21, 1, '35.1734070484840179733');
  t('3200755555.999999999999999999955', 120, 3, '22.5797999106921629812819624702843090661397051495827234704133312913186939122017369917900822282029602753290447715617913443');
  t('515555555655355555555555555555.5555555585555055', 47, 3, '69.108189759476837930170863307755652478684046111');
  t('8513555625052828598363422803386624199470363562955164158871585169383365148559138262436788130944099718559480027626297886127', 44, 6, '279.1450180124493791340525382214394203663702');
  t('63333333.333333333333333333333', 55, 1, '18.65706952201659580383008469311460204353554813381753627');
  t('3.1', 129, 6, '1.79745656826768650363900505309219353597478153524984078126195878737880094454847191781327677896317072266659955803179967359728250538');
  t('9093299659584060863269742713134899750465494201328', 27, 5, '113.424769485449513224036481');
  t('1050000000', 108, 1, '21.4652031816757884684177722482261066233609300412371144694007554132671545848811941937438220267513766719820103');
  t('5725662957131093072204723120414656205848634936868762013850212352877555', 40, 0, '161.3164769402572986499344763430727151956');
  t('901559095648', 51, 5, '28.2205386105780685718677771910840820862574238435286');
  t('13000', 64, 4, '10.16585181552432915341384345586810750661939113900768378294320095');
  t('85815410667430945', 100, 6, '39.68412217734485052270363448152781085907200427823044928220323903958647400170245897658798937710312851');
  t('855555555555558670977917296136739352872859131323006256787665242606362267919999999999999.22222222222222222203626222016401574941566666666666666666666', 85, 1, '200.8620460225653422427440635478741071967014832473027697642153674035135183493925054186');
  t('8059999999999999599959.99994999', 68, 3, '51.134347689953441547526199299390471237322975863844381303507865600214');
  t('3486539478.450171451612777703127198834487830042277', 8, 5, '22.665323');
  t('57108061', 285, 3, '18.5536030186021950395135699256018804243512756336090877638024288147415104918588377841521157349906964734386117524371274170845971074073616851135056936714103132696820388125746637572013174531497417919856852444272227657768154986365888153373309455979687239835031412918961348310964537999359268');
  t('3187855731000630043780438091642337349345142644991621388888888888', 71, 6, '146.91535654532489173837826460282689732922589098952424617111582542942864');
  t('753635', 132, 0, '14.225810625462048908924866351698424733206278962124495496668362783985319297344381995783287774992010091143288902473471904649107317318');
  t('65360000', 89, 4, '18.68856818907596679870120059856765839122427436548534027001594161362193214567150828003646');
  t('39.9999999999992599999999', 180, 2, '4.38187034804004848117916882176533235126146184467319830603391176128833992346694051030431118583662173748087574107043825164257058194331545091689393675098307727157613833576203636636209');
  t('4808987918343901600596893368235900813573794205928493', 44, 0, '119.69547357324752239173278566344498838445606');
  t('5408010014898259777777777777777777', 220, 6, '78.36633643996968290869475443801356092928426979075644708323899746166916100643744739095754810738412581019566868855490917642124551007160340115929554074198269272017970112616063804442304698021891826175222168647333225134594055');
  t('5537334532608604949028757684519663.068044198697282266678987250887714023336126384812163248', 235, 1, '78.38996850304375790751318479493775481879573470978124410255877825265638262552138890973402341482383001447954335158533605752713428309593630121858943570366747500915062968147696540344407106607658570716956392135937942492453185812136217606843');
  t('369999999999999999999799999999999.9999', 222, 3, '75.6842029760195859583425223471643736267989129121170048800579248960101539387008079567209354709731369906633877270372642015854626990369092438157811166669081034096901980347956114494255917906565642795918600976442876636356004299');
  t('39999.99999999979999999999999999999999999999999999999999999999499999999999999999999999999999999999999999999999999999', 279, 3, '11.2897819134997636642870395268367701446400134446967819312331111110313622971967652444636058108236532270080503968298851050663280919921783535114032895729032860440408387610637335367727286155854831811609959618661693371225344667585853220439485528118209179198172143719315396541096198117');
  t('79207837.0397323650927376478606390981', 107, 2, '18.880732984970994992769470543742458490217362388744766083020908891443598606434082921553276251844261208335001');
  t('1884330796085744171618182702334693708384101395678329685037', 63, 2, '132.574070223748531251892049931707898489382185954147307794359262');
  t('71999.89999899996949', 287, 5, '11.877567189606169502022605349148163159581524044599229071786656322936957638328752879587760359698581194421352469551278523418584657491339782582113707027055421570842276526246977622074068597209492739781382622055934987608787674297976794125138846784231492761567122790433219761143939105119839776');
  t('854281845390041010454938128876664191335348313172562438316286927048598592172206972868842548938607948234618253', 127, 2, '249.214843114006206864051649799084045941757711644219898072589338345966533569504072519153713562979577891079615311913074809203184');
  t('7999799999994999999999999999999999999999999.9', 199, 6, '99.48113762767656974236818721598884354406518612413691477242761149443027204714124560578369419210150670867740893289944042648785086523904974864308949936786236257577485996949632366023722422996105481682914');
  t('82793376132982.2039', 2, 4, '33');
   t('85340295502238345696586507721.955403106699', 150, 4, '67.3095914317993741083689775456708207966548644954251762534348017431576693180334369016640579447046537936208784096920149855495544329644479647066734690521');
  t('1080268652838848659097446677655799479957646245153', 138, 5, '111.294441407105024735788131066735095339916269848807500977517682690620510593845174479912481647482862243817182757330099230984043457036563055');
  t('6539499403823423238465132.8888888888888888888854888888888888888888', 85, 1, '57.83305003119863977115968584039168088437263982056245765590979042573813745725158736826');
  t('170005000003000000000000000000000000000000000040.000000000000000000000000008000904000000000000000006', 92, 4, '109.44530421369209780581165504796408715759166875475884985843867421392970320586689647591332409');
  t('20784.77', 121, 5, '10.63512296593440346913253874351365570927438011697526023641862924478285157685938268871786916815249619629282315099564523374');
  t('48888888888015150.4364183421996603869479354551535', 81, 4, '39.1214737250288461109194100401690219816512638040339039709101396131320781069205125');
  t('21907598017.0601', 151, 2, '24.50324653557682378700719657420514692383748586018341702430719808141571137668630452302562110521195016685264457009624301462892698550198766765073916420909');
  t('6257700478758391837989440337245428999927136689829872577099625877', 138, 4, '147.58982082115096091273577561457043334976481396730025060420825087012264750608845431875166646648975358370318159388994718092605218689019741');
  t('648873527443526978014061389.26506773', 67, 0, '62.43042723716255628683242710084397148602677128888490845488707342517');
  t('614413682.62487431747608759136911462472721507932942288069116207374491806', 160, 3, '20.92932619000696771953662121292379329990314154014133970973320067673300631737468722921469741746739158841229757015292727261804767190161428562519280191814899272219');
  t('4.5890154167489796371823906', 78, 1, '2.20472415082266547669293891148130580356150215352093591130697811562722384512557');
  t('4444444444444421131092245176637725244667.7706291360802217169694097999999', 74, 6, '91.985620684105438660676619242633777121634534828685308110796932207376516556');
  t('108888888888888888888888888888888888888.88888888888888838888888888888888888888888888', 64, 2, '88.27653852267398815492036307927913686737094369150333409033204726');
  t('788.999999999999888888888889244616666666', 150, 4, '7.36391309981269950433313062560610464301843794609202549791390814436230701932989960952815561649851061992034546695280337058476001665649373837014421663475');
  t('8590129214922680567378442752110795707461854123532964914868748653888684675670437619721947918627909280770522756363203144390882', 50, 3, '286.06172739719285926434759117235862624141424637293');
  t('559999999999999.9999991999994999999999999999909999999499999999999999999999999999999999999999199999999919999999999999299999999999999999999999599999999949999999999', 133, 3, '34.65210508021768843500674156785039493544728113373646934231937477056172566924120713309803898704258865431315216531030418409638863287741');
  t('11600812369159439627423710726062092106663.63232691025283623', 121, 5, '92.94504093481202186184164900262903893893552998858898408735740181588975611727700149631106895774101185497338703347799070009');
  t('34005003.7602792994490773183690546', 108, 6, '18.0351654217320032829726571222824391328393824341969055878447447477327380708485879361940743936010736339958869');
  t('11643.45370163656827051068940176144637496491521', 73, 1, '10.05564656575426386072251906640308575904982436709661519373533956851309961');
  t('6', 78, 4, '2.47788873028847500481395074507450544945639765729473202957479273981302913373275');
  t('899999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999.99999999999999999999999999399', 123, 0, '242.359221429276915830078833882477105567885036067398143665056170377395933614851570593896804165942105892682591079550256275094');
  t('58473481613275520003697652728583213067895245986790460645323722958141804205', 66, 5, '170.54784722183895724631957411289880663886607996018046197321962591');
  t('1999999.999', 94, 0, '15.20180491858410222281735046512144982835572246708599977877159673465720290860338001910659561605');
  t('5592918256577289695168.9536129633076617725261929698426400032', 45, 2, '50.7689353338586450964755315016740231029431448');
  t('35.4672167591542557992378338583260980283353747968450402311981028037985136180520122594451983777833634201897123190085370112230101532', 48, 0, '4.26155717930188460715437739143711948118890841155');
  t('55555555555555555555555557555.5555555555555', 13, 6, '66.88032821249');
  t('55555555555552184821996972176.43075165111090221638788417320779419111111', 122, 5, '66.880328212485090464545198664021009503338437703124747123574734718838856742725723040619315358528672854158889815409604771011');
  t('7942020578650838466612.01532423934255852', 110, 2, '51.119601857257560173019773187827904647383980415704204332360235216196895633852095028527509188793508500339025056');
  t('30862.6788570822046', 153, 5, '11.0304501092223260862292986286556451941814799452059776325701249215933027093854872556808819661607946516026732989929169032661686122578468745497309943936919');
  t('890003143048357687308938099178599420637313220187789927733372704155783816461982', 46, 2, '180.1782541493483299860812289206792496741789997');
  t('995982196.50966571238', 64, 6, '21.41238712095876263464576406617698817683504240059715324751405457');
  t('25555555555555575847310084192844533333333333333', 22, 5, '107.5503310968789778763');
  t('279', 104, 0, '6.3243557506907572870885029268461322615499808849989843121133777930290171132105180622953534921613632707671');
  t('90000000.00800000007', 111, 5, '19.0084674089433733391321813020303613252978564852602103448246490492401677317823582027792109515618390851860181955');
  t('78639228446728915464562950891101829870182254745', 88, 4, '108.6743470298763846912264870103915482230780260387746588747326821681852408542416375628049');
  t('89993999999999.99929999999999', 153, 4, '32.8239112979297709174037925268138656106782007612589309581583480566845461351755778295105518480392080050457824787922604416129985853866416830773450325903124');
  t('2278729913692.012842937003080789', 85, 0, '29.14778652884360041397291587671310565776618893179212443811876288537019747393036396877');
  t('89', 149, 0, '5.1817519871262655543124356199610887882284307783664481769021802048653824117482286534232138809302224218805088959787900246793617894131995666816742413182');
  t('6555555555555555555555.555555555555555555555555555555555555555555555555555555555555555555555555555555555', 76, 6, '50.92774700000440474162061256970447114246699706343214949579455552811142455228');
  t('4999999999959999999.9999999999499999999999999999999999999999', 42, 1, '43.7491167668788679963418056389929197737441');
  t('3', 22, 0, '1.762747174039086050466');
  t('804322500528653940703514372772180541695', 28, 0, '90.27621083715792625725581342');
  t('5444444.4', 110, 1, '16.203253451135352867517519541123253817812728332531788496023975485605748894859172319170947867894438150953659017');
  t('899999999999999.99999999999999969999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999909999999999', 141, 1, '35.1265630598128042684596029608836849084772601154999338467480169107990809569671221783269231057369689770942822474074003480333926549699069091634');
  t('233454417.88009828', 44, 1, '19.961644584071797872935928057040104101133745');
  t('7', 110, 5, '2.6339157938496334172500926946159368880539639429350329595369445138409203708328879521484380269002035671129308731');
  t('5972206434306133092400266891.722709723671404676703', 118, 6, '64.65006113750919453759069309604203253273239625732236551071122208256964030112189101334791363820393934022036965895811648');
  t('91753463779946944869043836789', 100, 1, '67.38204992999124959504054908088265148425555831951628190558967990459140365907923461861838469942622257');
  t('33049121.413878', 116, 5, '18.0066527209247836665882812318777789898646141170829020294472657116829080980561692618962716688014063838914985157769');
  t('90000000000000000.000000000000000000000000000000000000000000600000000007', 28, 6, '39.73173324580089563649558587');
  t('3922487335', 106, 5, '22.78313899431803639615654372238529649806176914668842657897268458022125686918628826905431190619947270687498');
  t('55555555555555537', 40, 5, '39.24930709655660259553335571047344846852');
  t('80.1514206028237610174524702', 159, 5, '5.07702586644180780803079710666434604723135859438145239668836076836635246162979243230413653114889222743786854223098420813626293208600824644101608067560884669054');
  t('96217701624130066577657709.036196520020678229792065510656314668', 109, 1, '60.52180276172804331003521495055250329629740547879419081456915488748736877101064253101650383476674515723632112');
  t('755555555555555555512527919630246207741112832545628837821481360271961333', 98, 4, '166.19897191097707619093118544932661296279483812598856823703515231851978930278940487112238425552668');
  t('49747573286', 152, 0, '25.323374701750410307309233139926722374055883642487698757753873269915225049161782712086418386850883077274078337706044681945263431417117173802994863586543');
  t('88.087360196941062', 27, 4, '5.17144401150508240878313913');
  t('7999999999999999999999999999999999999999.9999999999999999999999', 84, 3, '92.5734073490075629143705952185229103687449585939631670817825081632089062652955255877');
  t('98937224505092379001687046669156404348.8560468215281389287997105753893757654035960862809973093979299', 135, 3, '88.1806960814481860066893559869516176018657227840558910436689910308476482635984253401529303982257484939855630020949960718922588286860145');
  t('1', 59, 5, '0');
  t('122222222222222164819807946719932815155232829957311601393224183113642130183552646181545875371633371966476827652286514531', 58, 6, '274.9014439423135323991735515334532988168784570961539209306');
  t('65590000', 115, 1, '18.69208098382986348027903520927392773951028645745182907254969323801996559609439502570463765685214803139328985414932');
  t('600400190000000000090000000.12', 123, 4, '62.3527858286319947454357526024668611205688668090585734041888250793465517933168281481158717765926017487812237004268849292128');
  t('67777777777777772345700930787574967155365092096224024877903254', 142, 5, '143.0644871400338238203302133836508135282658641710099835509346010583034084445668878789643189338006515612602742866911442511254613455200815806388');
  t('8999999919999999999999999999999999399699999999699999.999999999999995999', 144, 3, '120.322211491703605648730224821700085345453607831871521957549706753135579622451122797324460255183794604673158645854794700935136984239123619538046');
  t('36580609807769420490049844442514580653545.2600891033349457929944005058', 39, 3, '94.0934841206755360018174453967703337945');
  t('500000000000000400009000000080000000000000000', 158, 4, '103.61632918473205658082761546095606932764940486046258210841292645640626965150146346469259656676923683554588889939759397549342852937830145827034078780631609856');
  t('6.99122541130746456319162411650454549346654', 50, 5, '2.6326484800387942995543793641395730147339926108367');
  t('8669359897151097461672560377426128030037391327302055843161339247258136505000000000000000000', 140, 2, '210.08560050846594884469820426605147546571100849352829812125233385546705169832908584462677081042303393931773055674380404426500355591451918951');
  t('8026802952637172050888888888888.00000000000000000009648505662518690942760643381496178474722306762889587334404685643469656886754623126666666666666666666', 33, 3, '71.853486281158831647953372138411');
  t('86449.4146014547980102609103871', 81, 6, '12.0604619000875864238741471909201197416949020319207145814138009441402851691197584');
  t('1061673432651413342226759435', 156, 4, '62.9227910647189511813907400896382179147189733804413330974134798853085220343357521657730521073102099954954717009227286541023809358929659857440475615521013599');
  t('8000000000000000000000000000000000000000000000000000000', 90, 6, '127.112183743918248174640467038788373482761480923394761722282426690222495410455812795167302');
  t('1999999999999999999999999999999999999999999999999.9699999999999999999999999999999', 77, 0, '111.91037882483408345169805406776583510100387172290159835784109926543027250846');
  t('2810804', 70, 3, '15.54212830194147725781966656961241186760556152664006569924377706641191');
  t('8016079112', 157, 0, '23.49786243106164165512953717820603688865850200450632174887901591887650079066379236839690285218215186712806578945925635622789691179633938194632967355377279353');
  t('521.1', 117, 4, '6.94908822181683695358755980752559433466338405950821820051761506254864728450753584121966839327289195244674796175983085');
  t('199999999999999999.99999599999999999999999999999999999999999999999909999999999999999999999999999', 148, 1, '40.53024094201866724714029897255054465911972557520965110080768433543101888319396492105701238380460428017433781028945672286032959327963256390262970853');
  t('76225.1140047365844', 145, 1, '11.93459344800671341099155075936791310493278569968870849712274005650502191627758251249763144766389419997178041262406197314511397678862463893739381');
  t('55463129055683048735127251212137527', 122, 4, '80.69417370800430588297189879688212814640012615956249510515316759421263537063778648594990496494091244561485241607340942064');
  t('1666666596482.00000000000000026969605039', 80, 0, '28.834993878143683314178880372167960588515244276913324725226026472908086982002409');
  t('954519658818723423714052790288311111111111111111.00000000027702596', 50, 4, '111.17068460417941716123653112224726475500857212535');
  t('62761726', 37, 4, '18.64800316760426088167883940702895016');
  t('3379', 144, 6, '8.81848224537829298437549993531960545708496251006001900805651071047950724745095053005651159088560562782341861713654034310473845231263624835176381');
  t('69591151729837363247150008302381626834589694466267844022704040766283323', 24, 2, '163.814156026089298884897');
  t('493.6626254463323566969635311891255614', 95, 2, '6.8949984941531577481063486952883136541521363842266955148242250212284777936516821338258448154442');
  t('165734773289023156091554326751689109154278799293802237303303874601760181291120374605881483308342', 111, 3, '219.943949588326014442379191458736655223849625904535435435284634824138545503607862493984196428752329432979756531');
  t('133333333333333331972709248157568733733141683458751663923783544751677362792395672252679104936852544611416822', 18, 1, '247.357434203374614');
  t('771999994999996991.99995', 33, 0, '41.8809081190187188852058005380962');
  t('199999.9999997999969999999989999999999999399999999999999999999', 6, 0, '12.8993');
  t('126208179536.04054487537113394574225', 97, 5, '26.25434577958634939168356021578568627788612023943761645009691354224156528413405640641195662114902');
  t('30.999999667', 19, 1, '4.126874127043592249');
  t('917893.7413272647205592717729684003095843500806520527967061', 133, 6, '14.42298409327454128777882930849573921410284338195742873802134082509790062983979486213672568481721822713540139363818634853210139854567');
  t('66384371030064505555505460558126992784161523662278763117861706411465254238432895875485786452387466666666666666666', 77, 4, '260.47555415562286825756164014717136511101075476300643292057704002794185892881');
  t('91180.4059838166054267878739048620964499847920442765739008322841353984728', 38, 0, '12.113742486840768486861564087882615446');
  t('16471761672405948326255', 158, 1, '51.849081634406252182993176865304866863176638554727700982572450389893059327709434184118962101992185318721668897822878156142517619356713531459334943553498574122');
  t('94', 65, 0, '5.236413668283698450678093565766582167466676104557168467810019853');
  t('30000000', 24, 3, '17.9098551201863745111606');
  t('28119222714104761853855261525875417447624335757006722043419902444595032538986280900368339917156316829375113559401328', 142, 5, '266.5243012066956584907438574654876469275641656164955013648540630021506498566980712883225825048647754569748713150421152249157374126899355785589');
  t('9200000000000000', 27, 4, '37.4511270595256251953103296');
  t('15151.3', 86, 5, '10.318988795307941984173508890947735121210019525738489930495859613795435019227245657008');
  t('5666826565158024708924052510742627909977914517994417167741', 35, 4, '133.67512675359138077564204174320199');
  t('4982150688393', 30, 4, '29.9300299594373024933327251831');
  t('1', 104, 5, '0');
  t('7.42', 10, 5, '2.692754195');
  t('75908229889882877777777777777777777', 41, 1, '81.007980358583598146947065310976220120797');
  t('4600745727952166.10150555555555555555', 3, 0, '36.8');
  t('698875.1', 40, 0, '14.15037450197547393209297146362851031997');
  t('26666791004057951333333333333333.48242309829946266732', 52, 5, '73.05411897902839079697648505893145940941891547806172');
  t('7813.353695394136209478621754456705447342693586537733595491483417245474', 137, 1, '9.6567367375500861611790810593418812457139286401527739314061759233556200427543929103244063018646143115466936339614195995257487986771378084');
  t('557286644597768434147557134788198014821821838141587294604108481.9765826565758913834896335', 134, 4, '145.17133249001546084146767519454988711119353582499683341388149009722031106776784227960608347004778277975561347212866819677152085086799');
  t('54444444444444.00000000000222222222259533333333333333333', 243, 2, '32.3213491102569382658060299636459069538765031480465023028795003642835084665996971409087298186164499785489199643590265786363108190343280513298802247153035219051792250694126014893361987052862384950809399928027883944417785781325823439485740469256');
  t('2000000000000000000.000000000000000000000000000000000000000000000000000000000000000001', 67, 5, '42.8328260350127129311583104272349088729083270640384240768412622364');
  t('41.352378197359997278133542232527149449873860423141998864', 252, 1, '4.41513088495639176536498633424844538036615656178025509899809722824623823360877616891381163278361573622135252031282645414530162383320362274334178975211726804072471650396705670474203891363728518773084973041331219690553183054548299613712947836040574031749');
  t('235919548901597385', 90, 0, '40.6954144278937505419988778354922116315997358692389299473936108523236129095281274117676069');
  t('31.819394645308010603248322281975569001345525802368770942876923854155539175978169497024713473821191726887109902914808118356848389197092828552124880672067871493474981572163643902069760852595832181325654036471', 38, 1, '4.1529761674868951650187343612578555121');
  t('9149020', 107, 2, '16.72230450825048551165834283578453065337763958750519766647822494673257012144697405409289798953277817826004');
  t('290603217666136586677856271256889481337274904242856429478708818232494546257647117571818565808763803208502764171941186193645655370197076453515316718718003184175454305827376574795437832763', 215, 6, '427.73817802203705555378622431879777877781706758243396472078952663743232573862671579006554868855299605860444369291539532560392567894651714880767820778846449046124106003212183730489215465792321944648838797707410776416');
  t('7469492381942566847992242519349360799753803320569858104462169466449496126391734957565', 71, 1, '196.12112203467095980567058374670264390727490722240442944396328778377693');
  t('82222222222995683403878888888888888', 260, 6, '81.087880858234855897341180599865871160439423334760788910431195956654952996971775413983368250861192064980593063899274559940257045144596280175036364857854199889181569013594879840893997482064032451677575409688188582233308643002945979666638185316756013899568159794');
  t('744444444444474444.444444444444444444444', 183, 5, '41.8445618035135089131101310593662187653588744719702560010849320440472083590799874232906815723468058529816201993580415753015090052194988484437427574642950054989456182964553455569137823');
  t('612.508', 23, 5, '7.1107085177457568181265');
  t('592650477679495157795563506760263456011888888888888888.25286536510951911286940333849055211813613499268116107137327148681412417782166469398746536313678066241456311503667974386639211971037706784650171747468914451714269731111606567633413035', 75, 0, '124.509591734787526043476556817048568038049116854086166195288072356161088676');
  t('810845908400000000000009.0000000000009', 229, 1, '55.74551216752478302045881765121892669532306567835709955896281646085824322570809789409285832439116992422997870545366474737084801047264313591717245726027076462366245681861534643903809520175005115813060645158290935227254738382125537');
  t('36231896', 226, 5, '18.09859757438319764005274538446683692992741280926390777611454430894634258337814145614258292971267599486909246418909251025388664873911836986475583933223469111502212210031954912573250979985040196986501867451553304025915777186553');
  t('6.2222254444', 83, 1, '2.5147540907260319117734468037221843429209367135209839243080601022058790098769088493');
  t('15111811111111191111111.11111111111151111111111111111111', 146, 0, '51.762910764291252803099366270042712063444478090306240252765099786104736098705769640196468687358245844917978556426577442260227917989316741408807083');
  t('25431590230377924980428817021594698764581546742156641005406310922187189262159.250939977531056629520879988932670254171976851278', 320, 1, '176.62302126622882156448441947278313601417412268635109619942905690964428906740706034262509910102119532364572050440418403980291821215204676857683488329789968073569476436740714841015171851568122150106090804662231736136660383553351165407086885411634789685571170365620793060988151056221342244789830418053017534912546709752757');
  t('3529893667853713333333333333.81146765175947156222006009954068253985345293989887722237076541976980577777777777', 265, 4, '64.12421243946965056014827706567205068851151675089284982577294212207825720604062976686981276974566837651717551852994352354478363122324469161879141258376593048291540136665855625509720777377160870509458809855845379306566853809704400729632845210598590229544890531929459');
  t('655555555555555555555277184571775444034687418623652297772302654113666.133783637421383021695696237544342612207267035476665779245697505875858978181885164', 69, 0, '159.149246370724551890465786306165517543161510464579266794758015358981');
  t('6666.666666666666666960666666', 51, 4, '9.49802243880296361609434673186568175927384494534887');
  t('438792838510644769071637662774181', 305, 4, '75.854727378026247322009246618351419220998085468471516018077230348062750941943046951017158193695565934054827633862696487301385773329048539033421597191124944257883871195746795903914247678510412413266964204426733105425935851791343180083221746974728232156506814100652995129096968794114044888129705450449807257');
  t('3346100300.99999925524425616833', 248, 6, '22.624208596011424548228590851707167272038726267295552407594576715067257316222801917039905817985102172415401711744989822965901928389761212394816185073124522868687590292732478578767945488716835725698707270756152285843721314366685295063651835819339684');
  t('106666666666666666666666666666666.66666666166666666666666666666666666666666666666666666666666664606866666666666666666666666666666669666666666666', 301, 4, '74.44040867750697836966588258704182413943960952083074433002255065329564568234748621297884475244213417881503810243181651879540607433035169249192160359251612393074362004238290991979817435770822525984303648426201945987054177786885396825835325332960567887108359193571158556803499705906621404297252973905998');
  t('955742079322446192041319073560203.69279599885', 315, 0, '76.6331880555287248672280010156031798512672164844682590741248824397510374374175921182764509971982091731894924514521462471326753110819429917849160417881189684292259655928463215337823408448273960759418364857346066178714001797717712674147726988086790501719044134261418307784264482700347590864367614808492449812166030306');
  t('77779815944145367353414506062', 7, 1, '67.21682');
  t('29999499999992999999992999999999999999999999999999999.9999999991999999999999999999999996', 287, 6, '121.52616763811264013374079011997748175918995994194563023843940683600450447652571325932494959779489873592431729284887620951407285936381791765144784938404415914907669779274484828027938475825417806459751250389217856941894982370790732817029352465679796005767843979548258605267943195987894193');
  t('4.075073580444590926046181762057201005319810165125', 254, 4, '2.0826295834145035625117002428182579926771198126853779841729098301111631827656771755635580769512397966207296633676475186280383353667509079921715775117373047323607675899800906905227462608449770619738736084161347725274933608842114100203285439205755587431379');
  t('14105444444444444.444444444444444444444444444444444444444444444444444444474444444444444', 280, 4, '37.87848442913709879270772345589471749573509500416055677074064663396054396434178393976310435009747653864504531473599829635858664795938093264488415863663422684600211486888298239963453748567264547495052822495154211363009939514324378324322188965429313713076901237728153077966248641317');
  t('69120040.47558267719', 169, 2, '18.7445024486040882096839396208928079839291109661739143440641150116153671718070594925595017335794762609597386966242660332544684428121077844560066320674768592492121557831');
  t('94216254551051396934421136689219357456824832564555564759904385149741099174397514984595879105797003366536837888', 292, 6, '253.9179299442340360941891279653701787950305647595034420368002965770140913823836476681910472969106820444832455014815424617660047854427062885535330470393649961107497811846146462857063448989907367987171181665985229865517523207563290353135730669703259288169587941247439193461289565606606472860233');
  t('940000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900000000000000000000000000000000000000000000500000000000000000000000000000000000000060000000.00000000000000000000000000000000000000000000000000000000000000000000000000000000006', 188, 1, '428.91209907373435506496584257461154104364972467843496213157420214382696563807804686724590214391462769777103743802070097116928839800201284062739572872584365068865121393715310134470324337155');
  t('2214.70734209058848432228614', 138, 1, '8.39602267787369463499185550598362694679949128086854711554521208382127230307690613867619826513493199394895343759258019678321128105654895101');
  t('905646', 291, 0, '14.4095509607536745566618767219233413971741575009369263605495645180305077380914690013797224950966619297588100045288071734682274262154384494052922866402786859520707890354345522524690220484285022841888857666006487918421770262073334185456763455279466034085991215216010346313726397965351176001238');
  t('4999999999999998267699', 135, 6, '50.6568720458690047019356120030559525498891407198191430607869080434111835680170038515033758694073212217004946411905099773898210696685681');
  t('22534298978112638626732152079616775080', 288, 6, '86.7012490758664429212618438076404354731727132408895798168718199637133432826286186626959043635700253635273677394296756342580511896808074359621920106982821322893907848099978936598789326179170242907225746702056526839138723462389446267106880875017841913870640138546800851509179674181296074');
  t('4.917112661372375326859164695345725705160924123187231162813004513297861168345305763392', 166, 5, '2.275364540671013849083869958635327771129857098551152861323888875656694515544219462707655737608174646441961145536966879929862487060066703065620664460443602317374762477');
  t('563549067354.51758770352', 78, 0, '27.7506674232458961891792257347312452385053979867196267238798465578139019421016');
  t('830812.993651609354801631411540051011838976114467285499996473519956125432980902', 73, 0, '14.32330719134868527537701604175320796359242581243643816305737932515530472');
  t('542.123', 78, 4, '6.98863924288436782261099486422728862733151811025649318491610107479750101594563');
  t('4382055.78', 16, 6, '15.98617570896379');
  t('15972666666666666.3333333333336666666666', 81, 0, '38.0028025035116891329653684421707098538237799620494668577438585114569810737007871');
  t('70', 1, 4, '5');
  t('95161111111171111111111111111111111111111111111711111111111111111111181111111111111111111111111111111113111111111111111111111111111111111111111111111111111111111111.1111111111111111511172', 176, 0, '378.26750360720375122142020384935258000012221498851140673676454661882508658281792842440549608953473119772930181586919377961114781991499424409175992835312148932511364179794638734');
  t('192187296866691881394562541736288097256116', 141, 3, '95.7524362083742070761427721614390085082734503013373965942528336014770346481829194146350591229671181900295217818943865030041644129855973644356');
  t('323343462801822361678864704', 137, 2, '61.73390452300869992017775037776722086641122218057531819833790910615093187573711977767569486207987692346062708286660634627188970604522536');
  t('654643679490241446537176289187903442597521184707980054830550.96191815035607607', 151, 5, '138.4245885680554353155343875067847949346288236543877357189120109624223156680358799670898680613325865447043247851566631003024241080218713773466251052099');
  t('97547.66057000757781426525', 79, 0, '12.18124354444197943400829624661626747711710103990407237629198510069337134957426');
  t('330966422653907014432202974912208756386048736844238214052539496507126006287834443953802244470709874286745385', 136, 5, '248.2665988730329924099709903958246239724235964389697534816194167032520539019019323729460933823635273823634739208479626212602340802522772');
  t('48700000050000000000000000000000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 71, 3, '522.66047213533546236482471645884829420553088172496597025327676982280203');
  t('4962019999999999992222.3333333339999999', 267, 4, '50.6492470493292003079438183167239651756644302466502579021920017628824910170672741213328788979076932463165367951715992554968989339672756935045573898707660419105565176946091851526145160691885299347514958242470836148659855690389545771334274212479486772440520095264962456');
  t('1191006889473747404.51823664878977', 207, 6, '42.3144779294219180903135173366664918219761285269250416062767845401760994831165009061578024678488315900870803917137805077959158110948619518500533015950665646260038484083675453365745156213237719164236530900696');
  t('237.4303896260746527103755309492622981805359928199606649703696371421715634836691994496724537813789733813909044205433675059680949839552229084375', 114, 3, '6.16301723000056716935267577524395056851072759397696230050371528742991419351531640965701891368946937728378211546652');
  t('24700135.4', 83, 6, '17.715466463924502125396060207294420774083427443712580997416255278232299071806025878');
  t('1.7355776652', 101, 1, '1.1487059001828354452123386629353234548373478311815798645617265492201433389979864829891874939619314234');
  t('1', 86, 4, '0');
  t('9515555555555555955555555545555555555555555555555555555555455555555555555555555555555755555555555555555355555555555555555555555555555555555555555555555555555555555455.555555555555555555555355555555555555', 100, 5, '382.8726154109627458789965714010046933388660941963669084277638751033711704046941435744216104049094664');
  t('133821337982', 7, 5, '26.31292');
  t('34444444444444444444444444444414444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444404444444444444.4444444444444444444444444444444444447444444444444444444444444444444444444444444444444444444444444444444444444444444444448444444444444444', 156, 3, '391.066790523702592771596461813812162486074674043587013530104940427953011806020911429939374985005691373765181187955120463976087197574917636702720530635481114');
  t('725334.1', 275, 2, '14.18753483583406623913270780877061835709483368669615029185749156218524338492488999979560314505539666814313073998165140693348638437794169321497908415093267164828921736525350977179323552514488716902878059876091064201075555109094078802633030148939839062104439545316801610030509');
  t('6207254259312229204740649583533109215565090044927756723067876176808758406734535823', 242, 4, '189.02825836298776923699640740130164604845899118215576388881058502279222267754769931963253049257492464383753294560858003283808398526605587566182248172141111139116801224789049032378817029080477146928410168220053495149822339607504310797169254655');
  t('89.3827077131143207089891827393390733153527353973', 89, 2, '5.1860431245570264926479658739038443900371282695274704261677530470734616111926055907071658');
  t('258850.994666666666666666', 152, 4, '13.157155045516184712918040660808015697914645982590791458360826916208061802759047455378167628850495560523540196620765226459247134226130222578672061932208');
  t('153854799109377965.2383191698385974176347999256869452586', 316, 3, '40.26793287018329744396075998699497433504679893760787885707096084877788531578998026305586601910020123952346554157847686441319862606846242032723844526737646785521547175998220738675195220107482660714323110205749047075835516328052487023362592293480914256809770044319921258669068732877284549722409603292984950239179563906');
  t('5.7335690145392405850372718320100204070536531426', 241, 6, '2.431792298586870982677248063204433892405320289708503940016875565597398678525642587848022338998704158900158072207166690834438020139794755586703421302392854029136957949690823433716363867284811228918018359290560575983858237031864640366869850967');
  t('63555385871759838686134965170514150662285896579178816988711069947498681592454493584289767732581761666196.031596482273029606405177978026925513118', 4, 5, '239.7');
  t('38802526147092881', 47, 3, '38.890408926864334293806196801446769472715656777');
  t('7', 176, 5, '2.6339157938496334172500926946159368880539639429350329595369445138409203708328879521484380269002035671129308731312099586396196337242127430654535266914198413538116622575525139163');
  t('71013267675.523150292', 39, 1, '25.6792797457592370816398719022588905845');
  t('484387062023528883135317694331894980084666', 122, 0, '96.676850109367406889398734786308993889419503320642296892816976765071543843731040630014418258642173763250841666933259390194');
  t('531', 101, 5, '6.9679083151532607748875067986301174410719856662951782808223909983724535009425668721909679103898594618');
  t('79665277722067292654443647225158', 271, 2, '74.14853379904169683002416033866134366538640306675167633548563793248866976934173719714179490512200557484226611636602052518553153996635821205097146979695421564708149759203290257120247538831626669198157820555674504818219302531936511451021909530017930435205857501084646075378');
  t('3765488.372', 265, 2, '15.83453530504258576372283695084592175826917919557314581051384998458390134475577378386717348007075867047058217343146057606309935868315006940476486509177238798268708696454849769942720923682946004957027929622019662100392731836399730417829527161793478914270125161489897');
  t('226533333333332333333.633333333303733333333333233333333333333330333333333333333333', 232, 4, '47.56257095558243047441954050246732610924035840777391113644368236494041140410630192492210082827341080242953865665196719458928190124665088508739733729274595894315790221184646933330301677624947442858083934928330528638687243906204478079');
  t('58', 151, 4, '4.753515866530498973336682803758840998091535204533907351011231082608497251484701831156287133853557651574450435839888206020477379602893021122283593995385');
  t('86853665.575021029268673543160555450305308757466860937403404238965062211958709445745277028296828256192665541527422129923878798651241163456331214739977894166395710526431264083049704974123960407969154871660044144087173317720957262491098586841005814125844', 244, 5, '18.97288243613555802370085177707039499115246773505239218086610190877157862380772604106135510777257344826974097988619358377668738023319898218961524894058756678238347797528670353532170805084405171184933848843278705587211540703993932657618718440685');
  t('7636672.6111697', 276, 5, '16.5416197247371428955079978560217295868052532380197586973624111681447361113829510105660544038481213496357164253911433824120514922732131344807254511287421865860365881670002968311773010364310722568132879260759367705145293501165019124592052033336818820178804031727317139090160145');
  t('58888888888888888883.8888888788888888888888888888888883888888885888887888888888828', 188, 1, '46.215331283662715757028142765097933062236993763283411646822822694837622031963639119021242113167169969668392027478373156756578333332067868306043903144956190635346232360552409795117770748114');
  t('300694344444444444444', 189, 1, '47.8457731363037825241702663285610676133470379383979543455097196360734734221303654154221802328337759926657549921506999256357909133537625953583388229226822706475543982346375262024177285140516');
  t('656317923028770327', 148, 5, '41.71856888577865287888959769772967488412298111687072227501742369691120003694584058508349765347076162535190925788940572417966462991891709476444035006');
  t('542.058040622449660038738741098384332687483273608346275720465043379834129064507452980505344936412756539901072341687979569341457423989', 95, 5, '6.9885194114434527100126780981691771829900564062968871097682386585733388234916989496169283188651');
  t('3440116478453720606809618172867160659724417358097318944544243609388888456031249425562873', 317, 3, '202.25355560186960586921376872328853575060231892815547628956802768519204700837226965120454453410207984266373462665789788325406753800278573191954414605283387943533367441519728347324798077972573245029984016325508142207546835000639384729748097945917532141591437307350063998663042697410108383278480366622005043490738732917');
  t('3000000000000000000000000000000.00000000000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004', 230, 6, '70.869312259049425521352220998911628500756035351046193986855211344380288427731100311781617456720321948817893920244004899367227019895654334559555575176847285538502588441630245079535529434035655539386707659468565728652323714120644132');
  t('60967.25444710416620109', 175, 6, '11.71123936717025024271587431855508032407744051946723763258896101476906258760747113582798774090649129104607800122720527552545399434185358621361599695033578951364813002032224424');
  t('19938', 74, 5, '10.593529917513701495849272569723843245989885916767490060715350710923228977');
  t('2103219188158375579949', 136, 3, '49.79090325114290003906297116015407685247227077913046356766489665760209126755884808073468177480358429385958101210723737076648888607204765');
  t('365082.699', 257, 1, '13.50102636006174214748564962210927098456013936667037668210841375238025067983562806280413885512134462710674906997126939755874068415054964250255008804624694168097434538539480177009377040119727678494920988279880342170663111877647382779919423859353260101652462');
  t('11111111111111111117421873530891952679791767650235777689438072712275431774239076370880857327116930490879634543822815272535431678164042038340441953980667480904639371685123119977187212655555.768825408823407476666666666', 314, 6, '431.3819200861043145225771037460538719288075637940536773586256518344982429522488208428677682352964452456149688045683149394415729591217760289704110747127445700708251804364566297605113100679122127215241370021379747866548522081624105735340337239217001736424998479156184141336756201729642028349787566154248807107949352');
  t('26541756998370332235059097559', 308, 6, '66.141663920009893790748922544701136082691101605354596399792168339549790900932135988235091610917239569366996220170848276790749044330985927376944477554430726534210883558735530434531088778070642805734561569242684057031979025659125878096263715047334960018407421659095160290228452027517182783312811598113991782253');
  t('539595952736418745904636627.3845345321779880738727128305218872996', 154, 1, '62.24601003623403847062583147777887913964725692883222302451105993400409923243806622674349902632713631111422513780697167846196724424816065625407458524749715');
  t('722222428222222222222222022222222222224222.2222222222222222222722222222222222222220222222272', 208, 4, '97.07629897110596463449974570136331187860035529623879919538967612451627994208191823672510103900634593251703413957681760360491871897408398915570769186004711532580468652605264155826109721304818219961456651802889');
  t('353274374379557968911439246409153485604433243941458861816316231763007146215181500476880733709870607654815794670706737759604802378233497955840', 225, 4, '324.317135033289230714771487099261732195653565834562935403429116180471211102880862597019736617726937616166289489101765588234938391697330584640536912505502588016262759139336286970511226422575180933863863798395001923350526972634');
  t('202256276247211699784585671557897404237579834111111111', 140, 3, '123.43452251083804596320440045384375298258854224941389205762974059496196631684945589356542006646029395230026283266866717497333588637951645258');
  t('40000000000000000000000000', 169, 2, '59.64406886653097802870148273148363489425403761880009000694523755266949610784289615271752010822921352117516242302511827303629469733434456058775519648237477011014920536855');
  t('820', 248, 4, '7.4024511490155382381110394301463133553047619307433353275313423818408978020332598750663253246321467663029697100805314346225417571696368364737000513166418620314588116771268477321838976878557919327685421516790738020173763491074643981529087434783576277');
  t('69999999899999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999.99999999999999999999999999999999999999999999999999999993', 24, 2, '288.159608859448352003162');
  t('952.496', 224, 1, '7.5522328125183829390644656560359888055483789525096321092851768635601462315101851755900438502971137109985702490588908777175214066705273797465108083234765144879814317545062856969722503898253304619428863666001963228146009617737');
  t('20000000000000000000000000000000000000000000000000000000.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003', 239, 5, '128.02847447579240323982399425055638455421158214330302419007439457220328077619377584419157293392074378389223108436626004630489494105107063273071114680370314484542135159956225031678960829269060926600388949222382477120506477993490165147326772');
  t('3728320804898809628202740817939338592021330518014656737696146821466343469507787823903', 301, 0, '195.4262529379970006247382109985131288682391926104299116037301225764435193523761291431157691436231466739433619544855277282053735634120379939115675699273602785877973782935500392338790041531392784333820432731195071576150014130109772261284241158421195287339201471502283960679141871084416638821846762440534');
  t('42222222222222226163887', 305, 0, '52.790380808819116837804031625067795052666596363897514051985548658113189353290738618937407102026061549501887592827123511600955892349084973569499204504367749440458587352187975716354814968617233716243211317204898051698412256093904839306094560410158608068756213158702655901120368275449999909954074087471666329');
  t('949094878175839592034742591696099422279800950248123487439903778236935090775370353180895545683735351.3668716277537493530078753351535153130123983633762352439709440342902330714537051510276874417414029051601544597556976912157823577418328482108128796394', 92, 2, '228.59682487860388354900546879183762407503927627237019647756404754787798490250231005425387394');
  t('421111111111211118111.91111111', 158, 0, '48.182575575193257754428876528083625262744254446747721803414006483216272016813238236310697145443355520347533691936944320295998703366535578387071761712600113739');
  t('651642230486125837.8329778119803361361227', 184, 1, '41.71141926054366590528588063230217971509973936740350669811164945971214813906716299272253063747038302497487714834747428342957974073550600606390026914913164778302041717913676130113565314');
  t('9244595347555461590431831070725246747397928036137625070.79989187733852999205236199883783011817269496307127579442639229082206707166472431542859124127456589510897', 2, 6, '130');
  t('111111158385', 263, 0, '26.126944144617183624635178969871434003445579802616446619095446222986761562301567566351159277698755417420808661255067990334097670164348818994899583401201657033561172232823722133720343435078502859797893888237248176410316047049521950051291501626819737276944418545633');
  t('322222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222220222222222222222222224222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222.222222222222222222229', 176, 3, '565.99656621675139253821792007764426762654489664668687955773829743091647518762168677297131417913839402639416809797395270416084155404035772400915902287834662604702946469896465357');
  t('3000000000000000000000000', 238, 2, '57.05380170108515141724427227080544325514942641927352835287746618857485276966698543036563422618273215760201314191621333349269695043849082735289118429551648383324666288257769431500313701530973782969782289959439547109666647314102559744418065');
  t('100000000000000000000000000000000000000000000003000000000000000000000', 154, 4, '157.2689335041550518226406510399949426849504013611468176243869772752883310800296633716536732730886529747958107958960355928055332518613889899853492118503522');
  t('9434382.2937', 210, 4, '16.7530184455353612813755656351157707588032141566402417688790512215930989623233829379043861275183817002472988076897088241995140707393881368162211446733255243934082031134590597016107848284612076055893297371400339');
  t('99999999999999999999999999999.99999990999999999999199999999999999999999999999999999999999999999999999999999999999999999999999999999999999999997999999999999999919999999999999999999999999', 16, 4, '67.46811487738727');
  t('2800132.92705308411439864629', 173, 6, '15.538324628526023626473341018553334514742270183420905959360819395058240151991912723398777672871251302021408664934994583417883662899665054154329949690801848935584355767957037');
  t('490000000000200000000000700.00086', 223, 0, '62.14959480352212218334303144317717890944485364335641646511948492140459605954879237699166185191922912674498284654822958101351621944614571253386858090905080290283481762391453635225351488374889165412202573892711891796948400589');
  t('22276772619257871246455282495196786658526667522', 60, 6, '107.413020914349439618955892186241732595156849526174548030474');
  t('696799015936021817783117424295218828333333322222222222.33333333', 67, 3, '124.6714839365318342204823919932713523484558264722793803079781309986');
  t('3473932', 236, 2, '15.753944832173415879336625147418246184312973578799407762804609969543939922467156873964428594955270904171295077465949726588277679231666121653682752953176976299848809797907240861945719218200763709198428602610180478920080886236686404771047');
  t('3.474925991', 279, 3, '1.91734235832506568824931562322545193850371200825438826828504193531932352457273289006235067984041997841687311799033820487102476789106873435219820766056885436669060270261302755936524533834284118132214287823035471905624007606792464691690112223946007173582292301433405895828345318726');
  t('308200847.222222269694', 209, 2, '20.23940941034293365695916880574406034175325155585320953616081061027344086209724462568342758204179239207499247943812393008638638814873247700756387920002438392149020492650801525049206999794260823931862639144861');
  t('96900000010000000000000.0000000000000000008', 258, 4, '53.6211136524348243958321482141922531487179913337233031292267513851091264653481398365172547236948005732847515885482048628734110793249048546589216251969902657784868716495051646814330484605156047364986132470882557125622785594444011646470835792792952346993785241');
  t('93738369513498389134974231405611263153696694607', 155, 1, '108.84998396392394241128764179627855075561768872352918778127903835701039555044148098373612730600985277270009859916114127637861190781430455562182772403946604');
  t('99999999999999999999999999999999.999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999989999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999996', 140, 5, '74.37587015636940719799295867135783121131074777048099048718717284043071713164497408315777388986356423448497057037373064200279033511747044677');
  t('8.0361178', 147, 2, '2.77319939545496422129989146134973138056318141047291413734626345742879644177270299800937400993043508186757525462948474029608470380630106242859964187');
  t('48931104906116169', 189, 0, '39.1223368618802099426501487137641101047512806198244429473893206985791823135038810313259922437606027418630858087009636876710665231474412276240647356032116648051223734791925154046098833112451');
  t('64073752225583654056112779', 301, 2, '60.11522421082299599931462841761749058299218937386243125077490263401534246579610369243745531058866463794303916299675412833407115390721088949457667644285497931904532940358509865565371709839243364368037962751365849088185941733106279827522636928945790614310634901314546226362444319473947787865202398539931');
  t('923', 152, 1, '7.5207761216109839419015095673311028305309809768251620605950361092298305276779161331821437070465314375368588426326081228234337517583480615099296670887008');
  t('4111111111111111111.1111111111111111111111111111111111111111111111111111111111111115111111111131184', 254, 5, '43.553372189760772683318683502963128059485631582354433182969152259819666694625738151575549434666593198337096868502447675777208381599490033164996293757955577845345691571646518403065897934525012666083206713906514851944176509486897898223901682653707142863005');
  t('89999999999999999999999999999.99999999999999999999999990999999', 270, 5, '67.3627543617294438447114833264654257902013229316113974855232189285517733040641401206523746038239932433843975165277975627033105096568970643697906628489688971467288707039920755920036517223733732823546299241797962586004527726375329621547839418770237738859689271309550552328');
  t('2', 102, 3, '1.31695789692481670862504634730796844402698197146751647976847225692046018541644397607421901345010178355');
  t('9444444498427239008023958518736215451111111.2222222221081580579333333333333333', 110, 2, '99.64714777117978640062929583820630008202833722541617274121651810140334387359697313237277186078707701203091168');
  t('15747510591492060760328875491417233165.3866572', 125, 2, '86.342892823441756290056642981379852661818427420967554033322935747269524293373442118482008952066380852056217824336234933501957');
  t('480270219.9733694022', 55, 6, '20.6830066423024438386407472514894714092546271163883015');
  t('69000000000000000000000000000000000090000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000007000000000000000000', 44, 6, '447.0235915400139760230735894895888262518812');
  t('54688621843972517104666258583206.313971540117872953862262908953', 280, 6, '73.77235564800710017674816907890506415634826407639499840471655964956045878122702142457975366794387096591546226544828600021874264282780974246424867477460323754570557223350895309252484264673780400256807393625182604267940108884326075614001381210576145615394820811332592542164265699125');
  t('6550696507769733672381326340498610384974221665074060466395963440807869350837423685688870369.88185066767550159805913067848633183617673070775400721972350594779494073408532490867221964722182376509629401', 93, 0, '209.80537693108191407239449938797446146305125083691590480152975364485766102179901434738386273');
  t('87304661111.6666666', 123, 1, '25.8858168708128330744708376918260960166197514906751441562385781692450296791481632408345999478592848106379014959750267446739');
  t('9000', 27, 2, '9.79812703379188197688629677');
  t('534995478061', 134, 2, '27.698671312144212873662902403290506949838951892285840081939007737120826054269659337734353563723134088647466857693593497902557201516084');
  t('33510010000000000000000000000000000000000000000000000000000020000000000000.00000000000000000000000000600000000000000000000000000000005000000000000000000070000000000000000000000000000000000000000000000000000050000000006', 74, 4, '169.99111807629879163625974865178022321947192724289646534209273324929519275');
  t('738.245', 160, 1, '7.297422469676460057258935714571304875282754408306560497316807162261123406168435263072369509041475105737583484684091946392872408276514681369949082374827023560118');
  */
});
