/* eslint-disable import/no-dynamic-require */
'use strict';
const { ok } = require('assert');
const compat = require('../packages/core-js-compat/data');
let tested = 0;
let PATH;

function load(module) {
  tested++;
  // eslint-disable-next-line node/global-require
  return require(`${ PATH }/${ module }`);
}

for (const _PATH of ['../packages/core-js-pure', '../packages/core-js']) {
  PATH = _PATH;
  ok(new (load('features/aggregate-error'))([42]).errors[0] === 42);
  ok(load('features/object/assign')({ q: 1 }, { w: 2 }).w === 2);
  ok(load('features/object/create')(Array.prototype) instanceof Array);
  ok(load('features/object/define-property')({}, 'a', { value: 42 }).a === 42);
  ok(load('features/object/define-properties')({}, { a: { value: 42 } }).a === 42);
  ok(load('features/object/freeze')({}));
  ok(load('features/object/get-own-property-descriptor')({ q: 1 }, 'q').enumerable);
  ok(load('features/object/get-own-property-names')({ q: 42 })[0] === 'q');
  ok(load('features/object/get-own-property-symbols')({ [Symbol()]: 42 }).length === 1);
  ok(load('features/object/get-prototype-of')([]) === Array.prototype);
  ok(load('features/object/is')(NaN, NaN));
  ok(load('features/object/is-extensible')({}));
  ok(!load('features/object/is-frozen')({}));
  ok(!load('features/object/is-sealed')({}));
  ok(typeof load('features/object/iterate-entries')({}).next === 'function');
  ok(typeof load('features/object/iterate-keys')({}).next === 'function');
  ok(typeof load('features/object/iterate-values')({}).next === 'function');
  ok(load('features/object/keys')({ q: 0 })[0] === 'q');
  ok(load('features/object/prevent-extensions')({}));
  ok(load('features/object/seal')({}));
  ok(load('features/object/set-prototype-of')({}, []) instanceof Array);
  ok(load('features/object/to-string')([]) === '[object Array]');
  ok(load('features/object/entries')({ q: 2 })[0][0] === 'q');
  ok(load('features/object/from-entries')([['a', 42]]).a === 42);
  ok(load('features/object/values')({ q: 2 })[0] === 2);
  ok(load('features/object/get-own-property-descriptors')({ q: 1 }).q.enumerable);
  ok(typeof load('features/object/define-getter') === 'function');
  ok(typeof load('features/object/define-setter') === 'function');
  ok(typeof load('features/object/lookup-getter') === 'function');
  ok(typeof load('features/object/lookup-setter') === 'function');
  ok('values' in load('features/object'));
  ok(load('features/function/bind')(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  ok(load('features/function/virtual/bind').call(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  ok(load('features/function/virtual').bind.call(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  load('features/function/name');
  load('features/function/has-instance');
  // eslint-disable-next-line prefer-arrow-callback
  ok(Function[load('features/symbol/has-instance')](function () { /* empty */ }));
  ok('bind' in load('features/function'));
  ok(load('features/array/is-array')([]));
  ok(typeof load('features/array/is-template-object') === 'function');
  ok(Array.isArray(load('features/array/from')('qwe')));
  ok(Array.isArray(load('features/array/of')('q', 'w', 'e')));
  ok(load('features/array/at')([1, 2, 3], -2) === 2);
  ok(load('features/array/join')('qwe', 1) === 'q1w1e');
  ok(load('features/array/slice')('qwe', 1)[1] === 'e');
  ok(load('features/array/sort')([1, 3, 2])[1] === 2);
  ok(typeof load('features/array/for-each') === 'function');
  ok(typeof load('features/array/map') === 'function');
  ok(typeof load('features/array/filter') === 'function');
  ok(typeof load('features/array/filter-out') === 'function');
  ok(typeof load('features/array/flat') === 'function');
  ok(typeof load('features/array/flat-map') === 'function');
  ok(typeof load('features/array/some') === 'function');
  ok(typeof load('features/array/every') === 'function');
  ok(typeof load('features/array/reduce') === 'function');
  ok(typeof load('features/array/reduce-right') === 'function');
  ok(typeof load('features/array/reverse') === 'function');
  ok(typeof load('features/array/index-of') === 'function');
  ok(typeof load('features/array/last-index-of') === 'function');
  ok(load('features/array/concat')([1, 2, 3], [4, 5, 6]).length === 6);
  ok(load('features/array/copy-within')([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  ok(load('features/array/splice')([1, 2, 3], 1, 2)[0] === 2);
  ok('next' in load('features/array/entries')([]));
  load('features/array/last-item');
  load('features/array/last-index');
  ok(load('features/array/fill')(Array(5), 2)[0] === 2);
  ok(load('features/array/find')([2, 3, 4], it => it % 2) === 3);
  ok(load('features/array/find-index')([2, 3, 4], it => it % 2) === 1);
  ok('next' in load('features/array/keys')([]));
  ok('next' in load('features/array/values')([]));
  ok(load('features/array/includes')([1, 2, 3], 2));
  ok('next' in load('features/array/iterator')([]));
  ok(typeof load('features/array/unique-by') === 'function');
  ok(load('features/array/virtual/at').call([1, 2, 3], -2) === 2);
  ok(load('features/array/virtual/join').call('qwe', 1) === 'q1w1e');
  ok(load('features/array/virtual/slice').call('qwe', 1)[1] === 'e');
  ok(load('features/array/virtual/splice').call([1, 2, 3], 1, 2)[0] === 2);
  ok(load('features/array/virtual/sort').call([1, 3, 2])[1] === 2);
  ok(typeof load('features/array/virtual/for-each') === 'function');
  ok(typeof load('features/array/virtual/map') === 'function');
  ok(typeof load('features/array/virtual/filter') === 'function');
  ok(typeof load('features/array/virtual/filter-out') === 'function');
  ok(typeof load('features/array/virtual/flat') === 'function');
  ok(typeof load('features/array/virtual/flat-map') === 'function');
  ok(typeof load('features/array/virtual/some') === 'function');
  ok(typeof load('features/array/virtual/every') === 'function');
  ok(typeof load('features/array/virtual/reduce') === 'function');
  ok(typeof load('features/array/virtual/reduce-right') === 'function');
  ok(typeof load('features/array/virtual/reverse') === 'function');
  ok(typeof load('features/array/virtual/index-of') === 'function');
  ok(typeof load('features/array/virtual/last-index-of') === 'function');
  ok(load('features/array/virtual/concat').call([1, 2, 3], [4, 5, 6]).length === 6);
  ok(load('features/array/virtual/copy-within').call([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  ok('next' in load('features/array/virtual/entries').call([]));
  ok(load('features/array/virtual/fill').call(Array(5), 2)[0] === 2);
  ok(load('features/array/virtual/find').call([2, 3, 4], it => it % 2) === 3);
  ok(load('features/array/virtual/find-index').call([2, 3, 4], it => it % 2) === 1);
  ok('next' in load('features/array/virtual/keys').call([]));
  ok('next' in load('features/array/virtual/values').call([]));
  ok(load('features/array/virtual/includes').call([1, 2, 3], 2));
  ok('next' in load('features/array/virtual/iterator').call([]));
  ok(typeof load('features/array/virtual/unique-by') === 'function');
  ok(load('features/array/virtual').includes.call([1, 2, 3], 2));
  ok('from' in load('features/array'));
  load('features/bigint/range');
  load('features/bigint');
  ok(load('features/math/acosh')(1) === 0);
  ok(Object.is(load('features/math/asinh')(-0), -0));
  ok(load('features/math/atanh')(1) === Infinity);
  ok(load('features/math/cbrt')(-8) === -2);
  ok(load('features/math/clz32')(0) === 32);
  ok(load('features/math/cosh')(0) === 1);
  ok(load('features/math/expm1')(-Infinity) === -1);
  ok(load('features/math/fround')(0) === 0);
  ok(load('features/math/hypot')(3, 4) === 5);
  ok(load('features/math/imul')(2, 2) === 4);
  ok(load('features/math/log10')(-0) === -Infinity);
  ok(load('features/math/log1p')(-1) === -Infinity);
  ok(load('features/math/log2')(1) === 0);
  ok(load('features/math/sign')(-2) === -1);
  ok(Object.is(load('features/math/sinh')(-0), -0));
  ok(load('features/math/tanh')(Infinity) === 1);
  ok(load('features/math/to-string-tag') === 'Math');
  ok(load('features/math/trunc')(1.5) === 1);
  ok(load('features/math/clamp')(6, 2, 4) === 4);
  ok(load('features/math/deg-per-rad') === Math.PI / 180);
  ok(load('features/math/degrees')(Math.PI) === 180);
  ok(load('features/math/fscale')(3, 1, 2, 1, 2) === 3);
  ok(load('features/math/iaddh')(3, 2, 0xFFFFFFFF, 4) === 7);
  ok(load('features/math/isubh')(3, 4, 0xFFFFFFFF, 2) === 1);
  ok(load('features/math/imulh')(0xFFFFFFFF, 7) === -1);
  ok(load('features/math/rad-per-deg') === 180 / Math.PI);
  ok(load('features/math/radians')(180) === Math.PI);
  ok(load('features/math/scale')(3, 1, 2, 1, 2) === 3);
  ok(load('features/math/umulh')(0xFFFFFFFF, 7) === 6);
  ok(load('features/math/signbit')(-2) === true);
  ok(typeof load('features/math/seeded-prng')({ seed: 42 }).next().value === 'number');
  ok(load('features/number/constructor')('5') === 5);
  ok(load('features/number/epsilon') === 2 ** -52);
  ok(load('features/number/is-finite')(42.5));
  ok(load('features/number/is-integer')(42.5) === false);
  ok(load('features/number/is-nan')(NaN));
  ok(load('features/number/is-safe-integer')(42));
  ok(load('features/number/max-safe-integer') === 0x1FFFFFFFFFFFFF);
  ok(load('features/number/min-safe-integer') === -0x1FFFFFFFFFFFFF);
  ok(load('features/number/parse-float')('1.5') === 1.5);
  ok(load('features/number/parse-int')('2.1') === 2);
  ok(load('features/number/to-fixed')(1, 1) === '1.0');
  ok(load('features/number/to-precision')(1) === '1');
  ok(load('features/number/from-string')('12', 3) === 5);
  ok(load('features/number/range')(1, 2).next().value === 1);
  ok(load('features/parse-float')('1.5') === 1.5);
  ok(load('features/parse-int')('2.1') === 2);
  ok(load('features/number/virtual/to-fixed').call(1, 1) === '1.0');
  ok(load('features/number/virtual/to-precision').call(1) === '1');
  ok(load('features/number/virtual').toFixed.call(42, 2) === '42.00');
  ok('isNaN' in load('features/number'));
  ok(load('features/reflect/apply')((a, b) => a + b, null, [1, 2]) === 3);
  ok(load('features/reflect/construct')(function () {
    return this.a = 2;
  }, []).a === 2);
  let O;
  load('features/reflect/define-property')(O = {}, 'a', { value: 42 });
  ok(O.a === 42);
  ok(load('features/reflect/delete-property')({ q: 1 }, 'q'));
  ok(load('features/reflect/get')({ q: 1 }, 'q') === 1);
  ok(load('features/reflect/get-own-property-descriptor')({ q: 1 }, 'q').enumerable);
  ok(load('features/reflect/get-prototype-of')([]) === Array.prototype);
  ok(load('features/reflect/has')({ q: 1 }, 'q'));
  ok(load('features/reflect/is-extensible')({}));
  ok(load('features/reflect/own-keys')({ q: 1 })[0] === 'q');
  ok(load('features/reflect/prevent-extensions')({}));
  ok(load('features/reflect/set')({}, 'a', 42));
  load('features/reflect/set-prototype-of')(O = {}, []);
  ok(load('features/reflect/to-string-tag') === 'Reflect');
  ok(O instanceof Array);
  ok(typeof load('features/reflect/define-metadata') === 'function');
  ok(typeof load('features/reflect/delete-metadata') === 'function');
  ok(typeof load('features/reflect/get-metadata') === 'function');
  ok(typeof load('features/reflect/get-metadata-keys') === 'function');
  ok(typeof load('features/reflect/get-own-metadata') === 'function');
  ok(typeof load('features/reflect/get-own-metadata-keys') === 'function');
  ok(typeof load('features/reflect/has-metadata') === 'function');
  ok(typeof load('features/reflect/has-own-metadata') === 'function');
  ok(typeof load('features/reflect/metadata') === 'function');
  ok('has' in load('features/reflect'));
  ok(load('features/string/from-code-point')(97) === 'a');
  ok(load('features/string/raw')({ raw: 'test' }, 0, 1, 2) === 't0e1s2t');
  ok(load('features/string/trim')(' ab ') === 'ab');
  ok(load('features/string/code-point-at')('a', 0) === 97);
  ok(load('features/string/ends-with')('qwe', 'we'));
  ok(load('features/string/includes')('qwe', 'w'));
  // ok(load('features/string/at-alternative')('123', -2) === '2');
  ok(load('features/string/repeat')('q', 3) === 'qqq');
  ok(load('features/string/starts-with')('qwe', 'qw'));
  ok(typeof load('features/string/anchor') === 'function');
  ok(typeof load('features/string/big') === 'function');
  ok(typeof load('features/string/blink') === 'function');
  ok(typeof load('features/string/bold') === 'function');
  ok(typeof load('features/string/fixed') === 'function');
  ok(typeof load('features/string/fontcolor') === 'function');
  ok(typeof load('features/string/fontsize') === 'function');
  ok(typeof load('features/string/italics') === 'function');
  ok(typeof load('features/string/link') === 'function');
  ok(typeof load('features/string/small') === 'function');
  ok(typeof load('features/string/strike') === 'function');
  ok(typeof load('features/string/sub') === 'function');
  ok(typeof load('features/string/sup') === 'function');
  ok(load('features/string/at')('a', 0) === 'a');
  ok('next' in load('features/string/code-points')('a'));
  ok(load('features/string/pad-start')('a', 3) === '  a');
  ok(load('features/string/pad-end')('a', 3) === 'a  ');
  ok(load('features/string/trim-start')(' a ') === 'a ');
  ok(load('features/string/trim-end')(' a ') === ' a');
  ok(load('features/string/trim-left')(' a ') === 'a ');
  ok(load('features/string/trim-right')(' a ') === ' a');
  ok('next' in load('features/string/match-all')('a', /./g));
  ok(typeof load('features/string/replace-all') === 'function');
  ok('next' in load('features/string/iterator')('qwe'));
  ok(load('features/string/virtual/code-point-at').call('a', 0) === 97);
  ok(load('features/string/virtual/ends-with').call('qwe', 'we'));
  ok(load('features/string/virtual/includes').call('qwe', 'w'));
  // ok(load('features/string/virtual/at-alternative').call('123', -2) === '2');
  ok(load('features/string/virtual/repeat').call('q', 3) === 'qqq');
  ok(load('features/string/virtual/starts-with').call('qwe', 'qw'));
  ok(typeof load('features/string/virtual/anchor') === 'function');
  ok(typeof load('features/string/virtual/big') === 'function');
  ok(typeof load('features/string/virtual/blink') === 'function');
  ok(typeof load('features/string/virtual/bold') === 'function');
  ok(typeof load('features/string/virtual/fixed') === 'function');
  ok(typeof load('features/string/virtual/fontcolor') === 'function');
  ok(typeof load('features/string/virtual/fontsize') === 'function');
  ok(typeof load('features/string/virtual/italics') === 'function');
  ok(typeof load('features/string/virtual/link') === 'function');
  ok(typeof load('features/string/virtual/small') === 'function');
  ok(typeof load('features/string/virtual/strike') === 'function');
  ok(typeof load('features/string/virtual/sub') === 'function');
  ok(typeof load('features/string/virtual/sup') === 'function');
  ok(load('features/string/virtual/at').call('a', 0) === 'a');
  ok('next' in load('features/string/virtual/code-points').call('a'));
  ok(load('features/string/virtual/pad-start').call('a', 3) === '  a');
  ok(load('features/string/virtual/pad-end').call('a', 3) === 'a  ');
  ok(load('features/string/virtual/trim-start').call(' a ') === 'a ');
  ok(load('features/string/virtual/trim-end').call(' a ') === ' a');
  ok(load('features/string/virtual/trim-left').call(' a ') === 'a ');
  ok(load('features/string/virtual/trim-right').call(' a ') === ' a');
  ok('next' in load('features/string/virtual/match-all').call('a', /./g));
  ok(typeof load('features/string/virtual/replace-all') === 'function');
  ok(load('features/string/virtual').at.call('a', 0) === 'a');
  ok('next' in load('features/string/virtual/iterator').call('qwe'));
  ok('raw' in load('features/string'));
  ok(String(load('features/regexp/constructor')('a', 'g')) === '/a/g');
  ok(load('features/regexp/to-string')(/./g) === '/./g');
  ok(load('features/regexp/flags')(/./g) === 'g');
  ok(typeof load('features/regexp/match') === 'function');
  ok(typeof load('features/regexp/replace') === 'function');
  ok(typeof load('features/regexp/search') === 'function');
  ok(typeof load('features/regexp/split') === 'function');
  ok(typeof load('features/regexp/sticky') === 'function');
  ok(typeof load('features/regexp/test') === 'function');
  load('features/regexp');
  ok(load('features/json').stringify([1]) === '[1]');
  ok(load('features/json/stringify')([1]) === '[1]');
  ok(load('features/json/to-string-tag') === 'JSON');
  ok(typeof load('features/date/now')(new Date()) === 'number');
  ok(typeof load('features/date/to-string')(new Date()) === 'string');
  ok(typeof load('features/date/to-primitive')(new Date(), 'number') === 'number');
  ok(typeof load('features/date/to-iso-string')(new Date()) === 'string');
  ok(load('features/date/to-json')(Infinity) === null);
  ok(load('features/date'));
  load('features/symbol/description');
  ok(load('features/symbol/has-instance'));
  ok(load('features/symbol/is-concat-spreadable'));
  ok(load('features/symbol/iterator'));
  ok(load('features/symbol/match'));
  ok(load('features/symbol/match-all'));
  ok(load('features/symbol/replace'));
  ok(load('features/symbol/search'));
  ok(load('features/symbol/species'));
  ok(load('features/symbol/split'));
  ok(load('features/symbol/to-primitive'));
  ok(load('features/symbol/to-string-tag'));
  ok(load('features/symbol/unscopables'));
  ok(load('features/symbol/async-iterator'));
  ok(load('features/symbol/observable'));
  ok(load('features/symbol/pattern-match'));
  ok(load('features/symbol/replace-all'));
  ok(load('features/symbol/async-dispose'));
  ok(load('features/symbol/dispose'));
  ok(typeof load('features/symbol/for') === 'function');
  ok(typeof load('features/symbol/key-for') === 'function');
  ok('iterator' in load('features/symbol'));
  let Map = load('features/map');
  let Set = load('features/set');
  let WeakMap = load('features/weak-map');
  let WeakSet = load('features/weak-set');
  ok(new Map([[1, 2], [3, 4]]).size === 2);
  ok(new Set([1, 2, 3, 2, 1]).size === 3);
  ok(new WeakMap([[O = {}, 42]]).get(O) === 42);
  ok(new WeakSet([O = {}]).has(O));
  ok(load('features/map/of')([1, 2], [3, 4]) instanceof Map);
  ok(load('features/set/of')(1, 2, 3, 2, 1) instanceof Set);
  ok(load('features/weak-map/of')([{}, 1], [[], 2]) instanceof WeakMap);
  ok(load('features/weak-set/of')({}, []) instanceof WeakSet);
  ok(load('features/map/from')([[1, 2], [3, 4]]) instanceof Map);
  ok(load('features/set/from')([1, 2, 3, 2, 1]) instanceof Set);
  ok(load('features/weak-map/from')([[{}, 1], [[], 2]]) instanceof WeakMap);
  ok(load('features/weak-set/from')([{}, []]) instanceof WeakSet);
  ok(load('features/map/delete-all')(new Map(), 1, 2) === false);
  ok(load('features/map/emplace')(new Map([[1, 2]]), 1, { update: it => it ** 2 }) === 4);
  ok(load('features/map/every')(new Map([[1, 2], [2, 3], [3, 4]]), it => it % 2) === false);
  ok(load('features/map/filter')(new Map([[1, 2], [2, 3], [3, 4]]), it => it % 2).size === 1);
  ok(load('features/map/find')(new Map([[1, 2], [2, 3], [3, 4]]), it => it % 2) === 3);
  ok(load('features/map/find-key')(new Map([[1, 2], [2, 3], [3, 4]]), it => it % 2) === 2);
  ok(load('features/map/group-by')([], it => it) instanceof Map);
  ok(load('features/map/includes')(new Map([[1, 2]]), 2), true);
  ok(load('features/map/key-by')([], it => it) instanceof Map);
  ok(load('features/map/key-of')(new Map([[1, 2]]), 2), 1);
  ok(load('features/map/map-keys')(new Map([[1, 2], [2, 3], [3, 4]]), it => it).size === 3);
  ok(load('features/map/map-values')(new Map([[1, 2], [2, 3], [3, 4]]), it => it).size === 3);
  ok(load('features/map/merge')(new Map([[1, 2], [2, 3]]), [[2, 4], [4, 5]]).size === 3);
  ok(load('features/map/reduce')(new Map([[1, 2], [2, 3], [3, 4]]), (a, b) => a + b) === 9);
  ok(load('features/map/some')(new Map([[1, 2], [2, 3], [3, 4]]), it => it % 2) === true);
  ok(load('features/map/update')(new Map([[1, 2]]), 1, it => it * 2).get(1) === 4);
  ok(load('features/map/update-or-insert')(new Map([[1, 2]]), 1, it => it ** 2, () => 42) === 4);
  ok(load('features/map/upsert')(new Map([[1, 2]]), 1, it => it ** 2, () => 42) === 4);
  ok(load('features/set/add-all')(new Set([1, 2, 3]), 4, 5).size === 5);
  ok(load('features/set/delete-all')(new Set([1, 2, 3]), 4, 5) === false);
  ok(load('features/set/difference')(new Set([1, 2, 3]), [3, 4, 5]).size === 2);
  ok(load('features/set/every')(new Set([1, 2, 3]), it => typeof it == 'number'));
  ok(load('features/set/filter')(new Set([1, 2, 3]), it => it % 2).size === 2);
  ok(load('features/set/find')(new Set([2, 3, 4]), it => it % 2) === 3);
  ok(load('features/set/intersection')(new Set([1, 2, 3]), [1, 3, 4]).size === 2);
  ok(load('features/set/is-disjoint-from')(new Set([1, 2, 3]), [4, 5, 6]));
  ok(load('features/set/is-subset-of')(new Set([1, 2, 3]), [1, 2, 3, 4]));
  ok(load('features/set/is-superset-of')(new Set([1, 2, 3, 4]), [1, 2, 3]));
  ok(load('features/set/join')(new Set([1, 2, 3])) === '1,2,3');
  ok(load('features/set/map')(new Set([1, 2, 3]), it => it % 2).size === 2);
  ok(load('features/set/reduce')(new Set([1, 2, 3]), (it, v) => it + v) === 6);
  ok(load('features/set/some')(new Set([1, 2, 3]), it => typeof it == 'number'));
  ok(load('features/set/symmetric-difference')(new Set([1, 2, 3]), [3, 4, 5]).size === 4);
  ok(load('features/set/union')(new Set([1, 2, 3]), [3, 4, 5]).size === 5);
  ok(load('features/weak-map/delete-all')(new WeakMap(), [], {}) === false);
  ok(load('features/weak-map/emplace')(new WeakMap(), {}, { insert: () => ({ a: 42 }) }).a === 42);
  ok(load('features/weak-map/upsert')(new WeakMap(), {}, null, () => 42) === 42);
  ok(load('features/weak-set/add-all')(new WeakSet(), [], {}) instanceof WeakSet);
  ok(load('features/weak-set/delete-all')(new WeakSet(), [], {}) === false);
  let Promise = load('features/promise');
  ok('all' in Promise);
  ok(load('features/promise/all-settled')([1, 2, 3]) instanceof Promise);
  ok(load('features/promise/any')([1, 2, 3]) instanceof Promise);
  ok(load('features/promise/try')(() => 42) instanceof load('features/promise'));
  ok('from' in load('features/observable'));
  ok(load('es/global-this').Math === Math);
  ok(load('stable/global-this').Math === Math);
  ok(load('features/global-this').Math === Math);
  ok(typeof load('features/dom-collections').iterator === 'function');
  ok(typeof load('features/dom-collections/iterator') === 'function');
  ok(typeof load('features/set-timeout') === 'function');
  ok(typeof load('features/set-interval') === 'function');
  ok(typeof load('features/set-immediate') === 'function');
  ok(typeof load('features/clear-immediate') === 'function');
  ok(typeof load('features/queue-microtask') === 'function');
  ok(typeof load('features/composite-key')({}, 1, {}) === 'object');
  ok(typeof load('features/composite-symbol')({}, 1, {}) === 'symbol');
  ok(typeof load('features/async-iterator') === 'function');
  ok(typeof load('features/async-iterator/as-indexed-pairs') === 'function');
  ok(typeof load('features/async-iterator/drop') === 'function');
  ok(typeof load('features/async-iterator/every') === 'function');
  ok(typeof load('features/async-iterator/filter') === 'function');
  ok(typeof load('features/async-iterator/find') === 'function');
  ok(typeof load('features/async-iterator/flat-map') === 'function');
  ok(typeof load('features/async-iterator/for-each') === 'function');
  ok(typeof load('features/async-iterator/from') === 'function');
  ok(typeof load('features/async-iterator/map') === 'function');
  ok(typeof load('features/async-iterator/reduce') === 'function');
  ok(typeof load('features/async-iterator/some') === 'function');
  ok(typeof load('features/async-iterator/take') === 'function');
  ok(typeof load('features/async-iterator/to-array') === 'function');
  ok(typeof load('features/iterator') === 'function');
  ok(typeof load('features/iterator/as-indexed-pairs') === 'function');
  ok(typeof load('features/iterator/drop') === 'function');
  ok(typeof load('features/iterator/every') === 'function');
  ok(typeof load('features/iterator/filter') === 'function');
  ok(typeof load('features/iterator/find') === 'function');
  ok(typeof load('features/iterator/flat-map') === 'function');
  ok(typeof load('features/iterator/for-each') === 'function');
  ok(typeof load('features/iterator/from') === 'function');
  ok(typeof load('features/iterator/map') === 'function');
  ok(typeof load('features/iterator/reduce') === 'function');
  ok(typeof load('features/iterator/some') === 'function');
  ok(typeof load('features/iterator/take') === 'function');
  ok(typeof load('features/iterator/to-array') === 'function');
  ok(typeof load('features/url') === 'function');
  load('features/url/to-json');
  ok(typeof load('features/url-search-params') === 'function');
  ok(load('features/is-iterable')([]));
  ok(typeof load('features/get-iterator-method')([]) === 'function');
  ok('next' in load('features/get-iterator')([]));
  ok(load('features'));

  ok(new (load('stable/aggregate-error'))([42]).errors[0] === 42);
  ok(load('stable/object/assign')({ q: 1 }, { w: 2 }).w === 2);
  ok(load('stable/object/create')(Array.prototype) instanceof Array);
  ok(load('stable/object/define-property')({}, 'a', { value: 42 }).a === 42);
  ok(load('stable/object/define-properties')({}, { a: { value: 42 } }).a === 42);
  ok(load('stable/object/freeze')({}));
  ok(load('stable/object/get-own-property-descriptor')({ q: 1 }, 'q').enumerable);
  ok(load('stable/object/get-own-property-names')({ q: 42 })[0] === 'q');
  ok(load('stable/object/get-own-property-symbols')({ [Symbol()]: 42 }).length === 1);
  ok(load('stable/object/get-prototype-of')([]) === Array.prototype);
  ok(load('stable/object/is')(NaN, NaN));
  ok(load('stable/object/is-extensible')({}));
  ok(!load('stable/object/is-frozen')({}));
  ok(!load('stable/object/is-sealed')({}));
  ok(load('stable/object/keys')({ q: 0 })[0] === 'q');
  ok(load('stable/object/prevent-extensions')({}));
  ok(load('stable/object/seal')({}));
  ok(load('stable/object/set-prototype-of')({}, []) instanceof Array);
  ok(load('stable/object/to-string')([]) === '[object Array]');
  ok(load('stable/object/entries')({ q: 2 })[0][0] === 'q');
  ok(load('stable/object/from-entries')([['a', 42]]).a === 42);
  ok(load('stable/object/values')({ q: 2 })[0] === 2);
  ok(load('stable/object/get-own-property-descriptors')({ q: 1 }).q.enumerable);
  ok(typeof load('stable/object/define-getter') === 'function');
  ok(typeof load('stable/object/define-setter') === 'function');
  ok(typeof load('stable/object/lookup-getter') === 'function');
  ok(typeof load('stable/object/lookup-setter') === 'function');
  ok('values' in load('stable/object'));
  ok(load('stable/function/bind')(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  ok(load('stable/function/virtual/bind').call(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  ok(load('stable/function/virtual').bind.call(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  load('stable/function/name');
  load('stable/function/has-instance');
  // eslint-disable-next-line prefer-arrow-callback
  ok(Function[load('stable/symbol/has-instance')](function () { /* empty */ }));
  ok('bind' in load('stable/function'));
  ok(load('stable/array/is-array')([]));
  ok(Array.isArray(load('stable/array/from')('qwe')));
  ok(Array.isArray(load('stable/array/of')('q', 'w', 'e')));
  ok(load('stable/array/join')('qwe', 1) === 'q1w1e');
  ok(load('stable/array/slice')('qwe', 1)[1] === 'e');
  ok(load('stable/array/sort')([1, 3, 2])[1] === 2);
  ok(typeof load('stable/array/for-each') === 'function');
  ok(typeof load('stable/array/map') === 'function');
  ok(typeof load('stable/array/filter') === 'function');
  ok(typeof load('stable/array/flat') === 'function');
  ok(typeof load('stable/array/flat-map') === 'function');
  ok(typeof load('stable/array/some') === 'function');
  ok(typeof load('stable/array/every') === 'function');
  ok(typeof load('stable/array/reduce') === 'function');
  ok(typeof load('stable/array/reduce-right') === 'function');
  ok(typeof load('stable/array/reverse') === 'function');
  ok(typeof load('stable/array/index-of') === 'function');
  ok(typeof load('stable/array/last-index-of') === 'function');
  ok(load('stable/array/concat')([1, 2, 3], [4, 5, 6]).length === 6);
  ok(load('stable/array/copy-within')([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  ok('next' in load('stable/array/entries')([]));
  ok(load('stable/array/fill')(Array(5), 2)[0] === 2);
  ok(load('stable/array/find')([2, 3, 4], it => it % 2) === 3);
  ok(load('stable/array/find-index')([2, 3, 4], it => it % 2) === 1);
  ok('next' in load('stable/array/keys')([]));
  ok('next' in load('stable/array/values')([]));
  ok(load('stable/array/includes')([1, 2, 3], 2));
  ok('next' in load('stable/array/iterator')([]));
  ok(load('stable/array/virtual/join').call('qwe', 1) === 'q1w1e');
  ok(load('stable/array/virtual/slice').call('qwe', 1)[1] === 'e');
  ok(load('stable/array/virtual/splice').call([1, 2, 3], 1, 2)[0] === 2);
  ok(load('stable/array/virtual/sort').call([1, 3, 2])[1] === 2);
  ok(typeof load('stable/array/virtual/for-each') === 'function');
  ok(typeof load('stable/array/virtual/map') === 'function');
  ok(typeof load('stable/array/virtual/filter') === 'function');
  ok(typeof load('stable/array/virtual/flat') === 'function');
  ok(typeof load('stable/array/virtual/flat-map') === 'function');
  ok(typeof load('stable/array/virtual/some') === 'function');
  ok(typeof load('stable/array/virtual/every') === 'function');
  ok(typeof load('stable/array/virtual/reduce') === 'function');
  ok(typeof load('stable/array/virtual/reduce-right') === 'function');
  ok(typeof load('stable/array/virtual/reverse') === 'function');
  ok(typeof load('stable/array/virtual/index-of') === 'function');
  ok(typeof load('stable/array/virtual/last-index-of') === 'function');
  ok(load('stable/array/virtual/concat').call([1, 2, 3], [4, 5, 6]).length === 6);
  ok(load('stable/array/virtual/copy-within').call([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  ok('next' in load('stable/array/virtual/entries').call([]));
  ok(load('stable/array/virtual/fill').call(Array(5), 2)[0] === 2);
  ok(load('stable/array/virtual/find').call([2, 3, 4], it => it % 2) === 3);
  ok(load('stable/array/virtual/find-index').call([2, 3, 4], it => it % 2) === 1);
  ok('next' in load('stable/array/virtual/keys').call([]));
  ok('next' in load('stable/array/virtual/values').call([]));
  ok(load('stable/array/virtual/includes').call([1, 2, 3], 2));
  ok('next' in load('stable/array/virtual/iterator').call([]));
  ok(load('stable/array/virtual').includes.call([1, 2, 3], 2));
  ok('from' in load('stable/array'));
  ok(load('stable/array/splice')([1, 2, 3], 1, 2)[0] === 2);
  ok(load('stable/math/acosh')(1) === 0);
  ok(Object.is(load('stable/math/asinh')(-0), -0));
  ok(load('stable/math/atanh')(1) === Infinity);
  ok(load('stable/math/cbrt')(-8) === -2);
  ok(load('stable/math/clz32')(0) === 32);
  ok(load('stable/math/cosh')(0) === 1);
  ok(load('stable/math/expm1')(-Infinity) === -1);
  ok(load('stable/math/fround')(0) === 0);
  ok(load('stable/math/hypot')(3, 4) === 5);
  ok(load('stable/math/imul')(2, 2) === 4);
  ok(load('stable/math/log10')(-0) === -Infinity);
  ok(load('stable/math/log1p')(-1) === -Infinity);
  ok(load('stable/math/log2')(1) === 0);
  ok(load('stable/math/sign')(-2) === -1);
  ok(Object.is(load('stable/math/sinh')(-0), -0));
  ok(load('stable/math/tanh')(Infinity) === 1);
  ok(load('stable/math/to-string-tag') === 'Math');
  ok(load('stable/math/trunc')(1.5) === 1);
  ok(load('stable/number/constructor')('5') === 5);
  ok(load('stable/number/epsilon') === 2 ** -52);
  ok(load('stable/number/is-finite')(42.5));
  ok(load('stable/number/is-integer')(42.5) === false);
  ok(load('stable/number/is-nan')(NaN));
  ok(load('stable/number/is-safe-integer')(42));
  ok(load('stable/number/max-safe-integer') === 0x1FFFFFFFFFFFFF);
  ok(load('stable/number/min-safe-integer') === -0x1FFFFFFFFFFFFF);
  ok(load('stable/number/parse-float')('1.5') === 1.5);
  ok(load('stable/number/parse-int')('2.1') === 2);
  ok(load('stable/number/to-fixed')(1, 1) === '1.0');
  ok(load('stable/number/to-precision')(1) === '1');
  ok(load('stable/parse-float')('1.5') === 1.5);
  ok(load('stable/parse-int')('2.1') === 2);
  ok(load('stable/number/virtual/to-fixed').call(1, 1) === '1.0');
  ok(load('stable/number/virtual/to-precision').call(1) === '1');
  ok(load('stable/number/virtual').toFixed.call(42, 2) === '42.00');
  ok('isNaN' in load('stable/number'));
  ok(load('stable/reflect/apply')((a, b) => a + b, null, [1, 2]) === 3);
  ok(load('stable/reflect/construct')(function () {
    return this.a = 2;
  }, []).a === 2);
  load('stable/reflect/define-property')(O = {}, 'a', { value: 42 });
  ok(O.a === 42);
  ok(load('stable/reflect/delete-property')({ q: 1 }, 'q'));
  ok(load('stable/reflect/get')({ q: 1 }, 'q') === 1);
  ok(load('stable/reflect/get-own-property-descriptor')({ q: 1 }, 'q').enumerable);
  ok(load('stable/reflect/get-prototype-of')([]) === Array.prototype);
  ok(load('stable/reflect/has')({ q: 1 }, 'q'));
  ok(load('stable/reflect/is-extensible')({}));
  ok(load('stable/reflect/own-keys')({ q: 1 })[0] === 'q');
  ok(load('stable/reflect/prevent-extensions')({}));
  ok(load('stable/reflect/set')({}, 'a', 42));
  load('stable/reflect/set-prototype-of')(O = {}, []);
  ok(load('stable/reflect/to-string-tag') === 'Reflect');
  ok(O instanceof Array);
  ok('has' in load('stable/reflect'));
  ok(load('stable/string/from-code-point')(97) === 'a');
  ok(load('stable/string/raw')({ raw: 'test' }, 0, 1, 2) === 't0e1s2t');
  ok(load('stable/string/trim')(' ab ') === 'ab');
  ok(load('stable/string/code-point-at')('a', 0) === 97);
  ok(load('stable/string/ends-with')('qwe', 'we'));
  ok(load('stable/string/includes')('qwe', 'w'));
  ok(load('stable/string/repeat')('q', 3) === 'qqq');
  ok('next' in load('stable/string/match-all')('a', /./g));
  ok(load('stable/string/starts-with')('qwe', 'qw'));
  ok(typeof load('stable/string/anchor') === 'function');
  ok(typeof load('stable/string/big') === 'function');
  ok(typeof load('stable/string/blink') === 'function');
  ok(typeof load('stable/string/bold') === 'function');
  ok(typeof load('stable/string/fixed') === 'function');
  ok(typeof load('stable/string/fontcolor') === 'function');
  ok(typeof load('stable/string/fontsize') === 'function');
  ok(typeof load('stable/string/italics') === 'function');
  ok(typeof load('stable/string/link') === 'function');
  ok(typeof load('stable/string/small') === 'function');
  ok(typeof load('stable/string/strike') === 'function');
  ok(typeof load('stable/string/sub') === 'function');
  ok(typeof load('stable/string/sup') === 'function');
  ok(typeof load('stable/string/replace-all') === 'function');
  ok(load('stable/string/pad-start')('a', 3) === '  a');
  ok(load('stable/string/pad-end')('a', 3) === 'a  ');
  ok(load('stable/string/trim-start')(' a ') === 'a ');
  ok(load('stable/string/trim-end')(' a ') === ' a');
  ok(load('stable/string/trim-left')(' a ') === 'a ');
  ok(load('stable/string/trim-right')(' a ') === ' a');
  ok('next' in load('stable/string/iterator')('qwe'));
  ok(load('stable/string/virtual/code-point-at').call('a', 0) === 97);
  ok(load('stable/string/virtual/ends-with').call('qwe', 'we'));
  ok(load('stable/string/virtual/includes').call('qwe', 'w'));
  ok(typeof load('stable/string/virtual/match-all') === 'function');
  ok(typeof load('stable/string/virtual/replace-all') === 'function');
  ok(load('stable/string/virtual/repeat').call('q', 3) === 'qqq');
  ok(load('stable/string/virtual/starts-with').call('qwe', 'qw'));
  ok(typeof load('stable/string/virtual/anchor') === 'function');
  ok(typeof load('stable/string/virtual/big') === 'function');
  ok(typeof load('stable/string/virtual/blink') === 'function');
  ok(typeof load('stable/string/virtual/bold') === 'function');
  ok(typeof load('stable/string/virtual/fixed') === 'function');
  ok(typeof load('stable/string/virtual/fontcolor') === 'function');
  ok(typeof load('stable/string/virtual/fontsize') === 'function');
  ok(typeof load('stable/string/virtual/italics') === 'function');
  ok(typeof load('stable/string/virtual/link') === 'function');
  ok(typeof load('stable/string/virtual/small') === 'function');
  ok(typeof load('stable/string/virtual/strike') === 'function');
  ok(typeof load('stable/string/virtual/sub') === 'function');
  ok(typeof load('stable/string/virtual/sup') === 'function');
  ok(load('stable/string/virtual/pad-start').call('a', 3) === '  a');
  ok(load('stable/string/virtual/pad-end').call('a', 3) === 'a  ');
  ok(load('stable/string/virtual/trim-start').call(' a ') === 'a ');
  ok(load('stable/string/virtual/trim-end').call(' a ') === ' a');
  ok(load('stable/string/virtual/trim-left').call(' a ') === 'a ');
  ok(load('stable/string/virtual/trim-right').call(' a ') === ' a');
  ok(load('stable/string/virtual').at.call('a', 0) === 'a');
  ok('next' in load('stable/string/virtual/iterator').call('qwe'));
  ok('raw' in load('stable/string'));
  ok(String(load('stable/regexp/constructor')('a', 'g')) === '/a/g');
  ok(load('stable/regexp/to-string')(/./g) === '/./g');
  ok(load('stable/regexp/flags')(/./g) === 'g');
  ok(typeof load('stable/regexp/match') === 'function');
  ok(typeof load('stable/regexp/replace') === 'function');
  ok(typeof load('stable/regexp/search') === 'function');
  ok(typeof load('stable/regexp/split') === 'function');
  ok(typeof load('stable/regexp/sticky') === 'function');
  ok(typeof load('stable/regexp/test') === 'function');
  load('stable/regexp');
  ok(load('stable/json').stringify([1]) === '[1]');
  ok(load('stable/json/stringify')([1]) === '[1]');
  ok(load('stable/json/to-string-tag') === 'JSON');
  ok(typeof load('stable/date/now')(new Date()) === 'number');
  ok(typeof load('stable/date/to-string')(new Date()) === 'string');
  ok(typeof load('stable/date/to-primitive')(new Date(), 'number') === 'number');
  ok(typeof load('stable/date/to-iso-string')(new Date()) === 'string');
  ok(load('stable/date/to-json')(Infinity) === null);
  ok(load('stable/date'));
  load('stable/symbol/description');
  ok(load('stable/symbol/has-instance'));
  ok(load('stable/symbol/is-concat-spreadable'));
  ok(load('stable/symbol/iterator'));
  ok(load('stable/symbol/match'));
  ok(load('stable/symbol/match-all'));
  ok(load('stable/symbol/replace'));
  ok(load('stable/symbol/search'));
  ok(load('stable/symbol/species'));
  ok(load('stable/symbol/split'));
  ok(load('stable/symbol/to-primitive'));
  ok(load('stable/symbol/to-string-tag'));
  ok(load('stable/symbol/unscopables'));
  ok(load('stable/symbol/async-iterator'));
  ok(typeof load('stable/symbol/for') === 'function');
  ok(typeof load('stable/symbol/key-for') === 'function');
  ok('iterator' in load('stable/symbol'));
  Map = load('stable/map');
  Set = load('stable/set');
  WeakMap = load('stable/weak-map');
  WeakSet = load('stable/weak-set');
  ok(new Map([[1, 2], [3, 4]]).size === 2);
  ok(new Set([1, 2, 3, 2, 1]).size === 3);
  ok(new WeakMap([[O = {}, 42]]).get(O) === 42);
  ok(new WeakSet([O = {}]).has(O));
  Promise = load('stable/promise');
  ok('all' in Promise);
  ok(load('stable/promise/all-settled')([1, 2, 3]) instanceof Promise);
  ok(load('stable/promise/any')([1, 2, 3]) instanceof Promise);
  ok(typeof load('stable/dom-collections').iterator === 'function');
  ok(typeof load('stable/dom-collections/iterator') === 'function');
  ok(typeof load('stable/set-timeout') === 'function');
  ok(typeof load('stable/set-interval') === 'function');
  ok(typeof load('stable/set-immediate') === 'function');
  ok(typeof load('stable/clear-immediate') === 'function');
  ok(typeof load('stable/queue-microtask') === 'function');
  ok(typeof load('stable/url') === 'function');
  load('stable/url/to-json');
  ok(typeof load('stable/url-search-params') === 'function');
  ok(load('stable'));

  ok(new (load('es/aggregate-error'))([42]).errors[0] === 42);
  ok(load('es/object/assign')({ q: 1 }, { w: 2 }).w === 2);
  ok(load('es/object/create')(Array.prototype) instanceof Array);
  ok(load('es/object/define-property')({}, 'a', { value: 42 }).a === 42);
  ok(load('es/object/define-properties')({}, { a: { value: 42 } }).a === 42);
  ok(load('es/object/freeze')({}));
  ok(load('es/object/get-own-property-descriptor')({ q: 1 }, 'q').enumerable);
  ok(load('es/object/get-own-property-names')({ q: 42 })[0] === 'q');
  ok(load('es/object/get-own-property-symbols')({ [Symbol()]: 42 }).length === 1);
  ok(load('es/object/get-prototype-of')([]) === Array.prototype);
  ok(load('es/object/is')(NaN, NaN));
  ok(load('es/object/is-extensible')({}));
  ok(!load('es/object/is-frozen')({}));
  ok(!load('es/object/is-sealed')({}));
  ok(load('es/object/keys')({ q: 0 })[0] === 'q');
  ok(load('es/object/prevent-extensions')({}));
  ok(load('es/object/seal')({}));
  ok(load('es/object/set-prototype-of')({}, []) instanceof Array);
  ok(load('es/object/to-string')([]) === '[object Array]');
  ok(load('es/object/entries')({ q: 2 })[0][0] === 'q');
  ok(load('es/object/from-entries')([['a', 42]]).a === 42);
  ok(load('es/object/values')({ q: 2 })[0] === 2);
  ok(load('es/object/get-own-property-descriptors')({ q: 1 }).q.enumerable);
  ok(typeof load('es/object/define-getter') === 'function');
  ok(typeof load('es/object/define-setter') === 'function');
  ok(typeof load('es/object/lookup-getter') === 'function');
  ok(typeof load('es/object/lookup-setter') === 'function');
  ok('values' in load('es/object'));
  ok(load('es/function/bind')(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  ok(load('es/function/virtual/bind').call(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  ok(load('es/function/virtual').bind.call(function (a, b) {
    return this + a + b;
  }, 1, 2)(3) === 6);
  load('es/function/name');
  load('es/function/has-instance');
  // eslint-disable-next-line prefer-arrow-callback
  ok(Function[load('es/symbol/has-instance')](function () { /* empty */ }));
  ok('bind' in load('es/function'));
  ok(load('es/array/is-array')([]));
  ok(Array.isArray(load('es/array/from')('qwe')));
  ok(Array.isArray(load('es/array/of')('q', 'w', 'e')));
  ok(load('es/array/join')('qwe', 1) === 'q1w1e');
  ok(load('es/array/slice')('qwe', 1)[1] === 'e');
  ok(load('es/array/sort')([1, 3, 2])[1] === 2);
  ok(typeof load('es/array/for-each') === 'function');
  ok(typeof load('es/array/map') === 'function');
  ok(typeof load('es/array/filter') === 'function');
  ok(typeof load('es/array/flat') === 'function');
  ok(typeof load('es/array/flat-map') === 'function');
  ok(typeof load('es/array/some') === 'function');
  ok(typeof load('es/array/every') === 'function');
  ok(typeof load('es/array/reduce') === 'function');
  ok(typeof load('es/array/reduce-right') === 'function');
  ok(typeof load('es/array/reverse') === 'function');
  ok(typeof load('es/array/index-of') === 'function');
  ok(typeof load('es/array/last-index-of') === 'function');
  ok(load('es/array/concat')([1, 2, 3], [4, 5, 6]).length === 6);
  ok(load('es/array/copy-within')([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  ok('next' in load('es/array/entries')([]));
  ok(load('es/array/fill')(Array(5), 2)[0] === 2);
  ok(load('es/array/find')([2, 3, 4], it => it % 2) === 3);
  ok(load('es/array/find-index')([2, 3, 4], it => it % 2) === 1);
  ok('next' in load('es/array/keys')([]));
  ok('next' in load('es/array/values')([]));
  ok(load('es/array/includes')([1, 2, 3], 2));
  ok('next' in load('es/array/iterator')([]));
  ok(load('es/array/virtual/join').call('qwe', 1) === 'q1w1e');
  ok(load('es/array/virtual/slice').call('qwe', 1)[1] === 'e');
  ok(load('es/array/virtual/splice').call([1, 2, 3], 1, 2)[0] === 2);
  ok(load('es/array/virtual/sort').call([1, 3, 2])[1] === 2);
  ok(typeof load('es/array/virtual/for-each') === 'function');
  ok(typeof load('es/array/virtual/map') === 'function');
  ok(typeof load('es/array/virtual/filter') === 'function');
  ok(typeof load('es/array/virtual/flat') === 'function');
  ok(typeof load('es/array/virtual/flat-map') === 'function');
  ok(typeof load('es/array/virtual/some') === 'function');
  ok(typeof load('es/array/virtual/every') === 'function');
  ok(typeof load('es/array/virtual/reduce') === 'function');
  ok(typeof load('es/array/virtual/reduce-right') === 'function');
  ok(typeof load('es/array/virtual/reverse') === 'function');
  ok(typeof load('es/array/virtual/index-of') === 'function');
  ok(typeof load('es/array/virtual/last-index-of') === 'function');
  ok(load('es/array/virtual/concat').call([1, 2, 3], [4, 5, 6]).length === 6);
  ok(load('es/array/virtual/copy-within').call([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  ok('next' in load('es/array/virtual/entries').call([]));
  ok(load('es/array/virtual/fill').call(Array(5), 2)[0] === 2);
  ok(load('es/array/virtual/find').call([2, 3, 4], it => it % 2) === 3);
  ok(load('es/array/virtual/find-index').call([2, 3, 4], it => it % 2) === 1);
  ok('next' in load('es/array/virtual/keys').call([]));
  ok('next' in load('es/array/virtual/values').call([]));
  ok(load('es/array/virtual/includes').call([1, 2, 3], 2));
  ok('next' in load('es/array/virtual/iterator').call([]));
  ok(load('es/array/virtual').includes.call([1, 2, 3], 2));
  ok('from' in load('es/array'));
  ok(load('es/array/splice')([1, 2, 3], 1, 2)[0] === 2);
  ok(load('es/math/acosh')(1) === 0);
  ok(Object.is(load('es/math/asinh')(-0), -0));
  ok(load('es/math/atanh')(1) === Infinity);
  ok(load('es/math/cbrt')(-8) === -2);
  ok(load('es/math/clz32')(0) === 32);
  ok(load('es/math/cosh')(0) === 1);
  ok(load('es/math/expm1')(-Infinity) === -1);
  ok(load('es/math/fround')(0) === 0);
  ok(load('es/math/hypot')(3, 4) === 5);
  ok(load('es/math/imul')(2, 2) === 4);
  ok(load('es/math/log10')(-0) === -Infinity);
  ok(load('es/math/log1p')(-1) === -Infinity);
  ok(load('es/math/log2')(1) === 0);
  ok(load('es/math/sign')(-2) === -1);
  ok(Object.is(load('es/math/sinh')(-0), -0));
  ok(load('es/math/tanh')(Infinity) === 1);
  ok(load('es/math/to-string-tag') === 'Math');
  ok(load('es/math/trunc')(1.5) === 1);
  ok(load('es/number/constructor')('5') === 5);
  ok(load('es/number/epsilon') === 2 ** -52);
  ok(load('es/number/is-finite')(42.5));
  ok(load('es/number/is-integer')(42.5) === false);
  ok(load('es/number/is-nan')(NaN));
  ok(load('es/number/is-safe-integer')(42));
  ok(load('es/number/max-safe-integer') === 0x1FFFFFFFFFFFFF);
  ok(load('es/number/min-safe-integer') === -0x1FFFFFFFFFFFFF);
  ok(load('es/number/parse-float')('1.5') === 1.5);
  ok(load('es/number/parse-int')('2.1') === 2);
  ok(load('es/number/to-fixed')(1, 1) === '1.0');
  ok(load('es/number/to-precision')(1) === '1');
  ok(load('es/parse-float')('1.5') === 1.5);
  ok(load('es/parse-int')('2.1') === 2);
  ok(load('es/number/virtual/to-fixed').call(1, 1) === '1.0');
  ok(load('es/number/virtual/to-precision').call(1) === '1');
  ok(load('es/number/virtual').toFixed.call(42, 2) === '42.00');
  ok('isNaN' in load('es/number'));
  ok(load('es/reflect/apply')((a, b) => a + b, null, [1, 2]) === 3);
  ok(load('es/reflect/construct')(function () {
    return this.a = 2;
  }, []).a === 2);
  load('es/reflect/define-property')(O = {}, 'a', { value: 42 });
  ok(O.a === 42);
  ok(load('es/reflect/delete-property')({ q: 1 }, 'q'));
  ok(load('es/reflect/get')({ q: 1 }, 'q') === 1);
  ok(load('es/reflect/get-own-property-descriptor')({ q: 1 }, 'q').enumerable);
  ok(load('es/reflect/get-prototype-of')([]) === Array.prototype);
  ok(load('es/reflect/has')({ q: 1 }, 'q'));
  ok(load('es/reflect/is-extensible')({}));
  ok(load('es/reflect/own-keys')({ q: 1 })[0] === 'q');
  ok(load('es/reflect/prevent-extensions')({}));
  ok(load('es/reflect/set')({}, 'a', 42));
  load('es/reflect/set-prototype-of')(O = {}, []);
  ok(load('es/reflect/to-string-tag') === 'Reflect');
  ok(O instanceof Array);
  ok('has' in load('es/reflect'));
  ok(load('es/string/from-code-point')(97) === 'a');
  ok(load('es/string/raw')({ raw: 'test' }, 0, 1, 2) === 't0e1s2t');
  ok(load('es/string/trim')(' ab ') === 'ab');
  ok(load('es/string/trim-start')(' a ') === 'a ');
  ok(load('es/string/trim-end')(' a ') === ' a');
  ok(load('es/string/trim-left')(' a ') === 'a ');
  ok(load('es/string/trim-right')(' a ') === ' a');
  ok(load('es/string/code-point-at')('a', 0) === 97);
  ok(load('es/string/ends-with')('qwe', 'we'));
  ok(load('es/string/includes')('qwe', 'w'));
  ok(load('es/string/repeat')('q', 3) === 'qqq');
  ok(load('es/string/starts-with')('qwe', 'qw'));
  ok(typeof load('es/string/anchor') === 'function');
  ok(typeof load('es/string/big') === 'function');
  ok(typeof load('es/string/blink') === 'function');
  ok(typeof load('es/string/bold') === 'function');
  ok(typeof load('es/string/fixed') === 'function');
  ok(typeof load('es/string/fontcolor') === 'function');
  ok(typeof load('es/string/fontsize') === 'function');
  ok(typeof load('es/string/italics') === 'function');
  ok(typeof load('es/string/link') === 'function');
  ok(typeof load('es/string/small') === 'function');
  ok(typeof load('es/string/strike') === 'function');
  ok(typeof load('es/string/sub') === 'function');
  ok(typeof load('es/string/sup') === 'function');
  ok(typeof load('es/string/replace-all') === 'function');
  ok(load('es/string/pad-start')('a', 3) === '  a');
  ok(load('es/string/pad-end')('a', 3) === 'a  ');
  ok('next' in load('es/string/iterator')('qwe'));
  ok(load('es/string/virtual/code-point-at').call('a', 0) === 97);
  ok(load('es/string/virtual/ends-with').call('qwe', 'we'));
  ok(load('es/string/virtual/includes').call('qwe', 'w'));
  ok(typeof load('es/string/virtual/match-all') === 'function');
  ok(typeof load('es/string/virtual/replace-all') === 'function');
  ok(load('es/string/virtual/repeat').call('q', 3) === 'qqq');
  ok(load('es/string/virtual/starts-with').call('qwe', 'qw'));
  ok(load('es/string/virtual/trim').call(' ab ') === 'ab');
  ok(load('es/string/virtual/trim-start').call(' a ') === 'a ');
  ok(load('es/string/virtual/trim-end').call(' a ') === ' a');
  ok(load('es/string/virtual/trim-left').call(' a ') === 'a ');
  ok(load('es/string/virtual/trim-right').call(' a ') === ' a');
  ok(typeof load('es/string/virtual/anchor') === 'function');
  ok(typeof load('es/string/virtual/big') === 'function');
  ok(typeof load('es/string/virtual/blink') === 'function');
  ok(typeof load('es/string/virtual/bold') === 'function');
  ok(typeof load('es/string/virtual/fixed') === 'function');
  ok(typeof load('es/string/virtual/fontcolor') === 'function');
  ok(typeof load('es/string/virtual/fontsize') === 'function');
  ok(typeof load('es/string/virtual/italics') === 'function');
  ok(typeof load('es/string/virtual/link') === 'function');
  ok(typeof load('es/string/virtual/small') === 'function');
  ok(typeof load('es/string/virtual/strike') === 'function');
  ok(typeof load('es/string/virtual/sub') === 'function');
  ok(typeof load('es/string/virtual/sup') === 'function');
  ok(load('es/string/virtual/pad-start').call('a', 3) === '  a');
  ok(load('es/string/virtual/pad-end').call('a', 3) === 'a  ');
  ok(load('es/string/virtual').trim.call(' a') === 'a');
  ok('next' in load('es/string/virtual/iterator').call('qwe'));
  ok('raw' in load('es/string'));
  ok(String(load('es/regexp/constructor')('a', 'g')) === '/a/g');
  ok(load('es/regexp/to-string')(/./g) === '/./g');
  ok(load('es/regexp/flags')(/./g) === 'g');
  ok(typeof load('es/regexp/match') === 'function');
  ok(typeof load('es/regexp/replace') === 'function');
  ok(typeof load('es/regexp/search') === 'function');
  ok(typeof load('es/regexp/split') === 'function');
  ok(typeof load('es/regexp/sticky') === 'function');
  ok(typeof load('es/regexp/test') === 'function');
  load('es/regexp');
  ok(load('es/json').stringify([1]) === '[1]');
  ok(load('es/json/stringify')([1]) === '[1]');
  ok(load('es/json/to-string-tag') === 'JSON');
  ok(typeof load('es/date/now')(new Date()) === 'number');
  ok(typeof load('es/date/to-string')(new Date()) === 'string');
  ok(typeof load('es/date/to-primitive')(new Date(), 'number') === 'number');
  ok(typeof load('es/date/to-iso-string')(new Date()) === 'string');
  ok(load('es/date/to-json')(Infinity) === null);
  ok(load('es/date'));
  ok(load('es/symbol/has-instance'));
  ok(load('es/symbol/is-concat-spreadable'));
  ok(load('es/symbol/iterator'));
  ok(load('es/symbol/match'));
  ok(load('es/symbol/match-all'));
  ok(load('es/symbol/replace'));
  ok(load('es/symbol/search'));
  ok(load('es/symbol/species'));
  ok(load('es/symbol/split'));
  ok(load('es/symbol/to-primitive'));
  ok(load('es/symbol/to-string-tag'));
  ok(load('es/symbol/unscopables'));
  ok(load('es/symbol/async-iterator'));
  load('es/symbol/description');
  ok(typeof load('es/symbol/for') === 'function');
  ok(typeof load('es/symbol/key-for') === 'function');
  ok('iterator' in load('es/symbol'));
  Map = load('es/map');
  Set = load('es/set');
  WeakMap = load('es/weak-map');
  WeakSet = load('es/weak-set');
  ok(new Map([[1, 2], [3, 4]]).size === 2);
  ok(new Set([1, 2, 3, 2, 1]).size === 3);
  ok(new WeakMap([[O = {}, 42]]).get(O) === 42);
  ok(new WeakSet([O = {}]).has(O));
  Promise = load('es/promise');
  ok('all' in Promise);
  ok(load('es/promise/all-settled')([1, 2, 3]) instanceof Promise);
  ok(load('es/promise/any')([1, 2, 3]) instanceof Promise);
  ok('Map' in load('es'));
  ok('setTimeout' in load('web/timers'));
  ok('setImmediate' in load('web/immediate'));
  ok(typeof load('web/queue-microtask') === 'function');
  load('web/dom-collections');
  ok(typeof load('web/url') === 'function');
  ok(typeof load('web/url-search-params') === 'function');
  ok('setImmediate' in load('web'));
  load('proposals/array-is-template-object');
  load('proposals/array-last');
  load('proposals/collection-methods');
  load('proposals/collection-of-from');
  load('proposals/efficient-64-bit-arithmetic');
  load('proposals/global-this');
  load('proposals/iterator-helpers');
  load('proposals/math-extensions');
  load('proposals/math-signbit');
  load('proposals/number-from-string');
  load('proposals/number-range');
  load('proposals/object-iteration');
  load('proposals/observable');
  load('proposals/pattern-matching');
  load('proposals/promise-all-settled');
  load('proposals/promise-any');
  load('proposals/promise-try');
  load('proposals/reflect-metadata');
  load('proposals/relative-indexing-method');
  load('proposals/keys-composition');
  load('proposals/seeded-random');
  load('proposals/set-methods');
  load('proposals/string-at');
  load('proposals/string-code-points');
  load('proposals/string-match-all');
  load('proposals/string-replace-all');
  load('proposals/using-statement');
  load('proposals/url');
  load('proposals');
  ok(load('stage/4'));
  ok(load('stage/3'));
  ok(load('stage/2'));
  ok(load('stage/1'));
  ok(load('stage/0'));
  ok(load('stage/pre'));
  ok(load('stage'));
  ok(load('index'));

  const instanceAt = load('features/instance/at');
  ok(typeof instanceAt === 'function');
  ok(instanceAt({}) === undefined);
  ok(typeof instanceAt([]) === 'function');
  ok(typeof instanceAt('') === 'function');
  ok(instanceAt([]).call([1, 2, 3], 2) === 3);
  ok(instanceAt('').call('123', 2) === '3');

  let instanceBind = load('features/instance/bind');
  ok(typeof instanceBind === 'function');
  ok(instanceBind({}) === undefined);
  ok(typeof instanceBind(it => it) === 'function');
  ok(instanceBind(it => it).call(it => it, 1, 2)() === 2);
  instanceBind = load('stable/instance/bind');
  ok(typeof instanceBind === 'function');
  ok(instanceBind({}) === undefined);
  ok(typeof instanceBind(it => it) === 'function');
  ok(instanceBind(it => it).call(it => it, 1, 2)() === 2);
  instanceBind = load('es/instance/bind');
  ok(typeof instanceBind === 'function');
  ok(instanceBind({}) === undefined);
  ok(typeof instanceBind(it => it) === 'function');
  ok(instanceBind(it => it).call(it => it, 1, 2)() === 2);

  let instanceCodePointAt = load('features/instance/code-point-at');
  ok(typeof instanceCodePointAt === 'function');
  ok(instanceCodePointAt({}) === undefined);
  ok(typeof instanceCodePointAt('') === 'function');
  ok(instanceCodePointAt('').call('a', 0) === 97);
  instanceCodePointAt = load('stable/instance/code-point-at');
  ok(typeof instanceCodePointAt === 'function');
  ok(instanceCodePointAt({}) === undefined);
  ok(typeof instanceCodePointAt('') === 'function');
  ok(instanceCodePointAt('').call('a', 0) === 97);
  instanceCodePointAt = load('es/instance/code-point-at');
  ok(typeof instanceCodePointAt === 'function');
  ok(instanceCodePointAt({}) === undefined);
  ok(typeof instanceCodePointAt('') === 'function');
  ok(instanceCodePointAt('').call('a', 0) === 97);

  const instanceCodePoints = load('features/instance/code-points');
  ok(typeof instanceCodePoints === 'function');
  ok(instanceCodePoints({}) === undefined);
  ok(typeof instanceCodePoints('') === 'function');
  ok(instanceCodePoints('').call('abc').next().value.codePoint === 97);

  let instanceConcat = load('features/instance/concat');
  ok(typeof instanceConcat === 'function');
  ok(instanceConcat({}) === undefined);
  ok(typeof instanceConcat([]) === 'function');
  ok(instanceConcat([]).call([1, 2, 3], [4, 5, 6]).length === 6);
  instanceConcat = load('stable/instance/concat');
  ok(typeof instanceConcat === 'function');
  ok(instanceConcat({}) === undefined);
  ok(typeof instanceConcat([]) === 'function');
  ok(instanceConcat([]).call([1, 2, 3], [4, 5, 6]).length === 6);
  instanceConcat = load('es/instance/concat');
  ok(typeof instanceConcat === 'function');
  ok(instanceConcat({}) === undefined);
  ok(typeof instanceConcat([]) === 'function');
  ok(instanceConcat([]).call([1, 2, 3], [4, 5, 6]).length === 6);

  let instanceCopyWithin = load('features/instance/copy-within');
  ok(typeof instanceCopyWithin === 'function');
  ok(instanceCopyWithin({}) === undefined);
  ok(typeof instanceCopyWithin([]) === 'function');
  ok(instanceCopyWithin([]).call([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  instanceCopyWithin = load('stable/instance/copy-within');
  ok(typeof instanceCopyWithin === 'function');
  ok(instanceCopyWithin({}) === undefined);
  ok(typeof instanceCopyWithin([]) === 'function');
  ok(instanceCopyWithin([]).call([1, 2, 3, 4, 5], 0, 3)[0] === 4);
  instanceCopyWithin = load('es/instance/copy-within');
  ok(typeof instanceCopyWithin === 'function');
  ok(instanceCopyWithin({}) === undefined);
  ok(typeof instanceCopyWithin([]) === 'function');
  ok(instanceCopyWithin([]).call([1, 2, 3, 4, 5], 0, 3)[0] === 4);

  let instanceEndsWith = load('features/instance/ends-with');
  ok(typeof instanceEndsWith === 'function');
  ok(instanceEndsWith({}) === undefined);
  ok(typeof instanceEndsWith('') === 'function');
  ok(instanceEndsWith('').call('qwe', 'we'));
  instanceEndsWith = load('stable/instance/ends-with');
  ok(typeof instanceEndsWith === 'function');
  ok(instanceEndsWith({}) === undefined);
  ok(typeof instanceEndsWith('') === 'function');
  ok(instanceEndsWith('').call('qwe', 'we'));
  instanceEndsWith = load('es/instance/ends-with');
  ok(typeof instanceEndsWith === 'function');
  ok(instanceEndsWith({}) === undefined);
  ok(typeof instanceEndsWith('') === 'function');
  ok(instanceEndsWith('').call('qwe', 'we'));

  let instanceEntries = load('features/instance/entries');
  ok(typeof instanceEntries === 'function');
  ok(instanceEntries({}) === undefined);
  ok(typeof instanceEntries([]) === 'function');
  ok(instanceEntries([]).call([1, 2, 3]).next().value[1] === 1);
  instanceEntries = load('stable/instance/entries');
  ok(typeof instanceEntries === 'function');
  ok(instanceEntries({}) === undefined);
  ok(typeof instanceEntries([]) === 'function');
  ok(instanceEntries([]).call([1, 2, 3]).next().value[1] === 1);
  instanceEntries = load('es/instance/entries');
  ok(typeof instanceEntries === 'function');
  ok(instanceEntries({}) === undefined);
  ok(typeof instanceEntries([]) === 'function');
  ok(instanceEntries([]).call([1, 2, 3]).next().value[1] === 1);

  let instanceEvery = load('features/instance/every');
  ok(typeof instanceEvery === 'function');
  ok(instanceEvery({}) === undefined);
  ok(typeof instanceEvery([]) === 'function');
  ok(instanceEvery([]).call([1, 2, 3], it => typeof it === 'number'));
  instanceEvery = load('stable/instance/every');
  ok(typeof instanceEvery === 'function');
  ok(instanceEvery({}) === undefined);
  ok(typeof instanceEvery([]) === 'function');
  ok(instanceEvery([]).call([1, 2, 3], it => typeof it === 'number'));
  instanceEvery = load('es/instance/every');
  ok(typeof instanceEvery === 'function');
  ok(instanceEvery({}) === undefined);
  ok(typeof instanceEvery([]) === 'function');
  ok(instanceEvery([]).call([1, 2, 3], it => typeof it === 'number'));

  let instanceFill = load('features/instance/fill');
  ok(typeof instanceFill === 'function');
  ok(instanceFill({}) === undefined);
  ok(typeof instanceFill([]) === 'function');
  ok(instanceFill([]).call(Array(5), 42)[3] === 42);
  instanceFill = load('stable/instance/fill');
  ok(typeof instanceFill === 'function');
  ok(instanceFill({}) === undefined);
  ok(typeof instanceFill([]) === 'function');
  ok(instanceFill([]).call(Array(5), 42)[3] === 42);
  instanceFill = load('es/instance/fill');
  ok(typeof instanceFill === 'function');
  ok(instanceFill({}) === undefined);
  ok(typeof instanceFill([]) === 'function');
  ok(instanceFill([]).call(Array(5), 42)[3] === 42);

  let instanceFilter = load('features/instance/filter');
  ok(typeof instanceFilter === 'function');
  ok(instanceFilter({}) === undefined);
  ok(typeof instanceFilter([]) === 'function');
  ok(instanceFilter([]).call([1, 2, 3], it => it % 2).length === 2);
  instanceFilter = load('stable/instance/filter');
  ok(typeof instanceFilter === 'function');
  ok(instanceFilter({}) === undefined);
  ok(typeof instanceFilter([]) === 'function');
  ok(instanceFilter([]).call([1, 2, 3], it => it % 2).length === 2);
  instanceFilter = load('es/instance/filter');
  ok(typeof instanceFilter === 'function');
  ok(instanceFilter({}) === undefined);
  ok(typeof instanceFilter([]) === 'function');
  ok(instanceFilter([]).call([1, 2, 3], it => it % 2).length === 2);

  const instanceFilterOut = load('features/instance/filter-out');
  ok(typeof instanceFilterOut === 'function');
  ok(instanceFilterOut({}) === undefined);
  ok(typeof instanceFilterOut([]) === 'function');
  ok(instanceFilterOut([]).call([1, 2, 3], it => it % 2).length === 1);

  let instanceFindIndex = load('features/instance/find-index');
  ok(typeof instanceFindIndex === 'function');
  ok(instanceFindIndex({}) === undefined);
  ok(typeof instanceFindIndex([]) === 'function');
  ok(instanceFindIndex([]).call([1, 2, 3], it => it % 2) === 0);
  instanceFindIndex = load('stable/instance/find-index');
  ok(typeof instanceFindIndex === 'function');
  ok(instanceFindIndex({}) === undefined);
  ok(typeof instanceFindIndex([]) === 'function');
  ok(instanceFindIndex([]).call([1, 2, 3], it => it % 2) === 0);
  instanceFindIndex = load('es/instance/find-index');
  ok(typeof instanceFindIndex === 'function');
  ok(instanceFindIndex({}) === undefined);
  ok(typeof instanceFindIndex([]) === 'function');
  ok(instanceFindIndex([]).call([1, 2, 3], it => it % 2) === 0);

  let instanceFind = load('features/instance/find');
  ok(typeof instanceFind === 'function');
  ok(instanceFind({}) === undefined);
  ok(typeof instanceFind([]) === 'function');
  ok(instanceFind([]).call([1, 2, 3], it => it % 2) === 1);
  instanceFind = load('stable/instance/find');
  ok(typeof instanceFind === 'function');
  ok(instanceFind({}) === undefined);
  ok(typeof instanceFind([]) === 'function');
  ok(instanceFind([]).call([1, 2, 3], it => it % 2) === 1);
  instanceFind = load('es/instance/find');
  ok(typeof instanceFind === 'function');
  ok(instanceFind({}) === undefined);
  ok(typeof instanceFind([]) === 'function');
  ok(instanceFind([]).call([1, 2, 3], it => it % 2) === 1);

  let instanceFlags = load('features/instance/flags');
  ok(typeof instanceFlags === 'function');
  ok(instanceFlags({}) === undefined);
  ok(instanceFlags(/./g) === 'g');
  instanceFlags = load('stable/instance/flags');
  ok(typeof instanceFlags === 'function');
  ok(instanceFlags({}) === undefined);
  ok(instanceFlags(/./g) === 'g');
  instanceFlags = load('es/instance/flags');
  ok(typeof instanceFlags === 'function');
  ok(instanceFlags({}) === undefined);
  ok(instanceFlags(/./g) === 'g');

  let instanceFlatMap = load('features/instance/flat-map');
  ok(typeof instanceFlatMap === 'function');
  ok(instanceFlatMap({}) === undefined);
  ok(typeof instanceFlatMap([]) === 'function');
  ok(instanceFlatMap([]).call([1, 2, 3], (v, i) => [v, i]).length === 6);
  instanceFlatMap = load('stable/instance/flat-map');
  ok(typeof instanceFlatMap === 'function');
  ok(instanceFlatMap({}) === undefined);
  ok(typeof instanceFlatMap([]) === 'function');
  ok(instanceFlatMap([]).call([1, 2, 3], (v, i) => [v, i]).length === 6);
  instanceFlatMap = load('es/instance/flat-map');
  ok(typeof instanceFlatMap === 'function');
  ok(instanceFlatMap({}) === undefined);
  ok(typeof instanceFlatMap([]) === 'function');
  ok(instanceFlatMap([]).call([1, 2, 3], (v, i) => [v, i]).length === 6);

  let instanceFlat = load('features/instance/flat');
  ok(typeof instanceFlat === 'function');
  ok(instanceFlat({}) === undefined);
  ok(typeof instanceFlat([]) === 'function');
  ok(instanceFlat([]).call([1, [2, 3], [4, [5, [6]]]]).length === 5);
  instanceFlat = load('stable/instance/flat');
  ok(typeof instanceFlat === 'function');
  ok(instanceFlat({}) === undefined);
  ok(typeof instanceFlat([]) === 'function');
  ok(instanceFlat([]).call([1, [2, 3], [4, [5, [6]]]]).length === 5);
  instanceFlat = load('es/instance/flat');
  ok(typeof instanceFlat === 'function');
  ok(instanceFlat({}) === undefined);
  ok(typeof instanceFlat([]) === 'function');
  ok(instanceFlat([]).call([1, [2, 3], [4, [5, [6]]]]).length === 5);

  let instanceForEach = load('features/instance/for-each');
  ok(typeof instanceForEach === 'function');
  ok(instanceForEach({}) === undefined);
  ok(typeof instanceForEach([]) === 'function');
  instanceForEach = load('stable/instance/for-each');
  ok(typeof instanceForEach === 'function');
  ok(instanceForEach({}) === undefined);
  ok(typeof instanceForEach([]) === 'function');
  instanceForEach = load('es/instance/for-each');
  ok(typeof instanceForEach === 'function');
  ok(instanceForEach({}) === undefined);
  ok(typeof instanceForEach([]) === 'function');

  let instanceIncludes = load('features/instance/includes');
  ok(typeof instanceIncludes === 'function');
  ok(instanceIncludes({}) === undefined);
  ok(typeof instanceIncludes([]) === 'function');
  ok(typeof instanceIncludes('') === 'function');
  ok(instanceIncludes([]).call([1, 2, 3], 2));
  ok(instanceIncludes('').call('123', '2'));
  instanceIncludes = load('stable/instance/includes');
  ok(typeof instanceIncludes === 'function');
  ok(instanceIncludes({}) === undefined);
  ok(typeof instanceIncludes([]) === 'function');
  ok(typeof instanceIncludes('') === 'function');
  ok(instanceIncludes([]).call([1, 2, 3], 2));
  ok(instanceIncludes('').call('123', '2'));
  instanceIncludes = load('es/instance/includes');
  ok(typeof instanceIncludes === 'function');
  ok(instanceIncludes({}) === undefined);
  ok(typeof instanceIncludes([]) === 'function');
  ok(typeof instanceIncludes('') === 'function');
  ok(instanceIncludes([]).call([1, 2, 3], 2));
  ok(instanceIncludes('').call('123', '2'));

  let instanceIndexOf = load('features/instance/index-of');
  ok(typeof instanceIndexOf === 'function');
  ok(instanceIndexOf({}) === undefined);
  ok(typeof instanceIndexOf([]) === 'function');
  ok(instanceIndexOf([]).call([1, 2, 3], 2) === 1);
  instanceIndexOf = load('stable/instance/index-of');
  ok(typeof instanceIndexOf === 'function');
  ok(instanceIndexOf({}) === undefined);
  ok(typeof instanceIndexOf([]) === 'function');
  ok(instanceIndexOf([]).call([1, 2, 3], 2) === 1);
  instanceIndexOf = load('es/instance/index-of');
  ok(typeof instanceIndexOf === 'function');
  ok(instanceIndexOf({}) === undefined);
  ok(typeof instanceIndexOf([]) === 'function');
  ok(instanceIndexOf([]).call([1, 2, 3], 2) === 1);

  let instanceKeys = load('features/instance/keys');
  ok(typeof instanceKeys === 'function');
  ok(instanceKeys({}) === undefined);
  ok(typeof instanceKeys([]) === 'function');
  ok(instanceKeys([]).call([1, 2, 3]).next().value === 0);
  instanceKeys = load('stable/instance/keys');
  ok(typeof instanceKeys === 'function');
  ok(instanceKeys({}) === undefined);
  ok(typeof instanceKeys([]) === 'function');
  ok(instanceKeys([]).call([1, 2, 3]).next().value === 0);
  instanceKeys = load('es/instance/keys');
  ok(typeof instanceKeys === 'function');
  ok(instanceKeys({}) === undefined);
  ok(typeof instanceKeys([]) === 'function');
  ok(instanceKeys([]).call([1, 2, 3]).next().value === 0);

  let instanceLastIndexOf = load('features/instance/last-index-of');
  ok(typeof instanceLastIndexOf === 'function');
  ok(instanceLastIndexOf({}) === undefined);
  ok(typeof instanceLastIndexOf([]) === 'function');
  ok(instanceLastIndexOf([]).call([1, 2, 3], 2) === 1);
  instanceLastIndexOf = load('stable/instance/last-index-of');
  ok(typeof instanceLastIndexOf === 'function');
  ok(instanceLastIndexOf({}) === undefined);
  ok(typeof instanceLastIndexOf([]) === 'function');
  ok(instanceLastIndexOf([]).call([1, 2, 3], 2) === 1);
  instanceLastIndexOf = load('es/instance/last-index-of');
  ok(typeof instanceLastIndexOf === 'function');
  ok(instanceLastIndexOf({}) === undefined);
  ok(typeof instanceLastIndexOf([]) === 'function');
  ok(instanceLastIndexOf([]).call([1, 2, 3], 2) === 1);

  let instanceMap = load('features/instance/map');
  ok(typeof instanceMap === 'function');
  ok(instanceMap({}) === undefined);
  ok(typeof instanceMap([]) === 'function');
  ok(instanceMap([]).call([1, 2, 3], it => it % 2)[1] === 0);
  instanceMap = load('stable/instance/map');
  ok(typeof instanceMap === 'function');
  ok(instanceMap({}) === undefined);
  ok(typeof instanceMap([]) === 'function');
  ok(instanceMap([]).call([1, 2, 3], it => it % 2)[1] === 0);
  instanceMap = load('es/instance/map');
  ok(typeof instanceMap === 'function');
  ok(instanceMap({}) === undefined);
  ok(typeof instanceMap([]) === 'function');
  ok(instanceMap([]).call([1, 2, 3], it => it % 2)[1] === 0);

  let instanceMatchAll = load('features/instance/match-all');
  ok(typeof instanceMatchAll === 'function');
  ok(instanceMatchAll({}) === undefined);
  ok(typeof instanceMatchAll('') === 'function');
  ok(instanceMatchAll('').call('test1test2', /t(e)(st(\d?))/g).next().value[0] === 'test1');
  instanceMatchAll = load('stable/instance/match-all');
  ok(typeof instanceMatchAll === 'function');
  ok(instanceMatchAll({}) === undefined);
  ok(typeof instanceMatchAll('') === 'function');
  ok(instanceMatchAll('').call('test1test2', /t(e)(st(\d?))/g).next().value[0] === 'test1');
  instanceMatchAll = load('es/instance/match-all');
  ok(typeof instanceMatchAll === 'function');
  ok(instanceMatchAll({}) === undefined);
  ok(typeof instanceMatchAll('') === 'function');
  ok(instanceMatchAll('').call('test1test2', /t(e)(st(\d?))/g).next().value[0] === 'test1');

  let instancePadEnd = load('features/instance/pad-end');
  ok(typeof instancePadEnd === 'function');
  ok(instancePadEnd({}) === undefined);
  ok(typeof instancePadEnd('') === 'function');
  ok(instancePadEnd('').call('a', 3, 'b') === 'abb');
  instancePadEnd = load('stable/instance/pad-end');
  ok(typeof instancePadEnd === 'function');
  ok(instancePadEnd({}) === undefined);
  ok(typeof instancePadEnd('') === 'function');
  ok(instancePadEnd('').call('a', 3, 'b') === 'abb');
  instancePadEnd = load('es/instance/pad-end');
  ok(typeof instancePadEnd === 'function');
  ok(instancePadEnd({}) === undefined);
  ok(typeof instancePadEnd('') === 'function');
  ok(instancePadEnd('').call('a', 3, 'b') === 'abb');

  let instancePadStart = load('features/instance/pad-start');
  ok(typeof instancePadStart === 'function');
  ok(instancePadStart({}) === undefined);
  ok(typeof instancePadStart('') === 'function');
  ok(instancePadStart('').call('a', 3, 'b') === 'bba');
  instancePadStart = load('stable/instance/pad-start');
  ok(typeof instancePadStart === 'function');
  ok(instancePadStart({}) === undefined);
  ok(typeof instancePadStart('') === 'function');
  ok(instancePadStart('').call('a', 3, 'b') === 'bba');
  instancePadStart = load('es/instance/pad-start');
  ok(typeof instancePadStart === 'function');
  ok(instancePadStart({}) === undefined);
  ok(typeof instancePadStart('') === 'function');
  ok(instancePadStart('').call('a', 3, 'b') === 'bba');

  let instanceReduceRight = load('features/instance/reduce-right');
  ok(typeof instanceReduceRight === 'function');
  ok(instanceReduceRight({}) === undefined);
  ok(typeof instanceReduceRight([]) === 'function');
  ok(instanceReduceRight([]).call([1, 2, 3], (memo, it) => it + memo, '') === '123');
  instanceReduceRight = load('stable/instance/reduce-right');
  ok(typeof instanceReduceRight === 'function');
  ok(instanceReduceRight({}) === undefined);
  ok(typeof instanceReduceRight([]) === 'function');
  ok(instanceReduceRight([]).call([1, 2, 3], (memo, it) => it + memo, '') === '123');
  instanceReduceRight = load('es/instance/reduce-right');
  ok(typeof instanceReduceRight === 'function');
  ok(instanceReduceRight({}) === undefined);
  ok(typeof instanceReduceRight([]) === 'function');
  ok(instanceReduceRight([]).call([1, 2, 3], (memo, it) => it + memo, '') === '123');

  let instanceReduce = load('features/instance/reduce');
  ok(typeof instanceReduce === 'function');
  ok(instanceReduce({}) === undefined);
  ok(typeof instanceReduce([]) === 'function');
  ok(instanceReduce([]).call([1, 2, 3], (memo, it) => it + memo, '') === '321');
  instanceReduce = load('stable/instance/reduce');
  ok(typeof instanceReduce === 'function');
  ok(instanceReduce({}) === undefined);
  ok(typeof instanceReduce([]) === 'function');
  ok(instanceReduce([]).call([1, 2, 3], (memo, it) => it + memo, '') === '321');
  instanceReduce = load('es/instance/reduce');
  ok(typeof instanceReduce === 'function');
  ok(instanceReduce({}) === undefined);
  ok(typeof instanceReduce([]) === 'function');
  ok(instanceReduce([]).call([1, 2, 3], (memo, it) => it + memo, '') === '321');

  let instanceRepeat = load('features/instance/repeat');
  ok(typeof instanceRepeat === 'function');
  ok(instanceRepeat({}) === undefined);
  ok(typeof instanceRepeat('') === 'function');
  ok(instanceRepeat('').call('a', 3) === 'aaa');
  instanceRepeat = load('stable/instance/repeat');
  ok(typeof instanceRepeat === 'function');
  ok(instanceRepeat({}) === undefined);
  ok(typeof instanceRepeat('') === 'function');
  ok(instanceRepeat('').call('a', 3) === 'aaa');
  instanceRepeat = load('es/instance/repeat');
  ok(typeof instanceRepeat === 'function');
  ok(instanceRepeat({}) === undefined);
  ok(typeof instanceRepeat('') === 'function');
  ok(instanceRepeat('').call('a', 3) === 'aaa');

  let instanceReplaceAll = load('features/instance/replace-all');
  ok(typeof instanceReplaceAll === 'function');
  ok(instanceReplaceAll({}) === undefined);
  ok(typeof instanceReplaceAll('') === 'function');
  ok(instanceReplaceAll('').call('aba', 'a', 'c') === 'cbc');
  instanceReplaceAll = load('stable/instance/replace-all');
  ok(typeof instanceReplaceAll === 'function');
  ok(instanceReplaceAll({}) === undefined);
  ok(typeof instanceReplaceAll('') === 'function');
  ok(instanceReplaceAll('').call('aba', 'a', 'c') === 'cbc');
  instanceReplaceAll = load('es/instance/replace-all');
  ok(typeof instanceReplaceAll === 'function');
  ok(instanceReplaceAll({}) === undefined);
  ok(typeof instanceReplaceAll('') === 'function');
  ok(instanceReplaceAll('').call('aba', 'a', 'c') === 'cbc');

  let instanceReverse = load('features/instance/reverse');
  ok(typeof instanceReverse === 'function');
  ok(instanceReverse({}) === undefined);
  ok(typeof instanceReverse([]) === 'function');
  instanceReverse = load('stable/instance/reverse');
  ok(typeof instanceReverse === 'function');
  ok(instanceReverse({}) === undefined);
  ok(typeof instanceReverse([]) === 'function');
  instanceReverse = load('es/instance/reverse');
  ok(typeof instanceReverse === 'function');
  ok(instanceReverse({}) === undefined);
  ok(typeof instanceReverse([]) === 'function');

  let instanceSlice = load('features/instance/slice');
  ok(typeof instanceSlice === 'function');
  ok(instanceSlice({}) === undefined);
  ok(typeof instanceSlice([]) === 'function');
  instanceSlice = load('stable/instance/slice');
  ok(typeof instanceSlice === 'function');
  ok(instanceSlice({}) === undefined);
  ok(typeof instanceSlice([]) === 'function');
  instanceSlice = load('es/instance/slice');
  ok(typeof instanceSlice === 'function');
  ok(instanceSlice({}) === undefined);
  ok(typeof instanceSlice([]) === 'function');

  let instanceSome = load('features/instance/some');
  ok(typeof instanceSome === 'function');
  ok(instanceSome({}) === undefined);
  ok(typeof instanceSome([]) === 'function');
  ok(instanceSome([]).call([1, 2, 3], it => typeof it === 'number'));
  instanceSome = load('stable/instance/some');
  ok(typeof instanceSome === 'function');
  ok(instanceSome({}) === undefined);
  ok(typeof instanceSome([]) === 'function');
  ok(instanceSome([]).call([1, 2, 3], it => typeof it === 'number'));
  instanceSome = load('es/instance/some');
  ok(typeof instanceSome === 'function');
  ok(instanceSome({}) === undefined);
  ok(typeof instanceSome([]) === 'function');
  ok(instanceSome([]).call([1, 2, 3], it => typeof it === 'number'));

  let instanceSort = load('features/instance/sort');
  ok(typeof instanceSort === 'function');
  ok(instanceSort({}) === undefined);
  ok(typeof instanceSort([]) === 'function');
  instanceSort = load('stable/instance/sort');
  ok(typeof instanceSort === 'function');
  ok(instanceSort({}) === undefined);
  ok(typeof instanceSort([]) === 'function');
  instanceSort = load('es/instance/sort');
  ok(typeof instanceSort === 'function');
  ok(instanceSort({}) === undefined);
  ok(typeof instanceSort([]) === 'function');

  let instanceSplice = load('features/instance/splice');
  ok(typeof instanceSplice === 'function');
  ok(instanceSplice({}) === undefined);
  ok(typeof instanceSplice([]) === 'function');
  instanceSplice = load('stable/instance/splice');
  ok(typeof instanceSplice === 'function');
  ok(instanceSplice({}) === undefined);
  ok(typeof instanceSplice([]) === 'function');
  instanceSplice = load('es/instance/splice');
  ok(typeof instanceSplice === 'function');
  ok(instanceSplice({}) === undefined);
  ok(typeof instanceSplice([]) === 'function');

  let instanceStartsWith = load('features/instance/starts-with');
  ok(typeof instanceStartsWith === 'function');
  ok(instanceStartsWith({}) === undefined);
  ok(typeof instanceStartsWith('') === 'function');
  ok(instanceStartsWith('').call('qwe', 'qw'));
  instanceStartsWith = load('stable/instance/starts-with');
  ok(typeof instanceStartsWith === 'function');
  ok(instanceStartsWith({}) === undefined);
  ok(typeof instanceStartsWith('') === 'function');
  ok(instanceStartsWith('').call('qwe', 'qw'));
  instanceStartsWith = load('es/instance/starts-with');
  ok(typeof instanceStartsWith === 'function');
  ok(instanceStartsWith({}) === undefined);
  ok(typeof instanceStartsWith('') === 'function');
  ok(instanceStartsWith('').call('qwe', 'qw'));

  let instanceTrimEnd = load('features/instance/trim-end');
  ok(typeof instanceTrimEnd === 'function');
  ok(instanceTrimEnd({}) === undefined);
  ok(typeof instanceTrimEnd('') === 'function');
  ok(instanceTrimEnd('').call(' 1 ') === ' 1');
  instanceTrimEnd = load('stable/instance/trim-end');
  ok(typeof instanceTrimEnd === 'function');
  ok(instanceTrimEnd({}) === undefined);
  ok(typeof instanceTrimEnd('') === 'function');
  ok(instanceTrimEnd('').call(' 1 ') === ' 1');
  instanceTrimEnd = load('es/instance/trim-end');
  ok(typeof instanceTrimEnd === 'function');
  ok(instanceTrimEnd({}) === undefined);
  ok(typeof instanceTrimEnd('') === 'function');
  ok(instanceTrimEnd('').call(' 1 ') === ' 1');

  let instanceTrimLeft = load('features/instance/trim-left');
  ok(typeof instanceTrimLeft === 'function');
  ok(instanceTrimLeft({}) === undefined);
  ok(typeof instanceTrimLeft('') === 'function');
  ok(instanceTrimLeft('').call(' 1 ') === '1 ');
  instanceTrimLeft = load('stable/instance/trim-left');
  ok(typeof instanceTrimLeft === 'function');
  ok(instanceTrimLeft({}) === undefined);
  ok(typeof instanceTrimLeft('') === 'function');
  ok(instanceTrimLeft('').call(' 1 ') === '1 ');
  instanceTrimLeft = load('es/instance/trim-left');
  ok(typeof instanceTrimLeft === 'function');
  ok(instanceTrimLeft({}) === undefined);
  ok(typeof instanceTrimLeft('') === 'function');
  ok(instanceTrimLeft('').call(' 1 ') === '1 ');

  let instanceTrimRight = load('features/instance/trim-right');
  ok(typeof instanceTrimRight === 'function');
  ok(instanceTrimRight({}) === undefined);
  ok(typeof instanceTrimRight('') === 'function');
  ok(instanceTrimRight('').call(' 1 ') === ' 1');
  instanceTrimRight = load('stable/instance/trim-right');
  ok(typeof instanceTrimRight === 'function');
  ok(instanceTrimRight({}) === undefined);
  ok(typeof instanceTrimRight('') === 'function');
  ok(instanceTrimRight('').call(' 1 ') === ' 1');
  instanceTrimRight = load('es/instance/trim-right');
  ok(typeof instanceTrimRight === 'function');
  ok(instanceTrimRight({}) === undefined);
  ok(typeof instanceTrimRight('') === 'function');
  ok(instanceTrimRight('').call(' 1 ') === ' 1');

  let instanceTrimStart = load('features/instance/trim-start');
  ok(typeof instanceTrimStart === 'function');
  ok(instanceTrimStart({}) === undefined);
  ok(typeof instanceTrimStart('') === 'function');
  ok(instanceTrimStart('').call(' 1 ') === '1 ');
  instanceTrimStart = load('stable/instance/trim-start');
  ok(typeof instanceTrimStart === 'function');
  ok(instanceTrimStart({}) === undefined);
  ok(typeof instanceTrimStart('') === 'function');
  ok(instanceTrimStart('').call(' 1 ') === '1 ');
  instanceTrimStart = load('es/instance/trim-start');
  ok(typeof instanceTrimStart === 'function');
  ok(instanceTrimStart({}) === undefined);
  ok(typeof instanceTrimStart('') === 'function');
  ok(instanceTrimStart('').call(' 1 ') === '1 ');

  let instanceTrim = load('features/instance/trim');
  ok(typeof instanceTrim === 'function');
  ok(instanceTrim({}) === undefined);
  ok(typeof instanceTrim('') === 'function');
  ok(instanceTrim('').call(' 1 ') === '1');
  instanceTrim = load('stable/instance/trim');
  ok(typeof instanceTrim === 'function');
  ok(instanceTrim({}) === undefined);
  ok(typeof instanceTrim('') === 'function');
  ok(instanceTrim('').call(' 1 ') === '1');
  instanceTrim = load('es/instance/trim');
  ok(typeof instanceTrim === 'function');
  ok(instanceTrim({}) === undefined);
  ok(typeof instanceTrim('') === 'function');
  ok(instanceTrim('').call(' 1 ') === '1');

  const instanceUniqueBy = load('features/instance/unique-by');
  ok(typeof instanceUniqueBy === 'function');
  ok(instanceUniqueBy({}) === undefined);
  ok(typeof instanceUniqueBy([]) === 'function');
  ok(instanceUniqueBy([]).call([1, 2, 3, 2, 1]).length === 3);

  let instanceValues = load('features/instance/values');
  ok(typeof instanceValues === 'function');
  ok(instanceValues({}) === undefined);
  ok(typeof instanceValues([]) === 'function');
  ok(instanceValues([]).call([1, 2, 3]).next().value === 1);
  instanceValues = load('stable/instance/values');
  ok(typeof instanceValues === 'function');
  ok(instanceValues({}) === undefined);
  ok(typeof instanceValues([]) === 'function');
  ok(instanceValues([]).call([1, 2, 3]).next().value === 1);
  instanceValues = load('es/instance/values');
  ok(typeof instanceValues === 'function');
  ok(instanceValues({}) === undefined);
  ok(typeof instanceValues([]) === 'function');
  ok(instanceValues([]).call([1, 2, 3]).next().value === 1);

  for (const key in compat) load(`modules/${ key }`);
}

ok(typeof load('features/string/match') === 'function');
ok(typeof load('features/string/replace') === 'function');
ok(typeof load('features/string/search') === 'function');
ok(load('features/string/split')('a s d', ' ').length === 3);
ok(typeof load('features/array-buffer') === 'function');
ok(typeof load('features/array-buffer/constructor') === 'function');
ok(typeof load('features/array-buffer/is-view') === 'function');
load('features/array-buffer/slice');
ok(typeof load('features/data-view') === 'function');
ok(typeof load('features/typed-array/int8-array') === 'function');
ok(typeof load('features/typed-array/uint8-array') === 'function');
ok(typeof load('features/typed-array/uint8-clamped-array') === 'function');
ok(typeof load('features/typed-array/int16-array') === 'function');
ok(typeof load('features/typed-array/uint16-array') === 'function');
ok(typeof load('features/typed-array/int32-array') === 'function');
ok(typeof load('features/typed-array/uint32-array') === 'function');
ok(typeof load('features/typed-array/float32-array') === 'function');
ok(typeof load('features/typed-array/float64-array') === 'function');
load('features/typed-array/at');
load('features/typed-array/copy-within');
load('features/typed-array/entries');
load('features/typed-array/every');
load('features/typed-array/fill');
load('features/typed-array/filter');
load('features/typed-array/filter-out');
load('features/typed-array/find');
load('features/typed-array/find-index');
load('features/typed-array/for-each');
load('features/typed-array/from');
load('features/typed-array/includes');
load('features/typed-array/index-of');
load('features/typed-array/iterator');
load('features/typed-array/join');
load('features/typed-array/keys');
load('features/typed-array/last-index-of');
load('features/typed-array/map');
load('features/typed-array/of');
load('features/typed-array/reduce');
load('features/typed-array/reduce-right');
load('features/typed-array/reverse');
load('features/typed-array/set');
load('features/typed-array/slice');
load('features/typed-array/some');
load('features/typed-array/sort');
load('features/typed-array/subarray');
load('features/typed-array/to-locale-string');
load('features/typed-array/to-string');
load('features/typed-array/values');
ok(typeof load('features/typed-array').Uint32Array === 'function');
ok(typeof load('es/string/match') === 'function');
ok('next' in load('es/string/match-all')('a', /./g));
ok(typeof load('es/string/replace') === 'function');
ok(typeof load('es/string/search') === 'function');
ok(load('es/string/split')('a s d', ' ').length === 3);
ok(typeof load('es/array-buffer') === 'function');
ok(typeof load('es/array-buffer/constructor') === 'function');
ok(typeof load('es/array-buffer/is-view') === 'function');
load('es/array-buffer/slice');
ok(typeof load('es/data-view') === 'function');
ok(typeof load('es/typed-array/int8-array') === 'function');
ok(typeof load('es/typed-array/uint8-array') === 'function');
ok(typeof load('es/typed-array/uint8-clamped-array') === 'function');
ok(typeof load('es/typed-array/int16-array') === 'function');
ok(typeof load('es/typed-array/uint16-array') === 'function');
ok(typeof load('es/typed-array/int32-array') === 'function');
ok(typeof load('es/typed-array/uint32-array') === 'function');
ok(typeof load('es/typed-array/float32-array') === 'function');
ok(typeof load('es/typed-array/float64-array') === 'function');
load('es/typed-array/copy-within');
load('es/typed-array/entries');
load('es/typed-array/every');
load('es/typed-array/fill');
load('es/typed-array/filter');
load('es/typed-array/find');
load('es/typed-array/find-index');
load('es/typed-array/for-each');
load('es/typed-array/from');
load('es/typed-array/includes');
load('es/typed-array/index-of');
load('es/typed-array/iterator');
load('es/typed-array/join');
load('es/typed-array/keys');
load('es/typed-array/last-index-of');
load('es/typed-array/map');
load('es/typed-array/of');
load('es/typed-array/reduce');
load('es/typed-array/reduce-right');
load('es/typed-array/reverse');
load('es/typed-array/set');
load('es/typed-array/slice');
load('es/typed-array/some');
load('es/typed-array/sort');
load('es/typed-array/subarray');
load('es/typed-array/to-locale-string');
load('es/typed-array/to-string');
load('es/typed-array/values');
ok(typeof load('es/typed-array').Uint32Array === 'function');

// eslint-disable-next-line no-console
console.log(`\u001B[32mtested ${ tested } commonjs entry points\u001B[0m`);
