; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
; (pload "./defsSubst.scm")
; (pload "./omega.scm")
; (pload "./defsNT.scm")
; (pload "./defsAxiomsSpecial.scm")
; (pload "./defsAxioms.scm")
; (pload "./trivial.scm")
; (pload "./auxSC.scm")
; (pload "./auxGlobal_SHORT.scm")
; (pload "./auxLem1_SHORT.scm")

; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************


; ==================
;  Section: Lemma 1
; ==================
; contains Lemma 1 of the Normalization Proof

; Lemma: "LemmaOne"
; -----------------
; Lemma 1 of the Normalization Proof
; Sketch: (SC -> SN) & (SA ->  SC)

(set-goal
 (pf "all rho allnc rhos,r.TypJ rhos r rho ->
       (ex a^ SCr rhos rho a^r -> 
        all k.Fr rhos rho r k -> ex s N rhos rho r s) & 
       ((all k.Fr rhos rho r k -> ex s A rhos rho r s) -> 
        ex a^ SCr rhos rho a^r)"))

(ind)

; Base Case: Iota
(assume "rhos" "r" "[TypJ]")
(split)

; SC -> SN
(use "LemmaSCIotaUnfold")

; SA -> SC
(assume "[SA]")
(use "LemmaSCIotaFold")
(use "[TypJ]")
(assume "k" "[Fr]")

(cut (pf "ex s A rhos Iota r s"))
(assume "[ex.Body]")
(by-assume-with "[ex.Body]" "s" "[Body]")

(ex-intro (pt "s"))
(use "Ax2")
(use "[Body]")
(use-with "[SA]" (pt "k") "[Fr]")

; Step Case: rho to sig
(assume "rho" "sig" "[IHrho]" "[IHsig]" "rhos" "r"  "[TypJ]")
(split)

; goal: SC -> SN
(assume "[SC]" "k" "[Fr]")

(cut (pf "ex s N(rhos:+:(ExtCtx rhos k rho))sig(r(Var k))s"))
(assume "[ex.Body]")
(by-assume-with "[ex.Body]" "s" "[Body]")
(ex-intro (pt "ABS k rho s"))

(use "Ax1")
(use "[Fr]")
(use "[Body]")

(assert (pf "ex a^ SCr(rhos:+:(ExtCtx rhos k rho))rho a^(Var k)"))
 (use "[IHrho]")
(use "LemmaOneAux1" (pt "sig") (pt "r"))
(use "[Fr]")
(assume "k1" "[Fr 2]")
(ex-intro (pt "Var k"))
(use "Ax3")
(use "LemmaOneAux1" (pt "sig") (pt "r"))
(use "[Fr]")
(assume "[SC 2]")

(use "[IHsig]" (pt "k+1"))
(use "LemmaOneAux2" (pt "sig") (pt "r"))
(use "[Fr]")

(use "LemmaSCUnfold" (pt "rho"))
(use "[SC]")
(use "[SC 2]")
(use "LemmaOneAux3")
(use "[Fr]")

; goal: SA -> SC
(assume "[SA]")
(use "LemmaSCFold")
(use "[TypJ]")
(assume "sigs" "s" "[SC]")
(use "[IHsig]")
(use "TypJAppIntro" (pt "rho"))
(use "[TypJ]")
(use "LemmaOneAux8")
(prop)

(assume "k" "[Fr]")
(cut (pf "ex t A rhos(rho to sig)r t"))
(assume "[ex.Body]")
(by-assume-with "[ex.Body]" "r1" "[Body]")

(cut (pf "ex s1 N(rhos:+:sigs)rho s s1"))
(assume "[ex.Body 2]")
(by-assume-with "[ex.Body 2]" "s1" "[Body 2]")

(ex-intro (pt "r1 s1"))
(use "Ax4" (pt "rho"))
(use "Ax10")
(use "[Body]")
(use "LemmaOneAux8")
(prop)

(use "[Body 2]")
(use "[IHrho]" (pt "k"))
(use "LemmaOneAux8")
(prop)

(use "[SC]")
(use "LemmaOneAux5" (pt "sig") (pt "r"))
(use "[Fr]")

(use "LemmaOneAux8")
(prop)

(use "[SA]" (pt "k"))
(use "LemmaOneAux7" (pt "sigs") (pt "s"))
(use "[Fr]")
(use "[TypJ]")
(save "LemmaOne")
