
; file: e0stind.scm

; subterm « (strict except for Zero)

(add-program-constant
 "subterm"
 (mk-arrow (make-alg "ord") (make-alg "ord") (make-alg "boole"))
 1 'const 2)



(add-token
 "«"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "subterm")) x y
   )
 )
)


(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "subterm"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "«"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f
     )
   )
 )
)




(add-computation-rule (pt "subterm a Zero") (pt "a=Zero"))
(add-computation-rule (pt "subterm a (OP b g)")
                      (pt "[if (a=b)(True)
                               ([if (a=g)(True)
                                    ([if(subterm a b)(True)(subterm a g)])
                               ])
                          ]"
                      )
)
;
(display-program-constants "subterm")

; Test for subterm

(term-to-string (nt (pt "subterm Zero Zero")))
; 0 subterm 0 => True
(term-to-string (nt (pt "subterm (OP Zero Zero) Zero")))
; ω^0+0 subterm 0 => False
(term-to-string (nt (pt "subterm Zero (OP Zero Zero)")))
; 0 subterm ω^0+0 => True
(term-to-string (nt (pt "subterm (OP Zero Zero) (OP Zero Zero)")))
; ω^0+0 subterm ω^0+0 => False
(term-to-string (nt (pt "Zero « (OP a Zero)")))
; 0 subterm ω^α+0 => True



; Zero subterm aller

(term-to-string (nt (pt "Zero « a")))
; 0 subterm a => ?

(set-goal (pf "all a.subterm Zero a"))
(ind)

(prop)
(assume "a" "b")
(strip)
(ng)
(simp 1)
(prop)

; QED

(add-rewrite-rule (pt "subterm Zero a") (pt "True"))
(display-program-constants "subterm")

(term-to-string (nt (pt "subterm Zero a")))
; 0 subterm a => True




; STtrans: ST relation is transitive

(display-program-constants "subterm")
(display "\n a«b -> b«g -> a«g \n")
(set-goal (pf "all a,b.a«b -> b«g -> a«g"))

(ind); on g
(assume "a" "b")
(ng)
(strip)
(cut (pf"subterm a b"))
(simp 2)
(prop)
(use 1)

(assume "g1" "g2")
(strip 2)
(assume "a" "b")

(casedist (pt"b=g1"))
(strip)
(casedist (pt "a=g1"))
(strip)
(simp 6)
(prop)
(strip)
(casedist (pt "a=g2"))
(strip)
(simp 7)
(prop)
(strip)
(cut (pf"subterm a g1"))
(strip)
(ng)
(simp 6)
(simp 7)
(simp 8)
(prop)
(cut (pf"subterm a b"))
(simp 3)
(prop)
(use 4)

; ?_14: (b=g1 -> F)
;      -> a«b -> b«OP g1 g2 -> a«OP g1 g2

(strip)
(casedist (pt"b=g2"))
(strip)
(cut (pf"subterm a g2"))
(strip)
(ng)
(simp 7)
(prop)
(cut (pf"subterm a b"))
(simp 6)
(prop)
(use 4)

; ?_37: (b=g2 -> F) -> a«OP g1 g2

(strip)
(casedist (pt "subterm b g1"))
(strip)
(cut (pf"subterm a g1"))
(strip)
(ng)
(simp 8)
(prop)
(use 1 (pt "b"))
(use 4)
(use 7)

; ?_49: (b«g1 -> F) -> a«OP g1 g2

(strip)
(cut (pf "subterm b g2"))
(strip)
(cut (pf"subterm a g2"))
(strip)
(ng)
(simp 9)
(prop)
(use 2 (pt "b"))
(use 4)
(use 8)

; ?_60: b«g2

(cut (pf"b«OP g1 g2"))
(ng)
(simp 3)
(simp 6)
(simp 7)
(prop)
(use 5)

; QED

(save "STtrans")
(display-theorems "STtrans")





; SubTermPower

(display-program-constants "subterm")
(set-goal (pf "subterm y x
               -> subterm x(OP a b)
               -> (subterm y a -> F)
               -> subterm y b"
          )
)

(assume "y" "x" "a" "b")
(strip)
(casedist (pt"x=b"))

; ?_4: x=b -> subterm y b
(strip)
(cut (pf "subterm y x"))
(simp 4)
(prop)
(use 1)

(strip)
(casedist (pt"x=a"))

; ?_11: x=a -> subterm y b
(strip)
(cut (pf"F"))
(prop); intuitionistic logic !!!
(use 3)
(cut (pf"a=x"))
(strip)
(simp 6)
(use 1)
(simp 5)
(prop)

; ?_12: (a=x -> F) -> subterm y b
(strip)
(casedist (pt"subterm x a"))
(strip)
(cut (pf"subterm y a"))
(strip)
(cut (pf"F"))
(prop); intuitionistic logic !!!
(use 3)
(use 7)
(use "STtrans" (pt "x"))
(use 1)
(use 6)

; ?_24: (subterm x a -> F) -> subterm y b
(strip)
;(cut (pf"(x=a->F) -> ( (x=b->F)->(subterm x a->F) -> (subterm x b))"))
(cut (pf"(x=a->F) -> (x=b->F)->(subterm x a->F) -> (subterm x b)"))
(strip)
(use "STtrans" (pt "x"))
(use 1)
(use 7)
(use 5)
(use 4)
(use 6)
(strip)
(cut (pf "subterm x(OP a b)"))
(ng)
(simp 5)
(simp 8)
(simp 6)
(prop)
(use 2)

; QED

(save "SubTermPower")
(display-theorems  "SubTermPower")






; STind

(display-program-constants "subterm")

(add-pvar-name "A" (make-arity (py "ord")))

(set-goal(pf "A^ Zero
              -> (all a.(all x.subterm x a -> A^ x) -> A^ a)
              -> all a A^ a"
         )
)

(strip)

; ; We need an auxiliary claim to get the induction through
(cut (pf "all b,y.subterm y b -> A^ y"))

; From the auxiliary claim we easily obtain the claim:
(strip)
(use 2)
(use 3)

; ; Now the proof of the generalized claim
; ?_4: all b,y.subterm y b -> A^y
(ind)

; ?_7: all y.subterm y Zero -> A^y
(strip)
(cut (pf"y=Zero"))
(strip)
(simp 4)
(use 1)
(cut (pf"subterm y Zero"))
(prop)
(use 3)

(assume "x" "y")
(strip 2)
(assume "z")
(strip)
(use 2)
(assume "t")
(strip)


(casedist(pt"subterm t x"))
(use 3)
(cut (pf"(subterm t x -> F)->subterm t y"))
(strip)
(cut (pf"subterm t y"))
(use 4)
(use 7)
(use 8)
(cut (pf"subterm z(OP x y)"))
(use "SubTermPower")
(use 6)
(use 5)

; ok, ?_32 is proved.  Proof finished.

(save "STind")
(animate "STind")
(display-theorems  "STind")