#testcases continuecommand continueflag
Test rebase --continue with rebasestate written by legacy client

  $ cat >> $HGRCPATH <<EOF
  > [extensions]
  > rebase=
  > drawdag=$TESTDIR/drawdag.py
  > EOF

#if continueflag
  $ cat >> $HGRCPATH <<EOF
  > [alias]
  > continue = rebase --continue
  > EOF
#endif

  $ hg init
  $ hg debugdrawdag <<'EOF'
  >    D H
  >    | |
  >    C G
  >    | |
  >    B F
  >    | |
  >  Z A E
  >   \|/
  >    R
  > EOF
  $ for r in A B C D E F G H R Z
  > do
  >   eval node_$r=$(hg log -r $r -T '{node}')
  > done

rebasestate generated by a legacy client running "hg rebase -r B+D+E+G+H -d Z"

  $ touch .hg/last-message.txt
  $ cat > .hg/rebasestate <<EOF
  > 0000000000000000000000000000000000000000
  > $node_Z
  > 0000000000000000000000000000000000000000
  > 0
  > 0
  > 0
  > 
  > $node_A:-2
  > $node_E:0000000000000000000000000000000000000000
  > $node_B:0000000000000000000000000000000000000000
  > $node_F:-3
  > $node_C:-3
  > $node_G:0000000000000000000000000000000000000000
  > $node_D:0000000000000000000000000000000000000000
  > $node_H:0000000000000000000000000000000000000000
  > EOF

#if continuecommand
  $ hg continue --dry-run
  rebase in progress, will be resumed
#endif

  $ hg continue
  rebasing 4:c1e6b162678d "B" (B)
  rebasing 8:6f7a236de685 "D" (D)
  rebasing 2:de008c61a447 "E" (E)
  rebasing 7:d2fa1c02b240 "G" (G)
  rebasing 9:6582e6951a9c "H" (H tip)
  warning: orphaned descendants detected, not stripping c1e6b162678d, de008c61a447
  saved backup bundle to $TESTTMP/.hg/strip-backup/6f7a236de685-9880a3dc-rebase.hg

  $ hg log -G -T '{rev}:{node|short} {desc}\n'
  o  11:721b8da0a708 H
  |
  o  10:9d65695ec3c2 G
  |
  o  9:21c8397a5d68 E
  |
  | o  8:fc52970345e8 D
  | |
  | o  7:eac96551b107 B
  |/
  | o  6:bd5548558fcf C
  | |
  | | o  5:aeba276fcb7d F
  | | |
  | o |  4:c1e6b162678d B
  | | |
  o | |  3:f424eb6a8c01 Z
  | | |
  +---o  2:de008c61a447 E
  | |
  | o  1:21a6c4502885 A
  |/
  o  0:b41ce7760717 R
  
