# Matomo DDEV environment

**WARNING**: Matomo DDEV environment can be helpful when developing for Matomo, to be able to create or test new plugins locally, to run unit, integration, system or UI tests, but it is **highly discouraged** to use DDEV environments to run or host publicly accessible production installations of Matomo.

## Prerequisites

Before you begin, make sure you have DDEV installed. If you don't have it yet, follow the installation instructions in the official [DDEV documentation](https://ddev.readthedocs.io/en/stable/).

## Setup steps

### 1. Start the environment

Once DDEV is installed, navigate to your project directory and run:

```
ddev start
```

This command will start the DDEV environment for local development. By default, your local environment will be accessible at [https://matomo.ddev.site](https://matomo.ddev.site).

You can also open this URL directly in your browser by running:

```
ddev launch
```

This will automatically open the default browser and take you to the Matomo setup page.

### 2. Set up Matomo using the UI installer

Follow the on-screen instructions in the UI installer to complete the Matomo setup. This will configure the necessary database and settings for your local instance.

### 3. Set up the development environment

After Matomo is set up, you can initialize the development environment by running:

```
ddev matomo:init:dev
```

This command will set up the environment for development, installing the additional dependencies required.

### 4. Set up the testing environment

After Matomo is set up, you can initialize the testing environment by running:

```
ddev matomo:init:tests
```

This command will set up the environment for running tests, ensuring everything is in place for the UI and other automated tests.

## Usage

The command `ddev matomo:console` provides access to all Matomo console commands. Some useful commands include:

- `core:archive` – Run local archiving
- `generate:plugin` - Generate a new plugin/theme including all needed files
- `tests:run` – Run unit, integration, and system tests
- `tests:run-ui` – Run UI tests
- `tests:run-js` – Run tracker JavaScript tests
- `vue:build` - Builds vue modules for one or more plugins

For more information about Matomo development, check out the official [Matomo Developer Documentation](https://developer.matomo.org/).

## Known issues

Currently, the screenshots generated by UI tests do not match those generated in the CI environment. However, this does not affect the functionality of the tests themselves. The screenshots should still be good enough to verify that your changes or plugin are working correctly.
