## API Report File for "@lumino/widgets"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { CommandRegistry } from '@lumino/commands';
import { ConflatableMessage } from '@lumino/messaging';
import { ElementDataset } from '@lumino/virtualdom';
import { ElementInlineStyle } from '@lumino/virtualdom';
import { h } from '@lumino/virtualdom';
import { IDisposable } from '@lumino/disposable';
import { IIterable } from '@lumino/algorithm';
import { IIterator } from '@lumino/algorithm';
import { IMessageHandler } from '@lumino/messaging';
import { IObservableDisposable } from '@lumino/disposable';
import { ISignal } from '@lumino/signaling';
import { Message } from '@lumino/messaging';
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { VirtualElement } from '@lumino/virtualdom';

// @public
export namespace BoxEngine {
    export function adjust(sizers: ArrayLike<BoxSizer>, index: number, delta: number): void;
    export function calc(sizers: ArrayLike<BoxSizer>, space: number): number;
}

// @public
export class BoxLayout extends PanelLayout {
    constructor(options?: BoxLayout.IOptions);
    alignment: BoxLayout.Alignment;
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    direction: BoxLayout.Direction;
    dispose(): void;
    protected init(): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    spacing: number;
    }

// @public
export namespace BoxLayout {
    export type Alignment = 'start' | 'center' | 'end' | 'justify';
    export type Direction = ('left-to-right' | 'right-to-left' | 'top-to-bottom' | 'bottom-to-top');
    export function getSizeBasis(widget: Widget): number;
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        direction?: Direction;
        spacing?: number;
    }
    export function setSizeBasis(widget: Widget, value: number): void;
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class BoxPanel extends Panel {
    constructor(options?: BoxPanel.IOptions);
    alignment: BoxPanel.Alignment;
    direction: BoxPanel.Direction;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    spacing: number;
}

// @public
export namespace BoxPanel {
    export type Alignment = BoxLayout.Alignment;
    export type Direction = BoxLayout.Direction;
    export function getSizeBasis(widget: Widget): number;
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        direction?: Direction;
        layout?: BoxLayout;
        spacing?: number;
    }
    export function setSizeBasis(widget: Widget, value: number): void;
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class BoxSizer {
    done: boolean;
    maxSize: number;
    minSize: number;
    size: number;
    sizeHint: number;
    stretch: number;
}

// @public
export class CommandPalette extends Widget {
    constructor(options: CommandPalette.IOptions);
    addItem(options: CommandPalette.IItemOptions): CommandPalette.IItem;
    clearItems(): void;
    readonly commands: CommandRegistry;
    readonly contentNode: HTMLUListElement;
    dispose(): void;
    handleEvent(event: Event): void;
    readonly inputNode: HTMLInputElement;
    readonly items: ReadonlyArray<CommandPalette.IItem>;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    refresh(): void;
    removeItem(item: CommandPalette.IItem): void;
    removeItemAt(index: number): void;
    readonly renderer: CommandPalette.IRenderer;
    readonly searchNode: HTMLDivElement;
    }

// @public
export namespace CommandPalette {
    export interface IEmptyMessageRenderData {
        query: string;
    }
    export interface IHeaderRenderData {
        readonly category: string;
        readonly indices: ReadonlyArray<number> | null;
    }
    export interface IItem {
        readonly args: ReadonlyJSONObject;
        readonly caption: string;
        readonly category: string;
        readonly className: string;
        readonly command: string;
        readonly dataset: CommandRegistry.Dataset;
        readonly iconClass: string;
        readonly iconLabel: string;
        readonly isEnabled: boolean;
        readonly isToggled: boolean;
        readonly isVisible: boolean;
        readonly keyBinding: CommandRegistry.IKeyBinding | null;
        readonly label: string;
        readonly rank: number;
    }
    export interface IItemOptions {
        args?: ReadonlyJSONObject;
        category: string;
        command: string;
        rank?: number;
    }
    export interface IItemRenderData {
        readonly active: boolean;
        readonly indices: ReadonlyArray<number> | null;
        readonly item: IItem;
    }
    export interface IOptions {
        commands: CommandRegistry;
        renderer?: IRenderer;
    }
    export interface IRenderer {
        renderEmptyMessage(data: IEmptyMessageRenderData): VirtualElement;
        renderHeader(data: IHeaderRenderData): VirtualElement;
        renderItem(data: IItemRenderData): VirtualElement;
    }
    export class Renderer implements IRenderer {
        createIconClass(data: IItemRenderData): string;
        createItemClass(data: IItemRenderData): string;
        createItemDataset(data: IItemRenderData): ElementDataset;
        formatEmptyMessage(data: IEmptyMessageRenderData): h.Child;
        formatHeader(data: IHeaderRenderData): h.Child;
        formatItemCaption(data: IItemRenderData): h.Child;
        formatItemLabel(data: IItemRenderData): h.Child;
        formatItemShortcut(data: IItemRenderData): h.Child;
        renderEmptyMessage(data: IEmptyMessageRenderData): VirtualElement;
        renderHeader(data: IHeaderRenderData): VirtualElement;
        renderItem(data: IItemRenderData): VirtualElement;
        renderItemCaption(data: IItemRenderData): VirtualElement;
        renderItemContent(data: IItemRenderData): VirtualElement;
        renderItemIcon(data: IItemRenderData): VirtualElement;
        renderItemLabel(data: IItemRenderData): VirtualElement;
        renderItemShortcut(data: IItemRenderData): VirtualElement;
    }
    const defaultRenderer: Renderer;
}

// @public
export class ContextMenu {
    constructor(options: ContextMenu.IOptions);
    addItem(options: ContextMenu.IItemOptions): IDisposable;
    readonly menu: Menu;
    open(event: MouseEvent): boolean;
}

// @public
export namespace ContextMenu {
    export interface IItemOptions extends Menu.IItemOptions {
        rank?: number;
        selector: string;
    }
    export interface IOptions {
        commands: CommandRegistry;
        renderer?: Menu.IRenderer;
    }
}

// @public
export class DockLayout extends Layout {
    constructor(options: DockLayout.IOptions);
    addWidget(widget: Widget, options?: DockLayout.IAddOptions): void;
    protected attachWidget(widget: Widget): void;
    protected detachWidget(widget: Widget): void;
    dispose(): void;
    handles(): IIterator<HTMLDivElement>;
    hitTestTabAreas(clientX: number, clientY: number): DockLayout.ITabAreaGeometry | null;
    protected init(): void;
    readonly isEmpty: boolean;
    iter(): IIterator<Widget>;
    moveHandle(handle: HTMLDivElement, offsetX: number, offsetY: number): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    removeWidget(widget: Widget): void;
    readonly renderer: DockLayout.IRenderer;
    restoreLayout(config: DockLayout.ILayoutConfig): void;
    saveLayout(): DockLayout.ILayoutConfig;
    selectedWidgets(): IIterator<Widget>;
    spacing: number;
    tabBars(): IIterator<TabBar<Widget>>;
    widgets(): IIterator<Widget>;
}

// @public
export namespace DockLayout {
    export type AreaConfig = ITabAreaConfig | ISplitAreaConfig;
    export interface IAddOptions {
        mode?: InsertMode;
        ref?: Widget | null;
    }
    export interface ILayoutConfig {
        main: AreaConfig | null;
    }
    export type InsertMode = (
    /**
     * The area to the top of the reference widget.
     *
     * The widget will be inserted just above the reference widget.
     *
     * If the reference widget is null or invalid, the widget will be
     * inserted at the top edge of the dock layout.
     */
    'split-top' |
    /**
     * The area to the left of the reference widget.
     *
     * The widget will be inserted just left of the reference widget.
     *
     * If the reference widget is null or invalid, the widget will be
     * inserted at the left edge of the dock layout.
     */
    'split-left' |
    /**
     * The area to the right of the reference widget.
     *
     * The widget will be inserted just right of the reference widget.
     *
     * If the reference widget is null or invalid, the widget will be
     * inserted  at the right edge of the dock layout.
     */
    'split-right' |
    /**
     * The area to the bottom of the reference widget.
     *
     * The widget will be inserted just below the reference widget.
     *
     * If the reference widget is null or invalid, the widget will be
     * inserted at the bottom edge of the dock layout.
     */
    'split-bottom' |
    /**
     * The tab position before the reference widget.
     *
     * The widget will be added as a tab before the reference widget.
     *
     * If the reference widget is null or invalid, a sensible default
     * will be used.
     */
    'tab-before' |
    /**
     * The tab position after the reference widget.
     *
     * The widget will be added as a tab after the reference widget.
     *
     * If the reference widget is null or invalid, a sensible default
     * will be used.
     */
    'tab-after');
    export interface IOptions {
        renderer: IRenderer;
        spacing?: number;
    }
    export interface IRenderer {
        createHandle(): HTMLDivElement;
        createTabBar(): TabBar<Widget>;
    }
    export interface ISplitAreaConfig {
        children: AreaConfig[];
        orientation: 'horizontal' | 'vertical';
        sizes: number[];
        type: 'split-area';
    }
    export interface ITabAreaConfig {
        currentIndex: number;
        type: 'tab-area';
        widgets: Widget[];
    }
    export interface ITabAreaGeometry {
        bottom: number;
        height: number;
        left: number;
        right: number;
        tabBar: TabBar<Widget>;
        top: number;
        width: number;
        x: number;
        y: number;
    }
}

// @public
export class DockPanel extends Widget {
    constructor(options?: DockPanel.IOptions);
    activateWidget(widget: Widget): void;
    addWidget(widget: Widget, options?: DockPanel.IAddOptions): void;
    dispose(): void;
    handleEvent(event: Event): void;
    handles(): IIterator<HTMLDivElement>;
    readonly isEmpty: boolean;
    readonly layoutModified: ISignal<this, void>;
    mode: DockPanel.Mode;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    readonly overlay: DockPanel.IOverlay;
    processMessage(msg: Message): void;
    readonly renderer: DockPanel.IRenderer;
    restoreLayout(config: DockPanel.ILayoutConfig): void;
    saveLayout(): DockPanel.ILayoutConfig;
    selectedWidgets(): IIterator<Widget>;
    selectWidget(widget: Widget): void;
    spacing: number;
    tabBars(): IIterator<TabBar<Widget>>;
    tabsMovable: boolean;
    widgets(): IIterator<Widget>;
}

// @public
export namespace DockPanel {
    export type IAddOptions = DockLayout.IAddOptions;
    export interface IEdges {
        bottom: number;
        left: number;
        right: number;
        top: number;
    }
    export type ILayoutConfig = DockLayout.ILayoutConfig;
    export type InsertMode = DockLayout.InsertMode;
    export interface IOptions {
        edges?: IEdges;
        mode?: DockPanel.Mode;
        overlay?: IOverlay;
        renderer?: IRenderer;
        spacing?: number;
        tabsMovable?: boolean;
    }
    export interface IOverlay {
        hide(delay: number): void;
        readonly node: HTMLDivElement;
        show(geo: IOverlayGeometry): void;
    }
    export interface IOverlayGeometry {
        bottom: number;
        left: number;
        right: number;
        top: number;
    }
    export type IRenderer = DockLayout.IRenderer;
    export type Mode = (
    /**
     * The single document mode.
     *
     * In this mode, only a single widget is visible at a time, and that
     * widget fills the available layout space. No tab bars are visible.
     */
    'single-document' |
    /**
     * The multiple document mode.
     *
     * In this mode, multiple documents are displayed in separate tab
     * areas, and those areas can be individually resized by the user.
     */
    'multiple-document');
    export class Overlay implements IOverlay {
        constructor();
        hide(delay: number): void;
        readonly node: HTMLDivElement;
        show(geo: IOverlayGeometry): void;
        }
    export class Renderer implements IRenderer {
        createHandle(): HTMLDivElement;
        createTabBar(): TabBar<Widget>;
    }
    const defaultRenderer: Renderer;
}

// @public
export class FocusTracker<T extends Widget> implements IDisposable {
    constructor();
    readonly activeChanged: ISignal<this, FocusTracker.IChangedArgs<T>>;
    readonly activeWidget: T | null;
    add(widget: T): void;
    readonly currentChanged: ISignal<this, FocusTracker.IChangedArgs<T>>;
    readonly currentWidget: T | null;
    dispose(): void;
    focusNumber(widget: T): number;
    handleEvent(event: Event): void;
    has(widget: T): boolean;
    readonly isDisposed: boolean;
    remove(widget: T): void;
    readonly widgets: ReadonlyArray<T>;
    }

// @public
export namespace FocusTracker {
    export interface IChangedArgs<T extends Widget> {
        newValue: T | null;
        oldValue: T | null;
    }
}

// @public
export class GridLayout extends Layout {
    constructor(options?: GridLayout.IOptions);
    addWidget(widget: Widget): void;
    protected attachWidget(widget: Widget): void;
    columnCount: number;
    columnSpacing: number;
    columnStretch(index: number): number;
    protected detachWidget(widget: Widget): void;
    dispose(): void;
    protected init(): void;
    iter(): IIterator<Widget>;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    removeWidget(widget: Widget): void;
    rowCount: number;
    rowSpacing: number;
    rowStretch(index: number): number;
    setColumnStretch(index: number, value: number): void;
    setRowStretch(index: number, value: number): void;
    }

// @public
export namespace GridLayout {
    export function getCellConfig(widget: Widget): ICellConfig;
    export interface ICellConfig {
        readonly column: number;
        readonly columnSpan: number;
        readonly row: number;
        readonly rowSpan: number;
    }
    export interface IOptions extends Layout.IOptions {
        columnCount?: number;
        columnSpacing?: number;
        rowCount?: number;
        rowSpacing?: number;
    }
    export function setCellConfig(widget: Widget, value: Partial<ICellConfig>): void;
}

// @public
export abstract class Layout implements IIterable<Widget>, IDisposable {
    constructor(options?: Layout.IOptions);
    dispose(): void;
    fitPolicy: Layout.FitPolicy;
    protected init(): void;
    readonly isDisposed: boolean;
    abstract iter(): IIterator<Widget>;
    protected onAfterAttach(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onAfterHide(msg: Message): void;
    protected onAfterShow(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeDetach(msg: Message): void;
    protected onBeforeHide(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    parent: Widget | null;
    processParentMessage(msg: Message): void;
    abstract removeWidget(widget: Widget): void;
}

// @public
export namespace Layout {
    export type FitPolicy = (
    /**
     * No size constraint will be applied to the parent widget.
     */
    'set-no-constraint' |
    /**
     * The computed min size will be applied to the parent widget.
     */
    'set-min-size');
    export function getHorizontalAlignment(widget: Widget): HorizontalAlignment;
    export function getVerticalAlignment(widget: Widget): VerticalAlignment;
    export type HorizontalAlignment = 'left' | 'center' | 'right';
    export interface IOptions {
        fitPolicy?: FitPolicy;
    }
    export function setHorizontalAlignment(widget: Widget, value: HorizontalAlignment): void;
    export function setVerticalAlignment(widget: Widget, value: VerticalAlignment): void;
    export type VerticalAlignment = 'top' | 'center' | 'bottom';
}

// @public
export class LayoutItem implements IDisposable {
    constructor(widget: Widget);
    dispose(): void;
    fit(): void;
    readonly isAttached: boolean;
    readonly isDisposed: boolean;
    readonly isHidden: boolean;
    readonly isVisible: boolean;
    readonly maxHeight: number;
    readonly maxWidth: number;
    readonly minHeight: number;
    readonly minWidth: number;
    update(left: number, top: number, width: number, height: number): void;
    readonly widget: Widget;
    }

// @public
export class Menu extends Widget {
    constructor(options: Menu.IOptions);
    readonly aboutToClose: ISignal<this, void>;
    activateNextItem(): void;
    activatePreviousItem(): void;
    activeIndex: number;
    activeItem: Menu.IItem | null;
    addItem(options: Menu.IItemOptions): Menu.IItem;
    readonly childMenu: Menu | null;
    clearItems(): void;
    readonly commands: CommandRegistry;
    readonly contentNode: HTMLUListElement;
    dispose(): void;
    handleEvent(event: Event): void;
    insertItem(index: number, options: Menu.IItemOptions): Menu.IItem;
    readonly items: ReadonlyArray<Menu.IItem>;
    readonly leafMenu: Menu;
    readonly menuRequested: ISignal<this, 'next' | 'previous'>;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onCloseRequest(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    open(x: number, y: number, options?: Menu.IOpenOptions): void;
    readonly parentMenu: Menu | null;
    removeItem(item: Menu.IItem): void;
    removeItemAt(index: number): void;
    readonly renderer: Menu.IRenderer;
    readonly rootMenu: Menu;
    triggerActiveItem(): void;
}

// @public
export namespace Menu {
    export interface IItem {
        readonly args: ReadonlyJSONObject;
        readonly caption: string;
        readonly className: string;
        readonly command: string;
        readonly dataset: CommandRegistry.Dataset;
        // @deprecated (undocumented)
        readonly icon: string;
        readonly iconClass: string;
        readonly iconLabel: string;
        readonly isEnabled: boolean;
        readonly isToggled: boolean;
        readonly isVisible: boolean;
        readonly keyBinding: CommandRegistry.IKeyBinding | null;
        readonly label: string;
        readonly mnemonic: number;
        readonly submenu: Menu | null;
        readonly type: ItemType;
    }
    export interface IItemOptions {
        args?: ReadonlyJSONObject;
        command?: string;
        submenu?: Menu | null;
        type?: ItemType;
    }
    export interface IOpenOptions {
        forceX?: boolean;
        forceY?: boolean;
    }
    export interface IOptions {
        commands: CommandRegistry;
        renderer?: IRenderer;
    }
    export interface IRenderData {
        readonly active: boolean;
        readonly collapsed: boolean;
        readonly item: IItem;
    }
    export interface IRenderer {
        renderItem(data: IRenderData): VirtualElement;
    }
    export type ItemType = 'command' | 'submenu' | 'separator';
    export class Renderer implements IRenderer {
        constructor();
        createIconClass(data: IRenderData): string;
        createItemClass(data: IRenderData): string;
        createItemDataset(data: IRenderData): ElementDataset;
        formatLabel(data: IRenderData): h.Child;
        formatShortcut(data: IRenderData): h.Child;
        renderIcon(data: IRenderData): VirtualElement;
        renderItem(data: IRenderData): VirtualElement;
        renderLabel(data: IRenderData): VirtualElement;
        renderShortcut(data: IRenderData): VirtualElement;
        renderSubmenu(data: IRenderData): VirtualElement;
    }
    const defaultRenderer: Renderer;
}

// @public
export class MenuBar extends Widget {
    constructor(options?: MenuBar.IOptions);
    activeIndex: number;
    activeMenu: Menu | null;
    addMenu(menu: Menu): void;
    readonly childMenu: Menu | null;
    clearMenus(): void;
    readonly contentNode: HTMLUListElement;
    dispose(): void;
    handleEvent(event: Event): void;
    insertMenu(index: number, menu: Menu): void;
    readonly menus: ReadonlyArray<Menu>;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    openActiveMenu(): void;
    removeMenu(menu: Menu): void;
    removeMenuAt(index: number): void;
    readonly renderer: MenuBar.IRenderer;
}

// @public
export namespace MenuBar {
    export interface IOptions {
        renderer?: IRenderer;
    }
    export interface IRenderData {
        readonly active: boolean;
        readonly title: Title<Widget>;
    }
    export interface IRenderer {
        renderItem(data: IRenderData): VirtualElement;
    }
    export class Renderer implements IRenderer {
        constructor();
        createIconClass(data: IRenderData): string;
        createItemClass(data: IRenderData): string;
        createItemDataset(data: IRenderData): ElementDataset;
        formatLabel(data: IRenderData): h.Child;
        renderIcon(data: IRenderData): VirtualElement;
        renderItem(data: IRenderData): VirtualElement;
        renderLabel(data: IRenderData): VirtualElement;
    }
    const defaultRenderer: Renderer;
}

// @public
export class Panel extends Widget {
    constructor(options?: Panel.IOptions);
    addWidget(widget: Widget): void;
    insertWidget(index: number, widget: Widget): void;
    readonly widgets: ReadonlyArray<Widget>;
}

// @public
export namespace Panel {
    export interface IOptions {
        layout?: PanelLayout;
    }
}

// @public
export class PanelLayout extends Layout {
    addWidget(widget: Widget): void;
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    protected init(): void;
    insertWidget(index: number, widget: Widget): void;
    iter(): IIterator<Widget>;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    removeWidget(widget: Widget): void;
    removeWidgetAt(index: number): void;
    readonly widgets: ReadonlyArray<Widget>;
    }

// @public
export class ScrollBar extends Widget {
    constructor(options?: ScrollBar.IOptions);
    readonly decrementNode: HTMLDivElement;
    handleEvent(event: Event): void;
    readonly incrementNode: HTMLDivElement;
    maximum: number;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    orientation: ScrollBar.Orientation;
    page: number;
    readonly pageRequested: ISignal<this, 'decrement' | 'increment'>;
    readonly stepRequested: ISignal<this, 'decrement' | 'increment'>;
    readonly thumbMoved: ISignal<this, number>;
    readonly thumbNode: HTMLDivElement;
    readonly trackNode: HTMLDivElement;
    value: number;
    }

// @public
export namespace ScrollBar {
    export interface IOptions {
        maximum?: number;
        orientation?: Orientation;
        page?: number;
        value?: number;
    }
    export type Orientation = 'horizontal' | 'vertical';
}

// @public
export class SingletonLayout extends Layout {
    protected attachWidget(widget: Widget): void;
    protected detachWidget(widget: Widget): void;
    dispose(): void;
    protected init(): void;
    iter(): IIterator<Widget>;
    removeWidget(widget: Widget): void;
    widget: Widget | null;
    }

// @public
export class SplitLayout extends PanelLayout {
    constructor(options: SplitLayout.IOptions);
    alignment: SplitLayout.Alignment;
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    readonly handles: ReadonlyArray<HTMLDivElement>;
    protected init(): void;
    moveHandle(index: number, position: number): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    orientation: SplitLayout.Orientation;
    relativeSizes(): number[];
    readonly renderer: SplitLayout.IRenderer;
    setRelativeSizes(sizes: number[]): void;
    spacing: number;
    }

// @public
export namespace SplitLayout {
    export type Alignment = 'start' | 'center' | 'end' | 'justify';
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        orientation?: Orientation;
        renderer: IRenderer;
        spacing?: number;
    }
    export interface IRenderer {
        createHandle(): HTMLDivElement;
    }
    export type Orientation = 'horizontal' | 'vertical';
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class SplitPanel extends Panel {
    constructor(options?: SplitPanel.IOptions);
    alignment: SplitPanel.Alignment;
    dispose(): void;
    handleEvent(event: Event): void;
    readonly handles: ReadonlyArray<HTMLDivElement>;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    orientation: SplitPanel.Orientation;
    relativeSizes(): number[];
    readonly renderer: SplitPanel.IRenderer;
    setRelativeSizes(sizes: number[]): void;
    spacing: number;
}

// @public
export namespace SplitPanel {
    export type Alignment = SplitLayout.Alignment;
    export function getStretch(widget: Widget): number;
    export interface IOptions {
        alignment?: Alignment;
        layout?: SplitLayout;
        orientation?: Orientation;
        renderer?: IRenderer;
        spacing?: number;
    }
    export type IRenderer = SplitLayout.IRenderer;
    export type Orientation = SplitLayout.Orientation;
    const defaultRenderer: Renderer;
    export class Renderer implements IRenderer {
        createHandle(): HTMLDivElement;
    }
    export function setStretch(widget: Widget, value: number): void;
}

// @public
export class StackedLayout extends PanelLayout {
    protected attachWidget(index: number, widget: Widget): void;
    protected detachWidget(index: number, widget: Widget): void;
    dispose(): void;
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildHidden(msg: Widget.ChildMessage): void;
    protected onChildShown(msg: Widget.ChildMessage): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    }

// @public
export class StackedPanel extends Panel {
    constructor(options?: StackedPanel.IOptions);
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    readonly widgetRemoved: ISignal<this, Widget>;
    }

// @public
export namespace StackedPanel {
    export interface IOptions {
        layout?: StackedLayout;
    }
}

// @public
export class TabBar<T> extends Widget {
    constructor(options?: TabBar.IOptions<T>);
    addTab(value: Title<T> | Title.IOptions<T>): Title<T>;
    allowDeselect: boolean;
    clearTabs(): void;
    readonly contentNode: HTMLUListElement;
    readonly currentChanged: ISignal<this, TabBar.ICurrentChangedArgs<T>>;
    currentIndex: number;
    currentTitle: Title<T> | null;
    dispose(): void;
    handleEvent(event: Event): void;
    insertBehavior: TabBar.InsertBehavior;
    insertTab(index: number, value: Title<T> | Title.IOptions<T>): Title<T>;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onUpdateRequest(msg: Message): void;
    orientation: TabBar.Orientation;
    releaseMouse(): void;
    removeBehavior: TabBar.RemoveBehavior;
    removeTab(title: Title<T>): void;
    removeTabAt(index: number): void;
    readonly renderer: TabBar.IRenderer<T>;
    readonly tabActivateRequested: ISignal<this, TabBar.ITabActivateRequestedArgs<T>>;
    readonly tabCloseRequested: ISignal<this, TabBar.ITabCloseRequestedArgs<T>>;
    readonly tabDetachRequested: ISignal<this, TabBar.ITabDetachRequestedArgs<T>>;
    readonly tabMoved: ISignal<this, TabBar.ITabMovedArgs<T>>;
    tabsMovable: boolean;
    readonly titles: ReadonlyArray<Title<T>>;
    }

// @public
export namespace TabBar {
    export interface ICurrentChangedArgs<T> {
        readonly currentIndex: number;
        readonly currentTitle: Title<T> | null;
        readonly previousIndex: number;
        readonly previousTitle: Title<T> | null;
    }
    export type InsertBehavior = (
    /**
     * The selected tab will not be changed.
     */
    'none' |
    /**
     * The inserted tab will be selected.
     */
    'select-tab' |
    /**
     * The inserted tab will be selected if the current tab is null.
     */
    'select-tab-if-needed');
    export interface IOptions<T> {
        allowDeselect?: boolean;
        insertBehavior?: TabBar.InsertBehavior;
        orientation?: TabBar.Orientation;
        removeBehavior?: TabBar.RemoveBehavior;
        renderer?: IRenderer<T>;
        tabsMovable?: boolean;
    }
    export interface IRenderData<T> {
        readonly current: boolean;
        readonly title: Title<T>;
        readonly zIndex: number;
    }
    export interface IRenderer<T> {
        readonly closeIconSelector: string;
        renderTab(data: IRenderData<T>): VirtualElement;
    }
    export interface ITabActivateRequestedArgs<T> {
        readonly index: number;
        readonly title: Title<T>;
    }
    export interface ITabCloseRequestedArgs<T> {
        readonly index: number;
        readonly title: Title<T>;
    }
    export interface ITabDetachRequestedArgs<T> {
        readonly clientX: number;
        readonly clientY: number;
        readonly index: number;
        readonly tab: HTMLElement;
        readonly title: Title<T>;
    }
    export interface ITabMovedArgs<T> {
        readonly fromIndex: number;
        readonly title: Title<T>;
        readonly toIndex: number;
    }
    export type Orientation = (
    /**
     * The tabs are arranged in a single row, left-to-right.
     *
     * The tab text orientation is horizontal.
     */
    'horizontal' |
    /**
     * The tabs are arranged in a single column, top-to-bottom.
     *
     * The tab text orientation is horizontal.
     */
    'vertical');
    export type RemoveBehavior = (
    /**
     * No tab will be selected.
     */
    'none' |
    /**
     * The tab after the removed tab will be selected if possible.
     */
    'select-tab-after' |
    /**
     * The tab before the removed tab will be selected if possible.
     */
    'select-tab-before' |
    /**
     * The previously selected tab will be selected if possible.
     */
    'select-previous-tab');
    export class Renderer implements IRenderer<any> {
        constructor();
        readonly closeIconSelector: string;
        createIconClass(data: IRenderData<any>): string;
        createTabClass(data: IRenderData<any>): string;
        createTabDataset(data: IRenderData<any>): ElementDataset;
        createTabKey(data: IRenderData<any>): string;
        createTabStyle(data: IRenderData<any>): ElementInlineStyle;
        renderCloseIcon(data: IRenderData<any>): VirtualElement;
        renderIcon(data: IRenderData<any>): VirtualElement;
        renderLabel(data: IRenderData<any>): VirtualElement;
        renderTab(data: IRenderData<any>): VirtualElement;
        }
    const defaultRenderer: Renderer;
}

// @public
export class TabPanel extends Widget {
    constructor(options?: TabPanel.IOptions);
    addWidget(widget: Widget): void;
    readonly currentChanged: ISignal<this, TabPanel.ICurrentChangedArgs>;
    currentIndex: number;
    currentWidget: Widget | null;
    insertWidget(index: number, widget: Widget): void;
    readonly stackedPanel: StackedPanel;
    readonly tabBar: TabBar<Widget>;
    tabPlacement: TabPanel.TabPlacement;
    tabsMovable: boolean;
    readonly widgets: ReadonlyArray<Widget>;
}

// @public
export namespace TabPanel {
    export interface ICurrentChangedArgs {
        currentIndex: number;
        currentWidget: Widget | null;
        previousIndex: number;
        previousWidget: Widget | null;
    }
    export interface IOptions {
        renderer?: TabBar.IRenderer<Widget>;
        tabPlacement?: TabPlacement;
        tabsMovable?: boolean;
    }
    export type TabPlacement = (
    /**
     * The tabs are placed as a row above the content.
     */
    'top' |
    /**
     * The tabs are placed as a column to the left of the content.
     */
    'left' |
    /**
     * The tabs are placed as a column to the right of the content.
     */
    'right' |
    /**
     * The tabs are placed as a row below the content.
     */
    'bottom');
}

// @public
export class Title<T> {
    constructor(options: Title.IOptions<T>);
    caption: string;
    readonly changed: ISignal<this, void>;
    className: string;
    closable: boolean;
    dataset: Title.Dataset;
    // @deprecated (undocumented)
    icon: string;
    iconClass: string;
    iconLabel: string;
    label: string;
    mnemonic: number;
    readonly owner: T;
}

// @public
export namespace Title {
    export type Dataset = {
        readonly [key: string]: string;
    };
    export interface IOptions<T> {
        caption?: string;
        className?: string;
        closable?: boolean;
        dataset?: Dataset;
        // @deprecated (undocumented)
        icon?: string;
        iconClass?: string;
        iconLabel?: string;
        label?: string;
        mnemonic?: number;
        owner: T;
    }
}

// @public
export class Widget implements IMessageHandler, IObservableDisposable {
    constructor(options?: Widget.IOptions);
    activate(): void;
    addClass(name: string): void;
    children(): IIterator<Widget>;
    clearFlag(flag: Widget.Flag): void;
    close(): void;
    contains(widget: Widget): boolean;
    readonly dataset: DOMStringMap;
    dispose(): void;
    readonly disposed: ISignal<this, void>;
    fit(): void;
    hasClass(name: string): boolean;
    hide(): void;
    id: string;
    readonly isAttached: boolean;
    readonly isDisposed: boolean;
    readonly isHidden: boolean;
    readonly isVisible: boolean;
    layout: Layout | null;
    readonly node: HTMLElement;
    protected notifyLayout(msg: Message): void;
    protected onActivateRequest(msg: Message): void;
    protected onAfterAttach(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onAfterHide(msg: Message): void;
    protected onAfterShow(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeDetach(msg: Message): void;
    protected onBeforeHide(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onChildAdded(msg: Widget.ChildMessage): void;
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    protected onCloseRequest(msg: Message): void;
    protected onFitRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    protected onUpdateRequest(msg: Message): void;
    parent: Widget | null;
    processMessage(msg: Message): void;
    removeClass(name: string): void;
    setFlag(flag: Widget.Flag): void;
    setHidden(hidden: boolean): void;
    show(): void;
    testFlag(flag: Widget.Flag): boolean;
    readonly title: Title<Widget>;
    toggleClass(name: string, force?: boolean): boolean;
    update(): void;
}

// @public
export namespace Widget {
    export function attach(widget: Widget, host: HTMLElement, ref?: HTMLElement | null): void;
    export class ChildMessage extends Message {
        constructor(type: string, child: Widget);
        readonly child: Widget;
    }
    export function detach(widget: Widget): void;
    export enum Flag {
        DisallowLayout = 16,
        IsAttached = 2,
        IsDisposed = 1,
        IsHidden = 4,
        IsVisible = 8
    }
    export interface IOptions {
        node?: HTMLElement;
    }
    export namespace Msg {
        const BeforeShow: Message;
        const AfterShow: Message;
        const BeforeHide: Message;
        const AfterHide: Message;
        const BeforeAttach: Message;
        const AfterAttach: Message;
        const BeforeDetach: Message;
        const AfterDetach: Message;
        const ParentChanged: Message;
        const UpdateRequest: ConflatableMessage;
        const FitRequest: ConflatableMessage;
        const ActivateRequest: ConflatableMessage;
        const CloseRequest: ConflatableMessage;
    }
    export class ResizeMessage extends Message {
        constructor(width: number, height: number);
        readonly height: number;
        readonly width: number;
    }
    export namespace ResizeMessage {
        const UnknownSize: ResizeMessage;
    }
}


// (No @packageDocumentation comment for this package)

```
