; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define double @x(i32 %a, i32 %b) {
; CHECK-LABEL: @x(
; CHECK-NEXT:    [[M:%.*]] = lshr i32 [[A:%.*]], 24
; CHECK-NEXT:    [[N:%.*]] = and i32 [[M]], [[B:%.*]]
; CHECK-NEXT:    [[ADDCONV:%.*]] = add nuw nsw i32 [[N]], 1
; CHECK-NEXT:    [[P:%.*]] = sitofp i32 [[ADDCONV]] to double
; CHECK-NEXT:    ret double [[P]]
;
  %m = lshr i32 %a, 24
  %n = and i32 %m, %b
  %o = sitofp i32 %n to double
  %p = fadd double %o, 1.0
  ret double %p
}

define double @test(i32 %a) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[A_AND:%.*]] = and i32 [[A:%.*]], 1073741823
; CHECK-NEXT:    [[ADDCONV:%.*]] = add nuw nsw i32 [[A_AND]], 1
; CHECK-NEXT:    [[RES:%.*]] = sitofp i32 [[ADDCONV]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  ; Drop two highest bits to guarantee that %a + 1 doesn't overflow
  %a_and = and i32 %a, 1073741823
  %a_and_fp = sitofp i32 %a_and to double
  %res = fadd double %a_and_fp, 1.0
  ret double %res
}

define float @test_neg(i32 %a) {
; CHECK-LABEL: @test_neg(
; CHECK-NEXT:    [[A_AND:%.*]] = and i32 [[A:%.*]], 1073741823
; CHECK-NEXT:    [[A_AND_FP:%.*]] = sitofp i32 [[A_AND]] to float
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[A_AND_FP]], 1.000000e+00
; CHECK-NEXT:    ret float [[RES]]
;
  ; Drop two highest bits to guarantee that %a + 1 doesn't overflow
  %a_and = and i32 %a, 1073741823
  %a_and_fp = sitofp i32 %a_and to float
  %res = fadd float %a_and_fp, 1.0
  ret float %res
}

define double @test_2(i32 %a, i32 %b) {
; CHECK-LABEL: @test_2(
; CHECK-NEXT:    [[A_AND:%.*]] = and i32 [[A:%.*]], 1073741823
; CHECK-NEXT:    [[B_AND:%.*]] = and i32 [[B:%.*]], 1073741823
; CHECK-NEXT:    [[ADDCONV:%.*]] = add nuw nsw i32 [[A_AND]], [[B_AND]]
; CHECK-NEXT:    [[RES:%.*]] = sitofp i32 [[ADDCONV]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  ; Drop two highest bits to guarantee that %a + %b doesn't overflow
  %a_and = and i32 %a, 1073741823
  %b_and = and i32 %b, 1073741823

  %a_and_fp = sitofp i32 %a_and to double
  %b_and_fp = sitofp i32 %b_and to double

  %res = fadd double %a_and_fp, %b_and_fp
  ret double %res
}

define float @test_2_neg(i32 %a, i32 %b) {
; CHECK-LABEL: @test_2_neg(
; CHECK-NEXT:    [[A_AND:%.*]] = and i32 [[A:%.*]], 1073741823
; CHECK-NEXT:    [[B_AND:%.*]] = and i32 [[B:%.*]], 1073741823
; CHECK-NEXT:    [[A_AND_FP:%.*]] = sitofp i32 [[A_AND]] to float
; CHECK-NEXT:    [[B_AND_FP:%.*]] = sitofp i32 [[B_AND]] to float
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[A_AND_FP]], [[B_AND_FP]]
; CHECK-NEXT:    ret float [[RES]]
;
  ; Drop two highest bits to guarantee that %a + %b doesn't overflow
  %a_and = and i32 %a, 1073741823
  %b_and = and i32 %b, 1073741823

  %a_and_fp = sitofp i32 %a_and to float
  %b_and_fp = sitofp i32 %b_and to float

  %res = fadd float %a_and_fp, %b_and_fp
  ret float %res
}

; This test demonstrates overly conservative legality check. The float addition
; can be replaced with the integer addition because the result of the operation
; can be represented in float, but we don't do that now.
define float @test_3(i32 %a, i32 %b) {
; CHECK-LABEL: @test_3(
; CHECK-NEXT:    [[M:%.*]] = lshr i32 [[A:%.*]], 24
; CHECK-NEXT:    [[N:%.*]] = and i32 [[M]], [[B:%.*]]
; CHECK-NEXT:    [[O:%.*]] = sitofp i32 [[N]] to float
; CHECK-NEXT:    [[P:%.*]] = fadd float [[O]], 1.000000e+00
; CHECK-NEXT:    ret float [[P]]
;
  %m = lshr i32 %a, 24
  %n = and i32 %m, %b
  %o = sitofp i32 %n to float
  %p = fadd float %o, 1.0
  ret float %p
}

define <4 x double> @test_4(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: @test_4(
; CHECK-NEXT:    [[A_AND:%.*]] = and <4 x i32> [[A:%.*]], <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>
; CHECK-NEXT:    [[B_AND:%.*]] = and <4 x i32> [[B:%.*]], <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>
; CHECK-NEXT:    [[ADDCONV:%.*]] = add nuw nsw <4 x i32> [[A_AND]], [[B_AND]]
; CHECK-NEXT:    [[RES:%.*]] = sitofp <4 x i32> [[ADDCONV]] to <4 x double>
; CHECK-NEXT:    ret <4 x double> [[RES]]
;
  ; Drop two highest bits to guarantee that %a + %b doesn't overflow
  %a_and = and <4 x i32> %a, <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>
  %b_and = and <4 x i32> %b, <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>

  %a_and_fp = sitofp <4 x i32> %a_and to <4 x double>
  %b_and_fp = sitofp <4 x i32> %b_and to <4 x double>

  %res = fadd <4 x double> %a_and_fp, %b_and_fp
  ret <4 x double> %res
}

define <4 x float> @test_4_neg(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: @test_4_neg(
; CHECK-NEXT:    [[A_AND:%.*]] = and <4 x i32> [[A:%.*]], <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>
; CHECK-NEXT:    [[B_AND:%.*]] = and <4 x i32> [[B:%.*]], <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>
; CHECK-NEXT:    [[A_AND_FP:%.*]] = sitofp <4 x i32> [[A_AND]] to <4 x float>
; CHECK-NEXT:    [[B_AND_FP:%.*]] = sitofp <4 x i32> [[B_AND]] to <4 x float>
; CHECK-NEXT:    [[RES:%.*]] = fadd <4 x float> [[A_AND_FP]], [[B_AND_FP]]
; CHECK-NEXT:    ret <4 x float> [[RES]]
;
  ; Drop two highest bits to guarantee that %a + %b doesn't overflow
  %a_and = and <4 x i32> %a, <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>
  %b_and = and <4 x i32> %b, <i32 1073741823, i32 1073741823, i32 1073741823, i32 1073741823>

  %a_and_fp = sitofp <4 x i32> %a_and to <4 x float>
  %b_and_fp = sitofp <4 x i32> %b_and to <4 x float>

  %res = fadd <4 x float> %a_and_fp, %b_and_fp
  ret <4 x float> %res
}
