/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2021, The Linux Foundation. All rights reserved.
 */

#ifndef QCOM_PHY_QMP_QSERDES_TXRX_V5_5NM_H_
#define QCOM_PHY_QMP_QSERDES_TXRX_V5_5NM_H_

/* Only for QMP V5 5NM PHY - TX registers */
#define QSERDES_V5_5NM_TX_RES_CODE_LANE_OFFSET_TX		0x30
#define QSERDES_V5_5NM_TX_RES_CODE_LANE_OFFSET_RX		0x34
#define QSERDES_V5_5NM_TX_LANE_MODE_1				0x78
#define QSERDES_V5_5NM_TX_LANE_MODE_2				0x7c
#define QSERDES_V5_5NM_TX_LANE_MODE_3				0x80
#define QSERDES_V5_5NM_TX_BIST_MODE_LANENO			0x00
#define QSERDES_V5_5NM_TX_BIST_INVERT				0x04
#define QSERDES_V5_5NM_TX_CLKBUF_ENABLE				0x08
#define QSERDES_V5_5NM_TX_TX_EMP_POST1_LVL			0x0c
#define QSERDES_V5_5NM_TX_TX_IDLE_LVL_LARGE_AMP			0x10
#define QSERDES_V5_5NM_TX_TX_DRV_LVL				0x14
#define QSERDES_V5_5NM_TX_TX_DRV_LVL_OFFSET			0x18
#define QSERDES_V5_5NM_TX_RESET_TSYNC_EN			0x1c
#define QSERDES_V5_5NM_TX_PRE_STALL_LDO_BOOST_EN		0x20
#define QSERDES_V5_5NM_TX_LPB_EN				0x24
#define QSERDES_V5_5NM_TX_RES_CODE_LANE_TX			0x28
#define QSERDES_V5_5NM_TX_RES_CODE_LANE_RX			0x2c
#define QSERDES_V5_5NM_TX_RES_CODE_LANE_OFFSET_TX		0x30
#define QSERDES_V5_5NM_TX_RES_CODE_LANE_OFFSET_RX		0x34
#define QSERDES_V5_5NM_TX_PERL_LENGTH1				0x38
#define QSERDES_V5_5NM_TX_PERL_LENGTH2				0x3c
#define QSERDES_V5_5NM_TX_SERDES_BYP_EN_OUT			0x40
#define QSERDES_V5_5NM_TX_DEBUG_BUS_SEL				0x44
#define QSERDES_V5_5NM_TX_TRANSCEIVER_BIAS_EN			0x48
#define QSERDES_V5_5NM_TX_HIGHZ_DRVR_EN				0x4c
#define QSERDES_V5_5NM_TX_TX_POL_INV				0x50
#define QSERDES_V5_5NM_TX_PARRATE_REC_DETECT_IDLE_EN		0x54
#define QSERDES_V5_5NM_TX_BIST_PATTERN1				0x58
#define QSERDES_V5_5NM_TX_BIST_PATTERN2				0x5c
#define QSERDES_V5_5NM_TX_BIST_PATTERN3				0x60
#define QSERDES_V5_5NM_TX_BIST_PATTERN4				0x64
#define QSERDES_V5_5NM_TX_BIST_PATTERN5				0x68
#define QSERDES_V5_5NM_TX_BIST_PATTERN6				0x6c
#define QSERDES_V5_5NM_TX_BIST_PATTERN7				0x70
#define QSERDES_V5_5NM_TX_BIST_PATTERN8				0x74
#define QSERDES_V5_5NM_TX_LANE_MODE_1				0x78
#define QSERDES_V5_5NM_TX_LANE_MODE_2				0x7c
#define QSERDES_V5_5NM_TX_LANE_MODE_3				0x80
#define QSERDES_V5_5NM_TX_ATB_SEL1				0x84
#define QSERDES_V5_5NM_TX_ATB_SEL2				0x88
#define QSERDES_V5_5NM_TX_RCV_DETECT_LVL			0x8c
#define QSERDES_V5_5NM_TX_RCV_DETECT_LVL_2			0x90
#define QSERDES_V5_5NM_TX_PRBS_SEED1				0x94
#define QSERDES_V5_5NM_TX_PRBS_SEED2				0x98
#define QSERDES_V5_5NM_TX_PRBS_SEED3				0x9c
#define QSERDES_V5_5NM_TX_PRBS_SEED4				0xa0
#define QSERDES_V5_5NM_TX_RESET_GEN				0xa4
#define QSERDES_V5_5NM_TX_RESET_GEN_MUXES			0xa8
#define QSERDES_V5_5NM_TX_TRAN_DRVR_EMP_EN			0xac
#define QSERDES_V5_5NM_TX_VMODE_CTRL1				0xb0
#define QSERDES_V5_5NM_TX_ALOG_OBSV_BUS_CTRL_1			0xb4
#define QSERDES_V5_5NM_TX_BIST_STATUS				0xb8
#define QSERDES_V5_5NM_TX_BIST_ERROR_COUNT1			0xbc
#define QSERDES_V5_5NM_TX_BIST_ERROR_COUNT2			0xc0
#define QSERDES_V5_5NM_TX_ALOG_OBSV_BUS_STATUS_1		0xc4
#define QSERDES_V5_5NM_TX_LANE_DIG_CONFIG			0xc8
#define QSERDES_V5_5NM_TX_PI_QEC_CTRL				0xcc
#define QSERDES_V5_5NM_TX_PRE_EMPH				0xd0
#define QSERDES_V5_5NM_TX_SW_RESET				0xd4
#define QSERDES_V5_5NM_TX_TX_BAND				0xd8
#define QSERDES_V5_5NM_TX_SLEW_CNTL0				0xdc
#define QSERDES_V5_5NM_TX_SLEW_CNTL1				0xe0
#define QSERDES_V5_5NM_TX_INTERFACE_SELECT			0xe4
#define QSERDES_V5_5NM_TX_DIG_BKUP_CTRL				0xe8
#define QSERDES_V5_5NM_TX_DEBUG_BUS0				0xec
#define QSERDES_V5_5NM_TX_DEBUG_BUS1				0xf0
#define QSERDES_V5_5NM_TX_DEBUG_BUS2				0xf4
#define QSERDES_V5_5NM_TX_DEBUG_BUS3				0xf8
#define QSERDES_V5_5NM_TX_TX_BKUP_RO_BUS			0xfc

/* Only for QMP V5 5NM PHY - RX registers */
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_FO_GAIN_RATE0		0x000
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_FO_GAIN_RATE1		0x004
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_FO_GAIN_RATE2		0x008
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_FO_GAIN_RATE3		0x00c
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_SO_GAIN_RATE0		0x010
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_SO_GAIN_RATE1		0x014
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_SO_GAIN_RATE2		0x018
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_SO_GAIN_RATE3		0x01c
#define QSERDES_V5_5NM_RX_UCDR_SO_SATURATION			0x020
#define QSERDES_V5_5NM_RX_UCDR_FO_TO_SO_DELAY			0x024
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_LOW_RATE0		0x028
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_HIGH_RATE0	0x02c
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_LOW_RATE1		0x030
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_HIGH_RATE1	0x034
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_LOW_RATE2		0x038
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_HIGH_RATE2	0x03c
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_LOW_RATE3		0x040
#define QSERDES_V5_5NM_RX_UCDR_FASTLOCK_COUNT_HIGH_RATE3	0x044
#define QSERDES_V5_5NM_RX_UCDR_PI_CTRL1				0x048
#define QSERDES_V5_5NM_RX_UCDR_PI_CTRL2				0x04c
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH1_RATE0		0x050
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH1_RATE1		0x054
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH1_RATE2		0x058
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH1_RATE3		0x05c
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH2_RATE0		0x060
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH2_RATE1		0x064
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH2_RATE2		0x068
#define QSERDES_V5_5NM_RX_UCDR_SB2_THRESH2_RATE3		0x06c
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN1_RATE0			0x070
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN1_RATE1			0x074
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN1_RATE2			0x078
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN1_RATE3			0x07c
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN2_RATE0			0x080
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN2_RATE1			0x084
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN2_RATE2			0x088
#define QSERDES_V5_5NM_RX_UCDR_SB2_GAIN2_RATE3			0x08c
#define QSERDES_V5_5NM_RX_RXCLK_DIV2_CTRL			0x090
#define QSERDES_V5_5NM_RX_RX_BAND				0x094
#define QSERDES_V5_5NM_RX_RX_TERM_BW				0x098
#define QSERDES_V5_5NM_RX_UCDR_FO_GAIN_RATE0			0x09c
#define QSERDES_V5_5NM_RX_UCDR_FO_GAIN_RATE1			0x0a0
#define QSERDES_V5_5NM_RX_UCDR_FO_GAIN_RATE2			0x0a4
#define QSERDES_V5_5NM_RX_UCDR_FO_GAIN_RATE3			0x0a8
#define QSERDES_V5_5NM_RX_UCDR_SO_GAIN_RATE0			0x0ac
#define QSERDES_V5_5NM_RX_UCDR_SO_GAIN_RATE1			0x0b0
#define QSERDES_V5_5NM_RX_UCDR_SO_GAIN_RATE2			0x0b4
#define QSERDES_V5_5NM_RX_UCDR_SO_GAIN_RATE3			0x0b8
#define QSERDES_V5_5NM_RX_UCDR_PI_CONTROLS			0x0bc
#define QSERDES_V5_5NM_RX_UCDR_PD_DATA_FILTER_ENABLES		0x0c0
#define QSERDES_V5_5NM_RX_UCDR_SO_ACC_DEFAULT_VAL_RATE0		0x0c4
#define QSERDES_V5_5NM_RX_UCDR_SO_ACC_DEFAULT_VAL_RATE1		0x0c8
#define QSERDES_V5_5NM_RX_UCDR_SO_ACC_DEFAULT_VAL_RATE2		0x0cc
#define QSERDES_V5_5NM_RX_UCDR_SO_ACC_DEFAULT_VAL_RATE3		0x0d0
#define QSERDES_V5_5NM_RX_AUX_CONTROL				0x0d4
#define QSERDES_V5_5NM_RX_AUXDATA_TB				0x0d8
#define QSERDES_V5_5NM_RX_RCLK_AUXDATA_SEL			0x0dc
#define QSERDES_V5_5NM_RX_EOM_CTRL				0x0e0
#define QSERDES_V5_5NM_RX_AC_JTAG_ENABLE			0x0e4
#define QSERDES_V5_5NM_RX_AC_JTAG_INITP				0x0e8
#define QSERDES_V5_5NM_RX_AC_JTAG_INITN				0x0ec
#define QSERDES_V5_5NM_RX_AC_JTAG_LVL				0x0f0
#define QSERDES_V5_5NM_RX_AC_JTAG_MODE				0x0f4
#define QSERDES_V5_5NM_RX_AC_JTAG_RESET				0x0f8
#define QSERDES_V5_5NM_RX_RX_RCVR_IQ_EN				0x0fc
#define QSERDES_V5_5NM_RX_RX_Q_EN_RATES				0x100
#define QSERDES_V5_5NM_RX_RX_IDAC_I0_DC_OFFSETS			0x104
#define QSERDES_V5_5NM_RX_RX_IDAC_I0BAR_DC_OFFSETS		0x108
#define QSERDES_V5_5NM_RX_RX_IDAC_I1_DC_OFFSETS			0x10c
#define QSERDES_V5_5NM_RX_RX_IDAC_I1BAR_DC_OFFSETS		0x110
#define QSERDES_V5_5NM_RX_RX_IDAC_Q_DC_OFFSETS			0x114
#define QSERDES_V5_5NM_RX_RX_IDAC_QBAR_DC_OFFSETS		0x118
#define QSERDES_V5_5NM_RX_RX_IDAC_A_DC_OFFSETS			0x11c
#define QSERDES_V5_5NM_RX_RX_IDAC_ABAR_DC_OFFSETS		0x120
#define QSERDES_V5_5NM_RX_RX_IDAC_EN				0x124
#define QSERDES_V5_5NM_RX_RX_IDAC_ENABLES			0x128
#define QSERDES_V5_5NM_RX_RX_IDAC_SIGN				0x12c
#define QSERDES_V5_5NM_RX_RX_IVCM_CAL_CODE_OVERRIDE		0x130
#define QSERDES_V5_5NM_RX_RX_IVCM_CAL_CTRL1			0x134
#define QSERDES_V5_5NM_RX_RX_IVCM_CAL_CTRL2			0x138
#define QSERDES_V5_5NM_RX_RX_IVCM_POSTCAL_OFFSET		0x13c
#define QSERDES_V5_5NM_RX_RX_SUMMER_CAL_SPD_MODE		0x140
#define QSERDES_V5_5NM_RX_RX_HIGHZ_PARRATE			0x144
#define QSERDES_V5_5NM_RX_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x148
#define QSERDES_V5_5NM_RX_DFE_1					0x14c
#define QSERDES_V5_5NM_RX_DFE_2					0x150
#define QSERDES_V5_5NM_RX_DFE_3					0x154
#define QSERDES_V5_5NM_RX_DFE_4					0x158
#define QSERDES_V5_5NM_RX_DFE_TAP3_CTRL				0x15c
#define QSERDES_V5_5NM_RX_DFE_TAP3_MANVAL_KTAP			0x160
#define QSERDES_V5_5NM_RX_DFE_TAP4_CTRL				0x164
#define QSERDES_V5_5NM_RX_DFE_TAP4_MANVAL_KTAP			0x168
#define QSERDES_V5_5NM_RX_DFE_TAP5_CTRL				0x16c
#define QSERDES_V5_5NM_RX_DFE_TAP5_MANVAL_KTAP			0x170
#define QSERDES_V5_5NM_RX_TX_ADPT_CTRL				0x174
#define QSERDES_V5_5NM_RX_DFE_DAC_ENABLE1			0x178
#define QSERDES_V5_5NM_RX_DFE_DAC_ENABLE2			0x17c
#define QSERDES_V5_5NM_RX_TX_ADAPT_PRE_THRESH1			0x180
#define QSERDES_V5_5NM_RX_TX_ADAPT_PRE_THRESH2			0x184
#define QSERDES_V5_5NM_RX_TX_ADAPT_POST_THRESH1			0x188
#define QSERDES_V5_5NM_RX_TX_ADAPT_POST_THRESH2			0x18c
#define QSERDES_V5_5NM_RX_TX_ADAPT_MAIN_THRESH1			0x190
#define QSERDES_V5_5NM_RX_TX_ADAPT_MAIN_THRESH2			0x194
#define QSERDES_V5_5NM_RX_VGA_CAL_CNTRL1			0x198
#define QSERDES_V5_5NM_RX_VGA_CAL_CNTRL2			0x19c
#define QSERDES_V5_5NM_RX_VGA_CAL_MAN_VAL			0x1a0
#define QSERDES_V5_5NM_RX_VTHRESH_CAL_CNTRL1			0x1a4
#define QSERDES_V5_5NM_RX_VTHRESH_CAL_CNTRL2			0x1a8
#define QSERDES_V5_5NM_RX_VTHRESH_CAL_MAN_VAL_RATE0		0x1ac
#define QSERDES_V5_5NM_RX_VTHRESH_CAL_MAN_VAL_RATE1		0x1b0
#define QSERDES_V5_5NM_RX_VTHRESH_CAL_MAN_VAL_RATE2		0x1b4
#define QSERDES_V5_5NM_RX_VTHRESH_CAL_MAN_VAL_RATE3		0x1b8
#define QSERDES_V5_5NM_RX_GM_CAL				0x1bc
#define QSERDES_V5_5NM_RX_RX_VGA_GAIN2_BLK1			0x1c0
#define QSERDES_V5_5NM_RX_RX_VGA_GAIN2_BLK2			0x1c4
#define QSERDES_V5_5NM_RX_RX_EQU_ADAPTOR_CNTRL2			0x1c8
#define QSERDES_V5_5NM_RX_RX_EQU_ADAPTOR_CNTRL3			0x1cc
#define QSERDES_V5_5NM_RX_RX_EQU_ADAPTOR_CNTRL4			0x1d0
#define QSERDES_V5_5NM_RX_RX_IDAC_TSETTLE_LOW			0x1d4
#define QSERDES_V5_5NM_RX_RX_EQ_OFFSET_LSB			0x1d8
#define QSERDES_V5_5NM_RX_RX_EQ_OFFSET_MSB			0x1dc
#define QSERDES_V5_5NM_RX_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x1e0
#define QSERDES_V5_5NM_RX_RX_OFFSET_ADAPTOR_CNTRL2		0x1e4
#define QSERDES_V5_5NM_RX_SIGDET_ENABLES			0x1e8
#define QSERDES_V5_5NM_RX_SIGDET_CNTRL				0x1ec
#define QSERDES_V5_5NM_RX_SIGDET_LVL				0x1f0
#define QSERDES_V5_5NM_RX_SIGDET_DEGLITCH_CNTRL			0x1f4
#define QSERDES_V5_5NM_RX_CDR_FREEZE_UP_DN			0x1f8
#define QSERDES_V5_5NM_RX_CDR_RESET_OVERRIDE			0x1fc
#define QSERDES_V5_5NM_RX_RX_INTERFACE_MODE			0x200
#define QSERDES_V5_5NM_RX_JITTER_GEN_MODE			0x204
#define QSERDES_V5_5NM_RX_SJ_AMP1				0x208
#define QSERDES_V5_5NM_RX_SJ_AMP2				0x20c
#define QSERDES_V5_5NM_RX_SJ_PER1				0x210
#define QSERDES_V5_5NM_RX_SJ_PER2				0x214
#define QSERDES_V5_5NM_RX_PPM_OFFSET1				0x218
#define QSERDES_V5_5NM_RX_PPM_OFFSET2				0x21c
#define QSERDES_V5_5NM_RX_SIGN_PPM_PERIOD1			0x220
#define QSERDES_V5_5NM_RX_SIGN_PPM_PERIOD2			0x224
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B0			0x228
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B1			0x22c
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B2			0x230
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B3			0x234
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B4			0x238
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B5			0x23c
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B6			0x240
#define QSERDES_V5_5NM_RX_RX_MODE_RATE_0_1_B7			0x244
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B0			0x248
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B1			0x24c
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B2			0x250
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B3			0x254
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B4			0x258
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B5			0x25c
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B6			0x260
#define QSERDES_V5_5NM_RX_RX_MODE_RATE2_B7			0x264
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B0			0x268
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B1			0x26c
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B2			0x270
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B3			0x274
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B4			0x278
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B5			0x27c
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B6			0x280
#define QSERDES_V5_5NM_RX_RX_MODE_RATE3_B7			0x284
#define QSERDES_V5_5NM_RX_PHPRE_CTRL				0x288
#define QSERDES_V5_5NM_RX_PHPRE_INITVAL				0x28c
#define QSERDES_V5_5NM_RX_DFE_EN_TIMER				0x290
#define QSERDES_V5_5NM_RX_DFE_CTLE_POST_CAL_OFFSET		0x294
#define QSERDES_V5_5NM_RX_DCC_CTRL1				0x298
#define QSERDES_V5_5NM_RX_DCC_CTRL2				0x29c
#define QSERDES_V5_5NM_RX_DCC_OFFSET				0x2a0
#define QSERDES_V5_5NM_RX_DCC_CMUX_POSTCAL_OFFSET		0x2a4
#define QSERDES_V5_5NM_RX_DCC_CMUX_CAL_CTRL1			0x2a8
#define QSERDES_V5_5NM_RX_DCC_CMUX_CAL_CTRL2			0x2ac
#define QSERDES_V5_5NM_RX_ALOG_OBSV_BUS_CTRL_1			0x2b0
#define QSERDES_V5_5NM_RX_RX_MARG_CTRL1				0x2b4
#define QSERDES_V5_5NM_RX_RX_MARG_CTRL2				0x2b8
#define QSERDES_V5_5NM_RX_RX_MARG_CTRL3				0x2bc
#define QSERDES_V5_5NM_RX_RX_MARG_CTRL_4			0x2c0
#define QSERDES_V5_5NM_RX_RX_MARG_CFG_RATE_0_1			0x2c4
#define QSERDES_V5_5NM_RX_RX_MARG_CFG_RATE_2_3			0x2c8
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_CTRL1			0x2cc
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_CTRL2			0x2d0
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH1_RATE210	0x2d4
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH1_RATE3		0x2d8
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH2_RATE210	0x2dc
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH2_RATE3		0x2e0
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH3_RATE210	0x2e4
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH3_RATE3		0x2e8
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH4_RATE210	0x2ec
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH4_RATE3		0x2f0
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH5_RATE210	0x2f4
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH5_RATE3		0x2f8
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH6_RATE210	0x2fc
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH6_RATE3		0x300
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH7_RATE210	0x304
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_THRESH7_RATE3		0x308
#define QSERDES_V5_5NM_RX_Q_PI_INTRINSIC_BIAS_RATE10		0x30c
#define QSERDES_V5_5NM_RX_Q_PI_INTRINSIC_BIAS_RATE32		0x310
#define QSERDES_V5_5NM_RX_RX_MARG_VERTICAL_CTRL			0x314
#define QSERDES_V5_5NM_RX_RX_MARG_VERTICAL_CODE			0x318
#define QSERDES_V5_5NM_RX_RES_CODE_THRESH_HIGH_AND_BYP		0x31c
#define QSERDES_V5_5NM_RX_RES_CODE_THRESH_LOW			0x320
#define QSERDES_V5_5NM_RX_RX_BKUP_CTRL1				0x324
#define QSERDES_V5_5NM_RX_RX_BKUP_CTRL2				0x328
#define QSERDES_V5_5NM_RX_RX_BKUP_CTRL3				0x32c
#define QSERDES_V5_5NM_RX_PI_CTRL1				0x330
#define QSERDES_V5_5NM_RX_PI_CTRL2				0x334
#define QSERDES_V5_5NM_RX_PI_QUAD				0x338
#define QSERDES_V5_5NM_RX_QPI_CTRL1				0x33c
#define QSERDES_V5_5NM_RX_QPI_CTRL2				0x340
#define QSERDES_V5_5NM_RX_QPI_QUAD				0x344
#define QSERDES_V5_5NM_RX_IDATA1				0x348
#define QSERDES_V5_5NM_RX_IDATA2				0x34c
#define QSERDES_V5_5NM_RX_IDATA3				0x350
#define QSERDES_V5_5NM_RX_AC_JTAG_OUTP				0x354
#define QSERDES_V5_5NM_RX_AC_JTAG_OUTN				0x358
#define QSERDES_V5_5NM_RX_RX_SIGDET				0x35c
#define QSERDES_V5_5NM_RX_ALOG_OBSV_BUS_STATUS_1		0x360
#define QSERDES_V5_5NM_RX_READ_EQCODE				0x364
#define QSERDES_V5_5NM_RX_READ_OFFSETCODE			0x368
#define QSERDES_V5_5NM_RX_IA_ERROR_COUNTER_LOW			0x36c
#define QSERDES_V5_5NM_RX_IA_ERROR_COUNTER_HIGH			0x370
#define QSERDES_V5_5NM_RX_VGA_READ_CODE				0x374
#define QSERDES_V5_5NM_RX_VTHRESH_READ_CODE			0x378
#define QSERDES_V5_5NM_RX_DFE_TAP1_READ_CODE			0x37c
#define QSERDES_V5_5NM_RX_DFE_TAP2_READ_CODE			0x380
#define QSERDES_V5_5NM_RX_DFE_TAP3_READ_CODE			0x384
#define QSERDES_V5_5NM_RX_DFE_TAP4_READ_CODE			0x388
#define QSERDES_V5_5NM_RX_DFE_TAP5_READ_CODE			0x38c
#define QSERDES_V5_5NM_RX_IDAC_STATUS_I0			0x390
#define QSERDES_V5_5NM_RX_IDAC_STATUS_I0BAR			0x394
#define QSERDES_V5_5NM_RX_IDAC_STATUS_I1			0x398
#define QSERDES_V5_5NM_RX_IDAC_STATUS_I1BAR			0x39c
#define QSERDES_V5_5NM_RX_IDAC_STATUS_Q				0x3a0
#define QSERDES_V5_5NM_RX_IDAC_STATUS_QBAR			0x3a4
#define QSERDES_V5_5NM_RX_IDAC_STATUS_A				0x3a8
#define QSERDES_V5_5NM_RX_IDAC_STATUS_ABAR			0x3ac
#define QSERDES_V5_5NM_RX_IDAC_STATUS_SM_ON			0x3b0
#define QSERDES_V5_5NM_RX_IDAC_STATUS_SIGNERROR			0x3b4
#define QSERDES_V5_5NM_RX_IVCM_CAL_STATUS			0x3b8
#define QSERDES_V5_5NM_RX_IVCM_CAL_DEBUG_STATUS			0x3bc
#define QSERDES_V5_5NM_RX_DCC_CAL_STATUS			0x3c0
#define QSERDES_V5_5NM_RX_DCC_READ_CODE_STATUS			0x3c4
#define QSERDES_V5_5NM_RX_RX_MARG_DEBUG1_STATUS			0x3c8
#define QSERDES_V5_5NM_RX_RX_MARG_DEBUG2_STATUS			0x3cc
#define QSERDES_V5_5NM_RX_RX_MARG_READ_CODE_STATUS		0x3d0
#define QSERDES_V5_5NM_RX_EOM_ERR_CNT_LSB_STATUS		0x3d4
#define QSERDES_V5_5NM_RX_EOM_ERR_CNT_MSB_STATUS		0x3d8
#define QSERDES_V5_5NM_RX_RX_MARG_COARSE_TUNE_STATUS		0x3dc
#define QSERDES_V5_5NM_RX_RX_BKUP_READ_BUS1_STATUS		0x3e0
#define QSERDES_V5_5NM_RX_RX_BKUP_READ_BUS2_STATUS		0x3e4
#define QSERDES_V5_5NM_RX_RX_BKUP_READ_BUS3_STATUS		0x3e8

#endif
