/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2022 Mikolaj Wielgus
 * Copyright The KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <sim/sim_model_ngspice.h>


void NGSPICE_MODEL_INFO_MAP::addB3SOI()
{
    modelInfos[MODEL_TYPE::B3SOIFD] = { "B3SOIFD", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley SOI MOSFET (FD) model version 2.1", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "capmod",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "noimod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "binunit",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "parameter for model version" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "tox",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cdsc",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cdscb",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cit",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "nfactor",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vsat",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "at",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "a0",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "a1",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "a2",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "keta",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.6", "-0.6", "Body-bias coefficient of non-uniform depletion width effect." );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "nsub",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration with polarity" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "nch",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ngate",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "gamma1",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "gamma2",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vbx",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vbm",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xt",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow width effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "nlx",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "tnom",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cgso",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cgdo",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cgeo",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-substrate overlap capacitance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xpart",  705, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "rsh",  706, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source-drain resistance per width" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "shmod",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Self heating mode selector" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "tbox",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-07", "3e-07", "Back gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "tsi",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Silicon-on-insulator thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xj",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Junction Depth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kb1",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Backgate coupling coefficient at strong inversion" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kb3",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Backgate coupling coefficient at subthreshold" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvbd0",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First coefficient of short-channel effect on Vbs0t" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dvbd1",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second coefficient of short-channel effect on Vbs0t" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vbsa",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vbs0t offset voltage" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "delp",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.02", "0.02", "Offset constant for limiting Vbseff to Phis" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "rbody",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "rbsh",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "adice0",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "DICE constant for bulk charge effect" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "abp",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate bias coefficient for Xcsat calculation" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "mxc",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.9", "-0.9", "A smoothing parameter for Xcsat calculation" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "rth0_",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Self-heating thermal resistance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cth0_",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Self-heating thermal capacitance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "aii",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "1st Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "bii",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "2nd Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cii",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "3rd Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dii",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "4th Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ngidl",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL first parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "agidl",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL second parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "bgidl",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL third parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ndiode",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ntun",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "isbjt",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT emitter injection constant" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "isdif",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to S/D injection constant" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "isrec",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion constant" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "istun",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Tunneling diode constant" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xbjt",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "2", "2", "Temperature coefficient for Isbjt" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xdif",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "2", "2", "n.a." );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xrec",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "20", "20", "Temperature coefficient for Isrec" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "xtun",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Istun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "edl",  230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "Electron diffusion length" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kbjt1",  231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependency on BJT base width" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "tt",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-12", "1e-12", "Diffusion capacitance transit time coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vsdth",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/Drain diffusion threshold voltage" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "vsdfb",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/Drain diffusion flatband voltage" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "csdmin",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.000100544", "0.000100544", "Source/Drain diffusion bottom minimum capacitance" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "asd",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Source/Drain diffusion smoothing parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pbswg",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Source/drain (gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "mjswg",  844, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source/drain (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cjswg",  845, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Source/drain (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "csdesw",  846, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/drain sidewall fringing constant" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lint",  819, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ll",  820, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lln",  821, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lw",  822, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lwn",  823, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lwl",  824, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wint",  827, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wl",  828, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wln",  829, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ww",  830, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wwn",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wwl",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "8.16367e-11", "8.16367e-11", "Fringe capacitance parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dwc",  835, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "dlc",  836, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "alpha1",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "beta0",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "30", "30", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "noia",  816, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e+20", "9.9e+18", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "noib",  817, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "50000", "2400", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "noic",  818, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "-1.4e-12", "1.4e-12", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "em",  837, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ef",  838, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "af",  839, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "kf",  840, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "noif",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Floating body excess noise ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lnch",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lnsub",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lngate",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lvth0",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lk1",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lk2",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lk3",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lk3b",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lvbsa",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbsa" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldelp",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delp" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lkb1",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lkb3",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length dependence of kb3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvbd0",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvbd0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvbd1",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvbd1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lw0",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lnlx",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvt0",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvt1",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvt2",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvt0w",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvt1w",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldvt2w",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lu0",  323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lua",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lub",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "luc",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lvsat",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "la0",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lags",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lb0",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lb1",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lketa",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "labp",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of abp" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lmxc",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mxc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ladice0",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of adice0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "la1",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "la2",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lrdsw",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lprwb",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lprwg",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lwr",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lnfactor",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldwg",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldwb",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lvoff",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "leta0",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "letab",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldsub",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lcit",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lcdsc",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lcdscb",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lcdscd",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lpclm",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lpdiblc1",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lpdiblc2",  355, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lpdiblcb",  356, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldrout",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lpvag",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldelta",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "laii",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lbii",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lcii",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ldii",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lalpha0",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lalpha1",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lbeta0",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lagidl",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lbgidl",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lngidl",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lntun",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lndiode",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lisbjt",  372, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lisdif",  373, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lisrec",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "listun",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ledl",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of edl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lkbjt1",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kbjt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lvsdfb",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "lvsdth",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wnch",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wnsub",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wngate",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wvth0",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wk2",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wk3",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wk3b",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wvbsa",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbsa" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdelp",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delp" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wkb1",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wkb3",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of kb3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvbd0",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvbd0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvbd1",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvbd1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ww0",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wnlx",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvt0",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvt1",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvt2",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvt0w",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvt1w",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdvt2w",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wu0",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wua",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wub",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wuc",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wvsat",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wa0",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wags",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wb0",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wb1",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wketa",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wabp",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of abp" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wmxc",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mxc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wadice0",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of adice0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wa1",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wa2",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wrdsw",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wprwb",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wprwg",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wwr",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wnfactor",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdwg",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdwb",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wvoff",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "weta0",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wetab",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdsub",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wcit",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wcdsc",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wcdscb",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wcdscd",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wpclm",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wpdiblc1",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wpdiblc2",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wpdiblcb",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdrout",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wpvag",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdelta",  459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "waii",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wbii",  461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wcii",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wdii",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "walpha0",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "walpha1",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wbeta0",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wagidl",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wbgidl",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wngidl",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wntun",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wndiode",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wisbjt",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wisdif",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wisrec",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wistun",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wedl",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of edl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wkbjt1",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kbjt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wvsdfb",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "wvsdth",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pnch",  501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pnsub",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pngate",  503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvth0",  504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pk2",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pk3",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pk3b",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvbsa",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbsa" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdelp",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delp" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pkb1",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pkb3",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Cross-term dependence of kb3" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvbd0",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvbd0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvbd1",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvbd1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pw0",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pnlx",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvt0",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvt1",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvt2",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvt0w",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvt1w",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdvt2w",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pu0",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pua",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pub",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "puc",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvsat",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pa0",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pags",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pb0",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pb1",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pketa",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pabp",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of abp" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pmxc",  534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mxc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "padice0",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of adice0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pa1",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pa2",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "prdsw",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pprwb",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pprwg",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pwr",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pnfactor",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdwg",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdwb",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvoff",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "peta0",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "petab",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdsub",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pcit",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pcdsc",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pcdscb",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pcdscd",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ppclm",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ppdiblc1",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ppdiblc2",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ppdiblcb",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdrout",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "ppvag",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdelta",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "paii",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pbii",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pcii",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pdii",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dii" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "palpha0",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "palpha1",  565, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pbeta0",  566, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pagidl",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pbgidl",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pngidl",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pntun",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pndiode",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pisbjt",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pisdif",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pisrec",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pistun",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pedl",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of edl" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pkbjt1",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kbjt1" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvsdfb",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pvsdth",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "nmos",  814, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
    modelInfos[MODEL_TYPE::B3SOIFD].modelParams.emplace_back( "pmos",  815, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
    // Instance parameters
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "m",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "ic",  19, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "gmbs",  918, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "gm",  916, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "gm/ids",  946, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm/Ids", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "gds",  917, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "vdsat",  939, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "vth",  938, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "ids",  913, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "vbs",  909, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "vgs",  910, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "vds",  912, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "ves",  911, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ves", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "bjtoff",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "debug",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "rth0",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Resistance", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "cth0",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Capacitance", true );
    modelInfos[MODEL_TYPE::B3SOIFD].instanceParams.emplace_back( "nrb",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of squares in body", true );


    modelInfos[MODEL_TYPE::B3SOIDD] = { "B3SOIDD", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley SOI MOSFET (DD) model version 2.1", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "capmod",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "noimod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "binunit",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "parameter for model version" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "tox",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cdsc",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cdscb",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cit",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "nfactor",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vsat",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "at",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "a0",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "a1",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "a2",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "keta",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.6", "-0.6", "Body-bias coefficient of non-uniform depletion width effect." );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "nsub",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration with polarity" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "nch",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ngate",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "gamma1",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "gamma2",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vbx",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vbm",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xt",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow width effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "nlx",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "tnom",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cgso",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cgdo",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cgeo",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-substrate overlap capacitance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xpart",  705, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "rsh",  706, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source-drain resistance per width" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "shmod",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Self heating mode selector" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "tbox",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-07", "3e-07", "Back gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "tsi",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Silicon-on-insulator thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xj",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Junction Depth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kb1",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Backgate coupling coefficient at strong inversion" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kb3",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Backgate coupling coefficient at subthreshold" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvbd0",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First coefficient of short-channel effect on Vbs0t" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dvbd1",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second coefficient of short-channel effect on Vbs0t" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vbsa",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vbs0t offset voltage" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "delp",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.02", "0.02", "Offset constant for limiting Vbseff to Phis" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "rbody",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "rbsh",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "adice0",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "DICE constant for bulk charge effect" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "abp",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate bias coefficient for Xcsat calculation" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "mxc",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.9", "-0.9", "A smoothing parameter for Xcsat calculation" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "rth0_",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Self-heating thermal resistance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cth0_",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Self-heating thermal capacitance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "aii",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "1st Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "bii",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "2nd Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cii",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "3rd Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dii",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "4th Vdsatii parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ngidl",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL first parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "agidl",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL second parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "bgidl",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL third parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ndiode",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ntun",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "isbjt",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT emitter injection constant" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "isdif",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to S/D injection constant" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "isrec",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion constant" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "istun",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Tunneling diode constant" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xbjt",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "2", "2", "Temperature coefficient for Isbjt" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xdif",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "2", "2", "n.a." );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xrec",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "20", "20", "Temperature coefficient for Isrec" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "xtun",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Istun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "edl",  230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "Electron diffusion length" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kbjt1",  231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependency on BJT base width" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "tt",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-12", "1e-12", "Diffusion capacitance transit time coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vsdth",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/Drain diffusion threshold voltage" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "vsdfb",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/Drain diffusion flatband voltage" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "csdmin",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.000100544", "0.000100544", "Source/Drain diffusion bottom minimum capacitance" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "asd",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Source/Drain diffusion smoothing parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pbswg",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Source/drain (gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "mjswg",  844, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source/drain (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cjswg",  845, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Source/drain (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "csdesw",  846, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/drain sidewall fringing constant" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lint",  819, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ll",  820, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lln",  821, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lw",  822, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lwn",  823, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lwl",  824, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wint",  827, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wl",  828, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wln",  829, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ww",  830, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wwn",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wwl",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "8.16367e-11", "8.16367e-11", "Fringe capacitance parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dwc",  835, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "dlc",  836, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "alpha1",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "beta0",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "30", "30", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "noia",  816, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e+20", "9.9e+18", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "noib",  817, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "50000", "2400", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "noic",  818, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "-1.4e-12", "1.4e-12", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "em",  837, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ef",  838, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "af",  839, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "kf",  840, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "noif",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Floating body excess noise ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lnch",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lnsub",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lngate",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lvth0",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lk1",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lk2",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lk3",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lk3b",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lvbsa",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbsa" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldelp",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delp" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lkb1",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lkb3",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length dependence of kb3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvbd0",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvbd0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvbd1",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvbd1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lw0",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lnlx",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvt0",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvt1",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvt2",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvt0w",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvt1w",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldvt2w",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lu0",  323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lua",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lub",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "luc",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lvsat",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "la0",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lags",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lb0",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lb1",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lketa",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "labp",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of abp" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lmxc",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mxc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ladice0",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of adice0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "la1",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "la2",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lrdsw",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lprwb",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lprwg",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lwr",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lnfactor",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldwg",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldwb",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lvoff",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "leta0",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "letab",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldsub",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lcit",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lcdsc",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lcdscb",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lcdscd",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lpclm",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lpdiblc1",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lpdiblc2",  355, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lpdiblcb",  356, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldrout",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lpvag",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldelta",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "laii",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lbii",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lcii",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ldii",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lalpha0",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lalpha1",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lbeta0",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lagidl",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lbgidl",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lngidl",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lntun",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lndiode",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lisbjt",  372, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lisdif",  373, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lisrec",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "listun",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ledl",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of edl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lkbjt1",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kbjt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lvsdfb",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "lvsdth",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wnch",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wnsub",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wngate",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wvth0",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wk2",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wk3",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wk3b",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wvbsa",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbsa" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdelp",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delp" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wkb1",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wkb3",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of kb3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvbd0",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvbd0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvbd1",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvbd1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ww0",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wnlx",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvt0",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvt1",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvt2",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvt0w",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvt1w",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdvt2w",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wu0",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wua",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wub",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wuc",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wvsat",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wa0",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wags",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wb0",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wb1",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wketa",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wabp",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of abp" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wmxc",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mxc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wadice0",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of adice0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wa1",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wa2",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wrdsw",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wprwb",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wprwg",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wwr",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wnfactor",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdwg",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdwb",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wvoff",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "weta0",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wetab",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdsub",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wcit",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wcdsc",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wcdscb",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wcdscd",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wpclm",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wpdiblc1",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wpdiblc2",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wpdiblcb",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdrout",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wpvag",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdelta",  459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "waii",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wbii",  461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wcii",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wdii",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "walpha0",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "walpha1",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wbeta0",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wagidl",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wbgidl",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wngidl",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wntun",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wndiode",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wisbjt",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wisdif",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wisrec",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wistun",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wedl",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of edl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wkbjt1",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kbjt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wvsdfb",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "wvsdth",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pnch",  501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pnsub",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pngate",  503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvth0",  504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pk2",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pk3",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pk3b",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvbsa",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbsa" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdelp",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delp" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pkb1",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pkb3",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Cross-term dependence of kb3" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvbd0",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvbd0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvbd1",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvbd1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pw0",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pnlx",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvt0",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvt1",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvt2",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvt0w",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvt1w",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdvt2w",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pu0",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pua",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pub",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "puc",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvsat",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pa0",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pags",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pb0",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pb1",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pketa",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pabp",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of abp" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pmxc",  534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mxc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "padice0",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of adice0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pa1",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pa2",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "prdsw",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pprwb",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pprwg",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pwr",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pnfactor",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdwg",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdwb",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvoff",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "peta0",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "petab",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdsub",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pcit",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pcdsc",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pcdscb",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pcdscd",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ppclm",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ppdiblc1",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ppdiblc2",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ppdiblcb",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdrout",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "ppvag",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdelta",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "paii",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pbii",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pcii",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pdii",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dii" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "palpha0",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "palpha1",  565, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pbeta0",  566, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pagidl",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pbgidl",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pngidl",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pntun",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pndiode",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pisbjt",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pisdif",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pisrec",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pistun",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pedl",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of edl" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pkbjt1",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kbjt1" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvsdfb",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pvsdth",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "nmos",  814, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
    modelInfos[MODEL_TYPE::B3SOIDD].modelParams.emplace_back( "pmos",  815, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
    // Instance parameters
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "m",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "ic",  19, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "gmbs",  918, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "gm",  916, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "gm/ids",  946, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm/Ids", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "gds",  917, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "vdsat",  939, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "vth",  938, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "ids",  913, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "vbs",  909, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "vgs",  910, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "vds",  912, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "ves",  911, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ves", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "bjtoff",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "debug",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "rth0",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Resistance", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "cth0",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Capacitance", true );
    modelInfos[MODEL_TYPE::B3SOIDD].instanceParams.emplace_back( "nrb",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of squares in body", true );


    modelInfos[MODEL_TYPE::B3SOIPD] = { "B3SOIPD", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley SOI (PD) MOSFET model version 2.2.3", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "capmod",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "noimod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "binunit",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "parameter for model version" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tox",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dtoxcv",  853, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta oxide thickness in meters in CapMod3" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cdsc",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cdscb",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cit",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nfactor",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vsat",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "at",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "a0",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "a1",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "a2",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "keta",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.6", "-0.6", "Body-bias coefficient of non-uniform depletion width effect." );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nsub",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration with polarity" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nch",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ngate",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "gamma1",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "gamma2",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vbx",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vbm",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xt",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow width effect coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nlx",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tnom",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cgso",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cgdo",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xpart",  705, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "rsh",  706, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source-drain resistance per width" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "shmod",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Self heating mode selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ddmod",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Dynamic depletion mode selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tbox",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-07", "3e-07", "Back gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tsi",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Silicon-on-insulator thickness in meters" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xj",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Junction Depth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "rth0_",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Self-heating thermal resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cth0_",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Self-heating thermal capacitance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ngidl",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "GIDL first parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "agidl",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL second parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "bgidl",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL third parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ndiode",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xbjt",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xdif",  227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isdif" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xrec",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isrec" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "xtun",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Istun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pbswg",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Source/drain (gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "mjswg",  844, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source/drain (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cjswg",  845, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Source/drain (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lint",  819, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ll",  820, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "llc",  848, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lln",  821, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lw",  822, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lwc",  849, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lwn",  823, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lwl",  824, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lwlc",  847, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wint",  827, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wl",  828, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wlc",  851, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wln",  829, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ww",  830, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wwc",  852, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wwn",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wwl",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wwlc",  850, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "8.16367e-11", "8.16367e-11", "Fringe capacitance parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dwc",  835, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dlc",  836, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "noia",  816, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e+20", "9.9e+18", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "noib",  817, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "50000", "2400", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "noic",  818, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "-1.4e-12", "1.4e-12", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "em",  837, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ef",  838, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "af",  839, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "kf",  840, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "noif",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Floating body excess noise ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "k1w1",  239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First Body effect width dependent parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "k1w2",  240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second Boby effect width dependent parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ketas",  241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface potential adjustment for bulk charge effect" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dwbc",  242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width offset for body contact isolation edge" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "beta0",  243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First Vds dependent parameter of impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "beta1",  244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second Vds dependent parameter of impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "beta2",  245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Third Vds dependent parameter of impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vdsatii0",  246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Nominal drain saturation voltage at threshold for impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tii",  247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependent parameter for impact ionizition" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lii",  248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length dependent parameter at threshold for impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "sii0",  249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "First Vgs dependent parameter for impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "sii1",  250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Second Vgs dependent parameter for impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "sii2",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third Vgs dependent parameter for impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "siid",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependent parameter of drain saturation voltage for impact ionizition current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "fbjtii",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fraction of bipolar current affecting the impact ionization" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "esatii",  238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Saturation electric field for impact ionization" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ntun",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nrecf0",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Recombination non-ideality factor at forward bias" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nrecr0",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Recombination non-ideality factor at reversed bias" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "isbjt",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT injection saturation current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "isdif",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to source/drain injection saturation current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "isrec",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion saturation current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "istun",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse tunneling saturation current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ln",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "Electron/hole diffusion length" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vrec0",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for recombination current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vtun0",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for tunneling current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nbjt",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Power coefficient of channel length dependency for bipolar current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lbjt0",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "Refferenc channel length for bipolar cuurent" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldif0",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Channel-length dependency coefficient of diffusion cap" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vabjt",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Early voltage for bipolar current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "aely",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length dependency of early voltage for bipolar cuurent" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ahli",  264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High level injection parameter for bipolar current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "rbody",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "rbsh",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "cgeo",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate substrate overlap capacitance per unit channel length" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tt",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-12", "1e-12", "Diffusion capacitance transit time coefficient" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ndif",  269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "-1", "-1", "Power coefficient of channel length dependency for diffusion capacitance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vsdfb",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain bottom diffusion capacitance flatband voltage" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vsdth",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain bottom diffusion capacitance threshold voltage" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "csdmin",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.000100544", "0.000100544", "Source/drain bottom diffusion minimum capacitance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "asd",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Source/drain bottom diffusion smoothing parameter" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "csdesw",  846, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain sidewall fringing capacitance per unit length" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ntrecf",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Nrecf" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ntrecr",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Nrecr" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dlcb",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length offset fitting parameter for body charge" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "fbody",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Scaling factor for body charge" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tcjswg",  270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Cjswg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "tpbswg",  271, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Pbswg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "acde",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for charge thickness in capMod=3 for accumulation and depletion regions" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "moin",  273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for the gate-bias dependent surface potential" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "delvt",  274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage adjust for CV" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "kb1",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Scaling factor for backgate charge" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "dlbg",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length offset fitting parameter for backgate charge" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "igmod",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate current model selector" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "toxqm",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "effective oxide thickness considering quantum effect" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wth0",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Minimum width for thermal resistance calculation" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "rhalo",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "body halo sheet resistance" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ntox",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "power term of gate current" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "toxref",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-09", "2.5e-09", "target oxide thickness" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ebg",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "effective bandgap in gate current calcula." );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vevb",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.075", "Vaux parameter for valence-band electron tunneling" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "alphagb1",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.35", "0.35", "First Vox dependent parameter for gate current in inversion" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "betagb1",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.03", "0.03", "Second Vox dependent parameter for gate current in inversion" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vgb1",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "300", "300", "Third Vox dependent parameter for gate current in inversion" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vecb",  286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.026", "0.026", "Vaux parameter for conduction-band electron tunneling" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "alphagb2",  287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.43", "First Vox dependent parameter for gate current in accumulation" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "betagb2",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.05", "0.05", "Second Vox dependent parameter for gate current in accumulation" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "vgb2",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "17", "17", "Third Vox dependent parameter for gate current in accumulation" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "voxh",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "the limit of Vox in gate current calculation" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "deltavox",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "the smoothing parameter in the Vox smoothing function" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnch",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnsub",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lngate",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvth0",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lk1",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lk1w1",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1w1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lk1w2",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1w2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lk2",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lk3",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lk3b",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lkb1",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lw0",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnlx",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldvt0",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldvt1",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldvt2",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldvt0w",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldvt1w",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldvt2w",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lu0",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lua",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lub",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "luc",  323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvsat",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "la0",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lags",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lb0",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lb1",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lketa",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lketas",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ketas" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "la1",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "la2",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lrdsw",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lprwb",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lprwg",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lwr",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnfactor",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldwg",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldwb",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvoff",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "leta0",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "letab",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldsub",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lcit",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lcdsc",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lcdscb",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lcdscd",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lpclm",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lpdiblc1",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lpdiblc2",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lpdiblcb",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldrout",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lpvag",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldelta",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lalpha0",  355, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lfbjtii",  356, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fbjtii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lbeta0",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lbeta1",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lbeta2",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvdsatii0",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdsatii0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "llii",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lesatii",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of esatii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lsii0",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lsii1",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lsii2",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lsiid",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of siid" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lagidl",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lbgidl",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lngidl",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lntun",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lndiode",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnrecf0",  372, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnrecr0",  373, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lisbjt",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lisdif",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lisrec",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "listun",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvrec0",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vrec0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvtun0",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtun0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lnbjt",  380, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "llbjt0",  381, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lbjt0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvabjt",  382, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vabjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "laely",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aely" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lahli",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ahli" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvsdfb",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lvsdth",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ldelvt",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delvt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lacde",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "lmoin",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of amoin" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnch",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnsub",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wngate",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvth0",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wk1w1",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1w1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wk1w2",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1w2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wk2",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wk3",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wk3b",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wkb1",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ww0",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnlx",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdvt0",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdvt1",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdvt2",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdvt0w",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdvt1w",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdvt2w",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wu0",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wua",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wub",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wuc",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvsat",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wa0",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wags",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wb0",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wb1",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wketa",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wketas",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ketas" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wa1",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wa2",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wrdsw",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wprwb",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wprwg",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wwr",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnfactor",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdwg",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdwb",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvoff",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "weta0",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wetab",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdsub",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wcit",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wcdsc",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wcdscb",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wcdscd",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wpclm",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wpdiblc1",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wpdiblc2",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wpdiblcb",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdrout",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wpvag",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdelta",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "walpha0",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wfbjtii",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fbjtii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wbeta0",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wbeta1",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wbeta2",  459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvdsatii0",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vdsatii0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wlii",  461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wesatii",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of esatii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wsii0",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wsii1",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wsii2",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wsiid",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of siid" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wagidl",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wbgidl",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wngidl",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wntun",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wndiode",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnrecf0",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnrecr0",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wisbjt",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wisdif",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wisrec",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wistun",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvrec0",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vrec0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvtun0",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtun0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wnbjt",  480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wlbjt0",  481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lbjt0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvabjt",  482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vabjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "waely",  483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aely" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wahli",  484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ahli" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvsdfb",  485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wvsdth",  486, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wdelvt",  487, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delvt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wacde",  488, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of acde" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "wmoin",  489, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of amoin" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnch",  501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnsub",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pngate",  503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvth0",  504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pk1w1",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1w1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pk1w2",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1w2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pk2",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pk3",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pk3b",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pkb1",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kb1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pw0",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnlx",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nlx" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdvt0",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdvt1",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdvt2",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdvt0w",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdvt1w",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdvt2w",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pu0",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pua",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pub",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "puc",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvsat",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pa0",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pags",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pb0",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pb1",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pketa",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pketas",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ketas" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pa1",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pa2",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "prdsw",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pprwb",  534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pprwg",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pwr",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnfactor",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdwg",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdwb",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvoff",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "peta0",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "petab",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdsub",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pcit",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pcdsc",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pcdscb",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pcdscd",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ppclm",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ppdiblc1",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ppdiblc2",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ppdiblcb",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdrout",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "ppvag",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdelta",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "palpha0",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pfbjtii",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fbjtii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pbeta0",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pbeta1",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pbeta2",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvdsatii0",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdsatii0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "plii",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pesatii",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of esatii" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "psii0",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "psii1",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii1" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "psii2",  565, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii2" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "psiid",  566, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of siid" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pagidl",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pbgidl",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pngidl",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngidl" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pntun",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pndiode",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnrecf0",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnrecr0",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pisbjt",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pisdif",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isdif" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pisrec",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isrec" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pistun",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of istun" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvrec0",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vrec0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvtun0",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtun0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pnbjt",  580, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nbjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "plbjt0",  581, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lbjt0" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvabjt",  582, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vabjt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "paely",  583, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aely" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pahli",  584, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ahli" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvsdfb",  585, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pvsdth",  586, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdth" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pdelvt",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delvt" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pacde",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of acde" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pmoin",  589, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of amoin" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "nmos",  814, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
    modelInfos[MODEL_TYPE::B3SOIPD].modelParams.emplace_back( "pmos",  815, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
    // Instance parameters
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "m",  31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "ic",  19, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "gmbs",  918, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "gm",  916, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "gm/ids",  946, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm/Ids", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "gds",  917, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "vdsat",  939, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "vth",  938, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "ids",  913, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "vbs",  909, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "vgs",  910, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "vds",  912, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "ves",  911, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ves", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "bjtoff",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "debug",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "rth0",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Resistance", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "cth0",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Capacitance", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "nrb",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of squares in body", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "frbody",  30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "layout dependent body-resistance coefficient", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "nbc",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of body contact isolation edge", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "nseg",  23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number segments for width partitioning", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "pdbcp",  24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Perimeter length for bc parasitics at drain side", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "psbcp",  25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Perimeter length for bc parasitics at source side", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "agbcp",  26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate to body overlap area for bc parasitics", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "aebcp",  27, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Substrate to body overlap area for bc prasitics", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "vbsusr",  28, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs specified by user", true );
    modelInfos[MODEL_TYPE::B3SOIPD].instanceParams.emplace_back( "tnodeout",  29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag indicating external temp node", true );
}