# Kata Agent

## Overview

The Kata agent is a long running process that runs inside the Virtual Machine
(VM) (also known as the "pod" or "sandbox").

The agent is packaged inside the Kata Containers
[guest image](../../docs/design/architecture.md#guest-image)
which is used to boot the VM. Once the runtime has launched the configured
[hypervisor](../../docs/hypervisors.md) to create a new VM, the agent is
started. From this point on, the agent is responsible for creating and
managing the life cycle of the containers inside the VM.

For further details, see the
[architecture document](../../docs/design/architecture.md).

## Audience

If you simply wish to use Kata Containers, it is not necessary to understand
the details of how the agent operates. Please see the
[installation documentation](../../docs/install) for details of how deploy
Kata Containers (which will include the Kata agent).

The remainder of this document is only useful for developers and testers.

## Build from Source

Since the agent is written in the Rust language this section assumes the tool
chain has been installed using standard Rust `rustup` tool.

### Build with musl

If you wish to build the agent with the `musl` C library, you need to run the
following commands:

```bash
$ arch=$(uname -m)
$ rustup target add "${arch}-unknown-linux-musl"
$ sudo ln -s /usr/bin/g++ /bin/musl-g++
```

> **Note:**
>
> It is not currently possible to build using `musl` on ppc64le and s390x
> since both platforms lack the `musl` target.

### Build the agent binary

The following steps download the Kata Containers source files and build the agent:

```bash
$ GOPATH="${GOPATH:-$HOME/go}"
$ dir="$GOPATH/src/github.com/kata-containers"
$ git -C ${dir} clone --depth 1 https://github.com/kata-containers/kata-containers
$ make -C ${dir}/kata-containers/src/agent
```

## Change the agent API

The Kata runtime communicates with the Kata agent using a ttRPC based API protocol.

This ttRPC API is defined by a set of [protocol buffers files](protocols/protos).
The protocol files are used to generate the bindings for the following components:

| Component | Language | Generation method | Tooling required |
|-|-|-|-|
| runtime | Golang | Run, `make generate-protocols` | `protoc` |
| agent | Rust | Run, `make` |  |

If you wish to change the API, these files must be regenerated. Although the
rust code will be automatically generated by the
[build script](protocols/build.rs),
the Golang code generation requires the external `protoc` command to be
available in `$PATH`.

To install the `protoc` command on a Fedora/CentOS/RHEL system:

```bash
$ sudo dnf install -y protobuf-compiler
```

## Custom guest image and kernel assets

If you wish to develop or test changes to the agent, you will need to create a
custom guest image using the [osbuilder tool](../../tools/osbuilder). You
may also wish to create a custom [guest kernel](../../tools/packaging/kernel).

Once created, [configure](../runtime/README.md#configuration) Kata Containers to use
these custom assets to allow you to test your changes.

> **Note:**
>
> To simplify development and testing, you may wish to run the agent
> [stand alone](#run-the-agent-stand-alone) initially.

## Tracing

For details of tracing the operation of the agent, see the
[tracing documentation](../../docs/tracing.md).

## Run the agent stand alone

Although the agent is designed to run in a VM environment, for development and
testing purposes it is possible to run it as a normal application.

When run in this way, the agent can be controlled using the low-level Kata
agent control tool, rather than the Kata runtime.

For further details, see the
[agent control tool documentation](../../tools/agent-ctl/README.md#run-the-tool-and-the-agent-in-the-same-environment).
