/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.dialog;

import org.dbdoclet.jive.widget.ButtonPanel;

public enum DialogAction {
	CANCEL, NO, NONE, OK, YES;

	public static int getFlag(DialogAction action) {
		switch (action) {
		case CANCEL:
			return ButtonPanel.OK;
		case NO:
			return ButtonPanel.NO;
		case OK:
			return ButtonPanel.OK;
		case YES:
			return ButtonPanel.YES;
		default:
			return -1;
		}
	}
}
