% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateDoubletRateFromCellSelectionPrototype.R
\name{estimateDoubletRatePoissonDistribution}
\alias{estimateDoubletRatePoissonDistribution}
\title{Estimate the expected number of doublets from the count of empty/nonempty cell barcodes}
\usage{
estimateDoubletRatePoissonDistribution(
  emptyCount,
  nonEmptyCount,
  showPlot = TRUE
)
}
\arguments{
\item{emptyCount}{The number of cell barcodes that do not encapsulate a cell in the experiment}

\item{nonEmptyCount}{The numbeYr of cell barcodes that encapsulate a cell in the experiment}

\item{showPlot}{Plot the poisson counts distribution using the inferred lambda parameter for the total number of cell barcodes.}
}
\value{
A dataframe contain the input parameters, and the esimated doublet rate and lambda parameter.
}
\description{
Given the count of empty and non-empty cell barcodes, fit data to a poisson distribution
where the empty count matches the number given, and the sum of counts >= 1 equals the non-empty count.
}
\details{
The number of nonEmpty cell barcodes is estimated by any cell selection software you'd like to use - 10x
and other scRNASeq methods will generate this number

The number of empty cell barcodes is slightly harder to estimate - it can be inferred using
cell level metrics of the number of UMIs and %intronic to find cell barcodes that have fewer UMIs and 
(in the case of nuclei) lower pct inronic.  See \code{\link{estimateEmptyCount}}

This estimates a lambda parameter for a Poisson distribution.  Assuming this distribution is reasonable,
it is them possible to estimate the doublet rate as the number of single observations divided by the number of
observations of one or more counts.
}
\examples{
estimateDoubletRatePoissonDistribution(10000,1000)
}
