/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.text.MessageFormat;

public class CreateIndexParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("CREATE");
        boolean bl = parser.expectOptional("UNIQUE");
        parser.expect("INDEX");
        parser.expectOptional("CONCURRENTLY");
        parser.expectOptional("IF", "NOT", "EXISTS");
        String string2 = ParserUtils.getObjectName(parser.parseIdentifier());
        parser.expect("ON");
        String string3 = parser.parseIdentifier();
        String string4 = parser.getRest();
        String string5 = ParserUtils.getSchemaName(string3, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string5);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string5, string));
        }
        String string6 = ParserUtils.getObjectName(string3);
        PgTable pgTable = pgSchema.getTable(string6);
        PgView pgView = pgSchema.getView(string6);
        PgIndex pgIndex = new PgIndex(string2);
        if (pgTable != null) {
            pgTable.addIndex(pgIndex);
        } else if (pgView != null) {
            pgView.addIndex(pgIndex);
        } else {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindObject"), string3, string));
        }
        pgSchema.addIndex(pgIndex);
        pgIndex.setDefinition(string4.trim());
        pgIndex.setTableName(string6);
        pgIndex.setUnique(bl);
    }

    private CreateIndexParser() {
    }
}

