#ifndef _runway_h
#define _runway_h

#include "../V/VPoly.h"

#ifdef runway_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Build runway polygons.
 * @param id Runway ends names separated by '/', ex. "10L/36R", in any order,
 * 7 chars max.
 * @param RWYtoXYZ Runway-to-world coord. transformation with origin in the
 * middle of the runway, with x pointing in the range [0,180[ DEG of the
 * geographical coors. and z pointing down.
 * @param length Runway length (meters).
 * @param width Runway width (meters).
 * @param heading Runway heading; it MUST be normalized to the range [0,pi[.
 * @return Set of polygons that draw the runway.
 */
EXTERN VPolySet * runway_build(char *id, VMatrix * RWYtoXYZ, double length,
	double width, double heading);

#undef EXTERN
#endif
